-- ADA101A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- OBJECTIVE:
--     CHECK THAT UNCHECKED_DEALLOCATION CAN BE INSTANTIATED WITH ANY
--     TYPE AS THE OBJECT PARAMETER.

-- HISTORY:
--     JET 09/23/88  CREATED ORIGINAL TEST.

WITH REPORT; USE REPORT;
WITH UNCHECKED_DEALLOCATION;
PROCEDURE ADA101A IS

     TYPE ENUM IS (CURLY, MOE, LARRY);
     TYPE DER IS NEW INTEGER;
     SUBTYPE SUB IS CHARACTER RANGE 'A'..'Z';
     TASK TYPE TSK;
     TYPE ACC IS ACCESS INTEGER;

     PACKAGE P IS
          TYPE PRIV IS PRIVATE;
     PRIVATE
          TYPE PRIV IS RANGE -100..100;
     END P;
     USE P;

     TYPE ARR1 IS ARRAY (INTEGER RANGE 1..10) OF INTEGER;
     TYPE ARR2 IS ARRAY (INTEGER RANGE <>) OF CHARACTER;

     TYPE REC1 IS RECORD
          D, I : INTEGER;
     END RECORD;

     TYPE REC2 (D : INTEGER) IS RECORD
          C : CHARACTER;
     END RECORD;

     TYPE INTEGERA IS ACCESS INTEGER;
     TYPE FLOATA IS ACCESS FLOAT;
     TYPE ENUMA IS ACCESS ENUM;
     TYPE BOOLEANA IS ACCESS BOOLEAN;
     TYPE CHARACTERA IS ACCESS CHARACTER;
     TYPE DERA IS ACCESS DER;
     TYPE SUBA IS ACCESS SUB;
     TYPE TSKA IS ACCESS TSK;
     TYPE ACCA IS ACCESS ACC;
     TYPE PRIVA IS ACCESS PRIV;
     TYPE ARR1A IS ACCESS ARR1;
     TYPE ARR2A IS ACCESS ARR2;
     TYPE REC1A IS ACCESS REC1;
     TYPE REC2A IS ACCESS REC2;

     TASK BODY TSK IS
     BEGIN
          NULL;
     END TSK;

     PROCEDURE RLSI IS NEW UNCHECKED_DEALLOCATION(INTEGER, INTEGERA);
     PROCEDURE RLSF IS NEW UNCHECKED_DEALLOCATION(FLOAT, FLOATA);
     PROCEDURE RLSE IS NEW UNCHECKED_DEALLOCATION(ENUM, ENUMA);
     PROCEDURE RLSB IS NEW UNCHECKED_DEALLOCATION(BOOLEAN, BOOLEANA);
     PROCEDURE RLSC IS NEW UNCHECKED_DEALLOCATION(CHARACTER,CHARACTERA);
     PROCEDURE RLSD IS NEW UNCHECKED_DEALLOCATION(DER, DERA);
     PROCEDURE RLSS IS NEW UNCHECKED_DEALLOCATION(SUB, SUBA);
     PROCEDURE RLST IS NEW UNCHECKED_DEALLOCATION(TSK, TSKA);
     PROCEDURE RLSA IS NEW UNCHECKED_DEALLOCATION(ACC, ACCA);
     PROCEDURE RLSP IS NEW UNCHECKED_DEALLOCATION(PRIV, PRIVA);
     PROCEDURE RLSA1 IS NEW UNCHECKED_DEALLOCATION(ARR1, ARR1A);
     PROCEDURE RLSA2 IS NEW UNCHECKED_DEALLOCATION(ARR2, ARR2A);
     PROCEDURE RLSR1 IS NEW UNCHECKED_DEALLOCATION(REC1, REC1A);
     PROCEDURE RLSR2 IS NEW UNCHECKED_DEALLOCATION(REC2, REC2A);

BEGIN
     TEST ("ADA101A", "CHECK THAT UNCHECKED_DEALLOCATION CAN BE " &
                      "INSTANTIATED WITH ANY TYPE AS THE OBJECT " &
                      "PARAMETER");

     RESULT;
END ADA101A;
