/* do not edit automatically generated by mc from Output.  */
/* Output.def redirect output.

Copyright (C) 2021-2024 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_Output_H)
#   define _Output_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GNameKey.h"
#   include "GDynamicStrings.h"

#   if defined (_Output_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   Open - attempt to open filename as the output file.
          TRUE is returned if success, FALSE otherwise.
*/

EXTERN bool Output_Open (const char *filename_, unsigned int _filename_high);

/*
   Close - close the output file.
*/

EXTERN void Output_Close (void);

/*
   Write - write a single character to the output file.
*/

EXTERN void Output_Write (char ch);

/*
   WriteString - write an unformatted string to the output.
*/

EXTERN void Output_WriteString (const char *s_, unsigned int _s_high);

/*
   KillWriteS - write a string to the output and free the string afterwards.
*/

EXTERN void Output_KillWriteS (DynamicStrings_String s);

/*
   WriteS - write a string to the output.  The string is not freed.
*/

EXTERN void Output_WriteS (DynamicStrings_String s);

/*
   WriteKey - write a key to the output.
*/

EXTERN void Output_WriteKey (NameKey_Name key);

/*
   WriteLn - write a newline to the output.
*/

EXTERN void Output_WriteLn (void);

/*
   WriteCard - write a cardinal using fieldlength characters.
*/

EXTERN void Output_WriteCard (unsigned int card, unsigned int fieldlength);

/*
   StartBuffer - create a buffer into which any output is redirected.
*/

EXTERN void Output_StartBuffer (void);

/*
   EndBuffer - end the redirection and return the contents of the buffer.
*/

EXTERN DynamicStrings_String Output_EndBuffer (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
