--- origsrc/nfrotz-0.3.3/src/curses/ux_init.c.orig	2009-10-19 14:50:36.784000000 -0400
+++ src/nfrotz-0.3.3/src/curses/ux_init.c	2009-10-19 14:56:23.455000000 -0400
@@ -31,6 +31,10 @@
 #include <unistd.h>
 #include <ctype.h>
 #include <locale.h>
+#include <errno.h>
+#include <sys/stat.h>
+#include <sys/types.h>
+#include <fcntl.h>
 
 /* We will use our own private getoptalike functions. */
 #include "options.h"
@@ -136,7 +140,7 @@
 {
 	int c, i;
 
-	char *p = NULL;
+	const char *p = NULL;
 
 	char *home;
 	char configfile[FILENAME_MAX + 1];
@@ -311,11 +315,47 @@
 		stripped_story_name[i] = p[i];
 	stripped_story_name[i] = '\0';
 
+
+	/*
+	 * If possible, saved games go in "$HOME/.infocom/" with extension
+	 * ".sav" (for quetzal save files) or ".frotz" (for old Frotz
+	 * save files).  If $HOME is not set, use the current directory.
+	 */
+
+	save_name[0] = 0;
+
+	if (home) {
+		struct stat buf;
+
+		strcpy (save_name, home);
+		strcat (save_name, "/.infocom");
+
+		if (stat (save_name, &buf)) {
+			if (errno == ENOENT) {
+				if (mkdir (save_name, 0777)) {
+					/* error; use cwd */
+					save_name[0] = 0;
+				} else {
+					strcat (save_name, "/");
+				}
+			} else {
+				save_name[0] = 0;
+			}
+		} else {
+			if (S_ISDIR(buf.st_mode)) {
+				strcat (save_name, "/");
+			} else {
+				save_name[0] = 0;
+			}
+		}
+	}
+
+
 	/* Create nice default file names */
 
 	strcpy (script_name, stripped_story_name);
 	strcpy (command_name, stripped_story_name);
-	strcpy (save_name, stripped_story_name);
+	strcat (save_name, stripped_story_name);
 	strcpy (auxilary_name, stripped_story_name);
 
 	/* Don't forget the extensions */
