; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s

define <vscale x 1 x bfloat> @load_nxv1bf16(ptr %p) {
; CHECK-LABEL: load_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 1 x bfloat>, ptr %p
  ret <vscale x 1 x bfloat> %x
}

define <vscale x 2 x bfloat> @load_nxv2bf16(ptr %p) {
; CHECK-LABEL: load_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 2 x bfloat>, ptr %p
  ret <vscale x 2 x bfloat> %x
}

define <vscale x 4 x bfloat> @load_nxv4bf16(ptr %p) {
; CHECK-LABEL: load_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 4 x bfloat>, ptr %p
  ret <vscale x 4 x bfloat> %x
}

define <vscale x 8 x bfloat> @load_nxv8bf16(ptr %p) {
; CHECK-LABEL: load_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 8 x bfloat>, ptr %p
  ret <vscale x 8 x bfloat> %x
}

define <vscale x 16 x bfloat> @load_nxv16bf16(ptr %p) {
; CHECK-LABEL: load_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 16 x bfloat>, ptr %p
  ret <vscale x 16 x bfloat> %x
}

define <vscale x 32 x bfloat> @load_nxv32bf16(ptr %p) {
; CHECK-LABEL: load_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re16.v v8, (a0)
; CHECK-NEXT:    ret
  %x = load <vscale x 32 x bfloat>, ptr %p
  ret <vscale x 32 x bfloat> %x
}

define <vscale x 4 x float> @extload(ptr %p) {
; CHECK-LABEL: extload:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    ret
  %x = load <vscale x 4 x bfloat>, ptr %p
  %y = fpext <vscale x 4 x bfloat> %x to <vscale x 4 x float>
  ret <vscale x 4 x float> %y
}
