; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=riscv64 -mattr=+v,+f,+short-forward-branch-opt -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s --check-prefixes=SFB64
; RUN: opt < %s -mtriple=riscv64 -mattr=+v,+f -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s --check-prefixes=RV64

define i32 @icmp-iselect(i64 %ca, i64 %cb, i32 %a, i32 %b) {
; SFB64-LABEL: 'icmp-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
; RV64-LABEL: 'icmp-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
  %cmp1 = icmp slt i64 %ca, %cb
  %select1 = select i1 %cmp1, i32 %a, i32 %b
  ret i32 %select1
}

define i32 @icmp-iselects(i64 %ca, i64 %cb, i32 %a, i32 %b, i32 %c) {
; SFB64-LABEL: 'icmp-iselects'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select2 = select i1 %cmp1, i32 %a, i32 %c
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ret = add i32 %select1, %select2
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %ret
;
; RV64-LABEL: 'icmp-iselects'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select2 = select i1 %cmp1, i32 %a, i32 %c
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ret = add i32 %select1, %select2
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %ret
;
  %cmp1 = icmp slt i64 %ca, %cb
  %select1 = select i1 %cmp1, i32 %a, i32 %b
  %select2 = select i1 %cmp1, i32 %a, i32 %c
  %ret = add i32 %select1, %select2
  ret i32 %ret
}

define i32 @icmp-ifselects(i64 %ca, i64 %cb, i32 %a, i32 %b, float %c, float %d) {
; SFB64-LABEL: 'icmp-ifselects'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select2 = select i1 %cmp1, float %c, float %d
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %selectint = fptosi float %select2 to i32
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ret = add i32 %select1, %selectint
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %ret
;
; RV64-LABEL: 'icmp-ifselects'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select2 = select i1 %cmp1, float %c, float %d
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %selectint = fptosi float %select2 to i32
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ret = add i32 %select1, %selectint
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %ret
;
  %cmp1 = icmp slt i64 %ca, %cb
  %select1 = select i1 %cmp1, i32 %a, i32 %b
  %select2 = select i1 %cmp1, float %c, float %d
  %selectint = fptosi float %select2 to i32
  %ret = add i32 %select1, %selectint
  ret i32 %ret
}

define i32 @constant-icmp-iselect(i64 %ca, i64 %cb, i32 %a) {
; SFB64-LABEL: 'constant-icmp-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 7
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
; RV64-LABEL: 'constant-icmp-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %cmp1 = icmp slt i64 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %cmp1, i32 %a, i32 7
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
  %cmp1 = icmp slt i64 %ca, %cb
  %select1 = select i1 %cmp1, i32 %a, i32 7
  ret i32 %select1
}

define i32 @fcmp-iselect(float %ca, float %cb, i32 %a, i32 %b) {
; SFB64-LABEL: 'fcmp-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %fcmp1, i32 %a, i32 %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
; RV64-LABEL: 'fcmp-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select i1 %fcmp1, i32 %a, i32 %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %select1
;
  %fcmp1 = fcmp ogt float %ca, %cb
  %select1 = select i1 %fcmp1, i32 %a, i32 %b
  ret i32 %select1
}

define float @fcmp-fselect(float %ca, float %cb, float %a, float %b) {
; SFB64-LABEL: 'fcmp-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fselect1 = select i1 %fcmp1, float %a, float %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret float %fselect1
;
; RV64-LABEL: 'fcmp-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fselect1 = select i1 %fcmp1, float %a, float %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret float %fselect1
;
  %fcmp1 = fcmp ogt float %ca, %cb
  %fselect1 = select i1 %fcmp1, float %a, float %b
  ret float %fselect1
}

define float @icmp-fselect(i64 %ca, i64 %cb, float %a, float %b) {
; SFB64-LABEL: 'icmp-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i64 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fselect1 = select i1 %icmp1, float %a, float %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret float %fselect1
;
; RV64-LABEL: 'icmp-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i64 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fselect1 = select i1 %icmp1, float %a, float %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret float %fselect1
;
  %icmp1 = icmp slt i64 %ca, %cb
  %fselect1 = select i1 %icmp1, float %a, float %b
  ret float %fselect1
}

define <2 x i32> @vector-icmp-vector-iselect(<2 x i32> %ca, <2 x i32> %cb, <2 x i32> %a, <2 x i32> %b) {
; SFB64-LABEL: 'vector-icmp-vector-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp = icmp slt <2 x i32> %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %icmp, <2 x i32> %a, <2 x i32> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
; RV64-LABEL: 'vector-icmp-vector-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp = icmp slt <2 x i32> %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %icmp, <2 x i32> %a, <2 x i32> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
  %icmp = icmp slt <2 x i32> %ca, %cb
  %select1 = select <2 x i1> %icmp, <2 x i32> %a, <2 x i32> %b
  ret <2 x i32> %select1
}

define <2 x i32> @vector-fcmp-vector-iselect(<2 x float> %ca, <2 x float> %cb, <2 x i32> %a, <2 x i32> %b) {
; SFB64-LABEL: 'vector-fcmp-vector-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt <2 x float> %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %fcmp1, <2 x i32> %a, <2 x i32> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
; RV64-LABEL: 'vector-fcmp-vector-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt <2 x float> %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %fcmp1, <2 x i32> %a, <2 x i32> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
  %fcmp1 = fcmp ogt <2 x float> %ca, %cb
  %select1 = select <2 x i1> %fcmp1, <2 x i32> %a, <2 x i32> %b
  ret <2 x i32> %select1
}

define <2 x float> @vector-fcmp-vector-fselect(<2 x float> %ca, <2 x float> %cb, <2 x float> %a, <2 x float> %b) {
; SFB64-LABEL: 'vector-fcmp-vector-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt <2 x float> %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %fcmp1, <2 x float> %a, <2 x float> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
; RV64-LABEL: 'vector-fcmp-vector-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt <2 x float> %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %fcmp1, <2 x float> %a, <2 x float> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
  %fcmp1 = fcmp ogt <2 x float> %ca, %cb
  %select1 = select <2 x i1> %fcmp1, <2 x float> %a, <2 x float> %b
  ret <2 x float> %select1
}

define <2 x float> @vector-icmp-vector-fselect(<2 x i32> %ca, <2 x i32> %cb, <2 x float> %a, <2 x float> %b) {
; SFB64-LABEL: 'vector-icmp-vector-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt <2 x i32> %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %icmp1, <2 x float> %a, <2 x float> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
; RV64-LABEL: 'vector-icmp-vector-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt <2 x i32> %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %select1 = select <2 x i1> %icmp1, <2 x float> %a, <2 x float> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
  %icmp1 = icmp slt <2 x i32> %ca, %cb
  %select1 = select <2 x i1> %icmp1, <2 x float> %a, <2 x float> %b
  ret <2 x float> %select1
}

define <2 x float> @icmp-vector-fselect(i1 %ca, i1 %cb, <2 x float> %a, <2 x float> %b) {
; SFB64-LABEL: 'icmp-vector-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i1 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %icmp1, <2 x float> %a, <2 x float> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
; RV64-LABEL: 'icmp-vector-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i1 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %icmp1, <2 x float> %a, <2 x float> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
  %icmp1 = icmp slt i1 %ca, %cb
  %select1 = select i1 %icmp1, <2 x float> %a, <2 x float> %b
  ret <2 x float> %select1
}

define <2 x i32> @icmp-vector-iselect(i1 %ca, i1 %cb, <2 x i32> %a, <2 x i32> %b) {
; SFB64-LABEL: 'icmp-vector-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i1 %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %icmp1, <2 x i32> %a, <2 x i32> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
; RV64-LABEL: 'icmp-vector-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %icmp1 = icmp slt i1 %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %icmp1, <2 x i32> %a, <2 x i32> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
  %icmp1 = icmp slt i1 %ca, %cb
  %select1 = select i1 %icmp1, <2 x i32> %a, <2 x i32> %b
  ret <2 x i32> %select1
}

define <2 x float> @fcmp-vector-fselect(float %ca, float %cb, <2 x float> %a, <2 x float> %b) {
; SFB64-LABEL: 'fcmp-vector-fselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %fcmp1, <2 x float> %a, <2 x float> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
; RV64-LABEL: 'fcmp-vector-fselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %fcmp1, <2 x float> %a, <2 x float> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x float> %select1
;
  %fcmp1 = fcmp ogt float %ca, %cb
  %select1 = select i1 %fcmp1, <2 x float> %a, <2 x float> %b
  ret <2 x float> %select1
}

define <2 x i32> @fcmp-vector-iselect(float %ca, float %cb, <2 x i32> %a, <2 x i32> %b) {
; SFB64-LABEL: 'fcmp-vector-iselect'
; SFB64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; SFB64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %fcmp1, <2 x i32> %a, <2 x i32> %b
; SFB64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
; RV64-LABEL: 'fcmp-vector-iselect'
; RV64-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %fcmp1 = fcmp ogt float %ca, %cb
; RV64-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %select1 = select i1 %fcmp1, <2 x i32> %a, <2 x i32> %b
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i32> %select1
;
  %fcmp1 = fcmp ogt float %ca, %cb
  %select1 = select i1 %fcmp1, <2 x i32> %a, <2 x i32> %b
  ret <2 x i32> %select1
}
