; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -o - -mcpu=sm_100a -march=nvptx64 -mattr=+ptx86 | FileCheck %s
; RUN: llc < %s -o - -mcpu=sm_101a -march=nvptx64 -mattr=+ptx86 | FileCheck %s
; RUN: %if ptxas-12.8 %{ llc < %s -march=nvptx64 -mcpu=sm_100a -mattr=+ptx86 | %ptxas-verify -arch=sm_100a %}
; RUN: %if ptxas-12.8 %{ llc < %s -march=nvptx64 -mcpu=sm_101a -mattr=+ptx86 | %ptxas-verify -arch=sm_101a %}

; CHECK-LABEL: nvvm_tcgen05_st_16x64b
define void @nvvm_tcgen05_st_16x64b(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x64b(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x64b_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_16x64b_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x1.b32 [%r1], {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_16x64b_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x2.b32 [%r1], {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_16x64b_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x4.b32 [%r1], {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_16x64b_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_16x64b_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x8.b32 [%r1], {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_16x64b_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_16x64b_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_16x64b_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_16x64b_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x16.b32 [%r1], {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_16x64b_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_16x64b_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_16x64b_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_16x64b_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_16x64b_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_16x64b_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_16x64b_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_16x64b_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x32.b32 [%r1], {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_16x64b_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_16x64b_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_16x64b_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_16x64b_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_16x64b_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_16x64b_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_16x64b_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_16x64b_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_16x64b_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_16x64b_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_16x64b_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_16x64b_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_16x64b_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_16x64b_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_16x64b_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_16x64b_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x64.b32 [%r1], {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_16x64b_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_16x64b_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_16x64b_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_16x64b_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_16x64b_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_16x64b_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_16x64b_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_16x64b_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_16x64b_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_16x64b_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_16x64b_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_16x64b_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_16x64b_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_16x64b_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_16x64b_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_16x64b_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_16x64b_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_16x64b_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_16x64b_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_16x64b_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_16x64b_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_16x64b_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_16x64b_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_16x64b_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_16x64b_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_16x64b_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_16x64b_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_16x64b_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_16x64b_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_16x64b_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_16x64b_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_16x64b_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x128.b32 [%r1], {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x64b.x1(ptr addrspace(6) %taddr, i32 %stv1, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x2(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x4(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x8(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x16(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x32(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x64(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x128(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 0)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x64b_unpack
define void @nvvm_tcgen05_st_16x64b_unpack(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x64b_unpack(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x64b_unpack_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_16x64b_unpack_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x1.unpack::16b.b32 [%r1], {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_16x64b_unpack_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x2.unpack::16b.b32 [%r1], {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_16x64b_unpack_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x4.unpack::16b.b32 [%r1], {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_16x64b_unpack_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_16x64b_unpack_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x8.unpack::16b.b32 [%r1], {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_16x64b_unpack_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_16x64b_unpack_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_16x64b_unpack_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_16x64b_unpack_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x16.unpack::16b.b32 [%r1], {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_16x64b_unpack_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_16x64b_unpack_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_16x64b_unpack_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_16x64b_unpack_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_16x64b_unpack_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_16x64b_unpack_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_16x64b_unpack_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_16x64b_unpack_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x32.unpack::16b.b32 [%r1], {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_16x64b_unpack_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_16x64b_unpack_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_16x64b_unpack_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_16x64b_unpack_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_16x64b_unpack_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_16x64b_unpack_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_16x64b_unpack_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_16x64b_unpack_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_16x64b_unpack_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_16x64b_unpack_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_16x64b_unpack_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_16x64b_unpack_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_16x64b_unpack_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_16x64b_unpack_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_16x64b_unpack_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_16x64b_unpack_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x64.unpack::16b.b32 [%r1], {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_16x64b_unpack_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_16x64b_unpack_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_16x64b_unpack_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_16x64b_unpack_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_16x64b_unpack_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_16x64b_unpack_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_16x64b_unpack_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_16x64b_unpack_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_16x64b_unpack_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_16x64b_unpack_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_16x64b_unpack_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_16x64b_unpack_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_16x64b_unpack_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_16x64b_unpack_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_16x64b_unpack_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_16x64b_unpack_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_16x64b_unpack_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_16x64b_unpack_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_16x64b_unpack_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_16x64b_unpack_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_16x64b_unpack_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_16x64b_unpack_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_16x64b_unpack_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_16x64b_unpack_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_16x64b_unpack_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_16x64b_unpack_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_16x64b_unpack_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_16x64b_unpack_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_16x64b_unpack_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_16x64b_unpack_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_16x64b_unpack_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_16x64b_unpack_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x64b.x128.unpack::16b.b32 [%r1], {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x64b.x1(ptr addrspace(6) %taddr, i32 %stv1, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x2(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x4(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x8(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x16(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x32(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x64(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x64b.x128(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 1)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x128b
define void @nvvm_tcgen05_st_16x128b(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x128b(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<256>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x128b_param_0];
; CHECK-NEXT:    ld.param.v2.b32 {%r2, %r3}, [nvvm_tcgen05_st_16x128b_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x1.b32 [%r1], {%r2, %r3};
; CHECK-NEXT:    ld.param.v4.b32 {%r4, %r5, %r6, %r7}, [nvvm_tcgen05_st_16x128b_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x2.b32 [%r1], {%r4, %r5, %r6, %r7};
; CHECK-NEXT:    ld.param.v4.b32 {%r8, %r9, %r10, %r11}, [nvvm_tcgen05_st_16x128b_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r12, %r13, %r14, %r15}, [nvvm_tcgen05_st_16x128b_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x4.b32 [%r1], {%r12, %r13, %r14, %r15, %r8, %r9, %r10, %r11};
; CHECK-NEXT:    ld.param.v4.b32 {%r16, %r17, %r18, %r19}, [nvvm_tcgen05_st_16x128b_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r20, %r21, %r22, %r23}, [nvvm_tcgen05_st_16x128b_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r24, %r25, %r26, %r27}, [nvvm_tcgen05_st_16x128b_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r28, %r29, %r30, %r31}, [nvvm_tcgen05_st_16x128b_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x8.b32 [%r1], {%r28, %r29, %r30, %r31, %r24, %r25, %r26, %r27, %r20, %r21, %r22, %r23, %r16, %r17, %r18, %r19};
; CHECK-NEXT:    ld.param.v4.b32 {%r32, %r33, %r34, %r35}, [nvvm_tcgen05_st_16x128b_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r36, %r37, %r38, %r39}, [nvvm_tcgen05_st_16x128b_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r40, %r41, %r42, %r43}, [nvvm_tcgen05_st_16x128b_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r44, %r45, %r46, %r47}, [nvvm_tcgen05_st_16x128b_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r48, %r49, %r50, %r51}, [nvvm_tcgen05_st_16x128b_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r52, %r53, %r54, %r55}, [nvvm_tcgen05_st_16x128b_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r56, %r57, %r58, %r59}, [nvvm_tcgen05_st_16x128b_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r60, %r61, %r62, %r63}, [nvvm_tcgen05_st_16x128b_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x16.b32 [%r1], {%r60, %r61, %r62, %r63, %r56, %r57, %r58, %r59, %r52, %r53, %r54, %r55, %r48, %r49, %r50, %r51, %r44, %r45, %r46, %r47, %r40, %r41, %r42, %r43, %r36, %r37, %r38, %r39, %r32, %r33, %r34, %r35};
; CHECK-NEXT:    ld.param.v4.b32 {%r64, %r65, %r66, %r67}, [nvvm_tcgen05_st_16x128b_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r68, %r69, %r70, %r71}, [nvvm_tcgen05_st_16x128b_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r72, %r73, %r74, %r75}, [nvvm_tcgen05_st_16x128b_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r76, %r77, %r78, %r79}, [nvvm_tcgen05_st_16x128b_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r80, %r81, %r82, %r83}, [nvvm_tcgen05_st_16x128b_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r84, %r85, %r86, %r87}, [nvvm_tcgen05_st_16x128b_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r88, %r89, %r90, %r91}, [nvvm_tcgen05_st_16x128b_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r92, %r93, %r94, %r95}, [nvvm_tcgen05_st_16x128b_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r96, %r97, %r98, %r99}, [nvvm_tcgen05_st_16x128b_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r100, %r101, %r102, %r103}, [nvvm_tcgen05_st_16x128b_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r104, %r105, %r106, %r107}, [nvvm_tcgen05_st_16x128b_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r108, %r109, %r110, %r111}, [nvvm_tcgen05_st_16x128b_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r112, %r113, %r114, %r115}, [nvvm_tcgen05_st_16x128b_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r116, %r117, %r118, %r119}, [nvvm_tcgen05_st_16x128b_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r120, %r121, %r122, %r123}, [nvvm_tcgen05_st_16x128b_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r124, %r125, %r126, %r127}, [nvvm_tcgen05_st_16x128b_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x32.b32 [%r1], {%r124, %r125, %r126, %r127, %r120, %r121, %r122, %r123, %r116, %r117, %r118, %r119, %r112, %r113, %r114, %r115, %r108, %r109, %r110, %r111, %r104, %r105, %r106, %r107, %r100, %r101, %r102, %r103, %r96, %r97, %r98, %r99, %r92, %r93, %r94, %r95, %r88, %r89, %r90, %r91, %r84, %r85, %r86, %r87, %r80, %r81, %r82, %r83, %r76, %r77, %r78, %r79, %r72, %r73, %r74, %r75, %r68, %r69, %r70, %r71, %r64, %r65, %r66, %r67};
; CHECK-NEXT:    ld.param.v4.b32 {%r128, %r129, %r130, %r131}, [nvvm_tcgen05_st_16x128b_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r132, %r133, %r134, %r135}, [nvvm_tcgen05_st_16x128b_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r136, %r137, %r138, %r139}, [nvvm_tcgen05_st_16x128b_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r140, %r141, %r142, %r143}, [nvvm_tcgen05_st_16x128b_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r144, %r145, %r146, %r147}, [nvvm_tcgen05_st_16x128b_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r148, %r149, %r150, %r151}, [nvvm_tcgen05_st_16x128b_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r152, %r153, %r154, %r155}, [nvvm_tcgen05_st_16x128b_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r156, %r157, %r158, %r159}, [nvvm_tcgen05_st_16x128b_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r160, %r161, %r162, %r163}, [nvvm_tcgen05_st_16x128b_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r164, %r165, %r166, %r167}, [nvvm_tcgen05_st_16x128b_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r168, %r169, %r170, %r171}, [nvvm_tcgen05_st_16x128b_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r172, %r173, %r174, %r175}, [nvvm_tcgen05_st_16x128b_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r176, %r177, %r178, %r179}, [nvvm_tcgen05_st_16x128b_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r180, %r181, %r182, %r183}, [nvvm_tcgen05_st_16x128b_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r184, %r185, %r186, %r187}, [nvvm_tcgen05_st_16x128b_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r188, %r189, %r190, %r191}, [nvvm_tcgen05_st_16x128b_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r192, %r193, %r194, %r195}, [nvvm_tcgen05_st_16x128b_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r196, %r197, %r198, %r199}, [nvvm_tcgen05_st_16x128b_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r200, %r201, %r202, %r203}, [nvvm_tcgen05_st_16x128b_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r204, %r205, %r206, %r207}, [nvvm_tcgen05_st_16x128b_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r208, %r209, %r210, %r211}, [nvvm_tcgen05_st_16x128b_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r212, %r213, %r214, %r215}, [nvvm_tcgen05_st_16x128b_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r216, %r217, %r218, %r219}, [nvvm_tcgen05_st_16x128b_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r220, %r221, %r222, %r223}, [nvvm_tcgen05_st_16x128b_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r224, %r225, %r226, %r227}, [nvvm_tcgen05_st_16x128b_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r228, %r229, %r230, %r231}, [nvvm_tcgen05_st_16x128b_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r232, %r233, %r234, %r235}, [nvvm_tcgen05_st_16x128b_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r236, %r237, %r238, %r239}, [nvvm_tcgen05_st_16x128b_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r240, %r241, %r242, %r243}, [nvvm_tcgen05_st_16x128b_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r244, %r245, %r246, %r247}, [nvvm_tcgen05_st_16x128b_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r248, %r249, %r250, %r251}, [nvvm_tcgen05_st_16x128b_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r252, %r253, %r254, %r255}, [nvvm_tcgen05_st_16x128b_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x64.b32 [%r1], {%r252, %r253, %r254, %r255, %r248, %r249, %r250, %r251, %r244, %r245, %r246, %r247, %r240, %r241, %r242, %r243, %r236, %r237, %r238, %r239, %r232, %r233, %r234, %r235, %r228, %r229, %r230, %r231, %r224, %r225, %r226, %r227, %r220, %r221, %r222, %r223, %r216, %r217, %r218, %r219, %r212, %r213, %r214, %r215, %r208, %r209, %r210, %r211, %r204, %r205, %r206, %r207, %r200, %r201, %r202, %r203, %r196, %r197, %r198, %r199, %r192, %r193, %r194, %r195, %r188, %r189, %r190, %r191, %r184, %r185, %r186, %r187, %r180, %r181, %r182, %r183, %r176, %r177, %r178, %r179, %r172, %r173, %r174, %r175, %r168, %r169, %r170, %r171, %r164, %r165, %r166, %r167, %r160, %r161, %r162, %r163, %r156, %r157, %r158, %r159, %r152, %r153, %r154, %r155, %r148, %r149, %r150, %r151, %r144, %r145, %r146, %r147, %r140, %r141, %r142, %r143, %r136, %r137, %r138, %r139, %r132, %r133, %r134, %r135, %r128, %r129, %r130, %r131};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x128b.x1(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x2(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x4(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x8(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x16(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x32(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x64(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 0)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x128b_unpack
define void @nvvm_tcgen05_st_16x128b_unpack(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x128b_unpack(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<256>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x128b_unpack_param_0];
; CHECK-NEXT:    ld.param.v2.b32 {%r2, %r3}, [nvvm_tcgen05_st_16x128b_unpack_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x1.unpack::16b.b32 [%r1], {%r2, %r3};
; CHECK-NEXT:    ld.param.v4.b32 {%r4, %r5, %r6, %r7}, [nvvm_tcgen05_st_16x128b_unpack_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x2.unpack::16b.b32 [%r1], {%r4, %r5, %r6, %r7};
; CHECK-NEXT:    ld.param.v4.b32 {%r8, %r9, %r10, %r11}, [nvvm_tcgen05_st_16x128b_unpack_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r12, %r13, %r14, %r15}, [nvvm_tcgen05_st_16x128b_unpack_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x4.unpack::16b.b32 [%r1], {%r12, %r13, %r14, %r15, %r8, %r9, %r10, %r11};
; CHECK-NEXT:    ld.param.v4.b32 {%r16, %r17, %r18, %r19}, [nvvm_tcgen05_st_16x128b_unpack_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r20, %r21, %r22, %r23}, [nvvm_tcgen05_st_16x128b_unpack_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r24, %r25, %r26, %r27}, [nvvm_tcgen05_st_16x128b_unpack_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r28, %r29, %r30, %r31}, [nvvm_tcgen05_st_16x128b_unpack_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x8.unpack::16b.b32 [%r1], {%r28, %r29, %r30, %r31, %r24, %r25, %r26, %r27, %r20, %r21, %r22, %r23, %r16, %r17, %r18, %r19};
; CHECK-NEXT:    ld.param.v4.b32 {%r32, %r33, %r34, %r35}, [nvvm_tcgen05_st_16x128b_unpack_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r36, %r37, %r38, %r39}, [nvvm_tcgen05_st_16x128b_unpack_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r40, %r41, %r42, %r43}, [nvvm_tcgen05_st_16x128b_unpack_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r44, %r45, %r46, %r47}, [nvvm_tcgen05_st_16x128b_unpack_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r48, %r49, %r50, %r51}, [nvvm_tcgen05_st_16x128b_unpack_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r52, %r53, %r54, %r55}, [nvvm_tcgen05_st_16x128b_unpack_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r56, %r57, %r58, %r59}, [nvvm_tcgen05_st_16x128b_unpack_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r60, %r61, %r62, %r63}, [nvvm_tcgen05_st_16x128b_unpack_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x16.unpack::16b.b32 [%r1], {%r60, %r61, %r62, %r63, %r56, %r57, %r58, %r59, %r52, %r53, %r54, %r55, %r48, %r49, %r50, %r51, %r44, %r45, %r46, %r47, %r40, %r41, %r42, %r43, %r36, %r37, %r38, %r39, %r32, %r33, %r34, %r35};
; CHECK-NEXT:    ld.param.v4.b32 {%r64, %r65, %r66, %r67}, [nvvm_tcgen05_st_16x128b_unpack_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r68, %r69, %r70, %r71}, [nvvm_tcgen05_st_16x128b_unpack_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r72, %r73, %r74, %r75}, [nvvm_tcgen05_st_16x128b_unpack_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r76, %r77, %r78, %r79}, [nvvm_tcgen05_st_16x128b_unpack_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r80, %r81, %r82, %r83}, [nvvm_tcgen05_st_16x128b_unpack_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r84, %r85, %r86, %r87}, [nvvm_tcgen05_st_16x128b_unpack_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r88, %r89, %r90, %r91}, [nvvm_tcgen05_st_16x128b_unpack_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r92, %r93, %r94, %r95}, [nvvm_tcgen05_st_16x128b_unpack_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r96, %r97, %r98, %r99}, [nvvm_tcgen05_st_16x128b_unpack_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r100, %r101, %r102, %r103}, [nvvm_tcgen05_st_16x128b_unpack_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r104, %r105, %r106, %r107}, [nvvm_tcgen05_st_16x128b_unpack_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r108, %r109, %r110, %r111}, [nvvm_tcgen05_st_16x128b_unpack_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r112, %r113, %r114, %r115}, [nvvm_tcgen05_st_16x128b_unpack_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r116, %r117, %r118, %r119}, [nvvm_tcgen05_st_16x128b_unpack_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r120, %r121, %r122, %r123}, [nvvm_tcgen05_st_16x128b_unpack_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r124, %r125, %r126, %r127}, [nvvm_tcgen05_st_16x128b_unpack_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x32.unpack::16b.b32 [%r1], {%r124, %r125, %r126, %r127, %r120, %r121, %r122, %r123, %r116, %r117, %r118, %r119, %r112, %r113, %r114, %r115, %r108, %r109, %r110, %r111, %r104, %r105, %r106, %r107, %r100, %r101, %r102, %r103, %r96, %r97, %r98, %r99, %r92, %r93, %r94, %r95, %r88, %r89, %r90, %r91, %r84, %r85, %r86, %r87, %r80, %r81, %r82, %r83, %r76, %r77, %r78, %r79, %r72, %r73, %r74, %r75, %r68, %r69, %r70, %r71, %r64, %r65, %r66, %r67};
; CHECK-NEXT:    ld.param.v4.b32 {%r128, %r129, %r130, %r131}, [nvvm_tcgen05_st_16x128b_unpack_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r132, %r133, %r134, %r135}, [nvvm_tcgen05_st_16x128b_unpack_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r136, %r137, %r138, %r139}, [nvvm_tcgen05_st_16x128b_unpack_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r140, %r141, %r142, %r143}, [nvvm_tcgen05_st_16x128b_unpack_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r144, %r145, %r146, %r147}, [nvvm_tcgen05_st_16x128b_unpack_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r148, %r149, %r150, %r151}, [nvvm_tcgen05_st_16x128b_unpack_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r152, %r153, %r154, %r155}, [nvvm_tcgen05_st_16x128b_unpack_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r156, %r157, %r158, %r159}, [nvvm_tcgen05_st_16x128b_unpack_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r160, %r161, %r162, %r163}, [nvvm_tcgen05_st_16x128b_unpack_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r164, %r165, %r166, %r167}, [nvvm_tcgen05_st_16x128b_unpack_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r168, %r169, %r170, %r171}, [nvvm_tcgen05_st_16x128b_unpack_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r172, %r173, %r174, %r175}, [nvvm_tcgen05_st_16x128b_unpack_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r176, %r177, %r178, %r179}, [nvvm_tcgen05_st_16x128b_unpack_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r180, %r181, %r182, %r183}, [nvvm_tcgen05_st_16x128b_unpack_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r184, %r185, %r186, %r187}, [nvvm_tcgen05_st_16x128b_unpack_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r188, %r189, %r190, %r191}, [nvvm_tcgen05_st_16x128b_unpack_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r192, %r193, %r194, %r195}, [nvvm_tcgen05_st_16x128b_unpack_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r196, %r197, %r198, %r199}, [nvvm_tcgen05_st_16x128b_unpack_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r200, %r201, %r202, %r203}, [nvvm_tcgen05_st_16x128b_unpack_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r204, %r205, %r206, %r207}, [nvvm_tcgen05_st_16x128b_unpack_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r208, %r209, %r210, %r211}, [nvvm_tcgen05_st_16x128b_unpack_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r212, %r213, %r214, %r215}, [nvvm_tcgen05_st_16x128b_unpack_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r216, %r217, %r218, %r219}, [nvvm_tcgen05_st_16x128b_unpack_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r220, %r221, %r222, %r223}, [nvvm_tcgen05_st_16x128b_unpack_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r224, %r225, %r226, %r227}, [nvvm_tcgen05_st_16x128b_unpack_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r228, %r229, %r230, %r231}, [nvvm_tcgen05_st_16x128b_unpack_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r232, %r233, %r234, %r235}, [nvvm_tcgen05_st_16x128b_unpack_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r236, %r237, %r238, %r239}, [nvvm_tcgen05_st_16x128b_unpack_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r240, %r241, %r242, %r243}, [nvvm_tcgen05_st_16x128b_unpack_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r244, %r245, %r246, %r247}, [nvvm_tcgen05_st_16x128b_unpack_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r248, %r249, %r250, %r251}, [nvvm_tcgen05_st_16x128b_unpack_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r252, %r253, %r254, %r255}, [nvvm_tcgen05_st_16x128b_unpack_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x128b.x64.unpack::16b.b32 [%r1], {%r252, %r253, %r254, %r255, %r248, %r249, %r250, %r251, %r244, %r245, %r246, %r247, %r240, %r241, %r242, %r243, %r236, %r237, %r238, %r239, %r232, %r233, %r234, %r235, %r228, %r229, %r230, %r231, %r224, %r225, %r226, %r227, %r220, %r221, %r222, %r223, %r216, %r217, %r218, %r219, %r212, %r213, %r214, %r215, %r208, %r209, %r210, %r211, %r204, %r205, %r206, %r207, %r200, %r201, %r202, %r203, %r196, %r197, %r198, %r199, %r192, %r193, %r194, %r195, %r188, %r189, %r190, %r191, %r184, %r185, %r186, %r187, %r180, %r181, %r182, %r183, %r176, %r177, %r178, %r179, %r172, %r173, %r174, %r175, %r168, %r169, %r170, %r171, %r164, %r165, %r166, %r167, %r160, %r161, %r162, %r163, %r156, %r157, %r158, %r159, %r152, %r153, %r154, %r155, %r148, %r149, %r150, %r151, %r144, %r145, %r146, %r147, %r140, %r141, %r142, %r143, %r136, %r137, %r138, %r139, %r132, %r133, %r134, %r135, %r128, %r129, %r130, %r131};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x128b.x1(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x2(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x4(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x8(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x16(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x32(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x128b.x64(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 1)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x256b
define void @nvvm_tcgen05_st_16x256b(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x256b(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<254>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x256b_param_0];
; CHECK-NEXT:    ld.param.v4.b32 {%r2, %r3, %r4, %r5}, [nvvm_tcgen05_st_16x256b_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x1.b32 [%r1], {%r2, %r3, %r4, %r5};
; CHECK-NEXT:    ld.param.v4.b32 {%r6, %r7, %r8, %r9}, [nvvm_tcgen05_st_16x256b_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r10, %r11, %r12, %r13}, [nvvm_tcgen05_st_16x256b_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x2.b32 [%r1], {%r10, %r11, %r12, %r13, %r6, %r7, %r8, %r9};
; CHECK-NEXT:    ld.param.v4.b32 {%r14, %r15, %r16, %r17}, [nvvm_tcgen05_st_16x256b_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r18, %r19, %r20, %r21}, [nvvm_tcgen05_st_16x256b_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r22, %r23, %r24, %r25}, [nvvm_tcgen05_st_16x256b_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r26, %r27, %r28, %r29}, [nvvm_tcgen05_st_16x256b_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x4.b32 [%r1], {%r26, %r27, %r28, %r29, %r22, %r23, %r24, %r25, %r18, %r19, %r20, %r21, %r14, %r15, %r16, %r17};
; CHECK-NEXT:    ld.param.v4.b32 {%r30, %r31, %r32, %r33}, [nvvm_tcgen05_st_16x256b_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r34, %r35, %r36, %r37}, [nvvm_tcgen05_st_16x256b_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r38, %r39, %r40, %r41}, [nvvm_tcgen05_st_16x256b_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r42, %r43, %r44, %r45}, [nvvm_tcgen05_st_16x256b_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r46, %r47, %r48, %r49}, [nvvm_tcgen05_st_16x256b_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r50, %r51, %r52, %r53}, [nvvm_tcgen05_st_16x256b_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r54, %r55, %r56, %r57}, [nvvm_tcgen05_st_16x256b_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r58, %r59, %r60, %r61}, [nvvm_tcgen05_st_16x256b_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x8.b32 [%r1], {%r58, %r59, %r60, %r61, %r54, %r55, %r56, %r57, %r50, %r51, %r52, %r53, %r46, %r47, %r48, %r49, %r42, %r43, %r44, %r45, %r38, %r39, %r40, %r41, %r34, %r35, %r36, %r37, %r30, %r31, %r32, %r33};
; CHECK-NEXT:    ld.param.v4.b32 {%r62, %r63, %r64, %r65}, [nvvm_tcgen05_st_16x256b_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r66, %r67, %r68, %r69}, [nvvm_tcgen05_st_16x256b_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r70, %r71, %r72, %r73}, [nvvm_tcgen05_st_16x256b_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r74, %r75, %r76, %r77}, [nvvm_tcgen05_st_16x256b_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r78, %r79, %r80, %r81}, [nvvm_tcgen05_st_16x256b_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r82, %r83, %r84, %r85}, [nvvm_tcgen05_st_16x256b_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r86, %r87, %r88, %r89}, [nvvm_tcgen05_st_16x256b_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r90, %r91, %r92, %r93}, [nvvm_tcgen05_st_16x256b_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r94, %r95, %r96, %r97}, [nvvm_tcgen05_st_16x256b_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r98, %r99, %r100, %r101}, [nvvm_tcgen05_st_16x256b_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r102, %r103, %r104, %r105}, [nvvm_tcgen05_st_16x256b_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r106, %r107, %r108, %r109}, [nvvm_tcgen05_st_16x256b_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r110, %r111, %r112, %r113}, [nvvm_tcgen05_st_16x256b_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r114, %r115, %r116, %r117}, [nvvm_tcgen05_st_16x256b_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r118, %r119, %r120, %r121}, [nvvm_tcgen05_st_16x256b_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r122, %r123, %r124, %r125}, [nvvm_tcgen05_st_16x256b_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x16.b32 [%r1], {%r122, %r123, %r124, %r125, %r118, %r119, %r120, %r121, %r114, %r115, %r116, %r117, %r110, %r111, %r112, %r113, %r106, %r107, %r108, %r109, %r102, %r103, %r104, %r105, %r98, %r99, %r100, %r101, %r94, %r95, %r96, %r97, %r90, %r91, %r92, %r93, %r86, %r87, %r88, %r89, %r82, %r83, %r84, %r85, %r78, %r79, %r80, %r81, %r74, %r75, %r76, %r77, %r70, %r71, %r72, %r73, %r66, %r67, %r68, %r69, %r62, %r63, %r64, %r65};
; CHECK-NEXT:    ld.param.v4.b32 {%r126, %r127, %r128, %r129}, [nvvm_tcgen05_st_16x256b_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r130, %r131, %r132, %r133}, [nvvm_tcgen05_st_16x256b_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r134, %r135, %r136, %r137}, [nvvm_tcgen05_st_16x256b_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r138, %r139, %r140, %r141}, [nvvm_tcgen05_st_16x256b_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r142, %r143, %r144, %r145}, [nvvm_tcgen05_st_16x256b_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r146, %r147, %r148, %r149}, [nvvm_tcgen05_st_16x256b_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r150, %r151, %r152, %r153}, [nvvm_tcgen05_st_16x256b_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r154, %r155, %r156, %r157}, [nvvm_tcgen05_st_16x256b_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r158, %r159, %r160, %r161}, [nvvm_tcgen05_st_16x256b_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r162, %r163, %r164, %r165}, [nvvm_tcgen05_st_16x256b_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r166, %r167, %r168, %r169}, [nvvm_tcgen05_st_16x256b_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r170, %r171, %r172, %r173}, [nvvm_tcgen05_st_16x256b_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r174, %r175, %r176, %r177}, [nvvm_tcgen05_st_16x256b_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r178, %r179, %r180, %r181}, [nvvm_tcgen05_st_16x256b_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r182, %r183, %r184, %r185}, [nvvm_tcgen05_st_16x256b_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r186, %r187, %r188, %r189}, [nvvm_tcgen05_st_16x256b_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r190, %r191, %r192, %r193}, [nvvm_tcgen05_st_16x256b_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r194, %r195, %r196, %r197}, [nvvm_tcgen05_st_16x256b_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r198, %r199, %r200, %r201}, [nvvm_tcgen05_st_16x256b_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r202, %r203, %r204, %r205}, [nvvm_tcgen05_st_16x256b_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r206, %r207, %r208, %r209}, [nvvm_tcgen05_st_16x256b_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r210, %r211, %r212, %r213}, [nvvm_tcgen05_st_16x256b_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r214, %r215, %r216, %r217}, [nvvm_tcgen05_st_16x256b_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r218, %r219, %r220, %r221}, [nvvm_tcgen05_st_16x256b_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r222, %r223, %r224, %r225}, [nvvm_tcgen05_st_16x256b_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r226, %r227, %r228, %r229}, [nvvm_tcgen05_st_16x256b_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r230, %r231, %r232, %r233}, [nvvm_tcgen05_st_16x256b_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r234, %r235, %r236, %r237}, [nvvm_tcgen05_st_16x256b_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r238, %r239, %r240, %r241}, [nvvm_tcgen05_st_16x256b_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r242, %r243, %r244, %r245}, [nvvm_tcgen05_st_16x256b_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r246, %r247, %r248, %r249}, [nvvm_tcgen05_st_16x256b_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r250, %r251, %r252, %r253}, [nvvm_tcgen05_st_16x256b_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x32.b32 [%r1], {%r250, %r251, %r252, %r253, %r246, %r247, %r248, %r249, %r242, %r243, %r244, %r245, %r238, %r239, %r240, %r241, %r234, %r235, %r236, %r237, %r230, %r231, %r232, %r233, %r226, %r227, %r228, %r229, %r222, %r223, %r224, %r225, %r218, %r219, %r220, %r221, %r214, %r215, %r216, %r217, %r210, %r211, %r212, %r213, %r206, %r207, %r208, %r209, %r202, %r203, %r204, %r205, %r198, %r199, %r200, %r201, %r194, %r195, %r196, %r197, %r190, %r191, %r192, %r193, %r186, %r187, %r188, %r189, %r182, %r183, %r184, %r185, %r178, %r179, %r180, %r181, %r174, %r175, %r176, %r177, %r170, %r171, %r172, %r173, %r166, %r167, %r168, %r169, %r162, %r163, %r164, %r165, %r158, %r159, %r160, %r161, %r154, %r155, %r156, %r157, %r150, %r151, %r152, %r153, %r146, %r147, %r148, %r149, %r142, %r143, %r144, %r145, %r138, %r139, %r140, %r141, %r134, %r135, %r136, %r137, %r130, %r131, %r132, %r133, %r126, %r127, %r128, %r129};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x256b.x1(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x2(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x4(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x8(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x16(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x32(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 0)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x256b_unpack
define void @nvvm_tcgen05_st_16x256b_unpack(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x256b_unpack(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<254>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x256b_unpack_param_0];
; CHECK-NEXT:    ld.param.v4.b32 {%r2, %r3, %r4, %r5}, [nvvm_tcgen05_st_16x256b_unpack_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x1.unpack::16b.b32 [%r1], {%r2, %r3, %r4, %r5};
; CHECK-NEXT:    ld.param.v4.b32 {%r6, %r7, %r8, %r9}, [nvvm_tcgen05_st_16x256b_unpack_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r10, %r11, %r12, %r13}, [nvvm_tcgen05_st_16x256b_unpack_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x2.unpack::16b.b32 [%r1], {%r10, %r11, %r12, %r13, %r6, %r7, %r8, %r9};
; CHECK-NEXT:    ld.param.v4.b32 {%r14, %r15, %r16, %r17}, [nvvm_tcgen05_st_16x256b_unpack_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r18, %r19, %r20, %r21}, [nvvm_tcgen05_st_16x256b_unpack_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r22, %r23, %r24, %r25}, [nvvm_tcgen05_st_16x256b_unpack_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r26, %r27, %r28, %r29}, [nvvm_tcgen05_st_16x256b_unpack_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x4.unpack::16b.b32 [%r1], {%r26, %r27, %r28, %r29, %r22, %r23, %r24, %r25, %r18, %r19, %r20, %r21, %r14, %r15, %r16, %r17};
; CHECK-NEXT:    ld.param.v4.b32 {%r30, %r31, %r32, %r33}, [nvvm_tcgen05_st_16x256b_unpack_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r34, %r35, %r36, %r37}, [nvvm_tcgen05_st_16x256b_unpack_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r38, %r39, %r40, %r41}, [nvvm_tcgen05_st_16x256b_unpack_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r42, %r43, %r44, %r45}, [nvvm_tcgen05_st_16x256b_unpack_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r46, %r47, %r48, %r49}, [nvvm_tcgen05_st_16x256b_unpack_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r50, %r51, %r52, %r53}, [nvvm_tcgen05_st_16x256b_unpack_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r54, %r55, %r56, %r57}, [nvvm_tcgen05_st_16x256b_unpack_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r58, %r59, %r60, %r61}, [nvvm_tcgen05_st_16x256b_unpack_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x8.unpack::16b.b32 [%r1], {%r58, %r59, %r60, %r61, %r54, %r55, %r56, %r57, %r50, %r51, %r52, %r53, %r46, %r47, %r48, %r49, %r42, %r43, %r44, %r45, %r38, %r39, %r40, %r41, %r34, %r35, %r36, %r37, %r30, %r31, %r32, %r33};
; CHECK-NEXT:    ld.param.v4.b32 {%r62, %r63, %r64, %r65}, [nvvm_tcgen05_st_16x256b_unpack_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r66, %r67, %r68, %r69}, [nvvm_tcgen05_st_16x256b_unpack_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r70, %r71, %r72, %r73}, [nvvm_tcgen05_st_16x256b_unpack_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r74, %r75, %r76, %r77}, [nvvm_tcgen05_st_16x256b_unpack_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r78, %r79, %r80, %r81}, [nvvm_tcgen05_st_16x256b_unpack_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r82, %r83, %r84, %r85}, [nvvm_tcgen05_st_16x256b_unpack_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r86, %r87, %r88, %r89}, [nvvm_tcgen05_st_16x256b_unpack_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r90, %r91, %r92, %r93}, [nvvm_tcgen05_st_16x256b_unpack_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r94, %r95, %r96, %r97}, [nvvm_tcgen05_st_16x256b_unpack_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r98, %r99, %r100, %r101}, [nvvm_tcgen05_st_16x256b_unpack_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r102, %r103, %r104, %r105}, [nvvm_tcgen05_st_16x256b_unpack_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r106, %r107, %r108, %r109}, [nvvm_tcgen05_st_16x256b_unpack_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r110, %r111, %r112, %r113}, [nvvm_tcgen05_st_16x256b_unpack_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r114, %r115, %r116, %r117}, [nvvm_tcgen05_st_16x256b_unpack_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r118, %r119, %r120, %r121}, [nvvm_tcgen05_st_16x256b_unpack_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r122, %r123, %r124, %r125}, [nvvm_tcgen05_st_16x256b_unpack_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x16.unpack::16b.b32 [%r1], {%r122, %r123, %r124, %r125, %r118, %r119, %r120, %r121, %r114, %r115, %r116, %r117, %r110, %r111, %r112, %r113, %r106, %r107, %r108, %r109, %r102, %r103, %r104, %r105, %r98, %r99, %r100, %r101, %r94, %r95, %r96, %r97, %r90, %r91, %r92, %r93, %r86, %r87, %r88, %r89, %r82, %r83, %r84, %r85, %r78, %r79, %r80, %r81, %r74, %r75, %r76, %r77, %r70, %r71, %r72, %r73, %r66, %r67, %r68, %r69, %r62, %r63, %r64, %r65};
; CHECK-NEXT:    ld.param.v4.b32 {%r126, %r127, %r128, %r129}, [nvvm_tcgen05_st_16x256b_unpack_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r130, %r131, %r132, %r133}, [nvvm_tcgen05_st_16x256b_unpack_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r134, %r135, %r136, %r137}, [nvvm_tcgen05_st_16x256b_unpack_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r138, %r139, %r140, %r141}, [nvvm_tcgen05_st_16x256b_unpack_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r142, %r143, %r144, %r145}, [nvvm_tcgen05_st_16x256b_unpack_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r146, %r147, %r148, %r149}, [nvvm_tcgen05_st_16x256b_unpack_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r150, %r151, %r152, %r153}, [nvvm_tcgen05_st_16x256b_unpack_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r154, %r155, %r156, %r157}, [nvvm_tcgen05_st_16x256b_unpack_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r158, %r159, %r160, %r161}, [nvvm_tcgen05_st_16x256b_unpack_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r162, %r163, %r164, %r165}, [nvvm_tcgen05_st_16x256b_unpack_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r166, %r167, %r168, %r169}, [nvvm_tcgen05_st_16x256b_unpack_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r170, %r171, %r172, %r173}, [nvvm_tcgen05_st_16x256b_unpack_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r174, %r175, %r176, %r177}, [nvvm_tcgen05_st_16x256b_unpack_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r178, %r179, %r180, %r181}, [nvvm_tcgen05_st_16x256b_unpack_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r182, %r183, %r184, %r185}, [nvvm_tcgen05_st_16x256b_unpack_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r186, %r187, %r188, %r189}, [nvvm_tcgen05_st_16x256b_unpack_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r190, %r191, %r192, %r193}, [nvvm_tcgen05_st_16x256b_unpack_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r194, %r195, %r196, %r197}, [nvvm_tcgen05_st_16x256b_unpack_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r198, %r199, %r200, %r201}, [nvvm_tcgen05_st_16x256b_unpack_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r202, %r203, %r204, %r205}, [nvvm_tcgen05_st_16x256b_unpack_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r206, %r207, %r208, %r209}, [nvvm_tcgen05_st_16x256b_unpack_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r210, %r211, %r212, %r213}, [nvvm_tcgen05_st_16x256b_unpack_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r214, %r215, %r216, %r217}, [nvvm_tcgen05_st_16x256b_unpack_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r218, %r219, %r220, %r221}, [nvvm_tcgen05_st_16x256b_unpack_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r222, %r223, %r224, %r225}, [nvvm_tcgen05_st_16x256b_unpack_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r226, %r227, %r228, %r229}, [nvvm_tcgen05_st_16x256b_unpack_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r230, %r231, %r232, %r233}, [nvvm_tcgen05_st_16x256b_unpack_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r234, %r235, %r236, %r237}, [nvvm_tcgen05_st_16x256b_unpack_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r238, %r239, %r240, %r241}, [nvvm_tcgen05_st_16x256b_unpack_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r242, %r243, %r244, %r245}, [nvvm_tcgen05_st_16x256b_unpack_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r246, %r247, %r248, %r249}, [nvvm_tcgen05_st_16x256b_unpack_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r250, %r251, %r252, %r253}, [nvvm_tcgen05_st_16x256b_unpack_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x256b.x32.unpack::16b.b32 [%r1], {%r250, %r251, %r252, %r253, %r246, %r247, %r248, %r249, %r242, %r243, %r244, %r245, %r238, %r239, %r240, %r241, %r234, %r235, %r236, %r237, %r230, %r231, %r232, %r233, %r226, %r227, %r228, %r229, %r222, %r223, %r224, %r225, %r218, %r219, %r220, %r221, %r214, %r215, %r216, %r217, %r210, %r211, %r212, %r213, %r206, %r207, %r208, %r209, %r202, %r203, %r204, %r205, %r198, %r199, %r200, %r201, %r194, %r195, %r196, %r197, %r190, %r191, %r192, %r193, %r186, %r187, %r188, %r189, %r182, %r183, %r184, %r185, %r178, %r179, %r180, %r181, %r174, %r175, %r176, %r177, %r170, %r171, %r172, %r173, %r166, %r167, %r168, %r169, %r162, %r163, %r164, %r165, %r158, %r159, %r160, %r161, %r154, %r155, %r156, %r157, %r150, %r151, %r152, %r153, %r146, %r147, %r148, %r149, %r142, %r143, %r144, %r145, %r138, %r139, %r140, %r141, %r134, %r135, %r136, %r137, %r130, %r131, %r132, %r133, %r126, %r127, %r128, %r129};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x256b.x1(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x2(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x4(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x8(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x16(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x256b.x32(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 1)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_32x32b
define void @nvvm_tcgen05_st_32x32b(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_32x32b(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_32x32b_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_32x32b_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x1.b32 [%r1], {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_32x32b_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x2.b32 [%r1], {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_32x32b_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x4.b32 [%r1], {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_32x32b_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_32x32b_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x8.b32 [%r1], {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_32x32b_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_32x32b_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_32x32b_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_32x32b_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x16.b32 [%r1], {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_32x32b_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_32x32b_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_32x32b_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_32x32b_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_32x32b_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_32x32b_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_32x32b_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_32x32b_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x32.b32 [%r1], {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_32x32b_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_32x32b_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_32x32b_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_32x32b_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_32x32b_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_32x32b_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_32x32b_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_32x32b_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_32x32b_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_32x32b_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_32x32b_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_32x32b_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_32x32b_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_32x32b_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_32x32b_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_32x32b_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x64.b32 [%r1], {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_32x32b_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_32x32b_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_32x32b_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_32x32b_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_32x32b_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_32x32b_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_32x32b_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_32x32b_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_32x32b_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_32x32b_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_32x32b_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_32x32b_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_32x32b_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_32x32b_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_32x32b_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_32x32b_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_32x32b_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_32x32b_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_32x32b_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_32x32b_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_32x32b_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_32x32b_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_32x32b_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_32x32b_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_32x32b_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_32x32b_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_32x32b_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_32x32b_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_32x32b_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_32x32b_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_32x32b_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_32x32b_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x128.b32 [%r1], {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.32x32b.x1(ptr addrspace(6) %taddr, i32 %stv1, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x2(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x4(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x8(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x16(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x32(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x64(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x128(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 0)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_32x32b_unpack
define void @nvvm_tcgen05_st_32x32b_unpack(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_32x32b_unpack(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_32x32b_unpack_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_32x32b_unpack_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x1.unpack::16b.b32 [%r1], {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_32x32b_unpack_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x2.unpack::16b.b32 [%r1], {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_32x32b_unpack_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x4.unpack::16b.b32 [%r1], {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_32x32b_unpack_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_32x32b_unpack_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x8.unpack::16b.b32 [%r1], {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_32x32b_unpack_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_32x32b_unpack_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_32x32b_unpack_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_32x32b_unpack_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x16.unpack::16b.b32 [%r1], {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_32x32b_unpack_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_32x32b_unpack_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_32x32b_unpack_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_32x32b_unpack_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_32x32b_unpack_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_32x32b_unpack_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_32x32b_unpack_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_32x32b_unpack_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x32.unpack::16b.b32 [%r1], {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_32x32b_unpack_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_32x32b_unpack_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_32x32b_unpack_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_32x32b_unpack_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_32x32b_unpack_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_32x32b_unpack_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_32x32b_unpack_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_32x32b_unpack_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_32x32b_unpack_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_32x32b_unpack_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_32x32b_unpack_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_32x32b_unpack_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_32x32b_unpack_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_32x32b_unpack_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_32x32b_unpack_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_32x32b_unpack_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x64.unpack::16b.b32 [%r1], {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_32x32b_unpack_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_32x32b_unpack_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_32x32b_unpack_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_32x32b_unpack_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_32x32b_unpack_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_32x32b_unpack_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_32x32b_unpack_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_32x32b_unpack_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_32x32b_unpack_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_32x32b_unpack_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_32x32b_unpack_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_32x32b_unpack_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_32x32b_unpack_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_32x32b_unpack_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_32x32b_unpack_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_32x32b_unpack_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_32x32b_unpack_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_32x32b_unpack_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_32x32b_unpack_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_32x32b_unpack_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_32x32b_unpack_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_32x32b_unpack_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_32x32b_unpack_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_32x32b_unpack_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_32x32b_unpack_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_32x32b_unpack_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_32x32b_unpack_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_32x32b_unpack_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_32x32b_unpack_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_32x32b_unpack_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_32x32b_unpack_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_32x32b_unpack_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.32x32b.x128.unpack::16b.b32 [%r1], {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.32x32b.x1(ptr addrspace(6) %taddr, i32 %stv1, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x2(ptr addrspace(6) %taddr, <2 x i32> %stv2, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x4(ptr addrspace(6) %taddr, <4 x i32> %stv4, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x8(ptr addrspace(6) %taddr, <8 x i32> %stv8, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x16(ptr addrspace(6) %taddr, <16 x i32> %stv16, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x32(ptr addrspace(6) %taddr, <32 x i32> %stv32, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x64(ptr addrspace(6) %taddr, <64 x i32> %stv64, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.32x32b.x128(ptr addrspace(6) %taddr, <128 x i32> %stv128, i1 1)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x32bx2
define void @nvvm_tcgen05_st_16x32bx2(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x32bx2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x32bx2_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_16x32bx2_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x1.b32 [%r1], 2, {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_16x32bx2_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x2.b32 [%r1], 2, {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_16x32bx2_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x4.b32 [%r1], 2, {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_16x32bx2_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_16x32bx2_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x8.b32 [%r1], 2, {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_16x32bx2_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_16x32bx2_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_16x32bx2_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_16x32bx2_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x16.b32 [%r1], 2, {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_16x32bx2_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_16x32bx2_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_16x32bx2_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_16x32bx2_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_16x32bx2_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_16x32bx2_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_16x32bx2_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_16x32bx2_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x32.b32 [%r1], 2, {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_16x32bx2_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_16x32bx2_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_16x32bx2_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_16x32bx2_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_16x32bx2_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_16x32bx2_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_16x32bx2_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_16x32bx2_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_16x32bx2_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_16x32bx2_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_16x32bx2_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_16x32bx2_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_16x32bx2_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_16x32bx2_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_16x32bx2_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_16x32bx2_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x64.b32 [%r1], 2, {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_16x32bx2_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_16x32bx2_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_16x32bx2_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_16x32bx2_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_16x32bx2_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_16x32bx2_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_16x32bx2_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_16x32bx2_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_16x32bx2_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_16x32bx2_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_16x32bx2_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_16x32bx2_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_16x32bx2_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_16x32bx2_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_16x32bx2_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_16x32bx2_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_16x32bx2_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_16x32bx2_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_16x32bx2_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_16x32bx2_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_16x32bx2_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_16x32bx2_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_16x32bx2_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_16x32bx2_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_16x32bx2_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_16x32bx2_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_16x32bx2_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_16x32bx2_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_16x32bx2_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_16x32bx2_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_16x32bx2_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_16x32bx2_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x128.b32 [%r1], 2, {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x1(ptr addrspace(6) %taddr, i64 2, i32 %stv1, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x2(ptr addrspace(6) %taddr, i64 2, <2 x i32> %stv2, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x4(ptr addrspace(6) %taddr, i64 2, <4 x i32> %stv4, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x8(ptr addrspace(6) %taddr, i64 2, <8 x i32> %stv8, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x16(ptr addrspace(6) %taddr, i64 2, <16 x i32> %stv16, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x32(ptr addrspace(6) %taddr, i64 2, <32 x i32> %stv32, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x64(ptr addrspace(6) %taddr, i64 2, <64 x i32> %stv64, i1 0)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x128(ptr addrspace(6) %taddr, i64 2, <128 x i32> %stv128, i1 0)
  ret void
}

; CHECK-LABEL: nvvm_tcgen05_st_16x32bx2_unpack
define void @nvvm_tcgen05_st_16x32bx2_unpack(ptr addrspace(6) %taddr, i32 %stv1, <2 x i32> %stv2, <4 x i32> %stv4, <8 x i32> %stv8, <16 x i32> %stv16, <32 x i32> %stv32, <64 x i32> %stv64, <128 x i32> %stv128) {
; CHECK-LABEL: nvvm_tcgen05_st_16x32bx2_unpack(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<257>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [nvvm_tcgen05_st_16x32bx2_unpack_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [nvvm_tcgen05_st_16x32bx2_unpack_param_1];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x1.unpack::16b.b32 [%r1], 2, {%r2};
; CHECK-NEXT:    ld.param.v2.b32 {%r3, %r4}, [nvvm_tcgen05_st_16x32bx2_unpack_param_2];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x2.unpack::16b.b32 [%r1], 2, {%r3, %r4};
; CHECK-NEXT:    ld.param.v4.b32 {%r5, %r6, %r7, %r8}, [nvvm_tcgen05_st_16x32bx2_unpack_param_3];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x4.unpack::16b.b32 [%r1], 2, {%r5, %r6, %r7, %r8};
; CHECK-NEXT:    ld.param.v4.b32 {%r9, %r10, %r11, %r12}, [nvvm_tcgen05_st_16x32bx2_unpack_param_4+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r13, %r14, %r15, %r16}, [nvvm_tcgen05_st_16x32bx2_unpack_param_4];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x8.unpack::16b.b32 [%r1], 2, {%r13, %r14, %r15, %r16, %r9, %r10, %r11, %r12};
; CHECK-NEXT:    ld.param.v4.b32 {%r17, %r18, %r19, %r20}, [nvvm_tcgen05_st_16x32bx2_unpack_param_5+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r21, %r22, %r23, %r24}, [nvvm_tcgen05_st_16x32bx2_unpack_param_5+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r25, %r26, %r27, %r28}, [nvvm_tcgen05_st_16x32bx2_unpack_param_5+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r29, %r30, %r31, %r32}, [nvvm_tcgen05_st_16x32bx2_unpack_param_5];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x16.unpack::16b.b32 [%r1], 2, {%r29, %r30, %r31, %r32, %r25, %r26, %r27, %r28, %r21, %r22, %r23, %r24, %r17, %r18, %r19, %r20};
; CHECK-NEXT:    ld.param.v4.b32 {%r33, %r34, %r35, %r36}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r37, %r38, %r39, %r40}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r41, %r42, %r43, %r44}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r45, %r46, %r47, %r48}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r49, %r50, %r51, %r52}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r53, %r54, %r55, %r56}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r57, %r58, %r59, %r60}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r61, %r62, %r63, %r64}, [nvvm_tcgen05_st_16x32bx2_unpack_param_6];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x32.unpack::16b.b32 [%r1], 2, {%r61, %r62, %r63, %r64, %r57, %r58, %r59, %r60, %r53, %r54, %r55, %r56, %r49, %r50, %r51, %r52, %r45, %r46, %r47, %r48, %r41, %r42, %r43, %r44, %r37, %r38, %r39, %r40, %r33, %r34, %r35, %r36};
; CHECK-NEXT:    ld.param.v4.b32 {%r65, %r66, %r67, %r68}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r69, %r70, %r71, %r72}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r73, %r74, %r75, %r76}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r77, %r78, %r79, %r80}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r81, %r82, %r83, %r84}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r85, %r86, %r87, %r88}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r89, %r90, %r91, %r92}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r93, %r94, %r95, %r96}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r97, %r98, %r99, %r100}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r101, %r102, %r103, %r104}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r105, %r106, %r107, %r108}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r109, %r110, %r111, %r112}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r113, %r114, %r115, %r116}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r117, %r118, %r119, %r120}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r121, %r122, %r123, %r124}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r125, %r126, %r127, %r128}, [nvvm_tcgen05_st_16x32bx2_unpack_param_7];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x64.unpack::16b.b32 [%r1], 2, {%r125, %r126, %r127, %r128, %r121, %r122, %r123, %r124, %r117, %r118, %r119, %r120, %r113, %r114, %r115, %r116, %r109, %r110, %r111, %r112, %r105, %r106, %r107, %r108, %r101, %r102, %r103, %r104, %r97, %r98, %r99, %r100, %r93, %r94, %r95, %r96, %r89, %r90, %r91, %r92, %r85, %r86, %r87, %r88, %r81, %r82, %r83, %r84, %r77, %r78, %r79, %r80, %r73, %r74, %r75, %r76, %r69, %r70, %r71, %r72, %r65, %r66, %r67, %r68};
; CHECK-NEXT:    ld.param.v4.b32 {%r129, %r130, %r131, %r132}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+496];
; CHECK-NEXT:    ld.param.v4.b32 {%r133, %r134, %r135, %r136}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+480];
; CHECK-NEXT:    ld.param.v4.b32 {%r137, %r138, %r139, %r140}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+464];
; CHECK-NEXT:    ld.param.v4.b32 {%r141, %r142, %r143, %r144}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+448];
; CHECK-NEXT:    ld.param.v4.b32 {%r145, %r146, %r147, %r148}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+432];
; CHECK-NEXT:    ld.param.v4.b32 {%r149, %r150, %r151, %r152}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+416];
; CHECK-NEXT:    ld.param.v4.b32 {%r153, %r154, %r155, %r156}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+400];
; CHECK-NEXT:    ld.param.v4.b32 {%r157, %r158, %r159, %r160}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+384];
; CHECK-NEXT:    ld.param.v4.b32 {%r161, %r162, %r163, %r164}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+368];
; CHECK-NEXT:    ld.param.v4.b32 {%r165, %r166, %r167, %r168}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+352];
; CHECK-NEXT:    ld.param.v4.b32 {%r169, %r170, %r171, %r172}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+336];
; CHECK-NEXT:    ld.param.v4.b32 {%r173, %r174, %r175, %r176}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+320];
; CHECK-NEXT:    ld.param.v4.b32 {%r177, %r178, %r179, %r180}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+304];
; CHECK-NEXT:    ld.param.v4.b32 {%r181, %r182, %r183, %r184}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+288];
; CHECK-NEXT:    ld.param.v4.b32 {%r185, %r186, %r187, %r188}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+272];
; CHECK-NEXT:    ld.param.v4.b32 {%r189, %r190, %r191, %r192}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+256];
; CHECK-NEXT:    ld.param.v4.b32 {%r193, %r194, %r195, %r196}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+240];
; CHECK-NEXT:    ld.param.v4.b32 {%r197, %r198, %r199, %r200}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+224];
; CHECK-NEXT:    ld.param.v4.b32 {%r201, %r202, %r203, %r204}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+208];
; CHECK-NEXT:    ld.param.v4.b32 {%r205, %r206, %r207, %r208}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+192];
; CHECK-NEXT:    ld.param.v4.b32 {%r209, %r210, %r211, %r212}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+176];
; CHECK-NEXT:    ld.param.v4.b32 {%r213, %r214, %r215, %r216}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+160];
; CHECK-NEXT:    ld.param.v4.b32 {%r217, %r218, %r219, %r220}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+144];
; CHECK-NEXT:    ld.param.v4.b32 {%r221, %r222, %r223, %r224}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+128];
; CHECK-NEXT:    ld.param.v4.b32 {%r225, %r226, %r227, %r228}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+112];
; CHECK-NEXT:    ld.param.v4.b32 {%r229, %r230, %r231, %r232}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+96];
; CHECK-NEXT:    ld.param.v4.b32 {%r233, %r234, %r235, %r236}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+80];
; CHECK-NEXT:    ld.param.v4.b32 {%r237, %r238, %r239, %r240}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+64];
; CHECK-NEXT:    ld.param.v4.b32 {%r241, %r242, %r243, %r244}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+48];
; CHECK-NEXT:    ld.param.v4.b32 {%r245, %r246, %r247, %r248}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+32];
; CHECK-NEXT:    ld.param.v4.b32 {%r249, %r250, %r251, %r252}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8+16];
; CHECK-NEXT:    ld.param.v4.b32 {%r253, %r254, %r255, %r256}, [nvvm_tcgen05_st_16x32bx2_unpack_param_8];
; CHECK-NEXT:    tcgen05.st.sync.aligned.16x32bx2.x128.unpack::16b.b32 [%r1], 2, {%r253, %r254, %r255, %r256, %r249, %r250, %r251, %r252, %r245, %r246, %r247, %r248, %r241, %r242, %r243, %r244, %r237, %r238, %r239, %r240, %r233, %r234, %r235, %r236, %r229, %r230, %r231, %r232, %r225, %r226, %r227, %r228, %r221, %r222, %r223, %r224, %r217, %r218, %r219, %r220, %r213, %r214, %r215, %r216, %r209, %r210, %r211, %r212, %r205, %r206, %r207, %r208, %r201, %r202, %r203, %r204, %r197, %r198, %r199, %r200, %r193, %r194, %r195, %r196, %r189, %r190, %r191, %r192, %r185, %r186, %r187, %r188, %r181, %r182, %r183, %r184, %r177, %r178, %r179, %r180, %r173, %r174, %r175, %r176, %r169, %r170, %r171, %r172, %r165, %r166, %r167, %r168, %r161, %r162, %r163, %r164, %r157, %r158, %r159, %r160, %r153, %r154, %r155, %r156, %r149, %r150, %r151, %r152, %r145, %r146, %r147, %r148, %r141, %r142, %r143, %r144, %r137, %r138, %r139, %r140, %r133, %r134, %r135, %r136, %r129, %r130, %r131, %r132};
; CHECK-NEXT:    ret;
  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x1(ptr addrspace(6) %taddr, i64 2, i32 %stv1, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x2(ptr addrspace(6) %taddr, i64 2, <2 x i32> %stv2, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x4(ptr addrspace(6) %taddr, i64 2, <4 x i32> %stv4, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x8(ptr addrspace(6) %taddr, i64 2, <8 x i32> %stv8, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x16(ptr addrspace(6) %taddr, i64 2, <16 x i32> %stv16, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x32(ptr addrspace(6) %taddr, i64 2, <32 x i32> %stv32, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x64(ptr addrspace(6) %taddr, i64 2, <64 x i32> %stv64, i1 1)

  tail call void @llvm.nvvm.tcgen05.st.16x32bx2.x128(ptr addrspace(6) %taddr, i64 2, <128 x i32> %stv128, i1 1)
  ret void
}
