/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeFenceMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J$\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "createNodesForFenceStart", "", "openingInfo", "Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider$OpeningInfo;", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "obtainFenceOpeningInfo", "Companion", "OpeningInfo", "markdown"})
public class CodeFenceProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex REGEX = new Regex("^ {0,3}(~~~+|```+)([^`]*)$");

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        Intrinsics.checkNotNullParameter(stateInfo, "stateInfo");
        OpeningInfo openingInfo = this.obtainFenceOpeningInfo(pos, stateInfo.getCurrentConstraints());
        if (openingInfo == null) {
            return CollectionsKt.emptyList();
        }
        OpeningInfo openingInfo2 = openingInfo;
        this.createNodesForFenceStart(pos, openingInfo2, productionHolder);
        return CollectionsKt.listOf(new CodeFenceMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, openingInfo2.getDelimiter()));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        return this.obtainFenceOpeningInfo(pos, constraints) != null;
    }

    private final void createNodesForFenceStart(LookaheadText.Position pos, OpeningInfo openingInfo, ProductionHolder productionHolder) {
        String info = openingInfo.component2();
        int infoStartPosition = pos.getNextLineOrEofOffset() - info.length();
        productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(pos.getOffset(), infoStartPosition), MarkdownTokenTypes.CODE_FENCE_START)));
        if (((CharSequence)openingInfo.getInfo()).length() > 0) {
            productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(infoStartPosition, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.FENCE_LANG)));
        }
    }

    @Nullable
    protected OpeningInfo obtainFenceOpeningInfo(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default(REGEX, pos.getCurrentLineFromPosition(), 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        Intrinsics.checkNotNull(string);
        MatchGroup matchGroup2 = matchResult2.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        Intrinsics.checkNotNull(string2);
        return new OpeningInfo(string, string2);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider$OpeningInfo;", "", "delimiter", "", "info", "(Ljava/lang/String;Ljava/lang/String;)V", "getDelimiter", "()Ljava/lang/String;", "getInfo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "markdown"})
    protected static final class OpeningInfo {
        @NotNull
        private final String delimiter;
        @NotNull
        private final String info;

        public OpeningInfo(@NotNull String delimiter, @NotNull String info) {
            Intrinsics.checkNotNullParameter(delimiter, "delimiter");
            Intrinsics.checkNotNullParameter(info, "info");
            this.delimiter = delimiter;
            this.info = info;
        }

        @NotNull
        public final String getDelimiter() {
            return this.delimiter;
        }

        @NotNull
        public final String getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.delimiter;
        }

        @NotNull
        public final String component2() {
            return this.info;
        }

        @NotNull
        public final OpeningInfo copy(@NotNull String delimiter, @NotNull String info) {
            Intrinsics.checkNotNullParameter(delimiter, "delimiter");
            Intrinsics.checkNotNullParameter(info, "info");
            return new OpeningInfo(delimiter, info);
        }

        public static /* synthetic */ OpeningInfo copy$default(OpeningInfo openingInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = openingInfo.delimiter;
            }
            if ((n & 2) != 0) {
                string2 = openingInfo.info;
            }
            return openingInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "OpeningInfo(delimiter=" + this.delimiter + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.delimiter.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpeningInfo)) {
                return false;
            }
            OpeningInfo openingInfo = (OpeningInfo)other;
            if (!Intrinsics.areEqual(this.delimiter, openingInfo.delimiter)) {
                return false;
            }
            return Intrinsics.areEqual(this.info, openingInfo.info);
        }
    }
}

