/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.impl.LocationAwareLogEventFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringMap;

public class ReusableLogEventFactory
implements LogEventFactory,
LocationAwareLogEventFactory {
    private static final ThreadNameCachingStrategy THREAD_NAME_CACHING_STRATEGY = ThreadNameCachingStrategy.create();
    private static final Clock CLOCK = ClockFactory.getClock();
    private static ThreadLocal<MutableLogEvent> mutableLogEventThreadLocal = new ThreadLocal();
    private final ContextDataInjector injector = ContextDataInjectorFactory.createInjector();

    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message message, List<Property> properties2, Throwable t) {
        return this.createEvent(loggerName, marker, fqcn, null, level, message, properties2, t);
    }

    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, StackTraceElement location, Level level, Message message, List<Property> properties2, Throwable t) {
        MutableLogEvent result2 = mutableLogEventThreadLocal.get();
        if (result2 == null || result2.reserved) {
            boolean initThreadLocal = result2 == null;
            result2 = new MutableLogEvent();
            result2.setThreadId(Thread.currentThread().getId());
            result2.setThreadName(Thread.currentThread().getName());
            result2.setThreadPriority(Thread.currentThread().getPriority());
            if (initThreadLocal) {
                mutableLogEventThreadLocal.set(result2);
            }
        }
        result2.reserved = true;
        result2.clear();
        result2.setLoggerName(loggerName);
        result2.setMarker(marker);
        result2.setLoggerFqcn(fqcn);
        result2.setLevel(level == null ? Level.OFF : level);
        result2.setMessage(message);
        result2.initTime(CLOCK, Log4jLogEvent.getNanoClock());
        result2.setThrown(t);
        result2.setSource(location);
        result2.setContextData(this.injector.injectContextData(properties2, (StringMap)result2.getContextData()));
        result2.setContextStack(ThreadContext.getDepth() == 0 ? ThreadContext.EMPTY_STACK : ThreadContext.cloneStack());
        if (THREAD_NAME_CACHING_STRATEGY == ThreadNameCachingStrategy.UNCACHED) {
            result2.setThreadName(Thread.currentThread().getName());
            result2.setThreadPriority(Thread.currentThread().getPriority());
        }
        return result2;
    }

    public static void release(LogEvent logEvent) {
        if (logEvent instanceof MutableLogEvent) {
            MutableLogEvent mutableLogEvent = (MutableLogEvent)logEvent;
            mutableLogEvent.clear();
            mutableLogEvent.reserved = false;
        }
    }
}

