/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.texplate.exceptions.InvalidTemplateException;
import org.islandoftex.texplate.model.Configuration;
import org.islandoftex.texplate.model.Template;
import org.islandoftex.texplate.util.MergingUtils;
import org.islandoftex.texplate.util.MessageUtils;
import org.islandoftex.texplate.util.PathUtils;
import org.islandoftex.texplate.util.ValidatorUtils;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(usageHelpWidth=70, name="texplate")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u0002H\u000e2\u0006\u0010\u0010\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/islandoftex/texplate/TemplateProcessing;", "Ljava/util/concurrent/Callable;", "", "()V", "configuration", "Ljava/nio/file/Path;", "map", "", "", "output", "template", "call", "()Ljava/lang/Integer;", "ensure", "T", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "ensureMap", "", "getSize", "bytes", "", "has", "", "obj", "", "texplate"})
public final class TemplateProcessing
implements Callable<Integer> {
    @CommandLine.Option(names={"-o", "--output"}, description={"The output file in which the chosen template will be effectively written. Make sure the directory has the correct permissions for writing the output file."}, required=true, type={Path.class})
    private final Path output;
    @CommandLine.Option(names={"-t", "--template"}, description={"The name of the template. The tool will search both user and system locations and set the template model accordingly, based on your specs."})
    private String template;
    @CommandLine.Option(names={"-m", "--map"}, description={"The contextual map that provides the data to be merged in the template. This parameter can be used multiple times. You can specify a map entry with the key=value syntax (mind the entry separator)."}, arity="1..*")
    private Map<String, String> map;
    @CommandLine.Option(names={"-c", "--config"}, description={"The configuration file in which the tool can read template data, for automation purposes. Make sure to follow the correct specification when writing a configuration file."}, type={Path.class})
    private final Path configuration;

    @Override
    @NotNull
    public Integer call() throws Exception {
        boolean bl;
        int exit = 0;
        boolean halt = false;
        boolean bl2 = false;
        Map<String, Object> cmap = new LinkedHashMap();
        this.ensureMap();
        if (this.has(this.configuration)) {
            MessageUtils.line("Checking configuration");
            try {
                Path path = this.configuration;
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                Configuration config = Configuration.Companion.fromPath(path);
                MessageUtils.status(true);
                if (this.has(config.getTemplate())) {
                    this.template = this.ensure(this.template, config.getTemplate());
                }
                if (this.has(config.getMap())) {
                    cmap = config.getMap();
                }
                MessageUtils.line("Adjusting variables from file");
                MessageUtils.status(true);
                bl = false;
                System.out.println();
            }
            catch (InvalidTemplateException e22) {
                MessageUtils.status(false);
                MessageUtils.error(e22);
                exit = -1;
                halt = true;
            }
        } else {
            MessageUtils.line("Configuration file mode disabled");
            MessageUtils.status(true);
            MessageUtils.line("Entering full command line mode");
            if (!this.has(this.template)) {
                MessageUtils.status(false);
                MessageUtils.error(new Exception("The template was not set in the command line through the -t/--template option. If not explicitly specified in a configuration file, this option becomes mandatory, so make sure to define it  either in the command line or in a proper configuration file."));
                exit = -1;
                halt = true;
            } else {
                MessageUtils.status(true);
                boolean e22 = false;
                System.out.println();
            }
        }
        if (!halt) {
            String e22 = "Please, wait...";
            bl = false;
            System.out.println((Object)e22);
            boolean e22 = false;
            System.out.println();
            MessageUtils.line("Obtaining reference");
            try {
                String string = this.template;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Path file = PathUtils.getTemplatePath(string);
                MessageUtils.status(true);
                MessageUtils.line("Composing template");
                Template template = Template.Companion.fromPath(file);
                MessageUtils.status(true);
                MessageUtils.line("Validating data");
                Map<String, String> map = this.map;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                Map<String, String> validatedData = ValidatorUtils.validate(template, map);
                MessageUtils.status(true);
                MessageUtils.line("Merging template and data");
                Path path = this.output;
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                long merged = MergingUtils.mergeTemplate(template, validatedData, path, cmap);
                MessageUtils.status(true);
                boolean bl3 = false;
                System.out.println();
                String string2 = "Done! Enjoy your template!";
                boolean bl4 = false;
                System.out.println((Object)string2);
                string2 = "Written: " + this.getSize(merged);
                bl4 = false;
                System.out.println((Object)string2);
            }
            catch (InvalidTemplateException e) {
                MessageUtils.status(false);
                MessageUtils.error(e);
                exit = -1;
            }
        }
        return exit;
    }

    private final void ensureMap() {
        if (!this.has(this.map)) {
            Map map;
            TemplateProcessing templateProcessing = this;
            boolean bl = false;
            templateProcessing.map = map = (Map)new LinkedHashMap();
        }
    }

    private final String getSize(long bytes) {
        String string;
        if (bytes < (long)1024) {
            string = bytes + " B";
        } else {
            Object[] objectArray;
            double d = bytes;
            boolean bl = false;
            double d2 = Math.log(d);
            d = 1024.0;
            double d3 = d2;
            bl = false;
            double d4 = Math.log(d);
            int exponent = (int)(d3 / d4);
            String string2 = "%.1f %cB";
            double d5 = 1024.0;
            double d6 = exponent;
            double d7 = bytes;
            int n = 0;
            Object[] objectArray2 = objectArray = new Object[2];
            boolean bl2 = false;
            double d8 = Math.pow(d5, d6);
            objectArray[n] = d7 / d8;
            objectArray2[1] = Character.valueOf("KMGTPE".charAt(exponent - 1));
            Object[] objectArray3 = objectArray2;
            bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray3, objectArray3.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        }
        return string;
    }

    private final <T> T ensure(T first, T second) {
        return !this.has(first) ? second : first;
    }

    private final boolean has(Object obj) {
        return obj != null;
    }
}

