/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.adapters;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.reflections.ReflectionUtils;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

public class JavaReflectionAdapter
implements MetadataAdapter<Class, Field, Member> {
    @Override
    public List<Field> getFields(Class cls) {
        return Lists.newArrayList(cls.getDeclaredFields());
    }

    @Override
    public List<Member> getMethods(Class cls) {
        ArrayList<Member> methods2 = Lists.newArrayList();
        methods2.addAll(Arrays.asList(cls.getDeclaredMethods()));
        methods2.addAll(Arrays.asList(cls.getDeclaredConstructors()));
        return methods2;
    }

    @Override
    public String getMethodName(Member method) {
        return method instanceof Method ? method.getName() : (method instanceof Constructor ? "<init>" : null);
    }

    @Override
    public List<String> getParameterNames(Member member) {
        Class<?>[] parameterTypes;
        ArrayList<String> result2 = Lists.newArrayList();
        Object object = member instanceof Method ? ((Method)member).getParameterTypes() : (parameterTypes = member instanceof Constructor ? ((Constructor)member).getParameterTypes() : null);
        if (parameterTypes != null) {
            for (Class<?> paramType : parameterTypes) {
                String name = JavaReflectionAdapter.getName(paramType);
                result2.add(name);
            }
        }
        return result2;
    }

    @Override
    public List<String> getClassAnnotationNames(Class aClass) {
        return this.getAnnotationNames(aClass.getDeclaredAnnotations());
    }

    @Override
    public List<String> getFieldAnnotationNames(Field field) {
        return this.getAnnotationNames(field.getDeclaredAnnotations());
    }

    @Override
    public List<String> getMethodAnnotationNames(Member method) {
        Annotation[] annotations2 = method instanceof Method ? ((Method)method).getDeclaredAnnotations() : (method instanceof Constructor ? ((Constructor)method).getDeclaredAnnotations() : null);
        return this.getAnnotationNames(annotations2);
    }

    @Override
    public List<String> getParameterAnnotationNames(Member method, int parameterIndex) {
        Annotation[][] annotations2 = method instanceof Method ? ((Method)method).getParameterAnnotations() : (method instanceof Constructor ? ((Constructor)method).getParameterAnnotations() : (Annotation[][])null);
        return this.getAnnotationNames(annotations2 != null ? annotations2[parameterIndex] : null);
    }

    @Override
    public String getReturnTypeName(Member method) {
        return ((Method)method).getReturnType().getName();
    }

    @Override
    public String getFieldName(Field field) {
        return field.getName();
    }

    @Override
    public Class getOfCreateClassObject(Vfs.File file2) throws Exception {
        return this.getOfCreateClassObject(file2, null);
    }

    public Class getOfCreateClassObject(Vfs.File file2, ClassLoader ... loaders) throws Exception {
        String name = file2.getRelativePath().replace("/", ".").replace(".class", "");
        return ReflectionUtils.forName(name, loaders);
    }

    @Override
    public String getMethodModifier(Member method) {
        return Modifier.toString(method.getModifiers());
    }

    @Override
    public String getMethodKey(Class cls, Member method) {
        return this.getMethodName(method) + "(" + Joiner.on(", ").join(this.getParameterNames(method)) + ")";
    }

    @Override
    public String getMethodFullKey(Class cls, Member method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    @Override
    public boolean isPublic(Object o) {
        Integer mod = o instanceof Class ? ((Class)o).getModifiers() : (o instanceof Member ? Integer.valueOf(((Member)o).getModifiers()) : null).intValue();
        return mod != null && Modifier.isPublic(mod);
    }

    @Override
    public String getClassName(Class cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(Class cls) {
        Class superclass = cls.getSuperclass();
        return superclass != null ? superclass.getName() : "";
    }

    @Override
    public List<String> getInterfacesNames(Class cls) {
        Class<?>[] classes2 = cls.getInterfaces();
        ArrayList<String> names = new ArrayList<String>(classes2 != null ? classes2.length : 0);
        if (classes2 != null) {
            for (Class<?> cls1 : classes2) {
                names.add(cls1.getName());
            }
        }
        return names;
    }

    @Override
    public boolean acceptsInput(String file2) {
        return file2.endsWith(".class");
    }

    private List<String> getAnnotationNames(Annotation[] annotations2) {
        ArrayList<String> names = new ArrayList<String>(annotations2.length);
        for (Annotation annotation : annotations2) {
            names.add(annotation.annotationType().getName());
        }
        return names;
    }

    public static String getName(Class type2) {
        if (type2.isArray()) {
            try {
                Class<?> cl = type2;
                int dim = 0;
                while (cl.isArray()) {
                    ++dim;
                    cl = cl.getComponentType();
                }
                return cl.getName() + Utils.repeat("[]", dim);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type2.getName();
    }
}

