/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Array;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class ArrayAccessorNest
implements AccessorNode {
    private AccessorNode nextNode;
    private ExecutableStatement index;
    private Class baseComponentType;
    private boolean requireConversion;

    public ArrayAccessorNest() {
    }

    public ArrayAccessorNest(String index) {
        this.index = (ExecutableStatement)ParseTools.subCompileExpression(index.toCharArray());
    }

    public ArrayAccessorNest(ExecutableStatement stmt) {
        this.index = stmt;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)], elCtx, vars);
        }
        return ((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)];
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value2) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)], elCtx, vars, value2);
        }
        if (this.baseComponentType == null) {
            this.baseComponentType = ParseTools.getBaseComponentType(ctx.getClass());
            boolean bl = this.requireConversion = this.baseComponentType != value2.getClass() && !this.baseComponentType.isAssignableFrom(value2.getClass());
        }
        if (this.requireConversion) {
            Object o = DataConversion.convert(value2, this.baseComponentType);
            Array.set(ctx, (Integer)this.index.getValue(ctx, elCtx, vars), o);
            return o;
        }
        Array.set(ctx, (Integer)this.index.getValue(ctx, elCtx, vars), value2);
        return value2;
    }

    public ExecutableStatement getIndex() {
        return this.index;
    }

    public void setIndex(ExecutableStatement index) {
        this.index = index;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Class getKnownEgressType() {
        return this.baseComponentType;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }
}

