/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.ruleset;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Conditional;
import org.islandoftex.arara.ruleset.Directive;
import org.islandoftex.arara.ruleset.DirectiveAssembler;
import org.islandoftex.arara.ruleset.DirectiveUtils;
import org.islandoftex.arara.utils.DisplayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000fH\u0002J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\r0\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010 \u001a\u00020\u00012\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\"\u001a\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/islandoftex/arara/ruleset/DirectiveUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "checkLinePattern", "", "pattern", "Ljava/util/regex/Pattern;", "line", "", "extractDirectives", "", "Lorg/islandoftex/arara/ruleset/Directive;", "lines", "generateDirective", "assembler", "Lorg/islandoftex/arara/ruleset/DirectiveAssembler;", "getParameters", "", "text", "numbers", "", "getPotentialDirectiveLines", "getType", "Lorg/islandoftex/arara/ruleset/Conditional$ConditionalType;", "process", "directives", "replicateDirective", "holder", "parameters", "directive", "application"})
public final class DirectiveUtils {
    private static final LanguageController messages;
    private static final Logger logger;
    public static final DirectiveUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, String> getPotentialDirectiveLines(List<String> lines) {
        String validLineRegex;
        boolean header = (Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getOnlyHeader());
        String string = validLineRegex = (String)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFilePattern());
        int n = 0;
        int n2 = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull(pattern, "java.util.regex.Pattern.compile(this, flags)");
        Pattern validLinePattern = pattern;
        String string2 = validLineRegex + (String)Arara.INSTANCE.getConfig().get(AraraSpec.Application.INSTANCE.getNamePattern());
        n2 = 0;
        boolean bl = false;
        Pattern pattern2 = Pattern.compile(string2, n2);
        Intrinsics.checkExpressionValueIsNotNull(pattern2, "java.util.regex.Pattern.compile(this, flags)");
        Pattern validLineStartPattern = pattern2;
        n2 = 0;
        Map map2 = new LinkedHashMap();
        n2 = 0;
        for (String text2 : (Iterable)lines) {
            void i;
            Matcher validLineMatcher = validLineStartPattern.matcher(text2);
            if (validLineMatcher.find()) {
                String line;
                String string3 = text2;
                int n3 = validLineMatcher.end();
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull(string4.substring(n3), "(this as java.lang.String).substring(startIndex)");
                map2.put((int)(i + true), line);
                Object[] objectArray = new Object[2];
                objectArray[0] = (int)(i + true);
                string3 = line;
                int n4 = 1;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                Enum enum_ = Messages.LOG_INFO_POTENTIAL_PATTERN_FOUND;
                LanguageController languageController = messages;
                Logger logger = DirectiveUtils.logger;
                n3 = 0;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                objectArray2[n4] = string6;
                logger.info(languageController.getMessage(enum_, objectArray3));
            } else if (header && !this.checkLinePattern(validLinePattern, text2)) break;
            ++i;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Directive> extractDirectives(@NotNull List<String> lines) throws AraraException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, "lines");
        Map<Integer, String> map2 = this.getPotentialDirectiveLines(lines);
        boolean bl = false;
        boolean bl2 = false;
        Map.Entry<Integer, String> it = map2;
        int $i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22 = 0;
        Map<Integer, String> map3 = it;
        boolean bl3 = false;
        Map<Integer, String> map4 = !map3.isEmpty() ? map2 : null;
        if (map4 == null) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_NO_DIRECTIVES_FOUND));
        }
        Map<Integer, String> pairs = map4;
        bl = false;
        List assemblers = new ArrayList();
        DirectiveAssembler assembler = new DirectiveAssembler();
        it = (String)Arara.INSTANCE.getConfig().get(AraraSpec.Directive.INSTANCE.getLinebreakPattern());
        $i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22 = 0;
        boolean bl4 = false;
        Pattern pattern = Pattern.compile((String)((Object)it), $i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22);
        Intrinsics.checkExpressionValueIsNotNull(pattern, "java.util.regex.Pattern.compile(this, flags)");
        Pattern linebreakPattern = pattern;
        Map<Integer, String> map5 = pairs;
        bl3 = false;
        Iterator<Map.Entry<Integer, String>> $i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22 = map5.entrySet().iterator();
        while ($i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22.hasNext()) {
            void lineno;
            Map.Entry<Integer, String> entry = it = $i$a$-takeIf-DirectiveUtils$extractDirectives$pairs$22.next();
            boolean bl5 = false;
            int n = ((Number)entry.getKey()).intValue();
            entry = it;
            bl5 = false;
            String content = entry.getValue();
            Matcher linebreakMatcher = linebreakPattern.matcher(content);
            if (linebreakMatcher.find()) {
                if (!assembler.isAppendAllowed()) {
                    throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_ORPHAN_LINEBREAK, (int)lineno));
                }
                assembler.addLineNumber((int)lineno);
                String string = linebreakMatcher.group(1);
                Intrinsics.checkExpressionValueIsNotNull(string, "linebreakMatcher.group(1)");
                assembler.appendLine(string);
                continue;
            }
            if (assembler.isAppendAllowed()) {
                assemblers.add(assembler);
            }
            assembler = new DirectiveAssembler();
            assembler.addLineNumber((int)lineno);
            assembler.appendLine(content);
        }
        if (assembler.isAppendAllowed()) {
            assemblers.add(assembler);
        }
        Iterable $this$map$iv = assemblers;
        boolean $i$f$map = false;
        Iterable lineno = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DirectiveAssembler directiveAssembler = (DirectiveAssembler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            Directive directive = INSTANCE.generateDirective((DirectiveAssembler)it2);
            collection.add(directive);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Directive generateDirective(@NotNull DirectiveAssembler assembler) throws AraraException {
        Intrinsics.checkParameterIsNotNull(assembler, "assembler");
        String string = (String)Arara.INSTANCE.getConfig().get(AraraSpec.Directive.INSTANCE.getDirectivePattern());
        int n = 0;
        boolean bl = false;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull(pattern, "java.util.regex.Pattern.compile(this, flags)");
        Matcher matcher = pattern.matcher(assembler.getText());
        if (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Map<String, Object> map2 = this.getParameters(matcher.group(3), assembler.getLineNumbers());
            Conditional.ConditionalType conditionalType = this.getType(matcher.group(5));
            String string3 = matcher.group(6);
            if (string3 == null) {
                string3 = "";
            }
            Directive directive = new Directive(string2, map2, new Conditional(conditionalType, string3), assembler.getLineNumbers());
            logger.info(messages.getMessage((Enum)Messages.LOG_INFO_POTENTIAL_DIRECTIVE_FOUND, directive));
            return directive;
        }
        throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT, "(" + CollectionsKt.joinToString$default(assembler.getLineNumbers(), ", ", null, null, 0, null, null, 62, null) + ")"));
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final Conditional.ConditionalType getType(String text2) {
        Conditional.ConditionalType conditionalType;
        String string = text2;
        if (string == null) {
            conditionalType = Conditional.ConditionalType.NONE;
            return conditionalType;
        }
        switch (string) {
            case "if": {
                conditionalType = Conditional.ConditionalType.IF;
                return conditionalType;
            }
            case "while": {
                conditionalType = Conditional.ConditionalType.WHILE;
                return conditionalType;
            }
            case "until": {
                conditionalType = Conditional.ConditionalType.UNTIL;
                return conditionalType;
            }
        }
        conditionalType = Conditional.ConditionalType.UNLESS;
        return conditionalType;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getParameters(String text2, List<Integer> numbers) throws AraraException {
        Object object;
        if (text2 == null) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        Object object2 = ExtensionsKt.registerKotlinModule(new ObjectMapper(new YAMLFactory()));
        boolean bl = false;
        try {
            void $this$readValue$iv;
            object = Result.Companion;
            Object $this$runCatching = object2;
            boolean bl2 = false;
            ObjectMapper objectMapper = $this$runCatching;
            String content$iv = text2;
            boolean $i$f$readValue = false;
            String string = content$iv;
            void var12_19 = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = new TypeReference<Map<String, ? extends Object>>(){};
            $this$runCatching = (Map)var12_19.readValue(string, typeReference);
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_YAML_EXCEPTION, "(" + CollectionsKt.joinToString$default(numbers, ", ", null, null, 0, null, null, 62, null) + ")"), it);
        }
        return (Map)object2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Directive> replicateDirective(Object holder, Map<String, ? extends Object> parameters2, Directive directive) throws AraraException {
        List<Directive> list2;
        if (holder instanceof List) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)holder;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Object)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Directive> list3 = SequencesKt.toList(SequencesKt.map(SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((List)destination$iv$iv), replicateDirective.1.INSTANCE), (Function1)new Function1<File, File>(FileHandlingUtils.INSTANCE){

                @NotNull
                public final File invoke(@NotNull File p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return ((FileHandlingUtils)this.receiver).getCanonicalFile(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(FileHandlingUtils.class);
                }

                public final String getName() {
                    return "getCanonicalFile";
                }

                public final String getSignature() {
                    return "getCanonicalFile(Ljava/io/File;)Ljava/io/File;";
                }
            }), (Function1)new Function1<File, Directive>(directive, parameters2){
                final /* synthetic */ Directive $directive;
                final /* synthetic */ Map $parameters;

                @NotNull
                public final Directive invoke(@NotNull File reference) {
                    Intrinsics.checkParameterIsNotNull(reference, "reference");
                    return Directive.copy$default(this.$directive, null, MapsKt.plus(this.$parameters, TuplesKt.to("reference", reference)), null, null, 13, null);
                }
                {
                    this.$directive = directive;
                    this.$parameters = map2;
                    super(1);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            List<Directive> it = list3;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            list2 = !collection.isEmpty() && ((List)holder).size() == it.size() ? list3 : null;
            if (list2 == null) {
                throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_EMPTY_FILES_LIST, "(" + CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", null, null, 0, null, null, 62, null) + ")"));
            }
        } else {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_FILES_IS_NOT_A_LIST, "(" + CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", null, null, 0, null, null, 62, null) + ")"));
        }
        return list2;
    }

    @NotNull
    public final List<Directive> process(@NotNull List<Directive> directives) throws AraraException {
        Intrinsics.checkParameterIsNotNull(directives, "directives");
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = directives;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Directive directive = (Directive)element$iv;
            boolean bl2 = false;
            Map<String, Object> parameters2 = directive.getParameters();
            if (parameters2.containsKey("reference")) {
                throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_VALIDATE_REFERENCE_IS_RESERVED, "(" + CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", null, null, 0, null, null, 62, null) + ")"));
            }
            if (parameters2.containsKey("files")) {
                result2.addAll((Collection)INSTANCE.replicateDirective(MapsKt.getValue(parameters2, "files"), MapsKt.minus(parameters2, "files"), directive));
                continue;
            }
            result2.add(Directive.copy$default(directive, null, MapsKt.plus(parameters2, TuplesKt.to("reference", Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference()))), null, null, 13, null));
        }
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_VALIDATED_DIRECTIVES));
        logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(messages.getMessage((Enum)Messages.LOG_INFO_DIRECTIVES_BLOCK)));
        $this$forEach$iv = result2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Directive it = (Directive)element$iv;
            boolean bl3 = false;
            logger.info(it.toString());
        }
        logger.info(DisplayUtils.INSTANCE.displaySeparator());
        return result2;
    }

    private final boolean checkLinePattern(Pattern pattern, String line) {
        return StringsKt.isBlank(line) || pattern.matcher(line).find();
    }

    private DirectiveUtils() {
    }

    static {
        DirectiveUtils directiveUtils;
        INSTANCE = directiveUtils = new DirectiveUtils();
        messages = LanguageController.INSTANCE;
        logger = LoggerFactory.getLogger(DirectiveUtils.class);
    }
}

