/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.model;

import com.uchuhimo.konf.Config;
import com.uchuhimo.konf.Item;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.model.Evaluator;
import org.islandoftex.arara.model.Session;
import org.islandoftex.arara.ruleset.Argument;
import org.islandoftex.arara.ruleset.Command;
import org.islandoftex.arara.ruleset.Conditional;
import org.islandoftex.arara.ruleset.Directive;
import org.islandoftex.arara.ruleset.Rule;
import org.islandoftex.arara.ruleset.RuleCommand;
import org.islandoftex.arara.ruleset.RuleUtils;
import org.islandoftex.arara.utils.CommonUtils;
import org.islandoftex.arara.utils.DisplayUtils;
import org.islandoftex.arara.utils.InterpreterUtils;
import org.islandoftex.arara.utils.Methods;
import org.jetbrains.annotations.NotNull;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0007J4\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012H\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J,\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0001H\u0002J&\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\b\u0010%\u001a\u0004\u0018\u00010\u0013H\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lorg/islandoftex/arara/model/Interpreter;", "", "directives", "", "Lorg/islandoftex/arara/ruleset/Directive;", "(Ljava/util/List;)V", "getDirectives", "()Ljava/util/List;", "execute", "", "executeCommand", "command", "Lorg/islandoftex/arara/ruleset/RuleCommand;", "conditional", "Lorg/islandoftex/arara/ruleset/Conditional;", "rule", "Lorg/islandoftex/arara/ruleset/Rule;", "parameters", "", "", "getRule", "Ljava/io/File;", "directive", "parseArguments", "processArgument", "argument", "Lorg/islandoftex/arara/ruleset/Argument;", "idInDirectiveParams", "", "context", "resultToList", "result", "runBoolean", "value", "authors", "runCommand", "Lorg/islandoftex/arara/ruleset/Command;", "ruleCommandExitValue", "Companion", "HaltExpectedException", "application"})
public final class Interpreter {
    @NotNull
    private final List<Directive> directives;
    private static final LanguageController messages;
    private static final Logger logger;
    public static final Companion Companion;

    private final File getRule(Directive directive) throws AraraException {
        File file2 = InterpreterUtils.INSTANCE.buildRulePath(directive.getIdentifier());
        if (file2 == null) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_INTERPRETER_RULE_NOT_FOUND, directive.getIdentifier(), "(" + CollectionsKt.joinToString$default(CommonUtils.INSTANCE.getAllRulePaths(), "; ", null, null, 0, null, null, 62, null) + ")"));
        }
        return file2;
    }

    private final boolean runBoolean(boolean value2, Conditional conditional, List<String> authors) {
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_BOOLEAN_MODE, String.valueOf(value2)));
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getDryrun())).booleanValue()) {
            DisplayUtils.INSTANCE.printAuthors(authors);
            DisplayUtils.INSTANCE.wrapText(messages.getMessage((Enum)Messages.INFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE, value2));
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return value2;
    }

    @ExperimentalTime
    private final boolean runCommand(Command command, Conditional conditional, List<String> authors, String ruleCommandExitValue) throws AraraException {
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_SYSTEM_COMMAND, command));
        boolean success = true;
        if (!((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getDryrun())).booleanValue()) {
            Object object;
            int code = InterpreterUtils.INSTANCE.run(command);
            try {
                Map<String, Integer> context = MapsKt.mapOf(TuplesKt.to("value", code));
                StringBuilder stringBuilder = new StringBuilder().append("@{ ");
                String string = ruleCommandExitValue;
                if (string == null) {
                    string = "value == 0";
                }
                Object object2 = TemplateRuntime.eval(stringBuilder.append((Object)string).append(" }").toString(), context);
                Intrinsics.checkExpressionValueIsNotNull(object2, "TemplateRuntime.eval(\n  \u2026                 context)");
                object = object2;
            }
            catch (RuntimeException exception) {
                throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_EXIT_RUNTIME_ERROR), exception);
            }
            Object check = object;
            if (!(check instanceof Boolean)) {
                throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN));
            }
            success = (Boolean)check;
        } else {
            DisplayUtils.INSTANCE.printAuthors(authors);
            DisplayUtils.INSTANCE.wrapText(messages.getMessage((Enum)Messages.INFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND, command));
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return success;
    }

    private final List<Object> resultToList(Object result2) {
        return result2 instanceof List ? CommonUtils.INSTANCE.flatten((List)result2) : CollectionsKt.listOf(result2);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    private final void executeCommand(RuleCommand command, Conditional conditional, Rule rule, Map<String, ? extends Object> parameters2) throws AraraException {
        Object element$iv$iv;
        void $this$filterTo$iv$iv;
        Object object;
        try {
            String string = command.getCommand();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = TemplateRuntime.eval(string, parameters2);
            Intrinsics.checkExpressionValueIsNotNull(object2, "TemplateRuntime.eval(com\u2026nd.command!!, parameters)");
            object = object2;
        }
        catch (RuntimeException exception) {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_COMMAND_RUNTIME_ERROR), exception);
        }
        Object result2 = object;
        Iterable $this$filter$iv = this.resultToList(result2);
        boolean $i$f$filter = false;
        Object object3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            CharSequence charSequence = it.toString();
            boolean bl2 = false;
            if (!(!StringsKt.isBlank(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object3 = $this$forEach$iv.iterator();
        while (object3.hasNext()) {
            boolean bl;
            String string;
            boolean bl3;
            Object element$iv;
            Object current = element$iv = object3.next();
            boolean bl4 = false;
            String string2 = rule.getName();
            String string3 = command.getName();
            if (string3 == null) {
                string3 = messages.getMessage((Enum)Messages.INFO_LABEL_UNNAMED_TASK);
            }
            DisplayUtils.INSTANCE.printEntry(string2, string3);
            element$iv$iv = current;
            if (element$iv$iv instanceof Boolean) {
                bl3 = this.runBoolean((Boolean)current, conditional, rule.getAuthors());
            } else if (element$iv$iv instanceof Command) {
                bl3 = this.runCommand((Command)current, conditional, rule.getAuthors(), command.getExit());
            } else {
                string = "error: this should not happenwe are only supporting boolean + command";
                bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            boolean success = bl3;
            DisplayUtils.INSTANCE.printEntryResult(success);
            if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getHaltOnErrors())).booleanValue() && !success) {
                throw (Throwable)new HaltExpectedException("Command failed");
            }
            String haltKey = "arara:" + ((File)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference())).getName() + ":halt";
            if (!Session.INSTANCE.contains(haltKey)) continue;
            string = Session.INSTANCE.get(haltKey).toString();
            Item item2 = AraraSpec.Execution.INSTANCE.getStatus();
            Config config = Arara.INSTANCE.getConfig();
            bl = false;
            int n = Integer.parseInt(string);
            config.set(item2, Integer.valueOf(n));
            throw (Throwable)new HaltExpectedException("User requested halt");
        }
    }

    @ExperimentalTime
    public final void execute() throws AraraException {
        for (Directive directive : this.directives) {
            logger.info(messages.getMessage((Enum)Messages.LOG_INFO_INTERPRET_RULE, directive.getIdentifier()));
            Object object = MapsKt.getValue(directive.getParameters(), "reference");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.io.File");
            }
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getFile(), (File)object);
            File file2 = this.getRule(directive);
            Enum enum_ = Messages.LOG_INFO_RULE_LOCATION;
            Object[] objectArray = new Object[1];
            String string = file2.getParent();
            Intrinsics.checkExpressionValueIsNotNull(string, "file.parent");
            objectArray[0] = string;
            logger.info(messages.getMessage(enum_, objectArray));
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.InfoSpec.INSTANCE.getRuleId(), directive.getIdentifier());
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.InfoSpec.INSTANCE.getRulePath(), file2.getParent());
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.DirectiveSpec.INSTANCE.getLines(), directive.getLineNumbers());
            Rule rule = RuleUtils.INSTANCE.parseRule(file2, directive.getIdentifier());
            Map<String, Object> map2 = this.parseArguments(rule, directive);
            Map<String, Object> map3 = Methods.getRuleMethods();
            Intrinsics.checkExpressionValueIsNotNull(map3, "Methods.getRuleMethods()");
            Map<String, Object> parameters2 = MapsKt.plus(map2, map3);
            Evaluator evaluator = new Evaluator();
            boolean available = true;
            if (InterpreterUtils.INSTANCE.runPriorEvaluation(directive.getConditional())) {
                available = evaluator.evaluate(directive.getConditional());
            }
            if (!available) continue;
            do {
                Iterable $this$forEach$iv = rule.getCommands();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RuleCommand command = (RuleCommand)element$iv;
                    boolean bl = false;
                    try {
                        this.executeCommand(command, directive.getConditional(), rule, parameters2);
                    }
                    catch (HaltExpectedException _) {
                        return;
                    }
                }
            } while (evaluator.evaluate(directive.getConditional()));
        }
    }

    private final Map<String, Object> parseArguments(Rule rule, Directive directive) throws AraraException {
        List<Argument> arguments2 = rule.getArguments();
        Set<String> unknown = SetsKt.minus(CommonUtils.INSTANCE.getUnknownKeys(directive.getParameters(), arguments2), "reference");
        Collection collection = unknown;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_UNKNOWN_KEYS, "(" + CollectionsKt.joinToString$default(unknown, ", ", null, null, 0, null, null, 62, null) + ")"));
        }
        bl = false;
        Map resolvedArguments = new LinkedHashMap();
        resolvedArguments.put("reference", MapsKt.getValue(directive.getParameters(), "reference"));
        Map map2 = MapsKt.mapOf(TuplesKt.to("parameters", directive.getParameters()), TuplesKt.to("reference", MapsKt.getValue(directive.getParameters(), "reference")));
        Map<String, Object> map3 = Methods.getRuleMethods();
        Intrinsics.checkExpressionValueIsNotNull(map3, "Methods.getRuleMethods()");
        Map<String, Object> context = MapsKt.plus(map2, map3);
        Iterable $this$forEach$iv = arguments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Argument argument2 = (Argument)element$iv;
            boolean bl2 = false;
            String string = argument2.getIdentifier();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Map<String, Object> map4 = directive.getParameters();
            String string2 = argument2.getIdentifier();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            resolvedArguments.put(string, this.processArgument(argument2, map4.containsKey(string2), context));
        }
        return resolvedArguments;
    }

    private final Object processArgument(Argument argument2, boolean idInDirectiveParams, Map<String, ? extends Object> context) throws AraraException {
        Object ret;
        Object object;
        block13: {
            Object object2;
            block12: {
                Object object3;
                if (argument2.isRequired() && !idInDirectiveParams) {
                    StringBuilder stringBuilder = new StringBuilder().append(CommonUtils.INSTANCE.getRuleErrorHeader());
                    Enum enum_ = Messages.ERROR_INTERPRETER_ARGUMENT_IS_REQUIRED;
                    Object[] objectArray = new Object[1];
                    String string = argument2.getIdentifier();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    objectArray[0] = string;
                    throw (Throwable)new AraraException(stringBuilder.append(messages.getMessage(enum_, objectArray)).toString());
                }
                object2 = argument2.getDefault();
                if (object2 == null) break block12;
                object = object2;
                boolean bl = false;
                boolean bl2 = false;
                String it = object;
                boolean bl3 = false;
                try {
                    object3 = TemplateRuntime.eval(it, context);
                }
                catch (RuntimeException exception) {
                    throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_DEFAULT_VALUE_RUNTIME_ERROR), exception);
                }
                Object object4 = object3;
                object2 = object4;
                if (object4 != null) break block13;
            }
            object2 = ret = "";
        }
        if (argument2.getFlag() != null && idInDirectiveParams) {
            try {
                String string = argument2.getFlag();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Object object5 = TemplateRuntime.eval(string, context);
                Intrinsics.checkExpressionValueIsNotNull(object5, "TemplateRuntime.eval(argument.flag!!, context)");
                object = object5;
            }
            catch (RuntimeException exception) {
                throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_INTERPRETER_FLAG_RUNTIME_EXCEPTION), exception);
            }
            ret = object;
        }
        return ret;
    }

    @NotNull
    public final List<Directive> getDirectives() {
        return this.directives;
    }

    public Interpreter(@NotNull List<Directive> directives) {
        Intrinsics.checkParameterIsNotNull(directives, "directives");
        this.directives = directives;
    }

    static {
        Companion = new Companion(null);
        messages = LanguageController.INSTANCE;
        logger = LoggerFactory.getLogger(Interpreter.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/islandoftex/arara/model/Interpreter$HaltExpectedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "application"})
    private static final class HaltExpectedException
    extends Exception {
        public HaltExpectedException(@NotNull String msg) {
            Intrinsics.checkParameterIsNotNull(msg, "msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/islandoftex/arara/model/Interpreter$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

