/***********************************************************************************
 *  Copyright 2013 by Akshay Ratan <akshayratan@gmail.com>                         *
 *                                                                                 *
 *                                                                                 *
 *   This library is free software; you can redistribute it and/or                 *
 *   modify it under the terms of the GNU Lesser General Public                    *
 *   License as published by the Free Software Foundation; either                  *
 *   version 2.1 of the License, or (at your option) any later version.            *
 *                                                                                 *
 *   This library is distributed in the hope that it will be useful,               *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
 *   Lesser General Public License for more details.                               *
 *                                                                                 *
 *   You should have received a copy of the GNU Lesser General Public              *
 *   License along with this library.  If not, see <http://www.gnu.org/licenses/>. *
 ***********************************************************************************/

#ifndef FILTERLOCALFILESMODEL_H
#define FILTERLOCALFILESMODEL_H

#include <QtGui/QSortFilterProxyModel>
#include <QAbstractItemModel>
#include <mediacenter/mediacenter.h>


class FilterLocalFilesModel: public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(QString filterString READ filterString WRITE setFilterString NOTIFY filterStringChanged)
    Q_PROPERTY(QObject* sourceLocalFilesModel READ sourceLocalFilesModel WRITE setSourceLocalFilesModel NOTIFY sourceLocalFilesModelChanged)
    
public:
    explicit FilterLocalFilesModel(QObject* parent = 0);
    void setFilterString(const QString &customString);
    QString filterString() const;
    QObject *sourceLocalFilesModel();
    void setSourceLocalFilesModel(QObject *model);
    
signals:
    void filterStringChanged();
    void sourceLocalFilesModelChanged();
    void currentIndexChanged();

//protected:
  //    bool setFilterFixedString ( const QString & pattern , int sourceRow, int sourceColumn , const QModelIndex & source_parent ) ;
      
private:
    QString m_searchString;
};

#endif //FILTERLOCALFILESMODEL_H
