/*
*  Copyright 2020  Michail Vourlakos <mvourlakos@gmail.com>
*
*  This file is part of Latte-Dock
*
*  Latte-Dock is free software; you can redistribute it and/or
*  modify it under the terms of the GNU General Public License as
*  published by the Free Software Foundation; either version 2 of
*  the License, or (at your option) any later version.
*
*  Latte-Dock is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef VIEWTASKSMODEL_H
#define VIEWTASKSMODEL_H

#include <QAbstractListModel>

namespace PlasmaQuick {
class AppletQuickItem;
}

namespace Latte {
namespace ViewPart {

class TasksModel : public QAbstractListModel
{
    Q_OBJECT
    Q_PROPERTY(int count READ count NOTIFY countChanged)

public:
    TasksModel(QObject *parent = nullptr);

    int count() const;

    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const override;
    QHash<int, QByteArray> roleNames() const override;

   void addTask(PlasmaQuick::AppletQuickItem *plasmoid);
   void removeTask(PlasmaQuick::AppletQuickItem *plasmoid);

signals:
   void countChanged();

private slots:
   void moveIntoWaitingTasks(PlasmaQuick::AppletQuickItem *plasmoid);
   void restoreFromWaitingTasks(PlasmaQuick::AppletQuickItem *plasmoid);

private:
    QList<PlasmaQuick::AppletQuickItem *> m_tasks;
    QList<PlasmaQuick::AppletQuickItem *> m_tasksWaiting;
};

}
}

#endif
