/*
    Copyright (c) 2010 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
    Copyright (c) 2010 Andras Mantia <andras@kdab.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


#ifndef MAILCOMMON_FILTERMODEL_H
#define MAILCOMMON_FILTERMODEL_H

#include <QtCore/QModelIndex>

namespace MailCommon {

class FilterModel : public QAbstractListModel
{
  Q_OBJECT

  public:
    explicit FilterModel( QObject *parent = 0 );
    virtual QVariant data( const QModelIndex &index, int role = Qt::DisplayRole ) const;
    virtual int rowCount( const QModelIndex &parent = QModelIndex() ) const;

    void moveRow( int sourceRow, int destinationRow );

  protected:
    virtual bool insertRows( int row, int count, const QModelIndex &parent = QModelIndex() );
    virtual bool removeRows( int row, int count, const QModelIndex &parent = QModelIndex() );

  private Q_SLOTS:
    void filterListUpdated();
};

}

#endif
