/* This file is part of the KDE project
 * Copyright (C) 2008 Thomas Zander <zander@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Words.h"
#include "frames/KWTextFrameSet.h"

#include <klocalizedstring.h>

namespace Words
{

bool isAutoGenerated(KWFrameSet *fs)
{
    Q_ASSERT(fs);
    if (fs->type() == BackgroundFrameSet)
        return true;
    if (fs->type() == TextFrameSet) {
        KWTextFrameSet *tfs = static_cast<KWTextFrameSet*>(fs);
        return tfs
            && (tfs->textFrameSetType() == Words::OddPagesHeaderTextFrameSet
                    || tfs->textFrameSetType() == Words::EvenPagesHeaderTextFrameSet
                    || tfs->textFrameSetType() == Words::OddPagesFooterTextFrameSet
                    || tfs->textFrameSetType() == Words::EvenPagesFooterTextFrameSet
                    || tfs->textFrameSetType() == Words::MainTextFrameSet);
    }
    return false;
}

bool isHeaderFooter(KWTextFrameSet *tfs)
{
    return tfs
        && (tfs->textFrameSetType() == Words::OddPagesHeaderTextFrameSet
                || tfs->textFrameSetType() == Words::EvenPagesHeaderTextFrameSet
                || tfs->textFrameSetType() == Words::OddPagesFooterTextFrameSet
                || tfs->textFrameSetType() == Words::EvenPagesFooterTextFrameSet);
}

QString frameSetTypeName(TextFrameSetType type)
{
    switch (type) {
        case Words::OddPagesHeaderTextFrameSet:
            return i18n("Odd Pages Header");
        case Words::EvenPagesHeaderTextFrameSet:
            return i18n("Even Pages Header");
        case Words::OddPagesFooterTextFrameSet:
            return i18n("Odd Pages Footer");
        case Words::EvenPagesFooterTextFrameSet:
            return i18n("Even Pages Footer");
        case Words::MainTextFrameSet:
            return i18n("Main text");
        case Words::OtherTextFrameSet:
            return i18n("Other text");
    }
    return QString();
}

QString frameSetTypeName(KWFrameSet* frameset)
{
    if (KWTextFrameSet* tfs = dynamic_cast<KWTextFrameSet*>(frameset))
        return frameSetTypeName(tfs->textFrameSetType());
    return QString();
}

}
