/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for SKGTableWithGraph component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtesttablewithgraph.h"
#include "skgtablewithgraph.h"
#include "skgtestmacro.h"

void SKGTESTTableWithGraph::Test()
{
    SKGTableWithGraph graph;

    SKGStringListList data;

    data.append(QStringList() << "Category" << "2013-01" << "2013-02" << "2013-03" << "2013-04" << "2013-05" << "2013-06");
    data.append(QStringList() << "Auto" << "-50" << "-40.5" << "-40" << "-60" << "-70" << "-100");
    data.append(QStringList() << "Food" << "-510.0" << "-520" << "-530.55" << "" << "-535" << "-520");
    data.append(QStringList() << "s1" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s2" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s3" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s4" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s5" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s6" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s7" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s8" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s9" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s10" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s11" << "1" << "2" << "3" << "" << "4" << "5");
    data.append(QStringList() << "s12" << "1" << "2" << "3" << "" << "4" << "5");

    SKGServices::SKGUnitInfo info1;
    info1.Symbol = 'P';
    info1.Name = 'P';
    info1.Date = QDate::currentDate();
    info1.NbDecimal = 2;
    info1.Value = 1;

    SKGServices::SKGUnitInfo info2;
    info2.Symbol = 'S';
    info2.Name = 'S';
    info2.Date = QDate::currentDate();
    info2.NbDecimal = 4;
    info2.Value = 0.5;
    graph.setData(data, info1, info2);

    graph.setBackgroundColor(Qt::black);
    QCOMPARE(graph.isGraphVisible(), true);
    QCOMPARE(graph.isTableVisible(), true);
    QCOMPARE(graph.isTextReportVisible(), false);
    QCOMPARE(graph.isGraphTypeSelectorVisible(), true);

    QCOMPARE(graph.switchLegendVisibility(), true);

    QCOMPARE(graph.switchLinearRegressionVisibility(), false);
    QCOMPARE(graph.switchLinearRegressionVisibility(), true);

    QCOMPARE(graph.switchLimitsVisibility(), false);
    QCOMPARE(graph.switchLimitsVisibility(), true);

    QCOMPARE(graph.swithOriginVisibility(), false);
    QCOMPARE(graph.swithOriginVisibility(), true);

    QCOMPARE(graph.getAdditionalDisplayMode(), SKGTableWithGraph::ALL);

    graph.setShadowVisible(true);
    QCOMPARE(graph.isShadowVisible(), true);

    graph.setShadowVisible(false);
    QCOMPARE(graph.isShadowVisible(), false);

    graph.setSelectable(true);
    QCOMPARE(graph.isSelectable(), true);

    graph.setSelectable(false);
    QCOMPARE(graph.isSelectable(), false);

    for (int i = 0; i < 9; ++i) {
        graph.setGraphType(static_cast<SKGTableWithGraph::GraphType>(i));
        QCOMPARE(graph.getGraphType(), static_cast<SKGTableWithGraph::GraphType>(i));
        QTest::qWait(1000);
        graph.graph()->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGGraphicsView_" + SKGServices::intToString(i) + ".png");
    }

    // Graph
    QTest::qWait(2000);

    graph.resetColors();
    SKGGraphicsView* g = graph.graph();
    g->onCopy();
    g->onSwitchToolBarVisibility();
    g->onSwitchToolBarVisibility();
    g->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGGraphicsView.svg");
    g->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGGraphicsView.pdf");
    g->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGGraphicsView.jpeg");
    g->setAntialiasing(false);
    g->setAntialiasing(true);

    SKGShow* show = graph.getShowWidget();
    show->setState("text");
    show->getMode();
    show->setDisplayTitle(true);
    QCOMPARE(show->getDisplayTitle(), true);
    show->setDisplayTitle(false);
    QCOMPARE(show->getDisplayTitle(), false);

    /*QCOMPARE(graph.isGraphVisible(), true);
    QCOMPARE(graph.isTableVisible(), true);
    QCOMPARE(graph.isTextReportVisible(), true);*/

    SKGWebView* t = graph.textReport();
    QTest::qWait(2000);
    t->onZoomIn();
    t->onZoomOriginal();
    t->onZoomOut();
    t->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGWebView.odt");
    t->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGWebView.pdf");
    t->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGWebView.html");
    t->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGWebView.htm");
    t->exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGWebView.png");

    graph.exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGTableWithGraph.csv");
    graph.exportInFile(SKGTest::getTestPath("OUT") % "/skgtesttablewithgraph/SKGTableWithGraph.txt");

    SKGStringListList ta = graph.getTable();
}

QTEST_MAIN(SKGTESTTableWithGraph)

