/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);
    QString path = qgetenv("PATH");
    QString in = qgetenv("IN");

    {
        // Test import Weboob
        SKGDocumentBank document1;
        SKGTESTERROR("document1.load()", document1.load(SKGTest::getTestPath("IN") % "/skgtestimportbackend/fake1/fake1.skg"), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/fake1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTESTERROR("WEBOOB.importFile", imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "12345", account), true);
            SKGTESTERROR("ACCOUNT.load", account.load(), true);
            SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1523.99");
            SKGTEST("ACCOUNT:getAmount", SKGServices::doubleToString(account.getAmount(QDate(2013, 5, 1))), "1471.22");

            SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "47896", account), true);
            SKGTESTERROR("ACCOUNT.load", account.load(), true);
            SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-30");
            SKGTEST("ACCOUNT:getAmount", SKGServices::doubleToString(account.getAmount(QDate(2013, 5, 1))), "0");

            SKGObjectBase::SKGListSKGObjectBase result;
            SKGTESTERROR("DOC.getObjects", document1.getObjects("v_operation", "t_comment='SNCF'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 2);

            SKGTESTERROR("DOC.getObjects", document1.getObjects("v_operation", "d_date='2013-05-26'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 1);
        }
    }

    {
        // BUG: 320716
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.320716_1", qputenv("PATH", (in + "/skgtestimportbackend/320716_1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTESTERROR("WEBOOB.importFile", imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "12345", account), true);
            SKGTESTERROR("ACCOUNT.load", account.load(), true);
            SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "100");
        }

        {
            SKGTESTBOOL("PUTENV.320716_1", qputenv("PATH", (in + "/skgtestimportbackend/320716_2/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTESTERROR("WEBOOB.importFile", imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "12345", account), true);
            SKGTESTERROR("ACCOUNT.load", account.load(), true);
            SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "0");
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTEST("WEBOOB.importFile", imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error2/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTEST("WEBOOB.importFile", imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error3/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            document1.sendMessage("Hello");

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTEST("WEBOOB.importFile", imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error4/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob"));
            SKGTEST("WEBOOB.importFile", imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // BUG: 329876
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.329876", qputenv("PATH", (in + "/skgtestimportbackend/329876/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob0g"));
            SKGTESTERROR("WEBOOB.importFile", imp1.importFile(), true);
        }

        // Check
        {
            SKGObjectBase::SKGListSKGObjectBase ops;
            SKGTESTERROR("DOC.getObjectByName", document1.getObjects("v_operation", "d_date='2014-01-05'", ops), true);
            SKGTEST("DOC.getObjectByName", static_cast<unsigned int>(ops.count()), static_cast<unsigned int>(3));
        }
    }

    {
        // BUG: weboob0h
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.weboob0h", qputenv("PATH", (in + "/skgtestimportbackend/weboob0h/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_WEBOOB", err);

            SKGImportExportManager imp1(&document1, QUrl(".weboob0g"));
            SKGTESTERROR("WEBOOB.importFile", imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "1234", account), true);
            SKGTESTERROR("ACCOUNT.load", account.load(), true);
            SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-147994.82");
        }
    }
    // End test
    SKGENDTEST();
}
