/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A KTabWidget with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtabwidget.h"
#include "skgtabpage.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include <kicon.h>
#include <klocale.h>
#include <ktabbar.h>

#include <QHBoxLayout>
#include <QPushButton>
#include <QTimer>
#include <QStringList>

SKGTabWidget::SKGTabWidget(QWidget* iParent)
    : KTabWidget(iParent)
{
    m_timerSave.setSingleShot(true);
    connect(&m_timerSave, SIGNAL(timeout()), this, SLOT(onRefreshSaveIcon()), Qt::QueuedConnection);
    connect(tabBar(), SIGNAL(moveTab(int,int)), this, SLOT(onMoveTab(int,int)));
    if (iParent) connect(static_cast<SKGMainPanel*>(iParent), SIGNAL(currentPageChanged()), this, SLOT(onCurrentChanged()));

    // Use new KDE for moving tabs.
    KTabBar* tabbar = qobject_cast< KTabBar* >(tabBar());
    tabbar->setMovable(true);

    m_timerSave.start(1000);
}

SKGTabWidget::~SKGTabWidget()
{
}

void SKGTabWidget::onCurrentChanged()
{
    if (currentWidget() && !m_tabIndexSaveButton.keys().contains(currentWidget())) {
        //Build widgets
        QPushButton* kSave = new QPushButton(this);
        kSave->setIcon(KIcon("document-save"));
        kSave->setToolTip(i18nc("Verb", "Save this tab"));
        kSave->setFlat(true);
        kSave->setMaximumSize(QSize(16, 16));
        kSave->show();

        connect(kSave, SIGNAL(clicked()), this, SLOT(onSaveRequested()));
        tabBar()->setTabButton(currentIndex(), KTabBar::LeftSide, kSave);

        m_tabIndexSaveButton.insert(currentWidget(), kSave);
    }

    //Rebuild indexes
    QMap<QWidget*, QPushButton*> TabIndexSaveButton2;

    int nb = count();
    for (int i = 0; i < nb; ++i) {
        QWidget* w = widget(i);
        QPushButton* save = m_tabIndexSaveButton.value(w);
        if (w && save) {
            save->setVisible(false);
            TabIndexSaveButton2[w] = save;
        }
    }

    m_tabIndexSaveButton = TabIndexSaveButton2;

    onRefreshSaveIcon();
}

void SKGTabWidget::removeTab(int index)
{
    m_tabIndexSaveButton.clear();
    KTabWidget::removeTab(index);
}


void SKGTabWidget::onMoveTab(int oldPos, int newPos)
{
    Q_UNUSED(oldPos);
    Q_UNUSED(newPos);
    m_tabIndexSaveButton.clear();
    onCurrentChanged();
}

void SKGTabWidget::onSaveRequested()
{
    SKGTabPage* page = qobject_cast<SKGTabPage*>(currentWidget());
    if (page) {
        page->overwrite(false);
        onRefreshSaveIcon();
    }
}

void SKGTabWidget::onRefreshSaveIcon()
{
    SKGTabPage* page = qobject_cast<SKGTabPage*>(currentWidget());
    if (page) {
        QPushButton* save = m_tabIndexSaveButton.value(page);
        if (save) {
            if (page->isOverwriteNeeded()) {
                save->show();
                save->setEnabled(true);
                QStringList overlay;
                if (page->isPin()) overlay.push_back("document-encrypt");
                if (!page->getBookmarkID().isEmpty()) overlay.push_back("bookmarks");
                save->setIcon(KIcon("document-save", NULL, overlay));
            } else if (page->isPin()) {
                save->show();
                save->setEnabled(false);
                save->setIcon(KIcon("document-encrypt"));
            } else save->hide();
        }

        m_timerSave.start(1000);
    }
}
#include "skgtabwidget.moc"

