/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A line edit with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skglineedit.h"

#include <klineedit.h>

SKGLineEdit::SKGLineEdit(QWidget* iParent)
    : KLineEdit(iParent), m_substringCompletionMode(true)
{
}

SKGLineEdit::~SKGLineEdit()
{
}

bool SKGLineEdit::substringCompletionMode() const
{
    return m_substringCompletionMode;
}

void SKGLineEdit::setSubstringCompletionMode(bool iMode)
{
    m_substringCompletionMode = iMode;
}

void SKGLineEdit::makeCompletion(const QString& text)
{
    if (m_substringCompletionMode && completionMode() == KGlobalSettings::CompletionPopup)
        setCompletedItems(completionObject()->substringCompletion(text));
    else KLineEdit::makeCompletion(text);
}

#include "skglineedit.moc"

