/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGWEBVIEW_H
#define SKGWEBVIEW_H
/** @file
 * A web viewer with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgbasegui_export.h"

#include <QWebView>

class QPrinter;

/**
 * This file is a web viewer
 */
class SKGBASEGUI_EXPORT SKGWebView : public QWebView
{
    Q_OBJECT

public:

    /**
     * Constructor
     * @param parent the parent
     * @param name name
     */
    explicit SKGWebView(QWidget* parent = 0, const char* name = 0);

    /**
     * Destructor
     */
    virtual ~SKGWebView();

    /**
     * Get the current state
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Export in the file (PDF, ODT, png, jpeg, ...)
     * @param iFileName the file name
     */
    virtual void exportInFile(const QString& iFileName);

Q_SIGNALS:
    /**
     * Emitted when zoom changed
     * @param iZoomPosition zoom position (-10<=zoom position<=10)
     */
    void zoomChanged(int iZoomPosition);

public Q_SLOTS:
    /**
     * Zoom in
     */
    virtual void onZoomIn();

    /**
     * Zoom out
     */
    virtual void onZoomOut();

    /**
     * Fit on scene
     */
    virtual void onZoomOriginal();

    /**
     * Print
     */
    virtual void onPrint();

    /**
     * Export
     */
    virtual void onExport();

    /**
     * Print preview
     */
    virtual void onPrintPreview();

protected:
    /**
     * Contextual event
     * @param event the event
     */
    virtual void contextMenuEvent(QContextMenuEvent* event);

    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject* object, QEvent* event);

private:
    Q_DISABLE_COPY(SKGWebView)
};

#endif
