// Copyright (C) 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/***********************************************************************
 * Copyright (c) 2016, International Business Machines Corporation
 * and others. All Rights Reserved.
 ***********************************************************************/

#ifdef INCLUDED_FROM_CALTEST_CPP

//  Separate test data for intltest/caltest.cpp

//  Mapping data between chinese lunar calendar & gregorian.
//  Includes days before and after a month transition in either
//  calendar, plus days of solar terms, and certain other dates
//  that were known to have conversion problems in the past.
//  Months are 1-based.
//  Data is from http://www.hko.gov.hk/gts/time/conversion.htm
//  and presumably for zone

typedef struct {
    int16_t gyr;
    int8_t  gmo; // 1-based
    int8_t  gda;
    int8_t  cyr;
    int8_t  cmo; // 1-based
    int8_t  clp; // 1 for leap month, 0 otherwise
    int8_t  cda;
} GregoToLunar;

static const GregoToLunar gregoToLunar[] = {
//    Gregorian          Chinese Lunar      solar term
//    yyyy   MM   dd     yy   MM,lp  dd     (just a comment for now)
//    --------------     --------------     ----------------------
// *** comment out the tests currently failing with "//#" ***
    { 1901,   1,   1,    37,  11,0,  11 },
    { 1901,   1,   6,    37,  11,0,  16 },  // 23 "minor cold"
    { 1901,   1,  19,    37,  11,0,  29 },
    { 1901,   1,  20,    37,  12,0,   1 },
    { 1901,   1,  21,    37,  12,0,   2 },  // 24 "major cold"
    { 1901,   1,  31,    37,  12,0,  12 },
    { 1901,   2,   1,    37,  12,0,  13 },
    { 1901,   2,   4,    37,  12,0,  16 },  //  1 "spring begins"
    { 1901,   2,  18,    37,  12,0,  30 },
    { 1901,   2,  19,    38,   1,0,   1 },  //  2 "rain water"
    { 1901,   2,  28,    38,   1,0,  10 },
    { 1901,   3,   1,    38,   1,0,  11 },
    { 1901,   3,   6,    38,   1,0,  16 },  //  3 "insects awaken"
    { 1901,   3,  19,    38,   1,0,  29 },
    { 1901,   3,  20,    38,   2,0,   1 },
    { 1901,   3,  21,    38,   2,0,   2 },  //  4 "spring equinox"
    { 1901,   3,  31,    38,   2,0,  12 },
    { 1901,   4,   1,    38,   2,0,  13 },
    { 1901,   4,   5,    38,   2,0,  17 },  //  5 "bright and clear"
    { 1901,   4,  18,    38,   2,0,  30 },
    { 1901,   4,  19,    38,   3,0,   1 },
    { 1901,   4,  21,    38,   3,0,   3 },  //  6 "grain rain"
    { 1901,   4,  30,    38,   3,0,  12 },
    { 1901,   5,   1,    38,   3,0,  13 },
    { 1901,   5,   6,    38,   3,0,  18 },  //  7 "summer begins"
    { 1901,   5,  17,    38,   3,0,  29 },
    { 1901,   5,  18,    38,   4,0,   1 },
    { 1901,   5,  22,    38,   4,0,   5 },  //  8 "grain full"
    { 1901,   5,  31,    38,   4,0,  14 },
    { 1901,   6,   1,    38,   4,0,  15 },
    { 1901,   6,   6,    38,   4,0,  20 },  //  9 "grain in ear"
    { 1901,   6,  15,    38,   4,0,  29 },
    { 1901,   6,  16,    38,   5,0,   1 },
    { 1901,   6,  22,    38,   5,0,   7 },  // 10 "summer solstice"
    { 1901,   6,  30,    38,   5,0,  15 },
    { 1901,   7,   1,    38,   5,0,  16 },
    { 1901,   7,   8,    38,   5,0,  23 },  // 11 "minor heat"
    { 1901,   7,  15,    38,   5,0,  30 },
    { 1901,   7,  16,    38,   6,0,   1 },
    { 1901,   7,  23,    38,   6,0,   8 },  // 12 "major heat"
    { 1901,   7,  31,    38,   6,0,  16 },
    { 1901,   8,   1,    38,   6,0,  17 },
    { 1901,   8,   8,    38,   6,0,  24 },  // 13 "autumn begins"
    { 1901,   8,  13,    38,   6,0,  29 },
    { 1901,   8,  14,    38,   7,0,   1 },
    { 1901,   8,  24,    38,   7,0,  11 },  // 14 "end of heat"
    { 1901,   8,  31,    38,   7,0,  18 },
    { 1901,   9,   1,    38,   7,0,  19 },
    { 1901,   9,   8,    38,   7,0,  26 },  // 15 "white dew"
    { 1901,   9,  12,    38,   7,0,  30 },
    { 1901,   9,  13,    38,   8,0,   1 },
    { 1901,   9,  24,    38,   8,0,  12 },  // 16 "autumn equinox"
    { 1901,   9,  30,    38,   8,0,  18 },
    { 1901,  10,   1,    38,   8,0,  19 },
    { 1901,  10,   9,    38,   8,0,  27 },  // 17 "cold dew"
    { 1901,  10,  11,    38,   8,0,  29 },
    { 1901,  10,  12,    38,   9,0,   1 },
    { 1901,  10,  24,    38,   9,0,  13 },  // 18 "frost descends"
    { 1901,  10,  31,    38,   9,0,  20 },
    { 1901,  11,   1,    38,   9,0,  21 },
    { 1901,  11,   8,    38,   9,0,  28 },  // 19 "winter begins"
    { 1901,  11,  10,    38,   9,0,  30 },
    { 1901,  11,  11,    38,  10,0,   1 },
    { 1901,  11,  23,    38,  10,0,  13 },  // 20 "minor snow"
    { 1901,  11,  30,    38,  10,0,  20 },
    { 1901,  12,   1,    38,  10,0,  21 },
    { 1901,  12,   8,    38,  10,0,  28 },  // 21 "major snow"
    { 1901,  12,  10,    38,  10,0,  30 },
    { 1901,  12,  11,    38,  11,0,   1 },
    { 1901,  12,  22,    38,  11,0,  12 },  // 22 "winter solstice"
    { 1901,  12,  31,    38,  11,0,  21 },

    { 1924,   1,   5,    60,  11,0,  29 },
    { 1924,   1,   6,    60,  12,0,   1 },  // 23 "minor cold"
    { 1924,   1,  21,    60,  12,0,  16 },  // 24 "major cold"
    { 1924,   1,  31,    60,  12,0,  26 },
    { 1924,   2,   1,    60,  12,0,  27 },
    { 1924,   2,   4,    60,  12,0,  30 },
    { 1924,   2,   5,     1,   1,0,   1 },  //  1 "spring begins"
    { 1924,   2,  20,     1,   1,0,  16 },  //  2 "rain water"
    { 1924,   2,  29,     1,   1,0,  25 },
    { 1924,   3,   1,     1,   1,0,  26 },
    { 1924,   3,   4,     1,   1,0,  29 },
    { 1924,   3,   5,     1,   2,0,   1 },
    { 1924,   3,   6,     1,   2,0,   2 },  //  3 "insects awaken"
    { 1924,   3,  21,     1,   2,0,  17 },  //  4 "spring equinox"
    { 1924,   3,  31,     1,   2,0,  27 },
    { 1924,   4,   1,     1,   2,0,  28 },
    { 1924,   4,   3,     1,   2,0,  30 },
    { 1924,   4,   4,     1,   3,0,   1 },
    { 1924,   4,   5,     1,   3,0,   2 },  //  5 "bright and clear"
    { 1924,   4,  20,     1,   3,0,  17 },  //  6 "grain rain"
    { 1924,   4,  30,     1,   3,0,  27 },
    { 1924,   5,   1,     1,   3,0,  28 },
    { 1924,   5,   3,     1,   3,0,  30 },
    { 1924,   5,   4,     1,   4,0,   1 },
    { 1924,   5,   6,     1,   4,0,   3 },  //  7 "summer begins"
    { 1924,   5,  21,     1,   4,0,  18 },  //  8 "grain full"
    { 1924,   5,  31,     1,   4,0,  28 },
    { 1924,   6,   1,     1,   4,0,  29 },
    { 1924,   6,   2,     1,   5,0,   1 },
    { 1924,   6,   6,     1,   5,0,   5 },  //  9 "grain in ear"
    { 1924,   6,  22,     1,   5,0,  21 },  // 10 "summer solstice"
    { 1924,   6,  30,     1,   5,0,  29 },
    { 1924,   7,   1,     1,   5,0,  30 },
    { 1924,   7,   2,     1,   6,0,   1 },
    { 1924,   7,   7,     1,   6,0,   6 },  // 11 "minor heat"
    { 1924,   7,  23,     1,   6,0,  22 },  // 12 "major heat"
    { 1924,   7,  31,     1,   6,0,  30 },
    { 1924,   8,   1,     1,   7,0,   1 },
    { 1924,   8,   8,     1,   7,0,   8 },  // 13 "autumn begins"
    { 1924,   8,  23,     1,   7,0,  23 },  // 14 "end of heat"
    { 1924,   8,  29,     1,   7,0,  29 },
    { 1924,   8,  30,     1,   8,0,   1 },
    { 1924,   8,  31,     1,   8,0,   2 },
    { 1924,   9,   1,     1,   8,0,   3 },
    { 1924,   9,   8,     1,   8,0,  10 },  // 15 "white dew"
    { 1924,   9,  23,     1,   8,0,  25 },  // 16 "autumn equinox"
    { 1924,   9,  28,     1,   8,0,  30 },
    { 1924,   9,  29,     1,   9,0,   1 },
    { 1924,   9,  30,     1,   9,0,   2 },
    { 1924,  10,   1,     1,   9,0,   3 },
    { 1924,  10,   8,     1,   9,0,  10 },  // 17 "cold dew"
    { 1924,  10,  24,     1,   9,0,  26 },  // 18 "frost descends"
    { 1924,  10,  27,     1,   9,0,  29 },
    { 1924,  10,  28,     1,  10,0,   1 },
    { 1924,  10,  31,     1,  10,0,   4 },
    { 1924,  11,   1,     1,  10,0,   5 },
    { 1924,  11,   8,     1,  10,0,  12 },  // 19 "winter begins"
    { 1924,  11,  22,     1,  10,0,  26 },  // 20 "minor snow"
    { 1924,  11,  26,     1,  10,0,  30 },
    { 1924,  11,  27,     1,  11,0,   1 },
    { 1924,  11,  30,     1,  11,0,   4 },
    { 1924,  12,   1,     1,  11,0,   5 },
    { 1924,  12,   7,     1,  11,0,  11 },  // 21 "major snow"
    { 1924,  12,  22,     1,  11,0,  26 },  // 22 "winter solstice"
    { 1924,  12,  25,     1,  11,0,  29 },
    { 1924,  12,  26,     1,  12,0,   1 },
    { 1924,  12,  31,     1,  12,0,   6 },

    { 1949,   1,   1,    25,  12,0,   3 },
    { 1949,   1,   5,    25,  12,0,   7 },  // 23 "minor cold"
    { 1949,   1,  20,    25,  12,0,  22 },  // 24 "major cold"
    { 1949,   1,  28,    25,  12,0,  30 },
    { 1949,   1,  29,    26,   1,0,   1 },
    { 1949,   1,  31,    26,   1,0,   3 },
    { 1949,   2,   1,    26,   1,0,   4 },
    { 1949,   2,   4,    26,   1,0,   7 },  //  1 "spring begins"
    { 1949,   2,  19,    26,   1,0,  22 },  //  2 "rain water"
    { 1949,   2,  27,    26,   1,0,  30 },
    { 1949,   2,  28,    26,   2,0,   1 },
    { 1949,   3,   1,    26,   2,0,   2 },
    { 1949,   3,   6,    26,   2,0,   7 },  //  3 "insects awaken"
    { 1949,   3,  21,    26,   2,0,  22 },  //  4 "spring equinox"
    { 1949,   3,  28,    26,   2,0,  29 },
    { 1949,   3,  29,    26,   3,0,   1 },
    { 1949,   3,  31,    26,   3,0,   3 },
    { 1949,   4,   1,    26,   3,0,   4 },
    { 1949,   4,   5,    26,   3,0,   8 },  //  5 "bright and clear"
    { 1949,   4,  20,    26,   3,0,  23 },  //  6 "grain rain"
    { 1949,   4,  27,    26,   3,0,  30 },
    { 1949,   4,  28,    26,   4,0,   1 },
    { 1949,   4,  30,    26,   4,0,   3 },
    { 1949,   5,   1,    26,   4,0,   4 },
    { 1949,   5,   6,    26,   4,0,   9 },  //  7 "summer begins"
    { 1949,   5,  21,    26,   4,0,  24 },  //  8 "grain full"
    { 1949,   5,  27,    26,   4,0,  30 },
    { 1949,   5,  28,    26,   5,0,   1 },
    { 1949,   5,  31,    26,   5,0,   4 },
    { 1949,   6,   1,    26,   5,0,   5 },
    { 1949,   6,   6,    26,   5,0,  10 },  //  9 "grain in ear"
    { 1949,   6,  22,    26,   5,0,  26 },  // 10 "summer solstice"
    { 1949,   6,  25,    26,   5,0,  29 },
    { 1949,   6,  26,    26,   6,0,   1 },
    { 1949,   6,  30,    26,   6,0,   5 },
    { 1949,   7,   1,    26,   6,0,   6 },
    { 1949,   7,   7,    26,   6,0,  12 },  // 11 "minor heat"
    { 1949,   7,  23,    26,   6,0,  28 },  // 12 "major heat"
    { 1949,   7,  25,    26,   6,0,  30 },
    { 1949,   7,  26,    26,   7,0,   1 },
    { 1949,   7,  31,    26,   7,0,   6 },
    { 1949,   8,   1,    26,   7,0,   7 },
    { 1949,   8,   8,    26,   7,0,  14 },  // 13 "autumn begins"
    { 1949,   8,  23,    26,   7,0,  29 },
    { 1949,   8,  23,    26,   7,0,  29 },  // 14 "end of heat"
    { 1949,   8,  24,    26,   7,1,   1 },
    { 1949,   8,  31,    26,   7,1,   8 },
    { 1949,   9,   1,    26,   7,1,   9 },
    { 1949,   9,   8,    26,   7,1,  16 },  // 15 "white dew"
    { 1949,   9,  21,    26,   7,1,  29 },
    { 1949,   9,  22,    26,   8,0,   1 },
    { 1949,   9,  23,    26,   8,0,   2 },  // 16 "autumn equinox"
    { 1949,   9,  30,    26,   8,0,   9 },
    { 1949,  10,   1,    26,   8,0,  10 },
    { 1949,  10,   8,    26,   8,0,  17 },  // 17 "cold dew"
    { 1949,  10,  21,    26,   8,0,  30 },
    { 1949,  10,  22,    26,   9,0,   1 },
    { 1949,  10,  24,    26,   9,0,   3 },  // 18 "frost descends"
    { 1949,  10,  31,    26,   9,0,  10 },
    { 1949,  11,   1,    26,   9,0,  11 },
    { 1949,  11,   8,    26,   9,0,  18 },  // 19 "winter begins"
    { 1949,  11,  19,    26,   9,0,  29 },
    { 1949,  11,  20,    26,  10,0,   1 },
    { 1949,  11,  22,    26,  10,0,   3 },  // 20 "minor snow"
    { 1949,  11,  30,    26,  10,0,  11 },
    { 1949,  12,   1,    26,  10,0,  12 },
    { 1949,  12,   7,    26,  10,0,  18 },  // 21 "major snow"
    { 1949,  12,  19,    26,  10,0,  30 },
    { 1949,  12,  20,    26,  11,0,   1 },
    { 1949,  12,  22,    26,  11,0,   3 },  // 22 "winter solstice"
    { 1949,  12,  31,    26,  11,0,  12 },

    { 1950,   1,   1,    26,  11,0,  13 },
    { 1950,   1,   6,    26,  11,0,  18 },
    { 1950,   1,  17,    26,  11,0,  29 },
    { 1950,   1,  18,    26,  12,0,   1 },
    { 1950,   1,  19,    26,  12,0,   2 },
    { 1950,   1,  20,    26,  12,0,   3 },
    { 1950,   1,  31,    26,  12,0,  14 },
    { 1950,   2,   1,    26,  12,0,  15 },
    { 1950,   2,   4,    26,  12,0,  18 },
    { 1950,   2,  16,    26,  12,0,  30 },
    { 1950,   2,  17,    27,   1,0,   1 },
    { 1950,   2,  18,    27,   1,0,   2 },
    { 1950,   2,  19,    27,   1,0,   3 },
    { 1950,   2,  28,    27,   1,0,  12 },
    { 1950,   3,   1,    27,   1,0,  13 },
    { 1950,   3,   6,    27,   1,0,  18 },
    { 1950,   3,  17,    27,   1,0,  29 },
    { 1950,   3,  18,    27,   2,0,   1 },
    { 1950,   3,  19,    27,   2,0,   2 },
    { 1950,   3,  21,    27,   2,0,   4 },
    { 1950,   3,  31,    27,   2,0,  14 },
    { 1950,   4,   1,    27,   2,0,  15 },
    { 1950,   4,   5,    27,   2,0,  19 },
    { 1950,   4,  16,    27,   2,0,  30 },
    { 1950,   4,  17,    27,   3,0,   1 },
    { 1950,   4,  18,    27,   3,0,   2 },
    { 1950,   4,  20,    27,   3,0,   4 },
    { 1950,   4,  30,    27,   3,0,  14 },
    { 1950,   5,   1,    27,   3,0,  15 },
    { 1950,   5,   6,    27,   3,0,  20 },
    { 1950,   5,  16,    27,   3,0,  30 },
    { 1950,   5,  17,    27,   4,0,   1 },
    { 1950,   5,  18,    27,   4,0,   2 },
    { 1950,   5,  21,    27,   4,0,   5 },
    { 1950,   5,  31,    27,   4,0,  15 },
    { 1950,   6,   1,    27,   4,0,  16 },
    { 1950,   6,   6,    27,   4,0,  21 },
    { 1950,   6,  14,    27,   4,0,  29 },
    { 1950,   6,  15,    27,   5,0,   1 },
    { 1950,   6,  16,    27,   5,0,   2 },
    { 1950,   6,  22,    27,   5,0,   8 },
    { 1950,   6,  30,    27,   5,0,  16 },
    { 1950,   7,   1,    27,   5,0,  17 },
    { 1950,   7,   8,    27,   5,0,  24 },
    { 1950,   7,  14,    27,   5,0,  30 },
    { 1950,   7,  15,    27,   6,0,   1 },
    { 1950,   7,  16,    27,   6,0,   2 },
    { 1950,   7,  23,    27,   6,0,   9 },
    { 1950,   7,  31,    27,   6,0,  17 },
    { 1950,   8,   1,    27,   6,0,  18 },
    { 1950,   8,   8,    27,   6,0,  25 },
    { 1950,   8,  13,    27,   6,0,  30 },
    { 1950,   8,  14,    27,   7,0,   1 },
    { 1950,   8,  15,    27,   7,0,   2 },
    { 1950,   8,  24,    27,   7,0,  11 },
    { 1950,   8,  31,    27,   7,0,  18 },
    { 1950,   9,   1,    27,   7,0,  19 },
    { 1950,   9,   8,    27,   7,0,  26 },
    { 1950,   9,  11,    27,   7,0,  29 },
    { 1950,   9,  12,    27,   8,0,   1 },
    { 1950,   9,  13,    27,   8,0,   2 },
    { 1950,   9,  23,    27,   8,0,  12 },
    { 1950,   9,  30,    27,   8,0,  19 },
    { 1950,  10,   1,    27,   8,0,  20 },
    { 1950,  10,   9,    27,   8,0,  28 },
    { 1950,  10,  10,    27,   8,0,  29 },
    { 1950,  10,  11,    27,   9,0,   1 },
    { 1950,  10,  12,    27,   9,0,   2 },
    { 1950,  10,  24,    27,   9,0,  14 },
    { 1950,  10,  31,    27,   9,0,  21 },
    { 1950,  11,   1,    27,   9,0,  22 },
    { 1950,  11,   8,    27,   9,0,  29 },
    { 1950,  11,   9,    27,   9,0,  30 },
    { 1950,  11,  10,    27,  10,0,   1 },
    { 1950,  11,  11,    27,  10,0,   2 },
    { 1950,  11,  23,    27,  10,0,  14 },
    { 1950,  11,  30,    27,  10,0,  21 },
    { 1950,  12,   1,    27,  10,0,  22 },
    { 1950,  12,   8,    27,  10,0,  29 },
    { 1950,  12,   9,    27,  11,0,   1 },
    { 1950,  12,  10,    27,  11,0,   2 },
    { 1950,  12,  22,    27,  11,0,  14 },
    { 1950,  12,  31,    27,  11,0,  23 },

    { 1951,   1,   1,    27,  11,0,  24 },
    { 1951,   1,   6,    27,  11,0,  29 },
    { 1951,   1,   7,    27,  11,0,  30 },
    { 1951,   1,   8,    27,  12,0,   1 },
    { 1951,   1,   9,    27,  12,0,   2 },
    { 1951,   1,  21,    27,  12,0,  14 },
    { 1951,   1,  31,    27,  12,0,  24 },
    { 1951,   2,   1,    27,  12,0,  25 },
    { 1951,   2,   4,    27,  12,0,  28 },
    { 1951,   2,   5,    27,  12,0,  29 },
    { 1951,   2,   6,    28,   1,0,   1 },
    { 1951,   2,   7,    28,   1,0,   2 },
    { 1951,   2,  19,    28,   1,0,  14 },
    { 1951,   2,  28,    28,   1,0,  23 },
    { 1951,   3,   1,    28,   1,0,  24 },
    { 1951,   3,   6,    28,   1,0,  29 },
    { 1951,   3,   7,    28,   1,0,  30 },
    { 1951,   3,   8,    28,   2,0,   1 },
    { 1951,   3,   9,    28,   2,0,   2 },
    { 1951,   3,  21,    28,   2,0,  14 },
    { 1951,   3,  31,    28,   2,0,  24 },
    { 1951,   4,   1,    28,   2,0,  25 },
    { 1951,   4,   5,    28,   2,0,  29 },
    { 1951,   4,   6,    28,   3,0,   1 },
    { 1951,   4,   7,    28,   3,0,   2 },
    { 1951,   4,  21,    28,   3,0,  16 },
    { 1951,   4,  30,    28,   3,0,  25 },
    { 1951,   5,   1,    28,   3,0,  26 },
    { 1951,   5,   5,    28,   3,0,  30 },
    { 1951,   5,   6,    28,   4,0,   1 },
    { 1951,   5,   7,    28,   4,0,   2 },
    { 1951,   5,  22,    28,   4,0,  17 },
    { 1951,   5,  31,    28,   4,0,  26 },
    { 1951,   6,   1,    28,   4,0,  27 },
    { 1951,   6,   4,    28,   4,0,  30 },
    { 1951,   6,   5,    28,   5,0,   1 },
    { 1951,   6,   6,    28,   5,0,   2 },
    { 1951,   6,  22,    28,   5,0,  18 },
    { 1951,   6,  30,    28,   5,0,  26 },
    { 1951,   7,   1,    28,   5,0,  27 },
    { 1951,   7,   3,    28,   5,0,  29 },
    { 1951,   7,   4,    28,   6,0,   1 },
    { 1951,   7,   5,    28,   6,0,   2 },
    { 1951,   7,   8,    28,   6,0,   5 },
    { 1951,   7,  24,    28,   6,0,  21 },
    { 1951,   8,   2,    28,   6,0,  30 },
    { 1951,   8,   3,    28,   7,0,   1 },
    { 1951,   8,   4,    28,   7,0,   2 },
    { 1951,   8,   8,    28,   7,0,   6 },
    { 1951,   8,  24,    28,   7,0,  22 },
    { 1951,   8,  31,    28,   7,0,  29 },
    { 1951,   9,   1,    28,   8,0,   1 },
    { 1951,   9,   8,    28,   8,0,   8 },
    { 1951,   9,  24,    28,   8,0,  24 },
    { 1951,   9,  30,    28,   8,0,  30 },
    { 1951,  10,   1,    28,   9,0,   1 },
    { 1951,  10,   9,    28,   9,0,   9 },
    { 1951,  10,  24,    28,   9,0,  24 },
    { 1951,  10,  29,    28,   9,0,  29 },
    { 1951,  10,  30,    28,  10,0,   1 },
    { 1951,  10,  31,    28,  10,0,   2 },
    { 1951,  11,   1,    28,  10,0,   3 },
    { 1951,  11,   8,    28,  10,0,  10 },
    { 1951,  11,  23,    28,  10,0,  25 },
    { 1951,  11,  28,    28,  10,0,  30 },
    { 1951,  11,  29,    28,  11,0,   1 },
    { 1951,  11,  30,    28,  11,0,   2 },
    { 1951,  12,   1,    28,  11,0,   3 },
    { 1951,  12,   8,    28,  11,0,  10 },
    { 1951,  12,  23,    28,  11,0,  25 },
    { 1951,  12,  27,    28,  11,0,  29 },
    { 1951,  12,  28,    28,  12,0,   1 },
    { 1951,  12,  29,    28,  12,0,   2 },
    { 1951,  12,  31,    28,  12,0,   4 },

    { 1952,   1,   1,    28,  12,0,   5 },
    { 1952,   1,   6,    28,  12,0,  10 },
    { 1952,   1,  21,    28,  12,0,  25 },
    { 1952,   1,  26,    28,  12,0,  30 },
    { 1952,   1,  27,    29,   1,0,   1 },
    { 1952,   1,  28,    29,   1,0,   2 },
    { 1952,   1,  31,    29,   1,0,   5 },
    { 1952,   2,   1,    29,   1,0,   6 },
    { 1952,   2,   5,    29,   1,0,  10 },
    { 1952,   2,  20,    29,   1,0,  25 },
    { 1952,   2,  24,    29,   1,0,  29 },
    { 1952,   2,  25,    29,   2,0,   1 },
    { 1952,   2,  26,    29,   2,0,   2 },
    { 1952,   2,  29,    29,   2,0,   5 },
    { 1952,   3,   1,    29,   2,0,   6 },
    { 1952,   3,   5,    29,   2,0,  10 },
    { 1952,   3,  21,    29,   2,0,  26 },
    { 1952,   3,  25,    29,   2,0,  30 },
    { 1952,   3,  26,    29,   3,0,   1 },
    { 1952,   3,  27,    29,   3,0,   2 },
    { 1952,   3,  31,    29,   3,0,   6 },
    { 1952,   4,   1,    29,   3,0,   7 },
    { 1952,   4,   5,    29,   3,0,  11 },
    { 1952,   4,  20,    29,   3,0,  26 },
    { 1952,   4,  23,    29,   3,0,  29 },
    { 1952,   4,  24,    29,   4,0,   1 },
    { 1952,   4,  25,    29,   4,0,   2 },
    { 1952,   4,  30,    29,   4,0,   7 },
    { 1952,   5,   1,    29,   4,0,   8 },
    { 1952,   5,   5,    29,   4,0,  12 },
    { 1952,   5,  21,    29,   4,0,  28 },
    { 1952,   5,  23,    29,   4,0,  30 },
    { 1952,   5,  24,    29,   5,0,   1 },
    { 1952,   5,  25,    29,   5,0,   2 },
    { 1952,   5,  31,    29,   5,0,   8 },
    { 1952,   6,   1,    29,   5,0,   9 },
    { 1952,   6,   6,    29,   5,0,  14 },
    { 1952,   6,  21,    29,   5,0,  29 },
    { 1952,   6,  22,    29,   5,1,   1 },
    { 1952,   6,  23,    29,   5,1,   2 },
    { 1952,   6,  30,    29,   5,1,   9 },
    { 1952,   7,   1,    29,   5,1,  10 },
    { 1952,   7,   7,    29,   5,1,  16 },
    { 1952,   7,  21,    29,   5,1,  30 },
    { 1952,   7,  22,    29,   6,0,   1 },
    { 1952,   7,  23,    29,   6,0,   2 },
    { 1952,   7,  31,    29,   6,0,  10 },
    { 1952,   8,   1,    29,   6,0,  11 },
    { 1952,   8,   7,    29,   6,0,  17 },
    { 1952,   8,  19,    29,   6,0,  29 },
    { 1952,   8,  20,    29,   7,0,   1 },
    { 1952,   8,  21,    29,   7,0,   2 },
    { 1952,   8,  23,    29,   7,0,   4 },
    { 1952,   8,  31,    29,   7,0,  12 },
    { 1952,   9,   1,    29,   7,0,  13 },
    { 1952,   9,   8,    29,   7,0,  20 },
    { 1952,   9,  18,    29,   7,0,  30 },
    { 1952,   9,  19,    29,   8,0,   1 },
    { 1952,   9,  20,    29,   8,0,   2 },
    { 1952,   9,  23,    29,   8,0,   5 },
    { 1952,   9,  30,    29,   8,0,  12 },
    { 1952,  10,   1,    29,   8,0,  13 },
    { 1952,  10,   8,    29,   8,0,  20 },
    { 1952,  10,  18,    29,   8,0,  30 },
    { 1952,  10,  19,    29,   9,0,   1 },
    { 1952,  10,  20,    29,   9,0,   2 },
    { 1952,  10,  23,    29,   9,0,   5 },
    { 1952,  10,  31,    29,   9,0,  13 },
    { 1952,  11,   1,    29,   9,0,  14 },
    { 1952,  11,   7,    29,   9,0,  20 },
    { 1952,  11,  16,    29,   9,0,  29 },
    { 1952,  11,  17,    29,  10,0,   1 },
    { 1952,  11,  18,    29,  10,0,   2 },
    { 1952,  11,  22,    29,  10,0,   6 },
    { 1952,  11,  30,    29,  10,0,  14 },
    { 1952,  12,   1,    29,  10,0,  15 },
    { 1952,  12,   7,    29,  10,0,  21 },
    { 1952,  12,  16,    29,  10,0,  30 },
    { 1952,  12,  17,    29,  11,0,   1 },
    { 1952,  12,  18,    29,  11,0,   2 },
    { 1952,  12,  22,    29,  11,0,   6 },
    { 1952,  12,  31,    29,  11,0,  15 },

    { 1953,   1,   1,    29,  11,0,  16 },
    { 1953,   1,   5,    29,  11,0,  20 },
    { 1953,   1,  14,    29,  11,0,  29 },
    { 1953,   1,  15,    29,  12,0,   1 },
    { 1953,   1,  16,    29,  12,0,   2 },
    { 1953,   1,  20,    29,  12,0,   6 },
    { 1953,   1,  31,    29,  12,0,  17 },
    { 1953,   2,   1,    29,  12,0,  18 },
    { 1953,   2,   4,    29,  12,0,  21 },
    { 1953,   2,  13,    29,  12,0,  30 },
    { 1953,   2,  14,    30,   1,0,   1 },
    { 1953,   2,  15,    30,   1,0,   2 },
    { 1953,   2,  19,    30,   1,0,   6 },
    { 1953,   2,  28,    30,   1,0,  15 },
    { 1953,   3,   1,    30,   1,0,  16 },
    { 1953,   3,   6,    30,   1,0,  21 },
    { 1953,   3,  14,    30,   1,0,  29 },
    { 1953,   3,  15,    30,   2,0,   1 },
    { 1953,   3,  16,    30,   2,0,   2 },
    { 1953,   3,  21,    30,   2,0,   7 },
    { 1953,   3,  31,    30,   2,0,  17 },
    { 1953,   4,   1,    30,   2,0,  18 },
    { 1953,   4,   5,    30,   2,0,  22 },
    { 1953,   4,  13,    30,   2,0,  30 },
    { 1953,   4,  14,    30,   3,0,   1 },
    { 1953,   4,  15,    30,   3,0,   2 },
    { 1953,   4,  20,    30,   3,0,   7 },
    { 1953,   4,  30,    30,   3,0,  17 },
    { 1953,   5,   1,    30,   3,0,  18 },
    { 1953,   5,   6,    30,   3,0,  23 },
    { 1953,   5,  12,    30,   3,0,  29 },
    { 1953,   5,  13,    30,   4,0,   1 },
    { 1953,   5,  14,    30,   4,0,   2 },
    { 1953,   5,  21,    30,   4,0,   9 },
    { 1953,   5,  31,    30,   4,0,  19 },
    { 1953,   6,   1,    30,   4,0,  20 },
    { 1953,   6,   6,    30,   4,0,  25 },
    { 1953,   6,  10,    30,   4,0,  29 },
    { 1953,   6,  11,    30,   5,0,   1 },
    { 1953,   6,  12,    30,   5,0,   2 },
    { 1953,   6,  22,    30,   5,0,  12 },
    { 1953,   6,  30,    30,   5,0,  20 },
    { 1953,   7,   1,    30,   5,0,  21 },
    { 1953,   7,   7,    30,   5,0,  27 },
    { 1953,   7,  10,    30,   5,0,  30 },
    { 1953,   7,  11,    30,   6,0,   1 },
    { 1953,   7,  12,    30,   6,0,   2 },
    { 1953,   7,  23,    30,   6,0,  13 },
    { 1953,   7,  31,    30,   6,0,  21 },
    { 1953,   8,   1,    30,   6,0,  22 },
    { 1953,   8,   8,    30,   6,0,  29 },
    { 1953,   8,   9,    30,   6,0,  30 },
    { 1953,   8,  10,    30,   7,0,   1 },
    { 1953,   8,  11,    30,   7,0,   2 },
    { 1953,   8,  23,    30,   7,0,  14 },
    { 1953,   8,  31,    30,   7,0,  22 },
    { 1953,   9,   1,    30,   7,0,  23 },
    { 1953,   9,   7,    30,   7,0,  29 },
    { 1953,   9,   8,    30,   8,0,   1 },
    { 1953,   9,   9,    30,   8,0,   2 },
    { 1953,   9,  23,    30,   8,0,  16 },
    { 1953,   9,  30,    30,   8,0,  23 },
    { 1953,  10,   1,    30,   8,0,  24 },
    { 1953,  10,   7,    30,   8,0,  30 },
    { 1953,  10,   8,    30,   9,0,   1 },
    { 1953,  10,   9,    30,   9,0,   2 },
    { 1953,  10,  24,    30,   9,0,  17 },
    { 1953,  10,  31,    30,   9,0,  24 },
    { 1953,  11,   1,    30,   9,0,  25 },
    { 1953,  11,   6,    30,   9,0,  30 },
    { 1953,  11,   7,    30,  10,0,   1 },
    { 1953,  11,   8,    30,  10,0,   2 },
    { 1953,  11,  22,    30,  10,0,  16 },
    { 1953,  11,  30,    30,  10,0,  24 },
    { 1953,  12,   1,    30,  10,0,  25 },
    { 1953,  12,   5,    30,  10,0,  29 },
    { 1953,  12,   6,    30,  11,0,   1 },
    { 1953,  12,   7,    30,  11,0,   2 },
    { 1953,  12,  22,    30,  11,0,  17 },
    { 1953,  12,  31,    30,  11,0,  26 },

    { 1954,   1,   1,    30,  11,0,  27 },
    { 1954,   1,   4,    30,  11,0,  30 },
    { 1954,   1,   5,    30,  12,0,   1 },
    { 1954,   1,   6,    30,  12,0,   2 },
    { 1954,   1,  20,    30,  12,0,  16 },
    { 1954,   2,   2,    30,  12,0,  29 },
//# { 1954,   2,   3,    31,   1,0,   1 },
//# { 1954,   2,   4,    31,   1,0,   2 },
//# { 1954,   2,  19,    31,   1,0,  17 },
//# { 1954,   2,  28,    31,   1,0,  26 },
//# { 1954,   3,   1,    31,   1,0,  27 },
//# { 1954,   3,   4,    31,   1,0,  30 },
    { 1954,   3,   5,    31,   2,0,   1 },
    { 1954,   3,   6,    31,   2,0,   2 },
    { 1954,   3,  21,    31,   2,0,  17 },
    { 1954,   4,   2,    31,   2,0,  29 },
    { 1954,   4,   3,    31,   3,0,   1 },
    { 1954,   4,   4,    31,   3,0,   2 },
    { 1954,   4,   5,    31,   3,0,   3 },
    { 1954,   4,  20,    31,   3,0,  18 },
    { 1954,   5,   2,    31,   3,0,  30 },
    { 1954,   5,   3,    31,   4,0,   1 },
    { 1954,   5,   4,    31,   4,0,   2 },
    { 1954,   5,   6,    31,   4,0,   4 },
    { 1954,   5,  21,    31,   4,0,  19 },
    { 1954,   5,  31,    31,   4,0,  29 },
    { 1954,   6,   1,    31,   5,0,   1 },
    { 1954,   6,   6,    31,   5,0,   6 },
    { 1954,   6,  22,    31,   5,0,  22 },
    { 1954,   6,  29,    31,   5,0,  29 },
    { 1954,   6,  30,    31,   6,0,   1 },
    { 1954,   7,   1,    31,   6,0,   2 },
    { 1954,   7,   8,    31,   6,0,   9 },
    { 1954,   7,  23,    31,   6,0,  24 },
    { 1954,   7,  29,    31,   6,0,  30 },
    { 1954,   7,  30,    31,   7,0,   1 },
    { 1954,   7,  31,    31,   7,0,   2 },
    { 1954,   8,   1,    31,   7,0,   3 },
    { 1954,   8,   8,    31,   7,0,  10 },
    { 1954,   8,  24,    31,   7,0,  26 },
    { 1954,   8,  27,    31,   7,0,  29 },
    { 1954,   8,  28,    31,   8,0,   1 },
    { 1954,   8,  29,    31,   8,0,   2 },
    { 1954,   8,  31,    31,   8,0,   4 },
    { 1954,   9,   1,    31,   8,0,   5 },
    { 1954,   9,   8,    31,   8,0,  12 },
    { 1954,   9,  23,    31,   8,0,  27 },
    { 1954,   9,  26,    31,   8,0,  30 },
    { 1954,   9,  27,    31,   9,0,   1 },
    { 1954,   9,  28,    31,   9,0,   2 },
    { 1954,   9,  30,    31,   9,0,   4 },
    { 1954,  10,   1,    31,   9,0,   5 },
    { 1954,  10,   9,    31,   9,0,  13 },
    { 1954,  10,  24,    31,   9,0,  28 },
    { 1954,  10,  26,    31,   9,0,  30 },
    { 1954,  10,  27,    31,  10,0,   1 },
    { 1954,  10,  28,    31,  10,0,   2 },
    { 1954,  10,  31,    31,  10,0,   5 },
    { 1954,  11,   1,    31,  10,0,   6 },
    { 1954,  11,   8,    31,  10,0,  13 },
    { 1954,  11,  23,    31,  10,0,  28 },
    { 1954,  11,  24,    31,  10,0,  29 },
    { 1954,  11,  25,    31,  11,0,   1 },
    { 1954,  11,  26,    31,  11,0,   2 },
    { 1954,  11,  30,    31,  11,0,   6 },
    { 1954,  12,   1,    31,  11,0,   7 },
    { 1954,  12,   7,    31,  11,0,  13 },
    { 1954,  12,  22,    31,  11,0,  28 },
    { 1954,  12,  24,    31,  11,0,  30 },
    { 1954,  12,  25,    31,  12,0,   1 },
    { 1954,  12,  26,    31,  12,0,   2 },
    { 1954,  12,  31,    31,  12,0,   7 },

    { 1955,   1,   1,    31,  12,0,   8 },
    { 1955,   1,   6,    31,  12,0,  13 },
    { 1955,   1,  21,    31,  12,0,  28 },
    { 1955,   1,  23,    31,  12,0,  30 },
    { 1955,   1,  24,    32,   1,0,   1 },
    { 1955,   1,  25,    32,   1,0,   2 },
    { 1955,   1,  31,    32,   1,0,   8 },
    { 1955,   2,   1,    32,   1,0,   9 },
    { 1955,   2,   4,    32,   1,0,  12 },
    { 1955,   2,  19,    32,   1,0,  27 },
    { 1955,   2,  21,    32,   1,0,  29 },
//# { 1955,   2,  22,    32,   2,0,   1 },
//# { 1955,   2,  23,    32,   2,0,   2 },
//# { 1955,   2,  28,    32,   2,0,   7 },
//# { 1955,   3,   1,    32,   2,0,   8 },
//# { 1955,   3,   6,    32,   2,0,  13 },
//# { 1955,   3,  21,    32,   2,0,  28 },
//# { 1955,   3,  23,    32,   2,0,  30 },
    { 1955,   3,  24,    32,   3,0,   1 },
    { 1955,   3,  25,    32,   3,0,   2 },
    { 1955,   3,  31,    32,   3,0,   8 },
    { 1955,   4,   1,    32,   3,0,   9 },
    { 1955,   4,   5,    32,   3,0,  13 },
    { 1955,   4,  21,    32,   3,0,  29 },
    { 1955,   4,  22,    32,   3,1,   1 },
    { 1955,   4,  23,    32,   3,1,   2 },
    { 1955,   4,  30,    32,   3,1,   9 },
    { 1955,   5,   1,    32,   3,1,  10 },
    { 1955,   5,   6,    32,   3,1,  15 },
    { 1955,   5,  21,    32,   3,1,  30 },
    { 1955,   5,  22,    32,   4,0,   1 },
    { 1955,   5,  23,    32,   4,0,   2 },
    { 1955,   5,  31,    32,   4,0,  10 },
    { 1955,   6,   1,    32,   4,0,  11 },
    { 1955,   6,   6,    32,   4,0,  16 },
    { 1955,   6,  19,    32,   4,0,  29 },
    { 1955,   6,  20,    32,   5,0,   1 },
    { 1955,   6,  21,    32,   5,0,   2 },
    { 1955,   6,  22,    32,   5,0,   3 },
    { 1955,   6,  30,    32,   5,0,  11 },
    { 1955,   7,   1,    32,   5,0,  12 },
    { 1955,   7,   8,    32,   5,0,  19 },
    { 1955,   7,  18,    32,   5,0,  29 },
    { 1955,   7,  19,    32,   6,0,   1 },
    { 1955,   7,  20,    32,   6,0,   2 },
    { 1955,   7,  23,    32,   6,0,   5 },
    { 1955,   7,  31,    32,   6,0,  13 },
    { 1955,   8,   1,    32,   6,0,  14 },
    { 1955,   8,   8,    32,   6,0,  21 },
    { 1955,   8,  17,    32,   6,0,  30 },
    { 1955,   8,  18,    32,   7,0,   1 },
    { 1955,   8,  19,    32,   7,0,   2 },
    { 1955,   8,  24,    32,   7,0,   7 },
    { 1955,   8,  31,    32,   7,0,  14 },
    { 1955,   9,   1,    32,   7,0,  15 },
    { 1955,   9,   8,    32,   7,0,  22 },
    { 1955,   9,  15,    32,   7,0,  29 },
    { 1955,   9,  16,    32,   8,0,   1 },
    { 1955,   9,  17,    32,   8,0,   2 },
    { 1955,   9,  24,    32,   8,0,   9 },
    { 1955,   9,  30,    32,   8,0,  15 },
    { 1955,  10,   1,    32,   8,0,  16 },
    { 1955,  10,   9,    32,   8,0,  24 },
    { 1955,  10,  15,    32,   8,0,  30 },
    { 1955,  10,  16,    32,   9,0,   1 },
    { 1955,  10,  17,    32,   9,0,   2 },
    { 1955,  10,  24,    32,   9,0,   9 },
    { 1955,  10,  31,    32,   9,0,  16 },
    { 1955,  11,   1,    32,   9,0,  17 },
    { 1955,  11,   8,    32,   9,0,  24 },
    { 1955,  11,  13,    32,   9,0,  29 },
    { 1955,  11,  14,    32,  10,0,   1 },
    { 1955,  11,  15,    32,  10,0,   2 },
    { 1955,  11,  23,    32,  10,0,  10 },
    { 1955,  11,  30,    32,  10,0,  17 },
    { 1955,  12,   1,    32,  10,0,  18 },
    { 1955,  12,   8,    32,  10,0,  25 },
    { 1955,  12,  13,    32,  10,0,  30 },
    { 1955,  12,  14,    32,  11,0,   1 },
    { 1955,  12,  15,    32,  11,0,   2 },
    { 1955,  12,  22,    32,  11,0,   9 },
    { 1955,  12,  31,    32,  11,0,  18 },

    { 1956,   1,   1,    32,  11,0,  19 },
    { 1956,   1,   6,    32,  11,0,  24 },
    { 1956,   1,  12,    32,  11,0,  30 },
    { 1956,   1,  13,    32,  12,0,   1 },
    { 1956,   1,  14,    32,  12,0,   2 },
    { 1956,   1,  21,    32,  12,0,   9 },
    { 1956,   1,  31,    32,  12,0,  19 },
    { 1956,   2,   1,    32,  12,0,  20 },
    { 1956,   2,   5,    32,  12,0,  24 },
    { 1956,   2,  11,    32,  12,0,  30 },
    { 1956,   2,  12,    33,   1,0,   1 },
    { 1956,   2,  13,    33,   1,0,   2 },
    { 1956,   2,  20,    33,   1,0,   9 },
    { 1956,   2,  29,    33,   1,0,  18 },
    { 1956,   3,   1,    33,   1,0,  19 },
    { 1956,   3,   5,    33,   1,0,  23 },
    { 1956,   3,  11,    33,   1,0,  29 },
    { 1956,   3,  12,    33,   2,0,   1 },
    { 1956,   3,  13,    33,   2,0,   2 },
    { 1956,   3,  20,    33,   2,0,   9 },
    { 1956,   3,  31,    33,   2,0,  20 },
    { 1956,   4,   1,    33,   2,0,  21 },
    { 1956,   4,   5,    33,   2,0,  25 },
    { 1956,   4,  10,    33,   2,0,  30 },
    { 1956,   4,  11,    33,   3,0,   1 },
    { 1956,   4,  12,    33,   3,0,   2 },
    { 1956,   4,  20,    33,   3,0,  10 },
    { 1956,   4,  30,    33,   3,0,  20 },
    { 1956,   5,   1,    33,   3,0,  21 },
    { 1956,   5,   5,    33,   3,0,  25 },
    { 1956,   5,   9,    33,   3,0,  29 },
    { 1956,   5,  10,    33,   4,0,   1 },
    { 1956,   5,  11,    33,   4,0,   2 },
    { 1956,   5,  21,    33,   4,0,  12 },
    { 1956,   5,  31,    33,   4,0,  22 },
    { 1956,   6,   1,    33,   4,0,  23 },
    { 1956,   6,   6,    33,   4,0,  28 },
    { 1956,   6,   8,    33,   4,0,  30 },
    { 1956,   6,   9,    33,   5,0,   1 },
    { 1956,   6,  10,    33,   5,0,   2 },
    { 1956,   6,  21,    33,   5,0,  13 },
    { 1956,   6,  30,    33,   5,0,  22 },
    { 1956,   7,   1,    33,   5,0,  23 },
    { 1956,   7,   7,    33,   5,0,  29 },
    { 1956,   7,   8,    33,   6,0,   1 },
    { 1956,   7,   9,    33,   6,0,   2 },
    { 1956,   7,  23,    33,   6,0,  16 },
    { 1956,   7,  31,    33,   6,0,  24 },
    { 1956,   8,   1,    33,   6,0,  25 },
    { 1956,   8,   5,    33,   6,0,  29 },
    { 1956,   8,   6,    33,   7,0,   1 },
    { 1956,   8,   7,    33,   7,0,   2 },
    { 1956,   8,  23,    33,   7,0,  18 },
    { 1956,   8,  31,    33,   7,0,  26 },
    { 1956,   9,   1,    33,   7,0,  27 },
    { 1956,   9,   4,    33,   7,0,  30 },
    { 1956,   9,   5,    33,   8,0,   1 },
    { 1956,   9,   6,    33,   8,0,   2 },
    { 1956,   9,   8,    33,   8,0,   4 },
    { 1956,   9,  23,    33,   8,0,  19 },
    { 1956,   9,  30,    33,   8,0,  26 },
    { 1956,  10,   1,    33,   8,0,  27 },
    { 1956,  10,   3,    33,   8,0,  29 },
    { 1956,  10,   4,    33,   9,0,   1 },
    { 1956,  10,   5,    33,   9,0,   2 },
    { 1956,  10,   8,    33,   9,0,   5 },
    { 1956,  10,  23,    33,   9,0,  20 },
    { 1956,  11,   2,    33,   9,0,  30 },
    { 1956,  11,   3,    33,  10,0,   1 },
    { 1956,  11,   4,    33,  10,0,   2 },
    { 1956,  11,   7,    33,  10,0,   5 },
    { 1956,  11,  22,    33,  10,0,  20 },
    { 1956,  12,   1,    33,  10,0,  29 },
    { 1956,  12,   2,    33,  11,0,   1 },
    { 1956,  12,   3,    33,  11,0,   2 },
    { 1956,  12,   7,    33,  11,0,   6 },
    { 1956,  12,  22,    33,  11,0,  21 },
    { 1956,  12,  31,    33,  11,0,  30 },

    { 1957,   1,   1,    33,  12,0,   1 },
    { 1957,   1,   5,    33,  12,0,   5 },
    { 1957,   1,  20,    33,  12,0,  20 },
    { 1957,   1,  30,    33,  12,0,  30 },
    { 1957,   1,  31,    34,   1,0,   1 },
    { 1957,   2,   1,    34,   1,0,   2 },
    { 1957,   2,   4,    34,   1,0,   5 },
    { 1957,   2,  19,    34,   1,0,  20 },
    { 1957,   3,   1,    34,   1,0,  30 },
    { 1957,   3,   2,    34,   2,0,   1 },
    { 1957,   3,   3,    34,   2,0,   2 },
    { 1957,   3,   6,    34,   2,0,   5 },
    { 1957,   3,  21,    34,   2,0,  20 },
    { 1957,   3,  30,    34,   2,0,  29 },
    { 1957,   3,  31,    34,   3,0,   1 },
    { 1957,   4,   1,    34,   3,0,   2 },
    { 1957,   4,   5,    34,   3,0,   6 },
    { 1957,   4,  20,    34,   3,0,  21 },
    { 1957,   4,  29,    34,   3,0,  30 },
    { 1957,   4,  30,    34,   4,0,   1 },
    { 1957,   5,   1,    34,   4,0,   2 },
    { 1957,   5,   6,    34,   4,0,   7 },
    { 1957,   5,  21,    34,   4,0,  22 },
    { 1957,   5,  28,    34,   4,0,  29 },
    { 1957,   5,  29,    34,   5,0,   1 },
    { 1957,   5,  30,    34,   5,0,   2 },
    { 1957,   5,  31,    34,   5,0,   3 },
    { 1957,   6,   1,    34,   5,0,   4 },
    { 1957,   6,   6,    34,   5,0,   9 },
    { 1957,   6,  22,    34,   5,0,  25 },
    { 1957,   6,  27,    34,   5,0,  30 },
    { 1957,   6,  28,    34,   6,0,   1 },
    { 1957,   6,  29,    34,   6,0,   2 },
    { 1957,   6,  30,    34,   6,0,   3 },
    { 1957,   7,   1,    34,   6,0,   4 },
    { 1957,   7,   7,    34,   6,0,  10 },
    { 1957,   7,  23,    34,   6,0,  26 },
    { 1957,   7,  26,    34,   6,0,  29 },
    { 1957,   7,  27,    34,   7,0,   1 },
    { 1957,   7,  28,    34,   7,0,   2 },
    { 1957,   7,  31,    34,   7,0,   5 },
    { 1957,   8,   1,    34,   7,0,   6 },
    { 1957,   8,   8,    34,   7,0,  13 },
    { 1957,   8,  23,    34,   7,0,  28 },
    { 1957,   8,  24,    34,   7,0,  29 },
    { 1957,   8,  25,    34,   8,0,   1 },
    { 1957,   8,  26,    34,   8,0,   2 },
    { 1957,   8,  31,    34,   8,0,   7 },
    { 1957,   9,   1,    34,   8,0,   8 },
    { 1957,   9,   8,    34,   8,0,  15 },
    { 1957,   9,  23,    34,   8,0,  30 },
    { 1957,   9,  24,    34,   8,1,   1 },
    { 1957,   9,  25,    34,   8,1,   2 },
    { 1957,   9,  30,    34,   8,1,   7 },
    { 1957,  10,   1,    34,   8,1,   8 },
    { 1957,  10,   8,    34,   8,1,  15 },
    { 1957,  10,  22,    34,   8,1,  29 },
    { 1957,  10,  23,    34,   9,0,   1 },
    { 1957,  10,  24,    34,   9,0,   2 },
    { 1957,  10,  31,    34,   9,0,   9 },
    { 1957,  11,   1,    34,   9,0,  10 },
    { 1957,  11,   8,    34,   9,0,  17 },
    { 1957,  11,  21,    34,   9,0,  30 },
    { 1957,  11,  22,    34,  10,0,   1 },
    { 1957,  11,  23,    34,  10,0,   2 },
    { 1957,  11,  30,    34,  10,0,   9 },
    { 1957,  12,   1,    34,  10,0,  10 },
    { 1957,  12,   7,    34,  10,0,  16 },
    { 1957,  12,  20,    34,  10,0,  29 },
    { 1957,  12,  21,    34,  11,0,   1 },
    { 1957,  12,  22,    34,  11,0,   2 },
    { 1957,  12,  31,    34,  11,0,  11 },

    { 1958,   1,   1,    34,  11,0,  12 },
    { 1958,   1,   6,    34,  11,0,  17 },
    { 1958,   1,  19,    34,  11,0,  30 },
    { 1958,   1,  20,    34,  12,0,   1 },
    { 1958,   1,  21,    34,  12,0,   2 },
    { 1958,   1,  31,    34,  12,0,  12 },
    { 1958,   2,   1,    34,  12,0,  13 },
    { 1958,   2,   4,    34,  12,0,  16 },
    { 1958,   2,  17,    34,  12,0,  29 },
    { 1958,   2,  18,    35,   1,0,   1 },
    { 1958,   2,  19,    35,   1,0,   2 },
    { 1958,   2,  28,    35,   1,0,  11 },
    { 1958,   3,   1,    35,   1,0,  12 },
    { 1958,   3,   6,    35,   1,0,  17 },
    { 1958,   3,  19,    35,   1,0,  30 },
    { 1958,   3,  20,    35,   2,0,   1 },
    { 1958,   3,  21,    35,   2,0,   2 },
    { 1958,   3,  31,    35,   2,0,  12 },
    { 1958,   4,   1,    35,   2,0,  13 },
    { 1958,   4,   5,    35,   2,0,  17 },
    { 1958,   4,  18,    35,   2,0,  30 },
    { 1958,   4,  19,    35,   3,0,   1 },
    { 1958,   4,  20,    35,   3,0,   2 },
    { 1958,   4,  30,    35,   3,0,  12 },
    { 1958,   5,   1,    35,   3,0,  13 },
    { 1958,   5,   6,    35,   3,0,  18 },
    { 1958,   5,  18,    35,   3,0,  30 },
    { 1958,   5,  19,    35,   4,0,   1 },
    { 1958,   5,  20,    35,   4,0,   2 },
    { 1958,   5,  21,    35,   4,0,   3 },
    { 1958,   5,  31,    35,   4,0,  13 },
    { 1958,   6,   1,    35,   4,0,  14 },
    { 1958,   6,   6,    35,   4,0,  19 },
    { 1958,   6,  16,    35,   4,0,  29 },
    { 1958,   6,  17,    35,   5,0,   1 },
    { 1958,   6,  18,    35,   5,0,   2 },
    { 1958,   6,  22,    35,   5,0,   6 },
    { 1958,   6,  30,    35,   5,0,  14 },
    { 1958,   7,   1,    35,   5,0,  15 },
    { 1958,   7,   7,    35,   5,0,  21 },
    { 1958,   7,  16,    35,   5,0,  30 },
    { 1958,   7,  17,    35,   6,0,   1 },
    { 1958,   7,  18,    35,   6,0,   2 },
    { 1958,   7,  23,    35,   6,0,   7 },
    { 1958,   7,  31,    35,   6,0,  15 },
    { 1958,   8,   1,    35,   6,0,  16 },
    { 1958,   8,   8,    35,   6,0,  23 },
    { 1958,   8,  14,    35,   6,0,  29 },
    { 1958,   8,  15,    35,   7,0,   1 },
    { 1958,   8,  16,    35,   7,0,   2 },
    { 1958,   8,  23,    35,   7,0,   9 },
    { 1958,   8,  31,    35,   7,0,  17 },
    { 1958,   9,   1,    35,   7,0,  18 },
    { 1958,   9,   8,    35,   7,0,  25 },
    { 1958,   9,  12,    35,   7,0,  29 },
    { 1958,   9,  13,    35,   8,0,   1 },
    { 1958,   9,  14,    35,   8,0,   2 },
    { 1958,   9,  23,    35,   8,0,  11 },
    { 1958,   9,  30,    35,   8,0,  18 },
    { 1958,  10,   1,    35,   8,0,  19 },
    { 1958,  10,   9,    35,   8,0,  27 },
    { 1958,  10,  12,    35,   8,0,  30 },
    { 1958,  10,  13,    35,   9,0,   1 },
    { 1958,  10,  14,    35,   9,0,   2 },
    { 1958,  10,  24,    35,   9,0,  12 },
    { 1958,  10,  31,    35,   9,0,  19 },
    { 1958,  11,   1,    35,   9,0,  20 },
    { 1958,  11,   8,    35,   9,0,  27 },
    { 1958,  11,  10,    35,   9,0,  29 },
    { 1958,  11,  11,    35,  10,0,   1 },
    { 1958,  11,  12,    35,  10,0,   2 },
    { 1958,  11,  23,    35,  10,0,  13 },
    { 1958,  11,  30,    35,  10,0,  20 },
    { 1958,  12,   1,    35,  10,0,  21 },
    { 1958,  12,   7,    35,  10,0,  27 },
    { 1958,  12,  10,    35,  10,0,  30 },
    { 1958,  12,  11,    35,  11,0,   1 },
    { 1958,  12,  12,    35,  11,0,   2 },
    { 1958,  12,  22,    35,  11,0,  12 },
    { 1958,  12,  31,    35,  11,0,  21 },

    { 1959,   1,   1,    35,  11,0,  22 },
    { 1959,   1,   6,    35,  11,0,  27 },
    { 1959,   1,   8,    35,  11,0,  29 },
    { 1959,   1,   9,    35,  12,0,   1 },
    { 1959,   1,  10,    35,  12,0,   2 },
    { 1959,   1,  21,    35,  12,0,  13 },
    { 1959,   1,  31,    35,  12,0,  23 },
    { 1959,   2,   1,    35,  12,0,  24 },
    { 1959,   2,   4,    35,  12,0,  27 },
    { 1959,   2,   7,    35,  12,0,  30 },
    { 1959,   2,   8,    36,   1,0,   1 },
    { 1959,   2,   9,    36,   1,0,   2 },
    { 1959,   2,  19,    36,   1,0,  12 },
    { 1959,   2,  28,    36,   1,0,  21 },
    { 1959,   3,   1,    36,   1,0,  22 },
    { 1959,   3,   6,    36,   1,0,  27 },
    { 1959,   3,   8,    36,   1,0,  29 },
    { 1959,   3,   9,    36,   2,0,   1 },
    { 1959,   3,  10,    36,   2,0,   2 },
    { 1959,   3,  21,    36,   2,0,  13 },
    { 1959,   3,  31,    36,   2,0,  23 },
    { 1959,   4,   1,    36,   2,0,  24 },
    { 1959,   4,   5,    36,   2,0,  28 },
    { 1959,   4,   7,    36,   2,0,  30 },
    { 1959,   4,   8,    36,   3,0,   1 },
    { 1959,   4,   9,    36,   3,0,   2 },
    { 1959,   4,  21,    36,   3,0,  14 },
    { 1959,   4,  30,    36,   3,0,  23 },
    { 1959,   5,   1,    36,   3,0,  24 },
    { 1959,   5,   6,    36,   3,0,  29 },
    { 1959,   5,   7,    36,   3,0,  30 },
    { 1959,   5,   8,    36,   4,0,   1 },
    { 1959,   5,   9,    36,   4,0,   2 },
    { 1959,   5,  22,    36,   4,0,  15 },
    { 1959,   5,  31,    36,   4,0,  24 },
    { 1959,   6,   1,    36,   4,0,  25 },
    { 1959,   6,   5,    36,   4,0,  29 },
    { 1959,   6,   6,    36,   5,0,   1 },
    { 1959,   6,   7,    36,   5,0,   2 },
    { 1959,   6,  22,    36,   5,0,  17 },
    { 1959,   6,  30,    36,   5,0,  25 },
    { 1959,   7,   1,    36,   5,0,  26 },
    { 1959,   7,   5,    36,   5,0,  30 },
    { 1959,   7,   6,    36,   6,0,   1 },
    { 1959,   7,   7,    36,   6,0,   2 },
    { 1959,   7,   8,    36,   6,0,   3 },
    { 1959,   7,  23,    36,   6,0,  18 },
    { 1959,   7,  31,    36,   6,0,  26 },
    { 1959,   8,   1,    36,   6,0,  27 },
    { 1959,   8,   3,    36,   6,0,  29 },
    { 1959,   8,   4,    36,   7,0,   1 },
    { 1959,   8,   5,    36,   7,0,   2 },
    { 1959,   8,   8,    36,   7,0,   5 },
    { 1959,   8,  24,    36,   7,0,  21 },
    { 1959,   9,   2,    36,   7,0,  30 },
    { 1959,   9,   3,    36,   8,0,   1 },
    { 1959,   9,   4,    36,   8,0,   2 },
    { 1959,   9,   8,    36,   8,0,   6 },
    { 1959,   9,  24,    36,   8,0,  22 },
    { 1959,  10,   1,    36,   8,0,  29 },
    { 1959,  10,   2,    36,   9,0,   1 },
    { 1959,  10,   3,    36,   9,0,   2 },
    { 1959,  10,   9,    36,   9,0,   8 },
    { 1959,  10,  24,    36,   9,0,  23 },
    { 1959,  10,  31,    36,   9,0,  30 },
    { 1959,  11,   1,    36,  10,0,   1 },
    { 1959,  11,   8,    36,  10,0,   8 },
    { 1959,  11,  23,    36,  10,0,  23 },
    { 1959,  11,  29,    36,  10,0,  29 },
    { 1959,  11,  30,    36,  11,0,   1 },
    { 1959,  12,   1,    36,  11,0,   2 },
    { 1959,  12,   8,    36,  11,0,   9 },
    { 1959,  12,  22,    36,  11,0,  23 },
    { 1959,  12,  29,    36,  11,0,  30 },
    { 1959,  12,  30,    36,  12,0,   1 },
    { 1959,  12,  31,    36,  12,0,   2 },

    { 1960,   1,   1,    36,  12,0,   3 },
    { 1960,   1,   6,    36,  12,0,   8 },
    { 1960,   1,  21,    36,  12,0,  23 },
    { 1960,   1,  27,    36,  12,0,  29 },
    { 1960,   1,  28,    37,   1,0,   1 },
    { 1960,   1,  29,    37,   1,0,   2 },
    { 1960,   1,  31,    37,   1,0,   4 },
    { 1960,   2,   1,    37,   1,0,   5 },
    { 1960,   2,   5,    37,   1,0,   9 },
    { 1960,   2,  19,    37,   1,0,  23 },
    { 1960,   2,  26,    37,   1,0,  30 },
    { 1960,   2,  27,    37,   2,0,   1 },
    { 1960,   2,  28,    37,   2,0,   2 },
    { 1960,   2,  29,    37,   2,0,   3 },
    { 1960,   3,   1,    37,   2,0,   4 },
    { 1960,   3,   5,    37,   2,0,   8 },
    { 1960,   3,  20,    37,   2,0,  23 },
    { 1960,   3,  26,    37,   2,0,  29 },
    { 1960,   3,  27,    37,   3,0,   1 },
    { 1960,   3,  28,    37,   3,0,   2 },
    { 1960,   3,  31,    37,   3,0,   5 },
    { 1960,   4,   1,    37,   3,0,   6 },
    { 1960,   4,   5,    37,   3,0,  10 },
    { 1960,   4,  20,    37,   3,0,  25 },
    { 1960,   4,  25,    37,   3,0,  30 },
    { 1960,   4,  26,    37,   4,0,   1 },
    { 1960,   4,  27,    37,   4,0,   2 },
    { 1960,   4,  30,    37,   4,0,   5 },
    { 1960,   5,   1,    37,   4,0,   6 },
    { 1960,   5,   5,    37,   4,0,  10 },
    { 1960,   5,  21,    37,   4,0,  26 },
    { 1960,   5,  24,    37,   4,0,  29 },
    { 1960,   5,  25,    37,   5,0,   1 },
    { 1960,   5,  26,    37,   5,0,   2 },
    { 1960,   5,  31,    37,   5,0,   7 },
    { 1960,   6,   1,    37,   5,0,   8 },
    { 1960,   6,   6,    37,   5,0,  13 },
    { 1960,   6,  21,    37,   5,0,  28 },
    { 1960,   6,  23,    37,   5,0,  30 },
    { 1960,   6,  24,    37,   6,0,   1 },
    { 1960,   6,  25,    37,   6,0,   2 },
    { 1960,   6,  30,    37,   6,0,   7 },
    { 1960,   7,   1,    37,   6,0,   8 },
    { 1960,   7,   7,    37,   6,0,  14 },
    { 1960,   7,  23,    37,   6,0,  30 },
    { 1960,   7,  24,    37,   6,1,   1 },
    { 1960,   7,  25,    37,   6,1,   2 },
    { 1960,   7,  31,    37,   6,1,   8 },
    { 1960,   8,   1,    37,   6,1,   9 },
    { 1960,   8,   7,    37,   6,1,  15 },
    { 1960,   8,  21,    37,   6,1,  29 },
    { 1960,   8,  22,    37,   7,0,   1 },
    { 1960,   8,  23,    37,   7,0,   2 },
    { 1960,   8,  31,    37,   7,0,  10 },
    { 1960,   9,   1,    37,   7,0,  11 },
    { 1960,   9,   7,    37,   7,0,  17 },
    { 1960,   9,  20,    37,   7,0,  30 },
    { 1960,   9,  21,    37,   8,0,   1 },
    { 1960,   9,  22,    37,   8,0,   2 },
    { 1960,   9,  23,    37,   8,0,   3 },
    { 1960,   9,  30,    37,   8,0,  10 },
    { 1960,  10,   1,    37,   8,0,  11 },
    { 1960,  10,   8,    37,   8,0,  18 },
    { 1960,  10,  19,    37,   8,0,  29 },
    { 1960,  10,  20,    37,   9,0,   1 },
    { 1960,  10,  21,    37,   9,0,   2 },
    { 1960,  10,  23,    37,   9,0,   4 },
    { 1960,  10,  31,    37,   9,0,  12 },
    { 1960,  11,   1,    37,   9,0,  13 },
    { 1960,  11,   7,    37,   9,0,  19 },
    { 1960,  11,  18,    37,   9,0,  30 },
    { 1960,  11,  19,    37,  10,0,   1 },
    { 1960,  11,  20,    37,  10,0,   2 },
    { 1960,  11,  22,    37,  10,0,   4 },
    { 1960,  11,  30,    37,  10,0,  12 },
    { 1960,  12,   1,    37,  10,0,  13 },
    { 1960,  12,   7,    37,  10,0,  19 },
    { 1960,  12,  17,    37,  10,0,  29 },
    { 1960,  12,  18,    37,  11,0,   1 },
    { 1960,  12,  19,    37,  11,0,   2 },
    { 1960,  12,  22,    37,  11,0,   5 },
    { 1960,  12,  31,    37,  11,0,  14 },
    { 1961,   1,   1,    37,  11,0,  15 },
    { 1961,   1,   5,    37,  11,0,  19 },
    { 1961,   1,  16,    37,  11,0,  30 },
    { 1961,   1,  17,    37,  12,0,   1 },
    { 1961,   1,  18,    37,  12,0,   2 },
    { 1961,   1,  20,    37,  12,0,   4 },
    { 1961,   1,  31,    37,  12,0,  15 },
    { 1961,   2,   1,    37,  12,0,  16 },
    { 1961,   2,   4,    37,  12,0,  19 },
    { 1961,   2,  14,    37,  12,0,  29 },
    { 1961,   2,  15,    38,   1,0,   1 },
    { 1961,   2,  16,    38,   1,0,   2 },
    { 1961,   2,  19,    38,   1,0,   5 },
    { 1961,   2,  28,    38,   1,0,  14 },
    { 1961,   3,   1,    38,   1,0,  15 },
    { 1961,   3,   6,    38,   1,0,  20 },
    { 1961,   3,  16,    38,   1,0,  30 },
    { 1961,   3,  17,    38,   2,0,   1 },
    { 1961,   3,  18,    38,   2,0,   2 },
    { 1961,   3,  21,    38,   2,0,   5 },
    { 1961,   3,  31,    38,   2,0,  15 },
    { 1961,   4,   1,    38,   2,0,  16 },
    { 1961,   4,   5,    38,   2,0,  20 },
    { 1961,   4,  14,    38,   2,0,  29 },
    { 1961,   4,  15,    38,   3,0,   1 },
    { 1961,   4,  16,    38,   3,0,   2 },
    { 1961,   4,  20,    38,   3,0,   6 },
    { 1961,   4,  30,    38,   3,0,  16 },
    { 1961,   5,   1,    38,   3,0,  17 },
    { 1961,   5,   6,    38,   3,0,  22 },
    { 1961,   5,  14,    38,   3,0,  30 },
    { 1961,   5,  15,    38,   4,0,   1 },
    { 1961,   5,  16,    38,   4,0,   2 },
    { 1961,   5,  21,    38,   4,0,   7 },
    { 1961,   5,  31,    38,   4,0,  17 },
    { 1961,   6,   1,    38,   4,0,  18 },
    { 1961,   6,   6,    38,   4,0,  23 },
    { 1961,   6,  12,    38,   4,0,  29 },
    { 1961,   6,  13,    38,   5,0,   1 },
    { 1961,   6,  14,    38,   5,0,   2 },
    { 1961,   6,  21,    38,   5,0,   9 },
    { 1961,   6,  30,    38,   5,0,  18 },
    { 1961,   7,   1,    38,   5,0,  19 },
    { 1961,   7,   7,    38,   5,0,  25 },
    { 1961,   7,  12,    38,   5,0,  30 },
    { 1961,   7,  13,    38,   6,0,   1 },
    { 1961,   7,  14,    38,   6,0,   2 },
    { 1961,   7,  23,    38,   6,0,  11 },
    { 1961,   7,  31,    38,   6,0,  19 },
    { 1961,   8,   1,    38,   6,0,  20 },
    { 1961,   8,   8,    38,   6,0,  27 },
    { 1961,   8,  10,    38,   6,0,  29 },
    { 1961,   8,  11,    38,   7,0,   1 },
    { 1961,   8,  12,    38,   7,0,   2 },
    { 1961,   8,  23,    38,   7,0,  13 },
    { 1961,   8,  31,    38,   7,0,  21 },
    { 1961,   9,   1,    38,   7,0,  22 },
    { 1961,   9,   8,    38,   7,0,  29 },
    { 1961,   9,   9,    38,   7,0,  30 },
    { 1961,   9,  10,    38,   8,0,   1 },
    { 1961,   9,  11,    38,   8,0,   2 },
    { 1961,   9,  23,    38,   8,0,  14 },
    { 1961,   9,  30,    38,   8,0,  21 },
    { 1961,  10,   1,    38,   8,0,  22 },
    { 1961,  10,   8,    38,   8,0,  29 },
    { 1961,  10,   9,    38,   8,0,  30 },
    { 1961,  10,  10,    38,   9,0,   1 },
    { 1961,  10,  11,    38,   9,0,   2 },
    { 1961,  10,  23,    38,   9,0,  14 },
    { 1961,  10,  31,    38,   9,0,  22 },
    { 1961,  11,   1,    38,   9,0,  23 },
    { 1961,  11,   7,    38,   9,0,  29 },
    { 1961,  11,   8,    38,  10,0,   1 },
    { 1961,  11,   9,    38,  10,0,   2 },
    { 1961,  11,  22,    38,  10,0,  15 },
    { 1961,  11,  30,    38,  10,0,  23 },
    { 1961,  12,   1,    38,  10,0,  24 },
    { 1961,  12,   7,    38,  10,0,  30 },
    { 1961,  12,   8,    38,  11,0,   1 },
    { 1961,  12,   9,    38,  11,0,   2 },
    { 1961,  12,  22,    38,  11,0,  15 },
    { 1961,  12,  31,    38,  11,0,  24 },
    { 1962,   1,   1,    38,  11,0,  25 },
    { 1962,   1,   5,    38,  11,0,  29 },
    { 1962,   1,   6,    38,  12,0,   1 },
    { 1962,   1,   7,    38,  12,0,   2 },
    { 1962,   1,  20,    38,  12,0,  15 },
    { 1962,   1,  31,    38,  12,0,  26 },
    { 1962,   2,   1,    38,  12,0,  27 },
    { 1962,   2,   4,    38,  12,0,  30 },
    { 1962,   2,   5,    39,   1,0,   1 },
    { 1962,   2,   6,    39,   1,0,   2 },
    { 1962,   2,  19,    39,   1,0,  15 },
    { 1962,   2,  28,    39,   1,0,  24 },
    { 1962,   3,   1,    39,   1,0,  25 },
    { 1962,   3,   5,    39,   1,0,  29 },
    { 1962,   3,   6,    39,   2,0,   1 },
    { 1962,   3,   7,    39,   2,0,   2 },
    { 1962,   3,  21,    39,   2,0,  16 },
    { 1962,   3,  31,    39,   2,0,  26 },
    { 1962,   4,   1,    39,   2,0,  27 },
    { 1962,   4,   4,    39,   2,0,  30 },
    { 1962,   4,   5,    39,   3,0,   1 },
    { 1962,   4,   6,    39,   3,0,   2 },
    { 1962,   4,  20,    39,   3,0,  16 },
    { 1962,   4,  30,    39,   3,0,  26 },
    { 1962,   5,   1,    39,   3,0,  27 },
    { 1962,   5,   3,    39,   3,0,  29 },
    { 1962,   5,   4,    39,   4,0,   1 },
    { 1962,   5,   5,    39,   4,0,   2 },
    { 1962,   5,   6,    39,   4,0,   3 },
    { 1962,   5,  21,    39,   4,0,  18 },
    { 1962,   6,   1,    39,   4,0,  29 },
    { 1962,   6,   2,    39,   5,0,   1 },
    { 1962,   6,   3,    39,   5,0,   2 },
    { 1962,   6,   6,    39,   5,0,   5 },
    { 1962,   6,  22,    39,   5,0,  21 },
    { 1962,   7,   1,    39,   5,0,  30 },
    { 1962,   7,   2,    39,   6,0,   1 },
    { 1962,   7,   3,    39,   6,0,   2 },
    { 1962,   7,   7,    39,   6,0,   6 },
    { 1962,   7,  23,    39,   6,0,  22 },
    { 1962,   7,  30,    39,   6,0,  29 },
    { 1962,   7,  31,    39,   7,0,   1 },
    { 1962,   8,   1,    39,   7,0,   2 },
    { 1962,   8,   8,    39,   7,0,   9 },
    { 1962,   8,  23,    39,   7,0,  24 },
    { 1962,   8,  29,    39,   7,0,  30 },
    { 1962,   8,  30,    39,   8,0,   1 },
    { 1962,   8,  31,    39,   8,0,   2 },
    { 1962,   9,   1,    39,   8,0,   3 },
    { 1962,   9,   8,    39,   8,0,  10 },
    { 1962,   9,  23,    39,   8,0,  25 },
    { 1962,   9,  28,    39,   8,0,  30 },
    { 1962,   9,  29,    39,   9,0,   1 },
    { 1962,   9,  30,    39,   9,0,   2 },
    { 1962,  10,   1,    39,   9,0,   3 },
    { 1962,  10,   9,    39,   9,0,  11 },
    { 1962,  10,  24,    39,   9,0,  26 },
    { 1962,  10,  27,    39,   9,0,  29 },
    { 1962,  10,  28,    39,  10,0,   1 },
    { 1962,  10,  29,    39,  10,0,   2 },
    { 1962,  10,  31,    39,  10,0,   4 },
    { 1962,  11,   1,    39,  10,0,   5 },
    { 1962,  11,   8,    39,  10,0,  12 },
    { 1962,  11,  23,    39,  10,0,  27 },
    { 1962,  11,  26,    39,  10,0,  30 },
    { 1962,  11,  27,    39,  11,0,   1 },
    { 1962,  11,  28,    39,  11,0,   2 },
    { 1962,  11,  30,    39,  11,0,   4 },
    { 1962,  12,   1,    39,  11,0,   5 },
    { 1962,  12,   7,    39,  11,0,  11 },
    { 1962,  12,  22,    39,  11,0,  26 },
    { 1962,  12,  26,    39,  11,0,  30 },
    { 1962,  12,  27,    39,  12,0,   1 },
    { 1962,  12,  28,    39,  12,0,   2 },
    { 1962,  12,  31,    39,  12,0,   5 },
    { 1963,   1,   1,    39,  12,0,   6 },
    { 1963,   1,   6,    39,  12,0,  11 },
    { 1963,   1,  21,    39,  12,0,  26 },
    { 1963,   1,  24,    39,  12,0,  29 },
    { 1963,   1,  25,    40,   1,0,   1 },
    { 1963,   1,  26,    40,   1,0,   2 },
    { 1963,   1,  31,    40,   1,0,   7 },
    { 1963,   2,   1,    40,   1,0,   8 },
    { 1963,   2,   4,    40,   1,0,  11 },
    { 1963,   2,  19,    40,   1,0,  26 },
    { 1963,   2,  23,    40,   1,0,  30 },
    { 1963,   2,  24,    40,   2,0,   1 },
    { 1963,   2,  25,    40,   2,0,   2 },
    { 1963,   2,  28,    40,   2,0,   5 },
    { 1963,   3,   1,    40,   2,0,   6 },
    { 1963,   3,   6,    40,   2,0,  11 },
    { 1963,   3,  21,    40,   2,0,  26 },
    { 1963,   3,  24,    40,   2,0,  29 },
    { 1963,   3,  25,    40,   3,0,   1 },
    { 1963,   3,  26,    40,   3,0,   2 },
    { 1963,   3,  31,    40,   3,0,   7 },
    { 1963,   4,   1,    40,   3,0,   8 },
    { 1963,   4,   5,    40,   3,0,  12 },
    { 1963,   4,  21,    40,   3,0,  28 },
    { 1963,   4,  23,    40,   3,0,  30 },
    { 1963,   4,  24,    40,   4,0,   1 },
    { 1963,   4,  25,    40,   4,0,   2 },
    { 1963,   4,  30,    40,   4,0,   7 },
    { 1963,   5,   1,    40,   4,0,   8 },
    { 1963,   5,   6,    40,   4,0,  13 },
    { 1963,   5,  22,    40,   4,0,  29 },
    { 1963,   5,  23,    40,   4,1,   1 },
    { 1963,   5,  24,    40,   4,1,   2 },
    { 1963,   5,  31,    40,   4,1,   9 },
    { 1963,   6,   1,    40,   4,1,  10 },
    { 1963,   6,   6,    40,   4,1,  15 },
    { 1963,   6,  20,    40,   4,1,  29 },
    { 1963,   6,  21,    40,   5,0,   1 },
    { 1963,   6,  22,    40,   5,0,   2 },
    { 1963,   6,  30,    40,   5,0,  10 },
    { 1963,   7,   1,    40,   5,0,  11 },
    { 1963,   7,   8,    40,   5,0,  18 },
    { 1963,   7,  20,    40,   5,0,  30 },
    { 1963,   7,  21,    40,   6,0,   1 },
    { 1963,   7,  22,    40,   6,0,   2 },
    { 1963,   7,  23,    40,   6,0,   3 },
    { 1963,   7,  31,    40,   6,0,  11 },
    { 1963,   8,   1,    40,   6,0,  12 },
    { 1963,   8,   8,    40,   6,0,  19 },
    { 1963,   8,  18,    40,   6,0,  29 },
    { 1963,   8,  19,    40,   7,0,   1 },
    { 1963,   8,  20,    40,   7,0,   2 },
    { 1963,   8,  24,    40,   7,0,   6 },
    { 1963,   8,  31,    40,   7,0,  13 },
    { 1963,   9,   1,    40,   7,0,  14 },
    { 1963,   9,   8,    40,   7,0,  21 },
    { 1963,   9,  17,    40,   7,0,  30 },
    { 1963,   9,  18,    40,   8,0,   1 },
    { 1963,   9,  19,    40,   8,0,   2 },
    { 1963,   9,  24,    40,   8,0,   7 },
    { 1963,   9,  30,    40,   8,0,  13 },
    { 1963,  10,   1,    40,   8,0,  14 },
    { 1963,  10,   9,    40,   8,0,  22 },
    { 1963,  10,  16,    40,   8,0,  29 },
    { 1963,  10,  17,    40,   9,0,   1 },
    { 1963,  10,  18,    40,   9,0,   2 },
    { 1963,  10,  24,    40,   9,0,   8 },
    { 1963,  10,  31,    40,   9,0,  15 },
    { 1963,  11,   1,    40,   9,0,  16 },
    { 1963,  11,   8,    40,   9,0,  23 },
    { 1963,  11,  15,    40,   9,0,  30 },
    { 1963,  11,  16,    40,  10,0,   1 },
    { 1963,  11,  17,    40,  10,0,   2 },
    { 1963,  11,  23,    40,  10,0,   8 },
    { 1963,  11,  30,    40,  10,0,  15 },
    { 1963,  12,   1,    40,  10,0,  16 },
    { 1963,  12,   8,    40,  10,0,  23 },
    { 1963,  12,  15,    40,  10,0,  30 },
    { 1963,  12,  16,    40,  11,0,   1 },
    { 1963,  12,  17,    40,  11,0,   2 },
    { 1963,  12,  22,    40,  11,0,   7 },
    { 1963,  12,  31,    40,  11,0,  16 },
    { 1964,   1,   1,    40,  11,0,  17 },
    { 1964,   1,   6,    40,  11,0,  22 },
    { 1964,   1,  14,    40,  11,0,  30 },
    { 1964,   1,  15,    40,  12,0,   1 },
    { 1964,   1,  16,    40,  12,0,   2 },
    { 1964,   1,  21,    40,  12,0,   7 },
    { 1964,   1,  31,    40,  12,0,  17 },
    { 1964,   2,   1,    40,  12,0,  18 },
    { 1964,   2,   5,    40,  12,0,  22 },
    { 1964,   2,  12,    40,  12,0,  29 },
    { 1964,   2,  13,    41,   1,0,   1 },
    { 1964,   2,  14,    41,   1,0,   2 },
    { 1964,   2,  19,    41,   1,0,   7 },
    { 1964,   2,  29,    41,   1,0,  17 },
    { 1964,   3,   1,    41,   1,0,  18 },
    { 1964,   3,   5,    41,   1,0,  22 },
    { 1964,   3,  13,    41,   1,0,  30 },
    { 1964,   3,  14,    41,   2,0,   1 },
    { 1964,   3,  15,    41,   2,0,   2 },
    { 1964,   3,  20,    41,   2,0,   7 },
    { 1964,   3,  31,    41,   2,0,  18 },
    { 1964,   4,   1,    41,   2,0,  19 },
    { 1964,   4,   5,    41,   2,0,  23 },
    { 1964,   4,  11,    41,   2,0,  29 },
    { 1964,   4,  12,    41,   3,0,   1 },
    { 1964,   4,  13,    41,   3,0,   2 },
    { 1964,   4,  20,    41,   3,0,   9 },
    { 1964,   4,  30,    41,   3,0,  19 },
    { 1964,   5,   1,    41,   3,0,  20 },
    { 1964,   5,   5,    41,   3,0,  24 },
    { 1964,   5,  11,    41,   3,0,  30 },
    { 1964,   5,  12,    41,   4,0,   1 },
    { 1964,   5,  13,    41,   4,0,   2 },
    { 1964,   5,  21,    41,   4,0,  10 },
    { 1964,   5,  31,    41,   4,0,  20 },
    { 1964,   6,   1,    41,   4,0,  21 },
    { 1964,   6,   6,    41,   4,0,  26 },
    { 1964,   6,   9,    41,   4,0,  29 },
    { 1964,   6,  10,    41,   5,0,   1 },
    { 1964,   6,  11,    41,   5,0,   2 },
    { 1964,   6,  21,    41,   5,0,  12 },
    { 1964,   6,  30,    41,   5,0,  21 },
    { 1964,   7,   1,    41,   5,0,  22 },
    { 1964,   7,   7,    41,   5,0,  28 },
    { 1964,   7,   8,    41,   5,0,  29 },
    { 1964,   7,   9,    41,   6,0,   1 },
    { 1964,   7,  10,    41,   6,0,   2 },
    { 1964,   7,  23,    41,   6,0,  15 },
    { 1964,   7,  31,    41,   6,0,  23 },
    { 1964,   8,   1,    41,   6,0,  24 },
    { 1964,   8,   7,    41,   6,0,  30 },
    { 1964,   8,   8,    41,   7,0,   1 },
    { 1964,   8,   9,    41,   7,0,   2 },
    { 1964,   8,  23,    41,   7,0,  16 },
    { 1964,   8,  31,    41,   7,0,  24 },
    { 1964,   9,   1,    41,   7,0,  25 },
    { 1964,   9,   5,    41,   7,0,  29 },
    { 1964,   9,   6,    41,   8,0,   1 },
    { 1964,   9,   7,    41,   8,0,   2 },
    { 1964,   9,  23,    41,   8,0,  18 },
    { 1964,   9,  30,    41,   8,0,  25 },
    { 1964,  10,   1,    41,   8,0,  26 },
    { 1964,  10,   5,    41,   8,0,  30 },
    { 1964,  10,   6,    41,   9,0,   1 },
    { 1964,  10,   7,    41,   9,0,   2 },
    { 1964,  10,   8,    41,   9,0,   3 },
    { 1964,  10,  23,    41,   9,0,  18 },
    { 1964,  10,  31,    41,   9,0,  26 },
    { 1964,  11,   1,    41,   9,0,  27 },
    { 1964,  11,   3,    41,   9,0,  29 },
    { 1964,  11,   4,    41,  10,0,   1 },
    { 1964,  11,   5,    41,  10,0,   2 },
    { 1964,  11,   7,    41,  10,0,   4 },
    { 1964,  11,  22,    41,  10,0,  19 },
    { 1964,  11,  30,    41,  10,0,  27 },
    { 1964,  12,   1,    41,  10,0,  28 },
    { 1964,  12,   3,    41,  10,0,  30 },
    { 1964,  12,   4,    41,  11,0,   1 },
    { 1964,  12,   5,    41,  11,0,   2 },
    { 1964,  12,   7,    41,  11,0,   4 },
    { 1964,  12,  22,    41,  11,0,  19 },
    { 1965,   1,   2,    41,  11,0,  30 },
    { 1965,   1,   3,    41,  12,0,   1 },
    { 1965,   1,   4,    41,  12,0,   2 },
    { 1965,   1,   5,    41,  12,0,   3 },
    { 1965,   1,  20,    41,  12,0,  18 },
    { 1965,   2,   1,    41,  12,0,  30 },
    { 1965,   2,   2,    42,   1,0,   1 },
    { 1965,   2,   3,    42,   1,0,   2 },
    { 1965,   2,   4,    42,   1,0,   3 },
    { 1965,   2,  19,    42,   1,0,  18 },
    { 1965,   3,   2,    42,   1,0,  29 },
    { 1965,   3,   3,    42,   2,0,   1 },
    { 1965,   3,   4,    42,   2,0,   2 },
    { 1965,   3,   6,    42,   2,0,   4 },
    { 1965,   3,  21,    42,   2,0,  19 },
    { 1965,   4,   1,    42,   2,0,  30 },
    { 1965,   4,   2,    42,   3,0,   1 },
    { 1965,   4,   3,    42,   3,0,   2 },
    { 1965,   4,   5,    42,   3,0,   4 },
    { 1965,   4,  20,    42,   3,0,  19 },
    { 1965,   4,  30,    42,   3,0,  29 },
    { 1965,   5,   1,    42,   4,0,   1 },
    { 1965,   5,   6,    42,   4,0,   6 },
    { 1965,   5,  21,    42,   4,0,  21 },
    { 1965,   5,  30,    42,   4,0,  30 },
    { 1965,   5,  31,    42,   5,0,   1 },
    { 1965,   6,   1,    42,   5,0,   2 },
    { 1965,   6,   6,    42,   5,0,   7 },
    { 1965,   6,  21,    42,   5,0,  22 },
    { 1965,   6,  28,    42,   5,0,  29 },
    { 1965,   6,  29,    42,   6,0,   1 },
    { 1965,   6,  30,    42,   6,0,   2 },
    { 1965,   7,   1,    42,   6,0,   3 },
    { 1965,   7,   7,    42,   6,0,   9 },
    { 1965,   7,  23,    42,   6,0,  25 },
    { 1965,   7,  27,    42,   6,0,  29 },
    { 1965,   7,  28,    42,   7,0,   1 },
    { 1965,   7,  29,    42,   7,0,   2 },
    { 1965,   7,  31,    42,   7,0,   4 },
    { 1965,   8,   1,    42,   7,0,   5 },
    { 1965,   8,   8,    42,   7,0,  12 },
    { 1965,   8,  23,    42,   7,0,  27 },
    { 1965,   8,  26,    42,   7,0,  30 },
    { 1965,   8,  27,    42,   8,0,   1 },
    { 1965,   8,  28,    42,   8,0,   2 },
    { 1965,   8,  31,    42,   8,0,   5 },
    { 1965,   9,   1,    42,   8,0,   6 },
    { 1965,   9,   8,    42,   8,0,  13 },
    { 1965,   9,  23,    42,   8,0,  28 },
    { 1965,   9,  24,    42,   8,0,  29 },
    { 1965,   9,  25,    42,   9,0,   1 },
    { 1965,   9,  26,    42,   9,0,   2 },
    { 1965,   9,  30,    42,   9,0,   6 },
    { 1965,  10,   1,    42,   9,0,   7 },
    { 1965,  10,   8,    42,   9,0,  14 },
    { 1965,  10,  23,    42,   9,0,  29 },
    { 1965,  10,  24,    42,  10,0,   1 },
    { 1965,  10,  25,    42,  10,0,   2 },
    { 1965,  10,  31,    42,  10,0,   8 },
    { 1965,  11,   1,    42,  10,0,   9 },
    { 1965,  11,   7,    42,  10,0,  15 },
    { 1965,  11,  22,    42,  10,0,  30 },
    { 1965,  11,  23,    42,  11,0,   1 },
    { 1965,  11,  24,    42,  11,0,   2 },
    { 1965,  11,  30,    42,  11,0,   8 },
    { 1965,  12,   1,    42,  11,0,   9 },
    { 1965,  12,   7,    42,  11,0,  15 },
    { 1965,  12,  22,    42,  11,0,  30 },
    { 1965,  12,  23,    42,  12,0,   1 },
    { 1965,  12,  24,    42,  12,0,   2 },
    { 1965,  12,  31,    42,  12,0,   9 },
    { 1966,   1,   1,    42,  12,0,  10 },
    { 1966,   1,   6,    42,  12,0,  15 },
    { 1966,   1,  20,    42,  12,0,  29 },
    { 1966,   1,  21,    43,   1,0,   1 },
    { 1966,   1,  22,    43,   1,0,   2 },
    { 1966,   1,  31,    43,   1,0,  11 },
    { 1966,   2,   1,    43,   1,0,  12 },
    { 1966,   2,   4,    43,   1,0,  15 },
    { 1966,   2,  19,    43,   1,0,  30 },
    { 1966,   2,  20,    43,   2,0,   1 },
    { 1966,   2,  21,    43,   2,0,   2 },
    { 1966,   2,  28,    43,   2,0,   9 },
    { 1966,   3,   1,    43,   2,0,  10 },
    { 1966,   3,   6,    43,   2,0,  15 },
    { 1966,   3,  21,    43,   2,0,  30 },
    { 1966,   3,  22,    43,   3,0,   1 },
    { 1966,   3,  23,    43,   3,0,   2 },
    { 1966,   3,  31,    43,   3,0,  10 },
    { 1966,   4,   1,    43,   3,0,  11 },
    { 1966,   4,   5,    43,   3,0,  15 },
    { 1966,   4,  20,    43,   3,0,  30 },
    { 1966,   4,  21,    43,   3,1,   1 },
    { 1966,   4,  22,    43,   3,1,   2 },
    { 1966,   4,  30,    43,   3,1,  10 },
    { 1966,   5,   1,    43,   3,1,  11 },
    { 1966,   5,   6,    43,   3,1,  16 },
    { 1966,   5,  19,    43,   3,1,  29 },
    { 1966,   5,  20,    43,   4,0,   1 },
    { 1966,   5,  21,    43,   4,0,   2 },
    { 1966,   5,  31,    43,   4,0,  12 },
    { 1966,   6,   1,    43,   4,0,  13 },
    { 1966,   6,   6,    43,   4,0,  18 },
    { 1966,   6,  18,    43,   4,0,  30 },
    { 1966,   6,  19,    43,   5,0,   1 },
    { 1966,   6,  20,    43,   5,0,   2 },
    { 1966,   6,  22,    43,   5,0,   4 },
    { 1966,   6,  30,    43,   5,0,  12 },
    { 1966,   7,   1,    43,   5,0,  13 },
    { 1966,   7,   7,    43,   5,0,  19 },
    { 1966,   7,  17,    43,   5,0,  29 },
    { 1966,   7,  18,    43,   6,0,   1 },
    { 1966,   7,  19,    43,   6,0,   2 },
    { 1966,   7,  23,    43,   6,0,   6 },
    { 1966,   7,  31,    43,   6,0,  14 },
    { 1966,   8,   1,    43,   6,0,  15 },
    { 1966,   8,   8,    43,   6,0,  22 },
    { 1966,   8,  15,    43,   6,0,  29 },
    { 1966,   8,  16,    43,   7,0,   1 },
    { 1966,   8,  17,    43,   7,0,   2 },
    { 1966,   8,  23,    43,   7,0,   8 },
    { 1966,   8,  31,    43,   7,0,  16 },
    { 1966,   9,   1,    43,   7,0,  17 },
    { 1966,   9,   8,    43,   7,0,  24 },
    { 1966,   9,  14,    43,   7,0,  30 },
    { 1966,   9,  15,    43,   8,0,   1 },
    { 1966,   9,  16,    43,   8,0,   2 },
    { 1966,   9,  23,    43,   8,0,   9 },
    { 1966,   9,  30,    43,   8,0,  16 },
    { 1966,  10,   1,    43,   8,0,  17 },
    { 1966,  10,   9,    43,   8,0,  25 },
    { 1966,  10,  13,    43,   8,0,  29 },
    { 1966,  10,  14,    43,   9,0,   1 },
    { 1966,  10,  15,    43,   9,0,   2 },
    { 1966,  10,  24,    43,   9,0,  11 },
    { 1966,  10,  31,    43,   9,0,  18 },
    { 1966,  11,   1,    43,   9,0,  19 },
    { 1966,  11,   8,    43,   9,0,  26 },
    { 1966,  11,  11,    43,   9,0,  29 },
    { 1966,  11,  12,    43,  10,0,   1 },
    { 1966,  11,  13,    43,  10,0,   2 },
    { 1966,  11,  23,    43,  10,0,  12 },
    { 1966,  11,  30,    43,  10,0,  19 },
    { 1966,  12,   1,    43,  10,0,  20 },
    { 1966,  12,   7,    43,  10,0,  26 },
    { 1966,  12,  11,    43,  10,0,  30 },
    { 1966,  12,  12,    43,  11,0,   1 },
    { 1966,  12,  13,    43,  11,0,   2 },
    { 1966,  12,  22,    43,  11,0,  11 },
    { 1966,  12,  31,    43,  11,0,  20 },
    { 1967,   1,   1,    43,  11,0,  21 },
    { 1967,   1,   6,    43,  11,0,  26 },
    { 1967,   1,  10,    43,  11,0,  30 },
    { 1967,   1,  11,    43,  12,0,   1 },
    { 1967,   1,  12,    43,  12,0,   2 },
    { 1967,   1,  21,    43,  12,0,  11 },
    { 1967,   1,  31,    43,  12,0,  21 },
    { 1967,   2,   1,    43,  12,0,  22 },
    { 1967,   2,   4,    43,  12,0,  25 },
    { 1967,   2,   8,    43,  12,0,  29 },
    { 1967,   2,   9,    44,   1,0,   1 },
    { 1967,   2,  10,    44,   1,0,   2 },
    { 1967,   2,  19,    44,   1,0,  11 },
    { 1967,   2,  28,    44,   1,0,  20 },
    { 1967,   3,   1,    44,   1,0,  21 },
    { 1967,   3,   6,    44,   1,0,  26 },
    { 1967,   3,  10,    44,   1,0,  30 },
    { 1967,   3,  11,    44,   2,0,   1 },
    { 1967,   3,  12,    44,   2,0,   2 },
    { 1967,   3,  21,    44,   2,0,  11 },
    { 1967,   3,  31,    44,   2,0,  21 },
    { 1967,   4,   1,    44,   2,0,  22 },
    { 1967,   4,   5,    44,   2,0,  26 },
    { 1967,   4,   9,    44,   2,0,  30 },
    { 1967,   4,  10,    44,   3,0,   1 },
    { 1967,   4,  11,    44,   3,0,   2 },
    { 1967,   4,  21,    44,   3,0,  12 },
    { 1967,   4,  30,    44,   3,0,  21 },
    { 1967,   5,   1,    44,   3,0,  22 },
    { 1967,   5,   6,    44,   3,0,  27 },
    { 1967,   5,   8,    44,   3,0,  29 },
    { 1967,   5,   9,    44,   4,0,   1 },
    { 1967,   5,  10,    44,   4,0,   2 },
    { 1967,   5,  22,    44,   4,0,  14 },
    { 1967,   5,  31,    44,   4,0,  23 },
    { 1967,   6,   1,    44,   4,0,  24 },
    { 1967,   6,   6,    44,   4,0,  29 },
    { 1967,   6,   7,    44,   4,0,  30 },
    { 1967,   6,   8,    44,   5,0,   1 },
    { 1967,   6,   9,    44,   5,0,   2 },
    { 1967,   6,  22,    44,   5,0,  15 },
    { 1967,   6,  30,    44,   5,0,  23 },
    { 1967,   7,   1,    44,   5,0,  24 },
    { 1967,   7,   7,    44,   5,0,  30 },
    { 1967,   7,   8,    44,   6,0,   1 },
    { 1967,   7,   9,    44,   6,0,   2 },
    { 1967,   7,  23,    44,   6,0,  16 },
    { 1967,   7,  31,    44,   6,0,  24 },
    { 1967,   8,   1,    44,   6,0,  25 },
    { 1967,   8,   5,    44,   6,0,  29 },
    { 1967,   8,   6,    44,   7,0,   1 },
    { 1967,   8,   7,    44,   7,0,   2 },
    { 1967,   8,   8,    44,   7,0,   3 },
    { 1967,   8,  24,    44,   7,0,  19 },
    { 1967,   8,  31,    44,   7,0,  26 },
    { 1967,   9,   1,    44,   7,0,  27 },
    { 1967,   9,   3,    44,   7,0,  29 },
    { 1967,   9,   4,    44,   8,0,   1 },
    { 1967,   9,   5,    44,   8,0,   2 },
    { 1967,   9,   8,    44,   8,0,   5 },
    { 1967,   9,  24,    44,   8,0,  21 },
    { 1967,   9,  30,    44,   8,0,  27 },
    { 1967,  10,   1,    44,   8,0,  28 },
    { 1967,  10,   3,    44,   8,0,  30 },
    { 1967,  10,   4,    44,   9,0,   1 },
    { 1967,  10,   5,    44,   9,0,   2 },
    { 1967,  10,   9,    44,   9,0,   6 },
    { 1967,  10,  24,    44,   9,0,  21 },
    { 1967,  11,   1,    44,   9,0,  29 },
    { 1967,  11,   2,    44,  10,0,   1 },
    { 1967,  11,   3,    44,  10,0,   2 },
    { 1967,  11,   8,    44,  10,0,   7 },
    { 1967,  11,  23,    44,  10,0,  22 },
    { 1967,  12,   1,    44,  10,0,  30 },
    { 1967,  12,   2,    44,  11,0,   1 },
    { 1967,  12,   3,    44,  11,0,   2 },
    { 1967,  12,   8,    44,  11,0,   7 },
    { 1967,  12,  22,    44,  11,0,  21 },
    { 1967,  12,  30,    44,  11,0,  29 },
    { 1967,  12,  31,    44,  12,0,   1 },
    { 1968,   1,   1,    44,  12,0,   2 },
    { 1968,   1,   6,    44,  12,0,   7 },
    { 1968,   1,  21,    44,  12,0,  22 },
    { 1968,   1,  29,    44,  12,0,  30 },
    { 1968,   1,  30,    45,   1,0,   1 },
    { 1968,   1,  31,    45,   1,0,   2 },
    { 1968,   2,   1,    45,   1,0,   3 },
    { 1968,   2,   5,    45,   1,0,   7 },
    { 1968,   2,  19,    45,   1,0,  21 },
    { 1968,   2,  27,    45,   1,0,  29 },
    { 1968,   2,  28,    45,   2,0,   1 },
    { 1968,   2,  29,    45,   2,0,   2 },
    { 1968,   3,   1,    45,   2,0,   3 },
    { 1968,   3,   5,    45,   2,0,   7 },
    { 1968,   3,  20,    45,   2,0,  22 },
    { 1968,   3,  28,    45,   2,0,  30 },
    { 1968,   3,  29,    45,   3,0,   1 },
    { 1968,   3,  30,    45,   3,0,   2 },
    { 1968,   3,  31,    45,   3,0,   3 },
    { 1968,   4,   1,    45,   3,0,   4 },
    { 1968,   4,   5,    45,   3,0,   8 },
    { 1968,   4,  20,    45,   3,0,  23 },
    { 1968,   4,  26,    45,   3,0,  29 },
    { 1968,   4,  27,    45,   4,0,   1 },
    { 1968,   4,  28,    45,   4,0,   2 },
    { 1968,   4,  30,    45,   4,0,   4 },
    { 1968,   5,   1,    45,   4,0,   5 },
    { 1968,   5,   5,    45,   4,0,   9 },
    { 1968,   5,  21,    45,   4,0,  25 },
    { 1968,   5,  26,    45,   4,0,  30 },
    { 1968,   5,  27,    45,   5,0,   1 },
    { 1968,   5,  28,    45,   5,0,   2 },
    { 1968,   5,  31,    45,   5,0,   5 },
    { 1968,   6,   1,    45,   5,0,   6 },
    { 1968,   6,   5,    45,   5,0,  10 },
    { 1968,   6,  21,    45,   5,0,  26 },
    { 1968,   6,  25,    45,   5,0,  30 },
    { 1968,   6,  26,    45,   6,0,   1 },
    { 1968,   6,  27,    45,   6,0,   2 },
    { 1968,   6,  30,    45,   6,0,   5 },
    { 1968,   7,   1,    45,   6,0,   6 },
    { 1968,   7,   7,    45,   6,0,  12 },
    { 1968,   7,  23,    45,   6,0,  28 },
    { 1968,   7,  24,    45,   6,0,  29 },
    { 1968,   7,  25,    45,   7,0,   1 },
    { 1968,   7,  26,    45,   7,0,   2 },
    { 1968,   7,  31,    45,   7,0,   7 },
    { 1968,   8,   1,    45,   7,0,   8 },
    { 1968,   8,   7,    45,   7,0,  14 },
    { 1968,   8,  23,    45,   7,0,  30 },
    { 1968,   8,  24,    45,   7,1,   1 },
    { 1968,   8,  25,    45,   7,1,   2 },
    { 1968,   8,  31,    45,   7,1,   8 },
    { 1968,   9,   1,    45,   7,1,   9 },
    { 1968,   9,   7,    45,   7,1,  15 },
    { 1968,   9,  21,    45,   7,1,  29 },
    { 1968,   9,  22,    45,   8,0,   1 },
    { 1968,   9,  23,    45,   8,0,   2 },
    { 1968,   9,  30,    45,   8,0,   9 },
    { 1968,  10,   1,    45,   8,0,  10 },
    { 1968,  10,   8,    45,   8,0,  17 },
    { 1968,  10,  21,    45,   8,0,  30 },
    { 1968,  10,  22,    45,   9,0,   1 },
    { 1968,  10,  23,    45,   9,0,   2 },
    { 1968,  10,  31,    45,   9,0,  10 },
    { 1968,  11,   1,    45,   9,0,  11 },
    { 1968,  11,   7,    45,   9,0,  17 },
    { 1968,  11,  19,    45,   9,0,  29 },
    { 1968,  11,  20,    45,  10,0,   1 },
    { 1968,  11,  21,    45,  10,0,   2 },
    { 1968,  11,  22,    45,  10,0,   3 },
    { 1968,  11,  30,    45,  10,0,  11 },
    { 1968,  12,   1,    45,  10,0,  12 },
    { 1968,  12,   7,    45,  10,0,  18 },
    { 1968,  12,  19,    45,  10,0,  30 },
    { 1968,  12,  20,    45,  11,0,   1 },
    { 1968,  12,  21,    45,  11,0,   2 },
    { 1968,  12,  22,    45,  11,0,   3 },
    { 1968,  12,  31,    45,  11,0,  12 },
    { 1969,   1,   1,    45,  11,0,  13 },
    { 1969,   1,   5,    45,  11,0,  17 },
    { 1969,   1,  17,    45,  11,0,  29 },
    { 1969,   1,  18,    45,  12,0,   1 },
    { 1969,   1,  19,    45,  12,0,   2 },
    { 1969,   1,  20,    45,  12,0,   3 },
    { 1969,   1,  31,    45,  12,0,  14 },
    { 1969,   2,   1,    45,  12,0,  15 },
    { 1969,   2,   4,    45,  12,0,  18 },
    { 1969,   2,  16,    45,  12,0,  30 },
    { 1969,   2,  17,    46,   1,0,   1 },
    { 1969,   2,  18,    46,   1,0,   2 },
    { 1969,   2,  19,    46,   1,0,   3 },
    { 1969,   2,  28,    46,   1,0,  12 },
    { 1969,   3,   1,    46,   1,0,  13 },
    { 1969,   3,   6,    46,   1,0,  18 },
    { 1969,   3,  17,    46,   1,0,  29 },
    { 1969,   3,  18,    46,   2,0,   1 },
    { 1969,   3,  19,    46,   2,0,   2 },
    { 1969,   3,  21,    46,   2,0,   4 },
    { 1969,   3,  31,    46,   2,0,  14 },
    { 1969,   4,   1,    46,   2,0,  15 },
    { 1969,   4,   5,    46,   2,0,  19 },
    { 1969,   4,  16,    46,   2,0,  30 },
    { 1969,   4,  17,    46,   3,0,   1 },
    { 1969,   4,  18,    46,   3,0,   2 },
    { 1969,   4,  20,    46,   3,0,   4 },
    { 1969,   4,  30,    46,   3,0,  14 },
    { 1969,   5,   1,    46,   3,0,  15 },
    { 1969,   5,   6,    46,   3,0,  20 },
    { 1969,   5,  15,    46,   3,0,  29 },
    { 1969,   5,  16,    46,   4,0,   1 },
    { 1969,   5,  17,    46,   4,0,   2 },
    { 1969,   5,  21,    46,   4,0,   6 },
    { 1969,   5,  31,    46,   4,0,  16 },
    { 1969,   6,   1,    46,   4,0,  17 },
    { 1969,   6,   6,    46,   4,0,  22 },
    { 1969,   6,  14,    46,   4,0,  30 },
    { 1969,   6,  15,    46,   5,0,   1 },
    { 1969,   6,  16,    46,   5,0,   2 },
    { 1969,   6,  21,    46,   5,0,   7 },
    { 1969,   6,  30,    46,   5,0,  16 },
    { 1969,   7,   1,    46,   5,0,  17 },
    { 1969,   7,   7,    46,   5,0,  23 },
    { 1969,   7,  13,    46,   5,0,  29 },
    { 1969,   7,  14,    46,   6,0,   1 },
    { 1969,   7,  15,    46,   6,0,   2 },
    { 1969,   7,  23,    46,   6,0,  10 },
    { 1969,   7,  31,    46,   6,0,  18 },
    { 1969,   8,   1,    46,   6,0,  19 },
    { 1969,   8,   8,    46,   6,0,  26 },
    { 1969,   8,  12,    46,   6,0,  30 },
    { 1969,   8,  13,    46,   7,0,   1 },
    { 1969,   8,  14,    46,   7,0,   2 },
    { 1969,   8,  23,    46,   7,0,  11 },
    { 1969,   8,  31,    46,   7,0,  19 },
    { 1969,   9,   1,    46,   7,0,  20 },
    { 1969,   9,   8,    46,   7,0,  27 },
    { 1969,   9,  11,    46,   7,0,  30 },
    { 1969,   9,  12,    46,   8,0,   1 },
    { 1969,   9,  13,    46,   8,0,   2 },
    { 1969,   9,  23,    46,   8,0,  12 },
    { 1969,   9,  30,    46,   8,0,  19 },
    { 1969,  10,   1,    46,   8,0,  20 },
    { 1969,  10,   8,    46,   8,0,  27 },
    { 1969,  10,  10,    46,   8,0,  29 },
    { 1969,  10,  11,    46,   9,0,   1 },
    { 1969,  10,  12,    46,   9,0,   2 },
    { 1969,  10,  23,    46,   9,0,  13 },
    { 1969,  10,  31,    46,   9,0,  21 },
    { 1969,  11,   1,    46,   9,0,  22 },
    { 1969,  11,   7,    46,   9,0,  28 },
    { 1969,  11,   9,    46,   9,0,  30 },
    { 1969,  11,  10,    46,  10,0,   1 },
    { 1969,  11,  11,    46,  10,0,   2 },
    { 1969,  11,  22,    46,  10,0,  13 },
    { 1969,  11,  30,    46,  10,0,  21 },
    { 1969,  12,   1,    46,  10,0,  22 },
    { 1969,  12,   7,    46,  10,0,  28 },
    { 1969,  12,   8,    46,  10,0,  29 },
    { 1969,  12,   9,    46,  11,0,   1 },
    { 1969,  12,  10,    46,  11,0,   2 },
    { 1969,  12,  22,    46,  11,0,  14 },
    { 1969,  12,  31,    46,  11,0,  23 },
    { 1970,   1,   1,    46,  11,0,  24 },
    { 1970,   1,   6,    46,  11,0,  29 },
    { 1970,   1,   7,    46,  11,0,  30 },
    { 1970,   1,   8,    46,  12,0,   1 },
    { 1970,   1,   9,    46,  12,0,   2 },
    { 1970,   1,  20,    46,  12,0,  13 },
    { 1970,   1,  31,    46,  12,0,  24 },
    { 1970,   2,   1,    46,  12,0,  25 },
    { 1970,   2,   4,    46,  12,0,  28 },
    { 1970,   2,   5,    46,  12,0,  29 },
    { 1970,   2,   6,    47,   1,0,   1 },
    { 1970,   2,   7,    47,   1,0,   2 },
    { 1970,   2,  19,    47,   1,0,  14 },
    { 1970,   2,  28,    47,   1,0,  23 },
    { 1970,   3,   1,    47,   1,0,  24 },
    { 1970,   3,   6,    47,   1,0,  29 },
    { 1970,   3,   7,    47,   1,0,  30 },
    { 1970,   3,   8,    47,   2,0,   1 },
    { 1970,   3,   9,    47,   2,0,   2 },
    { 1970,   3,  21,    47,   2,0,  14 },
    { 1970,   3,  31,    47,   2,0,  24 },
    { 1970,   4,   1,    47,   2,0,  25 },
    { 1970,   4,   5,    47,   2,0,  29 },
    { 1970,   4,   6,    47,   3,0,   1 },
    { 1970,   4,   7,    47,   3,0,   2 },
    { 1970,   4,  20,    47,   3,0,  15 },
    { 1970,   4,  30,    47,   3,0,  25 },
    { 1970,   5,   1,    47,   3,0,  26 },
    { 1970,   5,   4,    47,   3,0,  29 },
    { 1970,   5,   5,    47,   4,0,   1 },
    { 1970,   5,   6,    47,   4,0,   2 },
    { 1970,   5,  21,    47,   4,0,  17 },
    { 1970,   5,  31,    47,   4,0,  27 },
    { 1970,   6,   1,    47,   4,0,  28 },
    { 1970,   6,   3,    47,   4,0,  30 },
    { 1970,   6,   4,    47,   5,0,   1 },
    { 1970,   6,   5,    47,   5,0,   2 },
    { 1970,   6,   6,    47,   5,0,   3 },
    { 1970,   6,  22,    47,   5,0,  19 },
    { 1970,   7,   2,    47,   5,0,  29 },
    { 1970,   7,   3,    47,   6,0,   1 },
    { 1970,   7,   4,    47,   6,0,   2 },
    { 1970,   7,   7,    47,   6,0,   5 },
    { 1970,   7,  23,    47,   6,0,  21 },
    { 1970,   8,   1,    47,   6,0,  30 },
    { 1970,   8,   2,    47,   7,0,   1 },
    { 1970,   8,   3,    47,   7,0,   2 },
    { 1970,   8,   8,    47,   7,0,   7 },
    { 1970,   8,  23,    47,   7,0,  22 },
    { 1970,   8,  31,    47,   7,0,  30 },
    { 1970,   9,   1,    47,   8,0,   1 },
    { 1970,   9,   8,    47,   8,0,   8 },
    { 1970,   9,  23,    47,   8,0,  23 },
    { 1970,   9,  29,    47,   8,0,  29 },
    { 1970,   9,  30,    47,   9,0,   1 },
    { 1970,  10,   1,    47,   9,0,   2 },
    { 1970,  10,   9,    47,   9,0,  10 },
    { 1970,  10,  24,    47,   9,0,  25 },
    { 1970,  10,  29,    47,   9,0,  30 },
    { 1970,  10,  30,    47,  10,0,   1 },
    { 1970,  10,  31,    47,  10,0,   2 },
    { 1970,  11,   1,    47,  10,0,   3 },
    { 1970,  11,   8,    47,  10,0,  10 },
    { 1970,  11,  23,    47,  10,0,  25 },
    { 1970,  11,  28,    47,  10,0,  30 },
    { 1970,  11,  29,    47,  11,0,   1 },
    { 1970,  11,  30,    47,  11,0,   2 },
    { 1970,  12,   1,    47,  11,0,   3 },
    { 1970,  12,   7,    47,  11,0,   9 },
    { 1970,  12,  22,    47,  11,0,  24 },
    { 1970,  12,  27,    47,  11,0,  29 },
    { 1970,  12,  28,    47,  12,0,   1 },
    { 1970,  12,  29,    47,  12,0,   2 },
    { 1970,  12,  31,    47,  12,0,   4 },
    { 1971,   1,   1,    47,  12,0,   5 },
    { 1971,   1,   6,    47,  12,0,  10 },
    { 1971,   1,  21,    47,  12,0,  25 },
    { 1971,   1,  26,    47,  12,0,  30 },
    { 1971,   1,  27,    48,   1,0,   1 },
    { 1971,   1,  28,    48,   1,0,   2 },
    { 1971,   1,  31,    48,   1,0,   5 },
    { 1971,   2,   1,    48,   1,0,   6 },
    { 1971,   2,   4,    48,   1,0,   9 },
    { 1971,   2,  19,    48,   1,0,  24 },
    { 1971,   2,  24,    48,   1,0,  29 },
    { 1971,   2,  25,    48,   2,0,   1 },
    { 1971,   2,  26,    48,   2,0,   2 },
    { 1971,   2,  28,    48,   2,0,   4 },
    { 1971,   3,   1,    48,   2,0,   5 },
    { 1971,   3,   6,    48,   2,0,  10 },
    { 1971,   3,  21,    48,   2,0,  25 },
    { 1971,   3,  26,    48,   2,0,  30 },
    { 1971,   3,  27,    48,   3,0,   1 },
    { 1971,   3,  28,    48,   3,0,   2 },
    { 1971,   3,  31,    48,   3,0,   5 },
    { 1971,   4,   1,    48,   3,0,   6 },
    { 1971,   4,   5,    48,   3,0,  10 },
    { 1971,   4,  21,    48,   3,0,  26 },
    { 1971,   4,  24,    48,   3,0,  29 },
    { 1971,   4,  25,    48,   4,0,   1 },
    { 1971,   4,  26,    48,   4,0,   2 },
    { 1971,   4,  30,    48,   4,0,   6 },
    { 1971,   5,   1,    48,   4,0,   7 },
    { 1971,   5,   6,    48,   4,0,  12 },
    { 1971,   5,  22,    48,   4,0,  28 },
    { 1971,   5,  23,    48,   4,0,  29 },
    { 1971,   5,  24,    48,   5,0,   1 },
    { 1971,   5,  25,    48,   5,0,   2 },
    { 1971,   5,  31,    48,   5,0,   8 },
    { 1971,   6,   1,    48,   5,0,   9 },
    { 1971,   6,   6,    48,   5,0,  14 },
    { 1971,   6,  22,    48,   5,0,  30 },
    { 1971,   6,  23,    48,   5,1,   1 },
    { 1971,   6,  24,    48,   5,1,   2 },
    { 1971,   6,  30,    48,   5,1,   8 },
    { 1971,   7,   1,    48,   5,1,   9 },
    { 1971,   7,   8,    48,   5,1,  16 },
    { 1971,   7,  21,    48,   5,1,  29 },
    { 1971,   7,  22,    48,   6,0,   1 },
    { 1971,   7,  23,    48,   6,0,   2 },
    { 1971,   7,  31,    48,   6,0,  10 },
    { 1971,   8,   1,    48,   6,0,  11 },
    { 1971,   8,   8,    48,   6,0,  18 },
    { 1971,   8,  20,    48,   6,0,  30 },
    { 1971,   8,  21,    48,   7,0,   1 },
    { 1971,   8,  22,    48,   7,0,   2 },
    { 1971,   8,  24,    48,   7,0,   4 },
    { 1971,   8,  31,    48,   7,0,  11 },
    { 1971,   9,   1,    48,   7,0,  12 },
    { 1971,   9,   8,    48,   7,0,  19 },
    { 1971,   9,  18,    48,   7,0,  29 },
    { 1971,   9,  19,    48,   8,0,   1 },
    { 1971,   9,  20,    48,   8,0,   2 },
    { 1971,   9,  24,    48,   8,0,   6 },
    { 1971,   9,  30,    48,   8,0,  12 },
    { 1971,  10,   1,    48,   8,0,  13 },
    { 1971,  10,   9,    48,   8,0,  21 },
    { 1971,  10,  18,    48,   8,0,  30 },
    { 1971,  10,  19,    48,   9,0,   1 },
    { 1971,  10,  20,    48,   9,0,   2 },
    { 1971,  10,  24,    48,   9,0,   6 },
    { 1971,  10,  31,    48,   9,0,  13 },
    { 1971,  11,   1,    48,   9,0,  14 },
    { 1971,  11,   8,    48,   9,0,  21 },
    { 1971,  11,  17,    48,   9,0,  30 },
    { 1971,  11,  18,    48,  10,0,   1 },
    { 1971,  11,  19,    48,  10,0,   2 },
    { 1971,  11,  23,    48,  10,0,   6 },
    { 1971,  11,  30,    48,  10,0,  13 },
    { 1971,  12,   1,    48,  10,0,  14 },
    { 1971,  12,   8,    48,  10,0,  21 },
    { 1971,  12,  17,    48,  10,0,  30 },
    { 1971,  12,  18,    48,  11,0,   1 },
    { 1971,  12,  19,    48,  11,0,   2 },
    { 1971,  12,  22,    48,  11,0,   5 },
    { 1971,  12,  31,    48,  11,0,  14 },
    { 1972,   1,   1,    48,  11,0,  15 },
    { 1972,   1,   6,    48,  11,0,  20 },
    { 1972,   1,  15,    48,  11,0,  29 },
    { 1972,   1,  16,    48,  12,0,   1 },
    { 1972,   1,  17,    48,  12,0,   2 },
    { 1972,   1,  21,    48,  12,0,   6 },
    { 1972,   1,  31,    48,  12,0,  16 },
    { 1972,   2,   1,    48,  12,0,  17 },
    { 1972,   2,   5,    48,  12,0,  21 },
    { 1972,   2,  14,    48,  12,0,  30 },
    { 1972,   2,  15,    49,   1,0,   1 },
    { 1972,   2,  16,    49,   1,0,   2 },
    { 1972,   2,  19,    49,   1,0,   5 },
    { 1972,   2,  29,    49,   1,0,  15 },
    { 1972,   3,   1,    49,   1,0,  16 },
    { 1972,   3,   5,    49,   1,0,  20 },
    { 1972,   3,  14,    49,   1,0,  29 },
    { 1972,   3,  15,    49,   2,0,   1 },
    { 1972,   3,  16,    49,   2,0,   2 },
    { 1972,   3,  20,    49,   2,0,   6 },
    { 1972,   3,  31,    49,   2,0,  17 },
    { 1972,   4,   1,    49,   2,0,  18 },
    { 1972,   4,   5,    49,   2,0,  22 },
    { 1972,   4,  13,    49,   2,0,  30 },
    { 1972,   4,  14,    49,   3,0,   1 },
    { 1972,   4,  15,    49,   3,0,   2 },
    { 1972,   4,  20,    49,   3,0,   7 },
    { 1972,   4,  30,    49,   3,0,  17 },
    { 1972,   5,   1,    49,   3,0,  18 },
    { 1972,   5,   5,    49,   3,0,  22 },
    { 1972,   5,  12,    49,   3,0,  29 },
    { 1972,   5,  13,    49,   4,0,   1 },
    { 1972,   5,  14,    49,   4,0,   2 },
    { 1972,   5,  21,    49,   4,0,   9 },
    { 1972,   5,  31,    49,   4,0,  19 },
    { 1972,   6,   1,    49,   4,0,  20 },
    { 1972,   6,   5,    49,   4,0,  24 },
    { 1972,   6,  10,    49,   4,0,  29 },
    { 1972,   6,  11,    49,   5,0,   1 },
    { 1972,   6,  12,    49,   5,0,   2 },
    { 1972,   6,  21,    49,   5,0,  11 },
    { 1972,   6,  30,    49,   5,0,  20 },
    { 1972,   7,   1,    49,   5,0,  21 },
    { 1972,   7,   7,    49,   5,0,  27 },
    { 1972,   7,  10,    49,   5,0,  30 },
    { 1972,   7,  11,    49,   6,0,   1 },
    { 1972,   7,  12,    49,   6,0,   2 },
    { 1972,   7,  23,    49,   6,0,  13 },
    { 1972,   7,  31,    49,   6,0,  21 },
    { 1972,   8,   1,    49,   6,0,  22 },
    { 1972,   8,   7,    49,   6,0,  28 },
    { 1972,   8,   8,    49,   6,0,  29 },
    { 1972,   8,   9,    49,   7,0,   1 },
    { 1972,   8,  10,    49,   7,0,   2 },
    { 1972,   8,  23,    49,   7,0,  15 },
    { 1972,   8,  31,    49,   7,0,  23 },
    { 1972,   9,   1,    49,   7,0,  24 },
    { 1972,   9,   7,    49,   7,0,  30 },
    { 1972,   9,   8,    49,   8,0,   1 },
    { 1972,   9,   9,    49,   8,0,   2 },
    { 1972,   9,  23,    49,   8,0,  16 },
    { 1972,   9,  30,    49,   8,0,  23 },
    { 1972,  10,   1,    49,   8,0,  24 },
    { 1972,  10,   6,    49,   8,0,  29 },
    { 1972,  10,   7,    49,   9,0,   1 },
    { 1972,  10,   8,    49,   9,0,   2 },
    { 1972,  10,  23,    49,   9,0,  17 },
    { 1972,  10,  31,    49,   9,0,  25 },
    { 1972,  11,   1,    49,   9,0,  26 },
    { 1972,  11,   5,    49,   9,0,  30 },
    { 1972,  11,   6,    49,  10,0,   1 },
    { 1972,  11,   7,    49,  10,0,   2 },
    { 1972,  11,  22,    49,  10,0,  17 },
    { 1972,  11,  30,    49,  10,0,  25 },
    { 1972,  12,   1,    49,  10,0,  26 },
    { 1972,  12,   5,    49,  10,0,  30 },
    { 1972,  12,   6,    49,  11,0,   1 },
    { 1972,  12,   7,    49,  11,0,   2 },
    { 1972,  12,  22,    49,  11,0,  17 },
    { 1972,  12,  31,    49,  11,0,  26 },
    { 1973,   1,   1,    49,  11,0,  27 },
    { 1973,   1,   3,    49,  11,0,  29 },
    { 1973,   1,   4,    49,  12,0,   1 },
    { 1973,   1,   5,    49,  12,0,   2 },
    { 1973,   1,  20,    49,  12,0,  17 },
    { 1973,   2,   2,    49,  12,0,  30 },
    { 1973,   2,   3,    50,   1,0,   1 },
    { 1973,   2,   4,    50,   1,0,   2 },
    { 1973,   2,  19,    50,   1,0,  17 },
    { 1973,   2,  28,    50,   1,0,  26 },
    { 1973,   3,   1,    50,   1,0,  27 },
    { 1973,   3,   4,    50,   1,0,  30 },
    { 1973,   3,   5,    50,   2,0,   1 },
    { 1973,   3,   6,    50,   2,0,   2 },
    { 1973,   3,  21,    50,   2,0,  17 },
    { 1973,   4,   2,    50,   2,0,  29 },
    { 1973,   4,   3,    50,   3,0,   1 },
    { 1973,   4,   4,    50,   3,0,   2 },
    { 1973,   4,   5,    50,   3,0,   3 },
    { 1973,   4,  20,    50,   3,0,  18 },
    { 1973,   5,   2,    50,   3,0,  30 },
    { 1973,   5,   3,    50,   4,0,   1 },
    { 1973,   5,   4,    50,   4,0,   2 },
    { 1973,   5,   5,    50,   4,0,   3 },
    { 1973,   5,  21,    50,   4,0,  19 },
    { 1973,   5,  31,    50,   4,0,  29 },
    { 1973,   6,   1,    50,   5,0,   1 },
    { 1973,   6,   6,    50,   5,0,   6 },
    { 1973,   6,  21,    50,   5,0,  21 },
    { 1973,   6,  29,    50,   5,0,  29 },
    { 1973,   6,  30,    50,   6,0,   1 },
    { 1973,   7,   1,    50,   6,0,   2 },
    { 1973,   7,   7,    50,   6,0,   8 },
    { 1973,   7,  23,    50,   6,0,  24 },
    { 1973,   7,  29,    50,   6,0,  30 },
    { 1973,   7,  30,    50,   7,0,   1 },
    { 1973,   7,  31,    50,   7,0,   2 },
    { 1973,   8,   1,    50,   7,0,   3 },
    { 1973,   8,   8,    50,   7,0,  10 },
    { 1973,   8,  23,    50,   7,0,  25 },
    { 1973,   8,  27,    50,   7,0,  29 },
    { 1973,   8,  28,    50,   8,0,   1 },
    { 1973,   8,  29,    50,   8,0,   2 },
    { 1973,   8,  31,    50,   8,0,   4 },
    { 1973,   9,   1,    50,   8,0,   5 },
    { 1973,   9,   8,    50,   8,0,  12 },
    { 1973,   9,  23,    50,   8,0,  27 },
    { 1973,   9,  25,    50,   8,0,  29 },
    { 1973,   9,  26,    50,   9,0,   1 },
    { 1973,   9,  27,    50,   9,0,   2 },
    { 1973,   9,  30,    50,   9,0,   5 },
    { 1973,  10,   1,    50,   9,0,   6 },
    { 1973,  10,   8,    50,   9,0,  13 },
    { 1973,  10,  23,    50,   9,0,  28 },
    { 1973,  10,  25,    50,   9,0,  30 },
    { 1973,  10,  26,    50,  10,0,   1 },
    { 1973,  10,  27,    50,  10,0,   2 },
    { 1973,  10,  31,    50,  10,0,   6 },
    { 1973,  11,   1,    50,  10,0,   7 },
    { 1973,  11,   7,    50,  10,0,  13 },
    { 1973,  11,  22,    50,  10,0,  28 },
    { 1973,  11,  24,    50,  10,0,  30 },
    { 1973,  11,  25,    50,  11,0,   1 },
    { 1973,  11,  26,    50,  11,0,   2 },
    { 1973,  11,  30,    50,  11,0,   6 },
    { 1973,  12,   1,    50,  11,0,   7 },
    { 1973,  12,   7,    50,  11,0,  13 },
    { 1973,  12,  22,    50,  11,0,  28 },
    { 1973,  12,  23,    50,  11,0,  29 },
    { 1973,  12,  24,    50,  12,0,   1 },
    { 1973,  12,  25,    50,  12,0,   2 },
    { 1973,  12,  31,    50,  12,0,   8 },
    { 1974,   1,   1,    50,  12,0,   9 },
    { 1974,   1,   6,    50,  12,0,  14 },
    { 1974,   1,  20,    50,  12,0,  28 },
    { 1974,   1,  22,    50,  12,0,  30 },
    { 1974,   1,  23,    51,   1,0,   1 },
    { 1974,   1,  24,    51,   1,0,   2 },
    { 1974,   1,  31,    51,   1,0,   9 },
    { 1974,   2,   1,    51,   1,0,  10 },
    { 1974,   2,   4,    51,   1,0,  13 },
    { 1974,   2,  19,    51,   1,0,  28 },
    { 1974,   2,  21,    51,   1,0,  30 },
    { 1974,   2,  22,    51,   2,0,   1 },
    { 1974,   2,  23,    51,   2,0,   2 },
    { 1974,   2,  28,    51,   2,0,   7 },
    { 1974,   3,   1,    51,   2,0,   8 },
    { 1974,   3,   6,    51,   2,0,  13 },
    { 1974,   3,  21,    51,   2,0,  28 },
    { 1974,   3,  23,    51,   2,0,  30 },
    { 1974,   3,  24,    51,   3,0,   1 },
    { 1974,   3,  25,    51,   3,0,   2 },
    { 1974,   3,  31,    51,   3,0,   8 },
    { 1974,   4,   1,    51,   3,0,   9 },
    { 1974,   4,   5,    51,   3,0,  13 },
    { 1974,   4,  20,    51,   3,0,  28 },
    { 1974,   4,  21,    51,   3,0,  29 },
    { 1974,   4,  22,    51,   4,0,   1 },
    { 1974,   4,  23,    51,   4,0,   2 },
    { 1974,   4,  30,    51,   4,0,   9 },
    { 1974,   5,   1,    51,   4,0,  10 },
    { 1974,   5,   6,    51,   4,0,  15 },
    { 1974,   5,  21,    51,   4,0,  30 },
    { 1974,   5,  22,    51,   4,1,   1 },
    { 1974,   5,  23,    51,   4,1,   2 },
    { 1974,   5,  31,    51,   4,1,  10 },
    { 1974,   6,   1,    51,   4,1,  11 },
    { 1974,   6,   6,    51,   4,1,  16 },
    { 1974,   6,  19,    51,   4,1,  29 },
    { 1974,   6,  20,    51,   5,0,   1 },
    { 1974,   6,  21,    51,   5,0,   2 },
    { 1974,   6,  22,    51,   5,0,   3 },
    { 1974,   6,  30,    51,   5,0,  11 },
    { 1974,   7,   1,    51,   5,0,  12 },
    { 1974,   7,   7,    51,   5,0,  18 },
    { 1974,   7,  18,    51,   5,0,  29 },
    { 1974,   7,  19,    51,   6,0,   1 },
    { 1974,   7,  20,    51,   6,0,   2 },
    { 1974,   7,  23,    51,   6,0,   5 },
    { 1974,   7,  31,    51,   6,0,  13 },
    { 1974,   8,   1,    51,   6,0,  14 },
    { 1974,   8,   8,    51,   6,0,  21 },
    { 1974,   8,  17,    51,   6,0,  30 },
    { 1974,   8,  18,    51,   7,0,   1 },
    { 1974,   8,  19,    51,   7,0,   2 },
    { 1974,   8,  23,    51,   7,0,   6 },
    { 1974,   8,  31,    51,   7,0,  14 },
    { 1974,   9,   1,    51,   7,0,  15 },
    { 1974,   9,   8,    51,   7,0,  22 },
    { 1974,   9,  15,    51,   7,0,  29 },
    { 1974,   9,  16,    51,   8,0,   1 },
    { 1974,   9,  17,    51,   8,0,   2 },
    { 1974,   9,  23,    51,   8,0,   8 },
    { 1974,   9,  30,    51,   8,0,  15 },
    { 1974,  10,   1,    51,   8,0,  16 },
    { 1974,  10,   9,    51,   8,0,  24 },
    { 1974,  10,  14,    51,   8,0,  29 },
    { 1974,  10,  15,    51,   9,0,   1 },
    { 1974,  10,  16,    51,   9,0,   2 },
    { 1974,  10,  24,    51,   9,0,  10 },
    { 1974,  10,  31,    51,   9,0,  17 },
    { 1974,  11,   1,    51,   9,0,  18 },
    { 1974,  11,   8,    51,   9,0,  25 },
    { 1974,  11,  13,    51,   9,0,  30 },
    { 1974,  11,  14,    51,  10,0,   1 },
    { 1974,  11,  15,    51,  10,0,   2 },
    { 1974,  11,  23,    51,  10,0,  10 },
    { 1974,  11,  30,    51,  10,0,  17 },
    { 1974,  12,   1,    51,  10,0,  18 },
    { 1974,  12,   7,    51,  10,0,  24 },
    { 1974,  12,  13,    51,  10,0,  30 },
    { 1974,  12,  14,    51,  11,0,   1 },
    { 1974,  12,  15,    51,  11,0,   2 },
    { 1974,  12,  22,    51,  11,0,   9 },
    { 1974,  12,  31,    51,  11,0,  18 },
    { 1975,   1,   1,    51,  11,0,  19 },
    { 1975,   1,   6,    51,  11,0,  24 },
    { 1975,   1,  11,    51,  11,0,  29 },
    { 1975,   1,  12,    51,  12,0,   1 },
    { 1975,   1,  13,    51,  12,0,   2 },
    { 1975,   1,  21,    51,  12,0,  10 },
    { 1975,   1,  31,    51,  12,0,  20 },
    { 1975,   2,   1,    51,  12,0,  21 },
    { 1975,   2,   4,    51,  12,0,  24 },
    { 1975,   2,  10,    51,  12,0,  30 },
    { 1975,   2,  11,    52,   1,0,   1 },
    { 1975,   2,  12,    52,   1,0,   2 },
    { 1975,   2,  19,    52,   1,0,   9 },
    { 1975,   2,  28,    52,   1,0,  18 },
    { 1975,   3,   1,    52,   1,0,  19 },
    { 1975,   3,   6,    52,   1,0,  24 },
    { 1975,   3,  12,    52,   1,0,  30 },
    { 1975,   3,  13,    52,   2,0,   1 },
    { 1975,   3,  14,    52,   2,0,   2 },
    { 1975,   3,  21,    52,   2,0,   9 },
    { 1975,   3,  31,    52,   2,0,  19 },
    { 1975,   4,   1,    52,   2,0,  20 },
    { 1975,   4,   5,    52,   2,0,  24 },
    { 1975,   4,  11,    52,   2,0,  30 },
    { 1975,   4,  12,    52,   3,0,   1 },
    { 1975,   4,  13,    52,   3,0,   2 },
    { 1975,   4,  21,    52,   3,0,  10 },
    { 1975,   4,  30,    52,   3,0,  19 },
    { 1975,   5,   1,    52,   3,0,  20 },
    { 1975,   5,   6,    52,   3,0,  25 },
    { 1975,   5,  10,    52,   3,0,  29 },
    { 1975,   5,  11,    52,   4,0,   1 },
    { 1975,   5,  12,    52,   4,0,   2 },
    { 1975,   5,  22,    52,   4,0,  12 },
    { 1975,   5,  31,    52,   4,0,  21 },
    { 1975,   6,   1,    52,   4,0,  22 },
    { 1975,   6,   6,    52,   4,0,  27 },
    { 1975,   6,   9,    52,   4,0,  30 },
    { 1975,   6,  10,    52,   5,0,   1 },
    { 1975,   6,  11,    52,   5,0,   2 },
    { 1975,   6,  22,    52,   5,0,  13 },
    { 1975,   6,  30,    52,   5,0,  21 },
    { 1975,   7,   1,    52,   5,0,  22 },
    { 1975,   7,   8,    52,   5,0,  29 },
    { 1975,   7,   9,    52,   6,0,   1 },
    { 1975,   7,  10,    52,   6,0,   2 },
    { 1975,   7,  23,    52,   6,0,  15 },
    { 1975,   7,  31,    52,   6,0,  23 },
    { 1975,   8,   1,    52,   6,0,  24 },
    { 1975,   8,   6,    52,   6,0,  29 },
    { 1975,   8,   7,    52,   7,0,   1 },
    { 1975,   8,   8,    52,   7,0,   2 },
    { 1975,   8,  24,    52,   7,0,  18 },
    { 1975,   8,  31,    52,   7,0,  25 },
    { 1975,   9,   1,    52,   7,0,  26 },
    { 1975,   9,   5,    52,   7,0,  30 },
    { 1975,   9,   6,    52,   8,0,   1 },
    { 1975,   9,   7,    52,   8,0,   2 },
    { 1975,   9,   8,    52,   8,0,   3 },
    { 1975,   9,  23,    52,   8,0,  18 },
    { 1975,   9,  30,    52,   8,0,  25 },
    { 1975,  10,   1,    52,   8,0,  26 },
    { 1975,  10,   4,    52,   8,0,  29 },
    { 1975,  10,   5,    52,   9,0,   1 },
    { 1975,  10,   6,    52,   9,0,   2 },
    { 1975,  10,   9,    52,   9,0,   5 },
    { 1975,  10,  24,    52,   9,0,  20 },
    { 1975,  11,   2,    52,   9,0,  29 },
    { 1975,  11,   3,    52,  10,0,   1 },
    { 1975,  11,   4,    52,  10,0,   2 },
    { 1975,  11,   8,    52,  10,0,   6 },
    { 1975,  11,  23,    52,  10,0,  21 },
    { 1975,  12,   2,    52,  10,0,  30 },
    { 1975,  12,   3,    52,  11,0,   1 },
    { 1975,  12,   4,    52,  11,0,   2 },
    { 1975,  12,   8,    52,  11,0,   6 },
    { 1975,  12,  22,    52,  11,0,  20 },
    { 1975,  12,  31,    52,  11,0,  29 },
    { 1976,   1,   1,    52,  12,0,   1 },
    { 1976,   1,   6,    52,  12,0,   6 },
    { 1976,   1,  21,    52,  12,0,  21 },
    { 1976,   1,  30,    52,  12,0,  30 },
    { 1976,   1,  31,    53,   1,0,   1 },
    { 1976,   2,   1,    53,   1,0,   2 },
    { 1976,   2,   5,    53,   1,0,   6 },
    { 1976,   2,  19,    53,   1,0,  20 },
    { 1976,   2,  29,    53,   1,0,  30 },
    { 1976,   3,   1,    53,   2,0,   1 },
    { 1976,   3,   5,    53,   2,0,   5 },
    { 1976,   3,  20,    53,   2,0,  20 },
    { 1976,   3,  30,    53,   2,0,  30 },
    { 1976,   3,  31,    53,   3,0,   1 },
    { 1976,   4,   1,    53,   3,0,   2 },
    { 1976,   4,   4,    53,   3,0,   5 },
    { 1976,   4,  20,    53,   3,0,  21 },
    { 1976,   4,  28,    53,   3,0,  29 },
    { 1976,   4,  29,    53,   4,0,   1 },
    { 1976,   4,  30,    53,   4,0,   2 },
    { 1976,   5,   1,    53,   4,0,   3 },
    { 1976,   5,   5,    53,   4,0,   7 },
    { 1976,   5,  21,    53,   4,0,  23 },
    { 1976,   5,  28,    53,   4,0,  30 },
    { 1976,   5,  29,    53,   5,0,   1 },
    { 1976,   5,  30,    53,   5,0,   2 },
    { 1976,   5,  31,    53,   5,0,   3 },
    { 1976,   6,   1,    53,   5,0,   4 },
    { 1976,   6,   5,    53,   5,0,   8 },
    { 1976,   6,  21,    53,   5,0,  24 },
    { 1976,   6,  26,    53,   5,0,  29 },
    { 1976,   6,  27,    53,   6,0,   1 },
    { 1976,   6,  28,    53,   6,0,   2 },
    { 1976,   6,  30,    53,   6,0,   4 },
    { 1976,   7,   1,    53,   6,0,   5 },
    { 1976,   7,   7,    53,   6,0,  11 },
    { 1976,   7,  23,    53,   6,0,  27 },
    { 1976,   7,  26,    53,   6,0,  30 },
    { 1976,   7,  27,    53,   7,0,   1 },
    { 1976,   7,  28,    53,   7,0,   2 },
    { 1976,   7,  31,    53,   7,0,   5 },
    { 1976,   8,   1,    53,   7,0,   6 },
    { 1976,   8,   7,    53,   7,0,  12 },
    { 1976,   8,  23,    53,   7,0,  28 },
    { 1976,   8,  24,    53,   7,0,  29 },
    { 1976,   8,  25,    53,   8,0,   1 },
    { 1976,   8,  26,    53,   8,0,   2 },
    { 1976,   8,  31,    53,   8,0,   7 },
    { 1976,   9,   1,    53,   8,0,   8 },
    { 1976,   9,   7,    53,   8,0,  14 },
    { 1976,   9,  23,    53,   8,0,  30 },
    { 1976,   9,  24,    53,   8,1,   1 },
    { 1976,   9,  25,    53,   8,1,   2 },
    { 1976,   9,  30,    53,   8,1,   7 },
    { 1976,  10,   1,    53,   8,1,   8 },
    { 1976,  10,   8,    53,   8,1,  15 },
    { 1976,  10,  22,    53,   8,1,  29 },
    { 1976,  10,  23,    53,   9,0,   1 },
    { 1976,  10,  24,    53,   9,0,   2 },
    { 1976,  10,  31,    53,   9,0,   9 },
    { 1976,  11,   1,    53,   9,0,  10 },
    { 1976,  11,   7,    53,   9,0,  16 },
    { 1976,  11,  20,    53,   9,0,  29 },
    { 1976,  11,  21,    53,  10,0,   1 },
    { 1976,  11,  22,    53,  10,0,   2 },
    { 1976,  11,  30,    53,  10,0,  10 },
    { 1976,  12,   1,    53,  10,0,  11 },
    { 1976,  12,   7,    53,  10,0,  17 },
    { 1976,  12,  20,    53,  10,0,  30 },
    { 1976,  12,  21,    53,  11,0,   1 },
    { 1976,  12,  22,    53,  11,0,   2 },
    { 1976,  12,  31,    53,  11,0,  11 },
    { 1977,   1,   1,    53,  11,0,  12 },
    { 1977,   1,   5,    53,  11,0,  16 },
    { 1977,   1,  18,    53,  11,0,  29 },
    { 1977,   1,  19,    53,  12,0,   1 },
    { 1977,   1,  20,    53,  12,0,   2 },
    { 1977,   1,  31,    53,  12,0,  13 },
    { 1977,   2,   1,    53,  12,0,  14 },
    { 1977,   2,   4,    53,  12,0,  17 },
    { 1977,   2,  17,    53,  12,0,  30 },
    { 1977,   2,  18,    54,   1,0,   1 },
    { 1977,   2,  19,    54,   1,0,   2 },
    { 1977,   2,  28,    54,   1,0,  11 },
    { 1977,   3,   1,    54,   1,0,  12 },
    { 1977,   3,   6,    54,   1,0,  17 },
    { 1977,   3,  19,    54,   1,0,  30 },
    { 1977,   3,  20,    54,   2,0,   1 },
    { 1977,   3,  21,    54,   2,0,   2 },
    { 1977,   3,  31,    54,   2,0,  12 },
    { 1977,   4,   1,    54,   2,0,  13 },
    { 1977,   4,   5,    54,   2,0,  17 },
    { 1977,   4,  17,    54,   2,0,  29 },
    { 1977,   4,  18,    54,   3,0,   1 },
    { 1977,   4,  19,    54,   3,0,   2 },
    { 1977,   4,  20,    54,   3,0,   3 },
    { 1977,   4,  30,    54,   3,0,  13 },
    { 1977,   5,   1,    54,   3,0,  14 },
    { 1977,   5,   5,    54,   3,0,  18 },
    { 1977,   5,  17,    54,   3,0,  30 },
    { 1977,   5,  18,    54,   4,0,   1 },
    { 1977,   5,  19,    54,   4,0,   2 },
    { 1977,   5,  21,    54,   4,0,   4 },
    { 1977,   5,  31,    54,   4,0,  14 },
    { 1977,   6,   1,    54,   4,0,  15 },
    { 1977,   6,   6,    54,   4,0,  20 },
    { 1977,   6,  16,    54,   4,0,  30 },
    { 1977,   6,  17,    54,   5,0,   1 },
    { 1977,   6,  18,    54,   5,0,   2 },
    { 1977,   6,  21,    54,   5,0,   5 },
    { 1977,   6,  30,    54,   5,0,  14 },
    { 1977,   7,   1,    54,   5,0,  15 },
    { 1977,   7,   7,    54,   5,0,  21 },
    { 1977,   7,  15,    54,   5,0,  29 },
    { 1977,   7,  16,    54,   6,0,   1 },
    { 1977,   7,  17,    54,   6,0,   2 },
    { 1977,   7,  23,    54,   6,0,   8 },
    { 1977,   7,  31,    54,   6,0,  16 },
    { 1977,   8,   1,    54,   6,0,  17 },
    { 1977,   8,   7,    54,   6,0,  23 },
    { 1977,   8,  14,    54,   6,0,  30 },
    { 1977,   8,  15,    54,   7,0,   1 },
    { 1977,   8,  16,    54,   7,0,   2 },
    { 1977,   8,  23,    54,   7,0,   9 },
    { 1977,   8,  31,    54,   7,0,  17 },
    { 1977,   9,   1,    54,   7,0,  18 },
    { 1977,   9,   8,    54,   7,0,  25 },
    { 1977,   9,  12,    54,   7,0,  29 },
    { 1977,   9,  13,    54,   8,0,   1 },
    { 1977,   9,  14,    54,   8,0,   2 },
    { 1977,   9,  23,    54,   8,0,  11 },
    { 1977,   9,  30,    54,   8,0,  18 },
    { 1977,  10,   1,    54,   8,0,  19 },
    { 1977,  10,   8,    54,   8,0,  26 },
    { 1977,  10,  12,    54,   8,0,  30 },
    { 1977,  10,  13,    54,   9,0,   1 },
    { 1977,  10,  14,    54,   9,0,   2 },
    { 1977,  10,  23,    54,   9,0,  11 },
    { 1977,  10,  31,    54,   9,0,  19 },
    { 1977,  11,   1,    54,   9,0,  20 },
    { 1977,  11,   7,    54,   9,0,  26 },
    { 1977,  11,  10,    54,   9,0,  29 },
    { 1977,  11,  11,    54,  10,0,   1 },
    { 1977,  11,  12,    54,  10,0,   2 },
    { 1977,  11,  22,    54,  10,0,  12 },
    { 1977,  11,  30,    54,  10,0,  20 },
    { 1977,  12,   1,    54,  10,0,  21 },
    { 1977,  12,   7,    54,  10,0,  27 },
    { 1977,  12,  10,    54,  10,0,  30 },
    { 1977,  12,  11,    54,  11,0,   1 },
    { 1977,  12,  12,    54,  11,0,   2 },
    { 1977,  12,  22,    54,  11,0,  12 },
    { 1977,  12,  31,    54,  11,0,  21 },
    { 1978,   1,   1,    54,  11,0,  22 },
    { 1978,   1,   6,    54,  11,0,  27 },
    { 1978,   1,   8,    54,  11,0,  29 },
    { 1978,   1,   9,    54,  12,0,   1 },
    { 1978,   1,  10,    54,  12,0,   2 },
    { 1978,   1,  20,    54,  12,0,  12 },
    { 1978,   1,  31,    54,  12,0,  23 },
    { 1978,   2,   1,    54,  12,0,  24 },
    { 1978,   2,   4,    54,  12,0,  27 },
    { 1978,   2,   6,    54,  12,0,  29 },
    { 1978,   2,   7,    55,   1,0,   1 },
    { 1978,   2,   8,    55,   1,0,   2 },
    { 1978,   2,  19,    55,   1,0,  13 },
    { 1978,   2,  28,    55,   1,0,  22 },
    { 1978,   3,   1,    55,   1,0,  23 },
    { 1978,   3,   6,    55,   1,0,  28 },
    { 1978,   3,   8,    55,   1,0,  30 },
    { 1978,   3,   9,    55,   2,0,   1 },
    { 1978,   3,  10,    55,   2,0,   2 },
    { 1978,   3,  21,    55,   2,0,  13 },
    { 1978,   3,  31,    55,   2,0,  23 },
    { 1978,   4,   1,    55,   2,0,  24 },
    { 1978,   4,   5,    55,   2,0,  28 },
    { 1978,   4,   6,    55,   2,0,  29 },
    { 1978,   4,   7,    55,   3,0,   1 },
    { 1978,   4,   8,    55,   3,0,   2 },
    { 1978,   4,  20,    55,   3,0,  14 },
    { 1978,   4,  30,    55,   3,0,  24 },
    { 1978,   5,   1,    55,   3,0,  25 },
    { 1978,   5,   6,    55,   3,0,  30 },
    { 1978,   5,   7,    55,   4,0,   1 },
    { 1978,   5,   8,    55,   4,0,   2 },
    { 1978,   5,  21,    55,   4,0,  15 },
    { 1978,   5,  31,    55,   4,0,  25 },
    { 1978,   6,   1,    55,   4,0,  26 },
    { 1978,   6,   5,    55,   4,0,  30 },
    { 1978,   6,   6,    55,   5,0,   1 },
    { 1978,   6,   7,    55,   5,0,   2 },
    { 1978,   6,  22,    55,   5,0,  17 },
    { 1978,   6,  30,    55,   5,0,  25 },
    { 1978,   7,   1,    55,   5,0,  26 },
    { 1978,   7,   4,    55,   5,0,  29 },
    { 1978,   7,   5,    55,   6,0,   1 },
    { 1978,   7,   6,    55,   6,0,   2 },
    { 1978,   7,   7,    55,   6,0,   3 },
    { 1978,   7,  23,    55,   6,0,  19 },
    { 1978,   7,  31,    55,   6,0,  27 },
    { 1978,   8,   1,    55,   6,0,  28 },
    { 1978,   8,   3,    55,   6,0,  30 },
    { 1978,   8,   4,    55,   7,0,   1 },
    { 1978,   8,   5,    55,   7,0,   2 },
    { 1978,   8,   8,    55,   7,0,   5 },
    { 1978,   8,  23,    55,   7,0,  20 },
    { 1978,   9,   2,    55,   7,0,  30 },
    { 1978,   9,   3,    55,   8,0,   1 },
    { 1978,   9,   4,    55,   8,0,   2 },
    { 1978,   9,   8,    55,   8,0,   6 },
    { 1978,   9,  23,    55,   8,0,  21 },
    { 1978,  10,   1,    55,   8,0,  29 },
    { 1978,  10,   2,    55,   9,0,   1 },
    { 1978,  10,   3,    55,   9,0,   2 },
    { 1978,  10,   8,    55,   9,0,   7 },
    { 1978,  10,  24,    55,   9,0,  23 },
    { 1978,  10,  31,    55,   9,0,  30 },
    { 1978,  11,   1,    55,  10,0,   1 },
    { 1978,  11,   8,    55,  10,0,   8 },
    { 1978,  11,  23,    55,  10,0,  23 },
    { 1978,  11,  29,    55,  10,0,  29 },
    { 1978,  11,  30,    55,  11,0,   1 },
    { 1978,  12,   1,    55,  11,0,   2 },
    { 1978,  12,   7,    55,  11,0,   8 },
    { 1978,  12,  22,    55,  11,0,  23 },
    { 1978,  12,  29,    55,  11,0,  30 },
    { 1978,  12,  30,    55,  12,0,   1 },
    { 1978,  12,  31,    55,  12,0,   2 },
    { 1979,   1,   1,    55,  12,0,   3 },
    { 1979,   1,   6,    55,  12,0,   8 },
    { 1979,   1,  21,    55,  12,0,  23 },
    { 1979,   1,  27,    55,  12,0,  29 },
    { 1979,   1,  28,    56,   1,0,   1 },
    { 1979,   1,  29,    56,   1,0,   2 },
    { 1979,   1,  31,    56,   1,0,   4 },
    { 1979,   2,   1,    56,   1,0,   5 },
    { 1979,   2,   4,    56,   1,0,   8 },
    { 1979,   2,  19,    56,   1,0,  23 },
    { 1979,   2,  26,    56,   1,0,  30 },
    { 1979,   2,  27,    56,   2,0,   1 },
    { 1979,   2,  28,    56,   2,0,   2 },
    { 1979,   3,   1,    56,   2,0,   3 },
    { 1979,   3,   6,    56,   2,0,   8 },
    { 1979,   3,  21,    56,   2,0,  23 },
    { 1979,   3,  27,    56,   2,0,  29 },
    { 1979,   3,  28,    56,   3,0,   1 },
    { 1979,   3,  29,    56,   3,0,   2 },
    { 1979,   3,  31,    56,   3,0,   4 },
    { 1979,   4,   1,    56,   3,0,   5 },
    { 1979,   4,   5,    56,   3,0,   9 },
    { 1979,   4,  21,    56,   3,0,  25 },
    { 1979,   4,  25,    56,   3,0,  29 },
    { 1979,   4,  26,    56,   4,0,   1 },
    { 1979,   4,  27,    56,   4,0,   2 },
    { 1979,   4,  30,    56,   4,0,   5 },
    { 1979,   5,   1,    56,   4,0,   6 },
    { 1979,   5,   6,    56,   4,0,  11 },
    { 1979,   5,  21,    56,   4,0,  26 },
    { 1979,   5,  25,    56,   4,0,  30 },
    { 1979,   5,  26,    56,   5,0,   1 },
    { 1979,   5,  27,    56,   5,0,   2 },
    { 1979,   5,  31,    56,   5,0,   6 },
    { 1979,   6,   1,    56,   5,0,   7 },
    { 1979,   6,   6,    56,   5,0,  12 },
    { 1979,   6,  22,    56,   5,0,  28 },
    { 1979,   6,  23,    56,   5,0,  29 },
    { 1979,   6,  24,    56,   6,0,   1 },
    { 1979,   6,  25,    56,   6,0,   2 },
    { 1979,   6,  30,    56,   6,0,   7 },
    { 1979,   7,   1,    56,   6,0,   8 },
    { 1979,   7,   8,    56,   6,0,  15 },
    { 1979,   7,  23,    56,   6,0,  30 },
    { 1979,   7,  24,    56,   6,1,   1 },
    { 1979,   7,  25,    56,   6,1,   2 },
    { 1979,   7,  31,    56,   6,1,   8 },
    { 1979,   8,   1,    56,   6,1,   9 },
    { 1979,   8,   8,    56,   6,1,  16 },
    { 1979,   8,  22,    56,   6,1,  30 },
    { 1979,   8,  23,    56,   7,0,   1 },
    { 1979,   8,  24,    56,   7,0,   2 },
    { 1979,   8,  31,    56,   7,0,   9 },
    { 1979,   9,   1,    56,   7,0,  10 },
    { 1979,   9,   8,    56,   7,0,  17 },
    { 1979,   9,  20,    56,   7,0,  29 },
    { 1979,   9,  21,    56,   8,0,   1 },
    { 1979,   9,  22,    56,   8,0,   2 },
    { 1979,   9,  23,    56,   8,0,   3 },
    { 1979,   9,  30,    56,   8,0,  10 },
    { 1979,  10,   1,    56,   8,0,  11 },
    { 1979,  10,   9,    56,   8,0,  19 },
    { 1979,  10,  20,    56,   8,0,  30 },
    { 1979,  10,  21,    56,   9,0,   1 },
    { 1979,  10,  22,    56,   9,0,   2 },
    { 1979,  10,  24,    56,   9,0,   4 },
    { 1979,  10,  31,    56,   9,0,  11 },
    { 1979,  11,   1,    56,   9,0,  12 },
    { 1979,  11,   8,    56,   9,0,  19 },
    { 1979,  11,  19,    56,   9,0,  30 },
    { 1979,  11,  20,    56,  10,0,   1 },
    { 1979,  11,  21,    56,  10,0,   2 },
    { 1979,  11,  23,    56,  10,0,   4 },
    { 1979,  11,  30,    56,  10,0,  11 },
    { 1979,  12,   1,    56,  10,0,  12 },
    { 1979,  12,   8,    56,  10,0,  19 },
    { 1979,  12,  18,    56,  10,0,  29 },
    { 1979,  12,  19,    56,  11,0,   1 },
    { 1979,  12,  20,    56,  11,0,   2 },
    { 1979,  12,  22,    56,  11,0,   4 },
    { 1979,  12,  31,    56,  11,0,  13 },
    { 1980,   1,   1,    56,  11,0,  14 },
    { 1980,   1,   6,    56,  11,0,  19 },
    { 1980,   1,  17,    56,  11,0,  30 },
    { 1980,   1,  18,    56,  12,0,   1 },
    { 1980,   1,  19,    56,  12,0,   2 },
    { 1980,   1,  21,    56,  12,0,   4 },
    { 1980,   1,  31,    56,  12,0,  14 },
    { 1980,   2,   1,    56,  12,0,  15 },
    { 1980,   2,   5,    56,  12,0,  19 },
    { 1980,   2,  15,    56,  12,0,  29 },
    { 1980,   2,  16,    57,   1,0,   1 },
    { 1980,   2,  17,    57,   1,0,   2 },
    { 1980,   2,  19,    57,   1,0,   4 },
    { 1980,   2,  29,    57,   1,0,  14 },
    { 1980,   3,   1,    57,   1,0,  15 },
    { 1980,   3,   5,    57,   1,0,  19 },
    { 1980,   3,  16,    57,   1,0,  30 },
    { 1980,   3,  17,    57,   2,0,   1 },
    { 1980,   3,  18,    57,   2,0,   2 },
    { 1980,   3,  20,    57,   2,0,   4 },
    { 1980,   3,  31,    57,   2,0,  15 },
    { 1980,   4,   1,    57,   2,0,  16 },
    { 1980,   4,   4,    57,   2,0,  19 },
    { 1980,   4,  14,    57,   2,0,  29 },
    { 1980,   4,  15,    57,   3,0,   1 },
    { 1980,   4,  16,    57,   3,0,   2 },
    { 1980,   4,  20,    57,   3,0,   6 },
    { 1980,   4,  30,    57,   3,0,  16 },
    { 1980,   5,   1,    57,   3,0,  17 },
    { 1980,   5,   5,    57,   3,0,  21 },
    { 1980,   5,  13,    57,   3,0,  29 },
    { 1980,   5,  14,    57,   4,0,   1 },
    { 1980,   5,  15,    57,   4,0,   2 },
    { 1980,   5,  21,    57,   4,0,   8 },
    { 1980,   5,  31,    57,   4,0,  18 },
    { 1980,   6,   1,    57,   4,0,  19 },
    { 1980,   6,   5,    57,   4,0,  23 },
    { 1980,   6,  12,    57,   4,0,  30 },
    { 1980,   6,  13,    57,   5,0,   1 },
    { 1980,   6,  14,    57,   5,0,   2 },
    { 1980,   6,  21,    57,   5,0,   9 },
    { 1980,   6,  30,    57,   5,0,  18 },
    { 1980,   7,   1,    57,   5,0,  19 },
    { 1980,   7,   7,    57,   5,0,  25 },
    { 1980,   7,  11,    57,   5,0,  29 },
    { 1980,   7,  12,    57,   6,0,   1 },
    { 1980,   7,  13,    57,   6,0,   2 },
    { 1980,   7,  23,    57,   6,0,  12 },
    { 1980,   7,  31,    57,   6,0,  20 },
    { 1980,   8,   1,    57,   6,0,  21 },
    { 1980,   8,   7,    57,   6,0,  27 },
    { 1980,   8,  10,    57,   6,0,  30 },
    { 1980,   8,  11,    57,   7,0,   1 },
    { 1980,   8,  12,    57,   7,0,   2 },
    { 1980,   8,  23,    57,   7,0,  13 },
    { 1980,   8,  31,    57,   7,0,  21 },
    { 1980,   9,   1,    57,   7,0,  22 },
    { 1980,   9,   7,    57,   7,0,  28 },
    { 1980,   9,   8,    57,   7,0,  29 },
    { 1980,   9,   9,    57,   8,0,   1 },
    { 1980,   9,  10,    57,   8,0,   2 },
    { 1980,   9,  23,    57,   8,0,  15 },
    { 1980,   9,  30,    57,   8,0,  22 },
    { 1980,  10,   1,    57,   8,0,  23 },
    { 1980,  10,   8,    57,   8,0,  30 },
    { 1980,  10,   9,    57,   9,0,   1 },
    { 1980,  10,  10,    57,   9,0,   2 },
    { 1980,  10,  23,    57,   9,0,  15 },
    { 1980,  10,  31,    57,   9,0,  23 },
    { 1980,  11,   1,    57,   9,0,  24 },
    { 1980,  11,   7,    57,   9,0,  30 },
    { 1980,  11,   8,    57,  10,0,   1 },
    { 1980,  11,   9,    57,  10,0,   2 },
    { 1980,  11,  22,    57,  10,0,  15 },
    { 1980,  11,  30,    57,  10,0,  23 },
    { 1980,  12,   1,    57,  10,0,  24 },
    { 1980,  12,   6,    57,  10,0,  29 },
    { 1980,  12,   7,    57,  11,0,   1 },
    { 1980,  12,   8,    57,  11,0,   2 },
    { 1980,  12,  22,    57,  11,0,  16 },
    { 1980,  12,  31,    57,  11,0,  25 },
    { 1981,   1,   1,    57,  11,0,  26 },
    { 1981,   1,   5,    57,  11,0,  30 },
    { 1981,   1,   6,    57,  12,0,   1 },
    { 1981,   1,   7,    57,  12,0,   2 },
    { 1981,   1,  20,    57,  12,0,  15 },
    { 1981,   1,  31,    57,  12,0,  26 },
    { 1981,   2,   1,    57,  12,0,  27 },
    { 1981,   2,   4,    57,  12,0,  30 },
    { 1981,   2,   5,    58,   1,0,   1 },
    { 1981,   2,   6,    58,   1,0,   2 },
    { 1981,   2,  19,    58,   1,0,  15 },
    { 1981,   2,  28,    58,   1,0,  24 },
    { 1981,   3,   1,    58,   1,0,  25 },
    { 1981,   3,   5,    58,   1,0,  29 },
    { 1981,   3,   6,    58,   2,0,   1 },
    { 1981,   3,   7,    58,   2,0,   2 },
    { 1981,   3,  21,    58,   2,0,  16 },
    { 1981,   3,  31,    58,   2,0,  26 },
    { 1981,   4,   1,    58,   2,0,  27 },
    { 1981,   4,   4,    58,   2,0,  30 },
    { 1981,   4,   5,    58,   3,0,   1 },
    { 1981,   4,   6,    58,   3,0,   2 },
    { 1981,   4,  20,    58,   3,0,  16 },
    { 1981,   4,  30,    58,   3,0,  26 },
    { 1981,   5,   1,    58,   3,0,  27 },
    { 1981,   5,   3,    58,   3,0,  29 },
    { 1981,   5,   4,    58,   4,0,   1 },
    { 1981,   5,   5,    58,   4,0,   2 },
    { 1981,   5,  21,    58,   4,0,  18 },
    { 1981,   6,   1,    58,   4,0,  29 },
    { 1981,   6,   2,    58,   5,0,   1 },
    { 1981,   6,   3,    58,   5,0,   2 },
    { 1981,   6,   6,    58,   5,0,   5 },
    { 1981,   6,  21,    58,   5,0,  20 },
    { 1981,   7,   1,    58,   5,0,  30 },
    { 1981,   7,   2,    58,   6,0,   1 },
    { 1981,   7,   3,    58,   6,0,   2 },
    { 1981,   7,   7,    58,   6,0,   6 },
    { 1981,   7,  23,    58,   6,0,  22 },
    { 1981,   7,  30,    58,   6,0,  29 },
    { 1981,   7,  31,    58,   7,0,   1 },
    { 1981,   8,   1,    58,   7,0,   2 },
    { 1981,   8,   7,    58,   7,0,   8 },
    { 1981,   8,  23,    58,   7,0,  24 },
    { 1981,   8,  28,    58,   7,0,  29 },
    { 1981,   8,  29,    58,   8,0,   1 },
    { 1981,   8,  30,    58,   8,0,   2 },
    { 1981,   8,  31,    58,   8,0,   3 },
    { 1981,   9,   1,    58,   8,0,   4 },
    { 1981,   9,   8,    58,   8,0,  11 },
    { 1981,   9,  23,    58,   8,0,  26 },
    { 1981,   9,  27,    58,   8,0,  30 },
    { 1981,   9,  28,    58,   9,0,   1 },
    { 1981,   9,  29,    58,   9,0,   2 },
    { 1981,   9,  30,    58,   9,0,   3 },
    { 1981,  10,   1,    58,   9,0,   4 },
    { 1981,  10,   8,    58,   9,0,  11 },
    { 1981,  10,  23,    58,   9,0,  26 },
    { 1981,  10,  27,    58,   9,0,  30 },
    { 1981,  10,  28,    58,  10,0,   1 },
    { 1981,  10,  29,    58,  10,0,   2 },
    { 1981,  10,  31,    58,  10,0,   4 },
    { 1981,  11,   1,    58,  10,0,   5 },
    { 1981,  11,   7,    58,  10,0,  11 },
    { 1981,  11,  22,    58,  10,0,  26 },
    { 1981,  11,  25,    58,  10,0,  29 },
    { 1981,  11,  26,    58,  11,0,   1 },
    { 1981,  11,  27,    58,  11,0,   2 },
    { 1981,  11,  30,    58,  11,0,   5 },
    { 1981,  12,   1,    58,  11,0,   6 },
    { 1981,  12,   7,    58,  11,0,  12 },
    { 1981,  12,  22,    58,  11,0,  27 },
    { 1981,  12,  25,    58,  11,0,  30 },
    { 1981,  12,  26,    58,  12,0,   1 },
    { 1981,  12,  27,    58,  12,0,   2 },
    { 1981,  12,  31,    58,  12,0,   6 },
    { 1982,   1,   1,    58,  12,0,   7 },
    { 1982,   1,   6,    58,  12,0,  12 },
    { 1982,   1,  20,    58,  12,0,  26 },
    { 1982,   1,  24,    58,  12,0,  30 },
    { 1982,   1,  25,    59,   1,0,   1 },
    { 1982,   1,  26,    59,   1,0,   2 },
    { 1982,   1,  31,    59,   1,0,   7 },
    { 1982,   2,   1,    59,   1,0,   8 },
    { 1982,   2,   4,    59,   1,0,  11 },
    { 1982,   2,  19,    59,   1,0,  26 },
    { 1982,   2,  23,    59,   1,0,  30 },
    { 1982,   2,  24,    59,   2,0,   1 },
    { 1982,   2,  25,    59,   2,0,   2 },
    { 1982,   2,  28,    59,   2,0,   5 },
    { 1982,   3,   1,    59,   2,0,   6 },
    { 1982,   3,   6,    59,   2,0,  11 },
    { 1982,   3,  21,    59,   2,0,  26 },
    { 1982,   3,  24,    59,   2,0,  29 },
    { 1982,   3,  25,    59,   3,0,   1 },
    { 1982,   3,  26,    59,   3,0,   2 },
    { 1982,   3,  31,    59,   3,0,   7 },
    { 1982,   4,   1,    59,   3,0,   8 },
    { 1982,   4,   5,    59,   3,0,  12 },
    { 1982,   4,  20,    59,   3,0,  27 },
    { 1982,   4,  23,    59,   3,0,  30 },
    { 1982,   4,  24,    59,   4,0,   1 },
    { 1982,   4,  25,    59,   4,0,   2 },
    { 1982,   4,  30,    59,   4,0,   7 },
    { 1982,   5,   1,    59,   4,0,   8 },
    { 1982,   5,   6,    59,   4,0,  13 },
    { 1982,   5,  21,    59,   4,0,  28 },
    { 1982,   5,  22,    59,   4,0,  29 },
    { 1982,   5,  23,    59,   4,1,   1 },
    { 1982,   5,  24,    59,   4,1,   2 },
    { 1982,   5,  31,    59,   4,1,   9 },
    { 1982,   6,   1,    59,   4,1,  10 },
    { 1982,   6,   6,    59,   4,1,  15 },
    { 1982,   6,  20,    59,   4,1,  29 },
    { 1982,   6,  21,    59,   5,0,   1 },
    { 1982,   6,  22,    59,   5,0,   2 },
    { 1982,   6,  30,    59,   5,0,  10 },
    { 1982,   7,   1,    59,   5,0,  11 },
    { 1982,   7,   7,    59,   5,0,  17 },
    { 1982,   7,  20,    59,   5,0,  30 },
    { 1982,   7,  21,    59,   6,0,   1 },
    { 1982,   7,  22,    59,   6,0,   2 },
    { 1982,   7,  23,    59,   6,0,   3 },
    { 1982,   7,  31,    59,   6,0,  11 },
    { 1982,   8,   1,    59,   6,0,  12 },
    { 1982,   8,   8,    59,   6,0,  19 },
    { 1982,   8,  18,    59,   6,0,  29 },
    { 1982,   8,  19,    59,   7,0,   1 },
    { 1982,   8,  20,    59,   7,0,   2 },
    { 1982,   8,  23,    59,   7,0,   5 },
    { 1982,   8,  31,    59,   7,0,  13 },
    { 1982,   9,   1,    59,   7,0,  14 },
    { 1982,   9,   8,    59,   7,0,  21 },
    { 1982,   9,  16,    59,   7,0,  29 },
    { 1982,   9,  17,    59,   8,0,   1 },
    { 1982,   9,  18,    59,   8,0,   2 },
    { 1982,   9,  23,    59,   8,0,   7 },
    { 1982,   9,  30,    59,   8,0,  14 },
    { 1982,  10,   1,    59,   8,0,  15 },
    { 1982,  10,   8,    59,   8,0,  22 },
    { 1982,  10,  16,    59,   8,0,  30 },
    { 1982,  10,  17,    59,   9,0,   1 },
    { 1982,  10,  18,    59,   9,0,   2 },
    { 1982,  10,  24,    59,   9,0,   8 },
    { 1982,  10,  31,    59,   9,0,  15 },
    { 1982,  11,   1,    59,   9,0,  16 },
    { 1982,  11,   8,    59,   9,0,  23 },
    { 1982,  11,  14,    59,   9,0,  29 },
    { 1982,  11,  15,    59,  10,0,   1 },
    { 1982,  11,  16,    59,  10,0,   2 },
    { 1982,  11,  22,    59,  10,0,   8 },
    { 1982,  11,  30,    59,  10,0,  16 },
    { 1982,  12,   1,    59,  10,0,  17 },
    { 1982,  12,   7,    59,  10,0,  23 },
    { 1982,  12,  14,    59,  10,0,  30 },
    { 1982,  12,  15,    59,  11,0,   1 },
    { 1982,  12,  16,    59,  11,0,   2 },
    { 1982,  12,  22,    59,  11,0,   8 },
    { 1982,  12,  31,    59,  11,0,  17 },
    { 1983,   1,   1,    59,  11,0,  18 },
    { 1983,   1,   6,    59,  11,0,  23 },
    { 1983,   1,  13,    59,  11,0,  30 },
    { 1983,   1,  14,    59,  12,0,   1 },
    { 1983,   1,  15,    59,  12,0,   2 },
    { 1983,   1,  20,    59,  12,0,   7 },
    { 1983,   1,  31,    59,  12,0,  18 },
    { 1983,   2,   1,    59,  12,0,  19 },
    { 1983,   2,   4,    59,  12,0,  22 },
    { 1983,   2,  12,    59,  12,0,  30 },
    { 1983,   2,  13,    60,   1,0,   1 },
    { 1983,   2,  14,    60,   1,0,   2 },
    { 1983,   2,  19,    60,   1,0,   7 },
    { 1983,   2,  28,    60,   1,0,  16 },
    { 1983,   3,   1,    60,   1,0,  17 },
    { 1983,   3,   6,    60,   1,0,  22 },
    { 1983,   3,  14,    60,   1,0,  30 },
    { 1983,   3,  15,    60,   2,0,   1 },
    { 1983,   3,  16,    60,   2,0,   2 },
    { 1983,   3,  21,    60,   2,0,   7 },
    { 1983,   3,  31,    60,   2,0,  17 },
    { 1983,   4,   1,    60,   2,0,  18 },
    { 1983,   4,   5,    60,   2,0,  22 },
    { 1983,   4,  12,    60,   2,0,  29 },
    { 1983,   4,  13,    60,   3,0,   1 },
    { 1983,   4,  14,    60,   3,0,   2 },
    { 1983,   4,  20,    60,   3,0,   8 },
    { 1983,   4,  30,    60,   3,0,  18 },
    { 1983,   5,   1,    60,   3,0,  19 },
    { 1983,   5,   6,    60,   3,0,  24 },
    { 1983,   5,  12,    60,   3,0,  30 },
    { 1983,   5,  13,    60,   4,0,   1 },
    { 1983,   5,  14,    60,   4,0,   2 },
    { 1983,   5,  21,    60,   4,0,   9 },
    { 1983,   5,  31,    60,   4,0,  19 },
    { 1983,   6,   1,    60,   4,0,  20 },
    { 1983,   6,   6,    60,   4,0,  25 },
    { 1983,   6,  10,    60,   4,0,  29 },
    { 1983,   6,  11,    60,   5,0,   1 },
    { 1983,   6,  12,    60,   5,0,   2 },
    { 1983,   6,  22,    60,   5,0,  12 },
    { 1983,   6,  30,    60,   5,0,  20 },
    { 1983,   7,   1,    60,   5,0,  21 },
    { 1983,   7,   8,    60,   5,0,  28 },
    { 1983,   7,   9,    60,   5,0,  29 },
    { 1983,   7,  10,    60,   6,0,   1 },
    { 1983,   7,  11,    60,   6,0,   2 },
    { 1983,   7,  23,    60,   6,0,  14 },
    { 1983,   7,  31,    60,   6,0,  22 },
    { 1983,   8,   1,    60,   6,0,  23 },
    { 1983,   8,   8,    60,   6,0,  30 },
    { 1983,   8,   9,    60,   7,0,   1 },
    { 1983,   8,  10,    60,   7,0,   2 },
    { 1983,   8,  24,    60,   7,0,  16 },
    { 1983,   8,  31,    60,   7,0,  23 },
    { 1983,   9,   1,    60,   7,0,  24 },
    { 1983,   9,   6,    60,   7,0,  29 },
    { 1983,   9,   7,    60,   8,0,   1 },
    { 1983,   9,   8,    60,   8,0,   2 },
    { 1983,   9,  23,    60,   8,0,  17 },
    { 1983,   9,  30,    60,   8,0,  24 },
    { 1983,  10,   1,    60,   8,0,  25 },
    { 1983,  10,   5,    60,   8,0,  29 },
    { 1983,  10,   6,    60,   9,0,   1 },
    { 1983,  10,   7,    60,   9,0,   2 },
    { 1983,  10,   9,    60,   9,0,   4 },
    { 1983,  10,  24,    60,   9,0,  19 },
    { 1983,  10,  31,    60,   9,0,  26 },
    { 1983,  11,   1,    60,   9,0,  27 },
    { 1983,  11,   4,    60,   9,0,  30 },
    { 1983,  11,   5,    60,  10,0,   1 },
    { 1983,  11,   6,    60,  10,0,   2 },
    { 1983,  11,   8,    60,  10,0,   4 },
    { 1983,  11,  23,    60,  10,0,  19 },
    { 1983,  11,  30,    60,  10,0,  26 },
    { 1983,  12,   1,    60,  10,0,  27 },
    { 1983,  12,   3,    60,  10,0,  29 },
    { 1983,  12,   4,    60,  11,0,   1 },
    { 1983,  12,   5,    60,  11,0,   2 },
    { 1983,  12,   8,    60,  11,0,   5 },
    { 1983,  12,  22,    60,  11,0,  19 },
    { 1984,   1,   2,    60,  11,0,  30 },
    { 1984,   1,   3,    60,  12,0,   1 },
    { 1984,   1,   4,    60,  12,0,   2 },
    { 1984,   1,   6,    60,  12,0,   4 },
    { 1984,   1,  21,    60,  12,0,  19 },
    { 1984,   2,   1,    60,  12,0,  30 },
    { 1984,   2,   2,     1,   1,0,   1 },
    { 1984,   2,   3,     1,   1,0,   2 },
    { 1984,   2,   4,     1,   1,0,   3 },
    { 1984,   2,  19,     1,   1,0,  18 },
    { 1984,   3,   2,     1,   1,0,  30 },
    { 1984,   3,   3,     1,   2,0,   1 },
    { 1984,   3,   4,     1,   2,0,   2 },
    { 1984,   3,   5,     1,   2,0,   3 },
    { 1984,   3,  20,     1,   2,0,  18 },
    { 1984,   3,  31,     1,   2,0,  29 },
    { 1984,   4,   1,     1,   3,0,   1 },
    { 1984,   4,   4,     1,   3,0,   4 },
    { 1984,   4,  20,     1,   3,0,  20 },
    { 1984,   4,  30,     1,   3,0,  30 },
    { 1984,   5,   1,     1,   4,0,   1 },
    { 1984,   5,   5,     1,   4,0,   5 },
    { 1984,   5,  21,     1,   4,0,  21 },
    { 1984,   5,  30,     1,   4,0,  30 },
    { 1984,   5,  31,     1,   5,0,   1 },
    { 1984,   6,   1,     1,   5,0,   2 },
    { 1984,   6,   5,     1,   5,0,   6 },
    { 1984,   6,  21,     1,   5,0,  22 },
    { 1984,   6,  28,     1,   5,0,  29 },
    { 1984,   6,  29,     1,   6,0,   1 },
    { 1984,   6,  30,     1,   6,0,   2 },
    { 1984,   7,   1,     1,   6,0,   3 },
    { 1984,   7,   7,     1,   6,0,   9 },
    { 1984,   7,  22,     1,   6,0,  24 },
    { 1984,   7,  27,     1,   6,0,  29 },
    { 1984,   7,  28,     1,   7,0,   1 },
    { 1984,   7,  29,     1,   7,0,   2 },
    { 1984,   7,  31,     1,   7,0,   4 },
    { 1984,   8,   1,     1,   7,0,   5 },
    { 1984,   8,   7,     1,   7,0,  11 },
    { 1984,   8,  23,     1,   7,0,  27 },
    { 1984,   8,  26,     1,   7,0,  30 },
    { 1984,   8,  27,     1,   8,0,   1 },
    { 1984,   8,  28,     1,   8,0,   2 },
    { 1984,   8,  31,     1,   8,0,   5 },
    { 1984,   9,   1,     1,   8,0,   6 },
    { 1984,   9,   7,     1,   8,0,  12 },
    { 1984,   9,  23,     1,   8,0,  28 },
    { 1984,   9,  24,     1,   8,0,  29 },
    { 1984,   9,  25,     1,   9,0,   1 },
    { 1984,   9,  26,     1,   9,0,   2 },
    { 1984,   9,  30,     1,   9,0,   6 },
    { 1984,  10,   1,     1,   9,0,   7 },
    { 1984,  10,   8,     1,   9,0,  14 },
    { 1984,  10,  23,     1,   9,0,  29 },
    { 1984,  10,  24,     1,  10,0,   1 },
    { 1984,  10,  25,     1,  10,0,   2 },
    { 1984,  10,  31,     1,  10,0,   8 },
    { 1984,  11,   1,     1,  10,0,   9 },
    { 1984,  11,   7,     1,  10,0,  15 },
    { 1984,  11,  22,     1,  10,0,  30 },
    { 1984,  11,  23,     1,  10,1,   1 },
    { 1984,  11,  24,     1,  10,1,   2 },
    { 1984,  11,  30,     1,  10,1,   8 },
    { 1984,  12,   1,     1,  10,1,   9 },
    { 1984,  12,   7,     1,  10,1,  15 },
    { 1984,  12,  21,     1,  10,1,  29 },
    { 1984,  12,  22,     1,  11,0,   1 },
    { 1984,  12,  23,     1,  11,0,   2 },
    { 1984,  12,  31,     1,  11,0,  10 },
    { 1985,   1,   1,     1,  11,0,  11 },
    { 1985,   1,   5,     1,  11,0,  15 },
    { 1985,   1,  20,     1,  11,0,  30 },
    { 1985,   1,  21,     1,  12,0,   1 },
    { 1985,   1,  22,     1,  12,0,   2 },
    { 1985,   1,  31,     1,  12,0,  11 },
    { 1985,   2,   1,     1,  12,0,  12 },
    { 1985,   2,   4,     1,  12,0,  15 },
    { 1985,   2,  19,     1,  12,0,  30 },
    { 1985,   2,  20,     2,   1,0,   1 },
    { 1985,   2,  21,     2,   1,0,   2 },
    { 1985,   2,  28,     2,   1,0,   9 },
    { 1985,   3,   1,     2,   1,0,  10 },
    { 1985,   3,   5,     2,   1,0,  14 },
    { 1985,   3,  20,     2,   1,0,  29 },
    { 1985,   3,  21,     2,   2,0,   1 },
    { 1985,   3,  22,     2,   2,0,   2 },
    { 1985,   3,  31,     2,   2,0,  11 },
    { 1985,   4,   1,     2,   2,0,  12 },
    { 1985,   4,   5,     2,   2,0,  16 },
    { 1985,   4,  19,     2,   2,0,  30 },
    { 1985,   4,  20,     2,   3,0,   1 },
    { 1985,   4,  21,     2,   3,0,   2 },
    { 1985,   4,  30,     2,   3,0,  11 },
    { 1985,   5,   1,     2,   3,0,  12 },
    { 1985,   5,   5,     2,   3,0,  16 },
    { 1985,   5,  19,     2,   3,0,  30 },
    { 1985,   5,  20,     2,   4,0,   1 },
    { 1985,   5,  21,     2,   4,0,   2 },
    { 1985,   5,  31,     2,   4,0,  12 },
    { 1985,   6,   1,     2,   4,0,  13 },
    { 1985,   6,   6,     2,   4,0,  18 },
    { 1985,   6,  17,     2,   4,0,  29 },
    { 1985,   6,  18,     2,   5,0,   1 },
    { 1985,   6,  19,     2,   5,0,   2 },
    { 1985,   6,  21,     2,   5,0,   4 },
    { 1985,   6,  30,     2,   5,0,  13 },
    { 1985,   7,   1,     2,   5,0,  14 },
    { 1985,   7,   7,     2,   5,0,  20 },
    { 1985,   7,  17,     2,   5,0,  30 },
    { 1985,   7,  18,     2,   6,0,   1 },
    { 1985,   7,  19,     2,   6,0,   2 },
    { 1985,   7,  23,     2,   6,0,   6 },
    { 1985,   7,  31,     2,   6,0,  14 },
    { 1985,   8,   1,     2,   6,0,  15 },
    { 1985,   8,   7,     2,   6,0,  21 },
    { 1985,   8,  15,     2,   6,0,  29 },
    { 1985,   8,  16,     2,   7,0,   1 },
    { 1985,   8,  17,     2,   7,0,   2 },
    { 1985,   8,  23,     2,   7,0,   8 },
    { 1985,   8,  31,     2,   7,0,  16 },
    { 1985,   9,   1,     2,   7,0,  17 },
    { 1985,   9,   8,     2,   7,0,  24 },
    { 1985,   9,  14,     2,   7,0,  30 },
    { 1985,   9,  15,     2,   8,0,   1 },
    { 1985,   9,  16,     2,   8,0,   2 },
    { 1985,   9,  23,     2,   8,0,   9 },
    { 1985,   9,  30,     2,   8,0,  16 },
    { 1985,  10,   1,     2,   8,0,  17 },
    { 1985,  10,   8,     2,   8,0,  24 },
    { 1985,  10,  13,     2,   8,0,  29 },
    { 1985,  10,  14,     2,   9,0,   1 },
    { 1985,  10,  15,     2,   9,0,   2 },
    { 1985,  10,  23,     2,   9,0,  10 },
    { 1985,  10,  31,     2,   9,0,  18 },
    { 1985,  11,   1,     2,   9,0,  19 },
    { 1985,  11,   7,     2,   9,0,  25 },
    { 1985,  11,  11,     2,   9,0,  29 },
    { 1985,  11,  12,     2,  10,0,   1 },
    { 1985,  11,  13,     2,  10,0,   2 },
    { 1985,  11,  22,     2,  10,0,  11 },
    { 1985,  11,  30,     2,  10,0,  19 },
    { 1985,  12,   1,     2,  10,0,  20 },
    { 1985,  12,   7,     2,  10,0,  26 },
    { 1985,  12,  11,     2,  10,0,  30 },
    { 1985,  12,  12,     2,  11,0,   1 },
    { 1985,  12,  13,     2,  11,0,   2 },
    { 1985,  12,  22,     2,  11,0,  11 },
    { 1985,  12,  31,     2,  11,0,  20 },
    { 1986,   1,   1,     2,  11,0,  21 },
    { 1986,   1,   5,     2,  11,0,  25 },
    { 1986,   1,   9,     2,  11,0,  29 },
    { 1986,   1,  10,     2,  12,0,   1 },
    { 1986,   1,  11,     2,  12,0,   2 },
    { 1986,   1,  20,     2,  12,0,  11 },
    { 1986,   1,  31,     2,  12,0,  22 },
    { 1986,   2,   1,     2,  12,0,  23 },
    { 1986,   2,   4,     2,  12,0,  26 },
    { 1986,   2,   8,     2,  12,0,  30 },
    { 1986,   2,   9,     3,   1,0,   1 },
    { 1986,   2,  10,     3,   1,0,   2 },
    { 1986,   2,  19,     3,   1,0,  11 },
    { 1986,   2,  28,     3,   1,0,  20 },
    { 1986,   3,   1,     3,   1,0,  21 },
    { 1986,   3,   6,     3,   1,0,  26 },
    { 1986,   3,   9,     3,   1,0,  29 },
    { 1986,   3,  10,     3,   2,0,   1 },
    { 1986,   3,  11,     3,   2,0,   2 },
    { 1986,   3,  21,     3,   2,0,  12 },
    { 1986,   3,  31,     3,   2,0,  22 },
    { 1986,   4,   1,     3,   2,0,  23 },
    { 1986,   4,   5,     3,   2,0,  27 },
    { 1986,   4,   8,     3,   2,0,  30 },
    { 1986,   4,   9,     3,   3,0,   1 },
    { 1986,   4,  10,     3,   3,0,   2 },
    { 1986,   4,  20,     3,   3,0,  12 },
    { 1986,   4,  30,     3,   3,0,  22 },
    { 1986,   5,   1,     3,   3,0,  23 },
    { 1986,   5,   6,     3,   3,0,  28 },
    { 1986,   5,   8,     3,   3,0,  30 },
    { 1986,   5,   9,     3,   4,0,   1 },
    { 1986,   5,  10,     3,   4,0,   2 },
    { 1986,   5,  21,     3,   4,0,  13 },
    { 1986,   5,  31,     3,   4,0,  23 },
    { 1986,   6,   1,     3,   4,0,  24 },
    { 1986,   6,   6,     3,   4,0,  29 },
    { 1986,   6,   7,     3,   5,0,   1 },
    { 1986,   6,   8,     3,   5,0,   2 },
    { 1986,   6,  22,     3,   5,0,  16 },
    { 1986,   6,  30,     3,   5,0,  24 },
    { 1986,   7,   1,     3,   5,0,  25 },
    { 1986,   7,   6,     3,   5,0,  30 },
    { 1986,   7,   7,     3,   6,0,   1 },
    { 1986,   7,   8,     3,   6,0,   2 },
    { 1986,   7,  23,     3,   6,0,  17 },
    { 1986,   7,  31,     3,   6,0,  25 },
    { 1986,   8,   1,     3,   6,0,  26 },
    { 1986,   8,   5,     3,   6,0,  30 },
    { 1986,   8,   6,     3,   7,0,   1 },
    { 1986,   8,   7,     3,   7,0,   2 },
    { 1986,   8,   8,     3,   7,0,   3 },
    { 1986,   8,  23,     3,   7,0,  18 },
    { 1986,   8,  31,     3,   7,0,  26 },
    { 1986,   9,   1,     3,   7,0,  27 },
    { 1986,   9,   3,     3,   7,0,  29 },
    { 1986,   9,   4,     3,   8,0,   1 },
    { 1986,   9,   5,     3,   8,0,   2 },
    { 1986,   9,   8,     3,   8,0,   5 },
    { 1986,   9,  23,     3,   8,0,  20 },
    { 1986,   9,  30,     3,   8,0,  27 },
    { 1986,  10,   1,     3,   8,0,  28 },
    { 1986,  10,   3,     3,   8,0,  30 },
    { 1986,  10,   4,     3,   9,0,   1 },
    { 1986,  10,   5,     3,   9,0,   2 },
    { 1986,  10,   8,     3,   9,0,   5 },
    { 1986,  10,  24,     3,   9,0,  21 },
    { 1986,  11,   1,     3,   9,0,  29 },
    { 1986,  11,   2,     3,  10,0,   1 },
    { 1986,  11,   3,     3,  10,0,   2 },
    { 1986,  11,   8,     3,  10,0,   7 },
    { 1986,  11,  22,     3,  10,0,  21 },
    { 1986,  12,   1,     3,  10,0,  30 },
    { 1986,  12,   2,     3,  11,0,   1 },
    { 1986,  12,   3,     3,  11,0,   2 },
    { 1986,  12,   7,     3,  11,0,   6 },
    { 1986,  12,  22,     3,  11,0,  21 },
    { 1986,  12,  30,     3,  11,0,  29 },
    { 1986,  12,  31,     3,  12,0,   1 },
    { 1987,   1,   1,     3,  12,0,   2 },
    { 1987,   1,   6,     3,  12,0,   7 },
    { 1987,   1,  20,     3,  12,0,  21 },
    { 1987,   1,  28,     3,  12,0,  29 },
    { 1987,   1,  29,     4,   1,0,   1 },
    { 1987,   1,  30,     4,   1,0,   2 },
    { 1987,   1,  31,     4,   1,0,   3 },
    { 1987,   2,   1,     4,   1,0,   4 },
    { 1987,   2,   4,     4,   1,0,   7 },
    { 1987,   2,  19,     4,   1,0,  22 },
    { 1987,   2,  27,     4,   1,0,  30 },
    { 1987,   2,  28,     4,   2,0,   1 },
    { 1987,   3,   1,     4,   2,0,   2 },
    { 1987,   3,   6,     4,   2,0,   7 },
    { 1987,   3,  21,     4,   2,0,  22 },
    { 1987,   3,  28,     4,   2,0,  29 },
    { 1987,   3,  29,     4,   3,0,   1 },
    { 1987,   3,  30,     4,   3,0,   2 },
    { 1987,   3,  31,     4,   3,0,   3 },
    { 1987,   4,   1,     4,   3,0,   4 },
    { 1987,   4,   5,     4,   3,0,   8 },
    { 1987,   4,  20,     4,   3,0,  23 },
    { 1987,   4,  27,     4,   3,0,  30 },
    { 1987,   4,  28,     4,   4,0,   1 },
    { 1987,   4,  29,     4,   4,0,   2 },
    { 1987,   4,  30,     4,   4,0,   3 },
    { 1987,   5,   1,     4,   4,0,   4 },
    { 1987,   5,   6,     4,   4,0,   9 },
    { 1987,   5,  21,     4,   4,0,  24 },
    { 1987,   5,  26,     4,   4,0,  29 },
    { 1987,   5,  27,     4,   5,0,   1 },
    { 1987,   5,  28,     4,   5,0,   2 },
    { 1987,   5,  31,     4,   5,0,   5 },
    { 1987,   6,   1,     4,   5,0,   6 },
    { 1987,   6,   6,     4,   5,0,  11 },
    { 1987,   6,  22,     4,   5,0,  27 },
    { 1987,   6,  25,     4,   5,0,  30 },
    { 1987,   6,  26,     4,   6,0,   1 },
    { 1987,   6,  27,     4,   6,0,   2 },
    { 1987,   6,  30,     4,   6,0,   5 },
    { 1987,   7,   1,     4,   6,0,   6 },
    { 1987,   7,   7,     4,   6,0,  12 },
    { 1987,   7,  23,     4,   6,0,  28 },
    { 1987,   7,  25,     4,   6,0,  30 },
//# { 1987,   7,  26,     4,   6,1,   1 },
//# { 1987,   7,  27,     4,   6,1,   2 },
//# { 1987,   7,  31,     4,   6,1,   6 },
//# { 1987,   8,   1,     4,   6,1,   7 },
//# { 1987,   8,   8,     4,   6,1,  14 },
//# { 1987,   8,  23,     4,   6,1,  29 },
//# { 1987,   8,  24,     4,   7,0,   1 },
//# { 1987,   8,  25,     4,   7,0,   2 },
//# { 1987,   8,  31,     4,   7,0,   8 },
//# { 1987,   9,   1,     4,   7,0,   9 },
//# { 1987,   9,   8,     4,   7,0,  16 },
//# { 1987,   9,  22,     4,   7,0,  30 },
    { 1987,   9,  23,     4,   8,0,   1 },
    { 1987,   9,  24,     4,   8,0,   2 },
    { 1987,   9,  30,     4,   8,0,   8 },
    { 1987,  10,   1,     4,   8,0,   9 },
    { 1987,  10,   9,     4,   8,0,  17 },
    { 1987,  10,  22,     4,   8,0,  30 },
    { 1987,  10,  23,     4,   9,0,   1 },
    { 1987,  10,  24,     4,   9,0,   2 },
    { 1987,  10,  31,     4,   9,0,   9 },
    { 1987,  11,   1,     4,   9,0,  10 },
    { 1987,  11,   8,     4,   9,0,  17 },
    { 1987,  11,  20,     4,   9,0,  29 },
    { 1987,  11,  21,     4,  10,0,   1 },
    { 1987,  11,  22,     4,  10,0,   2 },
    { 1987,  11,  23,     4,  10,0,   3 },
    { 1987,  11,  30,     4,  10,0,  10 },
    { 1987,  12,   1,     4,  10,0,  11 },
    { 1987,  12,   7,     4,  10,0,  17 },
    { 1987,  12,  20,     4,  10,0,  30 },
    { 1987,  12,  21,     4,  11,0,   1 },
    { 1987,  12,  22,     4,  11,0,   2 },
    { 1987,  12,  31,     4,  11,0,  11 },
    { 1988,   1,   1,     4,  11,0,  12 },
    { 1988,   1,   6,     4,  11,0,  17 },
    { 1988,   1,  18,     4,  11,0,  29 },
    { 1988,   1,  19,     4,  12,0,   1 },
    { 1988,   1,  20,     4,  12,0,   2 },
    { 1988,   1,  21,     4,  12,0,   3 },
    { 1988,   1,  31,     4,  12,0,  13 },
    { 1988,   2,   1,     4,  12,0,  14 },
    { 1988,   2,   4,     4,  12,0,  17 },
    { 1988,   2,  16,     4,  12,0,  29 },
    { 1988,   2,  17,     5,   1,0,   1 },
    { 1988,   2,  18,     5,   1,0,   2 },
    { 1988,   2,  19,     5,   1,0,   3 },
    { 1988,   2,  29,     5,   1,0,  13 },
    { 1988,   3,   1,     5,   1,0,  14 },
    { 1988,   3,   5,     5,   1,0,  18 },
    { 1988,   3,  17,     5,   1,0,  30 },
    { 1988,   3,  18,     5,   2,0,   1 },
    { 1988,   3,  19,     5,   2,0,   2 },
    { 1988,   3,  20,     5,   2,0,   3 },
    { 1988,   3,  31,     5,   2,0,  14 },
    { 1988,   4,   1,     5,   2,0,  15 },
    { 1988,   4,   4,     5,   2,0,  18 },
    { 1988,   4,  15,     5,   2,0,  29 },
    { 1988,   4,  16,     5,   3,0,   1 },
    { 1988,   4,  17,     5,   3,0,   2 },
    { 1988,   4,  20,     5,   3,0,   5 },
    { 1988,   4,  30,     5,   3,0,  15 },
    { 1988,   5,   1,     5,   3,0,  16 },
    { 1988,   5,   5,     5,   3,0,  20 },
    { 1988,   5,  15,     5,   3,0,  30 },
    { 1988,   5,  16,     5,   4,0,   1 },
    { 1988,   5,  17,     5,   4,0,   2 },
    { 1988,   5,  21,     5,   4,0,   6 },
    { 1988,   5,  31,     5,   4,0,  16 },
    { 1988,   6,   1,     5,   4,0,  17 },
    { 1988,   6,   5,     5,   4,0,  21 },
    { 1988,   6,  13,     5,   4,0,  29 },
    { 1988,   6,  14,     5,   5,0,   1 },
    { 1988,   6,  15,     5,   5,0,   2 },
    { 1988,   6,  21,     5,   5,0,   8 },
    { 1988,   6,  30,     5,   5,0,  17 },
    { 1988,   7,   1,     5,   5,0,  18 },
    { 1988,   7,   7,     5,   5,0,  24 },
    { 1988,   7,  13,     5,   5,0,  30 },
    { 1988,   7,  14,     5,   6,0,   1 },
    { 1988,   7,  15,     5,   6,0,   2 },
    { 1988,   7,  22,     5,   6,0,   9 },
    { 1988,   7,  31,     5,   6,0,  18 },
    { 1988,   8,   1,     5,   6,0,  19 },
    { 1988,   8,   7,     5,   6,0,  25 },
    { 1988,   8,  11,     5,   6,0,  29 },
    { 1988,   8,  12,     5,   7,0,   1 },
    { 1988,   8,  13,     5,   7,0,   2 },
    { 1988,   8,  23,     5,   7,0,  12 },
    { 1988,   8,  31,     5,   7,0,  20 },
    { 1988,   9,   1,     5,   7,0,  21 },
    { 1988,   9,   7,     5,   7,0,  27 },
    { 1988,   9,  10,     5,   7,0,  30 },
    { 1988,   9,  11,     5,   8,0,   1 },
    { 1988,   9,  12,     5,   8,0,   2 },
    { 1988,   9,  23,     5,   8,0,  13 },
    { 1988,   9,  30,     5,   8,0,  20 },
    { 1988,  10,   1,     5,   8,0,  21 },
    { 1988,  10,   8,     5,   8,0,  28 },
    { 1988,  10,  10,     5,   8,0,  30 },
    { 1988,  10,  11,     5,   9,0,   1 },
    { 1988,  10,  12,     5,   9,0,   2 },
    { 1988,  10,  23,     5,   9,0,  13 },
    { 1988,  10,  31,     5,   9,0,  21 },
    { 1988,  11,   1,     5,   9,0,  22 },
    { 1988,  11,   7,     5,   9,0,  28 },
    { 1988,  11,   8,     5,   9,0,  29 },
    { 1988,  11,   9,     5,  10,0,   1 },
    { 1988,  11,  10,     5,  10,0,   2 },
    { 1988,  11,  22,     5,  10,0,  14 },
    { 1988,  11,  30,     5,  10,0,  22 },
    { 1988,  12,   1,     5,  10,0,  23 },
    { 1988,  12,   7,     5,  10,0,  29 },
    { 1988,  12,   8,     5,  10,0,  30 },
    { 1988,  12,   9,     5,  11,0,   1 },
    { 1988,  12,  10,     5,  11,0,   2 },
    { 1988,  12,  21,     5,  11,0,  13 },
    { 1988,  12,  31,     5,  11,0,  23 },
    { 1989,   1,   1,     5,  11,0,  24 },
    { 1989,   1,   5,     5,  11,0,  28 },
    { 1989,   1,   7,     5,  11,0,  30 },
    { 1989,   1,   8,     5,  12,0,   1 },
    { 1989,   1,   9,     5,  12,0,   2 },
    { 1989,   1,  20,     5,  12,0,  13 },
    { 1989,   1,  31,     5,  12,0,  24 },
    { 1989,   2,   1,     5,  12,0,  25 },
    { 1989,   2,   4,     5,  12,0,  28 },
    { 1989,   2,   5,     5,  12,0,  29 },
    { 1989,   2,   6,     6,   1,0,   1 },
    { 1989,   2,   7,     6,   1,0,   2 },
    { 1989,   2,  19,     6,   1,0,  14 },
    { 1989,   2,  28,     6,   1,0,  23 },
    { 1989,   3,   1,     6,   1,0,  24 },
    { 1989,   3,   5,     6,   1,0,  28 },
    { 1989,   3,   7,     6,   1,0,  30 },
    { 1989,   3,   8,     6,   2,0,   1 },
    { 1989,   3,   9,     6,   2,0,   2 },
    { 1989,   3,  20,     6,   2,0,  13 },
    { 1989,   3,  31,     6,   2,0,  24 },
    { 1989,   4,   1,     6,   2,0,  25 },
    { 1989,   4,   5,     6,   2,0,  29 },
    { 1989,   4,   6,     6,   3,0,   1 },
    { 1989,   4,   7,     6,   3,0,   2 },
    { 1989,   4,  20,     6,   3,0,  15 },
    { 1989,   4,  30,     6,   3,0,  25 },
    { 1989,   5,   1,     6,   3,0,  26 },
    { 1989,   5,   4,     6,   3,0,  29 },
    { 1989,   5,   5,     6,   4,0,   1 },
    { 1989,   5,   6,     6,   4,0,   2 },
    { 1989,   5,  21,     6,   4,0,  17 },
    { 1989,   5,  31,     6,   4,0,  27 },
    { 1989,   6,   1,     6,   4,0,  28 },
    { 1989,   6,   3,     6,   4,0,  30 },
    { 1989,   6,   4,     6,   5,0,   1 },
    { 1989,   6,   5,     6,   5,0,   2 },
    { 1989,   6,   6,     6,   5,0,   3 },
    { 1989,   6,  21,     6,   5,0,  18 },
    { 1989,   7,   2,     6,   5,0,  29 },
    { 1989,   7,   3,     6,   6,0,   1 },
    { 1989,   7,   4,     6,   6,0,   2 },
    { 1989,   7,   7,     6,   6,0,   5 },
    { 1989,   7,  23,     6,   6,0,  21 },
    { 1989,   8,   1,     6,   6,0,  30 },
    { 1989,   8,   2,     6,   7,0,   1 },
    { 1989,   8,   3,     6,   7,0,   2 },
    { 1989,   8,   7,     6,   7,0,   6 },
    { 1989,   8,  23,     6,   7,0,  22 },
    { 1989,   8,  30,     6,   7,0,  29 },
    { 1989,   8,  31,     6,   8,0,   1 },
    { 1989,   9,   1,     6,   8,0,   2 },
    { 1989,   9,   7,     6,   8,0,   8 },
    { 1989,   9,  23,     6,   8,0,  24 },
    { 1989,   9,  29,     6,   8,0,  30 },
    { 1989,   9,  30,     6,   9,0,   1 },
    { 1989,  10,   1,     6,   9,0,   2 },
    { 1989,  10,   8,     6,   9,0,   9 },
    { 1989,  10,  23,     6,   9,0,  24 },
    { 1989,  10,  28,     6,   9,0,  29 },
    { 1989,  10,  29,     6,  10,0,   1 },
    { 1989,  10,  30,     6,  10,0,   2 },
    { 1989,  10,  31,     6,  10,0,   3 },
    { 1989,  11,   1,     6,  10,0,   4 },
    { 1989,  11,   7,     6,  10,0,  10 },
    { 1989,  11,  22,     6,  10,0,  25 },
    { 1989,  11,  27,     6,  10,0,  30 },
    { 1989,  11,  28,     6,  11,0,   1 },
    { 1989,  11,  29,     6,  11,0,   2 },
    { 1989,  11,  30,     6,  11,0,   3 },
    { 1989,  12,   1,     6,  11,0,   4 },
    { 1989,  12,   7,     6,  11,0,  10 },
    { 1989,  12,  22,     6,  11,0,  25 },
    { 1989,  12,  27,     6,  11,0,  30 },
    { 1989,  12,  28,     6,  12,0,   1 },
    { 1989,  12,  29,     6,  12,0,   2 },
    { 1989,  12,  31,     6,  12,0,   4 },
    { 1990,   1,   1,     6,  12,0,   5 },
    { 1990,   1,   5,     6,  12,0,   9 },
    { 1990,   1,  20,     6,  12,0,  24 },
    { 1990,   1,  26,     6,  12,0,  30 },
    { 1990,   1,  27,     7,   1,0,   1 },
    { 1990,   1,  28,     7,   1,0,   2 },
    { 1990,   1,  31,     7,   1,0,   5 },
    { 1990,   2,   1,     7,   1,0,   6 },
    { 1990,   2,   4,     7,   1,0,   9 },
    { 1990,   2,  19,     7,   1,0,  24 },
    { 1990,   2,  24,     7,   1,0,  29 },
    { 1990,   2,  25,     7,   2,0,   1 },
    { 1990,   2,  26,     7,   2,0,   2 },
    { 1990,   2,  28,     7,   2,0,   4 },
    { 1990,   3,   1,     7,   2,0,   5 },
    { 1990,   3,   6,     7,   2,0,  10 },
    { 1990,   3,  21,     7,   2,0,  25 },
    { 1990,   3,  26,     7,   2,0,  30 },
    { 1990,   3,  27,     7,   3,0,   1 },
    { 1990,   3,  28,     7,   3,0,   2 },
    { 1990,   3,  31,     7,   3,0,   5 },
    { 1990,   4,   1,     7,   3,0,   6 },
    { 1990,   4,   5,     7,   3,0,  10 },
    { 1990,   4,  20,     7,   3,0,  25 },
    { 1990,   4,  24,     7,   3,0,  29 },
    { 1990,   4,  25,     7,   4,0,   1 },
    { 1990,   4,  26,     7,   4,0,   2 },
    { 1990,   4,  30,     7,   4,0,   6 },
    { 1990,   5,   1,     7,   4,0,   7 },
    { 1990,   5,   6,     7,   4,0,  12 },
    { 1990,   5,  21,     7,   4,0,  27 },
    { 1990,   5,  23,     7,   4,0,  29 },
    { 1990,   5,  24,     7,   5,0,   1 },
    { 1990,   5,  25,     7,   5,0,   2 },
    { 1990,   5,  31,     7,   5,0,   8 },
    { 1990,   6,   1,     7,   5,0,   9 },
    { 1990,   6,   6,     7,   5,0,  14 },
    { 1990,   6,  21,     7,   5,0,  29 },
    { 1990,   6,  22,     7,   5,0,  30 },
    { 1990,   6,  23,     7,   5,1,   1 },
    { 1990,   6,  24,     7,   5,1,   2 },
    { 1990,   6,  30,     7,   5,1,   8 },
    { 1990,   7,   1,     7,   5,1,   9 },
    { 1990,   7,   7,     7,   5,1,  15 },
    { 1990,   7,  21,     7,   5,1,  29 },
    { 1990,   7,  22,     7,   6,0,   1 },
    { 1990,   7,  23,     7,   6,0,   2 },
    { 1990,   7,  31,     7,   6,0,  10 },
    { 1990,   8,   1,     7,   6,0,  11 },
    { 1990,   8,   8,     7,   6,0,  18 },
    { 1990,   8,  19,     7,   6,0,  29 },
    { 1990,   8,  20,     7,   7,0,   1 },
    { 1990,   8,  21,     7,   7,0,   2 },
    { 1990,   8,  23,     7,   7,0,   4 },
    { 1990,   8,  31,     7,   7,0,  12 },
    { 1990,   9,   1,     7,   7,0,  13 },
    { 1990,   9,   8,     7,   7,0,  20 },
    { 1990,   9,  18,     7,   7,0,  30 },
    { 1990,   9,  19,     7,   8,0,   1 },
    { 1990,   9,  20,     7,   8,0,   2 },
    { 1990,   9,  23,     7,   8,0,   5 },
    { 1990,   9,  30,     7,   8,0,  12 },
    { 1990,  10,   1,     7,   8,0,  13 },
    { 1990,  10,   8,     7,   8,0,  20 },
    { 1990,  10,  17,     7,   8,0,  29 },
    { 1990,  10,  18,     7,   9,0,   1 },
    { 1990,  10,  19,     7,   9,0,   2 },
    { 1990,  10,  24,     7,   9,0,   7 },
    { 1990,  10,  31,     7,   9,0,  14 },
    { 1990,  11,   1,     7,   9,0,  15 },
    { 1990,  11,   8,     7,   9,0,  22 },
    { 1990,  11,  16,     7,   9,0,  30 },
    { 1990,  11,  17,     7,  10,0,   1 },
    { 1990,  11,  18,     7,  10,0,   2 },
    { 1990,  11,  22,     7,  10,0,   6 },
    { 1990,  11,  30,     7,  10,0,  14 },
    { 1990,  12,   1,     7,  10,0,  15 },
    { 1990,  12,   7,     7,  10,0,  21 },
    { 1990,  12,  16,     7,  10,0,  30 },
    { 1990,  12,  17,     7,  11,0,   1 },
    { 1990,  12,  18,     7,  11,0,   2 },
    { 1990,  12,  22,     7,  11,0,   6 },
    { 1990,  12,  31,     7,  11,0,  15 },
    { 1991,   1,   1,     7,  11,0,  16 },
    { 1991,   1,   6,     7,  11,0,  21 },
    { 1991,   1,  15,     7,  11,0,  30 },
    { 1991,   1,  16,     7,  12,0,   1 },
    { 1991,   1,  17,     7,  12,0,   2 },
    { 1991,   1,  20,     7,  12,0,   5 },
    { 1991,   1,  31,     7,  12,0,  16 },
    { 1991,   2,   1,     7,  12,0,  17 },
    { 1991,   2,   4,     7,  12,0,  20 },
    { 1991,   2,  14,     7,  12,0,  30 },
    { 1991,   2,  15,     8,   1,0,   1 },
    { 1991,   2,  16,     8,   1,0,   2 },
    { 1991,   2,  19,     8,   1,0,   5 },
    { 1991,   2,  28,     8,   1,0,  14 },
    { 1991,   3,   1,     8,   1,0,  15 },
    { 1991,   3,   6,     8,   1,0,  20 },
    { 1991,   3,  15,     8,   1,0,  29 },
    { 1991,   3,  16,     8,   2,0,   1 },
    { 1991,   3,  17,     8,   2,0,   2 },
    { 1991,   3,  21,     8,   2,0,   6 },
    { 1991,   3,  31,     8,   2,0,  16 },
    { 1991,   4,   1,     8,   2,0,  17 },
    { 1991,   4,   5,     8,   2,0,  21 },
    { 1991,   4,  14,     8,   2,0,  30 },
    { 1991,   4,  15,     8,   3,0,   1 },
    { 1991,   4,  16,     8,   3,0,   2 },
    { 1991,   4,  20,     8,   3,0,   6 },
    { 1991,   4,  30,     8,   3,0,  16 },
    { 1991,   5,   1,     8,   3,0,  17 },
    { 1991,   5,   6,     8,   3,0,  22 },
    { 1991,   5,  13,     8,   3,0,  29 },
    { 1991,   5,  14,     8,   4,0,   1 },
    { 1991,   5,  15,     8,   4,0,   2 },
    { 1991,   5,  21,     8,   4,0,   8 },
    { 1991,   5,  31,     8,   4,0,  18 },
    { 1991,   6,   1,     8,   4,0,  19 },
    { 1991,   6,   6,     8,   4,0,  24 },
    { 1991,   6,  11,     8,   4,0,  29 },
    { 1991,   6,  12,     8,   5,0,   1 },
    { 1991,   6,  13,     8,   5,0,   2 },
    { 1991,   6,  22,     8,   5,0,  11 },
    { 1991,   6,  30,     8,   5,0,  19 },
    { 1991,   7,   1,     8,   5,0,  20 },
    { 1991,   7,   7,     8,   5,0,  26 },
    { 1991,   7,  11,     8,   5,0,  30 },
    { 1991,   7,  12,     8,   6,0,   1 },
    { 1991,   7,  13,     8,   6,0,   2 },
    { 1991,   7,  23,     8,   6,0,  12 },
    { 1991,   7,  31,     8,   6,0,  20 },
    { 1991,   8,   1,     8,   6,0,  21 },
    { 1991,   8,   8,     8,   6,0,  28 },
    { 1991,   8,   9,     8,   6,0,  29 },
    { 1991,   8,  10,     8,   7,0,   1 },
    { 1991,   8,  11,     8,   7,0,   2 },
    { 1991,   8,  23,     8,   7,0,  14 },
    { 1991,   8,  31,     8,   7,0,  22 },
    { 1991,   9,   1,     8,   7,0,  23 },
    { 1991,   9,   7,     8,   7,0,  29 },
    { 1991,   9,   8,     8,   8,0,   1 },
    { 1991,   9,   9,     8,   8,0,   2 },
    { 1991,   9,  23,     8,   8,0,  16 },
    { 1991,   9,  30,     8,   8,0,  23 },
    { 1991,  10,   1,     8,   8,0,  24 },
    { 1991,  10,   7,     8,   8,0,  30 },
    { 1991,  10,   8,     8,   9,0,   1 },
    { 1991,  10,   9,     8,   9,0,   2 },
    { 1991,  10,  24,     8,   9,0,  17 },
    { 1991,  10,  31,     8,   9,0,  24 },
    { 1991,  11,   1,     8,   9,0,  25 },
    { 1991,  11,   5,     8,   9,0,  29 },
    { 1991,  11,   6,     8,  10,0,   1 },
    { 1991,  11,   7,     8,  10,0,   2 },
    { 1991,  11,   8,     8,  10,0,   3 },
    { 1991,  11,  23,     8,  10,0,  18 },
    { 1991,  11,  30,     8,  10,0,  25 },
    { 1991,  12,   1,     8,  10,0,  26 },
    { 1991,  12,   5,     8,  10,0,  30 },
    { 1991,  12,   6,     8,  11,0,   1 },
    { 1991,  12,   7,     8,  11,0,   2 },
    { 1991,  12,  22,     8,  11,0,  17 },
    { 1991,  12,  31,     8,  11,0,  26 },
    { 1992,   1,   1,     8,  11,0,  27 },
    { 1992,   1,   4,     8,  11,0,  30 },
    { 1992,   1,   5,     8,  12,0,   1 },
    { 1992,   1,   6,     8,  12,0,   2 },
    { 1992,   1,  21,     8,  12,0,  17 },
    { 1992,   1,  31,     8,  12,0,  27 },
    { 1992,   2,   1,     8,  12,0,  28 },
    { 1992,   2,   3,     8,  12,0,  30 },
    { 1992,   2,   4,     9,   1,0,   1 },
    { 1992,   2,   5,     9,   1,0,   2 },
    { 1992,   2,  19,     9,   1,0,  16 },
    { 1992,   2,  29,     9,   1,0,  26 },
    { 1992,   3,   1,     9,   1,0,  27 },
    { 1992,   3,   3,     9,   1,0,  29 },
    { 1992,   3,   4,     9,   2,0,   1 },
    { 1992,   3,   5,     9,   2,0,   2 },
    { 1992,   3,  20,     9,   2,0,  17 },
    { 1992,   4,   2,     9,   2,0,  30 },
    { 1992,   4,   3,     9,   3,0,   1 },
    { 1992,   4,   4,     9,   3,0,   2 },
    { 1992,   4,  20,     9,   3,0,  18 },
    { 1992,   5,   2,     9,   3,0,  30 },
    { 1992,   5,   3,     9,   4,0,   1 },
    { 1992,   5,   4,     9,   4,0,   2 },
    { 1992,   5,   5,     9,   4,0,   3 },
    { 1992,   5,  21,     9,   4,0,  19 },
    { 1992,   5,  31,     9,   4,0,  29 },
    { 1992,   6,   1,     9,   5,0,   1 },
    { 1992,   6,   5,     9,   5,0,   5 },
    { 1992,   6,  21,     9,   5,0,  21 },
    { 1992,   6,  29,     9,   5,0,  29 },
    { 1992,   6,  30,     9,   6,0,   1 },
    { 1992,   7,   1,     9,   6,0,   2 },
    { 1992,   7,   7,     9,   6,0,   8 },
    { 1992,   7,  22,     9,   6,0,  23 },
    { 1992,   7,  29,     9,   6,0,  30 },
    { 1992,   7,  30,     9,   7,0,   1 },
    { 1992,   7,  31,     9,   7,0,   2 },
    { 1992,   8,   1,     9,   7,0,   3 },
    { 1992,   8,   7,     9,   7,0,   9 },
    { 1992,   8,  23,     9,   7,0,  25 },
    { 1992,   8,  27,     9,   7,0,  29 },
    { 1992,   8,  28,     9,   8,0,   1 },
    { 1992,   8,  29,     9,   8,0,   2 },
    { 1992,   8,  31,     9,   8,0,   4 },
    { 1992,   9,   1,     9,   8,0,   5 },
    { 1992,   9,   7,     9,   8,0,  11 },
    { 1992,   9,  23,     9,   8,0,  27 },
    { 1992,   9,  25,     9,   8,0,  29 },
    { 1992,   9,  26,     9,   9,0,   1 },
    { 1992,   9,  27,     9,   9,0,   2 },
    { 1992,   9,  30,     9,   9,0,   5 },
    { 1992,  10,   1,     9,   9,0,   6 },
    { 1992,  10,   8,     9,   9,0,  13 },
    { 1992,  10,  23,     9,   9,0,  28 },
    { 1992,  10,  25,     9,   9,0,  30 },
    { 1992,  10,  26,     9,  10,0,   1 },
    { 1992,  10,  27,     9,  10,0,   2 },
    { 1992,  10,  31,     9,  10,0,   6 },
    { 1992,  11,   1,     9,  10,0,   7 },
    { 1992,  11,   7,     9,  10,0,  13 },
    { 1992,  11,  22,     9,  10,0,  28 },
    { 1992,  11,  23,     9,  10,0,  29 },
    { 1992,  11,  24,     9,  11,0,   1 },
    { 1992,  11,  25,     9,  11,0,   2 },
    { 1992,  11,  30,     9,  11,0,   7 },
    { 1992,  12,   1,     9,  11,0,   8 },
    { 1992,  12,   7,     9,  11,0,  14 },
    { 1992,  12,  21,     9,  11,0,  28 },
    { 1992,  12,  23,     9,  11,0,  30 },
    { 1992,  12,  24,     9,  12,0,   1 },
    { 1992,  12,  25,     9,  12,0,   2 },
    { 1992,  12,  31,     9,  12,0,   8 },
    { 1993,   1,   1,     9,  12,0,   9 },
    { 1993,   1,   5,     9,  12,0,  13 },
    { 1993,   1,  20,     9,  12,0,  28 },
    { 1993,   1,  22,     9,  12,0,  30 },
    { 1993,   1,  23,    10,   1,0,   1 },
    { 1993,   1,  24,    10,   1,0,   2 },
    { 1993,   1,  31,    10,   1,0,   9 },
    { 1993,   2,   1,    10,   1,0,  10 },
    { 1993,   2,   4,    10,   1,0,  13 },
    { 1993,   2,  18,    10,   1,0,  27 },
    { 1993,   2,  20,    10,   1,0,  29 },
    { 1993,   2,  21,    10,   2,0,   1 },
    { 1993,   2,  22,    10,   2,0,   2 },
    { 1993,   2,  28,    10,   2,0,   8 },
    { 1993,   3,   1,    10,   2,0,   9 },
    { 1993,   3,   5,    10,   2,0,  13 },
    { 1993,   3,  20,    10,   2,0,  28 },
    { 1993,   3,  22,    10,   2,0,  30 },
    { 1993,   3,  23,    10,   3,0,   1 },
    { 1993,   3,  24,    10,   3,0,   2 },
    { 1993,   3,  31,    10,   3,0,   9 },
    { 1993,   4,   1,    10,   3,0,  10 },
    { 1993,   4,   5,    10,   3,0,  14 },
    { 1993,   4,  20,    10,   3,0,  29 },
    { 1993,   4,  21,    10,   3,0,  30 },
    { 1993,   4,  22,    10,   3,1,   1 },
    { 1993,   4,  23,    10,   3,1,   2 },
    { 1993,   4,  30,    10,   3,1,   9 },
    { 1993,   5,   1,    10,   3,1,  10 },
    { 1993,   5,   5,    10,   3,1,  14 },
    { 1993,   5,  20,    10,   3,1,  29 },
    { 1993,   5,  21,    10,   4,0,   1 },
    { 1993,   5,  22,    10,   4,0,   2 },
    { 1993,   5,  31,    10,   4,0,  11 },
    { 1993,   6,   1,    10,   4,0,  12 },
    { 1993,   6,   6,    10,   4,0,  17 },
    { 1993,   6,  19,    10,   4,0,  30 },
    { 1993,   6,  20,    10,   5,0,   1 },
    { 1993,   6,  21,    10,   5,0,   2 },
    { 1993,   6,  30,    10,   5,0,  11 },
    { 1993,   7,   1,    10,   5,0,  12 },
    { 1993,   7,   7,    10,   5,0,  18 },
    { 1993,   7,  18,    10,   5,0,  29 },
    { 1993,   7,  19,    10,   6,0,   1 },
    { 1993,   7,  20,    10,   6,0,   2 },
    { 1993,   7,  23,    10,   6,0,   5 },
    { 1993,   7,  31,    10,   6,0,  13 },
    { 1993,   8,   1,    10,   6,0,  14 },
    { 1993,   8,   7,    10,   6,0,  20 },
    { 1993,   8,  17,    10,   6,0,  30 },
    { 1993,   8,  18,    10,   7,0,   1 },
    { 1993,   8,  19,    10,   7,0,   2 },
    { 1993,   8,  23,    10,   7,0,   6 },
    { 1993,   8,  31,    10,   7,0,  14 },
    { 1993,   9,   1,    10,   7,0,  15 },
    { 1993,   9,   7,    10,   7,0,  21 },
    { 1993,   9,  15,    10,   7,0,  29 },
    { 1993,   9,  16,    10,   8,0,   1 },
    { 1993,   9,  17,    10,   8,0,   2 },
    { 1993,   9,  23,    10,   8,0,   8 },
    { 1993,   9,  30,    10,   8,0,  15 },
    { 1993,  10,   1,    10,   8,0,  16 },
    { 1993,  10,   8,    10,   8,0,  23 },
    { 1993,  10,  14,    10,   8,0,  29 },
    { 1993,  10,  15,    10,   9,0,   1 },
    { 1993,  10,  16,    10,   9,0,   2 },
    { 1993,  10,  23,    10,   9,0,   9 },
    { 1993,  10,  31,    10,   9,0,  17 },
    { 1993,  11,   1,    10,   9,0,  18 },
    { 1993,  11,   7,    10,   9,0,  24 },
    { 1993,  11,  13,    10,   9,0,  30 },
    { 1993,  11,  14,    10,  10,0,   1 },
    { 1993,  11,  15,    10,  10,0,   2 },
    { 1993,  11,  22,    10,  10,0,   9 },
    { 1993,  11,  30,    10,  10,0,  17 },
    { 1993,  12,   1,    10,  10,0,  18 },
    { 1993,  12,   7,    10,  10,0,  24 },
    { 1993,  12,  12,    10,  10,0,  29 },
    { 1993,  12,  13,    10,  11,0,   1 },
    { 1993,  12,  14,    10,  11,0,   2 },
    { 1993,  12,  22,    10,  11,0,  10 },
    { 1993,  12,  31,    10,  11,0,  19 },
    { 1994,   1,   1,    10,  11,0,  20 },
    { 1994,   1,   5,    10,  11,0,  24 },
    { 1994,   1,  11,    10,  11,0,  30 },
    { 1994,   1,  12,    10,  12,0,   1 },
    { 1994,   1,  13,    10,  12,0,   2 },
    { 1994,   1,  20,    10,  12,0,   9 },
    { 1994,   1,  31,    10,  12,0,  20 },
    { 1994,   2,   1,    10,  12,0,  21 },
    { 1994,   2,   4,    10,  12,0,  24 },
    { 1994,   2,   9,    10,  12,0,  29 },
    { 1994,   2,  10,    11,   1,0,   1 },
    { 1994,   2,  11,    11,   1,0,   2 },
    { 1994,   2,  19,    11,   1,0,  10 },
    { 1994,   2,  28,    11,   1,0,  19 },
    { 1994,   3,   1,    11,   1,0,  20 },
    { 1994,   3,   6,    11,   1,0,  25 },
    { 1994,   3,  11,    11,   1,0,  30 },
    { 1994,   3,  12,    11,   2,0,   1 },
    { 1994,   3,  13,    11,   2,0,   2 },
    { 1994,   3,  21,    11,   2,0,  10 },
    { 1994,   3,  31,    11,   2,0,  20 },
    { 1994,   4,   1,    11,   2,0,  21 },
    { 1994,   4,   5,    11,   2,0,  25 },
    { 1994,   4,  10,    11,   2,0,  30 },
    { 1994,   4,  11,    11,   3,0,   1 },
    { 1994,   4,  12,    11,   3,0,   2 },
    { 1994,   4,  20,    11,   3,0,  10 },
    { 1994,   4,  30,    11,   3,0,  20 },
    { 1994,   5,   1,    11,   3,0,  21 },
    { 1994,   5,   6,    11,   3,0,  26 },
    { 1994,   5,  10,    11,   3,0,  30 },
    { 1994,   5,  11,    11,   4,0,   1 },
    { 1994,   5,  12,    11,   4,0,   2 },
    { 1994,   5,  21,    11,   4,0,  11 },
    { 1994,   5,  31,    11,   4,0,  21 },
    { 1994,   6,   1,    11,   4,0,  22 },
    { 1994,   6,   6,    11,   4,0,  27 },
    { 1994,   6,   8,    11,   4,0,  29 },
    { 1994,   6,   9,    11,   5,0,   1 },
    { 1994,   6,  10,    11,   5,0,   2 },
    { 1994,   6,  21,    11,   5,0,  13 },
    { 1994,   6,  30,    11,   5,0,  22 },
    { 1994,   7,   1,    11,   5,0,  23 },
    { 1994,   7,   7,    11,   5,0,  29 },
    { 1994,   7,   8,    11,   5,0,  30 },
    { 1994,   7,   9,    11,   6,0,   1 },
    { 1994,   7,  10,    11,   6,0,   2 },
    { 1994,   7,  23,    11,   6,0,  15 },
    { 1994,   7,  31,    11,   6,0,  23 },
    { 1994,   8,   1,    11,   6,0,  24 },
    { 1994,   8,   6,    11,   6,0,  29 },
    { 1994,   8,   7,    11,   7,0,   1 },
    { 1994,   8,   8,    11,   7,0,   2 },
    { 1994,   8,  23,    11,   7,0,  17 },
    { 1994,   8,  31,    11,   7,0,  25 },
    { 1994,   9,   1,    11,   7,0,  26 },
    { 1994,   9,   5,    11,   7,0,  30 },
    { 1994,   9,   6,    11,   8,0,   1 },
    { 1994,   9,   7,    11,   8,0,   2 },
    { 1994,   9,   8,    11,   8,0,   3 },
    { 1994,   9,  23,    11,   8,0,  18 },
    { 1994,   9,  30,    11,   8,0,  25 },
    { 1994,  10,   1,    11,   8,0,  26 },
    { 1994,  10,   4,    11,   8,0,  29 },
    { 1994,  10,   5,    11,   9,0,   1 },
    { 1994,  10,   6,    11,   9,0,   2 },
    { 1994,  10,   8,    11,   9,0,   4 },
    { 1994,  10,  23,    11,   9,0,  19 },
    { 1994,  11,   2,    11,   9,0,  29 },
    { 1994,  11,   3,    11,  10,0,   1 },
    { 1994,  11,   4,    11,  10,0,   2 },
    { 1994,  11,   7,    11,  10,0,   5 },
    { 1994,  11,  22,    11,  10,0,  20 },
    { 1994,  12,   2,    11,  10,0,  30 },
    { 1994,  12,   3,    11,  11,0,   1 },
    { 1994,  12,   4,    11,  11,0,   2 },
    { 1994,  12,   7,    11,  11,0,   5 },
    { 1994,  12,  22,    11,  11,0,  20 },
    { 1994,  12,  31,    11,  11,0,  29 },
    { 1995,   1,   1,    11,  12,0,   1 },
    { 1995,   1,   6,    11,  12,0,   6 },
    { 1995,   1,  20,    11,  12,0,  20 },
    { 1995,   1,  30,    11,  12,0,  30 },
    { 1995,   1,  31,    12,   1,0,   1 },
    { 1995,   2,   1,    12,   1,0,   2 },
    { 1995,   2,   4,    12,   1,0,   5 },
    { 1995,   2,  19,    12,   1,0,  20 },
    { 1995,   2,  28,    12,   1,0,  29 },
    { 1995,   3,   1,    12,   2,0,   1 },
    { 1995,   3,   6,    12,   2,0,   6 },
    { 1995,   3,  21,    12,   2,0,  21 },
    { 1995,   3,  30,    12,   2,0,  30 },
    { 1995,   3,  31,    12,   3,0,   1 },
    { 1995,   4,   1,    12,   3,0,   2 },
    { 1995,   4,   5,    12,   3,0,   6 },
    { 1995,   4,  20,    12,   3,0,  21 },
    { 1995,   4,  29,    12,   3,0,  30 },
    { 1995,   4,  30,    12,   4,0,   1 },
    { 1995,   5,   1,    12,   4,0,   2 },
    { 1995,   5,   6,    12,   4,0,   7 },
    { 1995,   5,  21,    12,   4,0,  22 },
    { 1995,   5,  28,    12,   4,0,  29 },
    { 1995,   5,  29,    12,   5,0,   1 },
    { 1995,   5,  30,    12,   5,0,   2 },
    { 1995,   5,  31,    12,   5,0,   3 },
    { 1995,   6,   1,    12,   5,0,   4 },
    { 1995,   6,   6,    12,   5,0,   9 },
    { 1995,   6,  22,    12,   5,0,  25 },
    { 1995,   6,  27,    12,   5,0,  30 },
    { 1995,   6,  28,    12,   6,0,   1 },
    { 1995,   6,  29,    12,   6,0,   2 },
    { 1995,   6,  30,    12,   6,0,   3 },
    { 1995,   7,   1,    12,   6,0,   4 },
    { 1995,   7,   7,    12,   6,0,  10 },
    { 1995,   7,  23,    12,   6,0,  26 },
    { 1995,   7,  26,    12,   6,0,  29 },
    { 1995,   7,  27,    12,   7,0,   1 },
    { 1995,   7,  28,    12,   7,0,   2 },
    { 1995,   7,  31,    12,   7,0,   5 },
    { 1995,   8,   1,    12,   7,0,   6 },
    { 1995,   8,   8,    12,   7,0,  13 },
    { 1995,   8,  23,    12,   7,0,  28 },
    { 1995,   8,  25,    12,   7,0,  30 },
    { 1995,   8,  26,    12,   8,0,   1 },
    { 1995,   8,  27,    12,   8,0,   2 },
    { 1995,   8,  31,    12,   8,0,   6 },
    { 1995,   9,   1,    12,   8,0,   7 },
    { 1995,   9,   8,    12,   8,0,  14 },
    { 1995,   9,  23,    12,   8,0,  29 },
    { 1995,   9,  24,    12,   8,0,  30 },
    { 1995,   9,  25,    12,   8,1,   1 },
    { 1995,   9,  26,    12,   8,1,   2 },
    { 1995,   9,  30,    12,   8,1,   6 },
    { 1995,  10,   1,    12,   8,1,   7 },
    { 1995,  10,   9,    12,   8,1,  15 },
    { 1995,  10,  23,    12,   8,1,  29 },
    { 1995,  10,  24,    12,   9,0,   1 },
    { 1995,  10,  25,    12,   9,0,   2 },
    { 1995,  10,  31,    12,   9,0,   8 },
    { 1995,  11,   1,    12,   9,0,   9 },
    { 1995,  11,   8,    12,   9,0,  16 },
    { 1995,  11,  21,    12,   9,0,  29 },
    { 1995,  11,  22,    12,  10,0,   1 },
    { 1995,  11,  23,    12,  10,0,   2 },
    { 1995,  11,  30,    12,  10,0,   9 },
    { 1995,  12,   1,    12,  10,0,  10 },
    { 1995,  12,   7,    12,  10,0,  16 },
    { 1995,  12,  21,    12,  10,0,  30 },
    { 1995,  12,  22,    12,  11,0,   1 },
    { 1995,  12,  23,    12,  11,0,   2 },
    { 1995,  12,  31,    12,  11,0,  10 },
    { 1996,   1,   1,    12,  11,0,  11 },
    { 1996,   1,   6,    12,  11,0,  16 },
    { 1996,   1,  19,    12,  11,0,  29 },
    { 1996,   1,  20,    12,  12,0,   1 },
    { 1996,   1,  21,    12,  12,0,   2 },
    { 1996,   1,  31,    12,  12,0,  12 },
    { 1996,   2,   1,    12,  12,0,  13 },
    { 1996,   2,   4,    12,  12,0,  16 },
    { 1996,   2,  18,    12,  12,0,  30 },
    { 1996,   2,  19,    13,   1,0,   1 },
    { 1996,   2,  20,    13,   1,0,   2 },
    { 1996,   2,  29,    13,   1,0,  11 },
    { 1996,   3,   1,    13,   1,0,  12 },
    { 1996,   3,   5,    13,   1,0,  16 },
    { 1996,   3,  18,    13,   1,0,  29 },
    { 1996,   3,  19,    13,   2,0,   1 },
    { 1996,   3,  20,    13,   2,0,   2 },
    { 1996,   3,  31,    13,   2,0,  13 },
    { 1996,   4,   1,    13,   2,0,  14 },
    { 1996,   4,   4,    13,   2,0,  17 },
    { 1996,   4,  17,    13,   2,0,  30 },
    { 1996,   4,  18,    13,   3,0,   1 },
    { 1996,   4,  19,    13,   3,0,   2 },
    { 1996,   4,  20,    13,   3,0,   3 },
    { 1996,   4,  30,    13,   3,0,  13 },
    { 1996,   5,   1,    13,   3,0,  14 },
    { 1996,   5,   5,    13,   3,0,  18 },
    { 1996,   5,  16,    13,   3,0,  29 },
    { 1996,   5,  17,    13,   4,0,   1 },
    { 1996,   5,  18,    13,   4,0,   2 },
    { 1996,   5,  21,    13,   4,0,   5 },
    { 1996,   5,  31,    13,   4,0,  15 },
    { 1996,   6,   1,    13,   4,0,  16 },
    { 1996,   6,   5,    13,   4,0,  20 },
    { 1996,   6,  15,    13,   4,0,  30 },
    { 1996,   6,  16,    13,   5,0,   1 },
    { 1996,   6,  17,    13,   5,0,   2 },
    { 1996,   6,  21,    13,   5,0,   6 },
    { 1996,   6,  30,    13,   5,0,  15 },
    { 1996,   7,   1,    13,   5,0,  16 },
    { 1996,   7,   7,    13,   5,0,  22 },
    { 1996,   7,  15,    13,   5,0,  30 },
    { 1996,   7,  16,    13,   6,0,   1 },
    { 1996,   7,  17,    13,   6,0,   2 },
    { 1996,   7,  22,    13,   6,0,   7 },
    { 1996,   7,  31,    13,   6,0,  16 },
    { 1996,   8,   1,    13,   6,0,  17 },
    { 1996,   8,   7,    13,   6,0,  23 },
    { 1996,   8,  13,    13,   6,0,  29 },
    { 1996,   8,  14,    13,   7,0,   1 },
    { 1996,   8,  15,    13,   7,0,   2 },
    { 1996,   8,  23,    13,   7,0,  10 },
    { 1996,   8,  31,    13,   7,0,  18 },
    { 1996,   9,   1,    13,   7,0,  19 },
    { 1996,   9,   7,    13,   7,0,  25 },
    { 1996,   9,  12,    13,   7,0,  30 },
    { 1996,   9,  13,    13,   8,0,   1 },
    { 1996,   9,  14,    13,   8,0,   2 },
    { 1996,   9,  23,    13,   8,0,  11 },
    { 1996,   9,  30,    13,   8,0,  18 },
    { 1996,  10,   1,    13,   8,0,  19 },
    { 1996,  10,   8,    13,   8,0,  26 },
    { 1996,  10,  11,    13,   8,0,  29 },
    { 1996,  10,  12,    13,   9,0,   1 },
    { 1996,  10,  13,    13,   9,0,   2 },
    { 1996,  10,  23,    13,   9,0,  12 },
    { 1996,  10,  31,    13,   9,0,  20 },
    { 1996,  11,   1,    13,   9,0,  21 },
    { 1996,  11,   7,    13,   9,0,  27 },
    { 1996,  11,  10,    13,   9,0,  30 },
    { 1996,  11,  11,    13,  10,0,   1 },
    { 1996,  11,  12,    13,  10,0,   2 },
    { 1996,  11,  22,    13,  10,0,  12 },
    { 1996,  11,  30,    13,  10,0,  20 },
    { 1996,  12,   1,    13,  10,0,  21 },
    { 1996,  12,   7,    13,  10,0,  27 },
    { 1996,  12,  10,    13,  10,0,  30 },
    { 1996,  12,  11,    13,  11,0,   1 },
    { 1996,  12,  12,    13,  11,0,   2 },
    { 1996,  12,  21,    13,  11,0,  11 },
    { 1996,  12,  31,    13,  11,0,  21 },
    { 1997,   1,   1,    13,  11,0,  22 },
    { 1997,   1,   5,    13,  11,0,  26 },
    { 1997,   1,   8,    13,  11,0,  29 },
    { 1997,   1,   9,    13,  12,0,   1 },
    { 1997,   1,  10,    13,  12,0,   2 },
    { 1997,   1,  20,    13,  12,0,  12 },
    { 1997,   1,  31,    13,  12,0,  23 },
    { 1997,   2,   1,    13,  12,0,  24 },
    { 1997,   2,   4,    13,  12,0,  27 },
    { 1997,   2,   6,    13,  12,0,  29 },
    { 1997,   2,   7,    14,   1,0,   1 },
    { 1997,   2,   8,    14,   1,0,   2 },
    { 1997,   2,  18,    14,   1,0,  12 },
    { 1997,   2,  28,    14,   1,0,  22 },
    { 1997,   3,   1,    14,   1,0,  23 },
    { 1997,   3,   5,    14,   1,0,  27 },
    { 1997,   3,   8,    14,   1,0,  30 },
    { 1997,   3,   9,    14,   2,0,   1 },
    { 1997,   3,  10,    14,   2,0,   2 },
    { 1997,   3,  20,    14,   2,0,  12 },
    { 1997,   3,  31,    14,   2,0,  23 },
    { 1997,   4,   1,    14,   2,0,  24 },
    { 1997,   4,   5,    14,   2,0,  28 },
    { 1997,   4,   6,    14,   2,0,  29 },
    { 1997,   4,   7,    14,   3,0,   1 },
    { 1997,   4,   8,    14,   3,0,   2 },
    { 1997,   4,  20,    14,   3,0,  14 },
    { 1997,   4,  30,    14,   3,0,  24 },
    { 1997,   5,   1,    14,   3,0,  25 },
    { 1997,   5,   5,    14,   3,0,  29 },
    { 1997,   5,   6,    14,   3,0,  30 },
    { 1997,   5,   7,    14,   4,0,   1 },
    { 1997,   5,   8,    14,   4,0,   2 },
    { 1997,   5,  21,    14,   4,0,  15 },
    { 1997,   5,  31,    14,   4,0,  25 },
    { 1997,   6,   1,    14,   4,0,  26 },
    { 1997,   6,   4,    14,   4,0,  29 },
    { 1997,   6,   5,    14,   5,0,   1 },
    { 1997,   6,   6,    14,   5,0,   2 },
    { 1997,   6,  21,    14,   5,0,  17 },
    { 1997,   6,  30,    14,   5,0,  26 },
    { 1997,   7,   1,    14,   5,0,  27 },
    { 1997,   7,   4,    14,   5,0,  30 },
    { 1997,   7,   5,    14,   6,0,   1 },
    { 1997,   7,   6,    14,   6,0,   2 },
    { 1997,   7,   7,    14,   6,0,   3 },
    { 1997,   7,  23,    14,   6,0,  19 },
    { 1997,   8,   2,    14,   6,0,  29 },
    { 1997,   8,   3,    14,   7,0,   1 },
    { 1997,   8,   4,    14,   7,0,   2 },
    { 1997,   8,   7,    14,   7,0,   5 },
    { 1997,   8,  23,    14,   7,0,  21 },
    { 1997,   9,   1,    14,   7,0,  30 },
    { 1997,   9,   2,    14,   8,0,   1 },
    { 1997,   9,   3,    14,   8,0,   2 },
    { 1997,   9,   7,    14,   8,0,   6 },
    { 1997,   9,  23,    14,   8,0,  22 },
    { 1997,  10,   1,    14,   8,0,  30 },
    { 1997,  10,   2,    14,   9,0,   1 },
    { 1997,  10,   3,    14,   9,0,   2 },
    { 1997,  10,   8,    14,   9,0,   7 },
    { 1997,  10,  23,    14,   9,0,  22 },
    { 1997,  10,  30,    14,   9,0,  29 },
    { 1997,  10,  31,    14,  10,0,   1 },
    { 1997,  11,   1,    14,  10,0,   2 },
    { 1997,  11,   7,    14,  10,0,   8 },
    { 1997,  11,  22,    14,  10,0,  23 },
    { 1997,  11,  29,    14,  10,0,  30 },
    { 1997,  11,  30,    14,  11,0,   1 },
    { 1997,  12,   1,    14,  11,0,   2 },
    { 1997,  12,   7,    14,  11,0,   8 },
    { 1997,  12,  22,    14,  11,0,  23 },
    { 1997,  12,  29,    14,  11,0,  30 },
    { 1997,  12,  30,    14,  12,0,   1 },
    { 1997,  12,  31,    14,  12,0,   2 },
    { 1998,   1,   1,    14,  12,0,   3 },
    { 1998,   1,   5,    14,  12,0,   7 },
    { 1998,   1,  20,    14,  12,0,  22 },
    { 1998,   1,  27,    14,  12,0,  29 },
    { 1998,   1,  28,    15,   1,0,   1 },
    { 1998,   1,  29,    15,   1,0,   2 },
    { 1998,   1,  31,    15,   1,0,   4 },
    { 1998,   2,   1,    15,   1,0,   5 },
    { 1998,   2,   4,    15,   1,0,   8 },
    { 1998,   2,  19,    15,   1,0,  23 },
    { 1998,   2,  26,    15,   1,0,  30 },
    { 1998,   2,  27,    15,   2,0,   1 },
    { 1998,   2,  28,    15,   2,0,   2 },
    { 1998,   3,   1,    15,   2,0,   3 },
    { 1998,   3,   6,    15,   2,0,   8 },
    { 1998,   3,  21,    15,   2,0,  23 },
    { 1998,   3,  27,    15,   2,0,  29 },
    { 1998,   3,  28,    15,   3,0,   1 },
    { 1998,   3,  29,    15,   3,0,   2 },
    { 1998,   3,  31,    15,   3,0,   4 },
    { 1998,   4,   1,    15,   3,0,   5 },
    { 1998,   4,   5,    15,   3,0,   9 },
    { 1998,   4,  20,    15,   3,0,  24 },
    { 1998,   4,  25,    15,   3,0,  29 },
    { 1998,   4,  26,    15,   4,0,   1 },
    { 1998,   4,  27,    15,   4,0,   2 },
    { 1998,   4,  30,    15,   4,0,   5 },
    { 1998,   5,   1,    15,   4,0,   6 },
    { 1998,   5,   6,    15,   4,0,  11 },
    { 1998,   5,  21,    15,   4,0,  26 },
    { 1998,   5,  25,    15,   4,0,  30 },
    { 1998,   5,  26,    15,   5,0,   1 },
    { 1998,   5,  27,    15,   5,0,   2 },
    { 1998,   5,  31,    15,   5,0,   6 },
    { 1998,   6,   1,    15,   5,0,   7 },
    { 1998,   6,   6,    15,   5,0,  12 },
    { 1998,   6,  21,    15,   5,0,  27 },
    { 1998,   6,  23,    15,   5,0,  29 },
    { 1998,   6,  24,    15,   5,1,   1 },
    { 1998,   6,  25,    15,   5,1,   2 },
    { 1998,   6,  30,    15,   5,1,   7 },
    { 1998,   7,   1,    15,   5,1,   8 },
    { 1998,   7,   7,    15,   5,1,  14 },
    { 1998,   7,  22,    15,   5,1,  29 },
    { 1998,   7,  23,    15,   6,0,   1 },
    { 1998,   7,  24,    15,   6,0,   2 },
    { 1998,   7,  31,    15,   6,0,   9 },
    { 1998,   8,   1,    15,   6,0,  10 },
    { 1998,   8,   8,    15,   6,0,  17 },
    { 1998,   8,  21,    15,   6,0,  30 },
    { 1998,   8,  22,    15,   7,0,   1 },
    { 1998,   8,  23,    15,   7,0,   2 },
    { 1998,   8,  31,    15,   7,0,  10 },
    { 1998,   9,   1,    15,   7,0,  11 },
    { 1998,   9,   8,    15,   7,0,  18 },
    { 1998,   9,  20,    15,   7,0,  30 },
    { 1998,   9,  21,    15,   8,0,   1 },
    { 1998,   9,  22,    15,   8,0,   2 },
    { 1998,   9,  23,    15,   8,0,   3 },
    { 1998,   9,  30,    15,   8,0,  10 },
    { 1998,  10,   1,    15,   8,0,  11 },
    { 1998,  10,   8,    15,   8,0,  18 },
    { 1998,  10,  19,    15,   8,0,  29 },
    { 1998,  10,  20,    15,   9,0,   1 },
    { 1998,  10,  21,    15,   9,0,   2 },
    { 1998,  10,  23,    15,   9,0,   4 },
    { 1998,  10,  31,    15,   9,0,  12 },
    { 1998,  11,   1,    15,   9,0,  13 },
    { 1998,  11,   7,    15,   9,0,  19 },
    { 1998,  11,  18,    15,   9,0,  30 },
    { 1998,  11,  19,    15,  10,0,   1 },
    { 1998,  11,  20,    15,  10,0,   2 },
    { 1998,  11,  22,    15,  10,0,   4 },
    { 1998,  11,  30,    15,  10,0,  12 },
    { 1998,  12,   1,    15,  10,0,  13 },
    { 1998,  12,   7,    15,  10,0,  19 },
    { 1998,  12,  18,    15,  10,0,  30 },
    { 1998,  12,  19,    15,  11,0,   1 },
    { 1998,  12,  20,    15,  11,0,   2 },
    { 1998,  12,  22,    15,  11,0,   4 },
    { 1998,  12,  31,    15,  11,0,  13 },
    { 1999,   1,   1,    15,  11,0,  14 },
    { 1999,   1,   6,    15,  11,0,  19 },
    { 1999,   1,  16,    15,  11,0,  29 },
//# { 1999,   1,  17,    15,  12,0,   1 },
//# { 1999,   1,  18,    15,  12,0,   2 },
//# { 1999,   1,  20,    15,  12,0,   4 },
//# { 1999,   1,  31,    15,  12,0,  15 },
//# { 1999,   2,   1,    15,  12,0,  16 },
//# { 1999,   2,   4,    15,  12,0,  19 },
//# { 1999,   2,  15,    15,  12,0,  30 },
    { 1999,   2,  16,    16,   1,0,   1 },
    { 1999,   2,  17,    16,   1,0,   2 },
    { 1999,   2,  19,    16,   1,0,   4 },
    { 1999,   2,  28,    16,   1,0,  13 },
    { 1999,   3,   1,    16,   1,0,  14 },
    { 1999,   3,   6,    16,   1,0,  19 },
    { 1999,   3,  17,    16,   1,0,  30 },
    { 1999,   3,  18,    16,   2,0,   1 },
    { 1999,   3,  19,    16,   2,0,   2 },
    { 1999,   3,  21,    16,   2,0,   4 },
    { 1999,   3,  31,    16,   2,0,  14 },
    { 1999,   4,   1,    16,   2,0,  15 },
    { 1999,   4,   5,    16,   2,0,  19 },
    { 1999,   4,  15,    16,   2,0,  29 },
    { 1999,   4,  16,    16,   3,0,   1 },
    { 1999,   4,  17,    16,   3,0,   2 },
    { 1999,   4,  20,    16,   3,0,   5 },
    { 1999,   4,  30,    16,   3,0,  15 },
    { 1999,   5,   1,    16,   3,0,  16 },
    { 1999,   5,   6,    16,   3,0,  21 },
    { 1999,   5,  14,    16,   3,0,  29 },
    { 1999,   5,  15,    16,   4,0,   1 },
    { 1999,   5,  16,    16,   4,0,   2 },
    { 1999,   5,  21,    16,   4,0,   7 },
    { 1999,   5,  31,    16,   4,0,  17 },
    { 1999,   6,   1,    16,   4,0,  18 },
    { 1999,   6,   6,    16,   4,0,  23 },
    { 1999,   6,  13,    16,   4,0,  30 },
    { 1999,   6,  14,    16,   5,0,   1 },
    { 1999,   6,  15,    16,   5,0,   2 },
    { 1999,   6,  22,    16,   5,0,   9 },
    { 1999,   6,  30,    16,   5,0,  17 },
    { 1999,   7,   1,    16,   5,0,  18 },
    { 1999,   7,   7,    16,   5,0,  24 },
    { 1999,   7,  12,    16,   5,0,  29 },
    { 1999,   7,  13,    16,   6,0,   1 },
    { 1999,   7,  14,    16,   6,0,   2 },
    { 1999,   7,  23,    16,   6,0,  11 },
    { 1999,   7,  31,    16,   6,0,  19 },
    { 1999,   8,   1,    16,   6,0,  20 },
    { 1999,   8,   8,    16,   6,0,  27 },
    { 1999,   8,  10,    16,   6,0,  29 },
    { 1999,   8,  11,    16,   7,0,   1 },
    { 1999,   8,  12,    16,   7,0,   2 },
    { 1999,   8,  23,    16,   7,0,  13 },
    { 1999,   8,  31,    16,   7,0,  21 },
    { 1999,   9,   1,    16,   7,0,  22 },
    { 1999,   9,   8,    16,   7,0,  29 },
    { 1999,   9,   9,    16,   7,0,  30 },
    { 1999,   9,  10,    16,   8,0,   1 },
    { 1999,   9,  11,    16,   8,0,   2 },
    { 1999,   9,  23,    16,   8,0,  14 },
    { 1999,   9,  30,    16,   8,0,  21 },
    { 1999,  10,   1,    16,   8,0,  22 },
    { 1999,  10,   8,    16,   8,0,  29 },
    { 1999,  10,   9,    16,   9,0,   1 },
    { 1999,  10,  10,    16,   9,0,   2 },
    { 1999,  10,  24,    16,   9,0,  16 },
    { 1999,  10,  31,    16,   9,0,  23 },
    { 1999,  11,   1,    16,   9,0,  24 },
    { 1999,  11,   7,    16,   9,0,  30 },
    { 1999,  11,   8,    16,  10,0,   1 },
    { 1999,  11,   9,    16,  10,0,   2 },
    { 1999,  11,  23,    16,  10,0,  16 },
    { 1999,  11,  30,    16,  10,0,  23 },
    { 1999,  12,   1,    16,  10,0,  24 },
    { 1999,  12,   7,    16,  10,0,  30 },
    { 1999,  12,   8,    16,  11,0,   1 },
    { 1999,  12,   9,    16,  11,0,   2 },
    { 1999,  12,  22,    16,  11,0,  15 },
    { 1999,  12,  31,    16,  11,0,  24 },
    { 2000,   1,   1,    16,  11,0,  25 },
    { 2000,   1,   6,    16,  11,0,  30 },
    { 2000,   1,   7,    16,  12,0,   1 },
    { 2000,   1,   8,    16,  12,0,   2 },
    { 2000,   1,  21,    16,  12,0,  15 },
    { 2000,   1,  31,    16,  12,0,  25 },
    { 2000,   2,   1,    16,  12,0,  26 },
    { 2000,   2,   4,    16,  12,0,  29 },
    { 2000,   2,   5,    17,   1,0,   1 },
    { 2000,   2,   6,    17,   1,0,   2 },
    { 2000,   2,  19,    17,   1,0,  15 },
    { 2000,   2,  29,    17,   1,0,  25 },
    { 2000,   3,   1,    17,   1,0,  26 },
    { 2000,   3,   5,    17,   1,0,  30 },
    { 2000,   3,   6,    17,   2,0,   1 },
    { 2000,   3,   7,    17,   2,0,   2 },
    { 2000,   3,  20,    17,   2,0,  15 },
    { 2000,   3,  31,    17,   2,0,  26 },
    { 2000,   4,   1,    17,   2,0,  27 },
    { 2000,   4,   4,    17,   2,0,  30 },
    { 2000,   4,   5,    17,   3,0,   1 },
    { 2000,   4,   6,    17,   3,0,   2 },
    { 2000,   4,  20,    17,   3,0,  16 },
    { 2000,   4,  30,    17,   3,0,  26 },
    { 2000,   5,   1,    17,   3,0,  27 },
    { 2000,   5,   3,    17,   3,0,  29 },
    { 2000,   5,   4,    17,   4,0,   1 },
    { 2000,   5,   5,    17,   4,0,   2 },
    { 2000,   5,  21,    17,   4,0,  18 },
    { 2000,   6,   1,    17,   4,0,  29 },
    { 2000,   6,   2,    17,   5,0,   1 },
    { 2000,   6,   3,    17,   5,0,   2 },
    { 2000,   6,   5,    17,   5,0,   4 },
    { 2000,   6,  21,    17,   5,0,  20 },
    { 2000,   7,   1,    17,   5,0,  30 },
    { 2000,   7,   2,    17,   6,0,   1 },
    { 2000,   7,   3,    17,   6,0,   2 },
    { 2000,   7,   7,    17,   6,0,   6 },
    { 2000,   7,  22,    17,   6,0,  21 },
    { 2000,   7,  30,    17,   6,0,  29 },
    { 2000,   7,  31,    17,   7,0,   1 },
    { 2000,   8,   1,    17,   7,0,   2 },
    { 2000,   8,   7,    17,   7,0,   8 },
    { 2000,   8,  23,    17,   7,0,  24 },
    { 2000,   8,  28,    17,   7,0,  29 },
    { 2000,   8,  29,    17,   8,0,   1 },
    { 2000,   8,  30,    17,   8,0,   2 },
    { 2000,   8,  31,    17,   8,0,   3 },
    { 2000,   9,   1,    17,   8,0,   4 },
    { 2000,   9,   7,    17,   8,0,  10 },
    { 2000,   9,  23,    17,   8,0,  26 },
    { 2000,   9,  27,    17,   8,0,  30 },
    { 2000,   9,  28,    17,   9,0,   1 },
    { 2000,   9,  29,    17,   9,0,   2 },
    { 2000,   9,  30,    17,   9,0,   3 },
    { 2000,  10,   1,    17,   9,0,   4 },
    { 2000,  10,   8,    17,   9,0,  11 },
    { 2000,  10,  23,    17,   9,0,  26 },
    { 2000,  10,  26,    17,   9,0,  29 },
    { 2000,  10,  27,    17,  10,0,   1 },
    { 2000,  10,  28,    17,  10,0,   2 },
    { 2000,  10,  31,    17,  10,0,   5 },
    { 2000,  11,   1,    17,  10,0,   6 },
    { 2000,  11,   7,    17,  10,0,  12 },
    { 2000,  11,  22,    17,  10,0,  27 },
    { 2000,  11,  25,    17,  10,0,  30 },
    { 2000,  11,  26,    17,  11,0,   1 },
    { 2000,  11,  27,    17,  11,0,   2 },
    { 2000,  11,  30,    17,  11,0,   5 },
    { 2000,  12,   1,    17,  11,0,   6 },
    { 2000,  12,   7,    17,  11,0,  12 },
    { 2000,  12,  21,    17,  11,0,  26 },
    { 2000,  12,  25,    17,  11,0,  30 },
    { 2000,  12,  26,    17,  12,0,   1 },
    { 2000,  12,  27,    17,  12,0,   2 },
    { 2000,  12,  31,    17,  12,0,   6 },
    { 2001,   1,   1,    17,  12,0,   7 },
    { 2001,   1,   5,    17,  12,0,  11 },
    { 2001,   1,  20,    17,  12,0,  26 },
    { 2001,   1,  23,    17,  12,0,  29 },
    { 2001,   1,  24,    18,   1,0,   1 },
    { 2001,   1,  25,    18,   1,0,   2 },
    { 2001,   1,  31,    18,   1,0,   8 },
    { 2001,   2,   1,    18,   1,0,   9 },
    { 2001,   2,   4,    18,   1,0,  12 },
    { 2001,   2,  18,    18,   1,0,  26 },
    { 2001,   2,  22,    18,   1,0,  30 },
    { 2001,   2,  23,    18,   2,0,   1 },
    { 2001,   2,  24,    18,   2,0,   2 },
    { 2001,   2,  28,    18,   2,0,   6 },
    { 2001,   3,   1,    18,   2,0,   7 },
    { 2001,   3,   5,    18,   2,0,  11 },
    { 2001,   3,  20,    18,   2,0,  26 },
    { 2001,   3,  24,    18,   2,0,  30 },
    { 2001,   3,  25,    18,   3,0,   1 },
    { 2001,   3,  26,    18,   3,0,   2 },
    { 2001,   3,  31,    18,   3,0,   7 },
    { 2001,   4,   1,    18,   3,0,   8 },
    { 2001,   4,   5,    18,   3,0,  12 },
    { 2001,   4,  20,    18,   3,0,  27 },
    { 2001,   4,  22,    18,   3,0,  29 },
    { 2001,   4,  23,    18,   4,0,   1 },
    { 2001,   4,  24,    18,   4,0,   2 },
    { 2001,   4,  30,    18,   4,0,   8 },
    { 2001,   5,   1,    18,   4,0,   9 },
    { 2001,   5,   5,    18,   4,0,  13 },
    { 2001,   5,  21,    18,   4,0,  29 },
    { 2001,   5,  22,    18,   4,0,  30 },
    { 2001,   5,  23,    18,   4,1,   1 },
    { 2001,   5,  24,    18,   4,1,   2 },
    { 2001,   5,  31,    18,   4,1,   9 },
    { 2001,   6,   1,    18,   4,1,  10 },
    { 2001,   6,   5,    18,   4,1,  14 },
    { 2001,   6,  20,    18,   4,1,  29 },
    { 2001,   6,  21,    18,   5,0,   1 },
    { 2001,   6,  22,    18,   5,0,   2 },
    { 2001,   6,  30,    18,   5,0,  10 },
    { 2001,   7,   1,    18,   5,0,  11 },
    { 2001,   7,   7,    18,   5,0,  17 },
    { 2001,   7,  20,    18,   5,0,  30 },
    { 2001,   7,  21,    18,   6,0,   1 },
    { 2001,   7,  22,    18,   6,0,   2 },
    { 2001,   7,  23,    18,   6,0,   3 },
    { 2001,   7,  31,    18,   6,0,  11 },
    { 2001,   8,   1,    18,   6,0,  12 },
    { 2001,   8,   7,    18,   6,0,  18 },
    { 2001,   8,  18,    18,   6,0,  29 },
    { 2001,   8,  19,    18,   7,0,   1 },
    { 2001,   8,  20,    18,   7,0,   2 },
    { 2001,   8,  23,    18,   7,0,   5 },
    { 2001,   8,  31,    18,   7,0,  13 },
    { 2001,   9,   1,    18,   7,0,  14 },
    { 2001,   9,   7,    18,   7,0,  20 },
    { 2001,   9,  16,    18,   7,0,  29 },
    { 2001,   9,  17,    18,   8,0,   1 },
    { 2001,   9,  18,    18,   8,0,   2 },
    { 2001,   9,  23,    18,   8,0,   7 },
    { 2001,   9,  30,    18,   8,0,  14 },
    { 2001,  10,   1,    18,   8,0,  15 },
    { 2001,  10,   8,    18,   8,0,  22 },
    { 2001,  10,  16,    18,   8,0,  30 },
    { 2001,  10,  17,    18,   9,0,   1 },
    { 2001,  10,  18,    18,   9,0,   2 },
    { 2001,  10,  23,    18,   9,0,   7 },
    { 2001,  10,  31,    18,   9,0,  15 },
    { 2001,  11,   1,    18,   9,0,  16 },
    { 2001,  11,   7,    18,   9,0,  22 },
    { 2001,  11,  14,    18,   9,0,  29 },
    { 2001,  11,  15,    18,  10,0,   1 },
    { 2001,  11,  16,    18,  10,0,   2 },
    { 2001,  11,  22,    18,  10,0,   8 },
    { 2001,  11,  30,    18,  10,0,  16 },
    { 2001,  12,   1,    18,  10,0,  17 },
    { 2001,  12,   7,    18,  10,0,  23 },
    { 2001,  12,  14,    18,  10,0,  30 },
    { 2001,  12,  15,    18,  11,0,   1 },
    { 2001,  12,  16,    18,  11,0,   2 },
    { 2001,  12,  22,    18,  11,0,   8 },
    { 2001,  12,  31,    18,  11,0,  17 },
    { 2002,   1,   1,    18,  11,0,  18 },
    { 2002,   1,   5,    18,  11,0,  22 },
    { 2002,   1,  12,    18,  11,0,  29 },
    { 2002,   1,  13,    18,  12,0,   1 },
    { 2002,   1,  14,    18,  12,0,   2 },
    { 2002,   1,  20,    18,  12,0,   8 },
    { 2002,   1,  31,    18,  12,0,  19 },
    { 2002,   2,   1,    18,  12,0,  20 },
    { 2002,   2,   4,    18,  12,0,  23 },
    { 2002,   2,  11,    18,  12,0,  30 },
    { 2002,   2,  12,    19,   1,0,   1 },
    { 2002,   2,  13,    19,   1,0,   2 },
    { 2002,   2,  19,    19,   1,0,   8 },
    { 2002,   2,  28,    19,   1,0,  17 },
    { 2002,   3,   1,    19,   1,0,  18 },
    { 2002,   3,   6,    19,   1,0,  23 },
    { 2002,   3,  13,    19,   1,0,  30 },
    { 2002,   3,  14,    19,   2,0,   1 },
    { 2002,   3,  15,    19,   2,0,   2 },
    { 2002,   3,  21,    19,   2,0,   8 },
    { 2002,   3,  31,    19,   2,0,  18 },
    { 2002,   4,   1,    19,   2,0,  19 },
    { 2002,   4,   5,    19,   2,0,  23 },
    { 2002,   4,  12,    19,   2,0,  30 },
    { 2002,   4,  13,    19,   3,0,   1 },
    { 2002,   4,  14,    19,   3,0,   2 },
    { 2002,   4,  20,    19,   3,0,   8 },
    { 2002,   4,  30,    19,   3,0,  18 },
    { 2002,   5,   1,    19,   3,0,  19 },
    { 2002,   5,   6,    19,   3,0,  24 },
    { 2002,   5,  11,    19,   3,0,  29 },
    { 2002,   5,  12,    19,   4,0,   1 },
    { 2002,   5,  13,    19,   4,0,   2 },
    { 2002,   5,  21,    19,   4,0,  10 },
    { 2002,   5,  31,    19,   4,0,  20 },
    { 2002,   6,   1,    19,   4,0,  21 },
    { 2002,   6,   6,    19,   4,0,  26 },
    { 2002,   6,  10,    19,   4,0,  30 },
    { 2002,   6,  11,    19,   5,0,   1 },
    { 2002,   6,  12,    19,   5,0,   2 },
    { 2002,   6,  21,    19,   5,0,  11 },
    { 2002,   6,  30,    19,   5,0,  20 },
    { 2002,   7,   1,    19,   5,0,  21 },
    { 2002,   7,   7,    19,   5,0,  27 },
    { 2002,   7,   9,    19,   5,0,  29 },
    { 2002,   7,  10,    19,   6,0,   1 },
    { 2002,   7,  11,    19,   6,0,   2 },
    { 2002,   7,  23,    19,   6,0,  14 },
    { 2002,   7,  31,    19,   6,0,  22 },
    { 2002,   8,   1,    19,   6,0,  23 },
    { 2002,   8,   8,    19,   6,0,  30 },
    { 2002,   8,   9,    19,   7,0,   1 },
    { 2002,   8,  10,    19,   7,0,   2 },
    { 2002,   8,  23,    19,   7,0,  15 },
    { 2002,   8,  31,    19,   7,0,  23 },
    { 2002,   9,   1,    19,   7,0,  24 },
    { 2002,   9,   6,    19,   7,0,  29 },
    { 2002,   9,   7,    19,   8,0,   1 },
    { 2002,   9,   8,    19,   8,0,   2 },
    { 2002,   9,  23,    19,   8,0,  17 },
    { 2002,   9,  30,    19,   8,0,  24 },
    { 2002,  10,   1,    19,   8,0,  25 },
    { 2002,  10,   5,    19,   8,0,  29 },
    { 2002,  10,   6,    19,   9,0,   1 },
    { 2002,  10,   7,    19,   9,0,   2 },
    { 2002,  10,   8,    19,   9,0,   3 },
    { 2002,  10,  23,    19,   9,0,  18 },
    { 2002,  10,  31,    19,   9,0,  26 },
    { 2002,  11,   1,    19,   9,0,  27 },
    { 2002,  11,   4,    19,   9,0,  30 },
    { 2002,  11,   5,    19,  10,0,   1 },
    { 2002,  11,   6,    19,  10,0,   2 },
    { 2002,  11,   7,    19,  10,0,   3 },
    { 2002,  11,  22,    19,  10,0,  18 },
    { 2002,  11,  30,    19,  10,0,  26 },
    { 2002,  12,   1,    19,  10,0,  27 },
    { 2002,  12,   3,    19,  10,0,  29 },
    { 2002,  12,   4,    19,  11,0,   1 },
    { 2002,  12,   5,    19,  11,0,   2 },
    { 2002,  12,   7,    19,  11,0,   4 },
    { 2002,  12,  22,    19,  11,0,  19 },
    { 2003,   1,   2,    19,  11,0,  30 },
    { 2003,   1,   3,    19,  12,0,   1 },
    { 2003,   1,   4,    19,  12,0,   2 },
    { 2003,   1,   6,    19,  12,0,   4 },
    { 2003,   1,  20,    19,  12,0,  18 },
    { 2003,   1,  31,    19,  12,0,  29 },
    { 2003,   2,   1,    20,   1,0,   1 },
    { 2003,   2,   4,    20,   1,0,   4 },
    { 2003,   2,  19,    20,   1,0,  19 },
    { 2003,   3,   2,    20,   1,0,  30 },
    { 2003,   3,   3,    20,   2,0,   1 },
    { 2003,   3,   4,    20,   2,0,   2 },
    { 2003,   3,   6,    20,   2,0,   4 },
    { 2003,   3,  21,    20,   2,0,  19 },
    { 2003,   4,   1,    20,   2,0,  30 },
    { 2003,   4,   2,    20,   3,0,   1 },
    { 2003,   4,   3,    20,   3,0,   2 },
    { 2003,   4,   5,    20,   3,0,   4 },
    { 2003,   4,  20,    20,   3,0,  19 },
    { 2003,   4,  30,    20,   3,0,  29 },
    { 2003,   5,   1,    20,   4,0,   1 },
    { 2003,   5,   6,    20,   4,0,   6 },
    { 2003,   5,  21,    20,   4,0,  21 },
    { 2003,   5,  30,    20,   4,0,  30 },
    { 2003,   5,  31,    20,   5,0,   1 },
    { 2003,   6,   1,    20,   5,0,   2 },
    { 2003,   6,   6,    20,   5,0,   7 },
    { 2003,   6,  22,    20,   5,0,  23 },
    { 2003,   6,  29,    20,   5,0,  30 },
    { 2003,   6,  30,    20,   6,0,   1 },
    { 2003,   7,   1,    20,   6,0,   2 },
    { 2003,   7,   7,    20,   6,0,   8 },
    { 2003,   7,  23,    20,   6,0,  24 },
    { 2003,   7,  28,    20,   6,0,  29 },
    { 2003,   7,  29,    20,   7,0,   1 },
    { 2003,   7,  30,    20,   7,0,   2 },
    { 2003,   7,  31,    20,   7,0,   3 },
    { 2003,   8,   1,    20,   7,0,   4 },
    { 2003,   8,   8,    20,   7,0,  11 },
    { 2003,   8,  23,    20,   7,0,  26 },
    { 2003,   8,  27,    20,   7,0,  30 },
    { 2003,   8,  28,    20,   8,0,   1 },
    { 2003,   8,  29,    20,   8,0,   2 },
    { 2003,   8,  31,    20,   8,0,   4 },
    { 2003,   9,   1,    20,   8,0,   5 },
    { 2003,   9,   8,    20,   8,0,  12 },
    { 2003,   9,  23,    20,   8,0,  27 },
    { 2003,   9,  25,    20,   8,0,  29 },
    { 2003,   9,  26,    20,   9,0,   1 },
    { 2003,   9,  27,    20,   9,0,   2 },
    { 2003,   9,  30,    20,   9,0,   5 },
    { 2003,  10,   1,    20,   9,0,   6 },
    { 2003,  10,   9,    20,   9,0,  14 },
    { 2003,  10,  24,    20,   9,0,  29 },
    { 2003,  10,  25,    20,  10,0,   1 },
    { 2003,  10,  26,    20,  10,0,   2 },
    { 2003,  10,  31,    20,  10,0,   7 },
    { 2003,  11,   1,    20,  10,0,   8 },
    { 2003,  11,   8,    20,  10,0,  15 },
    { 2003,  11,  23,    20,  10,0,  30 },
    { 2003,  11,  24,    20,  11,0,   1 },
    { 2003,  11,  25,    20,  11,0,   2 },
    { 2003,  11,  30,    20,  11,0,   7 },
    { 2003,  12,   1,    20,  11,0,   8 },
    { 2003,  12,   7,    20,  11,0,  14 },
    { 2003,  12,  22,    20,  11,0,  29 },
    { 2003,  12,  23,    20,  12,0,   1 },
    { 2003,  12,  24,    20,  12,0,   2 },
    { 2003,  12,  31,    20,  12,0,   9 },
    { 2004,   1,   1,    20,  12,0,  10 },
    { 2004,   1,   6,    20,  12,0,  15 },
    { 2004,   1,  21,    20,  12,0,  30 },
    { 2004,   1,  22,    21,   1,0,   1 },
    { 2004,   1,  23,    21,   1,0,   2 },
    { 2004,   1,  31,    21,   1,0,  10 },
    { 2004,   2,   1,    21,   1,0,  11 },
    { 2004,   2,   4,    21,   1,0,  14 },
    { 2004,   2,  19,    21,   1,0,  29 },
    { 2004,   2,  20,    21,   2,0,   1 },
    { 2004,   2,  21,    21,   2,0,   2 },
    { 2004,   2,  29,    21,   2,0,  10 },
    { 2004,   3,   1,    21,   2,0,  11 },
    { 2004,   3,   5,    21,   2,0,  15 },
    { 2004,   3,  20,    21,   2,0,  30 },
    { 2004,   3,  21,    21,   2,1,   1 },
    { 2004,   3,  22,    21,   2,1,   2 },
    { 2004,   3,  31,    21,   2,1,  11 },
    { 2004,   4,   1,    21,   2,1,  12 },
    { 2004,   4,   4,    21,   2,1,  15 },
    { 2004,   4,  18,    21,   2,1,  29 },
    { 2004,   4,  19,    21,   3,0,   1 },
    { 2004,   4,  20,    21,   3,0,   2 },
    { 2004,   4,  30,    21,   3,0,  12 },
    { 2004,   5,   1,    21,   3,0,  13 },
    { 2004,   5,   5,    21,   3,0,  17 },
    { 2004,   5,  18,    21,   3,0,  30 },
    { 2004,   5,  19,    21,   4,0,   1 },
    { 2004,   5,  20,    21,   4,0,   2 },
    { 2004,   5,  21,    21,   4,0,   3 },
    { 2004,   5,  31,    21,   4,0,  13 },
    { 2004,   6,   1,    21,   4,0,  14 },
    { 2004,   6,   5,    21,   4,0,  18 },
    { 2004,   6,  17,    21,   4,0,  30 },
    { 2004,   6,  18,    21,   5,0,   1 },
    { 2004,   6,  19,    21,   5,0,   2 },
    { 2004,   6,  21,    21,   5,0,   4 },
    { 2004,   6,  30,    21,   5,0,  13 },
    { 2004,   7,   1,    21,   5,0,  14 },
    { 2004,   7,   7,    21,   5,0,  20 },
    { 2004,   7,  16,    21,   5,0,  29 },
    { 2004,   7,  17,    21,   6,0,   1 },
    { 2004,   7,  18,    21,   6,0,   2 },
    { 2004,   7,  22,    21,   6,0,   6 },
    { 2004,   7,  31,    21,   6,0,  15 },
    { 2004,   8,   1,    21,   6,0,  16 },
    { 2004,   8,   7,    21,   6,0,  22 },
    { 2004,   8,  15,    21,   6,0,  30 },
    { 2004,   8,  16,    21,   7,0,   1 },
    { 2004,   8,  17,    21,   7,0,   2 },
    { 2004,   8,  23,    21,   7,0,   8 },
    { 2004,   8,  31,    21,   7,0,  16 },
    { 2004,   9,   1,    21,   7,0,  17 },
    { 2004,   9,   7,    21,   7,0,  23 },
    { 2004,   9,  13,    21,   7,0,  29 },
    { 2004,   9,  14,    21,   8,0,   1 },
    { 2004,   9,  15,    21,   8,0,   2 },
    { 2004,   9,  23,    21,   8,0,  10 },
    { 2004,   9,  30,    21,   8,0,  17 },
    { 2004,  10,   1,    21,   8,0,  18 },
    { 2004,  10,   8,    21,   8,0,  25 },
    { 2004,  10,  13,    21,   8,0,  30 },
    { 2004,  10,  14,    21,   9,0,   1 },
    { 2004,  10,  15,    21,   9,0,   2 },
    { 2004,  10,  23,    21,   9,0,  10 },
    { 2004,  10,  31,    21,   9,0,  18 },
    { 2004,  11,   1,    21,   9,0,  19 },
    { 2004,  11,   7,    21,   9,0,  25 },
    { 2004,  11,  11,    21,   9,0,  29 },
    { 2004,  11,  12,    21,  10,0,   1 },
    { 2004,  11,  13,    21,  10,0,   2 },
    { 2004,  11,  22,    21,  10,0,  11 },
    { 2004,  11,  30,    21,  10,0,  19 },
    { 2004,  12,   1,    21,  10,0,  20 },
    { 2004,  12,   7,    21,  10,0,  26 },
    { 2004,  12,  11,    21,  10,0,  30 },
    { 2004,  12,  12,    21,  11,0,   1 },
    { 2004,  12,  13,    21,  11,0,   2 },
    { 2004,  12,  21,    21,  11,0,  10 },
    { 2004,  12,  31,    21,  11,0,  20 },
    { 2005,   1,   1,    21,  11,0,  21 },
    { 2005,   1,   5,    21,  11,0,  25 },
    { 2005,   1,   9,    21,  11,0,  29 },
    { 2005,   1,  10,    21,  12,0,   1 },
    { 2005,   1,  11,    21,  12,0,   2 },
    { 2005,   1,  20,    21,  12,0,  11 },
    { 2005,   1,  31,    21,  12,0,  22 },
    { 2005,   2,   1,    21,  12,0,  23 },
    { 2005,   2,   4,    21,  12,0,  26 },
    { 2005,   2,   8,    21,  12,0,  30 },
    { 2005,   2,   9,    22,   1,0,   1 },
    { 2005,   2,  10,    22,   1,0,   2 },
    { 2005,   2,  18,    22,   1,0,  10 },
    { 2005,   2,  28,    22,   1,0,  20 },
    { 2005,   3,   1,    22,   1,0,  21 },
    { 2005,   3,   5,    22,   1,0,  25 },
    { 2005,   3,   9,    22,   1,0,  29 },
    { 2005,   3,  10,    22,   2,0,   1 },
    { 2005,   3,  11,    22,   2,0,   2 },
    { 2005,   3,  20,    22,   2,0,  11 },
    { 2005,   3,  31,    22,   2,0,  22 },
    { 2005,   4,   1,    22,   2,0,  23 },
    { 2005,   4,   5,    22,   2,0,  27 },
    { 2005,   4,   8,    22,   2,0,  30 },
    { 2005,   4,   9,    22,   3,0,   1 },
    { 2005,   4,  10,    22,   3,0,   2 },
    { 2005,   4,  20,    22,   3,0,  12 },
    { 2005,   4,  30,    22,   3,0,  22 },
    { 2005,   5,   1,    22,   3,0,  23 },
    { 2005,   5,   5,    22,   3,0,  27 },
    { 2005,   5,   7,    22,   3,0,  29 },
    { 2005,   5,   8,    22,   4,0,   1 },
    { 2005,   5,   9,    22,   4,0,   2 },
    { 2005,   5,  21,    22,   4,0,  14 },
    { 2005,   5,  31,    22,   4,0,  24 },
    { 2005,   6,   1,    22,   4,0,  25 },
    { 2005,   6,   5,    22,   4,0,  29 },
    { 2005,   6,   6,    22,   4,0,  30 },
    { 2005,   6,   7,    22,   5,0,   1 },
    { 2005,   6,   8,    22,   5,0,   2 },
    { 2005,   6,  21,    22,   5,0,  15 },
    { 2005,   6,  30,    22,   5,0,  24 },
    { 2005,   7,   1,    22,   5,0,  25 },
    { 2005,   7,   5,    22,   5,0,  29 },
    { 2005,   7,   6,    22,   6,0,   1 },
    { 2005,   7,   7,    22,   6,0,   2 },
    { 2005,   7,  23,    22,   6,0,  18 },
    { 2005,   7,  31,    22,   6,0,  26 },
    { 2005,   8,   1,    22,   6,0,  27 },
    { 2005,   8,   4,    22,   6,0,  30 },
    { 2005,   8,   5,    22,   7,0,   1 },
    { 2005,   8,   6,    22,   7,0,   2 },
    { 2005,   8,   7,    22,   7,0,   3 },
    { 2005,   8,  23,    22,   7,0,  19 },
    { 2005,   8,  31,    22,   7,0,  27 },
    { 2005,   9,   1,    22,   7,0,  28 },
    { 2005,   9,   3,    22,   7,0,  30 },
    { 2005,   9,   4,    22,   8,0,   1 },
    { 2005,   9,   5,    22,   8,0,   2 },
    { 2005,   9,   7,    22,   8,0,   4 },
    { 2005,   9,  23,    22,   8,0,  20 },
    { 2005,  10,   2,    22,   8,0,  29 },
    { 2005,  10,   3,    22,   9,0,   1 },
    { 2005,  10,   4,    22,   9,0,   2 },
    { 2005,  10,   8,    22,   9,0,   6 },
    { 2005,  10,  23,    22,   9,0,  21 },
    { 2005,  11,   1,    22,   9,0,  30 },
    { 2005,  11,   2,    22,  10,0,   1 },
    { 2005,  11,   3,    22,  10,0,   2 },
    { 2005,  11,   7,    22,  10,0,   6 },
    { 2005,  11,  22,    22,  10,0,  21 },
    { 2005,  11,  30,    22,  10,0,  29 },
    { 2005,  12,   1,    22,  11,0,   1 },
    { 2005,  12,   7,    22,  11,0,   7 },
    { 2005,  12,  22,    22,  11,0,  22 },
    { 2005,  12,  30,    22,  11,0,  30 },
    { 2005,  12,  31,    22,  12,0,   1 },
    { 2006,   1,   1,    22,  12,0,   2 },
    { 2006,   1,   5,    22,  12,0,   6 },
    { 2006,   1,  20,    22,  12,0,  21 },
    { 2006,   1,  28,    22,  12,0,  29 },
    { 2006,   1,  29,    23,   1,0,   1 },
    { 2006,   1,  30,    23,   1,0,   2 },
    { 2006,   1,  31,    23,   1,0,   3 },
    { 2006,   2,   1,    23,   1,0,   4 },
    { 2006,   2,   4,    23,   1,0,   7 },
    { 2006,   2,  19,    23,   1,0,  22 },
    { 2006,   2,  27,    23,   1,0,  30 },
    { 2006,   2,  28,    23,   2,0,   1 },
    { 2006,   3,   1,    23,   2,0,   2 },
    { 2006,   3,   6,    23,   2,0,   7 },
    { 2006,   3,  21,    23,   2,0,  22 },
    { 2006,   3,  28,    23,   2,0,  29 },
    { 2006,   3,  29,    23,   3,0,   1 },
    { 2006,   3,  30,    23,   3,0,   2 },
    { 2006,   3,  31,    23,   3,0,   3 },
    { 2006,   4,   1,    23,   3,0,   4 },
    { 2006,   4,   5,    23,   3,0,   8 },
    { 2006,   4,  20,    23,   3,0,  23 },
    { 2006,   4,  27,    23,   3,0,  30 },
    { 2006,   4,  28,    23,   4,0,   1 },
    { 2006,   4,  29,    23,   4,0,   2 },
    { 2006,   4,  30,    23,   4,0,   3 },
    { 2006,   5,   1,    23,   4,0,   4 },
    { 2006,   5,   5,    23,   4,0,   8 },
    { 2006,   5,  21,    23,   4,0,  24 },
    { 2006,   5,  26,    23,   4,0,  29 },
    { 2006,   5,  27,    23,   5,0,   1 },
    { 2006,   5,  28,    23,   5,0,   2 },
    { 2006,   5,  31,    23,   5,0,   5 },
    { 2006,   6,   1,    23,   5,0,   6 },
    { 2006,   6,   6,    23,   5,0,  11 },
    { 2006,   6,  21,    23,   5,0,  26 },
    { 2006,   6,  25,    23,   5,0,  30 },
    { 2006,   6,  26,    23,   6,0,   1 },
    { 2006,   6,  27,    23,   6,0,   2 },
    { 2006,   6,  30,    23,   6,0,   5 },
    { 2006,   7,   1,    23,   6,0,   6 },
    { 2006,   7,   7,    23,   6,0,  12 },
    { 2006,   7,  23,    23,   6,0,  28 },
    { 2006,   7,  24,    23,   6,0,  29 },
    { 2006,   7,  25,    23,   7,0,   1 },
    { 2006,   7,  26,    23,   7,0,   2 },
    { 2006,   7,  31,    23,   7,0,   7 },
    { 2006,   8,   1,    23,   7,0,   8 },
    { 2006,   8,   7,    23,   7,0,  14 },
    { 2006,   8,  23,    23,   7,0,  30 },
    { 2006,   8,  24,    23,   7,1,   1 },
    { 2006,   8,  25,    23,   7,1,   2 },
    { 2006,   8,  31,    23,   7,1,   8 },
    { 2006,   9,   1,    23,   7,1,   9 },
    { 2006,   9,   8,    23,   7,1,  16 },
    { 2006,   9,  21,    23,   7,1,  29 },
    { 2006,   9,  22,    23,   8,0,   1 },
    { 2006,   9,  23,    23,   8,0,   2 },
    { 2006,   9,  30,    23,   8,0,   9 },
    { 2006,  10,   1,    23,   8,0,  10 },
    { 2006,  10,   8,    23,   8,0,  17 },
    { 2006,  10,  21,    23,   8,0,  30 },
    { 2006,  10,  22,    23,   9,0,   1 },
    { 2006,  10,  23,    23,   9,0,   2 },
    { 2006,  10,  31,    23,   9,0,  10 },
    { 2006,  11,   1,    23,   9,0,  11 },
    { 2006,  11,   7,    23,   9,0,  17 },
    { 2006,  11,  20,    23,   9,0,  30 },
    { 2006,  11,  21,    23,  10,0,   1 },
    { 2006,  11,  22,    23,  10,0,   2 },
    { 2006,  11,  30,    23,  10,0,  10 },
    { 2006,  12,   1,    23,  10,0,  11 },
    { 2006,  12,   7,    23,  10,0,  17 },
    { 2006,  12,  19,    23,  10,0,  29 },
    { 2006,  12,  20,    23,  11,0,   1 },
    { 2006,  12,  21,    23,  11,0,   2 },
    { 2006,  12,  22,    23,  11,0,   3 },
    { 2006,  12,  31,    23,  11,0,  12 },
    { 2007,   1,   1,    23,  11,0,  13 },
    { 2007,   1,   6,    23,  11,0,  18 },
    { 2007,   1,  18,    23,  11,0,  30 },
    { 2007,   1,  19,    23,  12,0,   1 },
    { 2007,   1,  20,    23,  12,0,   2 },
    { 2007,   1,  31,    23,  12,0,  13 },
    { 2007,   2,   1,    23,  12,0,  14 },
    { 2007,   2,   4,    23,  12,0,  17 },
    { 2007,   2,  17,    23,  12,0,  30 },
    { 2007,   2,  18,    24,   1,0,   1 },
    { 2007,   2,  19,    24,   1,0,   2 },
    { 2007,   2,  28,    24,   1,0,  11 },
    { 2007,   3,   1,    24,   1,0,  12 },
    { 2007,   3,   6,    24,   1,0,  17 },
    { 2007,   3,  18,    24,   1,0,  29 },
    { 2007,   3,  19,    24,   2,0,   1 },
    { 2007,   3,  20,    24,   2,0,   2 },
    { 2007,   3,  21,    24,   2,0,   3 },
    { 2007,   3,  31,    24,   2,0,  13 },
    { 2007,   4,   1,    24,   2,0,  14 },
    { 2007,   4,   5,    24,   2,0,  18 },
    { 2007,   4,  16,    24,   2,0,  29 },
    { 2007,   4,  17,    24,   3,0,   1 },
    { 2007,   4,  18,    24,   3,0,   2 },
    { 2007,   4,  20,    24,   3,0,   4 },
    { 2007,   4,  30,    24,   3,0,  14 },
    { 2007,   5,   1,    24,   3,0,  15 },
    { 2007,   5,   6,    24,   3,0,  20 },
    { 2007,   5,  16,    24,   3,0,  30 },
    { 2007,   5,  17,    24,   4,0,   1 },
    { 2007,   5,  18,    24,   4,0,   2 },
    { 2007,   5,  21,    24,   4,0,   5 },
    { 2007,   5,  31,    24,   4,0,  15 },
    { 2007,   6,   1,    24,   4,0,  16 },
    { 2007,   6,   6,    24,   4,0,  21 },
    { 2007,   6,  14,    24,   4,0,  29 },
    { 2007,   6,  15,    24,   5,0,   1 },
    { 2007,   6,  16,    24,   5,0,   2 },
    { 2007,   6,  22,    24,   5,0,   8 },
    { 2007,   6,  30,    24,   5,0,  16 },
    { 2007,   7,   1,    24,   5,0,  17 },
    { 2007,   7,   7,    24,   5,0,  23 },
    { 2007,   7,  13,    24,   5,0,  29 },
    { 2007,   7,  14,    24,   6,0,   1 },
    { 2007,   7,  15,    24,   6,0,   2 },
    { 2007,   7,  23,    24,   6,0,  10 },
    { 2007,   7,  31,    24,   6,0,  18 },
    { 2007,   8,   1,    24,   6,0,  19 },
    { 2007,   8,   8,    24,   6,0,  26 },
    { 2007,   8,  12,    24,   6,0,  30 },
    { 2007,   8,  13,    24,   7,0,   1 },
    { 2007,   8,  14,    24,   7,0,   2 },
    { 2007,   8,  23,    24,   7,0,  11 },
    { 2007,   8,  31,    24,   7,0,  19 },
    { 2007,   9,   1,    24,   7,0,  20 },
    { 2007,   9,   8,    24,   7,0,  27 },
    { 2007,   9,  10,    24,   7,0,  29 },
    { 2007,   9,  11,    24,   8,0,   1 },
    { 2007,   9,  12,    24,   8,0,   2 },
    { 2007,   9,  23,    24,   8,0,  13 },
    { 2007,   9,  30,    24,   8,0,  20 },
    { 2007,  10,   1,    24,   8,0,  21 },
    { 2007,  10,   9,    24,   8,0,  29 },
    { 2007,  10,  10,    24,   8,0,  30 },
    { 2007,  10,  11,    24,   9,0,   1 },
    { 2007,  10,  12,    24,   9,0,   2 },
    { 2007,  10,  24,    24,   9,0,  14 },
    { 2007,  10,  31,    24,   9,0,  21 },
    { 2007,  11,   1,    24,   9,0,  22 },
    { 2007,  11,   8,    24,   9,0,  29 },
    { 2007,  11,   9,    24,   9,0,  30 },
    { 2007,  11,  10,    24,  10,0,   1 },
    { 2007,  11,  11,    24,  10,0,   2 },
    { 2007,  11,  23,    24,  10,0,  14 },
    { 2007,  11,  30,    24,  10,0,  21 },
    { 2007,  12,   1,    24,  10,0,  22 },
    { 2007,  12,   7,    24,  10,0,  28 },
    { 2007,  12,   9,    24,  10,0,  30 },
    { 2007,  12,  10,    24,  11,0,   1 },
    { 2007,  12,  11,    24,  11,0,   2 },
    { 2007,  12,  22,    24,  11,0,  13 },
    { 2007,  12,  31,    24,  11,0,  22 },
    { 2008,   1,   1,    24,  11,0,  23 },
    { 2008,   1,   6,    24,  11,0,  28 },
    { 2008,   1,   7,    24,  11,0,  29 },
    { 2008,   1,   8,    24,  12,0,   1 },
    { 2008,   1,   9,    24,  12,0,   2 },
    { 2008,   1,  21,    24,  12,0,  14 },
    { 2008,   1,  31,    24,  12,0,  24 },
    { 2008,   2,   1,    24,  12,0,  25 },
    { 2008,   2,   4,    24,  12,0,  28 },
    { 2008,   2,   6,    24,  12,0,  30 },
    { 2008,   2,   7,    25,   1,0,   1 },
    { 2008,   2,   8,    25,   1,0,   2 },
    { 2008,   2,  19,    25,   1,0,  13 },
    { 2008,   2,  29,    25,   1,0,  23 },
    { 2008,   3,   1,    25,   1,0,  24 },
    { 2008,   3,   5,    25,   1,0,  28 },
    { 2008,   3,   7,    25,   1,0,  30 },
    { 2008,   3,   8,    25,   2,0,   1 },
    { 2008,   3,   9,    25,   2,0,   2 },
    { 2008,   3,  20,    25,   2,0,  13 },
    { 2008,   3,  31,    25,   2,0,  24 },
    { 2008,   4,   1,    25,   2,0,  25 },
    { 2008,   4,   4,    25,   2,0,  28 },
    { 2008,   4,   5,    25,   2,0,  29 },
    { 2008,   4,   6,    25,   3,0,   1 },
    { 2008,   4,   7,    25,   3,0,   2 },
    { 2008,   4,  20,    25,   3,0,  15 },
    { 2008,   4,  30,    25,   3,0,  25 },
    { 2008,   5,   1,    25,   3,0,  26 },
    { 2008,   5,   4,    25,   3,0,  29 },
    { 2008,   5,   5,    25,   4,0,   1 },
    { 2008,   5,   6,    25,   4,0,   2 },
    { 2008,   5,  21,    25,   4,0,  17 },
    { 2008,   5,  31,    25,   4,0,  27 },
    { 2008,   6,   1,    25,   4,0,  28 },
    { 2008,   6,   3,    25,   4,0,  30 },
    { 2008,   6,   4,    25,   5,0,   1 },
    { 2008,   6,   5,    25,   5,0,   2 },
    { 2008,   6,  21,    25,   5,0,  18 },
    { 2008,   7,   2,    25,   5,0,  29 },
    { 2008,   7,   3,    25,   6,0,   1 },
    { 2008,   7,   4,    25,   6,0,   2 },
    { 2008,   7,   7,    25,   6,0,   5 },
    { 2008,   7,  22,    25,   6,0,  20 },
    { 2008,   7,  31,    25,   6,0,  29 },
    { 2008,   8,   1,    25,   7,0,   1 },
    { 2008,   8,   7,    25,   7,0,   7 },
    { 2008,   8,  23,    25,   7,0,  23 },
    { 2008,   8,  30,    25,   7,0,  30 },
    { 2008,   8,  31,    25,   8,0,   1 },
    { 2008,   9,   1,    25,   8,0,   2 },
    { 2008,   9,   7,    25,   8,0,   8 },
    { 2008,   9,  22,    25,   8,0,  23 },
    { 2008,   9,  28,    25,   8,0,  29 },
    { 2008,   9,  29,    25,   9,0,   1 },
    { 2008,   9,  30,    25,   9,0,   2 },
    { 2008,  10,   1,    25,   9,0,   3 },
    { 2008,  10,   8,    25,   9,0,  10 },
    { 2008,  10,  23,    25,   9,0,  25 },
    { 2008,  10,  28,    25,   9,0,  30 },
    { 2008,  10,  29,    25,  10,0,   1 },
    { 2008,  10,  30,    25,  10,0,   2 },
    { 2008,  10,  31,    25,  10,0,   3 },
    { 2008,  11,   1,    25,  10,0,   4 },
    { 2008,  11,   7,    25,  10,0,  10 },
    { 2008,  11,  22,    25,  10,0,  25 },
    { 2008,  11,  27,    25,  10,0,  30 },
    { 2008,  11,  28,    25,  11,0,   1 },
    { 2008,  11,  29,    25,  11,0,   2 },
    { 2008,  11,  30,    25,  11,0,   3 },
    { 2008,  12,   1,    25,  11,0,   4 },
    { 2008,  12,   7,    25,  11,0,  10 },
    { 2008,  12,  21,    25,  11,0,  24 },
    { 2008,  12,  26,    25,  11,0,  29 },
    { 2008,  12,  27,    25,  12,0,   1 },
    { 2008,  12,  28,    25,  12,0,   2 },
    { 2008,  12,  31,    25,  12,0,   5 },
    { 2009,   1,   1,    25,  12,0,   6 },
    { 2009,   1,   5,    25,  12,0,  10 },
    { 2009,   1,  20,    25,  12,0,  25 },
    { 2009,   1,  25,    25,  12,0,  30 },
    { 2009,   1,  26,    26,   1,0,   1 },
    { 2009,   1,  27,    26,   1,0,   2 },
    { 2009,   1,  31,    26,   1,0,   6 },
    { 2009,   2,   1,    26,   1,0,   7 },
    { 2009,   2,   4,    26,   1,0,  10 },
    { 2009,   2,  18,    26,   1,0,  24 },
    { 2009,   2,  24,    26,   1,0,  30 },
    { 2009,   2,  25,    26,   2,0,   1 },
    { 2009,   2,  26,    26,   2,0,   2 },
    { 2009,   2,  28,    26,   2,0,   4 },
    { 2009,   3,   1,    26,   2,0,   5 },
    { 2009,   3,   5,    26,   2,0,   9 },
    { 2009,   3,  20,    26,   2,0,  24 },
    { 2009,   3,  26,    26,   2,0,  30 },
    { 2009,   3,  27,    26,   3,0,   1 },
    { 2009,   3,  28,    26,   3,0,   2 },
    { 2009,   3,  31,    26,   3,0,   5 },
    { 2009,   4,   1,    26,   3,0,   6 },
    { 2009,   4,   4,    26,   3,0,   9 },
    { 2009,   4,  20,    26,   3,0,  25 },
    { 2009,   4,  24,    26,   3,0,  29 },
    { 2009,   4,  25,    26,   4,0,   1 },
    { 2009,   4,  26,    26,   4,0,   2 },
    { 2009,   4,  30,    26,   4,0,   6 },
    { 2009,   5,   1,    26,   4,0,   7 },
    { 2009,   5,   5,    26,   4,0,  11 },
    { 2009,   5,  21,    26,   4,0,  27 },
    { 2009,   5,  23,    26,   4,0,  29 },
    { 2009,   5,  24,    26,   5,0,   1 },
    { 2009,   5,  25,    26,   5,0,   2 },
    { 2009,   5,  31,    26,   5,0,   8 },
    { 2009,   6,   1,    26,   5,0,   9 },
    { 2009,   6,   5,    26,   5,0,  13 },
    { 2009,   6,  21,    26,   5,0,  29 },
    { 2009,   6,  22,    26,   5,0,  30 },
    { 2009,   6,  23,    26,   5,1,   1 },
    { 2009,   6,  24,    26,   5,1,   2 },
    { 2009,   6,  30,    26,   5,1,   8 },
    { 2009,   7,   1,    26,   5,1,   9 },
    { 2009,   7,   7,    26,   5,1,  15 },
    { 2009,   7,  21,    26,   5,1,  29 },
    { 2009,   7,  22,    26,   6,0,   1 },
    { 2009,   7,  23,    26,   6,0,   2 },
    { 2009,   7,  31,    26,   6,0,  10 },
    { 2009,   8,   1,    26,   6,0,  11 },
    { 2009,   8,   7,    26,   6,0,  17 },
    { 2009,   8,  19,    26,   6,0,  29 },
    { 2009,   8,  20,    26,   7,0,   1 },
    { 2009,   8,  21,    26,   7,0,   2 },
    { 2009,   8,  23,    26,   7,0,   4 },
    { 2009,   8,  31,    26,   7,0,  12 },
    { 2009,   9,   1,    26,   7,0,  13 },
    { 2009,   9,   7,    26,   7,0,  19 },
    { 2009,   9,  18,    26,   7,0,  30 },
    { 2009,   9,  19,    26,   8,0,   1 },
    { 2009,   9,  20,    26,   8,0,   2 },
    { 2009,   9,  23,    26,   8,0,   5 },
    { 2009,   9,  30,    26,   8,0,  12 },
    { 2009,  10,   1,    26,   8,0,  13 },
    { 2009,  10,   8,    26,   8,0,  20 },
    { 2009,  10,  17,    26,   8,0,  29 },
    { 2009,  10,  18,    26,   9,0,   1 },
    { 2009,  10,  19,    26,   9,0,   2 },
    { 2009,  10,  23,    26,   9,0,   6 },
    { 2009,  10,  31,    26,   9,0,  14 },
    { 2009,  11,   1,    26,   9,0,  15 },
    { 2009,  11,   7,    26,   9,0,  21 },
    { 2009,  11,  16,    26,   9,0,  30 },
    { 2009,  11,  17,    26,  10,0,   1 },
    { 2009,  11,  18,    26,  10,0,   2 },
    { 2009,  11,  22,    26,  10,0,   6 },
    { 2009,  11,  30,    26,  10,0,  14 },
    { 2009,  12,   1,    26,  10,0,  15 },
    { 2009,  12,   7,    26,  10,0,  21 },
    { 2009,  12,  15,    26,  10,0,  29 },
    { 2009,  12,  16,    26,  11,0,   1 },
    { 2009,  12,  17,    26,  11,0,   2 },
    { 2009,  12,  22,    26,  11,0,   7 },
    { 2009,  12,  31,    26,  11,0,  16 },
    { 2010,   1,   1,    26,  11,0,  17 },
    { 2010,   1,   5,    26,  11,0,  21 },
    { 2010,   1,  14,    26,  11,0,  30 },
    { 2010,   1,  15,    26,  12,0,   1 },
    { 2010,   1,  16,    26,  12,0,   2 },
    { 2010,   1,  20,    26,  12,0,   6 },
    { 2010,   1,  31,    26,  12,0,  17 },
    { 2010,   2,   1,    26,  12,0,  18 },
    { 2010,   2,   4,    26,  12,0,  21 },
    { 2010,   2,  13,    26,  12,0,  30 },
    { 2010,   2,  14,    27,   1,0,   1 },
    { 2010,   2,  15,    27,   1,0,   2 },
    { 2010,   2,  19,    27,   1,0,   6 },
    { 2010,   2,  28,    27,   1,0,  15 },
    { 2010,   3,   1,    27,   1,0,  16 },
    { 2010,   3,   6,    27,   1,0,  21 },
    { 2010,   3,  15,    27,   1,0,  30 },
    { 2010,   3,  16,    27,   2,0,   1 },
    { 2010,   3,  17,    27,   2,0,   2 },
    { 2010,   3,  21,    27,   2,0,   6 },
    { 2010,   3,  31,    27,   2,0,  16 },
    { 2010,   4,   1,    27,   2,0,  17 },
    { 2010,   4,   5,    27,   2,0,  21 },
    { 2010,   4,  13,    27,   2,0,  29 },
    { 2010,   4,  14,    27,   3,0,   1 },
    { 2010,   4,  15,    27,   3,0,   2 },
    { 2010,   4,  20,    27,   3,0,   7 },
    { 2010,   4,  30,    27,   3,0,  17 },
    { 2010,   5,   1,    27,   3,0,  18 },
    { 2010,   5,   5,    27,   3,0,  22 },
    { 2010,   5,  13,    27,   3,0,  30 },
    { 2010,   5,  14,    27,   4,0,   1 },
    { 2010,   5,  15,    27,   4,0,   2 },
    { 2010,   5,  21,    27,   4,0,   8 },
    { 2010,   5,  31,    27,   4,0,  18 },
    { 2010,   6,   1,    27,   4,0,  19 },
    { 2010,   6,   6,    27,   4,0,  24 },
    { 2010,   6,  11,    27,   4,0,  29 },
    { 2010,   6,  12,    27,   5,0,   1 },
    { 2010,   6,  13,    27,   5,0,   2 },
    { 2010,   6,  21,    27,   5,0,  10 },
    { 2010,   6,  30,    27,   5,0,  19 },
    { 2010,   7,   1,    27,   5,0,  20 },
    { 2010,   7,   7,    27,   5,0,  26 },
    { 2010,   7,  11,    27,   5,0,  30 },
    { 2010,   7,  12,    27,   6,0,   1 },
    { 2010,   7,  13,    27,   6,0,   2 },
    { 2010,   7,  23,    27,   6,0,  12 },
    { 2010,   7,  31,    27,   6,0,  20 },
    { 2010,   8,   1,    27,   6,0,  21 },
    { 2010,   8,   7,    27,   6,0,  27 },
    { 2010,   8,   9,    27,   6,0,  29 },
    { 2010,   8,  10,    27,   7,0,   1 },
    { 2010,   8,  11,    27,   7,0,   2 },
    { 2010,   8,  23,    27,   7,0,  14 },
    { 2010,   8,  31,    27,   7,0,  22 },
    { 2010,   9,   1,    27,   7,0,  23 },
    { 2010,   9,   7,    27,   7,0,  29 },
    { 2010,   9,   8,    27,   8,0,   1 },
    { 2010,   9,   9,    27,   8,0,   2 },
    { 2010,   9,  23,    27,   8,0,  16 },
    { 2010,   9,  30,    27,   8,0,  23 },
    { 2010,  10,   1,    27,   8,0,  24 },
    { 2010,  10,   7,    27,   8,0,  30 },
    { 2010,  10,   8,    27,   9,0,   1 },
    { 2010,  10,   9,    27,   9,0,   2 },
    { 2010,  10,  23,    27,   9,0,  16 },
    { 2010,  10,  31,    27,   9,0,  24 },
    { 2010,  11,   1,    27,   9,0,  25 },
    { 2010,  11,   5,    27,   9,0,  29 },
    { 2010,  11,   6,    27,  10,0,   1 },
    { 2010,  11,   7,    27,  10,0,   2 },
    { 2010,  11,  22,    27,  10,0,  17 },
    { 2010,  11,  30,    27,  10,0,  25 },
    { 2010,  12,   1,    27,  10,0,  26 },
    { 2010,  12,   5,    27,  10,0,  30 },
    { 2010,  12,   6,    27,  11,0,   1 },
    { 2010,  12,   7,    27,  11,0,   2 },
    { 2010,  12,  22,    27,  11,0,  17 },
    { 2010,  12,  31,    27,  11,0,  26 },
    { 2011,   1,   1,    27,  11,0,  27 },
    { 2011,   1,   3,    27,  11,0,  29 },
    { 2011,   1,   4,    27,  12,0,   1 },
    { 2011,   1,   5,    27,  12,0,   2 },
    { 2011,   1,   6,    27,  12,0,   3 },
    { 2011,   1,  20,    27,  12,0,  17 },
    { 2011,   2,   2,    27,  12,0,  30 },
    { 2011,   2,   3,    28,   1,0,   1 },
    { 2011,   2,   4,    28,   1,0,   2 },
    { 2011,   2,  19,    28,   1,0,  17 },
    { 2011,   2,  28,    28,   1,0,  26 },
    { 2011,   3,   1,    28,   1,0,  27 },
    { 2011,   3,   4,    28,   1,0,  30 },
    { 2011,   3,   5,    28,   2,0,   1 },
    { 2011,   3,   6,    28,   2,0,   2 },
    { 2011,   3,  21,    28,   2,0,  17 },
    { 2011,   4,   2,    28,   2,0,  29 },
    { 2011,   4,   3,    28,   3,0,   1 },
    { 2011,   4,   4,    28,   3,0,   2 },
    { 2011,   4,   5,    28,   3,0,   3 },
    { 2011,   4,  20,    28,   3,0,  18 },
    { 2011,   5,   2,    28,   3,0,  30 },
    { 2011,   5,   3,    28,   4,0,   1 },
    { 2011,   5,   4,    28,   4,0,   2 },
    { 2011,   5,   6,    28,   4,0,   4 },
    { 2011,   5,  21,    28,   4,0,  19 },
    { 2011,   6,   1,    28,   4,0,  30 },
    { 2011,   6,   2,    28,   5,0,   1 },
    { 2011,   6,   3,    28,   5,0,   2 },
    { 2011,   6,   6,    28,   5,0,   5 },
    { 2011,   6,  22,    28,   5,0,  21 },
    { 2011,   6,  30,    28,   5,0,  29 },
    { 2011,   7,   1,    28,   6,0,   1 },
    { 2011,   7,   7,    28,   6,0,   7 },
    { 2011,   7,  23,    28,   6,0,  23 },
    { 2011,   7,  30,    28,   6,0,  30 },
    { 2011,   7,  31,    28,   7,0,   1 },
    { 2011,   8,   1,    28,   7,0,   2 },
    { 2011,   8,   8,    28,   7,0,   9 },
    { 2011,   8,  23,    28,   7,0,  24 },
    { 2011,   8,  28,    28,   7,0,  29 },
    { 2011,   8,  29,    28,   8,0,   1 },
    { 2011,   8,  30,    28,   8,0,   2 },
    { 2011,   8,  31,    28,   8,0,   3 },
    { 2011,   9,   1,    28,   8,0,   4 },
    { 2011,   9,   8,    28,   8,0,  11 },
    { 2011,   9,  23,    28,   8,0,  26 },
    { 2011,   9,  26,    28,   8,0,  29 },
    { 2011,   9,  27,    28,   9,0,   1 },
    { 2011,   9,  28,    28,   9,0,   2 },
    { 2011,   9,  30,    28,   9,0,   4 },
    { 2011,  10,   1,    28,   9,0,   5 },
    { 2011,  10,   8,    28,   9,0,  12 },
    { 2011,  10,  24,    28,   9,0,  28 },
    { 2011,  10,  26,    28,   9,0,  30 },
    { 2011,  10,  27,    28,  10,0,   1 },
    { 2011,  10,  28,    28,  10,0,   2 },
    { 2011,  10,  31,    28,  10,0,   5 },
    { 2011,  11,   1,    28,  10,0,   6 },
    { 2011,  11,   8,    28,  10,0,  13 },
    { 2011,  11,  23,    28,  10,0,  28 },
    { 2011,  11,  24,    28,  10,0,  29 },
    { 2011,  11,  25,    28,  11,0,   1 },
    { 2011,  11,  26,    28,  11,0,   2 },
    { 2011,  11,  30,    28,  11,0,   6 },
    { 2011,  12,   1,    28,  11,0,   7 },
    { 2011,  12,   7,    28,  11,0,  13 },
    { 2011,  12,  22,    28,  11,0,  28 },
    { 2011,  12,  24,    28,  11,0,  30 },
    { 2011,  12,  25,    28,  12,0,   1 },
    { 2011,  12,  26,    28,  12,0,   2 },
    { 2011,  12,  31,    28,  12,0,   7 },
    { 2012,   1,   1,    28,  12,0,   8 },
    { 2012,   1,   6,    28,  12,0,  13 },
    { 2012,   1,  21,    28,  12,0,  28 },
    { 2012,   1,  22,    28,  12,0,  29 },
    { 2012,   1,  23,    29,   1,0,   1 },
    { 2012,   1,  24,    29,   1,0,   2 },
    { 2012,   1,  31,    29,   1,0,   9 },
    { 2012,   2,   1,    29,   1,0,  10 },
    { 2012,   2,   4,    29,   1,0,  13 },
    { 2012,   2,  19,    29,   1,0,  28 },
    { 2012,   2,  21,    29,   1,0,  30 },
    { 2012,   2,  22,    29,   2,0,   1 },
    { 2012,   2,  23,    29,   2,0,   2 },
    { 2012,   2,  29,    29,   2,0,   8 },
    { 2012,   3,   1,    29,   2,0,   9 },
    { 2012,   3,   5,    29,   2,0,  13 },
    { 2012,   3,  20,    29,   2,0,  28 },
    { 2012,   3,  21,    29,   2,0,  29 },
    { 2012,   3,  22,    29,   3,0,   1 },
    { 2012,   3,  23,    29,   3,0,   2 },
    { 2012,   3,  31,    29,   3,0,  10 },
    { 2012,   4,   1,    29,   3,0,  11 },
    { 2012,   4,   4,    29,   3,0,  14 },
    { 2012,   4,  20,    29,   3,0,  30 },
    { 2012,   4,  21,    29,   4,0,   1 },
    { 2012,   4,  22,    29,   4,0,   2 },
    { 2012,   4,  30,    29,   4,0,  10 },
    { 2012,   5,   1,    29,   4,0,  11 },
    { 2012,   5,   5,    29,   4,0,  15 },
    { 2012,   5,  20,    29,   4,0,  30 },
    { 2012,   5,  21,    29,   4,1,   1 },
    { 2012,   5,  22,    29,   4,1,   2 },
    { 2012,   5,  31,    29,   4,1,  11 },
    { 2012,   6,   1,    29,   4,1,  12 },
    { 2012,   6,   5,    29,   4,1,  16 },
    { 2012,   6,  18,    29,   4,1,  29 },
    { 2012,   6,  19,    29,   5,0,   1 },
    { 2012,   6,  20,    29,   5,0,   2 },
    { 2012,   6,  21,    29,   5,0,   3 },
    { 2012,   6,  30,    29,   5,0,  12 },
    { 2012,   7,   1,    29,   5,0,  13 },
    { 2012,   7,   7,    29,   5,0,  19 },
    { 2012,   7,  18,    29,   5,0,  30 },
    { 2012,   7,  19,    29,   6,0,   1 },
    { 2012,   7,  20,    29,   6,0,   2 },
    { 2012,   7,  22,    29,   6,0,   4 },
    { 2012,   7,  31,    29,   6,0,  13 },
    { 2012,   8,   1,    29,   6,0,  14 },
    { 2012,   8,   7,    29,   6,0,  20 },
    { 2012,   8,  16,    29,   6,0,  29 },
//# { 2012,   8,  17,    29,   7,0,   1 },
//# { 2012,   8,  18,    29,   7,0,   2 },
//# { 2012,   8,  23,    29,   7,0,   7 },
//# { 2012,   8,  31,    29,   7,0,  15 },
//# { 2012,   9,   1,    29,   7,0,  16 },
//# { 2012,   9,   7,    29,   7,0,  22 },
//# { 2012,   9,  15,    29,   7,0,  30 },
    { 2012,   9,  16,    29,   8,0,   1 },
    { 2012,   9,  17,    29,   8,0,   2 },
    { 2012,   9,  22,    29,   8,0,   7 },
    { 2012,   9,  30,    29,   8,0,  15 },
    { 2012,  10,   1,    29,   8,0,  16 },
    { 2012,  10,   8,    29,   8,0,  23 },
    { 2012,  10,  14,    29,   8,0,  29 },
    { 2012,  10,  15,    29,   9,0,   1 },
    { 2012,  10,  16,    29,   9,0,   2 },
    { 2012,  10,  23,    29,   9,0,   9 },
    { 2012,  10,  31,    29,   9,0,  17 },
    { 2012,  11,   1,    29,   9,0,  18 },
    { 2012,  11,   7,    29,   9,0,  24 },
    { 2012,  11,  13,    29,   9,0,  30 },
    { 2012,  11,  14,    29,  10,0,   1 },
    { 2012,  11,  15,    29,  10,0,   2 },
    { 2012,  11,  22,    29,  10,0,   9 },
    { 2012,  11,  30,    29,  10,0,  17 },
    { 2012,  12,   1,    29,  10,0,  18 },
    { 2012,  12,   7,    29,  10,0,  24 },
    { 2012,  12,  12,    29,  10,0,  29 },
    { 2012,  12,  13,    29,  11,0,   1 },
    { 2012,  12,  14,    29,  11,0,   2 },
    { 2012,  12,  21,    29,  11,0,   9 },
    { 2012,  12,  31,    29,  11,0,  19 },
    { 2013,   1,   1,    29,  11,0,  20 },
    { 2013,   1,   5,    29,  11,0,  24 },
    { 2013,   1,  11,    29,  11,0,  30 },
    { 2013,   1,  12,    29,  12,0,   1 },
    { 2013,   1,  13,    29,  12,0,   2 },
    { 2013,   1,  20,    29,  12,0,   9 },
    { 2013,   1,  31,    29,  12,0,  20 },
    { 2013,   2,   1,    29,  12,0,  21 },
    { 2013,   2,   4,    29,  12,0,  24 },
    { 2013,   2,   9,    29,  12,0,  29 },
    { 2013,   2,  10,    30,   1,0,   1 },
    { 2013,   2,  11,    30,   1,0,   2 },
    { 2013,   2,  18,    30,   1,0,   9 },
    { 2013,   2,  28,    30,   1,0,  19 },
    { 2013,   3,   1,    30,   1,0,  20 },
    { 2013,   3,   5,    30,   1,0,  24 },
    { 2013,   3,  11,    30,   1,0,  30 },
    { 2013,   3,  12,    30,   2,0,   1 },
    { 2013,   3,  13,    30,   2,0,   2 },
    { 2013,   3,  20,    30,   2,0,   9 },
    { 2013,   3,  31,    30,   2,0,  20 },
    { 2013,   4,   1,    30,   2,0,  21 },
    { 2013,   4,   4,    30,   2,0,  24 },
    { 2013,   4,   9,    30,   2,0,  29 },
    { 2013,   4,  10,    30,   3,0,   1 },
    { 2013,   4,  11,    30,   3,0,   2 },
    { 2013,   4,  20,    30,   3,0,  11 },
    { 2013,   4,  30,    30,   3,0,  21 },
    { 2013,   5,   1,    30,   3,0,  22 },
    { 2013,   5,   5,    30,   3,0,  26 },
    { 2013,   5,   9,    30,   3,0,  30 },
    { 2013,   5,  10,    30,   4,0,   1 },
    { 2013,   5,  11,    30,   4,0,   2 },
    { 2013,   5,  21,    30,   4,0,  12 },
    { 2013,   5,  31,    30,   4,0,  22 },
    { 2013,   6,   1,    30,   4,0,  23 },
    { 2013,   6,   5,    30,   4,0,  27 },
    { 2013,   6,   7,    30,   4,0,  29 },
    { 2013,   6,   8,    30,   5,0,   1 },
    { 2013,   6,   9,    30,   5,0,   2 },
    { 2013,   6,  21,    30,   5,0,  14 },
    { 2013,   6,  30,    30,   5,0,  23 },
    { 2013,   7,   1,    30,   5,0,  24 },
    { 2013,   7,   7,    30,   5,0,  30 },
    { 2013,   7,   8,    30,   6,0,   1 },
    { 2013,   7,   9,    30,   6,0,   2 },
    { 2013,   7,  22,    30,   6,0,  15 },
    { 2013,   7,  31,    30,   6,0,  24 },
    { 2013,   8,   1,    30,   6,0,  25 },
    { 2013,   8,   6,    30,   6,0,  30 },
    { 2013,   8,   7,    30,   7,0,   1 },
    { 2013,   8,   8,    30,   7,0,   2 },
    { 2013,   8,  23,    30,   7,0,  17 },
    { 2013,   8,  31,    30,   7,0,  25 },
    { 2013,   9,   1,    30,   7,0,  26 },
    { 2013,   9,   4,    30,   7,0,  29 },
    { 2013,   9,   5,    30,   8,0,   1 },
    { 2013,   9,   6,    30,   8,0,   2 },
    { 2013,   9,   7,    30,   8,0,   3 },
    { 2013,   9,  23,    30,   8,0,  19 },
    { 2013,   9,  30,    30,   8,0,  26 },
    { 2013,  10,   1,    30,   8,0,  27 },
    { 2013,  10,   4,    30,   8,0,  30 },
    { 2013,  10,   5,    30,   9,0,   1 },
    { 2013,  10,   6,    30,   9,0,   2 },
    { 2013,  10,   8,    30,   9,0,   4 },
    { 2013,  10,  23,    30,   9,0,  19 },
    { 2013,  11,   2,    30,   9,0,  29 },
    { 2013,  11,   3,    30,  10,0,   1 },
    { 2013,  11,   4,    30,  10,0,   2 },
    { 2013,  11,   7,    30,  10,0,   5 },
    { 2013,  11,  22,    30,  10,0,  20 },
    { 2013,  12,   2,    30,  10,0,  30 },
    { 2013,  12,   3,    30,  11,0,   1 },
    { 2013,  12,   4,    30,  11,0,   2 },
    { 2013,  12,   7,    30,  11,0,   5 },
    { 2013,  12,  22,    30,  11,0,  20 },
    { 2013,  12,  31,    30,  11,0,  29 },
    { 2014,   1,   1,    30,  12,0,   1 },
    { 2014,   1,   5,    30,  12,0,   5 },
    { 2014,   1,  20,    30,  12,0,  20 },
    { 2014,   1,  30,    30,  12,0,  30 },
    { 2014,   1,  31,    31,   1,0,   1 },
    { 2014,   2,   1,    31,   1,0,   2 },
    { 2014,   2,   4,    31,   1,0,   5 },
    { 2014,   2,  19,    31,   1,0,  20 },
    { 2014,   2,  28,    31,   1,0,  29 },
    { 2014,   3,   1,    31,   2,0,   1 },
    { 2014,   3,   6,    31,   2,0,   6 },
    { 2014,   3,  21,    31,   2,0,  21 },
    { 2014,   3,  30,    31,   2,0,  30 },
    { 2014,   3,  31,    31,   3,0,   1 },
    { 2014,   4,   1,    31,   3,0,   2 },
    { 2014,   4,   5,    31,   3,0,   6 },
    { 2014,   4,  20,    31,   3,0,  21 },
    { 2014,   4,  28,    31,   3,0,  29 },
    { 2014,   4,  29,    31,   4,0,   1 },
    { 2014,   4,  30,    31,   4,0,   2 },
    { 2014,   5,   1,    31,   4,0,   3 },
    { 2014,   5,   5,    31,   4,0,   7 },
    { 2014,   5,  21,    31,   4,0,  23 },
    { 2014,   5,  28,    31,   4,0,  30 },
    { 2014,   5,  29,    31,   5,0,   1 },
    { 2014,   5,  30,    31,   5,0,   2 },
    { 2014,   5,  31,    31,   5,0,   3 },
    { 2014,   6,   1,    31,   5,0,   4 },
    { 2014,   6,   6,    31,   5,0,   9 },
    { 2014,   6,  21,    31,   5,0,  24 },
    { 2014,   6,  26,    31,   5,0,  29 },
    { 2014,   6,  27,    31,   6,0,   1 },
    { 2014,   6,  28,    31,   6,0,   2 },
    { 2014,   6,  30,    31,   6,0,   4 },
    { 2014,   7,   1,    31,   6,0,   5 },
    { 2014,   7,   7,    31,   6,0,  11 },
    { 2014,   7,  23,    31,   6,0,  27 },
    { 2014,   7,  26,    31,   6,0,  30 },
    { 2014,   7,  27,    31,   7,0,   1 },
    { 2014,   7,  28,    31,   7,0,   2 },
    { 2014,   7,  31,    31,   7,0,   5 },
    { 2014,   8,   1,    31,   7,0,   6 },
    { 2014,   8,   7,    31,   7,0,  12 },
    { 2014,   8,  23,    31,   7,0,  28 },
    { 2014,   8,  24,    31,   7,0,  29 },
    { 2014,   8,  25,    31,   8,0,   1 },
    { 2014,   8,  26,    31,   8,0,   2 },
    { 2014,   8,  31,    31,   8,0,   7 },
    { 2014,   9,   1,    31,   8,0,   8 },
    { 2014,   9,   8,    31,   8,0,  15 },
    { 2014,   9,  23,    31,   8,0,  30 },
    { 2014,   9,  24,    31,   9,0,   1 },
    { 2014,   9,  25,    31,   9,0,   2 },
    { 2014,   9,  30,    31,   9,0,   7 },
    { 2014,  10,   1,    31,   9,0,   8 },
    { 2014,  10,   8,    31,   9,0,  15 },
    { 2014,  10,  23,    31,   9,0,  30 },
    { 2014,  10,  24,    31,   9,1,   1 },
    { 2014,  10,  25,    31,   9,1,   2 },
    { 2014,  10,  31,    31,   9,1,   8 },
    { 2014,  11,   1,    31,   9,1,   9 },
    { 2014,  11,   7,    31,   9,1,  15 },
    { 2014,  11,  21,    31,   9,1,  29 },
    { 2014,  11,  22,    31,  10,0,   1 },
    { 2014,  11,  23,    31,  10,0,   2 },
    { 2014,  11,  30,    31,  10,0,   9 },
    { 2014,  12,   1,    31,  10,0,  10 },
    { 2014,  12,   7,    31,  10,0,  16 },
    { 2014,  12,  21,    31,  10,0,  30 },
    { 2014,  12,  22,    31,  11,0,   1 },
    { 2014,  12,  23,    31,  11,0,   2 },
    { 2014,  12,  31,    31,  11,0,  10 },

    { 2015,   1,   1,    31,  11,0,  11 },
    { 2015,   1,   5,    31,  11,0,  15 },
    { 2015,   1,  19,    31,  11,0,  29 },
    { 2015,   1,  20,    31,  12,0,   1 },
    { 2015,   1,  21,    31,  12,0,   2 },
    { 2015,   1,  31,    31,  12,0,  12 },
    { 2015,   2,   1,    31,  12,0,  13 },
    { 2015,   2,   4,    31,  12,0,  16 },
    { 2015,   2,  18,    31,  12,0,  30 },
    { 2015,   2,  19,    32,   1,0,   1 },
    { 2015,   2,  20,    32,   1,0,   2 },
    { 2015,   2,  28,    32,   1,0,  10 },
    { 2015,   3,   1,    32,   1,0,  11 },
    { 2015,   3,   6,    32,   1,0,  16 },
    { 2015,   3,  19,    32,   1,0,  29 },
    { 2015,   3,  20,    32,   2,0,   1 },
    { 2015,   3,  21,    32,   2,0,   2 },
    { 2015,   3,  31,    32,   2,0,  12 },
    { 2015,   4,   1,    32,   2,0,  13 },
    { 2015,   4,   5,    32,   2,0,  17 },
    { 2015,   4,  18,    32,   2,0,  30 },
    { 2015,   4,  19,    32,   3,0,   1 },
    { 2015,   4,  20,    32,   3,0,   2 },
    { 2015,   4,  30,    32,   3,0,  12 },
    { 2015,   5,   1,    32,   3,0,  13 },
    { 2015,   5,   5,    32,   3,0,  17 },
    { 2015,   5,  17,    32,   3,0,  29 },
    { 2015,   5,  18,    32,   4,0,   1 },
    { 2015,   5,  19,    32,   4,0,   2 },
    { 2015,   5,  21,    32,   4,0,   4 },
    { 2015,   5,  31,    32,   4,0,  14 },
    { 2015,   6,   1,    32,   4,0,  15 },
    { 2015,   6,   6,    32,   4,0,  20 },
    { 2015,   6,  15,    32,   4,0,  29 },
    { 2015,   6,  16,    32,   5,0,   1 },
    { 2015,   6,  17,    32,   5,0,   2 },
    { 2015,   6,  21,    32,   5,0,   6 },
    { 2015,   6,  30,    32,   5,0,  15 },
    { 2015,   7,   1,    32,   5,0,  16 },
    { 2015,   7,   7,    32,   5,0,  22 },
    { 2015,   7,  15,    32,   5,0,  30 },
    { 2015,   7,  16,    32,   6,0,   1 },
    { 2015,   7,  17,    32,   6,0,   2 },
    { 2015,   7,  23,    32,   6,0,   8 },
    { 2015,   7,  31,    32,   6,0,  16 },
    { 2015,   8,   1,    32,   6,0,  17 },
    { 2015,   8,   7,    32,   6,0,  23 },
    { 2015,   8,  13,    32,   6,0,  29 },
    { 2015,   8,  14,    32,   7,0,   1 },
    { 2015,   8,  15,    32,   7,0,   2 },
    { 2015,   8,  23,    32,   7,0,  10 },
    { 2015,   8,  31,    32,   7,0,  18 },
    { 2015,   9,   1,    32,   7,0,  19 },
    { 2015,   9,   8,    32,   7,0,  26 },
    { 2015,   9,  12,    32,   7,0,  30 },
    { 2015,   9,  13,    32,   8,0,   1 },
    { 2015,   9,  14,    32,   8,0,   2 },
    { 2015,   9,  23,    32,   8,0,  11 },
    { 2015,   9,  30,    32,   8,0,  18 },
    { 2015,  10,   1,    32,   8,0,  19 },
    { 2015,  10,   8,    32,   8,0,  26 },
    { 2015,  10,  12,    32,   8,0,  30 },
    { 2015,  10,  13,    32,   9,0,   1 },
    { 2015,  10,  14,    32,   9,0,   2 },
    { 2015,  10,  23,    32,   9,0,  11 },
    { 2015,  10,  31,    32,   9,0,  19 },
    { 2015,  11,   1,    32,   9,0,  20 },
    { 2015,  11,   7,    32,   9,0,  26 },
    { 2015,  11,  11,    32,   9,0,  30 },
    { 2015,  11,  12,    32,  10,0,   1 },
    { 2015,  11,  13,    32,  10,0,   2 },
    { 2015,  11,  22,    32,  10,0,  11 },
    { 2015,  11,  30,    32,  10,0,  19 },
    { 2015,  12,   1,    32,  10,0,  20 },
    { 2015,  12,   7,    32,  10,0,  26 },
    { 2015,  12,  10,    32,  10,0,  29 },
    { 2015,  12,  11,    32,  11,0,   1 },
    { 2015,  12,  12,    32,  11,0,   2 },
    { 2015,  12,  22,    32,  11,0,  12 },
    { 2015,  12,  31,    32,  11,0,  21 },

    { 2016,   1,   1,    32,  11,0,  22 },
    { 2016,   1,   5,    32,  11,0,  26 },
    { 2016,   1,   6,    32,  11,0,  27 },  // 23 "minor cold"
    { 2016,   1,   9,    32,  11,0,  30 },
    { 2016,   1,  10,    32,  12,0,   1 },
    { 2016,   1,  11,    32,  12,0,   2 },
    { 2016,   1,  20,    32,  12,0,  11 },  // 24 "major cold"
    { 2016,   1,  31,    32,  12,0,  22 },
    { 2016,   2,   1,    32,  12,0,  23 },
    { 2016,   2,   4,    32,  12,0,  26 },  //  1 "spring begins"
    { 2016,   2,   7,    32,  12,0,  29 },
    { 2016,   2,   8,    33,   1,0,   1 },
    { 2016,   2,   9,    33,   1,0,   2 },
    { 2016,   2,  19,    33,   1,0,  12 },  //  2 "rain water"
    { 2016,   2,  29,    33,   1,0,  22 },
    { 2016,   3,   1,    33,   1,0,  23 },
    { 2016,   3,   5,    33,   1,0,  27 },  //  3 "insects awaken"
    { 2016,   3,   8,    33,   1,0,  30 },
    { 2016,   3,   9,    33,   2,0,   1 },
    { 2016,   3,  10,    33,   2,0,   2 },
    { 2016,   3,  20,    33,   2,0,  12 },  //  4 "spring equinox"
    { 2016,   3,  31,    33,   2,0,  23 },
    { 2016,   4,   1,    33,   2,0,  24 },
    { 2016,   4,   4,    33,   2,0,  27 },  //  5 "bright and clear"
    { 2016,   4,   6,    33,   2,0,  29 },
    { 2016,   4,   7,    33,   3,0,   1 },
    { 2016,   4,   8,    33,   3,0,   2 },
    { 2016,   4,  19,    33,   3,0,  13 },  //  6 "grain rain"
    { 2016,   4,  30,    33,   3,0,  24 },
    { 2016,   5,   1,    33,   3,0,  25 },
    { 2016,   5,   4,    33,   3,0,  28 },
    { 2016,   5,   5,    33,   3,0,  29 },  //  7 "summer begins"
    { 2016,   5,   6,    33,   3,0,  30 },
    { 2016,   5,   7,    33,   4,0,   1 },
    { 2016,   5,   8,    33,   4,0,   2 },
    { 2016,   5,  20,    33,   4,0,  14 },  //  8 "grain full"
    { 2016,   5,  31,    33,   4,0,  25 },
    { 2016,   6,   1,    33,   4,0,  26 },
    { 2016,   6,   4,    33,   4,0,  29 },
    { 2016,   6,   5,    33,   5,0,   1 },  //  9 "grain in ear"
    { 2016,   6,   6,    33,   5,0,   2 },
    { 2016,   6,  20,    33,   5,0,  16 },
    { 2016,   6,  21,    33,   5,0,  17 },  // 10 "summer solstice"
    { 2016,   6,  30,    33,   5,0,  26 },
    { 2016,   7,   1,    33,   5,0,  27 },
    { 2016,   7,   3,    33,   5,0,  29 },
    { 2016,   7,   4,    33,   6,0,   1 },
    { 2016,   7,   5,    33,   6,0,   2 },
    { 2016,   7,   6,    33,   6,0,   3 },
    { 2016,   7,   7,    33,   6,0,   4 },  // 11 "minor heat"
    { 2016,   7,  22,    33,   6,0,  19 },  // 12 "major heat"
    { 2016,   8,   2,    33,   6,0,  30 },
    { 2016,   8,   3,    33,   7,0,   1 },
    { 2016,   8,   4,    33,   7,0,   2 },
    { 2016,   8,   6,    33,   7,0,   4 },
    { 2016,   8,   7,    33,   7,0,   5 },  // 13 "autumn begins"
    { 2016,   8,  22,    33,   7,0,  20 },
    { 2016,   8,  23,    33,   7,0,  21 },  // 14 "end of heat"
    { 2016,   8,  31,    33,   7,0,  29 },
    { 2016,   9,   1,    33,   8,0,   1 },
    { 2016,   9,   7,    33,   8,0,   7 },  // 15 "white dew"
    { 2016,   9,  22,    33,   8,0,  22 },  // 16 "autumn equinox"
    { 2016,   9,  30,    33,   8,0,  30 },
    { 2016,  10,   1,    33,   9,0,   1 },
    { 2016,  10,   7,    33,   9,0,   7 },
    { 2016,  10,   8,    33,   9,0,   8 },  // 17 "cold dew"
    { 2016,  10,  22,    33,   9,0,  22 },
    { 2016,  10,  23,    33,   9,0,  23 },  // 18 "frost descends"
    { 2016,  10,  30,    33,   9,0,  30 },
    { 2016,  10,  31,    33,  10,0,   1 },
    { 2016,  11,   1,    33,  10,0,   2 },
    { 2016,  11,   6,    33,  10,0,   7 },
    { 2016,  11,   7,    33,  10,0,   8 },  // 19 "winter begins"
    { 2016,  11,  21,    33,  10,0,  22 },
    { 2016,  11,  22,    33,  10,0,  23 },  // 20 "minor snow"
    { 2016,  11,  28,    33,  10,0,  29 },
    { 2016,  11,  29,    33,  11,0,   1 },
    { 2016,  11,  30,    33,  11,0,   2 },
    { 2016,  12,   1,    33,  11,0,   3 },
    { 2016,  12,   6,    33,  11,0,   8 },
    { 2016,  12,   7,    33,  11,0,   9 },  // 21 "major snow"
    { 2016,  12,  21,    33,  11,0,  23 },  // 22 "winter solstice"
    { 2016,  12,  28,    33,  11,0,  30 },
    { 2016,  12,  29,    33,  12,0,   1 },
    { 2016,  12,  30,    33,  12,0,   2 },
    { 2016,  12,  31,    33,  12,0,   3 },

    { 2017,   1,   1,    33,  12,0,   4 },
    { 2017,   1,   5,    33,  12,0,   8 },
    { 2017,   1,  20,    33,  12,0,  23 },
    { 2017,   1,  27,    33,  12,0,  30 },
    { 2017,   1,  28,    34,   1,0,   1 },
    { 2017,   1,  29,    34,   1,0,   2 },
    { 2017,   1,  31,    34,   1,0,   4 },
    { 2017,   2,   1,    34,   1,0,   5 },
    { 2017,   2,   3,    34,   1,0,   7 },
    { 2017,   2,  18,    34,   1,0,  22 },
    { 2017,   2,  25,    34,   1,0,  29 },
    { 2017,   2,  26,    34,   2,0,   1 },
    { 2017,   2,  27,    34,   2,0,   2 },
    { 2017,   2,  28,    34,   2,0,   3 },
    { 2017,   3,   1,    34,   2,0,   4 },
    { 2017,   3,   5,    34,   2,0,   8 },
    { 2017,   3,  20,    34,   2,0,  23 },
    { 2017,   3,  27,    34,   2,0,  30 },
    { 2017,   3,  28,    34,   3,0,   1 },
    { 2017,   3,  29,    34,   3,0,   2 },
    { 2017,   3,  31,    34,   3,0,   4 },
    { 2017,   4,   1,    34,   3,0,   5 },
    { 2017,   4,   4,    34,   3,0,   8 },
    { 2017,   4,  20,    34,   3,0,  24 },
    { 2017,   4,  25,    34,   3,0,  29 },
    { 2017,   4,  26,    34,   4,0,   1 },
    { 2017,   4,  27,    34,   4,0,   2 },
    { 2017,   4,  30,    34,   4,0,   5 },
    { 2017,   5,   1,    34,   4,0,   6 },
    { 2017,   5,   5,    34,   4,0,  10 },
    { 2017,   5,  21,    34,   4,0,  26 },
    { 2017,   5,  25,    34,   4,0,  30 },
    { 2017,   5,  26,    34,   5,0,   1 },
    { 2017,   5,  27,    34,   5,0,   2 },
    { 2017,   5,  31,    34,   5,0,   6 },
    { 2017,   6,   1,    34,   5,0,   7 },
    { 2017,   6,   5,    34,   5,0,  11 },
    { 2017,   6,  21,    34,   5,0,  27 },
    { 2017,   6,  23,    34,   5,0,  29 },
    { 2017,   6,  24,    34,   6,0,   1 },
    { 2017,   6,  25,    34,   6,0,   2 },
    { 2017,   6,  30,    34,   6,0,   7 },
    { 2017,   7,   1,    34,   6,0,   8 },
    { 2017,   7,   7,    34,   6,0,  14 },
    { 2017,   7,  22,    34,   6,0,  29 },
    { 2017,   7,  23,    34,   6,1,   1 },
    { 2017,   7,  24,    34,   6,1,   2 },
    { 2017,   7,  31,    34,   6,1,   9 },
    { 2017,   8,   1,    34,   6,1,  10 },
    { 2017,   8,   7,    34,   6,1,  16 },
    { 2017,   8,  21,    34,   6,1,  30 },
    { 2017,   8,  22,    34,   7,0,   1 },
    { 2017,   8,  23,    34,   7,0,   2 },
    { 2017,   8,  31,    34,   7,0,  10 },
    { 2017,   9,   1,    34,   7,0,  11 },
    { 2017,   9,   7,    34,   7,0,  17 },
    { 2017,   9,  19,    34,   7,0,  29 },
    { 2017,   9,  20,    34,   8,0,   1 },
    { 2017,   9,  21,    34,   8,0,   2 },
    { 2017,   9,  23,    34,   8,0,   4 },
    { 2017,   9,  30,    34,   8,0,  11 },
    { 2017,  10,   1,    34,   8,0,  12 },
    { 2017,  10,   8,    34,   8,0,  19 },
    { 2017,  10,  19,    34,   8,0,  30 },
    { 2017,  10,  20,    34,   9,0,   1 },
    { 2017,  10,  21,    34,   9,0,   2 },
    { 2017,  10,  23,    34,   9,0,   4 },
    { 2017,  10,  31,    34,   9,0,  12 },
    { 2017,  11,   1,    34,   9,0,  13 },
    { 2017,  11,   7,    34,   9,0,  19 },
    { 2017,  11,  17,    34,   9,0,  29 },
    { 2017,  11,  18,    34,  10,0,   1 },
    { 2017,  11,  19,    34,  10,0,   2 },
    { 2017,  11,  22,    34,  10,0,   5 },
    { 2017,  11,  30,    34,  10,0,  13 },
    { 2017,  12,   1,    34,  10,0,  14 },
    { 2017,  12,   7,    34,  10,0,  20 },
    { 2017,  12,  17,    34,  10,0,  30 },
    { 2017,  12,  18,    34,  11,0,   1 },
    { 2017,  12,  19,    34,  11,0,   2 },
    { 2017,  12,  22,    34,  11,0,   5 },
    { 2017,  12,  31,    34,  11,0,  14 },
    { 2018,   1,   1,    34,  11,0,  15 },
    { 2018,   1,   5,    34,  11,0,  19 },
    { 2018,   1,  16,    34,  11,0,  30 },
    { 2018,   1,  17,    34,  12,0,   1 },
    { 2018,   1,  18,    34,  12,0,   2 },
    { 2018,   1,  20,    34,  12,0,   4 },
    { 2018,   1,  31,    34,  12,0,  15 },
    { 2018,   2,   1,    34,  12,0,  16 },
    { 2018,   2,   4,    34,  12,0,  19 },
    { 2018,   2,  15,    34,  12,0,  30 },
    { 2018,   2,  16,    35,   1,0,   1 },
    { 2018,   2,  17,    35,   1,0,   2 },
    { 2018,   2,  19,    35,   1,0,   4 },
    { 2018,   2,  28,    35,   1,0,  13 },
    { 2018,   3,   1,    35,   1,0,  14 },
    { 2018,   3,   5,    35,   1,0,  18 },
    { 2018,   3,  16,    35,   1,0,  29 },
    { 2018,   3,  17,    35,   2,0,   1 },
    { 2018,   3,  18,    35,   2,0,   2 },
    { 2018,   3,  21,    35,   2,0,   5 },
    { 2018,   3,  31,    35,   2,0,  15 },
    { 2018,   4,   1,    35,   2,0,  16 },
    { 2018,   4,   5,    35,   2,0,  20 },
    { 2018,   4,  15,    35,   2,0,  30 },
    { 2018,   4,  16,    35,   3,0,   1 },
    { 2018,   4,  17,    35,   3,0,   2 },
    { 2018,   4,  20,    35,   3,0,   5 },
    { 2018,   4,  30,    35,   3,0,  15 },
    { 2018,   5,   1,    35,   3,0,  16 },
    { 2018,   5,   5,    35,   3,0,  20 },
    { 2018,   5,  14,    35,   3,0,  29 },
    { 2018,   5,  15,    35,   4,0,   1 },
    { 2018,   5,  16,    35,   4,0,   2 },
    { 2018,   5,  21,    35,   4,0,   7 },
    { 2018,   5,  31,    35,   4,0,  17 },
    { 2018,   6,   1,    35,   4,0,  18 },
    { 2018,   6,   6,    35,   4,0,  23 },
    { 2018,   6,  13,    35,   4,0,  30 },
    { 2018,   6,  14,    35,   5,0,   1 },
    { 2018,   6,  15,    35,   5,0,   2 },
    { 2018,   6,  21,    35,   5,0,   8 },
    { 2018,   6,  30,    35,   5,0,  17 },
    { 2018,   7,   1,    35,   5,0,  18 },
    { 2018,   7,   7,    35,   5,0,  24 },
    { 2018,   7,  12,    35,   5,0,  29 },
    { 2018,   7,  13,    35,   6,0,   1 },
    { 2018,   7,  14,    35,   6,0,   2 },
    { 2018,   7,  23,    35,   6,0,  11 },
    { 2018,   7,  31,    35,   6,0,  19 },
    { 2018,   8,   1,    35,   6,0,  20 },
    { 2018,   8,   7,    35,   6,0,  26 },
    { 2018,   8,  10,    35,   6,0,  29 },
    { 2018,   8,  11,    35,   7,0,   1 },
    { 2018,   8,  12,    35,   7,0,   2 },
    { 2018,   8,  23,    35,   7,0,  13 },
    { 2018,   8,  31,    35,   7,0,  21 },
    { 2018,   9,   1,    35,   7,0,  22 },
    { 2018,   9,   8,    35,   7,0,  29 },
    { 2018,   9,   9,    35,   7,0,  30 },
    { 2018,   9,  10,    35,   8,0,   1 },
    { 2018,   9,  11,    35,   8,0,   2 },
    { 2018,   9,  23,    35,   8,0,  14 },
    { 2018,   9,  30,    35,   8,0,  21 },
    { 2018,  10,   1,    35,   8,0,  22 },
    { 2018,  10,   8,    35,   8,0,  29 },
    { 2018,  10,   9,    35,   9,0,   1 },
    { 2018,  10,  10,    35,   9,0,   2 },
    { 2018,  10,  23,    35,   9,0,  15 },
    { 2018,  10,  31,    35,   9,0,  23 },
    { 2018,  11,   1,    35,   9,0,  24 },
//# { 2018,  11,   7,    35,   9,0,  30 },
//# { 2018,  11,   8,    35,  10,0,   1 },
//# { 2018,  11,   9,    35,  10,0,   2 },
//# { 2018,  11,  22,    35,  10,0,  15 },
//# { 2018,  11,  30,    35,  10,0,  23 },
//# { 2018,  12,   1,    35,  10,0,  24 },
//# { 2018,  12,   6,    35,  10,0,  29 },
    { 2018,  12,   7,    35,  11,0,   1 },
    { 2018,  12,   8,    35,  11,0,   2 },
    { 2018,  12,  22,    35,  11,0,  16 },
    { 2018,  12,  31,    35,  11,0,  25 },
    { 2019,   1,   1,    35,  11,0,  26 },
    { 2019,   1,   5,    35,  11,0,  30 },
    { 2019,   1,   6,    35,  12,0,   1 },
    { 2019,   1,   7,    35,  12,0,   2 },
    { 2019,   1,  20,    35,  12,0,  15 },
    { 2019,   1,  31,    35,  12,0,  26 },
    { 2019,   2,   1,    35,  12,0,  27 },
    { 2019,   2,   4,    35,  12,0,  30 },
    { 2019,   2,   5,    36,   1,0,   1 },
    { 2019,   2,   6,    36,   1,0,   2 },
    { 2019,   2,  19,    36,   1,0,  15 },
    { 2019,   2,  28,    36,   1,0,  24 },
    { 2019,   3,   1,    36,   1,0,  25 },
    { 2019,   3,   6,    36,   1,0,  30 },
    { 2019,   3,   7,    36,   2,0,   1 },
    { 2019,   3,   8,    36,   2,0,   2 },
    { 2019,   3,  21,    36,   2,0,  15 },
    { 2019,   3,  31,    36,   2,0,  25 },
    { 2019,   4,   1,    36,   2,0,  26 },
    { 2019,   4,   4,    36,   2,0,  29 },
    { 2019,   4,   5,    36,   3,0,   1 },
    { 2019,   4,   6,    36,   3,0,   2 },
    { 2019,   4,  20,    36,   3,0,  16 },
    { 2019,   4,  30,    36,   3,0,  26 },
    { 2019,   5,   1,    36,   3,0,  27 },
    { 2019,   5,   4,    36,   3,0,  30 },
    { 2019,   5,   5,    36,   4,0,   1 },
    { 2019,   5,   6,    36,   4,0,   2 },
    { 2019,   5,  21,    36,   4,0,  17 },
    { 2019,   6,   2,    36,   4,0,  29 },
    { 2019,   6,   3,    36,   5,0,   1 },
    { 2019,   6,   4,    36,   5,0,   2 },
    { 2019,   6,   6,    36,   5,0,   4 },
    { 2019,   6,  21,    36,   5,0,  19 },
    { 2019,   7,   2,    36,   5,0,  30 },
    { 2019,   7,   3,    36,   6,0,   1 },
    { 2019,   7,   4,    36,   6,0,   2 },
    { 2019,   7,   7,    36,   6,0,   5 },
    { 2019,   7,  23,    36,   6,0,  21 },
    { 2019,   7,  31,    36,   6,0,  29 },
    { 2019,   8,   1,    36,   7,0,   1 },
    { 2019,   8,   8,    36,   7,0,   8 },
    { 2019,   8,  23,    36,   7,0,  23 },
    { 2019,   8,  29,    36,   7,0,  29 },
    { 2019,   8,  30,    36,   8,0,   1 },
    { 2019,   8,  31,    36,   8,0,   2 },
    { 2019,   9,   1,    36,   8,0,   3 },
    { 2019,   9,   8,    36,   8,0,  10 },
    { 2019,   9,  23,    36,   8,0,  25 },
    { 2019,   9,  28,    36,   8,0,  30 },
    { 2019,   9,  29,    36,   9,0,   1 },
    { 2019,   9,  30,    36,   9,0,   2 },
    { 2019,  10,   1,    36,   9,0,   3 },
    { 2019,  10,   8,    36,   9,0,  10 },
    { 2019,  10,  24,    36,   9,0,  26 },
    { 2019,  10,  27,    36,   9,0,  29 },
    { 2019,  10,  28,    36,  10,0,   1 },
    { 2019,  10,  29,    36,  10,0,   2 },
    { 2019,  10,  31,    36,  10,0,   4 },
    { 2019,  11,   1,    36,  10,0,   5 },
    { 2019,  11,   8,    36,  10,0,  12 },
    { 2019,  11,  22,    36,  10,0,  26 },
    { 2019,  11,  25,    36,  10,0,  29 },
    { 2019,  11,  26,    36,  11,0,   1 },
    { 2019,  11,  27,    36,  11,0,   2 },
    { 2019,  11,  30,    36,  11,0,   5 },
    { 2019,  12,   1,    36,  11,0,   6 },
    { 2019,  12,   7,    36,  11,0,  12 },
    { 2019,  12,  22,    36,  11,0,  27 },
    { 2019,  12,  25,    36,  11,0,  30 },
    { 2019,  12,  26,    36,  12,0,   1 },
    { 2019,  12,  27,    36,  12,0,   2 },
    { 2019,  12,  31,    36,  12,0,   6 },
    { 2020,   1,   1,    36,  12,0,   7 },
    { 2020,   1,   6,    36,  12,0,  12 },
    { 2020,   1,  20,    36,  12,0,  26 },
    { 2020,   1,  24,    36,  12,0,  30 },
    { 2020,   1,  25,    37,   1,0,   1 },
    { 2020,   1,  26,    37,   1,0,   2 },
    { 2020,   1,  31,    37,   1,0,   7 },
    { 2020,   2,   1,    37,   1,0,   8 },
    { 2020,   2,   4,    37,   1,0,  11 },
    { 2020,   2,  19,    37,   1,0,  26 },
    { 2020,   2,  22,    37,   1,0,  29 },
    { 2020,   2,  23,    37,   2,0,   1 },
    { 2020,   2,  24,    37,   2,0,   2 },
    { 2020,   2,  29,    37,   2,0,   7 },
    { 2020,   3,   1,    37,   2,0,   8 },
    { 2020,   3,   5,    37,   2,0,  12 },
    { 2020,   3,  20,    37,   2,0,  27 },
    { 2020,   3,  23,    37,   2,0,  30 },
    { 2020,   3,  24,    37,   3,0,   1 },
    { 2020,   3,  25,    37,   3,0,   2 },
    { 2020,   3,  31,    37,   3,0,   8 },
    { 2020,   4,   1,    37,   3,0,   9 },
    { 2020,   4,   4,    37,   3,0,  12 },
    { 2020,   4,  19,    37,   3,0,  27 },
    { 2020,   4,  22,    37,   3,0,  30 },
    { 2020,   4,  23,    37,   4,0,   1 },
    { 2020,   4,  24,    37,   4,0,   2 },
    { 2020,   4,  30,    37,   4,0,   8 },
    { 2020,   5,   1,    37,   4,0,   9 },
    { 2020,   5,   5,    37,   4,0,  13 },
    { 2020,   5,  20,    37,   4,0,  28 },
    { 2020,   5,  22,    37,   4,0,  30 },
    { 2020,   5,  23,    37,   4,1,   1 },
    { 2020,   5,  24,    37,   4,1,   2 },
    { 2020,   5,  31,    37,   4,1,   9 },
    { 2020,   6,   1,    37,   4,1,  10 },
    { 2020,   6,   5,    37,   4,1,  14 },
    { 2020,   6,  20,    37,   4,1,  29 },
    { 2020,   6,  21,    37,   5,0,   1 },
    { 2020,   6,  22,    37,   5,0,   2 },
    { 2020,   6,  30,    37,   5,0,  10 },
    { 2020,   7,   1,    37,   5,0,  11 },
    { 2020,   7,   6,    37,   5,0,  16 },
    { 2020,   7,  20,    37,   5,0,  30 },
    { 2020,   7,  21,    37,   6,0,   1 },
    { 2020,   7,  22,    37,   6,0,   2 },
    { 2020,   7,  31,    37,   6,0,  11 },
    { 2020,   8,   1,    37,   6,0,  12 },
    { 2020,   8,   7,    37,   6,0,  18 },
    { 2020,   8,  18,    37,   6,0,  29 },
    { 2020,   8,  19,    37,   7,0,   1 },
    { 2020,   8,  20,    37,   7,0,   2 },
    { 2020,   8,  22,    37,   7,0,   4 },
    { 2020,   8,  31,    37,   7,0,  13 },
    { 2020,   9,   1,    37,   7,0,  14 },
    { 2020,   9,   7,    37,   7,0,  20 },
    { 2020,   9,  16,    37,   7,0,  29 },
    { 2020,   9,  17,    37,   8,0,   1 },
    { 2020,   9,  18,    37,   8,0,   2 },
    { 2020,   9,  22,    37,   8,0,   6 },
    { 2020,   9,  30,    37,   8,0,  14 },
    { 2020,  10,   1,    37,   8,0,  15 },
    { 2020,  10,   8,    37,   8,0,  22 },
    { 2020,  10,  16,    37,   8,0,  30 },
    { 2020,  10,  17,    37,   9,0,   1 },
    { 2020,  10,  18,    37,   9,0,   2 },
    { 2020,  10,  23,    37,   9,0,   7 },
    { 2020,  10,  31,    37,   9,0,  15 },
    { 2020,  11,   1,    37,   9,0,  16 },
    { 2020,  11,   7,    37,   9,0,  22 },
    { 2020,  11,  14,    37,   9,0,  29 },
    { 2020,  11,  15,    37,  10,0,   1 },
    { 2020,  11,  16,    37,  10,0,   2 },
    { 2020,  11,  22,    37,  10,0,   8 },
    { 2020,  11,  30,    37,  10,0,  16 },
    { 2020,  12,   1,    37,  10,0,  17 },
    { 2020,  12,   7,    37,  10,0,  23 },
    { 2020,  12,  14,    37,  10,0,  30 },
    { 2020,  12,  15,    37,  11,0,   1 },
    { 2020,  12,  16,    37,  11,0,   2 },
    { 2020,  12,  21,    37,  11,0,   7 },
    { 2020,  12,  31,    37,  11,0,  17 },
    { 2021,   1,   1,    37,  11,0,  18 },
    { 2021,   1,   5,    37,  11,0,  22 },
    { 2021,   1,  12,    37,  11,0,  29 },
    { 2021,   1,  13,    37,  12,0,   1 },
    { 2021,   1,  14,    37,  12,0,   2 },
    { 2021,   1,  20,    37,  12,0,   8 },
    { 2021,   1,  31,    37,  12,0,  19 },
    { 2021,   2,   1,    37,  12,0,  20 },
    { 2021,   2,   3,    37,  12,0,  22 },
    { 2021,   2,  11,    37,  12,0,  30 },
    { 2021,   2,  12,    38,   1,0,   1 },
    { 2021,   2,  13,    38,   1,0,   2 },
    { 2021,   2,  18,    38,   1,0,   7 },
    { 2021,   2,  28,    38,   1,0,  17 },
    { 2021,   3,   1,    38,   1,0,  18 },
    { 2021,   3,   5,    38,   1,0,  22 },
    { 2021,   3,  12,    38,   1,0,  29 },
    { 2021,   3,  13,    38,   2,0,   1 },
    { 2021,   3,  14,    38,   2,0,   2 },
    { 2021,   3,  20,    38,   2,0,   8 },
    { 2021,   3,  31,    38,   2,0,  19 },
    { 2021,   4,   1,    38,   2,0,  20 },
    { 2021,   4,   4,    38,   2,0,  23 },
    { 2021,   4,  11,    38,   2,0,  30 },
    { 2021,   4,  12,    38,   3,0,   1 },
    { 2021,   4,  13,    38,   3,0,   2 },
    { 2021,   4,  20,    38,   3,0,   9 },
    { 2021,   4,  30,    38,   3,0,  19 },
    { 2021,   5,   1,    38,   3,0,  20 },
    { 2021,   5,   5,    38,   3,0,  24 },
    { 2021,   5,  11,    38,   3,0,  30 },
    { 2021,   5,  12,    38,   4,0,   1 },
    { 2021,   5,  13,    38,   4,0,   2 },
    { 2021,   5,  21,    38,   4,0,  10 },
    { 2021,   5,  31,    38,   4,0,  20 },
    { 2021,   6,   1,    38,   4,0,  21 },
    { 2021,   6,   5,    38,   4,0,  25 },
    { 2021,   6,   9,    38,   4,0,  29 },
    { 2021,   6,  10,    38,   5,0,   1 },
    { 2021,   6,  11,    38,   5,0,   2 },
    { 2021,   6,  21,    38,   5,0,  12 },
    { 2021,   6,  30,    38,   5,0,  21 },
    { 2021,   7,   1,    38,   5,0,  22 },
    { 2021,   7,   7,    38,   5,0,  28 },
    { 2021,   7,   9,    38,   5,0,  30 },
    { 2021,   7,  10,    38,   6,0,   1 },
    { 2021,   7,  11,    38,   6,0,   2 },
    { 2021,   7,  22,    38,   6,0,  13 },
    { 2021,   7,  31,    38,   6,0,  22 },
    { 2021,   8,   1,    38,   6,0,  23 },
    { 2021,   8,   7,    38,   6,0,  29 },
    { 2021,   8,   8,    38,   7,0,   1 },
    { 2021,   8,   9,    38,   7,0,   2 },
    { 2021,   8,  23,    38,   7,0,  16 },
    { 2021,   8,  31,    38,   7,0,  24 },
    { 2021,   9,   1,    38,   7,0,  25 },
    { 2021,   9,   6,    38,   7,0,  30 },
    { 2021,   9,   7,    38,   8,0,   1 },
    { 2021,   9,   8,    38,   8,0,   2 },
    { 2021,   9,  23,    38,   8,0,  17 },
    { 2021,   9,  30,    38,   8,0,  24 },
    { 2021,  10,   1,    38,   8,0,  25 },
    { 2021,  10,   5,    38,   8,0,  29 },
    { 2021,  10,   6,    38,   9,0,   1 },
    { 2021,  10,   7,    38,   9,0,   2 },
    { 2021,  10,   8,    38,   9,0,   3 },
    { 2021,  10,  23,    38,   9,0,  18 },
    { 2021,  10,  31,    38,   9,0,  26 },
    { 2021,  11,   1,    38,   9,0,  27 },
    { 2021,  11,   4,    38,   9,0,  30 },
    { 2021,  11,   5,    38,  10,0,   1 },
    { 2021,  11,   6,    38,  10,0,   2 },
    { 2021,  11,   7,    38,  10,0,   3 },
    { 2021,  11,  22,    38,  10,0,  18 },
    { 2021,  11,  30,    38,  10,0,  26 },
    { 2021,  12,   1,    38,  10,0,  27 },
    { 2021,  12,   3,    38,  10,0,  29 },
    { 2021,  12,   4,    38,  11,0,   1 },
    { 2021,  12,   5,    38,  11,0,   2 },
    { 2021,  12,   7,    38,  11,0,   4 },
    { 2021,  12,  21,    38,  11,0,  18 },
    { 2022,   1,   2,    38,  11,0,  30 },
    { 2022,   1,   3,    38,  12,0,   1 },
    { 2022,   1,   4,    38,  12,0,   2 },
    { 2022,   1,   5,    38,  12,0,   3 },
    { 2022,   1,  20,    38,  12,0,  18 },
    { 2022,   1,  31,    38,  12,0,  29 },
    { 2022,   2,   1,    39,   1,0,   1 },
    { 2022,   2,   4,    39,   1,0,   4 },
    { 2022,   2,  19,    39,   1,0,  19 },
    { 2022,   3,   2,    39,   1,0,  30 },
    { 2022,   3,   3,    39,   2,0,   1 },
    { 2022,   3,   4,    39,   2,0,   2 },
    { 2022,   3,   5,    39,   2,0,   3 },
    { 2022,   3,  20,    39,   2,0,  18 },
    { 2022,   3,  31,    39,   2,0,  29 },
    { 2022,   4,   1,    39,   3,0,   1 },
    { 2022,   4,   5,    39,   3,0,   5 },
    { 2022,   4,  20,    39,   3,0,  20 },
    { 2022,   4,  30,    39,   3,0,  30 },
    { 2022,   5,   1,    39,   4,0,   1 },
    { 2022,   5,   5,    39,   4,0,   5 },
    { 2022,   5,  21,    39,   4,0,  21 },
    { 2022,   5,  29,    39,   4,0,  29 },
    { 2022,   5,  30,    39,   5,0,   1 },
    { 2022,   5,  31,    39,   5,0,   2 },
    { 2022,   6,   1,    39,   5,0,   3 },
    { 2022,   6,   6,    39,   5,0,   8 },
    { 2022,   6,  21,    39,   5,0,  23 },
    { 2022,   6,  28,    39,   5,0,  30 },
    { 2022,   6,  29,    39,   6,0,   1 },
    { 2022,   6,  30,    39,   6,0,   2 },
    { 2022,   7,   1,    39,   6,0,   3 },
    { 2022,   7,   7,    39,   6,0,   9 },
    { 2022,   7,  23,    39,   6,0,  25 },
    { 2022,   7,  28,    39,   6,0,  30 },
    { 2022,   7,  29,    39,   7,0,   1 },
    { 2022,   7,  30,    39,   7,0,   2 },
    { 2022,   7,  31,    39,   7,0,   3 },
    { 2022,   8,   1,    39,   7,0,   4 },
    { 2022,   8,   7,    39,   7,0,  10 },
    { 2022,   8,  23,    39,   7,0,  26 },
    { 2022,   8,  26,    39,   7,0,  29 },
    { 2022,   8,  27,    39,   8,0,   1 },
    { 2022,   8,  28,    39,   8,0,   2 },
    { 2022,   8,  31,    39,   8,0,   5 },
    { 2022,   9,   1,    39,   8,0,   6 },
    { 2022,   9,   7,    39,   8,0,  12 },
    { 2022,   9,  23,    39,   8,0,  28 },
    { 2022,   9,  25,    39,   8,0,  30 },
    { 2022,   9,  26,    39,   9,0,   1 },
    { 2022,   9,  27,    39,   9,0,   2 },
    { 2022,   9,  30,    39,   9,0,   5 },
    { 2022,  10,   1,    39,   9,0,   6 },
    { 2022,  10,   8,    39,   9,0,  13 },
    { 2022,  10,  23,    39,   9,0,  28 },
    { 2022,  10,  24,    39,   9,0,  29 },
    { 2022,  10,  25,    39,  10,0,   1 },
    { 2022,  10,  26,    39,  10,0,   2 },
    { 2022,  10,  31,    39,  10,0,   7 },
    { 2022,  11,   1,    39,  10,0,   8 },
    { 2022,  11,   7,    39,  10,0,  14 },
    { 2022,  11,  22,    39,  10,0,  29 },
    { 2022,  11,  23,    39,  10,0,  30 },
    { 2022,  11,  24,    39,  11,0,   1 },
    { 2022,  11,  25,    39,  11,0,   2 },
    { 2022,  11,  30,    39,  11,0,   7 },
    { 2022,  12,   1,    39,  11,0,   8 },
    { 2022,  12,   7,    39,  11,0,  14 },
    { 2022,  12,  22,    39,  11,0,  29 },
    { 2022,  12,  23,    39,  12,0,   1 },
    { 2022,  12,  24,    39,  12,0,   2 },
    { 2022,  12,  31,    39,  12,0,   9 },
    { 2023,   1,   1,    39,  12,0,  10 },
    { 2023,   1,   5,    39,  12,0,  14 },
    { 2023,   1,  20,    39,  12,0,  29 },
    { 2023,   1,  21,    39,  12,0,  30 },
    { 2023,   1,  22,    40,   1,0,   1 },
    { 2023,   1,  23,    40,   1,0,   2 },
    { 2023,   1,  31,    40,   1,0,  10 },
    { 2023,   2,   1,    40,   1,0,  11 },
    { 2023,   2,   4,    40,   1,0,  14 },
    { 2023,   2,  19,    40,   1,0,  29 },
    { 2023,   2,  20,    40,   2,0,   1 },
    { 2023,   2,  21,    40,   2,0,   2 },
    { 2023,   2,  28,    40,   2,0,   9 },
    { 2023,   3,   1,    40,   2,0,  10 },
    { 2023,   3,   6,    40,   2,0,  15 },
    { 2023,   3,  21,    40,   2,0,  30 },
    { 2023,   3,  22,    40,   2,1,   1 },
    { 2023,   3,  23,    40,   2,1,   2 },
    { 2023,   3,  31,    40,   2,1,  10 },
    { 2023,   4,   1,    40,   2,1,  11 },
    { 2023,   4,   5,    40,   2,1,  15 },
    { 2023,   4,  19,    40,   2,1,  29 },
    { 2023,   4,  20,    40,   3,0,   1 },
    { 2023,   4,  21,    40,   3,0,   2 },
    { 2023,   4,  30,    40,   3,0,  11 },
    { 2023,   5,   1,    40,   3,0,  12 },
    { 2023,   5,   6,    40,   3,0,  17 },
    { 2023,   5,  18,    40,   3,0,  29 },
    { 2023,   5,  19,    40,   4,0,   1 },
    { 2023,   5,  20,    40,   4,0,   2 },
    { 2023,   5,  21,    40,   4,0,   3 },
    { 2023,   5,  31,    40,   4,0,  13 },
    { 2023,   6,   1,    40,   4,0,  14 },
    { 2023,   6,   6,    40,   4,0,  19 },
    { 2023,   6,  17,    40,   4,0,  30 },
    { 2023,   6,  18,    40,   5,0,   1 },
    { 2023,   6,  19,    40,   5,0,   2 },
    { 2023,   6,  21,    40,   5,0,   4 },
    { 2023,   6,  30,    40,   5,0,  13 },
    { 2023,   7,   1,    40,   5,0,  14 },
    { 2023,   7,   7,    40,   5,0,  20 },
    { 2023,   7,  17,    40,   5,0,  30 },
    { 2023,   7,  18,    40,   6,0,   1 },
    { 2023,   7,  19,    40,   6,0,   2 },
    { 2023,   7,  23,    40,   6,0,   6 },
    { 2023,   7,  31,    40,   6,0,  14 },
    { 2023,   8,   1,    40,   6,0,  15 },
    { 2023,   8,   8,    40,   6,0,  22 },
    { 2023,   8,  15,    40,   6,0,  29 },
    { 2023,   8,  16,    40,   7,0,   1 },
    { 2023,   8,  17,    40,   7,0,   2 },
    { 2023,   8,  23,    40,   7,0,   8 },
    { 2023,   8,  31,    40,   7,0,  16 },
    { 2023,   9,   1,    40,   7,0,  17 },
    { 2023,   9,   8,    40,   7,0,  24 },
    { 2023,   9,  14,    40,   7,0,  30 },
    { 2023,   9,  15,    40,   8,0,   1 },
    { 2023,   9,  16,    40,   8,0,   2 },
    { 2023,   9,  23,    40,   8,0,   9 },
    { 2023,   9,  30,    40,   8,0,  16 },
    { 2023,  10,   1,    40,   8,0,  17 },
    { 2023,  10,   8,    40,   8,0,  24 },
    { 2023,  10,  14,    40,   8,0,  30 },
    { 2023,  10,  15,    40,   9,0,   1 },
    { 2023,  10,  16,    40,   9,0,   2 },
    { 2023,  10,  24,    40,   9,0,  10 },
    { 2023,  10,  31,    40,   9,0,  17 },
    { 2023,  11,   1,    40,   9,0,  18 },
    { 2023,  11,   8,    40,   9,0,  25 },
    { 2023,  11,  12,    40,   9,0,  29 },
    { 2023,  11,  13,    40,  10,0,   1 },
    { 2023,  11,  14,    40,  10,0,   2 },
    { 2023,  11,  22,    40,  10,0,  10 },
    { 2023,  11,  30,    40,  10,0,  18 },
    { 2023,  12,   1,    40,  10,0,  19 },
    { 2023,  12,   7,    40,  10,0,  25 },
    { 2023,  12,  12,    40,  10,0,  30 },
    { 2023,  12,  13,    40,  11,0,   1 },
    { 2023,  12,  14,    40,  11,0,   2 },
    { 2023,  12,  22,    40,  11,0,  10 },
    { 2023,  12,  31,    40,  11,0,  19 },
    { 2024,   1,   1,    40,  11,0,  20 },
    { 2024,   1,   6,    40,  11,0,  25 },
    { 2024,   1,  10,    40,  11,0,  29 },
    { 2024,   1,  11,    40,  12,0,   1 },
    { 2024,   1,  12,    40,  12,0,   2 },
    { 2024,   1,  20,    40,  12,0,  10 },
    { 2024,   1,  31,    40,  12,0,  21 },
    { 2024,   2,   1,    40,  12,0,  22 },
    { 2024,   2,   4,    40,  12,0,  25 },
    { 2024,   2,   9,    40,  12,0,  30 },
    { 2024,   2,  10,    41,   1,0,   1 },
    { 2024,   2,  11,    41,   1,0,   2 },
    { 2024,   2,  19,    41,   1,0,  10 },
    { 2024,   2,  29,    41,   1,0,  20 },
    { 2024,   3,   1,    41,   1,0,  21 },
    { 2024,   3,   5,    41,   1,0,  25 },
    { 2024,   3,   9,    41,   1,0,  29 },
    { 2024,   3,  10,    41,   2,0,   1 },
    { 2024,   3,  11,    41,   2,0,   2 },
    { 2024,   3,  20,    41,   2,0,  11 },
    { 2024,   3,  31,    41,   2,0,  22 },
    { 2024,   4,   1,    41,   2,0,  23 },
    { 2024,   4,   4,    41,   2,0,  26 },
    { 2024,   4,   8,    41,   2,0,  30 },
    { 2024,   4,   9,    41,   3,0,   1 },
    { 2024,   4,  10,    41,   3,0,   2 },
    { 2024,   4,  19,    41,   3,0,  11 },
    { 2024,   4,  30,    41,   3,0,  22 },
    { 2024,   5,   1,    41,   3,0,  23 },
    { 2024,   5,   5,    41,   3,0,  27 },
    { 2024,   5,   7,    41,   3,0,  29 },
    { 2024,   5,   8,    41,   4,0,   1 },
    { 2024,   5,   9,    41,   4,0,   2 },
    { 2024,   5,  20,    41,   4,0,  13 },
    { 2024,   5,  31,    41,   4,0,  24 },
    { 2024,   6,   1,    41,   4,0,  25 },
    { 2024,   6,   5,    41,   4,0,  29 },
    { 2024,   6,   6,    41,   5,0,   1 },
    { 2024,   6,   7,    41,   5,0,   2 },
    { 2024,   6,  21,    41,   5,0,  16 },
    { 2024,   6,  30,    41,   5,0,  25 },
    { 2024,   7,   1,    41,   5,0,  26 },
    { 2024,   7,   5,    41,   5,0,  30 },
    { 2024,   7,   6,    41,   6,0,   1 },
    { 2024,   7,   7,    41,   6,0,   2 },
    { 2024,   7,  22,    41,   6,0,  17 },
    { 2024,   7,  31,    41,   6,0,  26 },
    { 2024,   8,   1,    41,   6,0,  27 },
    { 2024,   8,   3,    41,   6,0,  29 },
    { 2024,   8,   4,    41,   7,0,   1 },
    { 2024,   8,   5,    41,   7,0,   2 },
    { 2024,   8,   7,    41,   7,0,   4 },
    { 2024,   8,  22,    41,   7,0,  19 },
    { 2024,   9,   2,    41,   7,0,  30 },
    { 2024,   9,   3,    41,   8,0,   1 },
    { 2024,   9,   4,    41,   8,0,   2 },
    { 2024,   9,   7,    41,   8,0,   5 },
    { 2024,   9,  22,    41,   8,0,  20 },
    { 2024,  10,   2,    41,   8,0,  30 },
    { 2024,  10,   3,    41,   9,0,   1 },
    { 2024,  10,   4,    41,   9,0,   2 },
    { 2024,  10,   8,    41,   9,0,   6 },
    { 2024,  10,  23,    41,   9,0,  21 },
    { 2024,  10,  31,    41,   9,0,  29 },
    { 2024,  11,   1,    41,  10,0,   1 },
    { 2024,  11,   7,    41,  10,0,   7 },
    { 2024,  11,  22,    41,  10,0,  22 },
    { 2024,  11,  30,    41,  10,0,  30 },
    { 2024,  12,   1,    41,  11,0,   1 },
    { 2024,  12,   6,    41,  11,0,   6 },
    { 2024,  12,  21,    41,  11,0,  21 },
    { 2024,  12,  30,    41,  11,0,  30 },
    { 2024,  12,  31,    41,  12,0,   1 },
    { 2025,   1,   1,    41,  12,0,   2 },
    { 2025,   1,   5,    41,  12,0,   6 },
    { 2025,   1,  20,    41,  12,0,  21 },
    { 2025,   1,  28,    41,  12,0,  29 },
    { 2025,   1,  29,    42,   1,0,   1 },
    { 2025,   1,  30,    42,   1,0,   2 },
    { 2025,   1,  31,    42,   1,0,   3 },
    { 2025,   2,   1,    42,   1,0,   4 },
    { 2025,   2,   3,    42,   1,0,   6 },
    { 2025,   2,  18,    42,   1,0,  21 },
    { 2025,   2,  27,    42,   1,0,  30 },
    { 2025,   2,  28,    42,   2,0,   1 },
    { 2025,   3,   1,    42,   2,0,   2 },
    { 2025,   3,   5,    42,   2,0,   6 },
    { 2025,   3,  20,    42,   2,0,  21 },
    { 2025,   3,  28,    42,   2,0,  29 },
    { 2025,   3,  29,    42,   3,0,   1 },
    { 2025,   3,  30,    42,   3,0,   2 },
    { 2025,   3,  31,    42,   3,0,   3 },
    { 2025,   4,   1,    42,   3,0,   4 },
    { 2025,   4,   4,    42,   3,0,   7 },
    { 2025,   4,  20,    42,   3,0,  23 },
    { 2025,   4,  27,    42,   3,0,  30 },
    { 2025,   4,  28,    42,   4,0,   1 },
    { 2025,   4,  29,    42,   4,0,   2 },
    { 2025,   4,  30,    42,   4,0,   3 },
    { 2025,   5,   1,    42,   4,0,   4 },
    { 2025,   5,   5,    42,   4,0,   8 },
    { 2025,   5,  21,    42,   4,0,  24 },
    { 2025,   5,  26,    42,   4,0,  29 },
    { 2025,   5,  27,    42,   5,0,   1 },
    { 2025,   5,  28,    42,   5,0,   2 },
    { 2025,   5,  31,    42,   5,0,   5 },
    { 2025,   6,   1,    42,   5,0,   6 },
    { 2025,   6,   5,    42,   5,0,  10 },
    { 2025,   6,  21,    42,   5,0,  26 },
    { 2025,   6,  24,    42,   5,0,  29 },
    { 2025,   6,  25,    42,   6,0,   1 },
    { 2025,   6,  26,    42,   6,0,   2 },
    { 2025,   6,  30,    42,   6,0,   6 },
    { 2025,   7,   1,    42,   6,0,   7 },
    { 2025,   7,   7,    42,   6,0,  13 },
    { 2025,   7,  22,    42,   6,0,  28 },
    { 2025,   7,  24,    42,   6,0,  30 },
    { 2025,   7,  25,    42,   6,1,   1 },
    { 2025,   7,  26,    42,   6,1,   2 },
    { 2025,   7,  31,    42,   6,1,   7 },
    { 2025,   8,   1,    42,   6,1,   8 },
    { 2025,   8,   7,    42,   6,1,  14 },
    { 2025,   8,  22,    42,   6,1,  29 },
    { 2025,   8,  23,    42,   7,0,   1 },
    { 2025,   8,  24,    42,   7,0,   2 },
    { 2025,   8,  31,    42,   7,0,   9 },
    { 2025,   9,   1,    42,   7,0,  10 },
    { 2025,   9,   7,    42,   7,0,  16 },
    { 2025,   9,  21,    42,   7,0,  30 },
    { 2025,   9,  22,    42,   8,0,   1 },
    { 2025,   9,  23,    42,   8,0,   2 },
    { 2025,   9,  30,    42,   8,0,   9 },
    { 2025,  10,   1,    42,   8,0,  10 },
    { 2025,  10,   8,    42,   8,0,  17 },
    { 2025,  10,  20,    42,   8,0,  29 },
    { 2025,  10,  21,    42,   9,0,   1 },
    { 2025,  10,  22,    42,   9,0,   2 },
    { 2025,  10,  23,    42,   9,0,   3 },
    { 2025,  10,  31,    42,   9,0,  11 },
    { 2025,  11,   1,    42,   9,0,  12 },
    { 2025,  11,   7,    42,   9,0,  18 },
    { 2025,  11,  19,    42,   9,0,  30 },
    { 2025,  11,  20,    42,  10,0,   1 },
    { 2025,  11,  21,    42,  10,0,   2 },
    { 2025,  11,  22,    42,  10,0,   3 },
    { 2025,  11,  30,    42,  10,0,  11 },
    { 2025,  12,   1,    42,  10,0,  12 },
    { 2025,  12,   7,    42,  10,0,  18 },
    { 2025,  12,  19,    42,  10,0,  30 },
    { 2025,  12,  20,    42,  11,0,   1 },
    { 2025,  12,  21,    42,  11,0,   2 },
    { 2025,  12,  31,    42,  11,0,  12 },
    { 2026,   1,   1,    42,  11,0,  13 },
    { 2026,   1,   5,    42,  11,0,  17 },
    { 2026,   1,  18,    42,  11,0,  30 },
    { 2026,   1,  19,    42,  12,0,   1 },
    { 2026,   1,  20,    42,  12,0,   2 },
    { 2026,   1,  31,    42,  12,0,  13 },
    { 2026,   2,   1,    42,  12,0,  14 },
    { 2026,   2,   4,    42,  12,0,  17 },
    { 2026,   2,  16,    42,  12,0,  29 },
    { 2026,   2,  17,    43,   1,0,   1 },
    { 2026,   2,  18,    43,   1,0,   2 },
    { 2026,   2,  28,    43,   1,0,  12 },
    { 2026,   3,   1,    43,   1,0,  13 },
    { 2026,   3,   5,    43,   1,0,  17 },
    { 2026,   3,  18,    43,   1,0,  30 },
    { 2026,   3,  19,    43,   2,0,   1 },
    { 2026,   3,  20,    43,   2,0,   2 },
    { 2026,   3,  31,    43,   2,0,  13 },
    { 2026,   4,   1,    43,   2,0,  14 },
    { 2026,   4,   5,    43,   2,0,  18 },
    { 2026,   4,  16,    43,   2,0,  29 },
    { 2026,   4,  17,    43,   3,0,   1 },
    { 2026,   4,  18,    43,   3,0,   2 },
    { 2026,   4,  20,    43,   3,0,   4 },
    { 2026,   4,  30,    43,   3,0,  14 },
    { 2026,   5,   1,    43,   3,0,  15 },
    { 2026,   5,   5,    43,   3,0,  19 },
    { 2026,   5,  16,    43,   3,0,  30 },
    { 2026,   5,  17,    43,   4,0,   1 },
    { 2026,   5,  18,    43,   4,0,   2 },
    { 2026,   5,  21,    43,   4,0,   5 },
    { 2026,   5,  31,    43,   4,0,  15 },
    { 2026,   6,   1,    43,   4,0,  16 },
    { 2026,   6,   5,    43,   4,0,  20 },
    { 2026,   6,  14,    43,   4,0,  29 },
    { 2026,   6,  15,    43,   5,0,   1 },
    { 2026,   6,  16,    43,   5,0,   2 },
    { 2026,   6,  21,    43,   5,0,   7 },
    { 2026,   6,  30,    43,   5,0,  16 },
    { 2026,   7,   1,    43,   5,0,  17 },
    { 2026,   7,   7,    43,   5,0,  23 },
    { 2026,   7,  13,    43,   5,0,  29 },
    { 2026,   7,  14,    43,   6,0,   1 },
    { 2026,   7,  15,    43,   6,0,   2 },
    { 2026,   7,  23,    43,   6,0,  10 },
    { 2026,   7,  31,    43,   6,0,  18 },
    { 2026,   8,   1,    43,   6,0,  19 },
    { 2026,   8,   7,    43,   6,0,  25 },
    { 2026,   8,  12,    43,   6,0,  30 },
    { 2026,   8,  13,    43,   7,0,   1 },
    { 2026,   8,  14,    43,   7,0,   2 },
    { 2026,   8,  23,    43,   7,0,  11 },
    { 2026,   8,  31,    43,   7,0,  19 },
    { 2026,   9,   1,    43,   7,0,  20 },
    { 2026,   9,   7,    43,   7,0,  26 },
    { 2026,   9,  10,    43,   7,0,  29 },
    { 2026,   9,  11,    43,   8,0,   1 },
    { 2026,   9,  12,    43,   8,0,   2 },
    { 2026,   9,  23,    43,   8,0,  13 },
    { 2026,   9,  30,    43,   8,0,  20 },
    { 2026,  10,   1,    43,   8,0,  21 },
    { 2026,  10,   8,    43,   8,0,  28 },
    { 2026,  10,   9,    43,   8,0,  29 },
    { 2026,  10,  10,    43,   9,0,   1 },
    { 2026,  10,  11,    43,   9,0,   2 },
    { 2026,  10,  23,    43,   9,0,  14 },
    { 2026,  10,  31,    43,   9,0,  22 },
    { 2026,  11,   1,    43,   9,0,  23 },
    { 2026,  11,   7,    43,   9,0,  29 },
    { 2026,  11,   8,    43,   9,0,  30 },
    { 2026,  11,   9,    43,  10,0,   1 },
    { 2026,  11,  10,    43,  10,0,   2 },
    { 2026,  11,  22,    43,  10,0,  14 },
    { 2026,  11,  30,    43,  10,0,  22 },
    { 2026,  12,   1,    43,  10,0,  23 },
    { 2026,  12,   7,    43,  10,0,  29 },
    { 2026,  12,   8,    43,  10,0,  30 },
    { 2026,  12,   9,    43,  11,0,   1 },
    { 2026,  12,  10,    43,  11,0,   2 },
    { 2026,  12,  22,    43,  11,0,  14 },
    { 2026,  12,  31,    43,  11,0,  23 },
    { 2027,   1,   1,    43,  11,0,  24 },
    { 2027,   1,   5,    43,  11,0,  28 },
    { 2027,   1,   7,    43,  11,0,  30 },
    { 2027,   1,   8,    43,  12,0,   1 },
    { 2027,   1,   9,    43,  12,0,   2 },
    { 2027,   1,  20,    43,  12,0,  13 },
    { 2027,   1,  31,    43,  12,0,  24 },
    { 2027,   2,   1,    43,  12,0,  25 },
    { 2027,   2,   4,    43,  12,0,  28 },
    { 2027,   2,   5,    43,  12,0,  29 },
//# { 2027,   2,   6,    44,   1,0,   1 },
//# { 2027,   2,   7,    44,   1,0,   2 },
//# { 2027,   2,  19,    44,   1,0,  14 },
//# { 2027,   2,  28,    44,   1,0,  23 },
//# { 2027,   3,   1,    44,   1,0,  24 },
//# { 2027,   3,   6,    44,   1,0,  29 },
//# { 2027,   3,   7,    44,   1,0,  30 },
    { 2027,   3,   8,    44,   2,0,   1 },
    { 2027,   3,   9,    44,   2,0,   2 },
    { 2027,   3,  21,    44,   2,0,  14 },
    { 2027,   3,  31,    44,   2,0,  24 },
    { 2027,   4,   1,    44,   2,0,  25 },
    { 2027,   4,   5,    44,   2,0,  29 },
    { 2027,   4,   6,    44,   2,0,  30 },
    { 2027,   4,   7,    44,   3,0,   1 },
    { 2027,   4,   8,    44,   3,0,   2 },
    { 2027,   4,  20,    44,   3,0,  14 },
    { 2027,   4,  30,    44,   3,0,  24 },
    { 2027,   5,   1,    44,   3,0,  25 },
    { 2027,   5,   5,    44,   3,0,  29 },
    { 2027,   5,   6,    44,   4,0,   1 },
    { 2027,   5,   7,    44,   4,0,   2 },
    { 2027,   5,  21,    44,   4,0,  16 },
    { 2027,   5,  31,    44,   4,0,  26 },
    { 2027,   6,   1,    44,   4,0,  27 },
    { 2027,   6,   4,    44,   4,0,  30 },
    { 2027,   6,   5,    44,   5,0,   1 },
    { 2027,   6,   6,    44,   5,0,   2 },
    { 2027,   6,  21,    44,   5,0,  17 },
    { 2027,   6,  30,    44,   5,0,  26 },
    { 2027,   7,   1,    44,   5,0,  27 },
    { 2027,   7,   3,    44,   5,0,  29 },
    { 2027,   7,   4,    44,   6,0,   1 },
    { 2027,   7,   5,    44,   6,0,   2 },
    { 2027,   7,   7,    44,   6,0,   4 },
    { 2027,   7,  23,    44,   6,0,  20 },
    { 2027,   8,   1,    44,   6,0,  29 },
    { 2027,   8,   2,    44,   7,0,   1 },
    { 2027,   8,   3,    44,   7,0,   2 },
    { 2027,   8,   8,    44,   7,0,   7 },
    { 2027,   8,  23,    44,   7,0,  22 },
    { 2027,   8,  31,    44,   7,0,  30 },
    { 2027,   9,   1,    44,   8,0,   1 },
    { 2027,   9,   8,    44,   8,0,   8 },
    { 2027,   9,  23,    44,   8,0,  23 },
    { 2027,   9,  29,    44,   8,0,  29 },
    { 2027,   9,  30,    44,   9,0,   1 },
    { 2027,  10,   1,    44,   9,0,   2 },
    { 2027,  10,   8,    44,   9,0,   9 },
    { 2027,  10,  23,    44,   9,0,  24 },
    { 2027,  10,  28,    44,   9,0,  29 },
    { 2027,  10,  29,    44,  10,0,   1 },
    { 2027,  10,  30,    44,  10,0,   2 },
    { 2027,  10,  31,    44,  10,0,   3 },
    { 2027,  11,   1,    44,  10,0,   4 },
    { 2027,  11,   7,    44,  10,0,  10 },
    { 2027,  11,  22,    44,  10,0,  25 },
    { 2027,  11,  27,    44,  10,0,  30 },
    { 2027,  11,  28,    44,  11,0,   1 },
    { 2027,  11,  29,    44,  11,0,   2 },
    { 2027,  11,  30,    44,  11,0,   3 },
    { 2027,  12,   1,    44,  11,0,   4 },
    { 2027,  12,   7,    44,  11,0,  10 },
    { 2027,  12,  22,    44,  11,0,  25 },
    { 2027,  12,  27,    44,  11,0,  30 },
    { 2027,  12,  28,    44,  12,0,   1 },
    { 2027,  12,  29,    44,  12,0,   2 },
    { 2027,  12,  31,    44,  12,0,   4 },
    { 2028,   1,   1,    44,  12,0,   5 },
    { 2028,   1,   6,    44,  12,0,  10 },
    { 2028,   1,  20,    44,  12,0,  24 },
    { 2028,   1,  25,    44,  12,0,  29 },
    { 2028,   1,  26,    45,   1,0,   1 },
    { 2028,   1,  27,    45,   1,0,   2 },
    { 2028,   1,  31,    45,   1,0,   6 },
    { 2028,   2,   1,    45,   1,0,   7 },
    { 2028,   2,   4,    45,   1,0,  10 },
    { 2028,   2,  19,    45,   1,0,  25 },
    { 2028,   2,  24,    45,   1,0,  30 },
    { 2028,   2,  25,    45,   2,0,   1 },
    { 2028,   2,  26,    45,   2,0,   2 },
    { 2028,   2,  29,    45,   2,0,   5 },
    { 2028,   3,   1,    45,   2,0,   6 },
    { 2028,   3,   5,    45,   2,0,  10 },
    { 2028,   3,  20,    45,   2,0,  25 },
    { 2028,   3,  25,    45,   2,0,  30 },
    { 2028,   3,  26,    45,   3,0,   1 },
    { 2028,   3,  27,    45,   3,0,   2 },
    { 2028,   3,  31,    45,   3,0,   6 },
    { 2028,   4,   1,    45,   3,0,   7 },
    { 2028,   4,   4,    45,   3,0,  10 },
    { 2028,   4,  19,    45,   3,0,  25 },
    { 2028,   4,  24,    45,   3,0,  30 },
    { 2028,   4,  25,    45,   4,0,   1 },
    { 2028,   4,  26,    45,   4,0,   2 },
    { 2028,   4,  30,    45,   4,0,   6 },
    { 2028,   5,   1,    45,   4,0,   7 },
    { 2028,   5,   5,    45,   4,0,  11 },
    { 2028,   5,  20,    45,   4,0,  26 },
    { 2028,   5,  23,    45,   4,0,  29 },
    { 2028,   5,  24,    45,   5,0,   1 },
    { 2028,   5,  25,    45,   5,0,   2 },
    { 2028,   5,  31,    45,   5,0,   8 },
    { 2028,   6,   1,    45,   5,0,   9 },
    { 2028,   6,   5,    45,   5,0,  13 },
    { 2028,   6,  21,    45,   5,0,  29 },
    { 2028,   6,  22,    45,   5,0,  30 },
    { 2028,   6,  23,    45,   5,1,   1 },
    { 2028,   6,  24,    45,   5,1,   2 },
    { 2028,   6,  30,    45,   5,1,   8 },
    { 2028,   7,   1,    45,   5,1,   9 },
    { 2028,   7,   6,    45,   5,1,  14 },
    { 2028,   7,  21,    45,   5,1,  29 },
    { 2028,   7,  22,    45,   6,0,   1 },
    { 2028,   7,  23,    45,   6,0,   2 },
    { 2028,   7,  31,    45,   6,0,  10 },
    { 2028,   8,   1,    45,   6,0,  11 },
    { 2028,   8,   7,    45,   6,0,  17 },
    { 2028,   8,  19,    45,   6,0,  29 },
    { 2028,   8,  20,    45,   7,0,   1 },
    { 2028,   8,  21,    45,   7,0,   2 },
    { 2028,   8,  22,    45,   7,0,   3 },
    { 2028,   8,  31,    45,   7,0,  12 },
    { 2028,   9,   1,    45,   7,0,  13 },
    { 2028,   9,   7,    45,   7,0,  19 },
    { 2028,   9,  18,    45,   7,0,  30 },
    { 2028,   9,  19,    45,   8,0,   1 },
    { 2028,   9,  20,    45,   8,0,   2 },
    { 2028,   9,  22,    45,   8,0,   4 },
    { 2028,   9,  30,    45,   8,0,  12 },
    { 2028,  10,   1,    45,   8,0,  13 },
    { 2028,  10,   8,    45,   8,0,  20 },
    { 2028,  10,  17,    45,   8,0,  29 },
    { 2028,  10,  18,    45,   9,0,   1 },
    { 2028,  10,  19,    45,   9,0,   2 },
    { 2028,  10,  23,    45,   9,0,   6 },
    { 2028,  10,  31,    45,   9,0,  14 },
    { 2028,  11,   1,    45,   9,0,  15 },
    { 2028,  11,   7,    45,   9,0,  21 },
    { 2028,  11,  15,    45,   9,0,  29 },
    { 2028,  11,  16,    45,  10,0,   1 },
    { 2028,  11,  17,    45,  10,0,   2 },
    { 2028,  11,  22,    45,  10,0,   7 },
    { 2028,  11,  30,    45,  10,0,  15 },
    { 2028,  12,   1,    45,  10,0,  16 },
    { 2028,  12,   6,    45,  10,0,  21 },
    { 2028,  12,  15,    45,  10,0,  30 },
    { 2028,  12,  16,    45,  11,0,   1 },
    { 2028,  12,  17,    45,  11,0,   2 },
    { 2028,  12,  21,    45,  11,0,   6 },
    { 2028,  12,  31,    45,  11,0,  16 },
    { 2029,   1,   1,    45,  11,0,  17 },
    { 2029,   1,   5,    45,  11,0,  21 },
    { 2029,   1,  14,    45,  11,0,  30 },
    { 2029,   1,  15,    45,  12,0,   1 },
    { 2029,   1,  16,    45,  12,0,   2 },
    { 2029,   1,  20,    45,  12,0,   6 },
    { 2029,   1,  31,    45,  12,0,  17 },
    { 2029,   2,   1,    45,  12,0,  18 },
    { 2029,   2,   3,    45,  12,0,  20 },
    { 2029,   2,  12,    45,  12,0,  29 },
    { 2029,   2,  13,    46,   1,0,   1 },
    { 2029,   2,  14,    46,   1,0,   2 },
    { 2029,   2,  18,    46,   1,0,   6 },
    { 2029,   2,  28,    46,   1,0,  16 },
    { 2029,   3,   1,    46,   1,0,  17 },
    { 2029,   3,   5,    46,   1,0,  21 },
    { 2029,   3,  14,    46,   1,0,  30 },
    { 2029,   3,  15,    46,   2,0,   1 },
    { 2029,   3,  16,    46,   2,0,   2 },
    { 2029,   3,  20,    46,   2,0,   6 },
    { 2029,   3,  31,    46,   2,0,  17 },
    { 2029,   4,   1,    46,   2,0,  18 },
    { 2029,   4,   4,    46,   2,0,  21 },
    { 2029,   4,  13,    46,   2,0,  30 },
    { 2029,   4,  14,    46,   3,0,   1 },
    { 2029,   4,  15,    46,   3,0,   2 },
    { 2029,   4,  20,    46,   3,0,   7 },
    { 2029,   4,  30,    46,   3,0,  17 },
    { 2029,   5,   1,    46,   3,0,  18 },
    { 2029,   5,   5,    46,   3,0,  22 },
    { 2029,   5,  12,    46,   3,0,  29 },
    { 2029,   5,  13,    46,   4,0,   1 },
    { 2029,   5,  14,    46,   4,0,   2 },
    { 2029,   5,  21,    46,   4,0,   9 },
    { 2029,   5,  31,    46,   4,0,  19 },
    { 2029,   6,   1,    46,   4,0,  20 },
    { 2029,   6,   5,    46,   4,0,  24 },
    { 2029,   6,  11,    46,   4,0,  30 },
    { 2029,   6,  12,    46,   5,0,   1 },
    { 2029,   6,  13,    46,   5,0,   2 },
    { 2029,   6,  21,    46,   5,0,  10 },
    { 2029,   6,  30,    46,   5,0,  19 },
    { 2029,   7,   1,    46,   5,0,  20 },
    { 2029,   7,   7,    46,   5,0,  26 },
    { 2029,   7,  10,    46,   5,0,  29 },
    { 2029,   7,  11,    46,   6,0,   1 },
    { 2029,   7,  12,    46,   6,0,   2 },
    { 2029,   7,  22,    46,   6,0,  12 },
    { 2029,   7,  31,    46,   6,0,  21 },
    { 2029,   8,   1,    46,   6,0,  22 },
    { 2029,   8,   7,    46,   6,0,  28 },
    { 2029,   8,   9,    46,   6,0,  30 },
    { 2029,   8,  10,    46,   7,0,   1 },
    { 2029,   8,  11,    46,   7,0,   2 },
    { 2029,   8,  23,    46,   7,0,  14 },
    { 2029,   8,  31,    46,   7,0,  22 },
    { 2029,   9,   1,    46,   7,0,  23 },
    { 2029,   9,   7,    46,   7,0,  29 },
    { 2029,   9,   8,    46,   8,0,   1 },
    { 2029,   9,   9,    46,   8,0,   2 },
    { 2029,   9,  23,    46,   8,0,  16 },
    { 2029,   9,  30,    46,   8,0,  23 },
    { 2029,  10,   1,    46,   8,0,  24 },
    { 2029,  10,   7,    46,   8,0,  30 },
    { 2029,  10,   8,    46,   9,0,   1 },
    { 2029,  10,   9,    46,   9,0,   2 },
    { 2029,  10,  23,    46,   9,0,  16 },
    { 2029,  10,  31,    46,   9,0,  24 },
    { 2029,  11,   1,    46,   9,0,  25 },
    { 2029,  11,   5,    46,   9,0,  29 },
    { 2029,  11,   6,    46,  10,0,   1 },
    { 2029,  11,   7,    46,  10,0,   2 },
    { 2029,  11,  22,    46,  10,0,  17 },
    { 2029,  11,  30,    46,  10,0,  25 },
    { 2029,  12,   1,    46,  10,0,  26 },
    { 2029,  12,   4,    46,  10,0,  29 },
    { 2029,  12,   5,    46,  11,0,   1 },
    { 2029,  12,   6,    46,  11,0,   2 },
    { 2029,  12,   7,    46,  11,0,   3 },
    { 2029,  12,  21,    46,  11,0,  17 },
    { 2029,  12,  31,    46,  11,0,  27 },
    { 2030,   1,   1,    46,  11,0,  28 },
    { 2030,   1,   3,    46,  11,0,  30 },
    { 2030,   1,   4,    46,  12,0,   1 },
    { 2030,   1,   5,    46,  12,0,   2 },
    { 2030,   1,  20,    46,  12,0,  17 },
//# { 2030,   2,   2,    46,  12,0,  30 },
//# { 2030,   2,   3,    47,   1,0,   1 },
//# { 2030,   2,   4,    47,   1,0,   2 },
//# { 2030,   2,  18,    47,   1,0,  16 },
//# { 2030,   2,  28,    47,   1,0,  26 },
//# { 2030,   3,   1,    47,   1,0,  27 },
//# { 2030,   3,   3,    47,   1,0,  29 },
    { 2030,   3,   4,    47,   2,0,   1 },
    { 2030,   3,   5,    47,   2,0,   2 },
    { 2030,   3,  20,    47,   2,0,  17 },
    { 2030,   4,   2,    47,   2,0,  30 },
    { 2030,   4,   3,    47,   3,0,   1 },
    { 2030,   4,   4,    47,   3,0,   2 },
    { 2030,   4,   5,    47,   3,0,   3 },
    { 2030,   4,  20,    47,   3,0,  18 },
    { 2030,   5,   1,    47,   3,0,  29 },
    { 2030,   5,   2,    47,   4,0,   1 },
    { 2030,   5,   3,    47,   4,0,   2 },
    { 2030,   5,   5,    47,   4,0,   4 },
    { 2030,   5,  21,    47,   4,0,  20 },
    { 2030,   5,  31,    47,   4,0,  30 },
    { 2030,   6,   1,    47,   5,0,   1 },
    { 2030,   6,   5,    47,   5,0,   5 },
    { 2030,   6,  21,    47,   5,0,  21 },
    { 2030,   6,  30,    47,   5,0,  30 },
    { 2030,   7,   1,    47,   6,0,   1 },
    { 2030,   7,   7,    47,   6,0,   7 },
    { 2030,   7,  23,    47,   6,0,  23 },
    { 2030,   7,  29,    47,   6,0,  29 },
    { 2030,   7,  30,    47,   7,0,   1 },
    { 2030,   7,  31,    47,   7,0,   2 },
    { 2030,   8,   1,    47,   7,0,   3 },
    { 2030,   8,   7,    47,   7,0,   9 },
    { 2030,   8,  23,    47,   7,0,  25 },
    { 2030,   8,  28,    47,   7,0,  30 },
    { 2030,   8,  29,    47,   8,0,   1 },
    { 2030,   8,  30,    47,   8,0,   2 },
    { 2030,   8,  31,    47,   8,0,   3 },
    { 2030,   9,   1,    47,   8,0,   4 },
    { 2030,   9,   7,    47,   8,0,  10 },
    { 2030,   9,  23,    47,   8,0,  26 },
    { 2030,   9,  26,    47,   8,0,  29 },
    { 2030,   9,  27,    47,   9,0,   1 },
    { 2030,   9,  28,    47,   9,0,   2 },
    { 2030,   9,  30,    47,   9,0,   4 },
    { 2030,  10,   1,    47,   9,0,   5 },
    { 2030,  10,   8,    47,   9,0,  12 },
    { 2030,  10,  23,    47,   9,0,  27 },
    { 2030,  10,  26,    47,   9,0,  30 },
    { 2030,  10,  27,    47,  10,0,   1 },
    { 2030,  10,  28,    47,  10,0,   2 },
    { 2030,  10,  31,    47,  10,0,   5 },
    { 2030,  11,   1,    47,  10,0,   6 },
    { 2030,  11,   7,    47,  10,0,  12 },
    { 2030,  11,  22,    47,  10,0,  27 },
    { 2030,  11,  24,    47,  10,0,  29 },
    { 2030,  11,  25,    47,  11,0,   1 },
    { 2030,  11,  26,    47,  11,0,   2 },
    { 2030,  11,  30,    47,  11,0,   6 },
    { 2030,  12,   1,    47,  11,0,   7 },
    { 2030,  12,   7,    47,  11,0,  13 },
    { 2030,  12,  22,    47,  11,0,  28 },
    { 2030,  12,  24,    47,  11,0,  30 },
    { 2030,  12,  25,    47,  12,0,   1 },
    { 2030,  12,  26,    47,  12,0,   2 },
    { 2030,  12,  31,    47,  12,0,   7 },
    { 2031,   1,   1,    47,  12,0,   8 },
    { 2031,   1,   5,    47,  12,0,  12 },
    { 2031,   1,  20,    47,  12,0,  27 },
    { 2031,   1,  22,    47,  12,0,  29 },
    { 2031,   1,  23,    48,   1,0,   1 },
    { 2031,   1,  24,    48,   1,0,   2 },
    { 2031,   1,  31,    48,   1,0,   9 },
    { 2031,   2,   1,    48,   1,0,  10 },
    { 2031,   2,   4,    48,   1,0,  13 },
    { 2031,   2,  19,    48,   1,0,  28 },
    { 2031,   2,  20,    48,   1,0,  29 },
    { 2031,   2,  21,    48,   2,0,   1 },
    { 2031,   2,  22,    48,   2,0,   2 },
    { 2031,   2,  28,    48,   2,0,   8 },
    { 2031,   3,   1,    48,   2,0,   9 },
    { 2031,   3,   6,    48,   2,0,  14 },
    { 2031,   3,  21,    48,   2,0,  29 },
    { 2031,   3,  22,    48,   2,0,  30 },
    { 2031,   3,  23,    48,   3,0,   1 },
    { 2031,   3,  24,    48,   3,0,   2 },
    { 2031,   3,  31,    48,   3,0,   9 },
    { 2031,   4,   1,    48,   3,0,  10 },
    { 2031,   4,   5,    48,   3,0,  14 },
    { 2031,   4,  20,    48,   3,0,  29 },
    { 2031,   4,  21,    48,   3,0,  30 },
    { 2031,   4,  22,    48,   3,1,   1 },
    { 2031,   4,  23,    48,   3,1,   2 },
    { 2031,   4,  30,    48,   3,1,   9 },
    { 2031,   5,   1,    48,   3,1,  10 },
    { 2031,   5,   6,    48,   3,1,  15 },
    { 2031,   5,  20,    48,   3,1,  29 },
    { 2031,   5,  21,    48,   4,0,   1 },
    { 2031,   5,  22,    48,   4,0,   2 },
    { 2031,   5,  31,    48,   4,0,  11 },
    { 2031,   6,   1,    48,   4,0,  12 },
    { 2031,   6,   6,    48,   4,0,  17 },
    { 2031,   6,  19,    48,   4,0,  30 },
    { 2031,   6,  20,    48,   5,0,   1 },
    { 2031,   6,  21,    48,   5,0,   2 },
    { 2031,   6,  30,    48,   5,0,  11 },
    { 2031,   7,   1,    48,   5,0,  12 },
    { 2031,   7,   7,    48,   5,0,  18 },
    { 2031,   7,  18,    48,   5,0,  29 },
    { 2031,   7,  19,    48,   6,0,   1 },
    { 2031,   7,  20,    48,   6,0,   2 },
    { 2031,   7,  23,    48,   6,0,   5 },
    { 2031,   7,  31,    48,   6,0,  13 },
    { 2031,   8,   1,    48,   6,0,  14 },
    { 2031,   8,   8,    48,   6,0,  21 },
    { 2031,   8,  17,    48,   6,0,  30 },
    { 2031,   8,  18,    48,   7,0,   1 },
    { 2031,   8,  19,    48,   7,0,   2 },
    { 2031,   8,  23,    48,   7,0,   6 },
    { 2031,   8,  31,    48,   7,0,  14 },
    { 2031,   9,   1,    48,   7,0,  15 },
    { 2031,   9,   8,    48,   7,0,  22 },
    { 2031,   9,  16,    48,   7,0,  30 },
    { 2031,   9,  17,    48,   8,0,   1 },
    { 2031,   9,  18,    48,   8,0,   2 },
    { 2031,   9,  23,    48,   8,0,   7 },
    { 2031,   9,  30,    48,   8,0,  14 },
    { 2031,  10,   1,    48,   8,0,  15 },
    { 2031,  10,   8,    48,   8,0,  22 },
    { 2031,  10,  15,    48,   8,0,  29 },
    { 2031,  10,  16,    48,   9,0,   1 },
    { 2031,  10,  17,    48,   9,0,   2 },
    { 2031,  10,  23,    48,   9,0,   8 },
    { 2031,  10,  31,    48,   9,0,  16 },
    { 2031,  11,   1,    48,   9,0,  17 },
    { 2031,  11,   7,    48,   9,0,  23 },
    { 2031,  11,  14,    48,   9,0,  30 },
    { 2031,  11,  15,    48,  10,0,   1 },
    { 2031,  11,  16,    48,  10,0,   2 },
    { 2031,  11,  22,    48,  10,0,   8 },
    { 2031,  11,  30,    48,  10,0,  16 },
    { 2031,  12,   1,    48,  10,0,  17 },
    { 2031,  12,   7,    48,  10,0,  23 },
    { 2031,  12,  13,    48,  10,0,  29 },
    { 2031,  12,  14,    48,  11,0,   1 },
    { 2031,  12,  15,    48,  11,0,   2 },
    { 2031,  12,  22,    48,  11,0,   9 },
    { 2031,  12,  31,    48,  11,0,  18 },
    { 2032,   1,   1,    48,  11,0,  19 },
    { 2032,   1,   6,    48,  11,0,  24 },
    { 2032,   1,  12,    48,  11,0,  30 },
    { 2032,   1,  13,    48,  12,0,   1 },
    { 2032,   1,  14,    48,  12,0,   2 },
    { 2032,   1,  20,    48,  12,0,   8 },
    { 2032,   1,  31,    48,  12,0,  19 },
    { 2032,   2,   1,    48,  12,0,  20 },
    { 2032,   2,   4,    48,  12,0,  23 },
    { 2032,   2,  10,    48,  12,0,  29 },
    { 2032,   2,  11,    49,   1,0,   1 },
    { 2032,   2,  12,    49,   1,0,   2 },
    { 2032,   2,  19,    49,   1,0,   9 },
    { 2032,   2,  29,    49,   1,0,  19 },
    { 2032,   3,   1,    49,   1,0,  20 },
    { 2032,   3,   5,    49,   1,0,  24 },
    { 2032,   3,  11,    49,   1,0,  30 },
    { 2032,   3,  12,    49,   2,0,   1 },
    { 2032,   3,  13,    49,   2,0,   2 },
    { 2032,   3,  20,    49,   2,0,   9 },
    { 2032,   3,  31,    49,   2,0,  20 },
    { 2032,   4,   1,    49,   2,0,  21 },
    { 2032,   4,   4,    49,   2,0,  24 },
    { 2032,   4,   9,    49,   2,0,  29 },
    { 2032,   4,  10,    49,   3,0,   1 },
    { 2032,   4,  11,    49,   3,0,   2 },
    { 2032,   4,  19,    49,   3,0,  10 },
    { 2032,   4,  30,    49,   3,0,  21 },
    { 2032,   5,   1,    49,   3,0,  22 },
    { 2032,   5,   5,    49,   3,0,  26 },
    { 2032,   5,   8,    49,   3,0,  29 },
    { 2032,   5,   9,    49,   4,0,   1 },
    { 2032,   5,  10,    49,   4,0,   2 },
    { 2032,   5,  20,    49,   4,0,  12 },
    { 2032,   5,  31,    49,   4,0,  23 },
    { 2032,   6,   1,    49,   4,0,  24 },
    { 2032,   6,   5,    49,   4,0,  28 },
    { 2032,   6,   7,    49,   4,0,  30 },
    { 2032,   6,   8,    49,   5,0,   1 },
    { 2032,   6,   9,    49,   5,0,   2 },
    { 2032,   6,  21,    49,   5,0,  14 },
    { 2032,   6,  30,    49,   5,0,  23 },
    { 2032,   7,   1,    49,   5,0,  24 },
    { 2032,   7,   6,    49,   5,0,  29 },
    { 2032,   7,   7,    49,   6,0,   1 },
    { 2032,   7,   8,    49,   6,0,   2 },
    { 2032,   7,  22,    49,   6,0,  16 },
    { 2032,   7,  31,    49,   6,0,  25 },
    { 2032,   8,   1,    49,   6,0,  26 },
    { 2032,   8,   5,    49,   6,0,  30 },
    { 2032,   8,   6,    49,   7,0,   1 },
    { 2032,   8,   7,    49,   7,0,   2 },
    { 2032,   8,  22,    49,   7,0,  17 },
    { 2032,   8,  31,    49,   7,0,  26 },
    { 2032,   9,   1,    49,   7,0,  27 },
    { 2032,   9,   4,    49,   7,0,  30 },
    { 2032,   9,   5,    49,   8,0,   1 },
    { 2032,   9,   6,    49,   8,0,   2 },
    { 2032,   9,   7,    49,   8,0,   3 },
    { 2032,   9,  22,    49,   8,0,  18 },
    { 2032,   9,  30,    49,   8,0,  26 },
    { 2032,  10,   1,    49,   8,0,  27 },
    { 2032,  10,   3,    49,   8,0,  29 },
    { 2032,  10,   4,    49,   9,0,   1 },
    { 2032,  10,   5,    49,   9,0,   2 },
    { 2032,  10,   8,    49,   9,0,   5 },
    { 2032,  10,  23,    49,   9,0,  20 },
    { 2032,  11,   2,    49,   9,0,  30 },
    { 2032,  11,   3,    49,  10,0,   1 },
    { 2032,  11,   4,    49,  10,0,   2 },
    { 2032,  11,   7,    49,  10,0,   5 },
    { 2032,  11,  22,    49,  10,0,  20 },
    { 2032,  12,   2,    49,  10,0,  30 },
    { 2032,  12,   3,    49,  11,0,   1 },
    { 2032,  12,   4,    49,  11,0,   2 },
    { 2032,  12,   6,    49,  11,0,   4 },
    { 2032,  12,  21,    49,  11,0,  19 },
    { 2032,  12,  31,    49,  11,0,  29 },
    { 2033,   1,   1,    49,  12,0,   1 },
    { 2033,   1,   5,    49,  12,0,   5 },
    { 2033,   1,  20,    49,  12,0,  20 },
    { 2033,   1,  30,    49,  12,0,  30 },
    { 2033,   1,  31,    50,   1,0,   1 },
    { 2033,   2,   1,    50,   1,0,   2 },
    { 2033,   2,   3,    50,   1,0,   4 },
    { 2033,   2,  18,    50,   1,0,  19 },
    { 2033,   2,  28,    50,   1,0,  29 },
    { 2033,   3,   1,    50,   2,0,   1 },
    { 2033,   3,   5,    50,   2,0,   5 },
    { 2033,   3,  20,    50,   2,0,  20 },
    { 2033,   3,  30,    50,   2,0,  30 },
    { 2033,   3,  31,    50,   3,0,   1 },
    { 2033,   4,   1,    50,   3,0,   2 },
    { 2033,   4,   4,    50,   3,0,   5 },
    { 2033,   4,  20,    50,   3,0,  21 },
    { 2033,   4,  28,    50,   3,0,  29 },
    { 2033,   4,  29,    50,   4,0,   1 },
    { 2033,   4,  30,    50,   4,0,   2 },
    { 2033,   5,   1,    50,   4,0,   3 },
    { 2033,   5,   5,    50,   4,0,   7 },
    { 2033,   5,  21,    50,   4,0,  23 },
    { 2033,   5,  27,    50,   4,0,  29 },
    { 2033,   5,  28,    50,   5,0,   1 },
    { 2033,   5,  29,    50,   5,0,   2 },
    { 2033,   5,  31,    50,   5,0,   4 },
    { 2033,   6,   1,    50,   5,0,   5 },
    { 2033,   6,   5,    50,   5,0,   9 },
    { 2033,   6,  21,    50,   5,0,  25 },
    { 2033,   6,  26,    50,   5,0,  30 },
    { 2033,   6,  27,    50,   6,0,   1 },
    { 2033,   6,  28,    50,   6,0,   2 },
    { 2033,   6,  30,    50,   6,0,   4 },
    { 2033,   7,   1,    50,   6,0,   5 },
    { 2033,   7,   7,    50,   6,0,  11 },
    { 2033,   7,  22,    50,   6,0,  26 },
    { 2033,   7,  25,    50,   6,0,  29 },
    { 2033,   7,  26,    50,   7,0,   1 },
    { 2033,   7,  27,    50,   7,0,   2 },
    { 2033,   7,  31,    50,   7,0,   6 },
    { 2033,   8,   1,    50,   7,0,   7 },
    { 2033,   8,   7,    50,   7,0,  13 },
    { 2033,   8,  23,    50,   7,0,  29 },
    { 2033,   8,  24,    50,   7,0,  30 },
    { 2033,   8,  25,    50,   8,0,   1 },
    { 2033,   8,  26,    50,   8,0,   2 },
    { 2033,   8,  31,    50,   8,0,   7 },
    { 2033,   9,   1,    50,   8,0,   8 },
    { 2033,   9,   7,    50,   8,0,  14 },
    { 2033,   9,  22,    50,   8,0,  29 },
    { 2033,   9,  23,    50,   9,0,   1 },
    { 2033,   9,  24,    50,   9,0,   2 },
    { 2033,   9,  30,    50,   9,0,   8 },
    { 2033,  10,   1,    50,   9,0,   9 },
    { 2033,  10,   8,    50,   9,0,  16 },
    { 2033,  10,  22,    50,   9,0,  30 },
    { 2033,  10,  23,    50,  10,0,   1 },
    { 2033,  10,  24,    50,  10,0,   2 },
    { 2033,  10,  31,    50,  10,0,   9 },
    { 2033,  11,   1,    50,  10,0,  10 },
    { 2033,  11,   7,    50,  10,0,  16 },
    { 2033,  11,  21,    50,  10,0,  30 },
    { 2033,  11,  22,    50,  11,0,   1 },
    { 2033,  11,  23,    50,  11,0,   2 },
    { 2033,  11,  30,    50,  11,0,   9 },
    { 2033,  12,   1,    50,  11,0,  10 },
    { 2033,  12,   7,    50,  11,0,  16 },
    { 2033,  12,  21,    50,  11,0,  30 },
    { 2033,  12,  22,    50,  11,1,   1 },
    { 2033,  12,  23,    50,  11,1,   2 },
    { 2033,  12,  31,    50,  11,1,  10 },
    { 2034,   1,   1,    50,  11,1,  11 },
    { 2034,   1,   5,    50,  11,1,  15 },
    { 2034,   1,  19,    50,  11,1,  29 },
    { 2034,   1,  20,    50,  12,0,   1 },
    { 2034,   1,  21,    50,  12,0,   2 },
    { 2034,   1,  31,    50,  12,0,  12 },
    { 2034,   2,   1,    50,  12,0,  13 },
    { 2034,   2,   4,    50,  12,0,  16 },
    { 2034,   2,  18,    50,  12,0,  30 },
    { 2034,   2,  19,    51,   1,0,   1 },
    { 2034,   2,  20,    51,   1,0,   2 },
    { 2034,   2,  28,    51,   1,0,  10 },
    { 2034,   3,   1,    51,   1,0,  11 },
    { 2034,   3,   5,    51,   1,0,  15 },
    { 2034,   3,  19,    51,   1,0,  29 },
    { 2034,   3,  20,    51,   2,0,   1 },
    { 2034,   3,  21,    51,   2,0,   2 },
    { 2034,   3,  31,    51,   2,0,  12 },
    { 2034,   4,   1,    51,   2,0,  13 },
    { 2034,   4,   5,    51,   2,0,  17 },
    { 2034,   4,  18,    51,   2,0,  30 },
    { 2034,   4,  19,    51,   3,0,   1 },
    { 2034,   4,  20,    51,   3,0,   2 },
    { 2034,   4,  30,    51,   3,0,  12 },
    { 2034,   5,   1,    51,   3,0,  13 },
    { 2034,   5,   5,    51,   3,0,  17 },
    { 2034,   5,  17,    51,   3,0,  29 },
    { 2034,   5,  18,    51,   4,0,   1 },
    { 2034,   5,  19,    51,   4,0,   2 },
    { 2034,   5,  21,    51,   4,0,   4 },
    { 2034,   5,  31,    51,   4,0,  14 },
    { 2034,   6,   1,    51,   4,0,  15 },
    { 2034,   6,   5,    51,   4,0,  19 },
    { 2034,   6,  15,    51,   4,0,  29 },
    { 2034,   6,  16,    51,   5,0,   1 },
    { 2034,   6,  17,    51,   5,0,   2 },
    { 2034,   6,  21,    51,   5,0,   6 },
    { 2034,   6,  30,    51,   5,0,  15 },
    { 2034,   7,   1,    51,   5,0,  16 },
    { 2034,   7,   7,    51,   5,0,  22 },
    { 2034,   7,  15,    51,   5,0,  30 },
    { 2034,   7,  16,    51,   6,0,   1 },
    { 2034,   7,  17,    51,   6,0,   2 },
    { 2034,   7,  23,    51,   6,0,   8 },
    { 2034,   7,  31,    51,   6,0,  16 },
    { 2034,   8,   1,    51,   6,0,  17 },
    { 2034,   8,   7,    51,   6,0,  23 },
    { 2034,   8,  13,    51,   6,0,  29 },
    { 2034,   8,  14,    51,   7,0,   1 },
    { 2034,   8,  15,    51,   7,0,   2 },
    { 2034,   8,  23,    51,   7,0,  10 },
    { 2034,   8,  31,    51,   7,0,  18 },
    { 2034,   9,   1,    51,   7,0,  19 },
    { 2034,   9,   7,    51,   7,0,  25 },
    { 2034,   9,  12,    51,   7,0,  30 },
    { 2034,   9,  13,    51,   8,0,   1 },
    { 2034,   9,  14,    51,   8,0,   2 },
    { 2034,   9,  23,    51,   8,0,  11 },
    { 2034,   9,  30,    51,   8,0,  18 },
    { 2034,  10,   1,    51,   8,0,  19 },
    { 2034,  10,   8,    51,   8,0,  26 },
    { 2034,  10,  11,    51,   8,0,  29 },
    { 2034,  10,  12,    51,   9,0,   1 },
    { 2034,  10,  13,    51,   9,0,   2 },
    { 2034,  10,  23,    51,   9,0,  12 },
    { 2034,  10,  31,    51,   9,0,  20 },
    { 2034,  11,   1,    51,   9,0,  21 },
    { 2034,  11,   7,    51,   9,0,  27 },
    { 2034,  11,  10,    51,   9,0,  30 },
    { 2034,  11,  11,    51,  10,0,   1 },
    { 2034,  11,  12,    51,  10,0,   2 },
    { 2034,  11,  22,    51,  10,0,  12 },
    { 2034,  11,  30,    51,  10,0,  20 },
    { 2034,  12,   1,    51,  10,0,  21 },
    { 2034,  12,   7,    51,  10,0,  27 },
    { 2034,  12,  10,    51,  10,0,  30 },
    { 2034,  12,  11,    51,  11,0,   1 },
    { 2034,  12,  12,    51,  11,0,   2 },
    { 2034,  12,  22,    51,  11,0,  12 },
    { 2034,  12,  31,    51,  11,0,  21 },
    { 2035,   1,   1,    51,  11,0,  22 },
    { 2035,   1,   5,    51,  11,0,  26 },
    { 2035,   1,   8,    51,  11,0,  29 },
    { 2035,   1,   9,    51,  12,0,   1 },
    { 2035,   1,  10,    51,  12,0,   2 },
    { 2035,   1,  20,    51,  12,0,  12 },
    { 2035,   1,  31,    51,  12,0,  23 },
    { 2035,   2,   1,    51,  12,0,  24 },
    { 2035,   2,   4,    51,  12,0,  27 },
    { 2035,   2,   7,    51,  12,0,  30 },
    { 2035,   2,   8,    52,   1,0,   1 },
    { 2035,   2,   9,    52,   1,0,   2 },
    { 2035,   2,  19,    52,   1,0,  12 },
    { 2035,   2,  28,    52,   1,0,  21 },
    { 2035,   3,   1,    52,   1,0,  22 },
    { 2035,   3,   6,    52,   1,0,  27 },
    { 2035,   3,   9,    52,   1,0,  30 },
    { 2035,   3,  10,    52,   2,0,   1 },
    { 2035,   3,  11,    52,   2,0,   2 },
    { 2035,   3,  21,    52,   2,0,  12 },
    { 2035,   3,  31,    52,   2,0,  22 },
    { 2035,   4,   1,    52,   2,0,  23 },
    { 2035,   4,   5,    52,   2,0,  27 },
    { 2035,   4,   7,    52,   2,0,  29 },
    { 2035,   4,   8,    52,   3,0,   1 },
    { 2035,   4,   9,    52,   3,0,   2 },
    { 2035,   4,  20,    52,   3,0,  13 },
    { 2035,   4,  30,    52,   3,0,  23 },
    { 2035,   5,   1,    52,   3,0,  24 },
    { 2035,   5,   5,    52,   3,0,  28 },
    { 2035,   5,   7,    52,   3,0,  30 },
    { 2035,   5,   8,    52,   4,0,   1 },
    { 2035,   5,   9,    52,   4,0,   2 },
    { 2035,   5,  21,    52,   4,0,  14 },
    { 2035,   5,  31,    52,   4,0,  24 },
    { 2035,   6,   1,    52,   4,0,  25 },
    { 2035,   6,   5,    52,   4,0,  29 },
    { 2035,   6,   6,    52,   5,0,   1 },
    { 2035,   6,   7,    52,   5,0,   2 },
    { 2035,   6,  21,    52,   5,0,  16 },
    { 2035,   6,  30,    52,   5,0,  25 },
    { 2035,   7,   1,    52,   5,0,  26 },
    { 2035,   7,   4,    52,   5,0,  29 },
    { 2035,   7,   5,    52,   6,0,   1 },
    { 2035,   7,   6,    52,   6,0,   2 },
    { 2035,   7,   7,    52,   6,0,   3 },
    { 2035,   7,  23,    52,   6,0,  19 },
    { 2035,   7,  31,    52,   6,0,  27 },
    { 2035,   8,   1,    52,   6,0,  28 },
    { 2035,   8,   3,    52,   6,0,  30 },
    { 2035,   8,   4,    52,   7,0,   1 },
    { 2035,   8,   5,    52,   7,0,   2 },
    { 2035,   8,   7,    52,   7,0,   4 },
    { 2035,   8,  23,    52,   7,0,  20 },
    { 2035,   9,   1,    52,   7,0,  29 },
    { 2035,   9,   2,    52,   8,0,   1 },
    { 2035,   9,   3,    52,   8,0,   2 },
    { 2035,   9,   8,    52,   8,0,   7 },
    { 2035,   9,  23,    52,   8,0,  22 },
    { 2035,   9,  30,    52,   8,0,  29 },
    { 2035,  10,   1,    52,   9,0,   1 },
    { 2035,  10,   8,    52,   9,0,   8 },
    { 2035,  10,  23,    52,   9,0,  23 },
    { 2035,  10,  30,    52,   9,0,  30 },
    { 2035,  10,  31,    52,  10,0,   1 },
    { 2035,  11,   1,    52,  10,0,   2 },
    { 2035,  11,   7,    52,  10,0,   8 },
    { 2035,  11,  22,    52,  10,0,  23 },
    { 2035,  11,  29,    52,  10,0,  30 },
    { 2035,  11,  30,    52,  11,0,   1 },
    { 2035,  12,   1,    52,  11,0,   2 },
    { 2035,  12,   7,    52,  11,0,   8 },
    { 2035,  12,  22,    52,  11,0,  23 },
    { 2035,  12,  28,    52,  11,0,  29 },
    { 2035,  12,  29,    52,  12,0,   1 },
    { 2035,  12,  30,    52,  12,0,   2 },
    { 2035,  12,  31,    52,  12,0,   3 },
    { 2036,   1,   1,    52,  12,0,   4 },
    { 2036,   1,   6,    52,  12,0,   9 },
    { 2036,   1,  20,    52,  12,0,  23 },
    { 2036,   1,  27,    52,  12,0,  30 },
    { 2036,   1,  28,    53,   1,0,   1 },
    { 2036,   1,  29,    53,   1,0,   2 },
    { 2036,   1,  31,    53,   1,0,   4 },
    { 2036,   2,   1,    53,   1,0,   5 },
    { 2036,   2,   4,    53,   1,0,   8 },
    { 2036,   2,  19,    53,   1,0,  23 },
    { 2036,   2,  26,    53,   1,0,  30 },
    { 2036,   2,  27,    53,   2,0,   1 },
    { 2036,   2,  28,    53,   2,0,   2 },
    { 2036,   2,  29,    53,   2,0,   3 },
    { 2036,   3,   1,    53,   2,0,   4 },
    { 2036,   3,   5,    53,   2,0,   8 },
    { 2036,   3,  20,    53,   2,0,  23 },
    { 2036,   3,  27,    53,   2,0,  30 },
    { 2036,   3,  28,    53,   3,0,   1 },
    { 2036,   3,  29,    53,   3,0,   2 },
    { 2036,   3,  31,    53,   3,0,   4 },
    { 2036,   4,   1,    53,   3,0,   5 },
    { 2036,   4,   4,    53,   3,0,   8 },
    { 2036,   4,  19,    53,   3,0,  23 },
    { 2036,   4,  25,    53,   3,0,  29 },
    { 2036,   4,  26,    53,   4,0,   1 },
    { 2036,   4,  27,    53,   4,0,   2 },
    { 2036,   4,  30,    53,   4,0,   5 },
    { 2036,   5,   1,    53,   4,0,   6 },
    { 2036,   5,   5,    53,   4,0,  10 },
    { 2036,   5,  20,    53,   4,0,  25 },
    { 2036,   5,  25,    53,   4,0,  30 },
    { 2036,   5,  26,    53,   5,0,   1 },
    { 2036,   5,  27,    53,   5,0,   2 },
    { 2036,   5,  31,    53,   5,0,   6 },
    { 2036,   6,   1,    53,   5,0,   7 },
    { 2036,   6,   5,    53,   5,0,  11 },
    { 2036,   6,  21,    53,   5,0,  27 },
    { 2036,   6,  23,    53,   5,0,  29 },
    { 2036,   6,  24,    53,   6,0,   1 },
    { 2036,   6,  25,    53,   6,0,   2 },
    { 2036,   6,  30,    53,   6,0,   7 },
    { 2036,   7,   1,    53,   6,0,   8 },
    { 2036,   7,   6,    53,   6,0,  13 },
    { 2036,   7,  22,    53,   6,0,  29 },
    { 2036,   7,  23,    53,   6,1,   1 },
    { 2036,   7,  24,    53,   6,1,   2 },
    { 2036,   7,  31,    53,   6,1,   9 },
    { 2036,   8,   1,    53,   6,1,  10 },
    { 2036,   8,   7,    53,   6,1,  16 },
    { 2036,   8,  21,    53,   6,1,  30 },
    { 2036,   8,  22,    53,   7,0,   1 },
    { 2036,   8,  23,    53,   7,0,   2 },
    { 2036,   8,  31,    53,   7,0,  10 },
    { 2036,   9,   1,    53,   7,0,  11 },
    { 2036,   9,   7,    53,   7,0,  17 },
    { 2036,   9,  19,    53,   7,0,  29 },
    { 2036,   9,  20,    53,   8,0,   1 },
    { 2036,   9,  21,    53,   8,0,   2 },
    { 2036,   9,  22,    53,   8,0,   3 },
    { 2036,   9,  30,    53,   8,0,  11 },
    { 2036,  10,   1,    53,   8,0,  12 },
    { 2036,  10,   8,    53,   8,0,  19 },
    { 2036,  10,  18,    53,   8,0,  29 },
    { 2036,  10,  19,    53,   9,0,   1 },
    { 2036,  10,  20,    53,   9,0,   2 },
    { 2036,  10,  23,    53,   9,0,   5 },
    { 2036,  10,  31,    53,   9,0,  13 },
    { 2036,  11,   1,    53,   9,0,  14 },
    { 2036,  11,   7,    53,   9,0,  20 },
    { 2036,  11,  17,    53,   9,0,  30 },
    { 2036,  11,  18,    53,  10,0,   1 },
    { 2036,  11,  19,    53,  10,0,   2 },
    { 2036,  11,  22,    53,  10,0,   5 },
    { 2036,  11,  30,    53,  10,0,  13 },
    { 2036,  12,   1,    53,  10,0,  14 },
    { 2036,  12,   6,    53,  10,0,  19 },
    { 2036,  12,  16,    53,  10,0,  29 },
    { 2036,  12,  17,    53,  11,0,   1 },
    { 2036,  12,  18,    53,  11,0,   2 },
    { 2036,  12,  21,    53,  11,0,   5 },
    { 2036,  12,  31,    53,  11,0,  15 },
    { 2037,   1,   1,    53,  11,0,  16 },
    { 2037,   1,   5,    53,  11,0,  20 },
    { 2037,   1,  15,    53,  11,0,  30 },
    { 2037,   1,  16,    53,  12,0,   1 },
    { 2037,   1,  17,    53,  12,0,   2 },
    { 2037,   1,  20,    53,  12,0,   5 },
    { 2037,   1,  31,    53,  12,0,  16 },
    { 2037,   2,   1,    53,  12,0,  17 },
    { 2037,   2,   3,    53,  12,0,  19 },
    { 2037,   2,  14,    53,  12,0,  30 },
    { 2037,   2,  15,    54,   1,0,   1 },
    { 2037,   2,  16,    54,   1,0,   2 },
    { 2037,   2,  18,    54,   1,0,   4 },
    { 2037,   2,  28,    54,   1,0,  14 },
    { 2037,   3,   1,    54,   1,0,  15 },
    { 2037,   3,   5,    54,   1,0,  19 },
    { 2037,   3,  16,    54,   1,0,  30 },
    { 2037,   3,  17,    54,   2,0,   1 },
    { 2037,   3,  18,    54,   2,0,   2 },
    { 2037,   3,  20,    54,   2,0,   4 },
    { 2037,   3,  31,    54,   2,0,  15 },
    { 2037,   4,   1,    54,   2,0,  16 },
    { 2037,   4,   4,    54,   2,0,  19 },
    { 2037,   4,  15,    54,   2,0,  30 },
    { 2037,   4,  16,    54,   3,0,   1 },
    { 2037,   4,  17,    54,   3,0,   2 },
    { 2037,   4,  20,    54,   3,0,   5 },
    { 2037,   4,  30,    54,   3,0,  15 },
    { 2037,   5,   1,    54,   3,0,  16 },
    { 2037,   5,   5,    54,   3,0,  20 },
    { 2037,   5,  14,    54,   3,0,  29 },
    { 2037,   5,  15,    54,   4,0,   1 },
    { 2037,   5,  16,    54,   4,0,   2 },
    { 2037,   5,  21,    54,   4,0,   7 },
    { 2037,   5,  31,    54,   4,0,  17 },
    { 2037,   6,   1,    54,   4,0,  18 },
    { 2037,   6,   5,    54,   4,0,  22 },
    { 2037,   6,  13,    54,   4,0,  30 },
    { 2037,   6,  14,    54,   5,0,   1 },
    { 2037,   6,  15,    54,   5,0,   2 },
    { 2037,   6,  21,    54,   5,0,   8 },
    { 2037,   6,  30,    54,   5,0,  17 },
    { 2037,   7,   1,    54,   5,0,  18 },
    { 2037,   7,   7,    54,   5,0,  24 },
    { 2037,   7,  12,    54,   5,0,  29 },
    { 2037,   7,  13,    54,   6,0,   1 },
    { 2037,   7,  14,    54,   6,0,   2 },
    { 2037,   7,  22,    54,   6,0,  10 },
    { 2037,   7,  31,    54,   6,0,  19 },
    { 2037,   8,   1,    54,   6,0,  20 },
    { 2037,   8,   7,    54,   6,0,  26 },
    { 2037,   8,  10,    54,   6,0,  29 },
    { 2037,   8,  11,    54,   7,0,   1 },
    { 2037,   8,  12,    54,   7,0,   2 },
    { 2037,   8,  23,    54,   7,0,  13 },
    { 2037,   8,  31,    54,   7,0,  21 },
    { 2037,   9,   1,    54,   7,0,  22 },
    { 2037,   9,   7,    54,   7,0,  28 },
    { 2037,   9,   9,    54,   7,0,  30 },
    { 2037,   9,  10,    54,   8,0,   1 },
    { 2037,   9,  11,    54,   8,0,   2 },
    { 2037,   9,  23,    54,   8,0,  14 },
    { 2037,   9,  30,    54,   8,0,  21 },
    { 2037,  10,   1,    54,   8,0,  22 },
    { 2037,  10,   8,    54,   8,0,  29 },
    { 2037,  10,   9,    54,   9,0,   1 },
    { 2037,  10,  10,    54,   9,0,   2 },
    { 2037,  10,  23,    54,   9,0,  15 },
    { 2037,  10,  31,    54,   9,0,  23 },
    { 2037,  11,   1,    54,   9,0,  24 },
    { 2037,  11,   6,    54,   9,0,  29 },
    { 2037,  11,   7,    54,  10,0,   1 },
    { 2037,  11,   8,    54,  10,0,   2 },
    { 2037,  11,  22,    54,  10,0,  16 },
    { 2037,  11,  30,    54,  10,0,  24 },
    { 2037,  12,   1,    54,  10,0,  25 },
    { 2037,  12,   6,    54,  10,0,  30 },
    { 2037,  12,   7,    54,  11,0,   1 },
    { 2037,  12,   8,    54,  11,0,   2 },
    { 2037,  12,  21,    54,  11,0,  15 },
    { 2037,  12,  31,    54,  11,0,  25 },
    { 2038,   1,   1,    54,  11,0,  26 },
    { 2038,   1,   4,    54,  11,0,  29 },
    { 2038,   1,   5,    54,  12,0,   1 },
    { 2038,   1,   6,    54,  12,0,   2 },
    { 2038,   1,  20,    54,  12,0,  16 },
    { 2038,   1,  31,    54,  12,0,  27 },
    { 2038,   2,   1,    54,  12,0,  28 },
    { 2038,   2,   3,    54,  12,0,  30 },
    { 2038,   2,   4,    55,   1,0,   1 },
    { 2038,   2,   5,    55,   1,0,   2 },
    { 2038,   2,  18,    55,   1,0,  15 },
    { 2038,   2,  28,    55,   1,0,  25 },
    { 2038,   3,   1,    55,   1,0,  26 },
    { 2038,   3,   5,    55,   1,0,  30 },
    { 2038,   3,   6,    55,   2,0,   1 },
    { 2038,   3,   7,    55,   2,0,   2 },
    { 2038,   3,  20,    55,   2,0,  15 },
    { 2038,   3,  31,    55,   2,0,  26 },
    { 2038,   4,   1,    55,   2,0,  27 },
    { 2038,   4,   4,    55,   2,0,  30 },
    { 2038,   4,   5,    55,   3,0,   1 },
    { 2038,   4,   6,    55,   3,0,   2 },
    { 2038,   4,  20,    55,   3,0,  16 },
    { 2038,   4,  30,    55,   3,0,  26 },
    { 2038,   5,   1,    55,   3,0,  27 },
    { 2038,   5,   3,    55,   3,0,  29 },
    { 2038,   5,   4,    55,   4,0,   1 },
    { 2038,   5,   5,    55,   4,0,   2 },
    { 2038,   5,  21,    55,   4,0,  18 },
    { 2038,   6,   2,    55,   4,0,  30 },
    { 2038,   6,   3,    55,   5,0,   1 },
    { 2038,   6,   4,    55,   5,0,   2 },
    { 2038,   6,   5,    55,   5,0,   3 },
    { 2038,   6,  21,    55,   5,0,  19 },
    { 2038,   7,   1,    55,   5,0,  29 },
    { 2038,   7,   2,    55,   6,0,   1 },
    { 2038,   7,   3,    55,   6,0,   2 },
    { 2038,   7,   7,    55,   6,0,   6 },
    { 2038,   7,  23,    55,   6,0,  22 },
    { 2038,   7,  31,    55,   6,0,  30 },
    { 2038,   8,   1,    55,   7,0,   1 },
    { 2038,   8,   7,    55,   7,0,   7 },
    { 2038,   8,  23,    55,   7,0,  23 },
    { 2038,   8,  29,    55,   7,0,  29 },
    { 2038,   8,  30,    55,   8,0,   1 },
    { 2038,   8,  31,    55,   8,0,   2 },
    { 2038,   9,   1,    55,   8,0,   3 },
    { 2038,   9,   7,    55,   8,0,   9 },
    { 2038,   9,  23,    55,   8,0,  25 },
    { 2038,   9,  28,    55,   8,0,  30 },
    { 2038,   9,  29,    55,   9,0,   1 },
    { 2038,   9,  30,    55,   9,0,   2 },
    { 2038,  10,   1,    55,   9,0,   3 },
    { 2038,  10,   8,    55,   9,0,  10 },
    { 2038,  10,  23,    55,   9,0,  25 },
    { 2038,  10,  27,    55,   9,0,  29 },
    { 2038,  10,  28,    55,  10,0,   1 },
    { 2038,  10,  29,    55,  10,0,   2 },
    { 2038,  10,  31,    55,  10,0,   4 },
    { 2038,  11,   1,    55,  10,0,   5 },
    { 2038,  11,   7,    55,  10,0,  11 },
    { 2038,  11,  22,    55,  10,0,  26 },
    { 2038,  11,  25,    55,  10,0,  29 },
    { 2038,  11,  26,    55,  11,0,   1 },
    { 2038,  11,  27,    55,  11,0,   2 },
    { 2038,  11,  30,    55,  11,0,   5 },
    { 2038,  12,   1,    55,  11,0,   6 },
    { 2038,  12,   7,    55,  11,0,  12 },
    { 2038,  12,  22,    55,  11,0,  27 },
    { 2038,  12,  25,    55,  11,0,  30 },
    { 2038,  12,  26,    55,  12,0,   1 },
    { 2038,  12,  27,    55,  12,0,   2 },
    { 2038,  12,  31,    55,  12,0,   6 },
    { 2039,   1,   1,    55,  12,0,   7 },
    { 2039,   1,   5,    55,  12,0,  11 },
    { 2039,   1,  20,    55,  12,0,  26 },
    { 2039,   1,  23,    55,  12,0,  29 },
    { 2039,   1,  24,    56,   1,0,   1 },
    { 2039,   1,  25,    56,   1,0,   2 },
    { 2039,   1,  31,    56,   1,0,   8 },
    { 2039,   2,   1,    56,   1,0,   9 },
    { 2039,   2,   4,    56,   1,0,  12 },
    { 2039,   2,  19,    56,   1,0,  27 },
    { 2039,   2,  22,    56,   1,0,  30 },
    { 2039,   2,  23,    56,   2,0,   1 },
    { 2039,   2,  24,    56,   2,0,   2 },
    { 2039,   2,  28,    56,   2,0,   6 },
    { 2039,   3,   1,    56,   2,0,   7 },
    { 2039,   3,   6,    56,   2,0,  12 },
    { 2039,   3,  21,    56,   2,0,  27 },
    { 2039,   3,  24,    56,   2,0,  30 },
    { 2039,   3,  25,    56,   3,0,   1 },
    { 2039,   3,  26,    56,   3,0,   2 },
    { 2039,   3,  31,    56,   3,0,   7 },
    { 2039,   4,   1,    56,   3,0,   8 },
    { 2039,   4,   5,    56,   3,0,  12 },
    { 2039,   4,  20,    56,   3,0,  27 },
    { 2039,   4,  22,    56,   3,0,  29 },
    { 2039,   4,  23,    56,   4,0,   1 },
    { 2039,   4,  24,    56,   4,0,   2 },
    { 2039,   4,  30,    56,   4,0,   8 },
    { 2039,   5,   1,    56,   4,0,   9 },
    { 2039,   5,   5,    56,   4,0,  13 },
    { 2039,   5,  21,    56,   4,0,  29 },
    { 2039,   5,  22,    56,   4,0,  30 },
    { 2039,   5,  23,    56,   5,0,   1 },
    { 2039,   5,  24,    56,   5,0,   2 },
    { 2039,   5,  31,    56,   5,0,   9 },
    { 2039,   6,   1,    56,   5,0,  10 },
    { 2039,   6,   6,    56,   5,0,  15 },
    { 2039,   6,  21,    56,   5,0,  30 },
    { 2039,   6,  22,    56,   5,1,   1 },
    { 2039,   6,  23,    56,   5,1,   2 },
    { 2039,   6,  30,    56,   5,1,   9 },
    { 2039,   7,   1,    56,   5,1,  10 },
    { 2039,   7,   7,    56,   5,1,  16 },
    { 2039,   7,  20,    56,   5,1,  29 },
    { 2039,   7,  21,    56,   6,0,   1 },
    { 2039,   7,  22,    56,   6,0,   2 },
    { 2039,   7,  23,    56,   6,0,   3 },
    { 2039,   7,  31,    56,   6,0,  11 },
    { 2039,   8,   1,    56,   6,0,  12 },
    { 2039,   8,   7,    56,   6,0,  18 },
    { 2039,   8,  19,    56,   6,0,  30 },
    { 2039,   8,  20,    56,   7,0,   1 },
    { 2039,   8,  21,    56,   7,0,   2 },
    { 2039,   8,  23,    56,   7,0,   4 },
    { 2039,   8,  31,    56,   7,0,  12 },
    { 2039,   9,   1,    56,   7,0,  13 },
    { 2039,   9,   8,    56,   7,0,  20 },
    { 2039,   9,  17,    56,   7,0,  29 },
    { 2039,   9,  18,    56,   8,0,   1 },
    { 2039,   9,  19,    56,   8,0,   2 },
    { 2039,   9,  23,    56,   8,0,   6 },
    { 2039,   9,  30,    56,   8,0,  13 },
    { 2039,  10,   1,    56,   8,0,  14 },
    { 2039,  10,   8,    56,   8,0,  21 },
    { 2039,  10,  17,    56,   8,0,  30 },
    { 2039,  10,  18,    56,   9,0,   1 },
    { 2039,  10,  19,    56,   9,0,   2 },
    { 2039,  10,  23,    56,   9,0,   6 },
    { 2039,  10,  31,    56,   9,0,  14 },
    { 2039,  11,   1,    56,   9,0,  15 },
    { 2039,  11,   7,    56,   9,0,  21 },
    { 2039,  11,  15,    56,   9,0,  29 },
    { 2039,  11,  16,    56,  10,0,   1 },
    { 2039,  11,  17,    56,  10,0,   2 },
    { 2039,  11,  22,    56,  10,0,   7 },
    { 2039,  11,  30,    56,  10,0,  15 },
    { 2039,  12,   1,    56,  10,0,  16 },
    { 2039,  12,   7,    56,  10,0,  22 },
    { 2039,  12,  15,    56,  10,0,  30 },
    { 2039,  12,  16,    56,  11,0,   1 },
    { 2039,  12,  17,    56,  11,0,   2 },
    { 2039,  12,  22,    56,  11,0,   7 },
    { 2039,  12,  31,    56,  11,0,  16 },
    { 2040,   1,   1,    56,  11,0,  17 },
    { 2040,   1,   6,    56,  11,0,  22 },
    { 2040,   1,  13,    56,  11,0,  29 },
    { 2040,   1,  14,    56,  12,0,   1 },
    { 2040,   1,  15,    56,  12,0,   2 },
    { 2040,   1,  20,    56,  12,0,   7 },
    { 2040,   1,  31,    56,  12,0,  18 },
    { 2040,   2,   1,    56,  12,0,  19 },
    { 2040,   2,   4,    56,  12,0,  22 },
    { 2040,   2,  11,    56,  12,0,  29 },
    { 2040,   2,  12,    57,   1,0,   1 },
    { 2040,   2,  13,    57,   1,0,   2 },
    { 2040,   2,  19,    57,   1,0,   8 },
    { 2040,   2,  29,    57,   1,0,  18 },
    { 2040,   3,   1,    57,   1,0,  19 },
    { 2040,   3,   5,    57,   1,0,  23 },
    { 2040,   3,  12,    57,   1,0,  30 },
    { 2040,   3,  13,    57,   2,0,   1 },
    { 2040,   3,  14,    57,   2,0,   2 },
    { 2040,   3,  20,    57,   2,0,   8 },
    { 2040,   3,  31,    57,   2,0,  19 },
    { 2040,   4,   1,    57,   2,0,  20 },
    { 2040,   4,   4,    57,   2,0,  23 },
    { 2040,   4,  10,    57,   2,0,  29 },
    { 2040,   4,  11,    57,   3,0,   1 },
    { 2040,   4,  12,    57,   3,0,   2 },
    { 2040,   4,  19,    57,   3,0,   9 },
    { 2040,   4,  30,    57,   3,0,  20 },
    { 2040,   5,   1,    57,   3,0,  21 },
    { 2040,   5,   5,    57,   3,0,  25 },
    { 2040,   5,  10,    57,   3,0,  30 },
    { 2040,   5,  11,    57,   4,0,   1 },
    { 2040,   5,  12,    57,   4,0,   2 },
    { 2040,   5,  20,    57,   4,0,  10 },
    { 2040,   5,  31,    57,   4,0,  21 },
    { 2040,   6,   1,    57,   4,0,  22 },
    { 2040,   6,   5,    57,   4,0,  26 },
    { 2040,   6,   9,    57,   4,0,  30 },
    { 2040,   6,  10,    57,   5,0,   1 },
    { 2040,   6,  11,    57,   5,0,   2 },
    { 2040,   6,  21,    57,   5,0,  12 },
    { 2040,   6,  30,    57,   5,0,  21 },
    { 2040,   7,   1,    57,   5,0,  22 },
    { 2040,   7,   6,    57,   5,0,  27 },
    { 2040,   7,   8,    57,   5,0,  29 },
    { 2040,   7,   9,    57,   6,0,   1 },
    { 2040,   7,  10,    57,   6,0,   2 },
    { 2040,   7,  22,    57,   6,0,  14 },
    { 2040,   7,  31,    57,   6,0,  23 },
    { 2040,   8,   1,    57,   6,0,  24 },
    { 2040,   8,   7,    57,   6,0,  30 },
    { 2040,   8,   8,    57,   7,0,   1 },
    { 2040,   8,   9,    57,   7,0,   2 },
    { 2040,   8,  22,    57,   7,0,  15 },
    { 2040,   8,  31,    57,   7,0,  24 },
    { 2040,   9,   1,    57,   7,0,  25 },
    { 2040,   9,   5,    57,   7,0,  29 },
    { 2040,   9,   6,    57,   8,0,   1 },
    { 2040,   9,   7,    57,   8,0,   2 },
    { 2040,   9,  22,    57,   8,0,  17 },
    { 2040,   9,  30,    57,   8,0,  25 },
    { 2040,  10,   1,    57,   8,0,  26 },
    { 2040,  10,   5,    57,   8,0,  30 },
    { 2040,  10,   6,    57,   9,0,   1 },
    { 2040,  10,   7,    57,   9,0,   2 },
    { 2040,  10,   8,    57,   9,0,   3 },
    { 2040,  10,  23,    57,   9,0,  18 },
    { 2040,  10,  31,    57,   9,0,  26 },
    { 2040,  11,   1,    57,   9,0,  27 },
    { 2040,  11,   4,    57,   9,0,  30 },
    { 2040,  11,   5,    57,  10,0,   1 },
    { 2040,  11,   6,    57,  10,0,   2 },
    { 2040,  11,   7,    57,  10,0,   3 },
    { 2040,  11,  22,    57,  10,0,  18 },
    { 2040,  11,  30,    57,  10,0,  26 },
    { 2040,  12,   1,    57,  10,0,  27 },
    { 2040,  12,   3,    57,  10,0,  29 },
    { 2040,  12,   4,    57,  11,0,   1 },
    { 2040,  12,   5,    57,  11,0,   2 },
    { 2040,  12,   6,    57,  11,0,   3 },
    { 2040,  12,  21,    57,  11,0,  18 },
    { 2040,  12,  30,    57,  11,0,  27 },
    { 2040,  12,  31,    57,  11,0,  28 },

    { 2041,   1,   1,    57,  11,0,  29 },
    { 2041,   1,   2,    57,  11,0,  30 },
    { 2041,   1,   3,    57,  12,0,   1 },

    { 0,      0,   0,     0,   0,0,   0 } // terminator
};

#endif  // INCLUDED_FROM_CALTEST_CPP
