#include <linux/ipc.h>
#include <linux/mount.h>
#include <linux/net.h>

static const QMap<ulong, QString> signalMap = {
    {0, QStringLiteral("SIG0")},       {1, QStringLiteral("SIGHUP")},   {2, QStringLiteral("SIGINT")},     {3, QStringLiteral("SIGQUIT")},
    {4, QStringLiteral("SIGILL")},     {5, QStringLiteral("SIGTRAP")},  {6, QStringLiteral("SIGABRT")},    {7, QStringLiteral("SIGBUS")},
    {8, QStringLiteral("SIGFPE")},     {9, QStringLiteral("SIGKILL")},  {10, QStringLiteral("SIGUSR1")},   {11, QStringLiteral("SIGSEGV")},
    {12, QStringLiteral("SIGUSR2")},   {13, QStringLiteral("SIGPIPE")}, {14, QStringLiteral("SIGALRM")},   {15, QStringLiteral("SIGTERM")},
    {16, QStringLiteral("SIGSTKFLT")}, {17, QStringLiteral("SIGCHLD")}, {18, QStringLiteral("SIGCONT")},   {19, QStringLiteral("SIGSTOP")},
    {20, QStringLiteral("SIGTSTP")},   {21, QStringLiteral("SIGTTIN")}, {22, QStringLiteral("SIGTTOU")},   {23, QStringLiteral("SIGURG")},
    {24, QStringLiteral("SIGXCPU")},   {25, QStringLiteral("SIGXFSZ")}, {26, QStringLiteral("SIGVTALRM")}, {27, QStringLiteral("SIGPROF")},
    {28, QStringLiteral("SIGWINCH")},  {29, QStringLiteral("SIGIO")},   {30, QStringLiteral("IGPWR")},     {31, QStringLiteral("SIGSYS")}};

static const QMap<ulong, QString> cloneFlagMap = {{0x00000100, QStringLiteral("CLONE_VM")},
                                                  {0x00000200, QStringLiteral("CLONE_FS")},
                                                  {0x00000400, QStringLiteral("CLONE_FILES")},
                                                  {0x00000800, QStringLiteral("CLONE_SIGHAND")},
                                                  {0x00002000, QStringLiteral("CLONE_PTRACE")},
                                                  {0x00004000, QStringLiteral("CLONE_VFORK")},
                                                  {0x00008000, QStringLiteral("CLONE_PARENT")},
                                                  {0x00010000, QStringLiteral("CLONE_THREAD")},
                                                  {0x00020000, QStringLiteral("CLONE_NEWNS")},
                                                  {0x00040000, QStringLiteral("CLONE_SYSVSEM")},
                                                  {0x00080000, QStringLiteral("CLONE_SETTLS")},
                                                  {0x00100000, QStringLiteral("CLONE_PARENT_SETTID")},
                                                  {0x00200000, QStringLiteral("CLONE_CHILD_CLEARTID")},
                                                  {0x00400000, QStringLiteral("CLONE_DETACHED")},
                                                  {0x00800000, QStringLiteral("CLONE_UNTRACED")},
                                                  {0x01000000, QStringLiteral("CLONE_CHILD_SETTID")},
                                                  {0x02000000, QStringLiteral("CLONE_STOPPED")},
                                                  {0x04000000, QStringLiteral("CLONE_NEWUTS")},
                                                  {0x08000000, QStringLiteral("CLONE_NEWIPC")},
                                                  {0x10000000, QStringLiteral("CLONE_NEWUSER")},
                                                  {0x20000000, QStringLiteral("CLONE_NEWPID")},
                                                  {0x40000000, QStringLiteral("CLONE_NEWNET")},
                                                  {0x80000000, QStringLiteral("CLONE_IO")},
                                                  {0x00000000, QStringLiteral("CLONE_CLEAR_SIGHAND")}};

static const QMap<ulong, QString> clockMap = {{0, QStringLiteral("CLOCK_REALTIME")},
                                              {1, QStringLiteral("CLOCK_MONOTONIC")},
                                              {2, QStringLiteral("CLOCK_PROCESS_CPUTIME_ID")},
                                              {3, QStringLiteral("CLOCK_THREAD_CPUTIME_ID")},
                                              {4, QStringLiteral("CLOCK_MONOTONIC_RAW")},
                                              {5, QStringLiteral("CLOCK_REALTIME_COARSE")},
                                              {6, QStringLiteral("CLOCK_MONOTONIC_COARSE")},
                                              {7, QStringLiteral("CLOCK_BOOTTIME")},
                                              {8, QStringLiteral("CLOCK_REALTIME_ALARM")},
                                              {9, QStringLiteral("CLOCK_BOOTTIME_ALARM")},
                                              {10, QStringLiteral("CLOCK_SGI_CYCLE")},
                                              {11, QStringLiteral("CLOCK_TAI")}};

static const QMap<ulong, QString> personMap = {{0x0000, QStringLiteral("PER_LINUX")},
                                               {0x0000 | ADDR_LIMIT_32BIT, QStringLiteral("PER_LINUX_32BIT")},
                                               {0x0001 | STICKY_TIMEOUTS | MMAP_PAGE_ZERO, QStringLiteral("PER_SVR4")},
                                               {0x0002 | STICKY_TIMEOUTS | SHORT_INODE, QStringLiteral("PER_SVR3")},
                                               {0x0003 | STICKY_TIMEOUTS | WHOLE_SECONDS | SHORT_INODE, QStringLiteral("PER_SCOSVR3")},
                                               {0x0003 | STICKY_TIMEOUTS | WHOLE_SECONDS, QStringLiteral("PER_OSR5")},
                                               {0x0004 | STICKY_TIMEOUTS | SHORT_INODE, QStringLiteral("PER_WYSEV386")},
                                               {0x0005 | STICKY_TIMEOUTS, QStringLiteral("PER_ISCR4")},
                                               {0x0006, QStringLiteral("PER_BSD")},
                                               {0x0006 | STICKY_TIMEOUTS, QStringLiteral("PER_SUNOS")},
                                               {0x0007 | STICKY_TIMEOUTS | SHORT_INODE, QStringLiteral("PER_XENIX")},
                                               {0x0008, QStringLiteral("PER_LINUX32")},
                                               {0x0008 | ADDR_LIMIT_3GB, QStringLiteral("PER_LINUX32_3GB")},
                                               {0x0009 | STICKY_TIMEOUTS, QStringLiteral("PER_IRIX32")},
                                               {0x000a | STICKY_TIMEOUTS, QStringLiteral("PER_IRIXN32")},
                                               {0x000b | STICKY_TIMEOUTS, QStringLiteral("PER_IRIX64")},
                                               {0x000c, QStringLiteral("PER_RISCOS")},
                                               {0x000d | STICKY_TIMEOUTS, QStringLiteral("PER_SOLARIS")},
                                               {0x000e | STICKY_TIMEOUTS | MMAP_PAGE_ZERO, QStringLiteral("PER_UW7")},
                                               {0x000f, QStringLiteral("PER_OSF4")},
                                               {0x0010, QStringLiteral("PER_HPUX")}};

static const QMap<ulong, QString> ptraceMap = {{0, QStringLiteral("PTRACE_TRACEME")},
                                               {1, QStringLiteral("PTRACE_PEEKTEXT")},
                                               {2, QStringLiteral("PTRACE_PEEKDATA")},
                                               {3, QStringLiteral("PTRACE_PEEKUSER")},
                                               {4, QStringLiteral("PTRACE_POKETEXT")},
                                               {5, QStringLiteral("PTRACE_POKEDATA")},
                                               {6, QStringLiteral("PTRACE_POKEUSER")},
                                               {7, QStringLiteral("PTRACE_CONT")},
                                               {8, QStringLiteral("PTRACE_KILL")},
                                               {9, QStringLiteral("PTRACE_SINGLESTEP")},
                                               {12, QStringLiteral("PTRACE_GETREGS")},
                                               {13, QStringLiteral("PTRACE_SETREGS")},
                                               {14, QStringLiteral("PTRACE_GETFPREGS")},
                                               {15, QStringLiteral("PTRACE_SETFPREGS")},
                                               {16, QStringLiteral("PTRACE_ATTACH")},
                                               {17, QStringLiteral("PTRACE_DETACH")},
                                               {18, QStringLiteral("PTRACE_GETFPXREGS")},
                                               {19, QStringLiteral("PTRACE_SETFPXREGS")},
                                               {24, QStringLiteral("PTRACE_SYSCALL")},
                                               {25, QStringLiteral("PTRACE_GET_THREAD_AREA")},
                                               {26, QStringLiteral("PTRACE_SET_THREAD_AREA")},
                                               {30, QStringLiteral("PTRACE_ARCH_PRCTL")},
                                               {31, QStringLiteral("PTRACE_SYSEMU")},
                                               {32, QStringLiteral("PTRACE_SYSEMU_SINGLESTEP")},
                                               {33, QStringLiteral("PTRACE_SINGLEBLOCK")},
                                               {0x4200, QStringLiteral("PTRACE_SETOPTIONS")},
                                               {0x4201, QStringLiteral("PTRACE_GETEVENTMSG")},
                                               {0x4202, QStringLiteral("PTRACE_GETSIGINFO")},
                                               {0x4203, QStringLiteral("PTRACE_SETSIGINFO")},
                                               {0x4204, QStringLiteral("PTRACE_GETREGSET")},
                                               {0x4205, QStringLiteral("PTRACE_SETREGSET")},
                                               {0x4206, QStringLiteral("PTRACE_SEIZE")},
                                               {0x4207, QStringLiteral("PTRACE_INTERRUPT")},
                                               {0x4208, QStringLiteral("PTRACE_LISTEN")},
                                               {0x4209, QStringLiteral("PTRACE_PEEKSIGINFO")},
                                               {0x420a, QStringLiteral("PTRACE_GETSIGMASK")},
                                               {0x420b, QStringLiteral("PTRACE_SETSIGMASK")},
                                               {0x420c, QStringLiteral("PTRACE_SECCOMP_GET_FILTER")},
                                               {0x420d, QStringLiteral("PTRACE_SECCOMP_GET_METADATA")},
                                               {0x420e, QStringLiteral("PTRACE_GET_SYSCALL_INFO")}};

static const QMap<ulong, QString> prctloptMap = {{1, QStringLiteral("PR_SET_PDEATHSIG")},
                                                 {2, QStringLiteral("PR_GET_PDEATHSIG")},
                                                 {3, QStringLiteral("PR_GET_DUMPABLE")},
                                                 {4, QStringLiteral("PR_SET_DUMPABLE")},
                                                 {5, QStringLiteral("PR_GET_UNALIGN")},
                                                 {6, QStringLiteral("PR_SET_UNALIGN")},
                                                 {7, QStringLiteral("PR_GET_KEEPCAPS")},
                                                 {8, QStringLiteral("PR_SET_KEEPCAPS")},
                                                 {9, QStringLiteral("PR_GET_FPEMU")},
                                                 {10, QStringLiteral("PR_SET_FPEMU")},
                                                 {11, QStringLiteral("PR_GET_FPEXC")},
                                                 {12, QStringLiteral("PR_SET_FPEXC")},
                                                 {13, QStringLiteral("PR_GET_TIMING")},
                                                 {14, QStringLiteral("PR_SET_TIMING")},
                                                 {15, QStringLiteral("PR_SET_NAME")},
                                                 {16, QStringLiteral("PR_GET_NAME")},
                                                 {19, QStringLiteral("PR_GET_ENDIAN")},
                                                 {20, QStringLiteral("PR_SET_ENDIAN")},
                                                 {21, QStringLiteral("PR_GET_SECCOMP")},
                                                 {22, QStringLiteral("PR_SET_SECCOMP")},
                                                 {23, QStringLiteral("PR_CAPBSET_READ")},
                                                 {24, QStringLiteral("PR_CAPBSET_DROP")},
                                                 {25, QStringLiteral("PR_GET_TSC")},
                                                 {26, QStringLiteral("PR_SET_TSC")},
                                                 {27, QStringLiteral("PR_GET_SECUREBITS")},
                                                 {28, QStringLiteral("PR_SET_SECUREBITS")},
                                                 {29, QStringLiteral("PR_SET_TIMERSLACK")},
                                                 {30, QStringLiteral("PR_GET_TIMERSLACK")},
                                                 {31, QStringLiteral("PR_TASK_PERF_EVENTS_DISABLE")},
                                                 {32, QStringLiteral("PR_TASK_PERF_EVENTS_ENABLE")},
                                                 {33, QStringLiteral("PR_MCE_KILL")},
                                                 {34, QStringLiteral("PR_MCE_KILL_GET")},
                                                 {35, QStringLiteral("PR_SET_MM")},
                                                 {36, QStringLiteral("PR_SET_CHILD_SUBREAPER")},
                                                 {37, QStringLiteral("PR_GET_CHILD_SUBREAPER")},
                                                 {38, QStringLiteral("PR_SET_NO_NEW_PRIVS")},
                                                 {39, QStringLiteral("PR_GET_NO_NEW_PRIVS")},
                                                 {40, QStringLiteral("PR_GET_TID_ADDRESS")},
                                                 {41, QStringLiteral("PR_SET_THP_DISABLE")},
                                                 {42, QStringLiteral("PR_GET_THP_DISABLE")},
                                                 {43, QStringLiteral("PR_MPX_ENABLE_MANAGEMENT")},
                                                 {44, QStringLiteral("PR_MPX_DISABLE_MANAGEMENT")},
                                                 {45, QStringLiteral("PR_SET_FP_MODE")},
                                                 {46, QStringLiteral("PR_GET_FP_MODE")},
                                                 {47, QStringLiteral("PR_CAP_AMBIENT")},
                                                 {50, QStringLiteral("PR_SVE_SET_VL")},
                                                 {51, QStringLiteral("PR_SVE_GET_VL")},
                                                 {52, QStringLiteral("PR_GET_SPECULATION_CTRL")},
                                                 {53, QStringLiteral("PR_SET_SPECULATION_CTRL")},
                                                 {54, QStringLiteral("PR_PAC_RESET_KEYS")},
                                                 {55, QStringLiteral("PR_SET_TAGGED_ADDR_CTRL")},
                                                 {56, QStringLiteral("PR_GET_TAGGED_ADDR_CTRL")}};

static const QMap<ulong, QString> rlimitMap = {{0, QStringLiteral("RLIMIT_CPU")},
                                               {1, QStringLiteral("RLIMIT_FSIZE")},
                                               {2, QStringLiteral("RLIMIT_DATA")},
                                               {3, QStringLiteral("RLIMIT_STACK")},
                                               {4, QStringLiteral("RLIMIT_CORE")},
                                               {5, QStringLiteral("RLIMIT_RSS")},
                                               {6, QStringLiteral("RLIMIT_NPROC")},
                                               {7, QStringLiteral("RLIMIT_NOFILE")},
                                               {8, QStringLiteral("RLIMIT_MEMLOCK")},
                                               {9, QStringLiteral("RLIMIT_AS")},
                                               {10, QStringLiteral("RLIMIT_LOCKS")},
                                               {11, QStringLiteral("RLIMIT_SIGPENDING")},
                                               {12, QStringLiteral("RLIMIT_MSGQUEUE")},
                                               {13, QStringLiteral("RLIMIT_NICE")},
                                               {14, QStringLiteral("RLIMIT_RTPRIO")},
                                               {15, QStringLiteral("RLIMIT_RTTIME")}};

static const QMap<ulong, QString> famMap = {{AF_LOCAL, QStringLiteral("local")},
                                            {AF_INET, QStringLiteral("inet")},
                                            {AF_AX25, QStringLiteral("ax25")},
                                            {AF_IPX, QStringLiteral("ipx")},
                                            {AF_APPLETALK, QStringLiteral("appletalk")},
                                            {AF_NETROM, QStringLiteral("netrom")},
                                            {AF_BRIDGE, QStringLiteral("bridge")},
                                            {AF_ATMPVC, QStringLiteral("atmpvc")},
                                            {AF_X25, QStringLiteral("x25")},
                                            {AF_INET6, QStringLiteral("inet6")},
                                            {AF_ROSE, QStringLiteral("rose")},
                                            {AF_DECnet, QStringLiteral("decnet")},
                                            {AF_NETBEUI, QStringLiteral("netbeui")},
                                            {AF_SECURITY, QStringLiteral("security")},
                                            {AF_KEY, QStringLiteral("key")},
                                            {AF_NETLINK, QStringLiteral("netlink")},
                                            {AF_PACKET, QStringLiteral("packet")},
                                            {AF_ASH, QStringLiteral("ash")},
                                            {AF_ECONET, QStringLiteral("econet")},
                                            {AF_ATMSVC, QStringLiteral("atmsvc")},
                                            {AF_RDS, QStringLiteral("rds")},
                                            {AF_SNA, QStringLiteral("sna")},
                                            {AF_IRDA, QStringLiteral("irda")},
                                            {AF_PPPOX, QStringLiteral("pppox")},
                                            {AF_WANPIPE, QStringLiteral("wanpipe")},
                                            {AF_LLC, QStringLiteral("llc")},
                                            {AF_CAN, QStringLiteral("can")},
                                            {AF_TIPC, QStringLiteral("tipc")},
                                            {AF_BLUETOOTH, QStringLiteral("bluetooth")},
                                            {AF_IUCV, QStringLiteral("iucv")},
                                            {AF_RXRPC, QStringLiteral("rxrpc")},
                                            {AF_ISDN, QStringLiteral("isdn")},
                                            {AF_PHONET, QStringLiteral("phonet")},
                                            {AF_IEEE802154, QStringLiteral("ieee802154")},
                                            {37, QStringLiteral("caif")},
                                            {38, QStringLiteral("alg")},
                                            {39, QStringLiteral("nfc")},
                                            {40, QStringLiteral("vsock")},
                                            {41, QStringLiteral("kcm")},
                                            {42, QStringLiteral("qipcrtr")},
                                            {43, QStringLiteral("smc")},
                                            {44, QStringLiteral("xdp")}};

static const QMap<ulong, QString> sockMap = {{SYS_SOCKET, QStringLiteral("socket")},
                                             {SYS_BIND, QStringLiteral("bind")},
                                             {SYS_CONNECT, QStringLiteral("connect")},
                                             {SYS_LISTEN, QStringLiteral("listen")},
                                             {SYS_ACCEPT, QStringLiteral("accept")},
                                             {SYS_GETSOCKNAME, QStringLiteral("getsockname")},
                                             {SYS_GETPEERNAME, QStringLiteral("getpeername")},
                                             {SYS_SOCKETPAIR, QStringLiteral("socketpair")},
                                             {SYS_SEND, QStringLiteral("send")},
                                             {SYS_RECV, QStringLiteral("recv")},
                                             {SYS_SENDTO, QStringLiteral("sendto")},
                                             {SYS_RECVFROM, QStringLiteral("recvfrom")},
                                             {SYS_SHUTDOWN, QStringLiteral("shutdown")},
                                             {SYS_SETSOCKOPT, QStringLiteral("setsockopt")},
                                             {SYS_GETSOCKOPT, QStringLiteral("getsockopt")},
                                             {SYS_SENDMSG, QStringLiteral("sendmsg")},
                                             {SYS_RECVMSG, QStringLiteral("recvmsg")},
                                             {SYS_ACCEPT4, QStringLiteral("accept4")},
                                             {19, QStringLiteral("recvmmsg")},
                                             {20, QStringLiteral("sendmmsg")}};

static const QMap<ulong, QString> ipcMap = {{SEMOP, QStringLiteral("semop")},
                                            {SEMGET, QStringLiteral("semget")},
                                            {SEMCTL, QStringLiteral("semctl")},
                                            {SEMTIMEDOP, QStringLiteral("semtimedop")},
                                            {MSGSND, QStringLiteral("msgsnd")},
                                            {MSGRCV, QStringLiteral("msgrcv")},
                                            {MSGGET, QStringLiteral("msgget")},
                                            {MSGCTL, QStringLiteral("msgctl")},
                                            {SHMAT, QStringLiteral("shmat")},
                                            {SHMDT, QStringLiteral("shmdt")},
                                            {SHMGET, QStringLiteral("shmget")},
                                            {SHMCTL, QStringLiteral("shmctl")}};

static const QMap<ulong, QString> bpfMap = {{0, QStringLiteral("BPF_MAP_CREATE")},        {1, QStringLiteral("BPF_MAP_LOOKUP_ELEM")},
                                            {2, QStringLiteral("BPF_MAP_UPDATE_ELEM")},   {3, QStringLiteral("BPF_MAP_DELETE_ELEM")},
                                            {4, QStringLiteral("BPF_MAP_GET_NEXT_KEY")},  {5, QStringLiteral("BPF_PROG_LOAD")},
                                            {6, QStringLiteral("BPF_OBJ_PIN")},           {7, QStringLiteral("BPF_OBJ_GET")},
                                            {8, QStringLiteral("BPF_PROG_ATTACH")},       {9, QStringLiteral("BPF_PROG_DETACH")},
                                            {10, QStringLiteral("BPF_PROG_TEST_RUN")},    {11, QStringLiteral("BPF_PROG_GET_NEXT_ID")},
                                            {12, QStringLiteral("BPF_MAP_GET_NEXT_ID")},  {13, QStringLiteral("BPF_PROG_GET_FD_BY_ID")},
                                            {14, QStringLiteral("BPF_MAP_GET_FD_BY_ID")}, {15, QStringLiteral("BPF_OBJ_GET_INFO_BY_FD")},
                                            {16, QStringLiteral("BPF_PROG_QUERY")},       {17, QStringLiteral("BPF_RAW_TRACEPOINT_OPEN")},
                                            {18, QStringLiteral("BPF_BTF_LOAD")},         {19, QStringLiteral("BPF_BTF_GET_FD_BY_ID")},
                                            {20, QStringLiteral("BPF_TASK_FD_QUERY")},    {21, QStringLiteral("BPF_MAP_LOOKUP_AND_DELETE_ELEM")},
                                            {22, QStringLiteral("BPF_MAP_FREEZE")},       {23, QStringLiteral("BPF_BTF_GET_NEXT_ID")}};

static const QMap<ulong, QString> fcntlcmdMap = {{0, QStringLiteral("F_DUPFD")},
                                                 {1, QStringLiteral("F_GETFD")},
                                                 {2, QStringLiteral("F_SETFD")},
                                                 {3, QStringLiteral("F_GETFL")},
                                                 {4, QStringLiteral("F_SETFL")},
                                                 {5, QStringLiteral("F_GETLK")},
                                                 {6, QStringLiteral("F_SETLK")},
                                                 {7, QStringLiteral("F_SETLKW")},
                                                 {8, QStringLiteral("F_SETOWN")},
                                                 {9, QStringLiteral("F_GETOWN")},
                                                 {10, QStringLiteral("F_SETSIG")},
                                                 {11, QStringLiteral("F_GETSIG")},
                                                 {12, QStringLiteral("F_GETLK64")},
                                                 {13, QStringLiteral("F_SETLK64")},
                                                 {14, QStringLiteral("F_SETLKW64")},
                                                 {15, QStringLiteral("F_SETOWN_EX")},
                                                 {16, QStringLiteral("F_GETOWN_EX")},
                                                 {17, QStringLiteral("F_GETOWNER_UIDS")},
                                                 {1024, QStringLiteral("F_SETLEASE")},
                                                 {1025, QStringLiteral("F_GETLEASE")},
                                                 {1026, QStringLiteral("F_NOTIFY")},
                                                 {1029, QStringLiteral("F_CANCELLK")},
                                                 {1030, QStringLiteral("F_DUPFD_CLOEXEC")},
                                                 {1031, QStringLiteral("F_SETPIPE_SZ")},
                                                 {1032, QStringLiteral("F_GETPIPE_SZ")},
                                                 {1033, QStringLiteral("F_ADD_SEALS")},
                                                 {1034, QStringLiteral("F_GET_SEALS")},
                                                 {1035, QStringLiteral("F_GET_RW_HINT")},
                                                 {1036, QStringLiteral("F_SET_RW_HINT")},
                                                 {1037, QStringLiteral("F_GET_FILE_RW_HINT")},
                                                 {1038, QStringLiteral("F_SET_FILE_RW_HINT")}};

static const QMap<ulong, QString> socklevelMap = {
    {0, QStringLiteral("SOL_IP")},         {6, QStringLiteral("SOL_TCP")},         {17, QStringLiteral("SOL_UDP")},      {41, QStringLiteral("SOL_IPV6")},
    {58, QStringLiteral("SOL_ICMPV6")},    {132, QStringLiteral("SOL_SCTP")},      {136, QStringLiteral("SOL_UDPLITE")}, {255, QStringLiteral("SOL_RAW")},
    {256, QStringLiteral("SOL_IPX")},      {257, QStringLiteral("SOL_AX25")},      {258, QStringLiteral("SOL_ATALK")},   {259, QStringLiteral("SOL_NETROM")},
    {260, QStringLiteral("SOL_ROSE")},     {261, QStringLiteral("SOL_DECNET")},    {263, QStringLiteral("SOL_PACKET")},  {264, QStringLiteral("SOL_ATM")},
    {265, QStringLiteral("SOL_AAL")},      {266, QStringLiteral("SOL_IRDA")},      {267, QStringLiteral("SOL_NETBEUI")}, {268, QStringLiteral("SOL_LLC")},
    {269, QStringLiteral("SOL_DCCP")},     {270, QStringLiteral("SOL_NETLINK")},   {271, QStringLiteral("SOL_TIPC")},    {272, QStringLiteral("SOL_RXRPC")},
    {273, QStringLiteral("SOL_PPPOL2TP")}, {274, QStringLiteral("SOL_BLUETOOTH")}, {275, QStringLiteral("SOL_PNPIPE")},  {276, QStringLiteral("SOL_RDS")},
    {277, QStringLiteral("SOL_IUCV")},     {278, QStringLiteral("SOL_CAIF")},      {279, QStringLiteral("SOL_ALG")},     {280, QStringLiteral("SOL_NFC")},
    {281, QStringLiteral("SOL_KCM")},      {282, QStringLiteral("SOL_TLS")},       {283, QStringLiteral("SOL_XDP")}};

static const QMap<ulong, QString> socktypeMap = {{1, QStringLiteral("SOCK_STREAM")},
                                                 {2, QStringLiteral("SOCK_DGRAM")},
                                                 {3, QStringLiteral("SOCK_RAW")},
                                                 {4, QStringLiteral("SOCK_RDM")},
                                                 {5, QStringLiteral("SOCK_SEQPACKET")},
                                                 {6, QStringLiteral("SOCK_DCCP")},
                                                 {10, QStringLiteral("SOCK_PACKET")}};

static const QMap<ulong, QString> schedMap = {{0, QStringLiteral("SCHED_OTHER")},
                                              {1, QStringLiteral("SCHED_FIFO")},
                                              {2, QStringLiteral("SCHED_RR")},
                                              {3, QStringLiteral("SCHED_BATCH")},
                                              {5, QStringLiteral("SCHED_IDLE")},
                                              {6, QStringLiteral("SCHED_DEADLINE")}};

static const QMap<ulong, QString> openflagMap = {{0x0, QStringLiteral("O_RDONLY")},
                                                 {0x1, QStringLiteral("O_WRONLY")},
                                                 {0x2, QStringLiteral("O_RDWR")},
                                                 {0x100, QStringLiteral("O_CREAT")},
                                                 {0x200, QStringLiteral("O_EXCL")},
                                                 {0x400, QStringLiteral("O_NOCTTY")},
                                                 {0x1000, QStringLiteral("O_TRUNC")},
                                                 {0x2000, QStringLiteral("O_APPEND")},
                                                 {0x4000, QStringLiteral("O_NONBLOCK")},
                                                 {0x10000, QStringLiteral("O_DSYNC")},
                                                 {0x20000, QStringLiteral("O_ASYNC")},
                                                 {0x40000, QStringLiteral("O_DIRECT")},
                                                 {0x200000, QStringLiteral("O_DIRECTORY")},
                                                 {0x400000, QStringLiteral("O_NOFOLLOW")},
                                                 {0x1000000, QStringLiteral("O_NOATIME")},
                                                 {0x2000000, QStringLiteral("O_CLOEXEC")},
                                                 {0x4000000, QStringLiteral("O_SYNC")},
                                                 {0x10000000, QStringLiteral("__O_PATH")},
                                                 {0x20000000, QStringLiteral("__O_TMPFILE")}};

static const QMap<ulong, QString> accessMap = {{0x1U, QStringLiteral("X_OK")}, {0x2U, QStringLiteral("W_OK")}, {0x4U, QStringLiteral("R_OK")}};

static const QMap<ulong, QString> epollctlMap = {{1, QStringLiteral("EPOLL_CTL_ADD")},
                                                 {2, QStringLiteral("EPOLL_CTL_DEL")},
                                                 {3, QStringLiteral("EPOLL_CTL_MOD")}};

static const QMap<ulong, QString> capMap = {{0, QStringLiteral("chown")},
                                            {1, QStringLiteral("dac_override")},
                                            {2, QStringLiteral("dac_read_search")},
                                            {3, QStringLiteral("fowner")},
                                            {4, QStringLiteral("fsetid")},
                                            {5, QStringLiteral("kill")},
                                            {6, QStringLiteral("setgid")},
                                            {7, QStringLiteral("setuid")},
                                            {8, QStringLiteral("setpcap")},
                                            {9, QStringLiteral("linux_immutable")},
                                            {10, QStringLiteral("net_bind_service")},
                                            {11, QStringLiteral("net_broadcast")},
                                            {12, QStringLiteral("net_admin")},
                                            {13, QStringLiteral("net_raw")},
                                            {14, QStringLiteral("ipc_lock")},
                                            {15, QStringLiteral("ipc_owner")},
                                            {16, QStringLiteral("sys_module")},
                                            {17, QStringLiteral("sys_rawio")},
                                            {18, QStringLiteral("sys_chroot")},
                                            {19, QStringLiteral("sys_ptrace")},
                                            {20, QStringLiteral("sys_pacct")},
                                            {21, QStringLiteral("sys_admin")},
                                            {22, QStringLiteral("sys_boot")},
                                            {23, QStringLiteral("sys_nice")},
                                            {24, QStringLiteral("sys_resource")},
                                            {25, QStringLiteral("sys_time")},
                                            {26, QStringLiteral("sys_tty_config")},
                                            {27, QStringLiteral("mknod")},
                                            {28, QStringLiteral("lease")},
                                            {29, QStringLiteral("audit_write")},
                                            {30, QStringLiteral("audit_control")},
                                            {31, QStringLiteral("setfcap")},
                                            {32, QStringLiteral("mac_override")},
                                            {33, QStringLiteral("mac_admin")},
                                            {34, QStringLiteral("syslog")},
                                            {35, QStringLiteral("wake_alarm")},
                                            {36, QStringLiteral("block_suspend")},
                                            {37, QStringLiteral("audit_read")}};

static const QMap<ulong, QString> umountMap = {{0x00000001, QStringLiteral("MNT_FORCE")},
                                               {0x00000002, QStringLiteral("MNT_DETACH")},
                                               {0x00000004, QStringLiteral("MNT_EXPIRE")},
                                               {0x00000008, QStringLiteral("UMOUNT_NOFOLLOW")},
                                               {0x80000000, QStringLiteral("UMOUNT_UNUSED")}};

static const QMap<ulong, QString> ioctlreqMap = {{0x4B3A, QStringLiteral("KDSETMODE")},
                                                 {0x4B3B, QStringLiteral("KDGETMODE")},

                                                 {0x5309, QStringLiteral("CDROMEJECT")},
                                                 {0x530F, QStringLiteral("CDROMEJECT_SW")},
                                                 {0x5311, QStringLiteral("CDROM_GET_UPC")},
                                                 {0x5316, QStringLiteral("CDROMSEEK")},

                                                 {0x5401, QStringLiteral("TCGETS")},
                                                 {0x5402, QStringLiteral("TCSETS")},
                                                 {0x5403, QStringLiteral("TCSETSW")},
                                                 {0x5404, QStringLiteral("TCSETSF")},
                                                 {0x5409, QStringLiteral("TCSBRK")},
                                                 {0x540B, QStringLiteral("TCFLSH")},
                                                 {0x540E, QStringLiteral("TIOCSCTTY")},
                                                 {0x540F, QStringLiteral("TIOCGPGRP")},
                                                 {0x5410, QStringLiteral("TIOCSPGRP")},
                                                 {0x5413, QStringLiteral("TIOCGWINSZ")},
                                                 {0x5414, QStringLiteral("TIOCSWINSZ")},
                                                 {0x541B, QStringLiteral("TIOCINQ")},
                                                 {0x5421, QStringLiteral("FIONBIO")},
                                                 {0x5422, QStringLiteral("TIOCNOTTY")},
                                                 {0x8901, QStringLiteral("FIOSETOWN")},
                                                 {0x8903, QStringLiteral("FIOGETOWN")},
                                                 {0x8910, QStringLiteral("SIOCGIFNAME")},
                                                 {0x8927, QStringLiteral("SIOCGIFHWADDR")},
                                                 {0x8933, QStringLiteral("SIOCGIFINDEX")},
                                                 {0x89a2, QStringLiteral("SIOCBRADDIF")},
                                                 {0x40045431, QStringLiteral("TIOCSPTLCK")},
                                                 {0x80045430, QStringLiteral("TIOCGPTN")},
                                                 {0x80045431, QStringLiteral("TIOCSPTLCK")},

                                                 {0xC01C64A3, QStringLiteral("DRM_IOCTL_MODE_CURSOR")},
                                                 {0xC01864B0, QStringLiteral("DRM_IOCTL_MODE_PAGE_FLIP")},
                                                 {0xC01864B1, QStringLiteral("DRM_IOCTL_MODE_DIRTYFB")}};

static const QMap<ulong, QString> ipoptnameMap = {{1, QStringLiteral("IP_TOS")},
                                                  {2, QStringLiteral("IP_TTL")},
                                                  {3, QStringLiteral("IP_HDRINCL")},
                                                  {4, QStringLiteral("IP_OPTIONS")},
                                                  {5, QStringLiteral("IP_ROUTER_ALERT")},
                                                  {6, QStringLiteral("IP_RECVOPTS")},
                                                  {7, QStringLiteral("IP_RETOPTS")},
                                                  {8, QStringLiteral("IP_PKTINFO")},
                                                  {9, QStringLiteral("IP_PKTOPTIONS")},
                                                  {10, QStringLiteral("IP_MTU_DISCOVER")},
                                                  {11, QStringLiteral("IP_RECVERR")},
                                                  {12, QStringLiteral("IP_RECVTTL")},
                                                  {13, QStringLiteral("IP_RECVTOS")},
                                                  {14, QStringLiteral("IP_MTU")},
                                                  {15, QStringLiteral("IP_FREEBIND")},
                                                  {16, QStringLiteral("IP_IPSEC_POLICY")},
                                                  {17, QStringLiteral("IP_XFRM_POLICY")},
                                                  {18, QStringLiteral("IP_PASSSEC")},
                                                  {19, QStringLiteral("IP_TRANSPARENT")},
                                                  {20, QStringLiteral("IP_ORIGDSTADDR")},
                                                  {21, QStringLiteral("IP_MINTTL")},
                                                  {22, QStringLiteral("IP_NODEFRAG")},
                                                  {23, QStringLiteral("IP_CHECKSUM")},
                                                  {24, QStringLiteral("IP_BIND_ADDRESS_NO_PORT")},
                                                  {25, QStringLiteral("IP_RECVFRAGSIZE")},
                                                  {32, QStringLiteral("IP_MULTICAST_IF")},
                                                  {33, QStringLiteral("IP_MULTICAST_TTL")},
                                                  {34, QStringLiteral("IP_MULTICAST_LOOP")},
                                                  {35, QStringLiteral("IP_ADD_MEMBERSHIP")},
                                                  {36, QStringLiteral("IP_DROP_MEMBERSHIP")},
                                                  {37, QStringLiteral("IP_UNBLOCK_SOURCE")},
                                                  {38, QStringLiteral("IP_BLOCK_SOURCE")},
                                                  {39, QStringLiteral("IP_ADD_SOURCE_MEMBERSHIP")},
                                                  {40, QStringLiteral("IP_DROP_SOURCE_MEMBERSHIP")},
                                                  {41, QStringLiteral("IP_MSFILTER")},
                                                  {42, QStringLiteral("MCAST_JOIN_GROUP")},
                                                  {43, QStringLiteral("MCAST_BLOCK_SOURCE")},
                                                  {44, QStringLiteral("MCAST_UNBLOCK_SOURCE")},
                                                  {45, QStringLiteral("MCAST_LEAVE_GROUP")},
                                                  {46, QStringLiteral("MCAST_JOIN_SOURCE_GROUP")},
                                                  {47, QStringLiteral("MCAST_LEAVE_SOURCE_GROUP")},
                                                  {48, QStringLiteral("MCAST_MSFILTER")},
                                                  {49, QStringLiteral("IP_MULTICAST_ALL")},
                                                  {50, QStringLiteral("IP_UNICAST_IF")},
                                                  {64, QStringLiteral("IPT_SO_SET_REPLACE")},
                                                  {65, QStringLiteral("IPT_SO_SET_ADD_COUNTERS")},
                                                  {66, QStringLiteral("IPT_SO_GET_REVISION_TARGET")}};

static const QMap<ulong, QString> sockoptnameMap = {{1, QStringLiteral("SO_DEBUG")},
                                                    {2, QStringLiteral("SO_REUSEADDR")},
                                                    {3, QStringLiteral("SO_TYPE")},
                                                    {4, QStringLiteral("SO_ERROR")},
                                                    {5, QStringLiteral("SO_DONTROUTE")},
                                                    {6, QStringLiteral("SO_BROADCAST")},
                                                    {7, QStringLiteral("SO_SNDBUF")},
                                                    {8, QStringLiteral("SO_RCVBUF")},
                                                    {9, QStringLiteral("SO_KEEPALIVE")},
                                                    {10, QStringLiteral("SO_OOBINLINE")},
                                                    {11, QStringLiteral("SO_NO_CHECK")},
                                                    {12, QStringLiteral("SO_PRIORITY")},
                                                    {13, QStringLiteral("SO_LINGER")},
                                                    {14, QStringLiteral("SO_BSDCOMPAT")},
                                                    {15, QStringLiteral("SO_REUSEPORT")},
                                                    {16, QStringLiteral("SO_PASSCRED")},
                                                    {17, QStringLiteral("SO_PEERCRED")},
                                                    {18, QStringLiteral("SO_RCVLOWAT")},
                                                    {19, QStringLiteral("SO_SNDLOWAT")},
                                                    {20, QStringLiteral("SO_RCVTIMEO")},
                                                    {21, QStringLiteral("SO_SNDTIMEO")},
                                                    {22, QStringLiteral("SO_SECURITY_AUTHENTICATION")},
                                                    {23, QStringLiteral("SO_SECURITY_ENCRYPTION_TRANSPORT")},
                                                    {24, QStringLiteral("SO_SECURITY_ENCRYPTION_NETWORK")},
                                                    {25, QStringLiteral("SO_BINDTODEVICE")},
                                                    {26, QStringLiteral("SO_ATTACH_FILTER")},
                                                    {27, QStringLiteral("SO_DETACH_FILTER")},
                                                    {28, QStringLiteral("SO_PEERNAME")},
                                                    {29, QStringLiteral("SO_TIMESTAMP")},
                                                    {30, QStringLiteral("SO_ACCEPTCONN")},
                                                    {31, QStringLiteral("SO_PEERSEC")},
                                                    {32, QStringLiteral("SO_SNDBUFFORCE")},
                                                    {33, QStringLiteral("SO_RCVBUFFORCE")},
                                                    {34, QStringLiteral("SO_PASSSEC")},
                                                    {35, QStringLiteral("SO_TIMESTAMPNS")},
                                                    {36, QStringLiteral("SO_MARK")},
                                                    {37, QStringLiteral("SO_TIMESTAMPING")},
                                                    {38, QStringLiteral("SO_PROTOCOL")},
                                                    {39, QStringLiteral("SO_DOMAIN")},
                                                    {40, QStringLiteral("SO_RXQ_OVFL")},
                                                    {41, QStringLiteral("SO_WIFI_STATUS")},
                                                    {42, QStringLiteral("SO_PEEK_OFF")},
                                                    {43, QStringLiteral("SO_NOFCS")},
                                                    {44, QStringLiteral("SO_LOCK_FILTER")},
                                                    {45, QStringLiteral("SO_SELECT_ERR_QUEUE")},
                                                    {46, QStringLiteral("SO_BUSY_POLL")},
                                                    {47, QStringLiteral("SO_MAX_PACING_RATE")},
                                                    {48, QStringLiteral("SO_BPF_EXTENSIONS")},
                                                    {49, QStringLiteral("SO_INCOMING_CPU")},
                                                    {50, QStringLiteral("SO_ATTACH_BPF")},
                                                    {51, QStringLiteral("SO_ATTACH_REUSEPORT_CBPF")},
                                                    {52, QStringLiteral("SO_ATTACH_REUSEPORT_EBPF")},
                                                    {53, QStringLiteral("SO_CNX_ADVICE")},
                                                    {54, QStringLiteral("SCM_TIMESTAMPING_OPT_STATS")},
                                                    {55, QStringLiteral("SO_MEMINFO")},
                                                    {56, QStringLiteral("SO_INCOMING_NAPI_ID")},
                                                    {57, QStringLiteral("SO_COOKIE")},
                                                    {58, QStringLiteral("SCM_TIMESTAMPING_PKTINFO")},
                                                    {59, QStringLiteral("SO_PEERGROUPS")},
                                                    {60, QStringLiteral("SO_ZEROCOPY")},
                                                    {61, QStringLiteral("SO_TXTIME")},
                                                    {62, QStringLiteral("SO_BINDTOIFINDEX")},
                                                    {63, QStringLiteral("SO_TIMESTAMP_NEW")},
                                                    {64, QStringLiteral("SO_TIMESTAMPNS_NEW")},
                                                    {65, QStringLiteral("SO_TIMESTAMPING_NEW")},
                                                    {66, QStringLiteral("SO_RCVTIMEO_NEW")},
                                                    {67, QStringLiteral("SO_SNDTIMEO_NEW")},
                                                    {68, QStringLiteral("SO_DETACH_REUSEPORT_BPF")},
                                                    {116, QStringLiteral("SO_RCVLOWAT")},
                                                    {117, QStringLiteral("SO_SNDLOWAT")},
                                                    {118, QStringLiteral("SO_RCVTIMEO")},
                                                    {119, QStringLiteral("SO_SNDTIMEO")},
                                                    {120, QStringLiteral("SO_PASSCRED")},
                                                    {121, QStringLiteral("SO_PEERCRED")}};

static const QMap<ulong, QString> tcpoptnameMap = {{1, QStringLiteral("TCP_NODELAY")},
                                                   {2, QStringLiteral("TCP_MAXSEG")},
                                                   {3, QStringLiteral("TCP_CORK")},
                                                   {4, QStringLiteral("TCP_KEEPIDLE")},
                                                   {5, QStringLiteral("TCP_KEEPINTVL")},
                                                   {6, QStringLiteral("TCP_KEEPCNT")},
                                                   {7, QStringLiteral("TCP_SYNCNT")},
                                                   {8, QStringLiteral("TCP_LINGER2")},
                                                   {9, QStringLiteral("TCP_DEFER_ACCEPT")},
                                                   {10, QStringLiteral("TCP_WINDOW_CLAMP")},
                                                   {11, QStringLiteral("TCP_INFO")},
                                                   {12, QStringLiteral("TCP_QUICKACK")},
                                                   {13, QStringLiteral("TCP_CONGESTION")},
                                                   {14, QStringLiteral("TCP_MD5SIG")},
                                                   {15, QStringLiteral("TCP_COOKIE_TRANSACTIONS")},
                                                   {16, QStringLiteral("TCP_THIN_LINEAR_TIMEOUTS")},
                                                   {17, QStringLiteral("TCP_THIN_DUPACK")},
                                                   {18, QStringLiteral("TCP_USER_TIMEOUT")},
                                                   {19, QStringLiteral("TCP_REPAIR")},
                                                   {20, QStringLiteral("TCP_REPAIR_QUEUE")},
                                                   {21, QStringLiteral("TCP_QUEUE_SEQ")},
                                                   {22, QStringLiteral("TCP_REPAIR_OPTIONS")},
                                                   {23, QStringLiteral("TCP_FASTOPEN")},
                                                   {24, QStringLiteral("TCP_TIMESTAMP")},
                                                   {25, QStringLiteral("TCP_NOTSENT_LOWAT")},
                                                   {26, QStringLiteral("TCP_CC_INFO")},
                                                   {27, QStringLiteral("TCP_SAVE_SYN")},
                                                   {28, QStringLiteral("TCP_SAVED_SYN")},
                                                   {29, QStringLiteral("TCP_REPAIR_WINDOW")},
                                                   {30, QStringLiteral("TCP_FASTOPEN_CONNECT")},
                                                   {31, QStringLiteral("TCP_ULP")},
                                                   {32, QStringLiteral("TCP_MD5SIG_EXT")},
                                                   {33, QStringLiteral("TCP_FASTOPEN_KEY")},
                                                   {34, QStringLiteral("TCP_FASTOPEN_NO_COOKIE")},
                                                   {35, QStringLiteral("TCP_ZEROCOPY_RECEIVE")},
                                                   {36, QStringLiteral("TCP_INQ")},
                                                   {37, QStringLiteral("TCP_TX_DELAY")}};

static const QMap<ulong, QString> ip6optnameMap = {{1, QStringLiteral("IPV6_ADDRFORM")},
                                                   {2, QStringLiteral("IPV6_2292PKTINFO")},
                                                   {3, QStringLiteral("IPV6_2292HOPOPTS")},
                                                   {4, QStringLiteral("IPV6_2292DSTOPTS")},
                                                   {5, QStringLiteral("IPV6_2292RTHDR")},
                                                   {6, QStringLiteral("IPV6_2292PKTOPTIONS")},
                                                   {7, QStringLiteral("IPV6_CHECKSUM")},
                                                   {8, QStringLiteral("IPV6_2292HOPLIMIT")},
                                                   {9, QStringLiteral("IPV6_NEXTHOP")},
                                                   {10, QStringLiteral("IPV6_AUTHHDR")},
                                                   {11, QStringLiteral("IPV6_FLOWINFO")},
                                                   {16, QStringLiteral("IPV6_UNICAST_HOPS")},
                                                   {17, QStringLiteral("IPV6_MULTICAST_IF")},
                                                   {18, QStringLiteral("IPV6_MULTICAST_HOPS")},
                                                   {19, QStringLiteral("IPV6_MULTICAST_LOOP")},
                                                   {20, QStringLiteral("IPV6_ADD_MEMBERSHIP")},
                                                   {21, QStringLiteral("IPV6_DROP_MEMBERSHIP")},
                                                   {22, QStringLiteral("IPV6_ROUTER_ALERT")},
                                                   {23, QStringLiteral("IPV6_MTU_DISCOVER")},
                                                   {24, QStringLiteral("IPV6_MTU")},
                                                   {25, QStringLiteral("IPV6_RECVERR")},
                                                   {26, QStringLiteral("IPV6_V6ONLY")},
                                                   {27, QStringLiteral("IPV6_JOIN_ANYCAST")},
                                                   {28, QStringLiteral("IPV6_LEAVE_ANYCAST")},
                                                   {29, QStringLiteral("IPV6_MULTICAST_ALL")},
                                                   {30, QStringLiteral("IPV6_ROUTER_ALERT_ISOLATE")},
                                                   {32, QStringLiteral("IPV6_FLOWLABEL_MGR")},
                                                   {33, QStringLiteral("IPV6_FLOWINFO_SEND")},
                                                   {34, QStringLiteral("IPV6_IPSEC_POLICY")},
                                                   {35, QStringLiteral("IPV6_XFRM_POLICY")},
                                                   {36, QStringLiteral("IPV6_HDRINCL")},
                                                   {42, QStringLiteral("MCAST_JOIN_GROUP")},
                                                   {43, QStringLiteral("MCAST_BLOCK_SOURCE")},
                                                   {44, QStringLiteral("MCAST_UNBLOCK_SOURCE")},
                                                   {45, QStringLiteral("MCAST_LEAVE_GROUP")},
                                                   {46, QStringLiteral("MCAST_JOIN_SOURCE_GROUP")},
                                                   {47, QStringLiteral("MCAST_LEAVE_SOURCE_GROUP")},
                                                   {48, QStringLiteral("MCAST_MSFILTER")},
                                                   {49, QStringLiteral("IPV6_RECVPKTINFO")},
                                                   {50, QStringLiteral("IPV6_PKTINFO")},
                                                   {51, QStringLiteral("IPV6_RECVHOPLIMIT")},
                                                   {52, QStringLiteral("IPV6_HOPLIMIT")},
                                                   {53, QStringLiteral("IPV6_RECVHOPOPTS")},
                                                   {54, QStringLiteral("IPV6_HOPOPTS")},
                                                   {55, QStringLiteral("IPV6_RTHDRDSTOPTS")},
                                                   {56, QStringLiteral("IPV6_RECVRTHDR")},
                                                   {57, QStringLiteral("IPV6_RTHDR")},
                                                   {58, QStringLiteral("IPV6_RECVDSTOPTS")},
                                                   {59, QStringLiteral("IPV6_DSTOPTS")},
                                                   {60, QStringLiteral("IPV6_RECVPATHMTU")},
                                                   {61, QStringLiteral("IPV6_PATHMTU")},
                                                   {62, QStringLiteral("IPV6_DONTFRAG")},
                                                   {63, QStringLiteral("IPV6_USE_MIN_MTU")},
                                                   {64, QStringLiteral("IP6T_SO_SET_REPLACE")},
                                                   {65, QStringLiteral("IP6T_SO_SET_ADD_COUNTERS")},
                                                   {66, QStringLiteral("IPV6_RECVTCLASS")},
                                                   {67, QStringLiteral("IPV6_TCLASS")},
                                                   {68, QStringLiteral("IP6T_SO_GET_REVISION_MATCH")},
                                                   {69, QStringLiteral("IP6T_SO_GET_REVISION_TARGET")},
                                                   {70, QStringLiteral("IPV6_AUTOFLOWLABEL")},
                                                   {72, QStringLiteral("IPV6_ADDR_PREFERENCES")},
                                                   {73, QStringLiteral("IPV6_MINHOPCOUNT")},
                                                   {74, QStringLiteral("IPV6_ORIGDSTADDR")},
                                                   {75, QStringLiteral("IPV6_TRANSPARENT")},
                                                   {76, QStringLiteral("IPV6_UNICAST_IF")},
                                                   {77, QStringLiteral("IPV6_RECVFRAGSIZE")},
                                                   {78, QStringLiteral("IPV6_FREEBIND")},
                                                   {80, QStringLiteral("IP6T_SO_ORIGINAL_DST")}};

static const QMap<ulong, QString> pktoptnameMap = {
    {1, QStringLiteral("PACKET_ADD_MEMBERSHIP")},  {2, QStringLiteral("PACKET_DROP_MEMBERSHIP")}, {3, QStringLiteral("PACKET_RECV_OUTPUT")},
    {5, QStringLiteral("PACKET_RX_RING")},         {6, QStringLiteral("PACKET_STATISTICS")},      {7, QStringLiteral("PACKET_COPY_THRESH")},
    {8, QStringLiteral("PACKET_AUXDATA")},         {9, QStringLiteral("PACKET_ORIGDEV")},         {10, QStringLiteral("PACKET_VERSION")},
    {11, QStringLiteral("PACKET_HDRLEN")},         {12, QStringLiteral("PACKET_RESERVE")},        {13, QStringLiteral("PACKET_TX_RING")},
    {14, QStringLiteral("PACKET_LOSS")},           {15, QStringLiteral("PACKET_VNET_HDR")},       {16, QStringLiteral("PACKET_TX_TIMESTAMP")},
    {17, QStringLiteral("PACKET_TIMESTAMP")},      {18, QStringLiteral("PACKET_FANOUT")},         {19, QStringLiteral("PACKET_TX_HAS_OFF")},
    {20, QStringLiteral("PACKET_QDISC_BYPASS")},   {21, QStringLiteral("PACKET_ROLLOVER_STATS")}, {22, QStringLiteral("PACKET_FANOUT_DATA")},
    {23, QStringLiteral("PACKET_IGNORE_OUTGOING")}};

static const QMap<ulong, QString> recvMap = {
    {0x00000001, QStringLiteral("MSG_OOB")},        {0x00000002, QStringLiteral("MSG_PEEK")},       {0x00000004, QStringLiteral("MSG_DONTROUTE")},
    {0x00000008, QStringLiteral("MSG_CTRUNC")},     {0x00000010, QStringLiteral("MSG_PROXY")},      {0x00000020, QStringLiteral("MSG_TRUNC")},
    {0x00000040, QStringLiteral("MSG_DONTWAIT")},   {0x00000080, QStringLiteral("MSG_EOR")},        {0x00000100, QStringLiteral("MSG_WAITALL")},
    {0x00000200, QStringLiteral("MSG_FIN")},        {0x00000400, QStringLiteral("MSG_SYN")},        {0x00000800, QStringLiteral("MSG_CONFIRM")},
    {0x00001000, QStringLiteral("MSG_RST")},        {0x00002000, QStringLiteral("MSG_ERRQUEUE")},   {0x00004000, QStringLiteral("MSG_NOSIGNAL")},
    {0x00008000, QStringLiteral("MSG_MORE")},       {0x00010000, QStringLiteral("MSG_WAITFORONE")}, {0x00020000, QStringLiteral("MSG_SENDPAGE_NOTLAST")},
    {0x00040000, QStringLiteral("MSG_BATCH")},      {0x20000000, QStringLiteral("MSG_FASTOPEN")},   {0x40000000, QStringLiteral("MSG_CMSG_CLOEXEC")},
    {0x80000000, QStringLiteral("MSG_CMSG_COMPAT")}};

static const QMap<ulong, QString> shmmodeMap = {{00001000, QStringLiteral("SHM_DEST")},
                                                {00002000, QStringLiteral("SHM_LOCKED")},
                                                {00004000, QStringLiteral("SHM_HUGETLB")},
                                                {00010000, QStringLiteral("SHM_NORESERVE")}};

static const QMap<ulong, QString> ipccmdMap = {{00001000, QStringLiteral("IPC_CREAT")},
                                               {00002000, QStringLiteral("IPC_EXCL")},
                                               {00004000, QStringLiteral("IPC_NOWAIT")}};

static const QMap<ulong, QString> protMap = {{1, QStringLiteral("PROT_READ")},
                                             {2, QStringLiteral("PROT_WRITE")},
                                             {4, QStringLiteral("PROT_EXEC")},
                                             {8, QStringLiteral("PROT_SEM")}};

static const QMap<ulong, QString> seekMap = {{0, QStringLiteral("SEEK_SET")},
                                             {1, QStringLiteral("SEEK_CUR")},
                                             {2, QStringLiteral("SEEK_END")},
                                             {3, QStringLiteral("SEEK_DATA")},
                                             {4, QStringLiteral("SEEK_HOLE")}};

static const QMap<ulong, QString> mmapMap = {{0x0000001, QStringLiteral("MAP_SHARED")},
                                             {0x0000002, QStringLiteral("MAP_PRIVATE")},
                                             {0x0000010, QStringLiteral("MAP_FIXED")},
                                             {0x0000020, QStringLiteral("MAP_ANONYMOUS")},
                                             {0x0000040, QStringLiteral("MAP_32BIT")},
                                             {0x0000100, QStringLiteral("MAP_GROWSDOWN")},
                                             {0x0000800, QStringLiteral("MAP_DENYWRITE")},
                                             {0x0001000, QStringLiteral("MAP_EXECUTABLE")},
                                             {0x0002000, QStringLiteral("MAP_LOCKED")},
                                             {0x0004000, QStringLiteral("MAP_NORESERVE")},
                                             {0x0008000, QStringLiteral("MAP_POPULATE")},
                                             {0x0010000, QStringLiteral("MAP_NONBLOCK")},
                                             {0x0020000, QStringLiteral("MAP_STACK")},
                                             {0x0040000, QStringLiteral("MAP_HUGETLB")},
                                             {0x0080000, QStringLiteral("MAP_SYNC")},
                                             {0x0100000, QStringLiteral("MAP_FIXED_NOREPLACE")},
                                             {0x4000000, QStringLiteral("MAP_UNINITIALIZED")}};

static const QMap<ulong, QString> mountMap = {{MS_RDONLY, QStringLiteral("MS_RDONLY")},
                                              {MS_NOSUID, QStringLiteral("MS_NOSUID")},
                                              {MS_NODEV, QStringLiteral("MS_NODEV")},
                                              {MS_NOEXEC, QStringLiteral("MS_NOEXEC")},
                                              {MS_SYNCHRONOUS, QStringLiteral("MS_SYNCHRONOUS")},
                                              {MS_REMOUNT, QStringLiteral("MS_REMOUNT")},
                                              {MS_MANDLOCK, QStringLiteral("MS_MANDLOCK")},
                                              {MS_DIRSYNC, QStringLiteral("MS_DIRSYNC")},
                                              {MS_NOATIME, QStringLiteral("MS_NOATIME")},
                                              {MS_NODIRATIME, QStringLiteral("MS_NODIRATIME")},
                                              {MS_BIND, QStringLiteral("MS_BIND")},
                                              {MS_MOVE, QStringLiteral("MS_MOVE")},
                                              {MS_REC, QStringLiteral("MS_REC")},
                                              {MS_SILENT, QStringLiteral("MS_SILENT")},
                                              {MS_POSIXACL, QStringLiteral("MS_POSIXACL")},
                                              {MS_UNBINDABLE, QStringLiteral("MS_UNBINDABLE")},
                                              {MS_PRIVATE, QStringLiteral("MS_PRIVATE")},
                                              {MS_SLAVE, QStringLiteral("MS_SLAVE")},
                                              {MS_SHARED, QStringLiteral("MS_SHARED")},
                                              {MS_RELATIME, QStringLiteral("MS_RELATIME")},
                                              {MS_KERNMOUNT, QStringLiteral("MS_KERNMOUNT")},
                                              {MS_I_VERSION, QStringLiteral("MS_I_VERSION")},
                                              {(1 << 24), QStringLiteral("MS_STRICTATIME")},
                                              {(1 << 25), QStringLiteral("MS_LAZYTIME")},
                                              {(1 << 26), QStringLiteral("MS_SUBMOUNT")},
                                              {(1 << 27), QStringLiteral("MS_SNAP_STABLE")},
                                              {(1 << 28), QStringLiteral("MS_NOSEC")},
                                              {(1 << 29), QStringLiteral("MS_BORN")},
                                              {MS_ACTIVE, QStringLiteral("MS_ACTIVE")},
                                              {MS_NOUSER, QStringLiteral("MS_NOUSER")}};
