/*
  SPDX-FileCopyrightText: 2015-2020 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "customtoolswidgetng.h"
#include "customtoolsplugin.h"
#include "customtoolspluginmanager.h"
#include "customtoolsviewinterface.h"

#include <KToggleAction>

#include <QHBoxLayout>
#include <QStackedWidget>

using namespace PimCommon;

class PimCommon::CustomToolsWidgetNgPrivate
{
public:
    CustomToolsWidgetNgPrivate()
    {
    }

    QStackedWidget *mStackedWidget = nullptr;
    QList<PimCommon::CustomToolsViewInterface *> mListInterfaceView;
};

CustomToolsWidgetNg::CustomToolsWidgetNg(QWidget *parent)
    : QWidget(parent)
    , d(new PimCommon::CustomToolsWidgetNgPrivate)
{
    auto *lay = new QHBoxLayout(this);
    d->mStackedWidget = new QStackedWidget;
    d->mStackedWidget->setObjectName(QStringLiteral("stackedwidget"));
    lay->addWidget(d->mStackedWidget);
    hide();
}

CustomToolsWidgetNg::~CustomToolsWidgetNg()
{
    delete d;
}

void CustomToolsWidgetNg::addCustomToolViewInterface(PimCommon::CustomToolsViewInterface *plugin)
{
    d->mListInterfaceView.append(plugin);
    d->mStackedWidget->addWidget(plugin);
}

void CustomToolsWidgetNg::initializeView(KActionCollection *ac, const QVector<CustomToolsPlugin *> &localPluginsList)
{
    for (CustomToolsPlugin *plugin : localPluginsList) {
        PimCommon::CustomToolsViewInterface *localCreateView = plugin->createView(ac, this);
        d->mListInterfaceView.append(localCreateView);
        d->mStackedWidget->addWidget(localCreateView);
    }
}

void CustomToolsWidgetNg::slotToolsWasClosed()
{
    for (PimCommon::CustomToolsViewInterface *interface : qAsConst(d->mListInterfaceView)) {
        interface->action()->setChecked(false);
    }
    hide();
}

void CustomToolsWidgetNg::slotActivateView(QWidget *w)
{
    if (w) {
        d->mStackedWidget->setCurrentWidget(w);
        setVisible(true);
        for (PimCommon::CustomToolsViewInterface *interface : qAsConst(d->mListInterfaceView)) {
            if (interface != w) {
                interface->action()->setChecked(false);
            }
        }
        Q_EMIT toolActivated();
    } else {
        setVisible(false);
        slotToolsWasClosed();
    }
}

QList<KToggleAction *> CustomToolsWidgetNg::actionList() const
{
    QList<KToggleAction *> lstActions;
    lstActions.reserve(d->mListInterfaceView.count());
    for (PimCommon::CustomToolsViewInterface *interface : qAsConst(d->mListInterfaceView)) {
        lstActions << interface->action();
    }
    return lstActions;
}

void CustomToolsWidgetNg::setText(const QString &text)
{
    if (isVisible()) {
        for (PimCommon::CustomToolsViewInterface *interface : qAsConst(d->mListInterfaceView)) {
            if (interface == d->mStackedWidget->currentWidget()) {
                interface->setText(text);
                break;
            }
        }
    }
}
