/*
   Copyright (C) 2015-2020 Laurent Montel <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "synchronizeresourcedialogtest.h"
#include "../dialog/synchronizeresourcedialog.h"
#include <QDialogButtonBox>
#include <QTest>
#include <QListWidget>
#include <KListWidgetSearchLine>
#include <QStandardPaths>

#include <QLabel>
#include <QPushButton>

SynchronizeResourceDialogTest::SynchronizeResourceDialogTest(QObject *parent)
    : QObject(parent)
{
    QStandardPaths::setTestModeEnabled(true);
}

SynchronizeResourceDialogTest::~SynchronizeResourceDialogTest()
{
}

void SynchronizeResourceDialogTest::shouldHaveDefaultValue()
{
    SynchronizeResourceDialog dlg;
    QDialogButtonBox *buttonBox = dlg.findChild<QDialogButtonBox *>(QStringLiteral("buttonbox"));
    QVERIFY(buttonBox);

    QListWidget *listWidget = dlg.findChild<QListWidget *>(QStringLiteral("listresourcewidget"));
    QVERIFY(listWidget);

    KListWidgetSearchLine *searchLine = dlg.findChild<KListWidgetSearchLine *>(QStringLiteral("listwidgetsearchline"));
    QVERIFY(searchLine);

    QLabel *label = dlg.findChild<QLabel *>(QStringLiteral("label"));
    QVERIFY(label);
    QVERIFY(label->wordWrap());

    QPushButton *selectAll = dlg.findChild<QPushButton *>(QStringLiteral("selectall_button"));
    QVERIFY(selectAll);

    QPushButton *unselectAll = dlg.findChild<QPushButton *>(QStringLiteral("unselectall_button"));
    QVERIFY(unselectAll);

    QVERIFY(dlg.resources().isEmpty());
}

void SynchronizeResourceDialogTest::shouldNotEmptyList()
{
    SynchronizeResourceDialog dlg;
    QListWidget *listWidget = dlg.findChild<QListWidget *>(QStringLiteral("listresourcewidget"));
    QHash<QString, QString> lst;
    lst.insert(QStringLiteral("foo"), QStringLiteral("foo"));
    lst.insert(QStringLiteral("faa"), QStringLiteral("faa"));
    dlg.setResources(lst);
    QCOMPARE(dlg.resources().count(), 0);
    QCOMPARE(listWidget->count(), lst.count());
}

QTEST_MAIN(SynchronizeResourceDialogTest)
