/*
    KWin - the KDE window manager
    This file is part of the KDE project.

    SPDX-FileCopyrightText: 2017 Martin Flöser <mgraesslin@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later
*/
#include "xkb.h"

#include <QTest>
#include <xkbcommon/xkbcommon-keysyms.h>

using namespace KWin;

class XkbTest : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testToQtKey_data();
    void testToQtKey();
};

// from kwindowsystem/src/platforms/xcb/kkeyserver.cpp
// adjusted to xkb
struct TransKey
{
    xkb_keysym_t keySymX;
    Qt::Key keySymQt;
    Qt::KeyboardModifiers modifiers;
};

static const TransKey g_rgQtToSymX[] = {
    {XKB_KEY_Escape, Qt::Key_Escape, Qt::KeyboardModifiers()},
    {XKB_KEY_Tab, Qt::Key_Tab, Qt::KeyboardModifiers()},
    {XKB_KEY_ISO_Left_Tab, Qt::Key_Backtab, Qt::KeyboardModifiers()},
    {XKB_KEY_BackSpace, Qt::Key_Backspace, Qt::KeyboardModifiers()},
    {XKB_KEY_Return, Qt::Key_Return, Qt::KeyboardModifiers()},
    {XKB_KEY_Insert, Qt::Key_Insert, Qt::KeyboardModifiers()},
    {XKB_KEY_Delete, Qt::Key_Delete, Qt::KeyboardModifiers()},
    {XKB_KEY_Pause, Qt::Key_Pause, Qt::KeyboardModifiers()},
    {XKB_KEY_Print, Qt::Key_Print, Qt::KeyboardModifiers()},
    {XKB_KEY_Sys_Req, Qt::Key_SysReq, Qt::KeyboardModifiers()},
    {XKB_KEY_Home, Qt::Key_Home, Qt::KeyboardModifiers()},
    {XKB_KEY_End, Qt::Key_End, Qt::KeyboardModifiers()},
    {XKB_KEY_Left, Qt::Key_Left, Qt::KeyboardModifiers()},
    {XKB_KEY_Up, Qt::Key_Up, Qt::KeyboardModifiers()},
    {XKB_KEY_Right, Qt::Key_Right, Qt::KeyboardModifiers()},
    {XKB_KEY_Down, Qt::Key_Down, Qt::KeyboardModifiers()},
    {XKB_KEY_Prior, Qt::Key_PageUp, Qt::KeyboardModifiers()},
    {XKB_KEY_Next, Qt::Key_PageDown, Qt::KeyboardModifiers()},
    {XKB_KEY_Caps_Lock, Qt::Key_CapsLock, Qt::KeyboardModifiers()},
    {XKB_KEY_Num_Lock, Qt::Key_NumLock, Qt::KeyboardModifiers()},
    {XKB_KEY_Scroll_Lock, Qt::Key_ScrollLock, Qt::KeyboardModifiers()},
    {XKB_KEY_F1, Qt::Key_F1, Qt::KeyboardModifiers()},
    {XKB_KEY_F2, Qt::Key_F2, Qt::KeyboardModifiers()},
    {XKB_KEY_F3, Qt::Key_F3, Qt::KeyboardModifiers()},
    {XKB_KEY_F4, Qt::Key_F4, Qt::KeyboardModifiers()},
    {XKB_KEY_F5, Qt::Key_F5, Qt::KeyboardModifiers()},
    {XKB_KEY_F6, Qt::Key_F6, Qt::KeyboardModifiers()},
    {XKB_KEY_F7, Qt::Key_F7, Qt::KeyboardModifiers()},
    {XKB_KEY_F8, Qt::Key_F8, Qt::KeyboardModifiers()},
    {XKB_KEY_F9, Qt::Key_F9, Qt::KeyboardModifiers()},
    {XKB_KEY_F10, Qt::Key_F10, Qt::KeyboardModifiers()},
    {XKB_KEY_F11, Qt::Key_F11, Qt::KeyboardModifiers()},
    {XKB_KEY_F12, Qt::Key_F12, Qt::KeyboardModifiers()},
    {XKB_KEY_F13, Qt::Key_F13, Qt::KeyboardModifiers()},
    {XKB_KEY_F14, Qt::Key_F14, Qt::KeyboardModifiers()},
    {XKB_KEY_F15, Qt::Key_F15, Qt::KeyboardModifiers()},
    {XKB_KEY_F16, Qt::Key_F16, Qt::KeyboardModifiers()},
    {XKB_KEY_F17, Qt::Key_F17, Qt::KeyboardModifiers()},
    {XKB_KEY_F18, Qt::Key_F18, Qt::KeyboardModifiers()},
    {XKB_KEY_F19, Qt::Key_F19, Qt::KeyboardModifiers()},
    {XKB_KEY_F20, Qt::Key_F20, Qt::KeyboardModifiers()},
    {XKB_KEY_F21, Qt::Key_F21, Qt::KeyboardModifiers()},
    {XKB_KEY_F22, Qt::Key_F22, Qt::KeyboardModifiers()},
    {XKB_KEY_F23, Qt::Key_F23, Qt::KeyboardModifiers()},
    {XKB_KEY_F24, Qt::Key_F24, Qt::KeyboardModifiers()},
    {XKB_KEY_F25, Qt::Key_F25, Qt::KeyboardModifiers()},
    {XKB_KEY_F26, Qt::Key_F26, Qt::KeyboardModifiers()},
    {XKB_KEY_F27, Qt::Key_F27, Qt::KeyboardModifiers()},
    {XKB_KEY_F28, Qt::Key_F28, Qt::KeyboardModifiers()},
    {XKB_KEY_F29, Qt::Key_F29, Qt::KeyboardModifiers()},
    {XKB_KEY_F30, Qt::Key_F30, Qt::KeyboardModifiers()},
    {XKB_KEY_F31, Qt::Key_F31, Qt::KeyboardModifiers()},
    {XKB_KEY_F32, Qt::Key_F32, Qt::KeyboardModifiers()},
    {XKB_KEY_F33, Qt::Key_F33, Qt::KeyboardModifiers()},
    {XKB_KEY_F34, Qt::Key_F34, Qt::KeyboardModifiers()},
    {XKB_KEY_F35, Qt::Key_F35, Qt::KeyboardModifiers()},
    {XKB_KEY_Super_L, Qt::Key_Super_L, Qt::KeyboardModifiers()},
    {XKB_KEY_Super_R, Qt::Key_Super_R, Qt::KeyboardModifiers()},
    {XKB_KEY_Menu, Qt::Key_Menu, Qt::KeyboardModifiers()},
    {XKB_KEY_Hyper_L, Qt::Key_Meta, Qt::KeyboardModifiers()},
    {XKB_KEY_Hyper_R, Qt::Key_Meta, Qt::KeyboardModifiers()},
    {XKB_KEY_Help, Qt::Key_Help, Qt::KeyboardModifiers()},
    {XKB_KEY_KP_Space, Qt::Key_Space, Qt::KeypadModifier},
    {XKB_KEY_KP_Tab, Qt::Key_Tab, Qt::KeypadModifier},
    {XKB_KEY_KP_Enter, Qt::Key_Enter, Qt::KeypadModifier},
    {XKB_KEY_KP_Home, Qt::Key_Home, Qt::KeypadModifier},
    {XKB_KEY_KP_Left, Qt::Key_Left, Qt::KeypadModifier},
    {XKB_KEY_KP_Up, Qt::Key_Up, Qt::KeypadModifier},
    {XKB_KEY_KP_Right, Qt::Key_Right, Qt::KeypadModifier},
    {XKB_KEY_KP_Down, Qt::Key_Down, Qt::KeypadModifier},
    {XKB_KEY_KP_Prior, Qt::Key_PageUp, Qt::KeypadModifier},
    {XKB_KEY_KP_Next, Qt::Key_PageDown, Qt::KeypadModifier},
    {XKB_KEY_KP_End, Qt::Key_End, Qt::KeypadModifier},
    {XKB_KEY_KP_Begin, Qt::Key_Clear, Qt::KeypadModifier},
    {XKB_KEY_KP_Insert, Qt::Key_Insert, Qt::KeypadModifier},
    {XKB_KEY_KP_Delete, Qt::Key_Delete, Qt::KeypadModifier},
    {XKB_KEY_KP_Equal, Qt::Key_Equal, Qt::KeypadModifier},
    {XKB_KEY_KP_Multiply, Qt::Key_Asterisk, Qt::KeypadModifier},
    {XKB_KEY_KP_Add, Qt::Key_Plus, Qt::KeypadModifier},
    {XKB_KEY_KP_Separator, Qt::Key_Comma, Qt::KeypadModifier},
    {XKB_KEY_KP_Subtract, Qt::Key_Minus, Qt::KeypadModifier},
    {XKB_KEY_KP_Decimal, Qt::Key_Period, Qt::KeypadModifier},
    {XKB_KEY_KP_Divide, Qt::Key_Slash, Qt::KeypadModifier},
    {XKB_KEY_XF86Back, Qt::Key_Back, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Forward, Qt::Key_Forward, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Stop, Qt::Key_Stop, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Refresh, Qt::Key_Refresh, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Favorites, Qt::Key_Favorites, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioMedia, Qt::Key_LaunchMedia, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86OpenURL, Qt::Key_OpenUrl, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86HomePage, Qt::Key_HomePage, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Search, Qt::Key_Search, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioLowerVolume, Qt::Key_VolumeDown, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioMute, Qt::Key_VolumeMute, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioRaiseVolume, Qt::Key_VolumeUp, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioPlay, Qt::Key_MediaPlay, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioPause, Qt::Key_MediaPause, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioStop, Qt::Key_MediaStop, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioPrev, Qt::Key_MediaPrevious, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioNext, Qt::Key_MediaNext, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioRecord, Qt::Key_MediaRecord, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Mail, Qt::Key_LaunchMail, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MyComputer, Qt::Key_LaunchMedia, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Calculater, Qt::Key_Calculator, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Memo, Qt::Key_Memo, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ToDoList, Qt::Key_ToDoList, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Calendar, Qt::Key_Calendar, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86PowerDown, Qt::Key_PowerDown, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ContrastAdjust, Qt::Key_ContrastAdjust, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Standby, Qt::Key_Standby, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MonBrightnessUp, Qt::Key_MonBrightnessUp, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MonBrightnessDown, Qt::Key_MonBrightnessDown, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86KbdLightOnOff, Qt::Key_KeyboardLightOnOff, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86KbdBrightnessUp, Qt::Key_KeyboardBrightnessUp, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86KbdBrightnessDown, Qt::Key_KeyboardBrightnessDown, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86PowerOff, Qt::Key_PowerOff, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86WakeUp, Qt::Key_WakeUp, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Eject, Qt::Key_Eject, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ScreenSaver, Qt::Key_ScreenSaver, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86WWW, Qt::Key_WWW, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Sleep, Qt::Key_Sleep, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LightBulb, Qt::Key_LightBulb, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Shop, Qt::Key_Shop, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86History, Qt::Key_History, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AddFavorite, Qt::Key_AddFavorite, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86HotLinks, Qt::Key_HotLinks, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86BrightnessAdjust, Qt::Key_BrightnessAdjust, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Finance, Qt::Key_Finance, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Community, Qt::Key_Community, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioRewind, Qt::Key_AudioRewind, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86BackForward, Qt::Key_BackForward, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ApplicationLeft, Qt::Key_ApplicationLeft, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ApplicationRight, Qt::Key_ApplicationRight, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Book, Qt::Key_Book, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86CD, Qt::Key_CD, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Calculater, Qt::Key_Calculator, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Clear, Qt::Key_Clear, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ClearGrab, Qt::Key_ClearGrab, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Close, Qt::Key_Close, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Copy, Qt::Key_Copy, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Cut, Qt::Key_Cut, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Display, Qt::Key_Display, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86DOS, Qt::Key_DOS, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Documents, Qt::Key_Documents, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Excel, Qt::Key_Excel, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Explorer, Qt::Key_Explorer, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Game, Qt::Key_Game, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Go, Qt::Key_Go, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86iTouch, Qt::Key_iTouch, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LogOff, Qt::Key_LogOff, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Market, Qt::Key_Market, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Meeting, Qt::Key_Meeting, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MenuKB, Qt::Key_MenuKB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MenuPB, Qt::Key_MenuPB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MySites, Qt::Key_MySites, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86News, Qt::Key_News, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86OfficeHome, Qt::Key_OfficeHome, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Option, Qt::Key_Option, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Paste, Qt::Key_Paste, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Phone, Qt::Key_Phone, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Reply, Qt::Key_Reply, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Reload, Qt::Key_Reload, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86RotateWindows, Qt::Key_RotateWindows, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86RotationPB, Qt::Key_RotationPB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86RotationKB, Qt::Key_RotationKB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Save, Qt::Key_Save, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Send, Qt::Key_Send, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Spell, Qt::Key_Spell, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86SplitScreen, Qt::Key_SplitScreen, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Support, Qt::Key_Support, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86TaskPane, Qt::Key_TaskPane, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Terminal, Qt::Key_Terminal, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Tools, Qt::Key_Tools, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Travel, Qt::Key_Travel, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Video, Qt::Key_Video, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Word, Qt::Key_Word, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Xfer, Qt::Key_Xfer, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ZoomIn, Qt::Key_ZoomIn, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86ZoomOut, Qt::Key_ZoomOut, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Away, Qt::Key_Away, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Messenger, Qt::Key_Messenger, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86WebCam, Qt::Key_WebCam, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86MailForward, Qt::Key_MailForward, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Pictures, Qt::Key_Pictures, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Music, Qt::Key_Music, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Battery, Qt::Key_Battery, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Bluetooth, Qt::Key_Bluetooth, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86WLAN, Qt::Key_WLAN, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86UWB, Qt::Key_UWB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioForward, Qt::Key_AudioForward, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioRepeat, Qt::Key_AudioRepeat, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioRandomPlay, Qt::Key_AudioRandomPlay, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Subtitle, Qt::Key_Subtitle, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioCycleTrack, Qt::Key_AudioCycleTrack, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Time, Qt::Key_Time, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Select, Qt::Key_Select, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86View, Qt::Key_View, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86TopMenu, Qt::Key_TopMenu, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Bluetooth, Qt::Key_Bluetooth, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Suspend, Qt::Key_Suspend, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Hibernate, Qt::Key_Hibernate, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86TouchpadToggle, Qt::Key_TouchpadToggle, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86TouchpadOn, Qt::Key_TouchpadOn, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86TouchpadOff, Qt::Key_TouchpadOff, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86AudioMicMute, Qt::Key_MicMute, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch0, Qt::Key_Launch0, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch1, Qt::Key_Launch1, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch2, Qt::Key_Launch2, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch3, Qt::Key_Launch3, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch4, Qt::Key_Launch4, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch5, Qt::Key_Launch5, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch6, Qt::Key_Launch6, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch7, Qt::Key_Launch7, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch8, Qt::Key_Launch8, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86Launch9, Qt::Key_Launch9, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchA, Qt::Key_LaunchA, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchB, Qt::Key_LaunchB, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchC, Qt::Key_LaunchC, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchD, Qt::Key_LaunchD, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchE, Qt::Key_LaunchE, Qt::KeyboardModifiers()},
    {XKB_KEY_XF86LaunchF, Qt::Key_LaunchF, Qt::KeyboardModifiers()},

    // Latin-1
    {XKB_KEY_exclam, Qt::Key_Exclam, Qt::KeyboardModifiers()},
    {XKB_KEY_quotedbl, Qt::Key_QuoteDbl, Qt::KeyboardModifiers()},
    {XKB_KEY_numbersign, Qt::Key_NumberSign, Qt::KeyboardModifiers()},
    {XKB_KEY_dollar, Qt::Key_Dollar, Qt::KeyboardModifiers()},
    {XKB_KEY_percent, Qt::Key_Percent, Qt::KeyboardModifiers()},
    {XKB_KEY_ampersand, Qt::Key_Ampersand, Qt::KeyboardModifiers()},
    {XKB_KEY_apostrophe, Qt::Key_Apostrophe, Qt::KeyboardModifiers()},
    {XKB_KEY_parenleft, Qt::Key_ParenLeft, Qt::KeyboardModifiers()},
    {XKB_KEY_parenright, Qt::Key_ParenRight, Qt::KeyboardModifiers()},
    {XKB_KEY_asterisk, Qt::Key_Asterisk, Qt::KeyboardModifiers()},
    {XKB_KEY_plus, Qt::Key_Plus, Qt::KeyboardModifiers()},
    {XKB_KEY_comma, Qt::Key_Comma, Qt::KeyboardModifiers()},
    {XKB_KEY_minus, Qt::Key_Minus, Qt::KeyboardModifiers()},
    {XKB_KEY_period, Qt::Key_Period, Qt::KeyboardModifiers()},
    {XKB_KEY_slash, Qt::Key_Slash, Qt::KeyboardModifiers()},
    {XKB_KEY_0, Qt::Key_0, Qt::KeyboardModifiers()},
    {XKB_KEY_1, Qt::Key_1, Qt::KeyboardModifiers()},
    {XKB_KEY_2, Qt::Key_2, Qt::KeyboardModifiers()},
    {XKB_KEY_3, Qt::Key_3, Qt::KeyboardModifiers()},
    {XKB_KEY_4, Qt::Key_4, Qt::KeyboardModifiers()},
    {XKB_KEY_5, Qt::Key_5, Qt::KeyboardModifiers()},
    {XKB_KEY_6, Qt::Key_6, Qt::KeyboardModifiers()},
    {XKB_KEY_7, Qt::Key_7, Qt::KeyboardModifiers()},
    {XKB_KEY_8, Qt::Key_8, Qt::KeyboardModifiers()},
    {XKB_KEY_9, Qt::Key_9, Qt::KeyboardModifiers()},
    {XKB_KEY_colon, Qt::Key_Colon, Qt::KeyboardModifiers()},
    {XKB_KEY_semicolon, Qt::Key_Semicolon, Qt::KeyboardModifiers()},
    {XKB_KEY_less, Qt::Key_Less, Qt::KeyboardModifiers()},
    {XKB_KEY_equal, Qt::Key_Equal, Qt::KeyboardModifiers()},
    {XKB_KEY_greater, Qt::Key_Greater, Qt::KeyboardModifiers()},
    {XKB_KEY_question, Qt::Key_Question, Qt::KeyboardModifiers()},
    {XKB_KEY_at, Qt::Key_At, Qt::KeyboardModifiers()},
    {XKB_KEY_A, Qt::Key_A, Qt::ShiftModifier},
    {XKB_KEY_B, Qt::Key_B, Qt::ShiftModifier},
    {XKB_KEY_C, Qt::Key_C, Qt::ShiftModifier},
    {XKB_KEY_D, Qt::Key_D, Qt::ShiftModifier},
    {XKB_KEY_E, Qt::Key_E, Qt::ShiftModifier},
    {XKB_KEY_F, Qt::Key_F, Qt::ShiftModifier},
    {XKB_KEY_G, Qt::Key_G, Qt::ShiftModifier},
    {XKB_KEY_H, Qt::Key_H, Qt::ShiftModifier},
    {XKB_KEY_I, Qt::Key_I, Qt::ShiftModifier},
    {XKB_KEY_J, Qt::Key_J, Qt::ShiftModifier},
    {XKB_KEY_K, Qt::Key_K, Qt::ShiftModifier},
    {XKB_KEY_L, Qt::Key_L, Qt::ShiftModifier},
    {XKB_KEY_M, Qt::Key_M, Qt::ShiftModifier},
    {XKB_KEY_N, Qt::Key_N, Qt::ShiftModifier},
    {XKB_KEY_O, Qt::Key_O, Qt::ShiftModifier},
    {XKB_KEY_P, Qt::Key_P, Qt::ShiftModifier},
    {XKB_KEY_Q, Qt::Key_Q, Qt::ShiftModifier},
    {XKB_KEY_R, Qt::Key_R, Qt::ShiftModifier},
    {XKB_KEY_S, Qt::Key_S, Qt::ShiftModifier},
    {XKB_KEY_T, Qt::Key_T, Qt::ShiftModifier},
    {XKB_KEY_U, Qt::Key_U, Qt::ShiftModifier},
    {XKB_KEY_V, Qt::Key_V, Qt::ShiftModifier},
    {XKB_KEY_W, Qt::Key_W, Qt::ShiftModifier},
    {XKB_KEY_X, Qt::Key_X, Qt::ShiftModifier},
    {XKB_KEY_Y, Qt::Key_Y, Qt::ShiftModifier},
    {XKB_KEY_Z, Qt::Key_Z, Qt::ShiftModifier},
    {XKB_KEY_bracketleft, Qt::Key_BracketLeft, Qt::KeyboardModifiers()},
    {XKB_KEY_backslash, Qt::Key_Backslash, Qt::KeyboardModifiers()},
    {XKB_KEY_bracketright, Qt::Key_BracketRight, Qt::KeyboardModifiers()},
    {XKB_KEY_asciicircum, Qt::Key_AsciiCircum, Qt::KeyboardModifiers()},
    {XKB_KEY_underscore, Qt::Key_Underscore, Qt::KeyboardModifiers()},
    {XKB_KEY_quoteleft, Qt::Key_QuoteLeft, Qt::KeyboardModifiers()},
    {XKB_KEY_a, Qt::Key_A, Qt::KeyboardModifiers()},
    {XKB_KEY_b, Qt::Key_B, Qt::KeyboardModifiers()},
    {XKB_KEY_c, Qt::Key_C, Qt::KeyboardModifiers()},
    {XKB_KEY_d, Qt::Key_D, Qt::KeyboardModifiers()},
    {XKB_KEY_e, Qt::Key_E, Qt::KeyboardModifiers()},
    {XKB_KEY_f, Qt::Key_F, Qt::KeyboardModifiers()},
    {XKB_KEY_g, Qt::Key_G, Qt::KeyboardModifiers()},
    {XKB_KEY_h, Qt::Key_H, Qt::KeyboardModifiers()},
    {XKB_KEY_i, Qt::Key_I, Qt::KeyboardModifiers()},
    {XKB_KEY_j, Qt::Key_J, Qt::KeyboardModifiers()},
    {XKB_KEY_k, Qt::Key_K, Qt::KeyboardModifiers()},
    {XKB_KEY_l, Qt::Key_L, Qt::KeyboardModifiers()},
    {XKB_KEY_m, Qt::Key_M, Qt::KeyboardModifiers()},
    {XKB_KEY_n, Qt::Key_N, Qt::KeyboardModifiers()},
    {XKB_KEY_o, Qt::Key_O, Qt::KeyboardModifiers()},
    {XKB_KEY_p, Qt::Key_P, Qt::KeyboardModifiers()},
    {XKB_KEY_q, Qt::Key_Q, Qt::KeyboardModifiers()},
    {XKB_KEY_r, Qt::Key_R, Qt::KeyboardModifiers()},
    {XKB_KEY_s, Qt::Key_S, Qt::KeyboardModifiers()},
    {XKB_KEY_t, Qt::Key_T, Qt::KeyboardModifiers()},
    {XKB_KEY_u, Qt::Key_U, Qt::KeyboardModifiers()},
    {XKB_KEY_v, Qt::Key_V, Qt::KeyboardModifiers()},
    {XKB_KEY_w, Qt::Key_W, Qt::KeyboardModifiers()},
    {XKB_KEY_x, Qt::Key_X, Qt::KeyboardModifiers()},
    {XKB_KEY_y, Qt::Key_Y, Qt::KeyboardModifiers()},
    {XKB_KEY_z, Qt::Key_Z, Qt::KeyboardModifiers()},
    {XKB_KEY_braceleft, Qt::Key_BraceLeft, Qt::KeyboardModifiers()},
    {XKB_KEY_bar, Qt::Key_Bar, Qt::KeyboardModifiers()},
    {XKB_KEY_braceright, Qt::Key_BraceRight, Qt::KeyboardModifiers()},
    {XKB_KEY_asciitilde, Qt::Key_AsciiTilde, Qt::KeyboardModifiers()},

    {XKB_KEY_nobreakspace, Qt::Key_nobreakspace, Qt::KeyboardModifiers()},
    {XKB_KEY_exclamdown, Qt::Key_exclamdown, Qt::KeyboardModifiers()},
    {XKB_KEY_cent, Qt::Key_cent, Qt::KeyboardModifiers()},
    {XKB_KEY_sterling, Qt::Key_sterling, Qt::KeyboardModifiers()},
    {XKB_KEY_currency, Qt::Key_currency, Qt::KeyboardModifiers()},
    {XKB_KEY_yen, Qt::Key_yen, Qt::KeyboardModifiers()},
    {XKB_KEY_brokenbar, Qt::Key_brokenbar, Qt::KeyboardModifiers()},
    {XKB_KEY_section, Qt::Key_section, Qt::KeyboardModifiers()},
    {XKB_KEY_diaeresis, Qt::Key_diaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_copyright, Qt::Key_copyright, Qt::KeyboardModifiers()},
    {XKB_KEY_ordfeminine, Qt::Key_ordfeminine, Qt::KeyboardModifiers()},
    {XKB_KEY_guillemotleft, Qt::Key_guillemotleft, Qt::KeyboardModifiers()},
    {XKB_KEY_notsign, Qt::Key_notsign, Qt::KeyboardModifiers()},
    {XKB_KEY_hyphen, Qt::Key_hyphen, Qt::KeyboardModifiers()},
    {XKB_KEY_registered, Qt::Key_registered, Qt::KeyboardModifiers()},
    {XKB_KEY_macron, Qt::Key_macron, Qt::KeyboardModifiers()},
    {XKB_KEY_degree, Qt::Key_degree, Qt::KeyboardModifiers()},
    {XKB_KEY_plusminus, Qt::Key_plusminus, Qt::KeyboardModifiers()},
    {XKB_KEY_twosuperior, Qt::Key_twosuperior, Qt::KeyboardModifiers()},
    {XKB_KEY_threesuperior, Qt::Key_threesuperior, Qt::KeyboardModifiers()},
    {XKB_KEY_acute, Qt::Key_acute, Qt::KeyboardModifiers()},
    {XKB_KEY_mu, Qt::Key_mu, Qt::KeyboardModifiers()},
    {XKB_KEY_paragraph, Qt::Key_paragraph, Qt::KeyboardModifiers()},
    {XKB_KEY_periodcentered, Qt::Key_periodcentered, Qt::KeyboardModifiers()},
    {XKB_KEY_cedilla, Qt::Key_cedilla, Qt::KeyboardModifiers()},
    {XKB_KEY_onesuperior, Qt::Key_onesuperior, Qt::KeyboardModifiers()},
    {XKB_KEY_masculine, Qt::Key_masculine, Qt::KeyboardModifiers()},
    {XKB_KEY_guillemotright, Qt::Key_guillemotright, Qt::KeyboardModifiers()},
    {XKB_KEY_onequarter, Qt::Key_onequarter, Qt::KeyboardModifiers()},
    {XKB_KEY_onehalf, Qt::Key_onehalf, Qt::KeyboardModifiers()},
    {XKB_KEY_threequarters, Qt::Key_threequarters, Qt::KeyboardModifiers()},
    {XKB_KEY_questiondown, Qt::Key_questiondown, Qt::KeyboardModifiers()},
    {XKB_KEY_Agrave, Qt::Key_Agrave, Qt::ShiftModifier},
    {XKB_KEY_Aacute, Qt::Key_Aacute, Qt::ShiftModifier},
    {XKB_KEY_Acircumflex, Qt::Key_Acircumflex, Qt::ShiftModifier},
    {XKB_KEY_Atilde, Qt::Key_Atilde, Qt::ShiftModifier},
    {XKB_KEY_Adiaeresis, Qt::Key_Adiaeresis, Qt::ShiftModifier},
    {XKB_KEY_Aring, Qt::Key_Aring, Qt::ShiftModifier},
    {XKB_KEY_AE, Qt::Key_AE, Qt::ShiftModifier},
    {XKB_KEY_Ccedilla, Qt::Key_Ccedilla, Qt::ShiftModifier},
    {XKB_KEY_Egrave, Qt::Key_Egrave, Qt::ShiftModifier},
    {XKB_KEY_Eacute, Qt::Key_Eacute, Qt::ShiftModifier},
    {XKB_KEY_Ecircumflex, Qt::Key_Ecircumflex, Qt::ShiftModifier},
    {XKB_KEY_Ediaeresis, Qt::Key_Ediaeresis, Qt::ShiftModifier},
    {XKB_KEY_Igrave, Qt::Key_Igrave, Qt::ShiftModifier},
    {XKB_KEY_Iacute, Qt::Key_Iacute, Qt::ShiftModifier},
    {XKB_KEY_Icircumflex, Qt::Key_Icircumflex, Qt::ShiftModifier},
    {XKB_KEY_Idiaeresis, Qt::Key_Idiaeresis, Qt::ShiftModifier},
    {XKB_KEY_ETH, Qt::Key_ETH, Qt::ShiftModifier},
    {XKB_KEY_Ntilde, Qt::Key_Ntilde, Qt::ShiftModifier},
    {XKB_KEY_Ograve, Qt::Key_Ograve, Qt::ShiftModifier},
    {XKB_KEY_Oacute, Qt::Key_Oacute, Qt::ShiftModifier},
    {XKB_KEY_Ocircumflex, Qt::Key_Ocircumflex, Qt::ShiftModifier},
    {XKB_KEY_Otilde, Qt::Key_Otilde, Qt::ShiftModifier},
    {XKB_KEY_Odiaeresis, Qt::Key_Odiaeresis, Qt::ShiftModifier},
    {XKB_KEY_multiply, Qt::Key_multiply, Qt::ShiftModifier},
    {XKB_KEY_Ooblique, Qt::Key_Ooblique, Qt::ShiftModifier},
    {XKB_KEY_Ugrave, Qt::Key_Ugrave, Qt::ShiftModifier},
    {XKB_KEY_Uacute, Qt::Key_Uacute, Qt::ShiftModifier},
    {XKB_KEY_Ucircumflex, Qt::Key_Ucircumflex, Qt::ShiftModifier},
    {XKB_KEY_Udiaeresis, Qt::Key_Udiaeresis, Qt::ShiftModifier},
    {XKB_KEY_Yacute, Qt::Key_Yacute, Qt::ShiftModifier},
    {XKB_KEY_THORN, Qt::Key_THORN, Qt::ShiftModifier},
    {XKB_KEY_ssharp, Qt::Key_ssharp, Qt::KeyboardModifiers()},
    {XKB_KEY_agrave, Qt::Key_Agrave, Qt::KeyboardModifiers()},
    {XKB_KEY_aacute, Qt::Key_Aacute, Qt::KeyboardModifiers()},
    {XKB_KEY_acircumflex, Qt::Key_Acircumflex, Qt::KeyboardModifiers()},
    {XKB_KEY_atilde, Qt::Key_Atilde, Qt::KeyboardModifiers()},
    {XKB_KEY_adiaeresis, Qt::Key_Adiaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_aring, Qt::Key_Aring, Qt::KeyboardModifiers()},
    {XKB_KEY_ae, Qt::Key_AE, Qt::KeyboardModifiers()},
    {XKB_KEY_ccedilla, Qt::Key_Ccedilla, Qt::KeyboardModifiers()},
    {XKB_KEY_egrave, Qt::Key_Egrave, Qt::KeyboardModifiers()},
    {XKB_KEY_eacute, Qt::Key_Eacute, Qt::KeyboardModifiers()},
    {XKB_KEY_ecircumflex, Qt::Key_Ecircumflex, Qt::KeyboardModifiers()},
    {XKB_KEY_ediaeresis, Qt::Key_Ediaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_igrave, Qt::Key_Igrave, Qt::KeyboardModifiers()},
    {XKB_KEY_iacute, Qt::Key_Iacute, Qt::KeyboardModifiers()},
    {XKB_KEY_icircumflex, Qt::Key_Icircumflex, Qt::KeyboardModifiers()},
    {XKB_KEY_idiaeresis, Qt::Key_Idiaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_eth, Qt::Key_ETH, Qt::KeyboardModifiers()},
    {XKB_KEY_ntilde, Qt::Key_Ntilde, Qt::KeyboardModifiers()},
    {XKB_KEY_ograve, Qt::Key_Ograve, Qt::KeyboardModifiers()},
    {XKB_KEY_oacute, Qt::Key_Oacute, Qt::KeyboardModifiers()},
    {XKB_KEY_ocircumflex, Qt::Key_Ocircumflex, Qt::KeyboardModifiers()},
    {XKB_KEY_otilde, Qt::Key_Otilde, Qt::KeyboardModifiers()},
    {XKB_KEY_odiaeresis, Qt::Key_Odiaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_division, Qt::Key_division, Qt::KeyboardModifiers()},
    {XKB_KEY_ooblique, Qt::Key_Ooblique, Qt::KeyboardModifiers()},
    {XKB_KEY_ugrave, Qt::Key_Ugrave, Qt::KeyboardModifiers()},
    {XKB_KEY_uacute, Qt::Key_Uacute, Qt::KeyboardModifiers()},
    {XKB_KEY_ucircumflex, Qt::Key_Ucircumflex, Qt::KeyboardModifiers()},
    {XKB_KEY_udiaeresis, Qt::Key_Udiaeresis, Qt::KeyboardModifiers()},
    {XKB_KEY_yacute, Qt::Key_Yacute, Qt::KeyboardModifiers()},
    {XKB_KEY_thorn, Qt::Key_THORN, Qt::KeyboardModifiers()},
    {XKB_KEY_ydiaeresis, Qt::Key_ydiaeresis, Qt::KeyboardModifiers()},

    // Numpad
    {XKB_KEY_KP_0, Qt::Key_0, Qt::KeypadModifier},
    {XKB_KEY_KP_1, Qt::Key_1, Qt::KeypadModifier},
    {XKB_KEY_KP_2, Qt::Key_2, Qt::KeypadModifier},
    {XKB_KEY_KP_3, Qt::Key_3, Qt::KeypadModifier},
    {XKB_KEY_KP_4, Qt::Key_4, Qt::KeypadModifier},
    {XKB_KEY_KP_5, Qt::Key_5, Qt::KeypadModifier},
    {XKB_KEY_KP_6, Qt::Key_6, Qt::KeypadModifier},
    {XKB_KEY_KP_7, Qt::Key_7, Qt::KeypadModifier},
    {XKB_KEY_KP_8, Qt::Key_8, Qt::KeypadModifier},
    {XKB_KEY_KP_9, Qt::Key_9, Qt::KeypadModifier},
    {XKB_KEY_KP_Space, Qt::Key_Space, Qt::KeypadModifier},
    {XKB_KEY_KP_Tab, Qt::Key_Tab, Qt::KeypadModifier},
    {XKB_KEY_KP_Enter, Qt::Key_Enter, Qt::KeypadModifier},
    {XKB_KEY_KP_Home, Qt::Key_Home, Qt::KeypadModifier},
    {XKB_KEY_KP_Left, Qt::Key_Left, Qt::KeypadModifier},
    {XKB_KEY_KP_Up, Qt::Key_Up, Qt::KeypadModifier},
    {XKB_KEY_KP_Right, Qt::Key_Right, Qt::KeypadModifier},
    {XKB_KEY_KP_Down, Qt::Key_Down, Qt::KeypadModifier},
    {XKB_KEY_KP_Prior, Qt::Key_PageUp, Qt::KeypadModifier},
    {XKB_KEY_KP_Next, Qt::Key_PageDown, Qt::KeypadModifier},
    {XKB_KEY_KP_End, Qt::Key_End, Qt::KeypadModifier},
    {XKB_KEY_KP_Begin, Qt::Key_Clear, Qt::KeypadModifier},
    {XKB_KEY_KP_Insert, Qt::Key_Insert, Qt::KeypadModifier},
    {XKB_KEY_KP_Delete, Qt::Key_Delete, Qt::KeypadModifier},
    {XKB_KEY_KP_Equal, Qt::Key_Equal, Qt::KeypadModifier},
    {XKB_KEY_KP_Multiply, Qt::Key_Asterisk, Qt::KeypadModifier},
    {XKB_KEY_KP_Add, Qt::Key_Plus, Qt::KeypadModifier},
    {XKB_KEY_KP_Separator, Qt::Key_Comma, Qt::KeypadModifier},
    {XKB_KEY_KP_Subtract, Qt::Key_Minus, Qt::KeypadModifier},
    {XKB_KEY_KP_Decimal, Qt::Key_Period, Qt::KeypadModifier},
    {XKB_KEY_KP_Divide, Qt::Key_Slash, Qt::KeypadModifier},

};

void XkbTest::testToQtKey_data()
{
    QTest::addColumn<Qt::Key>("qt");
    QTest::addColumn<xkb_keysym_t>("keySym");
    for (std::size_t i = 0; i < sizeof(g_rgQtToSymX) / sizeof(TransKey); i++) {
        const QByteArray row = QByteArray::number(g_rgQtToSymX[i].keySymX, 16);
        QTest::newRow(row.constData()) << g_rgQtToSymX[i].keySymQt << g_rgQtToSymX[i].keySymX;
    }
}

void XkbTest::testToQtKey()
{
    Xkb xkb;
    QFETCH(xkb_keysym_t, keySym);
    QTEST(xkb.toQtKey(keySym), "qt");
}

QTEST_MAIN(XkbTest)
#include "test_xkb.moc"
