/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-10-22
 * Description : a widget to filter album contents by type mime
 *
 * Copyright (C) 2007-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include "mimefilter.moc"

// KDE includes


#include <klocale.h>
#include <kglobal.h>


namespace Digikam
{

MimeFilter::MimeFilter(QWidget* parent)
          : KComboBox(parent)
{
    insertItem( AllFiles,    i18n("All Files") );
    insertItem( ImageFiles,  i18n("Image Files") );
    insertItem( NoRAWFiles,  i18n("No RAW Files") );
    insertItem( JPGFiles,    i18n("JPEG Files") );
    insertItem( PNGFiles,    i18n("PNG Files") );
    insertItem( TIFFiles,    i18n("TIFF Files") );
    insertItem( DNGFiles,    i18n("DNG Files") );
    insertItem( RAWFiles,    i18n("RAW Files") );
    insertItem( MoviesFiles, i18n("Movie Files") );
    insertItem( AudioFiles,  i18n("Audio Files") );

    setToolTip(i18n("Filter by file type"));
    setWhatsThis(i18n("Select the file types (mime types) that you want shown"));

    setMimeFilter(AllFiles);
}

MimeFilter::~MimeFilter()
{
}

void MimeFilter::setMimeFilter(int filter)
{
    setCurrentIndex(filter);
    emit activated(filter);
}

int MimeFilter::mimeFilter()
{
    return currentIndex();
}

}  // namespace Digikam
