/***************************************************************************
                          gphoto_interface.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPHOTO_INTERFACE_H
#define GPHOTO_INTERFACE_H


/**
  *@author Renchi Raju
  */

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qobject.h>
#include <qpixmap.h>

extern "C" {
	#include <stdio.h>
	#include <gphoto2.h>
}

#include "gphoto_status.h"
#include "thumbnail_mt.h"
#include "list_mt.h"
#include "camera_fileinfo.h"

/* ************************************************************************
   Camera Errors:
   ErrorGphotoSetup:         Failure to setup camera
   ErrorGphotoInit:          Failure to initialize camera
   ErrorGphotoThumb:         Failure to Download a Thumbnail
   ErrorGphotoImage:         Failure to Download an Image
   ErrorGphotoImageName:     Failure to get image name
   ErrorGphotoImageDel:      Failure to delete image
   ErrorGphotoFolder:        Failure to get Folder List/Names
   ErrorGphotoFolderFiles:   Failure to get file list from Folder
   ErrorGphotoFolderMake:    Failure to create Folder
   ErrorGphotoFolderDel:     Failure to delete folder
   ErrorGphotoUnknown:       Unknown Error
   ErrorGphotoSuccess:       Successful Operation

   ************************************************************************ */

enum Gphoto_InterfaceErrors {ErrorGphotoSetup, ErrorGphotoInit,
			     ErrorGphotoThumb, ErrorGphotoImage,
			     ErrorGphotoImageName, ErrorGphotoImageDel,
			     ErrorGphotoFolderFiles, ErrorGphotoFolderMake,
			     ErrorGphotoFolderDel,
			     ErrorGphotoFolder, ErrorGphotoSuccess};



class Gphoto_Interface {

public:

    Gphoto_Interface();
    ~Gphoto_Interface();


    // Camera Operation functions
    int initializeCamera();

    int getSubFolders(QString folder, QStringList& subFolderList,
                      QStringList& subFolderNameList,
                      int& numSubFolders);

    int getFilesInformation(const QString& folder,
                            List_MT<Camera_FileInfo>& infoList);


    int getImageNames(QString folder, QStringList& imagesList,
                      QStringList& imagesInfoList);
    void getThumbNail(QString folder, QString imageName, Thumbnail_MT& thumb);
    int downloadImage(QString folder, QString imageName, QString saveFile);
    int deleteImage(QString folder, QString imageName);
    int makeDir(QString folder, QString newFolder);

    // Query functions
    bool isCameraInitialised();
    bool cameraSupportsThumbNails();
    bool cameraSupportsDelete();
    bool cameraSupportsUpload();
    bool cameraSupportsMkDir();
    bool cameraSupportsDelDir();

    // setup functions
    void getSupportedCameras(QStringList& cameraList, int& numSupported);
    void getSupportedPorts(QStringList& portList);
    void getCameraSettings(QString& cameraModel, QString& cameraPort);
    void saveCameraSettings(QString cameraModel, QString cameraPort);
    void getCameraPorts(QString cameraModel, QStringList& supportedPorts);
    int  autoDetectCamera(QString& cameraModel, QString& cameraPort);

    // camera information functions
    void getCameraSummary(QString& cameraSummary);
    void getCameraManual(QString& cameraManual);
    void getCameraAbout(QString& cameraAbout);

private:

    Camera *my_camera;
    CameraAbilities my_cameraAbilities;
    GPContext *glob_context;
    QString my_cameraModel;
    QString my_cameraPort;
    QString my_cameraPortPath;

    bool my_cameraInitialised;

    bool my_cameraSupportsThumbNails;
    bool my_cameraSupportsDelete;
    bool my_cameraSupportsUpload;
    bool my_cameraSupportsMkDir;
    bool my_cameraSupportsDelDir;

    int  setupCamera();
    void getCameraAbilities();


};



#endif
