#include <kaction.h>
#include <kstdaction.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <ksimpleconfig.h>
#include <kconfig.h>

#include <qlabel.h>
#include <qwhatsthis.h>

#include "digikam.h"
#include "camera_browser.h"
#include "setup.h"


Digikam::Digikam() : KMainWindow( 0, "digikam" ) {

    config=kapp->config();
    
    m_camThumbSize = ThumbnailSize::Large;

    m_view = new Digikam_View(this);

    setCentralWidget(m_view);
    setupActions();
    setupConnections();
    loadSettings();

    setAutoSaveSettings();
    applyMainWindowSettings (config);

    cameraModel = m_view->m_cameraBrowser->cameraModel();
    cameraPort = m_view->m_cameraBrowser->cameraPort();

}


Digikam::~Digikam() {

    delete m_view;
}


void Digikam::setupActions() {

    camConnectAction = new KAction(i18n("Connect"), "connect_established", 0,
                                      this, SLOT( slot_camConnect() ),
                                      actionCollection(), "cam_connect");
    camConnectAction->setWhatsThis( i18n("Establish Connection with the Camera") );


    camDisconnectAction = new KAction(i18n("Disconnect"), "connect_no", 0,
                                      this, SLOT( slot_camDisconnect() ),
                                      actionCollection(), "cam_disconnect");
    camDisconnectAction->setWhatsThis( i18n("Disconnect from the the Camera") );
    camDisconnectAction->setEnabled(false);


    camCancelAction = new KAction( i18n("Stop"), "stop", 0,
                                   this, SLOT(slot_camCancel()),
                                   actionCollection(), "cam_cancel");
    camCancelAction->setWhatsThis( i18n("Cancel Operations being Performed") );
    camCancelAction->setEnabled(false);


    camDownloadAction = new KActionMenu ( i18n("Download Images"), "filesave", 
					  this, "cam_download");
    camDownloadAction->setWhatsThis( i18n("Download Images from the camera") );
    camDownloadAction->setDelayed(false);
    camDownloadAction->setEnabled(false);
    actionCollection()->insert(camDownloadAction);

    camDownloadSelectedAction = new KAction( i18n("Selected"), 0, 
					     this, SLOT(slot_camDownload()),
					     actionCollection());
    camDownloadAllAction = new KAction( i18n("All"), 0, 
					this, SLOT(slot_camDownloadAll()),
					actionCollection());

    camDownloadAction->insert(camDownloadSelectedAction);
    camDownloadAction->insert(camDownloadAllAction);

    
    camDeleteAction = new KActionMenu ( i18n("Delete Images"), "edittrash", 
					this, "cam_delete");
    camDeleteAction->setWhatsThis( i18n("Delete Images from the camera") );
    camDeleteAction->setDelayed(false);
    camDeleteAction->setEnabled(false);
    actionCollection()->insert(camDeleteAction);

    camDeleteSelectedAction = new KAction( i18n("Selected"), 0, 
					   this, SLOT(slot_camDelete()),
					   actionCollection());
    camDeleteAllAction = new KAction( i18n("All"), 0, 
				      this, SLOT(slot_camDeleteAll()),
				      actionCollection());

    camDeleteAction->insert(camDeleteSelectedAction);
    camDeleteAction->insert(camDeleteAllAction);


    camSelectAllAction = new KAction( i18n("All"), 0,
				      this, SLOT(slot_camSelectAll()),
				      actionCollection(), "cam_selectAll");
    camSelectAllAction->setEnabled(false);

    camSelectNoneAction = new KAction( i18n("None"), 0,
				      this, SLOT(slot_camSelectNone()),
				      actionCollection(), "cam_selectNone");
    camSelectNoneAction->setEnabled(false);

    camSelectInvertAction = new KAction( i18n("Invert"), 0,
				      this, SLOT(slot_camSelectInvert()),
				      actionCollection(), "cam_selectInvert");
    camSelectInvertAction->setEnabled(false);



    camFolderHideAction = new KToggleAction(i18n("Hide Camera Folders"), 0, 0,
                             this, SLOT( slot_camHideFolders() ),
                             actionCollection(), "cam_folderhide");
    (void) new KToggleAction(i18n("Hide Camera StatusBar"), 0, 0,
                             this, SLOT( slot_camHideStatusBar() ),
                             actionCollection(), "cam_statusbarhide");


    camSetupAction = new KAction(i18n("Setup"), "configure", 0,
                                      this, SLOT( slot_camSetup() ),
                                      actionCollection(), "cam_setup");
    camSetupAction->setWhatsThis( i18n("Configure application setup") );


    camThumbSizePlusAction = new KAction(i18n("Increase Thumb Size"), 
					 "viewmag+", 0, 
					 this, SLOT( slot_camThumbSizePlus() ),
					 actionCollection(),
					 "cam_thumbsizeIncrease");
    camThumbSizePlusAction->setWhatsThis( i18n("Increase Thumbnail Size"));
    camThumbSizePlusAction->setEnabled(false);

    camThumbSizeMinusAction = new KAction(i18n("Decrease Thumb Size"), 
					  "viewmag-", 0, this, 
					  SLOT( slot_camThumbSizeMinus() ),
					  actionCollection(),
					  "cam_thumbsizeDecrease");
    camThumbSizeMinusAction->setWhatsThis( i18n("Decrease Thumbnail Size"));


    appWhatsThisAction = KStdAction::whatsThis(this, SLOT(slot_whatsthis()),
                                               actionCollection(), "app_whatsthis");
    appWhatsThisAction->setWhatsThis( i18n("Click on a Button/Menu to get Information about its function"));
    appQuitAction = KStdAction::quit(this, SLOT(slot_exit()),
                                     actionCollection(), "app_exit");
    appQuitAction->setWhatsThis( i18n("Exit Application") );

    createGUI();

}


void Digikam::setupConnections()
{

  connect(m_view->m_cameraBrowser, SIGNAL( signal_cameraConnected() ),
	  this, SLOT( slot_camConnected() ));
  
  connect(m_view->m_cameraBrowser, SIGNAL( signal_startedProcessing() ),
	  this, SLOT( slot_camStartedProcessing() ));
  connect(m_view->m_cameraBrowser, SIGNAL( signal_stoppedProcessing() ),
	  this, SLOT( slot_camStoppedProcessing() ));

}


void Digikam::setcamActionsState()
{


}


void Digikam::loadSettings() {

  KSimpleConfig* simpleConfig = new KSimpleConfig("digikamrc");
  simpleConfig->setGroup("General Settings");
  
  if (simpleConfig->readEntry("Default Download Directory") != NULL) {
    
    config_defaultDownloadDir = 
      simpleConfig->readEntry("Default Download Directory");
    
    m_view->m_cameraBrowser->setDefaultDownloadDir(config_defaultDownloadDir);

  }

  config_showThumbNails = !(simpleConfig->readBoolEntry("No ThumbNails on Startup"));
  m_view->m_cameraBrowser->checkThumbnailsButton(config_showThumbNails);
  

  config_showGlobalFolder = simpleConfig->readBoolEntry("Show All Images on Startup");
  m_view->m_cameraBrowser->startWithGlobalFolder(config_showGlobalFolder);

  config_hideCameraFolders = simpleConfig->readBoolEntry("Don't Show Camera Folders");
  m_view->m_cameraBrowser->camera_hideFolders(config_hideCameraFolders);
  if (config_hideCameraFolders)
    camFolderHideAction->setChecked(true);
  else
    camFolderHideAction->setChecked(false);

  config_connectStartup = simpleConfig->readBoolEntry("Connect on Startup");
  if (config_connectStartup) slot_camConnect();

  delete simpleConfig;

}


void Digikam::slot_camSetup() {

  Setup *setup = new Setup();
  connect(setup, SIGNAL( finished() ),
	  this, SLOT( slot_camSetupFinished() ) );
  
  setup->show();

}

void Digikam::slot_camSetupFinished() {
  
  QString cameraModelNew(m_view->m_cameraBrowser->cameraModel());
  QString cameraPortNew(m_view->m_cameraBrowser->cameraPort());
  
  if ((cameraModel != cameraModelNew) || (cameraPort != cameraPortNew)) {
    
    cameraModel = cameraModelNew;
    cameraPort = cameraPortNew;

    slot_camDisconnect();

  }

  loadSettings();

}


void Digikam::slot_camConnect()
{
  m_view->m_cameraBrowser->camera_connect();

}

void Digikam::slot_camDisconnect()
{
  m_view->m_cameraBrowser->camera_disconnect();

  camConnectAction->setEnabled(true);
  camDisconnectAction->setEnabled(false);
  camCancelAction->setEnabled(false);
  camDownloadAction->setEnabled(false);
  camDeleteAction->setEnabled(false);
  camSelectAllAction->setEnabled(false);
  camSelectNoneAction->setEnabled(false);
  camSelectInvertAction->setEnabled(false);

}

void Digikam::slot_camDownload()
{
    m_view->m_cameraBrowser->camera_download();
}

void Digikam::slot_camDownloadAll()
{
    m_view->m_cameraBrowser->camera_downloadAll();
}


void Digikam::slot_camDelete() 
{
  m_view->m_cameraBrowser->camera_delete();
}

void Digikam::slot_camDeleteAll() 
{
  m_view->m_cameraBrowser->camera_deleteAll();
}

void Digikam::slot_camCancel()
{
    m_view->m_cameraBrowser->camera_cancel();
}


void  Digikam::slot_camConnected()
{
  camConnectAction->setEnabled(false);
  camDisconnectAction->setEnabled(true);
  camCancelAction->setEnabled(false);
  camDownloadAction->setEnabled(true);
  camDeleteAction->setEnabled(true);
  camSelectAllAction->setEnabled(true);
  camSelectNoneAction->setEnabled(true);
  camSelectInvertAction->setEnabled(true);

}


void Digikam::slot_camStartedProcessing()
{
    camDisconnectAction->setEnabled(false);
    camCancelAction->setEnabled(true);
    camDownloadAction->setEnabled(false);
    camDeleteAction->setEnabled(false);
}

void Digikam::slot_camStoppedProcessing()
{
    camDisconnectAction->setEnabled(true);
    camCancelAction->setEnabled(false);
    camDownloadAction->setEnabled(true);
    camDeleteAction->setEnabled(true);
}


void Digikam::slot_camSelectAll()
{
    m_view->m_cameraBrowser->camera_setSelection(Camera_Browser::All); 
}

void Digikam::slot_camSelectNone()
{
  m_view->m_cameraBrowser->camera_setSelection(Camera_Browser::None); 
}

void Digikam::slot_camSelectInvert()
{
  m_view->m_cameraBrowser->camera_setSelection(Camera_Browser::Invert); 
}


void Digikam::slot_camHideFolders()
{

    m_view->m_cameraBrowser->camera_hideFolders();

}

void Digikam::slot_camHideStatusBar()
{
    m_view->m_cameraBrowser->camera_hideStatusBar();
}

void Digikam::slot_camThumbSizePlus() {

  switch(m_camThumbSize) {

  case(ThumbnailSize::Large): {
    camThumbSizePlusAction->setEnabled(false);
    camThumbSizeMinusAction->setEnabled(true);
    break;
  }

  case(ThumbnailSize::Med): {
    m_camThumbSize = ThumbnailSize::Large;
    camThumbSizePlusAction->setEnabled(false);
    camThumbSizeMinusAction->setEnabled(true);
    break;
  }

  case(ThumbnailSize::Small): {
    m_camThumbSize = ThumbnailSize::Med;
    camThumbSizePlusAction->setEnabled(true);
    camThumbSizeMinusAction->setEnabled(true);
    break;
  }

  }

  m_view->m_cameraBrowser->setThumbnailSize(m_camThumbSize);

}



void Digikam::slot_camThumbSizeMinus() {

  switch(m_camThumbSize) {

  case(ThumbnailSize::Large): {
    m_camThumbSize = ThumbnailSize::Med;
    camThumbSizePlusAction->setEnabled(true);
    camThumbSizeMinusAction->setEnabled(true);
    break;
  }

  case(ThumbnailSize::Med): {
    m_camThumbSize = ThumbnailSize::Small;
    camThumbSizePlusAction->setEnabled(true);
    camThumbSizeMinusAction->setEnabled(false);
    break;
  }

  case(ThumbnailSize::Small): {
    camThumbSizePlusAction->setEnabled(true);
    camThumbSizeMinusAction->setEnabled(false);
    break;
  }

  }

  m_view->m_cameraBrowser->setThumbnailSize(m_camThumbSize);

}

void Digikam::slot_whatsthis()
{
    QWhatsThis::enterWhatsThisMode();

}

void Digikam::slot_exit()
{
    close();
}
