/***************************************************************************
                          camera_iconview.cpp  -  description
                             -------------------
    begin                : Sat Jan 5 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qpixmap.h>

#include "camera_iconview.h"
#include "camera_folder.h"


Camera_IconView::Camera_IconView(QWidget* parent, Camera_Folder* folder):
  KIconView(parent) {

  setMode(KIconView::Select);
  setGridX(90);
  setGridY(90);
  setAutoArrange(true);
  setSorting(true);
  setResizeMode(QIconView::Adjust);
  setWordWrapIconText(true);
  setSelectionMode(QIconView::Extended);
  setItemsMovable(false);

  m_cameraFolder = folder;

}

Camera_IconView::~Camera_IconView(){

  m_cameraFolder = NULL;
}

Camera_Folder* Camera_IconView::cameraFolder() const {

  return m_cameraFolder;

}

void Camera_IconView::arrangeItemsInGrid() {

  if (firstItem()) {

    setGridX(firstItem()->pixmap()->width()+30);
    setGridY(firstItem()->pixmap()->height()+20);

  }

  QIconView::arrangeItemsInGrid(true);

}



