#ifndef CAMERA_FILEINFO_H
#define CAMERA_FILEINFO_H

#include <qstring.h>


class Camera_FileInfo {

public:

    Camera_FileInfo();
    ~Camera_FileInfo() {}

    Camera_FileInfo(const Camera_FileInfo& fileInfo);
    Camera_FileInfo& operator=(const Camera_FileInfo& fileInfo);


    void setName(const QString& name);
    QString getName() const;

    void setFolder(const QString& folder);
    QString getFolder() const;

    //----------------------------

    void setFileInfoAvailable(bool avail);
    bool isFileInfoAvailable();

    void setMime(const QString& mime);
    QString getMime() const;

    void setTime(const QString& time);
    QString getTime() const;

    void setSize(int size);
    int getSize();

    void setWidth(int width);
    int getWidth();

    void setHeight(int height);
    int getHeight();

    void setReadPermissions(int readPerms);
    int getReadPermissions();

    void setDeletePermissions(int readPerms);
    int getDeletePermissions();

    void setDownloaded(int downloaded);
    int getDownloaded();

    //----------------------------

    void setPreviewInfoAvailable(bool avail);
    bool isPreviewInfoAvailable();

    void setPreviewMime(const QString& mime);
    QString getPreviewMime() const;

    void setPreviewWidth(int width);
    int getPreviewWidth();

    void setPreviewHeight(int height);
    int getPreviewHeight();

    void setPreviewSize(int size);
    int getPreviewSize();

    void setPreviewDownloaded(int downloaded);
    int getPreviewDownloaded();

    //----------------------------------------

    void setAudioInfoAvailable(bool avail);
    bool isAudioInfoAvailable();

    void setAudioMime(const QString& mime);
    QString getAudioMime() const;

    void setAudioSize(int size);
    int getAudioSize();

    void setAudioDownloaded(int downloaded);
    int getAudioDownloaded();

private:

    QString m_Name;
    QString m_Folder;

    //----------------------------

    bool m_fileInfoAvailable;

    QString m_Mime;
    QString m_Time;
    int m_Size;
    int m_Width;
    int m_Height;
    int m_ReadPermissions;
    int m_DeletePermissions;
    int m_Downloaded;

    //----------------------------

    bool m_previewInfoAvailable;

    QString m_PreviewMime;
    int m_PreviewWidth;
    int m_PreviewHeight;
    int m_PreviewSize;
    int m_PreviewDownloaded;

    //----------------------------

    bool m_audioInfoAvailable;

    QString m_AudioMime;
    int m_AudioSize;
    int m_AudioDownloaded;

};

#endif
