/* This file is part of the KDE project

   Copyright 2012 Brijesh Patel <brijesh3105@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KCHART_FORMAT_ERRORBAR_DIALOG_DIALOG_H
#define KCHART_FORMAT_ERRORBAR_DIALOG_DIALOG_H


#include "ui_FormatErrorBarDialog.h"


namespace KChart {

class FormatErrorBarDialog : public QDialog, public Ui::FormatErrorBarDialog
{
    Q_OBJECT
public:
    FormatErrorBarDialog(QWidget *parent = 0);
    ~FormatErrorBarDialog();
    Ui::FormatErrorBarDialog widget;

private slots:
    void errorIndicatorChanged();
    void errorTypeChanged(int currIndex);
    void setSameErrorValueForBoth(bool isChecked);
    void setSameErrorValueForBoth(double value);
};

} // Namespace KChart


#endif // KCHART_FORMAT_ERRORBAR_DIALOG_H
