/*
 * This code is auto-generated from Wikidata data. Licensed under CC0.
 */

#include "knowledgedb.h"
#include "timezonedb.h"
#include "trainstationdb.h"
#include "timezonedb_data_p.h"

namespace KItinerary {
namespace KnowledgeDb {
static const TrainStation trainstation_table[] = {
    {Coordinate{16.5878, 47.6778}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sopron railway station
    {Coordinate{14.6164, 58.9892}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Laxå railway station
    {Coordinate{12.2728, 57.7694}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Lerum railway station
    {Coordinate{10.09, 46.6978}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zernez station
    {Coordinate{9.90556, 46.4856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Surovas
    {Coordinate{10.0544, 46.3247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Poschiavo
    {Coordinate{10.0997, 46.2731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Miralago
    {Coordinate{8.40417, 46.5672}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muttbach-Belvédère Station
    {Coordinate{8.76972, 46.6811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sedrun railway station
    {Coordinate{8.508, 47.3647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Friesenberg railway station
    {Coordinate{8.62073, 46.9493}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sisikon railway station
    {Coordinate{7.95869, 46.7362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberried am Brienzersee railway station
    {Coordinate{7.99012, 46.7525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ebligen railway station
    {Coordinate{8.31, 46.982}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hergiswil railway station
    {Coordinate{8.303, 47.0351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lucerne Allmend/Messe railway station
    {Coordinate{8.54448, 47.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langnau-Gattikon railway station
    {Coordinate{8.53508, 47.2967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wildpark-Höfli railway station
    {Coordinate{8.52522, 47.3032}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sihlau railway station
    {Coordinate{8.5215, 47.3197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sood-Oberleimbach railway station
    {Coordinate{8.87899, 47.3684}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bauma railway station
    {Coordinate{8.75207, 47.2359}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uerikon railway station
    {Coordinate{9.31, 46.8075}, Tz::Europe_Zurich, CountryId{"CH"}}, // Versam-Safien
    {Coordinate{9.70333, 46.7978}, Tz::Europe_Zurich, CountryId{"CH"}}, // Litzirüti
    {Coordinate{17.3156, 62.3867}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Sundsvall central station
    {Coordinate{17.2914, 62.3897}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Sundsvall western station
    {Coordinate{18.7044, 63.2893}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Örnsköldsvik central station
    {Coordinate{9.51236, 46.8498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chur West
    {Coordinate{15.1, 37.5067}, Tz::Europe_Rome, CountryId{"IT"}}, // Catania Centrale railway station
    {Coordinate{6.39944, 46.4756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Allaman
    {Coordinate{6.87722, 46.448}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10947816
    {Coordinate{6.89542, 46.4428}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948043
    {Coordinate{6.82431, 46.4707}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948087
    {Coordinate{6.72722, 46.4885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948129
    {Coordinate{6.74528, 46.4893}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948238
    {Coordinate{7.02556, 46.1692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948282
    {Coordinate{6.84361, 46.4631}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948797
    {Coordinate{6.69056, 46.5039}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10949227
    {Coordinate{6.65917, 46.511}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pully railway station
    {Coordinate{6.78472, 46.4742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10950827
    {Coordinate{6.79694, 46.4725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10951147
    {Coordinate{7.00205, 46.2164}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10951368
    {Coordinate{6.92292, 46.4264}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952194
    {Coordinate{7.03833, 46.1386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952886
    {Coordinate{6.83556, 46.4682}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952909
    {Coordinate{6.92778, 46.4175}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952911
    {Coordinate{6.70722, 46.4956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10953216
    {Coordinate{13.3694, 52.5251}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Hauptbahnhof
    {Coordinate{8.53619, 47.5239}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bülach railway station
    {Coordinate{7.35005, 47.362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Delémont Station
    {Coordinate{18.4246, 47.1832}, Tz::Europe_Budapest, CountryId{"HU"}}, // Székesfehérvár railway station
    {Coordinate{14.8727, 40.6403}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontecagnano railway station
    {Coordinate{11.3968, 45.2304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1113920
    {Coordinate{11.6606, 43.4965}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1115149
    {Coordinate{14.8302, 38.1593}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1115937
    {Coordinate{14.2709, 51.0844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neukirch West railway station
    {Coordinate{12.2988, 45.8848}, Tz::Europe_Rome, CountryId{"IT"}}, // Conegliano railway station
    {Coordinate{7.61006, 43.7927}, Tz::Europe_Rome, CountryId{"IT"}}, // Ventimiglia railway station
    {Coordinate{11.2367, 43.8003}, Tz::Europe_Rome, CountryId{"IT"}}, // Firenze Rifredi railway station
    {Coordinate{11.8803, 45.4175}, Tz::Europe_Rome, CountryId{"IT"}}, // Padova railway station
    {Coordinate{15.2806, 37.0689}, Tz::Europe_Rome, CountryId{"IT"}}, // Siracusa railway station
    {Coordinate{8.12617, 49.198}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landau (Pfalz) Hauptbahnhof
    {Coordinate{7.8817, 48.0687}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11693885
    {Coordinate{8.03083, 44.6978}, Tz::Europe_Rome, CountryId{"IT"}}, // Alba railway station
    {Coordinate{14, 54.0333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koserow railway station
    {Coordinate{6.6459, 51.3575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Uerdingen station
    {Coordinate{14.0667, 54}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kölpinsee railway station
    {Coordinate{14.608, 52.5684}, Tz::Europe_Berlin, CountryId{"DE"}}, // Küstrin-Kietz station
    {Coordinate{12.3894, 51.3962}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Messe railway station
    {Coordinate{13.961, 51.8622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübbenau railway station
    {Coordinate{8.4541, 49.4933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11767119
    {Coordinate{8.4541, 49.4238}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11767120
    {Coordinate{9.36917, 47.4231}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen railway station
    {Coordinate{11.1431, 47.8449}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weilheim (Oberbay) station
    {Coordinate{12.9598, 50.9872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mittweida railway station
    {Coordinate{11.432, 48.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11787835
    {Coordinate{11.4133, 48.1559}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11787837
    {Coordinate{11.428, 48.1545}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Leienfelsstraße station
    {Coordinate{11.4436, 48.1487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich-Westkreuz station
    {Coordinate{14.0667, 54}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu Pudagla railway station
    {Coordinate{13.2617, 53.5622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubrandenburg railway station
    {Coordinate{8.6123, 47.6826}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q11790768
    {Coordinate{8.495, 47.6891}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q11790775
    {Coordinate{11.0583, 49.4075}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794301
    {Coordinate{11.0548, 49.4295}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794302
    {Coordinate{11.0682, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794304
    {Coordinate{11.1217, 49.4641}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794306
    {Coordinate{10.4979, 48.8509}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nördlingen station
    {Coordinate{11.8308, 53.4301}, Tz::Europe_Berlin, CountryId{"DE"}}, // Parchim railway station
    {Coordinate{13.0367, 52.3928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Charlottenhof railway station
    {Coordinate{12.9501, 48.8394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Deggendorf Hauptbahnhof
    {Coordinate{19.1003, 49.5069}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Rajcza Centrum railway station
    {Coordinate{12.3453, 51.5242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Delitzsch unterer station
    {Coordinate{7.0752, 51.4503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Steele station
    {Coordinate{6.85219, 51.052}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Worringen station
    {Coordinate{6.94911, 51.4728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Borbeck station
    {Coordinate{21.6281, 47.5206}, Tz::Europe_Budapest, CountryId{"HU"}}, // Debrecen Railway Station
    {Coordinate{7.27097, 46.2085}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174781
    {Coordinate{6.55944, 46.6875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bavois
    {Coordinate{7.00083, 46.2514}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174783
    {Coordinate{7.24056, 46.1886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174786
    {Coordinate{6.56816, 46.7101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chavornay
    {Coordinate{7.30472, 46.216}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174788
    {Coordinate{7.12639, 46.1269}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174790
    {Coordinate{6.94875, 46.2713}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174791
    {Coordinate{6.5525, 46.6572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eclépens
    {Coordinate{6.6075, 46.7464}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ependes
    {Coordinate{6.58056, 46.7278}, Tz::Europe_Zurich, CountryId{"CH"}}, // Essert-Pittet
    {Coordinate{7.7475, 46.3067}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174800
    {Coordinate{8.86578, 46.1791}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174801
    {Coordinate{6.85347, 46.3859}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174805
    {Coordinate{6.87947, 46.3632}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Évouettes station
    {Coordinate{6.98556, 46.2414}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174808
    {Coordinate{8.37417, 47.045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174810
    {Coordinate{8.40903, 47.0676}, Tz::Europe_Zurich, CountryId{"CH"}}, // Merlischachen station
    {Coordinate{8.38306, 47.05}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174812
    {Coordinate{6.95523, 46.2556}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174813
    {Coordinate{7.80139, 46.3064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174816
    {Coordinate{7.21778, 46.1725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174817
    {Coordinate{8.88532, 46.1755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174819
    {Coordinate{6.80616, 46.3922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174821
    {Coordinate{7.57917, 46.3094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174824
    {Coordinate{7.41944, 46.2514}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174826
    {Coordinate{7.17333, 46.1494}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174829
    {Coordinate{8.94337, 47.2252}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schmerikon railway station
    {Coordinate{8.85056, 46.1775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174832
    {Coordinate{7.69972, 46.3094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174833
    {Coordinate{8.98068, 47.2243}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uznach railway station
    {Coordinate{6.91625, 46.315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vionnaz
    {Coordinate{6.89806, 46.3369}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vouvry
    {Coordinate{6.64083, 46.7817}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yverdon-les-Bains
    {Coordinate{3.61522, 51.1544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waarschoot railway station
    {Coordinate{3.57417, 51.1814}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eeklo railway station
    {Coordinate{8.34944, 49.5353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankenthal Central Station
    {Coordinate{4.96806, 51.8339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gorinchem railway station
    {Coordinate{19.0894, 47.5253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákosrendező railway station
    {Coordinate{11.32, 50.2394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kronach station
    {Coordinate{6.99056, 49.2414}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarbrücken Central Station
    {Coordinate{7.90778, 46.5983}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lauterbrunnen railway station
    {Coordinate{7.95944, 46.5844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kleine Scheidegg railway station
    {Coordinate{7.26331, 47.6416}, Tz::Europe_Paris, CountryId{"FR"}}, // Q128074
    {Coordinate{8.5804, 49.4487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Friedrichsfeld station
    {Coordinate{6.26389, 50.8148}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q129311
    {Coordinate{13.7664, 51.1244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Flughafen railway station
    {Coordinate{9.27, 48.82}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fellbach station
    {Coordinate{9.23472, 48.8061}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Nürnberger Straße station
    {Coordinate{6.43971, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheydt Central Station
    {Coordinate{6.62735, 46.5099}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jordils
    {Coordinate{7.4102, 49.5382}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kusel station
    {Coordinate{7.4448, 49.4702}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glan-Münchweiler station
    {Coordinate{8.85501, 47.6561}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stein am Rhein railway station
    {Coordinate{6.72258, 49.3526}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dillingen (Saar) station
    {Coordinate{8.58663, 47.5206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Embrach-Rorbas railway station
    {Coordinate{6.32083, 50.8244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q134564
    {Coordinate{8.65502, 50.1582}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Eschersheim station
    {Coordinate{4.49278, 52.0464}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zoetermeer Oost railway station
    {Coordinate{11.7388, 53.1607}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karstädt station
    {Coordinate{11.9608, 50.4197}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gutenfürst station
    {Coordinate{7.01389, 51.4514}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Central Station
    {Coordinate{5.88089, 45.2345}, Tz::Europe_Paris, CountryId{"FR"}}, // Lancey
    {Coordinate{4.61778, 51.1508}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kessel railway station
    {Coordinate{6.47226, 51.1996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mönchengladbach-Lürrip station
    {Coordinate{10.5778, 49.2983}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ansbach station
    {Coordinate{12.0994, 49.0122}, Tz::Europe_Berlin, CountryId{"DE"}}, // Regensburg Hauptbahnhof
    {Coordinate{9.35444, 48.8681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwaikheim station
    {Coordinate{11.1191, 46.0726}, Tz::Europe_Rome, CountryId{"IT"}}, // Trento railway station
    {Coordinate{13.4311, 52.4675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hermannstraße railway station
    {Coordinate{15.0203, 51.1531}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zgorzelec Miasto
    {Coordinate{4.02472, 50.9483}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalst-Kerrebroek railway station
    {Coordinate{3.92238, 50.9071}, Tz::Europe_Brussels, CountryId{"BE"}}, // Burst railway station
    {Coordinate{6.20143, 50.8345}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eschweiler-St. Jöris station
    {Coordinate{4.90214, 51.174}, Tz::Europe_Brussels, CountryId{"BE"}}, // Olen railway station
    {Coordinate{4.65361, 50.8358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oud-Heverlee railway station
    {Coordinate{13.7513, 52.4296}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkner railway station
    {Coordinate{6.84229, 46.7078}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q14475054
    {Coordinate{6.89438, 46.7588}, Tz::Europe_Zurich, CountryId{"CH"}}, // Granges-Marnand railway station
    {Coordinate{6.68628, 50.9381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14506318
    {Coordinate{10.9306, 44.6539}, Tz::Europe_Rome, CountryId{"IT"}}, // Modena railway station
    {Coordinate{9.04722, 51.5247}, Tz::Europe_Berlin, CountryId{"DE"}}, // Scherfede station
    {Coordinate{14.435, 50.0875}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha Masarykovo nádraží
    {Coordinate{6.79722, 50.9981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pulheim station
    {Coordinate{16.4069, 48.1753}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Geiselbergstraße railway station
    {Coordinate{7.21945, 50.6395}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Honnef (Rhein) station
    {Coordinate{10.6295, 47.8756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14544357
    {Coordinate{7.21023, 50.6581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rhöndorf station
    {Coordinate{8.91449, 49.1362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eppingen station
    {Coordinate{8.86361, 52.1719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vlotho station
    {Coordinate{12.6747, 48.2215}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altötting station
    {Coordinate{11.1079, 47.9503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Dießen
    {Coordinate{9.82944, 52.9831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soltau (Han) station
    {Coordinate{12.0838, 52.9032}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glöwen station
    {Coordinate{10.3321, 47.7313}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14550974
    {Coordinate{11.8524, 53.0714}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14551300
    {Coordinate{10.988, 48.263}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mering station
    {Coordinate{8.76033, 47.4652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sennhof-Kyburg railway station
    {Coordinate{8.41639, 45.3298}, Tz::Europe_Rome, CountryId{"IT"}}, // Vercelli railway station
    {Coordinate{7.59972, 50.3169}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederlahnstein station
    {Coordinate{8.05689, 50.0137}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattenheim station
    {Coordinate{10.8665, 53.9589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-Travemünde Hafen station
    {Coordinate{13.4809, 54.3563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Putbus railway station
    {Coordinate{12.2373, 51.8843}, Tz::Europe_Berlin, CountryId{"DE"}}, // Roßlau (Elbe) station
    {Coordinate{8.54825, 49.0876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Untergrombach station
    {Coordinate{8.26764, 50.4864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weilburg station
    {Coordinate{7.61046, 49.5841}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Wolfstein
    {Coordinate{12.3466, 51.5198}, Tz::Europe_Berlin, CountryId{"DE"}}, // Delitzsch oberer Bahnhof
    {Coordinate{16.3996, 48.1879}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q14906766
    {Coordinate{11.4158, 47.1935}, Tz::Europe_Vienna, CountryId{"AT"}}, // Patsch railway station
    {Coordinate{4.6062, 45.5243}, Tz::Europe_Paris, CountryId{"FR"}}, // Q14918105
    {Coordinate{7.642, 44.9914}, Tz::Europe_Rome, CountryId{"IT"}}, // Nichelino railway station
    {Coordinate{7.599, 44.9611}, Tz::Europe_Rome, CountryId{"IT"}}, // Candiolo railway station
    {Coordinate{11.3996, 48.1377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14948586
    {Coordinate{12.5644, 55.6728}, Tz::Europe_Copenhagen, CountryId{"DK"}}, // Copenhagen Central Station
    {Coordinate{10.2431, 50.0461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schweinfurt Stadt station
    {Coordinate{12.6334, 42.2422}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggio Mirteto railway station
    {Coordinate{12.5961, 42.0639}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15057779
    {Coordinate{11.3764, 44.4817}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna Mazzini railway halt
    {Coordinate{11.842, 44.6165}, Tz::Europe_Rome, CountryId{"IT"}}, // Argenta railway station
    {Coordinate{12.0401, 44.5116}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15070219
    {Coordinate{12.0983, 44.4628}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15070225
    {Coordinate{7.7555, 46.3674}, Tz::Europe_Zurich, CountryId{"CH"}}, // Goppenstein railway station
    {Coordinate{8.78478, 47.3671}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pfäffikon ZH railway station
    {Coordinate{8.75027, 47.3851}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fehraltorf railway station
    {Coordinate{8.70475, 47.4517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kemptthal railway station
    {Coordinate{8.93236, 47.354}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steg railway station
    {Coordinate{8.92318, 47.3334}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fischenthal railway station
    {Coordinate{8.62656, 47.4383}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bassersdorf railway station
    {Coordinate{8.91566, 47.3134}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gibswil railway station
    {Coordinate{8.8526, 47.2685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tann-Dürnten railway station
    {Coordinate{8.84238, 47.2237}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blumenau railway station
    {Coordinate{8.85488, 47.3938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saland railway station
    {Coordinate{8.84359, 47.4373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Turbenthal railway station
    {Coordinate{8.81892, 47.4416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rämismühle-Zell railway station
    {Coordinate{8.81892, 47.4416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Hegi station
    {Coordinate{8.6132, 47.2815}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herrliberg-Feldmeilen railway station
    {Coordinate{8.59892, 47.2974}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winkel am Zürichsee railway station
    {Coordinate{8.59161, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erlenbach ZH railway station
    {Coordinate{8.80066, 47.2136}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hurden railway station
    {Coordinate{8.75938, 47.2042}, Tz::Europe_Zurich, CountryId{"CH"}}, // Freienbach SOB railway station
    {Coordinate{8.7562, 47.2073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Freienbach SBB railway station
    {Coordinate{8.82279, 47.1943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altendorf railway station
    {Coordinate{8.64629, 47.516}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pfungen-Neftenbach railway station
    {Coordinate{8.50364, 47.4874}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederglatt railway station
    {Coordinate{8.5106, 47.4702}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberglatt Station
    {Coordinate{8.37371, 47.5653}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rümikon AG railway station
    {Coordinate{8.3528, 47.5684}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mellikon railway station
    {Coordinate{8.32704, 47.5695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rekingen AG railway station
    {Coordinate{8.27793, 47.6005}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rietheim railway station
    {Coordinate{8.23999, 47.6093}, Tz::Europe_Zurich, CountryId{"CH"}}, // Koblenz Dorf railway station
    {Coordinate{8.62586, 47.6829}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuhausen railway station
    {Coordinate{13.6618, 51.0132}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freital-Potschappel station
    {Coordinate{7.64556, 50.6872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenkirchen (Westerw) station
    {Coordinate{7.96625, 49.2053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Annweiler am Trifels station
    {Coordinate{8.0028, 49.1031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107129
    {Coordinate{7.69807, 47.9197}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Krozingen station
    {Coordinate{13.4785, 52.5012}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Rummelsburg railway station
    {Coordinate{11.4085, 47.7235}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107135
    {Coordinate{13.22, 47.4173}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bischofshofen railway station
    {Coordinate{12.9521, 50.8612}, Tz::Europe_Berlin, CountryId{"DE"}}, // Chemnitz-Hilbersdorf station
    {Coordinate{7.4283, 49.2454}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107147
    {Coordinate{10.138, 50.1312}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107154
    {Coordinate{7.89941, 49.4903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Enkenbach station
    {Coordinate{6.82356, 50.8104}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erftstadt station
    {Coordinate{8.09867, 47.8716}, Tz::Europe_Berlin, CountryId{"DE"}}, // Feldberg-Bärental Station
    {Coordinate{7.77304, 49.2031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hinterweidenthal Ost station
    {Coordinate{8.89617, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107186
    {Coordinate{7.89667, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochspeyer station
    {Coordinate{13.2714, 52.6725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohen Neuendorf West station
    {Coordinate{14.9024, 51.3039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107192
    {Coordinate{9.7628, 50.6733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107193
    {Coordinate{9.60415, 50.2326}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107198
    {Coordinate{8.1977, 49.0792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107199
    {Coordinate{10.098, 54.3112}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kiel-Hassee CITTI-PARK station
    {Coordinate{11.9884, 51.7522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köthen railway station
    {Coordinate{8.07436, 49.3733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lambrecht (Pfalz) station
    {Coordinate{11.8527, 48.4381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenbach station
    {Coordinate{8.5037, 49.5016}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107221
    {Coordinate{8.81304, 49.3208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meckesheim station
    {Coordinate{9.14667, 49.3522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mosbach (Baden) station
    {Coordinate{11.193, 47.6823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107232
    {Coordinate{9.02861, 50.6167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mücke (Hesse) station
    {Coordinate{7.90111, 50.6247}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nistertal-Bad Marienberg station
    {Coordinate{7.42624, 51.8922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nottuln-Appelhülsen station
    {Coordinate{7.65284, 49.5381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107260
    {Coordinate{7.4442, 49.5421}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107280
    {Coordinate{7.4404, 49.4852}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107282
    {Coordinate{7.24275, 51.2153}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid-Lüttringhausen station
    {Coordinate{11.0971, 47.9825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107284
    {Coordinate{8.1414, 49.1379}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rohrbach Station
    {Coordinate{8.829, 49.9732}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rödermark-Ober-Roden station
    {Coordinate{11.09, 48.0529}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Schondorf (Bay)
    {Coordinate{7.68757, 49.3591}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schopp station
    {Coordinate{7.44845, 49.5191}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107299
    {Coordinate{8.2732, 49.0455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wörth (Rhein) station
    {Coordinate{8.66468, 47.7173}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herblingen railway station
    {Coordinate{8.70389, 47.7453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thayngen railway station
    {Coordinate{8.53276, 47.4543}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rümlang railway station
    {Coordinate{8.48841, 47.4786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederhasli railway station
    {Coordinate{8.44684, 47.49}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinmaur railway station
    {Coordinate{16.4654, 48.146}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Kaiserebersdorf railway station
    {Coordinate{6.975, 50.9408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Messe/Deutz station
    {Coordinate{7.76528, 45.9844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rotenboden railway station
    {Coordinate{7.4834, 44.928}, Tz::Europe_Rome, CountryId{"IT"}}, // Airasca railway station
    {Coordinate{7.84282, 46.3125}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ausserberg railway station
    {Coordinate{13.6734, 52.5183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoppegarten (Mark) station
    {Coordinate{13.7625, 52.5265}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fredersdorf station
    {Coordinate{7.33956, 51.3238}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gevelsberg Hauptbahnhof
    {Coordinate{8.33269, 44.3362}, Tz::Europe_Rome, CountryId{"IT"}}, // Altare
    {Coordinate{8.19189, 44.3907}, Tz::Europe_Rome, CountryId{"IT"}}, // Cengio
    {Coordinate{8.5428, 44.3423}, Tz::Europe_Rome, CountryId{"IT"}}, // Celle Ligure railway halt
    {Coordinate{9.19753, 47.2267}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nesslau-Neu St. Johann Station
    {Coordinate{7.88116, 46.3065}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eggerberg railway station
    {Coordinate{13.0001, 52.3251}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elstal railway station
    {Coordinate{9.07723, 47.033}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ennenda railway station
    {Coordinate{7.78222, 45.9833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gornergrat railway station
    {Coordinate{7.76459, 46.3224}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hohtenn railway station
    {Coordinate{8.58934, 47.2585}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horgen Oberdorf railway station
    {Coordinate{11.7192, 48.0188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Höhenkirchen-Siegertsbrunn station
    {Coordinate{7.66061, 51.585}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kamen station
    {Coordinate{7.67148, 46.4952}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kandersteg railway station
    {Coordinate{13.62, 53.925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Klein Bünzow railway station
    {Coordinate{7.90852, 46.3014}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lalden railway station
    {Coordinate{9.70722, 46.8192}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langwies (Rhaetian Railway station)
    {Coordinate{9.61333, 46.8317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lüen-Castiel
    {Coordinate{8.27545, 47.4279}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mellingen Heitersberg railway station
    {Coordinate{9.08142, 47.01}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mitlödi railway station
    {Coordinate{11.7858, 48.3537}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Airport Terminal station
    {Coordinate{8.23507, 47.4145}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mägenwil railway station
    {Coordinate{7.69077, 46.6385}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mülenen railway station
    {Coordinate{13.9033, 53.4417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nechlin railway station
    {Coordinate{9.05954, 47.064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Netstal railway station
    {Coordinate{8.33131, 47.4504}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuenhof railway station
    {Coordinate{14.2139, 51.0211}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt (Sachs) railway station
    {Coordinate{9.06211, 47.1223}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nieder- and Oberurnen railway station
    {Coordinate{7.54, 44.938}, Tz::Europe_Rome, CountryId{"IT"}}, // None railway station
    {Coordinate{9.06947, 47.0988}, Tz::Europe_Zurich, CountryId{"CH"}}, // Näfels-Mollis railway station
    {Coordinate{8.21477, 47.4071}, Tz::Europe_Zurich, CountryId{"CH"}}, // Othmarsingen railway station
    {Coordinate{9.67167, 46.8294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Peist (Rhaetian Railway station)
    {Coordinate{7.4255, 44.9217}, Tz::Europe_Rome, CountryId{"IT"}}, // Piscina di Pinerolo railway station
    {Coordinate{7.69077, 46.6249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reichenbach im Kandertal railway station
    {Coordinate{8.71208, 47.1968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riedmatt railway station
    {Coordinate{9.65389, 46.8289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sankt Peter-Molinis station
    {Coordinate{7.05764, 47.4398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courchavon
    {Coordinate{7.12833, 47.4241}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alle station
    {Coordinate{7.01653, 47.4925}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boncourt
    {Coordinate{6.47939, 46.9053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Verrières
    {Coordinate{9.74917, 47.505}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bregenz railway station
    {Coordinate{8.00294, 49.4143}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weidenthal station
    {Coordinate{7.80615, 49.1024}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15297228
    {Coordinate{8.12722, 49.2839}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Edenkoben
    {Coordinate{9.65073, 46.6712}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alvaneu
    {Coordinate{7.84079, 49.8067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15303880
    {Coordinate{12.4297, 50.8928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gößnitz station
    {Coordinate{6.23055, 50.7643}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q153200
    {Coordinate{8.07051, 49.5545}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Eisenberg, Rhineland-Palatinate
    {Coordinate{12.4587, 52.4996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Pritzerbe
    {Coordinate{11.94, 48.0433}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grafing station
    {Coordinate{15.4484, 47.0538}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1544082
    {Coordinate{13.5204, 51.2963}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q1548558
    {Coordinate{11.5308, 48.071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grosshesselohe Isartal station
    {Coordinate{7.75058, 49.1975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15496747
    {Coordinate{12.5197, 48.2482}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühldorf (Oberbayern) station
    {Coordinate{13.2476, 51.5833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Falkenberg (Elster) station
    {Coordinate{13.6559, 51.1031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Radebeul-Weintraube station
    {Coordinate{6.09407, 46.2206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vernier
    {Coordinate{6.07723, 46.2223}, Tz::Europe_Zurich, CountryId{"CH"}}, // Meyrin
    {Coordinate{6.06578, 46.2212}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zimeysa
    {Coordinate{13.0763, 42.4154}, Tz::Europe_Rome, CountryId{"IT"}}, // Antrodoco Centro train station
    {Coordinate{13.096, 42.398}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617141
    {Coordinate{13.1443, 42.3884}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617142
    {Coordinate{13.19, 42.3606}, Tz::Europe_Rome, CountryId{"IT"}}, // Sella di Corno railway station
    {Coordinate{13.5629, 42.2507}, Tz::Europe_Rome, CountryId{"IT"}}, // Fagnano-Campana railway station
    {Coordinate{13.6044, 42.2228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617152
    {Coordinate{13.642, 42.2049}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617153
    {Coordinate{13.6609, 42.1974}, Tz::Europe_Rome, CountryId{"IT"}}, // Beffi railway station
    {Coordinate{13.8091, 42.0981}, Tz::Europe_Rome, CountryId{"IT"}}, // Raiano railway station
    {Coordinate{13.7397, 42.1436}, Tz::Europe_Rome, CountryId{"IT"}}, // Molina-Castelvecchio Subequo railway station
    {Coordinate{13.8719, 42.0804}, Tz::Europe_Rome, CountryId{"IT"}}, // Pratola Peligna Superiore railway station
    {Coordinate{13.7111, 42.1767}, Tz::Europe_Rome, CountryId{"IT"}}, // Acciano railway station
    {Coordinate{14.25, 51.4333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoyerswerda railway station
    {Coordinate{7.05539, 49.2994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sulzbach (Saar) station
    {Coordinate{11.189, 54.4436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15635107
    {Coordinate{9.59111, 47.4669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rheineck railway station
    {Coordinate{9.50521, 47.4778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rorschach station
    {Coordinate{9.63834, 47.4534}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15639432
    {Coordinate{14.1, 51.2667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kamenz railway station
    {Coordinate{7.6349, 51.1084}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15648785
    {Coordinate{8.71083, 49.2194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Odenheim train station
    {Coordinate{14.4489, 50.0642}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha-Vršovice railway station
    {Coordinate{8.09, 53.2356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Varel railway station
    {Coordinate{8.11479, 53.5187}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wilhelmshaven railway station
    {Coordinate{11.3677, 44.5777}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelmaggiore railway station
    {Coordinate{11.4417, 44.7377}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714363
    {Coordinate{11.5439, 44.7958}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714365
    {Coordinate{10.9779, 44.1558}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714368
    {Coordinate{11.0535, 44.23}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714372
    {Coordinate{11.1141, 44.2828}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714374
    {Coordinate{11.1618, 44.3106}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15714375
    {Coordinate{11.5171, 50.3572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dürrenwaid station
    {Coordinate{7.59, 50.3575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koblenz Stadtmitte station
    {Coordinate{10.6981, 53.8022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-Flughafen station
    {Coordinate{7.01861, 49.2303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarbrücken-Ost station
    {Coordinate{16.3064, 48.1982}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572413
    {Coordinate{16.329, 48.2313}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Gersthof
    {Coordinate{16.3411, 48.2401}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572420
    {Coordinate{16.3586, 48.1802}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Matzleinsdorfer Platz railway station
    {Coordinate{16.3443, 48.2444}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572425
    {Coordinate{16.3818, 48.188}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Quartier Belvedere train station
    {Coordinate{16.3834, 48.2348}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572428
    {Coordinate{8.74076, 48.7086}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15725866
    {Coordinate{9.46722, 51.23}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785148
    {Coordinate{7.28184, 49.2619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785154
    {Coordinate{7.77131, 49.1547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785159
    {Coordinate{8.10822, 49.564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785163
    {Coordinate{7.45633, 49.4948}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785166
    {Coordinate{13.5184, 51.4722}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elsterwerda-Biehla station
    {Coordinate{8.21066, 49.4884}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erpolzheim station
    {Coordinate{7.96985, 49.439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankenstein (Pfalz) station
    {Coordinate{9.59564, 49.6981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785172
    {Coordinate{11.5014, 47.2769}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q15785173
    {Coordinate{8.67521, 49.3799}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidelberg-Kirchheim/Rohrbach station
    {Coordinate{8.72357, 48.4823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Hochdorf (b Horb)
    {Coordinate{7.74978, 49.4475}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Kaiserslautern West
    {Coordinate{7.83509, 48.3403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lahr (Schwarzw) station
    {Coordinate{7.56602, 49.4163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landstuhl station
    {Coordinate{9.14595, 49.0764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785185
    {Coordinate{8.13336, 50.3776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindenholzhausen station
    {Coordinate{8.84145, 49.4048}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785188
    {Coordinate{8.16125, 50.3593}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederbrechen station
    {Coordinate{8.18806, 50.3546}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberbrechen station
    {Coordinate{7.7139, 47.2889}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15785193
    {Coordinate{13.0786, 47.7888}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q15785197
    {Coordinate{10.1739, 51.8875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seesen station
    {Coordinate{11.0482, 48.0946}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785204
    {Coordinate{7.16564, 49.467}, Tz::Europe_Berlin, CountryId{"DE"}}, // St. Wendel station
    {Coordinate{10.5627, 51.9552}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vienenburg station
    {Coordinate{7.31855, 49.2683}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792329
    {Coordinate{8.78281, 48.4798}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eutingen im Gäu station
    {Coordinate{8.1813, 49.5372}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792331
    {Coordinate{8.28764, 49.1595}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rülzheim station
    {Coordinate{9.73397, 49.1082}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwäbisch Hall station
    {Coordinate{9.36794, 49.5783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792337
    {Coordinate{13.8716, 53.5283}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blumenhagen
    {Coordinate{14.148, 53.9529}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heringsdorf Neuhof railway station
    {Coordinate{10.902, 47.8126}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Schongau
    {Coordinate{6.12531, 46.1888}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lancy-Pont-Rouge
    {Coordinate{10.4706, 43.5865}, Tz::Europe_Rome, CountryId{"IT"}}, // Collesalvetti railway station
    {Coordinate{8.56693, 44.3568}, Tz::Europe_Rome, CountryId{"IT"}}, // Varazze railway station
    {Coordinate{16.4261, 48.1542}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Zentralfriedhof
    {Coordinate{8.2831, 45.7163}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgosesia railway station
    {Coordinate{11.6305, 52.1093}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Magdeburg-Buckau
    {Coordinate{9.45102, 52.4222}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wunstorf station
    {Coordinate{9.1241, 52.9991}, Tz::Europe_Berlin, CountryId{"DE"}}, // Etelsen
    {Coordinate{7.7496, 44.9204}, Tz::Europe_Rome, CountryId{"IT"}}, // Villastellone
    {Coordinate{6.01755, 46.1878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Russin
    {Coordinate{8.60861, 46.5275}, Tz::Europe_Zurich, CountryId{"CH"}}, // Airolo railway station
    {Coordinate{8.69015, 46.5106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ambrì-Piotta railway station
    {Coordinate{8.69611, 47.1317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altmatt station
    {Coordinate{8.66917, 47.0933}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biberegg station
    {Coordinate{6.51889, 46.6981}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964055
    {Coordinate{7.10611, 46.8169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964056
    {Coordinate{7.10917, 46.8219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964057
    {Coordinate{6.81167, 46.9297}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bevaix
    {Coordinate{6.87778, 46.9797}, Tz::Europe_Zurich, CountryId{"CH"}}, // Auvernier
    {Coordinate{7.2725, 47.1447}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel Mett
    {Coordinate{7.42806, 47.1947}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bettlach station
    {Coordinate{7.495, 47.2083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bellach station
    {Coordinate{8.36556, 47.2469}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964066
    {Coordinate{8.51694, 47.1831}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964067
    {Coordinate{7.90833, 47.3203}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964068
    {Coordinate{9.50522, 47.0103}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bad Ragaz station
    {Coordinate{9.55667, 47.3742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altstätten SG station
    {Coordinate{9.64139, 47.4361}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964071
    {Coordinate{9.43333, 47.5106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964072
    {Coordinate{9.42472, 47.5214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964073
    {Coordinate{9.26611, 47.6214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altnau station
    {Coordinate{9.02194, 47.6731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Berlingen station
    {Coordinate{7.49833, 46.8892}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964076
    {Coordinate{7.55944, 47.0956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964077
    {Coordinate{6.52368, 46.606}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cossonay
    {Coordinate{6.47472, 46.715}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964082
    {Coordinate{6.69917, 46.5097}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964083
    {Coordinate{6.77861, 46.4811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964085
    {Coordinate{7.00056, 46.7492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964086
    {Coordinate{6.78639, 46.8169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964087
    {Coordinate{6.95722, 46.8289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964088
    {Coordinate{6.72306, 46.8508}, Tz::Europe_Zurich, CountryId{"CH"}}, // Concise
    {Coordinate{6.835, 46.9594}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boudry
    {Coordinate{6.84889, 46.9678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Colombier
    {Coordinate{7.02361, 47.0386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cornaux
    {Coordinate{8.31472, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964093
    {Coordinate{8.45722, 47.1781}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964094
    {Coordinate{8.47111, 47.1822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cham Alpenblick train station
    {Coordinate{8.35639, 47.0936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964096
    {Coordinate{7.95694, 47.2628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964097
    {Coordinate{9.47878, 47.1688}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchs station
    {Coordinate{6.47819, 46.6967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964103
    {Coordinate{6.54083, 46.5292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Denges-Echandens
    {Coordinate{9.34806, 47.0967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964105
    {Coordinate{6.81111, 46.6106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964106
    {Coordinate{7.035, 46.7513}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964107
    {Coordinate{6.84306, 46.8444}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964108
    {Coordinate{6.88917, 46.8161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964109
    {Coordinate{6.9775, 46.8186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cousset Station
    {Coordinate{7.1225, 46.8678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964111
    {Coordinate{7.14972, 46.9}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964112
    {Coordinate{7.03972, 47.0519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cressier railway station
    {Coordinate{7.61889, 47.2183}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964114
    {Coordinate{7.79889, 47.3147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964115
    {Coordinate{7.94667, 47.3542}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dulliken train station
    {Coordinate{7.97833, 47.3564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Däniken Train Station
    {Coordinate{8.235, 47.3736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964118
    {Coordinate{8.34222, 47.0842}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964121
    {Coordinate{7.97889, 47.2175}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964122
    {Coordinate{9.383, 47.544}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964123
    {Coordinate{8.87639, 47.6456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964125
    {Coordinate{9.08583, 47.67}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964126
    {Coordinate{8.7525, 47.6853}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964127
    {Coordinate{7.31944, 46.8885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flamatt railway station
    {Coordinate{6.72306, 46.4969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964134
    {Coordinate{6.87, 46.735}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964135
    {Coordinate{7.06611, 46.8319}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964136
    {Coordinate{6.64167, 46.8061}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandson
    {Coordinate{7.12528, 46.8167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964138
    {Coordinate{6.78111, 46.8992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gorgier-Saint-Aubin
    {Coordinate{7.84389, 47.3303}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964141
    {Coordinate{8.16667, 47.4286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964142
    {Coordinate{8.2075, 47.3894}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hendschiken train station
    {Coordinate{8.44972, 47.1692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964144
    {Coordinate{8.45028, 47.1736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964145
    {Coordinate{8.39417, 47.1208}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964146
    {Coordinate{9.6275, 47.4103}, Tz::Europe_Zurich, CountryId{"CH"}}, // Heerbrugg Station
    {Coordinate{9.46333, 47.4903}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horn station
    {Coordinate{9.46667, 47.4739}, Tz::Europe_Zurich, CountryId{"CH"}}, // Goldach station
    {Coordinate{9.2925, 47.6086}, Tz::Europe_Zurich, CountryId{"CH"}}, // Güttingen station
    {Coordinate{9.27667, 47.39}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herisau railway station
    {Coordinate{7.65556, 47.0161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964153
    {Coordinate{7.38944, 47.1917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grenchen Nord
    {Coordinate{7.23444, 46.9422}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gümmenen station
    {Coordinate{8.83974, 46.4409}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lavorgo railway station
    {Coordinate{6.51722, 46.6589}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964160
    {Coordinate{6.67833, 46.5131}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964161
    {Coordinate{7.06639, 47.0567}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Landeron
    {Coordinate{7.09528, 47.0628}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Neuveville
    {Coordinate{7.13528, 47.0838}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ligerz
    {Coordinate{7.36667, 47.1794}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lengnau
    {Coordinate{7.94222, 47.3072}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964166
    {Coordinate{8.01917, 47.3247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964167
    {Coordinate{8.02653, 47.3372}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964168
    {Coordinate{9.3175, 47.5956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964169
    {Coordinate{8.66222, 47.6833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964170
    {Coordinate{7.78417, 46.9392}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langnau im Emmental railway station
    {Coordinate{7.62139, 46.8806}, Tz::Europe_Zurich, CountryId{"CH"}}, // Konolfingen Station
    {Coordinate{7.23802, 46.9026}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laupen railway station
    {Coordinate{8.85028, 46.1453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964178
    {Coordinate{6.50806, 46.5181}, Tz::Europe_Zurich, CountryId{"CH"}}, // Morges-St-Jean
    {Coordinate{6.51944, 46.5231}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lonay-Préverenges
    {Coordinate{9.17306, 47.1179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964181
    {Coordinate{9.215, 47.1133}, Tz::Europe_Zurich, CountryId{"CH"}}, // Murg station
    {Coordinate{9.27639, 47.1131}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964183
    {Coordinate{9.41778, 47.0539}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mels railway station
    {Coordinate{6.78583, 46.5086}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964185
    {Coordinate{6.80278, 46.6681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964186
    {Coordinate{7.09639, 46.7889}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964187
    {Coordinate{7.01167, 46.8283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964188
    {Coordinate{7.58361, 47.2172}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964189
    {Coordinate{8.34, 47.2767}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964190
    {Coordinate{8.38833, 47.225}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964191
    {Coordinate{8.91417, 47.6442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964193
    {Coordinate{9.05278, 47.6736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mannenbach-Salenstein  station
    {Coordinate{9.41444, 47.4747}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964195
    {Coordinate{7.8325, 47.2656}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964196
    {Coordinate{7.01083, 47.0092}, Tz::Europe_Zurich, CountryId{"CH"}}, // Marin-Epagnier
    {Coordinate{7.30639, 47.0764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964198
    {Coordinate{7.65556, 47.0161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964199
    {Coordinate{8.88722, 46.1511}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964201
    {Coordinate{6.65806, 46.5147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964202
    {Coordinate{6.76583, 46.4939}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964203
    {Coordinate{6.83722, 46.5725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964205
    {Coordinate{7.06514, 46.7661}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964206
    {Coordinate{7.1375, 46.8431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964207
    {Coordinate{7.11444, 46.9119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964208
    {Coordinate{6.90333, 46.9839}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel-Serrières
    {Coordinate{7.34028, 47.1714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pieterlen
    {Coordinate{7.77194, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964211
    {Coordinate{7.8975, 47.3486}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964212
    {Coordinate{8.40472, 47.1661}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964213
    {Coordinate{8.13861, 47.1389}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964214
    {Coordinate{8.11417, 47.1553}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964215
    {Coordinate{7.9775, 47.1922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nebikon train station
    {Coordinate{7.96876, 47.2415}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reiden Station
    {Coordinate{8.04833, 47.3564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964219
    {Coordinate{8.08222, 47.3714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964220
    {Coordinate{9.57139, 47.3236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberriet station
    {Coordinate{9.58667, 47.3925}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964222
    {Coordinate{8.67472, 47.1058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rothenthurm station
    {Coordinate{8.6275, 47.08}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sattel-Aegeri station
    {Coordinate{8.97417, 46.1606}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sant'Antonino
    {Coordinate{8.80694, 46.135}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964229
    {Coordinate{7.06208, 46.7825}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964231
    {Coordinate{6.9825, 47.0147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Blaise CFF
    {Coordinate{8.12694, 47.4033}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964233
    {Coordinate{8.27306, 47.0908}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964235
    {Coordinate{8.24917, 47.0883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964236
    {Coordinate{8.37361, 47.1047}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964237
    {Coordinate{7.98333, 47.3218}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964238
    {Coordinate{9.48528, 47.15}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964239
    {Coordinate{9.5025, 47.2417}, Tz::Europe_Zurich, CountryId{"CH"}}, // Salez-Sennwald train station
    {Coordinate{9.53611, 47.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964241
    {Coordinate{9.49389, 47.4786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rorschach Hafen station
    {Coordinate{9.48944, 47.4756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964244
    {Coordinate{9.33806, 47.4078}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Haggen station
    {Coordinate{7.87917, 47.3064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964247
    {Coordinate{7.81472, 47.2517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964248
    {Coordinate{6.98472, 47.0119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Blaise-Lac
    {Coordinate{8.60722, 47.0478}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinen station
    {Coordinate{8.58528, 47.0522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinerberg station
    {Coordinate{6.88528, 46.6592}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964255
    {Coordinate{7.45667, 47.2006}, Tz::Europe_Zurich, CountryId{"CH"}}, // Selzach station
    {Coordinate{8, 47.3714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönenwerd railway station
    {Coordinate{8.16694, 47.4517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964258
    {Coordinate{8.39778, 47.1883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964259
    {Coordinate{8.19583, 47.1161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964260
    {Coordinate{8.07444, 47.18}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964261
    {Coordinate{9.49389, 47.1256}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sevelen Station
    {Coordinate{9.53639, 47.4808}, Tz::Europe_Zurich, CountryId{"CH"}}, // Staad station
    {Coordinate{9.44222, 47.5008}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964266
    {Coordinate{8.98111, 47.6644}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steckborn Station
    {Coordinate{8.77036, 47.6669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964269
    {Coordinate{8.73194, 47.6875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964270
    {Coordinate{8.6875, 47.6794}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964271
    {Coordinate{8.73444, 47.1976}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{6.53056, 46.5764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vufflens-la-Ville
    {Coordinate{9.09472, 47.1299}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964274
    {Coordinate{9.25501, 47.1139}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterterzen railway station
    {Coordinate{9.31306, 47.1197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964276
    {Coordinate{6.91625, 46.78}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964277
    {Coordinate{6.85014, 46.6214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964278
    {Coordinate{6.96056, 46.7206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964279
    {Coordinate{7.11667, 46.7897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964280
    {Coordinate{6.7575, 46.8778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vaumarcus
    {Coordinate{7.15667, 47.0936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Twann
    {Coordinate{7.19694, 47.1147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tüscherz
    {Coordinate{7.65639, 47.2319}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964284
    {Coordinate{7.86861, 47.3414}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964285
    {Coordinate{8.16306, 47.4156}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964286
    {Coordinate{8.505, 47.1083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walchwil Hörndli station
    {Coordinate{8.01889, 47.1839}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964288
    {Coordinate{8.51694, 47.0989}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walchwil station
    {Coordinate{7.96333, 47.32}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964290
    {Coordinate{9.48033, 47.0716}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964291
    {Coordinate{9.50167, 47.0914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964292
    {Coordinate{9.34028, 47.5858}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uttwil station
    {Coordinate{7.49611, 46.8586}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964294
    {Coordinate{7.55583, 47.1522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964295
    {Coordinate{7.55361, 47.1283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964296
    {Coordinate{8.72476, 47.1954}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wollerau railway station
    {Coordinate{6.6625, 46.7822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yverdon-Champ Pittet
    {Coordinate{6.74694, 46.8008}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yvonand
    {Coordinate{8.48611, 47.1803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964302
    {Coordinate{8.48611, 47.1803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964303
    {Coordinate{8.51694, 47.1683}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964304
    {Coordinate{8.515, 47.1622}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964305
    {Coordinate{8.51222, 47.1564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964306
    {Coordinate{9.38861, 47.4631}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964309
    {Coordinate{7.46306, 47.0019}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964310
    {Coordinate{7.37528, 46.5531}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964311
    {Coordinate{9.4749, 53.5961}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stade station
    {Coordinate{7.1005, 51.6541}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl Mitte station
    {Coordinate{7.1311, 51.6826}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl-Hamm station
    {Coordinate{8.66111, 49.2111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Schönborn Süd station
    {Coordinate{8.66111, 49.2111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Schönborn-Kronau station
    {Coordinate{7.817, 49.7272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsenz station
    {Coordinate{11.7761, 49.87}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16054528
    {Coordinate{8.27426, 49.1196}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinzabern station
    {Coordinate{12.5741, 48.8773}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Straubing
    {Coordinate{9.01229, 51.6218}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16054534
    {Coordinate{6.55202, 46.5474}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bussigny station
    {Coordinate{9.85524, 53.3159}, Tz::Europe_Berlin, CountryId{"DE"}}, // Suerhop station
    {Coordinate{11.478, 48.1642}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Obermenzing
    {Coordinate{11.6989, 48.1183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gronsdorf
    {Coordinate{11.1966, 44.551}, Tz::Europe_Rome, CountryId{"IT"}}, // Anzola dell’Emilia railway halt
    {Coordinate{11.2751, 44.4437}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268781
    {Coordinate{11.0961, 44.2469}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268782
    {Coordinate{11.8318, 44.5111}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268787
    {Coordinate{10.8154, 44.9392}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268790
    {Coordinate{10.1402, 44.7493}, Tz::Europe_Rome, CountryId{"IT"}}, // Medesano railway station
    {Coordinate{11.189, 44.3324}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268795
    {Coordinate{11.2693, 44.423}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268799
    {Coordinate{10.8677, 44.8857}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268802
    {Coordinate{11.5231, 44.4368}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268808
    {Coordinate{10.8421, 44.9158}, Tz::Europe_Rome, CountryId{"IT"}}, // Villanova di Reggiolo railway halt
    {Coordinate{8.30536, 49.38}, Tz::Europe_Berlin, CountryId{"DE"}}, // Böhl-Iggelheim station
    {Coordinate{8.39066, 49.4242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Limburgerhof station
    {Coordinate{11.6602, 48.0757}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubiberg
    {Coordinate{10.7772, 44.9722}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16468369
    {Coordinate{13.3165, 46.4453}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16469209
    {Coordinate{12.635, 41.5521}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16482098
    {Coordinate{1.93155, 44.9512}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laval-de-Cère
    {Coordinate{16.0213, 40.5747}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16487703
    {Coordinate{6.53029, 46.7242}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16507967
    {Coordinate{6.5394, 46.5271}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508009
    {Coordinate{7.06194, 45.7446}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16508010
    {Coordinate{7.12395, 47.2972}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bollement Railway Station
    {Coordinate{7.25843, 45.7178}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16508066
    {Coordinate{7.87801, 45.2787}, Tz::Europe_Rome, CountryId{"IT"}}, // Rodallo railway station
    {Coordinate{2.61075, 46.5363}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508093
    {Coordinate{7.64659, 47.5362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508111
    {Coordinate{6.54132, 46.721}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Granges (Orbe) station
    {Coordinate{6.532, 46.7206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508242
    {Coordinate{6.96511, 46.4546}, Tz::Europe_Zurich, CountryId{"CH"}}, // Halte de Jor
    {Coordinate{8.6625, 50.1069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt (Main) Hauptbahnhof
    {Coordinate{9.64389, 47.9533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aulendorf station
    {Coordinate{14.4255, 36.9968}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608713
    {Coordinate{15.9562, 39.4865}, Tz::Europe_Rome, CountryId{"IT"}}, // Acquappesa railway halt
    {Coordinate{10.9965, 45.7591}, Tz::Europe_Rome, CountryId{"IT"}}, // Ala
    {Coordinate{11.9444, 45.9026}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608724
    {Coordinate{14.1285, 40.9963}, Tz::Europe_Rome, CountryId{"IT"}}, // Albanova railway station
    {Coordinate{10.6726, 43.8174}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608737
    {Coordinate{13.5208, 43.5664}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608740
    {Coordinate{13.4559, 43.6101}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608743
    {Coordinate{13.8357, 42.0175}, Tz::Europe_Rome, CountryId{"IT"}}, // Anversa-Villalago-Scanno railway station
    {Coordinate{12.6161, 41.4617}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608749
    {Coordinate{15.1723, 40.141}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608758
    {Coordinate{10.9561, 45.7337}, Tz::Europe_Rome, CountryId{"IT"}}, // Avio
    {Coordinate{15.126, 36.9075}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608770
    {Coordinate{10.5518, 44.0035}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608773
    {Coordinate{15.4954, 40.65}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608776
    {Coordinate{7.81947, 44.722}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608779
    {Coordinate{10.4521, 44.0681}, Tz::Europe_Rome, CountryId{"IT"}}, // Barga-Gallicano
    {Coordinate{8.50238, 45.9092}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608805
    {Coordinate{8.57108, 45.8433}, Tz::Europe_Rome, CountryId{"IT"}}, // Belgirate railway station
    {Coordinate{15.8532, 39.6166}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608814
    {Coordinate{16.6823, 40.3977}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608817
    {Coordinate{11.3728, 44.4961}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna San Vitale railway halt
    {Coordinate{8.26456, 45.4554}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608838
    {Coordinate{10.9269, 45.6968}, Tz::Europe_Rome, CountryId{"IT"}}, // Borghetto sull'Adige
    {Coordinate{10.5412, 43.9774}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo a Mozzano
    {Coordinate{16.8574, 38.9341}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608857
    {Coordinate{13.8633, 42.0316}, Tz::Europe_Rome, CountryId{"IT"}}, // Bugnara railway station
    {Coordinate{11.9795, 46.04}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608879
    {Coordinate{13.849, 42.1941}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608882
    {Coordinate{10.9883, 45.3389}, Tz::Europe_Rome, CountryId{"IT"}}, // Buttapietra
    {Coordinate{12.8561, 37.9389}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608890
    {Coordinate{11.1698, 45.4144}, Tz::Europe_Rome, CountryId{"IT"}}, // Caldiero railway station
    {Coordinate{16.8192, 39.579}, Tz::Europe_Rome, CountryId{"IT"}}, // Calopezzati Railway Station
    {Coordinate{10.3346, 44.1614}, Tz::Europe_Rome, CountryId{"IT"}}, // Camporgiano
    {Coordinate{8.10031, 45.5474}, Tz::Europe_Rome, CountryId{"IT"}}, // Candelo railway halt
    {Coordinate{13.0291, 42.3916}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608933
    {Coordinate{15.0137, 40.4545}, Tz::Europe_Rome, CountryId{"IT"}}, // Capaccio-Roccadaspide railway station
    {Coordinate{15.8742, 39.5584}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608942
    {Coordinate{13.2046, 41.4006}, Tz::Europe_Rome, CountryId{"IT"}}, // Capocroce railway halt
    {Coordinate{16.952, 39.4968}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608954
    {Coordinate{8.42286, 45.529}, Tz::Europe_Rome, CountryId{"IT"}}, // Carpignano Sesia railway station
    {Coordinate{10.7585, 45.431}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelnuovo del Garda
    {Coordinate{10.455, 44.0901}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelvecchio Pascoli
    {Coordinate{16.4671, 38.344}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609011
    {Coordinate{15.3946, 40.1028}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609017
    {Coordinate{15.3467, 40.0905}, Tz::Europe_Rome, CountryId{"IT"}}, // Centola-Palinuro-Marina di Camerota railway halt
    {Coordinate{12.3914, 44.2007}, Tz::Europe_Rome, CountryId{"IT"}}, // Cesenatico railway station
    {Coordinate{15.9394, 39.5127}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609028
    {Coordinate{15.1567, 41.9218}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609034
    {Coordinate{13.3107, 46.4094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609040
    {Coordinate{12.9429, 42.3879}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609052
    {Coordinate{13.7766, 42.0408}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609064
    {Coordinate{13.6293, 42.0604}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609067
    {Coordinate{11.4416, 46.9381}, Tz::Europe_Rome, CountryId{"IT"}}, // Colle Isarco
    {Coordinate{14.6005, 36.9472}, Tz::Europe_Rome, CountryId{"IT"}}, // Comiso railway station
    {Coordinate{15.5356, 38.1503}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609084
    {Coordinate{16.5148, 39.6281}, Tz::Europe_Rome, CountryId{"IT"}}, // Corigliano Calabro railway station
    {Coordinate{12.0127, 45.8338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609099
    {Coordinate{8.49826, 45.6463}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609111
    {Coordinate{16.8134, 38.9221}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609117
    {Coordinate{17.0406, 39.4496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609120
    {Coordinate{16.9639, 39.0259}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609129
    {Coordinate{8.37327, 45.9935}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609132
    {Coordinate{10.5077, 43.9596}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609140
    {Coordinate{14.5689, 36.8822}, Tz::Europe_Rome, CountryId{"IT"}}, // Donnafugata railway station
    {Coordinate{8.58222, 45.7234}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609149
    {Coordinate{11.2574, 46.3194}, Tz::Europe_Rome, CountryId{"IT"}}, // Egna-Termeno
    {Coordinate{9.06296, 39.2572}, Tz::Europe_Rome, CountryId{"IT"}}, // Elmas Aeroporto railway station
    {Coordinate{14.0526, 37.1135}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609169
    {Coordinate{11.9919, 45.7083}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609173
    {Coordinate{15.544, 38.161}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609184
    {Coordinate{13.7749, 37.9666}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609190
    {Coordinate{13.4249, 41.3378}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609197
    {Coordinate{15.2114, 36.9691}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609200
    {Coordinate{10.4733, 44.0454}, Tz::Europe_Rome, CountryId{"IT"}}, // Fornaci di Barga
    {Coordinate{11.6103, 46.7889}, Tz::Europe_Rome, CountryId{"IT"}}, // Fortezza
    {Coordinate{10.4443, 44.1187}, Tz::Europe_Rome, CountryId{"IT"}}, // Fosciandora-Ceserana
    {Coordinate{15.6245, 40.6786}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609213
    {Coordinate{13.2007, 41.3659}, Tz::Europe_Rome, CountryId{"IT"}}, // Frasso railway halt
    {Coordinate{16.0118, 39.4097}, Tz::Europe_Rome, CountryId{"IT"}}, // Fuscaldo railway station
    {Coordinate{11.6711, 44.7781}, Tz::Europe_Rome, CountryId{"IT"}}, // Gaibanella railway station
    {Coordinate{11.8277, 45.6528}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609236
    {Coordinate{10.5103, 44.0278}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609254
    {Coordinate{15.4797, 38.0639}, Tz::Europe_Rome, CountryId{"IT"}}, // Giampilieri railway station
    {Coordinate{13.7829, 42.0827}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609265
    {Coordinate{8.44057, 45.7446}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609267
    {Coordinate{8.42863, 45.9341}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609273
    {Coordinate{8.33367, 45.6828}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609279
    {Coordinate{17.4244, 40.5291}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609285
    {Coordinate{9.8629, 45.6342}, Tz::Europe_Rome, CountryId{"IT"}}, // Grumello del Monte
    {Coordinate{16.5744, 38.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609291
    {Coordinate{14.9142, 36.7782}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609304
    {Coordinate{13.1988, 41.3331}, Tz::Europe_Rome, CountryId{"IT"}}, // La Fiora railway halt
    {Coordinate{11.1824, 46.6074}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Lana-Postal
    {Coordinate{13.9288, 38.0116}, Tz::Europe_Rome, CountryId{"IT"}}, // Lascari-Gratteri railway station
    {Coordinate{8.55896, 45.8256}, Tz::Europe_Rome, CountryId{"IT"}}, // Lesa railway station
    {Coordinate{7.94153, 44.3857}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609340
    {Coordinate{12.626, 41.5006}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609347
    {Coordinate{10.4872, 45.4575}, Tz::Europe_Rome, CountryId{"IT"}}, // Lonato railway station
    {Coordinate{13.6203, 43.4481}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609362
    {Coordinate{7.7477, 44.6954}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609371
    {Coordinate{7.77686, 44.4466}, Tz::Europe_Rome, CountryId{"IT"}}, // Magliano-Crava-Morozzo railway station
    {Coordinate{16.8931, 39.5253}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609385
    {Coordinate{12.1348, 42.1282}, Tz::Europe_Rome, CountryId{"IT"}}, // Manziana-Canale Monterano
    {Coordinate{15.8229, 39.7669}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609394
    {Coordinate{8.53576, 45.7945}, Tz::Europe_Rome, CountryId{"IT"}}, // Meina railway station
    {Coordinate{8.44101, 45.9615}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609418
    {Coordinate{15.5181, 38.1244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609427
    {Coordinate{16.7773, 39.6047}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609433
    {Coordinate{13.3466, 43.6513}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609458
    {Coordinate{7.96495, 44.7038}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609461
    {Coordinate{8.01667, 44.7134}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609481
    {Coordinate{8.55804, 45.4814}, Tz::Europe_Rome, CountryId{"IT"}}, // Nibbia railway halt
    {Coordinate{12.7668, 43.1007}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609494
    {Coordinate{16.6439, 40.1304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609506
    {Coordinate{8.41313, 45.8719}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609515
    {Coordinate{8.41413, 45.8981}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609518
    {Coordinate{15.1345, 40.2527}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609521
    {Coordinate{11.2972, 46.361}, Tz::Europe_Rome, CountryId{"IT"}}, // Ora
    {Coordinate{8.42125, 45.7959}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609532
    {Coordinate{13.5471, 43.4968}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609534
    {Coordinate{12.6293, 41.5136}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609551
    {Coordinate{8.26058, 46.0436}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609566
    {Coordinate{13.4298, 43.6171}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609569
    {Coordinate{13.8443, 43.094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609574
    {Coordinate{11.9651, 45.8772}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609577
    {Coordinate{10.9006, 45.6583}, Tz::Europe_Rome, CountryId{"IT"}}, // Peri railway station
    {Coordinate{13.669, 42.0374}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescina railway station
    {Coordinate{13.9516, 42.2544}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609593
    {Coordinate{15.6417, 40.6403}, Tz::Europe_Rome, CountryId{"IT"}}, // railway station of Picerno
    {Coordinate{8.26106, 46.0244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609602
    {Coordinate{15.7921, 40.7533}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609605
    {Coordinate{8.27625, 46.0098}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609611
    {Coordinate{15.2435, 40.0914}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609617
    {Coordinate{16.5521, 40.4207}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609621
    {Coordinate{7.89254, 44.7011}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609623
    {Coordinate{16.2669, 40.9351}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggiorsini railway station
    {Coordinate{15.5028, 38.0961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609651
    {Coordinate{15.4943, 38.0809}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609654
    {Coordinate{13.6617, 43.4338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609672
    {Coordinate{15.7771, 40.7811}, Tz::Europe_Rome, CountryId{"IT"}}, // Possidente railway station
    {Coordinate{12.1484, 45.716}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609682
    {Coordinate{13.698, 43.3602}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609685
    {Coordinate{14.8472, 36.7335}, Tz::Europe_Rome, CountryId{"IT"}}, // Pozzallo railway station
    {Coordinate{8.37042, 45.6464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609697
    {Coordinate{8.32718, 46.0024}, Tz::Europe_Rome, CountryId{"IT"}}, // Premosello-Chiovenda railway station
    {Coordinate{13.8345, 42.0537}, Tz::Europe_Rome, CountryId{"IT"}}, // Prezza railway station
    {Coordinate{8.26655, 45.7635}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609706
    {Coordinate{11.92, 45.9396}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609709
    {Coordinate{13.2147, 46.3945}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609718
    {Coordinate{16.5281, 38.3892}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609720
    {Coordinate{16.5744, 38.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609738
    {Coordinate{14.9528, 36.8161}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609750
    {Coordinate{16.6408, 39.6029}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609753
    {Coordinate{11.7849, 45.7022}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609756
    {Coordinate{16.3515, 40.5834}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609768
    {Coordinate{8.08233, 44.3963}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609770
    {Coordinate{8.17278, 44.4045}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609777
    {Coordinate{11.2029, 46.2457}, Tz::Europe_Rome, CountryId{"IT"}}, // Salorno
    {Coordinate{14.7446, 36.732}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609786
    {Coordinate{15.4883, 38.0712}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609817
    {Coordinate{16.7054, 40.2536}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609881
    {Coordinate{14.6989, 36.7899}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609884
    {Coordinate{12.8282, 37.9495}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609890
    {Coordinate{11.0153, 45.8083}, Tz::Europe_Rome, CountryId{"IT"}}, // Serravalle all'Adige
    {Coordinate{15.8959, 41.6131}, Tz::Europe_Rome, CountryId{"IT"}}, // Siponto railway halt
    {Coordinate{7.77725, 44.7708}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609919
    {Coordinate{12.997, 42.3642}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609922
    {Coordinate{17.1081, 39.2281}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609932
    {Coordinate{10.5705, 43.8342}, Tz::Europe_Rome, CountryId{"IT"}}, // Tassignano-Capannori
    {Coordinate{13.2418, 41.2976}, Tz::Europe_Rome, CountryId{"IT"}}, // Terracina railway halt
    {Coordinate{13.9047, 42.2267}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609961
    {Coordinate{17.1083, 39.3044}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609970
    {Coordinate{15.4812, 40.0991}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609973
    {Coordinate{13.9375, 42.244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609978
    {Coordinate{16.7073, 39.6075}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609984
    {Coordinate{15.5269, 38.1381}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609990
    {Coordinate{15.9978, 40.5886}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610005
    {Coordinate{8.25926, 45.8143}, Tz::Europe_Rome, CountryId{"IT"}}, // Varallo Sesia railway station
    {Coordinate{13.5232, 43.5748}, Tz::Europe_Rome, CountryId{"IT"}}, // Varano Station
    {Coordinate{12.6171, 41.4844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610056
    {Coordinate{8.26455, 46.0642}, Tz::Europe_Rome, CountryId{"IT"}}, // Villadossola railway station
    {Coordinate{11.4402, 46.8957}, Tz::Europe_Rome, CountryId{"IT"}}, // Vipiteno Val di Vizze
    {Coordinate{14.525, 36.9587}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610085
    {Coordinate{8.29471, 46.0058}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610090
    {Coordinate{11.9361, 44.5404}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610093
    {Coordinate{20.8686, 52.1911}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Ursus Niedźwiadek railway station
    {Coordinate{11.5933, 50.8838}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena-Göschwitz station
    {Coordinate{22.6306, 48.2019}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16692574
    {Coordinate{}, Timezone{}, CountryId{"UA"}}, // Q16702723
    {Coordinate{5.65167, 53.0322}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sneek railway station
    {Coordinate{8.26995, 47.3484}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wohlen railway station
    {Coordinate{11.1494, 51.73}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830549
    {Coordinate{9.72278, 52.3527}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Linden Train Station
    {Coordinate{8.72782, 48.5555}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830552
    {Coordinate{11.5804, 50.0937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830553
    {Coordinate{11.5954, 49.8106}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830554
    {Coordinate{8.5302, 49.2919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neulußheim station
    {Coordinate{11.5936, 50.9368}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena Saalbahnhof
    {Coordinate{8.23008, 50.3327}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederselters station
    {Coordinate{8.47818, 47.1945}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinhausen railway station
    {Coordinate{13.1072, 54.305}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stralsund Rügendamm railway station
    {Coordinate{9.27942, 47.3755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{8.76097, 47.5167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Wallrüti railway station
    {Coordinate{13.7547, 52.9639}, Tz::Europe_Berlin, CountryId{"DE"}}, // Joachimsthal Kaiserbahnhof
    {Coordinate{6.9948, 51.5756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltepunkt Gladbeck Ost
    {Coordinate{9.1275, 48.705}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberaichen station
    {Coordinate{9.37028, 48.8131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Endersbach station
    {Coordinate{0.77502, 49.7201}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16964672
    {Coordinate{4.39987, 50.8391}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merode railway station
    {Coordinate{0.70513, 49.7597}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16964682
    {Coordinate{16.4994, 41.2353}, Tz::Europe_Rome, CountryId{"IT"}}, // Bisceglie railway station
    {Coordinate{8.57853, 49.3834}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwetzingen train station
    {Coordinate{12.5509, 37.9914}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056890
    {Coordinate{12.5042, 37.9265}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056891
    {Coordinate{12.4772, 37.8363}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056893
    {Coordinate{12.4432, 37.7932}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056894
    {Coordinate{12.4807, 37.7486}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056895
    {Coordinate{12.7333, 37.6363}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056899
    {Coordinate{12.8657, 37.8067}, Tz::Europe_Rome, CountryId{"IT"}}, // Salemi-Gibellina railway station
    {Coordinate{12.9489, 37.8579}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056904
    {Coordinate{12.9157, 37.9789}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056905
    {Coordinate{7.74861, 46.0097}, Tz::Europe_Zurich, CountryId{"CH"}}, // Findelbach railway station
    {Coordinate{7.61904, 51.5047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzwickede station
    {Coordinate{7.68, 46.6861}, Tz::Europe_Zurich, CountryId{"CH"}}, // Spiez railway station
    {Coordinate{13.2271, 50.7067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pockau-Lengefeld station
    {Coordinate{7.75389, 46.0047}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riffelalp railway station
    {Coordinate{7.755, 45.9928}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riffelberg railway station
    {Coordinate{7.68634, 45.0995}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Rebaudengo Fossata railway station
    {Coordinate{16.4178, 41.2725}, Tz::Europe_Rome, CountryId{"IT"}}, // Trani railway station
    {Coordinate{10.8376, 48.2665}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17122383
    {Coordinate{13.5628, 47.4076}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q17122384
    {Coordinate{8.99, 49.6568}, Tz::Europe_Berlin, CountryId{"DE"}}, // Railway Station Erbach (Odenw)
    {Coordinate{8.52921, 50.1733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17122390
    {Coordinate{6.97326, 51.6145}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17123492
    {Coordinate{12.9862, 43.3458}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145109
    {Coordinate{12.8588, 43.3452}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145113
    {Coordinate{12.8183, 43.4621}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145114
    {Coordinate{12.8513, 43.4364}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145115
    {Coordinate{13.6748, 37.5704}, Tz::Europe_Rome, CountryId{"IT"}}, // Acquaviva-Casteltermini railway station
    {Coordinate{12.8242, 43.5202}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146356
    {Coordinate{11.6024, 44.0684}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146357
    {Coordinate{13.6867, 37.5101}, Tz::Europe_Rome, CountryId{"IT"}}, // Campofranco railway station
    {Coordinate{14.2105, 41.1014}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146361
    {Coordinate{13.7847, 37.9539}, Tz::Europe_Rome, CountryId{"IT"}}, // Cerda railway station
    {Coordinate{11.5482, 44.0418}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146373
    {Coordinate{15.8241, 39.6769}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146374
    {Coordinate{13.838, 42.7059}, Tz::Europe_Rome, CountryId{"IT"}}, // Bellante-Ripattone railway station
    {Coordinate{13.7929, 42.6957}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146388
    {Coordinate{12.757, 43.2839}, Tz::Europe_Rome, CountryId{"IT"}}, // Fossato di Vico-Gubbio train station
    {Coordinate{12.7673, 43.2334}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146397
    {Coordinate{13.6933, 37.859}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146400
    {Coordinate{13.8763, 42.7067}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146404
    {Coordinate{8.41581, 45.9702}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146415
    {Coordinate{8.40675, 45.8205}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146417
    {Coordinate{11.6364, 44.093}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146420
    {Coordinate{13.8968, 42.9127}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto d'Ascoli train station
    {Coordinate{11.0025, 45.8613}, Tz::Europe_Rome, CountryId{"IT"}}, // Mori railway halt
    {Coordinate{9.79117, 48.4039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17148684
    {Coordinate{14.6355, 50.6816}, Tz::Europe_Prague, CountryId{"CZ"}}, // Zákupy (train station)
    {Coordinate{15.6506, 41.4081}, Tz::Europe_Rome, CountryId{"IT"}}, // Incoronata railway station
    {Coordinate{8.06528, 48.6336}, Tz::Europe_Berlin, CountryId{"DE"}}, // Achern station
    {Coordinate{8.99028, 49.3539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aglasterhausen station
    {Coordinate{7.72864, 50.3276}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Ems station
    {Coordinate{8.29456, 49.1883}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bellheim station
    {Coordinate{8.4107, 48.4675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17310441
    {Coordinate{11.1852, 53.429}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagenow Stadt railway station
    {Coordinate{17.9283, 62.635}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Härnösand railway station
    {Coordinate{8.179, 49.5807}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17353341
    {Coordinate{8.27233, 49.0925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jockgrim station
    {Coordinate{8.28348, 49.5119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17353766
    {Coordinate{8.24987, 49.5139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17354278
    {Coordinate{17.3297, 62.4864}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Timrå railway station
    {Coordinate{16.5631, 48.1208}, Tz::Europe_Vienna, CountryId{"AT"}}, // Vienna Airport
    {Coordinate{6.71472, 51.9681}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winterswijk railway station
    {Coordinate{6.16108, 52.257}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deventer railway station
    {Coordinate{13.2879, 43.6773}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17462133
    {Coordinate{7.14222, 51.4264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum-Dahlhausen station
    {Coordinate{4.78583, 43.9217}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avignon TGV
    {Coordinate{11.9905, 51.3569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Merseburg railway station
    {Coordinate{8.4177, 45.5955}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494292
    {Coordinate{8.43602, 45.5738}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494294
    {Coordinate{12.1028, 45.6767}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494296
    {Coordinate{12.0144, 45.6703}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494298
    {Coordinate{11.7489, 45.6349}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494303
    {Coordinate{11.7148, 45.6215}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494305
    {Coordinate{8.47884, 45.5387}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494314
    {Coordinate{12.5337, 44.0883}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494364
    {Coordinate{8.94689, 46.0055}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lugano railway station
    {Coordinate{13.3343, 52.597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Wittenau station
    {Coordinate{12.8817, 47.7308}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Bad Reichenhall
    {Coordinate{10.3301, 51.6439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzberg (Harz) station
    {Coordinate{7.03361, 49.1578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17521469
    {Coordinate{8.42117, 49.4617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigshafen-Mundenheim station
    {Coordinate{8.36036, 49.195}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sondernheim station
    {Coordinate{-8.43205, 40.2088}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Coimbra-A railway station
    {Coordinate{15.3822, 41.7786}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637099
    {Coordinate{12.2947, 42.518}, Tz::Europe_Rome, CountryId{"IT"}}, // Attigliano-Bomarzo railway station
    {Coordinate{8.7144, 46.2398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637112
    {Coordinate{8.74292, 46.2058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637118
    {Coordinate{11.9694, 44.4123}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637120
    {Coordinate{11.9954, 45.0608}, Tz::Europe_Rome, CountryId{"IT"}}, // Baricetta train station
    {Coordinate{8.60747, 46.3393}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637133
    {Coordinate{8.62239, 46.1584}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637136
    {Coordinate{8.45164, 46.1358}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637147
    {Coordinate{8.61108, 46.1548}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637154
    {Coordinate{12.2492, 45.1112}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavanella d’Adige railway station
    {Coordinate{11.5702, 45.5963}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637176
    {Coordinate{8.72123, 46.1837}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cavigliano train station
    {Coordinate{8.39867, 46.1266}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637193
    {Coordinate{12.779, 42.412}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637204
    {Coordinate{8.67516, 46.1688}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637209
    {Coordinate{8.32562, 46.1241}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637214
    {Coordinate{8.43367, 46.133}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637235
    {Coordinate{11.5463, 45.6351}, Tz::Europe_Rome, CountryId{"IT"}}, // Dueville railway station
    {Coordinate{8.55804, 46.1343}, Tz::Europe_Rome, CountryId{"IT"}}, // Folsogno-Dissimo railway station
    {Coordinate{8.41983, 46.1288}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637269
    {Coordinate{16.6689, 41.1808}, Tz::Europe_Rome, CountryId{"IT"}}, // Giovinazzo railway station
    {Coordinate{12.0712, 44.3894}, Tz::Europe_Rome, CountryId{"IT"}}, // Godo railway halt
    {Coordinate{8.74185, 46.2249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637281
    {Coordinate{12.7768, 42.4628}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637283
    {Coordinate{8.70222, 46.1775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637306
    {Coordinate{12.7463, 42.5061}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637321
    {Coordinate{11.913, 45.0434}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637327
    {Coordinate{8.80101, 46.1727}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locarno FART station
    {Coordinate{8.78614, 46.1689}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locarno Sant'Antonio train station
    {Coordinate{8.6904, 46.2613}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637337
    {Coordinate{12.1916, 45.0595}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637338
    {Coordinate{8.94771, 46.0045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lugano FPL railway station
    {Coordinate{8.49935, 46.1292}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637358
    {Coordinate{11.4246, 45.7068}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637360
    {Coordinate{14.2879, 41.0359}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637363
    {Coordinate{12.7151, 42.5474}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637371
    {Coordinate{8.33342, 46.1226}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637373
    {Coordinate{8.32403, 46.132}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637376
    {Coordinate{8.98305, 45.8774}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637381
    {Coordinate{16.5964, 41.1958}, Tz::Europe_Rome, CountryId{"IT"}}, // Molfetta railway station
    {Coordinate{14.7575, 40.82}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637409
    {Coordinate{10.8237, 45.3067}, Tz::Europe_Rome, CountryId{"IT"}}, // Mozzecane
    {Coordinate{11.6065, 45.2217}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637425
    {Coordinate{8.63095, 46.1611}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637428
    {Coordinate{15.3507, 41.8077}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637455
    {Coordinate{8.75327, 46.1858}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637457
    {Coordinate{8.29269, 46.1456}, Tz::Europe_Rome, CountryId{"IT"}}, // Preglia railway station
    {Coordinate{8.4796, 46.1331}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637478
    {Coordinate{10.9119, 44.6913}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637480
    {Coordinate{14.3034, 41.0623}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637491
    {Coordinate{8.60177, 46.1543}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637494
    {Coordinate{12.2195, 42.2825}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637520
    {Coordinate{12.2397, 45.0755}, Tz::Europe_Rome, CountryId{"IT"}}, // Rosolina railway halt
    {Coordinate{8.77037, 46.172}, Tz::Europe_Zurich, CountryId{"CH"}}, // San Martino train station
    {Coordinate{11.8491, 44.3565}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637559
    {Coordinate{8.77759, 46.1695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solduno train station
    {Coordinate{8.6619, 46.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637569
    {Coordinate{14.093, 41.1858}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637573
    {Coordinate{8.74278, 46.1861}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637585
    {Coordinate{12.625, 42.5496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637588
    {Coordinate{12.7828, 42.4363}, Tz::Europe_Rome, CountryId{"IT"}}, // Terria train station
    {Coordinate{11.4767, 45.6999}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637595
    {Coordinate{12.1833, 41.9243}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637600
    {Coordinate{8.33354, 46.1226}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637611
    {Coordinate{8.24491, 46.2063}, Tz::Europe_Rome, CountryId{"IT"}}, // Varzo railway station
    {Coordinate{8.64939, 46.1652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637629
    {Coordinate{8.35215, 46.1219}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637630
    {Coordinate{8.72987, 46.1846}, Tz::Europe_Zurich, CountryId{"CH"}}, // Verscio train station
    {Coordinate{11.5241, 45.6569}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637637
    {Coordinate{8.49076, 46.1296}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637645
    {Coordinate{12.0825, 50.0044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marktredwitz station
    {Coordinate{8.58297, 47.4482}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kloten railway station
    {Coordinate{8.56174, 47.4292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Opfikon railway station
    {Coordinate{8.47208, 47.4368}, Tz::Europe_Zurich, CountryId{"CH"}}, // Regensdorf-Watt railway station
    {Coordinate{8.50824, 47.421}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Affoltern railway station
    {Coordinate{8.43522, 47.4539}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchs-Dällikon railway station
    {Coordinate{15.2231, 51.2901}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Węgliniec railway station
    {Coordinate{16.4856, 48.2334}, Tz::Europe_Vienna, CountryId{"AT"}}, // Hausfeldstraße
    {Coordinate{13.6311, 52.2966}, Tz::Europe_Berlin, CountryId{"DE"}}, // Königs Wusterhausen station
    {Coordinate{8.51556, 47.1742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zug railway station
    {Coordinate{9.145, 45.1889}, Tz::Europe_Rome, CountryId{"IT"}}, // Pavia railway station
    {Coordinate{5.54944, 53.1822}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Franeker railway station
    {Coordinate{6.56389, 53.2106}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen railway station
    {Coordinate{6.58444, 53.205}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen Europapark railway station
    {Coordinate{6.55639, 53.23}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen Noord railway station
    {Coordinate{5.79324, 53.1965}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden railway station
    {Coordinate{5.84167, 53.2019}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden Camminghaburen railway station
    {Coordinate{5.81639, 53.1989}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden Achter de Hoven railway station
    {Coordinate{6.51861, 53.3614}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Baflo railway station
    {Coordinate{6.51972, 53.3306}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winsum railway station
    {Coordinate{11.7292, 45.9197}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18005296
    {Coordinate{12.7954, 42.3958}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggio Fidoni railway halt
    {Coordinate{8.23852, 48.9923}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18005407
    {Coordinate{19.1881, 47.4025}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentimre railway station
    {Coordinate{19.1731, 47.414}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentimre felső railway station
    {Coordinate{19.1823, 47.455}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentlőrinc railway station
    {Coordinate{19.1223, 47.5777}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákospalota-Kertváros railway station
    {Coordinate{19.2128, 47.444}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szemeretelep railway station
    {Coordinate{11.7908, 50.1891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18018567
    {Coordinate{9.76691, 49.0968}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwäbisch Hall-Hessental station
    {Coordinate{12.4317, 52.0989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18018576
    {Coordinate{7.63829, 48.4231}, Tz::Europe_Paris, CountryId{"FR"}}, // Erstein
    {Coordinate{16.2839, 48.1347}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Hetzendorf railway station
    {Coordinate{6.42083, 52.2839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Holten railway station
    {Coordinate{7.83152, 48.9163}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810354
    {Coordinate{6.4161, 48.2446}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810836
    {Coordinate{-0.368163, 48.7019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Briouze
    {Coordinate{8.58681, 50.2833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Saalburg
    {Coordinate{7.22127, 51.2742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Oberbarmen station
    {Coordinate{3.45139, 50.5694}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antoing railway station
    {Coordinate{12.3817, 51.3292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Bayerischer Bahnhof
    {Coordinate{4.58754, 48.7179}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitry-le-François
    {Coordinate{3.57556, 51.0644}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landegem railway station
    {Coordinate{3.49635, 50.5472}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maubray railway station
    {Coordinate{4.15593, 50.5628}, Tz::Europe_Brussels, CountryId{"BE"}}, // Écaussinnes railway station
    {Coordinate{4.28306, 51.0772}, Tz::Europe_Brussels, CountryId{"BE"}}, // Puurs railway station
    {Coordinate{5.58186, 45.322}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moirans
    {Coordinate{7.3806, 48.9201}, Tz::Europe_Paris, CountryId{"FR"}}, // Wingen-sur-Moder
    {Coordinate{14.3801, 41.0362}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18224663
    {Coordinate{14.0771, 41.232}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18224699
    {Coordinate{3.91142, 50.3912}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genly railway station
    {Coordinate{4.36167, 50.7942}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Job railway station
    {Coordinate{4.27382, 50.7664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lot railway station
    {Coordinate{5.86417, 50.5908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Verviers-Palais railway station
    {Coordinate{3.78167, 50.9367}, Tz::Europe_Brussels, CountryId{"BE"}}, // Scheldewindeke railway station
    {Coordinate{5.13455, 48.1095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chaumont
    {Coordinate{3.00652, 49.577}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noyon
    {Coordinate{7.55583, 50.1558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18286822
    {Coordinate{8.43143, 50.0173}, Tz::Europe_Berlin, CountryId{"DE"}}, // Flörsheim (Main) station
    {Coordinate{3.40972, 50.1114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caudry
    {Coordinate{0.387395, 43.1142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lannemezan
    {Coordinate{5.83944, 51.995}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oosterbeek railway station
    {Coordinate{14.3497, 53.2708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tantow railway station
    {Coordinate{10.3216, 51.3876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leinefelde station
    {Coordinate{7.585, 51.5569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Kurl station
    {Coordinate{5.40647, 43.2962}, Tz::Europe_Paris, CountryId{"FR"}}, // Marseille-Blancarde
    {Coordinate{5.05495, 47.3228}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dijon-Porte-Neuve
    {Coordinate{5.19345, 45.9019}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1837811
    {Coordinate{9.02239, 47.2179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaltbrunn railway station
    {Coordinate{12.7551, 43.0569}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18397591
    {Coordinate{15.1006, 50.6672}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q18398041
    {Coordinate{3.96161, 50.5364}, Tz::Europe_Brussels, CountryId{"BE"}}, // Masnuy-Saint-Pierre railway station
    {Coordinate{6.6078, 51.7697}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Dingden
    {Coordinate{7.80935, 48.8861}, Tz::Europe_Paris, CountryId{"FR"}}, // Walbourg
    {Coordinate{15.1914, 37.6889}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18420506
    {Coordinate{15.7581, 40.7877}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel Lagopesole railway station
    {Coordinate{15.7523, 40.8372}, Tz::Europe_Rome, CountryId{"IT"}}, // Filiano railway station
    {Coordinate{8.94449, 45.8498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stabio railway station
    {Coordinate{-1.24499, 49.3023}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carentan
    {Coordinate{0.803018, 44.38}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Penne-d'Agenais
    {Coordinate{5.79917, 49.5636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aubange railway station
    {Coordinate{5.10767, 50.2677}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leignon railway station
    {Coordinate{7.78227, 48.8135}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Haguenau
    {Coordinate{-0.910766, 43.5245}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Puyoô
    {Coordinate{6.03222, 51.235}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Swalmen railway station
    {Coordinate{4.86463, 51.0026}, Tz::Europe_Brussels, CountryId{"BE"}}, // Langdorp railway station
    {Coordinate{-1.38926, 47.2929}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1848535
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schelle railway station
    {Coordinate{14.426, 41.0876}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18510373
    {Coordinate{4.83977, 45.0723}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1851214
    {Coordinate{11.3745, 53.3863}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jasnitz railway station
    {Coordinate{4.76879, 45.7347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1852144
    {Coordinate{5.58944, 52.1408}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barneveld Centrum railway station
    {Coordinate{6.669, 51.4135}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q1852663
    {Coordinate{4.59757, 50.7074}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bierges-Walibi railway station
    {Coordinate{4.21302, 50.3212}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fontaine-Valmont railway station
    {Coordinate{6.49261, 47.6831}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1855889
    {Coordinate{6.89348, 51.3415}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hösel station
    {Coordinate{14.2081, 53.2133}, Tz::Europe_Berlin, CountryId{"DE"}}, // Casekow station
    {Coordinate{5.36688, 50.67}, Tz::Europe_Brussels, CountryId{"BE"}}, // Momalle railway station
    {Coordinate{2.82529, 49.4228}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Compiègne
    {Coordinate{15.4654, 38.0464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18590151
    {Coordinate{15.4043, 37.9861}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18590155
    {Coordinate{-2.24225, 53.4739}, Tz::Europe_London, CountryId{"GB"}}, // Manchester Oxford Road railway station
    {Coordinate{-2.24453, 53.4872}, Tz::Europe_London, CountryId{"GB"}}, // Manchester Victoria station
    {Coordinate{2.4357, 44.921}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aurillac
    {Coordinate{9.16317, 49.2304}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Wimpfen train station
    {Coordinate{11.7784, 45.2915}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18613410
    {Coordinate{10.4208, 50.5742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meiningen station
    {Coordinate{8.24932, 50.4003}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aumenau station
    {Coordinate{9.1025, 49.2397}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Rappenau station
    {Coordinate{12.5307, 52.4118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616521
    {Coordinate{13.8822, 53.6597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ferdinandshof railway station
    {Coordinate{10.4217, 51.9111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Goslar railway station
    {Coordinate{6.46585, 51.1034}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochneukirch station
    {Coordinate{6.60761, 51.2221}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616526
    {Coordinate{6.59389, 51.2266}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616527
    {Coordinate{8.78175, 48.9837}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616528
    {Coordinate{16.2293, 46.9455}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Mogersdorf
    {Coordinate{7.28874, 50.9329}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Overath
    {Coordinate{4.4325, 51.2817}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kapellen railway station
    {Coordinate{10.3142, 53.5297}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aumühle railway station
    {Coordinate{0.573483, 43.078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montréjeau-Gourdan-Polignan
    {Coordinate{7.07878, 51.164}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18625061
    {Coordinate{7.40799, 50.9868}, Tz::Europe_Berlin, CountryId{"DE"}}, // Engelskirchen station
    {Coordinate{8.61002, 46.9992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brunnen railway station
    {Coordinate{4.43472, 51.2914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Mariaburg railway station
    {Coordinate{6.02552, 48.9855}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1865759
    {Coordinate{4.25944, 51.2083}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beveren railway station
    {Coordinate{-1.6725, 48.1033}, Tz::Europe_Paris, CountryId{"FR"}}, // Rennes railway station
    {Coordinate{2.64037, 50.5212}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1866833
    {Coordinate{-2.7525, 47.6653}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vannes
    {Coordinate{11.9975, 53.837}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bützow station
    {Coordinate{11.9863, 51.9934}, Tz::Europe_Berlin, CountryId{"DE"}}, // Güterglück railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18681697
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18681699
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18681700
    {Coordinate{8.84099, 47.7589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Singen (Hohentwiel) station
    {Coordinate{8.98453, 49.4654}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eberbach railway station
    {Coordinate{9.27581, 48.747}, Tz::Europe_Berlin, CountryId{"DE"}}, // Esslingen-Mettingen
    {Coordinate{4.06923, 50.5731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Soignies railway station
    {Coordinate{4.25361, 51.9164}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maassluis railway station
    {Coordinate{12.9817, 52.9615}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindow (Mark) railway station
    {Coordinate{12.9001, 53.0929}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinsberg (Mark) railway station
    {Coordinate{2.79944, 48.3783}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moret-Veneux-les-Sablons
    {Coordinate{4.25776, 50.7507}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buizingen railway station
    {Coordinate{4.76405, 52.9326}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Helder Zuid railway station
    {Coordinate{-0.441667, 45.4389}, Tz::Europe_Paris, CountryId{"FR"}}, // Jonzac
    {Coordinate{6.4825, 46.3692}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thonon-les-Bains
    {Coordinate{6.77056, 43.4228}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1871873
    {Coordinate{6.57556, 52.4414}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Daarlerveen railway station
    {Coordinate{4.70396, 44.3749}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1873503
    {Coordinate{11.1527, 51.7853}, Tz::Europe_Berlin, CountryId{"DE"}}, // Quedlinburg station
    {Coordinate{6.9916, 51.0316}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leverkusen Mitte station
    {Coordinate{10.0331, 53.6064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rübenkamp station
    {Coordinate{3.43053, 46.2091}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-des-Fossés
    {Coordinate{16.3677, 48.2606}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q18762414
    {Coordinate{0.693611, 47.3897}, Tz::Europe_Paris, CountryId{"FR"}}, // Tours railway station
    {Coordinate{5.67278, 51.9222}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hemmen-Dodewaard railway station
    {Coordinate{8.9409, 49.8331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß-Umstadt Wiebelsbach station
    {Coordinate{0.549316, 46.8186}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1878152
    {Coordinate{8.46148, 45.3592}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo Vercelli railway halt
    {Coordinate{10.9681, 43.6054}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18785594
    {Coordinate{8.89871, 46.1731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riazzino-Cugnasco train station
    {Coordinate{6.30278, 45.353}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Avre - La Chambre
    {Coordinate{4.60778, 52.3908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Overveen railway station
    {Coordinate{1.65722, 44.8183}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rocamadour-Padirac
    {Coordinate{1.71532, 48.9836}, Tz::Europe_Paris, CountryId{"FR"}}, // Mantes-Station
    {Coordinate{5.5242, 50.4027}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sy railway station
    {Coordinate{6.14667, 52.0906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Brummen railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ruisbroek-Sauvegarde railway station
    {Coordinate{15.38, 37.9617}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18844698
    {Coordinate{15.3914, 37.9729}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18844701
    {Coordinate{3.7936, 50.6612}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rebaix railway station
    {Coordinate{-1.51083, 47.2067}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sébastien-Pas-Enchantés
    {Coordinate{15.8175, 52.2419}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zbąszynek
    {Coordinate{4.08389, 51.1492}, Tz::Europe_Brussels, CountryId{"BE"}}, // Belsele railway station
    {Coordinate{6.98788, 51.2508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mettmann Stadtwald station
    {Coordinate{3.51694, 50.3633}, Tz::Europe_Paris, CountryId{"FR"}}, // Valenciennes railway station
    {Coordinate{7.23919, 47.6273}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1888534
    {Coordinate{3.44608, 50.0397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Busigny
    {Coordinate{0.192021, 49.2871}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-l'Évêque
    {Coordinate{7.07, 46.0931}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q1891056
    {Coordinate{3.89257, 45.0428}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Puy-en-Velay railway station
    {Coordinate{6.73267, 43.432}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fréjus
    {Coordinate{12.3185, 43.0947}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18923658
    {Coordinate{12.3559, 43.1024}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18923659
    {Coordinate{4.18049, 50.4782}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Louvière-Centre railway station
    {Coordinate{4.97694, 52.2786}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Abcoude railway station
    {Coordinate{5.29194, 51.6547}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vught railway station
    {Coordinate{3.98732, 50.911}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ede railway station
    {Coordinate{6.94111, 50.9686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Geldernstraße Parkgürtel station
    {Coordinate{-2.44972, 47.6833}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1895691
    {Coordinate{0.631366, 42.9629}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1897337
    {Coordinate{4.63194, 43.6847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arles
    {Coordinate{0.707778, 45.1874}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Périgueux
    {Coordinate{7.58889, 51.4953}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Sölde
    {Coordinate{11.6753, 44.923}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060595
    {Coordinate{11.7386, 44.961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060596
    {Coordinate{11.7492, 45.1322}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060599
    {Coordinate{5.49796, 50.6185}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemeppe-sur-Meuse railway station
    {Coordinate{4.14417, 51.1719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Niklaas railway station
    {Coordinate{5.66222, 53.0397}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sneek Noord railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melkouwen railway station
    {Coordinate{3.20182, 51.2231}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brugge-Sint-Pieters railway station
    {Coordinate{7.10172, 51.2543}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Rosenhügel station
    {Coordinate{7.10958, 51.4417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Eiberg station
    {Coordinate{5.17944, 52.0169}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Houten Castellum railway station
    {Coordinate{4.6325, 51.3569}, Tz::Europe_Brussels, CountryId{"BE"}}, // Noorderkempen railway station
    {Coordinate{3.88868, 50.508}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erbisœul railway station
    {Coordinate{7.12778, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Solingen-Schaberg
    {Coordinate{4.8132, 45.7174}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oullins
    {Coordinate{4.41176, 50.3527}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jamioulx railway station
    {Coordinate{3.38599, 45.8212}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1921700
    {Coordinate{6.67444, 53.4094}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Uithuizen railway station
    {Coordinate{5.56944, 51.3853}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heeze railway station
    {Coordinate{7.51607, 43.9441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Breil-sur-Roya
    {Coordinate{5.50972, 50.6197}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pont-de-Seraing railway station
    {Coordinate{4.80427, 45.8886}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-au-Mont-d'Or
    {Coordinate{7.56613, 48.5454}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1922941
    {Coordinate{7.48756, 47.6349}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bartenheim
    {Coordinate{-0.220278, 47.3622}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1925026
    {Coordinate{4.63876, 50.958}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wespelaar-Tildonk railway station
    {Coordinate{5.43694, 51.2214}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neerpelt railway station
    {Coordinate{3.12734, 51.025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lichtervelde railway station
    {Coordinate{4.77837, 45.9069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1926670
    {Coordinate{6.76454, 50.5592}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münstereifel station
    {Coordinate{6.68544, 49.802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ehrang station
    {Coordinate{13.6152, 52.3715}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eichwalde station
    {Coordinate{8.783, 50.6053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großen Buseck station
    {Coordinate{13.2675, 52.2986}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigsfelde railway station
    {Coordinate{11.1328, 51.6703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274496
    {Coordinate{6.35789, 51.1505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274497
    {Coordinate{14.1008, 52.5244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Müncheberg
    {Coordinate{14.4492, 51.8441}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274501
    {Coordinate{13.9228, 52.5283}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rehfelde station
    {Coordinate{10.3722, 52.0496}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Bad station
    {Coordinate{14.3517, 52.5594}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seelow-Gusow station
    {Coordinate{13.7453, 53.515}, Tz::Europe_Berlin, CountryId{"DE"}}, // Strasburg (Uckerm) railway station
    {Coordinate{13.1722, 52.685}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velten
    {Coordinate{7.95654, 51.6163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Welver station
    {Coordinate{14.4056, 52.565}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werbig station
    {Coordinate{10.5319, 52.1589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolfenbüttel station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274531
    {Coordinate{6.68816, 51.5977}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274532
    {Coordinate{-0.34187, 47.8417}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sablé
    {Coordinate{6.985, 51.589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19284709
    {Coordinate{1.80869, 48.9632}, Tz::Europe_Paris, CountryId{"FR"}}, // Épône - Mézières
    {Coordinate{7.58717, 48.5441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Duppigheim
    {Coordinate{1.38322, 43.5965}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1931292
    {Coordinate{5.72944, 51.8111}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wijchen railway station
    {Coordinate{1.69183, 47.8136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1931469
    {Coordinate{5.52448, 45.5446}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1932215
    {Coordinate{3.82694, 50.8158}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lierde railway station
    {Coordinate{4.40833, 50.7944}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boitsfort railway station
    {Coordinate{6.62806, 52.5725}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hardenberg railway station
    {Coordinate{5.7175, 50.8378}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maastricht Randwyck railway station
    {Coordinate{13.7692, 54.0439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolgast railway station
    {Coordinate{3.85723, 44.7327}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1935573
    {Coordinate{4.39045, 51.1975}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerp-South railway station
    {Coordinate{5.42317, 45.3967}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Grand-Lemps
    {Coordinate{6.56941, 48.1088}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1938345
    {Coordinate{4.07259, 50.8914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Denderleeuw railway station
    {Coordinate{1.69964, 46.8097}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Châteauroux
    {Coordinate{12.7125, 52.7425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Paulinenaue
    {Coordinate{4.27509, 50.8897}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zellik railway station
    {Coordinate{5.57389, 52.0458}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal-De Klomp railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pont-à-Celles railway station
    {Coordinate{6.60017, 48.0871}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1946266
    {Coordinate{10.0544, 53.6325}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kornweg station
    {Coordinate{2.3626, 49.167}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boran-sur-Oise
    {Coordinate{6.696, 48.4913}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1947085
    {Coordinate{5.73639, 50.8969}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bunde railway station
    {Coordinate{5.42056, 50.9106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diepenbeek railway station
    {Coordinate{6.22222, 52.4267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heino railway station
    {Coordinate{8.54392, 47.4117}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Oerlikon railway station
    {Coordinate{6.57753, 46.3979}, Tz::Europe_Paris, CountryId{"FR"}}, // Évian-les-Bains
    {Coordinate{4.4288, 50.2693}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pry railway station
    {Coordinate{4.86247, 50.4691}, Tz::Europe_Brussels, CountryId{"BE"}}, // Namur railway station
    {Coordinate{5.61972, 52.3375}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Harderwijk railway station
    {Coordinate{4.01119, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schoonaarde railway station
    {Coordinate{6.95806, 50.9425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cologne Central Station
    {Coordinate{12.5004, 45.6242}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545547
    {Coordinate{8.94654, 46.0064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q19545551
    {Coordinate{8.95158, 46.0029}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q19545553
    {Coordinate{10.0825, 53.6411}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wellingsbüttel station
    {Coordinate{6.9816, 43.5514}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bosquet
    {Coordinate{9.1425, 48.6964}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leinfelden station
    {Coordinate{5.27278, 45.5839}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1958669
    {Coordinate{16.2126, 48.3825}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Stockerau
    {Coordinate{4.89235, 45.8039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1959696
    {Coordinate{-1.5459, 43.4592}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Biarritz
    {Coordinate{10.0028, 52.4492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Railway station Burgdorf
    {Coordinate{6.56694, 53.3906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Warffum railway station
    {Coordinate{5.86833, 51.8267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Heyendaal railway station
    {Coordinate{8.61959, 47.4205}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietlikon railway station
    {Coordinate{8.44786, 47.3986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schlieren railway station
    {Coordinate{8.42136, 47.3987}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glanzenberg railway station
    {Coordinate{5.63444, 53.1778}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dronrijp railway station
    {Coordinate{8.62294, 47.4}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dübendorf railway station
    {Coordinate{5.15194, 52.3428}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Poort railway station
    {Coordinate{7.77925, 48.703}, Tz::Europe_Paris, CountryId{"FR"}}, // Hœrdt
    {Coordinate{11.7959, 45.7323}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622699
    {Coordinate{11.8776, 45.6881}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622702
    {Coordinate{13.633, 42.8443}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622704
    {Coordinate{13.8189, 42.8857}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622705
    {Coordinate{13.8499, 42.8942}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622707
    {Coordinate{13.7202, 42.8621}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622710
    {Coordinate{13.7628, 42.8703}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622714
    {Coordinate{4.34417, 51.9031}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlaardingen Centrum railway station
    {Coordinate{6.73611, 51.4572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltepunkt Duisburg-Ruhrort
    {Coordinate{6.9709, 51.713}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Deuten
    {Coordinate{1.90462, 47.9078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orléans
    {Coordinate{4.92556, 50.8061}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tienen railway station
    {Coordinate{4.61694, 51.9653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuwerkerk aan den IJssel railway station
    {Coordinate{6.11904, 50.8874}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzogenrath August-Schmidt-Platz station
    {Coordinate{7.14361, 46.0278}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q1968217
    {Coordinate{16.1506, 38.7264}, Tz::Europe_Rome, CountryId{"IT"}}, // Pizzo train station
    {Coordinate{7.05228, 48.7385}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1968912
    {Coordinate{8.72933, 40.4559}, Tz::Europe_Rome, CountryId{"IT"}}, // Giave railway station
    {Coordinate{6.49661, 44.567}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1969231
    {Coordinate{6.4497, 48.56}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1971525
    {Coordinate{11.797, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Naumburg (Saale) Hauptbahnhof
    {Coordinate{13.5536, 52.5575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mehrower Allee station
    {Coordinate{2.31194, 51.0022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grande-Synthe
    {Coordinate{2.20056, 49.9283}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ailly-sur-Somme
    {Coordinate{4.60972, 51.6414}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zevenbergen railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merchtem railway station
    {Coordinate{13.6647, 42.8449}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19768359
    {Coordinate{5.08168, 50.4972}, Tz::Europe_Brussels, CountryId{"BE"}}, // Château-de-Seilles railway station
    {Coordinate{3.18431, 51.3303}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zeebrugge-Strand railway station
    {Coordinate{15.7561, 50.9028}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q1978260
    {Coordinate{4.96472, 50.2106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gendron-Celles railway station
    {Coordinate{7.5897, 48.0271}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19787796
    {Coordinate{3.79528, 50.4358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boussu railway station
    {Coordinate{7.17667, 49.3531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neunkirchen Central Station
    {Coordinate{4.72099, 50.5514}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lonzée railway station
    {Coordinate{7.02943, 49.2163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19817142
    {Coordinate{5.31278, 51.2117}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lommel railway station
    {Coordinate{13.3577, 43.6072}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelferretti-Falconara Aeroporto delle Marche railway halt
    {Coordinate{13.3276, 43.5958}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiaravalle railway halt
    {Coordinate{13.2519, 43.5208}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819430
    {Coordinate{12.7844, 43.1819}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819439
    {Coordinate{12.7339, 42.8763}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819440
    {Coordinate{12.7615, 42.8228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819441
    {Coordinate{14.061, 42.3059}, Tz::Europe_Rome, CountryId{"IT"}}, // Manoppello railway station
    {Coordinate{14.0196, 42.2872}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819465
    {Coordinate{13.8762, 42.1023}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819467
    {Coordinate{8.59696, 40.6989}, Tz::Europe_Rome, CountryId{"IT"}}, // Scala di Giocca railway station
    {Coordinate{6.36528, 51.9217}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Terborg railway station
    {Coordinate{12.0319, 48.0836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinhöring Station
    {Coordinate{6.94433, 51.2186}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochdahl station
    {Coordinate{8.70806, 50.1128}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt East station
    {Coordinate{8.6505, 49.9506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835112
    {Coordinate{7.05007, 49.1188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835113
    {Coordinate{9.74, 52.4394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen Pferdemarkt station
    {Coordinate{8.32381, 48.8895}, Tz::Europe_Berlin, CountryId{"DE"}}, // Malsch station
    {Coordinate{12.4503, 52.8531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835119
    {Coordinate{11.2274, 52.0307}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oschersleben
    {Coordinate{7.1629, 51.1691}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid-Güldenwerth station
    {Coordinate{8.11496, 49.8461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835127
    {Coordinate{13.3175, 52.9797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835128
    {Coordinate{6.44639, 51.1381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheydt-Odenkirchen station
    {Coordinate{3.28832, 45.7845}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vertaizon
    {Coordinate{10.5628, 50.8628}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reinhardsbrunn-Friedrichroda railway station
    {Coordinate{8.76067, 40.4178}, Tz::Europe_Rome, CountryId{"IT"}}, // Bonorva railway station
    {Coordinate{5.0559, 50.3582}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florée railway station
    {Coordinate{-1.9513, 47.3587}, Tz::Europe_Paris, CountryId{"FR"}}, // Savenay
    {Coordinate{9.4037, 40.8377}, Tz::Europe_Rome, CountryId{"IT"}}, // Su Canale railway station
    {Coordinate{5.16823, 46.1306}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1989588
    {Coordinate{16.3855, 48.2419}, Tz::Europe_Vienna, CountryId{"AT"}}, // Handelskai (Vienna U-Bahn)
    {Coordinate{5.57556, 52.2653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Putten railway station
    {Coordinate{2.78139, 50.2869}, Tz::Europe_Paris, CountryId{"FR"}}, // Arras railway station
    {Coordinate{4.61276, 50.6383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mont-Saint-Guibert railway station
    {Coordinate{4.82556, 45.7483}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Perrache
    {Coordinate{6.67698, 51.3978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Rumeln
    {Coordinate{9.16944, 48.6919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Echterdingen station
    {Coordinate{5.29247, 50.0196}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poix-Saint-Hubert railway station
    {Coordinate{4.77365, 51.0373}, Tz::Europe_Brussels, CountryId{"BE"}}, // Booischot railway station
    {Coordinate{4.06417, 51.0151}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oudegem railway station
    {Coordinate{14.0828, 52.7628}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Altranft
    {Coordinate{14.14, 52.7158}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wriezen station
    {Coordinate{6.70121, 45.9066}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Gervais-les-Bains-Le Fayet
    {Coordinate{6.94814, 51.7512}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19965709
    {Coordinate{6.9922, 51.1663}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19965785
    {Coordinate{6.9062, 51.8092}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19971789
    {Coordinate{-0.882882, 48.8463}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vire
    {Coordinate{5.37548, 45.5611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1998901
    {Coordinate{7.49314, 43.7748}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Menton
    {Coordinate{9.58761, 41.0107}, Tz::Europe_Rome, CountryId{"IT"}}, // Cala Sabina railway station
    {Coordinate{9.43107, 40.8571}, Tz::Europe_Rome, CountryId{"IT"}}, // Enas railway station
    {Coordinate{9.53111, 40.9941}, Tz::Europe_Rome, CountryId{"IT"}}, // Rudalza railway station
    {Coordinate{16.2074, 38.1757}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009379
    {Coordinate{8.01835, 45.19}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009382
    {Coordinate{15.9239, 37.9303}, Tz::Europe_Rome, CountryId{"IT"}}, // Bova Marina railway station
    {Coordinate{16.8908, 40.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellaneta Marina railway station
    {Coordinate{15.8749, 37.9277}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009393
    {Coordinate{8.10717, 45.1942}, Tz::Europe_Rome, CountryId{"IT"}}, // Crescentino railway station
    {Coordinate{16.1345, 38.0163}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009398
    {Coordinate{8.18873, 45.1912}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009400
    {Coordinate{14.2878, 42.4214}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009402
    {Coordinate{8.56095, 45.0561}, Tz::Europe_Rome, CountryId{"IT"}}, // Giarole railway station
    {Coordinate{16.8908, 40.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Ginosa railway station
    {Coordinate{12.5545, 45.7844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009406
    {Coordinate{12.6972, 43.9774}, Tz::Europe_Rome, CountryId{"IT"}}, // Misano Adriatico railway station
    {Coordinate{13.6463, 43.2893}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009419
    {Coordinate{8.36619, 45.1707}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009420
    {Coordinate{8.23281, 45.189}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009427
    {Coordinate{15.9864, 37.9188}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009428
    {Coordinate{8.72806, 40.6613}, Tz::Europe_Rome, CountryId{"IT"}}, // Ploaghe railway station
    {Coordinate{12.4605, 45.7193}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009436
    {Coordinate{15.651, 38.0587}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009445
    {Coordinate{16.6156, 40.1001}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009447
    {Coordinate{13.8758, 41.1961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009461
    {Coordinate{7.96952, 45.1931}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009467
    {Coordinate{14.7278, 40.6742}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009468
    {Coordinate{16.3308, 38.3001}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009822
    {Coordinate{14.0687, 42.6077}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009824
    {Coordinate{14.0413, 42.6424}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009826
    {Coordinate{14.3397, 42.3939}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009827
    {Coordinate{16.144, 38.0527}, Tz::Europe_Rome, CountryId{"IT"}}, // Africo Nuovo railway station
    {Coordinate{16.5676, 38.5722}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009898
    {Coordinate{16.1532, 38.0891}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009905
    {Coordinate{8.80953, 40.2189}, Tz::Europe_Rome, CountryId{"IT"}}, // Borore train station
    {Coordinate{16.1806, 38.1491}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009909
    {Coordinate{16.1033, 37.9654}, Tz::Europe_Rome, CountryId{"IT"}}, // Brancaleone train station
    {Coordinate{13.0575, 43.2104}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009918
    {Coordinate{16.2648, 38.2332}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009968
    {Coordinate{16.5977, 40.0408}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009982
    {Coordinate{16.5418, 38.7286}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009984
    {Coordinate{16.6029, 39.9338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009991
    {Coordinate{8.77582, 40.0773}, Tz::Europe_Rome, CountryId{"IT"}}, // Paulilatino railway station
    {Coordinate{15.7108, 37.9387}, Tz::Europe_Rome, CountryId{"IT"}}, // Saline di Reggio train station
    {Coordinate{16.302, 38.2708}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010034
    {Coordinate{8.6798, 39.9525}, Tz::Europe_Rome, CountryId{"IT"}}, // Solarussa railway station
    {Coordinate{12.6688, 42.9844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010042
    {Coordinate{16.5321, 39.8656}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010060
    {Coordinate{8.69631, 39.6926}, Tz::Europe_Rome, CountryId{"IT"}}, // Uras-Mogoro railway station
    {Coordinate{16.4906, 39.8105}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010074
    {Coordinate{8.28278, 47.0706}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q20012446
    {Coordinate{6.62655, 46.5072}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ouchy station
    {Coordinate{7.79211, 47.5512}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q20020599
    {Coordinate{10.3827, 53.8054}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Oldesloe railway station
    {Coordinate{5.7875, 51.4561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deurne railway station
    {Coordinate{6.77167, 45.6181}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-Saint-Maurice
    {Coordinate{-1.10013, 49.1169}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Lô
    {Coordinate{6.385, 49.4736}, Tz::Europe_Berlin, CountryId{"DE"}}, // Perl railway station
    {Coordinate{4.24441, 50.8662}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dilbeek railway station
    {Coordinate{2.32623, 49.1552}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2006647
    {Coordinate{4.32389, 52.0811}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Centraal
    {Coordinate{3.25557, 50.9137}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ingelmunster railway station
    {Coordinate{4.85944, 45.7606}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Part-Dieu
    {Coordinate{2.73472, 48.1819}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Souppes–Château-Landon
    {Coordinate{3.80002, 50.6144}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maffle railway station
    {Coordinate{4.80378, 45.7801}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Vaise
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sterpenich railway station
    {Coordinate{4.97833, 49.9844}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gedinne railway station
    {Coordinate{4.82695, 45.766}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Saint-Paul
    {Coordinate{2.97194, 42.6011}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Elne
    {Coordinate{1.08934, 43.6172}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2016061
    {Coordinate{6.27401, 51.0331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hückelhoven-Baal station
    {Coordinate{15.2777, 41.2419}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20165207
    {Coordinate{6.25722, 51.8342}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emmerich station
    {Coordinate{13.1411, 54.3228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altefähr railway station
    {Coordinate{8.33863, 48.9648}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q20170857
    {Coordinate{7.89989, 49.9013}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenlonsheim station
    {Coordinate{13.1124, 52.5349}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löwenberg (Mark) railway station
    {Coordinate{13.7385, 52.6375}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werneuchen station
    {Coordinate{7.59238, 50.8072}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schladern station
    {Coordinate{7.58411, 48.3736}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Benfeld
    {Coordinate{4.72321, 50.0828}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2022973
    {Coordinate{-1.66102, 43.3857}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jean-de-Luz-Ciboure
    {Coordinate{5.71778, 50.8708}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maastricht Noord railway station
    {Coordinate{4.81969, 44.1375}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2025211
    {Coordinate{5.39746, 50.6642}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fexhe-le-Haut-Clocher railway station
    {Coordinate{4.53332, 50.7114}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rixensart railway station
    {Coordinate{7.15583, 52.3097}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Bentheim station
    {Coordinate{3.46528, 43.3175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Agde
    {Coordinate{4.505, 50.8831}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nossegem railway station
    {Coordinate{4.53097, 52.3758}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zandvoort aan Zee railway station
    {Coordinate{3.29716, 49.8397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Quentin
    {Coordinate{8.44604, 47.2759}, Tz::Europe_Zurich, CountryId{"CH"}}, // Affoltern am Albis railway station
    {Coordinate{8.79227, 47.317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wetzikon railway station
    {Coordinate{4.54372, 50.4821}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fleurus railway station
    {Coordinate{8.68662, 47.3691}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nänikon-Greifensee railway station
    {Coordinate{6.20641, 45.5576}, Tz::Europe_Paris, CountryId{"FR"}}, // Chamousset
    {Coordinate{5.78444, 52.3708}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nunspeet railway station
    {Coordinate{5.3425, 45.9539}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ambérieu
    {Coordinate{9.14361, 49.9803}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aschaffenburg Central Station
    {Coordinate{4.47194, 50.9781}, Tz::Europe_Brussels, CountryId{"BE"}}, // Weerde railway station
    {Coordinate{4.60194, 45.8118}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sain-Bel
    {Coordinate{4.11944, 51.9817}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoek van Holland Strand railway station
    {Coordinate{6.1025, 52.0447}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dieren railway station
    {Coordinate{5.80951, 49.6803}, Tz::Europe_Brussels, CountryId{"BE"}}, // Arlon railway station
    {Coordinate{6.12167, 45.9022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Annecy
    {Coordinate{4.43892, 50.4043}, Tz::Europe_Brussels, CountryId{"BE"}}, // Charleroi-South railway station
    {Coordinate{4.08455, 49.9144}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2044263
    {Coordinate{5.44077, 50.284}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melreux-Hotton railway station
    {Coordinate{4.38306, 51.9225}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schiedam Nieuwland railway station
    {Coordinate{-0.1918, 51.5473}, Tz::Europe_London, CountryId{"GB"}}, // West Hampstead railway station
    {Coordinate{5.28111, 52.2081}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Baarn railway station
    {Coordinate{1.38889, 43.5278}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Portet-Saint-Simon
    {Coordinate{7.05861, 46.0867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2047644
    {Coordinate{3.91002, 50.5302}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jurbise railway station
    {Coordinate{5.50095, 45.9228}, Tz::Europe_Paris, CountryId{"FR"}}, // Tenay - Hauteville
    {Coordinate{21.2975, 52.2408}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Sulejówek Miłosna train station
    {Coordinate{2.35278, 49.8642}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longueau
    {Coordinate{6.19685, 50.8558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf Poststraße station
    {Coordinate{6.58165, 48.0458}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2051806
    {Coordinate{4.26167, 50.3461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lobbes railway station
    {Coordinate{6.34225, 47.1498}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2052258
    {Coordinate{4.97861, 44.9917}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valence TGV
    {Coordinate{4.76997, 45.4503}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Clair - Les Roches
    {Coordinate{4.575, 50.6908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Limal railway station
    {Coordinate{13.0397, 52.7539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kremmen railway station
    {Coordinate{2.91755, 42.8355}, Tz::Europe_Paris, CountryId{"FR"}}, // Salses
    {Coordinate{2.0652, 45.4022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Égletons
    {Coordinate{6.41685, 46.0779}, Tz::Europe_Paris, CountryId{"FR"}}, // Bonneville
    {Coordinate{5.17583, 50.8172}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Truiden railway station
    {Coordinate{3.04359, 51.0251}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kortemark railway station
    {Coordinate{3.76689, 50.428}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hainin railway station
    {Coordinate{-0.924011, 53.7729}, Tz::Europe_London, CountryId{"GB"}}, // Wressle railway station
    {Coordinate{4.80479, 45.7661}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Gorge-de-Loup
    {Coordinate{3.98556, 50.9706}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lede railway station
    {Coordinate{4.37583, 50.6842}, Tz::Europe_Brussels, CountryId{"BE"}}, // Braine-l'Alleud railway station
    {Coordinate{4.43599, 50.2591}, Tz::Europe_Brussels, CountryId{"BE"}}, // Walcourt railway station
    {Coordinate{3.01316, 42.9325}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2062228
    {Coordinate{12.1845, 53.1461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pritzwalk station
    {Coordinate{12.8578, 52.0919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q20644102
    {Coordinate{4.63278, 52.4339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Santpoort Noord railway station
    {Coordinate{14.6458, 50.9864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eibau station
    {Coordinate{5.83278, 50.8692}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Valkenburg railway station
    {Coordinate{6.41694, 52.5097}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ommen railway station
    {Coordinate{5.56861, 50.6983}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liers railway station
    {Coordinate{14.0074, 51.028}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dürrröhrsdorf station
    {Coordinate{4.80472, 52.4692}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaandijk Zaanse Schans railway station
    {Coordinate{1.95389, 49.5714}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marseille-en-Beauvaisis
    {Coordinate{5.48028, 50.605}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flémalle-Grande railway station
    {Coordinate{4.49306, 51.0914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Duffel railway station
    {Coordinate{5.1, 45.6382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2072293
    {Coordinate{12.3743, 52.3852}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Wusterwitz
    {Coordinate{14.0364, 52.79}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Bad Freienwalde (Oder)
    {Coordinate{4.49528, 51.1631}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boechout railway station
    {Coordinate{4.86906, 50.3488}, Tz::Europe_Brussels, CountryId{"BE"}}, // Godinne railway station
    {Coordinate{9.27383, 51.492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q20754313
    {Coordinate{7.16998, 49.6056}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubrücke (Nahe) station
    {Coordinate{4.53306, 51.5875}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oudenbosch railway station
    {Coordinate{4.04234, 51.0731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zele railway station
    {Coordinate{1.35294, 43.6026}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Ramassiers
    {Coordinate{4.82435, 45.7068}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2076776
    {Coordinate{4.94796, 48.6426}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2077891
    {Coordinate{5.18722, 52.2164}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hilversum Sportpark railway station
    {Coordinate{5.17389, 52.2378}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hilversum Media Park railway station
    {Coordinate{4.69056, 50.5702}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gembloux railway station
    {Coordinate{4.54374, 50.4241}, Tz::Europe_Brussels, CountryId{"BE"}}, // Campinaire railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heusden railway station
    {Coordinate{5.44995, 45.5601}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2082423
    {Coordinate{6.04333, 50.7089}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hergenrath railway station
    {Coordinate{7.98806, 46.3194}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brig railway station
    {Coordinate{14.7088, 50.9661}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberoderwitz station
    {Coordinate{5.43855, 45.9474}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Rambert-en-Bugey
    {Coordinate{3.96016, 49.0465}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Épernay
    {Coordinate{4.12653, 50.4743}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bracquegnies railway station
    {Coordinate{4.76334, 49.8584}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bogny-sur-Meuse
    {Coordinate{11.1893, 47.3289}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Seefeld in Tirol
    {Coordinate{1.48113, 48.4483}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chartres
    {Coordinate{4.58556, 50.8964}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erps-Kwerps railway station
    {Coordinate{4.17652, 50.6513}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hennuyères railway station
    {Coordinate{4.26614, 50.7517}, Tz::Europe_Brussels, CountryId{"BE"}}, // Huizingen railway station
    {Coordinate{3.32919, 51.1282}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beernem railway station
    {Coordinate{5.92944, 50.8867}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voerendaal railway station
    {Coordinate{4.97701, 45.8274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Maurice-de-Beynost
    {Coordinate{7.48899, 48.4621}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2092112
    {Coordinate{5.98194, 49.6386}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Capellen railway station
    {Coordinate{13.2932, 51.0609}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nossen station
    {Coordinate{4.365, 51.9906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delft Zuid railway station
    {Coordinate{3.83435, 50.5998}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mévergnies-Attre railway station
    {Coordinate{6.72387, 51.4018}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinhausen Ost station
    {Coordinate{7.88645, 45.3534}, Tz::Europe_Rome, CountryId{"IT"}}, // Mercenasco railway station
    {Coordinate{7.88796, 45.3825}, Tz::Europe_Rome, CountryId{"IT"}}, // Strambino railway station
    {Coordinate{7.87635, 45.4615}, Tz::Europe_Rome, CountryId{"IT"}}, // Ivrea railway station
    {Coordinate{7.89189, 45.3299}, Tz::Europe_Rome, CountryId{"IT"}}, // Candia Canavese railway station
    {Coordinate{7.90259, 45.3032}, Tz::Europe_Rome, CountryId{"IT"}}, // Caluso railway station
    {Coordinate{7.85838, 45.2328}, Tz::Europe_Rome, CountryId{"IT"}}, // Montanaro railway station
    {Coordinate{13.4742, 46.5098}, Tz::Europe_Rome, CountryId{"IT"}}, // Ugovizza railway station
    {Coordinate{15.7109, 38.2513}, Tz::Europe_Rome, CountryId{"IT"}}, // Scilla railway station
    {Coordinate{15.8004, 38.2827}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnara railway station
    {Coordinate{2.87667, 50.8478}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ieper railway station
    {Coordinate{5.11859, 49.8953}, Tz::Europe_Brussels, CountryId{"BE"}}, // Paliseul railway station
    {Coordinate{12.1292, 50.4864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2098942
    {Coordinate{14.5789, 51.0044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebersbach (Sachs) station
    {Coordinate{-1.30054, 43.4993}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Urt
    {Coordinate{4.39361, 50.8019}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boondael railway station
    {Coordinate{-0.241589, 43.1819}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coarraze-Nay
    {Coordinate{4.94944, 52.3531}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Science Park railway station
    {Coordinate{6.4453, 51.6597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21035431
    {Coordinate{14.2164, 52.5381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trebnitz
    {Coordinate{11.3221, 49.5204}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Neunkirchen a Sand
    {Coordinate{7.84988, 47.7057}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zell (Wiesental station)
    {Coordinate{7.97028, 51.4381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21035442
    {Coordinate{14.4803, 51.0424}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21036573
    {Coordinate{7.07466, 51.458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21042075
    {Coordinate{5.13056, 45.8514}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La-Valbonne
    {Coordinate{30.489, 50.4404}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kiev Passenger Railway Station
    {Coordinate{6.00222, 52.4536}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wezep railway station
    {Coordinate{1.85056, 50.9533}, Tz::Europe_Paris, CountryId{"FR"}}, // Calais-Ville railway station
    {Coordinate{6.70361, 51.9744}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winterswijk West railway station
    {Coordinate{6.38608, 48.5652}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2110347
    {Coordinate{8.54879, 47.3241}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kilchberg railway station
    {Coordinate{8.57825, 47.2796}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberrieden railway station
    {Coordinate{8.55577, 47.3063}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rüschlikon railway station
    {Coordinate{7.1625, 46.0828}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2110844
    {Coordinate{4.23505, 50.506}, Tz::Europe_Brussels, CountryId{"BE"}}, // Manage railway station
    {Coordinate{4.44331, 50.8904}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diegem railway station
    {Coordinate{4.81972, 52.4567}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaandam Kogerveld railway station
    {Coordinate{7.67865, 48.5595}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116031
    {Coordinate{4.76099, 50.1039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116916
    {Coordinate{4.12534, 45.8859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116993
    {Coordinate{13.1603, 52.0906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Luckenwalde station
    {Coordinate{0.41765, 49.6036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bréauté-Beuzeville
    {Coordinate{2.94306, 48.3794}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montereau
    {Coordinate{1.60667, 42.97}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Foix
    {Coordinate{6.61051, 51.3299}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Oppum station
    {Coordinate{8.17872, 53.1517}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oldenburg-Wechloy railway station
    {Coordinate{0.808218, 45.1383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Niversac
    {Coordinate{6.15631, 45.5574}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-d'Albigny railway station
    {Coordinate{-4.3145, 55.9412}, Tz::Europe_London, CountryId{"GB"}}, // Milngavie railway station
    {Coordinate{5.68833, 50.5731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Trooz railway station
    {Coordinate{6.56917, 52.4575}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vroomshoop railway station
    {Coordinate{-3.83265, 48.5779}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Morlaix
    {Coordinate{5.41056, 52.9028}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Koudum-Molkwerum railway station
    {Coordinate{3.40949, 49.038}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-Thierry
    {Coordinate{5.57806, 51.9581}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rhenen railway station
    {Coordinate{4.45611, 51.1708}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Oude-God railway station
    {Coordinate{12.413, 51.1505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neukieritzsch station
    {Coordinate{12.6976, 51.0582}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geithain station
    {Coordinate{0.971667, 43.1789}, Tz::Europe_Paris, CountryId{"FR"}}, // Boussens train station
    {Coordinate{2.35194, 43.2181}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carcassonne
    {Coordinate{6.23639, 46.1994}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Annemasse
    {Coordinate{6.95357, 51.3634}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kettwig station
    {Coordinate{8.49892, 47.9478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Donaueschingen station
    {Coordinate{5.03667, 50.7636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neerwinden railway station
    {Coordinate{4.18808, 50.4654}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Louvière-South railway station
    {Coordinate{5.7225, 51.9194}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zetten-Andelst railway station
    {Coordinate{4.8145, 45.1857}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2134090
    {Coordinate{21.1353, 52.2369}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Gocławek railway station
    {Coordinate{4.01043, 50.5434}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neufvilles railway station
    {Coordinate{1.77444, 49.6856}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Abancourt
    {Coordinate{4.46889, 51.1692}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Liersesteenweg railway station
    {Coordinate{-1.78134, 46.4998}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Sables-d'Olonne
    {Coordinate{4.55197, 50.5571}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tilly railway station
    {Coordinate{3.83679, 50.7126}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lessines railway station
    {Coordinate{-0.867991, 47.4102}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2140129
    {Coordinate{1.64251, 50.5171}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Étaples-Le Touquet
    {Coordinate{9.86992, 53.2848}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holm-Seppensen station
    {Coordinate{6.14447, 48.7554}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2142149
    {Coordinate{5.79918, 46.9771}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mouchard
    {Coordinate{6.97693, 51.4802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Bergeborbeck station
    {Coordinate{5.26778, 49.8528}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bertrix railway station
    {Coordinate{9.2092, 48.496}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reutlingen Central Railway Station
    {Coordinate{4.40035, 50.462}, Tz::Europe_Brussels, CountryId{"BE"}}, // Courcelles-Motte railway station
    {Coordinate{7.45874, 47.6557}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sierentz
    {Coordinate{7.94544, 52.7236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen (Oldb)
    {Coordinate{6.72056, 53.4139}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Uithuizermeeden railway station
    {Coordinate{13.5475, 52.5506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Raoul-Wallenberg-Straße railway station
    {Coordinate{9.85857, 53.2696}, Tz::Europe_Berlin, CountryId{"DE"}}, // Büsenbachtal station
    {Coordinate{9.84476, 53.2418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Handeloh station
    {Coordinate{9.82863, 53.1861}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wintermoor station
    {Coordinate{5.65334, 46.2597}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oyonnax
    {Coordinate{6.15765, 46.8577}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Frasne
    {Coordinate{6.47056, 52.3656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijverdal railway station
    {Coordinate{6.8725, 52.7475}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Emmen Zuid railway station
    {Coordinate{19.9472, 50.0656}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Kraków Główny railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zolder railway station
    {Coordinate{3.20476, 46.0976}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2154970
    {Coordinate{6.96528, 51.455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Frohnhausen station
    {Coordinate{1.37019, 48.7314}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dreux
    {Coordinate{4.08545, 46.0239}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Coteau
    {Coordinate{19.8222, 49.9772}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2156575
    {Coordinate{2.97922, 45.1254}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2156841
    {Coordinate{4.45111, 51.4625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Essen railway station
    {Coordinate{8.5969, 47.2615}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horgen railway station
    {Coordinate{8.69286, 47.2087}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burghalden railway station
    {Coordinate{8.64273, 47.2469}, Tz::Europe_Zurich, CountryId{"CH"}}, // Au ZH railway station
    {Coordinate{8.67528, 47.2294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wädenswil railway station
    {Coordinate{1.90611, 42.4586}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Latour-de-Carol-Enveitg
    {Coordinate{4.65014, 50.7365}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gastuche railway station
    {Coordinate{5.62412, 52.0847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lunteren railway station
    {Coordinate{8.54599, 52.2891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzhausen-Heddinghausen station
    {Coordinate{3.9219, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schellebelle railway station
    {Coordinate{4.70446, 44.4433}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2161382
    {Coordinate{5.78583, 50.9469}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beek-Elsloo railway station
    {Coordinate{4.49185, 50.0564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Couvin railway station
    {Coordinate{1.88304, 48.081}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Artenay
    {Coordinate{5.06833, 52.0986}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Leidsche Rijn railway station
    {Coordinate{7.17367, 47.8019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cernay
    {Coordinate{5.55559, 50.6108}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sclessin railway station
    {Coordinate{-1.05038, 43.7208}, Tz::Europe_Paris, CountryId{"FR"}}, // Dax
    {Coordinate{3.10083, 45.7786}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clermont-Ferrand
    {Coordinate{2.25237, 46.9921}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2168788
    {Coordinate{4.00797, 50.4698}, Tz::Europe_Brussels, CountryId{"BE"}}, // Obourg railway station
    {Coordinate{2.28355, 49.8932}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Roch
    {Coordinate{5.22722, 51.9472}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Culemborg railway station
    {Coordinate{4.38, 50.5072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Luttre railway station
    {Coordinate{3.18228, 50.811}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wevelgem railway station
    {Coordinate{3.52621, 50.5273}, Tz::Europe_Brussels, CountryId{"BE"}}, // Callenelle railway station
    {Coordinate{4.81556, 51.8294}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hardinxveld Blauwe Zoom railway station
    {Coordinate{4.53422, 50.5778}, Tz::Europe_Brussels, CountryId{"BE"}}, // Villers-la-Ville railway station
    {Coordinate{5.56194, 50.6408}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liège-Jonfosse railway station
    {Coordinate{6.30435, 46.0667}, Tz::Europe_Paris, CountryId{"FR"}}, // La Roche-sur-Foron
    {Coordinate{4.4575, 50.9586}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eppegem railway station
    {Coordinate{1.83083, 49.6544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Feuquières-Broquiers
    {Coordinate{6.40556, 53.2483}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zuidhorn railway station
    {Coordinate{4.70164, 50.9226}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wijgmaal railway station
    {Coordinate{13.3679, 52.4924}, Tz::Europe_Berlin, CountryId{"DE"}}, // Yorckstraße (Großgörschenstraße) station
    {Coordinate{13.3721, 52.4918}, Tz::Europe_Berlin, CountryId{"DE"}}, // Yorckstraße station
    {Coordinate{6.17361, 48.6897}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nancy-Ville
    {Coordinate{4.40707, 50.285}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berzée railway station
    {Coordinate{1.45028, 43.5797}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Saint-Agne
    {Coordinate{6.95083, 52.2211}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enschede De Eschmarke railway station
    {Coordinate{-1.54167, 47.2167}, Tz::Europe_Paris, CountryId{"FR"}}, // Nantes station
    {Coordinate{3.75665, 51.0383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gentbrugge railway station
    {Coordinate{4.80528, 52.7861}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schagen railway station
    {Coordinate{4.17695, 50.5463}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marche-lez-Écaussinnes railway station
    {Coordinate{5.06138, 50.343}, Tz::Europe_Brussels, CountryId{"BE"}}, // Natoye railway station
    {Coordinate{4.12064, 45.5544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Romain le Puy
    {Coordinate{-0.236448, 44.9159}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Libourne
    {Coordinate{1.82419, 50.1021}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Abbeville
    {Coordinate{3.62378, 50.8703}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eine railway station
    {Coordinate{5.55133, 46.6685}, Tz::Europe_Paris, CountryId{"FR"}}, // Lons-le-Saunier railway station
    {Coordinate{3.22353, 49.6111}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chauny
    {Coordinate{5.29972, 52.1833}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Soestdijk railway station
    {Coordinate{19.1329, 47.7826}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vác railway station
    {Coordinate{4.93139, 52.495}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend Weidevenne railway station
    {Coordinate{7.01944, 43.5539}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cannes
    {Coordinate{4.51722, 52.2153}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sassenheim railway station
    {Coordinate{6.4971, 48.5879}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2186882
    {Coordinate{1.54155, 45.5362}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Masseret
    {Coordinate{4.34833, 51.1828}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hoboken-Polder railway station
    {Coordinate{3.25001, 48.5135}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longueville
    {Coordinate{5.23389, 50.5272}, Tz::Europe_Brussels, CountryId{"BE"}}, // Huy railway station
    {Coordinate{21.7055, 47.9453}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyíregyháza railway station
    {Coordinate{-2.43267, 47.2826}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Pouliguen train station
    {Coordinate{1.8, 42.5889}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Hospitalet-près-l'Andorre
    {Coordinate{5.99333, 50.89}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerlen de Kissel railway station
    {Coordinate{5.86222, 51.0603}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Susteren railway station
    {Coordinate{5.11278, 51.1903}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mol railway station
    {Coordinate{-0.698056, 49.2697}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bayeux
    {Coordinate{3.09062, 45.768}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2189379
    {Coordinate{7.71804, 48.666}, Tz::Europe_Paris, CountryId{"FR"}}, // Vendenheim
    {Coordinate{5.34892, 50.9896}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zonhoven railway station
    {Coordinate{6.4414, 48.178}, Tz::Europe_Paris, CountryId{"FR"}}, // Épinal railway station
    {Coordinate{4.65111, 50.7997}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Joris-Weert railway station
    {Coordinate{3.05702, 44.3247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2191151
    {Coordinate{6.07278, 51.9231}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zevenaar railway station
    {Coordinate{4.69528, 50.8625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heverlee railway station
    {Coordinate{-4.09222, 47.9947}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quimper
    {Coordinate{-0.930065, 45.6666}, Tz::Europe_Paris, CountryId{"FR"}}, // Saujon
    {Coordinate{0.0841667, 49.36}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Trouville-Deauville
    {Coordinate{6.663, 50.698}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zülpich
    {Coordinate{5.82861, 49.5633}, Tz::Europe_Brussels, CountryId{"BE"}}, // Athus railway station
    {Coordinate{5.41111, 53.1747}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Harlingen Haven railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Temse railway station
    {Coordinate{4.54947, 50.6935}, Tz::Europe_Brussels, CountryId{"BE"}}, // Profondsart railway station
    {Coordinate{4.46694, 51.3908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kalmthout railway station
    {Coordinate{4.76264, 50.4432}, Tz::Europe_Brussels, CountryId{"BE"}}, // Floreffe railway station
    {Coordinate{4.81111, 52.8669}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Anna Paulowna railway station
    {Coordinate{3.44909, 51.092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalter railway station
    {Coordinate{7.57224, 48.7552}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2198911
    {Coordinate{4.06479, 48.2959}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Troyes
    {Coordinate{6.36617, 46.2701}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bons-en-Chablais
    {Coordinate{0.596937, 43.6473}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2200917
    {Coordinate{4.36194, 50.8522}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels Congress railway station
    {Coordinate{3.69649, 43.4128}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sète
    {Coordinate{0.77258, 49.0743}, Tz::Europe_Paris, CountryId{"FR"}}, // Beaumont-le-Roger
    {Coordinate{7.09567, 48.7429}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2202248
    {Coordinate{4.43417, 51.2817}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ekeren railway station
    {Coordinate{5.89222, 50.9197}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nuth railway station
    {Coordinate{3.24132, 50.1768}, Tz::Europe_Paris, CountryId{"FR"}}, // Cambrai-Ville railway station
    {Coordinate{6.99796, 51.3868}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Werden station
    {Coordinate{4.77952, 45.7657}, Tz::Europe_Paris, CountryId{"FR"}}, // railway station of Écully-la-Demi-Lune
    {Coordinate{1.34194, 43.7858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castelnau-d'Estrétefonds
    {Coordinate{2.0888, 49.4265}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Beauvais
    {Coordinate{5.25194, 52.6961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bovenkarspel Flora railway station
    {Coordinate{5.71992, 45.1528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Échirolles
    {Coordinate{6.98, 51.4542}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen West station
    {Coordinate{4.46278, 50.4322}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lodelinsart railway station
    {Coordinate{-2.765, 48.5075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Brieuc
    {Coordinate{3.16307, 50.6957}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Roubaix
    {Coordinate{10.7666, 46.6261}, Tz::Europe_Rome, CountryId{"IT"}}, // Schlanders train station
    {Coordinate{5.58556, 50.4858}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rivage railway station
    {Coordinate{5.90332, 45.6485}, Tz::Europe_Paris, CountryId{"FR"}}, // Viviers-du-Lac
    {Coordinate{1.94072, 49.6618}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grandvilliers
    {Coordinate{4.99954, 43.5805}, Tz::Europe_Paris, CountryId{"FR"}}, // Miramas Station
    {Coordinate{3.10583, 42.5189}, Tz::Europe_Paris, CountryId{"FR"}}, // Port-Ventres railway station
    {Coordinate{8.947, 44.4066}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Brignole
    {Coordinate{6.74833, 53.3344}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Loppersum railway station
    {Coordinate{4.45111, 51.4625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wildert railway station
    {Coordinate{4.079, 45.6038}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2217344
    {Coordinate{-0.908241, 44.0336}, Tz::Europe_Paris, CountryId{"FR"}}, // Morcenx
    {Coordinate{7.27942, 48.0858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Turckheim
    {Coordinate{3.98333, 50.9433}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vijfhuizen railway station
    {Coordinate{-0.767612, 43.4841}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orthez
    {Coordinate{1.38947, 44.742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gourdon
    {Coordinate{2.73601, 50.8544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poperinge railway station
    {Coordinate{5.01194, 52.1031}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vleuten railway station
    {Coordinate{7.26846, 47.6763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2222548
    {Coordinate{-2.08833, 47.4352}, Tz::Europe_Paris, CountryId{"FR"}}, // Pontchâteau
    {Coordinate{7.00433, 50.9535}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Buchforst
    {Coordinate{0.489222, 44.8573}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bergerac
    {Coordinate{4.56912, 50.6596}, Tz::Europe_Brussels, CountryId{"BE"}}, // Céroux-Mousty railway station
    {Coordinate{7.54714, 48.8424}, Tz::Europe_Paris, CountryId{"FR"}}, // Obermodern
    {Coordinate{4.02611, 50.8394}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ninove railway station
    {Coordinate{6.71583, 52.26}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delden railway station
    {Coordinate{7.1342, 51.3724}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Nierenhof station
    {Coordinate{3.61677, 50.6006}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leuze railway station
    {Coordinate{6.8981, 51.0212}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Köln-Chorweiler
    {Coordinate{1.2894, 43.6215}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2227003
    {Coordinate{3.60177, 50.7422}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ronse railway station
    {Coordinate{4.66699, 50.5925}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ernage railway station
    {Coordinate{6.84116, 51.2025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Eller Mitte station
    {Coordinate{13.3292, 52.4776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Bundesplatz station
    {Coordinate{13.2994, 52.5303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Jungfernheide station
    {Coordinate{3.09053, 50.3718}, Tz::Europe_Paris, CountryId{"FR"}}, // Douai railway station
    {Coordinate{13.451, 52.5064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Warschauer Straße metro station
    {Coordinate{5.61194, 50.6439}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bressoux railway station
    {Coordinate{4.67139, 51.7897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dordrecht Zuid railway station
    {Coordinate{5.45406, 50.6563}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bierset-Awans railway station
    {Coordinate{5.21861, 50.5286}, Tz::Europe_Brussels, CountryId{"BE"}}, // Statte railway station
    {Coordinate{4.74278, 52.0147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gouda Goverwelle railway station
    {Coordinate{4.71667, 51.8017}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dordrecht Stadspolders railway station
    {Coordinate{4.44917, 50.7661}, Tz::Europe_Brussels, CountryId{"BE"}}, // Groenendaal railway station
    {Coordinate{8.77639, 46.1169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ranzo-Sant’Abbondio railway station
    {Coordinate{8.785, 46.1219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gerra (Gambarogno) railway station
    {Coordinate{4.24028, 51.0992}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bornem railway station
    {Coordinate{7.07073, 50.9816}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Dellbrück station
    {Coordinate{2.07799, 44.5782}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Capdenac
    {Coordinate{4.53607, 50.1915}, Tz::Europe_Brussels, CountryId{"BE"}}, // Philippeville railway station
    {Coordinate{5.85444, 50.5878}, Tz::Europe_Brussels, CountryId{"BE"}}, // Verviers-Central railway station
    {Coordinate{-0.476521, 48.1576}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Neau
    {Coordinate{5.2357, 51.0507}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beringen railway station
    {Coordinate{4.21097, 50.4303}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leval railway station
    {Coordinate{1.41854, 43.5934}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Saint-Cyprien-Arènes
    {Coordinate{4.63883, 51.1135}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berlaar railway station
    {Coordinate{2.19415, 50.9523}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2243517
    {Coordinate{3.12806, 42.4831}, Tz::Europe_Paris, CountryId{"FR"}}, // Banyuls-sur-Mer railway station
    {Coordinate{0.620833, 44.2083}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Agen
    {Coordinate{-0.784, 51.788}, Tz::Europe_London, CountryId{"GB"}}, // Stoke Mandeville railway station
    {Coordinate{8.54028, 47.3778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Hauptbahnhof
    {Coordinate{2.37679, 49.2034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2247293
    {Coordinate{16.7442, 53.1431}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Piła Główna
    {Coordinate{9.76, 48.6833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Süßen station
    {Coordinate{5.62278, 50.6606}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herstal railway station
    {Coordinate{5.95278, 50.8961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerlen Woonboulevard railway station
    {Coordinate{0.166206, 48.5999}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sées
    {Coordinate{6.87398, 45.9227}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2250995
    {Coordinate{5.08014, 50.7478}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landen railway station
    {Coordinate{3.88244, 51.0016}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wetteren railway station
    {Coordinate{7.3085, 47.747}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mulhouse-Dornach
    {Coordinate{4.77778, 46.2831}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mâcon-Loché TGV
    {Coordinate{3.73306, 50.8753}, Tz::Europe_Brussels, CountryId{"BE"}}, // Munkzwalm railway station
    {Coordinate{-4.48046, 48.3878}, Tz::Europe_Paris, CountryId{"FR"}}, // Brest railway station
    {Coordinate{5.87318, 50.3691}, Tz::Europe_Brussels, CountryId{"BE"}}, // Trois-Ponts railway station
    {Coordinate{6.60028, 52.4019}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vriezenveen railway station
    {Coordinate{6.93878, 51.1025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenfeld station
    {Coordinate{4.56583, 52.3028}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hillegom
    {Coordinate{2.36167, 48.9175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Plaine-Stade de France
    {Coordinate{-0.369481, 43.2915}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pau
    {Coordinate{4.6275, 52.4042}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bloemendaal railway station
    {Coordinate{4.79626, 45.6073}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2260903
    {Coordinate{1.04907, 44.627}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranche-du-Périgord
    {Coordinate{4.01389, 50.7242}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herne railway station
    {Coordinate{7.46493, 48.7518}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2262411
    {Coordinate{0.718873, 49.1076}, Tz::Europe_Paris, CountryId{"FR"}}, // Serquigny
    {Coordinate{5.32077, 50.6787}, Tz::Europe_Brussels, CountryId{"BE"}}, // Remicourt railway station
    {Coordinate{3.66789, 51.126}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sleidinge railway station
    {Coordinate{5.03361, 52.1353}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarssen railway station
    {Coordinate{1.35263, 49.1747}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gaillon - Aubevoye
    {Coordinate{8.46225, 50.1248}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22677939
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22682010
    {Coordinate{6.27778, 52.3917}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Raalte railway station
    {Coordinate{2.14056, 49.9461}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Picquigny
    {Coordinate{5.3446, 47.8771}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2268586
    {Coordinate{13.3658, 49.7403}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q2269031
    {Coordinate{12.5949, 52.1359}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691241
    {Coordinate{8.07386, 49.8083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691245
    {Coordinate{9.9125, 51.7972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Einbeck-Salzderhelden station
    {Coordinate{9.0053, 50.0767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691248
    {Coordinate{11.4522, 50.1097}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kulmbach station
    {Coordinate{10.3429, 51.9303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langelsheim station
    {Coordinate{9.42269, 49.43}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osterburken station
    {Coordinate{9.48499, 48.1497}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691254
    {Coordinate{12.1314, 51.0564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zeitz station
    {Coordinate{8.49479, 49.9123}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22692098
    {Coordinate{10.5486, 46.6843}, Tz::Europe_Rome, CountryId{"IT"}}, // Q22692924
    {Coordinate{16.8775, 48.6863}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bernhardsthal railway station
    {Coordinate{4.92389, 51.5839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gilze-Rijen railway station
    {Coordinate{4.65472, 50.7608}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florival railway station
    {Coordinate{5.72306, 52.5339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dronten railway station
    {Coordinate{4.74722, 52.3858}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Halfweg-Zwanenburg railway station
    {Coordinate{1.32353, 47.5854}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Blois
    {Coordinate{5.98222, 45.7861}, Tz::Europe_Paris, CountryId{"FR"}}, // Albens
    {Coordinate{-1.14273, 44.637}, Tz::Europe_Paris, CountryId{"FR"}}, // La Teste
    {Coordinate{-1.139, 50.678}, Tz::Europe_London, CountryId{"GB"}}, // Brading railway station
    {Coordinate{4.93013, 49.6949}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2275121
    {Coordinate{4.13106, 43.6794}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2277923
    {Coordinate{3.42436, 50.8917}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waregem railway station
    {Coordinate{2.76941, 43.1999}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2280048
    {Coordinate{6.00765, 45.4342}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2281291
    {Coordinate{3.28342, 44.7183}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aumont-Aubrac
    {Coordinate{5.82361, 51.8278}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Goffert railway station
    {Coordinate{2.87973, 42.6963}, Tz::Europe_Paris, CountryId{"FR"}}, // Perpignan railway station
    {Coordinate{4.55258, 50.4291}, Tz::Europe_Brussels, CountryId{"BE"}}, // Farciennes railway station
    {Coordinate{4.66343, 50.4514}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemeppe-sur-Sambre railway station
    {Coordinate{4.8182, 50.1402}, Tz::Europe_Paris, CountryId{"FR"}}, // Givet railway station
    {Coordinate{4.53918, 50.6095}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Roche railway station
    {Coordinate{4.24907, 45.6444}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2286280
    {Coordinate{4.49028, 51.03}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mechelen-Nekkerspoel railway station
    {Coordinate{1.47842, 49.0912}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vernon
    {Coordinate{1.61008, 50.7155}, Tz::Europe_Paris, CountryId{"FR"}}, // Boulogne-Ville railway station
    {Coordinate{8.87481, 49.2505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sinsheim Central Station
    {Coordinate{4.99528, 50.7714}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ezemaal train station
    {Coordinate{7.96722, 50.5578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Westerburg station
    {Coordinate{5.58944, 52.1408}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barneveld Zuid railway station
    {Coordinate{12.5233, 41.8794}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Tuscolana railway station
    {Coordinate{4.96533, 50.4807}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marche-les-Dames railway station
    {Coordinate{2.92583, 51.2289}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oostende railway station
    {Coordinate{4.20583, 50.6918}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tubize railway station
    {Coordinate{7.54271, 47.2042}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn railway station
    {Coordinate{-0.255702, 44.5554}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Langon
    {Coordinate{4.8803, 50.4549}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jambes-Est railway station
    {Coordinate{5.29083, 50.5392}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ampsin railway station
    {Coordinate{4.38972, 52.0561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Ypenburg
    {Coordinate{3.49389, 50.8264}, Tz::Europe_Brussels, CountryId{"BE"}}, // Anzegem railway station
    {Coordinate{3.84694, 50.7328}, Tz::Europe_Brussels, CountryId{"BE"}}, // Acren railway station
    {Coordinate{3.59167, 50.5136}, Tz::Europe_Brussels, CountryId{"BE"}}, // Péruwelz railway station
    {Coordinate{3.65569, 51.0471}, Tz::Europe_Brussels, CountryId{"BE"}}, // Drongen railway station
    {Coordinate{4.78472, 51.1683}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wolfstee railway station
    {Coordinate{4.0685, 50.8768}, Tz::Europe_Brussels, CountryId{"BE"}}, // Iddergem railway station
    {Coordinate{5.815, 50.5364}, Tz::Europe_Brussels, CountryId{"BE"}}, // Theux railway station
    {Coordinate{8.64794, 47.3253}, Tz::Europe_Zurich, CountryId{"CH"}}, // Forch railway station
    {Coordinate{8.7099, 47.2878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Esslingen railway station
    {Coordinate{8.58338, 47.351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Rehalp railway station
    {Coordinate{5.09113, 50.2913}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ciney railway station
    {Coordinate{9.79891, 53.1105}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schneverdingen station
    {Coordinate{9.84521, 53.0272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolterdingen (Han) station
    {Coordinate{9.86112, 53.0015}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soltau (Han) Nord station
    {Coordinate{9.7712, 52.8991}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dorfmark station
    {Coordinate{9.70031, 52.8629}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Fallingbostel station
    {Coordinate{9.60116, 52.8649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Walsrode station
    {Coordinate{5.45833, 52.1664}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoevelaken railway station
    {Coordinate{6.75806, 52.6944}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dalen railway station
    {Coordinate{5.04306, 52.1008}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Terwijde railway station
    {Coordinate{-1.47806, 47.1861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vertou
    {Coordinate{9.59529, 52.7663}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hodenhagen station
    {Coordinate{9.62449, 52.6786}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwarmstedt station
    {Coordinate{9.68875, 52.611}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindwedel station
    {Coordinate{5.26472, 51.8069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaltbommel railway station
    {Coordinate{1.37778, 50.0631}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Tréport-Mers
    {Coordinate{5.3929, 43.3307}, Tz::Europe_Paris, CountryId{"FR"}}, // Picon-Busserine
    {Coordinate{4.05083, 50.9031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Welle railway station
    {Coordinate{5.16278, 52.2656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bussum Zuid railway station
    {Coordinate{6.62722, 51.6558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wesel station
    {Coordinate{4.3366, 47.6187}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montbard
    {Coordinate{4.39417, 50.4122}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marchienne-au-Pont railway station
    {Coordinate{-1.78083, 43.3533}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hendaye
    {Coordinate{7.49447, 48.3101}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ebersheim
    {Coordinate{3.85627, 50.4499}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quaregnon railway station
    {Coordinate{6.02383, 46.5257}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2314163
    {Coordinate{4.34235, 50.8728}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tour and Taxis railway station
    {Coordinate{3.08139, 42.5267}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2315101
    {Coordinate{2.15208, 44.0487}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carmaux
    {Coordinate{5.45639, 50.5947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flémalle-Haute railway station
    {Coordinate{6.3534, 46.9008}, Tz::Europe_Paris, CountryId{"FR"}}, // Pontarlier
    {Coordinate{1.47623, 46.0469}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sulpice-Laurière
    {Coordinate{-0.201145, 46.4064}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Maixent (Deux-Sèvres)
    {Coordinate{21.0078, 52.2294}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Śródmieście PKP railway station
    {Coordinate{5.46694, 50.5997}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leman railway station
    {Coordinate{7.04694, 51.4936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Zollverein Nord station
    {Coordinate{7.35694, 49.2469}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zweibrücken Central Station
    {Coordinate{7.36376, 51.4981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Germania station
    {Coordinate{4.11238, 50.3037}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erquelinnes railway station
    {Coordinate{6.93742, 51.1635}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hilden Süd station
    {Coordinate{3.66661, 50.5053}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blaton railway station
    {Coordinate{4.35083, 50.3775}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landelies railway station
    {Coordinate{2.16778, 41.39}, Tz::Europe_Madrid, CountryId{"ES"}}, // Passeig de Gràcia
    {Coordinate{20.9656, 52.2194}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2328552
    {Coordinate{4.67557, 50.513}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mazy railway station
    {Coordinate{5.30306, 52.1653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Soest Zuid railway station
    {Coordinate{5.89038, 50.8665}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Klimmen-Ransdaal railway station
    {Coordinate{-1.21165, 48.1225}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitré
    {Coordinate{6.01472, 51.9431}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Duiven railway station
    {Coordinate{6.30944, 53.2558}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Grijpskerk railway station
    {Coordinate{3.77778, 50.6272}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ath railway station
    {Coordinate{4.33167, 50.7786}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moensberg railway station
    {Coordinate{3.7975, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melle railway station
    {Coordinate{6.295, 51.9583}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Doetinchem railway station
    {Coordinate{5.36972, 52.0642}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarn railway station
    {Coordinate{4.23611, 51.9256}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maassluis West railway station
    {Coordinate{7.5332, 48.5428}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dachstein
    {Coordinate{5.85556, 50.4903}, Tz::Europe_Brussels, CountryId{"BE"}}, // Spa railway station
    {Coordinate{4.16592, 50.8746}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ternat railway station
    {Coordinate{13.2496, 52.7536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oranienburg station
    {Coordinate{5.16509, 51.1693}, Tz::Europe_Brussels, CountryId{"BE"}}, // Balen railway station
    {Coordinate{0.595833, 49.0872}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bernay
    {Coordinate{4.15387, 51.0194}, Tz::Europe_Brussels, CountryId{"BE"}}, // Baasrode-South railway station
    {Coordinate{-1.11572, 43.5468}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Peyrehorade
    {Coordinate{5.40852, 50.9557}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bokrijk railway station
    {Coordinate{-0.131376, 45.0367}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coutras
    {Coordinate{13.2888, 52.6885}, Tz::Europe_Berlin, CountryId{"DE"}}, // Birkenwerder station
    {Coordinate{3.6399, 50.9294}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gavere-Asper railway station
    {Coordinate{3.91722, 50.7517}, Tz::Europe_Brussels, CountryId{"BE"}}, // Viane-Moerbeke railway station
    {Coordinate{2.12328, 50.9787}, Tz::Europe_Paris, CountryId{"FR"}}, // Gravelines
    {Coordinate{3.26362, 51.3383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Duinbergen railway station
    {Coordinate{6.67611, 52.61}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gramsbergen railway station
    {Coordinate{4.20583, 50.8669}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Martens-Bodegem railway station
    {Coordinate{5.85944, 51.8644}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Lent railway station
    {Coordinate{6.57806, 51.9211}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Aalten railway station
    {Coordinate{5.42804, 45.4384}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2351956
    {Coordinate{-2.51139, 48.4658}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamballe
    {Coordinate{-1.75013, 48.5441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dol-de-Bretagne
    {Coordinate{6.8712, 51.4396}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mülheim West station
    {Coordinate{7.14583, 46.0769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sembrancher train station
    {Coordinate{5.69417, 50.7442}, Tz::Europe_Brussels, CountryId{"BE"}}, // Visé railway station
    {Coordinate{3.80566, 50.9007}, Tz::Europe_Brussels, CountryId{"BE"}}, // Balegem-Zuid railway station
    {Coordinate{2.42056, 49.1172}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luzarches
    {Coordinate{5.94361, 51.9881}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem Presikhaaf railway station
    {Coordinate{6.03415, 47.2404}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2356506
    {Coordinate{4.13417, 51.005}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lebbeke railway station
    {Coordinate{4.36639, 43.8325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nîmes
    {Coordinate{4.88564, 50.4282}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dave-Saint-Martin railway station
    {Coordinate{1.43306, 44.4492}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cahors
    {Coordinate{-1.42882, 43.5871}, Tz::Europe_Paris, CountryId{"FR"}}, // Labenne
    {Coordinate{5.47203, 45.4918}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Virieu-sur-Bourbre
    {Coordinate{5.4634, 43.4559}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gardanne
    {Coordinate{4.26356, 50.4479}, Tz::Europe_Brussels, CountryId{"BE"}}, // Carnières railway station
    {Coordinate{-1.49076, 43.5235}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boucau
    {Coordinate{7.14861, 46.0525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2365843
    {Coordinate{4.21622, 45.5222}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bonson
    {Coordinate{-1.60989, 43.4254}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guéthary
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Neumarkt-Kallham
    {Coordinate{21.0178, 52.2636}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Zoo railway station
    {Coordinate{6.9418, 50.9588}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Nippes station
    {Coordinate{5.8185, 49.5927}, Tz::Europe_Brussels, CountryId{"BE"}}, // Messancy railway station
    {Coordinate{3.87486, 50.587}, Tz::Europe_Brussels, CountryId{"BE"}}, // Cambron-Casteau railway station
    {Coordinate{1.34083, 44.0139}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montauban-Ville-Bourbon
    {Coordinate{5.085, 52.6533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoorn Kersenboogerd railway station
    {Coordinate{6.146, 51.7896}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kleve
    {Coordinate{3.10583, 51.0648}, Tz::Europe_Brussels, CountryId{"BE"}}, // Torhout railway station
    {Coordinate{7.46285, 48.5336}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2377439
    {Coordinate{6.08562, 46.142}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Julien-en-Genevois
    {Coordinate{}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q23784034
    {Coordinate{6.66388, 51.373}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Hohenbudberg Chempark station
    {Coordinate{7.17335, 51.6676}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl-Sinsen station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q23787924
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q23787942
    {Coordinate{1.98578, 46.9488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2379431
    {Coordinate{7.60346, 47.4534}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2381221
    {Coordinate{5.81312, 45.5363}, Tz::Europe_Paris, CountryId{"FR"}}, // Aiguebelette-le-Lac
    {Coordinate{4.81803, 45.6272}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2382041
    {Coordinate{6.16738, 50.8675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Kellersberg station
    {Coordinate{1.09824, 49.7155}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2383414
    {Coordinate{3.16155, 45.7921}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aulnat-Aéroport
    {Coordinate{6.49402, 46.5111}, Tz::Europe_Zurich, CountryId{"CH"}}, // Morges railway station
    {Coordinate{3.62421, 49.5706}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2385461
    {Coordinate{5.54444, 51.2461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hamont railway station
    {Coordinate{4.74936, 46.907}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2386091
    {Coordinate{1.97292, 48.2566}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boisseaux
    {Coordinate{6.84861, 52.7183}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuw Amsterdam railway station
    {Coordinate{4.99278, 51.8719}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arkel railway station
    {Coordinate{5.83162, 45.963}, Tz::Europe_Paris, CountryId{"FR"}}, // Seyssel - Corbonod
    {Coordinate{5.69048, 48.3582}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2389073
    {Coordinate{5.0875, 49.9072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Carlsbourg railway station
    {Coordinate{4.69434, 50.4529}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moustier railway station
    {Coordinate{4.50944, 51.9053}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Zuid railway station
    {Coordinate{6.66042, 50.224}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gerolstein station
    {Coordinate{3.96283, 50.9295}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erpe-Mere railway station
    {Coordinate{9.6907, 52.4084}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Ledeburg station
    {Coordinate{0.098889, 48.4342}, Tz::Europe_Paris, CountryId{"FR"}}, // Alençon railway station
    {Coordinate{9.70765, 52.4241}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Vinnhorst station
    {Coordinate{6.57093, 49.9987}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bitburg-Erdorf station
    {Coordinate{9.72587, 52.4407}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen Mitte station
    {Coordinate{9.73636, 52.48}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen-Kaltenweide station
    {Coordinate{9.74813, 52.5225}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bissendorf station
    {Coordinate{9.7443, 52.5486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mellendorf station
    {Coordinate{9.72673, 52.5811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bennemühlen station
    {Coordinate{6.28133, 51.1451}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wegberg
    {Coordinate{6.58096, 50.3448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jünkerath station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q23933722
    {Coordinate{5.24857, 50.6945}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waremme railway station
    {Coordinate{3.92127, 50.8016}, Tz::Europe_Brussels, CountryId{"BE"}}, // Idegem railway station
    {Coordinate{4.99581, 50.3875}, Tz::Europe_Brussels, CountryId{"BE"}}, // Courrière railway station
    {Coordinate{0.522922, 45.1389}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Astier
    {Coordinate{6.15667, 51.3725}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Blerick railway station
    {Coordinate{4.725, 49.7678}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Charleville-Mézières
    {Coordinate{6.08389, 52.1781}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Klarenbeek railway station
    {Coordinate{3.82944, 50.9914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kwatrecht railway station
    {Coordinate{5.87583, 50.9386}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schinnen railway station
    {Coordinate{4.82339, 50.984}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aarschot railway station
    {Coordinate{5.19417, 52.0631}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bunnik railway station
    {Coordinate{4.49491, 50.2369}, Tz::Europe_Brussels, CountryId{"BE"}}, // Yves-Gomezée railway station
    {Coordinate{6.52832, 48.1199}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2401925
    {Coordinate{5.01611, 44.7301}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2404429
    {Coordinate{6.792, 51.21}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Volksgarten station
    {Coordinate{2.58128, 44.3619}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rodez
    {Coordinate{7.6933, 48.5631}, Tz::Europe_Paris, CountryId{"FR"}}, // Strasbourg-Roethig
    {Coordinate{-0.631747, 44.8044}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pessac
    {Coordinate{11.0312, 51.7459}, Tz::Europe_Berlin, CountryId{"DE"}}, // Thale Central Station
    {Coordinate{6.145, 53.2564}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Buitenpost railway station
    {Coordinate{6.54, 53.2911}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sauwerd railway station
    {Coordinate{5.4306, 50.6608}, Tz::Europe_Brussels, CountryId{"BE"}}, // Voroux railway station
    {Coordinate{3.19615, 44.4475}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2410794
    {Coordinate{2.60279, 49.31}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-Sainte-Maxence
    {Coordinate{3.8853, 50.4526}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemappes railway station
    {Coordinate{0.750208, 49.6222}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2411757
    {Coordinate{6.13072, 48.773}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2412350
    {Coordinate{6.73794, 47.0556}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2412486
    {Coordinate{4.63917, 52.4428}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Driehuis railway station
    {Coordinate{4.65724, 43.8011}, Tz::Europe_Paris, CountryId{"FR"}}, // Tarascon
    {Coordinate{4.63278, 50.9003}, Tz::Europe_Brussels, CountryId{"BE"}}, // Veltem railway station
    {Coordinate{3.48828, 51.0835}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bellem railway station
    {Coordinate{3.38682, 51.1075}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maria-Aalter railway station
    {Coordinate{2.60254, 51.0773}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Panne railway station
    {Coordinate{12.4878, 54.2511}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ribnitz-Damgarten Ost railway station
    {Coordinate{0.610432, 43.0211}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Loures-Barbazan
    {Coordinate{2.13611, 48.7958}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Versailles-Chantiers
    {Coordinate{3.49382, 48.498}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2424780
    {Coordinate{4.09972, 51.0228}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dendermonde railway station
    {Coordinate{2.37509, 51.0175}, Tz::Europe_Paris, CountryId{"FR"}}, // Coudekerque-Branche
    {Coordinate{7.68499, 48.521}, Tz::Europe_Paris, CountryId{"FR"}}, // Geispolsheim
    {Coordinate{5.61639, 53.0147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // IJlst railway station
    {Coordinate{-0.0749, 49.0708}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mézidon
    {Coordinate{2.86901, 51.0327}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diksmuide railway station
    {Coordinate{-3.46686, 48.6062}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Plouaret-Trégor
    {Coordinate{4.29314, 45.5659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2437593
    {Coordinate{4.74883, 50.5338}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beuzet railway station
    {Coordinate{4.36976, 49.5043}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2438613
    {Coordinate{4.82583, 50.4542}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ronet railway station
    {Coordinate{6.33696, 47.914}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2441064
    {Coordinate{4.55361, 51.8544}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barendrecht railway station
    {Coordinate{3.90944, 50.3414}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quévy railway station
    {Coordinate{5.58356, 50.5705}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tilff railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24420931
    {Coordinate{6.00333, 52.2147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Apeldoorn Osseveld railway station
    {Coordinate{4.35583, 51.0664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Willebroek railway station
    {Coordinate{2.4611, 45.6452}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2442991
    {Coordinate{5.77869, 45.8432}, Tz::Europe_Paris, CountryId{"FR"}}, // Culoz
    {Coordinate{7.42451, 51.3523}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen-Heubing station
    {Coordinate{0.069498, 43.2402}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tarbes
    {Coordinate{4.55917, 51.1361}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lier railway station
    {Coordinate{-0.325965, 45.6844}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2448097
    {Coordinate{6.17594, 46.0109}, Tz::Europe_Paris, CountryId{"FR"}}, // Pringy
    {Coordinate{5.98, 51.9947}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Velp railway station
    {Coordinate{7.47699, 48.8727}, Tz::Europe_Paris, CountryId{"FR"}}, // Ingwiller
    {Coordinate{5.93806, 50.625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dolhain-Gileppe railway station
    {Coordinate{5.61444, 52.3011}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ermelo railway station
    {Coordinate{4.99, 51.1689}, Tz::Europe_Brussels, CountryId{"BE"}}, // Geel railway station
    {Coordinate{4.46111, 51.3981}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heide railway station
    {Coordinate{8.585, 48.0878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trossingen station
    {Coordinate{5.31333, 50.2025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marloie railway station
    {Coordinate{2.63667, 47.6989}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gien
    {Coordinate{1.46889, 43.3486}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Auterive
    {Coordinate{4.64806, 52.0556}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Waddinxveen Noord railway station
    {Coordinate{5.25778, 51.1175}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leopoldsburg railway station
    {Coordinate{5.28604, 50.6852}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bleret railway station
    {Coordinate{4.93384, 45.6866}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Priest
    {Coordinate{8.73407, 44.4725}, Tz::Europe_Rome, CountryId{"IT"}}, // Q2460876
    {Coordinate{3.03919, 43.02}, Tz::Europe_Paris, CountryId{"FR"}}, // Port-la-Nouvelle
    {Coordinate{-3.55306, 47.8694}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quimperlé
    {Coordinate{9.98111, 53.4606}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Harburg Rathaus
    {Coordinate{6.42528, 52.1667}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lochem railway station
    {Coordinate{6.05694, 50.8614}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kerkrade Centrum railway station
    {Coordinate{4.66556, 51.1594}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nijlen railway station
    {Coordinate{5.68063, 45.5245}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-de-Beauvoisin
    {Coordinate{4.30208, 50.7664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beersel railway station
    {Coordinate{4.81722, 44.7544}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2462836
    {Coordinate{5.23722, 43.4425}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2462992
    {Coordinate{7.08997, 51.3135}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Neviges station
    {Coordinate{5.61673, 50.6077}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chênée railway station
    {Coordinate{5.23411, 51.0871}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beverlo railway station
    {Coordinate{10.6174, 48.0456}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2464536
    {Coordinate{7.02314, 51.4399}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Süd station
    {Coordinate{6.6326, 44.89}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Briançon
    {Coordinate{8.72967, 47.9362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Immendingen station
    {Coordinate{11.3133, 50.9717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24652564
    {Coordinate{4.80022, 51.0225}, Tz::Europe_Brussels, CountryId{"BE"}}, // Begijnendijk railway station
    {Coordinate{6.90296, 51.2204}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkrath station
    {Coordinate{7.18293, 50.9015}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24706440
    {Coordinate{5.53139, 52.0281}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal West railway station
    {Coordinate{4.64556, 52.2597}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuw Vennep railway station
    {Coordinate{4.64944, 52.0447}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Waddinxveen railway station
    {Coordinate{7.08083, 51.4692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Kray Nord station
    {Coordinate{2.36876, 51.0304}, Tz::Europe_Paris, CountryId{"FR"}}, // Dunkirk railway station
    {Coordinate{14.5497, 53.4186}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Szczecin Główny
    {Coordinate{4.96667, 52.5114}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend Overwhere railway station
    {Coordinate{4.32361, 50.8025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Uccle-Stalle railway station
    {Coordinate{5.87417, 51.7267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Cuijk railway station
    {Coordinate{5.33176, 49.7071}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florenville railway station
    {Coordinate{4.32056, 50.8092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forest-East railway station
    {Coordinate{5.2243, 47.2443}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Genlis
    {Coordinate{5.36236, 44.7587}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Die
    {Coordinate{5.02619, 50.4921}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sclaigneaux railway station
    {Coordinate{5.50944, 50.6611}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ans railway station
    {Coordinate{5.31889, 51.5847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boxtel railway station
    {Coordinate{-1.4356, 46.6726}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Roche-sur-Yon
    {Coordinate{9.7389, 47.4174}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q24817320
    {Coordinate{6.11119, 46.4545}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Givrine station
    {Coordinate{3.7238, 50.4648}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ville-Pommerœul railway station
    {Coordinate{6.33562, 48.3435}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2482640
    {Coordinate{-0.550776, 48.1413}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2483118
    {Coordinate{-1.58748, 48.8384}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Granville
    {Coordinate{4.39944, 45.4433}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Étienne-Châteaucreux
    {Coordinate{4.70083, 52.6}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heiloo railway station
    {Coordinate{4.70972, 51.0733}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heist-op-den-Berg railway station
    {Coordinate{6.56667, 52.4761}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geerdijk railway station
    {Coordinate{5.97407, 45.3419}, Tz::Europe_Paris, CountryId{"FR"}}, // Goncelin
    {Coordinate{7.33385, 48.0859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2489577
    {Coordinate{4.95639, 50.1153}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beauraing railway station
    {Coordinate{5.82222, 53.0894}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Grou-Jirnsum railway station
    {Coordinate{5.58731, 50.5475}, Tz::Europe_Brussels, CountryId{"BE"}}, // Méry railway station
    {Coordinate{5.19361, 51.5819}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oisterwijk railway station
    {Coordinate{4.60917, 50.4322}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tamines railway station
    {Coordinate{4.60514, 50.7162}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wavre railway station
    {Coordinate{5.24404, 47.0998}, Tz::Europe_Paris, CountryId{"FR"}}, // Q24937300
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hofstade railway station
    {Coordinate{7.32118, 48.0873}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2497752
    {Coordinate{6.80166, 47.5105}, Tz::Europe_Paris, CountryId{"FR"}}, // Montbéliard railway station
    {Coordinate{2.65444, 48.5272}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Melun
    {Coordinate{21.1347, 55.7208}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Klaipėda railway station
    {Coordinate{5.76494, 45.5416}, Tz::Europe_Paris, CountryId{"FR"}}, // Lépin-le-Lac - La Bauche
    {Coordinate{1.70333, 48.9898}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mantes-la-Jolie
    {Coordinate{8.544, 47.4186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Seebach railway station
    {Coordinate{0.941325, 44.4865}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monsempron-Libos
    {Coordinate{4.63604, 50.6205}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blanmont railway station
    {Coordinate{6.18844, 50.862}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Mariadorf station
    {Coordinate{3.83518, 50.7028}, Tz::Europe_Brussels, CountryId{"BE"}}, // Houraing railway station
    {Coordinate{3.60028, 50.8497}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oudenaarde railway station
    {Coordinate{5.71004, 50.772}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eijsden railway station
    {Coordinate{8.56603, 49.6589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25088577
    {Coordinate{8.64559, 49.9137}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089096
    {Coordinate{11.0736, 51.8994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Halberstadt station
    {Coordinate{11.77, 51.2063}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089303
    {Coordinate{8.60565, 52.3063}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089354
    {Coordinate{9.44056, 48.6447}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Kirchheim unter Teck
    {Coordinate{11.2756, 50.6825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089975
    {Coordinate{8.82812, 48.5228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25090000
    {Coordinate{4.29417, 50.7906}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ruisbroek railway station
    {Coordinate{4.46528, 51.1539}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hove railway station
    {Coordinate{2.80481, 45.5795}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Mont-Dore
    {Coordinate{4.82833, 51.1806}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herentals railway station
    {Coordinate{-0.391464, 45.1391}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Mariens - Saint-Yzan
    {Coordinate{3.87222, 50.7703}, Tz::Europe_Brussels, CountryId{"BE"}}, // Geraardsbergen railway station
    {Coordinate{6.01417, 51.5264}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Venray railway station
    {Coordinate{16.358, 48.2356}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Spittelau railway station
    {Coordinate{16.42, 48.1703}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Simmering railway station
    {Coordinate{3.54, 50.0914}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Cateau
    {Coordinate{4.77806, 51.8294}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sliedrecht railway station
    {Coordinate{3.22516, 50.8262}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bissegem railway station
    {Coordinate{6.14, 52.3897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wijhe railway station
    {Coordinate{2.31028, 46.8567}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2521024
    {Coordinate{4.56936, 50.6737}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ottignies railway station
    {Coordinate{17.646, 59.8587}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Uppsala Central Station
    {Coordinate{5.05751, 45.8478}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2522225
    {Coordinate{6.01972, 50.8964}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Landgraaf railway station
    {Coordinate{3.69833, 50.8742}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Denijs-Boekel railway station
    {Coordinate{7.08893, 51.4441}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Steele Ost station
    {Coordinate{4.02361, 50.9067}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haaltert railway station
    {Coordinate{5.85167, 51.9547}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem Zuid railway station
    {Coordinate{1.98833, 49.5036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Milly-sur-Thérain
    {Coordinate{-0.454722, 46.3194}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Niort
    {Coordinate{3.24593, 50.7137}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herseaux railway station
    {Coordinate{5.195, 51.8992}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beesd railway station
    {Coordinate{4.36056, 51.0908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boom railway station
    {Coordinate{6.0505, 48.9003}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2532824
    {Coordinate{6.63634, 45.9357}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2533028
    {Coordinate{6.04611, 50.8897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eygelshoven railway station
    {Coordinate{-9.10304, 38.7467}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Braço de Prata
    {Coordinate{1.82472, 42.5386}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Porté-Puymorens
    {Coordinate{6.2125, 51.9567}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wehl railway station
    {Coordinate{4.84852, 47.023}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2535260
    {Coordinate{5.28071, 50.0907}, Tz::Europe_Brussels, CountryId{"BE"}}, // Grupont railway station
    {Coordinate{5.3904, 43.3391}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2538961
    {Coordinate{9.43056, 46.8286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ems Werk
    {Coordinate{2.16416, 45.5305}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meymac
    {Coordinate{15.0784, 50.6293}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q25412023
    {Coordinate{7.12213, 51.3548}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Langenberg station
    {Coordinate{5.12528, 52.11}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Overvecht railway station
    {Coordinate{6.12413, 43.1088}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hyères
    {Coordinate{1.90667, 47.9267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Aubrais-Orléans
    {Coordinate{3.26762, 48.1978}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545246
    {Coordinate{5.7147, 45.1908}, Tz::Europe_Paris, CountryId{"FR"}}, // Grenoble railway station
    {Coordinate{4.61833, 45.8332}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de l'Arbresle
    {Coordinate{4.39254, 45.4172}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545435
    {Coordinate{11.555, 48.1408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Central Station
    {Coordinate{7.65678, 50.7733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Au station
    {Coordinate{4.23996, 50.7334}, Tz::Europe_Brussels, CountryId{"BE"}}, // Halle railway station
    {Coordinate{4.86906, 50.3488}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lustin railway station
    {Coordinate{4.805, 43.9417}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avignon-Centre
    {Coordinate{5.24139, 52.14}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Dolder railway station
    {Coordinate{6.68639, 53.3258}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Stedum railway station
    {Coordinate{-1.45706, 43.5687}, Tz::Europe_Paris, CountryId{"FR"}}, // Ondres
    {Coordinate{5.57834, 50.509}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poulseur railway station
    {Coordinate{5.50372, 43.6848}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2557517
    {Coordinate{2.33932, 50.3789}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2557790
    {Coordinate{6.79278, 51.2203}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Central Station
    {Coordinate{3.96654, 50.2726}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Maubeuge
    {Coordinate{5.86722, 50.4892}, Tz::Europe_Brussels, CountryId{"BE"}}, // Spa-Géronstère railway station
    {Coordinate{2.3141, 45.557}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ussel
    {Coordinate{4.83056, 44.7797}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2563655
    {Coordinate{4.8134, 45.6456}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2563981
    {Coordinate{-1.17786, 47.3695}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2564893
    {Coordinate{7.82341, 48.7819}, Tz::Europe_Paris, CountryId{"FR"}}, // Marienthal
    {Coordinate{4.95417, 52.5033}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Godarville railway station
    {Coordinate{5.18389, 52.6906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoogkarspel railway station
    {Coordinate{5.67284, 50.4727}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aywaille railway station
    {Coordinate{7.21472, 46.0792}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2569112
    {Coordinate{5.93444, 53.2189}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hurdegaryp railway station
    {Coordinate{5.63111, 51.4681}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond 't Hout railway station
    {Coordinate{3.33922, 46.5613}, Tz::Europe_Paris, CountryId{"FR"}}, // Moulins-sur-Allier railway station
    {Coordinate{1.47566, 45.258}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Allassac
    {Coordinate{-0.612264, 43.1948}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oloron-Sainte-Marie
    {Coordinate{6.15172, 47.6175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vesoul
    {Coordinate{4.72107, 45.9846}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranche-sur-Saône
    {Coordinate{-0.963719, 45.9474}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rochefort
    {Coordinate{3.51304, 47.9611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2577756
    {Coordinate{4.36167, 51.91}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlaardingen Oost railway station
    {Coordinate{3.06139, 45.7675}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2578159
    {Coordinate{3.43064, 46.1264}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2578951
    {Coordinate{6.71, 45.0767}, Tz::Europe_Rome, CountryId{"IT"}}, // Bardonecchia railway station
    {Coordinate{4.18528, 51.1853}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nieuwkerken-Waas railway station
    {Coordinate{5.66222, 51.4758}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond railway station
    {Coordinate{4.1875, 45.8179}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2583133
    {Coordinate{6.59881, 48.0164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2586908
    {Coordinate{4.0875, 50.2961}, Tz::Europe_Paris, CountryId{"FR"}}, // Jeumont railway station
    {Coordinate{3.2574, 51.1543}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oostkamp railway station
    {Coordinate{6.58306, 52.2303}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Goor railway station
    {Coordinate{3.00566, 43.1906}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Narbonne
    {Coordinate{7.4182, 47.7378}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2592955
    {Coordinate{5.54861, 52.0197}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal Centrum railway station
    {Coordinate{21.1578, 52.2569}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Rembertów railway station
    {Coordinate{4.64667, 52.0769}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boskoop railway station
    {Coordinate{5.51948, 50.3769}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bomal railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hemiksem railway station
    {Coordinate{6.25833, 51.9592}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Doetinchem De Huet railway station
    {Coordinate{3.16811, 50.7166}, Tz::Europe_Paris, CountryId{"FR"}}, // Tourcoing
    {Coordinate{4.28818, 50.3425}, Tz::Europe_Brussels, CountryId{"BE"}}, // Thuin railway station
    {Coordinate{3.19652, 45.2537}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2599851
    {Coordinate{5.63028, 51.3039}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarheeze railway station
    {Coordinate{4.675, 50.9036}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herent railway station
    {Coordinate{-3.46033, 48.7273}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lannion
    {Coordinate{2.5825, 48.8742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chelles-Gournay
    {Coordinate{4.68639, 50.9311}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hambos railway station
    {Coordinate{5.57276, 50.5305}, Tz::Europe_Brussels, CountryId{"BE"}}, // Esneux railway station
    {Coordinate{4.40666, 50.3338}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beignée railway station
    {Coordinate{12.1265, 42.7239}, Tz::Europe_Rome, CountryId{"IT"}}, // Q2608652
    {Coordinate{9.07278, 45.8092}, Tz::Europe_Rome, CountryId{"IT"}}, // Como San Giovanni railway station
    {Coordinate{7.29433, 47.6944}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Zillisheim
    {Coordinate{0.596512, 42.7973}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luchon
    {Coordinate{1.14972, 49.0186}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Évreux-Normandie
    {Coordinate{1.83361, 42.7244}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ax-les-Thermes
    {Coordinate{1.32389, 43.4647}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Muret
    {Coordinate{2.38308, 48.839}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bercy
    {Coordinate{1.21167, 43.2978}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carbonne
    {Coordinate{3.98639, 51.1075}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lokeren railway station
    {Coordinate{5.975, 50.6592}, Tz::Europe_Brussels, CountryId{"BE"}}, // Welkenraedt railway station
    {Coordinate{5.0512, 50.9931}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diest railway station
    {Coordinate{4.37948, 45.4648}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Étienne-La Terrasse
    {Coordinate{6.39954, 48.2709}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2616463
    {Coordinate{4.58488, 50.4295}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aiseau railway station
    {Coordinate{6.05806, 50.8961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eygelshoven Markt railway station
    {Coordinate{3.71959, 51.089}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wondelgem railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tollembeek railway station
    {Coordinate{5.09528, 50.4967}, Tz::Europe_Brussels, CountryId{"BE"}}, // Andenne railway station
    {Coordinate{4.41722, 50.9078}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buda railway station
    {Coordinate{5.80639, 50.5681}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pepinster railway station
    {Coordinate{5.80444, 50.5636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pepinster-Cité railway station
    {Coordinate{-2.00399, 48.6466}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Malo
    {Coordinate{0.93793, 48.9622}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2623394
    {Coordinate{4.62133, 50.7243}, Tz::Europe_Brussels, CountryId{"BE"}}, // Basse-Wavre railway station
    {Coordinate{15.7452, 48.6855}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q26254154
    {Coordinate{5.37683, 47.1928}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2625770
    {Coordinate{2.12917, 48.8}, Tz::Europe_Paris, CountryId{"FR"}}, // Versailles-Château
    {Coordinate{5.34972, 50.9544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kiewit railway station
    {Coordinate{4.6987, 50.5581}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chapelle-Dieu railway station
    {Coordinate{4.34853, 50.8412}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-Chapel railway station
    {Coordinate{1.23694, 43.6147}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2628524
    {Coordinate{4.64868, 50.6088}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chastre railway station
    {Coordinate{3.89611, 50.9014}, Tz::Europe_Brussels, CountryId{"BE"}}, // Terhagen railway station
    {Coordinate{3.96936, 50.8118}, Tz::Europe_Brussels, CountryId{"BE"}}, // Appelterre railway station
    {Coordinate{7.88249, 48.9346}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2630630
    {Coordinate{13.3069, 52.6178}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Hermsdorf station
    {Coordinate{5.13139, 52.0872}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Station Utrecht Maliebaan
    {Coordinate{4.20111, 51.0164}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buggenhout railway station
    {Coordinate{4.09528, 50.8825}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liedekerke railway station
    {Coordinate{7.86944, 50.7894}, Tz::Europe_Berlin, CountryId{"DE"}}, // Betzdorf (Sieg) station
    {Coordinate{6.59306, 53.3069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bedum railway station
    {Coordinate{13.4085, 52.3602}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mahlow station
    {Coordinate{8.63251, 44.6305}, Tz::Europe_Rome, CountryId{"IT"}}, // Ovada railway station
    {Coordinate{11.5803, 49.95}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bayreuth Central Station
    {Coordinate{4.99056, 52.17}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Breukelen railway station
    {Coordinate{4.63167, 52.4194}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Santpoort Zuid
    {Coordinate{6.85256, 51.4491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mülheim-Styrum station
    {Coordinate{4.11666, 50.8825}, Tz::Europe_Brussels, CountryId{"BE"}}, // Essene-Lombeek railway station
    {Coordinate{3.72873, 48.5142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Romilly-sur-Seine
    {Coordinate{4.58417, 51.9533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Capelle Schollevaar railway station
    {Coordinate{2.13761, 43.9226}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albi-Ville
    {Coordinate{3.82327, 50.6864}, Tz::Europe_Brussels, CountryId{"BE"}}, // Papignies railway station
    {Coordinate{3.64611, 50.9078}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zingem railway station
    {Coordinate{6.03583, 53.2483}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zwaagwesteinde railway station
    {Coordinate{6.64861, 45.5544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aime-La Plagne
    {Coordinate{2.7375, 47.8528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nogent-sur-Vernisson
    {Coordinate{4.79278, 52.4891}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wormerveer railway station
    {Coordinate{5.48795, 47.0961}, Tz::Europe_Paris, CountryId{"FR"}}, // Dole-Ville railway station
    {Coordinate{7.4624, 49.5474}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenglan station
    {Coordinate{13.5797, 51.1231}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coswig (b Dresden) station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhöfe in Feucht
    {Coordinate{7.96444, 51.1728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Finnentrop station
    {Coordinate{9.82771, 47.6463}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hergatz station
    {Coordinate{12.2356, 50.5712}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herlasgrün station
    {Coordinate{7.72949, 49.4838}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2657925
    {Coordinate{7.59071, 49.6537}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauterecken-Grumbach station
    {Coordinate{12.7989, 52.9302}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2657942
    {Coordinate{7.60389, 50.2998}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberlahnstein station
    {Coordinate{10.277, 47.4104}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberstdorf station
    {Coordinate{11.427, 47.9142}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolfratshausen station
    {Coordinate{2.418, 49.2142}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2659445
    {Coordinate{6.03889, 50.635}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eupen railway station
    {Coordinate{5.93952, 51.6445}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boxmeer railway station
    {Coordinate{6.60842, 48.5312}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2661330
    {Coordinate{3.70194, 51.1072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Evergem railway station
    {Coordinate{4.51333, 51.0086}, Tz::Europe_Brussels, CountryId{"BE"}}, // Muizen railway station
    {Coordinate{6.03083, 52.01}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rheden railway station
    {Coordinate{12.235, 51.84}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dessau Central Station
    {Coordinate{5.19056, 50.5219}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bas-Oha railway station
    {Coordinate{1.49223, 46.2398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2666389
    {Coordinate{3.78111, 50.9533}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moortsele railway station
    {Coordinate{2.70475, 45.6469}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2669277
    {Coordinate{5.8148, 44.5315}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2669992
    {Coordinate{4.67188, 50.4529}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ham-sur-Sambre railway station
    {Coordinate{1.08333, 43.2128}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cazères-sur-Garonne
    {Coordinate{6.90968, 51.2294}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkrath Nord station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26714912
    {Coordinate{4.74689, 45.7728}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2672930
    {Coordinate{5.4225, 51.2156}, Tz::Europe_Brussels, CountryId{"BE"}}, // Overpelt railway station
    {Coordinate{3.32958, 50.9904}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tielt railway station
    {Coordinate{-1.49611, 47.1903}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sébastien-Frêne-Rond
    {Coordinate{4.84108, 43.9345}, Tz::Europe_Paris, CountryId{"FR"}}, // Q26772027
    {Coordinate{-1.62139, 49.6333}, Tz::Europe_Paris, CountryId{"FR"}}, // Cherbourg railway station
    {Coordinate{5.84278, 50.9672}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geleen Oost railway station
    {Coordinate{4.79549, 45.3717}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2678036
    {Coordinate{1.87917, 46.1742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guéret
    {Coordinate{6.83861, 52.2372}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enschede Drienerlo railway station
    {Coordinate{2.35028, 48.9175}, Tz::Europe_Paris, CountryId{"FR"}}, // Stade de France – Saint-Denis
    {Coordinate{5.37028, 43.4031}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2678689
    {Coordinate{8.51606, 49.4599}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26791758
    {Coordinate{5.81779, 50.5299}, Tz::Europe_Brussels, CountryId{"BE"}}, // Franchimont railway station
    {Coordinate{3.76454, 51.0201}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merelbeke railway station
    {Coordinate{5.12466, 50.2619}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chapois railway station
    {Coordinate{6.15642, 50.8706}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Annapark station
    {Coordinate{4.61575, 50.6698}, Tz::Europe_Brussels, CountryId{"BE"}}, // Louvain-la-Neuve railway station
    {Coordinate{3.41861, 50.9844}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aarsele railway station
    {Coordinate{-3.41507, 50.6218}, Tz::Europe_London, CountryId{"GB"}}, // Exmouth railway station
    {Coordinate{20.9408, 52.2061}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Aleje Jerozolimskie railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kreiensen station
    {Coordinate{12.2472, 54.1767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rövershagen railway station
    {Coordinate{11.705, 50.1544}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26821640
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26821689
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burg (bei Magdeburg) station
    {Coordinate{2.27167, 48.9806}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ermont - Eaubonne
    {Coordinate{5.92972, 43.1286}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulon
    {Coordinate{8.56889, 50.1436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26836599
    {Coordinate{13.0227, 48.2631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26836635
    {Coordinate{5.87167, 50.8561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schin op Geul railway station
    {Coordinate{0.89, 44.1117}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valence-d'Agen
    {Coordinate{5.5021, 50.3496}, Tz::Europe_Brussels, CountryId{"BE"}}, // Barvaux railway station
    {Coordinate{5.55028, 51.42}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geldrop railway station
    {Coordinate{20.9719, 52.1722}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warsaw Chopin Airport railway station
    {Coordinate{4.13166, 50.3102}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erquelinnes-Village railway station
    {Coordinate{4.74278, 49.8119}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2687707
    {Coordinate{1.84814, 48.9721}, Tz::Europe_Paris, CountryId{"FR"}}, // Aubergenville-Élisabethville
    {Coordinate{7.70032, 48.7328}, Tz::Europe_Paris, CountryId{"FR"}}, // Brumath
    {Coordinate{3.53622, 51.0731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hansbeke railway station
    {Coordinate{4.56571, 50.6466}, Tz::Europe_Brussels, CountryId{"BE"}}, // Court-Saint-Étienne railway station
    {Coordinate{5.35791, 43.3696}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2689067
    {Coordinate{-3.28576, 47.7991}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hennebont
    {Coordinate{4.66306, 51.6908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lage Zwaluwe railway station
    {Coordinate{5.88098, 50.3912}, Tz::Europe_Brussels, CountryId{"BE"}}, // Coo railway station
    {Coordinate{3.54326, 45.8612}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2691990
    {Coordinate{5.58361, 51.9314}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kesteren railway station
    {Coordinate{4.96694, 52.3453}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Diemen railway station
    {Coordinate{4.99278, 51.5739}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tilburg Reeshof railway station
    {Coordinate{7.53117, 47.6095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Louis-la-Chaussée
    {Coordinate{20.9653, 52.2203}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Zachodnia station
    {Coordinate{5.60861, 51.4622}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond Brandevoort railway station
    {Coordinate{4.38338, 50.715}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waterloo railway station
    {Coordinate{4.29778, 51.0092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Londerzeel railway station
    {Coordinate{4.41444, 50.8892}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haren-South railway station
    {Coordinate{1.68611, 42.7864}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Cabannes
    {Coordinate{6.97417, 52.2186}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Glanerbrug railway station
    {Coordinate{7.93344, 48.9313}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2700531
    {Coordinate{5.8775, 51.7647}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Mook-Molenhoek railway station
    {Coordinate{16.78, 48.0189}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q27031506
    {Coordinate{7.95402, 48.9614}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2707075
    {Coordinate{7.44306, 48.26}, Tz::Europe_Paris, CountryId{"FR"}}, // Sélestat
    {Coordinate{-1.37013, 48.6902}, Tz::Europe_Paris, CountryId{"FR"}}, // Avranches
    {Coordinate{4.80198, 50.4992}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rhisnes railway station
    {Coordinate{7.34531, 48.0817}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colmar-Saint-Joseph
    {Coordinate{6.90128, 49.1895}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Forbach
    {Coordinate{0.191944, 47.9942}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Mans
    {Coordinate{6.73556, 52.6631}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Coevorden railway station
    {Coordinate{4.38944, 50.8222}, Tz::Europe_Brussels, CountryId{"BE"}}, // Etterbeek railway station
    {Coordinate{1.51832, 46.5923}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2727028
    {Coordinate{-0.397182, 48.1555}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2727830
    {Coordinate{5.76812, 49.6909}, Tz::Europe_Brussels, CountryId{"BE"}}, // Stockem railway station
    {Coordinate{7.06913, 51.4292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Überruhr station
    {Coordinate{2.42895, 49.5036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Just-en-Chaussée
    {Coordinate{4.66222, 50.7547}, Tz::Europe_Brussels, CountryId{"BE"}}, // Archennes railway station
    {Coordinate{5.53375, 50.4283}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hamoir railway station
    {Coordinate{4.33, 51.2142}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zwijndrecht railway station
    {Coordinate{6.69855, 51.22}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Am Kaiser station
    {Coordinate{4.43389, 52.1264}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorschoten railway station
    {Coordinate{4.88797, 45.7052}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vénissieux
    {Coordinate{-3.83417, 47.9606}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rosporden
    {Coordinate{4.03944, 50.9428}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalst railway station
    {Coordinate{5.04361, 49.9336}, Tz::Europe_Brussels, CountryId{"BE"}}, // Graide railway station
    {Coordinate{5.16838, 49.6283}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2743849
    {Coordinate{4.87458, 45.5213}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vienne
    {Coordinate{4.32857, 50.881}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jette railway station
    {Coordinate{2.14139, 43.9378}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albi-Madeleine
    {Coordinate{5.39222, 51.8739}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tiel Passewaaij railway station
    {Coordinate{4.90806, 50.2611}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dinant railway station
    {Coordinate{3.04639, 50.7818}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wervik railway station
    {Coordinate{5.63694, 51.9261}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Opheusden railway station
    {Coordinate{6.88828, 48.3271}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2747695
    {Coordinate{11.2448, 51.1802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478676
    {Coordinate{6.95306, 50.7903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478729
    {Coordinate{7.72889, 48.0497}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478870
    {Coordinate{8.02722, 48.3386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478874
    {Coordinate{7.7694, 48.1523}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478896
    {Coordinate{11.7572, 47.7141}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478934
    {Coordinate{9.8307, 47.6891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478957
    {Coordinate{9.17235, 48.7759}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Stadtmitte station
    {Coordinate{4.82437, 46.3025}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mâcon-Ville
    {Coordinate{6.85383, 47.6336}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belfort
    {Coordinate{2.05987, 47.2266}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vierzon-Ville
    {Coordinate{1.52833, 45.1525}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Brive-la-Gaillarde
    {Coordinate{3.15056, 46.9869}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nevers
    {Coordinate{4.05568, 50.9193}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erembodegem railway station
    {Coordinate{4.21053, 50.52}, Tz::Europe_Brussels, CountryId{"BE"}}, // Familleureux railway station
    {Coordinate{4.74333, 51.8297}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sliedrecht Baanhoek railway station
    {Coordinate{3.16389, 51.1267}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zedelgem railway station
    {Coordinate{5.00693, 45.8339}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2752803
    {Coordinate{2.41806, 49.3853}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clermont-de-l'Oise
    {Coordinate{21.0011, 52.2278}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Śródmieście WKD railway station
    {Coordinate{3.13796, 50.6786}, Tz::Europe_Paris, CountryId{"FR"}}, // Croix - Wasquehal
    {Coordinate{4.74556, 52.0819}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bodegraven railway station
    {Coordinate{6.07461, 50.8319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kohlscheid railway station
    {Coordinate{6.3069, 45.5436}, Tz::Europe_Paris, CountryId{"FR"}}, // Aiguebelle
    {Coordinate{-1.14556, 46.1528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Rochelle
    {Coordinate{7.7212, 48.6447}, Tz::Europe_Paris, CountryId{"FR"}}, // Mundolsheim
    {Coordinate{4.87861, 50.3208}, Tz::Europe_Brussels, CountryId{"BE"}}, // Yvoir railway station
    {Coordinate{6.65833, 45.1925}, Tz::Europe_Paris, CountryId{"FR"}}, // Modane
    {Coordinate{3.62784, 50.9607}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eke-Nazareth railway station
    {Coordinate{6.45056, 52.0806}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ruurlo railway station
    {Coordinate{21.0375, 52.2553}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Wileńska station
    {Coordinate{-0.504509, 43.8847}, Tz::Europe_Paris, CountryId{"FR"}}, // Mont-de-Marsan
    {Coordinate{3.88056, 50.8969}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herzele railway station
    {Coordinate{13.0544, 51.9976}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jüterbog station
    {Coordinate{5.78604, 49.6882}, Tz::Europe_Brussels, CountryId{"BE"}}, // Viville railway station
    {Coordinate{-1.16544, 44.6588}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arcachon
    {Coordinate{7.43486, 52.2765}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheine station
    {Coordinate{4.35889, 51.0108}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kapelle-op-den-Bos railway station
    {Coordinate{4.83583, 50.8358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vertrijk railway station
    {Coordinate{6.13222, 51.9331}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Didam railway station
    {Coordinate{5.56722, 50.4564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Comblain-la-Tour railway station
    {Coordinate{6.16904, 48.7353}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2779510
    {Coordinate{5.72833, 53.1886}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deinum railway station
    {Coordinate{8.80211, 50.06}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heusenstamm station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gouy-lez-Piéton railway station
    {Coordinate{4.67111, 52.3819}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Haarlem Spaarnwoude railway station
    {Coordinate{4.36167, 50.7481}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Genesius-Rode railway station
    {Coordinate{6.14062, 50.8766}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Busch station
    {Coordinate{5.15056, 45.6275}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2781996
    {Coordinate{3.95646, 50.4719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nimy railway station
    {Coordinate{8.83732, 50.1194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühlheim station
    {Coordinate{8.78923, 50.0177}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dietzenbach-Mitte station
    {Coordinate{5.44512, 43.5232}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aix-en-Provence
    {Coordinate{6.73554, 45.5751}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2783838
    {Coordinate{8.19242, 49.4082}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27842213
    {Coordinate{7.19734, 50.9117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27842219
    {Coordinate{1.75638, 45.2588}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tulle
    {Coordinate{8.64397, 52.7916}, Tz::Europe_Berlin, CountryId{"DE"}}, // Twistringen station
    {Coordinate{6.92246, 51.1671}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hilden station
    {Coordinate{20.9725, 52.3578}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Choszczówka railway station
    {Coordinate{3.2852, 51.3399}, Tz::Europe_Brussels, CountryId{"BE"}}, // Knokke railway station
    {Coordinate{6.15487, 50.7857}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eilendorf station
    {Coordinate{5.33075, 50.5538}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haute-Flône railway station
    {Coordinate{6.75558, 43.4284}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2786235
    {Coordinate{2.22904, 43.598}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castres
    {Coordinate{0.333056, 46.5822}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Poitiers
    {Coordinate{3.26442, 50.8244}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kortrijk railway station
    {Coordinate{7.55694, 47.7317}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27869673
    {Coordinate{4.76579, 45.5852}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Givors-Ville
    {Coordinate{5.63778, 51.795}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ravenstein railway station
    {Coordinate{1.10209, 49.343}, Tz::Europe_Paris, CountryId{"FR"}}, // Oissel
    {Coordinate{4.52455, 50.0958}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mariembourg railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27894893
    {Coordinate{-2.08861, 47.6517}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Redon
    {Coordinate{8.7884, 49.3937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neckargemünd
    {Coordinate{5.50667, 51.7583}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oss West railway station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Wien Speising
    {Coordinate{1.67595, 50.2731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rue
    {Coordinate{4.12833, 51.9753}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoek van Holland Haven railway station
    {Coordinate{5.66778, 52.0431}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ede Centrum railway station
    {Coordinate{6.55611, 44.791}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2792896
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melsele railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof (Löffingen)
    {Coordinate{5.84944, 50.9433}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Spaubeek railway station
    {Coordinate{16.2886, 48.1471}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Atzgersdorf railway station
    {Coordinate{2.23028, 49.9147}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dreuil-lès-Amiens
    {Coordinate{3.93561, 50.9135}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bambrugge railway station
    {Coordinate{6.14278, 52.1578}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorst-Empe railway station
    {Coordinate{3.85243, 50.5942}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brugelette railway station
    {Coordinate{7.75267, 48.5636}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Krimmeri-Meinau
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27996618
    {Coordinate{5.99667, 51.5922}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vierlingsbeek railway station
    {Coordinate{-1.09089, 46.0784}, Tz::Europe_Paris, CountryId{"FR"}}, // Châtelaillon
    {Coordinate{6.07314, 49.3307}, Tz::Europe_Paris, CountryId{"FR"}}, // Hayange railway station
    {Coordinate{4.47667, 51.1339}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kontich railway station
    {Coordinate{5.84684, 45.8034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2801473
    {Coordinate{3.21867, 43.3361}, Tz::Europe_Paris, CountryId{"FR"}}, // Béziers railway station
    {Coordinate{9.87972, 48.2289}, Tz::Europe_Berlin, CountryId{"DE"}}, // Laupheim West station
    {Coordinate{9.39239, 48.8795}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28025261
    {Coordinate{-1.76435, 43.37}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Deux-Jumeaux
    {Coordinate{8.77277, 47.8563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28029178
    {Coordinate{6.04128, 51.4271}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Horst-Sevenum railway station
    {Coordinate{6.62583, 51.2689}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meerbusch-Osterath station
    {Coordinate{1.31412, 43.6164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2804370
    {Coordinate{6.31778, 52.1069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vorden railway station
    {Coordinate{12.1, 54.0779}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock Thierfelder Straße railway station
    {Coordinate{12.0463, 54.077}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Schwaß railway station
    {Coordinate{11.9787, 54.0813}, Tz::Europe_Berlin, CountryId{"DE"}}, // Parkentin railway station
    {Coordinate{11.922, 54.0905}, Tz::Europe_Berlin, CountryId{"DE"}}, // Althof railway station
    {Coordinate{11.905, 54.1}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan railway station
    {Coordinate{11.8496, 54.0853}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reddelich railway station
    {Coordinate{11.9021, 54.1047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan Stadtmitte railway station
    {Coordinate{11.7274, 54.1467}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn West railway station
    {Coordinate{11.8999, 54.1083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan Goethestraße railway station
    {Coordinate{11.8429, 54.1417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heiligendamm railway station
    {Coordinate{11.7939, 54.1448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steilküste/Wittenbeck railway station
    {Coordinate{11.7598, 54.1478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn Ost railway station
    {Coordinate{11.7534, 54.1416}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn Mitte railway station
    {Coordinate{11.7918, 54.069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kröpelin railway station
    {Coordinate{11.7407, 54.0527}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sandhagen (b. Bad Doberan) railway station
    {Coordinate{11.6779, 54.0309}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubukow railway station
    {Coordinate{11.6378, 53.9943}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teschow railway station
    {Coordinate{11.6149, 53.9596}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagebök railway station
    {Coordinate{11.5963, 53.9422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinhausen-Neuburg railway station
    {Coordinate{11.5784, 53.9257}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kalsow railway station
    {Coordinate{11.5353, 53.9068}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hornstorf railway station
    {Coordinate{5.44389, 47.8094}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Culmont-Chalindrey
    {Coordinate{7.05855, 47.2771}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pré-Petitjean train station
    {Coordinate{3.3144, 50.8564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Harelbeke railway station
    {Coordinate{7.84917, 48.1214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28119419
    {Coordinate{11.8105, 51.9207}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28119428
    {Coordinate{9.00126, 49.6844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28131570
    {Coordinate{20.9422, 52.2056}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2832591
    {Coordinate{3.3966, 50.613}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tournai railway station
    {Coordinate{4.6513, 50.7784}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pécrot railway station
    {Coordinate{6.0855, 44.564}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gap
    {Coordinate{2.04774, 47.4252}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Salbris
    {Coordinate{4.46722, 51.3789}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kijkuit railway station
    {Coordinate{4.51528, 50.7256}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genval railway station
    {Coordinate{4.44694, 51.1822}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Deurnesteenweg railway station
    {Coordinate{4.74611, 51.1656}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bouwel railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28475391
    {Coordinate{5.76944, 49.5131}, Tz::Europe_Paris, CountryId{"FR"}}, // Longwy railway station
    {Coordinate{6.63002, 51.3377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Linn station
    {Coordinate{11.0376, 48.1059}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geltendorf station
    {Coordinate{22.055, 50.5703}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2853323
    {Coordinate{8.68611, 50.0994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt South station
    {Coordinate{3.96967, 51.0019}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wichelen railway station
    {Coordinate{8.79833, 47.98}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tuttlingen station
    {Coordinate{5.37917, 49.92}, Tz::Europe_Brussels, CountryId{"BE"}}, // Libramont railway station
    {Coordinate{3.19142, 51.3059}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zwankendamme railway station
    {Coordinate{7.9281, 49.2171}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28595256
    {Coordinate{6.42494, 46.3033}, Tz::Europe_Paris, CountryId{"FR"}}, // Perrignier
    {Coordinate{6.16401, 49.2536}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2859801
    {Coordinate{3.90633, 50.4875}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ghlin railway station
    {Coordinate{11.7846, 51.763}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Baalberge
    {Coordinate{11.7686, 51.7736}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28656480
    {Coordinate{7.86694, 48.0422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28656485
    {Coordinate{10.0251, 47.554}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28661170
    {Coordinate{3.84344, 50.1973}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aulnoye-Aymeries
    {Coordinate{-4.25626, 48.4537}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Landerneau
    {Coordinate{8.459, 49.645}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28806098
    {Coordinate{5.78444, 45.1847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grenoble-Universités-Gières
    {Coordinate{10.038, 44.8498}, Tz::Europe_Rome, CountryId{"IT"}}, // Vaio-Ospedale railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28859934
    {Coordinate{7.35939, 46.2274}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sion railway station
    {Coordinate{5.81, 50.5447}, Tz::Europe_Brussels, CountryId{"BE"}}, // Juslenville railway station
    {Coordinate{3.8375, 50.8839}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hillegem railway station
    {Coordinate{7.43944, 46.9497}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern railway station
    {Coordinate{11.2032, 50.8563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28870827
    {Coordinate{4.61361, 50.9661}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haacht railway station
    {Coordinate{6.38778, 48.3072}, Tz::Europe_Paris, CountryId{"FR"}}, // Q289445
    {Coordinate{5.88036, 48.6792}, Tz::Europe_Paris, CountryId{"FR"}}, // Toul railway station
    {Coordinate{1.04604, 46.1253}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2898331
    {Coordinate{12.3673, 50.7257}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werdau station
    {Coordinate{11.2814, 50.896}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29043546
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Röthenbach (Allgäu) railway station
    {Coordinate{6.38167, 45.6731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albertville
    {Coordinate{8.7075, 47.2083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Richterswil railway station
    {Coordinate{5.71333, 53.13}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Mantgum railway station
    {Coordinate{4.22917, 51.0144}, Tz::Europe_Brussels, CountryId{"BE"}}, // Malderen railway station
    {Coordinate{5.90132, 45.2626}, Tz::Europe_Paris, CountryId{"FR"}}, // Brignoud
    {Coordinate{8.01307, 47.5073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frick railway station
    {Coordinate{4.36361, 50.5358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Obaix-Buzet railway station
    {Coordinate{5.49611, 50.9669}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genk railway station
    {Coordinate{5.57363, 50.5399}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hony railway station
    {Coordinate{1.40147, 43.5956}, Tz::Europe_Paris, CountryId{"FR"}}, // Station of TOEC
    {Coordinate{13.02, 58.0789}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Herrljunga railway station
    {Coordinate{13.335, 58.1392}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Floby railway station
    {Coordinate{13.0533, 57.9867}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Ljung railway station
    {Coordinate{4.77261, 45.5958}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2936724
    {Coordinate{7.90778, 47.3519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Olten railway station
    {Coordinate{9.21998, 49.1887}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29370439
    {Coordinate{7.362, 48.7446}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saverne
    {Coordinate{19.156, 63.3441}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Husum railway station
    {Coordinate{18.7153, 63.3027}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Örnsköldsvik north station
    {Coordinate{17.7447, 63.0526}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Västeraspby railway station
    {Coordinate{19.4851, 63.5786}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Nordmaling railway station
    {Coordinate{19.9101, 63.6329}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Hörnefors railway station
    {Coordinate{}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Nykroppa railway station
    {Coordinate{5.52791, 46.1847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nurieux
    {Coordinate{9.5027, 49.2032}, Tz::Europe_Berlin, CountryId{"DE"}}, // Öhringen Central Station
    {Coordinate{4.46889, 50.3928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Couillet railway station
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landskouter railway station
    {Coordinate{1.46667, 44.9022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Souillac
    {Coordinate{2.98152, 50.3274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitry-en-Artois
    {Coordinate{4.33528, 50.6006}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nivelles railway station
    {Coordinate{13.6364, 52.7178}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29573095
    {Coordinate{5.18556, 50.9642}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schulen railway station
    {Coordinate{20.9911, 52.2258}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2961989
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Opwijk railway station
    {Coordinate{4.40111, 50.8678}, Tz::Europe_Brussels, CountryId{"BE"}}, // Evere railway station
    {Coordinate{6.42513, 51.3679}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29793926
    {Coordinate{6.89222, 51.0286}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Chorweiler Nord station
    {Coordinate{7.64225, 48.7558}, Tz::Europe_Paris, CountryId{"FR"}}, // Mommenheim
    {Coordinate{5.14333, 52.0656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Lunetten railway station
    {Coordinate{7.61835, 51.363}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29878878
    {Coordinate{13.8851, 37.6685}, Tz::Europe_Rome, CountryId{"IT"}}, // Villalba railway station
    {Coordinate{6.05944, 50.8761}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Chevremont railway station
    {Coordinate{11.7799, 51.6741}, Tz::Europe_Berlin, CountryId{"DE"}}, // Könnern station
    {Coordinate{7.62817, 48.5469}, Tz::Europe_Paris, CountryId{"FR"}}, // Entzheim-Aéroport Station
    {Coordinate{4.11806, 51.0217}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Gillis railway station
    {Coordinate{6.09111, 50.7681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen Central Station
    {Coordinate{7.35702, 46.9046}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q30088642
    {Coordinate{7.66231, 47.5315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schweizerhalle Station
    {Coordinate{12.9774, 52.9055}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30106124
    {Coordinate{4.36972, 52.0906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Mariahoeve
    {Coordinate{6.51917, 52.3117}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rijssen railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Waghäusel
    {Coordinate{4.35413, 50.7675}, Tz::Europe_Brussels, CountryId{"BE"}}, // Holleken railway station
    {Coordinate{8.25505, 50.2968}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30238830
    {Coordinate{7.20163, 47.2198}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tavannes Station
    {Coordinate{7.22741, 47.2352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reconvilier Station
    {Coordinate{7.27593, 47.2387}, Tz::Europe_Zurich, CountryId{"CH"}}, // Malleray-Bévilard Station
    {Coordinate{8.90796, 49.236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30248297
    {Coordinate{7.52833, 51.5719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Derne station
    {Coordinate{11.7588, 51.9057}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30274649
    {Coordinate{13.3124, 52.4797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Heidelberger Platz station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30303373
    {Coordinate{3.02306, 42.5464}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Argelès-sur-Mer
    {Coordinate{4.37955, 50.8299}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mouterij railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30340466
    {Coordinate{8.78519, 50.008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dietzenbach station
    {Coordinate{7.79691, 48.7178}, Tz::Europe_Paris, CountryId{"FR"}}, // Q305421
    {Coordinate{4.06273, 46.0395}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Roanne
    {Coordinate{5.20528, 52.13}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bilthoven railway station
    {Coordinate{5.09222, 51.8944}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leerdam railway station
    {Coordinate{12.6944, 56.0444}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Helsingborg Central Station
    {Coordinate{7.15111, 46.8028}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fribourg railway station
    {Coordinate{4.7688, 50.5208}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Denis-Bovesse railway station
    {Coordinate{8.2825, 50.0069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz-Kastel station
    {Coordinate{3.87914, 51.087}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beervelde railway station
    {Coordinate{4.71987, 45.9394}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3078253
    {Coordinate{6.10139, 50.8856}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzogenrath-Alt-Merkstein station
    {Coordinate{4.72111, 51.6058}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Breda-Prinsenbeek railway station
    {Coordinate{1.09389, 49.4489}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rouen-Rive-Droite
    {Coordinate{5.32, 50.5461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Amay railway station
    {Coordinate{1.02083, 47.8219}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vendôme-Villiers-sur-Loir TGV
    {Coordinate{4.30861, 52.0533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Moerwijk
    {Coordinate{7.6034, 47.4677}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095587
    {Coordinate{7.55521, 43.8713}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095596
    {Coordinate{4.77182, 45.752}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095600
    {Coordinate{5.90944, 45.6881}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aix-les-Bains-Le Revard
    {Coordinate{4.83263, 45.8748}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095609
    {Coordinate{4.08492, 44.128}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095618
    {Coordinate{4.3267, 45.971}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Amplepuis
    {Coordinate{0.981175, 47.4216}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Amboise
    {Coordinate{4.67035, 49.9308}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095628
    {Coordinate{4.2552, 45.5216}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095632
    {Coordinate{2.30833, 49.8906}, Tz::Europe_Paris, CountryId{"FR"}}, // Amiens railway station
    {Coordinate{19.0892, 47.55}, Tz::Europe_Budapest, CountryId{"HU"}}, // Angyalföld train station
    {Coordinate{4.90472, 50.2375}, Tz::Europe_Brussels, CountryId{"BE"}}, // Anseremme railway station
    {Coordinate{0.165278, 45.6542}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Angoulême
    {Coordinate{7.29613, 45.7326}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095652
    {Coordinate{7.30632, 45.7316}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095653
    {Coordinate{6.42373, 46.5509}, Tz::Europe_Zurich, CountryId{"CH"}}, // Apples railway station
    {Coordinate{7.3225, 45.7342}, Tz::Europe_Rome, CountryId{"IT"}}, // Aosta railway station
    {Coordinate{-0.025337, 48.7385}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Argentan
    {Coordinate{3.31062, 45.3654}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095673
    {Coordinate{7.16675, 45.7041}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095675
    {Coordinate{6.62052, 46.6132}, Tz::Europe_Zurich, CountryId{"CH"}}, // Assens railway station
    {Coordinate{1.86954, 44.6745}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Assier
    {Coordinate{5.02306, 50.3681}, Tz::Europe_Brussels, CountryId{"BE"}}, // Assesse railway station
    {Coordinate{2.59276, 50.3531}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095689
    {Coordinate{4.19836, 45.3711}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095697
    {Coordinate{-2.99917, 47.68}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Auray
    {Coordinate{3.58492, 47.798}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095705
    {Coordinate{7.13131, 45.7063}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095712
    {Coordinate{5.30139, 50.2242}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aye railway station
    {Coordinate{7.99007, 47.5331}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eiken railway station
    {Coordinate{3.99356, 50.8238}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eichem railway station
    {Coordinate{4.04722, 50.6972}, Tz::Europe_Brussels, CountryId{"BE"}}, // Enghien railway station
    {Coordinate{5.40111, 50.5822}, Tz::Europe_Brussels, CountryId{"BE"}}, // Engis railway station
    {Coordinate{4.86813, 45.5403}, Tz::Europe_Paris, CountryId{"FR"}}, // gare d'Estressin
    {Coordinate{2.06611, 49.9825}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hangest
    {Coordinate{4.05999, 50.4706}, Tz::Europe_Brussels, CountryId{"BE"}}, // Havré railway station
    {Coordinate{4.70243, 50.0114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Haybes
    {Coordinate{2.54136, 50.7252}, Tz::Europe_Paris, CountryId{"FR"}}, // Hazebrouck
    {Coordinate{2.01094, 49.488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095768
    {Coordinate{6.17974, 48.6455}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095770
    {Coordinate{6.8057, 48.6466}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095780
    {Coordinate{-0.919624, 47.4065}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095790
    {Coordinate{5.12935, 47.5203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095794
    {Coordinate{3.25396, 45.544}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095800
    {Coordinate{19.1063, 47.5503}, Tz::Europe_Budapest, CountryId{"HU"}}, // Istvántelek railway station
    {Coordinate{7.78725, 47.4673}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095807
    {Coordinate{3.21475, 50.9211}, Tz::Europe_Brussels, CountryId{"BE"}}, // Izegem railway station
    {Coordinate{4.05367, 50.8566}, Tz::Europe_Brussels, CountryId{"BE"}}, // Okegem railway station
    {Coordinate{1.186, 47.4919}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Onzain
    {Coordinate{6.8294, 45.0385}, Tz::Europe_Rome, CountryId{"IT"}}, // Oulx-Cesana-Claviere-Sestriere railway station
    {Coordinate{4.3321, 50.7919}, Tz::Europe_Brussels, CountryId{"BE"}}, // Uccle-Calevoet railway station
    {Coordinate{1.57045, 45.4407}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Uzerche
    {Coordinate{6.63294, 46.6394}, Tz::Europe_Zurich, CountryId{"CH"}}, // Échallens railway station
    {Coordinate{5.99465, 47.2748}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'École-Valentin
    {Coordinate{0.268898, 47.8245}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095866
    {Coordinate{6.29253, 45.457}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095873
    {Coordinate{19.0796, 47.5588}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újpest railway station
    {Coordinate{4.00699, 43.6533}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095890
    {Coordinate{7.4567, 48.4033}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Barr
    {Coordinate{4.13961, 45.2977}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095908
    {Coordinate{7.24684, 47.3367}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095912
    {Coordinate{5.925, 49.5583}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Bascharage-Sanem railway station
    {Coordinate{6.32275, 48.4679}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bayon
    {Coordinate{4.17414, 49.3611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095927
    {Coordinate{1.62577, 47.7785}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095933
    {Coordinate{-1.47, 43.4972}, Tz::Europe_Paris, CountryId{"FR"}}, // Bayonne railway station
    {Coordinate{6.10184, 48.8196}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095947
    {Coordinate{4.72886, 46.112}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belleville-sur-Saône
    {Coordinate{5.823, 46.1095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bellegarde
    {Coordinate{6.7037, 46.6929}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bercher railway station
    {Coordinate{4.28992, 50.8727}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berchem-Sainte-Agathe railway station
    {Coordinate{3.36048, 46.443}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095977
    {Coordinate{7.57929, 43.8252}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095986
    {Coordinate{7.4981, 48.4871}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095992
    {Coordinate{4.17278, 50.4086}, Tz::Europe_Brussels, CountryId{"BE"}}, // Binche railway station
    {Coordinate{7.43227, 49.0488}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Bitche
    {Coordinate{7.85132, 48.7656}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095997
    {Coordinate{6.333, 46.538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bière railway station
    {Coordinate{4.7405, 47.374}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096003
    {Coordinate{3.13387, 51.3122}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blankenberge railway station
    {Coordinate{4.57518, 45.9066}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096013
    {Coordinate{4.40944, 50.8772}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bordet railway station
    {Coordinate{5.21461, 46.2001}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-en-Bresse
    {Coordinate{4.27761, 45.5247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096044
    {Coordinate{4.13844, 50.6056}, Tz::Europe_Brussels, CountryId{"BE"}}, // Braine-le-Comte railway station
    {Coordinate{3.33017, 45.4141}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096057
    {Coordinate{2.1193, 43.244}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bram
    {Coordinate{7.10367, 48.0283}, Tz::Europe_Paris, CountryId{"FR"}}, // Breitenbach station
    {Coordinate{4.76377, 45.6737}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096066
    {Coordinate{3.37875, 45.3006}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096071
    {Coordinate{4.32134, 50.849}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels West railway station
    {Coordinate{1.54156, 48.9433}, Tz::Europe_Paris, CountryId{"FR"}}, // Bréval
    {Coordinate{7.84799, 47.4089}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096083
    {Coordinate{1.44352, 48.9253}, Tz::Europe_Paris, CountryId{"FR"}}, // Bueil
    {Coordinate{3.14947, 43.6087}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096097
    {Coordinate{7.61952, 47.5426}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096099
    {Coordinate{7.14806, 43.6578}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cagnes-sur-Mer
    {Coordinate{-0.3477, 49.1764}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caen
    {Coordinate{3.06634, 44.422}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096117
    {Coordinate{4.73067, 45.788}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096140
    {Coordinate{3.15515, 43.8123}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096153
    {Coordinate{-0.533632, 44.8563}, Tz::Europe_Paris, CountryId{"FR"}}, // Cenon station
    {Coordinate{-0.743689, 47.3429}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096169
    {Coordinate{-1.87194, 46.8433}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Challans
    {Coordinate{5.91937, 45.561}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chambéry-Challes-les-Eaux
    {Coordinate{4.76427, 45.6983}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096190
    {Coordinate{4.73582, 45.7822}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096192
    {Coordinate{4.80083, 45.5814}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096199
    {Coordinate{4.72534, 45.8733}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096209
    {Coordinate{-0.732163, 47.2177}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096215
    {Coordinate{6.60608, 46.5844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cheseaux-sur-Lausanne railway station
    {Coordinate{4.62253, 45.8856}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chessy
    {Coordinate{6.27186, 44.5458}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096225
    {Coordinate{-0.86979, 47.066}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cholet
    {Coordinate{0.414916, 47.6832}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-du-Loir
    {Coordinate{6.81549, 46.5705}, Tz::Europe_Zurich, CountryId{"CH"}}, // Châtillens railway station
    {Coordinate{4.64523, 45.8753}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096237
    {Coordinate{4.51889, 50.4087}, Tz::Europe_Brussels, CountryId{"BE"}}, // Châtelet railway station
    {Coordinate{6.19629, 46.1967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096243
    {Coordinate{4.7184, 45.8593}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Civrieux-d'Azergues
    {Coordinate{3.13415, 45.767}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096253
    {Coordinate{-1.2865, 47.0859}, Tz::Europe_Paris, CountryId{"FR"}}, // Clisson
    {Coordinate{4.84641, 45.8291}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096265
    {Coordinate{1.33395, 43.6036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colomiers
    {Coordinate{2.99825, 50.7717}, Tz::Europe_Brussels, CountryId{"BE"}}, // Comines railway station
    {Coordinate{1.22675, 45.1267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Condat-Le Lardin
    {Coordinate{7.12417, 47.4053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courgenay
    {Coordinate{7.29116, 47.3351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096306
    {Coordinate{6.59583, 52.0119}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lichtenvoorde-Groenlo railway station
    {Coordinate{7.31798, 47.3427}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtételle
    {Coordinate{-1.44148, 49.0427}, Tz::Europe_Paris, CountryId{"FR"}}, // Coutances
    {Coordinate{4.82928, 45.8487}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096321
    {Coordinate{4.78417, 46.2462}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096336
    {Coordinate{4.76122, 45.8153}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096346
    {Coordinate{4.75996, 45.7968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096347
    {Coordinate{3.46728, 46.8375}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096352
    {Coordinate{4.36183, 50.7481}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Hoek railway station
    {Coordinate{3.64908, 50.9965}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Pinte railway station
    {Coordinate{4.70722, 49.8796}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096359
    {Coordinate{7.83776, 47.4496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096363
    {Coordinate{5.02722, 47.3233}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dijon-Ville
    {Coordinate{6.34346, 48.6233}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096382
    {Coordinate{4.73441, 45.8397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dommartin - Lissieu
    {Coordinate{7.49293, 48.5244}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096390
    {Coordinate{7.61122, 47.4886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096391
    {Coordinate{7.67236, 48.491}, Tz::Europe_Paris, CountryId{"FR"}}, // Fegersheim - Lipsheim
    {Coordinate{19.2237, 47.4374}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ferihegy railway station
    {Coordinate{4.85308, 45.6659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096429
    {Coordinate{4.23077, 45.744}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096431
    {Coordinate{2.0373, 44.6035}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Figeac
    {Coordinate{4.2864, 45.3918}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Firminy
    {Coordinate{4.66012, 45.8451}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096438
    {Coordinate{4.80729, 50.4562}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flawinne railway station
    {Coordinate{-0.760833, 48.0764}, Tz::Europe_Paris, CountryId{"FR"}}, // Laval railway station
    {Coordinate{4.32455, 50.4332}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forchies railway station
    {Coordinate{4.2697, 45.395}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096467
    {Coordinate{3.08722, 47.0189}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fourchambault
    {Coordinate{3.90611, 50.4058}, Tz::Europe_Brussels, CountryId{"BE"}}, // Frameries railway station
    {Coordinate{7.71912, 47.5014}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096480
    {Coordinate{6.31408, 45.6304}, Tz::Europe_Paris, CountryId{"FR"}}, // Frontenex
    {Coordinate{3.75891, 43.4449}, Tz::Europe_Paris, CountryId{"FR"}}, // Frontignan
    {Coordinate{3.35447, 50.6301}, Tz::Europe_Brussels, CountryId{"BE"}}, // Froyennes railway station
    {Coordinate{2.63331, 50.3473}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096497
    {Coordinate{4.69253, 49.9861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fumay
    {Coordinate{2.67028, 51.0736}, Tz::Europe_Brussels, CountryId{"BE"}}, // Veurne railway station
    {Coordinate{4.72642, 50.0235}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096505
    {Coordinate{1.89606, 43.9068}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gaillac
    {Coordinate{3.74057, 51.0561}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gent-Dampoort railway station
    {Coordinate{7.84757, 47.4658}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096527
    {Coordinate{5.27083, 51.8839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geldermalsen railway station
    {Coordinate{3.78212, 46.5371}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096539
    {Coordinate{0.86748, 43.6331}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096543
    {Coordinate{7.2093, 47.3352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glovelier
    {Coordinate{5.53548, 50.7506}, Tz::Europe_Brussels, CountryId{"BE"}}, // Glons railway station
    {Coordinate{-1.31379, 47.1079}, Tz::Europe_Paris, CountryId{"FR"}}, // Gorges
    {Coordinate{7.47875, 48.4329}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096559
    {Coordinate{7.69028, 48.5328}, Tz::Europe_Paris, CountryId{"FR"}}, // Graffenstaden railway station
    {Coordinate{4.03289, 44.2098}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096562
    {Coordinate{5.95335, 50.19}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gouvy railway station
    {Coordinate{1.72226, 44.7734}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gramat
    {Coordinate{7.59235, 47.4413}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096575
    {Coordinate{6.17579, 46.0111}, Tz::Europe_Paris, CountryId{"FR"}}, // Groisy-Thorens-la-Caille
    {Coordinate{6.25891, 45.5944}, Tz::Europe_Paris, CountryId{"FR"}}, // Grésy-sur-Isère
    {Coordinate{5.92198, 45.7247}, Tz::Europe_Paris, CountryId{"FR"}}, // Grésy-sur-Aix train station
    {Coordinate{7.8909, 46.5965}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grütschalp railway station
    {Coordinate{7.17474, 48.0416}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096599
    {Coordinate{3.95165, 44.3472}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Génolhac
    {Coordinate{5.74329, 49.556}, Tz::Europe_Brussels, CountryId{"BE"}}, // Halanzy railway station
    {Coordinate{3.23913, 51.3339}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heist railway station
    {Coordinate{4.5377, 50.9977}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hever railway station
    {Coordinate{4.46778, 50.76}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hoeilaart railway station
    {Coordinate{7.66318, 48.5556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096635
    {Coordinate{5.00583, 50.1906}, Tz::Europe_Brussels, CountryId{"BE"}}, // Houyet railway station
    {Coordinate{6.20256, 48.6701}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096650
    {Coordinate{5.26667, 50.16}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemelle railway station
    {Coordinate{4.76707, 49.8337}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096655
    {Coordinate{5.14366, 48.4443}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096656
    {Coordinate{3.39314, 47.9736}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096662
    {Coordinate{6.60172, 46.5484}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jouxtens-Mézery railway station
    {Coordinate{7.7241, 47.5386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaiseraugst railway station
    {Coordinate{19.1572, 47.4479}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kispest railway station
    {Coordinate{7.81324, 48.7419}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096706
    {Coordinate{19.1491, 47.4631}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőbánya-Kispest railway station
    {Coordinate{0.620062, 48.7663}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Aigle
    {Coordinate{5.21944, 45.6075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Isle-d'Abeau
    {Coordinate{3.9042, 44.5935}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Bastide - Saint-Laurent-les-Bains
    {Coordinate{-2.38944, 47.2886}, Tz::Europe_Paris, CountryId{"FR"}}, // La Baule-Escoublac train station
    {Coordinate{2.50556, 49.1269}, Tz::Europe_Paris, CountryId{"FR"}}, // La Borne Blanche
    {Coordinate{3.02389, 47.1797}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Charité
    {Coordinate{6.82504, 47.0986}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-de-Fonds railway station
    {Coordinate{4.31687, 45.4979}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096780
    {Coordinate{6.97211, 43.5581}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Frayère
    {Coordinate{-1.39194, 47.1614}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Haye-Fouassière
    {Coordinate{4.49708, 50.7383}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Hulpe railway station
    {Coordinate{5.99961, 46.1787}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Plaine
    {Coordinate{4.35815, 45.4034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096803
    {Coordinate{-0.691705, 47.3714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096804
    {Coordinate{4.71615, 45.8001}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096811
    {Coordinate{4.18528, 50.3161}, Tz::Europe_Brussels, CountryId{"BE"}}, // Labuissière railway station
    {Coordinate{4.69282, 49.9114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laifour
    {Coordinate{6.22803, 48.6555}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096846
    {Coordinate{3.4905, 45.1012}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096847
    {Coordinate{8.06109, 47.5595}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laufenburg railway station
    {Coordinate{7.50263, 47.4193}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laufen railway station
    {Coordinate{7.75986, 47.4702}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096861
    {Coordinate{6.62611, 46.5233}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne-Chauderon railway station
    {Coordinate{1.81235, 43.7034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096865
    {Coordinate{3.90531, 45.1214}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096866
    {Coordinate{4.66718, 45.8218}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096871
    {Coordinate{4.68213, 45.8164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096872
    {Coordinate{4.22112, 50.7147}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lembeek railway station
    {Coordinate{3.9034, 50.559}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lens railway station
    {Coordinate{2.82786, 50.4267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lens
    {Coordinate{7.73148, 47.4844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Liestal railway station
    {Coordinate{7.65969, 48.4609}, Tz::Europe_Paris, CountryId{"FR"}}, // Limersheim
    {Coordinate{4.36583, 50.6453}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lillois railway station
    {Coordinate{3.19445, 51.2947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lissewege railway station
    {Coordinate{-1.0504, 49.227}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lison
    {Coordinate{2.00278, 50.0117}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longpré-les-Corps-Saints
    {Coordinate{-3.36611, 47.7553}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lorient
    {Coordinate{5.45472, 44.6136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096917
    {Coordinate{6.17088, 48.6221}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096918
    {Coordinate{7.11906, 48.0355}, Tz::Europe_Paris, CountryId{"FR"}}, // Luttenbach-près-Munster station
    {Coordinate{-1.16738, 46.4638}, Tz::Europe_Paris, CountryId{"FR"}}, // Luçon
    {Coordinate{7.85636, 47.3921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096933
    {Coordinate{7.65917, 47.6011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lörrach-Stetten
    {Coordinate{6.32809, 46.2513}, Tz::Europe_Paris, CountryId{"FR"}}, // Machilly
    {Coordinate{3.22948, 43.4676}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Magalas
    {Coordinate{6.62157, 46.0169}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096951
    {Coordinate{6.15845, 49.2155}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096957
    {Coordinate{6.50785, 46.0888}, Tz::Europe_Paris, CountryId{"FR"}}, // Marignier
    {Coordinate{5.07319, 46.0639}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marlieux - Châtillon
    {Coordinate{0.168031, 44.5032}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marmande
    {Coordinate{7.07912, 46.1058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096986
    {Coordinate{3.28101, 44.5447}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096989
    {Coordinate{7.61969, 48.3989}, Tz::Europe_Paris, CountryId{"FR"}}, // Matzenheim
    {Coordinate{3.50188, 44.5223}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097015
    {Coordinate{3.11407, 50.7996}, Tz::Europe_Brussels, CountryId{"BE"}}, // Menen railway station
    {Coordinate{6.1379, 48.6129}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097027
    {Coordinate{7.07322, 48.0132}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Metzeral
    {Coordinate{3.07437, 44.1024}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097038
    {Coordinate{4.91961, 45.8968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097042
    {Coordinate{5.60003, 50.6928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Milmort railway station
    {Coordinate{4.95388, 45.8221}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097047
    {Coordinate{5.56492, 45.3241}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097052
    {Coordinate{7.50009, 48.5373}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Molsheim
    {Coordinate{5.63391, 44.9119}, Tz::Europe_Paris, CountryId{"FR"}}, // Monestier-de-Clermont
    {Coordinate{3.94172, 50.454}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mons railway station
    {Coordinate{4.48151, 46.7593}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097072
    {Coordinate{4.74069, 49.8657}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monthermé
    {Coordinate{5.37162, 49.5229}, Tz::Europe_Paris, CountryId{"FR"}}, // Montmédy
    {Coordinate{6.04313, 45.5031}, Tz::Europe_Paris, CountryId{"FR"}}, // Montmélian
    {Coordinate{0.159355, 45.0062}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montpon-Ménestérol
    {Coordinate{4.74472, 44.5592}, Tz::Europe_Paris, CountryId{"FR"}}, // Montélimar railway station
    {Coordinate{7.034, 45.7572}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3097107
    {Coordinate{4.2471, 50.4585}, Tz::Europe_Brussels, CountryId{"BE"}}, // Morlanwelz railway station
    {Coordinate{6.97417, 43.6206}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mouans-Sartoux
    {Coordinate{4.31778, 49.1313}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097119
    {Coordinate{7.08774, 48.0246}, Tz::Europe_Paris, CountryId{"FR"}}, // Muhlbach-sur-Munster station
    {Coordinate{3.22806, 50.74}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mouscron railway station
    {Coordinate{6.53139, 45.4864}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moûtiers-Salins-Brides-les-Bains
    {Coordinate{7.9098, 47.5475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mumpf railway station
    {Coordinate{7.33125, 47.7363}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mulhouse-Hasenrain
    {Coordinate{7.15278, 48.0391}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097135
    {Coordinate{7.13416, 48.0383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Munster
    {Coordinate{2.86964, 45.109}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Murat
    {Coordinate{7.64806, 47.5336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muttenz
    {Coordinate{0.353911, 45.0345}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mussidan
    {Coordinate{1.15058, 43.6367}, Tz::Europe_Paris, CountryId{"FR"}}, // Mérenvielle train station
    {Coordinate{1.83667, 42.6589}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mérens-les-Vals
    {Coordinate{7.83403, 47.5619}, Tz::Europe_Zurich, CountryId{"CH"}}, // Möhlin railway station
    {Coordinate{7.59935, 47.8101}, Tz::Europe_Berlin, CountryId{"DE"}}, // Müllheim (Baden) station
    {Coordinate{7.61727, 47.5132}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchenstein
    {Coordinate{4.99756, 50.4701}, Tz::Europe_Brussels, CountryId{"BE"}}, // Namêche railway station
    {Coordinate{4.92981, 50.4196}, Tz::Europe_Brussels, CountryId{"BE"}}, // Naninne railway station
    {Coordinate{7.56194, 47.8115}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuenburg
    {Coordinate{5.45265, 49.8541}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neufchâteau railway station
    {Coordinate{5.74167, 50.5719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nessonvaux railway station
    {Coordinate{5.11176, 47.2815}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097188
    {Coordinate{6.10789, 48.6148}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097192
    {Coordinate{3.1638, 47.0069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097195
    {Coordinate{6.46863, 45.5393}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097221
    {Coordinate{4.79484, 49.6972}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097227
    {Coordinate{4.95618, 47.1305}, Tz::Europe_Paris, CountryId{"FR"}}, // Nuits-Saint-Georges train station
    {Coordinate{1.70471, 50.1874}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noyelles
    {Coordinate{7.47114, 45.7389}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3097235
    {Coordinate{5.73382, 48.6967}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097240
    {Coordinate{4.11372, 46.4473}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Paray-le-Monial
    {Coordinate{1.61944, 43.1161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pamiers
    {Coordinate{4.28879, 50.4349}, Tz::Europe_Brussels, CountryId{"BE"}}, // Piéton railway station
    {Coordinate{5.47378, 45.2559}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097293
    {Coordinate{6.10288, 48.6025}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097296
    {Coordinate{3.49049, 45.8428}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097303
    {Coordinate{4.77277, 46.2131}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pontanevaux
    {Coordinate{4.49287, 45.8714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097312
    {Coordinate{7.08007, 47.4209}, Tz::Europe_Zurich, CountryId{"CH"}}, // Porrentruy
    {Coordinate{-2.34489, 47.2706}, Tz::Europe_Paris, CountryId{"FR"}}, // Pornichet train station
    {Coordinate{3.09387, 47.0768}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pougues-les-Eaux
    {Coordinate{2.96361, 47.2828}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pouilly-sur-Loire
    {Coordinate{7.69131, 47.5228}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pratteln train station
    {Coordinate{7.71024, 47.5307}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pratteln Salina Raurica station
    {Coordinate{0.733615, 45.1784}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Périgueux-Saint-Georges
    {Coordinate{1.73037, 43.8196}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rabastens-Couffouleux
    {Coordinate{3.68667, 50.41}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quiévrain railway station
    {Coordinate{6.9693, 43.5691}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ranguin
    {Coordinate{6.26744, 46.1255}, Tz::Europe_Paris, CountryId{"FR"}}, // Reignier
    {Coordinate{6.57889, 46.5369}, Tz::Europe_Zurich, CountryId{"CH"}}, // Renens VD railway station
    {Coordinate{4.03614, 45.2013}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097397
    {Coordinate{7.78361, 47.5567}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinfelden railway station
    {Coordinate{4.64286, 49.9387}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097401
    {Coordinate{7.76813, 47.5456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rheinfelden-Augarten railway station
    {Coordinate{7.65167, 47.5831}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riehen
    {Coordinate{7.63333, 47.5694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riehen-Niederholz
    {Coordinate{5.49167, 45.3575}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rives
    {Coordinate{9.73621, 44.1007}, Tz::Europe_Rome, CountryId{"IT"}}, // Riomaggiore
    {Coordinate{4.16111, 51.4228}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rilland-Bath railway station
    {Coordinate{7.40618, 47.7487}, Tz::Europe_Paris, CountryId{"FR"}}, // Rixheim station
    {Coordinate{6.60315, 46.5624}, Tz::Europe_Zurich, CountryId{"CH"}}, // Romanel-sur-Lausanne railway station
    {Coordinate{4.74221, 46.1763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097437
    {Coordinate{5.04899, 45.0488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097440
    {Coordinate{7.49132, 48.5051}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097445
    {Coordinate{-1.01648, 45.6259}, Tz::Europe_Paris, CountryId{"FR"}}, // Royan
    {Coordinate{0.190038, 46.0307}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ruffec
    {Coordinate{19.112, 47.5658}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákospalota-Újpest railway station
    {Coordinate{5.63469, 45.3689}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097466
    {Coordinate{4.21506, 45.9878}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097467
    {Coordinate{7.85061, 47.4254}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097471
    {Coordinate{2.48575, 46.7265}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Amand-Montrond - Orval train station
    {Coordinate{4.94883, 45.9258}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-André-de-Corcy
    {Coordinate{-0.440411, 44.991}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097485
    {Coordinate{4.51709, 45.4724}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097503
    {Coordinate{5.73183, 45.504}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Béron - La Bridoire
    {Coordinate{3.27094, 44.8017}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097505
    {Coordinate{4.32786, 43.8135}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Césaire
    {Coordinate{1.66644, 44.9459}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Denis-près-Martel
    {Coordinate{3.10621, 45.0347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097518
    {Coordinate{6.94844, 48.282}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097519
    {Coordinate{4.85252, 45.7058}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097522
    {Coordinate{3.49471, 45.1605}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097525
    {Coordinate{2.98358, 44.0659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097526
    {Coordinate{4.71873, 46.0621}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097531
    {Coordinate{7.25396, 48.0714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097534
    {Coordinate{3.81924, 50.4426}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Ghislain railway station
    {Coordinate{5.24389, 45.0714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097541
    {Coordinate{6.35475, 45.2777}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Jean de Maurienne - Vallée de l'Arvan
    {Coordinate{4.97754, 45.9504}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Marcel-en-Dombes
    {Coordinate{5.32361, 45.1508}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097567
    {Coordinate{1.37175, 43.5998}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097574
    {Coordinate{1.99694, 49.5303}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Omer-en-Chaussée
    {Coordinate{-2.21171, 47.2866}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Nazaire railway station
    {Coordinate{5.12808, 46.1}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097592
    {Coordinate{6.37584, 46.0593}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-en-Faucigny
    {Coordinate{3.11152, 46.7933}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097600
    {Coordinate{0.0407615, 49.0232}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-sur-Dives
    {Coordinate{0.723611, 47.3861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Pierre-des-Corps
    {Coordinate{4.54231, 45.8616}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Romain-de-Popey
    {Coordinate{2.96738, 44.014}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097612
    {Coordinate{4.81043, 45.2977}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097619
    {Coordinate{1.68056, 43.775}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sulpice-sur-Tarn
    {Coordinate{7.16588, 47.3677}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Ursanne
    {Coordinate{4.28121, 46.0026}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097633
    {Coordinate{5.67114, 45.2351}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Saint-Égrève-Saint-Robert
    {Coordinate{4.37828, 45.4371}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097638
    {Coordinate{-0.617596, 45.7487}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saintes
    {Coordinate{4.94938, 50.4065}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sart-Bernard railway station
    {Coordinate{6.03767, 46.2143}, Tz::Europe_Zurich, CountryId{"CH"}}, // Satigny
    {Coordinate{4.8748, 45.8199}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097685
    {Coordinate{-0.071293, 47.2689}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saumur
    {Coordinate{1.57028, 43.2394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saverdun
    {Coordinate{3.95806, 50.9853}, Tz::Europe_Brussels, CountryId{"BE"}}, // Serskamp railway station
    {Coordinate{7.53277, 46.292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sierre/Siders train station
    {Coordinate{4.33108, 50.8635}, Tz::Europe_Brussels, CountryId{"BE"}}, // Simonis railway station
    {Coordinate{5.42608, 43.4347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097749
    {Coordinate{7.81214, 47.4627}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097750
    {Coordinate{21.4458, 41.9912}, Tz::Europe_Skopje, CountryId{"MK"}}, // Skopje Main railway station
    {Coordinate{7.85168, 47.439}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097761
    {Coordinate{6.66582, 46.655}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sugnens railway station
    {Coordinate{0.134453, 48.6648}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Surdon
    {Coordinate{6.61065, 46.5247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne-Sébeillon railway station
    {Coordinate{4.43901, 45.8899}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097836
    {Coordinate{4.75848, 45.7616}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097842
    {Coordinate{7.88759, 47.4456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097843
    {Coordinate{1.30037, 45.1358}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Terrasson
    {Coordinate{4.94733, 51.0097}, Tz::Europe_Brussels, CountryId{"BE"}}, // Testelt railway station
    {Coordinate{3.29742, 49.6592}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tergnier
    {Coordinate{1.06871, 45.1602}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thenon
    {Coordinate{4.09778, 50.47}, Tz::Europe_Brussels, CountryId{"BE"}}, // Thieu railway station
    {Coordinate{0.921229, 45.4191}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thiviers
    {Coordinate{5.42306, 51.8894}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tiel railway station
    {Coordinate{3.01667, 43.9697}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097889
    {Coordinate{4.90641, 46.5667}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097896
    {Coordinate{7.90433, 47.366}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097902
    {Coordinate{5.49222, 45.3011}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097910
    {Coordinate{5.96732, 46.1094}, Tz::Europe_Paris, CountryId{"FR"}}, // Valleiry
    {Coordinate{4.89278, 44.9281}, Tz::Europe_Paris, CountryId{"FR"}}, // Valence-Ville railway station
    {Coordinate{6.31319, 48.6354}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097932
    {Coordinate{6.37031, 46.7126}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vallorbe railway station
    {Coordinate{4.21894, 43.7398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097953
    {Coordinate{0.929162, 48.7427}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Verneuil-sur-Avre
    {Coordinate{3.79936, 43.5007}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097971
    {Coordinate{5.90936, 50.2787}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vielsalm railway station
    {Coordinate{5.02833, 46.0043}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097985
    {Coordinate{1.51511, 45.3829}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vigeois
    {Coordinate{1.71457, 43.3984}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097993
    {Coordinate{3.92396, 44.4395}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097995
    {Coordinate{3.84986, 43.5437}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097997
    {Coordinate{6.92695, 46.3984}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villeneuve railway station
    {Coordinate{5.41011, 45.2079}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098014
    {Coordinate{5.65373, 45.8482}, Tz::Europe_Paris, CountryId{"FR"}}, // Virieu-le-Grand - Belley
    {Coordinate{5.51935, 49.5605}, Tz::Europe_Brussels, CountryId{"BE"}}, // Virton railway station
    {Coordinate{2.40222, 48.8006}, Tz::Europe_Paris, CountryId{"FR"}}, // Vitry-sur-Seine
    {Coordinate{5.59466, 45.3639}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Voiron
    {Coordinate{7.23369, 48.0582}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098050
    {Coordinate{7.60861, 47.5936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weil am Rhein
    {Coordinate{7.61622, 47.5887}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3098066
    {Coordinate{7.62707, 47.589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3098067
    {Coordinate{4.74749, 50.956}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wezemaal railway station
    {Coordinate{7.20956, 48.0463}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098081
    {Coordinate{6.15596, 49.1489}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098088
    {Coordinate{7.5302, 47.4338}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zwingen
    {Coordinate{4.98833, 51.0064}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zichem railway station
    {Coordinate{6.41121, 46.6173}, Tz::Europe_Zurich, CountryId{"CH"}}, // L'Isle-Mont-la-Ville railway station
    {Coordinate{6.48215, 43.4556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098144
    {Coordinate{4.75414, 45.7774}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098153
    {Coordinate{6.16619, 46.201}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3098155
    {Coordinate{4.46252, 47.5431}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098164
    {Coordinate{4.91091, 45.8746}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Échets
    {Coordinate{3.16893, 43.6912}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bousquet-d'Orb
    {Coordinate{3.18871, 45.7239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098186
    {Coordinate{4.32237, 45.3948}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098188
    {Coordinate{4.43049, 46.8078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Creusot
    {Coordinate{6.78527, 47.0776}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3098196
    {Coordinate{6.72609, 47.0499}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locle-Col des Roches
    {Coordinate{-0.88164, 49.2492}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098213
    {Coordinate{0.125278, 49.4928}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Havre
    {Coordinate{-1.34678, 47.1439}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Pallet
    {Coordinate{16.0839, 47.0417}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q31209189
    {Coordinate{6.60091, 46.5566}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Lussex halt
    {Coordinate{6.60796, 46.5921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Ripes halt
    {Coordinate{6.60983, 46.5348}, Tz::Europe_Zurich, CountryId{"CH"}}, // Union-Prilly railway station
    {Coordinate{6.613, 46.6}, Tz::Europe_Zurich, CountryId{"CH"}}, // Étagnières halt
    {Coordinate{6.60558, 46.5785}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bel-Air LEB halt
    {Coordinate{6.60513, 46.5445}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cery − Fleur-de-Lys halt
    {Coordinate{6.68503, 46.6743}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fey halt
    {Coordinate{6.6134, 46.53}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montétan halt
    {Coordinate{6.60741, 46.5397}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prilly-Chasseur halt
    {Coordinate{6.60258, 46.5267}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prilly-Malley halt
    {Coordinate{-1.69129, 48.1187}, Tz::Europe_Paris, CountryId{"FR"}}, // Rennes-Pontchaillou
    {Coordinate{6.63886, 46.6404}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sur Roche halt
    {Coordinate{6.60484, 46.571}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vernand-Camarès halt
    {Coordinate{6.64211, 46.6433}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grésaley halt
    {Coordinate{9.68171, 47.365}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q31338289
    {Coordinate{7.0403, 51.549}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q31401849
    {Coordinate{7.20694, 50.6314}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rolandseck station
    {Coordinate{7.3421, 47.2406}, Tz::Europe_Zurich, CountryId{"CH"}}, // Court Station
    {Coordinate{7.30577, 47.2392}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sorvilier Station
    {Coordinate{7.05537, 47.4559}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtemaîche Station
    {Coordinate{7.25415, 47.2388}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pontenet Station
    {Coordinate{7.04809, 47.4699}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandgourt Station
    {Coordinate{7.02996, 47.4793}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buix Station
    {Coordinate{7.53195, 47.2067}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn West Station
    {Coordinate{7.69481, 47.2704}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederbipp Station
    {Coordinate{7.33774, 47.1187}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dotzigen Station
    {Coordinate{7.37123, 47.1381}, Tz::Europe_Zurich, CountryId{"CH"}}, // Büren an der Aare Station
    {Coordinate{6.40051, 46.7173}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Day Station
    {Coordinate{6.92705, 46.3587}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roche VD Station
    {Coordinate{8.31969, 47.1079}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waldibrücke Station
    {Coordinate{8.2423, 47.2297}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ermensee Station
    {Coordinate{8.32278, 47.1324}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eschenbach Station
    {Coordinate{8.31688, 47.1538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ballwil Station
    {Coordinate{8.28869, 47.167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hochdorf Station
    {Coordinate{8.28021, 47.1857}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baldegg Station
    {Coordinate{8.26481, 47.2136}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gelfingen Station
    {Coordinate{8.25198, 47.2227}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hitzkirch Station
    {Coordinate{8.2768, 47.0783}, Tz::Europe_Zurich, CountryId{"CH"}}, // Emmenbrücke Gersag Station
    {Coordinate{8.22415, 47.2443}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mosen Station
    {Coordinate{8.15879, 47.3461}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seon Station
    {Coordinate{8.17594, 47.3286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hallwil Station
    {Coordinate{8.18455, 47.315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boniswil Station
    {Coordinate{8.199, 47.2878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Birrwil Station
    {Coordinate{8.20222, 47.2672}, Tz::Europe_Zurich, CountryId{"CH"}}, // Beinwil am See Station
    {Coordinate{8.29821, 47.1647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hochdorf Schönau Station
    {Coordinate{8.12568, 47.3883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hunzenschwil Station
    {Coordinate{8.21497, 47.4452}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lupfig Station
    {Coordinate{8.21766, 47.4358}, Tz::Europe_Zurich, CountryId{"CH"}}, // Birr Station
    {Coordinate{8.8343, 47.3248}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ettenhausen-Emmetschloo Station
    {Coordinate{8.85216, 47.3373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bäretswil Station
    {Coordinate{8.86436, 47.3579}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuthal Station
    {Coordinate{8.64595, 47.6922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Feuerthalen Station
    {Coordinate{8.25634, 47.5753}, Tz::Europe_Zurich, CountryId{"CH"}}, // Döttingen Station
    {Coordinate{8.24015, 47.5179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Siggenthal-Würenlingen Station
    {Coordinate{6.79126, 46.6531}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bressonnaz Station
    {Coordinate{7.18975, 46.851}, Tz::Europe_Zurich, CountryId{"CH"}}, // Düdingen Station
    {Coordinate{7.25392, 46.8629}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schmitten Station
    {Coordinate{7.37645, 46.9255}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederwangen Station
    {Coordinate{7.39523, 46.9375}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Bümpliz Süd Station
    {Coordinate{7.40611, 46.9442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Europaplatz SBB station
    {Coordinate{7.28064, 46.8719}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wünnewil Station
    {Coordinate{7.35186, 46.8936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thörishaus Dorf Station
    {Coordinate{7.36219, 46.9146}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberwangen Station
    {Coordinate{6.96029, 46.8353}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corcelles-Nord Station
    {Coordinate{6.98536, 46.8544}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dompierre Station
    {Coordinate{7.01138, 46.8685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Domdidier Station
    {Coordinate{7.04092, 46.8846}, Tz::Europe_Zurich, CountryId{"CH"}}, // Avenches Station
    {Coordinate{7.07459, 46.9082}, Tz::Europe_Zurich, CountryId{"CH"}}, // Faoug Station
    {Coordinate{7.1532, 46.9509}, Tz::Europe_Zurich, CountryId{"CH"}}, // Galmiz Station
    {Coordinate{7.13325, 46.938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muntelier-Löwenberg Station
    {Coordinate{6.67656, 46.9424}, Tz::Europe_Zurich, CountryId{"CH"}}, // Travers Station
    {Coordinate{6.7218, 46.9549}, Tz::Europe_Zurich, CountryId{"CH"}}, // Noiraigue Station
    {Coordinate{6.77498, 46.9599}, Tz::Europe_Zurich, CountryId{"CH"}}, // Champ-du-Moulin Station
    {Coordinate{6.83769, 46.969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bôle Station
    {Coordinate{6.89915, 46.9855}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Deurres Station
    {Coordinate{6.88381, 46.9833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corcelles-Peseux Station
    {Coordinate{6.81225, 46.9671}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chambrelien Station
    {Coordinate{6.84284, 46.9914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montmollin-Montezillon Station
    {Coordinate{6.85321, 47.0151}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Geneveys-sur-Coffrane Station
    {Coordinate{6.87467, 47.0472}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Hauts-Geneveys Station
    {Coordinate{7.25752, 47.1694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frinvillier-Taubenloch Station
    {Coordinate{7.24701, 47.1897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reuchenette-Péry Station
    {Coordinate{7.22539, 47.1895}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Heutte Station
    {Coordinate{7.14465, 47.1934}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corgémont Station
    {Coordinate{7.1073, 47.1893}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cortébert Station
    {Coordinate{7.0688, 47.1756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtelary Station
    {Coordinate{7.05412, 47.1729}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cormoret Station
    {Coordinate{7.01967, 47.1602}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villeret Station
    {Coordinate{7.00121, 47.1517}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Imier Station
    {Coordinate{6.96934, 47.1413}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sonvilier Station
    {Coordinate{6.92537, 47.1257}, Tz::Europe_Zurich, CountryId{"CH"}}, // Renan BE Station
    {Coordinate{7.26117, 47.0402}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bargen Station
    {Coordinate{7.45194, 47.0214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchenbuchsee Station
    {Coordinate{7.386, 47.0418}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schüpfen Station
    {Coordinate{9.07024, 47.383}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lütisburg, Restaurant Bahnhof Station
    {Coordinate{7.33899, 47.0588}, Tz::Europe_Zurich, CountryId{"CH"}}, // Suberg-Grossaffoltern Station
    {Coordinate{7.31862, 47.0987}, Tz::Europe_Zurich, CountryId{"CH"}}, // Busswil Station
    {Coordinate{7.27821, 47.1236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brügg BE Station
    {Coordinate{7.30174, 47.1104}, Tz::Europe_Zurich, CountryId{"CH"}}, // Studen BE Station
    {Coordinate{9.24694, 47.6289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Landschlacht Station
    {Coordinate{8.85373, 47.6593}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hemishofen Station
    {Coordinate{8.82115, 47.7074}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ramsen Station
    {Coordinate{9.10875, 47.6629}, Tz::Europe_Zurich, CountryId{"CH"}}, // Triboltingen Station
    {Coordinate{9.19635, 47.6431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kurzrickenbach Seepark Station
    {Coordinate{9.227, 47.6334}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsterlingen-Scherzingen Station
    {Coordinate{9.21308, 47.6407}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bottighofen Station
    {Coordinate{9.18196, 47.6492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kreuzlingen Hafen Station
    {Coordinate{9.13296, 47.6596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägerwilen-Gottlieben Station
    {Coordinate{9.23611, 47.632}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsterlingen Spital Station
    {Coordinate{9.0783, 47.3446}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietfurt Station
    {Coordinate{9.07514, 47.3596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bütschwil Station
    {Coordinate{9.07067, 47.3838}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lütisburg Station
    {Coordinate{9.06904, 47.4101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bazenheid Station
    {Coordinate{7.48149, 46.9568}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ostermundigen Station
    {Coordinate{7.5055, 46.9343}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gümligen Station
    {Coordinate{7.54537, 46.8992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rubigen Station
    {Coordinate{7.55943, 46.8733}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsingen Station
    {Coordinate{7.56885, 46.8416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wichtrach Station
    {Coordinate{7.57549, 46.8189}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kiesen Station
    {Coordinate{7.58262, 46.7943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uttigen Station
    {Coordinate{7.49892, 47.0189}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönbühl SBB Station
    {Coordinate{7.5454, 47.0496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hindelbank Station
    {Coordinate{7.58131, 47.0638}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lyssach Station
    {Coordinate{7.56484, 46.9152}, Tz::Europe_Zurich, CountryId{"CH"}}, // Worb SBB Station
    {Coordinate{7.58083, 46.8823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägertschi Station
    {Coordinate{7.66288, 46.8997}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zäziwil Station
    {Coordinate{7.69805, 46.9}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bowil Station
    {Coordinate{7.72545, 46.9196}, Tz::Europe_Zurich, CountryId{"CH"}}, // Signau Station
    {Coordinate{7.74729, 46.9482}, Tz::Europe_Zurich, CountryId{"CH"}}, // Emmenmatt Station
    {Coordinate{7.84613, 46.9217}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trubschachen Station
    {Coordinate{7.93636, 46.9153}, Tz::Europe_Zurich, CountryId{"CH"}}, // Escholzmatt Station
    {Coordinate{8.01514, 46.9506}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schüpfheim Station
    {Coordinate{8.04696, 46.9781}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hasle LU Station
    {Coordinate{8.06235, 46.9937}, Tz::Europe_Zurich, CountryId{"CH"}}, // Entlebuch Station
    {Coordinate{8.07975, 47.0555}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wolhusen Station
    {Coordinate{8.10185, 47.057}, Tz::Europe_Zurich, CountryId{"CH"}}, // Werthenstein Station
    {Coordinate{8.14325, 47.038}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schachen LU Station
    {Coordinate{8.18195, 47.0386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Malters Station
    {Coordinate{8.2571, 47.0531}, Tz::Europe_Zurich, CountryId{"CH"}}, // Littau Station
    {Coordinate{8.51776, 47.1885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baar Neufeld Station
    {Coordinate{7.46547, 46.9678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Wankdorf Station
    {Coordinate{6.12608, 46.1767}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genève-Stade Station
    {Coordinate{8.24882, 47.5821}, Tz::Europe_Zurich, CountryId{"CH"}}, // Klingnau Station
    {Coordinate{8.28058, 47.1806}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baldegg Kloster Station
    {Coordinate{8.47969, 47.1879}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinhausen Rigiblick Station
    {Coordinate{7.29662, 47.073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lyss Grien Station
    {Coordinate{7.29459, 47.1584}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel/Bienne Bözingenfeld/Champs-de-Boujean Station
    {Coordinate{8.61746, 47.6796}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuhausen Rheinfall Station
    {Coordinate{7.52143, 47.2089}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn Allmend Station
    {Coordinate{7.15543, 46.8147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fribourg/Freiburg Poya Station
    {Coordinate{7.31249, 51.3167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gevelsberg West station
    {Coordinate{6.90667, 53.3319}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delfzijl West railway station
    {Coordinate{4.68611, 52.4947}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heemskerk railway station
    {Coordinate{7.31389, 51.4778}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum-Langendreer station
    {Coordinate{9.7925, 52.3172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover Messe/Laatzen station
    {Coordinate{13.1272, 52.3944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Griebnitzsee railway station
    {Coordinate{11.5658, 48.1392}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Karlsplatz station
    {Coordinate{13.4507, 48.574}, Tz::Europe_Berlin, CountryId{"DE"}}, // Passau Central Station
    {Coordinate{13.2264, 49.0208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zwiesel station
    {Coordinate{13.2325, 52.4375}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Mexikoplatz station
    {Coordinate{7.17306, 51.4}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattingen (Ruhr) station
    {Coordinate{11.9233, 50.3081}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hof Central Station
    {Coordinate{7.41589, 51.4584}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Kruckel station
    {Coordinate{4.43306, 50.9244}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vilvoorde railway station
    {Coordinate{7.2025, 50.7938}, Tz::Europe_Berlin, CountryId{"DE"}}, // Siegburg/Bonn station
    {Coordinate{7.1597, 50.6838}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn-Bad Godesberg
    {Coordinate{7.46889, 51.5079}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund Stadthaus station
    {Coordinate{8.57556, 52.2036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bünde station
    {Coordinate{8.31286, 50.1596}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niedernhausen station
    {Coordinate{12.4436, 50.9975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenburg station
    {Coordinate{8.58992, 49.1239}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bruchsal station
    {Coordinate{8.4905, 49.1619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Graben-Neudorf station
    {Coordinate{11.5336, 48.1333}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Heimeranplatz station
    {Coordinate{4.06889, 51.1433}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sinaai railway station
    {Coordinate{10.5397, 52.2522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Braunschweig Central Station
    {Coordinate{10.0961, 48.8408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aalen station
    {Coordinate{13.5237, 51.2913}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großenhain Cottbuser station
    {Coordinate{11.5781, 50.9233}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena West station
    {Coordinate{7.21778, 51.5436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herne station
    {Coordinate{10.9903, 49.47}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fürth Hauptbahnhof
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q31972218
    {Coordinate{13.361, 52.4864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Julius-Leber-Brücke station
    {Coordinate{11.2125, 49.2622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Allersberg (Rothsee) station
    {Coordinate{10.3314, 50.9764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eisenach station
    {Coordinate{9.0475, 52.2675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bückeburg station
    {Coordinate{8.90861, 50.1322}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hanau West station
    {Coordinate{8.43417, 49.4778}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigshafen Central Station
    {Coordinate{8.14056, 49.35}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt Central Station
    {Coordinate{9.92694, 51.5367}, Tz::Europe_Berlin, CountryId{"DE"}}, // Göttingen station
    {Coordinate{7.33417, 51.5008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Lütgendortmund station
    {Coordinate{13.0772, 54.3086}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stralsund Central Station
    {Coordinate{10.2064, 53.4894}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Bergedorf station
    {Coordinate{6.25222, 50.8133}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eschweiler Central Station
    {Coordinate{7.32167, 52.5194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lingen (Ems) station
    {Coordinate{13.5364, 52.5272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Springpfuhl station
    {Coordinate{8.27778, 49.9933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz Römisches Theater station
    {Coordinate{7.0137, 50.9587}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Mülheim station
    {Coordinate{8.35687, 49.6347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Worms Central Station
    {Coordinate{11.9867, 51.4781}, Tz::Europe_Berlin, CountryId{"DE"}}, // Halle Central Station
    {Coordinate{8.45306, 49.4792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigshafen (Rhein) Mitte station
    {Coordinate{11.4325, 48.7732}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ingolstadt Nord station
    {Coordinate{12.13, 50.5053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plauen (Vogtland) Oberer Bahnhof
    {Coordinate{10.9483, 50.8417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Arnstadt Central Station
    {Coordinate{6.07111, 50.78}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen West station
    {Coordinate{11.5878, 50.925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena Paradies station
    {Coordinate{8.66436, 52.1193}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herford railway station
    {Coordinate{7.19556, 53.3689}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emden Central Station
    {Coordinate{12.2955, 50.6275}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reichenbach (Vogtland) Oberer station
    {Coordinate{7.43146, 51.4774}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Barop station
    {Coordinate{7.41751, 51.4922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund University station
    {Coordinate{7.041, 50.9763}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Holweide station
    {Coordinate{14.4289, 51.1728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bautzen railway station
    {Coordinate{8.71306, 52.1972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löhne station
    {Coordinate{15.9857, 48.4018}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q32076233
    {Coordinate{6.4825, 50.8108}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düren station
    {Coordinate{7.2195, 50.6037}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unkel station
    {Coordinate{11.7628, 53.0019}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wittenberge station
    {Coordinate{11.1689, 50.3553}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sonneberg Central Station
    {Coordinate{11.3747, 50.6508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saalfeld station
    {Coordinate{12.0772, 50.8831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gera Hauptbahnhof
    {Coordinate{11.3269, 50.9917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weimar station
    {Coordinate{8.61677, 49.6824}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bensheim station
    {Coordinate{13.2836, 52.5078}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Messe Nord/ICC station
    {Coordinate{4.54167, 50.8928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kortenberg railway station
    {Coordinate{9.96719, 53.5638}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sternschanze station
    {Coordinate{12.104, 49.3266}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwandorf station
    {Coordinate{7.19944, 51.1772}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid Central Station
    {Coordinate{9.21778, 48.8017}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Bad Cannstatt station
    {Coordinate{9.52639, 48.8069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schorndorf station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q32173155
    {Coordinate{1.22494, 49.2755}, Tz::Europe_Paris, CountryId{"FR"}}, // Q321927
    {Coordinate{7.10728, 51.2435}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal Zoologischer Garten station
    {Coordinate{11.359, 49.309}, Tz::Europe_Berlin, CountryId{"DE"}}, // Postbauer-Heng station
    {Coordinate{9.9925, 53.5536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jungfernstieg
    {Coordinate{10.5531, 52.9697}, Tz::Europe_Berlin, CountryId{"DE"}}, // Uelzen station
    {Coordinate{7.12444, 50.9914}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bergisch Gladbach station
    {Coordinate{8.70299, 48.8937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pforzheim Central Station
    {Coordinate{10.9622, 51.7953}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankenburg (Harz) station
    {Coordinate{7.11059, 49.2745}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sankt Ingbert station
    {Coordinate{7.14, 51.4736}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wattenscheid station
    {Coordinate{7.72139, 52.2769}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ibbenbüren station
    {Coordinate{8.94222, 51.7664}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenbeken station
    {Coordinate{11.4573, 49.2733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neumarkt (Oberpfalz) station
    {Coordinate{6.35517, 50.8174}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langerwehe station
    {Coordinate{6.21944, 50.7947}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stolberg Central Station
    {Coordinate{6.4125, 51.4356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3226468
    {Coordinate{8.62111, 50.2199}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Homburg station
    {Coordinate{9.20794, 49.1428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heilbronn Central Station
    {Coordinate{9.84222, 48.6189}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geislingen (Steige) station
    {Coordinate{7.40333, 50.4356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Andernach station
    {Coordinate{8.29444, 50.735}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dillenburg station
    {Coordinate{8.09611, 50.3822}, Tz::Europe_Berlin, CountryId{"DE"}}, // Limburg Süd station
    {Coordinate{7.07143, 51.2341}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Vohwinkel station
    {Coordinate{7.19564, 51.5629}, Tz::Europe_Berlin, CountryId{"DE"}}, // Recklinghausen Süd station
    {Coordinate{9.78833, 48.8011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwäbisch Gmünd station
    {Coordinate{6.79772, 51.2296}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Wehrhahn station
    {Coordinate{7.52928, 51.6172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lünen Central Station
    {Coordinate{6.86111, 51.1808}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Reisholz station
    {Coordinate{6.78866, 51.2771}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Unterrath station
    {Coordinate{6.82106, 51.2643}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Rath station
    {Coordinate{6.80917, 51.208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Oberbilk station
    {Coordinate{13.2844, 52.5181}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Westend station
    {Coordinate{13.3292, 52.5344}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Beusselstraße station
    {Coordinate{7.28929, 51.2906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwelm station
    {Coordinate{6.1163, 50.7703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen-Rothe Erde station
    {Coordinate{6.86325, 51.2202}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Gerresheim station
    {Coordinate{7.44604, 50.7737}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eitorf station
    {Coordinate{13.5164, 51.4592}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elsterwerda railway station
    {Coordinate{9.21806, 52.6447}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nienburg station
    {Coordinate{6.76833, 51.2792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Airport Terminal station
    {Coordinate{8.38472, 51.9069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gütersloh Central Station
    {Coordinate{6.79692, 51.2365}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Zoo station
    {Coordinate{8.83417, 54.7889}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niebüll railway station
    {Coordinate{6.73964, 51.2105}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Hamm station
    {Coordinate{13.5414, 52.4347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Adlershof station
    {Coordinate{6.83633, 51.1979}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Eller Süd station
    {Coordinate{6.79458, 51.2475}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Derendorf station
    {Coordinate{6.78194, 51.3311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Angermund station
    {Coordinate{6.77631, 51.208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Bilk station
    {Coordinate{7.28422, 50.7733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hennef (Sieg) station
    {Coordinate{13.8672, 53.3219}, Tz::Europe_Berlin, CountryId{"DE"}}, // Prenzlau railway station
    {Coordinate{7.25722, 51.1925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid-Lennep station
    {Coordinate{8.63306, 50.0681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Stadion station
    {Coordinate{9.30056, 48.8261}, Tz::Europe_Berlin, CountryId{"DE"}}, // Waiblingen station
    {Coordinate{6.83833, 51.2019}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Eller station
    {Coordinate{8.06667, 50.3833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Limburg (Lahn) station
    {Coordinate{14.9792, 51.1472}, Tz::Europe_Berlin, CountryId{"DE"}}, // Görlitz station
    {Coordinate{8.79611, 52.205}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Oeynhausen station
    {Coordinate{8.66583, 50.0528}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu-Isenburg station
    {Coordinate{6.89775, 51.1435}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Garath station
    {Coordinate{9.53778, 54.5}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schleswig station
    {Coordinate{7.45169, 51.5071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund Möllerbrücke station
    {Coordinate{6.95263, 50.9491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Hansaring station
    {Coordinate{6.93674, 51.5095}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bottrop Central Station
    {Coordinate{7.4252, 51.5094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Dorstfeld station
    {Coordinate{7.69222, 51.5389}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unna station
    {Coordinate{10.8514, 53.1678}, Tz::Europe_Berlin, CountryId{"DE"}}, // Göhrde station
    {Coordinate{6.76056, 51.21}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Völklinger Straße station
    {Coordinate{6.81, 51.2261}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Flingern station
    {Coordinate{7.23025, 50.5771}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remagen station
    {Coordinate{13.0944, 51.1314}, Tz::Europe_Berlin, CountryId{"DE"}}, // Döbeln Central Station
    {Coordinate{8.66528, 49.5533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weinheim (Bergstraße) station
    {Coordinate{6.80833, 51.2611}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Rath Mitte station
    {Coordinate{8.95832, 48.947}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vaihingen (Enz) station
    {Coordinate{13.4897, 52.4675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Baumschulenweg station
    {Coordinate{8.01611, 50.8756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Siegen Hauptbahnhof
    {Coordinate{11.4667, 53.7667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Kleinen station
    {Coordinate{9.41167, 48.7131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plochingen station
    {Coordinate{8.64333, 50.1119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Messe station
    {Coordinate{9.71597, 50.87}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Hersfeld station
    {Coordinate{7.00854, 51.4044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Hügel station
    {Coordinate{11.0597, 50.1461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lichtenfels station
    {Coordinate{10.7717, 48.7144}, Tz::Europe_Berlin, CountryId{"DE"}}, // Donauwörth station
    {Coordinate{9.18583, 50.9103}, Tz::Europe_Berlin, CountryId{"DE"}}, // Treysa station
    {Coordinate{9.95389, 52.1606}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hildesheim Central Station
    {Coordinate{13.5746, 52.4122}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Grünau station
    {Coordinate{8.645, 50.1039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Galluswarte station
    {Coordinate{8.6418, 48.1648}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rottweil station
    {Coordinate{9.37611, 52.1019}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamelin station
    {Coordinate{7.33694, 49.3278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Homburg Central Station
    {Coordinate{8.6641, 49.2909}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wiesloch-Walldorf station
    {Coordinate{14.3264, 51.7508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cottbus station
    {Coordinate{12.3547, 52.6}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rathenow railway station
    {Coordinate{7.46528, 53.2311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leer (Ostfriesl) railway station
    {Coordinate{12.4768, 50.7151}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zwickau Hauptbahnhof
    {Coordinate{4.37861, 51.2919}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerpen-Haven railway station
    {Coordinate{8.58828, 50.1989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberursel station
    {Coordinate{9.7, 50.05}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gemünden station
    {Coordinate{12.2226, 51.4234}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig/Halle Airport station
    {Coordinate{8.50343, 50.1432}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Soden (Taunus) station
    {Coordinate{7.895, 51.7617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahlen (Westfalen) station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Böckstein
    {Coordinate{9.05585, 48.5158}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tübingen Central Station
    {Coordinate{15.8203, 47.6601}, Tz::Europe_Vienna, CountryId{"AT"}}, // Breitenstein station
    {Coordinate{4.51972, 51.8939}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Stadion railway station
    {Coordinate{12.9251, 47.9819}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Bürmoos
    {Coordinate{9.7979, 50.9692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bebra station
    {Coordinate{13.4261, 52.5447}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Prenzlauer Allee station
    {Coordinate{13.398, 52.5543}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Bornholmer Straße station
    {Coordinate{11.6453, 48.0889}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Neuperlach Süd station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q32800339
    {Coordinate{9.90667, 53.5958}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eidelstedt station
    {Coordinate{5.79361, 52.0053}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wolfheze railway station
    {Coordinate{9.1994, 49.232}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Friedrichshall-Jagstfeld station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q33216113
    {Coordinate{7.51301, 47.2179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langendorf station
    {Coordinate{7.75, 47.4511}, Tz::Europe_Zurich, CountryId{"CH"}}, // Talhaus station
    {Coordinate{7.74471, 47.4764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altmarkt station
    {Coordinate{7.74154, 47.4596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bubendorf station
    {Coordinate{7.76121, 47.4425}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lampenberg-Ramlinsburg station
    {Coordinate{7.77113, 47.4274}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hölstein station
    {Coordinate{7.75185, 47.4044}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederdorf station
    {Coordinate{7.7489, 47.3921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberdorf BL station
    {Coordinate{7.74884, 47.3863}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waldenburg station
    {Coordinate{7.74882, 47.3971}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberdorf BL Winkelweg station
    {Coordinate{7.76781, 47.423}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hölstein Süd station
    {Coordinate{7.76347, 47.4188}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hölstein Weidbächli station
    {Coordinate{7.75518, 47.4101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hirschlang station
    {Coordinate{7.11268, 47.2224}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tramelan-Dessous station
    {Coordinate{7.09244, 47.2235}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tramelan-Chalet station
    {Coordinate{7.05627, 47.222}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Pied-d'Or station
    {Coordinate{7.0024, 47.2131}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Breuleux-Eglise station
    {Coordinate{6.98547, 47.2437}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muriaux station
    {Coordinate{7.10557, 47.2228}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tramelan station
    {Coordinate{7.08344, 47.2242}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Reussilles station
    {Coordinate{7.02519, 47.2204}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-des-Breuleux station
    {Coordinate{7.00516, 47.2104}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Breuleux station
    {Coordinate{6.95685, 47.2237}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Noirmont station
    {Coordinate{6.94065, 47.2035}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Creux-des-Biches station
    {Coordinate{6.9221, 47.1942}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Boéchet station
    {Coordinate{6.90617, 47.1769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Bois station
    {Coordinate{6.89453, 47.1427}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Ferrière station
    {Coordinate{6.88366, 47.1221}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Cibourg station
    {Coordinate{6.8967, 47.1613}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Large-Journée station
    {Coordinate{6.89871, 47.1527}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-d'Abel station
    {Coordinate{6.88586, 47.1337}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Seignat station
    {Coordinate{6.83716, 47.1035}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-de-Fonds-Est station
    {Coordinate{7.15665, 47.4525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vendlincourt station
    {Coordinate{7.15539, 47.474}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bonfol station
    {Coordinate{6.98531, 47.2323}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Emibois station
    {Coordinate{6.9945, 47.2547}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saignelégier station
    {Coordinate{7.01425, 47.2633}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Bémont station
    {Coordinate{7.1001, 47.2849}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Combe station
    {Coordinate{7.15844, 47.3138}, Tz::Europe_Zurich, CountryId{"CH"}}, // Combe-Tabeillon station
    {Coordinate{7.45663, 47.2726}, Tz::Europe_Zurich, CountryId{"CH"}}, // Crémines-Zoo station
    {Coordinate{7.46949, 47.2186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lommiswil station
    {Coordinate{7.47501, 47.2309}, Tz::Europe_Zurich, CountryId{"CH"}}, // Im Holz station
    {Coordinate{7.49376, 47.236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberdorf SO station
    {Coordinate{7.46519, 47.2655}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gänsbrunnen station
    {Coordinate{7.45035, 47.2856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corcelles BE station
    {Coordinate{7.43531, 47.2856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Crémines station
    {Coordinate{7.4223, 47.2837}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandval station
    {Coordinate{7.54535, 47.2123}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn Sternen halt
    {Coordinate{7.54978, 47.2161}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Katharinen station
    {Coordinate{7.55585, 47.2207}, Tz::Europe_Zurich, CountryId{"CH"}}, // Feldbrunnen halt
    {Coordinate{7.56658, 47.2284}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bei den Weihern station
    {Coordinate{7.54189, 47.21}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn Baseltor halt
    {Coordinate{7.57267, 47.231}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riedholz halt
    {Coordinate{7.59667, 47.2392}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flumenthal halt
    {Coordinate{7.61387, 47.2464}, Tz::Europe_Zurich, CountryId{"CH"}}, // Attiswil station
    {Coordinate{7.6461, 47.2529}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wiedlisbach station
    {Coordinate{7.66097, 47.2596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberbipp station
    {Coordinate{7.67838, 47.2636}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchli station
    {Coordinate{7.69475, 47.3035}, Tz::Europe_Zurich, CountryId{"CH"}}, // Klus station
    {Coordinate{7.68822, 47.3085}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thalbrücke station
    {Coordinate{7.69391, 47.3129}, Tz::Europe_Zurich, CountryId{"CH"}}, // Balsthal station
    {Coordinate{6.21726, 46.3989}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Vuarpillière station
    {Coordinate{6.48447, 46.5065}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Gottaz station
    {Coordinate{6.12688, 46.4512}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Pralies station
    {Coordinate{6.20587, 46.4385}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sus-Châtel station
    {Coordinate{6.18352, 46.4485}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chèvrerie-Monteret station
    {Coordinate{6.21677, 46.4463}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Joy-Clinique station
    {Coordinate{6.22904, 46.3911}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Plantaz station
    {Coordinate{6.07358, 46.4651}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Cure station
    {Coordinate{6.16037, 46.4486}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Cergue station
    {Coordinate{6.21166, 46.4586}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arzier station
    {Coordinate{6.22232, 46.4606}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bassins station
    {Coordinate{6.21544, 46.4543}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Muids station
    {Coordinate{6.21457, 46.4362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genolier station
    {Coordinate{6.20523, 46.4288}, Tz::Europe_Zurich, CountryId{"CH"}}, // Givrins station
    {Coordinate{6.20643, 46.4137}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trélex station
    {Coordinate{6.21176, 46.4018}, Tz::Europe_Zurich, CountryId{"CH"}}, // L'Asse station
    {Coordinate{6.46259, 46.5275}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Marais station
    {Coordinate{6.47226, 46.516}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chigny station
    {Coordinate{6.43257, 46.5347}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chardonney-Château station
    {Coordinate{6.43098, 46.5404}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reverolle station
    {Coordinate{6.43218, 46.5591}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Manège station
    {Coordinate{6.39024, 46.5496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ballens-Froideville station
    {Coordinate{6.42973, 46.5849}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mauraz station
    {Coordinate{6.41422, 46.5928}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tuilerie station
    {Coordinate{6.40236, 46.6105}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villars-Bozon station
    {Coordinate{6.48027, 46.5095}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prélionne station
    {Coordinate{6.47318, 46.5248}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vufflens-le-Château station
    {Coordinate{6.44652, 46.5268}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bussy-Chardonney station
    {Coordinate{6.42733, 46.5199}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yens station
    {Coordinate{6.37446, 46.5522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ballens station
    {Coordinate{6.43217, 46.577}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pampigny-Sévery station
    {Coordinate{6.39305, 46.5963}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montricher station
    {Coordinate{6.32466, 46.6687}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Pont station
    {Coordinate{6.31709, 46.6643}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Charbonnières station
    {Coordinate{6.30601, 46.6585}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Séchey station
    {Coordinate{6.28345, 46.6469}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Lieu station
    {Coordinate{6.26052, 46.632}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Esserts-de-Rive station
    {Coordinate{6.2503, 46.6245}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Rocheray station
    {Coordinate{6.23904, 46.6144}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solliat-Golisse station
    {Coordinate{6.23139, 46.6058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sentier-Orient station
    {Coordinate{6.21429, 46.5858}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Brassus station
    {Coordinate{6.98653, 46.3199}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pont-de-Drapel station
    {Coordinate{7.1417, 46.4763}, Tz::Europe_Zurich, CountryId{"CH"}}, // Château-d'Oex La Palaz station
    {Coordinate{7.00149, 46.3313}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Roulaz station
    {Coordinate{6.94593, 46.2602}, Tz::Europe_Zurich, CountryId{"CH"}}, // Monthey-En Place station
    {Coordinate{6.85264, 46.4714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gilamont station
    {Coordinate{6.85492, 46.4678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Clies station
    {Coordinate{6.8609, 46.4663}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hauteville station
    {Coordinate{6.8653, 46.4685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Château-d'Hauteville station
    {Coordinate{6.87657, 46.471}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Légier-Village station
    {Coordinate{6.88214, 46.4695}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chiésaz station
    {Coordinate{6.89176, 46.4683}, Tz::Europe_Zurich, CountryId{"CH"}}, // Château-de-Blonay station
    {Coordinate{6.87193, 46.4705}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Légier-Gare station
    {Coordinate{6.89595, 46.4657}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blonay station
    {Coordinate{6.89794, 46.4688}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prélaz-sur-Blonay station
    {Coordinate{6.89626, 46.4739}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tusinge station
    {Coordinate{6.89813, 46.4756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Chevalleyres station
    {Coordinate{6.90764, 46.47}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fayaux station
    {Coordinate{6.91396, 46.4732}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ondallaz-L'Alliaz station
    {Coordinate{6.91403, 46.4792}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lally station
    {Coordinate{6.90994, 46.4834}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Pléiades station
    {Coordinate{6.91241, 46.4538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chamby-Musée station
    {Coordinate{6.90234, 46.4527}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fontanivent station
    {Coordinate{6.91009, 46.4459}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chernex station
    {Coordinate{6.9135, 46.4492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chamby station
    {Coordinate{6.94333, 46.4538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Avants station
    {Coordinate{7.00789, 46.4698}, Tz::Europe_Zurich, CountryId{"CH"}}, // Allières station
    {Coordinate{7.03422, 46.4915}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Sciernes station
    {Coordinate{6.91272, 46.4361}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montreux-Collège station
    {Coordinate{6.91097, 46.4391}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vuarennes station
    {Coordinate{6.90115, 46.4468}, Tz::Europe_Zurich, CountryId{"CH"}}, // Châtelard VD station
    {Coordinate{6.901, 46.4512}, Tz::Europe_Zurich, CountryId{"CH"}}, // Planchamp station
    {Coordinate{6.92121, 46.439}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sonzier station
    {Coordinate{6.92908, 46.4466}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sendy-Sollard station
    {Coordinate{6.99772, 46.4559}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Cases station
    {Coordinate{7.17183, 46.4775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Combes station
    {Coordinate{6.90613, 46.442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Belmont-sur-Montreux station
    {Coordinate{7.04658, 46.4672}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Tine station
    {Coordinate{7.08324, 46.4648}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rossinière station
    {Coordinate{7.0969, 46.4661}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaudanne-Les Moulins station
    {Coordinate{7.13142, 46.4747}, Tz::Europe_Zurich, CountryId{"CH"}}, // Château-d'Oex station
    {Coordinate{7.15573, 46.4739}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Granges-Gérignoz station
    {Coordinate{7.18607, 46.4821}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flendruz station
    {Coordinate{7.20896, 46.4886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rougemont station
    {Coordinate{7.26028, 46.4886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saanen station
    {Coordinate{7.28441, 46.4748}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gstaad station
    {Coordinate{7.0755, 46.3091}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villars-sur-Ollon Golf station
    {Coordinate{7.06111, 46.2938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roches Grises station
    {Coordinate{6.8715, 46.1749}, Tz::Europe_Zurich, CountryId{"CH"}}, // Champéry station
    {Coordinate{6.97373, 46.2782}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Triphon-Gare station
    {Coordinate{6.88669, 46.1942}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Cour station
    {Coordinate{6.89952, 46.2121}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fayot station
    {Coordinate{6.93007, 46.2436}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chemex station
    {Coordinate{6.94076, 46.2519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Monthey-Hôpital station
    {Coordinate{6.99441, 46.2869}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villy station
    {Coordinate{6.9758, 46.3021}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Triphon-Village station
    {Coordinate{6.92746, 46.2397}, Tz::Europe_Zurich, CountryId{"CH"}}, // Croix-du-Nant station
    {Coordinate{6.99311, 46.2968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ollon station
    {Coordinate{6.94603, 46.2702}, Tz::Europe_Zurich, CountryId{"CH"}}, // Collombey-Muraz station
    {Coordinate{6.94751, 46.2541}, Tz::Europe_Zurich, CountryId{"CH"}}, // Monthey-Ville station
    {Coordinate{6.91582, 46.2283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Troistorrents station
    {Coordinate{6.89323, 46.2036}, Tz::Europe_Zurich, CountryId{"CH"}}, // Val-d'Illiez station
    {Coordinate{6.87486, 46.1815}, Tz::Europe_Zurich, CountryId{"CH"}}, // Champéry-Village station
    {Coordinate{6.98056, 46.3164}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aigle-Dépôt ASD station
    {Coordinate{7.04546, 46.3431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Fontanelles station
    {Coordinate{6.98367, 46.3082}, Tz::Europe_Zurich, CountryId{"CH"}}, // Verchiez station
    {Coordinate{7.02398, 46.3273}, Tz::Europe_Zurich, CountryId{"CH"}}, // Plambuit station
    {Coordinate{7.03849, 46.3371}, Tz::Europe_Zurich, CountryId{"CH"}}, // Exergillod station
    {Coordinate{7.05527, 46.3553}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Planches (Aigle) station
    {Coordinate{7.0528, 46.3612}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Sépey station
    {Coordinate{7.08506, 46.3554}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Echenards station
    {Coordinate{7.11317, 46.353}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Aviolats station
    {Coordinate{7.13415, 46.3536}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vers-l'Eglise station
    {Coordinate{7.15502, 46.3512}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Diablerets station
    {Coordinate{7.00088, 46.3274}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rennaz (Leysin) station
    {Coordinate{7.00606, 46.3393}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leysin-Village station
    {Coordinate{7.00837, 46.3444}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leysin-Feydey station
    {Coordinate{7.00644, 46.3456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leysin-Grand-Hôtel station
    {Coordinate{6.97538, 46.3183}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aigle-Dépôt station
    {Coordinate{6.98231, 46.3183}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fontanney station
    {Coordinate{7.01444, 46.2509}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bex-Place-du-Marché station
    {Coordinate{7.03089, 46.259}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bévieux station
    {Coordinate{7.05586, 46.2676}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fontannaz-Seulaz station
    {Coordinate{7.0509, 46.2712}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Posses station
    {Coordinate{7.05972, 46.2736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gryon station
    {Coordinate{7.0705, 46.2827}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Barboleuse station
    {Coordinate{7.0627, 46.2912}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arveyes station
    {Coordinate{7.05624, 46.2963}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villars-sur-Ollon station
    {Coordinate{7.06955, 46.3049}, Tz::Europe_Zurich, CountryId{"CH"}}, // Col-de-Soud station
    {Coordinate{7.07235, 46.3164}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bouquetins station
    {Coordinate{7.07362, 46.3219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Col-de-Bretaye station
    {Coordinate{6.94633, 46.0669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Montuires station
    {Coordinate{6.97035, 46.3172}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aigle-Place-du-Marché station
    {Coordinate{7.04493, 46.1301}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vernayaz MC station
    {Coordinate{7.02105, 46.1216}, Tz::Europe_Zurich, CountryId{"CH"}}, // Salvan station
    {Coordinate{7.01169, 46.1123}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Marécottes station
    {Coordinate{6.9977, 46.1023}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Trétien station
    {Coordinate{6.97638, 46.0823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Finhaut station
    {Coordinate{6.95802, 46.0603}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Châtelard VS station
    {Coordinate{6.95061, 46.0537}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Châtelard-Frontière station
    {Coordinate{7.9163, 46.2968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eyholz railway station
    {Coordinate{7.88183, 46.2938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Visp MGB-bvz railway station
    {Coordinate{8.32624, 46.5134}, Tz::Europe_Zurich, CountryId{"CH"}}, // Obergesteln railway station
    {Coordinate{8.30882, 46.505}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ulrichen railway station
    {Coordinate{8.28211, 46.4917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Geschinen railway station
    {Coordinate{8.26654, 46.4854}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münster VS railway station
    {Coordinate{8.24388, 46.4682}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reckingen railway station
    {Coordinate{8.23391, 46.4628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gluringen railway station
    {Coordinate{8.21942, 46.4551}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel (Goms) railway station
    {Coordinate{8.20497, 46.4447}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blitzingen railway station
    {Coordinate{8.19022, 46.4353}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederwald railway station
    {Coordinate{8.15232, 46.4119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fürgangen-Bellwald Talstation railway station
    {Coordinate{8.11715, 46.387}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lax railway station
    {Coordinate{8.09168, 46.3752}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grengiols railway station
    {Coordinate{8.07652, 46.3712}, Tz::Europe_Zurich, CountryId{"CH"}}, // Betten Talstation railway station
    {Coordinate{8.04714, 46.3562}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mörel railway station
    {Coordinate{8.01722, 46.3361}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bitsch railway station
    {Coordinate{7.87077, 46.232}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stalden-Saas railway station
    {Coordinate{7.83697, 46.2141}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kalpetran railway station
    {Coordinate{7.80211, 46.1775}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Niklaus railway station
    {Coordinate{7.79164, 46.1321}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herbriggen railway station
    {Coordinate{7.78147, 46.0999}, Tz::Europe_Zurich, CountryId{"CH"}}, // Randa railway station
    {Coordinate{7.00696, 46.3414}, Tz::Europe_Zurich, CountryId{"CH"}}, // Versmont station
    {Coordinate{6.95145, 46.2722}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corbier station
    {Coordinate{7.06801, 46.2883}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Clairière station
    {Coordinate{8.13077, 46.3973}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fiesch Sport- & Feriencenter railway station
    {Coordinate{8.06958, 47.3897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchs AG station
    {Coordinate{8.09878, 47.3617}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gränichen station
    {Coordinate{8.11447, 47.3294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Teufenthal AG station
    {Coordinate{8.11512, 47.3101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterkulm station
    {Coordinate{8.12404, 47.2991}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberkulm station
    {Coordinate{8.14479, 47.2804}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gontenschwil station
    {Coordinate{8.15301, 47.2824}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zetzwil station
    {Coordinate{8.16786, 47.2727}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leimbach AG station
    {Coordinate{8.18088, 47.258}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reinach AG Nord station
    {Coordinate{8.18334, 47.2501}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reinach AG station
    {Coordinate{8.18931, 47.2409}, Tz::Europe_Zurich, CountryId{"CH"}}, // Menziken station
    {Coordinate{8.11354, 47.3435}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bleien Liebegg station
    {Coordinate{8.18338, 47.2545}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reinach AG Mitte station
    {Coordinate{8.05122, 47.3111}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schöftland Nordweg station
    {Coordinate{8.05562, 47.3289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Obermuhen station
    {Coordinate{8.05537, 47.3336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mittelmuhen station
    {Coordinate{8.05262, 47.3436}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muhen Nord station
    {Coordinate{8.04566, 47.3611}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberentfelden Uerkenbrücke station
    {Coordinate{8.04201, 47.3647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterentfelden Oberdorf station
    {Coordinate{8.11941, 47.3041}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberkulm Post station
    {Coordinate{8.10647, 47.3565}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gränichen Oberdorf station
    {Coordinate{8.34152, 47.3459}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bremgarten Isenlauf station
    {Coordinate{8.39894, 47.3934}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietikon Stoffelbach station
    {Coordinate{8.37703, 47.3647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rudolfstetten Hofacker station
    {Coordinate{8.3546, 47.3559}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zufikon Hammergut station
    {Coordinate{8.09204, 47.364}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gränichen Töndler station
    {Coordinate{8.05058, 47.3832}, Tz::Europe_Zurich, CountryId{"CH"}}, // Binzenhof station
    {Coordinate{8.04924, 47.3755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Distelberg station
    {Coordinate{8.04661, 47.3562}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberentfelden Engelplatz station
    {Coordinate{8.05361, 47.3395}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muhen station
    {Coordinate{8.04444, 47.3687}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterentfelden Post station
    {Coordinate{8.05281, 47.3199}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hirschthal station
    {Coordinate{8.05001, 47.3059}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schöftland station
    {Coordinate{8.34369, 47.3506}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bremgarten Obertor station
    {Coordinate{8.35923, 47.3576}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zufikon Belvédère station
    {Coordinate{8.31276, 47.3496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erdmannlistein station
    {Coordinate{8.39909, 47.3977}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bergfrieden station
    {Coordinate{8.28626, 47.3469}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wohlen Oberdorf station
    {Coordinate{8.33731, 47.3456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bremgarten West station
    {Coordinate{8.34655, 47.3515}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bremgarten station
    {Coordinate{8.35471, 47.3525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zufikon station
    {Coordinate{8.35478, 47.362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Widen Heinrüti station
    {Coordinate{8.36679, 47.3622}, Tz::Europe_Zurich, CountryId{"CH"}}, // Berikon-Widen station
    {Coordinate{8.38118, 47.3695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rudolfstetten station
    {Coordinate{8.39623, 47.3847}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reppischhof station
    {Coordinate{8.54813, 47.3664}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Stadelhofen FB station
    {Coordinate{8.69439, 47.296}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langwies ZH station
    {Coordinate{8.68961, 47.3015}, Tz::Europe_Zurich, CountryId{"CH"}}, // Egg station
    {Coordinate{8.68434, 47.3057}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hinteregg station
    {Coordinate{8.65955, 47.3226}, Tz::Europe_Zurich, CountryId{"CH"}}, // Scheuren station
    {Coordinate{8.62381, 47.3317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zumikon station
    {Coordinate{8.6034, 47.3461}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zollikerberg station
    {Coordinate{8.63107, 47.3282}, Tz::Europe_Zurich, CountryId{"CH"}}, // Maiacher station
    {Coordinate{8.70183, 47.2924}, Tz::Europe_Zurich, CountryId{"CH"}}, // Emmat station
    {Coordinate{8.67201, 47.3133}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuhaus bei Hinteregg station
    {Coordinate{8.63785, 47.3258}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neue Forch station
    {Coordinate{8.61703, 47.3368}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waltikon station
    {Coordinate{8.5968, 47.3473}, Tz::Europe_Zurich, CountryId{"CH"}}, // Spital Zollikerberg station
    {Coordinate{8.59302, 47.3455}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waldburg station
    {Coordinate{8.53917, 47.3774}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich HB SZU station
    {Coordinate{6.85324, 46.5258}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bossonnens station
    {Coordinate{6.87618, 46.5239}, Tz::Europe_Zurich, CountryId{"CH"}}, // Remaufens station
    {Coordinate{6.89875, 46.5261}, Tz::Europe_Zurich, CountryId{"CH"}}, // Châtel-St-Denis station
    {Coordinate{6.92693, 46.5733}, Tz::Europe_Zurich, CountryId{"CH"}}, // Semsales station
    {Coordinate{6.92488, 46.5875}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Verrerie station
    {Coordinate{6.98997, 46.6192}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vaulruz-Sud station
    {Coordinate{7.02017, 46.618}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vuadens-Sud station
    {Coordinate{7.06424, 46.6085}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Tour-Village station
    {Coordinate{7.07099, 46.6045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Epagny station
    {Coordinate{7.09127, 46.603}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Marches station
    {Coordinate{7.04264, 46.4859}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montbovon station
    {Coordinate{7.05255, 46.5074}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lessoc station
    {Coordinate{7.05542, 46.5179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Albeuve station
    {Coordinate{7.06157, 46.5283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neirivue station
    {Coordinate{7.07294, 46.5438}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandvillard station
    {Coordinate{7.08524, 46.5654}, Tz::Europe_Zurich, CountryId{"CH"}}, // Enney station
    {Coordinate{7.08654, 46.5734}, Tz::Europe_Zurich, CountryId{"CH"}}, // Estavannens station
    {Coordinate{7.07326, 46.5826}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gruyères station
    {Coordinate{7.05969, 46.5947}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Pâquier-Montbarry station
    {Coordinate{7.06144, 46.6056}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Tour-de-Trême station
    {Coordinate{7.05504, 46.6182}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bulle station
    {Coordinate{7.09874, 46.6041}, Tz::Europe_Zurich, CountryId{"CH"}}, // Broc-Village station
    {Coordinate{7.10933, 46.6054}, Tz::Europe_Zurich, CountryId{"CH"}}, // Broc-Fabrique station
    {Coordinate{7.13804, 46.9412}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muntelier station
    {Coordinate{7.11935, 46.9641}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sugiez station
    {Coordinate{7.31052, 46.8899}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flamatt Dorf station
    {Coordinate{7.29985, 46.8941}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuenegg station
    {Coordinate{6.6544, 46.9311}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Presta Mines d'asphalte station
    {Coordinate{6.63567, 46.9234}, Tz::Europe_Zurich, CountryId{"CH"}}, // Couvet station
    {Coordinate{6.61033, 46.9119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Môtiers station
    {Coordinate{6.58158, 46.9049}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fleurier station
    {Coordinate{6.55386, 46.8885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buttes station
    {Coordinate{6.62005, 46.7945}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Brinaz station
    {Coordinate{6.61136, 46.7968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Valeyres-sous-Montagny station
    {Coordinate{6.57983, 46.7953}, Tz::Europe_Zurich, CountryId{"CH"}}, // Essert-sous-Champvent station
    {Coordinate{6.55361, 46.8038}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vuiteboeuf station
    {Coordinate{6.52433, 46.7889}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baulmes station
    {Coordinate{6.49885, 46.7741}, Tz::Europe_Zurich, CountryId{"CH"}}, // Six-Fontaines station
    {Coordinate{6.53197, 46.8003}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trois-Villes station
    {Coordinate{6.50031, 46.8197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ste-Croix station
    {Coordinate{6.86542, 46.9659}, Tz::Europe_Zurich, CountryId{"CH"}}, // Colombier NE Littorail station
    {Coordinate{6.8337, 47.0997}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-de-Fonds-Grenier station
    {Coordinate{6.84408, 47.087}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Reymond station
    {Coordinate{6.8349, 47.0695}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Corbatière station
    {Coordinate{6.81854, 47.0509}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Sagne-Eglise station
    {Coordinate{6.80227, 47.0401}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Sagne station
    {Coordinate{6.78018, 47.0228}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Coeudres station
    {Coordinate{6.75528, 47.0101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Petit-Martel station
    {Coordinate{6.73587, 46.9996}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Ponts-de-Martel station
    {Coordinate{6.72581, 47.0586}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Frêtes station
    {Coordinate{6.70738, 47.0672}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Brenets station
    {Coordinate{6.92819, 46.9894}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel,Place Pury Littorail station
    {Coordinate{7.24218, 47.124}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nidau station
    {Coordinate{7.21421, 47.0967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lattrigen station
    {Coordinate{7.19854, 47.0665}, Tz::Europe_Zurich, CountryId{"CH"}}, // Täuffelen station
    {Coordinate{7.18793, 47.0581}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hagneck station
    {Coordinate{7.17714, 47.048}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lüscherz station
    {Coordinate{7.18038, 47.0312}, Tz::Europe_Zurich, CountryId{"CH"}}, // Siselen-Finsterhennen station
    {Coordinate{7.14829, 47.0206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brüttelen station
    {Coordinate{7.1068, 47.0056}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ins Dorf station
    {Coordinate{7.24031, 47.1198}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nidau Beunden station
    {Coordinate{7.22893, 47.1124}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ipsach Herdi station
    {Coordinate{7.23547, 47.1174}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ipsach station
    {Coordinate{7.21942, 47.1019}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sutz station
    {Coordinate{7.21223, 47.0856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mörigen station
    {Coordinate{7.20124, 47.075}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gerolfingen station
    {Coordinate{7.05644, 47.0094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gampelen station
    {Coordinate{7.09956, 46.9998}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ins station
    {Coordinate{7.14243, 46.9933}, Tz::Europe_Zurich, CountryId{"CH"}}, // Müntschemier station
    {Coordinate{7.21887, 46.9541}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ferenbalm-Gurbrü station
    {Coordinate{7.29686, 46.9343}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rosshäusern station
    {Coordinate{7.33405, 46.9411}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riedbach station
    {Coordinate{7.38975, 46.9458}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Bümpliz Nord station
    {Coordinate{7.03057, 47.0093}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zihlbrücke station
    {Coordinate{7.40117, 46.9464}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Stöckacker station
    {Coordinate{6.90487, 46.9809}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel, Port-de-Serrières station
    {Coordinate{6.87892, 46.9742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Auvernier Littorail station
    {Coordinate{6.83895, 46.9496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boudry Littorail station
    {Coordinate{8.57096, 46.6211}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hospental railway station
    {Coordinate{8.61295, 46.6424}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nätschen railway station
    {Coordinate{8.6705, 46.6602}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberalppass railway station
    {Coordinate{8.70909, 46.6567}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tschamut-Selva railway station
    {Coordinate{8.74287, 46.6699}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dieni railway station
    {Coordinate{8.7549, 46.6782}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rueras railway station
    {Coordinate{8.78646, 46.6824}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bugnei railway station
    {Coordinate{8.82444, 46.682}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mumpé Tujetsch railway station
    {Coordinate{8.82981, 46.691}, Tz::Europe_Zurich, CountryId{"CH"}}, // Segnas railway station
    {Coordinate{8.84578, 46.6972}, Tz::Europe_Zurich, CountryId{"CH"}}, // Acla da Fontauna railway station
    {Coordinate{9.02478, 47.5094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägerschen station
    {Coordinate{8.94887, 47.5022}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wiesengrund station
    {Coordinate{8.99172, 47.4816}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchwilen Pflegeheim station
    {Coordinate{8.89872, 47.5542}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frauenfeld Marktplatz station
    {Coordinate{8.91578, 47.5378}, Tz::Europe_Zurich, CountryId{"CH"}}, // Murkart station
    {Coordinate{8.9222, 47.5272}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weberei Matzingen station
    {Coordinate{8.93297, 47.5205}, Tz::Europe_Zurich, CountryId{"CH"}}, // Matzingen station
    {Coordinate{8.94426, 47.5089}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jakobstal station
    {Coordinate{8.95331, 47.4964}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wängi station
    {Coordinate{8.97524, 47.4923}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rosental station
    {Coordinate{8.99916, 47.4768}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchwilen TG station
    {Coordinate{8.90235, 47.5419}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lüdem station
    {Coordinate{9.03466, 47.4754}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bronschhofen station
    {Coordinate{9.02077, 47.4986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bettwiesen station
    {Coordinate{9.03369, 47.5213}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tobel-Affeltrangen station
    {Coordinate{9.06922, 47.5331}, Tz::Europe_Zurich, CountryId{"CH"}}, // Märwil station
    {Coordinate{9.06209, 47.5521}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oppikon station
    {Coordinate{9.03091, 47.4813}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bronschhofen AMP station
    {Coordinate{9.08414, 47.5561}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bussnang station
    {Coordinate{9.16977, 47.5722}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kehlhof station
    {Coordinate{9.17451, 47.5823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Berg station
    {Coordinate{9.16824, 47.6109}, Tz::Europe_Zurich, CountryId{"CH"}}, // Siegershausen station
    {Coordinate{9.19026, 47.6256}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lengwil station
    {Coordinate{9.16319, 47.6421}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kreuzlingen Bernrain station
    {Coordinate{9.13955, 47.6537}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägerwilen Dorf station
    {Coordinate{9.08317, 47.3197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lichtensteig station
    {Coordinate{9.37638, 47.4264}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Marktplatz station
    {Coordinate{9.37273, 47.3317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gontenbad station
    {Coordinate{9.4304, 47.3206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinegg station
    {Coordinate{9.43197, 47.3664}, Tz::Europe_Zurich, CountryId{"CH"}}, // Strahlholz station
    {Coordinate{9.43562, 47.3}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwende station
    {Coordinate{9.51635, 47.4775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seebleiche station
    {Coordinate{9.2864, 47.3575}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waldstatt station
    {Coordinate{9.29258, 47.3303}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürchersmühle station
    {Coordinate{9.28598, 47.3184}, Tz::Europe_Zurich, CountryId{"CH"}}, // Urnäsch station
    {Coordinate{9.32832, 47.3201}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jakobsbad station
    {Coordinate{9.34773, 47.3284}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gonten station
    {Coordinate{9.40883, 47.3283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Appenzell station
    {Coordinate{9.31675, 47.3979}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gübsensee station
    {Coordinate{9.43598, 47.3109}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weissbad station
    {Coordinate{9.42883, 47.2857}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wasserauen station
    {Coordinate{9.24351, 47.3856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schachen (Herisau) station
    {Coordinate{9.20028, 47.3725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Degersheim station
    {Coordinate{9.1426, 47.3637}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mogelsberg station
    {Coordinate{9.12988, 47.3373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brunnadern-Neckertal station
    {Coordinate{9.12097, 47.2637}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ebnat-Kappel station
    {Coordinate{9.16794, 47.2489}, Tz::Europe_Zurich, CountryId{"CH"}}, // Krummenau station
    {Coordinate{9.60126, 47.4517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walzenhausen station
    {Coordinate{9.59543, 47.4611}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ruderbach station
    {Coordinate{9.53358, 47.4718}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wartensee station
    {Coordinate{9.54063, 47.4662}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wienacht-Tobel station
    {Coordinate{9.53074, 47.4594}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwendi bei Heiden station
    {Coordinate{9.53677, 47.4464}, Tz::Europe_Zurich, CountryId{"CH"}}, // Heiden station
    {Coordinate{9.37971, 47.4246}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Spisertor station
    {Coordinate{9.38753, 47.4249}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Schülerhaus station
    {Coordinate{9.40323, 47.4253}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Notkersegg station
    {Coordinate{9.41544, 47.4224}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwarzer Bären station
    {Coordinate{9.4238, 47.4202}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rank station
    {Coordinate{9.43604, 47.4161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vögelinsegg station
    {Coordinate{9.43734, 47.4129}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schützengarten station
    {Coordinate{9.44332, 47.4106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Speicher station
    {Coordinate{9.45157, 47.4065}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bendlehn station
    {Coordinate{9.45587, 47.405}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gfeld station
    {Coordinate{9.46148, 47.4073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trogen station
    {Coordinate{9.37059, 47.4234}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen AB station
    {Coordinate{9.36688, 47.4104}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Riethüsli station
    {Coordinate{9.35921, 47.4002}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lustmühle station
    {Coordinate{9.3678, 47.3922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederteufen station
    {Coordinate{9.37453, 47.3896}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sternen bei Teufen station
    {Coordinate{9.39007, 47.3903}, Tz::Europe_Zurich, CountryId{"CH"}}, // Teufen station
    {Coordinate{9.40481, 47.377}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steigbach station
    {Coordinate{9.42113, 47.373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bühler station
    {Coordinate{9.45117, 47.3609}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gais station
    {Coordinate{9.53731, 47.3768}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altstätten Stadt station
    {Coordinate{9.42283, 47.3313}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hirschberg station
    {Coordinate{9.43255, 47.3485}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sammelplatz station
    {Coordinate{9.44452, 47.3602}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zweibrücken station
    {Coordinate{9.46471, 47.3621}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hebrig station
    {Coordinate{9.47726, 47.3615}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schachen (Gais) station
    {Coordinate{9.4872, 47.3607}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rietli station
    {Coordinate{9.49517, 47.3608}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stoss AR station
    {Coordinate{9.5056, 47.3657}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kreuzstrasse station
    {Coordinate{9.51355, 47.3654}, Tz::Europe_Zurich, CountryId{"CH"}}, // Warmesberg station
    {Coordinate{9.52208, 47.3685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alter Zoll station
    {Coordinate{9.39201, 47.4856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roggwil-Berg station
    {Coordinate{9.35871, 47.5039}, Tz::Europe_Zurich, CountryId{"CH"}}, // Häggenschwil-Winden station
    {Coordinate{9.33708, 47.5176}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muolen station
    {Coordinate{9.34984, 47.5315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinebrunn station
    {Coordinate{9.37583, 47.5388}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neukirch-Egnach station
    {Coordinate{9.52175, 47.4754}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sandbüchel station
    {Coordinate{9.38005, 47.3911}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stofel station
    {Coordinate{7.56247, 46.93}, Tz::Europe_Zurich, CountryId{"CH"}}, // Worb Dorf station
    {Coordinate{7.55645, 46.9468}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vechigen station
    {Coordinate{7.54729, 46.9536}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boll-Utzigen station
    {Coordinate{7.52409, 46.9568}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stettlen station
    {Coordinate{7.5142, 46.9572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Deisswil station
    {Coordinate{7.49741, 46.9695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bolligen station
    {Coordinate{7.48413, 46.9733}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ittigen bei Bern station
    {Coordinate{7.57284, 46.7749}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uetendorf station
    {Coordinate{7.54029, 46.7868}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seftigen station
    {Coordinate{7.52122, 46.7894}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burgistein station
    {Coordinate{7.51387, 46.8136}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thurnen station
    {Coordinate{7.50186, 46.8379}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaufdorf station
    {Coordinate{7.47235, 46.9088}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kehrsatz station
    {Coordinate{7.44588, 46.9287}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wabern bei Bern station
    {Coordinate{7.43002, 46.9358}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Weissenbühl station
    {Coordinate{7.40746, 46.9434}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Europaplatz BLS station
    {Coordinate{7.41516, 46.9249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Köniz station
    {Coordinate{7.40118, 46.91}, Tz::Europe_Zurich, CountryId{"CH"}}, // Moos station
    {Coordinate{7.40069, 46.9009}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gasel station
    {Coordinate{7.38811, 46.8865}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederscherli station
    {Coordinate{7.36799, 46.8765}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mittelhäusern station
    {Coordinate{7.34713, 46.8418}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lanzenhäusern station
    {Coordinate{7.34283, 46.8192}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwarzenburg station
    {Coordinate{7.4192, 46.9303}, Tz::Europe_Zurich, CountryId{"CH"}}, // Liebefeld station
    {Coordinate{7.49309, 46.8952}, Tz::Europe_Zurich, CountryId{"CH"}}, // Belp Steinbach station
    {Coordinate{7.46611, 46.9158}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kehrsatz Nord station
    {Coordinate{7.59488, 46.7731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uetendorf Allmend station
    {Coordinate{7.36236, 46.8628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwarzwasserbrücke station
    {Coordinate{7.47716, 46.9739}, Tz::Europe_Zurich, CountryId{"CH"}}, // Papiermühle station
    {Coordinate{7.28013, 46.4905}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gruben station
    {Coordinate{7.2911, 46.5045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönried station
    {Coordinate{7.31172, 46.5176}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saanenmöser station
    {Coordinate{7.35229, 46.5314}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oeschseite station
    {Coordinate{7.38532, 46.5411}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blankenburg station
    {Coordinate{7.38841, 46.5168}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stöckli station
    {Coordinate{7.40052, 46.5051}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Stephan station
    {Coordinate{7.42164, 46.4937}, Tz::Europe_Zurich, CountryId{"CH"}}, // Matten station
    {Coordinate{7.43539, 46.4708}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boden station
    {Coordinate{7.44352, 46.4586}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lenk im Simmental station
    {Coordinate{7.38313, 46.5798}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grubenwald station
    {Coordinate{7.41763, 46.6475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Enge im Simmental station
    {Coordinate{7.52463, 46.6575}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ringoldingen station
    {Coordinate{7.60558, 46.6665}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burgholz station
    {Coordinate{7.64227, 46.6839}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eifeld station
    {Coordinate{7.37437, 46.6035}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weissenbach station
    {Coordinate{7.39025, 46.6274}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boltigen station
    {Coordinate{7.43537, 46.6561}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberwil im Simmental station
    {Coordinate{7.47594, 46.6593}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weissenburg station
    {Coordinate{7.49542, 46.6589}, Tz::Europe_Zurich, CountryId{"CH"}}, // Därstetten station
    {Coordinate{7.55609, 46.659}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erlenbach im Simmental station
    {Coordinate{7.57933, 46.66}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oey-Diemtigen station
    {Coordinate{7.63548, 46.6756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wimmis station
    {Coordinate{7.65059, 46.6912}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lattigen bei Spiez station
    {Coordinate{7.87595, 46.646}, Tz::Europe_Zurich, CountryId{"CH"}}, // Umler station
    {Coordinate{7.67549, 46.529}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blausee-Mitholz station
    {Coordinate{7.81473, 46.6598}, Tz::Europe_Zurich, CountryId{"CH"}}, // Därligen station
    {Coordinate{7.77501, 46.6551}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leissigen station
    {Coordinate{7.69791, 46.6738}, Tz::Europe_Zurich, CountryId{"CH"}}, // Faulensee station
    {Coordinate{7.93377, 46.5836}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bannwald station
    {Coordinate{7.97553, 46.5843}, Tz::Europe_Zurich, CountryId{"CH"}}, // Salzegg station
    {Coordinate{7.98783, 46.5911}, Tz::Europe_Zurich, CountryId{"CH"}}, // Strättli station
    {Coordinate{7.88032, 46.6558}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rotenegg station
    {Coordinate{7.91279, 46.5943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Witimatte station
    {Coordinate{7.91437, 46.6031}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rohrfluh station
    {Coordinate{7.44424, 46.9685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Felsenau station
    {Coordinate{7.4502, 46.9727}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Tiefenau station
    {Coordinate{7.45752, 46.9833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinibach station
    {Coordinate{7.45762, 46.9788}, Tz::Europe_Zurich, CountryId{"CH"}}, // Worblaufen station
    {Coordinate{7.45709, 46.9917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterzollikofen station
    {Coordinate{7.48485, 47.0161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Moosseedorf station
    {Coordinate{7.49781, 47.0205}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönbühl RBS station
    {Coordinate{7.50065, 47.0289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Urtenen station
    {Coordinate{7.50777, 47.0476}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jegenstorf station
    {Coordinate{7.51161, 47.0801}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grafenried station
    {Coordinate{7.52215, 47.0865}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fraubrunnen station
    {Coordinate{7.51881, 47.0959}, Tz::Europe_Zurich, CountryId{"CH"}}, // Büren zum Hof station
    {Coordinate{7.52416, 47.1102}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schalunen station
    {Coordinate{7.5344, 47.13}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bätterkinden station
    {Coordinate{7.52695, 47.163}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lohn-Lüterkofen station
    {Coordinate{7.55537, 47.1829}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biberist RBS station
    {Coordinate{7.46163, 46.9969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberzollikofen station
    {Coordinate{7.49362, 47.0186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönbühl Shoppyland station
    {Coordinate{7.62963, 47.0396}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberburg station
    {Coordinate{7.61829, 47.0523}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burgdorf Steinhof station
    {Coordinate{7.60821, 47.0654}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burgdorf Buchmatt station
    {Coordinate{7.58014, 47.0835}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kirchberg-Alchenflüh station
    {Coordinate{7.56519, 47.1697}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gerlafingen station
    {Coordinate{7.56635, 47.1806}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biberist Ost station
    {Coordinate{7.78217, 47.2248}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langenthal Gaswerk station
    {Coordinate{7.77487, 47.2338}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hard-Mumenthal station
    {Coordinate{7.76959, 47.2405}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aarwangen station
    {Coordinate{7.76361, 47.2452}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aarwangen Schloss station
    {Coordinate{7.74036, 47.2444}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bannwil station
    {Coordinate{7.71039, 47.2582}, Tz::Europe_Zurich, CountryId{"CH"}}, // Holzhäusern station
    {Coordinate{7.70079, 47.2631}, Tz::Europe_Zurich, CountryId{"CH"}}, // Scharnageln station
    {Coordinate{7.69513, 47.2658}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederbipp Dorf station
    {Coordinate{7.7845, 47.2176}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langenthal [Gleis 4-5] station
    {Coordinate{7.79943, 47.2372}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaltenherberg station
    {Coordinate{7.82253, 47.2393}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roggwil Dorf station
    {Coordinate{7.83596, 47.2318}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Urban station
    {Coordinate{7.83606, 47.2273}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Urban Ziegelei station
    {Coordinate{7.83166, 47.2359}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roggwil Buchägerten station
    {Coordinate{7.81508, 47.2374}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roggwil Schmitten station
    {Coordinate{7.79326, 47.1816}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gutenburg station
    {Coordinate{7.78021, 47.2054}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langenthal Süd station
    {Coordinate{7.78838, 47.1895}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lotzwil station
    {Coordinate{7.79565, 47.1667}, Tz::Europe_Zurich, CountryId{"CH"}}, // Madiswil station
    {Coordinate{7.79053, 47.1546}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lindenholz station
    {Coordinate{7.79096, 47.1463}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kleindietwil station
    {Coordinate{7.81382, 47.1371}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rohrbach station
    {Coordinate{7.84272, 47.1146}, Tz::Europe_Zurich, CountryId{"CH"}}, // Huttwil station
    {Coordinate{7.7713, 47.2375}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aarwangen Vorstadt station
    {Coordinate{7.83291, 47.1122}, Tz::Europe_Zurich, CountryId{"CH"}}, // Huttwil Sportzentrum station
    {Coordinate{7.61923, 46.7627}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwäbis station
    {Coordinate{7.61502, 46.7729}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steffisburg station
    {Coordinate{7.60903, 46.7816}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lädeli station
    {Coordinate{7.60603, 46.7909}, Tz::Europe_Zurich, CountryId{"CH"}}, // Heimberg station
    {Coordinate{7.61069, 46.8183}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brenzikofen station
    {Coordinate{7.61804, 46.8395}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberdiessbach station
    {Coordinate{7.62295, 46.8709}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stalden i.E. station
    {Coordinate{7.6346, 46.904}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grosshöchstetten station
    {Coordinate{7.62702, 46.9245}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biglen station
    {Coordinate{7.61899, 46.9477}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walkringen station
    {Coordinate{7.62359, 46.9656}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bigenthal station
    {Coordinate{7.65683, 46.9945}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schafhausen i.E. station
    {Coordinate{7.7102, 46.9968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ramsei station
    {Coordinate{7.74068, 46.9761}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zollbrück station
    {Coordinate{7.74918, 46.9659}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neumühle station
    {Coordinate{7.72407, 47.0084}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grünenmatt station
    {Coordinate{7.73706, 47.0254}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sumiswald-Grünen station
    {Coordinate{7.74984, 47.0784}, Tz::Europe_Zurich, CountryId{"CH"}}, // Häusernmoos station
    {Coordinate{7.7926, 47.0912}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dürrenroth station
    {Coordinate{7.73788, 47.0349}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gammenthal station
    {Coordinate{7.74212, 47.0443}, Tz::Europe_Zurich, CountryId{"CH"}}, // Griesbach station
    {Coordinate{7.77272, 47.09}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mussachen station
    {Coordinate{7.90572, 47.1286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hüswil station
    {Coordinate{7.92653, 47.1367}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zell station
    {Coordinate{7.97058, 47.1402}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gettnau station
    {Coordinate{7.99706, 47.1226}, Tz::Europe_Zurich, CountryId{"CH"}}, // Willisau station
    {Coordinate{8.04093, 47.0834}, Tz::Europe_Zurich, CountryId{"CH"}}, // Menznau station
    {Coordinate{8.24911, 46.9002}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sarnen Nord station
    {Coordinate{8.03809, 46.7552}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brienz BRB station
    {Coordinate{8.01985, 46.7724}, Tz::Europe_Zurich, CountryId{"CH"}}, // Planalp station
    {Coordinate{8.03845, 46.7874}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brienzer Rothorn station
    {Coordinate{8.2325, 46.7023}, Tz::Europe_Zurich, CountryId{"CH"}}, // Innertkirchen MIB station
    {Coordinate{8.22958, 46.7056}, Tz::Europe_Zurich, CountryId{"CH"}}, // Innertkirchen Grimseltor station
    {Coordinate{8.27123, 46.9705}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aemsigen station
    {Coordinate{8.25595, 46.9794}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pilatus Kulm station
    {Coordinate{8.27718, 46.9555}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alpnachstad PB station
    {Coordinate{8.48238, 47.0094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vitznau station
    {Coordinate{9.63254, 46.9769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seewis-Valzeina station
    {Coordinate{9.70895, 46.9398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Furna station
    {Coordinate{9.73376, 46.9224}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fideris station
    {Coordinate{9.88425, 46.8558}, Tz::Europe_Zurich, CountryId{"CH"}}, // Klosters Selfranga station
    {Coordinate{9.62094, 46.6669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Surava
    {Coordinate{10.0599, 46.6704}, Tz::Europe_Zurich, CountryId{"CH"}}, // Carolina station
    {Coordinate{7.98639, 46.319}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brig Bahnhofplatz railway station
    {Coordinate{7.69467, 47.2703}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederbipp [Gleis 11-12] station
    {Coordinate{7.37468, 46.9439}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Brünnen Westside station
    {Coordinate{7.09998, 47}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ins [Gleis 11] station
    {Coordinate{7.54349, 47.2046}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn [Gleis 21] station
    {Coordinate{8.07111, 47.0652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wolhusen Weid station
    {Coordinate{8.11304, 47.3148}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterkulm Nord station
    {Coordinate{8.01694, 46.6139}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rohr (Grindelwald) station
    {Coordinate{8.40091, 47.402}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietikon Schöneggstrasse station
    {Coordinate{8.35027, 47.3538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bibenlos-Sonnenhof station
    {Coordinate{9.99699, 46.6198}, Tz::Europe_Zurich, CountryId{"CH"}}, // S-chanf Marathon station
    {Coordinate{6.98623, 46.3153}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aigle-Parc Aventure station
    {Coordinate{7.10064, 46.3533}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sur-le-Buis station
    {Coordinate{6.14272, 46.2151}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genève Montbrillant station
    {Coordinate{9.39343, 47.4259}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Birnbäumen station
    {Coordinate{8.59264, 47.6953}, Tz::Europe_Zurich, CountryId{"CH"}}, // Beringerfeld station
    {Coordinate{7.92601, 46.6032}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sengg (Verzw) station
    {Coordinate{7.93246, 46.5984}, Tz::Europe_Zurich, CountryId{"CH"}}, // In Gassen (Verzw) station
    {Coordinate{7.70316, 47.2786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederbipp Industrie station
    {Coordinate{7.70931, 47.285}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oensingen [Gleis 7-8] station
    {Coordinate{6.14729, 46.4469}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Cergue Les Cheseaux station
    {Coordinate{6.78947, 47.0288}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Coeudres-Est station
    {Coordinate{6.76524, 47.0137}, Tz::Europe_Zurich, CountryId{"CH"}}, // Petit-Martel-Est station
    {Coordinate{7.02084, 46.2505}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bex Pont-Neuf station
    {Coordinate{7.02323, 46.2526}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grand-Moulin station
    {Coordinate{7.02765, 46.2548}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Salines station
    {Coordinate{6.74559, 47.0051}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Stand station
    {Coordinate{7.02985, 46.2564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Foyer Dents-du-Midi station
    {Coordinate{6.90154, 46.4733}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bois-de-Chexbres station
    {Coordinate{6.63163, 46.7888}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yverdon William Barbey station
    {Coordinate{7.05276, 46.1205}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Fumeaux station
    {Coordinate{7.00784, 46.1088}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Médettaz station
    {Coordinate{6.96606, 46.3105}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aigle-Hôpital station
    {Coordinate{6.99679, 46.2913}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Arnoux station
    {Coordinate{6.96179, 46.2761}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pont du Rhône station
    {Coordinate{6.9248, 46.236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Neys station
    {Coordinate{6.92027, 46.2318}, Tz::Europe_Zurich, CountryId{"CH"}}, // Route de Morgins station
    {Coordinate{6.88703, 46.197}, Tz::Europe_Zurich, CountryId{"CH"}}, // En Charnet station
    {Coordinate{7.00773, 46.2531}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Ruaz station
    {Coordinate{8.50127, 46.5957}, Tz::Europe_Zurich, CountryId{"CH"}}, // Realp DFB station
    {Coordinate{6.92337, 46.9897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel, Evole station
    {Coordinate{6.91228, 46.9846}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel, Champ-Bougin station
    {Coordinate{6.89709, 46.9801}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel, Serrières Ruau station
    {Coordinate{6.86951, 46.9681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Colombier NE Allées Littorail station
    {Coordinate{6.86395, 46.9608}, Tz::Europe_Zurich, CountryId{"CH"}}, // Colombier NE, Les Chézards station
    {Coordinate{6.84286, 46.9515}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boudry, Tuilière station
    {Coordinate{7.24255, 47.1323}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel/Bienne [Gleis 11/voie 11] station
    {Coordinate{8.19858, 46.7213}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aareschlucht West station
    {Coordinate{6.22196, 46.5993}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chez-le-Maître-Ecoles station
    {Coordinate{8.19001, 46.7231}, Tz::Europe_Zurich, CountryId{"CH"}}, // Meiringen Alpbach station
    {Coordinate{8.22608, 46.7081}, Tz::Europe_Zurich, CountryId{"CH"}}, // Innertkirchen Unterwasser station
    {Coordinate{8.21789, 46.712}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aareschlucht Ost MIB station
    {Coordinate{8.57502, 47.3546}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Balgrist station
    {Coordinate{8.56062, 47.3617}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Hegibachplatz station
    {Coordinate{8.55408, 47.3649}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Kreuzplatz station
    {Coordinate{6.93529, 46.0659}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pied du barrage station
    {Coordinate{6.92433, 46.4329}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glion-Alpes station
    {Coordinate{6.92621, 46.4338}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glion-Collège station
    {Coordinate{6.94796, 46.4344}, Tz::Europe_Zurich, CountryId{"CH"}}, // Haut-de-Caux station
    {Coordinate{6.91756, 46.4331}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montreux-Les Planches station
    {Coordinate{6.92848, 46.4279}, Tz::Europe_Zurich, CountryId{"CH"}}, // Toveyre station
    {Coordinate{6.9293, 46.4286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Valmont station
    {Coordinate{6.93276, 46.436}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Tremblex station
    {Coordinate{6.94489, 46.4322}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Echets station
    {Coordinate{6.95538, 46.4352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Crêt-d'y-Bau station
    {Coordinate{6.9627, 46.4378}, Tz::Europe_Zurich, CountryId{"CH"}}, // Paccot station
    {Coordinate{6.9768, 46.4413}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jaman station
    {Coordinate{6.97511, 46.4364}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Perche station
    {Coordinate{6.97903, 46.4317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rochers-de-Naye station
    {Coordinate{6.92473, 46.4318}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glion station
    {Coordinate{6.93853, 46.4311}, Tz::Europe_Zurich, CountryId{"CH"}}, // Caux station
    {Coordinate{7.74868, 46.0239}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zermatt GGB station
    {Coordinate{8.56028, 47.3681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich, Römerhof station
    {Coordinate{8.57453, 47.3732}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich, Dolder station
    {Coordinate{8.54726, 47.0436}, Tz::Europe_Zurich, CountryId{"CH"}}, // Goldau A4 station
    {Coordinate{8.5471, 47.0474}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arth-Goldau RB station
    {Coordinate{8.53079, 47.0402}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kräbel station
    {Coordinate{8.50498, 47.0384}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fruttli station
    {Coordinate{8.48713, 47.0425}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Klösterli station
    {Coordinate{8.47651, 47.0472}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Wölfertschen-First station
    {Coordinate{8.47424, 47.0537}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Staffel station
    {Coordinate{8.48524, 47.0552}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Kulm station
    {Coordinate{8.48313, 47.0262}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grubisbalm station
    {Coordinate{8.47973, 47.03}, Tz::Europe_Zurich, CountryId{"CH"}}, // Freibergen station
    {Coordinate{8.47592, 47.0364}, Tz::Europe_Zurich, CountryId{"CH"}}, // Romiti Felsentor station
    {Coordinate{8.4667, 47.044}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Kaltbad-First station
    {Coordinate{8.4645, 47.0481}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rigi Staffelhöhe station
    {Coordinate{8.48247, 47.0192}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mittlerschwanden station
    {Coordinate{7.06756, 46.2777}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gryon Bois-Gentil station
    {Coordinate{7.55953, 46.9339}, Tz::Europe_Zurich, CountryId{"CH"}}, // Worbboden station
    {Coordinate{8.56495, 47.371}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich, Titlisstrasse station
    {Coordinate{8.56855, 47.3732}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich, Waldhaus Dolder station
    {Coordinate{6.90374, 46.219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pont de Fayot station
    {Coordinate{7.05192, 46.2736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gryon-Chalméry station
    {Coordinate{7.14164, 46.3555}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Bovets station
    {Coordinate{7.14713, 46.3549}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Faverge station
    {Coordinate{7.11955, 46.3545}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Nicolets station
    {Coordinate{7.12921, 46.3536}, Tz::Europe_Zurich, CountryId{"CH"}}, // Plan Morier station
    {Coordinate{6.84852, 46.9542}, Tz::Europe_Zurich, CountryId{"CH"}}, // Areuse Les Isles Littorail station
    {Coordinate{7.78647, 47.2286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langenthal Industrie Nord station
    {Coordinate{6.85281, 46.9545}, Tz::Europe_Zurich, CountryId{"CH"}}, // Areuse Littorail station
    {Coordinate{6.66639, 52.3422}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almelo de Riet railway station
    {Coordinate{7.08222, 46.0786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3366042
    {Coordinate{4.75444, 52.4949}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Krommenie-Assendelft railway station
    {Coordinate{20.2667, 63.8297}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Umeå Central Station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q33747480
    {Coordinate{20.2931, 63.8175}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Umeå East Station
    {Coordinate{8.69222, 50.1031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Lokalbahnhof
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q33926963
    {Coordinate{9.10722, 45.6972}, Tz::Europe_Rome, CountryId{"IT"}}, // Carimate railway station
    {Coordinate{9.08194, 45.7408}, Tz::Europe_Rome, CountryId{"IT"}}, // Cucciago railway station
    {Coordinate{13.9656, 42.7517}, Tz::Europe_Rome, CountryId{"IT"}}, // Giulianova railway station
    {Coordinate{3.19514, 51.3264}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zeebrugge-Dorp railway station
    {Coordinate{5.70444, 51.47}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond Brouwhuis railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q34064533
    {Coordinate{3.96556, 50.7439}, Tz::Europe_Brussels, CountryId{"BE"}}, // Galmaarden railway station
    {Coordinate{6.14333, 51.3394}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tegelen railway station
    {Coordinate{3.3914, 50.8336}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vichte railway station
    {Coordinate{5.75056, 50.8828}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Meerssen railway station
    {Coordinate{6.08179, 46.2225}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3555972
    {Coordinate{10.2867, 46.7936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Scuol-Tarasp
    {Coordinate{8.54939, 47.0491}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arth-Goldau railway station
    {Coordinate{13.3894, 52.3985}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schichauweg railway station
    {Coordinate{7.98833, 46.5486}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jungfraujoch railway station
    {Coordinate{5.38111, 43.3031}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marseille-Saint-Charles
    {Coordinate{8.57, 50.0528}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Airport long-distance station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224158
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224161
    {Coordinate{11.1686, 49.4631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224162
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224165
    {Coordinate{11.1686, 49.4631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224169
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37224173
    {Coordinate{1.45361, 43.6111}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Matabiau
    {Coordinate{11.505, 47.0019}, Tz::Europe_Rome, CountryId{"IT"}}, // Brenner railway station
    {Coordinate{5.36, 52.8867}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Stavoren railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37380914
    {Coordinate{11.0458, 49.4344}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37380916
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Stein station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37380928
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q37380930
    {Coordinate{14.4399, 50.1097}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha-Holešovice railway station
    {Coordinate{13.3481, 52.52}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Bellevue station
    {Coordinate{13.3644, 52.4756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Südkreuz
    {Coordinate{11.5595, 51.679}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sandersleben (Anh) station
    {Coordinate{18.0767, 40.4094}, Tz::Europe_Rome, CountryId{"IT"}}, // Trepuzzi railway station
    {Coordinate{16.0109, 46.9495}, Tz::Europe_Vienna, CountryId{"AT"}}, // Roundhouse with turntable
    {Coordinate{13.3439, 52.4786}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Innsbrucker Platz station
    {Coordinate{15.8149, 48.638}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q38035213
    {Coordinate{15.6708, 48.7424}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q38037125
    {Coordinate{9.55417, 46.9675}, Tz::Europe_Zurich, CountryId{"CH"}}, // Landquart railway station
    {Coordinate{11.6866, 50.3551}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marxgrün station
    {Coordinate{10.6178, 51.8}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brocken station
    {Coordinate{5.67194, 52.0278}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ede-Wageningen railway station
    {Coordinate{-9.14278, 38.7053}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Cais do Sodré
    {Coordinate{5.59889, 52.1603}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barneveld Noord railway station
    {Coordinate{4.39145, 50.3003}, Tz::Europe_Brussels, CountryId{"BE"}}, // Cour-sur-Heure railway station
    {Coordinate{14.1227, 40.8714}, Tz::Europe_Rome, CountryId{"IT"}}, // Quarto di Marano railway halt
    {Coordinate{4.49639, 51.07}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Katelijne-Waver railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q39214267
    {Coordinate{6.1, 52.2381}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Twello railway station
    {Coordinate{8.81556, 40.1267}, Tz::Europe_Rome, CountryId{"IT"}}, // Abbasanta railway station
    {Coordinate{14.3727, 40.9399}, Tz::Europe_Rome, CountryId{"IT"}}, // Acerra railway station
    {Coordinate{15.1615, 37.5958}, Tz::Europe_Rome, CountryId{"IT"}}, // Acireale railway station
    {Coordinate{15.672, 40.0351}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968818
    {Coordinate{14.7724, 40.7334}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968819
    {Coordinate{8.46778, 44.6725}, Tz::Europe_Rome, CountryId{"IT"}}, // Acqui Terme railway station
    {Coordinate{12.0543, 45.0605}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968828
    {Coordinate{13.588, 37.3192}, Tz::Europe_Rome, CountryId{"IT"}}, // Agrigento Bassa railway station
    {Coordinate{13.5847, 37.3091}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968835
    {Coordinate{13.5813, 42.0622}, Tz::Europe_Rome, CountryId{"IT"}}, // Aielli railway station
    {Coordinate{8.17142, 44.0079}, Tz::Europe_Rome, CountryId{"IT"}}, // Alassio railway station
    {Coordinate{13.9172, 42.8344}, Tz::Europe_Rome, CountryId{"IT"}}, // Alba Adriatica-Nereto-Controguerra railway station
    {Coordinate{12.6581, 41.7264}, Tz::Europe_Rome, CountryId{"IT"}}, // Albano Laziale railway station
    {Coordinate{11.2113, 42.502}, Tz::Europe_Rome, CountryId{"IT"}}, // Albinia
    {Coordinate{11.134, 42.6391}, Tz::Europe_Rome, CountryId{"IT"}}, // Alberese
    {Coordinate{9.07306, 45.7769}, Tz::Europe_Rome, CountryId{"IT"}}, // Albate-Camerlata railway station
    {Coordinate{8.22173, 44.0475}, Tz::Europe_Rome, CountryId{"IT"}}, // Albenga
    {Coordinate{8.51174, 44.3345}, Tz::Europe_Rome, CountryId{"IT"}}, // Albisola railway halt
    {Coordinate{15.2513, 37.8214}, Tz::Europe_Rome, CountryId{"IT"}}, // Alcantara station
    {Coordinate{14.0447, 41.7384}, Tz::Europe_Rome, CountryId{"IT"}}, // Alfedena-Scontrone railway station
    {Coordinate{8.44014, 44.7226}, Tz::Europe_Rome, CountryId{"IT"}}, // Alice Belcolle railway halt
    {Coordinate{12.0356, 42.7847}, Tz::Europe_Rome, CountryId{"IT"}}, // stazione di Allerona-Castel Viscardo
    {Coordinate{7.52389, 45.0914}, Tz::Europe_Rome, CountryId{"IT"}}, // Alpignano railway station
    {Coordinate{8.60639, 44.9092}, Tz::Europe_Rome, CountryId{"IT"}}, // Alessandria railway station
    {Coordinate{16.5517, 40.8375}, Tz::Europe_Rome, CountryId{"IT"}}, // Altamura railway station
    {Coordinate{13.5542, 38.0483}, Tz::Europe_Rome, CountryId{"IT"}}, // Altavilla Milicia railway station
    {Coordinate{11.5678, 45.5647}, Tz::Europe_Rome, CountryId{"IT"}}, // Anconetta railway station
    {Coordinate{13.5073, 43.6175}, Tz::Europe_Rome, CountryId{"IT"}}, // Ancona Marittima train station
    {Coordinate{13.096, 41.7105}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968873
    {Coordinate{8.1395, 43.952}, Tz::Europe_Rome, CountryId{"IT"}}, // Andora railway station
    {Coordinate{14.5754, 40.7462}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968875
    {Coordinate{12.2942, 42.0675}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968876
    {Coordinate{13.4978, 43.6074}, Tz::Europe_Rome, CountryId{"IT"}}, // Ancona railway station
    {Coordinate{10.329, 43.4954}, Tz::Europe_Rome, CountryId{"IT"}}, // Antignano railway station
    {Coordinate{12.6293, 41.4521}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968883
    {Coordinate{12.6392, 41.5922}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968884
    {Coordinate{13.5719, 41.5837}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968886
    {Coordinate{9.91456, 44.1185}, Tz::Europe_Rome, CountryId{"IT"}}, // Arcola
    {Coordinate{8.67838, 44.4031}, Tz::Europe_Rome, CountryId{"IT"}}, // Arenzano railway halt
    {Coordinate{15.1186, 41.1811}, Tz::Europe_Rome, CountryId{"IT"}}, // Ariano Irpino railway station
    {Coordinate{11.8756, 43.4611}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Arezzo
    {Coordinate{8.55944, 45.7553}, Tz::Europe_Rome, CountryId{"IT"}}, // Arona railway station
    {Coordinate{13.6, 41.6477}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968905
    {Coordinate{13.0133, 42.0459}, Tz::Europe_Rome, CountryId{"IT"}}, // Station Arsoli
    {Coordinate{8.885, 44.6923}, Tz::Europe_Rome, CountryId{"IT"}}, // Arquata Scrivia railway station
    {Coordinate{13.1623, 46.2313}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968910
    {Coordinate{15.5477, 41.2196}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968911
    {Coordinate{11.5798, 43.2355}, Tz::Europe_Rome, CountryId{"IT"}}, // Asciano
    {Coordinate{13.5881, 42.8553}, Tz::Europe_Rome, CountryId{"IT"}}, // Ascoli Piceno railway station
    {Coordinate{8.99778, 39.2878}, Tz::Europe_Rome, CountryId{"IT"}}, // Assemini railway station
    {Coordinate{9.01395, 39.2818}, Tz::Europe_Rome, CountryId{"IT"}}, // Assemini Carmine railway station
    {Coordinate{8.98938, 39.291}, Tz::Europe_Rome, CountryId{"IT"}}, // Assemini Santa Lucia railway station
    {Coordinate{12.5853, 43.0592}, Tz::Europe_Rome, CountryId{"IT"}}, // Assisi railway station
    {Coordinate{9.97696, 44.2188}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968928
    {Coordinate{15.2185, 37.2432}, Tz::Europe_Rome, CountryId{"IT"}}, // Augusta railway station
    {Coordinate{13.4263, 42.0394}, Tz::Europe_Rome, CountryId{"IT"}}, // Avezzano railway station
    {Coordinate{14.2178, 40.9744}, Tz::Europe_Rome, CountryId{"IT"}}, // Aversa railway station
    {Coordinate{14.8204, 40.9214}, Tz::Europe_Rome, CountryId{"IT"}}, // Avellino railway station
    {Coordinate{12.5903, 46.0645}, Tz::Europe_Rome, CountryId{"IT"}}, // Aviano railway station
    {Coordinate{7.40111, 45.0853}, Tz::Europe_Rome, CountryId{"IT"}}, // Avigliana railway station
    {Coordinate{15.7855, 40.7146}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968941
    {Coordinate{11.4849, 45.0945}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968942
    {Coordinate{13.2819, 45.8855}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968945
    {Coordinate{12.7223, 41.9496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968946
    {Coordinate{13.5074, 38.0897}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagheria railway station
    {Coordinate{14.1667, 40.8193}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnoli-Agnano Terme railway station
    {Coordinate{12.6637, 42.7262}, Tz::Europe_Rome, CountryId{"IT"}}, // Baiano di Spoleto railway station
    {Coordinate{8.09122, 44.8992}, Tz::Europe_Rome, CountryId{"IT"}}, // Baldichieri-Tigliole station
    {Coordinate{9.00503, 45.8468}, Tz::Europe_Zurich, CountryId{"CH"}}, // Balerna railway station
    {Coordinate{13.5568, 41.8095}, Tz::Europe_Rome, CountryId{"IT"}}, // Balsorano railway station
    {Coordinate{14.5965, 41.5178}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968965
    {Coordinate{11.2749, 44.504}, Tz::Europe_Rome, CountryId{"IT"}}, // Barbiano railway halt
    {Coordinate{15.1994, 38.154}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968974
    {Coordinate{16.9944, 41.083}, Tz::Europe_Rome, CountryId{"IT"}}, // Bari Torre a Mare railway station
    {Coordinate{16.8263, 41.128}, Tz::Europe_Rome, CountryId{"IT"}}, // Bari Zona Industriale railway station
    {Coordinate{15.6709, 40.943}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968994
    {Coordinate{14.7726, 40.7458}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3968997
    {Coordinate{13.1097, 46.0129}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969003
    {Coordinate{16.2786, 41.3153}, Tz::Europe_Rome, CountryId{"IT"}}, // Barletta railway station
    {Coordinate{11.7414, 45.7665}, Tz::Europe_Rome, CountryId{"IT"}}, // Bassano del Grappa railway station
    {Coordinate{8.40167, 44.7771}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969006
    {Coordinate{6.75959, 45.0466}, Tz::Europe_Rome, CountryId{"IT"}}, // Beaulard
    {Coordinate{14.9831, 40.6057}, Tz::Europe_Rome, CountryId{"IT"}}, // Battipaglia railway station
    {Coordinate{8.62774, 45.5668}, Tz::Europe_Rome, CountryId{"IT"}}, // Bellinzago railway station
    {Coordinate{14.7664, 41.1332}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969017
    {Coordinate{14.7799, 41.1345}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969018
    {Coordinate{12.2097, 46.1417}, Tz::Europe_Rome, CountryId{"IT"}}, // Belluno railway station
    {Coordinate{9.18194, 40.7719}, Tz::Europe_Rome, CountryId{"IT"}}, // Berchidda railway station
    {Coordinate{9.93169, 44.5558}, Tz::Europe_Rome, CountryId{"IT"}}, // Berceto railway station
    {Coordinate{8.76126, 45.6955}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969029
    {Coordinate{8.66311, 45.8423}, Tz::Europe_Rome, CountryId{"IT"}}, // Besozzo railway station
    {Coordinate{15.0448, 37.4609}, Tz::Europe_Rome, CountryId{"IT"}}, // Bicocca railway station
    {Coordinate{8.3721, 44.6593}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969040
    {Coordinate{13.6561, 45.7542}, Tz::Europe_Rome, CountryId{"IT"}}, // Bivio d’Aurisina railway station
    {Coordinate{14.4744, 41.4878}, Tz::Europe_Rome, CountryId{"IT"}}, // Boiano rail station
    {Coordinate{10.5509, 43.2447}, Tz::Europe_Rome, CountryId{"IT"}}, // Bolgheri railway station
    {Coordinate{9.06607, 44.3792}, Tz::Europe_Rome, CountryId{"IT"}}, // Bogliasco station
    {Coordinate{11.2848, 44.5151}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna Borgo Panigale railway station
    {Coordinate{9.58267, 44.1849}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969067
    {Coordinate{11.3728, 44.4627}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna San Ruffillo train station
    {Coordinate{7.66368, 43.7785}, Tz::Europe_Rome, CountryId{"IT"}}, // Bordighera
    {Coordinate{8.30897, 44.1578}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgio Verezzi railway halt
    {Coordinate{8.9382, 44.5889}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo Fornari per Voltaggio railway station
    {Coordinate{8.60239, 45.6919}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo Ticino railway station
    {Coordinate{9.78101, 44.4864}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo Val di Taro train station
    {Coordinate{10.73, 43.8806}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Borgo a Buggiano
    {Coordinate{10.7663, 45.1416}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgochiesanuova
    {Coordinate{8.46769, 45.701}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgomanero railway station
    {Coordinate{7.2362, 45.1235}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgone railway station
    {Coordinate{8.53825, 44.836}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgoratto railway halt
    {Coordinate{11.1245, 45.2546}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969106
    {Coordinate{12.1731, 42.1039}, Tz::Europe_Rome, CountryId{"IT"}}, // Bracciano railway station
    {Coordinate{7.84922, 44.6937}, Tz::Europe_Rome, CountryId{"IT"}}, // Bra railway station
    {Coordinate{8.30515, 44.3722}, Tz::Europe_Rome, CountryId{"IT"}}, // Bragno
    {Coordinate{7.84116, 45.1788}, Tz::Europe_Rome, CountryId{"IT"}}, // Brandizzo railway station
    {Coordinate{9.111, 45.0862}, Tz::Europe_Rome, CountryId{"IT"}}, // Bressana-Bottarone railway station
    {Coordinate{11.6501, 46.71}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969119
    {Coordinate{11.7698, 44.2206}, Tz::Europe_Rome, CountryId{"IT"}}, // Brisighella railway station
    {Coordinate{11.3162, 46.4051}, Tz::Europe_Rome, CountryId{"IT"}}, // Bronzolo
    {Coordinate{17.9389, 40.6344}, Tz::Europe_Rome, CountryId{"IT"}}, // Brindisi railway station
    {Coordinate{11.93, 46.7946}, Tz::Europe_Rome, CountryId{"IT"}}, // Brunico
    {Coordinate{7.20159, 45.1313}, Tz::Europe_Rome, CountryId{"IT"}}, // Bruzolo di Susa
    {Coordinate{11.6176, 43.4804}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969131
    {Coordinate{12.5375, 46.0316}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969132
    {Coordinate{11.4837, 43.1355}, Tz::Europe_Rome, CountryId{"IT"}}, // Buonconvento
    {Coordinate{7.14444, 45.1397}, Tz::Europe_Rome, CountryId{"IT"}}, // Bussoleno
    {Coordinate{8.94349, 44.5755}, Tz::Europe_Rome, CountryId{"IT"}}, // Busalla railway station
    {Coordinate{10.039, 44.9746}, Tz::Europe_Rome, CountryId{"IT"}}, // Busseto railway station
    {Coordinate{9.85317, 44.9673}, Tz::Europe_Rome, CountryId{"IT"}}, // Cadeo railway halt
    {Coordinate{8.85139, 45.6061}, Tz::Europe_Rome, CountryId{"IT"}}, // Busto Arsizio Nord railway station
    {Coordinate{9.04565, 39.2644}, Tz::Europe_Rome, CountryId{"IT"}}, // Cagliari Elmas railway station
    {Coordinate{9.10889, 39.2156}, Tz::Europe_Rome, CountryId{"IT"}}, // Cagliari railway station
    {Coordinate{8.27889, 44.394}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969153
    {Coordinate{12.3886, 46.4439}, Tz::Europe_Rome, CountryId{"IT"}}, // Calalzo-Pieve di Cadore-Cortina railway station
    {Coordinate{15.2266, 37.8148}, Tz::Europe_Rome, CountryId{"IT"}}, // Calatabiano railway halt
    {Coordinate{11.2408, 46.0074}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969157
    {Coordinate{11.2675, 44.5441}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969158
    {Coordinate{11.2645, 45.9975}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969159
    {Coordinate{11.1451, 43.8564}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969160
    {Coordinate{14.5278, 37.2292}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969162
    {Coordinate{14.0569, 37.5364}, Tz::Europe_Rome, CountryId{"IT"}}, // Caltanissetta Xirbi railway station
    {Coordinate{8.5915, 45.5191}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969164
    {Coordinate{10.2477, 43.9122}, Tz::Europe_Rome, CountryId{"IT"}}, // Camaiore Lido-Capezzano
    {Coordinate{7.77326, 44.9664}, Tz::Europe_Rome, CountryId{"IT"}}, // Cambiano-Santena station
    {Coordinate{9.13361, 45.6683}, Tz::Europe_Rome, CountryId{"IT"}}, // Camnago-Lentate railway station
    {Coordinate{10.5868, 43.0173}, Tz::Europe_Rome, CountryId{"IT"}}, // Campiglia Marittima
    {Coordinate{8.70106, 44.531}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969176
    {Coordinate{11.4884, 46.8693}, Tz::Europe_Rome, CountryId{"IT"}}, // Campo di Trens
    {Coordinate{11.9011, 45.5057}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969182
    {Coordinate{15.0424, 41.9574}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969184
    {Coordinate{12.6484, 41.6425}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969185
    {Coordinate{11.3031, 43.937}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969186
    {Coordinate{11.9284, 45.5692}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969188
    {Coordinate{11.1431, 44.7884}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969189
    {Coordinate{11.9713, 43.2612}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969190
    {Coordinate{12.6218, 41.7108}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969191
    {Coordinate{16.1463, 41.2945}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969196
    {Coordinate{13.4121, 41.941}, Tz::Europe_Rome, CountryId{"IT"}}, // Canistro railway halt
    {Coordinate{16.0542, 41.2185}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969201
    {Coordinate{14.3942, 41.5315}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969202
    {Coordinate{13.2325, 38.1718}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969207
    {Coordinate{11.3713, 42.4083}, Tz::Europe_Rome, CountryId{"IT"}}, // Capalbio
    {Coordinate{13.3991, 41.9705}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969209
    {Coordinate{14.7445, 38.1577}, Tz::Europe_Rome, CountryId{"IT"}}, // Capo d'Orlando-Naso rail station
    {Coordinate{12.5687, 41.8308}, Tz::Europe_Rome, CountryId{"IT"}}, // Capannelle railway station
    {Coordinate{8.97889, 45.9028}, Tz::Europe_Zurich, CountryId{"CH"}}, // Capolago-Riva San Vitale railway station
    {Coordinate{12.1574, 42.2452}, Tz::Europe_Rome, CountryId{"IT"}}, // Capranica-Sutri railway station
    {Coordinate{8.51333, 39.1639}, Tz::Europe_Rome, CountryId{"IT"}}, // Carbonia Serbariu railway station
    {Coordinate{13.1867, 38.1477}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969226
    {Coordinate{13.2182, 38.1635}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969227
    {Coordinate{7.72776, 44.8471}, Tz::Europe_Rome, CountryId{"IT"}}, // Carmagnola railway station
    {Coordinate{14.4438, 38.0343}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969231
    {Coordinate{13.1331, 46.3738}, Tz::Europe_Rome, CountryId{"IT"}}, // Carnia railway station
    {Coordinate{17.6837, 40.7372}, Tz::Europe_Rome, CountryId{"IT"}}, // Carovigno railway station
    {Coordinate{14.2995, 41.7124}, Tz::Europe_Rome, CountryId{"IT"}}, // Carovilli-Roccasicura railway station
    {Coordinate{14.327, 41.5882}, Tz::Europe_Rome, CountryId{"IT"}}, // Carpinone railway station
    {Coordinate{10.8916, 44.7828}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969241
    {Coordinate{13.0803, 42.0955}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969245
    {Coordinate{12.6044, 41.7883}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969249
    {Coordinate{14.6329, 42.1936}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969253
    {Coordinate{11.273, 44.4825}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969255
    {Coordinate{11.2762, 44.4744}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969256
    {Coordinate{8.45972, 45.1339}, Tz::Europe_Rome, CountryId{"IT"}}, // Casale Monferrato railway station
    {Coordinate{9.65364, 45.1825}, Tz::Europe_Rome, CountryId{"IT"}}, // Casalpusterlengo railway station
    {Coordinate{12.8405, 45.9531}, Tz::Europe_Rome, CountryId{"IT"}}, // Casarsa railway station
    {Coordinate{10.5453, 43.6746}, Tz::Europe_Rome, CountryId{"IT"}}, // Cascina railway station
    {Coordinate{8.74392, 45.675}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969273
    {Coordinate{14.3278, 41.0689}, Tz::Europe_Rome, CountryId{"IT"}}, // Caserta railway station
    {Coordinate{14.2987, 40.9076}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969278
    {Coordinate{8.53343, 44.7515}, Tz::Europe_Rome, CountryId{"IT"}}, // Cassine train station
    {Coordinate{13.832, 41.4845}, Tz::Europe_Rome, CountryId{"IT"}}, // Cassino railway station
    {Coordinate{11.404, 45.1195}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969281
    {Coordinate{10.5641, 43.1687}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969283
    {Coordinate{10.9153, 44.0124}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969284
    {Coordinate{12.6521, 41.7469}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel Gandolfo train station
    {Coordinate{12.8649, 41.9885}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969292
    {Coordinate{14.1121, 41.778}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel di Sangro railway station
    {Coordinate{14.1086, 38.0145}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelbuono railway station
    {Coordinate{13.5369, 38.0603}, Tz::Europe_Rome, CountryId{"IT"}}, // Casteldaccia railway station
    {Coordinate{11.2749, 44.504}, Tz::Europe_Rome, CountryId{"IT"}}, // Casteldebole railway station
    {Coordinate{10.1767, 44.8364}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelguelfo railway station
    {Coordinate{11.9339, 45.6667}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelfranco Veneto railway station
    {Coordinate{14.4838, 40.7014}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969308
    {Coordinate{16.9286, 40.6195}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellaneta railway station
    {Coordinate{8.3127, 44.8787}, Tz::Europe_Rome, CountryId{"IT"}}, // Castello d’Annone railway station
    {Coordinate{10.4092, 44.1165}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelnuovo Garfagnana
    {Coordinate{9.98237, 45.1002}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelvetro railway station
    {Coordinate{10.4144, 43.4045}, Tz::Europe_Rome, CountryId{"IT"}}, // Castiglioncello railway station
    {Coordinate{16.2441, 39.3557}, Tz::Europe_Rome, CountryId{"IT"}}, // Castiglione Cosentino railway station
    {Coordinate{13.4106, 41.5329}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969329
    {Coordinate{15.0747, 37.4928}, Tz::Europe_Rome, CountryId{"IT"}}, // Catania Acquicella railway station
    {Coordinate{15.1127, 37.5342}, Tz::Europe_Rome, CountryId{"IT"}}, // Catania Ognina railway station
    {Coordinate{16.5629, 38.8655}, Tz::Europe_Rome, CountryId{"IT"}}, // Catanzaro railway station
    {Coordinate{14.6883, 37.5621}, Tz::Europe_Rome, CountryId{"IT"}}, // Catenanuova-Centuripe railway station
    {Coordinate{16.6128, 38.8219}, Tz::Europe_Rome, CountryId{"IT"}}, // Catanzaro Lido railway station
    {Coordinate{7.69179, 44.7083}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavallermaggiore railway station
    {Coordinate{14.7083, 40.7036}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969353
    {Coordinate{9.37262, 44.2936}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969354
    {Coordinate{14.187, 40.8197}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavalleggeri Aosta railway station
    {Coordinate{12.6496, 41.6929}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969359
    {Coordinate{13.3365, 41.5737}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969360
    {Coordinate{10.5145, 43.3105}, Tz::Europe_Rome, CountryId{"IT"}}, // Cecina railway station
    {Coordinate{13.5436, 42.0772}, Tz::Europe_Rome, CountryId{"IT"}}, // Celano-Ovindoli railway station
    {Coordinate{13.5235, 41.5241}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969364
    {Coordinate{13.5982, 42.0613}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969365
    {Coordinate{11.871, 45.0505}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969367
    {Coordinate{11.2142, 45.1958}, Tz::Europe_Rome, CountryId{"IT"}}, // Cerea railway station
    {Coordinate{8.23429, 44.0989}, Tz::Europe_Rome, CountryId{"IT"}}, // Ceriale railway halt
    {Coordinate{15.8973, 41.3155}, Tz::Europe_Rome, CountryId{"IT"}}, // Cerignola Campagna railway station
    {Coordinate{11.0379, 43.5472}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969374
    {Coordinate{12.3472, 44.2585}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969377
    {Coordinate{14.6164, 41.0289}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969379
    {Coordinate{13.3428, 45.8238}, Tz::Europe_Rome, CountryId{"IT"}}, // Cervignano-Aquileia-Grado railway station
    {Coordinate{12.3266, 42.0621}, Tz::Europe_Rome, CountryId{"IT"}}, // Cesano di Roma railway station
    {Coordinate{8.03175, 44.3896}, Tz::Europe_Rome, CountryId{"IT"}}, // Ceva railway station
    {Coordinate{12.2492, 44.1453}, Tz::Europe_Rome, CountryId{"IT"}}, // Cesena railway station
    {Coordinate{11.445, 42.3881}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiarone
    {Coordinate{9.40507, 46.3196}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969397
    {Coordinate{7.82333, 45.0063}, Tz::Europe_Rome, CountryId{"IT"}}, // Chieri railway station
    {Coordinate{9.3225, 44.315}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiavari railway station
    {Coordinate{6.9877, 45.1197}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiomonte
    {Coordinate{14.1383, 42.3569}, Tz::Europe_Rome, CountryId{"IT"}}, // Chieti railway station
    {Coordinate{12.2755, 45.2103}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969406
    {Coordinate{11.5726, 46.6427}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiusa railway halt
    {Coordinate{11.9578, 43.0025}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969409
    {Coordinate{7.89, 45.1933}, Tz::Europe_Rome, CountryId{"IT"}}, // Chivasso railway station
    {Coordinate{12.5992, 41.8039}, Tz::Europe_Rome, CountryId{"IT"}}, // Ciampino railway station
    {Coordinate{12.8277, 41.5866}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969418
    {Coordinate{17.4569, 40.8165}, Tz::Europe_Rome, CountryId{"IT"}}, // Cisternino railway station
    {Coordinate{10.0328, 44.6354}, Tz::Europe_Rome, CountryId{"IT"}}, // Citerna Taro railway station
    {Coordinate{11.7895, 45.6439}, Tz::Europe_Rome, CountryId{"IT"}}, // Cittadella railway station
    {Coordinate{13.4591, 41.8707}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969426
    {Coordinate{13.726, 43.3092}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969427
    {Coordinate{13.4247, 41.9165}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969431
    {Coordinate{12.2349, 44.382}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Classe
    {Coordinate{11.7981, 42.0883}, Tz::Europe_Rome, CountryId{"IT"}}, // Civitavecchia railway station
    {Coordinate{9.97778, 45.5611}, Tz::Europe_Rome, CountryId{"IT"}}, // Coccaglio railway station
    {Coordinate{9.70168, 45.155}, Tz::Europe_Rome, CountryId{"IT"}}, // Codogno train station
    {Coordinate{14.6657, 40.7676}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969444
    {Coordinate{12.9767, 45.9656}, Tz::Europe_Rome, CountryId{"IT"}}, // Codroipo railway station
    {Coordinate{8.64392, 44.3895}, Tz::Europe_Rome, CountryId{"IT"}}, // Cogoleto
    {Coordinate{13.6017, 41.5557}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969449
    {Coordinate{12.7284, 41.8327}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969451
    {Coordinate{10.2122, 44.7553}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969454
    {Coordinate{13.0026, 41.7401}, Tz::Europe_Rome, CountryId{"IT"}}, // Colleferro-Segni-Paliano railway station
    {Coordinate{7.57413, 45.079}, Tz::Europe_Rome, CountryId{"IT"}}, // Collegno
    {Coordinate{12.5227, 42.2976}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969457
    {Coordinate{13.1506, 42.0972}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969458
    {Coordinate{8.75214, 46.0248}, Tz::Europe_Rome, CountryId{"IT"}}, // Colmegna railway halt
    {Coordinate{12.756, 41.8386}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969461
    {Coordinate{11.3589, 43.7824}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969466
    {Coordinate{11.5316, 43.8651}, Tz::Europe_Rome, CountryId{"IT"}}, // Contea-Londa railway station
    {Coordinate{10.9199, 43.9941}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969476
    {Coordinate{12.878, 45.8506}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969477
    {Coordinate{13.4617, 45.9576}, Tz::Europe_Rome, CountryId{"IT"}}, // Cormons railway station
    {Coordinate{13.0106, 46.2206}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969481
    {Coordinate{9.71636, 44.1186}, Tz::Europe_Rome, CountryId{"IT"}}, // Corniglia
    {Coordinate{16.26, 39.3189}, Tz::Europe_Rome, CountryId{"IT"}}, // Cosenza railway station
    {Coordinate{8.1761, 45.5643}, Tz::Europe_Rome, CountryId{"IT"}}, // Cossato railway station
    {Coordinate{11.938, 44.3871}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969495
    {Coordinate{11.1524, 44.7191}, Tz::Europe_Rome, CountryId{"IT"}}, // Crevalcore train station
    {Coordinate{17.1085, 39.0845}, Tz::Europe_Rome, CountryId{"IT"}}, // Crotone railway station
    {Coordinate{13.3775, 41.9648}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969507
    {Coordinate{12.7574, 45.9455}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969508
    {Coordinate{7.53639, 44.3878}, Tz::Europe_Rome, CountryId{"IT"}}, // Cuneo railway station
    {Coordinate{8.96611, 39.3047}, Tz::Europe_Rome, CountryId{"IT"}}, // Decimomannu railway station
    {Coordinate{8.30847, 44.448}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969518
    {Coordinate{9.51914, 44.2173}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969521
    {Coordinate{8.07863, 43.9096}, Tz::Europe_Rome, CountryId{"IT"}}, // Diano Marina railway station
    {Coordinate{9.21833, 45.6203}, Tz::Europe_Rome, CountryId{"IT"}}, // Desio railway station
    {Coordinate{11.5192, 43.8935}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969530
    {Coordinate{14.4624, 37.5645}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969533
    {Coordinate{12.2256, 46.7248}, Tz::Europe_Rome, CountryId{"IT"}}, // Dobbiaco
    {Coordinate{12.0717, 45.4534}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969535
    {Coordinate{8.29611, 46.1153}, Tz::Europe_Rome, CountryId{"IT"}}, // Domodossola railway station
    {Coordinate{10.9147, 45.3923}, Tz::Europe_Rome, CountryId{"IT"}}, // Dossobuono
    {Coordinate{15.0525, 40.6111}, Tz::Europe_Rome, CountryId{"IT"}}, // Eboli railway station
    {Coordinate{10.9493, 43.716}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969560
    {Coordinate{10.1537, 44.1701}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969567
    {Coordinate{11.663, 45.221}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969571
    {Coordinate{12.9055, 43.3453}, Tz::Europe_Rome, CountryId{"IT"}}, // Fabriano train station
    {Coordinate{13.9717, 41.1234}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969573
    {Coordinate{13.3973, 43.6303}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969575
    {Coordinate{13.3817, 43.6265}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969577
    {Coordinate{11.8831, 44.2933}, Tz::Europe_Rome, CountryId{"IT"}}, // Faenza railway station
    {Coordinate{15.0805, 38.1196}, Tz::Europe_Rome, CountryId{"IT"}}, // Falcone Station
    {Coordinate{12.7705, 46.1872}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969581
    {Coordinate{12.6482, 42.1556}, Tz::Europe_Rome, CountryId{"IT"}}, // Fara Sabina-Montelibretti train station
    {Coordinate{17.3858, 40.8516}, Tz::Europe_Rome, CountryId{"IT"}}, // Fasano railway station
    {Coordinate{8.43756, 44.8933}, Tz::Europe_Rome, CountryId{"IT"}}, // Felizzano train station
    {Coordinate{13.2471, 41.6565}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969590
    {Coordinate{11.9113, 46.013}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969592
    {Coordinate{8.32557, 44.3655}, Tz::Europe_Rome, CountryId{"IT"}}, // Ferrania
    {Coordinate{8.755, 45.6086}, Tz::Europe_Rome, CountryId{"IT"}}, // Ferno-Lonate Pozzolo railway station
    {Coordinate{13.4634, 38.0866}, Tz::Europe_Rome, CountryId{"IT"}}, // Ficarazzi railway station
    {Coordinate{11.6039, 44.8428}, Tz::Europe_Rome, CountryId{"IT"}}, // Ferrara railway station
    {Coordinate{13.3537, 38.1411}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiera railway station
    {Coordinate{12.5085, 41.9793}, Tz::Europe_Rome, CountryId{"IT"}}, // Fidene railway station
    {Coordinate{12.3188, 41.8099}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiera di Roma railway station
    {Coordinate{10.0632, 44.8676}, Tz::Europe_Rome, CountryId{"IT"}}, // Fidenza railway station
    {Coordinate{11.308, 43.8304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969604
    {Coordinate{9.93353, 44.3315}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969605
    {Coordinate{11.4733, 43.6217}, Tz::Europe_Rome, CountryId{"IT"}}, // Figline Valdarno railway station
    {Coordinate{9.68222, 46.6753}, Tz::Europe_Zurich, CountryId{"CH"}}, // Filisur
    {Coordinate{9.91729, 44.9286}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiorenzuola railway station
    {Coordinate{11.2183, 43.8194}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969616
    {Coordinate{14.7758, 40.7611}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969620
    {Coordinate{11.3092, 43.7691}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969621
    {Coordinate{11.2503, 43.7874}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969623
    {Coordinate{10.0916, 44.2028}, Tz::Europe_Rome, CountryId{"IT"}}, // Fivizzano-Gassano railway station
    {Coordinate{12.2511, 41.7942}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiumicino Aeroporto railway station
    {Coordinate{11.7278, 44.2033}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969629
    {Coordinate{10.7552, 42.9267}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969632
    {Coordinate{13.562, 41.6182}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969633
    {Coordinate{13.5567, 41.6096}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969634
    {Coordinate{15.5561, 41.4656}, Tz::Europe_Rome, CountryId{"IT"}}, // Foggia railway station
    {Coordinate{12.5752, 45.9676}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969636
    {Coordinate{12.7111, 42.9544}, Tz::Europe_Rome, CountryId{"IT"}}, // Foligno railway station
    {Coordinate{13.8638, 41.4468}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969638
    {Coordinate{15.7254, 40.8668}, Tz::Europe_Rome, CountryId{"IT"}}, // Forenza train station
    {Coordinate{12.964, 46.2035}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969642
    {Coordinate{12.128, 44.1941}, Tz::Europe_Rome, CountryId{"IT"}}, // Forlimpopoli-Bertinoro railway station
    {Coordinate{10.1021, 44.6936}, Tz::Europe_Rome, CountryId{"IT"}}, // Fornovo railway station
    {Coordinate{14.5229, 42.237}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969645
    {Coordinate{10.1995, 43.9779}, Tz::Europe_Rome, CountryId{"IT"}}, // Forte dei Marmi-Seravezza-Querceta
    {Coordinate{7.71806, 44.5503}, Tz::Europe_Rome, CountryId{"IT"}}, // Fossano railway station
    {Coordinate{13.6058, 41.2586}, Tz::Europe_Rome, CountryId{"IT"}}, // Formia-Gaeta railway station
    {Coordinate{9.555, 44.2017}, Tz::Europe_Rome, CountryId{"IT"}}, // Framura railway station
    {Coordinate{17.5839, 40.5231}, Tz::Europe_Rome, CountryId{"IT"}}, // Railway station of Francavilla Fontana
    {Coordinate{11.6427, 45.0386}, Tz::Europe_Rome, CountryId{"IT"}}, // Fratta train station
    {Coordinate{12.678, 41.8069}, Tz::Europe_Rome, CountryId{"IT"}}, // Frascati railway station
    {Coordinate{13.3289, 41.6254}, Tz::Europe_Rome, CountryId{"IT"}}, // Frosinone railway station
    {Coordinate{8.68268, 44.8418}, Tz::Europe_Rome, CountryId{"IT"}}, // Frugarolo Boscomarengo railway station
    {Coordinate{11.3709, 44.5937}, Tz::Europe_Rome, CountryId{"IT"}}, // Funo Centergross station
    {Coordinate{12.3145, 45.5453}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969671
    {Coordinate{12.3277, 44.1168}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969678
    {Coordinate{8.79839, 45.6598}, Tz::Europe_Rome, CountryId{"IT"}}, // Gallarate railway station
    {Coordinate{12.4321, 44.1708}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969686
    {Coordinate{12.608, 42.273}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969687
    {Coordinate{10.9336, 42.9479}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969691
    {Coordinate{10.8941, 45.1767}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969693
    {Coordinate{12.4272, 41.9278}, Tz::Europe_Rome, CountryId{"IT"}}, // Gemelli railway halt
    {Coordinate{8.7731, 44.4585}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969698
    {Coordinate{13.1283, 46.2745}, Tz::Europe_Rome, CountryId{"IT"}}, // Gemona del Friuli railway station
    {Coordinate{8.86528, 44.4347}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Borzoli railway station
    {Coordinate{8.84625, 44.4338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969701
    {Coordinate{8.90028, 44.4592}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Bolzaneto railway station
    {Coordinate{8.82361, 44.4419}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969703
    {Coordinate{8.865, 44.4147}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Cornigliano railway station
    {Coordinate{9.03972, 44.3811}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Nervi
    {Coordinate{8.81694, 44.4261}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Pegli
    {Coordinate{8.90583, 44.4942}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Pontedecimo railway station
    {Coordinate{8.78903, 44.4254}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Pra railway station
    {Coordinate{8.99611, 44.3883}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Quarto dei Mille
    {Coordinate{8.89139, 44.4361}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Rivarolo railway station
    {Coordinate{8.84806, 44.4225}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Sestri Ponente Aeroporto
    {Coordinate{8.98167, 44.3978}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Sturla
    {Coordinate{8.71417, 44.4164}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Vesima
    {Coordinate{8.7583, 44.4284}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Voltri
    {Coordinate{13.3582, 38.1354}, Tz::Europe_Rome, CountryId{"IT"}}, // Giachery railway halt
    {Coordinate{15.1936, 37.7302}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969728
    {Coordinate{15.8973, 38.4238}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969729
    {Coordinate{16.917, 40.7969}, Tz::Europe_Rome, CountryId{"IT"}}, // Gioia del Colle railway station
    {Coordinate{14.1038, 40.9351}, Tz::Europe_Rome, CountryId{"IT"}}, // Giugliano-Qualiano railway station
    {Coordinate{9.62694, 40.9947}, Tz::Europe_Rome, CountryId{"IT"}}, // Golfo Aranci railway station
    {Coordinate{13.6075, 45.9328}, Tz::Europe_Rome, CountryId{"IT"}}, // Gorizia Centrale railway station
    {Coordinate{10.1091, 44.1911}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969746
    {Coordinate{14.6412, 37.2094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969747
    {Coordinate{11.9373, 44.3574}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969748
    {Coordinate{16.4189, 40.8251}, Tz::Europe_Rome, CountryId{"IT"}}, // Gravina in Puglia railway station
    {Coordinate{11.6248, 46.0151}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969753
    {Coordinate{11.181, 44.2583}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969754
    {Coordinate{13.8702, 42.9939}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969760
    {Coordinate{7.59944, 45.0681}, Tz::Europe_Rome, CountryId{"IT"}}, // Grugliasco
    {Coordinate{11.1067, 42.7675}, Tz::Europe_Rome, CountryId{"IT"}}, // Grosseto
    {Coordinate{12.4829, 44.1307}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969807
    {Coordinate{8.53972, 39.3106}, Tz::Europe_Rome, CountryId{"IT"}}, // Iglesias railway station
    {Coordinate{11.1827, 43.8397}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969811
    {Coordinate{8.03897, 43.8921}, Tz::Europe_Rome, CountryId{"IT"}}, // Imperia Oneglia railway station
    {Coordinate{11.7188, 44.3592}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969814
    {Coordinate{11.4525, 43.6559}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969821
    {Coordinate{12.406, 41.9633}, Tz::Europe_Rome, CountryId{"IT"}}, // Ipogeo degli Ottavi railway station
    {Coordinate{14.2353, 41.5971}, Tz::Europe_Rome, CountryId{"IT"}}, // Isernia railway station
    {Coordinate{13.5806, 41.6813}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969828
    {Coordinate{8.95752, 44.6466}, Tz::Europe_Rome, CountryId{"IT"}}, // Isola del Cantone railway station
    {Coordinate{11.0132, 45.2695}, Tz::Europe_Rome, CountryId{"IT"}}, // Isola della Scala railway station
    {Coordinate{13.2501, 38.1949}, Tz::Europe_Rome, CountryId{"IT"}}, // Isola delle Femmine railway station
    {Coordinate{13.5457, 41.2714}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969837
    {Coordinate{15.84, 38.6306}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969840
    {Coordinate{9.88111, 46.8692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Klosters Platz
    {Coordinate{12.4035, 41.9853}, Tz::Europe_Rome, CountryId{"IT"}}, // La Giustiniana railway station
    {Coordinate{12.3805, 42.0028}, Tz::Europe_Rome, CountryId{"IT"}}, // La Storta railway station
    {Coordinate{9.83968, 44.1231}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969896
    {Coordinate{9.81472, 44.1114}, Tz::Europe_Rome, CountryId{"IT"}}, // La Spezia Centrale railway station
    {Coordinate{12.8898, 41.7831}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969900
    {Coordinate{15.7626, 40.1204}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969903
    {Coordinate{8.15875, 43.9812}, Tz::Europe_Rome, CountryId{"IT"}}, // Laigueglia
    {Coordinate{11.3236, 46.4345}, Tz::Europe_Rome, CountryId{"IT"}}, // Laives train station
    {Coordinate{12.2656, 45.7102}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969912
    {Coordinate{16.2556, 38.9211}, Tz::Europe_Rome, CountryId{"IT"}}, // Lamezia Terme Centrale railway station
    {Coordinate{8.93228, 46.0398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lamone-Cadempino railway station
    {Coordinate{12.6898, 41.6739}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969915
    {Coordinate{14.6813, 40.7698}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969917
    {Coordinate{14.9181, 41.8002}, Tz::Europe_Rome, CountryId{"IT"}}, // Larino railway station
    {Coordinate{11.1026, 43.7698}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969920
    {Coordinate{17.7177, 40.5579}, Tz::Europe_Rome, CountryId{"IT"}}, // Latiano railway station
    {Coordinate{9.34639, 44.3056}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969926
    {Coordinate{12.9461, 41.5381}, Tz::Europe_Rome, CountryId{"IT"}}, // Latina railway station
    {Coordinate{11.8799, 44.5596}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969929
    {Coordinate{11.0962, 46.1482}, Tz::Europe_Rome, CountryId{"IT"}}, // Lavis
    {Coordinate{11.3048, 45.1893}, Tz::Europe_Rome, CountryId{"IT"}}, // Legnago railway station
    {Coordinate{18.1661, 40.3456}, Tz::Europe_Rome, CountryId{"IT"}}, // Lecce railway station
    {Coordinate{11.5917, 45.0819}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969939
    {Coordinate{8.91083, 45.5936}, Tz::Europe_Rome, CountryId{"IT"}}, // Legnano railway station
    {Coordinate{14.9976, 37.3008}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969942
    {Coordinate{14.9812, 37.34}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969944
    {Coordinate{15.3031, 37.8774}, Tz::Europe_Rome, CountryId{"IT"}}, // Letojanni railway station
    {Coordinate{10.7606, 45.1235}, Tz::Europe_Rome, CountryId{"IT"}}, // Levata railway halt
    {Coordinate{9.61578, 44.1741}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969952
    {Coordinate{11.3049, 46.0057}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969953
    {Coordinate{13.938, 37.1059}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969955
    {Coordinate{15.1863, 40.8749}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969964
    {Coordinate{8.07372, 45.2833}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969970
    {Coordinate{8.2546, 44.1224}, Tz::Europe_Rome, CountryId{"IT"}}, // Loano railway station
    {Coordinate{10.3358, 43.5542}, Tz::Europe_Rome, CountryId{"IT"}}, // Livorno Centrale railway station
    {Coordinate{11.3452, 45.4131}, Tz::Europe_Rome, CountryId{"IT"}}, // Lonigo railway station
    {Coordinate{12.3018, 46.2676}, Tz::Europe_Rome, CountryId{"IT"}}, // Longarone-Zoldo railway station
    {Coordinate{10.5061, 43.8375}, Tz::Europe_Rome, CountryId{"IT"}}, // Lucca railway station
    {Coordinate{8.94639, 45.9892}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lugano-Paradiso railway station
    {Coordinate{8.73736, 45.9969}, Tz::Europe_Rome, CountryId{"IT"}}, // Luino railway station
    {Coordinate{12.6675, 41.9238}, Tz::Europe_Rome, CountryId{"IT"}}, // Lunghezza railway station
    {Coordinate{10.0159, 44.0748}, Tz::Europe_Rome, CountryId{"IT"}}, // Luni Station
    {Coordinate{8.73757, 46.0432}, Tz::Europe_Rome, CountryId{"IT"}}, // Maccagno railway station
    {Coordinate{12.2377, 41.879}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3969999
    {Coordinate{8.77306, 40.2675}, Tz::Europe_Rome, CountryId{"IT"}}, // Macomer railway station
    {Coordinate{13.455, 43.2936}, Tz::Europe_Rome, CountryId{"IT"}}, // Macerata railway station
    {Coordinate{12.1506, 45.5148}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970011
    {Coordinate{12.431, 41.8344}, Tz::Europe_Rome, CountryId{"IT"}}, // Magliana railway halt
    {Coordinate{11.2326, 46.2879}, Tz::Europe_Rome, CountryId{"IT"}}, // Magrè-Cortaccia
    {Coordinate{8.88068, 45.4682}, Tz::Europe_Rome, CountryId{"IT"}}, // Magenta railway station
    {Coordinate{8.71111, 45.6281}, Tz::Europe_Rome, CountryId{"IT"}}, // Malpensa T1 railway station
    {Coordinate{9.72922, 44.1049}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970025
    {Coordinate{15.9081, 41.6231}, Tz::Europe_Rome, CountryId{"IT"}}, // Manfredonia railway station
    {Coordinate{10.1325, 45.3572}, Tz::Europe_Rome, CountryId{"IT"}}, // Manerbio
    {Coordinate{12.7142, 46.1702}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970035
    {Coordinate{10.8311, 45.1505}, Tz::Europe_Rome, CountryId{"IT"}}, // Mantova Frassine
    {Coordinate{15.7098, 39.9953}, Tz::Europe_Rome, CountryId{"IT"}}, // Maratea station
    {Coordinate{8.62625, 45.6295}, Tz::Europe_Rome, CountryId{"IT"}}, // Marano Ticino railway station
    {Coordinate{16.888, 41.117}, Tz::Europe_Rome, CountryId{"IT"}}, // Bari Marconi railway halt
    {Coordinate{12.6129, 41.4724}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970042
    {Coordinate{10.7836, 45.1589}, Tz::Europe_Rome, CountryId{"IT"}}, // Mantua railway station
    {Coordinate{12.048, 41.9792}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970047
    {Coordinate{15.7361, 39.9597}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970050
    {Coordinate{8.97394, 45.9324}, Tz::Europe_Zurich, CountryId{"CH"}}, // Maroggia-Melano railway station
    {Coordinate{12.656, 41.7691}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970055
    {Coordinate{13.1373, 43.7697}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970056
    {Coordinate{8.64139, 39.7528}, Tz::Europe_Rome, CountryId{"IT"}}, // Marrubiu-Terralba-Arborea railway station
    {Coordinate{15.1903, 37.7551}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970059
    {Coordinate{10.1361, 44.0239}, Tz::Europe_Rome, CountryId{"IT"}}, // Massa Centro railway station
    {Coordinate{11.8278, 44.4488}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970065
    {Coordinate{10.3462, 43.8591}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970066
    {Coordinate{7.05975, 45.1247}, Tz::Europe_Rome, CountryId{"IT"}}, // Meana
    {Coordinate{12.5944, 37.6525}, Tz::Europe_Rome, CountryId{"IT"}}, // Mazara del Vallo Station
    {Coordinate{12.8028, 46.2009}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970075
    {Coordinate{15.6469, 40.9899}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970081
    {Coordinate{15.6501, 38.0255}, Tz::Europe_Rome, CountryId{"IT"}}, // Melito di Porto Salvo railway station
    {Coordinate{9.31944, 45.3564}, Tz::Europe_Rome, CountryId{"IT"}}, // Melegnano railway station
    {Coordinate{12.4546, 45.6134}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970084
    {Coordinate{8.29839, 44.5194}, Tz::Europe_Rome, CountryId{"IT"}}, // Merana railway halt
    {Coordinate{11.1491, 46.673}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970087
    {Coordinate{8.97861, 45.8692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mendrisio railway station
    {Coordinate{17.7989, 40.5608}, Tz::Europe_Rome, CountryId{"IT"}}, // Mesagne railway station
    {Coordinate{16.815, 40.3686}, Tz::Europe_Rome, CountryId{"IT"}}, // Metaponto railway station
    {Coordinate{15.5636, 38.1878}, Tz::Europe_Rome, CountryId{"IT"}}, // Messina Marittima railway station
    {Coordinate{15.5609, 38.1851}, Tz::Europe_Rome, CountryId{"IT"}}, // Messina Centrale railway station
    {Coordinate{11.1286, 46.2072}, Tz::Europe_Rome, CountryId{"IT"}}, // Mezzocorona
    {Coordinate{8.92868, 46.0942}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mezzovico railway station
    {Coordinate{13.9866, 41.4076}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970106
    {Coordinate{16.0598, 38.5772}, Tz::Europe_Rome, CountryId{"IT"}}, // Mileto railway station
    {Coordinate{14.7833, 37.2771}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970128
    {Coordinate{16.0752, 41.0818}, Tz::Europe_Rome, CountryId{"IT"}}, // Minervino Murge railway station
    {Coordinate{10.1938, 44.1942}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970143
    {Coordinate{13.7208, 41.2578}, Tz::Europe_Rome, CountryId{"IT"}}, // Minturno-Scauri railway station
    {Coordinate{12.1188, 45.4629}, Tz::Europe_Rome, CountryId{"IT"}}, // Mira-Mirano railway halt
    {Coordinate{13.7196, 45.705}, Tz::Europe_Rome, CountryId{"IT"}}, // Miramare
    {Coordinate{11.1115, 44.8917}, Tz::Europe_Rome, CountryId{"IT"}}, // Mirandola railway station
    {Coordinate{14.7541, 36.853}, Tz::Europe_Rome, CountryId{"IT"}}, // Modica railway station
    {Coordinate{12.2331, 45.5619}, Tz::Europe_Rome, CountryId{"IT"}}, // Mogliano Veneto railway station
    {Coordinate{17.081, 41.0573}, Tz::Europe_Rome, CountryId{"IT"}}, // Mola di Bari railway station
    {Coordinate{8.61, 44.6219}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970163
    {Coordinate{10.9613, 44.1001}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970166
    {Coordinate{8.33269, 44.5697}, Tz::Europe_Rome, CountryId{"IT"}}, // Mombaldone-Roccaverano train station
    {Coordinate{8.44117, 44.7625}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970169
    {Coordinate{8.55683, 45.5746}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970170
    {Coordinate{16.5744, 38.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Monasterace-Stilo railway station
    {Coordinate{7.67833, 44.9983}, Tz::Europe_Rome, CountryId{"IT"}}, // Moncalieri railway station
    {Coordinate{8.20754, 44.8417}, Tz::Europe_Rome, CountryId{"IT"}}, // Mongardino railway station
    {Coordinate{9.48694, 44.2423}, Tz::Europe_Rome, CountryId{"IT"}}, // Moneglia
    {Coordinate{11.7483, 45.2467}, Tz::Europe_Rome, CountryId{"IT"}}, // Monselice railway station
    {Coordinate{17.2925, 40.9521}, Tz::Europe_Rome, CountryId{"IT"}}, // Monopoli railway station
    {Coordinate{13.5436, 45.8075}, Tz::Europe_Rome, CountryId{"IT"}}, // Monfalcone railway station
    {Coordinate{11.4675, 45.2329}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970183
    {Coordinate{11.5952, 42.3348}, Tz::Europe_Rome, CountryId{"IT"}}, // Montalto di Castro
    {Coordinate{11.0084, 43.9128}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970188
    {Coordinate{11.3616, 42.9815}, Tz::Europe_Rome, CountryId{"IT"}}, // Monte Antico
    {Coordinate{12.0539, 45.7764}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970194
    {Coordinate{13.1474, 43.5}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970196
    {Coordinate{10.7706, 43.8814}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970198
    {Coordinate{10.7809, 43.8796}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970199
    {Coordinate{14.9471, 40.6166}, Tz::Europe_Rome, CountryId{"IT"}}, // Montecorvino railway halt
    {Coordinate{8.2393, 44.8187}, Tz::Europe_Rome, CountryId{"IT"}}, // Montegrosso railway station
    {Coordinate{11.0189, 43.7335}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970203
    {Coordinate{14.8509, 42.0333}, Tz::Europe_Rome, CountryId{"IT"}}, // Montenero-Petacciato railway station
    {Coordinate{15.0329, 40.8447}, Tz::Europe_Rome, CountryId{"IT"}}, // Montella Station
    {Coordinate{11.0689, 42.8697}, Tz::Europe_Rome, CountryId{"IT"}}, // Montepescali train station
    {Coordinate{11.8566, 43.1353}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970211
    {Coordinate{12.6587, 46.1482}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970212
    {Coordinate{11.4198, 43.2301}, Tz::Europe_Rome, CountryId{"IT"}}, // Monteroni d'Arbia
    {Coordinate{9.64898, 44.1457}, Tz::Europe_Rome, CountryId{"IT"}}, // Monterosso
    {Coordinate{14.1514, 42.5165}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970218
    {Coordinate{9.32278, 40.8297}, Tz::Europe_Rome, CountryId{"IT"}}, // Monti-Telti railway station
    {Coordinate{10.1238, 44.1658}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970225
    {Coordinate{11.2623, 44.3222}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970227
    {Coordinate{13.1945, 41.6669}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970230
    {Coordinate{8.73434, 45.7298}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970232
    {Coordinate{13.488, 41.852}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970233
    {Coordinate{8.73217, 45.2522}, Tz::Europe_Rome, CountryId{"IT"}}, // Mortara railway station
    {Coordinate{12.6076, 45.779}, Tz::Europe_Rome, CountryId{"IT"}}, // Motta di Livenza railway station
    {Coordinate{9.13029, 44.3623}, Tz::Europe_Rome, CountryId{"IT"}}, // Mulinetti railway station
    {Coordinate{12.4087, 41.8248}, Tz::Europe_Rome, CountryId{"IT"}}, // Muratella railway halt
    {Coordinate{11.4004, 43.1141}, Tz::Europe_Rome, CountryId{"IT"}}, // Murlo
    {Coordinate{13.1323, 45.8169}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970254
    {Coordinate{14.1947, 40.8225}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Campi Flegrei railway station
    {Coordinate{14.2878, 40.8537}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Gianturco railway station
    {Coordinate{14.2192, 40.8314}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Mergellina railway halt
    {Coordinate{14.2442, 40.8476}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Montesanto railway halt
    {Coordinate{14.255, 40.8553}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Piazza Cavour railway halt
    {Coordinate{14.2335, 40.8375}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Piazza Amedeo railway station
    {Coordinate{14.2707, 40.8526}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Piazza Garibaldi railway station
    {Coordinate{10.4869, 43.686}, Tz::Europe_Rome, CountryId{"IT"}}, // Station Navacchio
    {Coordinate{12.4766, 42.4979}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970289
    {Coordinate{12.662, 41.4594}, Tz::Europe_Rome, CountryId{"IT"}}, // Nettuno railway station
    {Coordinate{15.9338, 38.5494}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970292
    {Coordinate{14.4034, 37.1452}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970295
    {Coordinate{8.36101, 44.7731}, Tz::Europe_Rome, CountryId{"IT"}}, // Nizza Monferrato railway station
    {Coordinate{11.0704, 45.1798}, Tz::Europe_Rome, CountryId{"IT"}}, // Nogara railway station
    {Coordinate{14.5258, 40.9234}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970310
    {Coordinate{14.6362, 40.7449}, Tz::Europe_Rome, CountryId{"IT"}}, // Nocera Inferiore railway station
    {Coordinate{15.0746, 36.8826}, Tz::Europe_Rome, CountryId{"IT"}}, // Noto railway station
    {Coordinate{15.1306, 38.1217}, Tz::Europe_Rome, CountryId{"IT"}}, // Novara-Montalbano-Furnari railway station
    {Coordinate{8.78724, 44.7624}, Tz::Europe_Rome, CountryId{"IT"}}, // Novi Ligure railway station
    {Coordinate{10.4072, 43.83}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970323
    {Coordinate{11.6212, 44.8993}, Tz::Europe_Rome, CountryId{"IT"}}, // Occhiobello train station
    {Coordinate{12.4911, 45.775}, Tz::Europe_Rome, CountryId{"IT"}}, // Oderzo railway station
    {Coordinate{9.49861, 40.9247}, Tz::Europe_Rome, CountryId{"IT"}}, // Olbia railway station
    {Coordinate{8.63294, 45.598}, Tz::Europe_Rome, CountryId{"IT"}}, // Oleggio railway station
    {Coordinate{8.71193, 45.2121}, Tz::Europe_Rome, CountryId{"IT"}}, // Olevano railway station
    {Coordinate{12.3637, 42.0148}, Tz::Europe_Rome, CountryId{"IT"}}, // Olgiata railway station
    {Coordinate{15.0566, 38.1284}, Tz::Europe_Rome, CountryId{"IT"}}, // Oliveri-Tindari railway station
    {Coordinate{15.6206, 41.315}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970344
    {Coordinate{13.0444, 42.0678}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970350
    {Coordinate{12.1383, 42.1668}, Tz::Europe_Rome, CountryId{"IT"}}, // Oriolo railway station
    {Coordinate{8.60417, 39.9019}, Tz::Europe_Rome, CountryId{"IT"}}, // Oristano railway station
    {Coordinate{12.4343, 45.9282}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970356
    {Coordinate{14.4074, 42.3539}, Tz::Europe_Rome, CountryId{"IT"}}, // Ortona railway station
    {Coordinate{9.10611, 40.7133}, Tz::Europe_Rome, CountryId{"IT"}}, // Oschiri railway station
    {Coordinate{12.4089, 42.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Orte railway station
    {Coordinate{11.2357, 44.5848}, Tz::Europe_Rome, CountryId{"IT"}}, // Osteria Nuova railway halt
    {Coordinate{9.84489, 44.5201}, Tz::Europe_Rome, CountryId{"IT"}}, // Ostia Parmense railway station
    {Coordinate{12.4103, 41.9604}, Tz::Europe_Rome, CountryId{"IT"}}, // Ottavia railway station
    {Coordinate{17.5808, 40.7522}, Tz::Europe_Rome, CountryId{"IT"}}, // Ostuni railway station
    {Coordinate{8.93389, 40.6094}, Tz::Europe_Rome, CountryId{"IT"}}, // Ozieri-Chilivani railway station
    {Coordinate{10.1411, 44.7122}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970380
    {Coordinate{11.4875, 44.4508}, Tz::Europe_Rome, CountryId{"IT"}}, // Ozzano dell'Emilia railway halt
    {Coordinate{12.1617, 45.6692}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970390
    {Coordinate{12.1826, 45.6912}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970391
    {Coordinate{14.6172, 40.7464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970392
    {Coordinate{13.4644, 42.3348}, Tz::Europe_Rome, CountryId{"IT"}}, // Paganica railway station
    {Coordinate{17.0654, 40.6016}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970394
    {Coordinate{15.0147, 40.4217}, Tz::Europe_Rome, CountryId{"IT"}}, // Paestum railway station
    {Coordinate{13.354, 38.1088}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970398
    {Coordinate{9.89505, 45.6024}, Tz::Europe_Rome, CountryId{"IT"}}, // Palazzolo sull’Oglio railway station
    {Coordinate{13.3927, 38.0933}, Tz::Europe_Rome, CountryId{"IT"}}, // Palermo Brancaccio railway station
    {Coordinate{13.3419, 38.1325}, Tz::Europe_Rome, CountryId{"IT"}}, // Palermo Notarbartolo railway station
    {Coordinate{15.8445, 38.3651}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970411
    {Coordinate{12.5742, 41.9034}, Tz::Europe_Rome, CountryId{"IT"}}, // Palmiro Togliatti railway station
    {Coordinate{12.635, 41.7792}, Tz::Europe_Rome, CountryId{"IT"}}, // Pantanella station
    {Coordinate{13.2967, 45.9069}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970415
    {Coordinate{12.2961, 41.7998}, Tz::Europe_Rome, CountryId{"IT"}}, // Parco Leonardo railway station
    {Coordinate{16.0331, 39.3594}, Tz::Europe_Rome, CountryId{"IT"}}, // Paola railway station
    {Coordinate{8.94636, 45.5528}, Tz::Europe_Rome, CountryId{"IT"}}, // Parabiago railway station
    {Coordinate{12.6099, 41.7253}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970429
    {Coordinate{14.7703, 40.7223}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970432
    {Coordinate{12.3528, 46.3862}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970433
    {Coordinate{11.2322, 46.0629}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970434
    {Coordinate{12.8332, 43.5496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970436
    {Coordinate{12.351, 43.0812}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Perugia Silvestrini
    {Coordinate{12.3756, 43.1039}, Tz::Europe_Rome, CountryId{"IT"}}, // Perugia railway station
    {Coordinate{14.2118, 42.4578}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescara Porta Nuova railway station
    {Coordinate{14.2071, 42.4443}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescara San Marco railway halt
    {Coordinate{12.9061, 43.9061}, Tz::Europe_Rome, CountryId{"IT"}}, // Pesaro railway station
    {Coordinate{14.2199, 42.449}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescara Tribunale railway halt
    {Coordinate{10.6861, 43.8869}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970452
    {Coordinate{13.3916, 41.9589}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970453
    {Coordinate{10.7022, 45.4386}, Tz::Europe_Rome, CountryId{"IT"}}, // Peschiera del Garda railway station
    {Coordinate{14.3413, 41.679}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescolanciano-Chiauci railway station
    {Coordinate{7.84134, 44.9651}, Tz::Europe_Rome, CountryId{"IT"}}, // Pessione railway station
    {Coordinate{8.30882, 44.4864}, Tz::Europe_Rome, CountryId{"IT"}}, // Piana railway station
    {Coordinate{12.6325, 42.1038}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970463
    {Coordinate{8.91918, 44.5309}, Tz::Europe_Rome, CountryId{"IT"}}, // Piano Orizzontale railway station
    {Coordinate{11.341, 44.3818}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970471
    {Coordinate{12.3882, 45.9134}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970472
    {Coordinate{10.2967, 44.1827}, Tz::Europe_Rome, CountryId{"IT"}}, // Piazza al Serchio
    {Coordinate{8.92297, 44.6581}, Tz::Europe_Rome, CountryId{"IT"}}, // Pietrabissara railway station
    {Coordinate{8.27732, 44.1456}, Tz::Europe_Rome, CountryId{"IT"}}, // Pietra Ligure railway station
    {Coordinate{10.2296, 43.9559}, Tz::Europe_Rome, CountryId{"IT"}}, // Pietrasanta
    {Coordinate{9.09099, 44.3727}, Tz::Europe_Rome, CountryId{"IT"}}, // Pieve Ligure
    {Coordinate{8.73706, 46.0987}, Tz::Europe_Rome, CountryId{"IT"}}, // Pino-Tronzano railway station
    {Coordinate{7.337, 44.8875}, Tz::Europe_Rome, CountryId{"IT"}}, // Pinerolo railway station
    {Coordinate{10.5311, 42.9248}, Tz::Europe_Rome, CountryId{"IT"}}, // Piombino
    {Coordinate{12.9504, 46.1794}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970492
    {Coordinate{12.0005, 45.6094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970494
    {Coordinate{10.5449, 42.9287}, Tz::Europe_Rome, CountryId{"IT"}}, // Piombino Marittima
    {Coordinate{13.1414, 38.1719}, Tz::Europe_Rome, CountryId{"IT"}}, // Piraineto railway station
    {Coordinate{10.904, 43.9358}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970504
    {Coordinate{11.1246, 44.9818}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggio Rusco railway station
    {Coordinate{15.5283, 40.0766}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970515
    {Coordinate{16.6886, 40.2073}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970516
    {Coordinate{17.2188, 40.991}, Tz::Europe_Rome, CountryId{"IT"}}, // Polignano a Mare railway station
    {Coordinate{14.5013, 40.7459}, Tz::Europe_Rome, CountryId{"IT"}}, // Pompei station
    {Coordinate{11.4381, 43.7742}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontassieve railway station
    {Coordinate{12.3447, 41.8182}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte Galeria railway station
    {Coordinate{11.5328, 46.6012}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970527
    {Coordinate{10.534, 43.9083}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte a Moriano
    {Coordinate{11.3963, 43.251}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte a Tressa
    {Coordinate{11.9475, 45.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte di Brenta railway station
    {Coordinate{13.3116, 46.5084}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970540
    {Coordinate{8.92981, 44.962}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontecurone railway halt
    {Coordinate{10.629, 43.6623}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970542
    {Coordinate{9.792, 45.0016}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontenure railway station
    {Coordinate{9.07705, 44.3773}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970546
    {Coordinate{11.6123, 44.8732}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970547
    {Coordinate{8.36524, 44.6299}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970548
    {Coordinate{11.7164, 43.4816}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970550
    {Coordinate{9.88753, 44.372}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970552
    {Coordinate{13.8261, 42.1724}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970553
    {Coordinate{10.5404, 42.9965}, Tz::Europe_Rome, CountryId{"IT"}}, // Populonia
    {Coordinate{10.6192, 43.8313}, Tz::Europe_Rome, CountryId{"IT"}}, // Porcari
    {Coordinate{12.6544, 45.9567}, Tz::Europe_Rome, CountryId{"IT"}}, // Pordenone railway station
    {Coordinate{14.3359, 40.8099}, Tz::Europe_Rome, CountryId{"IT"}}, // Portici-Ercolano station
    {Coordinate{8.39611, 40.8331}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto Torres train station
    {Coordinate{8.67405, 45.9584}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto Valtravaglia railway station
    {Coordinate{14.6955, 42.1686}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto di Vasto railway station
    {Coordinate{11.7998, 44.6967}, Tz::Europe_Rome, CountryId{"IT"}}, // Portomaggiore railway station
    {Coordinate{12.8308, 45.781}, Tz::Europe_Rome, CountryId{"IT"}}, // Portogruaro-Caorle railway station
    {Coordinate{15.8066, 40.6301}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970583
    {Coordinate{15.8012, 40.646}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970591
    {Coordinate{11.1427, 46.065}, Tz::Europe_Rome, CountryId{"IT"}}, // Povo-Mesiano train station
    {Coordinate{14.1259, 40.828}, Tz::Europe_Rome, CountryId{"IT"}}, // Pozzuoli Solfatara railway station
    {Coordinate{10.9072, 44.0551}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970599
    {Coordinate{15.7806, 39.9008}, Tz::Europe_Rome, CountryId{"IT"}}, // Railway Station of Praja-Ajeta-Tortora
    {Coordinate{8.55, 44.6489}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970603
    {Coordinate{11.1623, 43.8491}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970605
    {Coordinate{11.0754, 43.8913}, Tz::Europe_Rome, CountryId{"IT"}}, // Prato Borgonuovo railway halt
    {Coordinate{12.2317, 45.6036}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970609
    {Coordinate{11.1092, 43.8786}, Tz::Europe_Rome, CountryId{"IT"}}, // Prato Centrale railway station
    {Coordinate{11.7011, 45.9655}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970614
    {Coordinate{15.1969, 37.1578}, Tz::Europe_Rome, CountryId{"IT"}}, // Priolo-Melilli railway station
    {Coordinate{13.105, 38.1872}, Tz::Europe_Rome, CountryId{"IT"}}, // Punta Raisi railway station
    {Coordinate{12.365, 45.5746}, Tz::Europe_Rome, CountryId{"IT"}}, // Quarto d'Altino railway station
    {Coordinate{10.3728, 43.4549}, Tz::Europe_Rome, CountryId{"IT"}}, // Quercianella-Sonnino railway station
    {Coordinate{8.43547, 44.28}, Tz::Europe_Rome, CountryId{"IT"}}, // Quiliano-Vado Ligure
    {Coordinate{12.4587, 41.8785}, Tz::Europe_Rome, CountryId{"IT"}}, // Quattro Venti railway station
    {Coordinate{7.6169, 44.7712}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970631
    {Coordinate{14.7256, 36.9192}, Tz::Europe_Rome, CountryId{"IT"}}, // Ragusa railway station
    {Coordinate{11.3576, 44.4434}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970641
    {Coordinate{9.14669, 44.3611}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970645
    {Coordinate{9.23111, 44.3511}, Tz::Europe_Rome, CountryId{"IT"}}, // Rapallo railway station
    {Coordinate{13.4859, 45.8536}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970650
    {Coordinate{15.6497, 38.115}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970651
    {Coordinate{15.6501, 38.0255}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970652
    {Coordinate{15.636, 38.1037}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio Calabria Centrale railway station
    {Coordinate{11.9642, 45.6341}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970660
    {Coordinate{14.125, 41.2652}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970663
    {Coordinate{13.5786, 41.7891}, Tz::Europe_Rome, CountryId{"IT"}}, // Ridotti-Collepiano railway halt
    {Coordinate{12.8626, 42.4059}, Tz::Europe_Rome, CountryId{"IT"}}, // Rieti railway station
    {Coordinate{10.4199, 43.7896}, Tz::Europe_Rome, CountryId{"IT"}}, // Rigoli
    {Coordinate{9.04333, 45.5242}, Tz::Europe_Rome, CountryId{"IT"}}, // Rho railway station
    {Coordinate{8.89624, 44.6714}, Tz::Europe_Rome, CountryId{"IT"}}, // Rigoroso railway station
    {Coordinate{12.5087, 44.107}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970672
    {Coordinate{15.6786, 40.9221}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970673
    {Coordinate{12.6181, 44.03}, Tz::Europe_Rome, CountryId{"IT"}}, // Rimini Miramare railway halt
    {Coordinate{10.416, 43.8217}, Tz::Europe_Rome, CountryId{"IT"}}, // Ripafratta
    {Coordinate{7.7262, 45.3284}, Tz::Europe_Rome, CountryId{"IT"}}, // Rivarolo Canavese railway station
    {Coordinate{8.92536, 46.1236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rivera-Bironico railway station
    {Coordinate{7.51082, 44.2964}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970686
    {Coordinate{13.9107, 41.4388}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970687
    {Coordinate{13.6739, 37.7937}, Tz::Europe_Rome, CountryId{"IT"}}, // Roccapalumba-Alia railway station
    {Coordinate{14.0792, 41.8507}, Tz::Europe_Rome, CountryId{"IT"}}, // Roccaraso railway station
    {Coordinate{13.6459, 41.5265}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970690
    {Coordinate{11.193, 42.9577}, Tz::Europe_Rome, CountryId{"IT"}}, // Roccastrada train station
    {Coordinate{7.48527, 44.3144}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970692
    {Coordinate{13.545, 41.818}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970693
    {Coordinate{8.29537, 44.4275}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970694
    {Coordinate{8.3515, 44.8755}, Tz::Europe_Rome, CountryId{"IT"}}, // Rocchetta Tanaro-Cerro railway station
    {Coordinate{12.4366, 41.9198}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Balduina
    {Coordinate{12.4218, 41.9391}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Monte Mario
    {Coordinate{12.5236, 41.9326}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Nomentana railway station
    {Coordinate{12.5457, 41.8975}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Prenestina railway station
    {Coordinate{8.38474, 45.6301}, Tz::Europe_Rome, CountryId{"IT"}}, // Romagnano Sesia railway station
    {Coordinate{11.3989, 46.0361}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970715
    {Coordinate{11.4341, 44.0094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970716
    {Coordinate{8.94938, 44.6145}, Tz::Europe_Rome, CountryId{"IT"}}, // Ronco Scrivia railway station
    {Coordinate{15.9702, 38.4887}, Tz::Europe_Rome, CountryId{"IT"}}, // Rosarno railway station
    {Coordinate{14.015, 42.6778}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970720
    {Coordinate{10.4384, 43.388}, Tz::Europe_Rome, CountryId{"IT"}}, // Rosignano railway station
    {Coordinate{8.66782, 44.5677}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970724
    {Coordinate{7.46164, 45.0782}, Tz::Europe_Rome, CountryId{"IT"}}, // Rosta railway halt
    {Coordinate{8.31753, 45.5372}, Tz::Europe_Rome, CountryId{"IT"}}, // Rovasenda railway station
    {Coordinate{10.0011, 45.5522}, Tz::Europe_Rome, CountryId{"IT"}}, // Rovato railway station
    {Coordinate{10.7971, 45.2525}, Tz::Europe_Rome, CountryId{"IT"}}, // Roverbella
    {Coordinate{12.9912, 42.0266}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970741
    {Coordinate{14.472, 40.7343}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970743
    {Coordinate{11.0339, 45.8908}, Tz::Europe_Rome, CountryId{"IT"}}, // Rovereto railway station
    {Coordinate{10.7802, 44.6561}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970746
    {Coordinate{11.4851, 43.8223}, Tz::Europe_Rome, CountryId{"IT"}}, // Rufina railway station
    {Coordinate{11.7814, 45.0775}, Tz::Europe_Rome, CountryId{"IT"}}, // Rovigo railway station
    {Coordinate{12.0316, 44.3787}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970749
    {Coordinate{12.4985, 45.9486}, Tz::Europe_Rome, CountryId{"IT"}}, // Sacile railway station
    {Coordinate{15.5755, 40.4057}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970758
    {Coordinate{6.88735, 45.0736}, Tz::Europe_Rome, CountryId{"IT"}}, // Salbertrand railway station
    {Coordinate{14.7757, 40.6829}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970764
    {Coordinate{11.535, 45.2228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970765
    {Coordinate{12.636, 41.9153}, Tz::Europe_Rome, CountryId{"IT"}}, // Salone railway station
    {Coordinate{9.98792, 44.8186}, Tz::Europe_Rome, CountryId{"IT"}}, // Salsomaggiore Terme railway station
    {Coordinate{8.11488, 45.4452}, Tz::Europe_Rome, CountryId{"IT"}}, // Salussola railway station
    {Coordinate{12.1114, 45.5354}, Tz::Europe_Rome, CountryId{"IT"}}, // Salzano-Robegano train station
    {Coordinate{8.89917, 39.4831}, Tz::Europe_Rome, CountryId{"IT"}}, // Samassi-Serrenti railway station
    {Coordinate{11.1462, 44.5673}, Tz::Europe_Rome, CountryId{"IT"}}, // Samoggia railway halt
    {Coordinate{11.1896, 44.2163}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970780
    {Coordinate{13.8822, 42.9544}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970781
    {Coordinate{12.2724, 46.7326}, Tz::Europe_Rome, CountryId{"IT"}}, // San Candido
    {Coordinate{8.80083, 39.5578}, Tz::Europe_Rome, CountryId{"IT"}}, // San Gavino railway station
    {Coordinate{12.8362, 45.9416}, Tz::Europe_Rome, CountryId{"IT"}}, // San Giovanni di Casarsa railway halt
    {Coordinate{8.28854, 44.3698}, Tz::Europe_Rome, CountryId{"IT"}}, // San Giuseppe di Cairo train station
    {Coordinate{12.2327, 45.6252}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970848
    {Coordinate{8.63089, 45.8745}, Tz::Europe_Rome, CountryId{"IT"}}, // Sangiano railway halt
    {Coordinate{13.217, 42.097}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970890
    {Coordinate{13.5932, 41.6268}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970899
    {Coordinate{8.43573, 44.3461}, Tz::Europe_Rome, CountryId{"IT"}}, // Santuario railway station
    {Coordinate{15.6277, 40.0779}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970901
    {Coordinate{14.6124, 40.8134}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970902
    {Coordinate{8.67013, 45.1118}, Tz::Europe_Rome, CountryId{"IT"}}, // Sartirana railway station
    {Coordinate{13.2953, 42.3606}, Tz::Europe_Rome, CountryId{"IT"}}, // Sassa-Tornimparte railway station
    {Coordinate{9.96026, 44.1092}, Tz::Europe_Rome, CountryId{"IT"}}, // Sarzana
    {Coordinate{11.2543, 44.395}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970910
    {Coordinate{12.6256, 41.784}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970911
    {Coordinate{8.55389, 40.7294}, Tz::Europe_Rome, CountryId{"IT"}}, // Sassari railway station
    {Coordinate{7.6636, 44.6513}, Tz::Europe_Rome, CountryId{"IT"}}, // Savigliano railway station
    {Coordinate{12.4041, 44.0952}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970918
    {Coordinate{8.47028, 44.3069}, Tz::Europe_Rome, CountryId{"IT"}}, // Savona railway station
    {Coordinate{14.523, 40.7461}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970922
    {Coordinate{10.8367, 42.9417}, Tz::Europe_Rome, CountryId{"IT"}}, // Scarlino
    {Coordinate{11.3574, 45.7106}, Tz::Europe_Rome, CountryId{"IT"}}, // Schio railway station
    {Coordinate{9.91191, 44.3443}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970929
    {Coordinate{11.4968, 43.8413}, Tz::Europe_Rome, CountryId{"IT"}}, // Scopeti railway halt
    {Coordinate{14.8511, 37.2947}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970931
    {Coordinate{13.3444, 42.0531}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970933
    {Coordinate{12.0866, 46.0955}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970936
    {Coordinate{13.2216, 43.7161}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970941
    {Coordinate{14.6574, 41.414}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970942
    {Coordinate{12.5575, 41.8999}, Tz::Europe_Rome, CountryId{"IT"}}, // Serenissima railway station
    {Coordinate{9.20306, 45.6461}, Tz::Europe_Rome, CountryId{"IT"}}, // Seregno railway station
    {Coordinate{8.91667, 39.4261}, Tz::Europe_Rome, CountryId{"IT"}}, // Serramanna-Nuraminis railway station
    {Coordinate{10.8516, 43.9081}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970951
    {Coordinate{8.85855, 44.7239}, Tz::Europe_Rome, CountryId{"IT"}}, // Serravalle Scrivia railway station
    {Coordinate{14.3287, 41.6396}, Tz::Europe_Rome, CountryId{"IT"}}, // Sessano del Molise railway station
    {Coordinate{8.62859, 45.7261}, Tz::Europe_Rome, CountryId{"IT"}}, // Sesto Calende railway station
    {Coordinate{11.1921, 43.8334}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970958
    {Coordinate{9.39752, 44.2762}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970961
    {Coordinate{13.1462, 41.6871}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3970972
    {Coordinate{13.0386, 41.4953}, Tz::Europe_Rome, CountryId{"IT"}}, // Sezze Romano railway station
    {Coordinate{11.3946, 43.7909}, Tz::Europe_Rome, CountryId{"IT"}}, // Sieci railway halt
    {Coordinate{16.4563, 39.7493}, Tz::Europe_Rome, CountryId{"IT"}}, // Sibari railway station
    {Coordinate{15.2908, 40.6056}, Tz::Europe_Rome, CountryId{"IT"}}, // Sicignano railway station
    {Coordinate{11.0958, 43.7756}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971000
    {Coordinate{8.81278, 39.2969}, Tz::Europe_Rome, CountryId{"IT"}}, // Siliqua railway station
    {Coordinate{11.323, 43.3316}, Tz::Europe_Rome, CountryId{"IT"}}, // Siena railway station
    {Coordinate{11.7449, 43.2162}, Tz::Europe_Rome, CountryId{"IT"}}, // Sinalunga train station
    {Coordinate{14.1103, 42.5589}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971004
    {Coordinate{13.6457, 45.7748}, Tz::Europe_Rome, CountryId{"IT"}}, // Sistiana-Visogliano
    {Coordinate{12.2986, 45.977}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971008
    {Coordinate{11.7213, 45.8152}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971010
    {Coordinate{8.51069, 44.9158}, Tz::Europe_Rome, CountryId{"IT"}}, // Solero railway station
    {Coordinate{9.97974, 44.6141}, Tz::Europe_Rome, CountryId{"IT"}}, // Solignano train station
    {Coordinate{8.71294, 45.6864}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971015
    {Coordinate{13.6178, 41.7164}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971017
    {Coordinate{9.10597, 44.3696}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971021
    {Coordinate{16.5474, 38.6845}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971026
    {Coordinate{16.2876, 39.7074}, Tz::Europe_Rome, CountryId{"IT"}}, // Spezzano Albanese Terme railway station
    {Coordinate{8.3181, 44.5394}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971030
    {Coordinate{16.0872, 40.9536}, Tz::Europe_Rome, CountryId{"IT"}}, // Spinazzola railway station
    {Coordinate{12.1762, 45.4901}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971033
    {Coordinate{8.68316, 44.8824}, Tz::Europe_Rome, CountryId{"IT"}}, // Spinetta
    {Coordinate{12.7363, 42.748}, Tz::Europe_Rome, CountryId{"IT"}}, // Spoleto railway station
    {Coordinate{8.41108, 44.2265}, Tz::Europe_Rome, CountryId{"IT"}}, // Spotorno-Noli railway station
    {Coordinate{12.2669, 45.7776}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971039
    {Coordinate{16.5704, 38.7775}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971040
    {Coordinate{18.0464, 40.4392}, Tz::Europe_Rome, CountryId{"IT"}}, // Squinzano railway station
    {Coordinate{11.1186, 42.9291}, Tz::Europe_Rome, CountryId{"IT"}}, // Sticciano
    {Coordinate{12.5687, 42.29}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971046
    {Coordinate{11.6977, 44.1835}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971047
    {Coordinate{8.53172, 45.8846}, Tz::Europe_Rome, CountryId{"IT"}}, // Stresa railway station
    {Coordinate{8.52538, 44.6978}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971051
    {Coordinate{11.5143, 46.051}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971053
    {Coordinate{13.9074, 42.0611}, Tz::Europe_Rome, CountryId{"IT"}}, // Sulmona railway station
    {Coordinate{8.51944, 45.6205}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971056
    {Coordinate{7.05197, 45.1384}, Tz::Europe_Rome, CountryId{"IT"}}, // Susa
    {Coordinate{12.2583, 45.8212}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971059
    {Coordinate{10.7557, 44.9944}, Tz::Europe_Rome, CountryId{"IT"}}, // Suzzara railway station
    {Coordinate{13.2556, 42.0706}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971069
    {Coordinate{11.1645, 42.5645}, Tz::Europe_Rome, CountryId{"IT"}}, // Talamone
    {Coordinate{15.2825, 37.8455}, Tz::Europe_Rome, CountryId{"IT"}}, // Taormina-Giardini railway station
    {Coordinate{13.1965, 46.2092}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971083
    {Coordinate{15.2457, 37.1095}, Tz::Europe_Rome, CountryId{"IT"}}, // Targia railway station
    {Coordinate{17.2242, 40.4835}, Tz::Europe_Rome, CountryId{"IT"}}, // Taranto railway station
    {Coordinate{11.727, 42.2395}, Tz::Europe_Rome, CountryId{"IT"}}, // Tarquinia
    {Coordinate{12.8589, 45.8099}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971090
    {Coordinate{8.93036, 46.0567}, Tz::Europe_Zurich, CountryId{"CH"}}, // Taverne-Torricella railway station
    {Coordinate{14.526, 41.2117}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971093
    {Coordinate{11.7965, 45.3274}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971095
    {Coordinate{13.7034, 37.9801}, Tz::Europe_Rome, CountryId{"IT"}}, // Termini Imerese railway station
    {Coordinate{13.7157, 42.6606}, Tz::Europe_Rome, CountryId{"IT"}}, // Teramo train station
    {Coordinate{8.70064, 45.7818}, Tz::Europe_Rome, CountryId{"IT"}}, // Ternate-Varano Borghi railway station
    {Coordinate{12.0081, 43.2106}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971102
    {Coordinate{14.9929, 42.0007}, Tz::Europe_Rome, CountryId{"IT"}}, // Termoli railway station
    {Coordinate{12.6512, 42.5704}, Tz::Europe_Rome, CountryId{"IT"}}, // Terni railway station
    {Coordinate{8.42864, 44.672}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971107
    {Coordinate{11.6698, 45.9905}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971110
    {Coordinate{15.6983, 40.6073}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Tito
    {Coordinate{10.1664, 46.2152}, Tz::Europe_Rome, CountryId{"IT"}}, // Tirano RhB
    {Coordinate{12.8046, 41.9616}, Tz::Europe_Rome, CountryId{"IT"}}, // Tivoli railway station
    {Coordinate{13.2906, 43.2145}, Tz::Europe_Rome, CountryId{"IT"}}, // Tolentino train station
    {Coordinate{13.2884, 38.1902}, Tz::Europe_Rome, CountryId{"IT"}}, // Palermo Tommaso Natale railway halt
    {Coordinate{12.6699, 41.8262}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971126
    {Coordinate{12.588, 41.906}, Tz::Europe_Rome, CountryId{"IT"}}, // Tor Sapienza railway station
    {Coordinate{14.0451, 41.3589}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971133
    {Coordinate{7.71281, 45.1219}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Stura railway station
    {Coordinate{10.2902, 43.8264}, Tz::Europe_Rome, CountryId{"IT"}}, // Torre del Lago Puccini
    {Coordinate{14.3632, 40.7876}, Tz::Europe_Rome, CountryId{"IT"}}, // Torre del Greco station
    {Coordinate{8.66057, 45.0604}, Tz::Europe_Rome, CountryId{"IT"}}, // Torreberetti railway station
    {Coordinate{15.3516, 38.2067}, Tz::Europe_Rome, CountryId{"IT"}}, // Torregrotta railway station
    {Coordinate{13.9388, 42.8052}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971159
    {Coordinate{13.2825, 45.8258}, Tz::Europe_Rome, CountryId{"IT"}}, // Torviscosa railway station
    {Coordinate{12.5575, 41.8095}, Tz::Europe_Rome, CountryId{"IT"}}, // Torricola railway station
    {Coordinate{8.86204, 44.9}, Tz::Europe_Rome, CountryId{"IT"}}, // Tortona railway station
    {Coordinate{13.6556, 37.9962}, Tz::Europe_Rome, CountryId{"IT"}}, // Trabia railway halt
    {Coordinate{8.69627, 45.8097}, Tz::Europe_Rome, CountryId{"IT"}}, // Travedona-Biandronno railway halt
    {Coordinate{12.8767, 46.1871}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971176
    {Coordinate{12.0861, 42.3315}, Tz::Europe_Rome, CountryId{"IT"}}, // Tre Croci
    {Coordinate{8.73942, 45.4286}, Tz::Europe_Rome, CountryId{"IT"}}, // Trecate railway station
    {Coordinate{9.58045, 45.5217}, Tz::Europe_Rome, CountryId{"IT"}}, // Treviglio Ovest railway halt
    {Coordinate{12.2452, 45.6601}, Tz::Europe_Rome, CountryId{"IT"}}, // Treviso Centrale railway station
    {Coordinate{8.29414, 45.1902}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971198
    {Coordinate{7.73532, 44.9803}, Tz::Europe_Rome, CountryId{"IT"}}, // Trofarello railway station
    {Coordinate{8.16859, 45.3431}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971204
    {Coordinate{15.8947, 38.6723}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971205
    {Coordinate{13.2564, 46.0553}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971213
    {Coordinate{10.4703, 43.3527}, Tz::Europe_Rome, CountryId{"IT"}}, // Vada railway station
    {Coordinate{11.2832, 43.906}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971225
    {Coordinate{11.1308, 43.9618}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971226
    {Coordinate{14.1041, 41.3176}, Tz::Europe_Rome, CountryId{"IT"}}, // Station of Variano-Caianello
    {Coordinate{8.62586, 45.0235}, Tz::Europe_Rome, CountryId{"IT"}}, // Valenza railway station
    {Coordinate{8.68595, 45.1506}, Tz::Europe_Rome, CountryId{"IT"}}, // Valle Lomellina railway station
    {Coordinate{8.61087, 44.9726}, Tz::Europe_Rome, CountryId{"IT"}}, // Valmadonna railway station
    {Coordinate{12.9237, 41.7744}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971239
    {Coordinate{7.63513, 43.7878}, Tz::Europe_Rome, CountryId{"IT"}}, // Vallecrosia
    {Coordinate{12.4425, 41.9027}, Tz::Europe_Rome, CountryId{"IT"}}, // Valle Aurelia railway station
    {Coordinate{8.62008, 45.67}, Tz::Europe_Rome, CountryId{"IT"}}, // Varallo Pombia railway station
    {Coordinate{8.53678, 45.599}, Tz::Europe_Rome, CountryId{"IT"}}, // Vaprio d’Agogna railway station
    {Coordinate{14.2494, 41.7395}, Tz::Europe_Rome, CountryId{"IT"}}, // Vastogirardi railway station
    {Coordinate{14.0486, 41.4831}, Tz::Europe_Rome, CountryId{"IT"}}, // Venafro rail station
    {Coordinate{12.781, 41.6822}, Tz::Europe_Rome, CountryId{"IT"}}, // Velletri railway station
    {Coordinate{12.2477, 45.5066}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971258
    {Coordinate{12.2257, 45.5132}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971259
    {Coordinate{12.2561, 45.4725}, Tz::Europe_Rome, CountryId{"IT"}}, // Venezia Porto Marghera railway station
    {Coordinate{15.8462, 40.9791}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971262
    {Coordinate{13.1355, 46.3321}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971264
    {Coordinate{8.6934, 45.7172}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971266
    {Coordinate{9.61984, 45.6057}, Tz::Europe_Rome, CountryId{"IT"}}, // Verdello-Dalmine railway station
    {Coordinate{7.53589, 44.2446}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971268
    {Coordinate{8.47211, 45.9438}, Tz::Europe_Rome, CountryId{"IT"}}, // Verbania-Pallanza railway station
    {Coordinate{9.6847, 44.1349}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971270
    {Coordinate{11.1522, 44.044}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971272
    {Coordinate{10.0837, 45.3251}, Tz::Europe_Rome, CountryId{"IT"}}, // Verolanuova railway station
    {Coordinate{11.0197, 45.4358}, Tz::Europe_Rome, CountryId{"IT"}}, // Verona Porta Vescovo railway station
    {Coordinate{13.3627, 38.102}, Tz::Europe_Rome, CountryId{"IT"}}, // Vespri railway halt
    {Coordinate{12.089, 42.3047}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971278
    {Coordinate{9.88934, 44.1273}, Tz::Europe_Rome, CountryId{"IT"}}, // Vezzano Ligure
    {Coordinate{16.1203, 38.7137}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971289
    {Coordinate{11.4576, 43.9336}, Tz::Europe_Rome, CountryId{"IT"}}, // Vicchio railway station
    {Coordinate{10.2581, 44.7787}, Tz::Europe_Rome, CountryId{"IT"}}, // Vicofertile railway station
    {Coordinate{12.8885, 42.0101}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971294
    {Coordinate{10.2529, 43.874}, Tz::Europe_Rome, CountryId{"IT"}}, // Viareggio railway station
    {Coordinate{11.5404, 45.5411}, Tz::Europe_Rome, CountryId{"IT"}}, // Vicenza railway station
    {Coordinate{8.21827, 44.8274}, Tz::Europe_Rome, CountryId{"IT"}}, // Vigliano d'Asti railway station
    {Coordinate{12.2108, 42.0769}, Tz::Europe_Rome, CountryId{"IT"}}, // Vigna di Valle
    {Coordinate{8.61297, 45.479}, Tz::Europe_Rome, CountryId{"IT"}}, // Vignale railway station
    {Coordinate{11.8915, 45.4533}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971306
    {Coordinate{12.0214, 45.4434}, Tz::Europe_Rome, CountryId{"IT"}}, // Vigonza-Pianiga station
    {Coordinate{13.7913, 45.6942}, Tz::Europe_Rome, CountryId{"IT"}}, // Villa Opicina railway station
    {Coordinate{12.4551, 41.8479}, Tz::Europe_Rome, CountryId{"IT"}}, // Villa Bonelli
    {Coordinate{14.0678, 41.0049}, Tz::Europe_Rome, CountryId{"IT"}}, // Villa Literno railway station
    {Coordinate{11.8525, 45.6077}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971318
    {Coordinate{10.8489, 45.3499}, Tz::Europe_Rome, CountryId{"IT"}}, // Villafranca di Verona
    {Coordinate{8.64222, 39.2947}, Tz::Europe_Rome, CountryId{"IT"}}, // Villamassargia-Domusnovas railway station
    {Coordinate{9.99333, 45.0284}, Tz::Europe_Rome, CountryId{"IT"}}, // Villanova d'Arda railway station
    {Coordinate{7.94721, 44.9631}, Tz::Europe_Rome, CountryId{"IT"}}, // Villanova d'Asti railway station
    {Coordinate{14.2005, 37.5673}, Tz::Europe_Rome, CountryId{"IT"}}, // Villarosa railway station
    {Coordinate{8.93583, 39.3814}, Tz::Europe_Rome, CountryId{"IT"}}, // Villasor railway station
    {Coordinate{11.1391, 46.0459}, Tz::Europe_Rome, CountryId{"IT"}}, // Villazzano railway station
    {Coordinate{8.94056, 39.3042}, Tz::Europe_Rome, CountryId{"IT"}}, // Villaspeciosa-Uta railway station
    {Coordinate{12.6494, 41.7386}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971339
    {Coordinate{14.598, 41.4937}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971341
    {Coordinate{8.50033, 44.6621}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971344
    {Coordinate{12.1103, 42.412}, Tz::Europe_Rome, CountryId{"IT"}}, // Viterbo Porta Romana railway station
    {Coordinate{12.2936, 45.9895}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971348
    {Coordinate{14.7294, 37.1825}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971350
    {Coordinate{7.7797, 45.2004}, Tz::Europe_Rome, CountryId{"IT"}}, // Volpiano railway station
    {Coordinate{8.9472, 45.491}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971353
    {Coordinate{12.827, 41.8219}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971376
    {Coordinate{11.2062, 43.8258}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971380
    {Coordinate{14.7032, 38.1169}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3971381
    {Coordinate{9.26945, 44.3353}, Tz::Europe_Rome, CountryId{"IT"}}, // Zoagli
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q39878739
    {Coordinate{8.34056, 44.169}, Tz::Europe_Rome, CountryId{"IT"}}, // Finale Ligure Marina railway station
    {Coordinate{0.667761, 47.3543}, Tz::Europe_Paris, CountryId{"FR"}}, // Q405631
    {Coordinate{9.47334, 47.6533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichshafen Stadt station
    {Coordinate{8.56222, 47.4503}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Airport railway station
    {Coordinate{13.2764, 52.7155}, Tz::Europe_Berlin, CountryId{"DE"}}, // Borgsdorf station
    {Coordinate{10.8594, 49.1189}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q41371728
    {Coordinate{10.9255, 49.1119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q41372018
    {Coordinate{10.994, 48.8918}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q41372246
    {Coordinate{11.4727, 48.1776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Untermenzing station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Peißenberg
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q42073109
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q42301989
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q42313166
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q42330661
    {Coordinate{13.2635, 52.7411}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lehnitz station
    {Coordinate{5.98778, 53.2347}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenwouden railway station
    {Coordinate{16.4911, 48.0353}, Tz::Europe_Vienna, CountryId{"AT"}}, // Gramatneusiedl station
    {Coordinate{17.0365, 51.0988}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Wrocław Główny
    {Coordinate{5.92111, 52.5597}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kampen railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q42871736
    {Coordinate{11.5369, 48.1169}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Harras station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q43054353
    {Coordinate{4.4775, 52.0475}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zoetermeer railway station
    {Coordinate{6.74417, 48.4522}, Tz::Europe_Paris, CountryId{"FR"}}, // Q430790
    {Coordinate{6.36844, 51.1049}, Tz::Europe_Berlin, CountryId{"DE"}}, // Station Herrath
    {Coordinate{11.6577, 51.1062}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q43109306
    {Coordinate{6.14447, 46.2226}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genève-Sécheron
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q43161681
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q43202950
    {Coordinate{9.72121, 47.4935}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bregenz Riedenburg station
    {Coordinate{9.66688, 47.4504}, Tz::Europe_Vienna, CountryId{"AT"}}, // Lustenau
    {Coordinate{6.11611, 52.7908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Steenwijk railway station
    {Coordinate{4.15639, 50.9892}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heizijde railway station
    {Coordinate{8.79497, 47.4986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Räterschen railway station
    {Coordinate{7.55866, 51.4416}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerte (Ruhr) station
    {Coordinate{4.47306, 50.8847}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zaventem railway station
    {Coordinate{9.86115, 52.3688}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Anderten-Misburg railway station
    {Coordinate{8.74933, 50.3679}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Nauheim station
    {Coordinate{9.17717, 47.6588}, Tz::Europe_Berlin, CountryId{"DE"}}, // Konstanz station
    {Coordinate{7.58611, 50.2311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Boppard Central Station
    {Coordinate{6.94361, 49.9731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wittlich Central Station
    {Coordinate{13.4394, 52.5397}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Greifswalder Straße station
    {Coordinate{8.76088, 50.3319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedberg station
    {Coordinate{9.3, 48.7386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Esslingen (Neckar) station
    {Coordinate{13.9961, 53.0156}, Tz::Europe_Berlin, CountryId{"DE"}}, // Angermünde railway station
    {Coordinate{3.79167, 50.9198}, Tz::Europe_Brussels, CountryId{"BE"}}, // Balegem-Dorp railway station
    {Coordinate{9.13583, 48.9472}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bietigheim-Bissingen station
    {Coordinate{9.00472, 48.6875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Böblingen station
    {Coordinate{10.3178, 47.7117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kempten Central Station
    {Coordinate{8.42972, 48.4614}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freudenstadt Central Station
    {Coordinate{13.7971, 52.8338}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eberswalde Central Station
    {Coordinate{8.86278, 48.5936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herrenberg station
    {Coordinate{9.17972, 48.8783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kornwestheim station
    {Coordinate{8.64427, 47.2695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Meilen railway station
    {Coordinate{8.69235, 47.2535}, Tz::Europe_Zurich, CountryId{"CH"}}, // Männedorf railway station
    {Coordinate{8.78444, 50.1027}, Tz::Europe_Berlin, CountryId{"DE"}}, // Offenbach Ost station
    {Coordinate{8.46242, 49.002}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karlsruhe-Durlach station
    {Coordinate{7.59833, 49.2056}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pirmasens Central Station
    {Coordinate{8.19083, 48.7906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Baden-Baden station
    {Coordinate{8.42816, 49.3241}, Tz::Europe_Berlin, CountryId{"DE"}}, // Speyer Central Station
    {Coordinate{8.80862, 50.0903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Offenbach-Bieber station
    {Coordinate{11.5072, 48.1803}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Moosach station
    {Coordinate{8.84639, 48.9531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühlacker station
    {Coordinate{7.665, 47.6139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lörrach Central Station
    {Coordinate{20.4675, 53.7781}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q445351
    {Coordinate{14.5471, 52.3368}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt (Oder) railway station
    {Coordinate{5.82444, 50.9753}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geleen-Lutterade railway station
    {Coordinate{13.287, 52.6684}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohen Neuendorf station
    {Coordinate{11.6468, 48.1902}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unterföhring station
    {Coordinate{14.0647, 52.2932}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Saarow station
    {Coordinate{4.20833, 50.9067}, Tz::Europe_Brussels, CountryId{"BE"}}, // Asse railway station
    {Coordinate{13.1396, 52.3236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarmund station
    {Coordinate{12.9719, 52.4098}, Tz::Europe_Berlin, CountryId{"DE"}}, // Golm station
    {Coordinate{13.5236, 52.4467}, Tz::Europe_Berlin, CountryId{"DE"}}, // Betriebsbahnhof Schöneweide
    {Coordinate{20.8625, 52.2081}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Gołąbki railway station
    {Coordinate{7.22278, 51.4785}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum Central Station
    {Coordinate{25.2844, 54.6703}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Vilnius railway station
    {Coordinate{5.31778, 51.7006}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // 's-Hertogenbosch Oost railway station
    {Coordinate{10.1318, 54.3148}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kiel Central Station
    {Coordinate{10.7878, 52.4292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolfsburg Central Station
    {Coordinate{8.31037, 47.0499}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lucerne railway station
    {Coordinate{7.58783, 47.5482}, Tz::Europe_Zurich, CountryId{"CH"}}, // Basel SNCF railway station
    {Coordinate{11.5753, 48.1372}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Marienplatz station
    {Coordinate{11.6278, 52.1306}, Tz::Europe_Berlin, CountryId{"DE"}}, // Magdeburg Central Station
    {Coordinate{13.2614, 52.4892}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Grunewald station
    {Coordinate{6.25944, 52.4981}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dalfsen railway station
    {Coordinate{13.2089, 49.1217}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bayerisch Eisenstein station
    {Coordinate{4.89361, 51.2411}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tielen railway station
    {Coordinate{9.43667, 54.7744}, Tz::Europe_Berlin, CountryId{"DE"}}, // Flensburg station
    {Coordinate{8.66194, 50.5792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gießen station
    {Coordinate{7.10139, 51.5044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelsenkirchen Central Station
    {Coordinate{9.49, 51.3181}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kassel Central Station
    {Coordinate{9.68472, 50.5539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fulda station
    {Coordinate{8.63944, 50.1192}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt West station
    {Coordinate{8.76083, 50.0994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Offenbach Central Station
    {Coordinate{13.3285, 52.4777}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Bundesplatz stations
    {Coordinate{13.5258, 52.4808}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Karlshorst station
    {Coordinate{11.4081, 53.6344}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin Central Station
    {Coordinate{8.06111, 52.2728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osnabrück Central Station
    {Coordinate{9.14806, 48.9069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Asperg station
    {Coordinate{13.344, 52.536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Westhafen station
    {Coordinate{7.20333, 51.6164}, Tz::Europe_Berlin, CountryId{"DE"}}, // Recklinghausen Central Station
    {Coordinate{8.67528, 49.4036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidelberg Central Station
    {Coordinate{6.88639, 51.4314}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mülheim Central Station
    {Coordinate{8.524, 47.3124}, Tz::Europe_Zurich, CountryId{"CH"}}, // Adliswil railway station
    {Coordinate{7.16583, 51.5314}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wanne-Eickel Central Station
    {Coordinate{8.90085, 45.9959}, Tz::Europe_Zurich, CountryId{"CH"}}, // Agno railway station
    {Coordinate{7.82528, 50.4447}, Tz::Europe_Berlin, CountryId{"DE"}}, // Montabaur station
    {Coordinate{8.25659, 50.0411}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wiesbaden Ost station
    {Coordinate{4.40472, 50.3196}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ham-sur-Heure railway station
    {Coordinate{12.2276, 54.2418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Torfbrücke railway station
    {Coordinate{12.2369, 54.2458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Graal-Müritz Koppelweg railway station
    {Coordinate{12.2457, 54.2489}, Tz::Europe_Berlin, CountryId{"DE"}}, // Graal-Müritz railway station
    {Coordinate{12.2106, 54.1174}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bentwisch railway station
    {Coordinate{12.2249, 54.1432}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mönchhagen railway station
    {Coordinate{12.3054, 54.1989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelbensande railway station
    {Coordinate{7.58917, 50.3506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koblenz Central Station
    {Coordinate{13.3289, 52.43}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Lichterfelde Ost station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47004054
    {Coordinate{10.0267, 49.7906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47004071
    {Coordinate{8.57139, 50.0014}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47004091
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47004109
    {Coordinate{7.32972, 51.4356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Witten Central Station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47008895
    {Coordinate{10.1179, 48.4301}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nersingen station
    {Coordinate{7.94572, 48.476}, Tz::Europe_Berlin, CountryId{"DE"}}, // Offenburg station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47035084
    {Coordinate{8.4786, 49.5982}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47035086
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47035089
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47035165
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47035195
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47037433
    {Coordinate{6.76083, 52.2619}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hengelo Gezondheidspark railway station
    {Coordinate{8.4089, 49.6595}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47093255
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47093264
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47093332
    {Coordinate{5.29222, 50.8869}, Tz::Europe_Brussels, CountryId{"BE"}}, // Alken railway station
    {Coordinate{7.00417, 51.1615}, Tz::Europe_Berlin, CountryId{"DE"}}, // Solingen Central Station
    {Coordinate{8.775, 50.82}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marburg station
    {Coordinate{6.76, 53.4189}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Roodeschool railway station
    {Coordinate{5.70333, 51.2486}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Weert railway station
    {Coordinate{9.65228, 48.7003}, Tz::Europe_Berlin, CountryId{"DE"}}, // Göppingen station
    {Coordinate{6.68403, 51.2042}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Central Station
    {Coordinate{6.92444, 53.3339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delfzijl railway station
    {Coordinate{9.05556, 54.4722}, Tz::Europe_Berlin, CountryId{"DE"}}, // Husum (Germany) station
    {Coordinate{6.72139, 53.1617}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kropswolde railway station
    {Coordinate{6.56944, 51.3258}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld Central Station
    {Coordinate{6.74083, 53.1608}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Martenshoek railway station
    {Coordinate{8.50361, 50.565}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wetzlar station
    {Coordinate{6.76972, 53.1597}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoogezand-Sappemeer railway station
    {Coordinate{8.93444, 52.2906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Minden station
    {Coordinate{6.79583, 53.1589}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sappemeer Oost railway station
    {Coordinate{6.86722, 53.1592}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zuidbroek railway station
    {Coordinate{6.97804, 53.1655}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Scheemda railway station
    {Coordinate{9.98333, 48.4}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ulm Central Station
    {Coordinate{7.03361, 53.1392}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winschoten railway station
    {Coordinate{6.85333, 51.4742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberhausen Central Station
    {Coordinate{7.20083, 53.1847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bad Nieuweschans railway station
    {Coordinate{6.6175, 53.1753}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Haren railway station
    {Coordinate{6.57111, 52.9925}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Assen railway station
    {Coordinate{7.93161, 46.5938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Allmend railway station
    {Coordinate{6.52056, 52.8542}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beilen railway station
    {Coordinate{6.47333, 52.7342}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoogeveen railway station
    {Coordinate{6.19754, 52.6917}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Meppel railway station
    {Coordinate{6.09056, 52.5053}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zwolle railway station
    {Coordinate{7.99139, 46.5925}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alpiglen railway station
    {Coordinate{8.27502, 46.9404}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alpnach Dorf railway station
    {Coordinate{8.27785, 46.9551}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alpnachstad railway station
    {Coordinate{7.84194, 47.9978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freiburg Central Station
    {Coordinate{8.63156, 46.875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altdorf railway station
    {Coordinate{13.5588, 52.4073}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altglienicke station
    {Coordinate{12.1195, 47.8504}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rosenheim station
    {Coordinate{7.30417, 51.5736}, Tz::Europe_Berlin, CountryId{"DE"}}, // Castrop-Rauxel Central Station
    {Coordinate{6.87839, 51.1623}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Benrath station
    {Coordinate{8.74056, 51.7131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Paderborn Central Station
    {Coordinate{8.23637, 50.0487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wiesbaden-Biebrich station
    {Coordinate{4.65861, 52.125}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Alphen aan den Rijn railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q47535836
    {Coordinate{8.67789, 47.5937}, Tz::Europe_Zurich, CountryId{"CH"}}, // Andelfingen railway station
    {Coordinate{8.59361, 46.6369}, Tz::Europe_Zurich, CountryId{"CH"}}, // Andermatt railway station
    {Coordinate{9.97988, 54.076}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neumünster station
    {Coordinate{13.329, 52.578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Karl-Bonhoeffer-Nervenklinik station
    {Coordinate{8.66972, 50.1139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Taunusanlage station
    {Coordinate{11.0378, 50.9728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erfurt Central Station
    {Coordinate{8.70028, 50.1017}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Mühlberg station
    {Coordinate{8.6975, 50.1114}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Ostendstraße station
    {Coordinate{13.7017, 53.856}, Tz::Europe_Berlin, CountryId{"DE"}}, // Anklam railway station
    {Coordinate{13.3808, 52.5164}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Brandenburger Tor station
    {Coordinate{13.1414, 52.5378}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Staaken station
    {Coordinate{6.00028, 52.205}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Apeldoorn De Maten railway station
    {Coordinate{10.2011, 46.7736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ardez
    {Coordinate{5.91944, 51.985}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem Velperpoort railway station
    {Coordinate{13.9822, 51.0928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Arnsdorf (bei Dresden) railway station
    {Coordinate{13.5931, 52.6763}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bernau bei Berlin station
    {Coordinate{13.3929, 52.525}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Oranienburger Straße station
    {Coordinate{6.63455, 49.4368}, Tz::Europe_Berlin, CountryId{"DE"}}, // Merzig (Saar) station
    {Coordinate{13.3796, 52.5451}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Humboldthain station
    {Coordinate{13.4558, 52.473}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Sonnenallee station
    {Coordinate{11.2258, 54.4996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Puttgarden station
    {Coordinate{8.29557, 47.5885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bad Zurzach railway station
    {Coordinate{7.10277, 51.4312}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Horst station
    {Coordinate{4.90833, 52.6781}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Obdam railway station
    {Coordinate{12.7261, 54.3619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Barth railway station
    {Coordinate{6.45806, 51.9369}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Varsseveld railway station
    {Coordinate{12.9719, 52.4584}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marquardt station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q48876272
    {Coordinate{9.74639, 46.6311}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bergün/Bravuogn
    {Coordinate{13.5554, 52.5131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Biesdorf station
    {Coordinate{13.4917, 52.6359}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Buch station
    {Coordinate{13.4297, 52.5783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Pankow-Heinersdorf station
    {Coordinate{13.5648, 52.6685}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bernau-Friedenstal station
    {Coordinate{9.98194, 46.4417}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bernina Diavolezza
    {Coordinate{9.99139, 46.4367}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bernina Lagalb
    {Coordinate{9.96917, 46.4447}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bernina Suot
    {Coordinate{13.2319, 52.3172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigsfelde-Struveshof station
    {Coordinate{11.6459, 48.1682}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich-Johanneskirchen station
    {Coordinate{11.7142, 48.3092}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hallbergmoos station
    {Coordinate{11.1706, 47.9988}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herrsching station
    {Coordinate{11.9121, 48.3034}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erding station
    {Coordinate{14.2781, 52.5503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alt Rosenthal station
    {Coordinate{14.1673, 52.5369}, Tz::Europe_Berlin, CountryId{"DE"}}, // Obersdorf station
    {Coordinate{13.8875, 52.5299}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herrensee station
    {Coordinate{14.0865, 52.3418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fürstenwalde
    {Coordinate{9.88861, 46.5497}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bever
    {Coordinate{4.65611, 52.4783}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beverwijk railway station
    {Coordinate{5.45583, 52.9714}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Workum railway station
    {Coordinate{8.91374, 46.0123}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bioggio Molinazzo railway station
    {Coordinate{8.90896, 46.0119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bioggio railway station
    {Coordinate{8.43754, 47.3574}, Tz::Europe_Zurich, CountryId{"CH"}}, // Birmensdorf railway station
    {Coordinate{14.1864, 51.1253}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bischofswerda railway station
    {Coordinate{6.61333, 51.6942}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blumenkamp railway station
    {Coordinate{4.93889, 51.3222}, Tz::Europe_Brussels, CountryId{"BE"}}, // Turnhout railway station
    {Coordinate{4.34778, 50.8789}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bockstael railway station
    {Coordinate{8.90699, 46.3799}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bodio railway station
    {Coordinate{9.39776, 46.8103}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bonaduz
    {Coordinate{8.46817, 47.3259}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bonstetten-Wettswil railway station
    {Coordinate{12.9102, 50.5472}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q49456420
    {Coordinate{4.21654, 50.9328}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mollem railway station
    {Coordinate{8.01028, 46.6064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brandegg railway station
    {Coordinate{12.5663, 52.4008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brandenburg Central Station
    {Coordinate{7.89601, 46.6595}, Tz::Europe_Zurich, CountryId{"CH"}}, // Breitlauenen railway station
    {Coordinate{8.61213, 53.5085}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremerhaven-Wulsdorf station
    {Coordinate{8.03846, 46.7549}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brienz railway station
    {Coordinate{8.02041, 46.7572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brienz West railway station
    {Coordinate{8.091, 46.746}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brienzwiler railway station
    {Coordinate{6.34722, 51.9311}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gaanderen railway station
    {Coordinate{10.1256, 46.2597}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brusio
    {Coordinate{8.13819, 46.7575}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brünig-Hasliberg railway station
    {Coordinate{8.82291, 47.2707}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bubikon railway station
    {Coordinate{5.37417, 52.1539}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amersfoort railway station
    {Coordinate{5.43361, 52.1925}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amersfoort Vathorst railway station
    {Coordinate{5.40361, 52.1747}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amersfoort Schothorst railway station
    {Coordinate{5.18111, 52.2269}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hilversum railway station
    {Coordinate{4.93639, 52.3233}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Duivendrecht
    {Coordinate{4.87306, 52.3389}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Zuid
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q49892242
    {Coordinate{4.48444, 52.2242}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorhout railway station
    {Coordinate{8.94835, 45.9557}, Tz::Europe_Zurich, CountryId{"CH"}}, // Melide railway station
    {Coordinate{7.97583, 46.6356}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burglauenen railway station
    {Coordinate{9.68722, 53.4703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buxtehude
    {Coordinate{11.5097, 48.0434}, Tz::Europe_Berlin, CountryId{"DE"}}, // Höllriegelskreuth station
    {Coordinate{8.94167, 46.1525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cadenazzo railway station
    {Coordinate{10.0514, 46.3453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cadera
    {Coordinate{3.80139, 50.9797}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gontrode railway station
    {Coordinate{10.1319, 46.2447}, Tz::Europe_Zurich, CountryId{"CH"}}, // Campascio
    {Coordinate{10.1425, 46.2331}, Tz::Europe_Zurich, CountryId{"CH"}}, // Campocologno
    {Coordinate{11.3392, 50.7182}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q50300514
    {Coordinate{12.2128, 54.0734}, Tz::Europe_Berlin, CountryId{"DE"}}, // Roggentin railway station
    {Coordinate{12.2632, 54.0789}, Tz::Europe_Berlin, CountryId{"DE"}}, // Broderstorf railway station
    {Coordinate{12.3387, 54.0734}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Lüsewitz railway station
    {Coordinate{12.3766, 54.0751}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sanitz (b Rostock) railway station
    {Coordinate{12.4422, 54.0344}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tessin West railway station
    {Coordinate{12.4625, 54.0319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tessin railway station
    {Coordinate{11.6969, 47.8845}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzkirchen station
    {Coordinate{11.708, 48.364}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pulling station
    {Coordinate{13.5006, 54.3454}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauterbach (Rügen) railway station
    {Coordinate{13.5031, 54.3421}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauterbach Mole railway station
    {Coordinate{11.4113, 53.7294}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübstorf railway station
    {Coordinate{11.4714, 53.8429}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dorf Mecklenburg railway station
    {Coordinate{11.4819, 53.8064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Moidentin railway station
    {Coordinate{12.573, 54.2594}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenwillershagen railway station
    {Coordinate{12.7108, 54.2682}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buchenhorst railway station
    {Coordinate{12.9311, 54.3009}, Tz::Europe_Berlin, CountryId{"DE"}}, // Martensdorf railway station
    {Coordinate{13.044, 54.3043}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stralsund-Grünhufe railway station
    {Coordinate{12.0995, 54.0932}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock Holbeinplatz railway station
    {Coordinate{12.0902, 54.102}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Bramow railway station
    {Coordinate{12.08, 54.1118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Marienehe railway station
    {Coordinate{12.0686, 54.1234}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Evershagen railway station
    {Coordinate{12.065, 54.1382}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Lütten Klein railway station
    {Coordinate{12.0708, 54.1523}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Lichtenhagen railway station
    {Coordinate{12.0861, 54.1695}, Tz::Europe_Berlin, CountryId{"DE"}}, // Warnemünde Werft railway station
    {Coordinate{13.7737, 54.1387}, Tz::Europe_Berlin, CountryId{"DE"}}, // Peenemünde railway station
    {Coordinate{13.831, 54.117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karlshagen railway station
    {Coordinate{13.8684, 54.0908}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trassenmoor railway station
    {Coordinate{11.5797, 53.7872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ventschow railway station
    {Coordinate{12.118, 53.9391}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwaan railway station
    {Coordinate{12.9975, 50.5559}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q50333444
    {Coordinate{13.7909, 54.0564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolgaster Fähre railway station
    {Coordinate{13.9595, 54.066}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zempin railway station
    {Coordinate{13.8695, 54.0815}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trassenheide railway station
    {Coordinate{13.8365, 54.0714}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bannemin-Mölschow railway station
    {Coordinate{13.7798, 54.0521}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolgast Hafen railway station
    {Coordinate{13.61, 53.9824}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karlsburg railway station
    {Coordinate{13.6821, 54.0014}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buddenhagen railway station
    {Coordinate{13.7301, 54.027}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohendorf railway station
    {Coordinate{8.98111, 45.9062}, Tz::Europe_Zurich, CountryId{"CH"}}, // Capolago Lago railway station
    {Coordinate{8.92503, 45.9933}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cappella-Agnuzzo railway station
    {Coordinate{13.0738, 54.21}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elmenhorst railway station
    {Coordinate{13.057, 54.1854}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wittenhagen railway station
    {Coordinate{13.034, 54.1096}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grimmen railway station
    {Coordinate{13.0458, 54.0481}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rakow railway station
    {Coordinate{13.1164, 53.8606}, Tz::Europe_Berlin, CountryId{"DE"}}, // Utzedel railway station
    {Coordinate{13.1503, 53.8248}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sternfeld railway station
    {Coordinate{13.1743, 53.7935}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gnevkow railway station
    {Coordinate{13.2428, 53.6922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altentreptow railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Annaberg-Buchholz unterer Bahnhof
    {Coordinate{13.5731, 53.518}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oertzenhof railway station
    {Coordinate{13.5005, 53.5336}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neetzka railway station
    {Coordinate{13.3674, 53.5639}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sponholz railway station
    {Coordinate{13.0846, 53.5858}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mölln (Meckl) railway station
    {Coordinate{12.914, 53.7068}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reuterstadt Stavenhagen station
    {Coordinate{12.7616, 53.7433}, Tz::Europe_Berlin, CountryId{"DE"}}, // Malchin railway station
    {Coordinate{12.5778, 53.7683}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teterow railway station
    {Coordinate{12.5017, 53.76}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu Wokern railway station
    {Coordinate{12.2229, 53.7959}, Tz::Europe_Berlin, CountryId{"DE"}}, // Priemerburg railway station
    {Coordinate{13.0308, 52.3161}, Tz::Europe_Berlin, CountryId{"DE"}}, // Michendorf station
    {Coordinate{10.703, 53.8423}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-St. Jürgen railway station
    {Coordinate{10.76, 53.8377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herrnburg railway station
    {Coordinate{10.8151, 53.8329}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüdersdorf (Meckl) railway station
    {Coordinate{10.9282, 53.8536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schönberg (Meckl) railway station
    {Coordinate{11.0686, 53.8512}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grieben (Meckl) railway station
    {Coordinate{11.1845, 53.8574}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grevesmühlen railway station
    {Coordinate{11.2861, 53.8371}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plüschow railway station
    {Coordinate{11.3632, 53.8044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bobitz railway station
    {Coordinate{12.1231, 53.8806}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mistorf railway station
    {Coordinate{12.1377, 53.8435}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüssow (Meckl) railway station
    {Coordinate{12.1375, 54.0368}, Tz::Europe_Berlin, CountryId{"DE"}}, // Papendorf railway station
    {Coordinate{12.1212, 54.011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pölchow railway station
    {Coordinate{12.1161, 53.9845}, Tz::Europe_Berlin, CountryId{"DE"}}, // Huckstorf railway station
    {Coordinate{12.3381, 53.8407}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plaaz railway station
    {Coordinate{12.197, 54.0077}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kavelstorf (Kr Rostock) railway station
    {Coordinate{12.2463, 53.9698}, Tz::Europe_Berlin, CountryId{"DE"}}, // Scharstorf railway station
    {Coordinate{12.315, 53.9336}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kronskamp railway station
    {Coordinate{12.3395, 53.9198}, Tz::Europe_Berlin, CountryId{"DE"}}, // Laage (Meckl) railway station
    {Coordinate{12.3477, 53.8917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Subzin-Liessow railway station
    {Coordinate{12.4255, 53.6808}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langhagen railway station
    {Coordinate{12.9418, 53.4277}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kratzeburg railway station
    {Coordinate{12.9489, 53.2831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weißer See railway station
    {Coordinate{12.8867, 53.281}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zirtow-Leussow railway station
    {Coordinate{12.4239, 53.482}, Tz::Europe_Berlin, CountryId{"DE"}}, // Inselstadt Malchow railway station
    {Coordinate{12.4523, 53.5216}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nossentin railway station
    {Coordinate{12.5467, 53.5451}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jabel (Meckl) railway station
    {Coordinate{12.612, 53.5361}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwenzin railway station
    {Coordinate{12.6457, 53.5307}, Tz::Europe_Berlin, CountryId{"DE"}}, // Warenshof railway station
    {Coordinate{13.3031, 53.4997}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burg Stargard (Meckl) railway station
    {Coordinate{13.2995, 53.4387}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cammin (Meckl) railway station
    {Coordinate{13.2634, 53.4085}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankensee (Meckl) railway station
    {Coordinate{13.1392, 53.1866}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fürstenberg (Havel) railway station
    {Coordinate{11.0498, 53.7741}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rehna railway station
    {Coordinate{11.0653, 53.7353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holdorf (Meckl) railway station
    {Coordinate{11.1191, 53.7054}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gadebusch railway station
    {Coordinate{11.1806, 53.6558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lützow railway station
    {Coordinate{11.2511, 53.653}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Brütz railway station
    {Coordinate{11.3455, 53.6617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin-Warnitz railway station
    {Coordinate{11.3607, 53.6586}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin-Margaretenhof railway station
    {Coordinate{11.4054, 53.6269}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin Mitte railway station
    {Coordinate{11.3849, 53.6092}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin-Görries railway station
    {Coordinate{11.4002, 53.5839}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin-Wüstmark railway station
    {Coordinate{11.507, 53.5532}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plate (Meckl) railway station
    {Coordinate{11.5599, 53.5548}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sukow (b Schwerin) railway station
    {Coordinate{11.645, 53.5725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Crivitz railway station
    {Coordinate{11.7115, 53.545}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ruthenbeck railway station
    {Coordinate{11.7393, 53.5246}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichsruhe (Meckl) railway station
    {Coordinate{11.7659, 53.4854}, Tz::Europe_Berlin, CountryId{"DE"}}, // Domsühl railway station
    {Coordinate{11.534, 53.3464}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Laasch railway station
    {Coordinate{11.5934, 53.3774}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt-Glewe railway station
    {Coordinate{11.6788, 53.402}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dütschow railway station
    {Coordinate{11.7115, 53.4124}, Tz::Europe_Berlin, CountryId{"DE"}}, // Spornitz railway station
    {Coordinate{11.377, 53.5747}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin Süd railway station
    {Coordinate{11.3658, 53.5563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holthusen railway station
    {Coordinate{11.3883, 53.5136}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sülstorf railway station
    {Coordinate{11.4319, 53.4568}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rastow railway station
    {Coordinate{11.4601, 53.4187}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüblow (Meckl) railway station
    {Coordinate{11.2637, 53.4489}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirch-Jesar railway station
    {Coordinate{11.3249, 53.5029}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zachun railway station
    {Coordinate{11.318, 53.3984}, Tz::Europe_Berlin, CountryId{"DE"}}, // Strohkirchen railway station
    {Coordinate{11.083, 53.3649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pritzier railway station
    {Coordinate{10.9534, 53.3641}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brahlstorf railway station
    {Coordinate{10.7545, 53.378}, Tz::Europe_Berlin, CountryId{"DE"}}, // Boizenburg (Elbe) railway station
    {Coordinate{10.5611, 53.4995}, Tz::Europe_Berlin, CountryId{"DE"}}, // Müssen railway station
    {Coordinate{10.4849, 53.5038}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwarzenbek railway station
    {Coordinate{8.87558, 45.9771}, Tz::Europe_Zurich, CountryId{"CH"}}, // Caslano railway station
    {Coordinate{9.0414, 46.2253}, Tz::Europe_Zurich, CountryId{"CH"}}, // Castione-Arbedo railway station
    {Coordinate{4.65889, 52.5456}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Castricum railway station
    {Coordinate{9.23306, 46.7786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Castrisch
    {Coordinate{8.5613, 47.3501}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Tiefenbrunnen railway station
    {Coordinate{9.86806, 46.8706}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cavadürli
    {Coordinate{9.43306, 46.72}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cazis
    {Coordinate{9.865, 46.5094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Celerina Staz
    {Coordinate{9.85861, 46.5139}, Tz::Europe_Zurich, CountryId{"CH"}}, // Celerina
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Niel railway station
    {Coordinate{11.2547, 48.3853}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altomünster station
    {Coordinate{13.7379, 54.346}, Tz::Europe_Berlin, CountryId{"DE"}}, // Göhren (Rügen) railway station
    {Coordinate{11.4708, 48.4103}, Tz::Europe_Berlin, CountryId{"DE"}}, // Petershausen station
    {Coordinate{11.468, 48.1897}, Tz::Europe_Berlin, CountryId{"DE"}}, // Allach station
    {Coordinate{11.1739, 48.2167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mammendorf station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q50714432
    {Coordinate{4.90056, 52.3789}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Centraal
    {Coordinate{4.91778, 52.3464}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Amstel
    {Coordinate{4.83806, 52.3892}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Sloterdijk
    {Coordinate{4.83389, 52.3572}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Lelylaan
    {Coordinate{4.94611, 52.3131}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Bijlmer ArenA
    {Coordinate{4.93111, 52.3608}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Muiderpoort railway station
    {Coordinate{13.5027, 54.362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Beuchow railway station
    {Coordinate{13.5287, 54.3681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Posewald railway station
    {Coordinate{13.5612, 54.3675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seelvitz railway station
    {Coordinate{13.5827, 54.3779}, Tz::Europe_Berlin, CountryId{"DE"}}, // Serams railway station
    {Coordinate{13.611, 54.3923}, Tz::Europe_Berlin, CountryId{"DE"}}, // Binz LB railway station
    {Coordinate{13.6201, 54.3764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jagdschloß railway station
    {Coordinate{13.6387, 54.3777}, Tz::Europe_Berlin, CountryId{"DE"}}, // Garftitz railway station
    {Coordinate{13.6803, 54.3766}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sellin (Rügen) West railway station
    {Coordinate{13.6985, 54.3713}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sellin (Rügen) Ost railway station
    {Coordinate{13.7048, 54.3625}, Tz::Europe_Berlin, CountryId{"DE"}}, // Baabe railway station
    {Coordinate{13.7067, 54.3478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Philippshagen railway station
    {Coordinate{9.38333, 47.5667}, Tz::Europe_Zurich, CountryId{"CH"}}, // Romanshorn railway station
    {Coordinate{12.0373, 50.5446}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mehltheuer railway station
    {Coordinate{5.72355, 50.565}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fraipont railway station
    {Coordinate{5.91583, 52.5342}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kampen Zuid railway station
    {Coordinate{3.59556, 51.4442}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlissingen railway station
    {Coordinate{12.2472, 54.2494}, Tz::Europe_Berlin, CountryId{"DE"}}, // Graal-Müritz station
    {Coordinate{8.92556, 50.1419}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q510283
    {Coordinate{19.0444, 49.8294}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q5105319
    {Coordinate{5.3, 52.4031}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Oostvaarders railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q51064122
    {Coordinate{3.39413, 46.3155}, Tz::Europe_Paris, CountryId{"FR"}}, // Q510695
    {Coordinate{-1.785, 50.738}, Tz::Europe_London, CountryId{"GB"}}, // Christchurch railway station
    {Coordinate{6.78662, 50.5975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münstereifel-Arloff station
    {Coordinate{11.9705, 48.075}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebersberg station
    {Coordinate{11.7593, 47.9171}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kreuzstraße station
    {Coordinate{5.79611, 50.8733}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Houthem-Sint Gerlach railway station
    {Coordinate{9.53139, 46.8619}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chur Wiesental station
    {Coordinate{10.0218, 46.6379}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cinuos-chel-Brail station
    {Coordinate{4.89056, 52.3367}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam RAI
    {Coordinate{8.57778, 50.0519}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Airport regional station
    {Coordinate{16.3353, 48.175}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Meidling
    {Coordinate{8.93639, 48.0317}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q51507704
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q51507707
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Finsterwalde (Niederlausitz) station
    {Coordinate{8.4893, 49.8332}, Tz::Europe_Berlin, CountryId{"DE"}}, // Riedstadt-Goddelau station
    {Coordinate{9.65778, 51.4125}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q51607009
    {Coordinate{8.44782, 50.1376}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kelkheim station
    {Coordinate{3.13046, 50.9489}, Tz::Europe_Brussels, CountryId{"BE"}}, // Roeselare railway station
    {Coordinate{12.7135, 51.0093}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Narsdorf
    {Coordinate{11.5258, 48.1978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Fasanerie station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gera-Liebschwitz train station
    {Coordinate{6.15631, 49.3033}, Tz::Europe_Paris, CountryId{"FR"}}, // Uckange railway station
    {Coordinate{5.72056, 50.0064}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bastogne-North railway station
    {Coordinate{8.61433, 47.6663}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dachsen railway station
    {Coordinate{12.232, 45.4824}, Tz::Europe_Rome, CountryId{"IT"}}, // Venezia Mestre railway station
    {Coordinate{3.89933, 50.7979}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schendelbeke railway station
    {Coordinate{8.39229, 46.9336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dallenwil railway station
    {Coordinate{3.12072, 45.8899}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Riom - Châtel-Guyon
    {Coordinate{11.4597, 48.2108}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karlsfeld station
    {Coordinate{11.7642, 48.3522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Airport Besucherpark station
    {Coordinate{11.4342, 48.2603}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dachau Stadt station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eching station
    {Coordinate{11.9628, 48.0471}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grafing Stadt station
    {Coordinate{19.0575, 47.5108}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budapest Western Railway Terminal
    {Coordinate{9.84222, 46.8097}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Dorf
    {Coordinate{9.79917, 46.7667}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Frauenkirch
    {Coordinate{9.77972, 46.7456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Glaris
    {Coordinate{9.87194, 46.8481}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Laret
    {Coordinate{9.76, 46.7158}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Monstein
    {Coordinate{9.82083, 46.7914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Platz
    {Coordinate{9.85472, 46.8317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Wolfgang
    {Coordinate{4.45639, 52.1472}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // De Vink railway station
    {Coordinate{11.5817, 48.2883}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lohhof station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Markt Schwaben station
    {Coordinate{11.5836, 48.0195}, Tz::Europe_Berlin, CountryId{"DE"}}, // Deisenhofen station
    {Coordinate{11.3903, 48.3211}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederroth station
    {Coordinate{11.5689, 48.2739}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unterschleißheim station
    {Coordinate{6.21528, 52.25}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deventer Colmschate railway station
    {Coordinate{2.65306, 51.0791}, Tz::Europe_Brussels, CountryId{"BE"}}, // Koksijde railway station
    {Coordinate{6.92228, 51.4879}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Dellwig station
    {Coordinate{9.93389, 53.5686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Diebsteich station
    {Coordinate{8.45917, 47.4823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dielsdorf railway station
    {Coordinate{8.38056, 52.6047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Diepholz railway station
    {Coordinate{6.73694, 51.5678}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dinslaken station
    {Coordinate{7.80806, 51.6783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamm (Westfalen) station
    {Coordinate{8.855, 46.705}, Tz::Europe_Zurich, CountryId{"CH"}}, // Disentis/Mustér railway station
    {Coordinate{8.18472, 52.1117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dissen-Bad Rothenfelde railway station
    {Coordinate{5.34611, 50.2225}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marche-en-Famenne railway station
    {Coordinate{10.1813, 52.417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dollbergen railway station
    {Coordinate{9.45333, 46.8333}, Tz::Europe_Zurich, CountryId{"CH"}}, // Domat/Ems
    {Coordinate{7.46167, 51.3622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen Central Station
    {Coordinate{5.45611, 51.4508}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eindhoven Strijp-S railway station
    {Coordinate{8.39033, 46.8969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dörfli railway station
    {Coordinate{9.1658, 48.7726}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Feuersee station
    {Coordinate{8.68666, 47.4258}, Tz::Europe_Zurich, CountryId{"CH"}}, // Effretikon railway station
    {Coordinate{14.073, 53.6818}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eggesin railway station
    {Coordinate{8.51513, 47.5725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eglisau railway station
    {Coordinate{7.99917, 46.5792}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eigerwand railway station
    {Coordinate{5.32778, 50.9306}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hasselt railway station
    {Coordinate{8.00667, 46.5678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eismeer railway station
    {Coordinate{9.89361, 53.6025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elbgaustrasse station
    {Coordinate{11.2201, 49.3762}, Tz::Europe_Berlin, CountryId{"DE"}}, // Feucht Ost station
    {Coordinate{8.59886, 53.5349}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremerhaven Hauptbahnhof
    {Coordinate{8.86371, 47.4986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Elgg railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aichach station
    {Coordinate{8.40142, 46.8196}, Tz::Europe_Zurich, CountryId{"CH"}}, // Engelberg railway station
    {Coordinate{9.18778, 48.8036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart North station
    {Coordinate{8.92972, 50.1214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hanau Central Station
    {Coordinate{8.4021, 47.4558}, Tz::Europe_Zurich, CountryId{"CH"}}, // Otelfingen Golfpark railway station
    {Coordinate{6.95361, 51.4625}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Borbeck Süd station
    {Coordinate{6.92152, 51.4875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Dellwig Ost station
    {Coordinate{7.07288, 51.4175}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Holthausen station
    {Coordinate{7.02332, 51.4226}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Stadtwald station
    {Coordinate{8.81859, 47.6611}, Tz::Europe_Zurich, CountryId{"CH"}}, // Etzwilen railway station
    {Coordinate{9.04692, 46.9757}, Tz::Europe_Zurich, CountryId{"CH"}}, // Leuggelbach railway station
    {Coordinate{1.64831, 50.4157}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rang-du-Fliers
    {Coordinate{13.5094, 52.455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Schöneweide station
    {Coordinate{7.15, 51.2547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal Central Station
    {Coordinate{8.2188, 46.8605}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ewil Maxon railway station
    {Coordinate{8.79033, 46.4825}, Tz::Europe_Zurich, CountryId{"CH"}}, // Faido railway station
    {Coordinate{8.2225, 53.1436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oldenburg Central Station
    {Coordinate{13.3517, 52.4794}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Schöneberg station
    {Coordinate{1.88138, 45.3294}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Corrèze
    {Coordinate{6.65194, 49.7569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trier Central Station
    {Coordinate{8.78354, 47.2388}, Tz::Europe_Zurich, CountryId{"CH"}}, // Feldbach railway station
    {Coordinate{9.48139, 46.8431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Felsberg station
    {Coordinate{8.13222, 46.4033}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fiesch railway station
    {Coordinate{4.64222, 51.8147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zwijndrecht railway station
    {Coordinate{9.8195, 53.4747}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fischbek station
    {Coordinate{4.33917, 50.7739}, Tz::Europe_Brussels, CountryId{"BE"}}, // Linkebeek railway station
    {Coordinate{2.73333, 47.6464}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Briare
    {Coordinate{7.76882, 49.4359}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kaiserslautern Hauptbahnhof
    {Coordinate{6.44611, 51.1964}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mönchengladbach Hauptbahnhof
    {Coordinate{8.68639, 50.1147}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Konstablerwache station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q54801974
    {Coordinate{8.94316, 47.5771}, Tz::Europe_Zurich, CountryId{"CH"}}, // Felben-Wellhausen railway station
    {Coordinate{11.3086, 49.3427}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Burgthann
    {Coordinate{11.2036, 49.3821}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q54878964
    {Coordinate{8.68597, 47.1915}, Tz::Europe_Zurich, CountryId{"CH"}}, // Samstagern railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q55000745
    {Coordinate{13.0146, 51.0744}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q55000746
    {Coordinate{10.2581, 46.7878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ftan
    {Coordinate{8.42833, 46.5761}, Tz::Europe_Zurich, CountryId{"CH"}}, // Furka railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q55154742
    {Coordinate{8.83422, 47.2299}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jona railway station
    {Coordinate{2.24, 44.5272}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aubin
    {Coordinate{2.27111, 44.5231}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cransac
    {Coordinate{1.5675, 43.6961}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gragnague
    {Coordinate{1.80722, 43.8561}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lisle-sur-Tarn
    {Coordinate{1.59806, 43.7158}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montastruc-la-Conseillère
    {Coordinate{1.52403, 43.645}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montrabé
    {Coordinate{2.40861, 44.4636}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Christophe
    {Coordinate{2.03583, 44.3469}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranche-de-Rouergue
    {Coordinate{2.21861, 44.5556}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Viviez-Decazeville
    {Coordinate{13.5752, 52.5126}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Wuhletal station
    {Coordinate{13.4747, 52.5142}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Frankfurter Allee station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Frohburg
    {Coordinate{7.05033, 51.5869}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelsenkirchen-Buer Nord station
    {Coordinate{9.01872, 45.9278}, Tz::Europe_Zurich, CountryId{"CH"}}, // Generoso Vetta railway station
    {Coordinate{7.09694, 50.7319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn Hauptbahnhof
    {Coordinate{13.3191, 52.5052}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Savignyplatz station
    {Coordinate{8.18582, 46.7271}, Tz::Europe_Zurich, CountryId{"CH"}}, // Meiringen railway station
    {Coordinate{6.7692, 50.5829}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münstereifel-Iversheim station
    {Coordinate{9.22611, 47.5514}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erlen station
    {Coordinate{6.83722, 46.5425}, Tz::Europe_Zurich, CountryId{"CH"}}, // Palézieux railway station
    {Coordinate{8.71868, 47.3504}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uster railway station
    {Coordinate{13.3216, 52.4562}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Rathaus Steglitz station
    {Coordinate{6.8109, 50.6338}, Tz::Europe_Berlin, CountryId{"DE"}}, // Euskirchen-Stotzheim station
    {Coordinate{8.18619, 46.8362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Giswil railway station
    {Coordinate{9.00343, 46.1741}, Tz::Europe_Zurich, CountryId{"CH"}}, // Giubiasco railway station
    {Coordinate{6.59667, 49.7103}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q55652449
    {Coordinate{6.97645, 51.5751}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gladbeck West station
    {Coordinate{8.55904, 47.4305}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glattbrugg railway station
    {Coordinate{8.52365, 47.5488}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glattfelden railway station
    {Coordinate{8.36139, 46.5614}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gletsch railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q55743881
    {Coordinate{8.37153, 46.8686}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grafenort railway station
    {Coordinate{13.4618, 52.4938}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Treptower Park station
    {Coordinate{14.3478, 53.4172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grambow railway station
    {Coordinate{13.3969, 54.0761}, Tz::Europe_Berlin, CountryId{"DE"}}, // Greifswald Süd railway station
    {Coordinate{8.02333, 46.6228}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grindelwald Grund railway station
    {Coordinate{8.03333, 46.6244}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grindelwald railway station
    {Coordinate{13.4806, 54.0133}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Kiesow railway station
    {Coordinate{13.0047, 53.3147}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Quassow railway station
    {Coordinate{9.64583, 46.9803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grusch
    {Coordinate{13.5416, 52.3992}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grünbergallee station
    {Coordinate{10.1506, 46.7714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Guarda
    {Coordinate{}, Tz::Europe_Paris, CountryId{"FR"}}, // Gray Gare Routière
    {Coordinate{9.44722, 51.3122}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kassel-Wilhelmshöhe station
    {Coordinate{6.99804, 51.1882}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haan station
    {Coordinate{7.92056, 46.605}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wengen railway station
    {Coordinate{82.9, 55.0358}, Tz::Asia_Novosibirsk, CountryId{"RU"}}, // Novosibirsk Main railway station
    {Coordinate{9.53333, 46.8769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Haldenstein
    {Coordinate{9.03901, 46.9651}, Tz::Europe_Zurich, CountryId{"CH"}}, // Luchsingen-Hätzingen railway station
    {Coordinate{7.6516, 46.5888}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frutigen railway station
    {Coordinate{9.52488, 46.6811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solis station
    {Coordinate{9.72312, 46.6505}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stugl/Stuls station
    {Coordinate{7.18471, 51.7379}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltern am See station
    {Coordinate{9.98944, 53.6319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg Airport station
    {Coordinate{6.60167, 51.735}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamminkeln railway station
    {Coordinate{8.53167, 52.0283}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bielefeld Central Station
    {Coordinate{7.635, 51.9567}, Tz::Europe_Berlin, CountryId{"DE"}}, // Münster Central Station
    {Coordinate{11.4369, 48.7444}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ingolstadt Central Station
    {Coordinate{12.9306, 50.8402}, Tz::Europe_Berlin, CountryId{"DE"}}, // Chemnitz Hauptbahnhof
    {Coordinate{10.6692, 53.8672}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck Central Station
    {Coordinate{11.4614, 48.15}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Pasing station
    {Coordinate{7.30111, 52.785}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haren (Ems) station
    {Coordinate{8.67889, 50.1139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Hauptwache station
    {Coordinate{9.99167, 53.4561}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Harburg station
    {Coordinate{6.77611, 51.43}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg Central Station
    {Coordinate{13.3013, 52.5305}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Jungfernheide station
    {Coordinate{13.1792, 52.4214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Wannsee station
    {Coordinate{8.41393, 49.9917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rüsselsheim station
    {Coordinate{5.19028, 52.3675}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Muziekwijk railway station
    {Coordinate{7.11917, 50.8789}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cologne/Bonn Airport station
    {Coordinate{9.18925, 47.4156}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flawil station
    {Coordinate{6.84345, 46.463}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vevey railway station
    {Coordinate{13.8581, 50.9811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidenau railway station
    {Coordinate{13.4417, 52.4692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Neukölln station
    {Coordinate{9.49772, 45.3092}, Tz::Europe_Rome, CountryId{"IT"}}, // Lodi railway station
    {Coordinate{13.4137, 52.5492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Schönhauser Allee station
    {Coordinate{13.3854, 52.4708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Tempelhof station
    {Coordinate{6.81861, 52.2686}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hengelo Oost railway station
    {Coordinate{8.68507, 47.5645}, Tz::Europe_Zurich, CountryId{"CH"}}, // Henggart railway station
    {Coordinate{13.3365, 52.5144}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Tiergarten station
    {Coordinate{8.31408, 46.9933}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hergiswil Matt railway station
    {Coordinate{8.69478, 47.5452}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hettlingen railway station
    {Coordinate{5.1572, 52.2806}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Naarden-Bussum railway station
    {Coordinate{5.10997, 52.0893}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Centraal railway station
    {Coordinate{14.5208, 48.1794}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q576448
    {Coordinate{8.52246, 47.1948}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baar railway station
    {Coordinate{5.42361, 52.9467}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hindeloopen railway station
    {Coordinate{8.8397, 47.3001}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hinwil railway station
    {Coordinate{4.34889, 48.9554}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Châlons-en-Champagne
    {Coordinate{1.59917, 42.8492}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tarascon-sur-Ariège
    {Coordinate{8.77806, 47.2031}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pfäffikon SZ railway station
    {Coordinate{8.90328, 47.4881}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aadorf railway station
    {Coordinate{7.27878, 47.047}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5845568
    {Coordinate{8.76561, 47.336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aathal railway station
    {Coordinate{6.96368, 46.3168}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5845601
    {Coordinate{9.10972, 47.4486}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5845647
    {Coordinate{9.30222, 47.5506}, Tz::Europe_Zurich, CountryId{"CH"}}, // Amriswil station
    {Coordinate{9.25194, 47.4421}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arnegg station
    {Coordinate{9.00863, 47.2045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Benken railway station
    {Coordinate{9.0299, 47.1522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bilten railway station
    {Coordinate{9.23389, 47.5003}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bischofszell Nord
    {Coordinate{9.24167, 47.4921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bischofszell Stadt
    {Coordinate{7.62167, 47.0607}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burgdorf station
    {Coordinate{8.72716, 47.201}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bäch railway station
    {Coordinate{9.14958, 47.5492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bürglen station
    {Coordinate{6.14734, 46.2424}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chambésy
    {Coordinate{6.18778, 46.3174}, Tz::Europe_Zurich, CountryId{"CH"}}, // Coppet
    {Coordinate{6.16139, 46.2636}, Tz::Europe_Zurich, CountryId{"CH"}}, // Creux-de-Genthod
    {Coordinate{9.02436, 46.9462}, Tz::Europe_Zurich, CountryId{"CH"}}, // Diesbach-Betschwanden railway station
    {Coordinate{8.75296, 47.5533}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dinhard railway station
    {Coordinate{8.95852, 47.4615}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eschlikon railway station
    {Coordinate{7.206, 46.9992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846260
    {Coordinate{6.15417, 46.2567}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genthod-Bellevue
    {Coordinate{9.07135, 47.0393}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glarus railway station
    {Coordinate{9.253, 47.4117}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gossau station
    {Coordinate{8.68728, 47.1983}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grüenfeld railway station
    {Coordinate{8.91702, 47.4741}, Tz::Europe_Zurich, CountryId{"CH"}}, // Guntershausen railway station
    {Coordinate{9.25139, 47.4769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hauptwil station
    {Coordinate{8.44595, 47.2988}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hedingen railway station
    {Coordinate{7.70083, 47.1881}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846371
    {Coordinate{8.97454, 47.5823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hüttlingen-Mettendorf railway station
    {Coordinate{8.84618, 47.5478}, Tz::Europe_Zurich, CountryId{"CH"}}, // Islikon railway station
    {Coordinate{7.23506, 47.0256}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846437
    {Coordinate{7.19278, 46.9751}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kerzers station
    {Coordinate{7.19931, 46.9898}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846441
    {Coordinate{8.46671, 47.2203}, Tz::Europe_Zurich, CountryId{"CH"}}, // Knonau railway station
    {Coordinate{9.20167, 47.5247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kradolf station
    {Coordinate{8.85269, 47.1901}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lachen railway station
    {Coordinate{7.78471, 47.2173}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846546
    {Coordinate{7.64361, 46.3119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846591
    {Coordinate{8.99778, 46.9256}, Tz::Europe_Zurich, CountryId{"CH"}}, // Linthal railway station
    {Coordinate{9.00248, 46.9284}, Tz::Europe_Zurich, CountryId{"CH"}}, // Linthal Braunwaldbahn railway station
    {Coordinate{8.45737, 47.2441}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mettmenstetten railway station
    {Coordinate{6.16278, 46.2872}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mies
    {Coordinate{7.38134, 47.2803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Moutier
    {Coordinate{7.11531, 46.9253}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846782
    {Coordinate{9.06218, 47.5828}, Tz::Europe_Zurich, CountryId{"CH"}}, // Märstetten railway station
    {Coordinate{9.0155, 47.5882}, Tz::Europe_Zurich, CountryId{"CH"}}, // Müllheim-Wigoltingen railway station
    {Coordinate{9.05926, 46.9859}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nidfurn-Haslen railway station
    {Coordinate{9.26711, 47.5537}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846823
    {Coordinate{8.72409, 47.6146}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ossingen railway station
    {Coordinate{8.38751, 47.4549}, Tz::Europe_Zurich, CountryId{"CH"}}, // Otelfingen railway station
    {Coordinate{6.94, 46.8196}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5846899
    {Coordinate{6.16278, 46.2872}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pont-Céard
    {Coordinate{8.9823, 47.1727}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reichenburg railway station
    {Coordinate{8.7525, 47.5294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reutlingen railway station
    {Coordinate{8.78916, 47.5354}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rickenbach-Attikon railway station
    {Coordinate{6.91194, 46.6935}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5847067
    {Coordinate{9.01303, 46.9345}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rüti GL railway station
    {Coordinate{9.32972, 47.4072}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Bruggen station
    {Coordinate{9.30089, 47.404}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Winkeln station
    {Coordinate{8.70937, 47.1764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schindellegi-Feusisberg railway station
    {Coordinate{8.81171, 47.5001}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schottikon railway station
    {Coordinate{9.07745, 46.9968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwanden railway station
    {Coordinate{9.06839, 47.4453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwarzenbach SG
    {Coordinate{8.65866, 47.3844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwerzenbach railway station
    {Coordinate{9.04396, 47.1577}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schänis railway station
    {Coordinate{8.93876, 47.1764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schübelbach-Buttikon railway station
    {Coordinate{8.73887, 47.5358}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seuzach railway station
    {Coordinate{8.9007, 47.1827}, Tz::Europe_Zurich, CountryId{"CH"}}, // Siebnen-Wangen railway station
    {Coordinate{9.00046, 47.462}, Tz::Europe_Zurich, CountryId{"CH"}}, // Train station of Sirnach
    {Coordinate{9.24844, 47.5057}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sitterdorf station
    {Coordinate{7.16889, 47.1951}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5847270
    {Coordinate{8.78873, 47.6349}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stammheim railway station
    {Coordinate{8.72167, 47.2406}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stäfa railway station
    {Coordinate{6.18083, 46.3075}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tannay
    {Coordinate{8.75763, 47.5696}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thalheim-Altikon railway station
    {Coordinate{6.14734, 46.2499}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Tuileries station
    {Coordinate{8.67877, 47.259}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uetikon railway station
    {Coordinate{9.13111, 47.4365}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uzwil railway station
    {Coordinate{6.16583, 46.2797}, Tz::Europe_Zurich, CountryId{"CH"}}, // Versoix
    {Coordinate{9.08624, 47.2994}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wattwil Station
    {Coordinate{8.77602, 47.5255}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wiesendangen railway station
    {Coordinate{9.04098, 47.4624}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wil railway station
    {Coordinate{7.66333, 47.1052}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q5847534
    {Coordinate{8.35764, 47.4458}, Tz::Europe_Zurich, CountryId{"CH"}}, // Würenlos railway station
    {Coordinate{7.76083, 51.4717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fröndenberg station
    {Coordinate{-3.14333, 48.5556}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guingamp
    {Coordinate{6.96699, 51.2162}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochdahl-Millrath station
    {Coordinate{5.93028, 50.9056}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoensbroek railway station
    {Coordinate{5.17917, 52.1781}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hollandsche Rading railway station
    {Coordinate{13.2419, 46.056}, Tz::Europe_Rome, CountryId{"IT"}}, // Udine railway station
    {Coordinate{1.78466, 49.2851}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gisors-Embranchement
    {Coordinate{6.35061, 48.6054}, Tz::Europe_Paris, CountryId{"FR"}}, // Q589290
    {Coordinate{8.62528, 45.4508}, Tz::Europe_Rome, CountryId{"IT"}}, // Novara railway station
    {Coordinate{8.30662, 47.0172}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horw railway station
    {Coordinate{8.9439, 50.1071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q590724
    {Coordinate{3.74509, 50.4233}, Tz::Europe_Brussels, CountryId{"BE"}}, // Thulin railway station
    {Coordinate{4.39028, 50.3978}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marchienne-Zone railway station
    {Coordinate{5.21778, 52.375}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Centrum railway station
    {Coordinate{23.3624, 60.9196}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Humppila railway station
    {Coordinate{8.92141, 50.5977}, Tz::Europe_Berlin, CountryId{"DE"}}, // Göbelnrod station
    {Coordinate{8.51278, 47.5811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hüntwangen-Wil railway station
    {Coordinate{8.81673, 47.2249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rapperswil railway station
    {Coordinate{-1.50509, 48.5525}, Tz::Europe_Paris, CountryId{"FR"}}, // Pontorson - Mont-Saint-Michel
    {Coordinate{5.95778, 47.3089}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Besançon Franche-Comté TGV
    {Coordinate{9.56472, 46.9497}, Tz::Europe_Zurich, CountryId{"CH"}}, // Igis
    {Coordinate{6.93306, 52.3061}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oldenzaal railway station
    {Coordinate{8.7227, 47.4088}, Tz::Europe_Zurich, CountryId{"CH"}}, // Illnau railway station
    {Coordinate{-2.23, 53.477}, Tz::Europe_London, CountryId{"GB"}}, // Manchester Piccadilly station
    {Coordinate{5.59952, 50.6129}, Tz::Europe_Brussels, CountryId{"BE"}}, // Angleur railway station
    {Coordinate{5.84333, 53.0469}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Akkrum railway station
    {Coordinate{-1.40724, 48.8299}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Folligny
    {Coordinate{9.4459, 47.045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sargans Station
    {Coordinate{5.23444, 52.6953}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bovenkarspel-Grootebroek railway station
    {Coordinate{24.2758, 55.0932}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Jonava railway station
    {Coordinate{0.160833, 49.4997}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Havre-Graville
    {Coordinate{2.91428, 50.5519}, Tz::Europe_Paris, CountryId{"FR"}}, // Don-Sainghin
    {Coordinate{16.3149, 48.2232}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q608453
    {Coordinate{9.42954, 44.264}, Tz::Europe_Rome, CountryId{"IT"}}, // Riva Trigoso station
    {Coordinate{5.36889, 51.715}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rosmalen railway station
    {Coordinate{7.53522, 48.3389}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Kogenheim
    {Coordinate{9.2375, 52.9208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Verden (Aller) railway station
    {Coordinate{9.70611, 45.0519}, Tz::Europe_Rome, CountryId{"IT"}}, // Piacenza railway station
    {Coordinate{-0.762222, 46.1133}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Surgères
    {Coordinate{4.57328, 50.9823}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boortmeerbeek railway station
    {Coordinate{9.18167, 48.7839}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Central Station
    {Coordinate{3.89028, 51.4983}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Goes railway station
    {Coordinate{14.2594, 37.0727}, Tz::Europe_Rome, CountryId{"IT"}}, // Gela railway station
    {Coordinate{13.2589, 54.1644}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jeeser railway station
    {Coordinate{9.71833, 46.93}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jenaz
    {Coordinate{8.57327, 47.6544}, Tz::Europe_Berlin, CountryId{"CH"}}, // Jestetten railway station
    {Coordinate{2.38278, 48.6892}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Juvisy
    {Coordinate{5.60444, 49.4436}, Tz::Europe_Paris, CountryId{"FR"}}, // Q628887
    {Coordinate{8.81361, 53.0831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremen main station
    {Coordinate{2.31861, 48.84}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare Montparnasse
    {Coordinate{6.17139, 51.3647}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Venlo railway station
    {Coordinate{-0.1075, 49.2864}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dives-Cabourg
    {Coordinate{9.98944, 53.5608}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg Dammtor station
    {Coordinate{13.4964, 52.5106}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Lichtenberg station
    {Coordinate{2.88, 47.3369}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tracy-Sancerre
    {Coordinate{8.41867, 47.5666}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaiserstuhl AG railway station
    {Coordinate{8.17542, 46.8143}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaiserstuhl OW railway station
    {Coordinate{6.20279, 51.3272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kaldenkirchen station
    {Coordinate{14.4975, 50.1122}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha-Vysočany railway station
    {Coordinate{4.27337, 50.8683}, Tz::Europe_Brussels, CountryId{"BE"}}, // Groot-Bijgaarden railway station
    {Coordinate{8.25865, 50.0013}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz Central Station
    {Coordinate{5.99389, 51.1922}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Roermond railway station
    {Coordinate{13.1865, 41.4221}, Tz::Europe_Rome, CountryId{"IT"}}, // Priverno-Fossanova railway station
    {Coordinate{6.91, 50.8758}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hürth-Kalscheuren station
    {Coordinate{13.1933, 52.4317}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Nikolassee station
    {Coordinate{8.65071, 46.8201}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erstfeld railway station
    {Coordinate{8.5321, 47.3729}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Selnau railway station
    {Coordinate{13.3661, 52.5425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Wedding station
    {Coordinate{8.81448, 47.2383}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kempraten railway station
    {Coordinate{8.80419, 47.3318}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kempten railway station
    {Coordinate{12.7411, 54.3286}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kenz railway station
    {Coordinate{4.87806, 51.8322}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boven Hardinxveld railway station
    {Coordinate{9.86111, 53.5581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Klein Flottbek station
    {Coordinate{9.87556, 46.8833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Klosters Dorf
    {Coordinate{8.57076, 47.442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kloten Balsberg railway station
    {Coordinate{5.57549, 45.5422}, Tz::Europe_Paris, CountryId{"FR"}}, // Q642288
    {Coordinate{8.77301, 47.4581}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kollbrunn railway station
    {Coordinate{4.39389, 50.4431}, Tz::Europe_Brussels, CountryId{"BE"}}, // Roux railway station
    {Coordinate{6.51162, 51.1954}, Tz::Europe_Berlin, CountryId{"DE"}}, // Korschenbroich station
    {Coordinate{8.30218, 47.0267}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kriens Mattenhof railway station
    {Coordinate{9.77194, 46.9142}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kublis
    {Coordinate{3.69869, 50.4825}, Tz::Europe_Brussels, CountryId{"BE"}}, // Harchies railway station
    {Coordinate{9.84639, 46.498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sankt Moritz
    {Coordinate{8.57578, 47.3272}, Tz::Europe_Zurich, CountryId{"CH"}}, // Küsnacht Goldbach railway station
    {Coordinate{8.5807, 47.3193}, Tz::Europe_Zurich, CountryId{"CH"}}, // Küsnacht ZH railway station
    {Coordinate{10.0064, 53.5528}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg Central Station
    {Coordinate{4.38505, 45.4468}, Tz::Europe_Paris, CountryId{"FR"}}, // Q645671
    {Coordinate{9.92333, 46.5786}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Punt-Chamues-ch
    {Coordinate{13.0667, 52.3917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Hauptbahnhof
    {Coordinate{13.6083, 54.5178}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lancken railway station
    {Coordinate{9.56083, 46.9572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Landquart Ried
    {Coordinate{6.92413, 51.1172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenfeld-Berghausen station
    {Coordinate{6.7303, 51.161}, Tz::Europe_Berlin, CountryId{"DE"}}, // Norf station
    {Coordinate{8.32194, 47.6289}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauchringen station
    {Coordinate{10.1111, 46.7694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lavin
    {Coordinate{9.935, 53.5519}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Altona station
    {Coordinate{10.0781, 46.2919}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Prese
    {Coordinate{5.80706, 45.8244}, Tz::Europe_Paris, CountryId{"FR"}}, // Vions - Chanaz
    {Coordinate{7.00537, 51.1079}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leichlingen station
    {Coordinate{13.4111, 52.5667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Pankow station
    {Coordinate{10.0633, 46.3108}, Tz::Europe_Zurich, CountryId{"CH"}}, // Li Curt
    {Coordinate{7.26415, 47.655}, Tz::Europe_Paris, CountryId{"FR"}}, // Q653961
    {Coordinate{13.3963, 52.3876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lichtenrade station
    {Coordinate{13.5111, 54.4811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lietzow railway station
    {Coordinate{13.1958, 52.5347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Spandau station
    {Coordinate{4.39417, 50.855}, Tz::Europe_Brussels, CountryId{"BE"}}, // Meiser railway station
    {Coordinate{5.08889, 52.1033}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Zuilen railway station
    {Coordinate{-2.50671, 47.2903}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Croisic train station
    {Coordinate{16.3737, 48.1869}, Tz::Europe_Vienna, CountryId{"AT"}}, // Südtiroler Platz-Hauptbahnhof
    {Coordinate{1.2675, 45.8361}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Limoges-Bénédictins
    {Coordinate{9.7175, 52.3937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Nordstadt station
    {Coordinate{4.30861, 50.365}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hourpes railway station
    {Coordinate{13.4689, 52.5031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ostkreuz
    {Coordinate{4.36083, 50.8603}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-North railway station
    {Coordinate{2.39428, 47.0944}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourges
    {Coordinate{13.5128, 52.3914}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Schönefeld Flughafen station
    {Coordinate{9.02909, 46.195}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bellinzona railway station
    {Coordinate{7.55586, 47.5905}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Louis
    {Coordinate{5.53959, 49.7274}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marbehan railway station
    {Coordinate{15.6239, 48.2081}, Tz::Europe_Vienna, CountryId{"AT"}}, // St. Pölten Central Station
    {Coordinate{2.93222, 47.4139}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cosne-sur-Loire
    {Coordinate{4.40417, 50.8189}, Tz::Europe_Brussels, CountryId{"BE"}}, // Delta railway station
    {Coordinate{11.7781, 47.3886}, Tz::Europe_Vienna, CountryId{"AT"}}, // Jenbach railway station
    {Coordinate{7.85139, 46.6822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Interlaken West railway station
    {Coordinate{16.2342, 47.8117}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wiener Neustadt Central Station
    {Coordinate{9.52843, 46.8529}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chur
    {Coordinate{13.4497, 52.5058}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Warschauer Straße station
    {Coordinate{2.46917, 49.2639}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Creil
    {Coordinate{7.57207, 47.5713}, Tz::Europe_Zurich, CountryId{"CH"}}, // Basel St. Johann railway station
    {Coordinate{13.9281, 50.9617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pirna railway station
    {Coordinate{7.60728, 47.5681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Basel Badischer Bahnhof
    {Coordinate{1.89889, 50.0472}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-Rémy
    {Coordinate{8.24389, 50.0708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wiesbaden Central Station
    {Coordinate{11.2069, 44.3411}, Tz::Europe_Rome, CountryId{"IT"}}, // Q667146
    {Coordinate{7.58972, 47.5475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Basel SBB railway station
    {Coordinate{13.7242, 51.0556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Mitte railway station
    {Coordinate{8.56681, 47.6257}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lottstetten railway station
    {Coordinate{6.62917, 46.5172}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne railway station
    {Coordinate{7.80868, 48.5768}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kehl station
    {Coordinate{8.16369, 46.7861}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lungern railway station
    {Coordinate{14.2153, 53.4567}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löcknitz railway station
    {Coordinate{7.949, 46.637}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lütschental railway station
    {Coordinate{7.86972, 46.6906}, Tz::Europe_Zurich, CountryId{"CH"}}, // Interlaken Ost railway station
    {Coordinate{6.63024, 46.5206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne-Flon railway station
    {Coordinate{13.3758, 52.5094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Potsdamer Platz station
    {Coordinate{9.93833, 46.5872}, Tz::Europe_Zurich, CountryId{"CH"}}, // Madulain
    {Coordinate{8.89058, 45.9834}, Tz::Europe_Zurich, CountryId{"CH"}}, // Magliaso Paese railway station
    {Coordinate{8.88459, 45.9816}, Tz::Europe_Zurich, CountryId{"CH"}}, // Magliaso railway station
    {Coordinate{8.54861, 47.3667}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Stadelhofen railway station
    {Coordinate{13.3878, 52.5319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Nordbahnhof
    {Coordinate{9.57361, 46.9775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Malans
    {Coordinate{-0.0725655, 51.4181}, Tz::Europe_London, CountryId{"GB"}}, // Crystal Palace railway station
    {Coordinate{8.63344, 49.6418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heppenheim station
    {Coordinate{6.11194, 46.2325}, Tz::Europe_Zurich, CountryId{"CH"}}, // Geneva Airport railway station
    {Coordinate{8.65284, 47.6347}, Tz::Europe_Zurich, CountryId{"CH"}}, // Marthalen railway station
    {Coordinate{8.72333, 47.5}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur railway station
    {Coordinate{16.3847, 48.2064}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Mitte railway station
    {Coordinate{8.63306, 47.0264}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwyz railway station
    {Coordinate{4.6827, 45.8542}, Tz::Europe_Paris, CountryId{"FR"}}, // Q677672
    {Coordinate{1.9502, 43.3121}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castelnaudary
    {Coordinate{13.2839, 52.5011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Westkreuz station
    {Coordinate{13.3894, 52.5486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Gesundbrunnen station
    {Coordinate{13.0748, 53.3593}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustrelitz Central Station
    {Coordinate{8.48917, 47.3917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Altstetten railway station
    {Coordinate{8.5236, 47.3714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Wiedikon railway station
    {Coordinate{8.52917, 47.3922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Wipkingen railway station
    {Coordinate{16.3919, 48.2181}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Praterstern railway station
    {Coordinate{4.84289, 46.7814}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chalon-sur-Saône
    {Coordinate{6.91028, 46.4358}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montreux railway station
    {Coordinate{5.47333, 50.7839}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tongeren railway station
    {Coordinate{13.3325, 52.5072}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Zoologischer Garten railway station
    {Coordinate{8.05124, 47.3915}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aarau railway station
    {Coordinate{10.8864, 48.3656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augsburg Central Station
    {Coordinate{8.62889, 49.8725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Darmstadt Central Station
    {Coordinate{12.1308, 54.0781}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock Central Station
    {Coordinate{11.0819, 49.4464}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nuremberg Central Station
    {Coordinate{9.93556, 49.8014}, Tz::Europe_Berlin, CountryId{"DE"}}, // Würzburg Central Station
    {Coordinate{9.03169, 45.8322}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chiasso railway station
    {Coordinate{13.4347, 52.51}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Ostbahnhof
    {Coordinate{16.3861, 48.195}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Wien Rennweg
    {Coordinate{16.4522, 48.2775}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Leopoldau railway station
    {Coordinate{7.60894, 47.5379}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bahnhof Basel Dreispitz
    {Coordinate{1.53317, 44.1621}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caussade
    {Coordinate{8.58828, 46.6653}, Tz::Europe_Zurich, CountryId{"CH"}}, // Göschenen
    {Coordinate{6.60806, 53.4008}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Usquert railway station
    {Coordinate{0.3775, 46.67}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Futuroscope
    {Coordinate{13.2014, 54.1992}, Tz::Europe_Berlin, CountryId{"DE"}}, // Miltzow railway station
    {Coordinate{8.80189, 46.1725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locarno railway station
    {Coordinate{16.3611, 48.2261}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Franz-Josefs-Bahnhof
    {Coordinate{10.0198, 46.4088}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ospizio Bernina
    {Coordinate{10.0965, 46.7634}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sagliains
    {Coordinate{12.8208, 53.2703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mirow railway station
    {Coordinate{6.02196, 47.247}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Besançon-Viotte
    {Coordinate{8.40056, 48.9939}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karlsruhe Central Station
    {Coordinate{13.4022, 52.5226}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Hackescher Markt station
    {Coordinate{5.70556, 50.8497}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maastricht railway station
    {Coordinate{5.47972, 51.4428}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eindhoven railway station
    {Coordinate{8.63333, 47.7}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schaffhausen railway station
    {Coordinate{4.76472, 52.6439}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Alkmaar Noord railway station
    {Coordinate{9.94028, 46.4508}, Tz::Europe_Zurich, CountryId{"CH"}}, // Morteratsch
    {Coordinate{4.44889, 51.1831}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel railway station
    {Coordinate{7.9, 51.1167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q691608
    {Coordinate{21.0031, 52.2286}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warsaw Central railway station
    {Coordinate{7.24298, 47.133}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel/Bienne railway station
    {Coordinate{13.0467, 47.8131}, Tz::Europe_Vienna, CountryId{"AT"}}, // Salzburg Hauptbahnhof
    {Coordinate{11.6065, 48.0915}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Fasangarten station
    {Coordinate{11.616, 48.1342}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Leuchtenbergring station
    {Coordinate{11.5958, 48.1186}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-St.-Martin-Strasse station
    {Coordinate{11.6484, 48.1566}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Englschalking station
    {Coordinate{11.6494, 48.1492}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Daglfing station
    {Coordinate{11.5196, 48.1437}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Hirschgarten station
    {Coordinate{11.5364, 48.1078}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Mittersendling station
    {Coordinate{11.5331, 48.095}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Siemenswerke station
    {Coordinate{11.5269, 48.08}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Solln station
    {Coordinate{7.89731, 46.5638}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mürren railway station
    {Coordinate{13.3819, 52.5031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Anhalter Bahnhof
    {Coordinate{16.3778, 48.185}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Hauptbahnhof
    {Coordinate{16.3378, 48.1967}, Tz::Europe_Vienna, CountryId{"AT"}}, // Vienna West railway station
    {Coordinate{13.4119, 52.5214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Alexanderplatz station
    {Coordinate{9.60417, 47.2411}, Tz::Europe_Vienna, CountryId{"AT"}}, // Feldkirch railway station
    {Coordinate{13.7192, 48.0114}, Tz::Europe_Vienna, CountryId{"AT"}}, // Attnang-Puchheim station
    {Coordinate{13.8483, 46.6183}, Tz::Europe_Vienna, CountryId{"AT"}}, // Villach Central Station
    {Coordinate{13.7002, 52.5208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuenhagen station
    {Coordinate{14.3133, 46.6158}, Tz::Europe_Vienna, CountryId{"AT"}}, // Klagenfurt Central Station
    {Coordinate{13.3869, 52.5203}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Friedrichstraße railway station
    {Coordinate{13.3033, 52.5047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Charlottenburg station
    {Coordinate{8.39645, 46.9277}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederrickenbach railway station
    {Coordinate{7.92841, 46.7162}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederried railway station
    {Coordinate{8.38038, 47.506}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederweningen Dorf railway station
    {Coordinate{8.36935, 47.5114}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederweningen railway station
    {Coordinate{5.49389, 52.2222}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijkerk railway station
    {Coordinate{5.79472, 51.8236}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Dukenburg railway station
    {Coordinate{12.3822, 51.3453}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Hauptbahnhof
    {Coordinate{9.74167, 52.3772}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hanover Central Station
    {Coordinate{13.7317, 51.0403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Central Station
    {Coordinate{7.45889, 51.5175}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund Central Station
    {Coordinate{7.15889, 53.6244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Norddeich Mole railway station
    {Coordinate{7.21917, 53.5878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Norden (Germany) railway station
    {Coordinate{8.46972, 49.4797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim Central Station
    {Coordinate{11.098, 49.4481}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Dürrenhof station
    {Coordinate{11.12, 49.4541}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Ostring station
    {Coordinate{11.1333, 49.4591}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Mögeldorf station
    {Coordinate{11.1547, 49.4626}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Rehhof railway station
    {Coordinate{11.1056, 49.4738}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg Nordost station
    {Coordinate{8.57747, 47.2772}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberrieden Dorf railway station
    {Coordinate{8.34222, 46.53}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberwald railway station
    {Coordinate{7.00854, 51.0657}, Tz::Europe_Berlin, CountryId{"DE"}}, // Opladen station
    {Coordinate{13.3145, 52.4194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osdorfer Straße station
    {Coordinate{8.04561, 52.2811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osnabrück Altstadt station
    {Coordinate{11.6788, 48.063}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ottobrunn station
    {Coordinate{6.82834, 46.5572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Palézieux-Village railway station
    {Coordinate{14.0078, 53.5094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pasewalk Ost railway station
    {Coordinate{13.791, 52.5291}, Tz::Europe_Berlin, CountryId{"DE"}}, // Petershagen Nord railway station
    {Coordinate{-0.125, 51.531}, Tz::Europe_London, CountryId{"GB"}}, // St Pancras railway station
    {Coordinate{13.4733, 52.4786}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plänterwald railway station
    {Coordinate{10.7556, 49.1206}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gunzenhausen station
    {Coordinate{10.9772, 49.1061}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pleinfeld train station
    {Coordinate{10.908, 48.9608}, Tz::Europe_Berlin, CountryId{"DE"}}, // Treuchtlingen station
    {Coordinate{8.86, 45.9697}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ponte Tresa railway station
    {Coordinate{9.89639, 46.4906}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pontresina
    {Coordinate{10.0939, 53.6522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Poppenbüttel station
    {Coordinate{9.77722, 46.5881}, Tz::Europe_Zurich, CountryId{"CH"}}, // Preda
    {Coordinate{10.055, 46.3378}, Tz::Europe_Zurich, CountryId{"CH"}}, // Privilasco
    {Coordinate{13.5747, 54.4297}, Tz::Europe_Berlin, CountryId{"DE"}}, // Prora Ost railway station
    {Coordinate{13.5647, 54.4439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Prora railway station
    {Coordinate{9.88111, 46.5094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Punt Muragl
    {Coordinate{9.88028, 46.5072}, Tz::Europe_Zurich, CountryId{"CH"}}, // Punt Muragl Staz
    {Coordinate{13.6076, 46.5062}, Tz::Europe_Rome, CountryId{"IT"}}, // Tarvisio Boscoverde railway station
    {Coordinate{10.2128, 45.5324}, Tz::Europe_Rome, CountryId{"IT"}}, // Brescia railway station
    {Coordinate{8.9575, 46.7325}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rabius-Surrein
    {Coordinate{8.54339, 47.6034}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rafz railway station
    {Coordinate{13.2081, 54.3531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rambin railway station
    {Coordinate{3.535, 50.9781}, Tz::Europe_Brussels, CountryId{"BE"}}, // Deinze railway station
    {Coordinate{8.50389, 46.5989}, Tz::Europe_Zurich, CountryId{"CH"}}, // Realp railway station
    {Coordinate{4.5489, 50.6215}, Tz::Europe_Brussels, CountryId{"BE"}}, // Faux railway station
    {Coordinate{9.4125, 46.8236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reichenau-Tamins
    {Coordinate{6.07972, 51.2833}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Reuver railway station
    {Coordinate{9.39944, 46.7997}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rhäzüns
    {Coordinate{12.4369, 54.2392}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ribnitz-Damgarten West railway station
    {Coordinate{4.31972, 52.0394}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rijswijk railway station
    {Coordinate{8.79655, 47.4445}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rikon railway station
    {Coordinate{7.90008, 46.7036}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ringgenberg railway station
    {Coordinate{8.47743, 47.36}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ringlikon railway station
    {Coordinate{2.36583, 48.8422}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Austerlitz
    {Coordinate{8.3504, 50.0043}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochheim station
    {Coordinate{9.43278, 46.7353}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rodels-Realta
    {Coordinate{2.26632, 50.7533}, Tz::Europe_Paris, CountryId{"FR"}}, // Q736324
    {Coordinate{-1.22562, 48.8341}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villedieu-les-Poêles
    {Coordinate{4.41972, 50.8886}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haren railway station
    {Coordinate{9.41944, 46.7681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rothenbrunnen
    {Coordinate{4.48917, 51.92}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Blaak railway station
    {Coordinate{4.53111, 51.8797}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Lombardijen railway station
    {Coordinate{4.48139, 51.9422}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Noord
    {Coordinate{14.6397, 52.3419}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Kunowice
    {Coordinate{9.14556, 46.7747}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rueun
    {Coordinate{13.2584, 52.4309}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Zehlendorf station
    {Coordinate{8.85468, 47.2601}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rüti ZH railway station
    {Coordinate{9.98167, 46.6119}, Tz::Europe_Zurich, CountryId{"CH"}}, // S-chanf
    {Coordinate{7.26194, 43.7044}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nice-Ville
    {Coordinate{4.39972, 50.8092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Watermael railway station
    {Coordinate{9.39333, 45.8564}, Tz::Europe_Rome, CountryId{"IT"}}, // Lecco railway station
    {Coordinate{5.63212, 45.2904}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Voreppe
    {Coordinate{9.80972, 46.9078}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saas
    {Coordinate{12.7725, 54.3003}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saatel railway station
    {Coordinate{8.23793, 46.8711}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sachseln railway station
    {Coordinate{5.57039, 50.6464}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liège-Palais railway station
    {Coordinate{13.5647, 54.5239}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sagard railway station
    {Coordinate{9.87389, 46.5336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Samedan
    {Coordinate{13.2908, 54.3542}, Tz::Europe_Berlin, CountryId{"DE"}}, // Samtens railway station
    {Coordinate{8.98873, 45.8868}, Tz::Europe_Zurich, CountryId{"CH"}}, // San Nicolao railway station
    {Coordinate{13.9708, 53.5642}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sandförde railway station
    {Coordinate{7.90222, 46.6167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sandweid railway station
    {Coordinate{8.90089, 44.4094}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Via di Francia railway halt
    {Coordinate{2.56306, 49.0106}, Tz::Europe_Paris, CountryId{"FR"}}, // Aéroport Charles de Gaulle 1
    {Coordinate{8.24743, 46.8943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sarnen railway station
    {Coordinate{5.50944, 50.8686}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bilzen railway station
    {Coordinate{9.5451, 46.8382}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sassal
    {Coordinate{13.6381, 54.5161}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sassnitz railway station
    {Coordinate{6.58268, 46.0614}, Tz::Europe_Paris, CountryId{"FR"}}, // Cluses
    {Coordinate{9.68833, 46.9678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schiers
    {Coordinate{8.61387, 47.6764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schloss Laufen am Rheinfall
    {Coordinate{14.2906, 53.0628}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwedt railway station
    {Coordinate{8.00333, 46.63}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schwendi railway station
    {Coordinate{7.91104, 46.6523}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schynige Platte railway station
    {Coordinate{8.41179, 47.498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schöfflisdorf-Oberweningen railway station
    {Coordinate{6.89, 52.2222}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enschede railway station
    {Coordinate{5.19439, 50.2491}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haversin railway station
    {Coordinate{8.20778, 44.895}, Tz::Europe_Rome, CountryId{"IT"}}, // Asti railway station
    {Coordinate{2.59605, 46.3378}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montluçon-Ville
    {Coordinate{14.2717, 50.9753}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sebnitz railway station
    {Coordinate{13.8847, 53.2208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seehausen (Uckermark) railway station
    {Coordinate{14.4196, 40.9942}, Tz::Europe_Rome, CountryId{"IT"}}, // Cancello railway station
    {Coordinate{8.90452, 46.0083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Serocca railway station
    {Coordinate{2.35667, 48.8828}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Nord
    {Coordinate{2.32444, 48.8769}, Tz::Europe_Paris, CountryId{"FR"}}, // gare Saint-Lazare
    {Coordinate{2.37361, 48.8447}, Tz::Europe_Paris, CountryId{"FR"}}, // Paris-Gare de Lyon
    {Coordinate{0.65198, 42.9156}, Tz::Europe_Paris, CountryId{"FR"}}, // Q748493
    {Coordinate{4.37333, 50.7959}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vivier d'Oie railway station
    {Coordinate{9.05722, 50.1619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenselbold station
    {Coordinate{3.81444, 50.8689}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zottegem railway station
    {Coordinate{14.7697, 41.1419}, Tz::Europe_Rome, CountryId{"IT"}}, // Benevento railway station
    {Coordinate{14.4358, 50.0831}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha hlavní nádraží
    {Coordinate{8.577, 47.2385}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sihlbrugg railway station
    {Coordinate{8.5575, 47.2683}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sihlwald railway station
    {Coordinate{12.5018, 41.9006}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Termini railway station
    {Coordinate{8.10535, 51.5782}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soest (Germany) station
    {Coordinate{5.31, 52.1731}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Soest (Netherlands) railway station
    {Coordinate{7.08935, 51.1661}, Tz::Europe_Berlin, CountryId{"DE"}}, // Solingen Mitte station
    {Coordinate{8.93343, 45.997}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sorengo Laghetto railway station
    {Coordinate{8.93476, 46.0003}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sorengo railway station
    {Coordinate{2.35917, 48.8769}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Paris-Est
    {Coordinate{9.84528, 46.5597}, Tz::Europe_Zurich, CountryId{"CH"}}, // Spinas
    {Coordinate{10.2669, 47.1273}, Tz::Europe_Vienna, CountryId{"AT"}}, // St. Anton am Arlberg railway station
    {Coordinate{8.3668, 46.9583}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stans railway station
    {Coordinate{8.33574, 46.9767}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stansstad railway station
    {Coordinate{12.3139, 57.7921}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Stenkullen
    {Coordinate{7.46648, 48.4134}, Tz::Europe_Paris, CountryId{"FR"}}, // Q761462
    {Coordinate{6.61551, 44.6746}, Tz::Europe_Paris, CountryId{"FR"}}, // Q761835
    {Coordinate{13.9084, 52.5902}, Tz::Europe_Berlin, CountryId{"DE"}}, // Strausberg Nord station
    {Coordinate{13.8369, 52.5319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Strausberg station
    {Coordinate{-2.807, 54.048}, Tz::Europe_London, CountryId{"GB"}}, // Lancaster railway station
    {Coordinate{14.2911, 48.2906}, Tz::Europe_Vienna, CountryId{"AT"}}, // Linz Central Station
    {Coordinate{8.93139, 46.7242}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sumvitg-Cumpadials
    {Coordinate{14.3122, 47.55}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q764148
    {Coordinate{19.4736, 49.7125}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q764332
    {Coordinate{19.025, 47.4994}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budapest Southern Railway Terminal
    {Coordinate{10.0794, 46.7519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Susch
    {Coordinate{22.2528, 60.4539}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Turku Central railway station
    {Coordinate{10.9144, 43.9269}, Tz::Europe_Rome, CountryId{"IT"}}, // Pistoia railway station
    {Coordinate{10.0408, 46.3646}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cavaglia
    {Coordinate{9.06222, 46.755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tavanasa-Breil/Brigels
    {Coordinate{13.2767, 52.3969}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teltow Stadt railway station
    {Coordinate{13.2994, 52.3881}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teltow railway station
    {Coordinate{13.3742, 54.3892}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teschenhagen railway station
    {Coordinate{4.48361, 51.0175}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mechelen railway station
    {Coordinate{-1.48, 49.5052}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valognes
    {Coordinate{9.00117, 45.9113}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bellavista railway station
    {Coordinate{4.83528, 51.8303}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hardinxveld-Giessendam railway station
    {Coordinate{7.96294, 48.9908}, Tz::Europe_Paris, CountryId{"FR"}}, // Riedseltz
    {Coordinate{14.6724, 40.7427}, Tz::Europe_Rome, CountryId{"IT"}}, // Q776522
    {Coordinate{16.1772, 53.2192}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q776916
    {Coordinate{6.68806, 49.3867}, Tz::Europe_Berlin, CountryId{"DE"}}, // Beckingen
    {Coordinate{9.44083, 46.6986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thusis
    {Coordinate{10.5725, 50.9303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fröttstädt station
    {Coordinate{8.46472, 46.5875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tiefenbach halting point
    {Coordinate{9.57278, 46.6639}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tiefencastel
    {Coordinate{8.2725, 47.6353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tiengen station
    {Coordinate{4.73429, 50.4393}, Tz::Europe_Brussels, CountryId{"BE"}}, // Franière railway station
    {Coordinate{4.15778, 50.3128}, Tz::Europe_Brussels, CountryId{"BE"}}, // Solre-sur-Sambre railway station
    {Coordinate{7.66583, 45.0725}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Porta Susa railway station
    {Coordinate{14.0085, 53.6346}, Tz::Europe_Berlin, CountryId{"DE"}}, // Torgelow railway station
    {Coordinate{1.75306, 42.7647}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luzenac-Garanou
    {Coordinate{4.80556, 52.4578}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Koog aan de Zaan railway station
    {Coordinate{9.35944, 46.8}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trin
    {Coordinate{8.99056, 46.7425}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trun
    {Coordinate{8.63694, 50.0806}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Niederrad station
    {Coordinate{7.77472, 46.0667}, Tz::Europe_Zurich, CountryId{"CH"}}, // Täsch railway station
    {Coordinate{14.0522, 53.7362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ueckermünde Stadthafen railway station
    {Coordinate{8.4876, 47.3518}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uetliberg railway station
    {Coordinate{8.466, 47.3659}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uitikon Waldegg railway station
    {Coordinate{9.55944, 46.9189}, Tz::Europe_Zurich, CountryId{"CH"}}, // Untervaz-Trimmis
    {Coordinate{8.43021, 47.381}, Tz::Europe_Zurich, CountryId{"CH"}}, // Urdorf Weihermatt railway station
    {Coordinate{8.43484, 47.3908}, Tz::Europe_Zurich, CountryId{"CH"}}, // Urdorf railway station
    {Coordinate{16.87, 41.1181}, Tz::Europe_Rome, CountryId{"IT"}}, // Bari Centrale railway station
    {Coordinate{9.27556, 46.7917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Valendas-Sagogn
    {Coordinate{12.8022, 54.2772}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velgast station
    {Coordinate{4.31417, 51.9039}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlaardingen West railway station
    {Coordinate{4.35869, 52.0665}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorburg railway station
    {Coordinate{8.91387, 47.2724}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wald railway station
    {Coordinate{8.22, 47.6208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Waldshut station
    {Coordinate{9.12, 46.7694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waltensburg/Vuorz
    {Coordinate{13.8772, 53.1836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Warnitz (Uckermark) railway station
    {Coordinate{20.9586, 52.2392}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Koło railway station
    {Coordinate{20.8847, 52.1961}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Ursus railway station
    {Coordinate{20.9811, 52.1931}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Żwirki i Wigury railway station
    {Coordinate{20.9994, 52.3136}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Żerań railway station
    {Coordinate{9.70543, 53.5817}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wedel station
    {Coordinate{7.93667, 46.5761}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wengernalp railway station
    {Coordinate{7.91333, 46.61}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wengwald railway station
    {Coordinate{12.9625, 53.2864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wesenberg railway station
    {Coordinate{5.97043, 51.9624}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Westervoort railway station
    {Coordinate{9.71583, 46.6956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Davos Wiesen station
    {Coordinate{8.84869, 47.4178}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wila railway station
    {Coordinate{7.86972, 46.6661}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilderswil railway station
    {Coordinate{12.2607, 50.3243}, Tz::Europe_Berlin, CountryId{"DE"}}, // Adorf (Vogtl) station
    {Coordinate{6.07373, 50.77}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen Schanz station
    {Coordinate{7.74996, 47.0621}, Tz::Europe_Zurich, CountryId{"CH"}}, // Affoltern-Weier railway station
    {Coordinate{8.4357, 50.5458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Albshausen station
    {Coordinate{13.5653, 52.5711}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahrensfelde station
    {Coordinate{11.1148, 51.6478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Alexisbad
    {Coordinate{5.31722, 43.455}, Tz::Europe_Paris, CountryId{"FR"}}, // Aix-en-Provence TGV railway station
    {Coordinate{4.74056, 52.6378}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Alkmaar railway station
    {Coordinate{76.949, 43.341}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Almaty-1 railway station
    {Coordinate{76.9391, 43.2737}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Almaty-2 railway station
    {Coordinate{6.65601, 52.3558}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almelo railway station
    {Coordinate{5.27778, 52.3942}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Buiten railway station
    {Coordinate{9.26426, 50.7509}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsfeld (Oberhess) station
    {Coordinate{5.2443, 52.3766}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Parkwijk railway station
    {Coordinate{12.1642, 49.7231}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800378
    {Coordinate{8.10989, 49.7501}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alzey station
    {Coordinate{4.96, 52.2983}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Holendrecht
    {Coordinate{9.87278, 48.5781}, Tz::Europe_Berlin, CountryId{"DE"}}, // Amstetten (Württemberg) station
    {Coordinate{14.8781, 48.1217}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Amstetten
    {Coordinate{4.43222, 51.1997}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerp-Berchem railway station
    {Coordinate{32.8439, 39.9361}, Tz::Europe_Istanbul, CountryId{"TR"}}, // Ankara railway station
    {Coordinate{7.11944, 43.5858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Antibes
    {Coordinate{4.42444, 51.2444}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerpen-Luchtbal railway station
    {Coordinate{8.21108, 50.4064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Arfurt (Lahn) station
    {Coordinate{4.42778, 51.2614}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerpen-Noorderdokken railway station
    {Coordinate{11.526, 51.0308}, Tz::Europe_Berlin, CountryId{"DE"}}, // Apolda station
    {Coordinate{5.9675, 52.2092}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Apeldoorn railway station
    {Coordinate{8.06667, 51.4053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Arnsberg (Westfalen) station
    {Coordinate{9.67938, 46.7842}, Tz::Europe_Zurich, CountryId{"CH"}}, // Arosa
    {Coordinate{4.42111, 51.2169}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerp-Central railway station
    {Coordinate{5.90083, 51.9847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem railway station
    {Coordinate{3.66917, 51.5014}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnemuiden railway station
    {Coordinate{71.4091, 51.1957}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Astana-1 railway station
    {Coordinate{0.874481, 51.1436}, Tz::Europe_London, CountryId{"GB"}}, // Ashford International railway station
    {Coordinate{12.6983, 50.5917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800408
    {Coordinate{10.9442, 48.3531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augsburg-Hochzoll station
    {Coordinate{10.9011, 48.3553}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augsburg Haunstetter Straße station
    {Coordinate{10.8728, 48.3806}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augsburg-Oberhausen station
    {Coordinate{10.8931, 48.3553}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augsburg Morellstraße station
    {Coordinate{-8.6405, 40.6435}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Aveiro railway station
    {Coordinate{8.95694, 49.9581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Babenhausen station
    {Coordinate{8.17056, 49.4608}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Dürkheim station
    {Coordinate{12.3016, 47.9051}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Endorf station
    {Coordinate{9.42611, 48.9425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Backnang station
    {Coordinate{8.43914, 48.8026}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800423
    {Coordinate{2.56611, 49.0036}, Tz::Europe_Paris, CountryId{"FR"}}, // Aéroport Charles de Gaulle 2 TGV
    {Coordinate{10.0797, 50.1917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Kissingen station
    {Coordinate{13.6273, 47.7122}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q800426
    {Coordinate{8.42016, 50.9291}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800427
    {Coordinate{7.86614, 49.8427}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Kreuznach station
    {Coordinate{7.84701, 49.8134}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münster am Stein station
    {Coordinate{8.80222, 52.1972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Oeynhausen Süd station
    {Coordinate{9.49298, 50.6272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Salzschlirf station
    {Coordinate{8.98, 50.4188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Salzhausen station
    {Coordinate{7.64978, 49.783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Sobernheim station
    {Coordinate{10.2295, 50.8149}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Salzungen station
    {Coordinate{14.1392, 50.9183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Schandau railway station
    {Coordinate{8.74, 50.1883}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Vilbel station
    {Coordinate{9.37222, 50.2808}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Soden-Salmünster station
    {Coordinate{8.30769, 47.4764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baden railway station
    {Coordinate{7.96794, 50.3469}, Tz::Europe_Berlin, CountryId{"DE"}}, // Balduinstein station
    {Coordinate{10.8994, 49.9008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bamberg station
    {Coordinate{2.18061, 41.3924}, Tz::Europe_Madrid, CountryId{"ES"}}, // Arc de Triomf station
    {Coordinate{2.17, 41.3869}, Tz::Europe_Madrid, CountryId{"ES"}}, // Plaça de Catalunya station
    {Coordinate{2.186, 41.384}, Tz::Europe_Madrid, CountryId{"ES"}}, // Barcelona Estació de França
    {Coordinate{2.14, 41.3789}, Tz::Europe_Madrid, CountryId{"ES"}}, // Barcelona Sants railway station
    {Coordinate{14.251, 52.1776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Beeskow station
    {Coordinate{8.82108, 50.3591}, Tz::Europe_Berlin, CountryId{"DE"}}, // Beienheim station
    {Coordinate{9.27306, 48.5725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bempflingen station
    {Coordinate{6.8975, 47.5858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belfort – Montbéliard TGV
    {Coordinate{11.0156, 51.4522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berga-Kelbra station
    {Coordinate{8.61333, 49.7019}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bensheim-Auerbach station
    {Coordinate{12.594, 47.8255}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bergen (Oberbayern) station
    {Coordinate{9.675, 45.6906}, Tz::Europe_Rome, CountryId{"IT"}}, // Bergamo railway station
    {Coordinate{13.4181, 54.4203}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bergen auf Rügen railway station
    {Coordinate{4.29611, 51.4944}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bergen op Zoom railway station
    {Coordinate{13.4435, 52.5915}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Blankenburg station
    {Coordinate{13.1283, 52.5494}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Albrechtshof station
    {Coordinate{13.341, 52.47}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Friedenau station
    {Coordinate{13.2902, 52.6325}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Frohnau station
    {Coordinate{13.5198, 52.5141}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Friedrichsfelde Ost station
    {Coordinate{13.6233, 52.4574}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Friedrichshagen station
    {Coordinate{13.2292, 52.6244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heiligensee station
    {Coordinate{13.2906, 52.4961}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Halensee station
    {Coordinate{13.5122, 52.5664}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Hohenschönhausen station
    {Coordinate{13.5904, 52.5121}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Kaulsdorf railway station
    {Coordinate{13.5808, 52.4586}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Köpenick station
    {Coordinate{13.4692, 52.615}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Karow station
    {Coordinate{13.3417, 52.4386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lankwitz station
    {Coordinate{13.3086, 52.41}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lichterfelde Süd station
    {Coordinate{13.2947, 52.4433}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Lichterfelde West station
    {Coordinate{13.6106, 52.5121}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mahlsdorf railway station
    {Coordinate{13.3747, 52.4242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marienfelde station
    {Coordinate{13.5411, 52.5436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Marzahn station
    {Coordinate{13.2462, 52.6128}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schulzendorf railway station
    {Coordinate{13.2271, 52.5103}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Pichelsberg railway station
    {Coordinate{13.6897, 52.4516}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Rahnsdorf station
    {Coordinate{13.3814, 52.5714}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Schönholz station
    {Coordinate{13.2089, 52.532}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Stresow railway station
    {Coordinate{13.321, 52.6064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Waidmannslust station
    {Coordinate{13.2894, 52.5886}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Tegel railway station
    {Coordinate{13.7222, 52.4386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Wilhelmshagen station
    {Coordinate{13.3631, 52.5814}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Wilhelmsruh station
    {Coordinate{13.3506, 52.5779}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Alt-Reinickendorf station
    {Coordinate{13.3609, 52.4478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Attilastraße station
    {Coordinate{13.3072, 52.448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Botanischer Garten station
    {Coordinate{13.3829, 52.4103}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buckower Chaussee station
    {Coordinate{13.3169, 52.5776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eichborndamm station
    {Coordinate{13.3328, 52.4636}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Feuerbachstraße station
    {Coordinate{13.2586, 52.5086}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Heerstraße station
    {Coordinate{13.3004, 52.4885}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Hohenzollerndamm station
    {Coordinate{13.2702, 52.4987}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Messe Süd railway station
    {Coordinate{13.4675, 52.4694}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köllnische Heide station
    {Coordinate{13.2416, 52.511}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Olympiastadion station
    {Coordinate{13.4547, 52.5294}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Landsberger Allee station
    {Coordinate{13.3563, 52.4601}, Tz::Europe_Berlin, CountryId{"DE"}}, // Priesterweg railway station
    {Coordinate{13.2153, 52.4401}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Schlachtensee station
    {Coordinate{13.3536, 52.4481}, Tz::Europe_Berlin, CountryId{"DE"}}, // Südende station
    {Coordinate{13.4644, 52.5238}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Storkower Straße station
    {Coordinate{13.2738, 52.4363}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Sundgauer Straße station
    {Coordinate{13.5533, 52.4689}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Wuhlheide station
    {Coordinate{13.3922, 52.5653}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Wollankstraße station
    {Coordinate{7.25417, 49.3456}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bexbach station
    {Coordinate{9.13639, 48.9975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Besigheim station
    {Coordinate{8.97443, 46.3518}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biasca railway station
    {Coordinate{8.72278, 47.1553}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biberbrugg railway station
    {Coordinate{8.60341, 49.7596}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bickenbach (Bergstr) station
    {Coordinate{10.7932, 47.4212}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Bichlbach-Berwang
    {Coordinate{8.45059, 49.689}, Tz::Europe_Berlin, CountryId{"DE"}}, // Biblis station
    {Coordinate{8.53056, 50.9089}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800527
    {Coordinate{10.6407, 47.8304}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800528
    {Coordinate{7.90531, 49.9698}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bingen (Rhein) Stadt station
    {Coordinate{-1.893, 52.4783}, Tz::Europe_London, CountryId{"GB"}}, // Birmingham Moor Street railway station
    {Coordinate{11.7147, 53.7719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankenberg (Meckl) railway station
    {Coordinate{9.81472, 47.155}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bludenz railway station
    {Coordinate{12.3346, 53.0763}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Blumenthal (Mark)
    {Coordinate{13.4158, 52.3376}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankenfelde station
    {Coordinate{6.62056, 51.8339}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bocholt railway station
    {Coordinate{8.3075, 52.3608}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bohmte railway station
    {Coordinate{7.0423, 50.7164}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800549
    {Coordinate{7.12742, 50.7384}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn-Beuel station
    {Coordinate{7.18161, 50.6692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn-Mehlem station
    {Coordinate{10.0437, 54.1744}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bordesholm station
    {Coordinate{7.15925, 50.715}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn-Oberkassel station
    {Coordinate{6.86556, 51.8486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Borken (Westf) station
    {Coordinate{11.3417, 44.5058}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna Centrale railway station
    {Coordinate{8.49806, 51.9964}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brackwede station
    {Coordinate{11.3584, 46.4966}, Tz::Europe_Rome, CountryId{"IT"}}, // Bolzano/Bozen railway station
    {Coordinate{4.78, 51.595}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Breda railway station
    {Coordinate{-0.555731, 44.8258}, Tz::Europe_Paris, CountryId{"FR"}}, // Bordeaux-Saint-Jean railway station
    {Coordinate{8.69306, 49.0369}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bretten station
    {Coordinate{8.5761, 51.3491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brilon Stadt station
    {Coordinate{8.5761, 51.3491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brilon-Wald station
    {Coordinate{11.88, 47.4347}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q800570
    {Coordinate{-0.1411, 50.8288}, Tz::Europe_London, CountryId{"GB"}}, // Brighton railway station
    {Coordinate{15.2791, 47.4135}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Bruck an der Mur
    {Coordinate{8.20909, 47.4808}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brugg railway station
    {Coordinate{3.21792, 51.1976}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brugge railway station
    {Coordinate{7.57116, 51.2083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brügge (Westfalen) station
    {Coordinate{4.37333, 50.8389}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-Luxembourg railway station
    {Coordinate{6.91235, 50.8292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brühl station
    {Coordinate{10.7164, 48.0339}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buchloe station
    {Coordinate{4.33583, 50.8353}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-South railway station
    {Coordinate{4.35722, 50.8456}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-Central railway station
    {Coordinate{4.38072, 50.8433}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-Schuman railway station
    {Coordinate{9.04749, 50.6906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burg- und Nieder-Gemünden station
    {Coordinate{8.66944, 50.4311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Butzbach station
    {Coordinate{8.865, 45.6161}, Tz::Europe_Rome, CountryId{"IT"}}, // Busto Arsizio railway station
    {Coordinate{10.6229, 53.4745}, Tz::Europe_Berlin, CountryId{"DE"}}, // Büchen railway station
    {Coordinate{6.75222, 48.9064}, Tz::Europe_Paris, CountryId{"FR"}}, // Q800601
    {Coordinate{17.9914, 53.1353}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Bydgoszcz Główna railway station
    {Coordinate{9.10021, 50.289}, Tz::Europe_Berlin, CountryId{"DE"}}, // Büdingen (Oberhess) station
    {Coordinate{6.6055, 51.1972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Büttgen station
    {Coordinate{14.0575, 37.4883}, Tz::Europe_Rome, CountryId{"IT"}}, // Caltanissetta Centrale railway station
    {Coordinate{1.81194, 50.9019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Calais-Fréthun
    {Coordinate{-0.0925, 51.5482}, Tz::Europe_London, CountryId{"GB"}}, // Canonbury railway station
    {Coordinate{-9.41844, 38.7008}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Cascais railway station
    {Coordinate{12.7988, 37.6837}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelvetrano train station
    {Coordinate{3.99389, 49.215}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Champagne-Ardenne TGV
    {Coordinate{2.45972, 49.1872}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chantilly-Gouvieux
    {Coordinate{12.3806, 50.0722}, Tz::Europe_Prague, CountryId{"CZ"}}, // Cheb station
    {Coordinate{12.9268, 50.8237}, Tz::Europe_Berlin, CountryId{"DE"}}, // Chemnitz Süd station
    {Coordinate{10.9581, 50.2631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coburg railway station
    {Coordinate{7.16444, 51.9394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coesfeld (Westf) station
    {Coordinate{-8.4407, 40.2252}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Coimbra B train station
    {Coordinate{10.0644, 49.1378}, Tz::Europe_Berlin, CountryId{"DE"}}, // Crailsheim station
    {Coordinate{12.9927, 50.5112}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cranzahl station
    {Coordinate{10.018, 45.1432}, Tz::Europe_Rome, CountryId{"IT"}}, // Cremona railway station
    {Coordinate{12.3928, 50.815}, Tz::Europe_Berlin, CountryId{"DE"}}, // Crimmitschau station
    {Coordinate{8.78764, 50.8483}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cölbe station
    {Coordinate{8.70303, 53.861}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cuxhaven railway station
    {Coordinate{6.1786, 51.1492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dalheim station
    {Coordinate{11.118, 53.105}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dannenberg Ost station
    {Coordinate{0.146381, 51.5261}, Tz::Europe_London, CountryId{"GB"}}, // Dagenham Dock railway station
    {Coordinate{8.67942, 49.9068}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800644
    {Coordinate{8.65389, 49.8922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Darmstadt Nord station
    {Coordinate{8.67361, 49.8747}, Tz::Europe_Berlin, CountryId{"DE"}}, // Darmstadt Ost station
    {Coordinate{8.63672, 49.8556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Darmstadt Süd station
    {Coordinate{-0.0747389, 51.5454}, Tz::Europe_London, CountryId{"GB"}}, // Dalston Junction railway station
    {Coordinate{13.0534, 53.9011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Demmin railway station
    {Coordinate{4.35667, 52.0067}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delft railway station
    {Coordinate{4.76083, 52.9564}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Helder railway station
    {Coordinate{4.34306, 52.0789}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Laan van NOI
    {Coordinate{4.32167, 52.0697}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Hollands Spoor
    {Coordinate{16.5644, 48.3031}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Deutsch Wagram
    {Coordinate{8.87252, 51.9408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Detmold station
    {Coordinate{8.84056, 49.9036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dieburg station
    {Coordinate{7.54262, 50.9852}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dieringhausen station
    {Coordinate{4.95639, 52.3303}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Diemen Zuid
    {Coordinate{8.405, 47.4061}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietikon railway station
    {Coordinate{11.0789, 48.8715}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800669
    {Coordinate{9.06694, 48.8236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ditzingen station
    {Coordinate{6.97028, 51.6586}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dorsten station
    {Coordinate{4.66774, 51.8075}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dordrecht railway station
    {Coordinate{7.415, 51.5336}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Huckarde Nord station
    {Coordinate{7.49972, 51.4878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Hörde station
    {Coordinate{7.44712, 51.4516}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Löttringhausen station
    {Coordinate{7.37474, 51.5703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Mengede station
    {Coordinate{7.53694, 51.5383}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Scharnhorst station
    {Coordinate{7.45758, 51.4907}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund Signal-Iduna-Park station
    {Coordinate{13.7042, 51.0556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden-Friedrichstadt station
    {Coordinate{8.66094, 50.0224}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dreieich-Buchschlag station
    {Coordinate{10.7269, 51.7706}, Tz::Europe_Berlin, CountryId{"DE"}}, // Drei Annen Hohne station
    {Coordinate{13.7408, 51.0656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden-Neustadt station
    {Coordinate{13.7886, 51.1144}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden-Klotzsche railway station
    {Coordinate{5.25944, 52.065}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Driebergen-Zeist railway station
    {Coordinate{6.75306, 51.4089}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Hochfeld Süd station
    {Coordinate{6.78083, 51.4686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Meiderich Süd railway station
    {Coordinate{13.7978, 53.7622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ducherow railway station
    {Coordinate{6.80361, 51.3992}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Wedau station
    {Coordinate{7.29472, 51.8272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dülmen station
    {Coordinate{8.59889, 50.5642}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dutenhofen station
    {Coordinate{-0.0923, 51.3752}, Tz::Europe_London, CountryId{"GB"}}, // East Croydon station
    {Coordinate{0.281, 50.769}, Tz::Europe_London, CountryId{"GB"}}, // Eastbourne railway station
    {Coordinate{6.78633, 51.2916}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Airport station
    {Coordinate{11.4546, 47.9789}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebenhausen-Schäftlarn station
    {Coordinate{0.320883, 51.443}, Tz::Europe_London, CountryId{"GB"}}, // Ebbsfleet International railway station
    {Coordinate{9.52694, 48.7161}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebersbach (Fils) station
    {Coordinate{9.83528, 54.4678}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eckernförde station
    {Coordinate{8.10056, 47.4764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q800707
    {Coordinate{9.9215, 51.3752}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eichenberg station
    {Coordinate{7.97028, 46.5747}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eigergletscher railway station
    {Coordinate{12.6367, 51.4517}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eilenburg station
    {Coordinate{8.74447, 47.1286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Einsiedeln railway station
    {Coordinate{12.6695, 51.4641}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Eilenburg Ost
    {Coordinate{10.3043, 50.9788}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eisenach West station
    {Coordinate{9.70417, 48.6967}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eislingen (Fils) station
    {Coordinate{10.8128, 51.6208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eisfelder Talmühle
    {Coordinate{10.1297, 48.9641}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ellwangen station
    {Coordinate{9.65897, 53.7548}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elmshorn station
    {Coordinate{8.12153, 50.0276}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eltville station
    {Coordinate{7.53119, 52.1773}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emsdetten station
    {Coordinate{12.4643, 51.3433}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Engelsdorf station
    {Coordinate{7.18611, 53.3442}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emden Außenhafen
    {Coordinate{13.3589, 48.474}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800728
    {Coordinate{6.89944, 52.7903}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Emmen railway station
    {Coordinate{7.5468, 50.4261}, Tz::Europe_Berlin, CountryId{"DE"}}, // Engers station
    {Coordinate{14.2863, 37.5808}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Enna
    {Coordinate{5.28778, 52.6994}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enkhuizen railway station
    {Coordinate{7.34361, 51.3044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ennepetal (Gevelsberg) station
    {Coordinate{8.38802, 50.1396}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eppstein station
    {Coordinate{6.32133, 51.0767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkelenz station
    {Coordinate{11.002, 49.596}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erlangen railway station
    {Coordinate{8.10491, 50.3936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eschhofen station
    {Coordinate{9.9963, 51.1927}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800739
    {Coordinate{10.0407, 51.1917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Eschwege
    {Coordinate{-9.39875, 38.7033}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Estoril railway station
    {Coordinate{7.00684, 51.4843}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Altenessen station
    {Coordinate{12.3603, 50.4788}, Tz::Europe_Berlin, CountryId{"DE"}}, // Falkenstein (Vogtl) Station
    {Coordinate{6.79111, 50.6578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Euskirchen station
    {Coordinate{4.6375, 51.5753}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Etten-Leur railway station
    {Coordinate{11.29, 47.9467}, Tz::Europe_Berlin, CountryId{"DE"}}, // Feldafing station
    {Coordinate{12.5233, 55.6817}, Tz::Europe_Copenhagen, CountryId{"DK"}}, // Fasanvej Station
    {Coordinate{9.21833, 48.6764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Filderstadt station
    {Coordinate{-8.84786, 40.1485}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Figueira da Foz train station
    {Coordinate{11.2763, 43.7776}, Tz::Europe_Rome, CountryId{"IT"}}, // Firenze Campo di Marte railway station
    {Coordinate{9.57648, 50.4216}, Tz::Europe_Berlin, CountryId{"DE"}}, // Flieden station
    {Coordinate{8.62444, 46.9017}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flüelen railway station
    {Coordinate{13.5033, 52.3667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Brandenburg Airport railway station
    {Coordinate{8.78944, 51.0544}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800760
    {Coordinate{8.6772, 50.1701}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Frankfurter Berg station
    {Coordinate{8.60611, 50.0942}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Griesheim station
    {Coordinate{8.52818, 50.0984}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Höchst Farbwerke station
    {Coordinate{8.67034, 50.0832}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Louisa station
    {Coordinate{8.76722, 50.1342}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Mainkur station
    {Coordinate{8.56998, 50.1028}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Nied station
    {Coordinate{8.60726, 50.1244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Rödelheim station
    {Coordinate{8.51228, 50.0875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Sindlingen station
    {Coordinate{8.50667, 50.0903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Zeilsheim station
    {Coordinate{8.5425, 50.1025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Höchst station
    {Coordinate{8.89654, 47.5582}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frauenfeld railway station
    {Coordinate{8.2046, 49.5024}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freinsheim station
    {Coordinate{9.1975, 48.9297}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freiberg (Neckar) station
    {Coordinate{13.3446, 50.9088}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freiberg (Sachs) station
    {Coordinate{12.9773, 47.8372}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freilassing station
    {Coordinate{11.7443, 48.3952}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freising station
    {Coordinate{16.0527, 47.4343}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Friedberg
    {Coordinate{8.53056, 50.9089}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800787
    {Coordinate{10.3411, 53.5279}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichsruh railway station
    {Coordinate{8.64433, 50.2522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichsdorf station
    {Coordinate{9.48303, 47.6506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichshafen Hafen station
    {Coordinate{7.08887, 49.3199}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichsthal (Saar) station
    {Coordinate{10.2621, 50.9389}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltepunkt Förtha
    {Coordinate{14.0597, 52.3666}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fürstenwalde (Spree)
    {Coordinate{8.78149, 49.649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800798
    {Coordinate{10.6978, 47.5703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Füssen station
    {Coordinate{9.75389, 49.0033}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800801
    {Coordinate{15.6553, 48.5975}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q800803
    {Coordinate{11.097, 47.4915}, Tz::Europe_Berlin, CountryId{"DE"}}, // Garmisch-Partenkirchen station
    {Coordinate{6.12417, 50.9611}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geilenkirchen station
    {Coordinate{7.08901, 51.4925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelsenkirchen-Rotthausen station
    {Coordinate{9.18945, 50.1966}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelnhausen station
    {Coordinate{13.2576, 52.3279}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800811
    {Coordinate{8.36667, 49.2167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Germersheim station
    {Coordinate{3.71056, 51.0356}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gent-Sint-Pieters railway station
    {Coordinate{10.0654, 50.9649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gerstungen station
    {Coordinate{8.92056, 44.4167}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Piazza Principe railway station
    {Coordinate{8.99602, 50.3138}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800817
    {Coordinate{9.01028, 50.3271}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glauburg-Stockheim station
    {Coordinate{6.14306, 46.2106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Genève-Cornavin railway station
    {Coordinate{15.9467, 47.6777}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Gloggnitz
    {Coordinate{12.5488, 50.8289}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glauchau (Sachs)
    {Coordinate{-4.2512, 55.8622}, Tz::Europe_London, CountryId{"GB"}}, // Glasgow Queen Street railway station
    {Coordinate{11.7355, 47.7499}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800824
    {Coordinate{13.7828, 47.9253}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q800826
    {Coordinate{10.1283, 48.8944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Goldshöfe station
    {Coordinate{-0.1514, 51.5552}, Tz::Europe_London, CountryId{"GB"}}, // Gospel Oak railway station
    {Coordinate{10.7139, 50.9392}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gotha station
    {Coordinate{11.5641, 53.2826}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grabow (Meckl) railway station
    {Coordinate{14.1644, 50.9408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Goßdorf-Kohlmühle railway station
    {Coordinate{4.70556, 52.0175}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gouda railway station
    {Coordinate{12.194, 50.6525}, Tz::Europe_Berlin, CountryId{"DE"}}, // Greiz station
    {Coordinate{13.3706, 54.0928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Greifswald railway station
    {Coordinate{7.39836, 47.1887}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grenchen Süd
    {Coordinate{6.58056, 51.0931}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grevenbroich station
    {Coordinate{7.02194, 52.215}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gronau (Westf) railway station
    {Coordinate{8.75364, 50.2319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Karben station
    {Coordinate{8.48625, 49.9249}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Gerau station
    {Coordinate{13.2844, 52.3506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großbeeren railway station
    {Coordinate{8.16773, 49.5642}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grünstadt station
    {Coordinate{8.45837, 50.3823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grävenwiesbach station
    {Coordinate{8.96016, 50.5966}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grünberg station
    {Coordinate{7.01085, 51.2146}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gruiten station
    {Coordinate{7.56704, 51.0233}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gummersbach station
    {Coordinate{14.7068, 51.9586}, Tz::Europe_Berlin, CountryId{"DE"}}, // Guben station
    {Coordinate{10.2786, 48.4602}, Tz::Europe_Berlin, CountryId{"DE"}}, // Günzburg station
    {Coordinate{7.423, 51.3836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen-Vorhalle station
    {Coordinate{11.2153, 53.4134}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagenow Land railway station
    {Coordinate{4.63889, 52.3878}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Haarlem railway station
    {Coordinate{14.9606, 51.0708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800864
    {Coordinate{7.57167, 51.3489}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohenlimburg station
    {Coordinate{8.22111, 50.7414}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haiger station
    {Coordinate{10.0447, 53.5869}, Tz::Europe_Berlin, CountryId{"DE"}}, // Barmbek station
    {Coordinate{9.81385, 53.564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankenese station
    {Coordinate{10.0236, 53.5464}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hammerbrook station
    {Coordinate{9.93083, 53.5794}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenfelde station
    {Coordinate{10.0314, 53.6203}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ohlsdorf
    {Coordinate{10.0772, 53.5699}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Wandsbek station
    {Coordinate{10.0069, 53.4989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wilhelmsburg station
    {Coordinate{9.95, 53.5614}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holstenstrasse station
    {Coordinate{10.0597, 53.5702}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg Wandsbeker Chaussee station
    {Coordinate{8.93278, 50.0983}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800883
    {Coordinate{8.8836, 50.1439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hanau-Wilhelmsbad station
    {Coordinate{9.67713, 52.3964}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Leinhausen station
    {Coordinate{5.425, 53.17}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Harlingen railway station
    {Coordinate{7.95339, 52.2418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hasbergen
    {Coordinate{10.0558, 53.5647}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hasselbrook station
    {Coordinate{8.4893, 50.0677}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattersheim am Main station
    {Coordinate{4.60722, 52.3597}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heemstede-Aerdenhout
    {Coordinate{5.91556, 52.9603}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerenveen railway station
    {Coordinate{4.82361, 52.67}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerhugowaard railway station
    {Coordinate{5.97472, 50.8908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerlen railway station
    {Coordinate{9.10098, 54.193}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heide station
    {Coordinate{8.72, 49.4147}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidelberg-Altstadt station
    {Coordinate{6.09956, 51.0647}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heinsberg (Rheinland) station
    {Coordinate{13.2057, 52.638}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hennigsdorf station
    {Coordinate{6.79417, 52.2619}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hengelo railway station
    {Coordinate{8.3077, 50.6844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herborn station
    {Coordinate{11.8583, 50.9036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hermsdorf-Klosterlausnitz station
    {Coordinate{6.97423, 51.6717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Hervest-Dorsten
    {Coordinate{13.1288, 50.8401}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hetzdorf (Flöhatal) railway station
    {Coordinate{6.09464, 50.8708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzogenrath station
    {Coordinate{9.96296, 52.1458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hildesheim Ost station
    {Coordinate{8.5372, 49.3174}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hockenheim station
    {Coordinate{11.9046, 50.3214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800925
    {Coordinate{8.44439, 50.0844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hofheim (Taunus) station
    {Coordinate{12.707, 50.7988}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohenstein-Ernstthal station
    {Coordinate{4.7, 52.2933}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoofddorp railway station
    {Coordinate{14.025, 51.455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hosena station
    {Coordinate{6.71368, 50.9161}, Tz::Europe_Berlin, CountryId{"DE"}}, // Horrem station
    {Coordinate{8.89264, 50.478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hungen station
    {Coordinate{5.05472, 52.645}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoorn railway station
    {Coordinate{5.16778, 52.0342}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Houten railway station
    {Coordinate{7.6565, 52.2997}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ibbenbüren-Esch station
    {Coordinate{7.78139, 52.2649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ibbenbüren-Laggenbeck station
    {Coordinate{9.02556, 48.815}, Tz::Europe_Berlin, CountryId{"DE"}}, // Höfingen station
    {Coordinate{25.1667, 55.3412}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Ignalina train station
    {Coordinate{7.32111, 49.6994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Idar-Oberstein station
    {Coordinate{8.92056, 48.9564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800944
    {Coordinate{9.20771, 46.7753}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ilanz
    {Coordinate{10.9222, 50.6842}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ilmenau station
    {Coordinate{8.4627, 47.0918}, Tz::Europe_Zurich, CountryId{"CH"}}, // Immensee station
    {Coordinate{10.9089, 50.6814}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Ilmenau Bad
    {Coordinate{10.2806, 50.7933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800952
    {Coordinate{-0.182811, 51.4752}, Tz::Europe_London, CountryId{"GB"}}, // Imperial Wharf railway station
    {Coordinate{7.69222, 51.3732}, Tz::Europe_Berlin, CountryId{"DE"}}, // Iserlohn station
    {Coordinate{8.20775, 46.2062}, Tz::Europe_Rome, CountryId{"IT"}}, // Iselle di Trasquera railway station
    {Coordinate{11.6792, 48.2258}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ismaning station
    {Coordinate{-4.223, 57.48}, Tz::Europe_London, CountryId{"GB"}}, // Inverness railway station
    {Coordinate{9.51062, 53.924}, Tz::Europe_Berlin, CountryId{"DE"}}, // Itzehoe station
    {Coordinate{13.9386, 53.6022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jatznick railway station
    {Coordinate{14.5703, 50.8427}, Tz::Europe_Prague, CountryId{"CZ"}}, // Jedlová railway station
    {Coordinate{6.36806, 50.9183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q800970
    {Coordinate{28.9772, 41.015}, Tz::Europe_Istanbul, CountryId{"TR"}}, // Sirkeci railway station
    {Coordinate{24.4622, 54.8633}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Q800976
    {Coordinate{20.4983, 54.6944}, Tz::Europe_Kaliningrad, CountryId{"RU"}}, // Kaliningrad Railway station
    {Coordinate{3.95694, 51.4806}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kapelle-Biezelinge railway station
    {Coordinate{12.2722, 53.5403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karow (Meckl) railway station
    {Coordinate{10.8546, 48.0808}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kaufering station
    {Coordinate{19.0175, 50.2583}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Katowice railway station
    {Coordinate{23.9314, 54.8864}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Kaunas Railway Station
    {Coordinate{8.52946, 50.0625}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kelsterbach station
    {Coordinate{19.0217, 47.465}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kelenföld railway station
    {Coordinate{8.35428, 47.4333}, Tz::Europe_Zurich, CountryId{"CH"}}, // Killwangen-Spreitenbach railway station
    {Coordinate{6.88814, 50.8379}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kierberg station
    {Coordinate{11.3775, 48.9917}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kinding (Altmühltal) station
    {Coordinate{8.92149, 50.8239}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchhain (Bz Kassel) station
    {Coordinate{8.8471, 52.9836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchweyhe railway station
    {Coordinate{9.15056, 49.0375}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchheim (Neckar) station
    {Coordinate{7.22644, 49.2862}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirkel station
    {Coordinate{12.4618, 50.357}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801018
    {Coordinate{6.55222, 51.1955}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kleinenbroich station
    {Coordinate{7.61028, 50.3619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koblenz-Ehrenbreitstein station
    {Coordinate{7.5916, 50.3677}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koblenz-Lützel station
    {Coordinate{8.22706, 47.6003}, Tz::Europe_Zurich, CountryId{"CH"}}, // Koblenz railway station
    {Coordinate{8.87312, 51.2784}, Tz::Europe_Berlin, CountryId{"DE"}}, // Korbach station
    {Coordinate{9.12111, 48.8261}, Tz::Europe_Berlin, CountryId{"DE"}}, // Korntal station
    {Coordinate{11.9311, 50.8781}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801033
    {Coordinate{15.605, 48.4094}, Tz::Europe_Vienna, CountryId{"AT"}}, // Krems an der Donau train station
    {Coordinate{9.16889, 47.6522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kreuzlingen station
    {Coordinate{4.11694, 51.4336}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Krabbendijke railway station
    {Coordinate{7.99194, 50.9561}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kreuztal station
    {Coordinate{4.03722, 51.4653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kruiningen-Yerseke railway station
    {Coordinate{12.1658, 47.5831}, Tz::Europe_Vienna, CountryId{"AT"}}, // Kufstein railway station
    {Coordinate{21.2239, 48.8528}, Tz::Europe_Bratislava, CountryId{"SK"}}, // Kysak railway station
    {Coordinate{6.93393, 50.9436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln West station
    {Coordinate{7.19312, 50.6788}, Tz::Europe_Berlin, CountryId{"DE"}}, // Königswinter station
    {Coordinate{6.93777, 50.9275}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Süd station
    {Coordinate{8.43349, 47.0836}, Tz::Europe_Zurich, CountryId{"CH"}}, // Küssnacht am Rigi station
    {Coordinate{12.387, 53.7551}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lalendorf station
    {Coordinate{12.6951, 48.6829}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801055
    {Coordinate{10.5785, 47.1485}, Tz::Europe_Vienna, CountryId{"AT"}}, // Landeck-Zams railway station
    {Coordinate{25.6575, 60.9769}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Lahti railway station
    {Coordinate{10.8717, 48.0473}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof (Landsberg am Lech)
    {Coordinate{8.65691, 49.9935}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langen (Hess) station
    {Coordinate{13.8167, 51.5}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801063
    {Coordinate{9.4077, 50.6436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauterbach (Hess) Nord station
    {Coordinate{11.1603, 50.4731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Lauscha
    {Coordinate{9.70951, 49.5654}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauda station
    {Coordinate{8.18276, 48.9676}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lauterbourg
    {Coordinate{9.97444, 52.3767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lehrte station
    {Coordinate{15.5472, 46.7808}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Leibnitz
    {Coordinate{16.1684, 51.2133}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Legnica
    {Coordinate{4.49972, 46.7653}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Creusot TGV
    {Coordinate{4.4925, 52.1469}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leiden Lammenschans railway station
    {Coordinate{12.3214, 51.3264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Plagwitz railway station
    {Coordinate{12.3133, 51.3563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Leutzsch railway station
    {Coordinate{4.48222, 52.1664}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leiden Centraal railway station
    {Coordinate{12.4115, 51.3244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Stötteritz railway station
    {Coordinate{12.3217, 51.3807}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Wahren station
    {Coordinate{12.3755, 50.5714}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801078
    {Coordinate{7.87808, 52.1757}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lengerich railway station
    {Coordinate{8.16944, 47.3914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lenzburg railway station
    {Coordinate{7.18694, 51.8925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lette (Kr Coesfeld) station
    {Coordinate{8.36691, 50.5399}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leun/Braunfels station
    {Coordinate{5.47278, 52.5078}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lelystad Centrum railway station
    {Coordinate{9.00278, 48.7994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leonberg station
    {Coordinate{10.0164, 47.8264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leutkirch station
    {Coordinate{8.8222, 50.5146}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801087
    {Coordinate{4.71611, 50.8808}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leuven railway station
    {Coordinate{12.7714, 46.8283}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q801093
    {Coordinate{6.20806, 50.9971}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindern station
    {Coordinate{3.07083, 50.6364}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lille Flandres
    {Coordinate{3.07528, 50.6394}, Tz::Europe_Paris, CountryId{"FR"}}, // Lille-Europe railway station
    {Coordinate{14.2797, 48.3117}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q801101
    {Coordinate{8.34878, 51.6707}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lippstadt station
    {Coordinate{-9.19804, 38.6961}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Belém train station
    {Coordinate{-9.16821, 38.7325}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q801108
    {Coordinate{-9.14856, 38.7446}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q801109
    {Coordinate{-9.11889, 38.7391}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Chelas
    {Coordinate{-9.16667, 38.7403}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q801112
    {Coordinate{8.70111, 50.6478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Lollar
    {Coordinate{5.56697, 50.6247}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liège-Guillemins railway station
    {Coordinate{9.69555, 48.7979}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801119
    {Coordinate{8.65639, 53.4731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Loxstedt station
    {Coordinate{6.16972, 48.9475}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lorraine TGV
    {Coordinate{15.2934, 51.1115}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q801122
    {Coordinate{13.6083, 51.8514}, Tz::Europe_Berlin, CountryId{"DE"}}, // Luckau-Uckro railway station
    {Coordinate{9.18528, 48.8922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigsburg station
    {Coordinate{8.38152, 49.4931}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Ludwigshafen-Oggersheim
    {Coordinate{11.4931, 53.3353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigslust railway station
    {Coordinate{6.90389, 49.2494}, Tz::Europe_Berlin, CountryId{"DE"}}, // Luisenthal
    {Coordinate{12.6622, 51.8676}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lutherstadt Wittenberg railway station
    {Coordinate{8.33722, 47.0539}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q801133
    {Coordinate{14.6711, 51.0994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löbau (Sachs) railway station
    {Coordinate{10.8761, 53.965}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-Travemünde Strand station
    {Coordinate{6.13389, 49.6}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Luxembourg railway station
    {Coordinate{13.8775, 51.9397}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübben (Spreewald) station
    {Coordinate{7.6289, 51.2205}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüdenscheid station
    {Coordinate{5.07611, 45.7211}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon Saint-Exupéry
    {Coordinate{10.4199, 53.2499}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüneburg station
    {Coordinate{11.6692, 52.0704}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801147
    {Coordinate{-3.69201, 40.3992}, Tz::Europe_Madrid, CountryId{"ES"}}, // Delicias Railway Station
    {Coordinate{9.5292, 47.0038}, Tz::Europe_Zurich, CountryId{"CH"}}, // Maienfeld railway station
    {Coordinate{8.31404, 49.9944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz-Gustavsburg station
    {Coordinate{8.36257, 49.9903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz-Bischofsheim station
    {Coordinate{8.83505, 50.1421}, Tz::Europe_Berlin, CountryId{"DE"}}, // Maintal Ost station
    {Coordinate{8.90444, 48.7717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Malmsheim station
    {Coordinate{9.26444, 48.9436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marbach (Neckar) station
    {Coordinate{8.03881, 49.6229}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801162
    {Coordinate{6.57444, 52.5089}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Mariënberg railway station
    {Coordinate{12.4575, 50.8509}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meerane railway station
    {Coordinate{2.78278, 48.8697}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marne-la-Vallée – Chessy
    {Coordinate{12.8889, 50.7232}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801168
    {Coordinate{13.4825, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meissen station
    {Coordinate{2.26167, 48.7261}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Massy TGV
    {Coordinate{10.1867, 47.9858}, Tz::Europe_Berlin, CountryId{"DE"}}, // Memmingen station
    {Coordinate{7.29083, 50.3694}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mendig station
    {Coordinate{7.79242, 51.4356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Menden (Sauerland) station
    {Coordinate{8.74597, 49.9217}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801175
    {Coordinate{9.29, 48.5389}, Tz::Europe_Berlin, CountryId{"DE"}}, // Metzingen (Württemberg) station
    {Coordinate{6.11028, 49.7525}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Mersch railway station
    {Coordinate{6.1775, 49.1098}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Metz-Ville
    {Coordinate{5.27167, 48.9783}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meuse TGV
    {Coordinate{3.61815, 51.4953}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Middelburg railway station
    {Coordinate{9.21419, 45.5129}, Tz::Europe_Rome, CountryId{"IT"}}, // Milano Greco Pirelli railway station
    {Coordinate{9.23694, 45.485}, Tz::Europe_Rome, CountryId{"IT"}}, // Milano Lambrate railway station
    {Coordinate{9.24847, 49.7065}, Tz::Europe_Berlin, CountryId{"DE"}}, // Miltenberg station
    {Coordinate{9.1876, 45.4846}, Tz::Europe_Rome, CountryId{"IT"}}, // Milano Porta Garibaldi railway station
    {Coordinate{9.23917, 45.4336}, Tz::Europe_Rome, CountryId{"IT"}}, // Milano Rogoredo railway station
    {Coordinate{10.5017, 48.0449}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mindelheim station
    {Coordinate{6.64162, 51.451}, Tz::Europe_Berlin, CountryId{"DE"}}, // Moers station
    {Coordinate{8.20839, 49.6337}, Tz::Europe_Berlin, CountryId{"DE"}}, // Monsheim station
    {Coordinate{9.20361, 45.4861}, Tz::Europe_Rome, CountryId{"IT"}}, // Milano Centrale railway station
    {Coordinate{-0.396111, 45.2806}, Tz::Europe_Paris, CountryId{"FR"}}, // Montendre
    {Coordinate{7.41987, 43.7382}, Tz::Europe_Monaco, CountryId{"MC"}}, // Monaco-Monte Carlo railway station
    {Coordinate{3.88104, 43.6046}, Tz::Europe_Paris, CountryId{"FR"}}, // Montpellier-Saint-Roch railway station
    {Coordinate{9.27306, 45.5778}, Tz::Europe_Rome, CountryId{"IT"}}, // Monza railway station
    {Coordinate{12.4812, 50.7836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mosel station
    {Coordinate{13.4152, 50.8087}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Mulda (Sachs)
    {Coordinate{12.3973, 50.4252}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801203
    {Coordinate{7.3433, 47.7426}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mulhouse
    {Coordinate{10.6831, 53.6242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mölln (Lauenburg) station
    {Coordinate{11.6337, 48.1342}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Berg am Laim station
    {Coordinate{8.70333, 49.8319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801212
    {Coordinate{10.4752, 51.2087}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühlhausen (Thür) station
    {Coordinate{-4.43194, 36.7117}, Tz::Europe_Madrid, CountryId{"ES"}}, // Málaga-María Zambrano Railway Station
    {Coordinate{11.5964, 48.1103}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Giesing station
    {Coordinate{11.5414, 48.2136}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Feldmoching station
    {Coordinate{11.5033, 48.1444}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Laim station
    {Coordinate{11.6786, 48.1442}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Riem station
    {Coordinate{11.535, 48.1428}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Donnersbergerbrücke station
    {Coordinate{11.6625, 48.1258}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Trudering station
    {Coordinate{11.5819, 48.135}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Isartor station
    {Coordinate{11.5486, 48.1419}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Hackerbrücke station
    {Coordinate{11.5939, 48.1286}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Rosenheimer Platz station
    {Coordinate{15.6771, 47.6076}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q801226
    {Coordinate{7.6546, 51.9047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Münster-Hiltrup station
    {Coordinate{11.6047, 48.1269}, Tz::Europe_Berlin, CountryId{"DE"}}, // München Ost station
    {Coordinate{6.95306, 51.2278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neanderthal station
    {Coordinate{8.94264, 49.3071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801235
    {Coordinate{10.0054, 48.3933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu-Ulm station
    {Coordinate{14.2721, 40.8523}, Tz::Europe_Rome, CountryId{"IT"}}, // Napoli Centrale railway station
    {Coordinate{10.9103, 50.9139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neudietendorf station
    {Coordinate{11.6358, 50.8756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801239
    {Coordinate{11.6611, 48.3214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neufahrn bei Freising station
    {Coordinate{14.3216, 51.0908}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801242
    {Coordinate{12.7269, 50.7194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801244
    {Coordinate{8.21088, 47.9102}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt (Schwarzwald) station
    {Coordinate{7.47349, 50.4312}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuwied station
    {Coordinate{8.8799, 50.2313}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nidderau station
    {Coordinate{8.99904, 50.4112}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nidda station
    {Coordinate{13.5606, 51.1764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederau station
    {Coordinate{7.18111, 50.6953}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederdollendorf station
    {Coordinate{8.70833, 50.7364}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederwalgern station
    {Coordinate{8.54756, 50.1539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederhöchstadt station
    {Coordinate{5.8525, 51.8433}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen railway station
    {Coordinate{9.99222, 53.7078}, Tz::Europe_Berlin, CountryId{"DE"}}, // Norderstedt Mitte
    {Coordinate{10.7892, 51.4933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nordhausen station
    {Coordinate{9.79, 52.1671}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nordstemmen station
    {Coordinate{9.98694, 51.7033}, Tz::Europe_Berlin, CountryId{"DE"}}, // Northeim (Han) station
    {Coordinate{9.93338, 51.6284}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nörten-Hardenberg station
    {Coordinate{9.3425, 48.6281}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürtingen station
    {Coordinate{6.81, 51.5347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberhausen-Holten station
    {Coordinate{10.7097, 50.6842}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801275
    {Coordinate{6.88444, 51.4997}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberhausen-Osterfeld Süd station
    {Coordinate{11.932, 50.2668}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Oberkotzau
    {Coordinate{6.84361, 51.5117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberhausen-Sterkrade station
    {Coordinate{11.5575, 48.2569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Train station Oberschleißheim
    {Coordinate{11.3542, 50.9664}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801281
    {Coordinate{8.76083, 47.5078}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberwinterthur railway station
    {Coordinate{10.0717, 49.663}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ochsenfurt station
    {Coordinate{7.73852, 50.1017}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberwesel station
    {Coordinate{12.1589, 50.4132}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801286
    {Coordinate{-9.31906, 38.6885}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Oeiras railway station
    {Coordinate{10.9839, 52.4392}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oebisfelde railway station
    {Coordinate{20.5075, 53.7875}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q801295
    {Coordinate{8.35776, 49.8575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Oppenheim
    {Coordinate{7.80933, 52.0698}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ostbevern station
    {Coordinate{5.5325, 51.7656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oss railway station
    {Coordinate{13.5999, 54.405}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ostseebad Binz railway station
    {Coordinate{9.3062, 51.7109}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ottbergen station
    {Coordinate{17.9267, 50.6623}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Opole Główne railway station
    {Coordinate{7.16608, 49.4024}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ottweiler (Saar) station
    {Coordinate{14.101, 53.1488}, Tz::Europe_Berlin, CountryId{"DE"}}, // Passow
    {Coordinate{13.9889, 53.515}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pasewalk railway station
    {Coordinate{15.8645, 47.6959}, Tz::Europe_Vienna, CountryId{"AT"}}, // Payerbach-Reichenau station
    {Coordinate{8.27913, 49.6347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801314
    {Coordinate{13.3669, 38.11}, Tz::Europe_Rome, CountryId{"IT"}}, // Palermo Centrale railway station
    {Coordinate{24.9336, 60.1986}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pasila railway station
    {Coordinate{9.79761, 53.6553}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pinneberg station
    {Coordinate{7.60444, 49.2583}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pirmasens Nord station
    {Coordinate{-8.91314, 38.6301}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Pinhal Novo railway station
    {Coordinate{10.9086, 50.7783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plaue station
    {Coordinate{12.8636, 48.7801}, Tz::Europe_Berlin, CountryId{"DE"}}, // Plattling station
    {Coordinate{20.2964, 49.0597}, Tz::Europe_Bratislava, CountryId{"SK"}}, // Poprad-Tatry railway station
    {Coordinate{8.92085, 52.2435}, Tz::Europe_Berlin, CountryId{"DE"}}, // Porta Westfalica railway station
    {Coordinate{13.0139, 52.3944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Park Sanssouci railway station
    {Coordinate{13.0928, 52.3914}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam-Babelsberg station
    {Coordinate{13.1217, 52.3819}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Medienstadt Babelsberg station
    {Coordinate{-8.5854, 41.1488}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Campanhã railway station
    {Coordinate{13.0111, 52.3728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Pirschheide station
    {Coordinate{-9.17992, 38.666}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Pragal railway station
    {Coordinate{14.4089, 50.0614}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha-Smíchov railway station
    {Coordinate{12.3466, 47.8555}, Tz::Europe_Berlin, CountryId{"DE"}}, // Prien am Chiemsee station
    {Coordinate{13.5085, 51.2507}, Tz::Europe_Berlin, CountryId{"DE"}}, // Priestewitz station
    {Coordinate{11.5219, 48.0587}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pullach station
    {Coordinate{11.3838, 50.5281}, Tz::Europe_Berlin, CountryId{"DE"}}, // Probstzella station
    {Coordinate{7.94836, 52.674}, Tz::Europe_Berlin, CountryId{"DE"}}, // Quakenbrück
    {Coordinate{13.6797, 51.0986}, Tz::Europe_Berlin, CountryId{"DE"}}, // Radebeul Ost station
    {Coordinate{13.6286, 51.1078}, Tz::Europe_Berlin, CountryId{"DE"}}, // Radebeul-Kötzschenbroda station
    {Coordinate{5.87778, 49.5539}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Pétange railway station
    {Coordinate{8.62389, 52.4331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rahden (Kreis Minden-Lübbecke) station
    {Coordinate{8.21556, 48.8606}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rastatt station
    {Coordinate{13.4303, 52.2944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rangsdorf railway station
    {Coordinate{8.4551, 50.0101}, Tz::Europe_Berlin, CountryId{"DE"}}, // Raunheim station
    {Coordinate{6.86355, 51.2951}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ratingen Ost station
    {Coordinate{12.2079, 44.4191}, Tz::Europe_Rome, CountryId{"IT"}}, // Ravenna railway station
    {Coordinate{-9.223, 38.751}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q801351
    {Coordinate{12.0491, 49.0118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Regensburg-Prüfening station
    {Coordinate{8.83537, 49.8298}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reinheim railway station
    {Coordinate{9.67083, 54.3025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rendsburg station
    {Coordinate{4.02417, 49.2592}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Reims
    {Coordinate{8.93222, 48.775}, Tz::Europe_Berlin, CountryId{"DE"}}, // Renningen station
    {Coordinate{10.8356, 50.6153}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801358
    {Coordinate{6.70667, 51.3936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinhausen station
    {Coordinate{8.28833, 51.8572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheda-Wiedenbrück station
    {Coordinate{13.2872, 51.3094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Riesa railway station
    {Coordinate{12.574, 44.0639}, Tz::Europe_Rome, CountryId{"IT"}}, // Rimini railway station
    {Coordinate{9.06667, 52.1989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rinteln station
    {Coordinate{7.15708, 49.2769}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rohrbach Station
    {Coordinate{12.4847, 41.8728}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Ostiense railway station
    {Coordinate{8.70122, 50.298}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rosbach vor der Höhe station
    {Coordinate{12.4664, 41.8722}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Trastevere railway station
    {Coordinate{15.6425, 48.6286}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q801375
    {Coordinate{12.5308, 41.9103}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Tiburtina railway station
    {Coordinate{4.45875, 51.5397}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Roosendaal railway station
    {Coordinate{8.43047, 47.1418}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rotkreuz station
    {Coordinate{9.39, 53.1122}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rotenburg railway station
    {Coordinate{13.8661, 51.4531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ruhland station
    {Coordinate{4.55278, 51.9519}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Alexander railway station
    {Coordinate{14.5481, 50.9567}, Tz::Europe_Prague, CountryId{"CZ"}}, // Rumburk (train station)
    {Coordinate{19.3092, 49.0831}, Tz::Europe_Bratislava, CountryId{"SK"}}, // Ružomberok
    {Coordinate{14.8142, 52.3497}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Rzepin
    {Coordinate{13.5136, 52.6487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Röntgental station
    {Coordinate{7.91561, 49.9771}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rüdesheim (Rhein) station
    {Coordinate{4.46944, 51.925}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Centraal railway station
    {Coordinate{9.06333, 48.9614}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801390
    {Coordinate{11.1617, 52.8581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzwedel station
    {Coordinate{10.3144, 52.0381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Ringelheim station
    {Coordinate{8.34222, 48.1239}, Tz::Europe_Berlin, CountryId{"DE"}}, // St. Georgen station
    {Coordinate{8.76933, 50.8726}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801398
    {Coordinate{7.06859, 49.1072}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sarreguemines
    {Coordinate{7.53275, 51.2406}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schalksmühle station
    {Coordinate{9.50833, 47.1686}, Tz::Europe_Vaduz, CountryId{"LI"}}, // Schaan-Vaduz railway station
    {Coordinate{4.41, 51.9219}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schiedam Centrum railway station
    {Coordinate{10.6777, 51.7651}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schierke station
    {Coordinate{8.36444, 49.3919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schifferstadt station
    {Coordinate{11.8604, 47.7353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801409
    {Coordinate{4.76167, 52.3089}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schiphol railway station
    {Coordinate{9.50967, 50.3411}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schlüchtern station
    {Coordinate{10.4378, 50.7201}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801412
    {Coordinate{10.8931, 52.8669}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schnega
    {Coordinate{12.7839, 50.5454}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Schwarzenberg (Erzgeb)
    {Coordinate{10.6901, 53.428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwanheide railway station
    {Coordinate{4.37968, 50.8781}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schaarbeek railway station
    {Coordinate{8.5356, 48.06}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwenningen
    {Coordinate{12.9956, 52.2958}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seddin station
    {Coordinate{13.3397, 52.6648}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schönfließ railway station
    {Coordinate{14.17, 53.9492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seebad Heringsdorf railway station
    {Coordinate{14.0036, 51.5267}, Tz::Europe_Berlin, CountryId{"DE"}}, // Senftenberg station
    {Coordinate{-0.217561, 51.5051}, Tz::Europe_London, CountryId{"GB"}}, // Shepherd's Bush railway station
    {Coordinate{-5.97489, 37.3922}, Tz::Europe_Madrid, CountryId{"ES"}}, // Seville-Santa Justa railway station
    {Coordinate{11.3416, 49.5983}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Simmelsdorf-Hüttenbach
    {Coordinate{5.85833, 51.0014}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sittard railway station
    {Coordinate{-9.39, 38.8}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Sintra train station
    {Coordinate{11.3489, 55.4073}, Tz::Europe_Copenhagen, CountryId{"DK"}}, // Q801448
    {Coordinate{8.74015, 48.069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Spaichingen station
    {Coordinate{15.6292, 46.7098}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q801450
    {Coordinate{9.39343, 47.4345}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen St. Fiden railway station
    {Coordinate{8.0464, 50.3993}, Tz::Europe_Berlin, CountryId{"DE"}}, // Staffel station
    {Coordinate{7.69296, 49.7804}, Tz::Europe_Berlin, CountryId{"DE"}}, // Staudernheim station
    {Coordinate{11.7228, 50.8678}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801458
    {Coordinate{9.01528, 50.825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stadtallendorf station
    {Coordinate{7.32986, 52.1477}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinfurt-Burgsteinfurt station
    {Coordinate{10.2738, 49.453}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinach (b Rothenburg o. d. Tauber) station
    {Coordinate{7.94919, 47.5416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stein-Säckingen railway station
    {Coordinate{8.90667, 50.1214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinheim (Main) station
    {Coordinate{8.59611, 47.3972}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stettbach railway station
    {Coordinate{11.8544, 52.5944}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stendal station
    {Coordinate{6.75222, 51.0181}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stommeln station
    {Coordinate{9.30071, 45.0794}, Tz::Europe_Rome, CountryId{"IT"}}, // Stradella railway station
    {Coordinate{9.16889, 48.8136}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Feuerbach station
    {Coordinate{7.73426, 48.5851}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Strasbourg
    {Coordinate{9.21597, 48.8206}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801475
    {Coordinate{9.26806, 48.7617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Obertürkheim station
    {Coordinate{9.10833, 48.7175}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Rohr station
    {Coordinate{9.11306, 48.7267}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Vaihingen station
    {Coordinate{9.25028, 48.7797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Untertürkheim station
    {Coordinate{9.16667, 48.8292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Zuffenhausen station
    {Coordinate{9.09417, 48.8219}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart-Weilimdorf station
    {Coordinate{9.11667, 48.7375}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Österfeld station
    {Coordinate{9.18944, 48.69}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Flughafen/Messe station
    {Coordinate{9.15251, 48.8339}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Neuwirtshaus station
    {Coordinate{9.24083, 48.7922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Neckarpark station
    {Coordinate{9.15653, 48.7702}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Schwabstraße station
    {Coordinate{9.10528, 48.7458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart University station
    {Coordinate{9.18368, 47.5388}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sulgen railway station
    {Coordinate{8.09788, 47.1708}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q801493
    {Coordinate{11.1281, 51.1656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sömmerda station
    {Coordinate{2.83224, 49.8592}, Tz::Europe_Paris, CountryId{"FR"}}, // TGV Haute-Picardie railway station
    {Coordinate{9.12528, 48.9217}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tamm (Württemberg) station
    {Coordinate{10.0965, 47.9949}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801508
    {Coordinate{13.491, 53.1119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Templin Railway Station
    {Coordinate{8.56476, 47.296}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thalwil railway station
    {Coordinate{23.7731, 61.4986}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Tampere railway station
    {Coordinate{7.62959, 46.7549}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thun railway station
    {Coordinate{8.15512, 47.9035}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Titisee
    {Coordinate{5.08334, 51.5603}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tilburg railway station
    {Coordinate{7.65706, 45.0267}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Lingotto railway station
    {Coordinate{7.67889, 45.0625}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Porta Nuova railway station
    {Coordinate{12.6333, 47.8667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Traunstein station
    {Coordinate{10.6783, 49.2017}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801526
    {Coordinate{12.5186, 38.0169}, Tz::Europe_Rome, CountryId{"IT"}}, // Trapani railway station
    {Coordinate{15.9967, 48.2951}, Tz::Europe_Vienna, CountryId{"AT"}}, // Tullnerfeld railway station
    {Coordinate{8.25345, 47.4918}, Tz::Europe_Zurich, CountryId{"CH"}}, // Turgi railway station
    {Coordinate{13.7721, 45.6575}, Tz::Europe_Rome, CountryId{"IT"}}, // Trieste Centrale railway station
    {Coordinate{11.2732, 47.9071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tutzing station
    {Coordinate{9.0385, 48.52}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tübingen West station
    {Coordinate{18.9642, 50.1364}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Tychy railway station
    {Coordinate{12.0061, 50.8906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801538
    {Coordinate{14.054, 53.734}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ueckermünde railway station
    {Coordinate{7.11469, 49.5804}, Tz::Europe_Berlin, CountryId{"DE"}}, // Türkismühle station
    {Coordinate{4.70278, 52.5214}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Uitgeest railway station
    {Coordinate{-0.382306, 39.4605}, Tz::Europe_Madrid, CountryId{"ES"}}, // Valencia-Joaquín Sorolla railway station
    {Coordinate{6.88691, 53.1051}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veendam railway station
    {Coordinate{9.87611, 49.8306}, Tz::Europe_Berlin, CountryId{"DE"}}, // Veitshöchheim station
    {Coordinate{2.43219, 48.7883}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Vert de Maisons
    {Coordinate{8.46508, 48.0578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Villingen (Schwarzwald) station
    {Coordinate{6.40417, 51.2547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Viersen station
    {Coordinate{7.88146, 46.294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Visp railway station
    {Coordinate{9.56639, 52.9797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Visselhövede station
    {Coordinate{12.321, 45.441}, Tz::Europe_Rome, CountryId{"IT"}}, // Venezia Santa Lucia railway station
    {Coordinate{9.00861, 44.9978}, Tz::Europe_Rome, CountryId{"IT"}}, // Voghera railway station
    {Coordinate{3.59528, 51.4647}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlissingen Souburg railway station
    {Coordinate{6.84928, 49.2488}, Tz::Europe_Berlin, CountryId{"DE"}}, // Völklingen station
    {Coordinate{12.4965, 49.6399}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801571
    {Coordinate{12.6987, 49.3777}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801573
    {Coordinate{8.46972, 50.9228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801575
    {Coordinate{8.59191, 47.4127}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wallisellen railway station
    {Coordinate{12.0908, 54.1771}, Tz::Europe_Berlin, CountryId{"DE"}}, // Warnemünde railway station
    {Coordinate{9.16361, 51.4928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Warburg station
    {Coordinate{6.49861, 49.7125}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Wasserbillig railway station
    {Coordinate{11.2091, 52.3872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801583
    {Coordinate{8.42552, 47.5635}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q801584
    {Coordinate{5.04361, 52.3131}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Weesp railway station
    {Coordinate{8.87306, 48.7556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weil der Stadt station
    {Coordinate{9.10606, 47.5662}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weinfelden railway station
    {Coordinate{12.0607, 50.4486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weischlitz railway station
    {Coordinate{8.5791, 49.9094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801589
    {Coordinate{9.37333, 48.6731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wendlingen (Neckar) station
    {Coordinate{7.75831, 51.2593}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werdohl station
    {Coordinate{8.31167, 54.9067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Westerland (Sylt) station
    {Coordinate{8.31603, 47.4596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wettingen railway station
    {Coordinate{7.38593, 51.3867}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wetter (Ruhr) station
    {Coordinate{16.4, 48.2564}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Floridsdorf railway station
    {Coordinate{16.365, 48.2492}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Heiligenstadt railway station
    {Coordinate{16.2639, 48.1964}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Hütteldorf railway station
    {Coordinate{16.3111, 48.2111}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Ottakring railway station
    {Coordinate{16.2839, 48.1347}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Liesing railway station
    {Coordinate{16.4496, 48.2198}, Tz::Europe_Vienna, CountryId{"AT"}}, // Stadlau
    {Coordinate{16.3053, 48.1924}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Penzing railway station
    {Coordinate{6.59111, 52.3614}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wierden railway station
    {Coordinate{8.32556, 50.0822}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Wiesbaden-Igstadt
    {Coordinate{12.5097, 50.6761}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801613
    {Coordinate{8.12257, 49.0955}, Tz::Europe_Berlin, CountryId{"DE"}}, // Winden (Pfalz) station
    {Coordinate{8.75083, 47.4989}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Grüze railway station
    {Coordinate{8.76674, 47.4874}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Seen railway station
    {Coordinate{8.70929, 47.4898}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Töss railway station
    {Coordinate{8.68098, 47.5065}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Wülflingen railway station
    {Coordinate{7.3762, 51.4477}, Tz::Europe_Berlin, CountryId{"DE"}}, // Witten-Annen Nord station
    {Coordinate{7.95, 49.0317}, Tz::Europe_Paris, CountryId{"FR"}}, // Wissembourg
    {Coordinate{7.02587, 50.6895}, Tz::Europe_Berlin, CountryId{"DE"}}, // Witterschlick
    {Coordinate{4.89306, 52.0847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Woerden railway station
    {Coordinate{16.5128, 48.3791}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Wolkersdorf
    {Coordinate{9.7492, 53.9331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wrist station
    {Coordinate{7.01144, 51.719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801630
    {Coordinate{7.19444, 51.2672}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Barmen station
    {Coordinate{7.21556, 51.2264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Ronsdorf station
    {Coordinate{7.14012, 51.251}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Steinbeck station
    {Coordinate{7.17083, 51.2589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Unterbarmen station
    {Coordinate{12.8967, 52.8572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801645
    {Coordinate{10.3966, 50.9571}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wutha station
    {Coordinate{12.9386, 52.5519}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wustermark railway station
    {Coordinate{12.7567, 50.8054}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wüstenbrand station
    {Coordinate{9.29644, 50.2551}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wächtersbach station
    {Coordinate{4.81389, 52.4383}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaandam railway station
    {Coordinate{8.60554, 50.037}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zeppelinheim station
    {Coordinate{13.5342, 52.6598}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zepernick station
    {Coordinate{12.0114, 50.6594}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zeulenroda unt Bf station
    {Coordinate{15.0042, 51.1403}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zgorzelec
    {Coordinate{9.06, 47.1361}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ziegelbrücke railway station
    {Coordinate{14.8058, 50.9043}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zittau railway station
    {Coordinate{7.9431, 47.288}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q801665
    {Coordinate{8.50992, 47.1477}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q801666
    {Coordinate{8.60929, 49.7257}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zwingenberg (Bergstraße) station
    {Coordinate{6.19389, 52.1446}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zutphen railway station
    {Coordinate{12.3636, 50.3622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q801672
    {Coordinate{8.52194, 47.3622}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Giesshübel railway station
    {Coordinate{8.53194, 47.3653}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Enge railway station
    {Coordinate{8.53325, 47.3872}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Letten railway station
    {Coordinate{8.51711, 47.3852}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Hardbrücke railway station
    {Coordinate{8.53361, 47.3475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Wollishofen railway station
    {Coordinate{13.5483, 53.9739}, Tz::Europe_Berlin, CountryId{"DE"}}, // Züssow railway station
    {Coordinate{12.4873, 47.822}, Tz::Europe_Berlin, CountryId{"DE"}}, // Übersee station
    {Coordinate{6.09765, 50.9242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Übach-Palenberg station
    {Coordinate{14.2345, 53.9142}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Świnoujście Centrum
    {Coordinate{23.3157, 55.9226}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Šiauliai railway station
    {Coordinate{18.7461, 49.2269}, Tz::Europe_Bratislava, CountryId{"SK"}}, // Žilina railway station
    {Coordinate{5.29333, 51.6903}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // 's-Hertogenbosch railway station
    {Coordinate{9.5311, 46.8475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chur Stadt station
    {Coordinate{13.8925, 53.1114}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wilmersdorf (b Angermünde) railway station
    {Coordinate{7.896, 46.5819}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winteregg railway station
    {Coordinate{11.4692, 53.8967}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wismar railway station
    {Coordinate{8.39468, 46.9076}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wolfenschiessen railway station
    {Coordinate{6.00472, 52.8797}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wolvega railway station
    {Coordinate{13.1397, 54.23}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wüstenfelde railway station
    {Coordinate{24.7369, 59.4403}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Balti jaam
    {Coordinate{13.08, 54.2406}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zarrendorf railway station
    {Coordinate{7.7475, 46.0242}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zermatt railway station
    {Coordinate{14.0978, 53.4992}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zerrenthin railway station
    {Coordinate{13.6274, 52.3486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zeuthen railway station
    {Coordinate{9.55972, 46.9347}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zizers
    {Coordinate{8.56943, 47.3373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zollikon railway station
    {Coordinate{9.96139, 46.6}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zuoz
    {Coordinate{8.5265, 47.352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Brunau railway station
    {Coordinate{8.5191, 47.3336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Leimbach railway station
    {Coordinate{8.51988, 47.3382}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Manegg railway station
    {Coordinate{8.46786, 47.5703}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zweidlen railway station
    {Coordinate{7.9, 46.6333}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zweilütschinen railway station
    {Coordinate{8.51795, 47.3628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Binz railway station
    {Coordinate{8.5218, 47.3579}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Saalsporthalle-Sihlcity railway station
    {Coordinate{8.5033, 47.365}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Schweighof railway station
    {Coordinate{8.4952, 47.365}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Triemli railway station
    {Coordinate{10.8592, 47.2384}, Tz::Europe_Vienna, CountryId{"AT"}}, // Ötztal railway station
    {Coordinate{12.9992, 47.6264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berchtesgaden Central Station
    {Coordinate{11.4444, 48.2547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dachau station
    {Coordinate{6.93912, 51.3566}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kettwig Stausee station
    {Coordinate{12.1355, 48.5483}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landshut Central Station
    {Coordinate{7.89167, 49.9689}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bingen Central Station
    {Coordinate{10.0249, 53.5527}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berliner Tor station
    {Coordinate{7.15375, 51.4598}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wattenscheid-Höntrop station
    {Coordinate{9.68389, 47.5458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindau Central Station
    {Coordinate{13.4978, 52.4939}, Tz::Europe_Berlin, CountryId{"DE"}}, // Betriebsbahnhof Rummelsburg station
    {Coordinate{6.83444, 50.9428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Lövenich station
    {Coordinate{6.17034, 49.3543}, Tz::Europe_Paris, CountryId{"FR"}}, // Thionville railway station
    {Coordinate{19.0839, 47.5003}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budapest Keleti railway station
    {Coordinate{4.8416, 45.7451}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Jean Macé
    {Coordinate{10.3983, 43.7083}, Tz::Europe_Rome, CountryId{"IT"}}, // Pisa Centrale railway station
    {Coordinate{4.48472, 50.8972}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels National Airport railway station
    {Coordinate{10.2117, 50.0356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schweinfurt Central Station
    {Coordinate{10.0339, 46.3744}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alp Grüm
    {Coordinate{8.6625, 50.1069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Central Station
    {Coordinate{10.3068, 50.4248}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mellrichstadt station
    {Coordinate{12.0619, 47.4917}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wörgl Central Station
    {Coordinate{14.0267, 48.1656}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wels Central Station
    {Coordinate{15.0903, 47.3864}, Tz::Europe_Vienna, CountryId{"AT"}}, // Leoben Central Station
    {Coordinate{15.4172, 47.0722}, Tz::Europe_Vienna, CountryId{"AT"}}, // Graz Central Station
    {Coordinate{6.42667, 46.4752}, Tz::Europe_Zurich, CountryId{"CH"}}, // Etoy
    {Coordinate{6.26917, 46.42}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gland
    {Coordinate{6.23597, 46.3844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nyon
    {Coordinate{-1.13756, 39.5244}, Tz::Europe_Madrid, CountryId{"ES"}}, // Q8841592
    {Coordinate{6.33653, 46.4628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rolle
    {Coordinate{6.45583, 46.4822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Prex
    {Coordinate{8.59992, 53.5662}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremerhaven-Lehe railway station
    {Coordinate{10.9822, 45.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Verona Porta Nuova railway station
    {Coordinate{14.2152, 53.9223}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahlbeck Grenze railway station
    {Coordinate{14.1796, 53.9425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahlbeck Ostseetherme railway station
    {Coordinate{13.5734, 52.5807}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahrensfelde Friedhof station
    {Coordinate{10.555, 51.8878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Harzburg railway station
    {Coordinate{8.57452, 47.695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q9169065
    {Coordinate{12.3158, 51.6239}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bitterfeld station
    {Coordinate{13.0473, 48.2592}, Tz::Europe_Vienna, CountryId{"AT"}}, // Braunau am Inn railway station
    {Coordinate{5.94816, 45.863}, Tz::Europe_Paris, CountryId{"FR"}}, // Rumilly
    {Coordinate{13.7197, 51.0483}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Freiberger Straße station
    {Coordinate{12.6585, 43.9992}, Tz::Europe_Rome, CountryId{"IT"}}, // Q924111
    {Coordinate{8.4303, 47.6597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erzingen (Baden) station
    {Coordinate{11.3541, 44.5519}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna Corticella railway halt
    {Coordinate{14.6369, 51.7389}, Tz::Europe_Berlin, CountryId{"DE"}}, // Forst (Lausitz)
    {Coordinate{2.73993, 46.2953}, Tz::Europe_Paris, CountryId{"FR"}}, // Q926219
    {Coordinate{14.4722, 52.3377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt (Oder)-Rosengarten
    {Coordinate{3.95778, 50.8069}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zandbergen railway station
    {Coordinate{0.231111, 49.1383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lisieux
    {Coordinate{12.1722, 53.8006}, Tz::Europe_Berlin, CountryId{"DE"}}, // Güstrow railway station
    {Coordinate{11.9623, 51.5235}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q9285520
    {Coordinate{9.76978, 52.3556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover Bismarckstraße
    {Coordinate{12.1081, 54.0851}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock Parkstraße railway station
    {Coordinate{12.1629, 54.0794}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock-Kassebohm railway station
    {Coordinate{11.2947, 51.4798}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sangerhausen station
    {Coordinate{14.0773, 53.9823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schmollensee railway station
    {Coordinate{11.3697, 53.6566}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwerin-Lankow railway station
    {Coordinate{14.1878, 53.9355}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seebad Ahlbeck railway station
    {Coordinate{14.1383, 53.9686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bansin Seebad railway station
    {Coordinate{14.0167, 54.0169}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stubbenfelde railway station
    {Coordinate{6.74616, 47.0578}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Locle
    {Coordinate{8.4368, 47.6652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q9361343
    {Coordinate{12.6808, 53.5214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Waren (Müritz) railway station
    {Coordinate{20.9358, 52.1944}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Raków
    {Coordinate{}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q9371153
    {Coordinate{11.9709, 51.2046}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weißenfels station
    {Coordinate{16.4072, 48.1667}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Grillgasse railway station
    {Coordinate{16.441, 48.1995}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q9373170
    {Coordinate{8.464, 47.6795}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilchingen-Hallau train station
    {Coordinate{5.37868, 43.3516}, Tz::Europe_Paris, CountryId{"FR"}}, // Q938931
    {Coordinate{13.9029, 54.0758}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zinnowitz railway station
    {Coordinate{14.05, 54.0167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ückeritz railway station
    {Coordinate{20.9911, 52.2258}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Ochota railway station
    {Coordinate{3.936, 50.6627}, Tz::Europe_Brussels, CountryId{"BE"}}, // Silly railway station
    {Coordinate{4.87595, 50.4546}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jambes railway station
    {Coordinate{-0.965556, 44.6375}, Tz::Europe_Paris, CountryId{"FR"}}, // Facture-Biganos
    {Coordinate{8.8875, 44.4131}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Sampierdarena
    {Coordinate{-0.556944, 47.4647}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Angers-Saint-Laud
    {Coordinate{4.30906, 50.8091}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forest-South railway station
    {Coordinate{4.43639, 50.4106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Charleroi-West railway station
    {Coordinate{6.92613, 43.6536}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grasse
    {Coordinate{6.81544, 50.9406}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Weiden West station
    {Coordinate{7.34657, 48.0725}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colmar
    {Coordinate{0.730278, 43.105}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Gaudens
    {Coordinate{21.2006, 52.1725}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Miedzeszyn railway station
    {Coordinate{12.5103, 41.9554}, Tz::Europe_Rome, CountryId{"IT"}}, // Nuovo Salario railway station
    {Coordinate{2.74306, 48.0069}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montargis
    {Coordinate{5.63257, 49.7182}, Tz::Europe_Brussels, CountryId{"BE"}}, // Habay railway station
    {Coordinate{1.08111, 49.9214}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dieppe
    {Coordinate{5.27694, 50.1325}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forrières railway station
    {Coordinate{2.868, 42.7665}, Tz::Europe_Paris, CountryId{"FR"}}, // Rivesaltes
    {Coordinate{7.07201, 51.2677}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wülfrath-Aprath station
    {Coordinate{2.68556, 48.2675}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nemours–Saint-Pierre
    {Coordinate{14.7724, 40.6754}, Tz::Europe_Rome, CountryId{"IT"}}, // Salerno railway station
    {Coordinate{-0.573175, 48.7447}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Flers
    {Coordinate{3.07167, 46.9306}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saincaize
    {Coordinate{5.70977, 49.9996}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bastogne-South railway station
    {Coordinate{-0.042125, 43.1006}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lourdes
    {Coordinate{6.86278, 53.3258}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Appingedam railway station
    {Coordinate{5.05139, 51.5653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tilburg Universiteit railway station
    {Coordinate{4.56608, 50.5116}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ligny railway station
    {Coordinate{6.93583, 46.9967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel railway station
    {Coordinate{5.16722, 48.7736}, Tz::Europe_Paris, CountryId{"FR"}}, // Q972791
    {Coordinate{7.08061, 51.3905}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Kupferdreh station
    {Coordinate{3.16336, 42.4415}, Tz::Europe_Paris, CountryId{"FR"}}, // Cerbère railway station
    {Coordinate{4.63083, 50.4494}, Tz::Europe_Brussels, CountryId{"BE"}}, // Auvelais railway station
    {Coordinate{9.54175, 47.2003}, Tz::Europe_Vaduz, CountryId{"LI"}}, // Nendeln railway station
    {Coordinate{3.15778, 42.4247}, Tz::Europe_Madrid, CountryId{"ES"}}, // Portbou railway station
    {Coordinate{6.47106, 45.2173}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Michel-Valloire railway station
    {Coordinate{6.75022, 49.3278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarlouis Central Station
    {Coordinate{9.49649, 53.1657}, Tz::Europe_Berlin, CountryId{"DE"}}, // Scheeßel railway station
};

static const IBNR ibnr_table[] = {
    IBNR{1000009}, // Humppila railway station
    IBNR{1000038}, // Tampere railway station
    IBNR{1000095}, // Pasila railway station
    IBNR{1000101}, // Turku Central railway station
    IBNR{1000430}, // Lahti railway station
    IBNR{2000047}, // Kaliningrad Railway station
    IBNR{2044001}, // Novosibirsk Main railway station
    IBNR{2200004}, // Q16692574
    IBNR{2200005}, // Kiev Passenger Railway Station
    IBNR{2200086}, // Q16702723
    IBNR{2400008}, // Vilnius railway station
    IBNR{2400012}, // Q800976
    IBNR{2400050}, // Kaunas Railway Station
    IBNR{2400127}, // Klaipėda railway station
    IBNR{2400129}, // Šiauliai railway station
    IBNR{2400187}, // Jonava railway station
    IBNR{2400191}, // Ignalina train station
    IBNR{2700004}, // Astana-1 railway station
    IBNR{2700024}, // Almaty-2 railway station
    IBNR{2796001}, // Almaty-1 railway station
    IBNR{2800080}, // Balti jaam
    IBNR{5100005}, // Bydgoszcz Główna railway station
    IBNR{5100020}, // Katowice railway station
    IBNR{5100028}, // Kraków Główny railway station
    IBNR{5100035}, // Legnica
    IBNR{5100045}, // Q801295
    IBNR{5100046}, // Opole Główne railway station
    IBNR{5100049}, // Piła Główna
    IBNR{5100057}, // Szczecin Główny
    IBNR{5100065}, // Warsaw Central railway station
    IBNR{5100067}, // Warszawa Zachodnia station
    IBNR{5100068}, // Węgliniec railway station
    IBNR{5100069}, // Wrocław Główny
    IBNR{5100071}, // Zbąszynek
    IBNR{5100082}, // Rzepin
    IBNR{5100083}, // Kunowice
    IBNR{5100085}, // Zgorzelec
    IBNR{5100130}, // Q2156575
    IBNR{5100224}, // Q801122
    IBNR{5100232}, // Zgorzelec Miasto
    IBNR{5100246}, // Warszawa Śródmieście PKP railway station
    IBNR{5100259}, // Q1978260
    IBNR{5100260}, // Tychy railway station
    IBNR{5100316}, // Q5105319
    IBNR{5101955}, // Q764332
    IBNR{5102650}, // Q445351
    IBNR{5103265}, // Q2853323
    IBNR{5103424}, // Sulejówek Miłosna train station
    IBNR{5103786}, // Q776916
    IBNR{5103819}, // Warsaw Chopin Airport railway station
    IBNR{5103920}, // Warszawa Gocławek railway station
    IBNR{5103922}, // Warszawa Rembertów railway station
    IBNR{5103923}, // Warszawa Choszczówka railway station
    IBNR{5103925}, // Warszawa Gołąbki railway station
    IBNR{5103929}, // Q2832591
    IBNR{5103930}, // Warszawa Koło railway station
    IBNR{5103932}, // Warszawa Miedzeszyn railway station
    IBNR{5103934}, // Warszawa Ochota railway station
    IBNR{5103939}, // Q2961989
    IBNR{5103940}, // Warszawa Ursus railway station
    IBNR{5104221}, // Warszawa Śródmieście WKD railway station
    IBNR{5104223}, // Q2328552
    IBNR{5104226}, // Warszawa Wileńska station
    IBNR{5104227}, // Warszawa Żerań railway station
    IBNR{5104229}, // Warszawa Raków
    IBNR{5104233}, // Warszawa Zoo railway station
    IBNR{5104519}, // Rajcza Centrum railway station
    IBNR{5104679}, // Q9371153
    IBNR{5104686}, // Warszawa Ursus Niedźwiadek railway station
    IBNR{5128148}, // Warszawa Aleje Jerozolimskie railway station
    IBNR{5149451}, // Warszawa Żwirki i Wigury railway station
    IBNR{5189954}, // Świnoujście Centrum
    IBNR{5400004}, // Cheb station
    IBNR{5400014}, // Praha hlavní nádraží
    IBNR{5400171}, // Praha-Vysočany railway station
    IBNR{5400201}, // Praha-Holešovice railway station
    IBNR{5400204}, // Praha-Smíchov railway station
    IBNR{5400206}, // Praha Masarykovo nádraží
    IBNR{5400227}, // Rumburk (train station)
    IBNR{5400275}, // Praha-Vršovice railway station
    IBNR{5400282}, // Jedlová railway station
    IBNR{5401068}, // Q18398041
    IBNR{5402389}, // Q2269031
    IBNR{5403020}, // Q25412023
    IBNR{5403526}, // Zákupy (train station)
    IBNR{5500003}, // Budapest Keleti railway station
    IBNR{5500005}, // Kőbánya-Kispest railway station
    IBNR{5500007}, // Budapest Southern Railway Terminal
    IBNR{5500008}, // Kelenföld railway station
    IBNR{5500035}, // Székesfehérvár railway station
    IBNR{5500058}, // Debrecen Railway Station
    IBNR{5500061}, // Nyíregyháza railway station
    IBNR{5500346}, // Angyalföld train station
    IBNR{5500682}, // Kispest railway station
    IBNR{5500728}, // Budapest Western Railway Terminal
    IBNR{5501052}, // Pestszentimre railway station
    IBNR{5501053}, // Pestszentimre felső railway station
    IBNR{5501054}, // Pestszentlőrinc railway station
    IBNR{5501119}, // Rákospalota-Kertváros railway station
    IBNR{5501120}, // Rákospalota-Újpest railway station
    IBNR{5501121}, // Rákosrendező railway station
    IBNR{5501251}, // Szemeretelep railway station
    IBNR{5501399}, // Újpest railway station
    IBNR{5501413}, // Vác railway station
    IBNR{5501494}, // Sopron railway station
    IBNR{5501599}, // Istvántelek railway station
    IBNR{5564605}, // Ferihegy railway station
    IBNR{5600013}, // Poprad-Tatry railway station
    IBNR{5600020}, // Žilina railway station
    IBNR{5600135}, // Kysak railway station
    IBNR{5600185}, // Ružomberok
    IBNR{6500001}, // Skopje Main railway station
    IBNR{7000176}, // Brading railway station
    IBNR{7000229}, // Birmingham Moor Street railway station
    IBNR{7000321}, // Brighton railway station
    IBNR{7000478}, // Christchurch railway station
    IBNR{7000528}, // Canonbury railway station
    IBNR{7000635}, // Crystal Palace railway station
    IBNR{7000636}, // Dagenham Dock railway station
    IBNR{7000750}, // Eastbourne railway station
    IBNR{7000763}, // East Croydon station
    IBNR{7000821}, // Exmouth railway station
    IBNR{7000920}, // Glasgow Queen Street railway station
    IBNR{7000964}, // Gospel Oak railway station
    IBNR{7001204}, // Inverness railway station
    IBNR{7001303}, // Lancaster railway station
    IBNR{7001497}, // Milngavie railway station
    IBNR{7001527}, // Manchester Oxford Road railway station
    IBNR{7001537}, // Manchester Piccadilly station
    IBNR{7001584}, // Manchester Victoria station
    IBNR{7002071}, // Stoke Mandeville railway station
    IBNR{7002384}, // West Hampstead railway station
    IBNR{7002473}, // Wressle railway station
    IBNR{7004287}, // Imperial Wharf railway station
    IBNR{7004296}, // Shepherd's Bush railway station
    IBNR{7004419}, // Ebbsfleet International railway station
    IBNR{7004529}, // Dalston Junction railway station
    IBNR{7004721}, // St Pancras railway station
    IBNR{7098107}, // Ashford International railway station
    IBNR{7100045}, // Málaga-María Zambrano Railway Station
    IBNR{7100063}, // Passeig de Gràcia
    IBNR{7100064}, // Barcelona Sants railway station
    IBNR{7100067}, // Barcelona Estació de França
    IBNR{7100074}, // Plaça de Catalunya station
    IBNR{7100079}, // Portbou railway station
    IBNR{7100180}, // Seville-Santa Justa railway station
    IBNR{7103213}, // Q8841592
    IBNR{7103216}, // Valencia-Joaquín Sorolla railway station
    IBNR{7118004}, // Delicias Railway Station
    IBNR{7178804}, // Arc de Triomf station
    IBNR{7400062}, // Härnösand railway station
    IBNR{7400066}, // Herrljunga railway station
    IBNR{7400085}, // Laxå railway station
    IBNR{7400101}, // Umeå Central Station
    IBNR{7400102}, // Uppsala Central Station
    IBNR{7400124}, // Örnsköldsvik central station
    IBNR{7400154}, // Helsingborg Central Station
    IBNR{7400216}, // Timrå railway station
    IBNR{7400412}, // Sundsvall central station
    IBNR{7400544}, // Lerum railway station
    IBNR{7400548}, // Ljung railway station
    IBNR{7400622}, // Stenkullen
    IBNR{7400636}, // Sundsvall western station
    IBNR{7400687}, // Husum railway station
    IBNR{7400697}, // Nykroppa railway station
    IBNR{7400886}, // Floby railway station
    IBNR{7400970}, // Umeå East Station
    IBNR{7400971}, // Hörnefors railway station
    IBNR{7400972}, // Nordmaling railway station
    IBNR{7400975}, // Örnsköldsvik north station
    IBNR{7405186}, // Västeraspby railway station
    IBNR{7500003}, // Sirkeci railway station
    IBNR{7500010}, // Ankara railway station
    IBNR{8000001}, // Aachen Central Station
    IBNR{8000002}, // Aalen station
    IBNR{8000004}, // Altenbeken station
    IBNR{8000005}, // Alzey station
    IBNR{8000009}, // Ansbach station
    IBNR{8000010}, // Aschaffenburg Central Station
    IBNR{8000012}, // Au station
    IBNR{8000013}, // Augsburg Central Station
    IBNR{8000014}, // Aulendorf station
    IBNR{8000015}, // Babenhausen station
    IBNR{8000016}, // Backnang station
    IBNR{8000017}, // Bad Friedrichshall-Jagstfeld station
    IBNR{8000019}, // Bad Harzburg railway station
    IBNR{8000020}, // Bad Hersfeld station
    IBNR{8000021}, // Bad Kreuznach station
    IBNR{8000023}, // Bad Oldesloe railway station
    IBNR{8000025}, // Bamberg station
    IBNR{8000026}, // Basel Badischer Bahnhof
    IBNR{8000027}, // Schwandorf station
    IBNR{8000028}, // Bayreuth Central Station
    IBNR{8000029}, // Bebra station
    IBNR{8000031}, // Bensheim station
    IBNR{8000032}, // Schweinfurt Central Station
    IBNR{8000033}, // Schwelm station
    IBNR{8000034}, // Betzdorf (Sieg) station
    IBNR{8000036}, // Bielefeld Central Station
    IBNR{8000037}, // Schwerte (Ruhr) station
    IBNR{8000038}, // Bietigheim-Bissingen station
    IBNR{8000039}, // Bingen Central Station
    IBNR{8000040}, // Bocholt railway station
    IBNR{8000041}, // Bochum Central Station
    IBNR{8000043}, // Seesen station
    IBNR{8000044}, // Bonn Hauptbahnhof
    IBNR{8000045}, // Boppard Central Station
    IBNR{8000046}, // Siegen Hauptbahnhof
    IBNR{8000047}, // Bottrop Central Station
    IBNR{8000048}, // Brackwede station
    IBNR{8000049}, // Braunschweig Central Station
    IBNR{8000050}, // Bremen main station
    IBNR{8000051}, // Bremerhaven Hauptbahnhof
    IBNR{8000053}, // Bretten station
    IBNR{8000054}, // Brilon-Wald station
    IBNR{8000055}, // Bruchsal station
    IBNR{8000057}, // Buchloe station
    IBNR{8000058}, // Büchen railway station
    IBNR{8000059}, // Bünde station
    IBNR{8000061}, // Burg- und Nieder-Gemünden station
    IBNR{8000062}, // Steinfurt-Burgsteinfurt station
    IBNR{8000063}, // Q15725866
    IBNR{8000065}, // Cölbe station
    IBNR{8000066}, // Coesfeld (Westf) station
    IBNR{8000067}, // Crailsheim station
    IBNR{8000068}, // Darmstadt Central Station
    IBNR{8000072}, // Q26836635
    IBNR{8000073}, // Singen (Hohentwiel) station
    IBNR{8000074}, // Dillenburg station
    IBNR{8000075}, // Dillingen (Saar) station
    IBNR{8000076}, // Soest (Germany) station
    IBNR{8000077}, // Donaueschingen station
    IBNR{8000078}, // Donauwörth station
    IBNR{8000079}, // Puttgarden station
    IBNR{8000080}, // Dortmund Central Station
    IBNR{8000081}, // Dortmund-Dorstfeld station
    IBNR{8000082}, // Düsseldorf Airport station
    IBNR{8000083}, // Dülmen station
    IBNR{8000084}, // Düren station
    IBNR{8000085}, // Düsseldorf Central Station
    IBNR{8000086}, // Duisburg Central Station
    IBNR{8000087}, // Solingen Central Station
    IBNR{8000088}, // Soltau (Han) station
    IBNR{8000089}, // Stade station
    IBNR{8000090}, // Eichenberg station
    IBNR{8000091}, // Steinach (b Rothenburg o. d. Tauber) station
    IBNR{8000092}, // Elmshorn station
    IBNR{8000094}, // Engers station
    IBNR{8000095}, // Bahnhof Straubing
    IBNR{8000096}, // Stuttgart Central Station
    IBNR{8000098}, // Essen Central Station
    IBNR{8000099}, // Essen-Steele station
    IBNR{8000100}, // Euskirchen station
    IBNR{8000101}, // Eutingen im Gäu station
    IBNR{8000102}, // Finnentrop station
    IBNR{8000103}, // Flensburg station
    IBNR{8000104}, // Q800760
    IBNR{8000105}, // Frankfurt (Main) Hauptbahnhof
    IBNR{8000106}, // Frankfurt Höchst station
    IBNR{8000107}, // Freiburg Central Station
    IBNR{8000108}, // Freilassing station
    IBNR{8000110}, // Freudenstadt Central Station
    IBNR{8000111}, // Friedberg station
    IBNR{8000112}, // Friedrichshafen Stadt station
    IBNR{8000113}, // Fröndenberg station
    IBNR{8000114}, // Fürth Hauptbahnhof
    IBNR{8000115}, // Fulda station
    IBNR{8000116}, // Traunstein station
    IBNR{8000117}, // Gelnhausen station
    IBNR{8000118}, // Gelsenkirchen Central Station
    IBNR{8000119}, // Geltendorf station
    IBNR{8000120}, // Gemünden station
    IBNR{8000121}, // Q26821689
    IBNR{8000122}, // Treuchtlingen station
    IBNR{8000123}, // Gerolstein station
    IBNR{8000124}, // Gießen station
    IBNR{8000125}, // Gladbeck West station
    IBNR{8000126}, // Riedstadt-Goddelau station
    IBNR{8000127}, // Göppingen station
    IBNR{8000128}, // Göttingen station
    IBNR{8000129}, // Treysa station
    IBNR{8000130}, // Goslar railway station
    IBNR{8000131}, // Graben-Neudorf station
    IBNR{8000132}, // Grävenwiesbach station
    IBNR{8000133}, // Grevenbroich station
    IBNR{8000134}, // Trier Central Station
    IBNR{8000136}, // Groß Gerau station
    IBNR{8000137}, // Grünstadt station
    IBNR{8000138}, // Gruiten station
    IBNR{8000139}, // Günzburg station
    IBNR{8000140}, // Q15785148
    IBNR{8000141}, // Tübingen Central Station
    IBNR{8000142}, // Hagen Central Station
    IBNR{8000143}, // Q3098066
    IBNR{8000144}, // Q2464536
    IBNR{8000145}, // Haltern am See station
    IBNR{8000146}, // Q3098067
    IBNR{8000147}, // Hamburg-Harburg station
    IBNR{8000148}, // Hamelin station
    IBNR{8000149}, // Hamm (Westfalen) station
    IBNR{8000150}, // Hanau Central Station
    IBNR{8000151}, // Bad Bentheim station
    IBNR{8000152}, // Hanover Central Station
    IBNR{8000154}, // Türkismühle station
    IBNR{8000155}, // Heide station
    IBNR{8000156}, // Heidelberg Central Station
    IBNR{8000157}, // Heilbronn Central Station
    IBNR{8000158}, // Nidderau station
    IBNR{8000161}, // Herborn station
    IBNR{8000162}, // Herford railway station
    IBNR{8000163}, // Tuttlingen station
    IBNR{8000164}, // Herne station
    IBNR{8000165}, // Bahnhof Hervest-Dorsten
    IBNR{8000166}, // Herzberg (Harz) station
    IBNR{8000168}, // Uelzen station
    IBNR{8000169}, // Hildesheim Central Station
    IBNR{8000170}, // Ulm Central Station
    IBNR{8000171}, // Unna station
    IBNR{8000174}, // Viersen station
    IBNR{8000175}, // Völklingen station
    IBNR{8000176}, // Homburg Central Station
    IBNR{8000178}, // Horrem station
    IBNR{8000180}, // Waiblingen station
    IBNR{8000181}, // Husum (Germany) station
    IBNR{8000182}, // Immendingen station
    IBNR{8000183}, // Ingolstadt Central Station
    IBNR{8000186}, // Iserlohn station
    IBNR{8000187}, // Q801575
    IBNR{8000188}, // Q800970
    IBNR{8000189}, // Kaiserslautern Hauptbahnhof
    IBNR{8000190}, // Kaldenkirchen station
    IBNR{8000191}, // Karlsruhe Central Station
    IBNR{8000192}, // Wanne-Eickel Central Station
    IBNR{8000193}, // Kassel Central Station
    IBNR{8000194}, // Q14544357
    IBNR{8000195}, // Kaufering station
    IBNR{8000196}, // Warburg station
    IBNR{8000197}, // Kempten Central Station
    IBNR{8000198}, // Kettwig station
    IBNR{8000199}, // Kiel Central Station
    IBNR{8000201}, // Q16054528
    IBNR{8000205}, // Kleve
    IBNR{8000206}, // Koblenz Central Station
    IBNR{8000207}, // Cologne Central Station
    IBNR{8000209}, // Köln-Mülheim station
    IBNR{8000210}, // Korbach station
    IBNR{8000211}, // Krefeld Central Station
    IBNR{8000212}, // Krefeld-Oppum station
    IBNR{8000213}, // Kreiensen station
    IBNR{8000214}, // Kreuztal station
    IBNR{8000216}, // Landau (Pfalz) Hauptbahnhof
    IBNR{8000217}, // Landshut Central Station
    IBNR{8000218}, // Weilburg station
    IBNR{8000220}, // Weilheim (Oberbay) station
    IBNR{8000221}, // Lauda station
    IBNR{8000222}, // Lauterbach (Hess) Nord station
    IBNR{8000225}, // Leer (Ostfriesl) railway station
    IBNR{8000226}, // Lehrte station
    IBNR{8000227}, // Q29878878
    IBNR{8000228}, // Lichtenfels station
    IBNR{8000229}, // Limburg (Lahn) station
    IBNR{8000230}, // Lindau Central Station
    IBNR{8000233}, // Löhne station
    IBNR{8000234}, // Bahnhof Lollar
    IBNR{8000235}, // Ludwigsburg station
    IBNR{8000236}, // Ludwigshafen Central Station
    IBNR{8000237}, // Lübeck Central Station
    IBNR{8000238}, // Lüneburg station
    IBNR{8000239}, // Lünen Central Station
    IBNR{8000240}, // Mainz Central Station
    IBNR{8000241}, // Mainz-Bischofsheim station
    IBNR{8000242}, // Wesel station
    IBNR{8000243}, // Q27894893
    IBNR{8000244}, // Mannheim Central Station
    IBNR{8000245}, // Westerburg station
    IBNR{8000247}, // Marktredwitz station
    IBNR{8000249}, // Memmingen station
    IBNR{8000250}, // Wiesbaden Central Station
    IBNR{8000251}, // Witten Central Station
    IBNR{8000252}, // Minden station
    IBNR{8000253}, // Mönchengladbach Hauptbahnhof
    IBNR{8000254}, // Wörth (Rhein) station
    IBNR{8000255}, // Wolfenbüttel station
    IBNR{8000257}, // Worms Central Station
    IBNR{8000258}, // Mühldorf (Oberbayern) station
    IBNR{8000259}, // Mülheim Central Station
    IBNR{8000260}, // Würzburg Central Station
    IBNR{8000261}, // Munich Central Station
    IBNR{8000262}, // München Ost station
    IBNR{8000263}, // Münster Central Station
    IBNR{8000265}, // Neckargemünd
    IBNR{8000266}, // Wuppertal Central Station
    IBNR{8000267}, // Q16830553
    IBNR{8000268}, // Wunstorf station
    IBNR{8000271}, // Neumünster station
    IBNR{8000272}, // Neunkirchen Central Station
    IBNR{8000274}, // Neuss Central Station
    IBNR{8000275}, // Neustadt Central Station
    IBNR{8000276}, // Neuwied station
    IBNR{8000277}, // Nidda station
    IBNR{8000278}, // Niederlahnstein station
    IBNR{8000279}, // Nienburg station
    IBNR{8000280}, // Nördlingen station
    IBNR{8000282}, // Nordstemmen station
    IBNR{8000283}, // Northeim (Han) station
    IBNR{8000284}, // Nuremberg Central Station
    IBNR{8000285}, // Rödermark-Ober-Roden station
    IBNR{8000286}, // Oberhausen Central Station
    IBNR{8000287}, // Bahnhof Oberkotzau
    IBNR{8000288}, // Wiesbaden-Biebrich station
    IBNR{8000290}, // Offenburg station
    IBNR{8000291}, // Oldenburg Central Station
    IBNR{8000294}, // Osnabrück Central Station
    IBNR{8000295}, // Osterburken station
    IBNR{8000297}, // Paderborn Central Station
    IBNR{8000298}, // Passau Central Station
    IBNR{8000299}, // Pforzheim Central Station
    IBNR{8000301}, // Plattling station
    IBNR{8000302}, // Plochingen station
    IBNR{8000304}, // Quakenbrück
    IBNR{8000306}, // Rastatt station
    IBNR{8000307}, // Recklinghausen Central Station
    IBNR{8000309}, // Regensburg Hauptbahnhof
    IBNR{8000310}, // Remagen station
    IBNR{8000311}, // Remscheid-Lennep station
    IBNR{8000312}, // Rendsburg station
    IBNR{8000313}, // Renningen station
    IBNR{8000314}, // Reutlingen Central Railway Station
    IBNR{8000315}, // Rheda-Wiedenbrück station
    IBNR{8000316}, // Rheine station
    IBNR{8000317}, // Rheinhausen station
    IBNR{8000318}, // Rheydt Central Station
    IBNR{8000319}, // Rohrbach Station
    IBNR{8000320}, // Rosenheim station
    IBNR{8000321}, // Rotenburg railway station
    IBNR{8000322}, // Rottweil station
    IBNR{8000323}, // Saarbrücken Central Station
    IBNR{8000325}, // Salzgitter-Ringelheim station
    IBNR{8000326}, // Schifferstadt station
    IBNR{8000328}, // Q16830554
    IBNR{8000329}, // Schwäbisch Gmünd station
    IBNR{8000330}, // Schwäbisch Hall-Hessental station
    IBNR{8000331}, // Andernach station
    IBNR{8000332}, // Frankenthal Central Station
    IBNR{8000336}, // Leutkirch station
    IBNR{8000337}, // Marburg station
    IBNR{8000338}, // Mindelheim station
    IBNR{8000339}, // Mühlacker station
    IBNR{8000346}, // Borken (Westf) station
    IBNR{8000347}, // Glauburg-Stockheim station
    IBNR{8000348}, // Stolberg Central Station
    IBNR{8000349}, // Offenbach Central Station
    IBNR{8000350}, // Alsfeld (Oberhess) station
    IBNR{8000351}, // Altenkirchen (Westerw) station
    IBNR{8000357}, // Q15785154
    IBNR{8000358}, // Bochum-Langendreer station
    IBNR{8000360}, // Q28806098
    IBNR{8000362}, // Dieburg station
    IBNR{8000363}, // Dieringhausen station
    IBNR{8000364}, // Vienenburg station
    IBNR{8000366}, // Villingen (Schwarzwald) station
    IBNR{8000367}, // Duisburg-Meiderich Süd railway station
    IBNR{8000369}, // Eberbach railway station
    IBNR{8000370}, // Ehrang station
    IBNR{8000371}, // Q15792329
    IBNR{8000372}, // Enkenbach station
    IBNR{8000373}, // Eppingen station
    IBNR{8000374}, // Freinsheim station
    IBNR{8000376}, // Germersheim station
    IBNR{8000377}, // Weinheim (Bergstraße) station
    IBNR{8000379}, // Wittlich Central Station
    IBNR{8000380}, // Goldshöfe station
    IBNR{8000382}, // Gronau (Westf) railway station
    IBNR{8000383}, // Wetzlar station
    IBNR{8000384}, // Groß-Umstadt Wiebelsbach station
    IBNR{8000385}, // Gunzenhausen station
    IBNR{8000386}, // Haiger station
    IBNR{8000387}, // Hergatz station
    IBNR{8000388}, // Hilden station
    IBNR{8000389}, // Bahnhof Hochdorf (b Horb)
    IBNR{8000390}, // Hochneukirch station
    IBNR{8000392}, // Holzwickede station
    IBNR{8000400}, // Hungen station
    IBNR{8000402}, // Q55652449
    IBNR{8000404}, // Aachen West station
    IBNR{8000406}, // Aachen-Rothe Erde station
    IBNR{8000409}, // Q29793926
    IBNR{8000412}, // Achern station
    IBNR{8000423}, // Q18681697
    IBNR{8000430}, // Q18616527
    IBNR{8000435}, // Kirchhain (Bz Kassel) station
    IBNR{8000440}, // Schnega
    IBNR{8000441}, // Ahlen (Westfalen) station
    IBNR{8000452}, // Aichach station
    IBNR{8000471}, // Albshausen station
    IBNR{8000473}, // Q18681699
    IBNR{8000477}, // Q3226468
    IBNR{8000491}, // Altenglan station
    IBNR{8000498}, // Allersberg (Rothsee) station
    IBNR{8000502}, // Alsdorf-Annapark station
    IBNR{8000503}, // Biblis station
    IBNR{8000505}, // Alsenz station
    IBNR{8000507}, // Alsdorf-Busch station
    IBNR{8000508}, // Q18681700
    IBNR{8000510}, // Alsdorf Poststraße station
    IBNR{8000521}, // Alsdorf-Kellersberg station
    IBNR{8000527}, // Alsdorf-Mariadorf station
    IBNR{8000540}, // Q800378
    IBNR{8000547}, // Lauterecken-Grumbach station
    IBNR{8000555}, // Altötting station
    IBNR{8000556}, // Altomünster station
    IBNR{8000571}, // Lippstadt station
    IBNR{8000577}, // Amstetten (Württemberg) station
    IBNR{8000578}, // Hannover-Anderten-Misburg railway station
    IBNR{8000579}, // Düsseldorf-Angermund station
    IBNR{8000582}, // Annweiler am Trifels station
    IBNR{8000585}, // Langenlonsheim station
    IBNR{8000595}, // Nottuln-Appelhülsen station
    IBNR{8000599}, // Arfurt (Lahn) station
    IBNR{8000601}, // Bad Münstereifel-Arloff station
    IBNR{8000602}, // Q22691245
    IBNR{8000605}, // Arnsberg (Westfalen) station
    IBNR{8000612}, // Q27478874
    IBNR{8000615}, // Mainz-Kastel station
    IBNR{8000630}, // Asperg station
    IBNR{8000631}, // Mannheim-Friedrichsfeld station
    IBNR{8000638}, // Q691608
    IBNR{8000640}, // Miltenberg station
    IBNR{8000644}, // Moers station
    IBNR{8000652}, // Q24420931
    IBNR{8000658}, // Augsburg Haunstetter Straße station
    IBNR{8000660}, // Augsburg Morellstraße station
    IBNR{8000661}, // Augsburg-Hochzoll station
    IBNR{8000662}, // Augsburg-Oberhausen station
    IBNR{8000663}, // Monsheim station
    IBNR{8000667}, // Montabaur station
    IBNR{8000668}, // Aumenau station
    IBNR{8000669}, // Aumühle railway station
    IBNR{8000677}, // Hückelhoven-Baal station
    IBNR{8000687}, // Mülheim-Styrum station
    IBNR{8000691}, // Q15107129
    IBNR{8000698}, // Bad Dürkheim station
    IBNR{8000701}, // Bad Ems station
    IBNR{8000712}, // Bad Homburg station
    IBNR{8000713}, // Bad Honnef (Rhein) station
    IBNR{8000714}, // Bad Kissingen station
    IBNR{8000718}, // Bad Krozingen station
    IBNR{8000726}, // Bad Münster am Stein station
    IBNR{8000727}, // Bad Münstereifel station
    IBNR{8000728}, // Bad Nauheim station
    IBNR{8000732}, // Bad Oeynhausen station
    IBNR{8000733}, // Bad Oeynhausen Süd station
    IBNR{8000736}, // Bad Rappenau station
    IBNR{8000737}, // Bahnhof Bad Reichenhall
    IBNR{8000741}, // Bad Salzhausen station
    IBNR{8000743}, // Bad Salzschlirf station
    IBNR{8000752}, // Bad Soden (Taunus) station
    IBNR{8000760}, // Bad Vilbel station
    IBNR{8000765}, // Bad Wimpfen train station
    IBNR{8000774}, // Baden-Baden station
    IBNR{8000786}, // Balduinstein station
    IBNR{8000800}, // Norden (Germany) railway station
    IBNR{8000805}, // Barmbek station
    IBNR{8000818}, // Ochsenfurt station
    IBNR{8000830}, // Bayerisch Eisenstein station
    IBNR{8000840}, // Beckingen
    IBNR{8000845}, // Q19787796
    IBNR{8000851}, // Beienheim station
    IBNR{8000853}, // Opladen station
    IBNR{8000863}, // Bellheim station
    IBNR{8000864}, // Q27869673
    IBNR{8000865}, // Bempflingen station
    IBNR{8000871}, // Bennemühlen station
    IBNR{8000875}, // Ottweiler (Saar) station
    IBNR{8000876}, // Pirmasens Nord station
    IBNR{8000877}, // Bensheim-Auerbach station
    IBNR{8000885}, // Berchtesgaden Central Station
    IBNR{8000887}, // Recklinghausen Süd station
    IBNR{8000888}, // Bergen (Oberbayern) station
    IBNR{8000891}, // Schlüchtern station
    IBNR{8000899}, // Bergisch Gladbach station
    IBNR{8000908}, // Berliner Tor station
    IBNR{8000925}, // Besigheim station
    IBNR{8000941}, // Bexbach station
    IBNR{8000945}, // Q15107135
    IBNR{8000948}, // Bickenbach (Bergstr) station
    IBNR{8000952}, // Q800527
    IBNR{8000961}, // Dortmund-Hörde station
    IBNR{8000962}, // Q800528
    IBNR{8000976}, // Bingen (Rhein) Stadt station
    IBNR{8000977}, // Hagen-Vorhalle station
    IBNR{8001000}, // Bissendorf station
    IBNR{8001005}, // Böblingen station
    IBNR{8001007}, // Blankenese station
    IBNR{8001013}, // Q17148684
    IBNR{8001030}, // Blumenkamp railway station
    IBNR{8001033}, // Q17122383
    IBNR{8001038}, // Bochum-Dahlhausen station
    IBNR{8001057}, // Böhl-Iggelheim station
    IBNR{8001071}, // Bohmte railway station
    IBNR{8001080}, // Q25090000
    IBNR{8001082}, // Bonn-Bad Godesberg
    IBNR{8001083}, // Bonn-Beuel station
    IBNR{8001084}, // Q800549
    IBNR{8001085}, // Bonn-Mehlem station
    IBNR{8001086}, // Bonn-Oberkassel station
    IBNR{8001092}, // Bordesholm station
    IBNR{8001132}, // Leun/Braunfels station
    IBNR{8001134}, // Q42073109
    IBNR{8001135}, // Q19817142
    IBNR{8001149}, // Q39878739
    IBNR{8001168}, // Bremerhaven-Lehe railway station
    IBNR{8001170}, // Bremerhaven-Wulsdorf station
    IBNR{8001182}, // Brilon Stadt station
    IBNR{8001183}, // Ostbevern station
    IBNR{8001213}, // Brügge (Westfalen) station
    IBNR{8001215}, // Brühl station
    IBNR{8001236}, // Dreieich-Buchschlag station
    IBNR{8001245}, // Bückeburg station
    IBNR{8001250}, // Büdingen (Oberhess) station
    IBNR{8001258}, // Büsenbachtal station
    IBNR{8001261}, // Büttgen station
    IBNR{8001274}, // Q15635107
    IBNR{8001279}, // Railway station Burgdorf
    IBNR{8001297}, // Bahnhof Burgthann
    IBNR{8001308}, // Düsseldorf-Eller Mitte station
    IBNR{8001312}, // Butzbach station
    IBNR{8001315}, // Buxtehude
    IBNR{8001322}, // Q30238830
    IBNR{8001327}, // Castrop-Rauxel Central Station
    IBNR{8001338}, // Coburg railway station
    IBNR{8001341}, // Q15107147
    IBNR{8001352}, // Cuxhaven railway station
    IBNR{8001354}, // Dachau station
    IBNR{8001355}, // Dachau Stadt station
    IBNR{8001362}, // Q23787924
    IBNR{8001365}, // Dalheim station
    IBNR{8001372}, // Dannenberg Ost station
    IBNR{8001375}, // Darmstadt Nord station
    IBNR{8001376}, // Darmstadt Ost station
    IBNR{8001377}, // Darmstadt Süd station
    IBNR{8001378}, // Q25089096
    IBNR{8001380}, // Q800644
    IBNR{8001397}, // Deggendorf Hauptbahnhof
    IBNR{8001399}, // Q27842213
    IBNR{8001404}, // Deisenhofen station
    IBNR{8001415}, // Q11693885
    IBNR{8001420}, // Detmold station
    IBNR{8001432}, // Bahnhof Deuten
    IBNR{8001438}, // Diebsteich station
    IBNR{8001443}, // Diepholz railway station
    IBNR{8001447}, // Bahnhof Dießen
    IBNR{8001455}, // Dietzenbach-Mitte station
    IBNR{8001456}, // Dietzenbach station
    IBNR{8001465}, // Bahnhof Dingden
    IBNR{8001469}, // Dinslaken station
    IBNR{8001471}, // Dissen-Bad Rothenfelde railway station
    IBNR{8001476}, // Ditzingen station
    IBNR{8001492}, // Dollbergen railway station
    IBNR{8001495}, // Q800669
    IBNR{8001502}, // Dorfmark station
    IBNR{8001515}, // Dortmund-Scharnhorst station
    IBNR{8001516}, // Dortmund-Lütgendortmund station
    IBNR{8001518}, // Dortmund Möllerbrücke station
    IBNR{8001520}, // Dortmund Stadthaus station
    IBNR{8001522}, // Dortmund Signal-Iduna-Park station
    IBNR{8001527}, // Dortmund-Barop station
    IBNR{8001530}, // Dortmund-Derne station
    IBNR{8001532}, // Dortmund-Huckarde Nord station
    IBNR{8001536}, // Dortmund-Kruckel station
    IBNR{8001537}, // Dortmund-Kurl station
    IBNR{8001538}, // Dortmund-Löttringhausen station
    IBNR{8001540}, // Dortmund-Germania station
    IBNR{8001543}, // Dortmund-Mengede station
    IBNR{8001545}, // Dortmund-Sölde
    IBNR{8001580}, // Düsseldorf Airport Terminal station
    IBNR{8001581}, // Düsseldorf Volksgarten station
    IBNR{8001582}, // Düsseldorf Wehrhahn station
    IBNR{8001583}, // Düsseldorf Zoo station
    IBNR{8001584}, // Düsseldorf-Benrath station
    IBNR{8001585}, // Düsseldorf-Bilk station
    IBNR{8001586}, // Düsseldorf-Derendorf station
    IBNR{8001587}, // Düsseldorf-Eller station
    IBNR{8001588}, // Düsseldorf-Eller Süd station
    IBNR{8001589}, // Düsseldorf-Garath station
    IBNR{8001590}, // Düsseldorf-Gerresheim station
    IBNR{8001591}, // Düsseldorf-Oberbilk station
    IBNR{8001592}, // Düsseldorf-Rath station
    IBNR{8001593}, // Düsseldorf-Rath Mitte station
    IBNR{8001594}, // Düsseldorf-Reisholz station
    IBNR{8001595}, // Düsseldorf-Unterrath station
    IBNR{8001597}, // Düsseldorf-Hamm station
    IBNR{8001598}, // Düsseldorf-Flingern station
    IBNR{8001603}, // Düsseldorf Völklinger Straße station
    IBNR{8001605}, // Duisburg-Hochfeld Süd station
    IBNR{8001611}, // Haltepunkt Duisburg-Ruhrort
    IBNR{8001612}, // Duisburg-Wedau station
    IBNR{8001618}, // Dutenhofen station
    IBNR{8001620}, // Q15107154
    IBNR{8001621}, // Ebenhausen-Schäftlarn station
    IBNR{8001630}, // Q15303880
    IBNR{8001632}, // Ebersbach (Fils) station
    IBNR{8001634}, // Ebersberg station
    IBNR{8001638}, // Q15785163
    IBNR{8001647}, // Eching station
    IBNR{8001650}, // Echterdingen station
    IBNR{8001654}, // Eckernförde station
    IBNR{8001663}, // Bahnhof Edenkoben
    IBNR{8001712}, // Eilendorf station
    IBNR{8001727}, // Q15785166
    IBNR{8001728}, // Bahnhof Eisenberg, Rhineland-Palatinate
    IBNR{8001731}, // Eislingen (Fils) station
    IBNR{8001736}, // Eitorf station
    IBNR{8001739}, // Elbgaustrasse station
    IBNR{8001745}, // Mönchengladbach-Lürrip station
    IBNR{8001751}, // Ellwangen station
    IBNR{8001763}, // Eltville station
    IBNR{8001767}, // Emden Außenhafen
    IBNR{8001768}, // Emden Central Station
    IBNR{8001770}, // Q18286822
    IBNR{8001771}, // Q28119419
    IBNR{8001773}, // Emmerich station
    IBNR{8001782}, // Emsdetten station
    IBNR{8001785}, // Endersbach station
    IBNR{8001787}, // Bad Endorf station
    IBNR{8001789}, // Engelskirchen station
    IBNR{8001790}, // Q28029178
    IBNR{8001792}, // Q800728
    IBNR{8001795}, // Ennepetal (Gevelsberg) station
    IBNR{8001815}, // Eppstein station
    IBNR{8001817}, // Railway Station Erbach (Odenw)
    IBNR{8001819}, // Nistertal-Bad Marienberg station
    IBNR{8001825}, // Erding station
    IBNR{8001828}, // Bitburg-Erdorf station
    IBNR{8001839}, // Erkelenz station
    IBNR{8001841}, // Erkrath station
    IBNR{8001842}, // Erkrath Nord station
    IBNR{8001844}, // Erlangen railway station
    IBNR{8001860}, // Erpolzheim station
    IBNR{8001864}, // Q19835112
    IBNR{8001865}, // Erzingen (Baden) station
    IBNR{8001867}, // Ibbenbüren-Esch station
    IBNR{8001871}, // Q26836599
    IBNR{8001883}, // Eschhofen station
    IBNR{8001884}, // Bahnhof Eschwege
    IBNR{8001886}, // Eschweiler Central Station
    IBNR{8001888}, // Q129311
    IBNR{8001893}, // Q134564
    IBNR{8001895}, // Q800739
    IBNR{8001896}, // Essen Stadtwald station
    IBNR{8001897}, // Essen Süd station
    IBNR{8001898}, // Essen West station
    IBNR{8001899}, // Essen (Oldb)
    IBNR{8001900}, // Essen-Altenessen station
    IBNR{8001901}, // Essen-Bergeborbeck station
    IBNR{8001902}, // Essen-Borbeck station
    IBNR{8001903}, // Essen-Dellwig station
    IBNR{8001904}, // Essen-Dellwig Ost station
    IBNR{8001905}, // Essen-Eiberg station
    IBNR{8001906}, // Essen-Frohnhausen station
    IBNR{8001908}, // Essen-Hügel station
    IBNR{8001909}, // Essen Zollverein Nord station
    IBNR{8001910}, // Essen-Kray Nord station
    IBNR{8001911}, // Q21042075
    IBNR{8001912}, // Essen-Kupferdreh station
    IBNR{8001913}, // Essen-Steele Ost station
    IBNR{8001914}, // Essen-Überruhr station
    IBNR{8001915}, // Essen-Werden station
    IBNR{8001917}, // Eschweiler-St. Jöris station
    IBNR{8001920}, // Esslingen (Neckar) station
    IBNR{8001921}, // Esslingen-Mettingen
    IBNR{8001924}, // Etelsen
    IBNR{8001958}, // Bad Fallingbostel station
    IBNR{8001970}, // Feldafing station
    IBNR{8001971}, // Feldberg-Bärental Station
    IBNR{8001972}, // Q17123492
    IBNR{8001974}, // Fellbach station
    IBNR{8001978}, // Bahnhöfe in Feucht
    IBNR{8001984}, // Filderstadt station
    IBNR{8001988}, // Feucht Ost station
    IBNR{8001989}, // Q37224158
    IBNR{8002010}, // Flieden station
    IBNR{8002013}, // Flörsheim (Main) station
    IBNR{8002023}, // Q20170857
    IBNR{8002024}, // Q55743881
    IBNR{8002034}, // Frankfurt Mühlberg station
    IBNR{8002036}, // Frankenstein (Pfalz) station
    IBNR{8002038}, // Frankfurt Lokalbahnhof
    IBNR{8002039}, // Frankfurt East station
    IBNR{8002040}, // Frankfurt Stadion station
    IBNR{8002041}, // Frankfurt South station
    IBNR{8002042}, // Frankfurt West station
    IBNR{8002044}, // Frankfurt Frankfurter Berg station
    IBNR{8002045}, // Frankfurt Eschersheim station
    IBNR{8002046}, // Frankfurt Griesheim station
    IBNR{8002047}, // Frankfurt Louisa station
    IBNR{8002048}, // Frankfurt Mainkur station
    IBNR{8002049}, // Frankfurt Nied station
    IBNR{8002050}, // Frankfurt Niederrad station
    IBNR{8002051}, // Frankfurt Höchst Farbwerke station
    IBNR{8002052}, // Frankfurt Rödelheim station
    IBNR{8002053}, // Frankfurt Sindlingen station
    IBNR{8002055}, // Frankfurt Zeilsheim station
    IBNR{8002058}, // Frankfurt Ostendstraße station
    IBNR{8002065}, // Freiberg (Neckar) station
    IBNR{8002078}, // Freising station
    IBNR{8002091}, // Q17310441
    IBNR{8002096}, // Q51507704
    IBNR{8002101}, // Q800787
    IBNR{8002108}, // Friedrichsdorf station
    IBNR{8002110}, // Friedrichshafen Hafen station
    IBNR{8002113}, // Friedrichsruh railway station
    IBNR{8002117}, // Friedrichsthal (Saar) station
    IBNR{8002150}, // Q800798
    IBNR{8002156}, // Füssen station
    IBNR{8002168}, // Q800801
    IBNR{8002177}, // Q15785172
    IBNR{8002187}, // Garmisch-Partenkirchen station
    IBNR{8002206}, // Geilenkirchen station
    IBNR{8002218}, // Geislingen (Steige) station
    IBNR{8002224}, // Gelsenkirchen-Buer Nord station
    IBNR{8002225}, // Q31401849
    IBNR{8002227}, // Gelsenkirchen-Rotthausen station
    IBNR{8002267}, // Gevelsberg Hauptbahnhof
    IBNR{8002268}, // Gevelsberg West station
    IBNR{8002283}, // Haltepunkt Gladbeck Ost
    IBNR{8002284}, // Q19284709
    IBNR{8002286}, // Glan-Münchweiler station
    IBNR{8002288}, // Q800817
    IBNR{8002301}, // Göbelnrod station
    IBNR{8002304}, // Göhrde station
    IBNR{8002334}, // Q27478870
    IBNR{8002347}, // Grafing station
    IBNR{8002348}, // Grafing Stadt station
    IBNR{8002383}, // Gronsdorf
    IBNR{8002386}, // Q22692098
    IBNR{8002388}, // Groß Karben station
    IBNR{8002391}, // Q47093264
    IBNR{8002400}, // Q590724
    IBNR{8002409}, // Großen Buseck station
    IBNR{8002422}, // Grosshesselohe Isartal station
    IBNR{8002439}, // Grünberg station
    IBNR{8002461}, // Gütersloh Central Station
    IBNR{8002462}, // Gummersbach station
    IBNR{8002465}, // Q28656485
    IBNR{8002490}, // Haan station
    IBNR{8002512}, // Hagen-Heubing station
    IBNR{8002534}, // Hallbergmoos station
    IBNR{8002547}, // Hamburg Airport station
    IBNR{8002548}, // Hamburg Dammtor station
    IBNR{8002549}, // Hamburg Central Station
    IBNR{8002550}, // Holstenstrasse station
    IBNR{8002553}, // Hamburg-Altona station
    IBNR{8002554}, // Hamburg-Bergedorf station
    IBNR{8002555}, // Eidelstedt station
    IBNR{8002556}, // Fischbek station
    IBNR{8002560}, // Hamburg-Wandsbek station
    IBNR{8002561}, // Wilhelmsburg station
    IBNR{8002571}, // Hamminkeln railway station
    IBNR{8002572}, // Q510283
    IBNR{8002573}, // Hanau West station
    IBNR{8002574}, // Hanau-Wilhelmsbad station
    IBNR{8002575}, // Handeloh station
    IBNR{8002580}, // Hannover Bismarckstraße
    IBNR{8002585}, // Hannover-Leinhausen station
    IBNR{8002586}, // Hannover-Linden Train Station
    IBNR{8002588}, // Q19835113
    IBNR{8002598}, // Haren (Ems) station
    IBNR{8002615}, // Hasbergen
    IBNR{8002628}, // Hasselbrook station
    IBNR{8002635}, // Hattenheim station
    IBNR{8002637}, // Hattersheim am Main station
    IBNR{8002639}, // Hattingen (Ruhr) station
    IBNR{8002656}, // Q51507707
    IBNR{8002685}, // Heidelberg-Altstadt station
    IBNR{8002686}, // Heidelberg-Kirchheim/Rohrbach station
    IBNR{8002687}, // Q34064533
    IBNR{8002721}, // Heinsberg (Rheinland) station
    IBNR{8002753}, // Hennef (Sieg) station
    IBNR{8002757}, // Heppenheim station
    IBNR{8002762}, // Herblingen railway station
    IBNR{8002784}, // Station Herrath
    IBNR{8002785}, // Herrenberg station
    IBNR{8002792}, // Herrsching station
    IBNR{8002804}, // Herzogenrath-Alt-Merkstein station
    IBNR{8002806}, // Herzogenrath station
    IBNR{8002816}, // Herzogenrath August-Schmidt-Platz station
    IBNR{8002822}, // Heusenstamm station
    IBNR{8002828}, // Hilden Süd station
    IBNR{8002830}, // Hildesheim Ost station
    IBNR{8002841}, // Münster-Hiltrup station
    IBNR{8002857}, // Q15107186
    IBNR{8002868}, // Hochdahl station
    IBNR{8002869}, // Hochdahl-Millrath station
    IBNR{8002872}, // Hochheim station
    IBNR{8002875}, // Hochspeyer station
    IBNR{8002877}, // Maintal Ost station
    IBNR{8002883}, // Hockenheim station
    IBNR{8002884}, // Hodenhagen station
    IBNR{8002892}, // Höfingen station
    IBNR{8002894}, // Höhenkirchen-Siegertsbrunn station
    IBNR{8002899}, // Höllriegelskreuth station
    IBNR{8002919}, // Hösel station
    IBNR{8002924}, // Hof Central Station
    IBNR{8002927}, // Q800925
    IBNR{8002932}, // Q27842219
    IBNR{8002934}, // Q47093255
    IBNR{8002935}, // Hofheim (Taunus) station
    IBNR{8002941}, // Krefeld-Hohenbudberg Chempark station
    IBNR{8002953}, // Hohenlimburg station
    IBNR{8002967}, // Holm-Seppensen station
    IBNR{8002978}, // Holzhausen-Heddinghausen station
    IBNR{8002980}, // Holzkirchen station
    IBNR{8003016}, // Q15107193
    IBNR{8003036}, // Ibbenbüren station
    IBNR{8003040}, // Idar-Oberstein station
    IBNR{8003042}, // Q51064122
    IBNR{8003060}, // Q800944
    IBNR{8003076}, // Ingolstadt Nord station
    IBNR{8003092}, // Ismaning station
    IBNR{8003102}, // Itzehoe station
    IBNR{8003104}, // Bad Münstereifel-Iversheim station
    IBNR{8003125}, // Jockgrim station
    IBNR{8003129}, // Q15107198
    IBNR{8003135}, // Jünkerath station
    IBNR{8003137}, // Jungfernstieg
    IBNR{8003141}, // Q18616526
    IBNR{8003143}, // Q22691248
    IBNR{8003151}, // Bahnhof Kaiserslautern West
    IBNR{8003158}, // Q33216113
    IBNR{8003160}, // Hürth-Kalscheuren station
    IBNR{8003165}, // Langenhagen-Kaltenweide station
    IBNR{8003168}, // Kamen station
    IBNR{8003172}, // Q15107199
    IBNR{8003184}, // Karlsruhe-Durlach station
    IBNR{8003200}, // Kassel-Wilhelmshöhe station
    IBNR{8003214}, // Q37224165
    IBNR{8003218}, // Kehl station
    IBNR{8003228}, // Kelsterbach station
    IBNR{8003230}, // Q14550974
    IBNR{8003245}, // Kettwig Stausee station
    IBNR{8003252}, // Kierberg station
    IBNR{8003256}, // Kinding (Altmühltal) station
    IBNR{8003278}, // Kirchheim (Neckar) station
    IBNR{8003280}, // Bahnhof Kirchheim unter Teck
    IBNR{8003285}, // Q15792331
    IBNR{8003292}, // Kirchweyhe railway station
    IBNR{8003294}, // Kirkel station
    IBNR{8003311}, // Q800883
    IBNR{8003312}, // Klein Flottbek station
    IBNR{8003318}, // Q17521469
    IBNR{8003321}, // Kleinenbroich station
    IBNR{8003330}, // Cologne/Bonn Airport station
    IBNR{8003341}, // Koblenz Stadtmitte station
    IBNR{8003351}, // Koblenz-Ehrenbreitstein station
    IBNR{8003352}, // Koblenz-Lützel station
    IBNR{8003360}, // Köln Geldernstraße Parkgürtel station
    IBNR{8003361}, // Köln Süd station
    IBNR{8003363}, // Köln West station
    IBNR{8003364}, // Köln-Buchforst
    IBNR{8003365}, // Bahnhof Köln-Chorweiler
    IBNR{8003366}, // Köln-Chorweiler Nord station
    IBNR{8003367}, // Köln-Dellbrück station
    IBNR{8003368}, // Köln Messe/Deutz station
    IBNR{8003369}, // Köln-Holweide station
    IBNR{8003372}, // Köln-Nippes station
    IBNR{8003373}, // Köln-Worringen station
    IBNR{8003383}, // Köln-Weiden West station
    IBNR{8003386}, // Königswinter station
    IBNR{8003392}, // Köln Hansaring station
    IBNR{8003395}, // Kohlscheid railway station
    IBNR{8003400}, // Konstanz station
    IBNR{8003409}, // Korntal station
    IBNR{8003410}, // Kornweg station
    IBNR{8003411}, // Kornwestheim station
    IBNR{8003412}, // Korschenbroich station
    IBNR{8003426}, // Krefeld-Linn station
    IBNR{8003427}, // Krefeld-Uerdingen station
    IBNR{8003438}, // Kreuzstraße station
    IBNR{8003446}, // Kronach station
    IBNR{8003447}, // Q17122390
    IBNR{8003474}, // Kiel-Hassee CITTI-PARK station
    IBNR{8003476}, // Kulmbach station
    IBNR{8003481}, // Kusel station
    IBNR{8003486}, // Q800427
    IBNR{8003487}, // Hannover Messe/Laatzen station
    IBNR{8003489}, // Q22682010
    IBNR{8003491}, // Ibbenbüren-Laggenbeck station
    IBNR{8003494}, // Lahr (Schwarzw) station
    IBNR{8003497}, // Lambrecht (Pfalz) station
    IBNR{8003498}, // Q17353766
    IBNR{8003503}, // Q47035086
    IBNR{8003504}, // Q2657925
    IBNR{8003506}, // Q801055
    IBNR{8003512}, // Bahnhof (Landsberg am Lech)
    IBNR{8003514}, // Q55000745
    IBNR{8003515}, // Landstuhl station
    IBNR{8003522}, // Langelsheim station
    IBNR{8003523}, // Langen (Hess) station
    IBNR{8003528}, // Langenbach station
    IBNR{8003529}, // Velbert-Langenberg station
    IBNR{8003533}, // Bad Schönborn Süd station
    IBNR{8003539}, // Langenfeld-Berghausen station
    IBNR{8003540}, // Langenfeld station
    IBNR{8003541}, // Langenfelde station
    IBNR{8003542}, // Langenhagen Pferdemarkt station
    IBNR{8003545}, // Langenhagen Mitte station
    IBNR{8003550}, // Langenselbold station
    IBNR{8003553}, // Langerwehe station
    IBNR{8003554}, // Q41371728
    IBNR{8003575}, // Lauchringen station
    IBNR{8003591}, // Q15785185
    IBNR{8003592}, // Laupheim West station
    IBNR{8003616}, // Leichlingen station
    IBNR{8003622}, // Leinfelden station
    IBNR{8003640}, // Lengerich railway station
    IBNR{8003652}, // Leonberg station
    IBNR{8003658}, // Lette (Kr Coesfeld) station
    IBNR{8003671}, // Erftstadt station
    IBNR{8003673}, // Q801087
    IBNR{8003677}, // Q20754313
    IBNR{8003680}, // Limburg Süd station
    IBNR{8003687}, // Limburgerhof station
    IBNR{8003696}, // Lindenholzhausen station
    IBNR{8003697}, // Lindern station
    IBNR{8003700}, // Lindwedel station
    IBNR{8003701}, // Lingen (Ems) station
    IBNR{8003729}, // Lörrach Central Station
    IBNR{8003732}, // Köln-Lövenich station
    IBNR{8003735}, // Lohhof station
    IBNR{8003752}, // Q801119
    IBNR{8003755}, // Q25088577
    IBNR{8003759}, // Ludwigshafen (Rhein) Mitte station
    IBNR{8003760}, // Loxstedt station
    IBNR{8003762}, // Bahnhof (Löffingen)
    IBNR{8003765}, // Ludwigshafen-Mundenheim station
    IBNR{8003766}, // Bahnhof Ludwigshafen-Oggersheim
    IBNR{8003767}, // Q47093332
    IBNR{8003772}, // Q25089354
    IBNR{8003774}, // Lübeck-St. Jürgen railway station
    IBNR{8003777}, // Lübeck-Travemünde Hafen station
    IBNR{8003778}, // Lübeck-Travemünde Strand station
    IBNR{8003781}, // Lübeck-Flughafen station
    IBNR{8003782}, // Lüdenscheid station
    IBNR{8003784}, // Lörrach-Stetten
    IBNR{8003796}, // Luisenthal
    IBNR{8003816}, // Mainz Römisches Theater station
    IBNR{8003818}, // Mainz-Gustavsburg station
    IBNR{8003831}, // Malmsheim station
    IBNR{8003832}, // Malsch station
    IBNR{8003841}, // Q26791758
    IBNR{8003842}, // Q47035195
    IBNR{8003843}, // Q15107221
    IBNR{8003844}, // Q27996618
    IBNR{8003845}, // Q11767120
    IBNR{8003847}, // Q47035165
    IBNR{8003848}, // Q47004109
    IBNR{8003853}, // Marbach (Neckar) station
    IBNR{8003855}, // Q19971789
    IBNR{8003879}, // Markt Schwaben station
    IBNR{8003888}, // Marl Mitte station
    IBNR{8003890}, // Marl-Hamm station
    IBNR{8003891}, // Marl-Sinsen station
    IBNR{8003893}, // Q801162
    IBNR{8003903}, // Marxgrün station
    IBNR{8003922}, // Q42871736
    IBNR{8003932}, // Meckesheim station
    IBNR{8003950}, // Q15648785
    IBNR{8003957}, // Mellendorf station
    IBNR{8003959}, // Mellrichstadt station
    IBNR{8003967}, // Menden (Sauerland) station
    IBNR{8003982}, // Mering station
    IBNR{8003992}, // Merzig (Saar) station
    IBNR{8003996}, // Q801175
    IBNR{8004005}, // Mettmann Stadtwald station
    IBNR{8004007}, // Q54801974
    IBNR{8004009}, // Metzingen (Württemberg) station
    IBNR{8004017}, // Q28131570
    IBNR{8004032}, // Bad Schönborn-Kronau station
    IBNR{8004057}, // Mölln (Lauenburg) station
    IBNR{8004063}, // Q19274497
    IBNR{8004094}, // Mosbach (Baden) station
    IBNR{8004100}, // Mücke (Hesse) station
    IBNR{8004112}, // Mühlheim station
    IBNR{8004122}, // Mülheim West station
    IBNR{8004124}, // Müllheim (Baden) station
    IBNR{8004126}, // Q18018567
    IBNR{8004127}, // Q47037433
    IBNR{8004128}, // München Donnersbergerbrücke station
    IBNR{8004129}, // München Hackerbrücke station
    IBNR{8004130}, // München Harras station
    IBNR{8004131}, // München Isartor station
    IBNR{8004132}, // München Karlsplatz station
    IBNR{8004133}, // Munich Leienfelsstraße station
    IBNR{8004134}, // München-Leuchtenbergring station
    IBNR{8004135}, // München Marienplatz station
    IBNR{8004136}, // München Rosenheimer Platz station
    IBNR{8004137}, // Munich Siemenswerke station
    IBNR{8004138}, // München-St.-Martin-Strasse station
    IBNR{8004139}, // Munich Untermenzing station
    IBNR{8004140}, // Allach station
    IBNR{8004141}, // Q11787837
    IBNR{8004142}, // München-Berg am Laim station
    IBNR{8004143}, // München Daglfing station
    IBNR{8004144}, // München Englschalking station
    IBNR{8004145}, // Munich Fasanerie station
    IBNR{8004146}, // München-Fasangarten station
    IBNR{8004147}, // München-Feldmoching station
    IBNR{8004148}, // München-Giesing station
    IBNR{8004149}, // Munich-Johanneskirchen station
    IBNR{8004150}, // Karlsfeld station
    IBNR{8004151}, // München-Laim station
    IBNR{8004152}, // Q11787835
    IBNR{8004154}, // München Mittersendling station
    IBNR{8004155}, // München Moosach station
    IBNR{8004157}, // München-Obermenzing
    IBNR{8004158}, // Munich Pasing station
    IBNR{8004160}, // München-Riem station
    IBNR{8004161}, // Munich Solln station
    IBNR{8004162}, // München Trudering station
    IBNR{8004163}, // Munich-Westkreuz station
    IBNR{8004167}, // Munich Airport Besucherpark station
    IBNR{8004168}, // Munich Airport Terminal station
    IBNR{8004177}, // Müssen railway station
    IBNR{8004179}, // München Hirschgarten station
    IBNR{8004181}, // Q14948586
    IBNR{8004185}, // Q15107232
    IBNR{8004196}, // Q16830552
    IBNR{8004204}, // Mammendorf station
    IBNR{8004213}, // Neanderthal station
    IBNR{8004219}, // Q15785188
    IBNR{8004220}, // Q29370439
    IBNR{8004228}, // Q21035442
    IBNR{8004239}, // Nersingen station
    IBNR{8004246}, // Neu-Isenburg station
    IBNR{8004252}, // Neubiberg
    IBNR{8004253}, // Neubrücke (Nahe) station
    IBNR{8004257}, // Q18005407
    IBNR{8004266}, // Hammerbrook station
    IBNR{8004267}, // Hamburg-Harburg Rathaus
    IBNR{8004279}, // Neufahrn bei Freising station
    IBNR{8004304}, // Neulußheim station
    IBNR{8004305}, // Neumarkt (Oberpfalz) station
    IBNR{8004310}, // Bahnhof Neunkirchen a Sand
    IBNR{8004320}, // Neuss Am Kaiser station
    IBNR{8004331}, // Neustadt (Schwarzwald) station
    IBNR{8004338}, // Stuttgart Neuwirtshaus station
    IBNR{8004340}, // Velbert-Neviges station
    IBNR{8004343}, // Niebüll railway station
    IBNR{8004350}, // Q801212
    IBNR{8004357}, // Stuttgart Nürnberger Straße station
    IBNR{8004364}, // Niederbrechen station
    IBNR{8004366}, // Niederdollendorf station
    IBNR{8004380}, // Niederhöchstadt station
    IBNR{8004393}, // Mendig station
    IBNR{8004400}, // Niedernhausen station
    IBNR{8004404}, // Niederroth station
    IBNR{8004409}, // Niederselters station
    IBNR{8004417}, // Niederwalgern station
    IBNR{8004419}, // Dortmund University station
    IBNR{8004429}, // Frankfurt Konstablerwache station
    IBNR{8004430}, // Velbert-Nierenhof station
    IBNR{8004441}, // Nörten-Hardenberg station
    IBNR{8004442}, // Nürnberg-Dürrenhof station
    IBNR{8004462}, // Norf station
    IBNR{8004469}, // Nürnberg Nordost station
    IBNR{8004470}, // Nürnberg-Ostring station
    IBNR{8004471}, // Q11794306
    IBNR{8004473}, // Q37380930
    IBNR{8004476}, // Q37224173
    IBNR{8004477}, // Q11794301
    IBNR{8004478}, // Q37224169
    IBNR{8004480}, // Q37224162
    IBNR{8004481}, // Nürnberg-Mögeldorf station
    IBNR{8004483}, // Q37380914
    IBNR{8004484}, // Q11794302
    IBNR{8004485}, // Q37380916
    IBNR{8004486}, // Nürnberg-Stein station
    IBNR{8004487}, // Q11794304
    IBNR{8004488}, // Nürtingen station
    IBNR{8004491}, // Nürnberg-Rehhof railway station
    IBNR{8004493}, // Q37224161
    IBNR{8004496}, // Oberaichen station
    IBNR{8004518}, // Oberbrechen station
    IBNR{8004540}, // Oberhausen-Holten station
    IBNR{8004541}, // Oberhausen-Osterfeld Süd station
    IBNR{8004542}, // Oberhausen-Sterkrade station
    IBNR{8004550}, // Oberlahnstein station
    IBNR{8004580}, // Train station Oberschleißheim
    IBNR{8004584}, // Q28661170
    IBNR{8004585}, // Oberstdorf station
    IBNR{8004596}, // Oberursel station
    IBNR{8004601}, // Oberwesel station
    IBNR{8004623}, // Öhringen Central Station
    IBNR{8004645}, // Offenbach Ost station
    IBNR{8004647}, // Offenbach-Bieber station
    IBNR{8004661}, // Ohlsdorf
    IBNR{8004670}, // Oldenburg-Wechloy railway station
    IBNR{8004677}, // Q15107260
    IBNR{8004680}, // Bahnhof Oppenheim
    IBNR{8004689}, // Osnabrück Altstadt station
    IBNR{8004694}, // Meerbusch-Osterath station
    IBNR{8004720}, // Ottbergen station
    IBNR{8004733}, // Ottobrunn station
    IBNR{8004739}, // Bahnhof Overath
    IBNR{8004762}, // Bahnhof Peißenberg
    IBNR{8004771}, // Perl railway station
    IBNR{8004775}, // Petershausen station
    IBNR{8004788}, // Q801314
    IBNR{8004806}, // Q47535836
    IBNR{8004819}, // Pinneberg station
    IBNR{8004822}, // Pirmasens Central Station
    IBNR{8004835}, // Pleinfeld train station
    IBNR{8004862}, // Poppenbüttel station
    IBNR{8004868}, // Porta Westfalica railway station
    IBNR{8004875}, // Postbauer-Heng station
    IBNR{8004885}, // Prien am Chiemsee station
    IBNR{8004898}, // Pulheim station
    IBNR{8004899}, // Pullach station
    IBNR{8004900}, // Pulling station
    IBNR{8004907}, // Q14506318
    IBNR{8004919}, // Rahden (Kreis Minden-Lübbecke) station
    IBNR{8004929}, // Q15107280
    IBNR{8004933}, // Q41372018
    IBNR{8004948}, // Ratingen Ost station
    IBNR{8004962}, // Raunheim station
    IBNR{8004983}, // Regensburg-Prüfening station
    IBNR{8004993}, // Q15107282
    IBNR{8004994}, // Q37380928
    IBNR{8005020}, // Reinheim railway station
    IBNR{8005031}, // Essen-Borbeck Süd station
    IBNR{8005033}, // Remscheid Central Station
    IBNR{8005034}, // Remscheid-Güldenwerth station
    IBNR{8005035}, // Remscheid-Lüttringhausen station
    IBNR{8005055}, // Q19965709
    IBNR{8005059}, // Q19274531
    IBNR{8005065}, // Rheinhausen Ost station
    IBNR{8005069}, // Rheinzabern station
    IBNR{8005073}, // Rheydt-Odenkirchen station
    IBNR{8005074}, // Rhöndorf station
    IBNR{8005086}, // Q15107284
    IBNR{8005087}, // Q22691254
    IBNR{8005090}, // Q27478896
    IBNR{8005103}, // Q28595256
    IBNR{8005104}, // Rinteln station
    IBNR{8005134}, // Q24706440
    IBNR{8005138}, // Röthenbach (Allgäu) railway station
    IBNR{8005146}, // Rohrbach Station
    IBNR{8005153}, // Rolandseck station
    IBNR{8005163}, // Rosbach vor der Höhe station
    IBNR{8005198}, // Q47004071
    IBNR{8005207}, // Rübenkamp station
    IBNR{8005213}, // Rüdesheim (Rhein) station
    IBNR{8005217}, // Rülzheim station
    IBNR{8005220}, // Rüsselsheim station
    IBNR{8005225}, // Bahnhof Rumeln
    IBNR{8005241}, // Saarbrücken-Ost station
    IBNR{8005247}, // Saarlouis Central Station
    IBNR{8005252}, // Rheinfelden railway station
    IBNR{8005253}, // Q801390
    IBNR{8005261}, // Bad Soden-Salmünster station
    IBNR{8005264}, // Einbeck-Salzderhelden station
    IBNR{8005265}, // Salzgitter-Bad station
    IBNR{8005291}, // Q801398
    IBNR{8005316}, // Schalksmühle station
    IBNR{8005330}, // Scheeßel railway station
    IBNR{8005336}, // Scherfede station
    IBNR{8005350}, // Q30303373
    IBNR{8005356}, // Schladern station
    IBNR{8005362}, // Schleswig station
    IBNR{8005367}, // Q801409
    IBNR{8005390}, // Schneverdingen station
    IBNR{8005417}, // Bahnhof Schondorf (Bay)
    IBNR{8005418}, // Bahnhof Schongau
    IBNR{8005419}, // München-Heimeranplatz station
    IBNR{8005423}, // Schopp station
    IBNR{8005424}, // Schorndorf station
    IBNR{8005449}, // Schwäbisch Hall station
    IBNR{8005454}, // Schwaikheim station
    IBNR{8005457}, // Schwarmstedt station
    IBNR{8005468}, // Schwarzenbek railway station
    IBNR{8005481}, // Schweinfurt Stadt station
    IBNR{8005490}, // Schwenningen
    IBNR{8005499}, // Q27478729
    IBNR{8005502}, // Q23787942
    IBNR{8005556}, // Siegburg/Bonn station
    IBNR{8005572}, // Bahnhof Simmelsdorf-Hüttenbach
    IBNR{8005578}, // Sinsheim Central Station
    IBNR{8005583}, // Bad Sobernheim station
    IBNR{8005590}, // Bahnhof Solingen-Schaberg
    IBNR{8005593}, // Q41372246
    IBNR{8005594}, // Soltau (Han) Nord station
    IBNR{8005597}, // Q18625061
    IBNR{8005598}, // Solingen Mitte station
    IBNR{8005602}, // Sondernheim station
    IBNR{8005616}, // Spaichingen station
    IBNR{8005628}, // Speyer Central Station
    IBNR{8005644}, // St. Georgen station
    IBNR{8005649}, // Sankt Ingbert station
    IBNR{8005656}, // Q15785204
    IBNR{8005659}, // St. Wendel station
    IBNR{8005661}, // Stadtallendorf station
    IBNR{8005668}, // Staffel station
    IBNR{8005674}, // Q26821640
    IBNR{8005678}, // Staudernheim station
    IBNR{8005706}, // Steinheim (Main) station
    IBNR{8005709}, // Steinhöring Station
    IBNR{8005714}, // Q30248297
    IBNR{8005741}, // Q153200
    IBNR{8005746}, // Stommeln station
    IBNR{8005748}, // Euskirchen-Stotzheim station
    IBNR{8005766}, // Schwetzingen train station
    IBNR{8005767}, // Stuttgart North station
    IBNR{8005768}, // Stuttgart Flughafen/Messe station
    IBNR{8005769}, // Stuttgart-Bad Cannstatt station
    IBNR{8005770}, // Stuttgart-Feuerbach station
    IBNR{8005771}, // Q801475
    IBNR{8005772}, // Stuttgart-Obertürkheim station
    IBNR{8005773}, // Stuttgart-Rohr station
    IBNR{8005775}, // Stuttgart-Untertürkheim station
    IBNR{8005776}, // Stuttgart-Vaihingen station
    IBNR{8005778}, // Stuttgart-Zuffenhausen station
    IBNR{8005779}, // Stuttgart Österfeld station
    IBNR{8005788}, // Suerhop station
    IBNR{8005790}, // Süßen station
    IBNR{8005796}, // Sulzbach (Saar) station
    IBNR{8005809}, // Q28859934
    IBNR{8005820}, // Tamm (Württemberg) station
    IBNR{8005823}, // Q801508
    IBNR{8005856}, // Thayngen railway station
    IBNR{8005857}, // Q15107299
    IBNR{8005876}, // Bahnhof Titisee
    IBNR{8005907}, // Q801526
    IBNR{8005910}, // Q1852663
    IBNR{8005911}, // Trossingen station
    IBNR{8005916}, // Tübingen West station
    IBNR{8005927}, // Tutzing station
    IBNR{8005929}, // Twistringen station
    IBNR{8005935}, // Übach-Palenberg station
    IBNR{8005937}, // Q49892242
    IBNR{8005940}, // Übersee station
    IBNR{8005970}, // Unkel station
    IBNR{8005986}, // Unterföhring station
    IBNR{8005990}, // Untergrombach station
    IBNR{8006053}, // Vaihingen (Enz) station
    IBNR{8006056}, // Varel railway station
    IBNR{8006064}, // Velbert-Rosenhügel station
    IBNR{8006065}, // Veitshöchheim station
    IBNR{8006076}, // Verden (Aller) railway station
    IBNR{8006085}, // Stuttgart Stadtmitte station
    IBNR{8006089}, // Hannover-Vinnhorst station
    IBNR{8006090}, // Visselhövede station
    IBNR{8006091}, // Vlotho station
    IBNR{8006098}, // Q19274532
    IBNR{8006132}, // Wächtersbach station
    IBNR{8006137}, // Bahnhof Waghäusel
    IBNR{8006141}, // Q801571
    IBNR{8006163}, // Q801573
    IBNR{8006167}, // Waldshut station
    IBNR{8006175}, // Q47004091
    IBNR{8006176}, // Q15792337
    IBNR{8006193}, // Walsrode station
    IBNR{8006194}, // Essen-Horst station
    IBNR{8006198}, // Hamburg Wandsbeker Chaussee station
    IBNR{8006200}, // Q27478957
    IBNR{8006216}, // Tiengen station
    IBNR{8006226}, // Wattenscheid station
    IBNR{8006227}, // Wattenscheid-Höntrop station
    IBNR{8006236}, // Wedel station
    IBNR{8006243}, // Wegberg
    IBNR{8006261}, // Weidenthal station
    IBNR{8006268}, // Stuttgart-Weilimdorf station
    IBNR{8006271}, // Weil der Stadt station
    IBNR{8006272}, // Weil am Rhein
    IBNR{8006292}, // Q17354278
    IBNR{8006298}, // Q26714912
    IBNR{8006306}, // Q801589
    IBNR{8006319}, // Wellingsbüttel station
    IBNR{8006323}, // Welver station
    IBNR{8006331}, // Wendlingen (Neckar) station
    IBNR{8006339}, // Werdohl station
    IBNR{8006369}, // Westerland (Sylt) station
    IBNR{8006386}, // Wetter (Ruhr) station
    IBNR{8006391}, // Q43202950
    IBNR{8006404}, // Wiesbaden Ost station
    IBNR{8006408}, // Bahnhof Wiesbaden-Igstadt
    IBNR{8006421}, // Wiesloch-Walldorf station
    IBNR{8006445}, // Wilhelmshaven railway station
    IBNR{8006449}, // Q16054534
    IBNR{8006460}, // Q30340466
    IBNR{8006468}, // Winden (Pfalz) station
    IBNR{8006479}, // Q28025261
    IBNR{8006489}, // Wintermoor station
    IBNR{8006508}, // Q11767119
    IBNR{8006509}, // Q47035089
    IBNR{8006510}, // Witten-Annen Nord station
    IBNR{8006511}, // Q47035084
    IBNR{8006513}, // Stuttgart University station
    IBNR{8006514}, // Essen-Holthausen station
    IBNR{8006516}, // Witterschlick
    IBNR{8006534}, // Q19835127
    IBNR{8006550}, // Wolfratshausen station
    IBNR{8006552}, // Wolfsburg Central Station
    IBNR{8006555}, // Bahnhof Wolfstein
    IBNR{8006559}, // Wolterdingen (Han) station
    IBNR{8006572}, // Wrist station
    IBNR{8006575}, // Wülfrath-Aprath station
    IBNR{8006590}, // Q801630
    IBNR{8006596}, // Wuppertal-Barmen station
    IBNR{8006616}, // Wuppertal-Ronsdorf station
    IBNR{8006619}, // Wuppertal-Steinbeck station
    IBNR{8006620}, // Wuppertal-Unterbarmen station
    IBNR{8006623}, // Wuppertal Zoologischer Garten station
    IBNR{8006630}, // Q21035431
    IBNR{8006648}, // Zeppelinheim station
    IBNR{8006674}, // Zülpich
    IBNR{8006680}, // Zweibrücken Central Station
    IBNR{8006684}, // Zwiesel station
    IBNR{8006687}, // Zwingenberg (Bergstraße) station
    IBNR{8006688}, // Unterschleißheim station
    IBNR{8006690}, // Frankfurt Galluswarte station
    IBNR{8006691}, // Frankfurt Taunusanlage station
    IBNR{8006692}, // Frankfurt Hauptwache station
    IBNR{8006696}, // München Neuperlach Süd station
    IBNR{8006698}, // Stuttgart Schwabstraße station
    IBNR{8006699}, // Stuttgart Feuersee station
    IBNR{8006707}, // Q51607009
    IBNR{8006709}, // Dorsten station
    IBNR{8006713}, // Leverkusen Mitte station
    IBNR{8006714}, // Q19965785
    IBNR{8006718}, // Wuppertal-Vohwinkel station
    IBNR{8006719}, // Wuppertal-Oberbarmen station
    IBNR{8006730}, // Neu-Ulm station
    IBNR{8006743}, // Stuttgart Neckarpark station
    IBNR{8006988}, // Zell (Wiesental station)
    IBNR{8007011}, // Q800423
    IBNR{8007138}, // Odenheim train station
    IBNR{8007160}, // Q22677939
    IBNR{8007161}, // Kelkheim station
    IBNR{8007445}, // Aglasterhausen station
    IBNR{8007631}, // Q800824
    IBNR{8007632}, // Q27478934
    IBNR{8007768}, // Norddeich Mole railway station
    IBNR{8007851}, // Bahnhof Saalburg
    IBNR{8007859}, // Q28475391
    IBNR{8010001}, // Adorf (Vogtl) station
    IBNR{8010003}, // Altenburg station
    IBNR{8010004}, // Angermünde railway station
    IBNR{8010005}, // Q50333444
    IBNR{8010006}, // Arnsdorf (bei Dresden) railway station
    IBNR{8010007}, // Arnstadt Central Station
    IBNR{8010010}, // Q800408
    IBNR{8010013}, // Bahnhof Baalberge
    IBNR{8010014}, // Q25089975
    IBNR{8010016}, // Bad Doberan railway station
    IBNR{8010017}, // Bahnhof Bad Freienwalde (Oder)
    IBNR{8010018}, // Bad Kleinen station
    IBNR{8010021}, // Bad Salzungen station
    IBNR{8010022}, // Bad Schandau railway station
    IBNR{8010026}, // Bautzen railway station
    IBNR{8010029}, // Beeskow station
    IBNR{8010031}, // Q22691241
    IBNR{8010032}, // Berga-Kelbra station
    IBNR{8010033}, // Bergen auf Rügen railway station
    IBNR{8010035}, // Berlin-Karlshorst station
    IBNR{8010036}, // Berlin-Lichtenberg station
    IBNR{8010041}, // Berlin-Schöneweide station
    IBNR{8010043}, // Q23933722
    IBNR{8010049}, // Bischofswerda railway station
    IBNR{8010050}, // Bitterfeld station
    IBNR{8010051}, // Blankenberg (Meckl) railway station
    IBNR{8010053}, // Blankenfelde station
    IBNR{8010060}, // Brandenburg Central Station
    IBNR{8010066}, // Bützow station
    IBNR{8010070}, // Q28119428
    IBNR{8010071}, // Q30274649
    IBNR{8010072}, // Coswig (b Dresden) station
    IBNR{8010073}, // Cottbus station
    IBNR{8010074}, // Cranzahl station
    IBNR{8010076}, // Delitzsch unterer station
    IBNR{8010077}, // Dessau Central Station
    IBNR{8010080}, // Döbeln Central Station
    IBNR{8010085}, // Dresden Central Station
    IBNR{8010088}, // Dresden-Klotzsche railway station
    IBNR{8010089}, // Dresden-Neustadt station
    IBNR{8010091}, // Dürrröhrsdorf station
    IBNR{8010092}, // Ebersbach (Sachs) station
    IBNR{8010093}, // Eberswalde Central Station
    IBNR{8010094}, // Eibau station
    IBNR{8010095}, // Eilenburg station
    IBNR{8010097}, // Eisenach station
    IBNR{8010099}, // Elsterwerda railway station
    IBNR{8010100}, // Elsterwerda-Biehla station
    IBNR{8010101}, // Erfurt Central Station
    IBNR{8010103}, // Falkenberg (Elster) station
    IBNR{8010106}, // Falkenstein (Vogtl) Station
    IBNR{8010109}, // Berlin Schönefeld Flughafen station
    IBNR{8010110}, // Haltepunkt Förtha
    IBNR{8010111}, // Forst (Lausitz)
    IBNR{8010113}, // Frankfurt (Oder) railway station
    IBNR{8010115}, // Freiberg (Sachs) station
    IBNR{8010118}, // Fröttstädt station
    IBNR{8010120}, // Fürstenwalde (Spree)
    IBNR{8010122}, // Geithain station
    IBNR{8010125}, // Gera Hauptbahnhof
    IBNR{8010127}, // Q16830549
    IBNR{8010129}, // Glauchau (Sachs)
    IBNR{8010131}, // Görlitz station
    IBNR{8010133}, // Jena-Göschwitz station
    IBNR{8010134}, // Gößnitz station
    IBNR{8010136}, // Gotha station
    IBNR{8010139}, // Greifswald railway station
    IBNR{8010140}, // Greiz station
    IBNR{8010141}, // Grevesmühlen railway station
    IBNR{8010145}, // Q43109306
    IBNR{8010153}, // Güstrow railway station
    IBNR{8010154}, // Güterglück railway station
    IBNR{8010156}, // Hagenow Land railway station
    IBNR{8010157}, // Halberstadt station
    IBNR{8010159}, // Halle Central Station
    IBNR{8010161}, // Bahnhof Eilenburg Ost
    IBNR{8010163}, // Heidenau railway station
    IBNR{8010166}, // Herlasgrün station
    IBNR{8010167}, // Q30106124
    IBNR{8010171}, // Hosena station
    IBNR{8010173}, // Holthusen railway station
    IBNR{8010174}, // Q15107192
    IBNR{8010175}, // Q2657942
    IBNR{8010176}, // Hornstorf railway station
    IBNR{8010177}, // Hoyerswerda railway station
    IBNR{8010178}, // Ilmenau station
    IBNR{8010179}, // Jatznick railway station
    IBNR{8010182}, // Jüterbog station
    IBNR{8010184}, // Chemnitz Hauptbahnhof
    IBNR{8010185}, // Chemnitz Süd station
    IBNR{8010188}, // Karow (Meckl) railway station
    IBNR{8010189}, // Küstrin-Kietz station
    IBNR{8010193}, // Königs Wusterhausen station
    IBNR{8010195}, // Köthen railway station
    IBNR{8010199}, // Lalendorf station
    IBNR{8010201}, // Langhagen railway station
    IBNR{8010203}, // Leinefelde station
    IBNR{8010205}, // Leipzig Hauptbahnhof
    IBNR{8010207}, // Leipzig-Leutzsch railway station
    IBNR{8010209}, // Leipzig-Plagwitz railway station
    IBNR{8010210}, // Lietzow railway station
    IBNR{8010212}, // Löbau (Sachs) railway station
    IBNR{8010213}, // Löcknitz railway station
    IBNR{8010214}, // Löwenberg (Mark) railway station
    IBNR{8010215}, // Ludwigsfelde railway station
    IBNR{8010216}, // Ludwigslust railway station
    IBNR{8010217}, // Lübben (Spreewald) station
    IBNR{8010220}, // Lübbenau railway station
    IBNR{8010222}, // Lutherstadt Wittenberg railway station
    IBNR{8010224}, // Magdeburg Central Station
    IBNR{8010227}, // Malchin railway station
    IBNR{8010229}, // Mehltheuer railway station
    IBNR{8010230}, // Meiningen station
    IBNR{8010232}, // Merseburg railway station
    IBNR{8010233}, // Michendorf station
    IBNR{8010235}, // Mühlhausen (Thür) station
    IBNR{8010236}, // Müncheberg
    IBNR{8010238}, // Bahnhof Narsdorf
    IBNR{8010240}, // Naumburg (Saale) Hauptbahnhof
    IBNR{8010241}, // Neubrandenburg railway station
    IBNR{8010242}, // Neudietendorf station
    IBNR{8010243}, // Neukieritzsch station
    IBNR{8010244}, // Q43161681
    IBNR{8010245}, // Q801244
    IBNR{8010246}, // Q2657942
    IBNR{8010248}, // Q19835119
    IBNR{8010249}, // Neustadt (Sachs) railway station
    IBNR{8010250}, // Neustrelitz Central Station
    IBNR{8010255}, // Berlin Ostbahnhof
    IBNR{8010256}, // Nordhausen station
    IBNR{8010258}, // Nossen station
    IBNR{8010259}, // Oberoderwitz station
    IBNR{8010261}, // Oebisfelde railway station
    IBNR{8010264}, // Q47004054
    IBNR{8010266}, // Oschersleben
    IBNR{8010267}, // Parchim railway station
    IBNR{8010268}, // Pasewalk railway station
    IBNR{8010272}, // Pirna railway station
    IBNR{8010273}, // Plaaz railway station
    IBNR{8010274}, // Plaue station
    IBNR{8010275}, // Plauen (Vogtland) Oberer Bahnhof
    IBNR{8010277}, // Pockau-Lengefeld station
    IBNR{8010279}, // Potsdam Pirschheide station
    IBNR{8010280}, // Potsdam Charlottenhof railway station
    IBNR{8010282}, // Prenzlau railway station
    IBNR{8010284}, // Priemerburg railway station
    IBNR{8010285}, // Priestewitz station
    IBNR{8010287}, // Pritzwalk station
    IBNR{8010288}, // Probstzella station
    IBNR{8010290}, // Quedlinburg station
    IBNR{8010292}, // Radebeul Ost station
    IBNR{8010293}, // Radebeul-Kötzschenbroda station
    IBNR{8010296}, // Rathenow railway station
    IBNR{8010297}, // Riesa railway station
    IBNR{8010300}, // Rövershagen railway station
    IBNR{8010302}, // Roßlau (Elbe) station
    IBNR{8010304}, // Rostock Central Station
    IBNR{8010306}, // Q50300514
    IBNR{8010308}, // Ruhland station
    IBNR{8010309}, // Saalfeld station
    IBNR{8010310}, // Salzwedel station
    IBNR{8010311}, // Sandersleben (Anh) station
    IBNR{8010312}, // Sangerhausen station
    IBNR{8010315}, // Q801412
    IBNR{8010317}, // Q50714432
    IBNR{8010322}, // Schwaan railway station
    IBNR{8010323}, // Bahnhof Schwarzenberg (Erzgeb)
    IBNR{8010324}, // Schwerin Central Station
    IBNR{8010325}, // Schwerin-Görries railway station
    IBNR{8010327}, // Senftenberg station
    IBNR{8010328}, // Sömmerda station
    IBNR{8010334}, // Stendal station
    IBNR{8010338}, // Stralsund Central Station
    IBNR{8010339}, // Strasburg (Uckerm) railway station
    IBNR{8010341}, // Strausberg station
    IBNR{8010347}, // Templin Railway Station
    IBNR{8010348}, // Teterow railway station
    IBNR{8010353}, // Luckau-Uckro railway station
    IBNR{8010355}, // Velgast station
    IBNR{8010357}, // Guben station
    IBNR{8010359}, // Q55000746
    IBNR{8010361}, // Waren (Müritz) railway station
    IBNR{8010366}, // Weimar station
    IBNR{8010367}, // Weischlitz railway station
    IBNR{8010368}, // Weißenfels station
    IBNR{8010371}, // Werbig station
    IBNR{8010372}, // Werdau station
    IBNR{8010376}, // Q18018576
    IBNR{8010377}, // Potsdam Park Sanssouci railway station
    IBNR{8010379}, // Q801613
    IBNR{8010381}, // Wismar railway station
    IBNR{8010382}, // Wittenberge station
    IBNR{8010386}, // Wriezen station
    IBNR{8010388}, // Wüstenbrand station
    IBNR{8010389}, // Wustermark railway station
    IBNR{8010390}, // Zeitz station
    IBNR{8010392}, // Zinnowitz railway station
    IBNR{8010393}, // Zittau railway station
    IBNR{8010396}, // Züssow railway station
    IBNR{8010397}, // Zwickau Hauptbahnhof
    IBNR{8010398}, // Q801672
    IBNR{8010399}, // Fürstenberg (Havel) railway station
    IBNR{8010400}, // Neukirch West railway station
    IBNR{8010401}, // Putbus railway station
    IBNR{8010403}, // Berlin-Charlottenburg station
    IBNR{8010404}, // Berlin-Spandau station
    IBNR{8010405}, // Berlin-Wannsee station
    IBNR{8010406}, // Berlin Zoologischer Garten railway station
    IBNR{8011003}, // Ahrensfelde station
    IBNR{8011004}, // Ahrensfelde Friedhof station
    IBNR{8011014}, // Alt Rosenthal station
    IBNR{8011017}, // Altefähr railway station
    IBNR{8011025}, // Altentreptow railway station
    IBNR{8011027}, // Altenwillershagen railway station
    IBNR{8011031}, // Althof railway station
    IBNR{8011034}, // Bahnhof Altranft
    IBNR{8011041}, // Berlin-Lichterfelde Ost station
    IBNR{8011044}, // Anklam railway station
    IBNR{8011046}, // Berlin-Karow station
    IBNR{8011047}, // Annaberg-Buchholz unterer Bahnhof
    IBNR{8011051}, // Apolda station
    IBNR{8011058}, // Jena Saalbahnhof
    IBNR{8011063}, // Baabe railway station
    IBNR{8011066}, // Q29043546
    IBNR{8011069}, // Bad Doberan Goethestraße railway station
    IBNR{8011079}, // Bad Saarow station
    IBNR{8011102}, // Berlin-Gesundbrunnen station
    IBNR{8011108}, // Bannemin-Mölschow railway station
    IBNR{8011109}, // Bansin Seebad railway station
    IBNR{8011113}, // Berlin Südkreuz
    IBNR{8011114}, // Barth railway station
    IBNR{8011118}, // Berlin Potsdamer Platz station
    IBNR{8011140}, // Bentwisch railway station
    IBNR{8011155}, // Berlin Alexanderplatz station
    IBNR{8011160}, // Berlin Hauptbahnhof
    IBNR{8011162}, // Ostkreuz
    IBNR{8011167}, // Berlin Jungfernheide station
    IBNR{8011168}, // Q28656480
    IBNR{8011191}, // Ostseebad Binz railway station
    IBNR{8011193}, // Binz LB railway station
    IBNR{8011201}, // Berlin Brandenburg Airport railway station
    IBNR{8011205}, // Blankensee (Meckl) railway station
    IBNR{8011213}, // Blumenhagen
    IBNR{8011214}, // Bahnhof Blumenthal (Mark)
    IBNR{8011215}, // Bobitz railway station
    IBNR{8011230}, // Boizenburg (Elbe) railway station
    IBNR{8011248}, // Brahlstorf railway station
    IBNR{8011252}, // Q18616521
    IBNR{8011270}, // Broderstorf railway station
    IBNR{8011281}, // Buchenhorst railway station
    IBNR{8011286}, // Buddenhagen railway station
    IBNR{8011293}, // Burg Stargard (Meckl) railway station
    IBNR{8011294}, // Burg (bei Magdeburg) station
    IBNR{8011304}, // Q39214267
    IBNR{8011306}, // Berlin-Friedrichstraße railway station
    IBNR{8011307}, // Cammin (Meckl) railway station
    IBNR{8011311}, // Casekow station
    IBNR{8011325}, // Crimmitschau station
    IBNR{8011326}, // Crivitz railway station
    IBNR{8011356}, // Demmin railway station
    IBNR{8011399}, // Dresden Flughafen railway station
    IBNR{8011403}, // Domsühl railway station
    IBNR{8011430}, // Potsdam Medienstadt Babelsberg station
    IBNR{8011431}, // Dresden Freiberger Straße station
    IBNR{8011438}, // Ducherow railway station
    IBNR{8011442}, // Dütschow railway station
    IBNR{8011456}, // Eggesin railway station
    IBNR{8011468}, // Eisenach West station
    IBNR{8011481}, // Elmenhorst railway station
    IBNR{8011491}, // Leipzig-Engelsdorf station
    IBNR{8011523}, // Rostock-Evershagen railway station
    IBNR{8011536}, // Ferdinandshof railway station
    IBNR{8011542}, // Finsterwalde (Niederlausitz) station
    IBNR{8011559}, // Frankfurt (Oder)-Rosengarten
    IBNR{8011573}, // Q25089303
    IBNR{8011582}, // Friedrichsruhe (Meckl) railway station
    IBNR{8011588}, // Bahnhof Frohburg
    IBNR{8011591}, // Fürstenwalde
    IBNR{8011592}, // Gadebusch railway station
    IBNR{8011597}, // Garftitz railway station
    IBNR{8011611}, // Gelbensande railway station
    IBNR{8011620}, // Gera-Liebschwitz train station
    IBNR{8011629}, // Gerstungen station
    IBNR{8011641}, // Glöwen station
    IBNR{8011646}, // Gnevkow railway station
    IBNR{8011651}, // Göhren (Rügen) railway station
    IBNR{8011676}, // Goßdorf-Kohlmühle railway station
    IBNR{8011681}, // Grabow (Meckl) railway station
    IBNR{8011689}, // Grambow railway station
    IBNR{8011694}, // Greifswald Süd railway station
    IBNR{8011702}, // Grieben (Meckl) railway station
    IBNR{8011707}, // Grimmen railway station
    IBNR{8011718}, // Groß Brütz railway station
    IBNR{8011723}, // Groß Kiesow railway station
    IBNR{8011726}, // Groß Laasch railway station
    IBNR{8011729}, // Groß Lüsewitz railway station
    IBNR{8011731}, // Groß Quassow railway station
    IBNR{8011735}, // Groß Schwaß railway station
    IBNR{8011740}, // Großbeeren railway station
    IBNR{8011748}, // Q1548558
    IBNR{8011749}, // Großenhain Cottbuser station
    IBNR{8011778}, // Stralsund-Grünhufe railway station
    IBNR{8011788}, // Seelow-Gusow station
    IBNR{8011790}, // Gutenfürst station
    IBNR{8011797}, // Hagebök railway station
    IBNR{8011798}, // Hagenow Stadt railway station
    IBNR{8011799}, // Q800864
    IBNR{8011814}, // Q9285520
    IBNR{8011846}, // Heiligendamm railway station
    IBNR{8011847}, // Steilküste/Wittenbeck railway station
    IBNR{8011862}, // Hermsdorf-Klosterlausnitz station
    IBNR{8011863}, // Herrensee station
    IBNR{8011864}, // Herrnburg railway station
    IBNR{8011870}, // Hetzdorf (Flöhatal) railway station
    IBNR{8011889}, // Hohendorf railway station
    IBNR{8011901}, // Berlin-Hohenschönhausen station
    IBNR{8011904}, // Hohenstein-Ernstthal station
    IBNR{8011908}, // Holdorf (Meckl) railway station
    IBNR{8011924}, // Huckstorf railway station
    IBNR{8011931}, // Bahnhof Ilmenau Bad
    IBNR{8011934}, // Q800952
    IBNR{8011939}, // Jabel (Meckl) railway station
    IBNR{8011947}, // Jagdschloß railway station
    IBNR{8011951}, // Jasnitz railway station
    IBNR{8011953}, // Jeeser railway station
    IBNR{8011956}, // Jena Paradies station
    IBNR{8011957}, // Jena West station
    IBNR{8011985}, // Q47008895
    IBNR{8011988}, // Kamenz railway station
    IBNR{8011991}, // Karlsburg railway station
    IBNR{8011992}, // Karlshagen railway station
    IBNR{8011994}, // Karstädt station
    IBNR{8011995}, // Kalsow railway station
    IBNR{8012002}, // Kavelstorf (Kr Rostock) railway station
    IBNR{8012005}, // Kenz railway station
    IBNR{8012009}, // Kirch-Jesar railway station
    IBNR{8012021}, // Klein Bünzow railway station
    IBNR{8012045}, // Q801018
    IBNR{8012064}, // Q27478676
    IBNR{8012065}, // Kölpinsee railway station
    IBNR{8012086}, // Koserow railway station
    IBNR{8012088}, // Q801033
    IBNR{8012092}, // Q28870827
    IBNR{8012093}, // Kratzeburg railway station
    IBNR{8012096}, // Kremmen railway station
    IBNR{8012108}, // Kröpelin railway station
    IBNR{8012109}, // Kronskamp railway station
    IBNR{8012143}, // Laage (Meckl) railway station
    IBNR{8012146}, // Lancken railway station
    IBNR{8012167}, // Q42313166
    IBNR{8012169}, // Q801063
    IBNR{8012171}, // Bahnhof Lauscha
    IBNR{8012177}, // Lauterbach Mole railway station
    IBNR{8012183}, // Leipzig/Halle Airport station
    IBNR{8012184}, // Leipzig Bayerischer Bahnhof
    IBNR{8012194}, // Leipzig-Stötteritz railway station
    IBNR{8012197}, // Leipzig-Wahren station
    IBNR{8012203}, // Q801078
    IBNR{8012221}, // Rostock-Lichtenhagen railway station
    IBNR{8012239}, // Lindow (Mark) railway station
    IBNR{8012253}, // Ludwigsfelde-Struveshof station
    IBNR{8012260}, // Luckenwalde station
    IBNR{8012262}, // Lüblow (Meckl) railway station
    IBNR{8012264}, // Lübstorf railway station
    IBNR{8012268}, // Lüdersdorf (Meckl) railway station
    IBNR{8012269}, // Lüssow (Meckl) railway station
    IBNR{8012271}, // Rostock-Lütten Klein railway station
    IBNR{8012274}, // Lützow railway station
    IBNR{8012287}, // Q801147
    IBNR{8012296}, // Inselstadt Malchow railway station
    IBNR{8012315}, // Marquardt station
    IBNR{8012316}, // Martensdorf railway station
    IBNR{8012321}, // Dorf Mecklenburg railway station
    IBNR{8012323}, // Meerane railway station
    IBNR{8012324}, // Q801168
    IBNR{8012326}, // Meissen station
    IBNR{8012358}, // Miltzow railway station
    IBNR{8012361}, // Mirow railway station
    IBNR{8012362}, // Mistorf railway station
    IBNR{8012369}, // Mittweida railway station
    IBNR{8012376}, // Mölln (Meckl) railway station
    IBNR{8012377}, // Mönchhagen railway station
    IBNR{8012384}, // Moidentin railway station
    IBNR{8012388}, // Mosel station
    IBNR{8012407}, // Bahnhof Mulda (Sachs)
    IBNR{8012418}, // Nechlin railway station
    IBNR{8012421}, // Neetzka railway station
    IBNR{8012436}, // Neu Wokern railway station
    IBNR{8012438}, // Neubukow railway station
    IBNR{8012443}, // Q801239
    IBNR{8012460}, // Q801242
    IBNR{8012474}, // Neustadt-Glewe railway station
    IBNR{8012478}, // Leipzig Messe railway station
    IBNR{8012482}, // Niederau station
    IBNR{8012517}, // Nossentin railway station
    IBNR{8012525}, // Q801275
    IBNR{8012537}, // Obersdorf station
    IBNR{8012541}, // Q801281
    IBNR{8012554}, // Q801286
    IBNR{8012555}, // Oertzenhof railway station
    IBNR{8012582}, // Rostock-Torfbrücke railway station
    IBNR{8012583}, // Graal-Müritz railway station
    IBNR{8012584}, // Graal-Müritz Koppelweg railway station
    IBNR{8012585}, // Kühlungsborn Mitte railway station
    IBNR{8012586}, // Kühlungsborn Ost railway station
    IBNR{8012587}, // Kühlungsborn West railway station
    IBNR{8012603}, // Papendorf railway station
    IBNR{8012609}, // Parkentin railway station
    IBNR{8012610}, // Pasewalk Ost railway station
    IBNR{8012611}, // Passow
    IBNR{8012614}, // Bahnhof Paulinenaue
    IBNR{8012617}, // Peenemünde railway station
    IBNR{8012621}, // Q19274501
    IBNR{8012622}, // Q14551300
    IBNR{8012634}, // Philippshagen railway station
    IBNR{8012643}, // Plate (Meckl) railway station
    IBNR{8012651}, // Plüschow railway station
    IBNR{8012654}, // Pölchow railway station
    IBNR{8012663}, // Q55154742
    IBNR{8012665}, // Posewald railway station
    IBNR{8012666}, // Potsdam Hauptbahnhof
    IBNR{8012676}, // Bahnhof Pritzerbe
    IBNR{8012677}, // Pritzier railway station
    IBNR{8012683}, // Prora railway station
    IBNR{8012684}, // Prora Ost railway station
    IBNR{8012700}, // Radebeul-Weintraube station
    IBNR{8012703}, // Q801645
    IBNR{8012710}, // Rakow railway station
    IBNR{8012711}, // Rambin railway station
    IBNR{8012713}, // Rangsdorf railway station
    IBNR{8012716}, // Rastow railway station
    IBNR{8012729}, // Reddelich railway station
    IBNR{8012735}, // Rehfelde station
    IBNR{8012737}, // Rehna railway station
    IBNR{8012739}, // Reichenbach (Vogtland) Oberer station
    IBNR{8012742}, // Reinhardsbrunn-Friedrichroda railway station
    IBNR{8012749}, // Q801358
    IBNR{8012758}, // Reuterstadt Stavenhagen station
    IBNR{8012760}, // Rheinsberg (Mark) railway station
    IBNR{8012762}, // Ribnitz-Damgarten Ost railway station
    IBNR{8012763}, // Ribnitz-Damgarten West railway station
    IBNR{8012785}, // Roggentin railway station
    IBNR{8012801}, // Rostock Parkstraße railway station
    IBNR{8012803}, // Rostock-Bramow railway station
    IBNR{8012805}, // Rostock Holbeinplatz railway station
    IBNR{8012806}, // Rostock-Kassebohm railway station
    IBNR{8012807}, // Rostock-Marienehe railway station
    IBNR{8012819}, // Q29573095
    IBNR{8012824}, // Ruthenbeck railway station
    IBNR{8012827}, // Saatel railway station
    IBNR{8012832}, // Sagard railway station
    IBNR{8012835}, // Samtens railway station
    IBNR{8012839}, // Sandförde railway station
    IBNR{8012840}, // Sandhagen (b. Bad Doberan) railway station
    IBNR{8012841}, // Sanitz (b Rostock) railway station
    IBNR{8012843}, // Sassnitz railway station
    IBNR{8012856}, // Scharstorf railway station
    IBNR{8012892}, // Schmollensee railway station
    IBNR{8012902}, // Schönberg (Meckl) railway station
    IBNR{8012933}, // Schwanheide railway station
    IBNR{8012940}, // Schwerin Mitte railway station
    IBNR{8012943}, // Schwedt railway station
    IBNR{8012949}, // Schwenzin railway station
    IBNR{8012951}, // Schwerin Süd railway station
    IBNR{8012953}, // Schwerin-Lankow railway station
    IBNR{8012954}, // Schwerin-Warnitz railway station
    IBNR{8012959}, // Sebnitz railway station
    IBNR{8012960}, // Schwerin-Margaretenhof railway station
    IBNR{8012962}, // Seebad Ahlbeck railway station
    IBNR{8012963}, // Seebad Heringsdorf railway station
    IBNR{8012968}, // Seehausen (Uckermark) railway station
    IBNR{8012974}, // Seelvitz railway station
    IBNR{8012983}, // Sellin (Rügen) Ost railway station
    IBNR{8012986}, // Serams railway station
    IBNR{8013008}, // Sonneberg Central Station
    IBNR{8013017}, // Sponholz railway station
    IBNR{8013018}, // Spornitz railway station
    IBNR{8013021}, // Berlin-Staaken station
    IBNR{8013025}, // Q801458
    IBNR{8013040}, // Steinhausen-Neuburg railway station
    IBNR{8013051}, // Sternfeld railway station
    IBNR{8013062}, // Stralsund Rügendamm railway station
    IBNR{8013064}, // Strausberg Nord station
    IBNR{8013069}, // Strohkirchen railway station
    IBNR{8013072}, // Subzin-Liessow railway station
    IBNR{8013073}, // Sülstorf railway station
    IBNR{8013079}, // Sukow (b Schwerin) railway station
    IBNR{8013090}, // Tantow railway station
    IBNR{8013092}, // Q21036573
    IBNR{8013100}, // Teltow railway station
    IBNR{8013104}, // Teschenhagen railway station
    IBNR{8013105}, // Teschow railway station
    IBNR{8013106}, // Tessin railway station
    IBNR{8013112}, // Thale Central Station
    IBNR{8013129}, // Q801538
    IBNR{8013131}, // Torgelow railway station
    IBNR{8013132}, // Trassenheide railway station
    IBNR{8013133}, // Trassenmoor railway station
    IBNR{8013140}, // Könnern station
    IBNR{8013141}, // Trebnitz
    IBNR{8013145}, // Q20644102
    IBNR{8013156}, // Ueckermünde Stadthafen railway station
    IBNR{8013161}, // Ückeritz railway station
    IBNR{8013162}, // Ueckermünde railway station
    IBNR{8013177}, // Utzedel railway station
    IBNR{8013185}, // Velten
    IBNR{8013186}, // Ventschow railway station
    IBNR{8013232}, // Warenshof railway station
    IBNR{8013236}, // Warnemünde railway station
    IBNR{8013237}, // Warnemünde Werft railway station
    IBNR{8013238}, // Warnitz (Uckermark) railway station
    IBNR{8013250}, // Q801583
    IBNR{8013256}, // Q24652564
    IBNR{8013279}, // Joachimsthal Kaiserbahnhof
    IBNR{8013285}, // Werneuchen station
    IBNR{8013293}, // Wesenberg railway station
    IBNR{8013313}, // Wilmersdorf (b Angermünde) railway station
    IBNR{8013322}, // Wittenhagen railway station
    IBNR{8013339}, // Wolgast railway station
    IBNR{8013340}, // Wolgast Hafen railway station
    IBNR{8013341}, // Wolgaster Fähre railway station
    IBNR{8013352}, // Wüstenfelde railway station
    IBNR{8013354}, // Schwerin-Wüstmark railway station
    IBNR{8013365}, // Bahnhof Wusterwitz
    IBNR{8013366}, // Wutha station
    IBNR{8013370}, // Zachun railway station
    IBNR{8013373}, // Zarrendorf railway station
    IBNR{8013377}, // Q19835128
    IBNR{8013385}, // Zempin railway station
    IBNR{8013393}, // Zerrenthin railway station
    IBNR{8013396}, // Zeulenroda unt Bf station
    IBNR{8013409}, // Zirtow-Leussow railway station
    IBNR{8013439}, // Blankenburg (Harz) station
    IBNR{8013444}, // Dresden Mitte railway station
    IBNR{8013445}, // Freital-Potschappel station
    IBNR{8013450}, // Chemnitz-Hilbersdorf station
    IBNR{8013456}, // Bahnhof Magdeburg-Buckau
    IBNR{8013463}, // Q2098942
    IBNR{8013470}, // Bernau bei Berlin station
    IBNR{8013474}, // Q43054353
    IBNR{8013475}, // Dresden-Friedrichstadt station
    IBNR{8013477}, // Erkner railway station
    IBNR{8013481}, // Golm station
    IBNR{8013483}, // Hennigsdorf station
    IBNR{8013486}, // Q801203
    IBNR{8013487}, // Oranienburg station
    IBNR{8013492}, // Seddin station
    IBNR{8013539}, // Beuchow railway station
    IBNR{8017001}, // Bahnhof Alexisbad
    IBNR{8017004}, // Brocken station
    IBNR{8017006}, // Drei Annen Hohne station
    IBNR{8017007}, // Eisfelder Talmühle
    IBNR{8017011}, // Q33747480
    IBNR{8017012}, // Q42301989
    IBNR{8017015}, // Q19274496
    IBNR{8017022}, // Schierke station
    IBNR{8017029}, // Q33926963
    IBNR{8017345}, // Lauterbach (Rügen) railway station
    IBNR{8017349}, // Neu Pudagla railway station
    IBNR{8070003}, // Frankfurt Airport long-distance station
    IBNR{8070004}, // Frankfurt Airport regional station
    IBNR{8070096}, // Q17353341
    IBNR{8070146}, // Sternschanze station
    IBNR{8070258}, // Sellin (Rügen) West railway station
    IBNR{8070704}, // Aachen Schanz station
    IBNR{8070805}, // Dürrenwaid station
    IBNR{8070946}, // Weißer See railway station
    IBNR{8077434}, // Q801235
    IBNR{8079027}, // Norderstedt Mitte
    IBNR{8079084}, // Ahlbeck Grenze railway station
    IBNR{8079085}, // Q15785159
    IBNR{8079087}, // Q15297228
    IBNR{8079088}, // Q15496747
    IBNR{8079095}, // Hannover-Nordstadt station
    IBNR{8079097}, // Hannover-Ledeburg station
    IBNR{8079147}, // Hinterweidenthal Ost station
    IBNR{8079604}, // Tessin West railway station
    IBNR{8079629}, // Rostock Thierfelder Straße railway station
    IBNR{8079632}, // Frankfurt Messe station
    IBNR{8080040}, // Berlin Albrechtshof station
    IBNR{8080070}, // Potsdam-Babelsberg station
    IBNR{8080190}, // Birkenwerder station
    IBNR{8080200}, // Borgsdorf station
    IBNR{8080280}, // Delitzsch oberer Bahnhof
    IBNR{8080340}, // Eichwalde station
    IBNR{8080370}, // Elstal railway station
    IBNR{8080440}, // Fredersdorf station
    IBNR{8080450}, // Teltow Stadt railway station
    IBNR{8080460}, // Q800811
    IBNR{8080530}, // Potsdam Griebnitzsee railway station
    IBNR{8080710}, // Hohen Neuendorf West station
    IBNR{8080720}, // Hohen Neuendorf station
    IBNR{8080750}, // Hoppegarten (Mark) station
    IBNR{8080970}, // Mahlow station
    IBNR{8081020}, // Neuenhagen station
    IBNR{8081085}, // Bad Doberan Stadtmitte railway station
    IBNR{8081150}, // Petershagen Nord railway station
    IBNR{8081210}, // Röntgental station
    IBNR{8081220}, // Saarmund station
    IBNR{8081290}, // Schönfließ railway station
    IBNR{8081560}, // Zepernick station
    IBNR{8081580}, // Zeuthen railway station
    IBNR{8081722}, // Lehnitz station
    IBNR{8087025}, // Ahlbeck Ostseetherme railway station
    IBNR{8087026}, // Heringsdorf Neuhof railway station
    IBNR{8087027}, // Stubbenfelde railway station
    IBNR{8087080}, // Q18616528
    IBNR{8089000}, // Schulzendorf railway station
    IBNR{8089001}, // Berlin Alexanderplatz station
    IBNR{8089002}, // Berlin Anhalter Bahnhof
    IBNR{8089003}, // Attilastraße station
    IBNR{8089004}, // Baumschulenweg station
    IBNR{8089005}, // Berlin Bellevue station
    IBNR{8089006}, // Betriebsbahnhof Rummelsburg station
    IBNR{8089007}, // Betriebsbahnhof Schöneweide
    IBNR{8089008}, // Berlin Bornholmer Straße station
    IBNR{8089009}, // Berlin Botanischer Garten station
    IBNR{8089010}, // Buckower Chaussee station
    IBNR{8089011}, // Berlin Greifswalder Straße station
    IBNR{8089012}, // Berlin Feuerbachstraße station
    IBNR{8089013}, // Berlin Frankfurter Allee station
    IBNR{8089015}, // Berlin-Gesundbrunnen station
    IBNR{8089016}, // Grünbergallee station
    IBNR{8089017}, // Berlin Hackescher Markt station
    IBNR{8089018}, // Berlin Humboldthain station
    IBNR{8089020}, // Berlin Landsberger Allee station
    IBNR{8089021}, // Berlin Hauptbahnhof
    IBNR{8089022}, // Mehrower Allee station
    IBNR{8089023}, // Berlin Mexikoplatz station
    IBNR{8089024}, // Berlin Nordbahnhof
    IBNR{8089025}, // Heiligensee station
    IBNR{8089027}, // Berlin Oranienburger Straße station
    IBNR{8089028}, // Ostkreuz
    IBNR{8089030}, // Plänterwald railway station
    IBNR{8089032}, // Berlin Potsdamer Platz station
    IBNR{8089033}, // Berlin Prenzlauer Allee station
    IBNR{8089034}, // Priesterweg railway station
    IBNR{8089035}, // Raoul-Wallenberg-Straße railway station
    IBNR{8089036}, // Berlin Rathaus Steglitz station
    IBNR{8089037}, // Berlin Savignyplatz station
    IBNR{8089038}, // Schichauweg railway station
    IBNR{8089039}, // Berlin Schönhauser Allee station
    IBNR{8089040}, // Berlin Springpfuhl station
    IBNR{8089041}, // Berlin Storkower Straße station
    IBNR{8089042}, // Berlin Sundgauer Straße station
    IBNR{8089043}, // Berlin Treptower Park station
    IBNR{8089044}, // Berlin Brandenburger Tor station
    IBNR{8089045}, // Berlin Warschauer Straße metro station
    IBNR{8089047}, // Berlin Westkreuz station
    IBNR{8089048}, // Berlin Wollankstraße station
    IBNR{8089049}, // Berlin Wuhletal station
    IBNR{8089050}, // Yorckstraße station
    IBNR{8089051}, // Yorckstraße (Großgörschenstraße) station
    IBNR{8089052}, // Adlershof station
    IBNR{8089053}, // Berlin-Stresow railway station
    IBNR{8089054}, // Altglienicke station
    IBNR{8089055}, // Berlin-Biesdorf station
    IBNR{8089056}, // Berlin-Blankenburg station
    IBNR{8089057}, // Berlin-Buch station
    IBNR{8089058}, // Berlin-Friedenau station
    IBNR{8089059}, // Berlin-Friedrichsfelde Ost station
    IBNR{8089060}, // Berlin-Friedrichshagen station
    IBNR{8089061}, // Berlin-Frohnau station
    IBNR{8089062}, // Berlin-Grunewald station
    IBNR{8089063}, // Berlin-Grünau station
    IBNR{8089064}, // Berlin-Hermsdorf station
    IBNR{8089066}, // Berlin-Friedrichstraße railway station
    IBNR{8089068}, // Berlin-Kaulsdorf railway station
    IBNR{8089069}, // Berlin-Köpenick station
    IBNR{8089070}, // Lichtenrade station
    IBNR{8089071}, // Berlin-Lichterfelde West station
    IBNR{8089072}, // Mahlsdorf railway station
    IBNR{8089074}, // Marienfelde station
    IBNR{8089075}, // Berlin-Marzahn station
    IBNR{8089077}, // Berlin-Neukölln station
    IBNR{8089078}, // Berlin-Nikolassee station
    IBNR{8089080}, // Berlin-Pankow station
    IBNR{8089081}, // Berlin-Pankow-Heinersdorf station
    IBNR{8089082}, // Berlin-Rahnsdorf station
    IBNR{8089084}, // Berlin-Rummelsburg railway station
    IBNR{8089085}, // Berlin-Schlachtensee station
    IBNR{8089087}, // Berlin-Schönholz station
    IBNR{8089089}, // Berlin-Tegel railway station
    IBNR{8089090}, // Berlin-Tempelhof station
    IBNR{8089091}, // Berlin-Tiergarten station
    IBNR{8089092}, // Berlin-Waidmannslust station
    IBNR{8089094}, // Berlin Wilhelmshagen station
    IBNR{8089095}, // Berlin-Wilhelmsruh station
    IBNR{8089096}, // Berlin-Wittenau station
    IBNR{8089097}, // Berlin Wuhlheide station
    IBNR{8089098}, // Berlin-Zehlendorf station
    IBNR{8089099}, // Bernau-Friedenstal station
    IBNR{8089100}, // Berlin Jungfernheide station
    IBNR{8089101}, // Eichborndamm station
    IBNR{8089102}, // Berlin Karl-Bonhoeffer-Nervenklinik station
    IBNR{8089103}, // Berlin Alt-Reinickendorf station
    IBNR{8089104}, // Köllnische Heide station
    IBNR{8089105}, // Hermannstraße railway station
    IBNR{8089106}, // Berlin Innsbrucker Platz station
    IBNR{8089107}, // Berlin Bundesplatz station
    IBNR{8089108}, // Berlin Hohenzollerndamm station
    IBNR{8089109}, // Berlin-Halensee station
    IBNR{8089110}, // Berlin Messe Nord/ICC station
    IBNR{8089111}, // Berlin-Westend station
    IBNR{8089112}, // Berlin Heidelberger Platz station
    IBNR{8089113}, // Berlin-Lichterfelde Ost station
    IBNR{8089114}, // Lankwitz station
    IBNR{8089115}, // Südende station
    IBNR{8089116}, // Berlin Westhafen station
    IBNR{8089118}, // Berlin Beusselstraße station
    IBNR{8089119}, // Neuenburg
    IBNR{8089131}, // Berlin-Wedding station
    IBNR{8089168}, // Berlin-Schöneweide station
    IBNR{8089201}, // Berlin Brandenburg Airport railway station
    IBNR{8089327}, // Berlin Sonnenallee station
    IBNR{8089328}, // Berlin Messe Süd railway station
    IBNR{8089329}, // Berlin Heerstraße station
    IBNR{8089330}, // Berlin Olympiastadion station
    IBNR{8089331}, // Berlin-Pichelsberg railway station
    IBNR{8089472}, // Lichterfelde Süd station
    IBNR{8089473}, // Osdorfer Straße station
    IBNR{8089474}, // Berlin-Schöneberg station
    IBNR{8089537}, // Berlin Julius-Leber-Brücke station
    IBNR{8098105}, // Frankfurt Central Station
    IBNR{8098160}, // Berlin Hauptbahnhof
    IBNR{8098261}, // Munich Central Station
    IBNR{8098262}, // Munich Central Station
    IBNR{8098263}, // Munich Central Station
    IBNR{8100001}, // Kufstein railway station
    IBNR{8100002}, // Salzburg Hauptbahnhof
    IBNR{8100003}, // Vienna West railway station
    IBNR{8100008}, // St. Pölten Central Station
    IBNR{8100009}, // Q576448
    IBNR{8100012}, // Bahnhof Amstetten
    IBNR{8100013}, // Linz Central Station
    IBNR{8100014}, // Wels Central Station
    IBNR{8100017}, // Attnang-Puchheim station
    IBNR{8100023}, // Bahnhof Neumarkt-Kallham
    IBNR{8100025}, // Q32173155
    IBNR{8100026}, // Bahnhof Gloggnitz
    IBNR{8100027}, // Payerbach-Reichenau station
    IBNR{8100029}, // Q801226
    IBNR{8100032}, // Bahnhof Bruck an der Mur
    IBNR{8100035}, // Bahnhof Leibnitz
    IBNR{8100042}, // Bischofshofen railway station
    IBNR{8100061}, // Ötztal railway station
    IBNR{8100063}, // Landeck-Zams railway station
    IBNR{8100064}, // St. Anton am Arlberg railway station
    IBNR{8100067}, // Bludenz railway station
    IBNR{8100070}, // Leoben Central Station
    IBNR{8100082}, // Q801450
    IBNR{8100085}, // Klagenfurt Central Station
    IBNR{8100090}, // Bregenz railway station
    IBNR{8100094}, // Bahnhof Böckstein
    IBNR{8100098}, // Q32800339
    IBNR{8100099}, // Wörgl Central Station
    IBNR{8100101}, // Q800570
    IBNR{8100102}, // Jenbach railway station
    IBNR{8100105}, // Q15785173
    IBNR{8100113}, // Bahnhof Seefeld in Tirol
    IBNR{8100114}, // Bahnhof Bichlbach-Berwang
    IBNR{8100121}, // Q31338289
    IBNR{8100122}, // Q24817320
    IBNR{8100123}, // Lustenau
    IBNR{8100129}, // Q42330661
    IBNR{8100140}, // Q17122384
    IBNR{8100141}, // Q801093
    IBNR{8100147}, // Villach Central Station
    IBNR{8100150}, // Q764148
    IBNR{8100151}, // Q800826
    IBNR{8100156}, // Q31972218
    IBNR{8100157}, // Q800426
    IBNR{8100173}, // Graz Central Station
    IBNR{8100176}, // Roundhouse with turntable
    IBNR{8100177}, // Q31209189
    IBNR{8100185}, // Bahnhof Friedberg
    IBNR{8100197}, // Feldkirch railway station
    IBNR{8100198}, // Q27031506
    IBNR{8100201}, // Q38035213
    IBNR{8100202}, // Q32076233
    IBNR{8100217}, // Bahnhof Bürmoos
    IBNR{8100236}, // Wien Floridsdorf railway station
    IBNR{8100247}, // Q800803
    IBNR{8100249}, // Wien Gersthof
    IBNR{8100269}, // Wien Heiligenstadt railway station
    IBNR{8100271}, // Q608453
    IBNR{8100273}, // Q38037125
    IBNR{8100277}, // Q48876272
    IBNR{8100295}, // Krems an der Donau train station
    IBNR{8100297}, // Q1572420
    IBNR{8100349}, // Wien Praterstern railway station
    IBNR{8100353}, // Vienna Airport
    IBNR{8100365}, // Braunau am Inn railway station
    IBNR{8100369}, // Gramatneusiedl station
    IBNR{8100371}, // Q1544082
    IBNR{8100374}, // Wien Kaiserebersdorf railway station
    IBNR{8100395}, // Q1572413
    IBNR{8100396}, // Q801101
    IBNR{8100411}, // Q801375
    IBNR{8100441}, // Q1572425
    IBNR{8100446}, // Wien Franz-Josefs-Bahnhof
    IBNR{8100447}, // Wien Hütteldorf railway station
    IBNR{8100449}, // Wien Mitte railway station
    IBNR{8100450}, // Wien Penzing railway station
    IBNR{8100457}, // Bernhardsthal railway station
    IBNR{8100473}, // Bregenz Riedenburg station
    IBNR{8100482}, // Schaan-Vaduz railway station
    IBNR{8100493}, // Q26254154
    IBNR{8100512}, // Wien Ottakring railway station
    IBNR{8100514}, // Wien Meidling
    IBNR{8100516}, // Wiener Neustadt Central Station
    IBNR{8100534}, // Bahnhof Stockerau
    IBNR{8100634}, // Wien Atzgersdorf railway station
    IBNR{8100692}, // Breitenstein station
    IBNR{8100721}, // Bahnhof Deutsch Wagram
    IBNR{8100935}, // Wien Hetzendorf railway station
    IBNR{8100975}, // Hausfeldstraße
    IBNR{8101150}, // Wien Liesing railway station
    IBNR{8101170}, // Wien Leopoldau railway station
    IBNR{8101227}, // Wien Matzleinsdorfer Platz railway station
    IBNR{8101231}, // Bahnhof Mogersdorf
    IBNR{8101262}, // Nendeln railway station
    IBNR{8101290}, // Q18762414
    IBNR{8101337}, // Patsch railway station
    IBNR{8101433}, // Bahnhof Wien Rennweg
    IBNR{8101470}, // Q15785197
    IBNR{8101473}, // Wien Quartier Belvedere train station
    IBNR{8101539}, // Q9373170
    IBNR{8101553}, // Wien Simmering railway station
    IBNR{8101555}, // Wien Geiselbergstraße railway station
    IBNR{8101556}, // Wien Grillgasse railway station
    IBNR{8101590}, // Südtiroler Platz-Hauptbahnhof
    IBNR{8101641}, // Q1572428
    IBNR{8101793}, // Bahnhof Wolkersdorf
    IBNR{8101818}, // Q14906766
    IBNR{8101820}, // Wien Zentralfriedhof
    IBNR{8101853}, // Bahnhof Wien Speising
    IBNR{8101934}, // Handelskai (Vienna U-Bahn)
    IBNR{8101937}, // Wien Spittelau railway station
    IBNR{8101947}, // Handelskai (Vienna U-Bahn)
    IBNR{8102059}, // Tullnerfeld railway station
    IBNR{8103000}, // Wien Hauptbahnhof
    IBNR{8104229}, // Stadlau
    IBNR{8198129}, // Q42330661
    IBNR{8198353}, // Vienna Airport
    IBNR{8198449}, // Wien Mitte railway station
    IBNR{8200100}, // Luxembourg railway station
    IBNR{8200110}, // Mersch railway station
    IBNR{8200340}, // Wasserbillig railway station
    IBNR{8200930}, // Pétange railway station
    IBNR{8270060}, // Bascharage-Sanem railway station
    IBNR{8270270}, // Capellen railway station
    IBNR{8300001}, // Torino Porta Nuova railway station
    IBNR{8300002}, // Alessandria railway station
    IBNR{8300003}, // Asti railway station
    IBNR{8300004}, // Bardonecchia railway station
    IBNR{8300006}, // Bussoleno
    IBNR{8300007}, // Novara railway station
    IBNR{8300008}, // Vercelli railway station
    IBNR{8300009}, // Savigliano railway station
    IBNR{8300010}, // Oulx-Cesana-Claviere-Sestriere railway station
    IBNR{8300011}, // Oleggio railway station
    IBNR{8300012}, // Aosta railway station
    IBNR{8300013}, // Borgomanero railway station
    IBNR{8300014}, // Bra railway station
    IBNR{8300015}, // Carmagnola railway station
    IBNR{8300016}, // Cuneo railway station
    IBNR{8300017}, // Cavallermaggiore railway station
    IBNR{8300018}, // Ceva railway station
    IBNR{8300019}, // Chivasso railway station
    IBNR{8300020}, // Fossano railway station
    IBNR{8300021}, // Ivrea railway station
    IBNR{8300023}, // Mortara railway station
    IBNR{8300025}, // Romagnano Sesia railway station
    IBNR{8300026}, // Rovasenda railway station
    IBNR{8300027}, // San Giuseppe di Cairo train station
    IBNR{8300029}, // Tortona railway station
    IBNR{8300030}, // Trofarello railway station
    IBNR{8300031}, // Valenza railway station
    IBNR{8300032}, // Sassari railway station
    IBNR{8300035}, // Pietra Ligure railway station
    IBNR{8300036}, // Q3970433
    IBNR{8300037}, // Porto Torres train station
    IBNR{8300038}, // Oristano railway station
    IBNR{8300039}, // Cagliari railway station
    IBNR{8300040}, // Bergamo railway station
    IBNR{8300041}, // Arona railway station
    IBNR{8300043}, // Busto Arsizio railway station
    IBNR{8300046}, // Milano Centrale railway station
    IBNR{8300047}, // Milano Porta Garibaldi railway station
    IBNR{8300048}, // Brescia railway station
    IBNR{8300049}, // Pavia railway station
    IBNR{8300051}, // Q16608805
    IBNR{8300053}, // Q3969533
    IBNR{8300054}, // Codogno train station
    IBNR{8300056}, // Como San Giovanni railway station
    IBNR{8300057}, // Domodossola railway station
    IBNR{8300058}, // Gallarate railway station
    IBNR{8300059}, // Lecco railway station
    IBNR{8300060}, // Lodi railway station
    IBNR{8300061}, // Luino railway station
    IBNR{8300062}, // Milano Lambrate railway station
    IBNR{8300063}, // Monza railway station
    IBNR{8300065}, // Rho railway station
    IBNR{8300066}, // Seregno railway station
    IBNR{8300067}, // Sesto Calende railway station
    IBNR{8300068}, // Stresa railway station
    IBNR{8300070}, // Verbania-Pallanza railway station
    IBNR{8300072}, // Q3970936
    IBNR{8300073}, // Longarone-Zoldo railway station
    IBNR{8300074}, // Carnia railway station
    IBNR{8300075}, // Bassano del Grappa railway station
    IBNR{8300076}, // Q3969119
    IBNR{8300077}, // Brunico
    IBNR{8300078}, // Chiusa railway halt
    IBNR{8300079}, // Q3969188
    IBNR{8300080}, // Casarsa railway station
    IBNR{8300081}, // Castelfranco Veneto railway station
    IBNR{8300082}, // Q16609040
    IBNR{8300083}, // Crevalcore train station
    IBNR{8300084}, // Bolzano/Bozen railway station
    IBNR{8300085}, // Belluno railway station
    IBNR{8300086}, // Conegliano railway station
    IBNR{8300088}, // Q3969592
    IBNR{8300089}, // Fortezza
    IBNR{8300090}, // Gemona del Friuli railway station
    IBNR{8300091}, // Colle Isarco
    IBNR{8300092}, // Brenner railway station
    IBNR{8300093}, // Venezia Mestre railway station
    IBNR{8300094}, // Venezia Santa Lucia railway station
    IBNR{8300095}, // Cervignano-Aquileia-Grado railway station
    IBNR{8300096}, // Gorizia Centrale railway station
    IBNR{8300097}, // Q3970087
    IBNR{8300098}, // Padova railway station
    IBNR{8300099}, // Q3969953
    IBNR{8300101}, // Trento railway station
    IBNR{8300102}, // Mezzocorona
    IBNR{8300103}, // Monfalcone railway station
    IBNR{8300104}, // Dobbiaco
    IBNR{8300105}, // Q3970194
    IBNR{8300107}, // Trieste Centrale railway station
    IBNR{8300108}, // Q3970540
    IBNR{8300110}, // Pordenone railway station
    IBNR{8300111}, // Portogruaro-Caorle railway station
    IBNR{8300112}, // Q3970614
    IBNR{8300113}, // Rovereto railway station
    IBNR{8300114}, // San Candido
    IBNR{8300115}, // Udine railway station
    IBNR{8300118}, // Sacile railway station
    IBNR{8300120}, // Verona Porta Nuova railway station
    IBNR{8300121}, // Vipiteno Val di Vizze
    IBNR{8300122}, // Stazione di Lana-Postal
    IBNR{8300123}, // Ora
    IBNR{8300124}, // Peschiera del Garda railway station
    IBNR{8300125}, // Q3970527
    IBNR{8300126}, // Vicenza railway station
    IBNR{8300127}, // Poggio Rusco railway station
    IBNR{8300130}, // Treviso Centrale railway station
    IBNR{8300131}, // Q16608724
    IBNR{8300132}, // Albenga
    IBNR{8300133}, // Alassio railway station
    IBNR{8300134}, // Arquata Scrivia railway station
    IBNR{8300136}, // Bordighera
    IBNR{8300137}, // Borgo Val di Taro train station
    IBNR{8300139}, // Campiglia Marittima
    IBNR{8300140}, // Viareggio railway station
    IBNR{8300142}, // Cecina railway station
    IBNR{8300143}, // Chiavari railway station
    IBNR{8300144}, // Finale Ligure Marina railway station
    IBNR{8300145}, // Q3969632
    IBNR{8300146}, // Ventimiglia railway station
    IBNR{8300147}, // Genova Nervi
    IBNR{8300148}, // Q3969409
    IBNR{8300149}, // Diano Marina railway station
    IBNR{8300150}, // Grosseto
    IBNR{8300152}, // Genova Brignole
    IBNR{8300153}, // Genova Piazza Principe railway station
    IBNR{8300154}, // Imperia Oneglia railway station
    IBNR{8300156}, // La Spezia Centrale railway station
    IBNR{8300157}, // Livorno Centrale railway station
    IBNR{8300158}, // Genova Sampierdarena
    IBNR{8300159}, // Q3969952
    IBNR{8300160}, // Loano railway station
    IBNR{8300161}, // Lucca railway station
    IBNR{8300162}, // Massa Centro railway station
    IBNR{8300163}, // Novi Ligure railway station
    IBNR{8300164}, // Ronco Scrivia railway station
    IBNR{8300165}, // Piombino
    IBNR{8300166}, // Pistoia railway station
    IBNR{8300167}, // Q3970542
    IBNR{8300169}, // Pisa Centrale railway station
    IBNR{8300170}, // Prato Centrale railway station
    IBNR{8300173}, // Sarzana
    IBNR{8300174}, // Q3970961
    IBNR{8300175}, // Siena railway station
    IBNR{8300177}, // Q3971102
    IBNR{8300178}, // Rapallo railway station
    IBNR{8300179}, // Stazione di Arezzo
    IBNR{8300180}, // Firenze Campo di Marte railway station
    IBNR{8300181}, // Pietrasanta
    IBNR{8300183}, // Monterosso
    IBNR{8300184}, // Q3970552
    IBNR{8300185}, // Savona railway station
    IBNR{8300186}, // Ancona railway station
    IBNR{8300187}, // Q17145109
    IBNR{8300188}, // Assisi railway station
    IBNR{8300190}, // Foligno railway station
    IBNR{8300193}, // Cesena railway station
    IBNR{8300194}, // Cesenatico railway station
    IBNR{8300195}, // Chieti railway station
    IBNR{8300196}, // Q3969427
    IBNR{8300197}, // Fabriano train station
    IBNR{8300199}, // Faenza railway station
    IBNR{8300200}, // Fidenza railway station
    IBNR{8300201}, // Fornovo railway station
    IBNR{8300202}, // Giulianova railway station
    IBNR{8300203}, // Q3969807
    IBNR{8300204}, // Q3969814
    IBNR{8300205}, // Q19819430
    IBNR{8300206}, // Q3969929
    IBNR{8300207}, // Q16609362
    IBNR{8300209}, // Ferrara railway station
    IBNR{8300210}, // Mirandola railway station
    IBNR{8300211}, // Perugia railway station
    IBNR{8300212}, // Ortona railway station
    IBNR{8300214}, // Modena railway station
    IBNR{8300216}, // Pesaro railway station
    IBNR{8300217}, // Bologna Centrale railway station
    IBNR{8300219}, // Ravenna railway station
    IBNR{8300221}, // Rimini railway station
    IBNR{8300224}, // Orte railway station
    IBNR{8300225}, // Q924111
    IBNR{8300227}, // Q3970941
    IBNR{8300230}, // Piacenza railway station
    IBNR{8300231}, // Isola della Scala railway station
    IBNR{8300232}, // Monselice railway station
    IBNR{8300233}, // Nogara railway station
    IBNR{8300235}, // Fiorenzuola railway station
    IBNR{8300236}, // Terni railway station
    IBNR{8300237}, // Q3971000
    IBNR{8300238}, // Rovigo railway station
    IBNR{8300239}, // Napoli Centrale railway station
    IBNR{8300240}, // Napoli Mergellina railway halt
    IBNR{8300241}, // Napoli Piazza Garibaldi railway station
    IBNR{8300242}, // Aversa railway station
    IBNR{8300243}, // Benevento railway station
    IBNR{8300244}, // Caserta railway station
    IBNR{8300245}, // Cancello railway station
    IBNR{8300246}, // Cassino railway station
    IBNR{8300247}, // Ciampino railway station
    IBNR{8300248}, // Avezzano railway station
    IBNR{8300249}, // Civitavecchia railway station
    IBNR{8300250}, // Frosinone railway station
    IBNR{8300251}, // Minturno-Scauri railway station
    IBNR{8300252}, // Attigliano-Bomarzo railway station
    IBNR{8300253}, // Napoli Campi Flegrei railway station
    IBNR{8300254}, // Formia-Gaeta railway station
    IBNR{8300255}, // Nocera Inferiore railway station
    IBNR{8300257}, // Q2608652
    IBNR{8300258}, // Latina railway station
    IBNR{8300259}, // Priverno-Fossanova railway station
    IBNR{8300260}, // Q3970690
    IBNR{8300261}, // Roma Ostiense railway station
    IBNR{8300262}, // Roma Tiburtina railway station
    IBNR{8300263}, // Roma Termini railway station
    IBNR{8300264}, // Sulmona railway station
    IBNR{8300265}, // Tarquinia
    IBNR{8300267}, // Station of Variano-Caianello
    IBNR{8300268}, // Sicignano railway station
    IBNR{8300269}, // Salerno railway station
    IBNR{8300270}, // Pompei station
    IBNR{8300271}, // Spotorno-Noli railway station
    IBNR{8300272}, // Lecce railway station
    IBNR{8300273}, // Barletta railway station
    IBNR{8300274}, // Bisceglie railway station
    IBNR{8300275}, // Cerignola Campagna railway station
    IBNR{8300276}, // Fasano railway station
    IBNR{8300277}, // Gioia del Colle railway station
    IBNR{8300278}, // Monopoli railway station
    IBNR{8300279}, // Mola di Bari railway station
    IBNR{8300281}, // Brindisi railway station
    IBNR{8300282}, // Molfetta railway station
    IBNR{8300284}, // Ostuni railway station
    IBNR{8300285}, // Termoli railway station
    IBNR{8300286}, // Trani railway station
    IBNR{8300287}, // Foggia railway station
    IBNR{8300289}, // Q16608954
    IBNR{8300290}, // Q16609753
    IBNR{8300291}, // Q3970583
    IBNR{8300292}, // Taranto railway station
    IBNR{8300293}, // Bari Centrale railway station
    IBNR{8300294}, // Eboli railway station
    IBNR{8300295}, // Castelvetrano train station
    IBNR{8300296}, // Q3968835
    IBNR{8300297}, // Acireale railway station
    IBNR{8300298}, // Agrigento Bassa railway station
    IBNR{8300299}, // Q17056905
    IBNR{8300301}, // Augusta railway station
    IBNR{8300302}, // Q3968974
    IBNR{8300303}, // Caltanissetta Centrale railway station
    IBNR{8300304}, // Caltanissetta Xirbi railway station
    IBNR{8300306}, // Capo d'Orlando-Naso rail station
    IBNR{8300307}, // Catania Centrale railway station
    IBNR{8300309}, // Crotone railway station
    IBNR{8300310}, // Gela railway station
    IBNR{8300311}, // Q3969728
    IBNR{8300312}, // Catanzaro Lido railway station
    IBNR{8300313}, // Q3969942
    IBNR{8300314}, // Catenanuova-Centuripe railway station
    IBNR{8300315}, // Catanzaro railway station
    IBNR{8300316}, // Q20009968
    IBNR{8300317}, // Maratea station
    IBNR{8300318}, // Q17056894
    IBNR{8300319}, // Mazara del Vallo Station
    IBNR{8300320}, // Q20009822
    IBNR{8300323}, // Railway station of Francavilla Fontana
    IBNR{8300324}, // Roccapalumba-Alia railway station
    IBNR{8300325}, // Q16609738
    IBNR{8300326}, // Stazione di Enna
    IBNR{8300328}, // Lamezia Terme Centrale railway station
    IBNR{8300329}, // Sibari railway station
    IBNR{8300330}, // Termini Imerese railway station
    IBNR{8300331}, // Messina Marittima railway station
    IBNR{8300332}, // Messina Centrale railway station
    IBNR{8300333}, // Q3970901
    IBNR{8300334}, // Melito di Porto Salvo railway station
    IBNR{8300335}, // Paola railway station
    IBNR{8300336}, // Ragusa railway station
    IBNR{8300337}, // Reggio Calabria Centrale railway station
    IBNR{8300338}, // Siracusa railway station
    IBNR{8300339}, // Taormina-Giardini railway station
    IBNR{8300340}, // Trapani railway station
    IBNR{8300341}, // Palermo Centrale railway station
    IBNR{8300344}, // Q3969729
    IBNR{8300348}, // Bagnara railway station
    IBNR{8300349}, // Q3970292
    IBNR{8300350}, // Ala
    IBNR{8300354}, // Rosignano railway station
    IBNR{8300355}, // Salemi-Gibellina railway station
    IBNR{8300356}, // Torreberetti railway station
    IBNR{8300357}, // Q3971289
    IBNR{8300358}, // Q3095596
    IBNR{8300359}, // Anversa-Villalago-Scanno railway station
    IBNR{8300360}, // Bagheria railway station
    IBNR{8300367}, // Q16608890
    IBNR{8300369}, // Q3971225
    IBNR{8300370}, // Q17146361
    IBNR{8300371}, // Q3969245
    IBNR{8300374}, // Castiglioncello railway station
    IBNR{8300376}, // Decimomannu railway station
    IBNR{8300377}, // Q3969186
    IBNR{8300379}, // Fossato di Vico-Gubbio train station
    IBNR{8300380}, // Q3969955
    IBNR{8300383}, // Stradella railway station
    IBNR{8300384}, // Q3971069
    IBNR{8300386}, // Tivoli railway station
    IBNR{8300390}, // Q3971268
    IBNR{8300392}, // Villa Opicina railway station
    IBNR{8300395}, // Q3971348
    IBNR{8300397}, // Battipaglia railway station
    IBNR{8300399}, // Q3969162
    IBNR{8300400}, // Carovigno railway station
    IBNR{8300402}, // Celle Ligure railway halt
    IBNR{8300403}, // Q3969377
    IBNR{8300404}, // Forte dei Marmi-Seravezza-Querceta
    IBNR{8300405}, // Q3969686
    IBNR{8300408}, // Genova Sestri Ponente Aeroporto
    IBNR{8300409}, // Q3969747
    IBNR{8300410}, // Laigueglia
    IBNR{8300413}, // Metaponto railway station
    IBNR{8300416}, // Milano Greco Pirelli railway station
    IBNR{8300418}, // Milano Rogoredo railway station
    IBNR{8300420}, // Misano Adriatico railway station
    IBNR{8300423}, // Q3970295
    IBNR{8300427}, // Q3970672
    IBNR{8300429}, // Roma Tuscolana railway station
    IBNR{8300430}, // Rosarno railway station
    IBNR{8300432}, // Q3970781
    IBNR{8300440}, // Scilla railway station
    IBNR{8300441}, // Squinzano railway station
    IBNR{8300442}, // Trepuzzi railway station
    IBNR{8300444}, // Varazze railway station
    IBNR{8300448}, // Villa Literno railway station
    IBNR{8300450}, // Q3971350
    IBNR{8300451}, // Rimini Miramare railway halt
    IBNR{8300452}, // Olbia railway station
    IBNR{8300454}, // Q3969604
    IBNR{8300456}, // Macomer railway station
    IBNR{8300462}, // Modica railway station
    IBNR{8300463}, // Q3970199
    IBNR{8300466}, // Q16609494
    IBNR{8300468}, // Oschiri railway station
    IBNR{8300469}, // Ozieri-Chilivani railway station
    IBNR{8300471}, // Q3970434
    IBNR{8300473}, // Portomaggiore railway station
    IBNR{8300476}, // Calalzo-Pieve di Cadore-Cortina railway station
    IBNR{8300477}, // Q3969575
    IBNR{8300479}, // Roma Trastevere railway station
    IBNR{8300480}, // San Gavino railway station
    IBNR{8300482}, // Q16609890
    IBNR{8300483}, // Schlanders train station
    IBNR{8300484}, // Q3971015
    IBNR{8300486}, // Q3971026
    IBNR{8300487}, // Spoleto railway station
    IBNR{8300489}, // Villarosa railway station
    IBNR{8300491}, // Q16610085
    IBNR{8300492}, // Voghera railway station
    IBNR{8300496}, // Piombino Marittima
    IBNR{8300497}, // Firenze Rifredi railway station
    IBNR{8300498}, // Q3969560
    IBNR{8300503}, // Q3970651
    IBNR{8300506}, // Q17494364
    IBNR{8300509}, // Ancona Marittima train station
    IBNR{8300510}, // Legnano railway station
    IBNR{8300511}, // Palermo Notarbartolo railway station
    IBNR{8300512}, // Pescara Porta Nuova railway station
    IBNR{8300513}, // Q3969970
    IBNR{8300514}, // Torino Stura railway station
    IBNR{8300516}, // Torino Lingotto railway station
    IBNR{8300518}, // Golfo Aranci railway station
    IBNR{8300521}, // Q3971095
    IBNR{8300522}, // Torino Porta Susa railway station
    IBNR{8300523}, // Pinerolo railway station
    IBNR{8300525}, // Andora railway station
    IBNR{8300526}, // Pontecurone railway halt
    IBNR{8300532}, // Cremona railway station
    IBNR{8300533}, // Rovato railway station
    IBNR{8300534}, // Campo di Trens
    IBNR{8300535}, // Cormons railway station
    IBNR{8300541}, // Mantua railway station
    IBNR{8300542}, // Q3969926
    IBNR{8300543}, // Q3970645
    IBNR{8300544}, // Q3969067
    IBNR{8300545}, // Q3969521
    IBNR{8300546}, // Moneglia
    IBNR{8300547}, // Riomaggiore
    IBNR{8300548}, // Ascoli Piceno railway station
    IBNR{8300549}, // Macerata railway station
    IBNR{8300550}, // Salsomaggiore Terme railway station
    IBNR{8300551}, // Q17462133
    IBNR{8300552}, // Teramo train station
    IBNR{8300554}, // Q18613410
    IBNR{8300557}, // Alba Adriatica-Nereto-Controguerra railway station
    IBNR{8300558}, // Q16609672
    IBNR{8300560}, // Q3970720
    IBNR{8300561}, // Rieti railway station
    IBNR{8300563}, // Avellino railway station
    IBNR{8300566}, // Roma Prenestina railway station
    IBNR{8300568}, // Viterbo Porta Romana railway station
    IBNR{8300569}, // Bari Torre a Mare railway station
    IBNR{8300570}, // Q16608758
    IBNR{8300572}, // Polignano a Mare railway station
    IBNR{8300575}, // Cosenza railway station
    IBNR{8300576}, // Q3971205
    IBNR{8300577}, // Campofranco railway station
    IBNR{8300579}, // Q3970715
    IBNR{8300582}, // Beaulard
    IBNR{8300583}, // Avigliana railway station
    IBNR{8300584}, // Alpignano railway station
    IBNR{8300585}, // Collegno
    IBNR{8300586}, // Q3969354
    IBNR{8300587}, // Vezzano Ligure
    IBNR{8300588}, // Q3969691
    IBNR{8300591}, // Susa
    IBNR{8300592}, // Q16610090
    IBNR{8300593}, // Q16609418
    IBNR{8300594}, // Belgirate railway station
    IBNR{8300595}, // Lesa railway station
    IBNR{8300596}, // Q3971266
    IBNR{8300597}, // Magenta railway station
    IBNR{8300598}, // Verdello-Dalmine railway station
    IBNR{8300601}, // Lonigo railway station
    IBNR{8300603}, // Borgo Ticino railway station
    IBNR{8300604}, // Varallo Pombia railway station
    IBNR{8300605}, // Porto Valtravaglia railway station
    IBNR{8300608}, // Desio railway station
    IBNR{8300611}, // Arenzano railway halt
    IBNR{8300612}, // Borgio Verezzi railway halt
    IBNR{8300613}, // Ceriale railway halt
    IBNR{8300614}, // Vallecrosia
    IBNR{8300615}, // Q3971272
    IBNR{8300617}, // Q3969131
    IBNR{8300618}, // Q3969190
    IBNR{8300620}, // Mori railway halt
    IBNR{8300621}, // Serravalle all'Adige
    IBNR{8300624}, // Q16609718
    IBNR{8300625}, // Q3971264
    IBNR{8300626}, // Q3968910
    IBNR{8300627}, // Q3971083
    IBNR{8300628}, // Codroipo railway station
    IBNR{8300629}, // Q3969508
    IBNR{8300630}, // Q3969636
    IBNR{8300631}, // Q3970356
    IBNR{8300632}, // Q3970472
    IBNR{8300633}, // Q3971059
    IBNR{8300634}, // Q3971039
    IBNR{8300635}, // Q3969912
    IBNR{8300636}, // Mogliano Veneto railway station
    IBNR{8300637}, // Quarto d'Altino railway station
    IBNR{8300639}, // Q19060596
    IBNR{8300640}, // Occhiobello train station
    IBNR{8300642}, // Q16609777
    IBNR{8300644}, // Airasca railway station
    IBNR{8300653}, // Alba railway station
    IBNR{8300654}, // Casale Monferrato railway station
    IBNR{8300656}, // Acqui Terme railway station
    IBNR{8300659}, // Q16609532
    IBNR{8300660}, // Q16609267
    IBNR{8300661}, // Q3971056
    IBNR{8300663}, // Varallo Sesia railway station
    IBNR{8300664}, // Q16609706
    IBNR{8300665}, // Borgosesia railway station
    IBNR{8300667}, // Besozzo railway station
    IBNR{8300668}, // Q3969029
    IBNR{8300670}, // Q3969397
    IBNR{8300676}, // Grumello del Monte
    IBNR{8300680}, // Verolanuova railway station
    IBNR{8300682}, // Legnago railway station
    IBNR{8300683}, // Q3970183
    IBNR{8300684}, // Q3969571
    IBNR{8300685}, // Dossobuono
    IBNR{8300687}, // Q3969281
    IBNR{8300688}, // Q3968942
    IBNR{8300689}, // Q3969939
    IBNR{8300690}, // Q3968828
    IBNR{8300691}, // Q17637338
    IBNR{8300692}, // Q3969406
    IBNR{8300693}, // Dueville railway station
    IBNR{8300694}, // Q17637595
    IBNR{8300695}, // Q17637360
    IBNR{8300696}, // Schio railway station
    IBNR{8300697}, // Cittadella railway station
    IBNR{8300699}, // Q17494298
    IBNR{8300700}, // Q3970390
    IBNR{8300703}, // Q18005296
    IBNR{8300706}, // Q3971010
    IBNR{8300708}, // Q16609756
    IBNR{8300712}, // Q16608879
    IBNR{8300713}, // Q16609709
    IBNR{8300714}, // Q16609099
    IBNR{8300716}, // Q16609173
    IBNR{8300717}, // Q3969241
    IBNR{8300718}, // Q20009436
    IBNR{8300719}, // Oderzo railway station
    IBNR{8300720}, // Motta di Livenza railway station
    IBNR{8300723}, // Q3969481
    IBNR{8300724}, // Q3970492
    IBNR{8300725}, // Q3971176
    IBNR{8300726}, // Q3970075
    IBNR{8300727}, // Q3970035
    IBNR{8300729}, // Aviano railway station
    IBNR{8300736}, // Q3969605
    IBNR{8300738}, // Q15714374
    IBNR{8300739}, // Q3970166
    IBNR{8300740}, // Q3970599
    IBNR{8300741}, // Q3969476
    IBNR{8300743}, // Q16608737
    IBNR{8300744}, // Q3970452
    IBNR{8300745}, // Q3969374
    IBNR{8300746}, // Q3970211
    IBNR{8300749}, // Piazza al Serchio
    IBNR{8300750}, // Fornaci di Barga
    IBNR{8300751}, // Q16609254
    IBNR{8300752}, // Q16608773
    IBNR{8300753}, // Populonia
    IBNR{8300754}, // Capranica-Sutri railway station
    IBNR{8300756}, // Porto d'Ascoli train station
    IBNR{8300760}, // Q20010042
    IBNR{8300761}, // Q16610093
    IBNR{8300762}, // Q17637120
    IBNR{8300763}, // Varano Station
    IBNR{8300764}, // Q16609574
    IBNR{8300765}, // Q3971159
    IBNR{8300766}, // Q3970218
    IBNR{8300767}, // Q20009402
    IBNR{8300768}, // Q3969645
    IBNR{8300770}, // Q3969253
    IBNR{8300772}, // Q17637099
    IBNR{8300773}, // Giovinazzo railway station
    IBNR{8300774}, // Cisternino railway station
    IBNR{8300776}, // Q17146397
    IBNR{8300777}, // Q19819439
    IBNR{8300778}, // Q18397591
    IBNR{8300779}, // Q19819440
    IBNR{8300780}, // Q19819465
    IBNR{8300781}, // Q16609978
    IBNR{8300782}, // Q16609961
    IBNR{8300783}, // Q16608882
    IBNR{8300784}, // Q3970553
    IBNR{8300786}, // Q19819467
    IBNR{8300787}, // Prezza railway station
    IBNR{8300788}, // Q16609265
    IBNR{8300789}, // Pescina railway station
    IBNR{8300790}, // Q3969365
    IBNR{8300791}, // Aielli railway station
    IBNR{8300792}, // Celano-Ovindoli railway station
    IBNR{8300793}, // Sassa-Tornimparte railway station
    IBNR{8300794}, // Paganica railway station
    IBNR{8300795}, // Fagnano-Campana railway station
    IBNR{8300796}, // Q15617152
    IBNR{8300797}, // Q15617153
    IBNR{8300798}, // Acciano railway station
    IBNR{8300799}, // Raiano railway station
    IBNR{8300800}, // Q3970436
    IBNR{8300801}, // Tolentino train station
    IBNR{8300805}, // Abbasanta railway station
    IBNR{8300806}, // Q3969590
    IBNR{8300807}, // Q3969360
    IBNR{8300808}, // Q3969329
    IBNR{8300809}, // Q3969364
    IBNR{8300810}, // Q3971133
    IBNR{8300811}, // Q18224699
    IBNR{8300812}, // Q17637573
    IBNR{8300814}, // Acerra railway station
    IBNR{8300815}, // Q17637363
    IBNR{8300816}, // Q3971093
    IBNR{8300818}, // Ariano Irpino railway station
    IBNR{8300822}, // Corigliano Calabro railway station
    IBNR{8300823}, // Q16609120
    IBNR{8300824}, // Q16609129
    IBNR{8300825}, // Q16608857
    IBNR{8300826}, // Q16609117
    IBNR{8300828}, // Q16609291
    IBNR{8300829}, // Q16609720
    IBNR{8300830}, // Q16609011
    IBNR{8300831}, // Q20010034
    IBNR{8300832}, // Q20009909
    IBNR{8300833}, // Q20009905
    IBNR{8300834}, // Africo Nuovo railway station
    IBNR{8300835}, // Q20009398
    IBNR{8300836}, // Brancaleone train station
    IBNR{8300838}, // Bova Marina railway station
    IBNR{8300839}, // Q20009393
    IBNR{8300840}, // Q18590155
    IBNR{8300842}, // Bicocca railway station
    IBNR{8300843}, // Targia railway station
    IBNR{8300844}, // Q16609190
    IBNR{8300847}, // Villalba railway station
    IBNR{8300849}, // Acquaviva-Casteltermini railway station
    IBNR{8300851}, // Q16609617
    IBNR{8300852}, // Q16608814
    IBNR{8300853}, // Q3970411
    IBNR{8300854}, // Sezze Romano railway station
    IBNR{8300855}, // Q16609197
    IBNR{8300856}, // Q3969837
    IBNR{8300858}, // Paestum railway station
    IBNR{8300860}, // Centola-Palinuro-Marina di Camerota railway halt
    IBNR{8300861}, // Pizzo train station
    IBNR{8300864}, // Maccagno railway station
    IBNR{8300865}, // Nizza Monferrato railway station
    IBNR{8300868}, // Q3970918
    IBNR{8300871}, // Monasterace-Stilo railway station
    IBNR{8300872}, // Q16609577
    IBNR{8300877}, // Castelnuovo del Garda
    IBNR{8300881}, // Q3969477
    IBNR{8300882}, // Castelnuovo Garfagnana
    IBNR{8300883}, // Q20009918
    IBNR{8300885}, // Fosciandora-Ceserana
    IBNR{8300886}, // Q3969581
    IBNR{8300887}, // Q17494303
    IBNR{8300898}, // Q3970254
    IBNR{8300899}, // Q18224663
    IBNR{8300900}, // Molina-Castelvecchio Subequo railway station
    IBNR{8300901}, // Manoppello railway station
    IBNR{8300905}, // Q3970212
    IBNR{8300906}, // Q19622710
    IBNR{8300907}, // Q20165207
    IBNR{8300908}, // Q3970391
    IBNR{8300909}, // Q3970515
    IBNR{8300913}, // Q15714368
    IBNR{8300914}, // Pino-Tronzano railway station
    IBNR{8300916}, // Q3970687
    IBNR{8300924}, // Q17145115
    IBNR{8300928}, // Villafranca di Verona
    IBNR{8300929}, // Q20009468
    IBNR{8300931}, // Chiomonte
    IBNR{8300932}, // Q16609602
    IBNR{8300933}, // Meana
    IBNR{8300934}, // Salbertrand railway station
    IBNR{8300941}, // Rocchetta Tanaro-Cerro railway station
    IBNR{8300942}, // Vignale railway station
    IBNR{8300944}, // Villamassargia-Domusnovas railway station
    IBNR{8300948}, // Iglesias railway station
    IBNR{8300949}, // Cagliari Elmas railway station
    IBNR{8300950}, // Albate-Camerlata railway station
    IBNR{8300953}, // Casalpusterlengo railway station
    IBNR{8300954}, // Bressana-Bottarone railway station
    IBNR{8300955}, // Q16609132
    IBNR{8300956}, // Palazzolo sull’Oglio railway station
    IBNR{8300957}, // Q16609273
    IBNR{8300962}, // Parabiago railway station
    IBNR{8300965}, // Premosello-Chiovenda railway station
    IBNR{8300966}, // Cerea railway station
    IBNR{8300967}, // Q3970415
    IBNR{8300968}, // Q3971258
    IBNR{8300969}, // Verona Porta Vescovo railway station
    IBNR{8300970}, // Asciano
    IBNR{8300971}, // Camaiore Lido-Capezzano
    IBNR{8300972}, // Collesalvetti railway station
    IBNR{8300973}, // Q3969530
    IBNR{8300974}, // Q3969698
    IBNR{8300975}, // Genova Borzoli railway station
    IBNR{8300976}, // Genova Cornigliano railway station
    IBNR{8300977}, // Q3969703
    IBNR{8300978}, // Genova Pegli
    IBNR{8300979}, // Genova Pontedecimo railway station
    IBNR{8300980}, // Genova Pra railway station
    IBNR{8300981}, // Genova Quarto dei Mille
    IBNR{8300983}, // Genova Rivarolo railway station
    IBNR{8300984}, // Genova Voltri
    IBNR{8300985}, // Q3969896
    IBNR{8300986}, // Monte Antico
    IBNR{8300987}, // Ovada railway station
    IBNR{8300988}, // Montepescali train station
    IBNR{8300989}, // Pontassieve railway station
    IBNR{8300991}, // Vada railway station
    IBNR{8300992}, // Genova Bolzaneto railway station
    IBNR{8300994}, // Zoagli
    IBNR{8300995}, // Bologna Corticella railway halt
    IBNR{8300996}, // Bologna San Ruffillo train station
    IBNR{8300997}, // Bologna Borgo Panigale railway station
    IBNR{8300998}, // Q3969495
    IBNR{8300999}, // Q3969748
    IBNR{8301000}, // Q16609534
    IBNR{8301001}, // Q3970749
    IBNR{8301002}, // Buttapietra
    IBNR{8301004}, // Q3970203
    IBNR{8301007}, // Cascina railway station
    IBNR{8301008}, // Forlimpopoli-Bertinoro railway station
    IBNR{8301009}, // Q3969185
    IBNR{8301010}, // Colleferro-Segni-Paliano railway station
    IBNR{8301011}, // Q15057779
    IBNR{8301012}, // Napoli Gianturco railway station
    IBNR{8301014}, // Ponte Galeria railway station
    IBNR{8301016}, // Roma Monte Mario
    IBNR{8301018}, // Q3969418
    IBNR{8301021}, // Q3969353
    IBNR{8301022}, // Q3971376
    IBNR{8301027}, // Ginosa railway station
    IBNR{8301030}, // Q20009898
    IBNR{8301037}, // Q3971040
    IBNR{8301038}, // Castelvetro railway station
    IBNR{8301040}, // Catania Acquicella railway station
    IBNR{8301041}, // Catania Ognina railway station
    IBNR{8301047}, // Q3970652
    IBNR{8301048}, // Q20009445
    IBNR{8301049}, // Palermo Brancaccio railway station
    IBNR{8301050}, // Q16609506
    IBNR{8301051}, // Q3970516
    IBNR{8301052}, // Q20010060
    IBNR{8301053}, // Mileto railway station
    IBNR{8301055}, // Q3971381
    IBNR{8301056}, // Alberese
    IBNR{8301057}, // Albinia
    IBNR{8301058}, // Q3969182
    IBNR{8301066}, // Q3969840
    IBNR{8301068}, // Montalto di Castro
    IBNR{8301074}, // Q3971306
    IBNR{8301077}, // Altare
    IBNR{8301078}, // Q17494314
    IBNR{8301079}, // Candiolo railway station
    IBNR{8301082}, // Capaccio-Roccadaspide railway station
    IBNR{8301083}, // Q3969176
    IBNR{8301085}, // Q3969284
    IBNR{8301091}, // Monteroni d'Arbia
    IBNR{8301092}, // Q3970059
    IBNR{8301093}, // Q3970050
    IBNR{8301095}, // Piana railway station
    IBNR{8301096}, // Pontecagnano railway station
    IBNR{8301099}, // Q20009461
    IBNR{8301100}, // Q3971047
    IBNR{8301105}, // Alice Belcolle railway halt
    IBNR{8301107}, // Albisola railway halt
    IBNR{8301111}, // Alcantara station
    IBNR{8301113}, // Antrodoco Centro train station
    IBNR{8301117}, // stazione di Allerona-Castel Viscardo
    IBNR{8301120}, // Q20009379
    IBNR{8301122}, // Q3968873
    IBNR{8301123}, // Q3968818
    IBNR{8301125}, // Q3968875
    IBNR{8301127}, // Q15070219
    IBNR{8301135}, // Altavilla Milicia railway station
    IBNR{8301139}, // Antignano railway station
    IBNR{8301141}, // Q3968876
    IBNR{8301143}, // Albanova railway station
    IBNR{8301146}, // Anzola dell’Emilia railway halt
    IBNR{8301147}, // Q20009991
    IBNR{8301148}, // Acquappesa railway halt
    IBNR{8301149}, // Arcola
    IBNR{8301154}, // Argenta railway station
    IBNR{8301155}, // Carimate railway station
    IBNR{8301160}, // Q3095675
    IBNR{8301162}, // Station Arsoli
    IBNR{8301163}, // Assemini railway station
    IBNR{8301168}, // Avio
    IBNR{8301169}, // Q3095712
    IBNR{8301174}, // Baricetta train station
    IBNR{8301176}, // Q3968945
    IBNR{8301177}, // Baiano di Spoleto railway station
    IBNR{8301178}, // Q16608779
    IBNR{8301179}, // Q3969003
    IBNR{8301180}, // Baldichieri-Tigliole station
    IBNR{8301182}, // Stazione di Borgo a Buggiano
    IBNR{8301186}, // Bracciano railway station
    IBNR{8301189}, // Berceto railway station
    IBNR{8301190}, // Bivio d’Aurisina railway station
    IBNR{8301195}, // Beffi railway station
    IBNR{8301197}, // Berchidda railway station
    IBNR{8301199}, // Q3095986
    IBNR{8301200}, // Bellinzago railway station
    IBNR{8301201}, // Q1115937
    IBNR{8301202}, // Barga-Gallicano
    IBNR{8301204}, // Brisighella railway station
    IBNR{8301209}, // Q3968946
    IBNR{8301212}, // Q17146357
    IBNR{8301213}, // Q3969040
    IBNR{8301222}, // Borgo a Mozzano
    IBNR{8301224}, // Q16268781
    IBNR{8301225}, // Bonorva railway station
    IBNR{8301226}, // Borgone railway station
    IBNR{8301227}, // Borore train station
    IBNR{8301228}, // Bogliasco station
    IBNR{8301229}, // Bolgheri railway station
    IBNR{8301231}, // Borgo Fornari per Voltaggio railway station
    IBNR{8301233}, // Q3969132
    IBNR{8301237}, // Bruzolo di Susa
    IBNR{8301238}, // Brandizzo railway station
    IBNR{8301239}, // Barbiano railway halt
    IBNR{8301242}, // Borgoratto railway halt
    IBNR{8301245}, // Bronzolo
    IBNR{8301246}, // Bellante-Ripattone railway station
    IBNR{8301248}, // Q20009382
    IBNR{8301250}, // Borghetto sull'Adige
    IBNR{8301257}, // Q17146356
    IBNR{8301259}, // Busseto railway station
    IBNR{8301263}, // Bugnara railway station
    IBNR{8301265}, // Buonconvento
    IBNR{8301267}, // Busalla railway station
    IBNR{8301268}, // Borgo Vercelli railway halt
    IBNR{8301270}, // Q1113920
    IBNR{8301271}, // Q3969106
    IBNR{8301273}, // Q16608838
    IBNR{8301274}, // Q3969006
    IBNR{8301276}, // Casteldaccia railway station
    IBNR{8301279}, // Q16608933
    IBNR{8301280}, // Q16609064
    IBNR{8301283}, // Castello d’Annone railway station
    IBNR{8301284}, // Capalbio
    IBNR{8301288}, // Q3969153
    IBNR{8301289}, // Cambiano-Santena station
    IBNR{8301290}, // Candelo railway halt
    IBNR{8301292}, // Carpignano Sesia railway station
    IBNR{8301300}, // Q16608942
    IBNR{8301302}, // Q16609017
    IBNR{8301305}, // Castelbuono railway station
    IBNR{8301306}, // Candia Canavese railway station
    IBNR{8301309}, // Q3969283
    IBNR{8301311}, // Coccaglio railway station
    IBNR{8301317}, // Q17146388
    IBNR{8301319}, // Q17494305
    IBNR{8301322}, // Cadeo railway halt
    IBNR{8301323}, // Caldiero railway station
    IBNR{8301325}, // Q3969159
    IBNR{8301326}, // Q3969256
    IBNR{8301331}, // Cengio
    IBNR{8301339}, // Q16609111
    IBNR{8301340}, // Q18785594
    IBNR{8301342}, // Camporgiano
    IBNR{8301344}, // Q3969367
    IBNR{8301346}, // Q19622702
    IBNR{8301350}, // Chiarone
    IBNR{8301351}, // Chiaravalle railway halt
    IBNR{8301353}, // Chieri railway station
    IBNR{8301354}, // Q16609034
    IBNR{8301357}, // Q3969231
    IBNR{8301359}, // Q16609052
    IBNR{8301367}, // Camnago-Lentate railway station
    IBNR{8301369}, // Q3969454
    IBNR{8301374}, // Castelvecchio Pascoli
    IBNR{8301375}, // Caluso railway station
    IBNR{8301377}, // Q3969160
    IBNR{8301379}, // Q3969458
    IBNR{8301380}, // Q19819441
    IBNR{8301384}, // Q16609067
    IBNR{8301386}, // Q3969184
    IBNR{8301387}, // Castellaneta Marina railway station
    IBNR{8301392}, // Q15714365
    IBNR{8301393}, // Cesano di Roma railway station
    IBNR{8301394}, // Q16268787
    IBNR{8301395}, // Q17637204
    IBNR{8301401}, // Contea-Londa railway station
    IBNR{8301402}, // Cogoleto
    IBNR{8301405}, // Q3969466
    IBNR{8301406}, // Corniglia
    IBNR{8301413}, // Capannelle railway station
    IBNR{8301414}, // Q3969189
    IBNR{8301415}, // Q3969457
    IBNR{8301418}, // Calopezzati Railway Station
    IBNR{8301419}, // Q16268782
    IBNR{8301424}, // Q3969157
    IBNR{8301425}, // Q19060595
    IBNR{8301426}, // Q17146373
    IBNR{8301429}, // Crescentino railway station
    IBNR{8301433}, // Stazione di Classe
    IBNR{8301435}, // Cassine train station
    IBNR{8301438}, // Q3969273
    IBNR{8301440}, // Cossato railway station
    IBNR{8301443}, // Calatabiano railway halt
    IBNR{8301444}, // Castelferretti-Falconara Aeroporto delle Marche railway halt
    IBNR{8301445}, // Castelguelfo railway station
    IBNR{8301447}, // Castelmaggiore railway station
    IBNR{8301448}, // Q3969164
    IBNR{8301451}, // Citerna Taro railway station
    IBNR{8301455}, // Q18420506
    IBNR{8301456}, // Cucciago railway station
    IBNR{8301461}, // Cavanella d’Adige railway station
    IBNR{8301466}, // Q17637176
    IBNR{8301470}, // Q17146374
    IBNR{8301471}, // Q3969518
    IBNR{8301475}, // Q16609149
    IBNR{8301476}, // Q16469209
    IBNR{8301477}, // Q3969535
    IBNR{8301480}, // Q16609140
    IBNR{8301482}, // Saline di Reggio train station
    IBNR{8301488}, // Q18923658
    IBNR{8301490}, // Enas railway station
    IBNR{8301491}, // Egna-Termeno
    IBNR{8301492}, // Q3969567
    IBNR{8301494}, // Cerda railway station
    IBNR{8301495}, // Q16609028
    IBNR{8301499}, // Falcone Station
    IBNR{8301501}, // Q3969642
    IBNR{8301503}, // Q3969616
    IBNR{8301505}, // Q19545547
    IBNR{8301507}, // Felizzano train station
    IBNR{8301508}, // Ferrania
    IBNR{8301510}, // Fivizzano-Gassano railway station
    IBNR{8301512}, // Fiumicino Aeroporto railway station
    IBNR{8301517}, // Q3969573
    IBNR{8301519}, // Q3969638
    IBNR{8301520}, // Q3969629
    IBNR{8301521}, // Q20009400
    IBNR{8301524}, // Framura railway station
    IBNR{8301525}, // Fratta train station
    IBNR{8301526}, // Frugarolo Boscomarengo railway station
    IBNR{8301530}, // Fara Sabina-Montelibretti train station
    IBNR{8301531}, // Q3969623
    IBNR{8301535}, // Q18844698
    IBNR{8301536}, // Fuscaldo railway station
    IBNR{8301537}, // Figline Valdarno railway station
    IBNR{8301539}, // Gaibanella railway station
    IBNR{8301543}, // Q3969687
    IBNR{8301546}, // Q3969678
    IBNR{8301549}, // Q3969693
    IBNR{8301557}, // Q3969746
    IBNR{8301558}, // Q16609279
    IBNR{8301562}, // Q17494292
    IBNR{8301566}, // Giampilieri railway station
    IBNR{8301569}, // Giave railway station
    IBNR{8301570}, // Giarole railway station
    IBNR{8301573}, // Q3969461
    IBNR{8301574}, // Q15714363
    IBNR{8301577}, // Q20009406
    IBNR{8301581}, // Colmegna railway halt
    IBNR{8301582}, // Godo railway halt
    IBNR{8301586}, // Q17637283
    IBNR{8301588}, // Q16268790
    IBNR{8301590}, // Q3969754
    IBNR{8301591}, // Q3969753
    IBNR{8301592}, // Q3969760
    IBNR{8301594}, // Genova Sturla
    IBNR{8301598}, // Q16609236
    IBNR{8301600}, // Isola del Cantone railway station
    IBNR{8301604}, // Q3969811
    IBNR{8301606}, // Q3969821
    IBNR{8301607}, // Incoronata railway station
    IBNR{8301612}, // Q17494296
    IBNR{8301613}, // Q3969900
    IBNR{8301615}, // Laives train station
    IBNR{8301616}, // Q17637327
    IBNR{8301617}, // Lavis
    IBNR{8301618}, // Q1115149
    IBNR{8301625}, // Letojanni railway station
    IBNR{8301627}, // Lunghezza railway station
    IBNR{8301628}, // La Giustiniana railway station
    IBNR{8301629}, // Lascari-Gratteri railway station
    IBNR{8301634}, // Q17637321
    IBNR{8301638}, // Lonato railway station
    IBNR{8301642}, // Q16508010
    IBNR{8301644}, // Q16609340
    IBNR{8301647}, // Q3969944
    IBNR{8301649}, // Luni Station
    IBNR{8301654}, // Magliana railway halt
    IBNR{8301658}, // Q3970025
    IBNR{8301661}, // Marano Ticino railway station
    IBNR{8301665}, // Manerbio
    IBNR{8301668}, // Q3970169
    IBNR{8301669}, // Q16609461
    IBNR{8301670}, // Q3970196
    IBNR{8301671}, // Q3969999
    IBNR{8301673}, // Q3970047
    IBNR{8301675}, // Q3970232
    IBNR{8301676}, // Magliano-Crava-Morozzo railway station
    IBNR{8301677}, // Mercenasco railway station
    IBNR{8301679}, // Q16609433
    IBNR{8301684}, // Q3970011
    IBNR{8301689}, // Q2460876
    IBNR{8301690}, // Melegnano railway station
    IBNR{8301691}, // Meina railway station
    IBNR{8301693}, // Q3970084
    IBNR{8301698}, // Mantova Frassine
    IBNR{8301700}, // Q17146400
    IBNR{8301701}, // Q20009982
    IBNR{8301704}, // Q19768359
    IBNR{8301705}, // Mongardino railway station
    IBNR{8301709}, // Q16609385
    IBNR{8301712}, // Miramare
    IBNR{8301716}, // Q3970188
    IBNR{8301717}, // Q3970065
    IBNR{8301721}, // Mira-Mirano railway halt
    IBNR{8301722}, // Q3969292
    IBNR{8301723}, // Magrè-Cortaccia
    IBNR{8301724}, // Q3970225
    IBNR{8301726}, // Q17145114
    IBNR{8301728}, // Q3970056
    IBNR{8301730}, // Q16609458
    IBNR{8301731}, // Q17145113
    IBNR{8301732}, // Q3970106
    IBNR{8301733}, // Q20009984
    IBNR{8301734}, // Medesano railway station
    IBNR{8301736}, // Q20009419
    IBNR{8301738}, // Q3970163
    IBNR{8301739}, // Q3970170
    IBNR{8301740}, // Moncalieri railway station
    IBNR{8301741}, // Q3970230
    IBNR{8301744}, // Mozzecane
    IBNR{8301747}, // Q3970143
    IBNR{8301748}, // Q19622707
    IBNR{8301749}, // Montenero-Petacciato railway station
    IBNR{8301750}, // Q16609371
    IBNR{8301752}, // Q19622705
    IBNR{8301753}, // Merana railway halt
    IBNR{8301754}, // Mombaldone-Roccaverano train station
    IBNR{8301757}, // Bari Marconi railway halt
    IBNR{8301758}, // Murlo
    IBNR{8301759}, // Q17637371
    IBNR{8301762}, // Q3970066
    IBNR{8301768}, // Q20009420
    IBNR{8301769}, // Q3970198
    IBNR{8301774}, // Marrubiu-Terralba-Arborea railway station
    IBNR{8301777}, // Monti-Telti railway station
    IBNR{8301778}, // Q19622704
    IBNR{8301779}, // Montegrosso railway station
    IBNR{8301780}, // Q3969451
    IBNR{8301781}, // Montanaro railway station
    IBNR{8301786}, // Montecorvino railway halt
    IBNR{8301787}, // Mulinetti railway station
    IBNR{8301790}, // Muratella railway halt
    IBNR{8301791}, // Q16609481
    IBNR{8301792}, // Q16609394
    IBNR{8301793}, // Q3097107
    IBNR{8301794}, // Q667146
    IBNR{8301795}, // Manziana-Canale Monterano
    IBNR{8301798}, // Q3970227
    IBNR{8301799}, // Q15070225
    IBNR{8301802}, // Station Navacchio
    IBNR{8301804}, // Nibbia railway halt
    IBNR{8301805}, // Nichelino railway station
    IBNR{8301808}, // Novara-Montalbano-Furnari railway station
    IBNR{8301809}, // Q3970289
    IBNR{8301811}, // None railway station
    IBNR{8301812}, // Q17146404
    IBNR{8301814}, // Q3970323
    IBNR{8301815}, // Nuovo Salario railway station
    IBNR{8301816}, // Q776522
    IBNR{8301819}, // Q3097235
    IBNR{8301821}, // Q17637425
    IBNR{8301827}, // Olevano railway station
    IBNR{8301828}, // Q16609518
    IBNR{8301829}, // Q16609515
    IBNR{8301832}, // Ostia Parmense railway station
    IBNR{8301835}, // Q3970350
    IBNR{8301836}, // Oriolo railway station
    IBNR{8301838}, // Q16609521
    IBNR{8301843}, // Oliveri-Tindari railway station
    IBNR{8301844}, // Ottavia railway station
    IBNR{8301849}, // Q3970380
    IBNR{8301854}, // Q3970471
    IBNR{8301857}, // Ponte a Tressa
    IBNR{8301858}, // Paulilatino railway station
    IBNR{8301859}, // Q20009427
    IBNR{8301860}, // Q16609593
    IBNR{8301861}, // Q3970463
    IBNR{8301862}, // Porcari
    IBNR{8301865}, // Portici-Ercolano station
    IBNR{8301871}, // Q3970603
    IBNR{8301874}, // Ponte di Brenta railway station
    IBNR{8301878}, // Q17146420
    IBNR{8301880}, // Piscina di Pinerolo railway station
    IBNR{8301885}, // Peri railway station
    IBNR{8301886}, // Pessione railway station
    IBNR{8301887}, // Q17146417
    IBNR{8301892}, // Q3970547
    IBNR{8301894}, // Pietrabissara railway station
    IBNR{8301898}, // Q17637455
    IBNR{8301900}, // Piano Orizzontale railway station
    IBNR{8301902}, // Railway Station of Praja-Ajeta-Tortora
    IBNR{8301903}, // Pieve Ligure
    IBNR{8301904}, // Q16609569
    IBNR{8301905}, // Q16468369
    IBNR{8301906}, // Ploaghe railway station
    IBNR{8301907}, // Q20009428
    IBNR{8301908}, // Q16609566
    IBNR{8301915}, // Ponte a Moriano
    IBNR{8301916}, // Q16268799
    IBNR{8301917}, // Q20009824
    IBNR{8301918}, // Q3970392
    IBNR{8301919}, // Pontenure railway station
    IBNR{8301921}, // Q3970494
    IBNR{8301922}, // Poggio Fidoni railway halt
    IBNR{8301923}, // Poggio Mirteto railway station
    IBNR{8301925}, // Q16609682
    IBNR{8301926}, // Q3970504
    IBNR{8301928}, // Q16609623
    IBNR{8301931}, // Q16609685
    IBNR{8301935}, // Q3970605
    IBNR{8301938}, // Q3970609
    IBNR{8301942}, // Q16609697
    IBNR{8301948}, // Pratola Peligna Superiore railway station
    IBNR{8301949}, // Q15714375
    IBNR{8301954}, // Q3970548
    IBNR{8301955}, // Q3970550
    IBNR{8301957}, // Q3970546
    IBNR{8301961}, // Q16609611
    IBNR{8301965}, // Porto di Vasto railway station
    IBNR{8301971}, // Quercianella-Sonnino railway station
    IBNR{8301974}, // Quiliano-Vado Ligure
    IBNR{8301975}, // Q3970631
    IBNR{8301976}, // Q3970660
    IBNR{8301980}, // Q3970694
    IBNR{8301983}, // Q17637491
    IBNR{8301986}, // Roccastrada train station
    IBNR{8301989}, // Q3970692
    IBNR{8301990}, // Q15617142
    IBNR{8301991}, // Q15617141
    IBNR{8301996}, // Q3970650
    IBNR{8302001}, // Ripafratta
    IBNR{8302003}, // Q17637520
    IBNR{8302005}, // Rigoli
    IBNR{8302006}, // Rigoroso railway station
    IBNR{8302009}, // Q20009447
    IBNR{8302012}, // Riva Trigoso station
    IBNR{8302013}, // Q15714372
    IBNR{8302016}, // Roma Balduina
    IBNR{8302017}, // Q18844701
    IBNR{8302019}, // Roma Nomentana railway station
    IBNR{8302020}, // Q16268802
    IBNR{8302021}, // Rosta railway halt
    IBNR{8302022}, // Q3970686
    IBNR{8302023}, // Rodallo railway station
    IBNR{8302029}, // Q3970663
    IBNR{8302037}, // Rosolina railway halt
    IBNR{8302039}, // Q3970724
    IBNR{8302041}, // Q3970716
    IBNR{8302045}, // Q3970746
    IBNR{8302046}, // Rudalza railway station
    IBNR{8302047}, // Rufina railway station
    IBNR{8302049}, // Roverbella
    IBNR{8302051}, // Q3970741
    IBNR{8302062}, // Samoggia railway halt
    IBNR{8302063}, // Sartirana railway station
    IBNR{8302065}, // Salussola railway station
    IBNR{8302067}, // Q3970780
    IBNR{8302073}, // Cala Sabina railway station
    IBNR{8302074}, // Scarlino
    IBNR{8302076}, // Sticciano
    IBNR{8302078}, // Scala di Giocca railway station
    IBNR{8302083}, // Q3970929
    IBNR{8302085}, // Sella di Corno railway station
    IBNR{8302088}, // Q18590151
    IBNR{8302099}, // Serravalle Scrivia railway station
    IBNR{8302103}, // Q3970958
    IBNR{8302106}, // Q3971008
    IBNR{8302109}, // Q3970922
    IBNR{8302114}, // Q3970972
    IBNR{8302122}, // Q17494294
    IBNR{8302124}, // Sieci railway halt
    IBNR{8302127}, // Sinalunga train station
    IBNR{8302129}, // Siliqua railway station
    IBNR{8302130}, // Samassi-Serrenti railway station
    IBNR{8302131}, // Q16609881
    IBNR{8302132}, // Q16609770
    IBNR{8302133}, // Q19622699
    IBNR{8302139}, // Salone railway station
    IBNR{8302140}, // Solignano train station
    IBNR{8302143}, // Q3970765
    IBNR{8302144}, // Q3971004
    IBNR{8302148}, // Q3970910
    IBNR{8302151}, // Q16609919
    IBNR{8302156}, // Q3970933
    IBNR{8302162}, // Q3970890
    IBNR{8302163}, // Sangiano railway halt
    IBNR{8302165}, // Serramanna-Nuraminis railway station
    IBNR{8302167}, // Solero railway station
    IBNR{8302170}, // Q16609932
    IBNR{8302172}, // Q3971021
    IBNR{8302179}, // Q3971030
    IBNR{8302180}, // Spinetta
    IBNR{8302182}, // Q19622714
    IBNR{8302186}, // Q16508066
    IBNR{8302189}, // Q16609922
    IBNR{8302191}, // Q17637559
    IBNR{8302193}, // Q3971053
    IBNR{8302195}, // Q3971051
    IBNR{8302197}, // Salorno
    IBNR{8302206}, // Q19060599
    IBNR{8302209}, // Q3971046
    IBNR{8302211}, // Strambino railway station
    IBNR{8302213}, // Santuario railway station
    IBNR{8302215}, // Solarussa railway station
    IBNR{8302216}, // Su Canale railway station
    IBNR{8302218}, // Suzzara railway station
    IBNR{8302220}, // Sistiana-Visogliano
    IBNR{8302223}, // Q3970951
    IBNR{8302228}, // Salzano-Robegano train station
    IBNR{8302233}, // Talamone
    IBNR{8302236}, // Trabia railway halt
    IBNR{8302237}, // Travedona-Biandronno railway halt
    IBNR{8302239}, // Tassignano-Capannori
    IBNR{8302242}, // Torricola railway station
    IBNR{8302243}, // Q17637588
    IBNR{8302244}, // Tre Croci
    IBNR{8302245}, // Q20009827
    IBNR{8302248}, // Q3971110
    IBNR{8302252}, // Terria train station
    IBNR{8302254}, // Treviglio Ovest railway halt
    IBNR{8302256}, // Q17637600
    IBNR{8302258}, // Q3971107
    IBNR{8302260}, // Q16609970
    IBNR{8302266}, // Torre del Lago Puccini
    IBNR{8302267}, // Q16609973
    IBNR{8302274}, // Torre del Greco station
    IBNR{8302275}, // Trecate railway station
    IBNR{8302279}, // Q3971204
    IBNR{8302281}, // Q16609990
    IBNR{8302282}, // Tor Sapienza railway station
    IBNR{8302289}, // Torviscosa railway station
    IBNR{8302290}, // Ternate-Varano Borghi railway station
    IBNR{8302291}, // Q3971198
    IBNR{8302292}, // Q3971090
    IBNR{8302294}, // Ugovizza railway station
    IBNR{8302295}, // Uras-Mogoro railway station
    IBNR{8302297}, // Vaprio d’Agogna railway station
    IBNR{8302299}, // Q3971226
    IBNR{8302300}, // Villanova d'Asti railway station
    IBNR{8302302}, // Vigliano d'Asti railway station
    IBNR{8302305}, // Vicchio railway station
    IBNR{8302307}, // Vicofertile railway station
    IBNR{8302309}, // Q3971294
    IBNR{8302312}, // Q3971318
    IBNR{8302313}, // Q18510373
    IBNR{8302314}, // Villadossola railway station
    IBNR{8302315}, // Villanova d'Arda railway station
    IBNR{8302318}, // Q3971270
    IBNR{8302320}, // Q3971278
    IBNR{8302325}, // Vigna di Valle
    IBNR{8302332}, // Villasor railway station
    IBNR{8302333}, // Vigonza-Pianiga station
    IBNR{8302335}, // Q3971353
    IBNR{8302337}, // Villazzano railway station
    IBNR{8302339}, // Valmadonna railway station
    IBNR{8302343}, // Valle Lomellina railway station
    IBNR{8302344}, // Villaspeciosa-Uta railway station
    IBNR{8302346}, // Q17637637
    IBNR{8302354}, // Q20010074
    IBNR{8302355}, // Venezia Porto Marghera railway station
    IBNR{8302356}, // Villanova di Reggiolo railway halt
    IBNR{8302357}, // Q20009467
    IBNR{8302358}, // Q16268808
    IBNR{8302364}, // Q3971344
    IBNR{8302367}, // Villastellone
    IBNR{8302369}, // Q3971239
    IBNR{8302377}, // Q3971380
    IBNR{8302378}, // Q3969278
    IBNR{8302380}, // Q16487703
    IBNR{8302385}, // Q16608776
    IBNR{8302389}, // Q16608817
    IBNR{8302417}, // Q3970394
    IBNR{8302420}, // railway station of Picerno
    IBNR{8302421}, // Q16609621
    IBNR{8302425}, // Q3970758
    IBNR{8302426}, // Q16609768
    IBNR{8302429}, // Stazione di Tito
    IBNR{8302430}, // Q16610005
    IBNR{8302432}, // Priolo-Melilli railway station
    IBNR{8302438}, // Spezzano Albanese Terme railway station
    IBNR{8302439}, // Castiglione Cosentino railway station
    IBNR{8302441}, // Q17146415
    IBNR{8302445}, // Q16608713
    IBNR{8302447}, // Q3968819
    IBNR{8302449}, // Albano Laziale railway station
    IBNR{8302450}, // Alfedena-Scontrone railway station
    IBNR{8302451}, // Altamura railway station
    IBNR{8302453}, // Q3968883
    IBNR{8302454}, // Q16608749
    IBNR{8302455}, // Q3968884
    IBNR{8302457}, // Q3968886
    IBNR{8302458}, // Q3968905
    IBNR{8302460}, // Q3968941
    IBNR{8302461}, // Q16608770
    IBNR{8302463}, // Bagnoli-Agnano Terme railway station
    IBNR{8302465}, // Balsorano railway station
    IBNR{8302466}, // Q3968965
    IBNR{8302467}, // Bari Zona Industriale railway station
    IBNR{8302468}, // Q3968994
    IBNR{8302469}, // Q3968997
    IBNR{8302472}, // Boiano rail station
    IBNR{8302484}, // Q17056899
    IBNR{8302488}, // Q3969191
    IBNR{8302489}, // Canistro railway halt
    IBNR{8302490}, // Q3969196
    IBNR{8302491}, // Q3969201
    IBNR{8302493}, // Q3969202
    IBNR{8302494}, // Q3969207
    IBNR{8302495}, // Q3969209
    IBNR{8302496}, // Capocroce railway halt
    IBNR{8302498}, // Q3969226
    IBNR{8302499}, // Carovilli-Roccasicura railway station
    IBNR{8302500}, // Carpinone railway station
    IBNR{8302501}, // Q3969249
    IBNR{8302507}, // Q3969308
    IBNR{8302508}, // Castel di Sangro railway station
    IBNR{8302509}, // Castel Gandolfo train station
    IBNR{8302510}, // Castel Lagopesole railway station
    IBNR{8302515}, // Cavalleggeri Aosta railway station
    IBNR{8302516}, // Q3969359
    IBNR{8302520}, // Q3969426
    IBNR{8302521}, // Q3969431
    IBNR{8302522}, // Q3969444
    IBNR{8302523}, // Q3969449
    IBNR{8302524}, // Comiso railway station
    IBNR{8302528}, // Q3969507
    IBNR{8302530}, // Donnafugata railway station
    IBNR{8302532}, // Q16609169
    IBNR{8302534}, // Fiera railway station
    IBNR{8302536}, // Filiano railway station
    IBNR{8302537}, // Q3969620
    IBNR{8302538}, // Q3969633
    IBNR{8302539}, // Q3969634
    IBNR{8302540}, // Forenza train station
    IBNR{8302543}, // Q16609213
    IBNR{8302544}, // Frascati railway station
    IBNR{8302548}, // Q17056904
    IBNR{8302551}, // Giachery railway halt
    IBNR{8302552}, // Giugliano-Qualiano railway station
    IBNR{8302555}, // Gravina in Puglia railway station
    IBNR{8302556}, // Q16609285
    IBNR{8302559}, // Isernia railway station
    IBNR{8302560}, // Isola delle Femmine railway station
    IBNR{8302561}, // Q3969828
    IBNR{8302562}, // Q16609304
    IBNR{8302564}, // La Fiora railway halt
    IBNR{8302565}, // Q3969915
    IBNR{8302566}, // Q3969917
    IBNR{8302567}, // Larino railway station
    IBNR{8302568}, // Latiano railway station
    IBNR{8302571}, // Q16609347
    IBNR{8302572}, // Q3969964
    IBNR{8302576}, // Manfredonia railway station
    IBNR{8302577}, // Q17056891
    IBNR{8302578}, // Q3970042
    IBNR{8302581}, // Q3970081
    IBNR{8302583}, // Mesagne railway station
    IBNR{8302584}, // Q3970128
    IBNR{8302587}, // Minervino Murge railway station
    IBNR{8302593}, // Montella Station
    IBNR{8302599}, // Q17637409
    IBNR{8302603}, // Q3970233
    IBNR{8302607}, // Nettuno railway station
    IBNR{8302608}, // Q3970310
    IBNR{8302609}, // Noto railway station
    IBNR{8302611}, // Q3970344
    IBNR{8302613}, // Q17056890
    IBNR{8302614}, // Q16609551
    IBNR{8302619}, // Pantanella station
    IBNR{8302621}, // Q3970429
    IBNR{8302622}, // Q3970432
    IBNR{8302624}, // Q3970453
    IBNR{8302625}, // Pescolanciano-Chiauci railway station
    IBNR{8302631}, // Napoli Piazza Amedeo railway station
    IBNR{8302632}, // Napoli Piazza Cavour railway halt
    IBNR{8302633}, // Q16609605
    IBNR{8302635}, // Q16482098
    IBNR{8302636}, // Poggiorsini railway station
    IBNR{8302639}, // Possidente railway station
    IBNR{8302640}, // Q3970591
    IBNR{8302642}, // Pozzallo railway station
    IBNR{8302643}, // Pozzuoli Solfatara railway station
    IBNR{8302645}, // Quarto di Marano railway halt
    IBNR{8302652}, // Ridotti-Collepiano railway halt
    IBNR{8302653}, // Q3970673
    IBNR{8302657}, // Roccaraso railway station
    IBNR{8302658}, // Q3970693
    IBNR{8302660}, // Q16609750
    IBNR{8302661}, // Q3970743
    IBNR{8302684}, // Q3970764
    IBNR{8302686}, // Q16609786
    IBNR{8302689}, // Q3970899
    IBNR{8302692}, // Q3970902
    IBNR{8302694}, // Q3970911
    IBNR{8302695}, // Q16609884
    IBNR{8302696}, // Q3970931
    IBNR{8302697}, // Q3970942
    IBNR{8302699}, // Sessano del Molise railway station
    IBNR{8302701}, // Siponto railway halt
    IBNR{8302703}, // Q3971017
    IBNR{8302704}, // Q17056893
    IBNR{8302705}, // Spinazzola railway station
    IBNR{8302709}, // Terracina railway halt
    IBNR{8302710}, // Q17056895
    IBNR{8302713}, // Palermo Tommaso Natale railway halt
    IBNR{8302721}, // Vastogirardi railway station
    IBNR{8302722}, // Velletri railway station
    IBNR{8302723}, // Venafro rail station
    IBNR{8302724}, // Q3971262
    IBNR{8302725}, // Vespri railway halt
    IBNR{8302727}, // Q16610056
    IBNR{8302729}, // Q3971339
    IBNR{8302730}, // Q3971341
    IBNR{8302731}, // Frasso railway halt
    IBNR{8302732}, // Bragno
    IBNR{8302734}, // Piraineto railway station
    IBNR{8302736}, // Q3970055
    IBNR{8302737}, // Scopeti railway halt
    IBNR{8302740}, // La Storta railway station
    IBNR{8302751}, // Q3968911
    IBNR{8302753}, // Napoli Montesanto railway halt
    IBNR{8302768}, // Q3969701
    IBNR{8302774}, // Fidene railway station
    IBNR{8302782}, // Povo-Mesiano train station
    IBNR{8302788}, // Anconetta railway station
    IBNR{8302789}, // Genova Vesima
    IBNR{8302790}, // Villa Bonelli
    IBNR{8302795}, // Q3969621
    IBNR{8302796}, // Q16609984
    IBNR{8302807}, // Q17637358
    IBNR{8302809}, // Q17637235
    IBNR{8302811}, // Q17637376
    IBNR{8302812}, // Preglia railway station
    IBNR{8302813}, // Varzo railway station
    IBNR{8302814}, // Iselle di Trasquera railway station
    IBNR{8302816}, // Q17637214
    IBNR{8302817}, // Q17637611
    IBNR{8302818}, // Q17637630
    IBNR{8302819}, // Q17637373
    IBNR{8302820}, // Q17637193
    IBNR{8302821}, // Q17637269
    IBNR{8302822}, // Q17637147
    IBNR{8302823}, // Q17637478
    IBNR{8302824}, // Q17637645
    IBNR{8302826}, // Folsogno-Dissimo railway station
    IBNR{8302828}, // Q17637494
    IBNR{8302830}, // Valle Aurelia railway station
    IBNR{8302831}, // Ipogeo degli Ottavi railway station
    IBNR{8302832}, // Olgiata railway station
    IBNR{8302917}, // Q3969018
    IBNR{8302958}, // Q16609084
    IBNR{8303051}, // Busto Arsizio Nord railway station
    IBNR{8303225}, // Q3969017
    IBNR{8303226}, // Q3969379
    IBNR{8303722}, // Volpiano railway station
    IBNR{8303731}, // Rivarolo Canavese railway station
    IBNR{8303887}, // Q3971213
    IBNR{8303905}, // Malpensa T1 railway station
    IBNR{8303915}, // Tarvisio Boscoverde railway station
    IBNR{8303923}, // Q3971126
    IBNR{8303925}, // Gemelli railway halt
    IBNR{8303930}, // Q3970398
    IBNR{8303931}, // Punta Raisi railway station
    IBNR{8303939}, // Torino Rebaudengo Fossata railway station
    IBNR{8303940}, // Borgochiesanuova
    IBNR{8304132}, // Q3969920
    IBNR{8304223}, // Genova Via di Francia railway halt
    IBNR{8305010}, // Q3969158
    IBNR{8305011}, // Vaio-Ospedale railway station
    IBNR{8305055}, // Ozzano dell'Emilia railway halt
    IBNR{8305081}, // Bologna San Vitale railway halt
    IBNR{8305114}, // Q16268795
    IBNR{8305138}, // Q3970641
    IBNR{8305140}, // Bologna Mazzini railway halt
    IBNR{8305268}, // Q17637480
    IBNR{8306013}, // Q3968928
    IBNR{8306426}, // Prato Borgonuovo railway halt
    IBNR{8306900}, // Quattro Venti railway station
    IBNR{8307019}, // Pescara Tribunale railway halt
    IBNR{8307020}, // Q18923659
    IBNR{8307114}, // Q16608740
    IBNR{8307117}, // Q3969577
    IBNR{8307805}, // Q20009826
    IBNR{8308415}, // Fiera di Roma railway station
    IBNR{8308509}, // Palmiro Togliatti railway station
    IBNR{8308514}, // Serenissima railway station
    IBNR{8309419}, // Q3971033
    IBNR{8309911}, // Q3969903
    IBNR{8312001}, // Q16609184
    IBNR{8312003}, // Q16609427
    IBNR{8312005}, // Q16609651
    IBNR{8312023}, // Q16609200
    IBNR{8312035}, // Ficarazzi railway station
    IBNR{8312059}, // Q16609817
    IBNR{8312060}, // Q16609654
    IBNR{8312061}, // Torregrotta railway station
    IBNR{8312808}, // Assemini Santa Lucia railway station
    IBNR{8312809}, // Assemini Carmine railway station
    IBNR{8312818}, // Carbonia Serbariu railway station
    IBNR{8312819}, // Elmas Aeroporto railway station
    IBNR{8314428}, // Casteldebole railway station
    IBNR{8318090}, // Q3970848
    IBNR{8319371}, // Ferno-Lonate Pozzolo railway station
    IBNR{8336329}, // Q16608743
    IBNR{8340987}, // Q3095652
    IBNR{8342619}, // Pescara San Marco railway halt
    IBNR{8343509}, // Funo Centergross station
    IBNR{8346369}, // Q3969255
    IBNR{8350539}, // Parco Leonardo railway station
    IBNR{8351381}, // Q3969671
    IBNR{8358110}, // Q3969227
    IBNR{8362035}, // Q22692924
    IBNR{8367679}, // Levata railway halt
    IBNR{8368886}, // San Giovanni di Casarsa railway halt
    IBNR{8377438}, // Stazione di Perugia Silvestrini
    IBNR{8378364}, // Q3095653
    IBNR{8381587}, // Grugliasco
    IBNR{8389072}, // Castellaneta railway station
    IBNR{8392019}, // Osteria Nuova railway halt
    IBNR{8396626}, // Q3971259
    IBNR{8400004}, // Leeuwarden Achter de Hoven railway station
    IBNR{8400005}, // Hillegom
    IBNR{8400010}, // Houten Castellum railway station
    IBNR{8400011}, // Glanerbrug railway station
    IBNR{8400012}, // Enschede De Eschmarke railway station
    IBNR{8400013}, // Winterswijk West railway station
    IBNR{8400015}, // Rotterdam Stadion railway station
    IBNR{8400016}, // Nijmegen Lent railway station
    IBNR{8400021}, // Tilburg Reeshof railway station
    IBNR{8400022}, // Utrecht Terwijde railway station
    IBNR{8400024}, // Almere Oostvaarders railway station
    IBNR{8400027}, // Station Utrecht Maliebaan
    IBNR{8400029}, // Arnhem Zuid railway station
    IBNR{8400030}, // Den Haag Ypenburg
    IBNR{8400031}, // Amersfoort Vathorst railway station
    IBNR{8400032}, // Apeldoorn De Maten railway station
    IBNR{8400033}, // Apeldoorn Osseveld railway station
    IBNR{8400034}, // Gaanderen railway station
    IBNR{8400035}, // Helmond Brandevoort railway station
    IBNR{8400036}, // Tiel Passewaaij railway station
    IBNR{8400037}, // Twello railway station
    IBNR{8400038}, // Voorst-Empe railway station
    IBNR{8400039}, // Utrecht Zuilen railway station
    IBNR{8400042}, // Groningen Europapark railway station
    IBNR{8400043}, // Eygelshoven Markt railway station
    IBNR{8400044}, // Heerlen de Kissel railway station
    IBNR{8400045}, // Aalten railway station
    IBNR{8400046}, // Purmerend Weidevenne railway station
    IBNR{8400047}, // Abcoude railway station
    IBNR{8400049}, // Akkrum railway station
    IBNR{8400050}, // Alkmaar railway station
    IBNR{8400051}, // Almelo railway station
    IBNR{8400052}, // Alkmaar Noord railway station
    IBNR{8400053}, // Alphen aan den Rijn railway station
    IBNR{8400054}, // Amersfoort Schothorst railway station
    IBNR{8400055}, // Amersfoort railway station
    IBNR{8400056}, // Amsterdam RAI
    IBNR{8400057}, // Amsterdam Amstel
    IBNR{8400058}, // Amsterdam Centraal
    IBNR{8400059}, // Amsterdam Sloterdijk
    IBNR{8400060}, // Amsterdam Muiderpoort railway station
    IBNR{8400061}, // Amsterdam Zuid
    IBNR{8400065}, // Anna Paulowna railway station
    IBNR{8400066}, // Apeldoorn railway station
    IBNR{8400067}, // Appingedam railway station
    IBNR{8400068}, // Arkel railway station
    IBNR{8400069}, // Arnemuiden railway station
    IBNR{8400071}, // Arnhem railway station
    IBNR{8400072}, // Arnhem Velperpoort railway station
    IBNR{8400073}, // Assen railway station
    IBNR{8400074}, // Amsterdam Bijlmer ArenA
    IBNR{8400075}, // Arnhem Presikhaaf railway station
    IBNR{8400076}, // Amsterdam Holendrecht
    IBNR{8400077}, // Mook-Molenhoek railway station
    IBNR{8400079}, // Amsterdam Lelylaan
    IBNR{8400080}, // Almere Centrum railway station
    IBNR{8400081}, // Almere Buiten railway station
    IBNR{8400082}, // Almere Muziekwijk railway station
    IBNR{8400083}, // Amsterdam Science Park railway station
    IBNR{8400086}, // Baarn railway station
    IBNR{8400087}, // Heerlen Woonboulevard railway station
    IBNR{8400088}, // Maarheeze railway station
    IBNR{8400089}, // Baflo railway station
    IBNR{8400090}, // Barendrecht railway station
    IBNR{8400091}, // Barneveld Centrum railway station
    IBNR{8400092}, // Barneveld Noord railway station
    IBNR{8400093}, // Emmen Zuid railway station
    IBNR{8400094}, // Bedum railway station
    IBNR{8400095}, // Veendam railway station
    IBNR{8400096}, // Beek-Elsloo railway station
    IBNR{8400097}, // Beesd railway station
    IBNR{8400098}, // Boven Hardinxveld railway station
    IBNR{8400100}, // Beilen railway station
    IBNR{8400101}, // Sliedrecht Baanhoek railway station
    IBNR{8400102}, // Sassenheim railway station
    IBNR{8400103}, // Westervoort railway station
    IBNR{8400104}, // Hardinxveld Blauwe Zoom railway station
    IBNR{8400108}, // Bergen op Zoom railway station
    IBNR{8400109}, // Nijmegen Goffert railway station
    IBNR{8400111}, // Barneveld Zuid railway station
    IBNR{8400113}, // Beverwijk railway station
    IBNR{8400114}, // Bilthoven railway station
    IBNR{8400117}, // Blerick railway station
    IBNR{8400118}, // Bloemendaal railway station
    IBNR{8400121}, // Bodegraven railway station
    IBNR{8400125}, // Boskoop railway station
    IBNR{8400127}, // Bovenkarspel-Grootebroek railway station
    IBNR{8400128}, // Boxmeer railway station
    IBNR{8400129}, // Boxtel railway station
    IBNR{8400131}, // Breda railway station
    IBNR{8400132}, // Breda-Prinsenbeek railway station
    IBNR{8400133}, // Breukelen railway station
    IBNR{8400136}, // Brummen railway station
    IBNR{8400139}, // Buitenpost railway station
    IBNR{8400140}, // Bunde railway station
    IBNR{8400141}, // Bunnik railway station
    IBNR{8400145}, // Bussum Zuid railway station
    IBNR{8400147}, // Capelle Schollevaar railway station
    IBNR{8400151}, // Castricum railway station
    IBNR{8400152}, // Chevremont railway station
    IBNR{8400153}, // Coevorden railway station
    IBNR{8400154}, // Culemborg railway station
    IBNR{8400155}, // Cuijk railway station
    IBNR{8400161}, // Dalen railway station
    IBNR{8400163}, // Diemen Zuid
    IBNR{8400164}, // Daarlerveen railway station
    IBNR{8400165}, // Diemen railway station
    IBNR{8400166}, // Delft Zuid railway station
    IBNR{8400167}, // Dalfsen railway station
    IBNR{8400168}, // Deinum railway station
    IBNR{8400169}, // Delden railway station
    IBNR{8400170}, // Delft railway station
    IBNR{8400171}, // Delfzijl railway station
    IBNR{8400172}, // Deurne railway station
    IBNR{8400173}, // Deventer railway station
    IBNR{8400174}, // Didam railway station
    IBNR{8400175}, // Delfzijl West railway station
    IBNR{8400176}, // Dieren railway station
    IBNR{8400177}, // Doetinchem railway station
    IBNR{8400179}, // Den Dolder railway station
    IBNR{8400180}, // Dordrecht railway station
    IBNR{8400181}, // Dordrecht Zuid railway station
    IBNR{8400182}, // Driebergen-Zeist railway station
    IBNR{8400183}, // Driehuis railway station
    IBNR{8400184}, // Doetinchem De Huet railway station
    IBNR{8400185}, // Deventer Colmschate railway station
    IBNR{8400186}, // Dordrecht Stadspolders railway station
    IBNR{8400188}, // De Vink railway station
    IBNR{8400192}, // Dronrijp railway station
    IBNR{8400193}, // Duiven railway station
    IBNR{8400194}, // Duivendrecht
    IBNR{8400196}, // Eindhoven Strijp-S railway station
    IBNR{8400198}, // Dronten railway station
    IBNR{8400200}, // Ede-Wageningen railway station
    IBNR{8400201}, // Ede Centrum railway station
    IBNR{8400206}, // Eindhoven railway station
    IBNR{8400208}, // Emmen railway station
    IBNR{8400210}, // Enkhuizen railway station
    IBNR{8400212}, // Enschede railway station
    IBNR{8400213}, // Enschede Drienerlo railway station
    IBNR{8400216}, // Ermelo railway station
    IBNR{8400218}, // Etten-Leur railway station
    IBNR{8400219}, // Eijsden railway station
    IBNR{8400230}, // Bovenkarspel Flora railway station
    IBNR{8400232}, // Franeker railway station
    IBNR{8400239}, // Geerdijk railway station
    IBNR{8400244}, // Geldermalsen railway station
    IBNR{8400245}, // Geldrop railway station
    IBNR{8400246}, // Geleen Oost railway station
    IBNR{8400248}, // Geleen-Lutterade railway station
    IBNR{8400251}, // Gilze-Rijen railway station
    IBNR{8400253}, // Goes railway station
    IBNR{8400254}, // Goor railway station
    IBNR{8400256}, // Gorinchem railway station
    IBNR{8400257}, // Gouda Goverwelle railway station
    IBNR{8400258}, // Gouda railway station
    IBNR{8400259}, // Gramsbergen railway station
    IBNR{8400263}, // Groningen railway station
    IBNR{8400264}, // Groningen Noord railway station
    IBNR{8400266}, // Grou-Jirnsum railway station
    IBNR{8400267}, // Grijpskerk railway station
    IBNR{8400278}, // Den Haag Mariahoeve
    IBNR{8400279}, // Den Haag Moerwijk
    IBNR{8400280}, // Den Haag Hollands Spoor
    IBNR{8400282}, // Den Haag Centraal
    IBNR{8400285}, // Haarlem railway station
    IBNR{8400292}, // Hurdegaryp railway station
    IBNR{8400293}, // Hardenberg railway station
    IBNR{8400294}, // Harderwijk railway station
    IBNR{8400295}, // Hardinxveld-Giessendam railway station
    IBNR{8400296}, // Harlingen railway station
    IBNR{8400297}, // Haren railway station
    IBNR{8400299}, // Helmond Brouwhuis railway station
    IBNR{8400300}, // Helmond 't Hout railway station
    IBNR{8400302}, // Heemstede-Aerdenhout
    IBNR{8400303}, // Den Helder Zuid railway station
    IBNR{8400305}, // Heerenveen railway station
    IBNR{8400306}, // Heerhugowaard railway station
    IBNR{8400307}, // Heerlen railway station
    IBNR{8400308}, // Heeze railway station
    IBNR{8400309}, // Heiloo railway station
    IBNR{8400310}, // Heino railway station
    IBNR{8400311}, // Den Helder railway station
    IBNR{8400312}, // Hengelo Oost railway station
    IBNR{8400313}, // Helmond railway station
    IBNR{8400315}, // Hemmen-Dodewaard railway station
    IBNR{8400316}, // Hengelo railway station
    IBNR{8400317}, // Heemskerk railway station
    IBNR{8400319}, // 's-Hertogenbosch railway station
    IBNR{8400320}, // 's-Hertogenbosch Oost railway station
    IBNR{8400322}, // Hilversum railway station
    IBNR{8400323}, // Hindeloopen railway station
    IBNR{8400324}, // Hilversum Media Park railway station
    IBNR{8400325}, // Hoek van Holland Haven railway station
    IBNR{8400326}, // Hoensbroek railway station
    IBNR{8400327}, // Hollandsche Rading railway station
    IBNR{8400328}, // Holten railway station
    IBNR{8400330}, // Hoogeveen railway station
    IBNR{8400331}, // Hoogezand-Sappemeer railway station
    IBNR{8400332}, // Hoofddorp railway station
    IBNR{8400334}, // Hoogkarspel railway station
    IBNR{8400336}, // Hoorn Kersenboogerd railway station
    IBNR{8400337}, // Hoorn railway station
    IBNR{8400338}, // Eygelshoven railway station
    IBNR{8400339}, // Horst-Sevenum railway station
    IBNR{8400340}, // Houten railway station
    IBNR{8400341}, // Houthem-Sint Gerlach railway station
    IBNR{8400353}, // Kampen railway station
    IBNR{8400354}, // Kapelle-Biezelinge railway station
    IBNR{8400355}, // Kerkrade Centrum railway station
    IBNR{8400359}, // Kesteren railway station
    IBNR{8400360}, // Kampen Zuid railway station
    IBNR{8400361}, // Klarenbeek railway station
    IBNR{8400362}, // Klimmen-Ransdaal railway station
    IBNR{8400363}, // Koog aan de Zaan railway station
    IBNR{8400364}, // Zaandijk Zaanse Schans railway station
    IBNR{8400366}, // Koudum-Molkwerum railway station
    IBNR{8400367}, // Krabbendijke railway station
    IBNR{8400368}, // Krommenie-Assendelft railway station
    IBNR{8400369}, // Kropswolde railway station
    IBNR{8400370}, // Kruiningen-Yerseke railway station
    IBNR{8400380}, // Den Haag Laan van NOI
    IBNR{8400382}, // Lage Zwaluwe railway station
    IBNR{8400384}, // Leiden Lammenschans railway station
    IBNR{8400386}, // Leerdam railway station
    IBNR{8400387}, // Leeuwarden railway station
    IBNR{8400389}, // Leeuwarden Camminghaburen railway station
    IBNR{8400390}, // Leiden Centraal railway station
    IBNR{8400394}, // Lelystad Centrum railway station
    IBNR{8400395}, // Lichtenvoorde-Groenlo railway station
    IBNR{8400399}, // Lochem railway station
    IBNR{8400400}, // Halfweg-Zwanenburg railway station
    IBNR{8400403}, // Loppersum railway station
    IBNR{8400405}, // Lunteren railway station
    IBNR{8400417}, // Maarn railway station
    IBNR{8400419}, // Maarssen railway station
    IBNR{8400421}, // Maassluis West railway station
    IBNR{8400422}, // Maassluis railway station
    IBNR{8400424}, // Maastricht railway station
    IBNR{8400426}, // Maastricht Randwyck railway station
    IBNR{8400427}, // Mantgum railway station
    IBNR{8400428}, // Mariënberg railway station
    IBNR{8400430}, // Martenshoek railway station
    IBNR{8400433}, // Hengelo Gezondheidspark railway station
    IBNR{8400434}, // Meerssen railway station
    IBNR{8400435}, // Meppel railway station
    IBNR{8400436}, // Middelburg railway station
    IBNR{8400449}, // Maastricht Noord railway station
    IBNR{8400450}, // Almere Poort railway station
    IBNR{8400452}, // Naarden-Bussum railway station
    IBNR{8400454}, // Nieuw Amsterdam railway station
    IBNR{8400455}, // Nieuwerkerk aan den IJssel railway station
    IBNR{8400457}, // Bad Nieuweschans railway station
    IBNR{8400460}, // Nieuw Vennep railway station
    IBNR{8400466}, // Nunspeet railway station
    IBNR{8400467}, // Nuth railway station
    IBNR{8400468}, // Nijmegen Heyendaal railway station
    IBNR{8400469}, // Nijkerk railway station
    IBNR{8400470}, // Nijmegen railway station
    IBNR{8400472}, // Nijverdal railway station
    IBNR{8400475}, // Nijmegen Dukenburg railway station
    IBNR{8400480}, // Obdam railway station
    IBNR{8400482}, // Oisterwijk railway station
    IBNR{8400483}, // Oldenzaal railway station
    IBNR{8400487}, // Ommen railway station
    IBNR{8400489}, // Oosterbeek railway station
    IBNR{8400490}, // Hoevelaken railway station
    IBNR{8400494}, // Opheusden railway station
    IBNR{8400495}, // Oss railway station
    IBNR{8400496}, // Oss West railway station
    IBNR{8400498}, // Oudenbosch railway station
    IBNR{8400501}, // Overveen railway station
    IBNR{8400505}, // Rijswijk railway station
    IBNR{8400506}, // Purmerend Overwhere railway station
    IBNR{8400507}, // Rotterdam Alexander railway station
    IBNR{8400508}, // Purmerend railway station
    IBNR{8400509}, // Putten railway station
    IBNR{8400513}, // Raalte railway station
    IBNR{8400515}, // Ravenstein railway station
    IBNR{8400517}, // Rhenen railway station
    IBNR{8400518}, // Reuver railway station
    IBNR{8400519}, // Rheden railway station
    IBNR{8400520}, // Almelo de Riet railway station
    IBNR{8400521}, // Rilland-Bath railway station
    IBNR{8400523}, // Roermond railway station
    IBNR{8400524}, // Rosmalen railway station
    IBNR{8400525}, // Roodeschool railway station
    IBNR{8400526}, // Roosendaal railway station
    IBNR{8400529}, // Rotterdam Blaak railway station
    IBNR{8400530}, // Rotterdam Centraal railway station
    IBNR{8400531}, // Rotterdam Noord
    IBNR{8400533}, // Rotterdam Zuid railway station
    IBNR{8400537}, // Ruurlo railway station
    IBNR{8400538}, // Rijssen railway station
    IBNR{8400542}, // Rotterdam Lombardijen railway station
    IBNR{8400543}, // Santpoort Noord railway station
    IBNR{8400544}, // Santpoort Zuid
    IBNR{8400545}, // Sappemeer Oost railway station
    IBNR{8400547}, // Sauwerd railway station
    IBNR{8400548}, // Landgraaf railway station
    IBNR{8400549}, // Schagen railway station
    IBNR{8400551}, // Scheemda railway station
    IBNR{8400553}, // Schiedam Centrum railway station
    IBNR{8400554}, // Schinnen railway station
    IBNR{8400555}, // Schin op Geul railway station
    IBNR{8400561}, // Schiphol railway station
    IBNR{8400563}, // Schiedam Nieuwland railway station
    IBNR{8400564}, // Sittard railway station
    IBNR{8400565}, // Sliedrecht railway station
    IBNR{8400566}, // Sneek railway station
    IBNR{8400567}, // Soest (Netherlands) railway station
    IBNR{8400569}, // Soestdijk railway station
    IBNR{8400570}, // Hilversum Sportpark railway station
    IBNR{8400571}, // Soest Zuid railway station
    IBNR{8400572}, // Spaubeek railway station
    IBNR{8400574}, // Sneek Noord railway station
    IBNR{8400575}, // Stavoren railway station
    IBNR{8400576}, // Stedum railway station
    IBNR{8400578}, // Steenwijk railway station
    IBNR{8400582}, // Susteren railway station
    IBNR{8400583}, // Swalmen railway station
    IBNR{8400591}, // Tegelen railway station
    IBNR{8400592}, // Terborg railway station
    IBNR{8400594}, // Tilburg Universiteit railway station
    IBNR{8400596}, // Tiel railway station
    IBNR{8400597}, // Tilburg railway station
    IBNR{8400607}, // Utrecht Leidsche Rijn railway station
    IBNR{8400615}, // Uitgeest railway station
    IBNR{8400617}, // Uithuizen railway station
    IBNR{8400618}, // Uithuizermeeden railway station
    IBNR{8400619}, // Usquert railway station
    IBNR{8400620}, // Utrecht Overvecht railway station
    IBNR{8400621}, // Utrecht Centraal railway station
    IBNR{8400623}, // Utrecht Lunetten railway station
    IBNR{8400627}, // Veenendaal Centrum railway station
    IBNR{8400628}, // Veenendaal West railway station
    IBNR{8400632}, // Valkenburg railway station
    IBNR{8400635}, // Varsseveld railway station
    IBNR{8400637}, // Veenendaal-De Klomp railway station
    IBNR{8400638}, // Veenwouden railway station
    IBNR{8400640}, // Velp railway station
    IBNR{8400642}, // Vlaardingen West railway station
    IBNR{8400644}, // Venlo railway station
    IBNR{8400646}, // Venray railway station
    IBNR{8400647}, // Vierlingsbeek railway station
    IBNR{8400649}, // Vlaardingen Oost railway station
    IBNR{8400650}, // Vlaardingen Centrum railway station
    IBNR{8400651}, // Vleuten railway station
    IBNR{8400652}, // Vlissingen railway station
    IBNR{8400653}, // Vlissingen Souburg railway station
    IBNR{8400655}, // Voorhout railway station
    IBNR{8400656}, // Voerendaal railway station
    IBNR{8400658}, // Voorburg railway station
    IBNR{8400659}, // Voorschoten railway station
    IBNR{8400661}, // Vorden railway station
    IBNR{8400664}, // Vriezenveen railway station
    IBNR{8400666}, // Vroomshoop railway station
    IBNR{8400667}, // Vught railway station
    IBNR{8400674}, // Waddinxveen Noord railway station
    IBNR{8400675}, // Waddinxveen railway station
    IBNR{8400679}, // Warffum railway station
    IBNR{8400684}, // Weert railway station
    IBNR{8400685}, // Weesp railway station
    IBNR{8400686}, // Wehl railway station
    IBNR{8400690}, // Wezep railway station
    IBNR{8400691}, // Wierden railway station
    IBNR{8400696}, // Winschoten railway station
    IBNR{8400697}, // Winsum railway station
    IBNR{8400698}, // Winterswijk railway station
    IBNR{8400702}, // Woerden railway station
    IBNR{8400704}, // Wolfheze railway station
    IBNR{8400705}, // Wolvega railway station
    IBNR{8400706}, // Workum railway station
    IBNR{8400707}, // Wormerveer railway station
    IBNR{8400710}, // Wijchen railway station
    IBNR{8400711}, // Wijhe railway station
    IBNR{8400722}, // IJlst railway station
    IBNR{8400728}, // Zaandam Kogerveld railway station
    IBNR{8400731}, // Zaandam railway station
    IBNR{8400732}, // Zaltbommel railway station
    IBNR{8400733}, // Zandvoort aan Zee railway station
    IBNR{8400734}, // Zetten-Andelst railway station
    IBNR{8400735}, // Zevenaar railway station
    IBNR{8400737}, // Zevenbergen railway station
    IBNR{8400740}, // Zoetermeer Oost railway station
    IBNR{8400741}, // Zoetermeer railway station
    IBNR{8400742}, // Zuidbroek railway station
    IBNR{8400743}, // Zuidhorn railway station
    IBNR{8400744}, // Zutphen railway station
    IBNR{8400745}, // Zwaagwesteinde railway station
    IBNR{8400747}, // Zwolle railway station
    IBNR{8400752}, // Zwijndrecht railway station
    IBNR{8402735}, // Haarlem Spaarnwoude railway station
    IBNR{8479001}, // Hoek van Holland Strand railway station
    IBNR{8479003}, // Harlingen Haven railway station
    IBNR{8479008}, // Almere Parkwijk railway station
    IBNR{8500010}, // Basel SBB railway station
    IBNR{8500013}, // Q16508111
    IBNR{8500016}, // Basel St. Johann railway station
    IBNR{8500019}, // Schweizerhalle Station
    IBNR{8500020}, // Muttenz
    IBNR{8500021}, // Pratteln train station
    IBNR{8500022}, // Q3096480
    IBNR{8500023}, // Liestal railway station
    IBNR{8500024}, // Q3096861
    IBNR{8500025}, // Q3095807
    IBNR{8500026}, // Q3097750
    IBNR{8500027}, // Q3096527
    IBNR{8500028}, // Q3097843
    IBNR{8500031}, // Q3096363
    IBNR{8500032}, // Q3097761
    IBNR{8500033}, // Q3097471
    IBNR{8500034}, // Q3096083
    IBNR{8500035}, // Q3096933
    IBNR{8500037}, // Q3097902
    IBNR{8500080}, // Talhaus station
    IBNR{8500081}, // Altmarkt station
    IBNR{8500082}, // Bubendorf station
    IBNR{8500083}, // Lampenberg-Ramlinsburg station
    IBNR{8500084}, // Hölstein station
    IBNR{8500085}, // Niederdorf station
    IBNR{8500086}, // Oberdorf BL station
    IBNR{8500087}, // Waldenburg station
    IBNR{8500088}, // Oberdorf BL Winkelweg station
    IBNR{8500092}, // Hölstein Süd station
    IBNR{8500093}, // Hölstein Weidbächli station
    IBNR{8500094}, // Hirschlang station
    IBNR{8500100}, // Tavannes Station
    IBNR{8500101}, // Reconvilier Station
    IBNR{8500102}, // Malleray-Bévilard Station
    IBNR{8500103}, // Sorvilier Station
    IBNR{8500104}, // Court Station
    IBNR{8500105}, // Moutier
    IBNR{8500109}, // Delémont Station
    IBNR{8500113}, // Laufen railway station
    IBNR{8500114}, // Zwingen
    IBNR{8500115}, // Q3096575
    IBNR{8500116}, // Q2381221
    IBNR{8500117}, // Q3095587
    IBNR{8500118}, // Q3096391
    IBNR{8500119}, // Münchenstein
    IBNR{8500120}, // Courtételle
    IBNR{8500121}, // Q3096306
    IBNR{8500122}, // Q3095912
    IBNR{8500123}, // Glovelier
    IBNR{8500124}, // Saint-Ursanne
    IBNR{8500125}, // Courgenay
    IBNR{8500126}, // Porrentruy
    IBNR{8500127}, // Courtemaîche Station
    IBNR{8500128}, // Boncourt
    IBNR{8500132}, // Bahnhof Basel Dreispitz
    IBNR{8500135}, // Pontenet Station
    IBNR{8500141}, // Courchavon
    IBNR{8500143}, // Grandgourt Station
    IBNR{8500144}, // Buix Station
    IBNR{8500159}, // Grenchen Nord
    IBNR{8500162}, // Tramelan-Dessous station
    IBNR{8500164}, // Tramelan-Chalet station
    IBNR{8500165}, // Le Pied-d'Or station
    IBNR{8500167}, // Les Breuleux-Eglise station
    IBNR{8500169}, // Muriaux station
    IBNR{8500170}, // Tramelan station
    IBNR{8500171}, // Les Reussilles station
    IBNR{8500172}, // La Chaux-des-Breuleux station
    IBNR{8500173}, // Les Breuleux station
    IBNR{8500174}, // Le Noirmont station
    IBNR{8500175}, // Le Creux-des-Biches station
    IBNR{8500176}, // Le Boéchet station
    IBNR{8500177}, // Les Bois station
    IBNR{8500178}, // La Ferrière station
    IBNR{8500179}, // La Cibourg station
    IBNR{8500180}, // La Large-Journée station
    IBNR{8500181}, // La Chaux-d'Abel station
    IBNR{8500182}, // Le Seignat station
    IBNR{8500184}, // La Chaux-de-Fonds-Est station
    IBNR{8500186}, // Alle station
    IBNR{8500187}, // Vendlincourt station
    IBNR{8500188}, // Bonfol station
    IBNR{8500190}, // Les Emibois station
    IBNR{8500191}, // Saignelégier station
    IBNR{8500192}, // Le Bémont station
    IBNR{8500194}, // Pré-Petitjean train station
    IBNR{8500195}, // La Combe station
    IBNR{8500196}, // Bollement Railway Station
    IBNR{8500199}, // Combe-Tabeillon station
    IBNR{8500200}, // Pieterlen
    IBNR{8500201}, // Lengnau
    IBNR{8500202}, // Grenchen Süd
    IBNR{8500203}, // Bettlach station
    IBNR{8500204}, // Selzach station
    IBNR{8500205}, // Bellach station
    IBNR{8500206}, // Solothurn West Station
    IBNR{8500207}, // Solothurn railway station
    IBNR{8500208}, // Q15964189
    IBNR{8500209}, // Q15964114
    IBNR{8500210}, // Q15964284
    IBNR{8500211}, // Niederbipp Station
    IBNR{8500212}, // Q15785193
    IBNR{8500213}, // Q15964211
    IBNR{8500214}, // Q15964115
    IBNR{8500215}, // Q15964141
    IBNR{8500216}, // Q15964285
    IBNR{8500217}, // Q15964212
    IBNR{8500218}, // Olten railway station
    IBNR{8500220}, // Dotzigen Station
    IBNR{8500221}, // Büren an der Aare Station
    IBNR{8500260}, // Crémines-Zoo station
    IBNR{8500261}, // Langendorf station
    IBNR{8500262}, // Lommiswil station
    IBNR{8500263}, // Im Holz station
    IBNR{8500264}, // Oberdorf SO station
    IBNR{8500265}, // Gänsbrunnen station
    IBNR{8500266}, // Corcelles BE station
    IBNR{8500267}, // Crémines station
    IBNR{8500268}, // Grandval station
    IBNR{8500272}, // Solothurn Sternen halt
    IBNR{8500273}, // St. Katharinen station
    IBNR{8500274}, // Feldbrunnen halt
    IBNR{8500275}, // Bei den Weihern station
    IBNR{8500280}, // Solothurn Baseltor halt
    IBNR{8500283}, // Riedholz halt
    IBNR{8500285}, // Flumenthal halt
    IBNR{8500286}, // Attiswil station
    IBNR{8500287}, // Wiedlisbach station
    IBNR{8500288}, // Oberbipp station
    IBNR{8500289}, // Buchli station
    IBNR{8500292}, // Klus station
    IBNR{8500293}, // Thalbrücke station
    IBNR{8500294}, // Balsthal station
    IBNR{8500300}, // Kaiseraugst railway station
    IBNR{8500301}, // Q20020599
    IBNR{8500302}, // Möhlin railway station
    IBNR{8500303}, // Mumpf railway station
    IBNR{8500304}, // Eiken railway station
    IBNR{8500305}, // Frick railway station
    IBNR{8500307}, // Q800707
    IBNR{8500309}, // Brugg railway station
    IBNR{8500313}, // Rheinfelden-Augarten railway station
    IBNR{8500320}, // Stein-Säckingen railway station
    IBNR{8500322}, // Laufenburg railway station
    IBNR{8500329}, // Koblenz railway station
    IBNR{8500741}, // Q23784034
    IBNR{8501000}, // Zimeysa
    IBNR{8501001}, // La Plaine
    IBNR{8501002}, // Russin
    IBNR{8501003}, // Satigny
    IBNR{8501006}, // Meyrin
    IBNR{8501007}, // Vernier
    IBNR{8501008}, // Genève-Cornavin railway station
    IBNR{8501011}, // Les Tuileries station
    IBNR{8501012}, // Creux-de-Genthod
    IBNR{8501013}, // Pont-Céard
    IBNR{8501014}, // Mies
    IBNR{8501015}, // Tannay
    IBNR{8501020}, // Chambésy
    IBNR{8501021}, // Genthod-Bellevue
    IBNR{8501022}, // Versoix
    IBNR{8501023}, // Coppet
    IBNR{8501026}, // Geneva Airport railway station
    IBNR{8501030}, // Nyon
    IBNR{8501031}, // Gland
    IBNR{8501033}, // Rolle
    IBNR{8501035}, // Allaman
    IBNR{8501036}, // Saint-Prex
    IBNR{8501037}, // Morges railway station
    IBNR{8501042}, // Etoy
    IBNR{8501045}, // Denges-Echandens
    IBNR{8501047}, // Morges-St-Jean
    IBNR{8501048}, // Lonay-Préverenges
    IBNR{8501049}, // Q16508009
    IBNR{8501053}, // La Vuarpillière station
    IBNR{8501054}, // La Gottaz station
    IBNR{8501055}, // Les Pralies station
    IBNR{8501056}, // Sus-Châtel station
    IBNR{8501057}, // La Chèvrerie-Monteret station
    IBNR{8501058}, // La Joy-Clinique station
    IBNR{8501059}, // Les Plantaz station
    IBNR{8501060}, // La Cure station
    IBNR{8501061}, // La Givrine station
    IBNR{8501062}, // St-Cergue station
    IBNR{8501063}, // Arzier station
    IBNR{8501064}, // Bassins station
    IBNR{8501065}, // Le Muids station
    IBNR{8501066}, // Genolier station
    IBNR{8501067}, // Givrins station
    IBNR{8501068}, // Trélex station
    IBNR{8501069}, // L'Asse station
    IBNR{8501080}, // Le Marais station
    IBNR{8501081}, // Chigny station
    IBNR{8501082}, // Chardonney-Château station
    IBNR{8501083}, // Reverolle station
    IBNR{8501084}, // Le Manège station
    IBNR{8501085}, // Ballens-Froideville station
    IBNR{8501087}, // Mauraz station
    IBNR{8501088}, // Tuilerie station
    IBNR{8501089}, // Villars-Bozon station
    IBNR{8501090}, // Prélionne station
    IBNR{8501091}, // Vufflens-le-Château station
    IBNR{8501092}, // Bussy-Chardonney station
    IBNR{8501093}, // Yens station
    IBNR{8501094}, // Apples railway station
    IBNR{8501095}, // Ballens station
    IBNR{8501096}, // Bière railway station
    IBNR{8501097}, // Pampigny-Sévery station
    IBNR{8501098}, // Montricher station
    IBNR{8501099}, // L'Isle-Mont-la-Ville railway station
    IBNR{8501100}, // Le Pont station
    IBNR{8501103}, // Vallorbe railway station
    IBNR{8501104}, // Le Day Station
    IBNR{8501105}, // Q15964082
    IBNR{8501106}, // Q15964103
    IBNR{8501107}, // Q15964055
    IBNR{8501108}, // Q15964160
    IBNR{8501110}, // Ependes
    IBNR{8501111}, // Essert-Pittet
    IBNR{8501112}, // Chavornay
    IBNR{8501113}, // Bavois
    IBNR{8501114}, // Eclépens
    IBNR{8501115}, // Cossonay
    IBNR{8501116}, // Vufflens-la-Ville
    IBNR{8501117}, // Bussigny station
    IBNR{8501118}, // Renens VD railway station
    IBNR{8501120}, // Lausanne railway station
    IBNR{8501121}, // Pully railway station
    IBNR{8501122}, // Q10949227
    IBNR{8501123}, // Q10953216
    IBNR{8501124}, // Q10948129
    IBNR{8501125}, // Q10948238
    IBNR{8501126}, // Q10950827
    IBNR{8501127}, // Q10951147
    IBNR{8501128}, // Lausanne-Sébeillon railway station
    IBNR{8501151}, // Les Charbonnières station
    IBNR{8501152}, // Le Séchey station
    IBNR{8501153}, // Le Lieu station
    IBNR{8501154}, // Les Esserts-de-Rive station
    IBNR{8501155}, // Le Rocheray station
    IBNR{8501156}, // Solliat-Golisse station
    IBNR{8501157}, // Sentier-Orient station
    IBNR{8501159}, // Le Brassus station
    IBNR{8501160}, // Lausanne-Chauderon railway station
    IBNR{8501161}, // Montétan halt
    IBNR{8501162}, // Union-Prilly railway station
    IBNR{8501163}, // Prilly-Chasseur halt
    IBNR{8501164}, // Cery − Fleur-de-Lys halt
    IBNR{8501165}, // Jouxtens-Mézery railway station
    IBNR{8501166}, // Romanel-sur-Lausanne railway station
    IBNR{8501167}, // Le Lussex halt
    IBNR{8501168}, // Vernand-Camarès halt
    IBNR{8501169}, // Cheseaux-sur-Lausanne railway station
    IBNR{8501170}, // Bel-Air LEB halt
    IBNR{8501171}, // Étagnières halt
    IBNR{8501172}, // Assens railway station
    IBNR{8501173}, // Échallens railway station
    IBNR{8501174}, // Sur Roche halt
    IBNR{8501175}, // Sugnens railway station
    IBNR{8501176}, // Fey halt
    IBNR{8501177}, // Bercher railway station
    IBNR{8501178}, // Grésaley halt
    IBNR{8501179}, // Pont-de-Drapel station
    IBNR{8501181}, // Lausanne-Flon railway station
    IBNR{8501183}, // Jordils
    IBNR{8501191}, // Q16507967
    IBNR{8501194}, // Les Granges (Orbe) station
    IBNR{8501198}, // Château-d'Oex La Palaz station
    IBNR{8501199}, // La Roulaz station
    IBNR{8501200}, // Vevey railway station
    IBNR{8501201}, // Q10948797
    IBNR{8501202}, // Q10947816
    IBNR{8501203}, // Q10948043
    IBNR{8501229}, // Monthey-En Place station
    IBNR{8501230}, // Glion-Alpes station
    IBNR{8501260}, // Gilamont station
    IBNR{8501261}, // Clies station
    IBNR{8501262}, // Hauteville station
    IBNR{8501263}, // Château-d'Hauteville station
    IBNR{8501264}, // St-Légier-Village station
    IBNR{8501265}, // La Chiésaz station
    IBNR{8501266}, // Château-de-Blonay station
    IBNR{8501280}, // St-Légier-Gare station
    IBNR{8501281}, // Blonay station
    IBNR{8501282}, // Prélaz-sur-Blonay station
    IBNR{8501283}, // Tusinge station
    IBNR{8501284}, // Les Chevalleyres station
    IBNR{8501285}, // Fayaux station
    IBNR{8501286}, // Ondallaz-L'Alliaz station
    IBNR{8501287}, // Lally station
    IBNR{8501288}, // Les Pléiades station
    IBNR{8501300}, // Montreux railway station
    IBNR{8501301}, // Q10952194
    IBNR{8501302}, // Q10952911
    IBNR{8501303}, // Villeneuve railway station
    IBNR{8501304}, // Roche VD Station
    IBNR{8501306}, // Chamby-Musée station
    IBNR{8501308}, // Glion-Collège station
    IBNR{8501311}, // Q3098155
    IBNR{8501357}, // Haut-de-Caux station
    IBNR{8501360}, // Montreux-Les Planches station
    IBNR{8501361}, // Toveyre station
    IBNR{8501362}, // Valmont station
    IBNR{8501363}, // Le Tremblex station
    IBNR{8501364}, // Les Echets station
    IBNR{8501365}, // Crêt-d'y-Bau station
    IBNR{8501366}, // Paccot station
    IBNR{8501367}, // Jaman station
    IBNR{8501368}, // La Perche station
    IBNR{8501369}, // Rochers-de-Naye station
    IBNR{8501370}, // Glion station
    IBNR{8501371}, // Caux station
    IBNR{8501374}, // Fontanivent station
    IBNR{8501375}, // Chernex station
    IBNR{8501376}, // Chamby station
    IBNR{8501377}, // Les Avants station
    IBNR{8501378}, // Allières station
    IBNR{8501379}, // Les Sciernes station
    IBNR{8501380}, // Montreux-Collège station
    IBNR{8501381}, // Vuarennes station
    IBNR{8501382}, // Châtelard VD station
    IBNR{8501383}, // Planchamp station
    IBNR{8501384}, // Sonzier station
    IBNR{8501385}, // Sendy-Sollard station
    IBNR{8501386}, // Halte de Jor
    IBNR{8501387}, // Les Cases station
    IBNR{8501388}, // Les Combes station
    IBNR{8501390}, // Belmont-sur-Montreux station
    IBNR{8501391}, // La Tine station
    IBNR{8501392}, // Rossinière station
    IBNR{8501393}, // La Chaudanne-Les Moulins station
    IBNR{8501394}, // Château-d'Oex station
    IBNR{8501395}, // Les Granges-Gérignoz station
    IBNR{8501396}, // Flendruz station
    IBNR{8501397}, // Rougemont station
    IBNR{8501398}, // Saanen station
    IBNR{8501399}, // Gstaad station
    IBNR{8501400}, // Q5845601
    IBNR{8501402}, // Q12174783
    IBNR{8501403}, // Q10951368
    IBNR{8501404}, // Q10948282
    IBNR{8501405}, // Q10952886
    IBNR{8501420}, // Q12174808
    IBNR{8501421}, // Q12174813
    IBNR{8501422}, // Q12174791
    IBNR{8501423}, // Vionnaz
    IBNR{8501424}, // Vouvry
    IBNR{8501425}, // Les Évouettes station
    IBNR{8501426}, // Q12174805
    IBNR{8501428}, // Q12174821
    IBNR{8501446}, // Villars-sur-Ollon Golf station
    IBNR{8501447}, // Roches Grises station
    IBNR{8501448}, // Champéry station
    IBNR{8501452}, // St-Triphon-Gare station
    IBNR{8501453}, // La Cour station
    IBNR{8501454}, // Fayot station
    IBNR{8501456}, // Chemex station
    IBNR{8501457}, // Monthey-Hôpital station
    IBNR{8501458}, // Villy station
    IBNR{8501459}, // St-Triphon-Village station
    IBNR{8501460}, // Croix-du-Nant station
    IBNR{8501461}, // Ollon station
    IBNR{8501462}, // Collombey-Muraz station
    IBNR{8501463}, // Monthey-Ville station
    IBNR{8501464}, // Troistorrents station
    IBNR{8501465}, // Val-d'Illiez station
    IBNR{8501466}, // Champéry-Village station
    IBNR{8501468}, // Aigle-Dépôt ASD station
    IBNR{8501469}, // Les Fontanelles station
    IBNR{8501470}, // Verchiez station
    IBNR{8501471}, // Plambuit station
    IBNR{8501472}, // Exergillod station
    IBNR{8501473}, // Les Planches (Aigle) station
    IBNR{8501474}, // Le Sépey station
    IBNR{8501475}, // Les Echenards station
    IBNR{8501476}, // Les Aviolats station
    IBNR{8501477}, // Vers-l'Eglise station
    IBNR{8501479}, // Les Diablerets station
    IBNR{8501480}, // Rennaz (Leysin) station
    IBNR{8501481}, // Leysin-Village station
    IBNR{8501482}, // Leysin-Feydey station
    IBNR{8501483}, // Leysin-Grand-Hôtel station
    IBNR{8501484}, // Aigle-Dépôt station
    IBNR{8501485}, // Fontanney station
    IBNR{8501487}, // Bex-Place-du-Marché station
    IBNR{8501488}, // Bévieux station
    IBNR{8501490}, // Fontannaz-Seulaz station
    IBNR{8501491}, // Les Posses station
    IBNR{8501492}, // Gryon station
    IBNR{8501493}, // La Barboleuse station
    IBNR{8501494}, // Arveyes station
    IBNR{8501495}, // Villars-sur-Ollon station
    IBNR{8501497}, // Col-de-Soud station
    IBNR{8501498}, // Bouquetins station
    IBNR{8501499}, // Col-de-Bretaye station
    IBNR{8501500}, // Q3096986
    IBNR{8501501}, // Q12174790
    IBNR{8501502}, // Q12174829
    IBNR{8501503}, // Q12174817
    IBNR{8501504}, // Q12174786
    IBNR{8501505}, // Q12174781
    IBNR{8501506}, // Sion railway station
    IBNR{8501507}, // Q12174826
    IBNR{8501509}, // Sierre/Siders train station
    IBNR{8501510}, // Q12174788
    IBNR{8501552}, // Les Montuires station
    IBNR{8501554}, // Aigle-Place-du-Marché station
    IBNR{8501561}, // Vernayaz MC station
    IBNR{8501562}, // Salvan station
    IBNR{8501563}, // Les Marécottes station
    IBNR{8501564}, // Le Trétien station
    IBNR{8501565}, // Finhaut station
    IBNR{8501566}, // Le Châtelard VS station
    IBNR{8501568}, // Le Châtelard-Frontière station
    IBNR{8501572}, // Q1891056
    IBNR{8501573}, // Q2047644
    IBNR{8501575}, // Q3366042
    IBNR{8501576}, // Sembrancher train station
    IBNR{8501577}, // Q2365843
    IBNR{8501578}, // Q1968217
    IBNR{8501579}, // Q2569112
    IBNR{8501580}, // Q2110844
    IBNR{8501600}, // Q12174824
    IBNR{8501601}, // Q5846591
    IBNR{8501602}, // Q12174833
    IBNR{8501603}, // Q12174800
    IBNR{8501604}, // Q12174816
    IBNR{8501605}, // Visp railway station
    IBNR{8501609}, // Brig railway station
    IBNR{8501634}, // Muttbach-Belvédère Station
    IBNR{8501635}, // Gletsch railway station
    IBNR{8501636}, // Eyholz railway station
    IBNR{8501640}, // Visp MGB-bvz railway station
    IBNR{8501661}, // Oberwald railway station
    IBNR{8501662}, // Obergesteln railway station
    IBNR{8501663}, // Ulrichen railway station
    IBNR{8501664}, // Geschinen railway station
    IBNR{8501665}, // Münster VS railway station
    IBNR{8501666}, // Reckingen railway station
    IBNR{8501667}, // Gluringen railway station
    IBNR{8501668}, // Biel (Goms) railway station
    IBNR{8501669}, // Blitzingen railway station
    IBNR{8501670}, // Niederwald railway station
    IBNR{8501671}, // Fürgangen-Bellwald Talstation railway station
    IBNR{8501672}, // Fiesch railway station
    IBNR{8501673}, // Lax railway station
    IBNR{8501674}, // Grengiols railway station
    IBNR{8501675}, // Betten Talstation railway station
    IBNR{8501676}, // Mörel railway station
    IBNR{8501677}, // Bitsch railway station
    IBNR{8501679}, // Findelbach railway station
    IBNR{8501683}, // Stalden-Saas railway station
    IBNR{8501684}, // Kalpetran railway station
    IBNR{8501685}, // St. Niklaus railway station
    IBNR{8501686}, // Herbriggen railway station
    IBNR{8501687}, // Randa railway station
    IBNR{8501688}, // Täsch railway station
    IBNR{8501689}, // Zermatt railway station
    IBNR{8501690}, // Zermatt GGB station
    IBNR{8501691}, // Riffelalp railway station
    IBNR{8501692}, // Riffelberg railway station
    IBNR{8501693}, // Rotenboden railway station
    IBNR{8501694}, // Gornergrat railway station
    IBNR{8501725}, // Versmont station
    IBNR{8501726}, // Corbier station
    IBNR{8501727}, // La Clairière station
    IBNR{8501729}, // Fiesch Sport- & Feriencenter railway station
    IBNR{8502000}, // Q15964068
    IBNR{8502001}, // Q801665
    IBNR{8502002}, // Q15964097
    IBNR{8502003}, // Reiden Station
    IBNR{8502004}, // Q15964122
    IBNR{8502005}, // Nebikon train station
    IBNR{8502006}, // Q15964288
    IBNR{8502007}, // Q801493
    IBNR{8502008}, // Q15964214
    IBNR{8502009}, // Q15964260
    IBNR{8502010}, // Q15964261
    IBNR{8502011}, // Q15964215
    IBNR{8502012}, // Q15964235
    IBNR{8502017}, // Waldibrücke Station
    IBNR{8502019}, // Ermensee Station
    IBNR{8502020}, // Q15964236
    IBNR{8502021}, // Q20012446
    IBNR{8502022}, // Eschenbach Station
    IBNR{8502023}, // Ballwil Station
    IBNR{8502024}, // Hochdorf Station
    IBNR{8502025}, // Baldegg Station
    IBNR{8502026}, // Gelfingen Station
    IBNR{8502027}, // Hitzkirch Station
    IBNR{8502028}, // Emmenbrücke Gersag Station
    IBNR{8502029}, // Mosen Station
    IBNR{8502030}, // Seon Station
    IBNR{8502031}, // Hallwil Station
    IBNR{8502032}, // Boniswil Station
    IBNR{8502033}, // Birrwil Station
    IBNR{8502034}, // Beinwil am See Station
    IBNR{8502042}, // Hochdorf Schönau Station
    IBNR{8502100}, // Q15964238
    IBNR{8502101}, // Q15964168
    IBNR{8502102}, // Q15964219
    IBNR{8502103}, // Q15964220
    IBNR{8502104}, // Hunzenschwil Station
    IBNR{8502105}, // Othmarsingen railway station
    IBNR{8502106}, // Mägenwil railway station
    IBNR{8502110}, // Dulliken train station
    IBNR{8502111}, // Däniken Train Station
    IBNR{8502112}, // Schönenwerd railway station
    IBNR{8502113}, // Aarau railway station
    IBNR{8502114}, // Q15964233
    IBNR{8502115}, // Q15964286
    IBNR{8502116}, // Q15964258
    IBNR{8502119}, // Lenzburg railway station
    IBNR{8502120}, // Q15964166
    IBNR{8502121}, // Q15964290
    IBNR{8502122}, // Q15964167
    IBNR{8502123}, // Buchs AG station
    IBNR{8502128}, // Q15964142
    IBNR{8502160}, // Gränichen station
    IBNR{8502161}, // Teufenthal AG station
    IBNR{8502162}, // Unterkulm station
    IBNR{8502163}, // Oberkulm station
    IBNR{8502164}, // Gontenschwil station
    IBNR{8502165}, // Zetzwil station
    IBNR{8502166}, // Leimbach AG station
    IBNR{8502167}, // Reinach AG Nord station
    IBNR{8502168}, // Reinach AG station
    IBNR{8502169}, // Menziken station
    IBNR{8502174}, // Bleien Liebegg station
    IBNR{8502176}, // Reinach AG Mitte station
    IBNR{8502177}, // Schöftland Nordweg station
    IBNR{8502178}, // Obermuhen station
    IBNR{8502179}, // Mittelmuhen station
    IBNR{8502180}, // Muhen Nord station
    IBNR{8502181}, // Oberentfelden Uerkenbrücke station
    IBNR{8502182}, // Unterentfelden Oberdorf station
    IBNR{8502183}, // Oberkulm Post station
    IBNR{8502184}, // Gränichen Oberdorf station
    IBNR{8502185}, // Bremgarten Isenlauf station
    IBNR{8502186}, // Dietikon Stoffelbach station
    IBNR{8502187}, // Rudolfstetten Hofacker station
    IBNR{8502188}, // Zufikon Hammergut station
    IBNR{8502189}, // Gränichen Töndler station
    IBNR{8502191}, // Binzenhof station
    IBNR{8502192}, // Distelberg station
    IBNR{8502194}, // Oberentfelden Engelplatz station
    IBNR{8502195}, // Muhen station
    IBNR{8502196}, // Unterentfelden Post station
    IBNR{8502197}, // Hirschthal station
    IBNR{8502199}, // Schöftland station
    IBNR{8502200}, // Q15964121
    IBNR{8502201}, // Q15964146
    IBNR{8502202}, // Rotkreuz station
    IBNR{8502203}, // Q15964094
    IBNR{8502204}, // Zug railway station
    IBNR{8502205}, // Walchwil station
    IBNR{8502206}, // Baar railway station
    IBNR{8502207}, // Sihlbrugg railway station
    IBNR{8502208}, // Horgen Oberdorf railway station
    IBNR{8502209}, // Oberrieden Dorf railway station
    IBNR{8502211}, // Hendschiken train station
    IBNR{8502212}, // Q15964118
    IBNR{8502213}, // Wohlen railway station
    IBNR{8502214}, // Q15964093
    IBNR{8502215}, // Q15964190
    IBNR{8502216}, // Q15964066
    IBNR{8502217}, // Q15964191
    IBNR{8502218}, // Q15964259
    IBNR{8502219}, // Q15964213
    IBNR{8502220}, // Urdorf railway station
    IBNR{8502221}, // Birmensdorf railway station
    IBNR{8502222}, // Bonstetten-Wettswil railway station
    IBNR{8502223}, // Hedingen railway station
    IBNR{8502224}, // Affoltern am Albis railway station
    IBNR{8502225}, // Mettmenstetten railway station
    IBNR{8502226}, // Knonau railway station
    IBNR{8502227}, // Steinhausen railway station
    IBNR{8502229}, // Urdorf Weihermatt railway station
    IBNR{8502230}, // Q15964302
    IBNR{8502231}, // Q801666
    IBNR{8502237}, // Lupfig Station
    IBNR{8502247}, // Birr Station
    IBNR{8502248}, // Bremgarten Obertor station
    IBNR{8502268}, // Zufikon Belvédère station
    IBNR{8502269}, // Erdmannlistein station
    IBNR{8502270}, // Bergfrieden station
    IBNR{8502271}, // Wohlen Oberdorf station
    IBNR{8502272}, // Bremgarten West station
    IBNR{8502273}, // Bremgarten station
    IBNR{8502274}, // Zufikon station
    IBNR{8502275}, // Widen Heinrüti station
    IBNR{8502276}, // Berikon-Widen station
    IBNR{8502277}, // Rudolfstetten station
    IBNR{8502278}, // Reppischhof station
    IBNR{8502300}, // Q15964304
    IBNR{8502306}, // Q15964144
    IBNR{8503000}, // Zürich Hauptbahnhof
    IBNR{8503001}, // Zurich Altstetten railway station
    IBNR{8503002}, // Zurich Letten railway station
    IBNR{8503003}, // Zurich Stadelhofen railway station
    IBNR{8503004}, // Zürich Tiefenbrunnen railway station
    IBNR{8503006}, // Zürich Oerlikon railway station
    IBNR{8503007}, // Zurich Seebach railway station
    IBNR{8503008}, // Zurich Affoltern railway station
    IBNR{8503009}, // Zürich Wollishofen railway station
    IBNR{8503010}, // Zürich Enge railway station
    IBNR{8503011}, // Zurich Wiedikon railway station
    IBNR{8503015}, // Zurich Wipkingen railway station
    IBNR{8503016}, // Zurich Airport railway station
    IBNR{8503020}, // Zurich Hardbrücke railway station
    IBNR{8503051}, // Zürich Binz railway station
    IBNR{8503052}, // Zürich Friesenberg railway station
    IBNR{8503053}, // Zürich Schweighof railway station
    IBNR{8503054}, // Zürich Triemli railway station
    IBNR{8503055}, // Uitikon Waldegg railway station
    IBNR{8503056}, // Ringlikon railway station
    IBNR{8503057}, // Uetliberg railway station
    IBNR{8503059}, // Zürich Stadelhofen FB station
    IBNR{8503060}, // Esslingen railway station
    IBNR{8503061}, // Langwies ZH station
    IBNR{8503062}, // Egg station
    IBNR{8503063}, // Hinteregg station
    IBNR{8503064}, // Scheuren station
    IBNR{8503065}, // Forch railway station
    IBNR{8503066}, // Zumikon station
    IBNR{8503067}, // Zollikerberg station
    IBNR{8503068}, // Maiacher station
    IBNR{8503069}, // Zürich Rehalp railway station
    IBNR{8503070}, // Emmat station
    IBNR{8503072}, // Neuhaus bei Hinteregg station
    IBNR{8503074}, // Neue Forch station
    IBNR{8503075}, // Waltikon station
    IBNR{8503077}, // Spital Zollikerberg station
    IBNR{8503078}, // Waldburg station
    IBNR{8503083}, // Zürich, Römerhof station
    IBNR{8503084}, // Zürich, Dolder station
    IBNR{8503086}, // Zurich Brunau railway station
    IBNR{8503087}, // Zürich Saalsporthalle-Sihlcity railway station
    IBNR{8503088}, // Zürich HB SZU station
    IBNR{8503089}, // Wildpark-Höfli railway station
    IBNR{8503090}, // Zürich Selnau railway station
    IBNR{8503091}, // Zürich Giesshübel railway station
    IBNR{8503093}, // Zurich Manegg railway station
    IBNR{8503094}, // Zurich Leimbach railway station
    IBNR{8503095}, // Sood-Oberleimbach railway station
    IBNR{8503096}, // Adliswil railway station
    IBNR{8503097}, // Langnau-Gattikon railway station
    IBNR{8503098}, // Sihlwald railway station
    IBNR{8503099}, // Sihlau railway station
    IBNR{8503100}, // Zollikon railway station
    IBNR{8503101}, // Küsnacht ZH railway station
    IBNR{8503102}, // Erlenbach ZH railway station
    IBNR{8503103}, // Herrliberg-Feldmeilen railway station
    IBNR{8503104}, // Meilen railway station
    IBNR{8503105}, // Uetikon railway station
    IBNR{8503106}, // Männedorf railway station
    IBNR{8503107}, // Stäfa railway station
    IBNR{8503108}, // Uerikon railway station
    IBNR{8503109}, // Feldbach railway station
    IBNR{8503110}, // Rapperswil railway station
    IBNR{8503111}, // Winkel am Zürichsee railway station
    IBNR{8503112}, // Kempraten railway station
    IBNR{8503113}, // Blumenau railway station
    IBNR{8503115}, // Schmerikon railway station
    IBNR{8503116}, // Uznach railway station
    IBNR{8503117}, // Kaltbrunn railway station
    IBNR{8503118}, // Benken railway station
    IBNR{8503119}, // Schänis railway station
    IBNR{8503120}, // Jona railway station
    IBNR{8503121}, // Rüti ZH railway station
    IBNR{8503122}, // Bubikon railway station
    IBNR{8503123}, // Wetzikon railway station
    IBNR{8503124}, // Aathal railway station
    IBNR{8503125}, // Uster railway station
    IBNR{8503126}, // Nänikon-Greifensee railway station
    IBNR{8503127}, // Schwerzenbach railway station
    IBNR{8503128}, // Dübendorf railway station
    IBNR{8503129}, // Wallisellen railway station
    IBNR{8503130}, // Hinwil railway station
    IBNR{8503131}, // Ettenhausen-Emmetschloo Station
    IBNR{8503132}, // Bäretswil Station
    IBNR{8503133}, // Neuthal Station
    IBNR{8503134}, // Bauma railway station
    IBNR{8503135}, // Steg railway station
    IBNR{8503136}, // Fischenthal railway station
    IBNR{8503137}, // Gibswil railway station
    IBNR{8503138}, // Wald railway station
    IBNR{8503139}, // Tann-Dürnten railway station
    IBNR{8503141}, // Küsnacht Goldbach railway station
    IBNR{8503147}, // Stettbach railway station
    IBNR{8503200}, // Kilchberg railway station
    IBNR{8503201}, // Rüschlikon railway station
    IBNR{8503202}, // Thalwil railway station
    IBNR{8503203}, // Oberrieden railway station
    IBNR{8503204}, // Horgen railway station
    IBNR{8503205}, // Au ZH railway station
    IBNR{8503206}, // Wädenswil railway station
    IBNR{8503207}, // Richterswil railway station
    IBNR{8503208}, // Bäch railway station
    IBNR{8503209}, // Pfäffikon SZ railway station
    IBNR{8503210}, // Freienbach SBB railway station
    IBNR{8503211}, // Altendorf railway station
    IBNR{8503220}, // Lachen railway station
    IBNR{8503221}, // Siebnen-Wangen railway station
    IBNR{8503222}, // Schübelbach-Buttikon railway station
    IBNR{8503223}, // Reichenburg railway station
    IBNR{8503224}, // Bilten railway station
    IBNR{8503225}, // Ziegelbrücke railway station
    IBNR{8503226}, // Nieder- and Oberurnen railway station
    IBNR{8503227}, // Näfels-Mollis railway station
    IBNR{8503228}, // Netstal railway station
    IBNR{8503230}, // Glarus railway station
    IBNR{8503231}, // Ennenda railway station
    IBNR{8503232}, // Mitlödi railway station
    IBNR{8503233}, // Schwanden railway station
    IBNR{8503234}, // Nidfurn-Haslen railway station
    IBNR{8503235}, // Leuggelbach railway station
    IBNR{8503236}, // Luchsingen-Hätzingen railway station
    IBNR{8503237}, // Diesbach-Betschwanden railway station
    IBNR{8503238}, // Rüti GL railway station
    IBNR{8503239}, // Linthal railway station
    IBNR{8503240}, // Linthal Braunwaldbahn railway station
    IBNR{8503280}, // Steinerberg station
    IBNR{8503281}, // Sattel-Aegeri station
    IBNR{8503282}, // Rothenthurm station
    IBNR{8503283}, // Einsiedeln railway station
    IBNR{8503284}, // Biberbrugg railway station
    IBNR{8503285}, // Schindellegi-Feusisberg railway station
    IBNR{8503286}, // Samstagern railway station
    IBNR{8503287}, // Burghalden railway station
    IBNR{8503288}, // Wollerau railway station
    IBNR{8503289}, // Freienbach SOB railway station
    IBNR{8503290}, // Biberegg station
    IBNR{8503292}, // Altmatt station
    IBNR{8503293}, // Grüenfeld railway station
    IBNR{8503294}, // Riedmatt railway station
    IBNR{8503295}, // Wilen railway station
    IBNR{8503299}, // Hurden railway station
    IBNR{8503300}, // Kempten railway station
    IBNR{8503301}, // Pfäffikon ZH railway station
    IBNR{8503302}, // Fehraltorf railway station
    IBNR{8503303}, // Illnau railway station
    IBNR{8503304}, // Kemptthal railway station
    IBNR{8503305}, // Effretikon railway station
    IBNR{8503306}, // Dietlikon railway station
    IBNR{8503307}, // Bassersdorf railway station
    IBNR{8503308}, // Kloten railway station
    IBNR{8503309}, // Kloten Balsberg railway station
    IBNR{8503310}, // Glattbrugg railway station
    IBNR{8503311}, // Rümlang railway station
    IBNR{8503312}, // Oberglatt Station
    IBNR{8503313}, // Niederglatt railway station
    IBNR{8503314}, // Niederhasli railway station
    IBNR{8503315}, // Dielsdorf railway station
    IBNR{8503316}, // Steinmaur railway station
    IBNR{8503317}, // Schöfflisdorf-Oberweningen railway station
    IBNR{8503318}, // Niederweningen Dorf railway station
    IBNR{8503319}, // Niederweningen railway station
    IBNR{8503340}, // Opfikon railway station
    IBNR{8503400}, // Bülach railway station
    IBNR{8503401}, // Glattfelden railway station
    IBNR{8503402}, // Eglisau railway station
    IBNR{8503403}, // Hüntwangen-Wil railway station
    IBNR{8503404}, // Rafz railway station
    IBNR{8503405}, // Zweidlen railway station
    IBNR{8503406}, // Q801584
    IBNR{8503408}, // Rekingen AG railway station
    IBNR{8503409}, // Bad Zurzach railway station
    IBNR{8503410}, // Rietheim railway station
    IBNR{8503411}, // Koblenz Dorf railway station
    IBNR{8503413}, // Kaiserstuhl AG railway station
    IBNR{8503414}, // Mellikon railway station
    IBNR{8503415}, // Rümikon AG railway station
    IBNR{8503420}, // Lottstetten railway station
    IBNR{8503421}, // Jestetten railway station
    IBNR{8503423}, // Neuhausen railway station
    IBNR{8503424}, // Schaffhausen railway station
    IBNR{8503425}, // Feuerthalen Station
    IBNR{8503426}, // Q15964170
    IBNR{8503427}, // Q15964271
    IBNR{8503428}, // Q15964127
    IBNR{8503429}, // Q15964269
    IBNR{8503463}, // Q11790768
    IBNR{8503464}, // Q9169065
    IBNR{8503465}, // Q11790775
    IBNR{8503466}, // Wilchingen-Hallau train station
    IBNR{8503467}, // Q9361343
    IBNR{8503501}, // Döttingen Station
    IBNR{8503502}, // Siggenthal-Würenlingen Station
    IBNR{8503503}, // Turgi railway station
    IBNR{8503504}, // Baden railway station
    IBNR{8503505}, // Wettingen railway station
    IBNR{8503506}, // Killwangen-Spreitenbach railway station
    IBNR{8503508}, // Dietikon railway station
    IBNR{8503509}, // Schlieren railway station
    IBNR{8503511}, // Neuenhof railway station
    IBNR{8503512}, // Glanzenberg railway station
    IBNR{8503525}, // Otelfingen Golfpark railway station
    IBNR{8503526}, // Regensdorf-Watt railway station
    IBNR{8503527}, // Buchs-Dällikon railway station
    IBNR{8503528}, // Otelfingen railway station
    IBNR{8503529}, // Würenlos railway station
    IBNR{8504000}, // Q15964202
    IBNR{8504003}, // Q15964083
    IBNR{8504007}, // Q15964185
    IBNR{8504010}, // Q15964161
    IBNR{8504011}, // Q15964134
    IBNR{8504012}, // Q15964203
    IBNR{8504013}, // Q15964085
    IBNR{8504014}, // Palézieux railway station
    IBNR{8504015}, // Q10952909
    IBNR{8504016}, // Palézieux-Village railway station
    IBNR{8504017}, // Châtillens railway station
    IBNR{8504018}, // Q15964106
    IBNR{8504019}, // Bressonnaz Station
    IBNR{8504020}, // Q15964205
    IBNR{8504021}, // Q15964278
    IBNR{8504022}, // Q15964255
    IBNR{8504023}, // Q5847067
    IBNR{8504024}, // Q15964279
    IBNR{8504025}, // Q15964086
    IBNR{8504026}, // Q15964107
    IBNR{8504027}, // Q15964206
    IBNR{8504028}, // Q15964231
    IBNR{8504029}, // Q15964187
    IBNR{8504030}, // Q15964280
    IBNR{8504040}, // Q10948087
    IBNR{8504060}, // Bossonnens station
    IBNR{8504061}, // Remaufens station
    IBNR{8504062}, // Châtel-St-Denis station
    IBNR{8504063}, // Semsales station
    IBNR{8504064}, // La Verrerie station
    IBNR{8504065}, // Vaulruz-Sud station
    IBNR{8504066}, // Vuadens-Sud station
    IBNR{8504067}, // La Tour-Village station
    IBNR{8504068}, // Epagny station
    IBNR{8504069}, // Les Marches station
    IBNR{8504070}, // Montbovon station
    IBNR{8504071}, // Lessoc station
    IBNR{8504072}, // Albeuve station
    IBNR{8504073}, // Neirivue station
    IBNR{8504074}, // Grandvillard station
    IBNR{8504075}, // Enney station
    IBNR{8504076}, // Estavannens station
    IBNR{8504077}, // Gruyères station
    IBNR{8504078}, // Le Pâquier-Montbarry station
    IBNR{8504079}, // La Tour-de-Trême station
    IBNR{8504086}, // Bulle station
    IBNR{8504088}, // Broc-Village station
    IBNR{8504089}, // Broc-Fabrique station
    IBNR{8504100}, // Fribourg railway station
    IBNR{8504101}, // Düdingen Station
    IBNR{8504102}, // Schmitten Station
    IBNR{8504103}, // Flamatt railway station
    IBNR{8504104}, // Q30088642
    IBNR{8504105}, // Niederwangen Station
    IBNR{8504106}, // Bern Bümpliz Süd Station
    IBNR{8504108}, // Bern Europaplatz SBB station
    IBNR{8504113}, // Wünnewil Station
    IBNR{8504115}, // Thörishaus Dorf Station
    IBNR{8504117}, // Oberwangen Station
    IBNR{8504120}, // Q15964186
    IBNR{8504121}, // Q14475054
    IBNR{8504122}, // Granges-Marnand railway station
    IBNR{8504123}, // Corcelles-Nord Station
    IBNR{8504124}, // Dompierre Station
    IBNR{8504125}, // Domdidier Station
    IBNR{8504126}, // Avenches Station
    IBNR{8504127}, // Faoug Station
    IBNR{8504128}, // Q5846782
    IBNR{8504129}, // Galmiz Station
    IBNR{8504130}, // Yvonand
    IBNR{8504131}, // Q15964087
    IBNR{8504132}, // Q15964108
    IBNR{8504133}, // Q15964109
    IBNR{8504134}, // Q5846899
    IBNR{8504135}, // Q15964088
    IBNR{8504136}, // Cousset Station
    IBNR{8504137}, // Q15964188
    IBNR{8504138}, // Q15964136
    IBNR{8504139}, // Q15964056
    IBNR{8504140}, // Muntelier-Löwenberg Station
    IBNR{8504141}, // Q15964135
    IBNR{8504142}, // Q15964277
    IBNR{8504144}, // Yverdon-Champ Pittet
    IBNR{8504149}, // Muntelier station
    IBNR{8504181}, // Q15964138
    IBNR{8504182}, // Q15964057
    IBNR{8504183}, // Q15964207
    IBNR{8504184}, // Q15964111
    IBNR{8504185}, // Q15964112
    IBNR{8504186}, // Q15964208
    IBNR{8504188}, // Sugiez station
    IBNR{8504191}, // Flamatt Dorf station
    IBNR{8504192}, // Neuenegg station
    IBNR{8504194}, // Laupen railway station
    IBNR{8504200}, // Yverdon-les-Bains
    IBNR{8504201}, // Grandson
    IBNR{8504203}, // Concise
    IBNR{8504204}, // Vaumarcus
    IBNR{8504205}, // Gorgier-Saint-Aubin
    IBNR{8504206}, // Bevaix
    IBNR{8504208}, // Boudry
    IBNR{8504209}, // Colombier
    IBNR{8504211}, // Verrières
    IBNR{8504215}, // Travers Station
    IBNR{8504216}, // Noiraigue Station
    IBNR{8504217}, // Champ-du-Moulin Station
    IBNR{8504218}, // Bôle Station
    IBNR{8504219}, // Auvernier
    IBNR{8504220}, // Neuchâtel-Serrières
    IBNR{8504221}, // Neuchâtel railway station
    IBNR{8504222}, // Saint-Blaise CFF
    IBNR{8504223}, // Cornaux
    IBNR{8504224}, // Cressier railway station
    IBNR{8504225}, // Le Landeron
    IBNR{8504226}, // La Neuveville
    IBNR{8504227}, // Ligerz
    IBNR{8504228}, // Twann
    IBNR{8504229}, // Tüscherz
    IBNR{8504231}, // Les Deurres Station
    IBNR{8504232}, // Corcelles-Peseux Station
    IBNR{8504234}, // Chambrelien Station
    IBNR{8504235}, // Montmollin-Montezillon Station
    IBNR{8504236}, // Les Geneveys-sur-Coffrane Station
    IBNR{8504237}, // Les Hauts-Geneveys Station
    IBNR{8504284}, // La Presta Mines d'asphalte station
    IBNR{8504285}, // Couvet station
    IBNR{8504286}, // Môtiers station
    IBNR{8504287}, // Fleurier station
    IBNR{8504288}, // Buttes station
    IBNR{8504291}, // La Brinaz station
    IBNR{8504292}, // Valeyres-sous-Montagny station
    IBNR{8504293}, // Essert-sous-Champvent station
    IBNR{8504294}, // Vuiteboeuf station
    IBNR{8504295}, // Baulmes station
    IBNR{8504296}, // Six-Fontaines station
    IBNR{8504297}, // Trois-Villes station
    IBNR{8504298}, // Ste-Croix station
    IBNR{8504300}, // Biel/Bienne railway station
    IBNR{8504301}, // Frinvillier-Taubenloch Station
    IBNR{8504302}, // Reuchenette-Péry Station
    IBNR{8504303}, // La Heutte Station
    IBNR{8504304}, // Q5847270
    IBNR{8504305}, // Corgémont Station
    IBNR{8504306}, // Cortébert Station
    IBNR{8504307}, // Courtelary Station
    IBNR{8504308}, // Cormoret Station
    IBNR{8504309}, // Villeret Station
    IBNR{8504310}, // St-Imier Station
    IBNR{8504311}, // Sonvilier Station
    IBNR{8504312}, // Renan BE Station
    IBNR{8504314}, // La Chaux-de-Fonds railway station
    IBNR{8504315}, // Q3098196
    IBNR{8504316}, // Le Locle
    IBNR{8504317}, // Locle-Col des Roches
    IBNR{8504325}, // Colombier NE Littorail station
    IBNR{8504381}, // La Chaux-de-Fonds-Grenier station
    IBNR{8504382}, // Le Reymond station
    IBNR{8504383}, // La Corbatière station
    IBNR{8504384}, // La Sagne-Eglise station
    IBNR{8504385}, // La Sagne station
    IBNR{8504386}, // Les Coeudres station
    IBNR{8504387}, // Petit-Martel station
    IBNR{8504388}, // Les Ponts-de-Martel station
    IBNR{8504391}, // Les Frêtes station
    IBNR{8504392}, // Les Brenets station
    IBNR{8504398}, // Neuchâtel,Place Pury Littorail station
    IBNR{8504400}, // Kerzers station
    IBNR{8504401}, // Q5846260
    IBNR{8504402}, // Q5846437
    IBNR{8504403}, // Bargen Station
    IBNR{8504404}, // Q5845568
    IBNR{8504410}, // Q15964310
    IBNR{8504411}, // Münchenbuchsee Station
    IBNR{8504412}, // Schüpfen Station
    IBNR{8504413}, // Suberg-Grossaffoltern Station
    IBNR{8504414}, // Q15964198
    IBNR{8504415}, // Busswil Station
    IBNR{8504416}, // Brügg BE Station
    IBNR{8504419}, // Biel Mett
    IBNR{8504441}, // Studen BE Station
    IBNR{8504461}, // Nidau station
    IBNR{8504462}, // Lattrigen station
    IBNR{8504463}, // Täuffelen station
    IBNR{8504464}, // Hagneck station
    IBNR{8504465}, // Lüscherz station
    IBNR{8504466}, // Siselen-Finsterhennen station
    IBNR{8504467}, // Brüttelen station
    IBNR{8504468}, // Ins Dorf station
    IBNR{8504469}, // Nidau Beunden station
    IBNR{8504470}, // Ipsach Herdi station
    IBNR{8504471}, // Ipsach station
    IBNR{8504472}, // Sutz station
    IBNR{8504474}, // Mörigen station
    IBNR{8504475}, // Gerolfingen station
    IBNR{8504480}, // Saint-Blaise-Lac
    IBNR{8504481}, // Marin-Epagnier
    IBNR{8504482}, // Gampelen station
    IBNR{8504483}, // Ins station
    IBNR{8504484}, // Müntschemier station
    IBNR{8504485}, // Ferenbalm-Gurbrü station
    IBNR{8504486}, // Gümmenen station
    IBNR{8504487}, // Rosshäusern station
    IBNR{8504488}, // Riedbach station
    IBNR{8504489}, // Bern Bümpliz Nord station
    IBNR{8504490}, // Zihlbrücke station
    IBNR{8504495}, // Bern Stöckacker station
    IBNR{8504509}, // Neuchâtel, Port-de-Serrières station
    IBNR{8504510}, // Auvernier Littorail station
    IBNR{8504511}, // Boudry Littorail station
    IBNR{8505000}, // Lucerne railway station
    IBNR{8505001}, // Q12174812
    IBNR{8505002}, // Küssnacht am Rigi station
    IBNR{8505003}, // Immensee station
    IBNR{8505004}, // Arth-Goldau railway station
    IBNR{8505005}, // Steinen station
    IBNR{8505006}, // Schwyz railway station
    IBNR{8505007}, // Brunnen railway station
    IBNR{8505011}, // Merlischachen station
    IBNR{8505018}, // Q12174810
    IBNR{8505062}, // Goldau A4 station
    IBNR{8505063}, // Arth-Goldau RB station
    IBNR{8505064}, // Kräbel station
    IBNR{8505065}, // Fruttli station
    IBNR{8505066}, // Rigi Klösterli station
    IBNR{8505067}, // Rigi Wölfertschen-First station
    IBNR{8505068}, // Rigi Staffel station
    IBNR{8505069}, // Rigi Kulm station
    IBNR{8505071}, // Grubisbalm station
    IBNR{8505072}, // Freibergen station
    IBNR{8505073}, // Romiti Felsentor station
    IBNR{8505074}, // Rigi Kaltbad-First station
    IBNR{8505075}, // Rigi Staffelhöhe station
    IBNR{8505079}, // Mittlerschwanden station
    IBNR{8505111}, // Sisikon railway station
    IBNR{8505112}, // Flüelen railway station
    IBNR{8505113}, // Altdorf railway station
    IBNR{8505114}, // Erstfeld railway station
    IBNR{8505119}, // Göschenen
    IBNR{8505163}, // Realp railway station
    IBNR{8505164}, // Hospental railway station
    IBNR{8505165}, // Andermatt railway station
    IBNR{8505170}, // Nätschen railway station
    IBNR{8505172}, // Oberalppass railway station
    IBNR{8505173}, // Tschamut-Selva railway station
    IBNR{8505174}, // Dieni railway station
    IBNR{8505175}, // Rueras railway station
    IBNR{8505176}, // Sedrun railway station
    IBNR{8505177}, // Bugnei railway station
    IBNR{8505178}, // Mumpé Tujetsch railway station
    IBNR{8505179}, // Segnas railway station
    IBNR{8505180}, // Acla da Fontauna railway station
    IBNR{8505201}, // Airolo railway station
    IBNR{8505202}, // Ambrì-Piotta railway station
    IBNR{8505204}, // Faido railway station
    IBNR{8505205}, // Lavorgo railway station
    IBNR{8505207}, // Bodio railway station
    IBNR{8505209}, // Biasca railway station
    IBNR{8505212}, // Castione-Arbedo railway station
    IBNR{8505213}, // Bellinzona railway station
    IBNR{8505214}, // Giubiasco railway station
    IBNR{8505216}, // Rivera-Bironico railway station
    IBNR{8505217}, // Mezzovico railway station
    IBNR{8505218}, // Taverne-Torricella railway station
    IBNR{8505219}, // Lamone-Cadempino railway station
    IBNR{8505300}, // Lugano railway station
    IBNR{8505301}, // Lugano-Paradiso railway station
    IBNR{8505302}, // Melide railway station
    IBNR{8505303}, // Maroggia-Melano railway station
    IBNR{8505304}, // Capolago-Riva San Vitale railway station
    IBNR{8505305}, // Mendrisio railway station
    IBNR{8505306}, // Balerna railway station
    IBNR{8505307}, // Chiasso railway station
    IBNR{8505367}, // Capolago Lago railway station
    IBNR{8505372}, // San Nicolao railway station
    IBNR{8505373}, // Bellavista railway station
    IBNR{8505374}, // Generoso Vetta railway station
    IBNR{8505390}, // Serocca railway station
    IBNR{8505391}, // Lugano FPL railway station
    IBNR{8505392}, // Magliaso Paese railway station
    IBNR{8505393}, // Cappella-Agnuzzo railway station
    IBNR{8505394}, // Bioggio railway station
    IBNR{8505395}, // Agno railway station
    IBNR{8505396}, // Magliaso railway station
    IBNR{8505397}, // Caslano railway station
    IBNR{8505398}, // Ponte Tresa railway station
    IBNR{8505399}, // Sorengo railway station
    IBNR{8505400}, // Locarno railway station
    IBNR{8505401}, // Q12174832
    IBNR{8505402}, // Q12174801
    IBNR{8505403}, // Riazzino-Cugnasco train station
    IBNR{8505404}, // Cadenazzo railway station
    IBNR{8505405}, // Q15964201
    IBNR{8505406}, // Q15964178
    IBNR{8505407}, // Q15964229
    IBNR{8505408}, // Ranzo-Sant’Abbondio railway station
    IBNR{8505410}, // Gerra (Gambarogno) railway station
    IBNR{8505412}, // Q12174819
    IBNR{8505415}, // Sant'Antonino
    IBNR{8505467}, // San Martino train station
    IBNR{8505470}, // Locarno FART station
    IBNR{8505471}, // Locarno Sant'Antonio train station
    IBNR{8505472}, // Solduno train station
    IBNR{8505473}, // Q17637457
    IBNR{8505474}, // Q17637118
    IBNR{8505475}, // Q17637281
    IBNR{8505477}, // Q17637112
    IBNR{8505479}, // Q17637337
    IBNR{8505482}, // Q17637569
    IBNR{8505486}, // Q17637133
    IBNR{8505491}, // Q17637585
    IBNR{8505492}, // Verscio train station
    IBNR{8505493}, // Cavigliano train station
    IBNR{8505494}, // Q17637306
    IBNR{8505495}, // Q17637209
    IBNR{8505496}, // Q17637629
    IBNR{8505497}, // Q17637428
    IBNR{8505498}, // Q17637136
    IBNR{8505499}, // Q17637154
    IBNR{8505550}, // Q19545553
    IBNR{8506000}, // Winterthur railway station
    IBNR{8506001}, // Winterthur Grüze railway station
    IBNR{8506002}, // Winterthur Seen railway station
    IBNR{8506003}, // Sennhof-Kyburg railway station
    IBNR{8506004}, // Kollbrunn railway station
    IBNR{8506005}, // Rikon railway station
    IBNR{8506006}, // Rämismühle-Zell railway station
    IBNR{8506007}, // Turbenthal railway station
    IBNR{8506008}, // Wila railway station
    IBNR{8506009}, // Saland railway station
    IBNR{8506010}, // Train station of Sirnach
    IBNR{8506011}, // Eschlikon railway station
    IBNR{8506012}, // Guntershausen railway station
    IBNR{8506013}, // Aadorf railway station
    IBNR{8506014}, // Elgg railway station
    IBNR{8506015}, // Räterschen railway station
    IBNR{8506016}, // Oberwinterthur railway station
    IBNR{8506017}, // Wiesendangen railway station
    IBNR{8506018}, // Rickenbach-Attikon railway station
    IBNR{8506019}, // Islikon railway station
    IBNR{8506020}, // Seuzach railway station
    IBNR{8506021}, // Dinhard railway station
    IBNR{8506022}, // Thalheim-Altikon railway station
    IBNR{8506023}, // Ossingen railway station
    IBNR{8506024}, // Stammheim railway station
    IBNR{8506025}, // Etzwilen railway station
    IBNR{8506026}, // Hemishofen Station
    IBNR{8506027}, // Ramsen Station
    IBNR{8506035}, // Schottikon railway station
    IBNR{8506036}, // Reutlingen railway station
    IBNR{8506038}, // Winterthur Wallrüti railway station
    IBNR{8506039}, // Schloss Laufen am Rheinfall
    IBNR{8506041}, // Embrach-Rorbas railway station
    IBNR{8506042}, // Pfungen-Neftenbach railway station
    IBNR{8506043}, // Winterthur Wülflingen railway station
    IBNR{8506044}, // Winterthur Töss railway station
    IBNR{8506045}, // Hettlingen railway station
    IBNR{8506046}, // Henggart railway station
    IBNR{8506047}, // Andelfingen railway station
    IBNR{8506048}, // Marthalen railway station
    IBNR{8506049}, // Dachsen railway station
    IBNR{8506100}, // Frauenfeld railway station
    IBNR{8506101}, // Felben-Wellhausen railway station
    IBNR{8506102}, // Hüttlingen-Mettendorf railway station
    IBNR{8506103}, // Müllheim-Wigoltingen railway station
    IBNR{8506104}, // Märstetten railway station
    IBNR{8506105}, // Weinfelden railway station
    IBNR{8506106}, // Bürglen station
    IBNR{8506107}, // Erlen station
    IBNR{8506108}, // Q5846823
    IBNR{8506109}, // Amriswil station
    IBNR{8506118}, // Triboltingen Station
    IBNR{8506119}, // Kurzrickenbach Seepark Station
    IBNR{8506121}, // Romanshorn railway station
    IBNR{8506122}, // Uttwil station
    IBNR{8506123}, // Q15964169
    IBNR{8506124}, // Güttingen station
    IBNR{8506125}, // Altnau station
    IBNR{8506126}, // Münsterlingen-Scherzingen Station
    IBNR{8506127}, // Bottighofen Station
    IBNR{8506128}, // Kreuzlingen Hafen Station
    IBNR{8506131}, // Kreuzlingen station
    IBNR{8506132}, // Tägerwilen-Gottlieben Station
    IBNR{8506133}, // Q15964126
    IBNR{8506134}, // Mannenbach-Salenstein  station
    IBNR{8506135}, // Berlingen station
    IBNR{8506136}, // Steckborn Station
    IBNR{8506137}, // Q15964193
    IBNR{8506138}, // Q15964125
    IBNR{8506139}, // Stein am Rhein railway station
    IBNR{8506143}, // Münsterlingen Spital Station
    IBNR{8506148}, // Q15964270
    IBNR{8506168}, // Tägerschen station
    IBNR{8506169}, // Wiesengrund station
    IBNR{8506170}, // Münchwilen Pflegeheim station
    IBNR{8506171}, // Frauenfeld Marktplatz station
    IBNR{8506172}, // Murkart station
    IBNR{8506173}, // Weberei Matzingen station
    IBNR{8506174}, // Matzingen station
    IBNR{8506175}, // Jakobstal station
    IBNR{8506176}, // Wängi station
    IBNR{8506177}, // Rosental station
    IBNR{8506178}, // Münchwilen TG station
    IBNR{8506179}, // Lüdem station
    IBNR{8506181}, // Bronschhofen station
    IBNR{8506182}, // Bettwiesen station
    IBNR{8506183}, // Tobel-Affeltrangen station
    IBNR{8506184}, // Märwil station
    IBNR{8506185}, // Oppikon station
    IBNR{8506188}, // Bronschhofen AMP station
    IBNR{8506190}, // Bussnang station
    IBNR{8506193}, // Kehlhof station
    IBNR{8506194}, // Berg station
    IBNR{8506195}, // Siegershausen station
    IBNR{8506196}, // Lengwil station
    IBNR{8506197}, // Kreuzlingen Bernrain station
    IBNR{8506198}, // Tägerwilen Dorf station
    IBNR{8506200}, // Wattwil Station
    IBNR{8506201}, // Lichtensteig station
    IBNR{8506202}, // Dietfurt Station
    IBNR{8506203}, // Bütschwil Station
    IBNR{8506204}, // Lütisburg Station
    IBNR{8506205}, // Bazenheid Station
    IBNR{8506206}, // Wil railway station
    IBNR{8506207}, // Schwarzenbach SG
    IBNR{8506208}, // Uzwil railway station
    IBNR{8506209}, // Flawil station
    IBNR{8506210}, // Gossau station
    IBNR{8506211}, // Arnegg station
    IBNR{8506212}, // Hauptwil station
    IBNR{8506213}, // Bischofszell Stadt
    IBNR{8506214}, // Sitterdorf station
    IBNR{8506215}, // Bischofszell Nord
    IBNR{8506216}, // Kradolf station
    IBNR{8506217}, // Sulgen railway station
    IBNR{8506220}, // Q5845647
    IBNR{8506270}, // St. Gallen Marktplatz station
    IBNR{8506271}, // Gontenbad station
    IBNR{8506275}, // Steinegg station
    IBNR{8506276}, // Strahlholz station
    IBNR{8506277}, // Schwende station
    IBNR{8506278}, // Seebleiche station
    IBNR{8506280}, // Wilen railway station
    IBNR{8506281}, // Waldstatt station
    IBNR{8506282}, // Zürchersmühle station
    IBNR{8506283}, // Urnäsch station
    IBNR{8506284}, // Jakobsbad station
    IBNR{8506285}, // Gonten station
    IBNR{8506286}, // Appenzell station
    IBNR{8506287}, // Gübsensee station
    IBNR{8506288}, // Weissbad station
    IBNR{8506289}, // Wasserauen station
    IBNR{8506290}, // Herisau railway station
    IBNR{8506291}, // Schachen (Herisau) station
    IBNR{8506292}, // Degersheim station
    IBNR{8506293}, // Mogelsberg station
    IBNR{8506294}, // Brunnadern-Neckertal station
    IBNR{8506297}, // Ebnat-Kappel station
    IBNR{8506298}, // Krummenau station
    IBNR{8506299}, // Nesslau-Neu St. Johann Station
    IBNR{8506300}, // St. Gallen Winkeln station
    IBNR{8506301}, // St. Gallen Bruggen station
    IBNR{8506302}, // St. Gallen railway station
    IBNR{8506303}, // St. Gallen St. Fiden railway station
    IBNR{8506304}, // Q15964195
    IBNR{8506305}, // Goldach station
    IBNR{8506306}, // Rorschach Hafen station
    IBNR{8506307}, // Horn station
    IBNR{8506308}, // Q15964072
    IBNR{8506309}, // Q15964123
    IBNR{8506311}, // Rorschach station
    IBNR{8506312}, // Staad station
    IBNR{8506313}, // Rheineck railway station
    IBNR{8506314}, // Q15639432
    IBNR{8506316}, // Q15964071
    IBNR{8506317}, // Heerbrugg Station
    IBNR{8506318}, // Q15964222
    IBNR{8506319}, // Altstätten SG station
    IBNR{8506322}, // Q15964244
    IBNR{8506350}, // Walzenhausen station
    IBNR{8506351}, // Ruderbach station
    IBNR{8506352}, // Wartensee station
    IBNR{8506353}, // Wienacht-Tobel station
    IBNR{8506354}, // Schwendi bei Heiden station
    IBNR{8506355}, // Heiden station
    IBNR{8506358}, // St. Gallen Spisertor station
    IBNR{8506359}, // St. Gallen Schülerhaus station
    IBNR{8506361}, // St. Gallen Notkersegg station
    IBNR{8506362}, // Schwarzer Bären station
    IBNR{8506363}, // Rank station
    IBNR{8506364}, // Vögelinsegg station
    IBNR{8506365}, // Schützengarten station
    IBNR{8506366}, // Speicher station
    IBNR{8506367}, // Bendlehn station
    IBNR{8506368}, // Gfeld station
    IBNR{8506369}, // Trogen station
    IBNR{8506370}, // St. Gallen AB station
    IBNR{8506371}, // St. Gallen Riethüsli station
    IBNR{8506372}, // Lustmühle station
    IBNR{8506373}, // Niederteufen station
    IBNR{8506374}, // Sternen bei Teufen station
    IBNR{8506375}, // Teufen station
    IBNR{8506376}, // Steigbach station
    IBNR{8506377}, // Bühler station
    IBNR{8506378}, // Gais station
    IBNR{8506379}, // Altstätten Stadt station
    IBNR{8506380}, // Hirschberg station
    IBNR{8506381}, // Sammelplatz station
    IBNR{8506382}, // Zweibrücken station
    IBNR{8506383}, // Hebrig station
    IBNR{8506384}, // Schachen (Gais) station
    IBNR{8506385}, // Rietli station
    IBNR{8506386}, // Stoss AR station
    IBNR{8506387}, // Kreuzstrasse station
    IBNR{8506388}, // Warmesberg station
    IBNR{8506389}, // Alter Zoll station
    IBNR{8506392}, // St. Gallen Haggen station
    IBNR{8506393}, // Q15964309
    IBNR{8506394}, // Roggwil-Berg station
    IBNR{8506395}, // Häggenschwil-Winden station
    IBNR{8506396}, // Muolen station
    IBNR{8506397}, // Steinebrunn station
    IBNR{8506398}, // Neukirch-Egnach station
    IBNR{8506400}, // Sandbüchel station
    IBNR{8506470}, // Stofel station
    IBNR{8507000}, // Bern railway station
    IBNR{8507002}, // Ostermundigen Station
    IBNR{8507003}, // Gümligen Station
    IBNR{8507005}, // Rubigen Station
    IBNR{8507006}, // Münsingen Station
    IBNR{8507007}, // Wichtrach Station
    IBNR{8507008}, // Kiesen Station
    IBNR{8507009}, // Uttigen Station
    IBNR{8507063}, // Worb Dorf station
    IBNR{8507064}, // Vechigen station
    IBNR{8507065}, // Boll-Utzigen station
    IBNR{8507066}, // Stettlen station
    IBNR{8507067}, // Deisswil station
    IBNR{8507068}, // Bolligen station
    IBNR{8507069}, // Ittigen bei Bern station
    IBNR{8507070}, // Uetendorf station
    IBNR{8507071}, // Seftigen station
    IBNR{8507072}, // Burgistein station
    IBNR{8507073}, // Thurnen station
    IBNR{8507074}, // Kaufdorf station
    IBNR{8507075}, // Q15964294
    IBNR{8507076}, // Q15964076
    IBNR{8507077}, // Kehrsatz station
    IBNR{8507078}, // Wabern bei Bern station
    IBNR{8507079}, // Bern Weissenbühl station
    IBNR{8507082}, // Bern Europaplatz BLS station
    IBNR{8507083}, // Köniz station
    IBNR{8507084}, // Moos station
    IBNR{8507085}, // Gasel station
    IBNR{8507086}, // Niederscherli station
    IBNR{8507087}, // Mittelhäusern station
    IBNR{8507088}, // Lanzenhäusern station
    IBNR{8507089}, // Schwarzenburg station
    IBNR{8507091}, // Liebefeld station
    IBNR{8507092}, // Belp Steinbach station
    IBNR{8507093}, // Kehrsatz Nord station
    IBNR{8507094}, // Uetendorf Allmend station
    IBNR{8507095}, // Schwarzwasserbrücke station
    IBNR{8507096}, // Papiermühle station
    IBNR{8507100}, // Thun railway station
    IBNR{8507270}, // Gruben station
    IBNR{8507271}, // Schönried station
    IBNR{8507272}, // Saanenmöser station
    IBNR{8507273}, // Oeschseite station
    IBNR{8507274}, // Blankenburg station
    IBNR{8507275}, // Stöckli station
    IBNR{8507276}, // St. Stephan station
    IBNR{8507277}, // Matten station
    IBNR{8507278}, // Boden station
    IBNR{8507279}, // Lenk im Simmental station
    IBNR{8507281}, // Grubenwald station
    IBNR{8507284}, // Enge im Simmental station
    IBNR{8507286}, // Ringoldingen station
    IBNR{8507287}, // Burgholz station
    IBNR{8507288}, // Eifeld station
    IBNR{8507290}, // Q15964311
    IBNR{8507291}, // Weissenbach station
    IBNR{8507292}, // Boltigen station
    IBNR{8507293}, // Oberwil im Simmental station
    IBNR{8507294}, // Weissenburg station
    IBNR{8507295}, // Därstetten station
    IBNR{8507296}, // Erlenbach im Simmental station
    IBNR{8507297}, // Oey-Diemtigen station
    IBNR{8507298}, // Wimmis station
    IBNR{8507299}, // Lattigen bei Spiez station
    IBNR{8507361}, // Eigergletscher railway station
    IBNR{8507362}, // Eigerwand railway station
    IBNR{8507363}, // Eismeer railway station
    IBNR{8507364}, // Jungfraujoch railway station
    IBNR{8507372}, // Wengen railway station
    IBNR{8507373}, // Wengernalp railway station
    IBNR{8507374}, // Kleine Scheidegg railway station
    IBNR{8507375}, // Alpiglen railway station
    IBNR{8507376}, // Grindelwald Grund railway station
    IBNR{8507378}, // Grütschalp railway station
    IBNR{8507379}, // Mürren railway station
    IBNR{8507380}, // Grindelwald railway station
    IBNR{8507381}, // Schwendi railway station
    IBNR{8507382}, // Burglauenen railway station
    IBNR{8507383}, // Lütschental railway station
    IBNR{8507384}, // Lauterbrunnen railway station
    IBNR{8507385}, // Umler station
    IBNR{8507386}, // Breitlauenen railway station
    IBNR{8507387}, // Schynige Platte railway station
    IBNR{8507388}, // Wilderswil railway station
    IBNR{8507389}, // Zweilütschinen railway station
    IBNR{8507470}, // Lalden railway station
    IBNR{8507471}, // Eggerberg railway station
    IBNR{8507472}, // Ausserberg railway station
    IBNR{8507473}, // Hohtenn railway station
    IBNR{8507474}, // Goppenstein railway station
    IBNR{8507475}, // Kandersteg railway station
    IBNR{8507476}, // Blausee-Mitholz station
    IBNR{8507478}, // Frutigen railway station
    IBNR{8507480}, // Reichenbach im Kandertal railway station
    IBNR{8507481}, // Mülenen railway station
    IBNR{8507483}, // Spiez railway station
    IBNR{8507492}, // Interlaken Ost railway station
    IBNR{8507493}, // Interlaken West railway station
    IBNR{8507494}, // Därligen station
    IBNR{8507495}, // Leissigen station
    IBNR{8507496}, // Faulensee station
    IBNR{8507550}, // Allmend railway station
    IBNR{8507551}, // Bannwald station
    IBNR{8507552}, // Brandegg railway station
    IBNR{8507553}, // Salzegg station
    IBNR{8507555}, // Wengwald railway station
    IBNR{8507556}, // Strättli station
    IBNR{8507557}, // Sandweid railway station
    IBNR{8507558}, // Rotenegg station
    IBNR{8507559}, // Witimatte station
    IBNR{8507560}, // Winteregg railway station
    IBNR{8507566}, // Rohrfluh station
    IBNR{8508001}, // Schönbühl SBB Station
    IBNR{8508003}, // Hindelbank Station
    IBNR{8508004}, // Lyssach Station
    IBNR{8508005}, // Burgdorf station
    IBNR{8508006}, // Q5847534
    IBNR{8508008}, // Q5846371
    IBNR{8508051}, // Bern Felsenau station
    IBNR{8508052}, // Bern Tiefenau station
    IBNR{8508053}, // Steinibach station
    IBNR{8508054}, // Worblaufen station
    IBNR{8508055}, // Unterzollikofen station
    IBNR{8508056}, // Moosseedorf station
    IBNR{8508057}, // Schönbühl RBS station
    IBNR{8508058}, // Urtenen station
    IBNR{8508059}, // Jegenstorf station
    IBNR{8508060}, // Grafenried station
    IBNR{8508061}, // Fraubrunnen station
    IBNR{8508062}, // Büren zum Hof station
    IBNR{8508063}, // Schalunen station
    IBNR{8508064}, // Bätterkinden station
    IBNR{8508066}, // Lohn-Lüterkofen station
    IBNR{8508068}, // Biberist RBS station
    IBNR{8508070}, // Oberzollikofen station
    IBNR{8508071}, // Schönbühl Shoppyland station
    IBNR{8508080}, // Oberburg station
    IBNR{8508081}, // Burgdorf Steinhof station
    IBNR{8508083}, // Burgdorf Buchmatt station
    IBNR{8508084}, // Kirchberg-Alchenflüh station
    IBNR{8508085}, // Q15964077
    IBNR{8508086}, // Q15964296
    IBNR{8508087}, // Q15964295
    IBNR{8508088}, // Gerlafingen station
    IBNR{8508089}, // Biberist Ost station
    IBNR{8508100}, // Q5846546
    IBNR{8508101}, // Q15964248
    IBNR{8508102}, // Q15964196
    IBNR{8508103}, // Q15964247
    IBNR{8508151}, // Langenthal Gaswerk station
    IBNR{8508152}, // Hard-Mumenthal station
    IBNR{8508153}, // Aarwangen station
    IBNR{8508154}, // Aarwangen Schloss station
    IBNR{8508155}, // Bannwil station
    IBNR{8508157}, // Holzhäusern station
    IBNR{8508158}, // Scharnageln station
    IBNR{8508159}, // Niederbipp Dorf station
    IBNR{8508160}, // Langenthal [Gleis 4-5] station
    IBNR{8508161}, // Kaltenherberg station
    IBNR{8508162}, // Roggwil Dorf station
    IBNR{8508163}, // St. Urban station
    IBNR{8508164}, // St. Urban Ziegelei station
    IBNR{8508168}, // Roggwil Buchägerten station
    IBNR{8508173}, // Roggwil Schmitten station
    IBNR{8508174}, // Gutenburg station
    IBNR{8508181}, // Langenthal Süd station
    IBNR{8508182}, // Lotzwil station
    IBNR{8508183}, // Madiswil station
    IBNR{8508184}, // Lindenholz station
    IBNR{8508185}, // Kleindietwil station
    IBNR{8508186}, // Rohrbach station
    IBNR{8508187}, // Huttwil station
    IBNR{8508193}, // Aarwangen Vorstadt station
    IBNR{8508194}, // Huttwil Sportzentrum station
    IBNR{8508200}, // Worb SBB Station
    IBNR{8508201}, // Tägertschi Station
    IBNR{8508202}, // Konolfingen Station
    IBNR{8508203}, // Zäziwil Station
    IBNR{8508204}, // Bowil Station
    IBNR{8508205}, // Signau Station
    IBNR{8508206}, // Emmenmatt Station
    IBNR{8508207}, // Langnau im Emmental railway station
    IBNR{8508208}, // Trubschachen Station
    IBNR{8508210}, // Escholzmatt Station
    IBNR{8508211}, // Schüpfheim Station
    IBNR{8508212}, // Hasle LU Station
    IBNR{8508213}, // Entlebuch Station
    IBNR{8508215}, // Wolhusen Station
    IBNR{8508216}, // Werthenstein Station
    IBNR{8508217}, // Schachen LU Station
    IBNR{8508218}, // Malters Station
    IBNR{8508219}, // Littau Station
    IBNR{8508250}, // Schwäbis station
    IBNR{8508251}, // Steffisburg station
    IBNR{8508252}, // Lädeli station
    IBNR{8508253}, // Heimberg station
    IBNR{8508254}, // Brenzikofen station
    IBNR{8508255}, // Oberdiessbach station
    IBNR{8508256}, // Stalden i.E. station
    IBNR{8508260}, // Grosshöchstetten station
    IBNR{8508261}, // Biglen station
    IBNR{8508262}, // Walkringen station
    IBNR{8508263}, // Bigenthal station
    IBNR{8508264}, // Schafhausen i.E. station
    IBNR{8508265}, // Q15964153
    IBNR{8508266}, // Q15964199
    IBNR{8508267}, // Ramsei station
    IBNR{8508268}, // Zollbrück station
    IBNR{8508269}, // Neumühle station
    IBNR{8508271}, // Grünenmatt station
    IBNR{8508272}, // Sumiswald-Grünen station
    IBNR{8508275}, // Affoltern-Weier railway station
    IBNR{8508276}, // Häusernmoos station
    IBNR{8508278}, // Dürrenroth station
    IBNR{8508285}, // Gammenthal station
    IBNR{8508286}, // Griesbach station
    IBNR{8508287}, // Mussachen station
    IBNR{8508292}, // Hüswil station
    IBNR{8508293}, // Zell station
    IBNR{8508294}, // Gettnau station
    IBNR{8508295}, // Willisau station
    IBNR{8508297}, // Menznau station
    IBNR{8508301}, // Ringgenberg railway station
    IBNR{8508302}, // Niederried railway station
    IBNR{8508303}, // Oberried am Brienzersee railway station
    IBNR{8508304}, // Ebligen railway station
    IBNR{8508305}, // Brienz railway station
    IBNR{8508306}, // Brienzwiler railway station
    IBNR{8508308}, // Meiringen railway station
    IBNR{8508309}, // Brünig-Hasliberg railway station
    IBNR{8508310}, // Lungern railway station
    IBNR{8508311}, // Kaiserstuhl OW railway station
    IBNR{8508312}, // Giswil railway station
    IBNR{8508313}, // Sachseln railway station
    IBNR{8508314}, // Sarnen railway station
    IBNR{8508316}, // Alpnach Dorf railway station
    IBNR{8508317}, // Alpnachstad railway station
    IBNR{8508318}, // Hergiswil railway station
    IBNR{8508319}, // Horw railway station
    IBNR{8508320}, // Hergiswil Matt railway station
    IBNR{8508321}, // Lucerne Allmend/Messe railway station
    IBNR{8508323}, // Sarnen Nord station
    IBNR{8508327}, // Ewil Maxon railway station
    IBNR{8508329}, // Brienz West railway station
    IBNR{8508350}, // Brienz BRB station
    IBNR{8508351}, // Planalp station
    IBNR{8508352}, // Brienzer Rothorn station
    IBNR{8508359}, // Innertkirchen MIB station
    IBNR{8508384}, // Niederrickenbach railway station
    IBNR{8508386}, // Dörfli railway station
    IBNR{8508390}, // Stansstad railway station
    IBNR{8508391}, // Stans railway station
    IBNR{8508392}, // Dallenwil railway station
    IBNR{8508394}, // Wolfenschiessen railway station
    IBNR{8508395}, // Innertkirchen Grimseltor station
    IBNR{8508396}, // Grafenort railway station
    IBNR{8508399}, // Engelberg railway station
    IBNR{8508449}, // Aemsigen station
    IBNR{8508456}, // Pilatus Kulm station
    IBNR{8508458}, // Alpnachstad PB station
    IBNR{8508464}, // Vitznau station
    IBNR{8509000}, // Chur
    IBNR{8509002}, // Landquart railway station
    IBNR{8509003}, // Maienfeld railway station
    IBNR{8509004}, // Bad Ragaz station
    IBNR{8509006}, // Chur Wiesental station
    IBNR{8509050}, // Chur West
    IBNR{8509051}, // Haldenstein
    IBNR{8509053}, // Untervaz-Trimmis
    IBNR{8509054}, // Zizers
    IBNR{8509055}, // Igis
    IBNR{8509056}, // Landquart Ried
    IBNR{8509057}, // Malans
    IBNR{8509058}, // Seewis-Valzeina station
    IBNR{8509059}, // Grusch
    IBNR{8509060}, // Schiers
    IBNR{8509061}, // Furna station
    IBNR{8509062}, // Jenaz
    IBNR{8509063}, // Fideris station
    IBNR{8509064}, // Kublis
    IBNR{8509065}, // Saas
    IBNR{8509067}, // Klosters Dorf
    IBNR{8509068}, // Klosters Platz
    IBNR{8509069}, // Cavadürli
    IBNR{8509070}, // Davos Laret
    IBNR{8509071}, // Davos Wolfgang
    IBNR{8509072}, // Davos Dorf
    IBNR{8509073}, // Davos Platz
    IBNR{8509075}, // Davos Frauenkirch
    IBNR{8509076}, // Davos Glaris
    IBNR{8509077}, // Davos Monstein
    IBNR{8509078}, // Davos Wiesen station
    IBNR{8509095}, // Klosters Selfranga station
    IBNR{8509150}, // Chur Stadt station
    IBNR{8509151}, // Sassal
    IBNR{8509152}, // Lüen-Castiel
    IBNR{8509153}, // Sankt Peter-Molinis station
    IBNR{8509154}, // Peist (Rhaetian Railway station)
    IBNR{8509155}, // Langwies (Rhaetian Railway station)
    IBNR{8509156}, // Litzirüti
    IBNR{8509157}, // Arosa
    IBNR{8509167}, // Trin
    IBNR{8509168}, // Versam-Safien
    IBNR{8509169}, // Valendas-Sagogn
    IBNR{8509170}, // Castrisch
    IBNR{8509171}, // Ilanz
    IBNR{8509173}, // Rueun
    IBNR{8509174}, // Waltensburg/Vuorz
    IBNR{8509175}, // Tavanasa-Breil/Brigels
    IBNR{8509176}, // Trun
    IBNR{8509177}, // Rabius-Surrein
    IBNR{8509178}, // Sumvitg-Cumpadials
    IBNR{8509179}, // Disentis/Mustér railway station
    IBNR{8509180}, // Felsberg station
    IBNR{8509181}, // Domat/Ems
    IBNR{8509182}, // Ems Werk
    IBNR{8509183}, // Reichenau-Tamins
    IBNR{8509184}, // Bonaduz
    IBNR{8509185}, // Rhäzüns
    IBNR{8509186}, // Rothenbrunnen
    IBNR{8509187}, // Rodels-Realta
    IBNR{8509188}, // Cazis
    IBNR{8509189}, // Thusis
    IBNR{8509191}, // Solis station
    IBNR{8509192}, // Tiefencastel
    IBNR{8509193}, // Surava
    IBNR{8509194}, // Alvaneu
    IBNR{8509195}, // Filisur
    IBNR{8509196}, // Stugl/Stuls station
    IBNR{8509197}, // Bergün/Bravuogn
    IBNR{8509198}, // Preda
    IBNR{8509199}, // Spinas
    IBNR{8509250}, // Bever
    IBNR{8509251}, // Samedan
    IBNR{8509252}, // Celerina
    IBNR{8509253}, // Sankt Moritz
    IBNR{8509254}, // Punt Muragl
    IBNR{8509255}, // Pontresina
    IBNR{8509256}, // La Punt-Chamues-ch
    IBNR{8509257}, // Madulain
    IBNR{8509258}, // Zuoz
    IBNR{8509259}, // S-chanf
    IBNR{8509260}, // Cinuos-chel-Brail station
    IBNR{8509261}, // Carolina station
    IBNR{8509262}, // Zernez station
    IBNR{8509263}, // Susch
    IBNR{8509264}, // Lavin
    IBNR{8509265}, // Guarda
    IBNR{8509266}, // Ardez
    IBNR{8509267}, // Ftan
    IBNR{8509268}, // Scuol-Tarasp
    IBNR{8509269}, // Sagliains
    IBNR{8509350}, // Celerina Staz
    IBNR{8509351}, // Punt Muragl Staz
    IBNR{8509352}, // Surovas
    IBNR{8509353}, // Morteratsch
    IBNR{8509354}, // Bernina Suot
    IBNR{8509356}, // Ospizio Bernina
    IBNR{8509357}, // Alp Grüm
    IBNR{8509358}, // Cavaglia
    IBNR{8509359}, // Cadera
    IBNR{8509360}, // Privilasco
    IBNR{8509361}, // Poschiavo
    IBNR{8509363}, // Li Curt
    IBNR{8509364}, // Le Prese
    IBNR{8509365}, // Miralago
    IBNR{8509366}, // Brusio
    IBNR{8509367}, // Campascio
    IBNR{8509368}, // Campocologno
    IBNR{8509369}, // Tirano RhB
    IBNR{8509373}, // Bernina Lagalb
    IBNR{8509400}, // Oberriet station
    IBNR{8509401}, // Q15964241
    IBNR{8509402}, // Salez-Sennwald train station
    IBNR{8509404}, // Buchs station
    IBNR{8509405}, // Q15964239
    IBNR{8509406}, // Sevelen Station
    IBNR{8509407}, // Q15964292
    IBNR{8509408}, // Q15964291
    IBNR{8509411}, // Sargans Station
    IBNR{8509412}, // Mels railway station
    IBNR{8509413}, // Q15964105
    IBNR{8509414}, // Q15964276
    IBNR{8509415}, // Q15964183
    IBNR{8509416}, // Unterterzen railway station
    IBNR{8509417}, // Murg station
    IBNR{8509418}, // Q15964181
    IBNR{8509419}, // Q15964274
    IBNR{8515296}, // Brig Bahnhofplatz railway station
    IBNR{8515778}, // Q3555972
    IBNR{8515992}, // Baar Neufeld Station
    IBNR{8515993}, // Q15964067
    IBNR{8515994}, // Q15964306
    IBNR{8515995}, // Cham Alpenblick train station
    IBNR{8515996}, // Q15964145
    IBNR{8515997}, // Q15964237
    IBNR{8516153}, // Niederbipp [Gleis 11-12] station
    IBNR{8516154}, // Bern Brünnen Westside station
    IBNR{8516155}, // Lancy-Pont-Rouge
    IBNR{8516161}, // Bern Wankdorf Station
    IBNR{8516174}, // Genève-Stade Station
    IBNR{8516176}, // Klingnau Station
    IBNR{8516177}, // Ins [Gleis 11] station
    IBNR{8516181}, // Solothurn [Gleis 21] station
    IBNR{8516187}, // Q15964303
    IBNR{8516218}, // Winterthur Hegi station
    IBNR{8516219}, // Mellingen Heitersberg railway station
    IBNR{8516270}, // Q15964073
    IBNR{8516271}, // Q15964266
    IBNR{8516274}, // Q3096243
    IBNR{8516283}, // Genève-Sécheron
    IBNR{8516350}, // Q15964096
    IBNR{8516351}, // Kriens Mattenhof railway station
    IBNR{8516353}, // Baldegg Kloster Station
    IBNR{8516354}, // Wolhusen Weid station
    IBNR{8516444}, // Q5846441
    IBNR{8516450}, // Unterkulm Nord station
    IBNR{8516764}, // Riehen
    IBNR{8516930}, // Rohr (Grindelwald) station
    IBNR{8517010}, // Riehen-Niederholz
    IBNR{8517112}, // Walchwil Hörndli station
    IBNR{8517131}, // Pratteln Salina Raurica station
    IBNR{8517336}, // Q801133
    IBNR{8517376}, // Dietikon Schöneggstrasse station
    IBNR{8517377}, // Bibenlos-Sonnenhof station
    IBNR{8517481}, // S-chanf Marathon station
    IBNR{8517484}, // Aigle-Parc Aventure station
    IBNR{8517485}, // Sur-le-Buis station
    IBNR{8517519}, // Stabio railway station
    IBNR{8517527}, // Q15964305
    IBNR{8518028}, // Genève Montbrillant station
    IBNR{8518100}, // St. Gallen Birnbäumen station
    IBNR{8518243}, // Beringerfeld station
    IBNR{8518452}, // Prilly-Malley halt
    IBNR{8518459}, // Steinhausen Rigiblick Station
    IBNR{8518475}, // Q17637381
    IBNR{8518663}, // Sengg (Verzw) station
    IBNR{8518664}, // In Gassen (Verzw) station
    IBNR{8518690}, // Niederbipp Industrie station
    IBNR{8518749}, // Lyss Grien Station
    IBNR{8518771}, // Biel/Bienne Bözingenfeld/Champs-de-Boujean Station
    IBNR{8518792}, // Oensingen [Gleis 7-8] station
    IBNR{8518924}, // Neuhausen Rheinfall Station
    IBNR{8518963}, // Solothurn Allmend Station
    IBNR{8519077}, // St-Cergue Les Cheseaux station
    IBNR{8519133}, // Fribourg/Freiburg Poya Station
    IBNR{8519370}, // Bernina Diavolezza
    IBNR{8530011}, // Les Coeudres-Est station
    IBNR{8530012}, // Petit-Martel-Est station
    IBNR{8530064}, // Bex Pont-Neuf station
    IBNR{8530066}, // Grand-Moulin station
    IBNR{8530067}, // Les Salines station
    IBNR{8530225}, // Le Stand station
    IBNR{8530246}, // Foyer Dents-du-Midi station
    IBNR{8530260}, // Q2412486
    IBNR{8530261}, // Bois-de-Chexbres station
    IBNR{8530262}, // Q16508242
    IBNR{8530263}, // Yverdon William Barbey station
    IBNR{8530303}, // Les Fumeaux station
    IBNR{8530334}, // La Médettaz station
    IBNR{8530335}, // Aigle-Hôpital station
    IBNR{8530355}, // Les Arnoux station
    IBNR{8530366}, // Pont du Rhône station
    IBNR{8530378}, // Les Neys station
    IBNR{8530430}, // Route de Morgins station
    IBNR{8530462}, // Q19545551
    IBNR{8530463}, // En Charnet station
    IBNR{8530523}, // La Ruaz station
    IBNR{8530612}, // Realp DFB station
    IBNR{8530613}, // Tiefenbach halting point
    IBNR{8530614}, // Furka railway station
    IBNR{8530708}, // Neuchâtel, Evole station
    IBNR{8530709}, // Neuchâtel, Champ-Bougin station
    IBNR{8530710}, // Neuchâtel, Serrières Ruau station
    IBNR{8530711}, // Colombier NE Allées Littorail station
    IBNR{8530712}, // Colombier NE, Les Chézards station
    IBNR{8530713}, // Boudry, Tuilière station
    IBNR{8530750}, // Biel/Bienne [Gleis 11/voie 11] station
    IBNR{8530760}, // Aareschlucht West station
    IBNR{8530783}, // Chez-le-Maître-Ecoles station
    IBNR{8530789}, // Bioggio Molinazzo railway station
    IBNR{8530790}, // Sorengo Laghetto railway station
    IBNR{8530799}, // Meiringen Alpbach station
    IBNR{8530800}, // Innertkirchen Unterwasser station
    IBNR{8530801}, // Aareschlucht Ost MIB station
    IBNR{8530811}, // Zürich Balgrist station
    IBNR{8530812}, // Zürich Hegibachplatz station
    IBNR{8530813}, // Zürich Kreuzplatz station
    IBNR{8530832}, // Pied du barrage station
    IBNR{8571576}, // Brünig-Hasliberg railway station
    IBNR{8587340}, // Lütisburg, Restaurant Bahnhof Station
    IBNR{8587727}, // Les Ripes halt
    IBNR{8588122}, // Landschlacht Station
    IBNR{8588193}, // Gryon Bois-Gentil station
    IBNR{8588943}, // Q3096099
    IBNR{8589198}, // Worbboden station
    IBNR{8591394}, // Zürich, Titlisstrasse station
    IBNR{8591421}, // Zürich, Waldhaus Dolder station
    IBNR{8591664}, // Q49456420
    IBNR{8592086}, // Ouchy station
    IBNR{8593467}, // Pont de Fayot station
    IBNR{8593772}, // Gryon-Chalméry station
    IBNR{8593773}, // Les Bovets station
    IBNR{8593774}, // La Faverge station
    IBNR{8593775}, // Les Nicolets station
    IBNR{8593776}, // Plan Morier station
    IBNR{8594231}, // Areuse Les Isles Littorail station
    IBNR{8594258}, // Langenthal Industrie Nord station
    IBNR{8595245}, // Areuse Littorail station
    IBNR{8601309}, // Copenhagen Central Station
    IBNR{8602254}, // Q801448
    IBNR{8613639}, // Fasanvej Station
    IBNR{8700001}, // Amiens railway station
    IBNR{8700003}, // Gare des Aubrais-Orléans
    IBNR{8700004}, // Dunkirk railway station
    IBNR{8700007}, // Douai railway station
    IBNR{8700008}, // Gare de Culmont-Chalindrey
    IBNR{8700009}, // Gare de Moirans
    IBNR{8700010}, // Gare d'Austerlitz
    IBNR{8700011}, // Gare de Paris-Est
    IBNR{8700012}, // Paris-Gare de Lyon
    IBNR{8700013}, // Gare Montparnasse
    IBNR{8700014}, // Gare du Nord
    IBNR{8700015}, // gare Saint-Lazare
    IBNR{8700016}, // Gare de Busigny
    IBNR{8700019}, // Gare de Metz-Ville
    IBNR{8700020}, // Nantes station
    IBNR{8700021}, // Gare de Dijon-Ville
    IBNR{8700022}, // Gare d'Angers-Saint-Laud
    IBNR{8700023}, // Gare de Strasbourg
    IBNR{8700025}, // Rennes railway station
    IBNR{8700026}, // Q2154970
    IBNR{8700029}, // Gare de Limoges-Bénédictins
    IBNR{8700030}, // Gare de Lille Flandres
    IBNR{8700031}, // Gare de Mulhouse
    IBNR{8700034}, // Grenoble railway station
    IBNR{8700035}, // Gare de Saincaize
    IBNR{8700036}, // Gare de Brive-la-Gaillarde
    IBNR{8700037}, // Gare de Bourg-en-Bresse
    IBNR{8700038}, // Gare de Clermont-Ferrand
    IBNR{8700039}, // Culoz
    IBNR{8700042}, // Gare de Bourges
    IBNR{8700043}, // Dax
    IBNR{8700044}, // Gare de Besançon-Viotte
    IBNR{8700047}, // Bordeaux-Saint-Jean railway station
    IBNR{8700049}, // Gare de Mouchard
    IBNR{8700051}, // Gare de Chaumont
    IBNR{8700052}, // Q2442991
    IBNR{8700057}, // Gare de Montauban-Ville-Bourbon
    IBNR{8700059}, // Thionville railway station
    IBNR{8700063}, // Gare d'Angoulême
    IBNR{8700065}, // Gare de Toulouse-Matabiau
    IBNR{8700066}, // Gare de Poitiers
    IBNR{8700067}, // Savenay
    IBNR{8700070}, // Q628887
    IBNR{8700072}, // Gare de Creil
    IBNR{8700073}, // Gare de Narbonne
    IBNR{8700076}, // Hazebrouck
    IBNR{8700077}, // Gare de Tergnier
    IBNR{8700078}, // Valenciennes railway station
    IBNR{8700080}, // Gare de Chartres
    IBNR{8700081}, // Gare de Reims
    IBNR{8700082}, // Gare de Vitry-le-François
    IBNR{8700083}, // Gare de Redon
    IBNR{8700084}, // La Baule-Escoublac train station
    IBNR{8700085}, // Gare de Dieppe
    IBNR{8700089}, // Q3095673
    IBNR{8700092}, // Q2577756
    IBNR{8700093}, // Q3097038
    IBNR{8700094}, // Gare de Roanne
    IBNR{8700095}, // Gare de Vienne
    IBNR{8700097}, // Montpellier-Saint-Roch railway station
    IBNR{8700098}, // Gare d'Ussel
    IBNR{8700100}, // Gare de Carcassonne
    IBNR{8700101}, // Q2669277
    IBNR{8700104}, // Gare de Tarbes
    IBNR{8700105}, // Gare de Lourdes
    IBNR{8700106}, // Gare de Pau
    IBNR{8700108}, // Gare de Toulon
    IBNR{8700112}, // Gare du Havre
    IBNR{8700114}, // Gare de Biarritz
    IBNR{8700115}, // Q2625770
    IBNR{8700116}, // Dole-Ville railway station
    IBNR{8700117}, // Gare de Montargis
    IBNR{8700118}, // Jeumont railway station
    IBNR{8700120}, // Q2578951
    IBNR{8700121}, // Tourcoing
    IBNR{8700124}, // Q2082423
    IBNR{8700127}, // Modane
    IBNR{8700128}, // Gare d'Albertville
    IBNR{8700131}, // Gare d'Annemasse
    IBNR{8700135}, // Gare d'Annecy
    IBNR{8700137}, // Bonneville
    IBNR{8700139}, // Gare d'Arles
    IBNR{8700141}, // Alençon railway station
    IBNR{8700144}, // Gare de Cannes
    IBNR{8700145}, // Gare d'Agde
    IBNR{8700146}, // Gare d'Antibes
    IBNR{8700147}, // Cerbère railway station
    IBNR{8700148}, // Gare de Latour-de-Carol-Enveitg
    IBNR{8700149}, // Gare d'Hendaye
    IBNR{8700150}, // Gare de Menton
    IBNR{8700151}, // Gare de Nîmes
    IBNR{8700152}, // Gare de Lyon-Part-Dieu
    IBNR{8700153}, // Q2786235
    IBNR{8700154}, // Gare de Genlis
    IBNR{8700157}, // Gare d'Aix-en-Provence
    IBNR{8700160}, // Q2386091
    IBNR{8700161}, // Tours railway station
    IBNR{8700162}, // Longwy railway station
    IBNR{8700163}, // Gare de Frasne
    IBNR{8700164}, // Perpignan railway station
    IBNR{8700166}, // Q3097072
    IBNR{8700172}, // Gare d'Avignon-Centre
    IBNR{8700174}, // Monaco-Monte Carlo railway station
    IBNR{8700178}, // Gare de Colmar
    IBNR{8700179}, // Sélestat
    IBNR{8700180}, // Gare de Cahors
    IBNR{8700181}, // Gare de Châteauroux
    IBNR{8700183}, // Gare de Mussidan
    IBNR{8700184}, // Gare de Coutras
    IBNR{8700185}, // Gare de Libourne
    IBNR{8700188}, // Gare de Longueau
    IBNR{8700189}, // Lons-le-Saunier railway station
    IBNR{8700190}, // Gare de Capdenac
    IBNR{8700191}, // Gare de Foix
    IBNR{8700192}, // Gare d'Ax-les-Thermes
    IBNR{8700194}, // Gare de Rodez
    IBNR{8700196}, // Morcenx
    IBNR{8700197}, // Gare d'Arcachon
    IBNR{8700200}, // Les Sables-d'Olonne
    IBNR{8700201}, // Gare de Niort
    IBNR{8700203}, // Gare de Rochefort
    IBNR{8700204}, // Gare de Tulle
    IBNR{8700205}, // Gare de Vannes
    IBNR{8700206}, // Gare d'Auray
    IBNR{8700207}, // Gare de Lorient
    IBNR{8700208}, // Gare de Quimper
    IBNR{8700209}, // Gare de Langon
    IBNR{8700213}, // Gare de Morlaix
    IBNR{8700214}, // Gare de Dreux
    IBNR{8700215}, // Gare d'Argentan
    IBNR{8700216}, // Gare de Briouze
    IBNR{8700217}, // Gare de Flers
    IBNR{8700218}, // Gare de Folligny
    IBNR{8700220}, // Serquigny
    IBNR{8700221}, // Gare de Bernay
    IBNR{8700222}, // Gare de Lisieux
    IBNR{8700223}, // Gare de Caen
    IBNR{8700224}, // Gare de Bayeux
    IBNR{8700225}, // Gare de Carentan
    IBNR{8700226}, // Gare de Valognes
    IBNR{8700227}, // Cherbourg railway station
    IBNR{8700229}, // Gare de Surdon
    IBNR{8700232}, // Coutances
    IBNR{8700233}, // Q2156841
    IBNR{8700234}, // Gare de Bréauté-Beuzeville
    IBNR{8700236}, // Gare de Roubaix
    IBNR{8700238}, // Gare d'Abbeville
    IBNR{8700241}, // Q2044263
    IBNR{8700242}, // Q2275121
    IBNR{8700247}, // Gare de Noyon
    IBNR{8700249}, // Gare de Maubeuge
    IBNR{8700251}, // Gare d'Abancourt
    IBNR{8700252}, // Q2385461
    IBNR{8700254}, // Gare du Creusot
    IBNR{8700257}, // Bayonne railway station
    IBNR{8700262}, // Q972791
    IBNR{8700263}, // Toul railway station
    IBNR{8700264}, // Q2186882
    IBNR{8700265}, // Q1968912
    IBNR{8700266}, // Gare de Saverne
    IBNR{8700272}, // Q2268586
    IBNR{8700273}, // Gare de Troyes
    IBNR{8700274}, // Gare de Romilly-sur-Seine
    IBNR{8700275}, // Gare de Longueville
    IBNR{8700276}, // Q1865759
    IBNR{8700278}, // Q2438613
    IBNR{8700279}, // Q1855889
    IBNR{8700281}, // Erstein
    IBNR{8700282}, // Q1888534
    IBNR{8700283}, // Q2859801
    IBNR{8700289}, // Q2383414
    IBNR{8700290}, // Gare de Barr
    IBNR{8700294}, // Brumath
    IBNR{8700299}, // Q2250995
    IBNR{8700305}, // Don-Sainghin
    IBNR{8700306}, // Gare de Granville
    IBNR{8700309}, // Ingwiller
    IBNR{8700312}, // Q3096656
    IBNR{8700315}, // Gare de L'Aigle
    IBNR{8700321}, // Q321927
    IBNR{8700326}, // Walbourg
    IBNR{8700327}, // Wingen-sur-Moder
    IBNR{8700328}, // Q2411757
    IBNR{8700330}, // Q3095947
    IBNR{8700335}, // Q2779510
    IBNR{8700345}, // Gare de Gardanne
    IBNR{8700347}, // Gare de Haguenau
    IBNR{8700350}, // Hayange railway station
    IBNR{8700352}, // Gare de Juvisy
    IBNR{8700353}, // Gare de Lauterbourg
    IBNR{8700362}, // Miramas Station
    IBNR{8700366}, // Q2532824
    IBNR{8700367}, // Q3097296
    IBNR{8700377}, // Uckange railway station
    IBNR{8700382}, // Wissembourg
    IBNR{8700383}, // Q3098088
    IBNR{8700385}, // Gare de Vesoul
    IBNR{8700386}, // Calais-Ville railway station
    IBNR{8700394}, // Gare de Molsheim
    IBNR{8700395}, // Mommenheim
    IBNR{8700399}, // Gare de Nevers
    IBNR{8700400}, // Obermodern
    IBNR{8700401}, // Q2092112
    IBNR{8700402}, // Oissel
    IBNR{8700404}, // Gare d'Orléans
    IBNR{8700405}, // Gare de Périgueux
    IBNR{8700406}, // Pontarlier
    IBNR{8700415}, // Q3097445
    IBNR{8700418}, // Gare de Saintes
    IBNR{8700420}, // Q2191151
    IBNR{8700424}, // Gare de Vire
    IBNR{8700425}, // gare de Voiron
    IBNR{8700428}, // Q3095997
    IBNR{8700429}, // Gare de Dijon-Porte-Neuve
    IBNR{8700434}, // Brest railway station
    IBNR{8700435}, // Gare du Mans
    IBNR{8700439}, // Gare de Sarreguemines
    IBNR{8700440}, // Rumilly
    IBNR{8700444}, // Q2783838
    IBNR{8700450}, // Boulogne-Ville railway station
    IBNR{8700453}, // Gare de Landerneau
    IBNR{8700455}, // Q430790
    IBNR{8700458}, // Seyssel - Corbonod
    IBNR{8700465}, // Gare de Peyrehorade
    IBNR{8700469}, // Q3095794
    IBNR{8700472}, // Gare de Fréjus
    IBNR{8700473}, // Gare de Muret
    IBNR{8700474}, // Boussens train station
    IBNR{8700475}, // Gare de Lannemezan
    IBNR{8700478}, // Gare d'Orthez
    IBNR{8700480}, // Gare de Cagnes-sur-Mer
    IBNR{8700485}, // Banyuls-sur-Mer railway station
    IBNR{8700486}, // Q2315101
    IBNR{8700487}, // Gare d'Argelès-sur-Mer
    IBNR{8700489}, // Rivesaltes
    IBNR{8700490}, // Port-la-Nouvelle
    IBNR{8700492}, // Marignier
    IBNR{8700493}, // Gare de Pamiers
    IBNR{8700497}, // Gare de Souillac
    IBNR{8700498}, // Gare de Saverdun
    IBNR{8700500}, // Gare de Rosporden
    IBNR{8700507}, // Q2743849
    IBNR{8700512}, // Croix - Wasquehal
    IBNR{8700522}, // Givet railway station
    IBNR{8700530}, // gare de Bitche
    IBNR{8700537}, // Gare de Gourdon
    IBNR{8700538}, // Gare de Guingamp
    IBNR{8700540}, // Gare de Melun
    IBNR{8700541}, // Gare de Metzeral
    IBNR{8700547}, // Gare de Thonon-les-Bains
    IBNR{8700549}, // Gare de Castelnaudary
    IBNR{8700557}, // Q800601
    IBNR{8700564}, // Gare de Mulhouse-Dornach
    IBNR{8700565}, // Q3095689
    IBNR{8700569}, // Q2116916
    IBNR{8700575}, // Q3095628
    IBNR{8700581}, // Q2401925
    IBNR{8700598}, // Gare d'Allassac
    IBNR{8700629}, // Gare d'Artenay
    IBNR{8700634}, // Gare d'Ailly-sur-Somme
    IBNR{8700656}, // Q1947085
    IBNR{8700678}, // Gare de Boucau
    IBNR{8700699}, // Q3096003
    IBNR{8700729}, // Gare de Lorraine TGV
    IBNR{8700755}, // Gare de Bayon
    IBNR{8700757}, // Gare de Boisseaux
    IBNR{8700783}, // Q3095992
    IBNR{8700785}, // Gare de Bogny-sur-Meuse
    IBNR{8700804}, // Q2110347
    IBNR{8700820}, // Gare de Chantilly-Gouvieux
    IBNR{8700842}, // Cambrai-Ville railway station
    IBNR{8700890}, // Coudekerque-Branche
    IBNR{8700910}, // Clisson
    IBNR{8700917}, // Q289445
    IBNR{8700919}, // Gare de Coarraze-Nay
    IBNR{8700923}, // Q3096265
    IBNR{8700924}, // Gare de Colmar-Saint-Joseph
    IBNR{8700960}, // Q2140129
    IBNR{8700994}, // Q3096321
    IBNR{8701003}, // Q3096382
    IBNR{8701021}, // Q3096390
    IBNR{8701044}, // Q2262411
    IBNR{8701045}, // Q1922941
    IBNR{8701047}, // Gare de Duppigheim
    IBNR{8701050}, // Q3096359
    IBNR{8701054}, // Gare d'Ebersheim
    IBNR{8701064}, // Gare d'Elne
    IBNR{8701065}, // Q1946266
    IBNR{8701081}, // gare d'Estressin
    IBNR{8701096}, // Q2727830
    IBNR{8701099}, // Entzheim-Aéroport Station
    IBNR{8701112}, // Q2142149
    IBNR{8701121}, // Q3096505
    IBNR{8701130}, // Fegersheim - Lipsheim
    IBNR{8701132}, // Gare de Calais-Fréthun
    IBNR{8701164}, // Frontignan
    IBNR{8701167}, // Gare de Fumay
    IBNR{8701168}, // Q3096497
    IBNR{8701178}, // Q3096599
    IBNR{8701186}, // Geispolsheim
    IBNR{8701209}, // Graffenstaden railway station
    IBNR{8701213}, // Gare de Grande-Synthe
    IBNR{8701215}, // Gare de Grandvilliers
    IBNR{8701231}, // Gravelines
    IBNR{8701232}, // Q761462
    IBNR{8701234}, // Q3096559
    IBNR{8701236}, // Hœrdt
    IBNR{8701243}, // Gare de Haybes
    IBNR{8701249}, // Q3095770
    IBNR{8701251}, // Gare d'Hennebont
    IBNR{8701255}, // Q2700531
    IBNR{8701259}, // Q3096635
    IBNR{8701260}, // Q2198911
    IBNR{8701262}, // Q3095768
    IBNR{8701265}, // Q1810354
    IBNR{8701274}, // Gare de Mulhouse-Hasenrain
    IBNR{8701280}, // Q2707075
    IBNR{8701291}, // Tenay - Hauteville
    IBNR{8701299}, // Q3095780
    IBNR{8701302}, // Q3095790
    IBNR{8701303}, // Q2616463
    IBNR{8701304}, // Q2222548
    IBNR{8701327}, // Q3096655
    IBNR{8701335}, // Q3096706
    IBNR{8701340}, // Gare de Kogenheim
    IBNR{8701361}, // Labenne
    IBNR{8701374}, // Gare de Laifour
    IBNR{8701385}, // Q2497752
    IBNR{8701394}, // Q2116031
    IBNR{8701400}, // Limersheim
    IBNR{8701404}, // Q2563655
    IBNR{8701413}, // Gare de Lamballe
    IBNR{8701442}, // Q2462836
    IBNR{8701458}, // Q3096918
    IBNR{8701466}, // Gare de Lyon-Vaise
    IBNR{8701469}, // Q3096846
    IBNR{8701470}, // Laval railway station
    IBNR{8701479}, // Machilly
    IBNR{8701497}, // Mundolsheim
    IBNR{8701512}, // Q3097027
    IBNR{8701513}, // Q1848535
    IBNR{8701535}, // Gare de Montereau
    IBNR{8701543}, // Q3097119
    IBNR{8701558}, // Gare de Montbard
    IBNR{8701563}, // Q2483118
    IBNR{8701598}, // Gare de Marseille-en-Beauvaisis
    IBNR{8701599}, // Q1931469
    IBNR{8701607}, // Gare de Massy TGV
    IBNR{8701612}, // Gare de Monthermé
    IBNR{8701613}, // Gare de Masseret
    IBNR{8701622}, // Matzenheim
    IBNR{8701623}, // Muhlbach-sur-Munster station
    IBNR{8701641}, // Gare de Meymac
    IBNR{8701643}, // Gare de Moret-Veneux-les-Sablons
    IBNR{8701650}, // Q3096957
    IBNR{8701661}, // Gare de Neau
    IBNR{8701681}, // Q3097192
    IBNR{8701687}, // Gare de Niversac
    IBNR{8701689}, // Q3097227
    IBNR{8701691}, // Q2424780
    IBNR{8701701}, // Q2687707
    IBNR{8701716}, // Ondres
    IBNR{8701726}, // Q926219
    IBNR{8701734}, // Le Pallet
    IBNR{8701753}, // Q2678036
    IBNR{8701760}, // Gare de Picquigny
    IBNR{8701764}, // Q1873503
    IBNR{8701779}, // Q2412350
    IBNR{8701797}, // Perrignier
    IBNR{8701799}, // Pornichet train station
    IBNR{8701806}, // Q3097240
    IBNR{8701818}, // Gare de Pontanevaux
    IBNR{8701820}, // Le Pouliguen train station
    IBNR{8701823}, // Q1938345
    IBNR{8701826}, // Q1926670
    IBNR{8701827}, // Q1895691
    IBNR{8701838}, // Q589290
    IBNR{8701846}, // Gare de Riom - Châtel-Guyon
    IBNR{8701879}, // Q2586908
    IBNR{8701882}, // Q3097401
    IBNR{8701900}, // Riedseltz
    IBNR{8701902}, // Gare de Ruffec
    IBNR{8701910}, // Rixheim station
    IBNR{8701935}, // Q2661330
    IBNR{8701994}, // Q2666389
    IBNR{8702002}, // Q2747695
    IBNR{8702010}, // Q2051806
    IBNR{8702060}, // Gare de Sierentz
    IBNR{8702089}, // Gare de Turckheim
    IBNR{8702095}, // Q653961
    IBNR{8702098}, // Q1810836
    IBNR{8702104}, // Gare de Thiviers
    IBNR{8702106}, // Q2691990
    IBNR{8702116}, // Q3097896
    IBNR{8702129}, // Gare de Terrasson
    IBNR{8702130}, // La Teste
    IBNR{8702144}, // Gare d'Urt
    IBNR{8702147}, // Gare d'Uzerche
    IBNR{8702148}, // Vendenheim
    IBNR{8702160}, // Q2482640
    IBNR{8702174}, // Q3097932
    IBNR{8702178}, // Gare de Vigeois
    IBNR{8702196}, // Q2022973
    IBNR{8702234}, // Gare de Vitry-en-Artois
    IBNR{8702238}, // Gare de Vertou
    IBNR{8702243}, // Q3095609
    IBNR{8702252}, // Valleiry
    IBNR{8702260}, // Q305421
    IBNR{8702261}, // Q128074
    IBNR{8702297}, // Gare de Zillisheim
    IBNR{8702299}, // Q2727028
    IBNR{8702310}, // Q2379431
    IBNR{8702315}, // Q2277923
    IBNR{8702325}, // Gare de Salbris
    IBNR{8702337}, // Q2448097
    IBNR{8702344}, // Q1971525
    IBNR{8702345}, // Royan
    IBNR{8702346}, // Saujon
    IBNR{8702347}, // Q3097993
    IBNR{8702385}, // Aiguebelle
    IBNR{8702395}, // Chamousset
    IBNR{8702397}, // Q2801473
    IBNR{8702402}, // Frontenex
    IBNR{8702405}, // Jonzac
    IBNR{8702427}, // Vions - Chanaz
    IBNR{8702428}, // Viviers-du-Lac
    IBNR{8702436}, // Gorges
    IBNR{8702443}, // Montendre
    IBNR{8702451}, // Gare de Voreppe
    IBNR{8702455}, // Gare de Bercy
    IBNR{8702463}, // Q2314163
    IBNR{8702466}, // Q642288
    IBNR{8702467}, // Aiguebelette-le-Lac
    IBNR{8702476}, // Gare de Bram
    IBNR{8702479}, // Q2752803
    IBNR{8702481}, // Q1958669
    IBNR{8702494}, // Q3096225
    IBNR{8702495}, // Q1998901
    IBNR{8702506}, // Q1969231
    IBNR{8702514}, // Gare du Grand-Lemps
    IBNR{8702518}, // Gare de L'Isle-d'Abeau
    IBNR{8702521}, // Q2404429
    IBNR{8702522}, // Gare de Die
    IBNR{8702527}, // Q3096917
    IBNR{8702546}, // Q3097047
    IBNR{8702558}, // Gare de Pont-de-Beauvoisin
    IBNR{8702576}, // Gare de Rives
    IBNR{8702587}, // Gare de La-Valbonne
    IBNR{8702599}, // Q3097188
    IBNR{8702637}, // Albens
    IBNR{8702638}, // Gare d'Albi-Madeleine
    IBNR{8702654}, // Gare d'Amplepuis
    IBNR{8702699}, // Gare d'Assier
    IBNR{8702710}, // Gare d'Aubin
    IBNR{8702713}, // Q2200917
    IBNR{8702722}, // Q3095697
    IBNR{8702724}, // Gare d'Aurillac
    IBNR{8702725}, // Gare d'Auterive
    IBNR{8702732}, // Q3095705
    IBNR{8702743}, // Avranches
    IBNR{8702761}, // Q2583133
    IBNR{8702800}, // Q2898331
    IBNR{8702816}, // Gare de Bergerac
    IBNR{8702820}, // Q2356506
    IBNR{8702823}, // Q3095977
    IBNR{8702869}, // Gare de Bonson
    IBNR{8702908}, // Gare de Breil-sur-Roya
    IBNR{8702920}, // Gare de Briare
    IBNR{8702923}, // Q3096066
    IBNR{8702924}, // Brignoud
    IBNR{8702928}, // Q3096071
    IBNR{8702936}, // Bueil
    IBNR{8702976}, // Gare de Carmaux
    IBNR{8702984}, // Gare de Castres
    IBNR{8703015}, // Gare de Challans
    IBNR{8703016}, // Q3096169
    IBNR{8703043}, // Q3096190
    IBNR{8703085}, // Gare de Chelles-Gournay
    IBNR{8703093}, // Gare de Chessy
    IBNR{8703103}, // Gare de Cholet
    IBNR{8703134}, // Gare de Colomiers
    IBNR{8703142}, // Q2623394
    IBNR{8703182}, // Gare de Cransac
    IBNR{8703199}, // Q3096346
    IBNR{8703205}, // Q3096352
    IBNR{8703230}, // Gare de Dommartin - Lissieu
    IBNR{8703238}, // Q16964672
    IBNR{8703313}, // Q3096431
    IBNR{8703314}, // Gare de Figeac
    IBNR{8703317}, // Gare de Firminy
    IBNR{8703343}, // Gare de Fourchambault
    IBNR{8703348}, // Q1852144
    IBNR{8703362}, // Gare de Gaillac
    IBNR{8703395}, // Gare de Gien
    IBNR{8703403}, // Q3096539
    IBNR{8703404}, // Q3096543
    IBNR{8703409}, // Q2936724
    IBNR{8703414}, // Goncelin
    IBNR{8703423}, // Gare de Gragnague
    IBNR{8703425}, // Gare de Gramat
    IBNR{8703484}, // Q3095800
    IBNR{8703509}, // Q405631
    IBNR{8703527}, // Gare de l'Arbresle
    IBNR{8703543}, // La Borne Blanche
    IBNR{8703555}, // Gare de La Charité
    IBNR{8703573}, // Q3096780
    IBNR{8703598}, // Q3096803
    IBNR{8703640}, // Lancey
    IBNR{8703643}, // Q3096847
    IBNR{8703645}, // Q1935573
    IBNR{8703647}, // Gare de Lannion
    IBNR{8703674}, // Gare de Laval-de-Cère
    IBNR{8703677}, // Q3096865
    IBNR{8703681}, // Q3096866
    IBNR{8703702}, // Gare du Coteau
    IBNR{8703709}, // Gare du Havre-Graville
    IBNR{8703726}, // Gare du Futuroscope
    IBNR{8703739}, // Q2052258
    IBNR{8703745}, // Le Vert de Maisons
    IBNR{8703752}, // Q3096871
    IBNR{8703759}, // Gare des Cabannes
    IBNR{8703797}, // Q1921700
    IBNR{8703846}, // Q677672
    IBNR{8703852}, // Gare de Luchon
    IBNR{8703867}, // Gare de Luzarches
    IBNR{8703871}, // Gare de Lyon-Gorge-de-Loup
    IBNR{8703875}, // Gare de Magalas
    IBNR{8703876}, // Q3096951
    IBNR{8703901}, // Mantes-Station
    IBNR{8703918}, // Gare de Marmande
    IBNR{8703932}, // Q3096989
    IBNR{8703996}, // Q3097042
    IBNR{8704001}, // Q3097052
    IBNR{8704015}, // Mont-de-Marsan
    IBNR{8704024}, // Q2217344
    IBNR{8704072}, // Gare de Murat
    IBNR{8704075}, // Q2377439
    IBNR{8704138}, // Gare de Nurieux
    IBNR{8704163}, // Gare d'Oullins
    IBNR{8704166}, // Gare d'Oyonnax
    IBNR{8704201}, // Gare de Périgueux-Saint-Georges
    IBNR{8704205}, // Q2557517
    IBNR{8704214}, // Q2227003
    IBNR{8704262}, // Q3097303
    IBNR{8704277}, // Rennes-Pontchaillou
    IBNR{8704302}, // Gare de Pouilly-sur-Loire
    IBNR{8704345}, // Gare de Ranguin
    IBNR{8704352}, // Reignier
    IBNR{8704361}, // Q3097397
    IBNR{8704370}, // Q14918105
    IBNR{8704377}, // Aéroport Charles de Gaulle 1
    IBNR{8704385}, // Q1925026
    IBNR{8704500}, // Q3097749
    IBNR{8704694}, // Q3097836
    IBNR{8704695}, // Q3097842
    IBNR{8704709}, // Gare de Thenon
    IBNR{8704735}, // Q3097889
    IBNR{8704738}, // Gare de Tracy-Sancerre
    IBNR{8704747}, // Gare de Trouville-Deauville
    IBNR{8704750}, // Q3097910
    IBNR{8704768}, // Gare de Valence-d'Agen
    IBNR{8704804}, // Q2563981
    IBNR{8704816}, // Versailles-Château
    IBNR{8704819}, // Gare de Vertaizon
    IBNR{8704854}, // Q3097995
    IBNR{8704882}, // Q3098014
    IBNR{8704897}, // Vitry-sur-Seine
    IBNR{8704918}, // Gare d'Avignon TGV
    IBNR{8704941}, // Q3097195
    IBNR{8704948}, // Gare de Marne-la-Vallée – Chessy
    IBNR{8704949}, // Lille-Europe railway station
    IBNR{8704957}, // TGV Haute-Picardie railway station
    IBNR{8704980}, // Aix-en-Provence TGV railway station
    IBNR{8704997}, // Aéroport Charles de Gaulle 2 TGV
    IBNR{8705051}, // Q16964682
    IBNR{8705093}, // Q3096140
    IBNR{8705328}, // Gare des Ramassiers
    IBNR{8705331}, // Station of TOEC
    IBNR{8705345}, // Q3097135
    IBNR{8705360}, // Gare de Mouans-Sartoux
    IBNR{8705486}, // Gare de Grasse
    IBNR{8705612}, // Q2489577
    IBNR{8705754}, // Cenon station
    IBNR{8705764}, // Gray Gare Routière
    IBNR{8705947}, // Q3095927
    IBNR{8706227}, // Picon-Busserine
    IBNR{8706450}, // Gare de Lyon-Jean Macé
    IBNR{8706479}, // Gare du Bosquet
    IBNR{8706480}, // Gare de La Frayère
    IBNR{8714732}, // Gare de Meuse TGV
    IBNR{8718562}, // Q2441064
    IBNR{8718791}, // Basel SNCF railway station
    IBNR{8730082}, // Gare de Belfort – Montbéliard TGV
    IBNR{8730086}, // Gare de Besançon Franche-Comté TGV
    IBNR{8796004}, // Calais-Ville railway station
    IBNR{8796005}, // Gare d'Avignon TGV
    IBNR{8796006}, // Gare de Champagne-Ardenne TGV
    IBNR{8800001}, // Schaarbeek railway station
    IBNR{8800002}, // Brussels-North railway station
    IBNR{8800003}, // Brussels-Central railway station
    IBNR{8800004}, // Brussels-South railway station
    IBNR{8800005}, // Brussels-Luxembourg railway station
    IBNR{8800006}, // Halle railway station
    IBNR{8800007}, // Antwerp-Central railway station
    IBNR{8800008}, // Antwerp-Berchem railway station
    IBNR{8800009}, // Essen railway station
    IBNR{8800010}, // Mechelen railway station
    IBNR{8800011}, // Leuven railway station
    IBNR{8800012}, // Liège-Guillemins railway station
    IBNR{8800013}, // Ans railway station
    IBNR{8800014}, // Rivage railway station
    IBNR{8800015}, // Flémalle-Haute railway station
    IBNR{8800016}, // Verviers-Central railway station
    IBNR{8800017}, // Welkenraedt railway station
    IBNR{8800018}, // Namur railway station
    IBNR{8800019}, // Andenne railway station
    IBNR{8800020}, // Jemelle railway station
    IBNR{8800021}, // Libramont railway station
    IBNR{8800022}, // Arlon railway station
    IBNR{8800023}, // Erquelinnes railway station
    IBNR{8800024}, // Charleroi-South railway station
    IBNR{8800025}, // Mons railway station
    IBNR{8800026}, // Quévy railway station
    IBNR{8800027}, // Enghien railway station
    IBNR{8800028}, // Leuze railway station
    IBNR{8800029}, // Brugge rai