/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002      Heiko Nardmann  <h.nardmann@secunet.de>       *
 *   copyright (C) 2003-2014                                               *
 *   Umbrello UML Modeller Authors <umbrello-devel@kde.org>                *
 ***************************************************************************/

#include "phpwriter.h"

#include "association.h"
#include "attribute.h"
#include "classifier.h"
#include "debug_utils.h"
#include "operation.h"
#include "umldoc.h"

#include <QRegExp>
#include <QTextStream>

static const char *reserved_words[] = {
    "abs",
    "acos",
    "acosh",
    "add",
    "addAction",
    "addColor",
    "addcslashes",
    "addEntry",
    "addFill",
    "add_namespace",
    "addShape",
    "addslashes",
    "addstring",
    "addString",
    "aggregate",
    "aggregate_info",
    "aggregate_methods",
    "aggregate_methods_by_list",
    "aggregate_methods_by_regexp",
    "aggregate_properties",
    "aggregate_properties_by_list",
    "aggregate_properties_by_regexp",
    "aggregation_info",
    "align",
    "apache_child_terminate",
    "apache_lookup_uri",
    "apache_note",
    "apache_request_headers",
    "apache_response_headers",
    "apache_setenv",
    "append_child",
    "append_sibling",
    "array",
    "array_change_key_case",
    "array_chunk",
    "array_count_values",
    "array_diff",
    "array_diff_assoc",
    "array_fill",
    "array_filter",
    "array_flip",
    "array_intersect",
    "array_intersect_assoc",
    "array_key_exists",
    "array_keys",
    "array_map",
    "array_merge",
    "array_merge_recursive",
    "array_multisort",
    "array_pad",
    "array_pop",
    "array_push",
    "array_rand",
    "array_reduce",
    "array_reverse",
    "array_search",
    "array_shift",
    "array_slice",
    "array_splice",
    "array_sum",
    "array_unique",
    "array_unshift",
    "array_values",
    "array_walk",
    "arsort",
    "ascii2ebcdic",
    "asin",
    "asinh",
    "asort",
    "aspell_check",
    "aspell_new",
    "aspell_suggest",
    "assert",
    "assert_options",
    "assign",
    "atan",
    "atan2",
    "atanh",
    "attreditable",
    "attributes",
    "base64_decode",
    "base64_encode",
    "base_convert",
    "basename",
    "bcadd",
    "bccomp",
    "bcdiv",
    "bcmod",
    "bcmul",
    "bcpow",
    "bcpowmod",
    "bcscale",
    "bcsqrt",
    "bcsub",
    "bin2hex",
    "bindec",
    "bindtextdomain",
    "bind_textdomain_codeset",
    "bool",
    "break",
    "bzclose",
    "bzcompress",
    "bzdecompress",
    "bzerrno",
    "bzerror",
    "bzerrstr",
    "bzflush",
    "bzopen",
    "bzread",
    "bzwrite",
    "cal_days_in_month",
    "cal_from_jd",
    "cal_info",
    "call_user_func",
    "call_user_func_array",
    "call_user_method",
    "call_user_method_array",
    "cal_to_jd",
    "ccvs_add",
    "ccvs_auth",
    "ccvs_command",
    "ccvs_count",
    "ccvs_delete",
    "ccvs_done",
    "ccvs_init",
    "ccvs_lookup",
    "ccvs_new",
    "ccvs_report",
    "ccvs_return",
    "ccvs_reverse",
    "ccvs_sale",
    "ccvs_status",
    "ccvs_textvalue",
    "ccvs_void",
    "ceil",
    "chdir",
    "checkdate",
    "checkdnsrr",
    "checkin",
    "checkout",
    "chgrp",
    "child_nodes",
    "children",
    "chmod",
    "chop",
    "chown",
    "chr",
    "chroot",
    "chunk_split",
    "class",
    "class_exists",
    "clearstatcache",
    "clone_node",
    "closedir",
    "closelog",
    "com_addref",
    "com_get",
    "com_invoke",
    "com_isenum",
    "com_load",
    "com_load_typelib",
    "compact",
    "com_propget",
    "com_propput",
    "com_propset",
    "com_release",
    "com_set",
    "connection_aborted",
    "connection_status",
    "connection_timeout",
    "constant",
    "content",
    "continue",
    "convert_cyr_string",
    "_COOKIE",
    "copy",
    "cos",
    "cosh",
    "count",
    "count_chars",
    "cpdf_add_annotation",
    "cpdf_add_outline",
    "cpdf_arc",
    "cpdf_begin_text",
    "cpdf_circle",
    "cpdf_clip",
    "cpdf_close",
    "cpdf_closepath",
    "cpdf_closepath_fill_stroke",
    "cpdf_closepath_stroke",
    "cpdf_continue_text",
    "cpdf_curveto",
    "cpdf_end_text",
    "cpdf_fill",
    "cpdf_fill_stroke",
    "cpdf_finalize",
    "cpdf_finalize_page",
    "cpdf_global_set_document_limits",
    "cpdf_import_jpeg",
    "cpdf_lineto",
    "cpdf_moveto",
    "cpdf_newpath",
    "cpdf_open",
    "cpdf_output_buffer",
    "cpdf_page_init",
    "cpdf_place_inline_image",
    "cpdf_rect",
    "cpdf_restore",
    "cpdf_rlineto",
    "cpdf_rmoveto",
    "cpdf_rotate",
    "cpdf_rotate_text",
    "cpdf_save",
    "cpdf_save_to_file",
    "cpdf_scale",
    "cpdf_set_action_url",
    "cpdf_set_char_spacing",
    "cpdf_set_creator",
    "cpdf_set_current_page",
    "cpdf_setdash",
    "cpdf_setflat",
    "cpdf_set_font",
    "cpdf_set_font_directories",
    "cpdf_set_font_map_file",
    "cpdf_setgray",
    "cpdf_setgray_fill",
    "cpdf_setgray_stroke",
    "cpdf_set_horiz_scaling",
    "cpdf_set_keywords",
    "cpdf_set_leading",
    "cpdf_setlinecap",
    "cpdf_setlinejoin",
    "cpdf_setlinewidth",
    "cpdf_setmiterlimit",
    "cpdf_set_page_animation",
    "cpdf_setrgbcolor",
    "cpdf_setrgbcolor_fill",
    "cpdf_setrgbcolor_stroke",
    "cpdf_set_subject",
    "cpdf_set_text_matrix",
    "cpdf_set_text_pos",
    "cpdf_set_text_rendering",
    "cpdf_set_text_rise",
    "cpdf_set_title",
    "cpdf_set_viewer_preferences",
    "cpdf_set_word_spacing",
    "cpdf_show",
    "cpdf_show_xy",
    "cpdf_stringwidth",
    "cpdf_stroke",
    "cpdf_text",
    "cpdf_translate",
    "crack_check",
    "crack_closedict",
    "crack_getlastmessage",
    "crack_opendict",
    "crc32",
    "create_attribute",
    "create_cdata_section",
    "create_comment",
    "create_element",
    "create_element_ns",
    "create_entity_reference",
    "create_function",
    "create_processing_instruction",
    "create_text_node",
    "crypt",
    "ctype_alnum",
    "ctype_alpha",
    "ctype_cntrl",
    "ctype_digit",
    "ctype_graph",
    "ctype_lower",
    "ctype_print",
    "ctype_punct",
    "ctype_space",
    "ctype_upper",
    "ctype_xdigit",
    "curl_close",
    "curl_errno",
    "curl_error",
    "curl_exec",
    "curl_getinfo",
    "curl_init",
    "curl_setopt",
    "curl_version",
    "current",
    "cybercash_base64_decode",
    "cybercash_base64_encode",
    "cybercash_decr",
    "cybercash_encr",
    "cybermut_creerformulairecm",
    "cybermut_creerreponsecm",
    "cybermut_testmac",
    "cyrus_authenticate",
    "cyrus_bind",
    "cyrus_close",
    "cyrus_connect",
    "cyrus_query",
    "cyrus_unbind",
    "data",
    "date",
    "dba_close",
    "dba_delete",
    "dba_exists",
    "dba_fetch",
    "dba_firstkey",
    "dba_handlers",
    "dba_insert",
    "dba_list",
    "dba_nextkey",
    "dba_open",
    "dba_optimize",
    "dba_popen",
    "dba_replace",
    "dbase_add_record",
    "dbase_close",
    "dbase_create",
    "dbase_delete_record",
    "dbase_get_record",
    "dbase_get_record_with_names",
    "dbase_numfields",
    "dbase_numrecords",
    "dbase_open",
    "dbase_pack",
    "dbase_replace_record",
    "dba_sync",
    "dblist",
    "dbmclose",
    "dbmdelete",
    "dbmexists",
    "dbmfetch",
    "dbmfirstkey",
    "dbminsert",
    "dbmnextkey",
    "dbmopen",
    "dbmreplace",
    "dbplus_add",
    "dbplus_aql",
    "dbplus_chdir",
    "dbplus_close",
    "dbplus_curr",
    "dbplus_errcode",
    "dbplus_errno",
    "dbplus_find",
    "dbplus_first",
    "dbplus_flush",
    "dbplus_freealllocks",
    "dbplus_freelock",
    "dbplus_freerlocks",
    "dbplus_getlock",
    "dbplus_getunique",
    "dbplus_info",
    "dbplus_last",
    "dbplus_lockrel",
    "dbplus_next",
    "dbplus_open",
    "dbplus_prev",
    "dbplus_rchperm",
    "dbplus_rcreate",
    "dbplus_rcrtexact",
    "dbplus_rcrtlike",
    "dbplus_resolve",
    "dbplus_restorepos",
    "dbplus_rkeys",
    "dbplus_ropen",
    "dbplus_rquery",
    "dbplus_rrename",
    "dbplus_rsecindex",
    "dbplus_runlink",
    "dbplus_rzap",
    "dbplus_savepos",
    "dbplus_setindex",
    "dbplus_setindexbynumber",
    "dbplus_sql",
    "dbplus_tcl",
    "dbplus_tremove",
    "dbplus_undo",
    "dbplus_undoprepare",
    "dbplus_unlockrel",
    "dbplus_unselect",
    "dbplus_update",
    "dbplus_xlockrel",
    "dbplus_xunlockrel",
    "dbstat",
    "dbx_close",
    "dbx_compare",
    "dbx_connect",
    "dbx_error",
    "dbx_escape_string",
    "dbx_query",
    "dbx_sort",
    "dcgettext",
    "dcngettext",
    "dcstat",
    "deaggregate",
    "debug_backtrace",
    "debugger_off",
    "debugger_on",
    "decbin",
    "dechex",
    "declare",
    "decoct",
    "DEFAULT_INCLUDE_PATH",
    "define",
    "defined",
    "define_syslog_variables",
    "deg2rad",
    "delete",
    "description",
    "dgettext",
    "die",
    "dio_close",
    "dio_fcntl",
    "dio_open",
    "dio_read",
    "dio_seek",
    "dio_stat",
    "dio_tcsetattr",
    "dio_truncate",
    "dio_write",
    "dir",
    "dirname",
    "disk_free_space",
    "diskfreespace",
    "disk_total_space",
    "dl",
    "dngettext",
    "dns_check_record",
    "dns_get_mx",
    "dns_get_record",
    "do",
    "doctype",
    "document_element",
    "DOCUMENT_ROOT",
    "domxml_new_doc",
    "domxml_open_file",
    "domxml_open_mem",
    "domxml_version",
    "domxml_xmltree",
    "domxml_xslt_stylesheet",
    "domxml_xslt_stylesheet_doc",
    "domxml_xslt_stylesheet_file",
    "dotnet_load",
    "doubleval",
    "drawCurve",
    "drawCurveTo",
    "drawLine",
    "drawLineTo",
    "dstanchors",
    "dstofsrcanchors",
    "dump_file",
    "dump_mem",
    "dump_node",
    "each",
    "E_ALL",
    "easter_date",
    "easter_days",
    "ebcdic2ascii",
    "echo",
    "E_COMPILE_ERROR",
    "E_COMPILE_WARNING",
    "E_CORE_ERROR",
    "E_CORE_WARNING",
    "E_ERROR",
    "else",
    "elseif",
    "empty",
    "end",
    "endfor",
    "endforeach",
    "endif",
    "endswitch",
    "endwhile",
    "E_NOTICE",
    "entities",
    "_ENV",
    "E_PARSE",
    "ereg",
    "eregi",
    "eregi_replace",
    "ereg_replace",
    "error_log",
    "error_reporting",
    "escapeshellarg",
    "escapeshellcmd",
    "E_USER_ERROR",
    "E_USER_NOTICE",
    "E_USER_WARNING",
    "eval",
    "E_WARNING",
    "exec",
    "exif_imagetype",
    "exif_read_data",
    "exif_thumbnail",
    "exit",
    "exp",
    "explode",
    "expm1",
    "extension_loaded",
    "extract",
    "ezmlm_hash",
    "FALSE",
    "fbsql_affected_rows",
    "fbsql_autocommit",
    "fbsql_change_user",
    "fbsql_close",
    "fbsql_commit",
    "fbsql_connect",
    "fbsql_create_blob",
    "fbsql_create_clob",
    "fbsql_create_db",
    "fbsql_database",
    "fbsql_database_password",
    "fbsql_data_seek",
    "fbsql_db_query",
    "fbsql_db_status",
    "fbsql_drop_db",
    "fbsql_errno",
    "fbsql_error",
    "fbsql_fetch_array",
    "fbsql_fetch_assoc",
    "fbsql_fetch_field",
    "fbsql_fetch_lengths",
    "fbsql_fetch_object",
    "fbsql_fetch_row",
    "fbsql_field_flags",
    "fbsql_field_len",
    "fbsql_field_name",
    "fbsql_field_seek",
    "fbsql_field_table",
    "fbsql_field_type",
    "fbsql_free_result",
    "fbsql_get_autostart_info",
    "fbsql_hostname",
    "fbsql_insert_id",
    "fbsql_list_dbs",
    "fbsql_list_fields",
    "fbsql_list_tables",
    "fbsql_next_result",
    "fbsql_num_fields",
    "fbsql_num_rows",
    "fbsql_password",
    "fbsql_pconnect",
    "fbsql_query",
    "fbsql_read_blob",
    "fbsql_read_clob",
    "fbsql_result",
    "fbsql_rollback",
    "fbsql_select_db",
    "fbsql_set_lob_mode",
    "fbsql_set_transaction",
    "fbsql_start_db",
    "fbsql_stop_db",
    "fbsql_tablename",
    "fbsql_username",
    "fbsql_warnings",
    "fclose",
    "fdf_add_doc_javascript",
    "fdf_add_template",
    "fdf_close",
    "fdf_create",
    "fdf_errno",
    "fdf_error",
    "fdf_get_ap",
    "fdf_get_attachment",
    "fdf_get_encoding",
    "fdf_get_file",
    "fdf_get_status",
    "fdf_get_value",
    "fdf_get_version",
    "fdf_header",
    "fdf_next_field_name",
    "fdf_open",
    "fdf_open_string",
    "fdf_save",
    "fdf_save_string",
    "fdf_set_ap",
    "fdf_set_encoding",
    "fdf_set_file",
    "fdf_set_flags",
    "fdf_set_javascript_action",
    "fdf_set_opt",
    "fdf_set_status",
    "fdf_set_submit_form_action",
    "fdf_set_target_frame",
    "fdf_set_value",
    "fdf_set_version",
    "feof",
    "fflush",
    "fgetc",
    "fgetcsv",
    "fgets",
    "fgetss",
    "file",
    "__FILE__",
    "fileatime",
    "filectime",
    "file_exists",
    "file_get_contents",
    "filegroup",
    "fileinode",
    "filemtime",
    "fileowner",
    "fileperms",
    "filepro",
    "filepro_fieldcount",
    "filepro_fieldname",
    "filepro_fieldtype",
    "filepro_fieldwidth",
    "filepro_retrieve",
    "filepro_rowcount",
    "_FILES",
    "filesize",
    "filetype",
    "find",
    "first_child",
    "floatval",
    "flock",
    "floor",
    "flush",
    "fmod",
    "fnmatch",
    "fopen",
    "for",
    "foreach",
    "fpassthru",
    "fprintf",
    "fputs",
    "fread",
    "frenchtojd",
    "fribidi_log2vis",
    "fscanf",
    "fseek",
    "fsockopen",
    "fstat",
    "ftell",
    "ftok",
    "ftp_cdup",
    "ftp_chdir",
    "ftp_close",
    "ftp_connect",
    "ftp_delete",
    "ftp_exec",
    "ftp_fget",
    "ftp_fput",
    "ftp_get",
    "ftp_get_option",
    "ftp_login",
    "ftp_mdtm",
    "ftp_mkdir",
    "ftp_nb_continue",
    "ftp_nb_fget",
    "ftp_nb_fput",
    "ftp_nb_get",
    "ftp_nb_put",
    "ftp_nlist",
    "ftp_pasv",
    "ftp_put",
    "ftp_pwd",
    "ftp_quit",
    "ftp_rawlist",
    "ftp_rename",
    "ftp_rmdir",
    "ftp_set_option",
    "ftp_site",
    "ftp_size",
    "ftp_ssl_connect",
    "ftp_systype",
    "ftruncate",
    "ftstat",
    "func_get_arg",
    "func_get_args",
    "func_num_args",
    "function",
    "function_exists",
    "fwrite",
    "GATEWAY_INTERFACE",
    "gd_info",
    "_GET",
    "getallheaders",
    "get_attribute",
    "get_attribute_node",
    "get_browser",
    "get_cfg_var",
    "get_class",
    "get_class_methods",
    "get_class_vars",
    "get_content",
    "get_current_user",
    "getcwd",
    "getdate",
    "get_declared_classes",
    "get_defined_constants",
    "get_defined_functions",
    "get_defined_vars",
    "get_element_by_id",
    "get_elements_by_tagname",
    "getenv",
    "get_extension_funcs",
    "getHeight",
    "gethostbyaddr",
    "gethostbyname",
    "gethostbynamel",
    "get_html_translation_table",
    "getimagesize",
    "get_included_files",
    "get_include_path",
    "getlastmod",
    "get_loaded_extensions",
    "get_magic_quotes_gpc",
    "get_magic_quotes_runtime",
    "get_meta_tags",
    "getmxrr",
    "getmygid",
    "getmyinode",
    "getmypid",
    "getmyuid",
    "get_object_vars",
    "getopt",
    "get_parent_class",
    "getprotobyname",
    "getprotobynumber",
    "getrandmax",
    "get_required_files",
    "get_resource_type",
    "getrusage",
    "getservbyname",
    "getservbyport",
    "getshape1",
    "getshape2",
    "gettext",
    "gettimeofday",
    "gettype",
    "getwidth",
    "getWidth",
    "glob",
    "global",
    "GLOBALS",
    "gmdate",
    "gmmktime",
    "gmp_abs",
    "gmp_add",
    "gmp_and",
    "gmp_clrbit",
    "gmp_cmp",
    "gmp_com",
    "gmp_div",
    "gmp_divexact",
    "gmp_div_q",
    "gmp_div_qr",
    "gmp_div_r",
    "gmp_fact",
    "gmp_gcd",
    "gmp_gcdext",
    "gmp_hamdist",
    "gmp_init",
    "gmp_intval",
    "gmp_invert",
    "gmp_jacobi",
    "gmp_legendre",
    "gmp_mod",
    "gmp_mul",
    "gmp_neg",
    "gmp_or",
    "gmp_perfect_square",
    "gmp_popcount",
    "gmp_pow",
    "gmp_powm",
    "gmp_prob_prime",
    "gmp_random",
    "gmp_scan0",
    "gmp_scan1",
    "gmp_setbit",
    "gmp_sign",
    "gmp_sqrt",
    "gmp_sqrtrm",
    "gmp_strval",
    "gmp_sub",
    "gmp_xor",
    "gmstrftime",
    "gregoriantojd",
    "gzclose",
    "gzcompress",
    "gzdeflate",
    "gzencode",
    "gzeof",
    "gzfile",
    "gzgetc",
    "gzgets",
    "gzgetss",
    "gzinflate",
    "gzopen",
    "gzpassthru",
    "gzputs",
    "gzread",
    "gzrewind",
    "gzseek",
    "gztell",
    "gzuncompress",
    "gzwrite",
    "has_attribute",
    "has_attributess",
    "has_child_nodes",
    "header",
    "headers_sent",
    "hebrev",
    "hebrevc",
    "hexdec",
    "highlight_file",
    "highlight_string",
    "html_dump_mem",
    "htmlentities",
    "html_entity_decode",
    "htmlspecialchars",
    "HTTP_ACCEPT",
    "HTTP_ACCEPT_CHARSET",
    "HTTP_ACCEPT_LANGUAGE",
    "HTTP_CONNECTION",
    "HTTP_COOKIE_VARS",
    "HTTP_ENCODING",
    "HTTP_ENV_VARS",
    "HTTP_GET_VARS",
    "HTTP_HOST",
    "HTTP_POST_FILES",
    "HTTP_POST_VARS",
    "HTTP_RAW_POST_DATA",
    "HTTP_REFERER",
    "HTTP_SERVER_VARS",
    "HTTP_SESSION_VARS",
    "HTTP_STATE_VARS",
    "HTTP_USER_AGENT",
    "hw_api_attribute",
    "hw_api_content",
    "hwapi_hgcsp",
    "hw_api_object",
    "hw_Array2Objrec",
    "hw_changeobject",
    "hw_Children",
    "hw_ChildrenObj",
    "hw_Close",
    "hw_Connect",
    "hw_connection_info",
    "hw_Cp",
    "hw_Deleteobject",
    "hw_DocByAnchor",
    "hw_DocByAnchorObj",
    "hw_Document_Attributes",
    "hw_Document_BodyTag",
    "hw_Document_Content",
    "hw_Document_SetContent",
    "hw_Document_Size",
    "hw_dummy",
    "hw_EditText",
    "hw_Error",
    "hw_ErrorMsg",
    "hw_Free_Document",
    "hw_GetAnchors",
    "hw_GetAnchorsObj",
    "hw_GetAndLock",
    "hw_GetChildColl",
    "hw_GetChildCollObj",
    "hw_GetChildDocColl",
    "hw_GetChildDocCollObj",
    "hw_GetObject",
    "hw_GetObjectByQuery",
    "hw_GetObjectByQueryColl",
    "hw_GetObjectByQueryCollObj",
    "hw_GetObjectByQueryObj",
    "hw_GetParents",
    "hw_GetParentsObj",
    "hw_getrellink",
    "hw_GetRemote",
    "hw_GetRemoteChildren",
    "hw_GetSrcByDestObj",
    "hw_GetText",
    "hw_getusername",
    "hw_Identify",
    "hw_InCollections",
    "hw_Info",
    "hw_InsColl",
    "hw_InsDoc",
    "hw_insertanchors",
    "hw_InsertDocument",
    "hw_InsertObject",
    "hw_mapid",
    "hw_Modifyobject",
    "hw_Mv",
    "hw_New_Document",
    "hw_Objrec2Array",
    "hw_Output_Document",
    "hw_pConnect",
    "hw_PipeDocument",
    "hw_Root",
    "hw_setlinkroot",
    "hw_stat",
    "hwstat",
    "hw_Unlock",
    "hw_Who",
    "hypot",
    "ibase_blob_add",
    "ibase_blob_cancel",
    "ibase_blob_close",
    "ibase_blob_create",
    "ibase_blob_echo",
    "ibase_blob_get",
    "ibase_blob_import",
    "ibase_blob_info",
    "ibase_blob_open",
    "ibase_close",
    "ibase_commit",
    "ibase_connect",
    "ibase_errmsg",
    "ibase_execute",
    "ibase_fetch_object",
    "ibase_fetch_row",
    "ibase_field_info",
    "ibase_free_query",
    "ibase_free_result",
    "ibase_num_fields",
    "ibase_pconnect",
    "ibase_prepare",
    "ibase_query",
    "ibase_rollback",
    "ibase_timefmt",
    "ibase_trans",
    "iconv",
    "iconv_get_encoding",
    "iconv_set_encoding",
    "identify",
    "if",
    "ifx_affected_rows",
    "ifx_blobinfile_mode",
    "ifx_byteasvarchar",
    "ifx_close",
    "ifx_connect",
    "ifx_copy_blob",
    "ifx_create_blob",
    "ifx_create_char",
    "ifx_do",
    "ifx_error",
    "ifx_errormsg",
    "ifx_fetch_row",
    "ifx_fieldproperties",
    "ifx_fieldtypes",
    "ifx_free_blob",
    "ifx_free_char",
    "ifx_free_result",
    "ifx_get_blob",
    "ifx_get_char",
    "ifx_getsqlca",
    "ifx_htmltbl_result",
    "ifx_nullformat",
    "ifx_num_fields",
    "ifx_num_rows",
    "ifx_pconnect",
    "ifx_prepare",
    "ifx_query",
    "ifx_textasvarchar",
    "ifx_update_blob",
    "ifx_update_char",
    "ifxus_close_slob",
    "ifxus_create_slob",
    "ifxus_free_slob",
    "ifxus_open_slob",
    "ifxus_read_slob",
    "ifxus_seek_slob",
    "ifxus_tell_slob",
    "ifxus_write_slob",
    "ignore_user_abort",
    "image2wbmp",
    "imagealphablending",
    "imagearc",
    "imagechar",
    "imagecharup",
    "imagecolorallocate",
    "imagecolorallocatealpha",
    "imagecolorat",
    "imagecolorclosest",
    "imagecolorclosestalpha",
    "imagecolorclosesthwb",
    "imagecolordeallocate",
    "imagecolorexact",
    "imagecolorexactalpha",
    "imagecolorresolve",
    "imagecolorresolvealpha",
    "imagecolorset",
    "imagecolorsforindex",
    "imagecolorstotal",
    "imagecolortransparent",
    "imagecopy",
    "imagecopymerge",
    "imagecopymergegray",
    "imagecopyresampled",
    "imagecopyresized",
    "imagecreate",
    "imagecreatefromgd",
    "imagecreatefromgd2",
    "imagecreatefromgd2part",
    "imagecreatefromgif",
    "imagecreatefromjpeg",
    "imagecreatefrompng",
    "imagecreatefromstring",
    "imagecreatefromwbmp",
    "imagecreatefromxbm",
    "imagecreatefromxpm",
    "imagecreatetruecolor",
    "imagedashedline",
    "imagedestroy",
    "imageellipse",
    "imagefill",
    "imagefilledarc",
    "imagefilledellipse",
    "imagefilledpolygon",
    "imagefilledrectangle",
    "imagefilltoborder",
    "imagefontheight",
    "imagefontwidth",
    "imageftbbox",
    "imagefttext",
    "imagegammacorrect",
    "imagegd",
    "imagegd2",
    "imagegif",
    "imageinterlace",
    "imagejpeg",
    "imageline",
    "imageloadfont",
    "imagepalettecopy",
    "imagepng",
    "imagepolygon",
    "imagepsbbox",
    "imagepscopyfont",
    "imagepsencodefont",
    "imagepsextendfont",
    "imagepsfreefont",
    "imagepsloadfont",
    "imagepsslantfont",
    "imagepstext",
    "imagerectangle",
    "imagerotate",
    "imagesetbrush",
    "imagesetpixel",
    "imagesetstyle",
    "imagesetthickness",
    "imagesettile",
    "imagestring",
    "imagestringup",
    "imagesx",
    "imagesy",
    "imagetruecolortopalette",
    "imagettfbbox",
    "imagettftext",
    "imagetypes",
    "image_type_to_mime_type",
    "imagewbmp",
    "imap_8bit",
    "imap_alerts",
    "imap_append",
    "imap_base64",
    "imap_binary",
    "imap_body",
    "imap_bodystruct",
    "imap_check",
    "imap_clearflag_full",
    "imap_close",
    "imap_createmailbox",
    "imap_delete",
    "imap_deletemailbox",
    "imap_errors",
    "imap_expunge",
    "imap_fetchbody",
    "imap_fetchheader",
    "imap_fetch_overview",
    "imap_fetchstructure",
    "imap_getmailboxes",
    "imap_get_quota",
    "imap_get_quotaroot",
    "imap_getsubscribed",
    "imap_header",
    "imap_headerinfo",
    "imap_headers",
    "imap_last_error",
    "imap_list",
    "imap_listmailbox",
    "imap_listscan",
    "imap_listsubscribed",
    "imap_lsub",
    "imap_mail",
    "imap_mailboxmsginfo",
    "imap_mail_compose",
    "imap_mail_copy",
    "imap_mail_move",
    "imap_mime_header_decode",
    "imap_msgno",
    "imap_num_msg",
    "imap_num_recent",
    "imap_open",
    "imap_ping",
    "imap_qprint",
    "imap_renamemailbox",
    "imap_reopen",
    "imap_rfc822_parse_adrlist",
    "imap_rfc822_parse_headers",
    "imap_rfc822_write_address",
    "imap_scanmailbox",
    "imap_search",
    "imap_setacl",
    "imap_setflag_full",
    "imap_set_quota",
    "imap_sort",
    "imap_status",
    "imap_subscribe",
    "imap_thread",
    "imap_uid",
    "imap_undelete",
    "imap_unsubscribe",
    "imap_utf7_decode",
    "imap_utf7_encode",
    "imap_utf8",
    "implode",
    "import_request_variables",
    "in_array",
    "include",
    "include_once",
    "info",
    "ingres_autocommit",
    "ingres_close",
    "ingres_commit",
    "ingres_connect",
    "ingres_fetch_array",
    "ingres_fetch_object",
    "ingres_fetch_row",
    "ingres_field_length",
    "ingres_field_name",
    "ingres_field_nullable",
    "ingres_field_precision",
    "ingres_field_scale",
    "ingres_field_type",
    "ingres_num_fields",
    "ingres_num_rows",
    "ingres_pconnect",
    "ingres_query",
    "ingres_rollback",
    "ini_alter",
    "ini_get",
    "ini_get_all",
    "ini_restore",
    "ini_set",
    "insert",
    "insertanchor",
    "insert_before",
    "insertcollection",
    "insertdocument",
    "int",
    "internal_subset",
    "intval",
    "ip2long",
    "iptcembed",
    "iptcparse",
    "ircg_channel_mode",
    "ircg_disconnect",
    "ircg_fetch_error_msg",
    "ircg_get_username",
    "ircg_html_encode",
    "ircg_ignore_add",
    "ircg_ignore_del",
    "ircg_is_conn_alive",
    "ircg_join",
    "ircg_kick",
    "ircg_lookup_format_messages",
    "ircg_msg",
    "ircg_nick",
    "ircg_nickname_escape",
    "ircg_nickname_unescape",
    "ircg_notice",
    "ircg_part",
    "ircg_pconnect",
    "ircg_register_format_messages",
    "ircg_set_current",
    "ircg_set_file",
    "ircg_set_on_die",
    "ircg_topic",
    "ircg_whois",
    "is_a",
    "is_array",
    "is_blank_node",
    "is_bool",
    "is_callable",
    "is_dir",
    "is_double",
    "is_executable",
    "is_file",
    "is_finite",
    "is_float",
    "is_infinite",
    "is_int",
    "is_integer",
    "is_link",
    "is_long",
    "is_nan",
    "is_null",
    "is_numeric",
    "is_object",
    "is_readable",
    "is_real",
    "is_resource",
    "is_scalar",
    "isset",
    "is_string",
    "is_subclass_of",
    "is_uploaded_file",
    "is_writable",
    "is_writeable",
    "java_last_exception_clear",
    "java_last_exception_get",
    "jddayofweek",
    "jdmonthname",
    "jdtofrench",
    "jdtogregorian",
    "jdtojewish",
    "jdtojulian",
    "jdtounix",
    "jewishtojd",
    "join",
    "jpeg2wbmp",
    "juliantojd",
    "key",
    "krsort",
    "ksort",
    "langdepvalue",
    "last_child",
    "lcg_value",
    "ldap_8859_to_t61",
    "ldap_add",
    "ldap_bind",
    "ldap_close",
    "ldap_compare",
    "ldap_connect",
    "ldap_count_entries",
    "ldap_delete",
    "ldap_dn2ufn",
    "ldap_err2str",
    "ldap_errno",
    "ldap_error",
    "ldap_explode_dn",
    "ldap_first_attribute",
    "ldap_first_entry",
    "ldap_first_reference",
    "ldap_free_result",
    "ldap_get_attributes",
    "ldap_get_dn",
    "ldap_get_entries",
    "ldap_get_option",
    "ldap_get_values",
    "ldap_get_values_len",
    "ldap_list",
    "ldap_mod_add",
    "ldap_mod_del",
    "ldap_modify",
    "ldap_mod_replace",
    "ldap_next_attribute",
    "ldap_next_entry",
    "ldap_next_reference",
    "ldap_parse_reference",
    "ldap_parse_result",
    "ldap_read",
    "ldap_rename",
    "ldap_search",
    "ldap_set_option",
    "ldap_set_rebind_proc",
    "ldap_sort",
    "ldap_start_tls",
    "ldap_t61_to_8859",
    "ldap_unbind",
    "levenshtein",
    "__LINE__",
    "link",
    "linkinfo",
    "list",
    "localeconv",
    "localtime",
    "lock",
    "log",
    "log10",
    "log1p",
    "long2ip",
    "lstat",
    "ltrim",
    "mail",
    "mailparse_determine_best_xfer_encoding",
    "mailparse_msg_create",
    "mailparse_msg_extract_part",
    "mailparse_msg_extract_part_file",
    "mailparse_msg_free",
    "mailparse_msg_get_part",
    "mailparse_msg_get_part_data",
    "mailparse_msg_get_structure",
    "mailparse_msg_parse",
    "mailparse_msg_parse_file",
    "mailparse_rfc822_parse_addresses",
    "mailparse_stream_encode",
    "mailparse_uudecode_all",
    "main",
    "max",
    "mb_convert_case",
    "mb_convert_encoding",
    "mb_convert_kana",
    "mb_convert_variables",
    "mb_decode_mimeheader",
    "mb_decode_numericentity",
    "mb_detect_encoding",
    "mb_detect_order",
    "mb_encode_mimeheader",
    "mb_encode_numericentity",
    "mb_ereg",
    "mb_eregi",
    "mb_eregi_replace",
    "mb_ereg_match",
    "mb_ereg_replace",
    "mb_ereg_search",
    "mb_ereg_search_getpos",
    "mb_ereg_search_getregs",
    "mb_ereg_search_init",
    "mb_ereg_search_pos",
    "mb_ereg_search_regs",
    "mb_ereg_search_setpos",
    "mb_get_info",
    "mb_http_input",
    "mb_http_output",
    "mb_internal_encoding",
    "mb_language",
    "mb_output_handler",
    "mb_parse_str",
    "mb_preferred_mime_name",
    "mb_regex_encoding",
    "mb_regex_set_options",
    "mb_send_mail",
    "mb_split",
    "mb_strcut",
    "mb_strimwidth",
    "mb_strlen",
    "mb_strpos",
    "mb_strrpos",
    "mb_strtolower",
    "mb_strtoupper",
    "mb_strwidth",
    "mb_substitute_character",
    "mb_substr",
    "mb_substr_count",
    "mcal_append_event",
    "mcal_close",
    "mcal_create_calendar",
    "mcal_date_compare",
    "mcal_date_valid",
    "mcal_day_of_week",
    "mcal_day_of_year",
    "mcal_days_in_month",
    "mcal_delete_calendar",
    "mcal_delete_event",
    "mcal_event_add_attribute",
    "mcal_event_init",
    "mcal_event_set_alarm",
    "mcal_event_set_category",
    "mcal_event_set_class",
    "mcal_event_set_description",
    "mcal_event_set_end",
    "mcal_event_set_recur_daily",
    "mcal_event_set_recur_monthly_mday",
    "mcal_event_set_recur_monthly_wday",
    "mcal_event_set_recur_none",
    "mcal_event_set_recur_weekly",
    "mcal_event_set_recur_yearly",
    "mcal_event_set_start",
    "mcal_event_set_title",
    "mcal_expunge",
    "mcal_fetch_current_stream_event",
    "mcal_fetch_event",
    "mcal_is_leap_year",
    "mcal_list_alarms",
    "mcal_list_events",
    "mcal_next_recurrence",
    "mcal_open",
    "mcal_popen",
    "mcal_rename_calendar",
    "mcal_reopen",
    "mcal_snooze",
    "mcal_store_event",
    "mcal_time_valid",
    "mcal_week_of_year",
    "mcrypt_cbc",
    "mcrypt_cfb",
    "mcrypt_create_iv",
    "mcrypt_decrypt",
    "mcrypt_ecb",
    "mcrypt_enc_get_algorithms_name",
    "mcrypt_enc_get_block_size",
    "mcrypt_enc_get_iv_size",
    "mcrypt_enc_get_key_size",
    "mcrypt_enc_get_modes_name",
    "mcrypt_enc_get_supported_key_sizes",
    "mcrypt_enc_is_block_algorithm",
    "mcrypt_enc_is_block_algorithm_mode",
    "mcrypt_enc_is_block_mode",
    "mcrypt_encrypt",
    "mcrypt_enc_self_test",
    "mcrypt_generic",
    "mcrypt_generic_deinit",
    "mcrypt_generic_end",
    "mcrypt_generic_init",
    "mcrypt_get_block_size",
    "mcrypt_get_cipher_name",
    "mcrypt_get_iv_size",
    "mcrypt_get_key_size",
    "mcrypt_list_algorithms",
    "mcrypt_list_modes",
    "mcrypt_module_close",
    "mcrypt_module_get_algo_block_size",
    "mcrypt_module_get_algo_key_size",
    "mcrypt_module_get_supported_key_sizes",
    "mcrypt_module_is_block_algorithm",
    "mcrypt_module_is_block_algorithm_mode",
    "mcrypt_module_is_block_mode",
    "mcrypt_module_open",
    "mcrypt_module_self_test",
    "mcrypt_ofb",
    "mcve_adduser",
    "mcve_adduserarg",
    "mcve_bt",
    "mcve_checkstatus",
    "mcve_chkpwd",
    "mcve_chngpwd",
    "mcve_completeauthorizations",
    "mcve_connect",
    "mcve_connectionerror",
    "mcve_deleteresponse",
    "mcve_deletetrans",
    "mcve_deleteusersetup",
    "mcve_deluser",
    "mcve_destroyconn",
    "mcve_destroyengine",
    "mcve_disableuser",
    "mcve_edituser",
    "mcve_enableuser",
    "mcve_force",
    "mcve_getcell",
    "mcve_getcellbynum",
    "mcve_getcommadelimited",
    "mcve_getheader",
    "mcve_getuserarg",
    "mcve_getuserparam",
    "mcve_gft",
    "mcve_gl",
    "mcve_gut",
    "mcve_initconn",
    "mcve_initengine",
    "mcve_initusersetup",
    "mcve_iscommadelimited",
    "mcve_liststats",
    "mcve_listusers",
    "mcve_maxconntimeout",
    "mcve_monitor",
    "mcve_numcolumns",
    "mcve_numrows",
    "mcve_override",
    "mcve_parsecommadelimited",
    "mcve_ping",
    "mcve_preauth",
    "mcve_preauthcompletion",
    "mcve_qc",
    "mcve_responseparam",
    "mcve_return",
    "mcve_returncode",
    "mcve_returnstatus",
    "mcve_sale",
    "mcve_setblocking",
    "mcve_setdropfile",
    "mcve_setip",
    "mcve_setssl",
    "mcve_settimeout",
    "mcve_settle",
    "mcve_text_avs",
    "mcve_text_code",
    "mcve_text_cv",
    "mcve_transactionauth",
    "mcve_transactionavs",
    "mcve_transactionbatch",
    "mcve_transactioncv",
    "mcve_transactionid",
    "mcve_transactionitem",
    "mcve_transactionssent",
    "mcve_transactiontext",
    "mcve_transinqueue",
    "mcve_transnew",
    "mcve_transparam",
    "mcve_transsend",
    "mcve_ub",
    "mcve_uwait",
    "mcve_verifyconnection",
    "mcve_verifysslcert",
    "mcve_void",
    "md5",
    "md5_file",
    "mdecrypt_generic",
    "memory_get_usage",
    "metaphone",
    "method_exists",
    "mhash",
    "mhash_count",
    "mhash_get_block_size",
    "mhash_get_hash_name",
    "mhash_keygen_s2k",
    "microtime",
    "mime_content_type",
    "mimetype",
    "min",
    "ming_setcubicthreshold",
    "ming_setscale",
    "ming_useswfversion",
    "mkdir",
    "mktime",
    "money_format",
    "move",
    "movePen",
    "movePenTo",
    "moveTo",
    "move_uploaded_file",
    "msession_connect",
    "msession_count",
    "msession_create",
    "msession_destroy",
    "msession_disconnect",
    "msession_find",
    "msession_get",
    "msession_get_array",
    "msession_getdata",
    "msession_inc",
    "msession_list",
    "msession_listvar",
    "msession_lock",
    "msession_plugin",
    "msession_randstr",
    "msession_set",
    "msession_set_array",
    "msession_setdata",
    "msession_timeout",
    "msession_uniq",
    "msession_unlock",
    "msg_get_queue",
    "msg_receive",
    "msg_remove_queue",
    "msg_send",
    "msg_set_queue",
    "msg_stat_queue",
    "msql",
    "msql_affected_rows",
    "msql_close",
    "msql_connect",
    "msql_create_db",
    "msql_createdb",
    "msql_data_seek",
    "msql_dbname",
    "msql_drop_db",
    "msql_dropdb",
    "msql_error",
    "msql_fetch_array",
    "msql_fetch_field",
    "msql_fetch_object",
    "msql_fetch_row",
    "msql_fieldflags",
    "msql_fieldlen",
    "msql_fieldname",
    "msql_field_seek",
    "msql_fieldtable",
    "msql_fieldtype",
    "msql_free_result",
    "msql_freeresult",
    "msql_list_dbs",
    "msql_listdbs",
    "msql_list_fields",
    "msql_listfields",
    "msql_list_tables",
    "msql_listtables",
    "msql_num_fields",
    "msql_numfields",
    "msql_num_rows",
    "msql_numrows",
    "msql_pconnect",
    "msql_query",
    "msql_regcase",
    "msql_result",
    "msql_select_db",
    "msql_selectdb",
    "msql_tablename",
    "mssql_bind",
    "mssql_close",
    "mssql_connect",
    "mssql_data_seek",
    "mssql_execute",
    "mssql_fetch_array",
    "mssql_fetch_assoc",
    "mssql_fetch_batch",
    "mssql_fetch_field",
    "mssql_fetch_object",
    "mssql_fetch_row",
    "mssql_field_length",
    "mssql_field_name",
    "mssql_field_seek",
    "mssql_field_type",
    "mssql_free_result",
    "mssql_free_statement",
    "mssql_get_last_message",
    "mssql_guid_string",
    "mssql_init",
    "mssql_min_error_severity",
    "mssql_min_message_severity",
    "mssql_next_result",
    "mssql_num_fields",
    "mssql_num_rows",
    "mssql_pconnect",
    "mssql_query",
    "mssql_result",
    "mssql_rows_affected",
    "mssql_select_db",
    "mt_getrandmax",
    "mt_rand",
    "mt_srand",
    "multColor",
    "muscat_close",
    "muscat_get",
    "muscat_give",
    "muscat_setup",
    "muscat_setup_net",
    "mysql_affected_rows",
    "mysql_change_user",
    "mysql_client_encoding",
    "mysql_close",
    "mysql_connect",
    "mysql_create_db",
    "mysql_data_seek",
    "mysql_db_name",
    "mysql_db_query",
    "mysql_drop_db",
    "mysql_errno",
    "mysql_error",
    "mysql_escape_string",
    "mysql_fetch_array",
    "mysql_fetch_assoc",
    "mysql_fetch_field",
    "mysql_fetch_lengths",
    "mysql_fetch_object",
    "mysql_fetch_row",
    "mysql_field_flags",
    "mysql_field_len",
    "mysql_field_name",
    "mysql_field_seek",
    "mysql_field_table",
    "mysql_field_type",
    "mysql_free_result",
    "mysql_get_client_info",
    "mysql_get_host_info",
    "mysql_get_proto_info",
    "mysql_get_server_info",
    "mysql_info",
    "mysql_insert_id",
    "mysql_list_dbs",
    "mysql_list_fields",
    "mysql_list_processes",
    "mysql_list_tables",
    "mysql_num_fields",
    "mysql_num_rows",
    "mysql_pconnect",
    "mysql_ping",
    "mysql_query",
    "mysql_real_escape_string",
    "mysql_result",
    "mysql_select_db",
    "mysql_stat",
    "mysql_tablename",
    "mysql_thread_id",
    "mysql_unbuffered_query",
    "name",
    "natcasesort",
    "natsort",
    "ncurses_addch",
    "ncurses_addchnstr",
    "ncurses_addchstr",
    "ncurses_addnstr",
    "ncurses_addstr",
    "ncurses_assume_default_colors",
    "ncurses_attroff",
    "ncurses_attron",
    "ncurses_attrset",
    "ncurses_baudrate",
    "ncurses_beep",
    "ncurses_bkgd",
    "ncurses_bkgdset",
    "ncurses_border",
    "ncurses_can_change_color",
    "ncurses_cbreak",
    "ncurses_clear",
    "ncurses_clrtobot",
    "ncurses_clrtoeol",
    "ncurses_color_set",
    "ncurses_curs_set",
    "ncurses_define_key",
    "ncurses_def_prog_mode",
    "ncurses_def_shell_mode",
    "ncurses_delay_output",
    "ncurses_delch",
    "ncurses_deleteln",
    "ncurses_delwin",
    "ncurses_doupdate",
    "ncurses_echo",
    "ncurses_echochar",
    "ncurses_end",
    "ncurses_erase",
    "ncurses_erasechar",
    "ncurses_filter",
    "ncurses_flash",
    "ncurses_flushinp",
    "ncurses_getch",
    "ncurses_getmouse",
    "ncurses_halfdelay",
    "ncurses_has_colors",
    "ncurses_has_ic",
    "ncurses_has_il",
    "ncurses_has_key",
    "ncurses_hline",
    "ncurses_inch",
    "ncurses_init",
    "ncurses_init_color",
    "ncurses_init_pair",
    "ncurses_insch",
    "ncurses_insdelln",
    "ncurses_insertln",
    "ncurses_insstr",
    "ncurses_instr",
    "ncurses_isendwin",
    "ncurses_keyok",
    "ncurses_killchar",
    "ncurses_longname",
    "ncurses_mouseinterval",
    "ncurses_mousemask",
    "ncurses_move",
    "ncurses_mvaddch",
    "ncurses_mvaddchnstr",
    "ncurses_mvaddchstr",
    "ncurses_mvaddnstr",
    "ncurses_mvaddstr",
    "ncurses_mvcur",
    "ncurses_mvdelch",
    "ncurses_mvgetch",
    "ncurses_mvhline",
    "ncurses_mvinch",
    "ncurses_mvvline",
    "ncurses_mvwaddstr",
    "ncurses_napms",
    "ncurses_newwin",
    "ncurses_nl",
    "ncurses_nocbreak",
    "ncurses_noecho",
    "ncurses_nonl",
    "ncurses_noqiflush",
    "ncurses_noraw",
    "ncurses_putp",
    "ncurses_qiflush",
    "ncurses_raw",
    "ncurses_refresh",
    "ncurses_resetty",
    "ncurses_savetty",
    "ncurses_scr_dump",
    "ncurses_scr_init",
    "ncurses_scrl",
    "ncurses_scr_restore",
    "ncurses_scr_set",
    "ncurses_slk_attr",
    "ncurses_slk_attroff",
    "ncurses_slk_attron",
    "ncurses_slk_attrset",
    "ncurses_slk_clear",
    "ncurses_slk_color",
    "ncurses_slk_init",
    "ncurses_slk_noutrefresh",
    "ncurses_slk_refresh",
    "ncurses_slk_restore",
    "ncurses_slk_touch",
    "ncurses_standend",
    "ncurses_standout",
    "ncurses_start_color",
    "ncurses_termattrs",
    "ncurses_termname",
    "ncurses_timeout",
    "ncurses_typeahead",
    "ncurses_ungetch",
    "ncurses_ungetmouse",
    "ncurses_use_default_colors",
    "ncurses_use_env",
    "ncurses_use_extended_names",
    "ncurses_vidattr",
    "ncurses_vline",
    "ncurses_wrefresh",
    "new",
    "next",
    "nextframe",
    "next_sibling",
    "ngettext",
    "nl2br",
    "nl_langinfo",
    "node_name",
    "node_type",
    "node_value",
    "notations",
    "notes_body",
    "notes_copy_db",
    "notes_create_db",
    "notes_create_note",
    "notes_drop_db",
    "notes_find_note",
    "notes_header_info",
    "notes_list_msgs",
    "notes_mark_read",
    "notes_mark_unread",
    "notes_nav_create",
    "notes_search",
    "notes_unread",
    "notes_version",
    "NULL",
    "number_format",
    "ob_clean",
    "ob_end_clean",
    "ob_end_flush",
    "ob_flush",
    "ob_get_contents",
    "ob_get_length",
    "ob_get_level",
    "ob_get_status",
    "ob_gzhandler",
    "ob_iconv_handler",
    "ob_implicit_flush",
    "object",
    "objectbyanchor",
    "ob_start",
    "ocibindbyname",
    "ocicancel",
    "OCICollAppend",
    "ocicollassign",
    "ocicollassignelem",
    "ocicollgetelem",
    "ocicollmax",
    "ocicollsize",
    "ocicolltrim",
    "ocicolumnisnull",
    "ocicolumnname",
    "ocicolumnprecision",
    "ocicolumnscale",
    "ocicolumnsize",
    "ocicolumntype",
    "ocicolumntyperaw",
    "ocicommit",
    "ocidefinebyname",
    "ocierror",
    "ociexecute",
    "ocifetch",
    "ocifetchinto",
    "ocifetchstatement",
    "ocifreecollection",
    "ocifreecursor",
    "OCIFreeDesc",
    "ocifreestatement",
    "ociinternaldebug",
    "ociloadlob",
    "ocilogoff",
    "ocilogon",
    "ocinewcollection",
    "ocinewcursor",
    "ocinewdescriptor",
    "ocinlogon",
    "ocinumcols",
    "ociparse",
    "ociplogon",
    "ociresult",
    "ocirollback",
    "ocirowcount",
    "ocisavelob",
    "ocisavelobfile",
    "ociserverversion",
    "ocisetprefetch",
    "ocistatementtype",
    "ociwritelobtofile",
    "octdec",
    "odbc_autocommit",
    "odbc_binmode",
    "odbc_close",
    "odbc_close_all",
    "odbc_columnprivileges",
    "odbc_columns",
    "odbc_commit",
    "odbc_connect",
    "odbc_cursor",
    "odbc_data_source",
    "odbc_do",
    "odbc_error",
    "odbc_errormsg",
    "odbc_exec",
    "odbc_execute",
    "odbc_fetch_array",
    "odbc_fetch_into",
    "odbc_fetch_object",
    "odbc_fetch_row",
    "odbc_field_len",
    "odbc_field_name",
    "odbc_field_num",
    "odbc_field_precision",
    "odbc_field_scale",
    "odbc_field_type",
    "odbc_foreignkeys",
    "odbc_free_result",
    "odbc_gettypeinfo",
    "odbc_longreadlen",
    "odbc_next_result",
    "odbc_num_fields",
    "odbc_num_rows",
    "odbc_pconnect",
    "odbc_prepare",
    "odbc_primarykeys",
    "odbc_procedurecolumns",
    "odbc_procedures",
    "odbc_result",
    "odbc_result_all",
    "odbc_rollback",
    "odbc_setoption",
    "odbc_specialcolumns",
    "odbc_statistics",
    "odbc_tableprivileges",
    "odbc_tables",
    "opendir",
    "openlog",
    "openssl_csr_export",
    "openssl_csr_export_to_file",
    "openssl_csr_new",
    "openssl_csr_sign",
    "openssl_error_string",
    "openssl_free_key",
    "openssl_get_privatekey",
    "openssl_get_publickey",
    "openssl_open",
    "openssl_pkcs7_decrypt",
    "openssl_pkcs7_encrypt",
    "openssl_pkcs7_sign",
    "openssl_pkcs7_verify",
    "openssl_pkey_export",
    "openssl_pkey_export_to_file",
    "openssl_pkey_get_private",
    "openssl_pkey_get_public",
    "openssl_pkey_new",
    "openssl_private_decrypt",
    "openssl_private_encrypt",
    "openssl_public_decrypt",
    "openssl_public_encrypt",
    "openssl_seal",
    "openssl_sign",
    "openssl_verify",
    "openssl_x509_check_private_key",
    "openssl_x509_checkpurpose",
    "openssl_x509_export",
    "openssl_x509_export_to_file",
    "openssl_x509_free",
    "openssl_x509_parse",
    "openssl_x509_read",
    "ora_bind",
    "ora_close",
    "ora_columnname",
    "ora_columnsize",
    "ora_columntype",
    "ora_commit",
    "ora_commitoff",
    "ora_commiton",
    "ora_do",
    "ora_error",
    "ora_errorcode",
    "ora_exec",
    "ora_fetch",
    "ora_fetch_into",
    "ora_getcolumn",
    "ora_logoff",
    "ora_logon",
    "ora_numcols",
    "ora_numrows",
    "ora_open",
    "ora_parse",
    "ora_plogon",
    "ora_rollback",
    "ord",
    "output",
    "overload",
    "ovrimos_close",
    "ovrimos_commit",
    "ovrimos_connect",
    "ovrimos_cursor",
    "ovrimos_exec",
    "ovrimos_execute",
    "ovrimos_fetch_into",
    "ovrimos_fetch_row",
    "ovrimos_field_len",
    "ovrimos_field_name",
    "ovrimos_field_num",
    "ovrimos_field_type",
    "ovrimos_free_result",
    "ovrimos_longreadlen",
    "ovrimos_num_fields",
    "ovrimos_num_rows",
    "ovrimos_prepare",
    "ovrimos_result",
    "ovrimos_result_all",
    "ovrimos_rollback",
    "owner_document",
    "pack",
    "parent_node",
    "parents",
    "parse_ini_file",
    "parse_str",
    "parse_url",
    "passthru",
    "pathinfo",
    "PATH_TRANSLATED",
    "pclose",
    "pcntl_exec",
    "pcntl_fork",
    "pcntl_signal",
    "pcntl_waitpid",
    "pcntl_wexitstatus",
    "pcntl_wifexited",
    "pcntl_wifsignaled",
    "pcntl_wifstopped",
    "pcntl_wstopsig",
    "pcntl_wtermsig",
    "pdf_add_annotation",
    "pdf_add_bookmark",
    "pdf_add_launchlink",
    "pdf_add_locallink",
    "pdf_add_note",
    "pdf_add_outline",
    "pdf_add_pdflink",
    "pdf_add_thumbnail",
    "pdf_add_weblink",
    "pdf_arc",
    "pdf_arcn",
    "pdf_attach_file",
    "pdf_begin_page",
    "pdf_begin_pattern",
    "pdf_begin_template",
    "pdf_circle",
    "pdf_clip",
    "pdf_close",
    "pdf_close_image",
    "pdf_closepath",
    "pdf_closepath_fill_stroke",
    "pdf_closepath_stroke",
    "pdf_close_pdi",
    "pdf_close_pdi_page",
    "pdf_concat",
    "pdf_continue_text",
    "pdf_curveto",
    "pdf_delete",
    "pdf_end_page",
    "pdf_endpath",
    "pdf_end_pattern",
    "pdf_end_template",
    "pdf_fill",
    "pdf_fill_stroke",
    "pdf_findfont",
    "pdf_get_buffer",
    "pdf_get_font",
    "pdf_get_fontname",
    "pdf_get_fontsize",
    "pdf_get_image_height",
    "pdf_get_image_width",
    "pdf_get_majorversion",
    "pdf_get_minorversion",
    "pdf_get_parameter",
    "pdf_get_pdi_parameter",
    "pdf_get_pdi_value",
    "pdf_get_value",
    "pdf_initgraphics",
    "pdf_lineto",
    "pdf_makespotcolor",
    "pdf_moveto",
    "pdf_new",
    "pdf_open",
    "pdf_open_CCITT",
    "pdf_open_file",
    "pdf_open_gif",
    "pdf_open_image",
    "pdf_open_image_file",
    "pdf_open_jpeg",
    "pdf_open_memory_image",
    "pdf_open_pdi",
    "pdf_open_pdi_page",
    "pdf_open_png",
    "pdf_open_tiff",
    "pdf_place_image",
    "pdf_place_pdi_page",
    "pdf_rect",
    "pdf_restore",
    "pdf_rotate",
    "pdf_save",
    "pdf_scale",
    "pdf_set_border_color",
    "pdf_set_border_dash",
    "pdf_set_border_style",
    "pdf_set_char_spacing",
    "pdf_setcolor",
    "pdf_setdash",
    "pdf_set_duration",
    "pdf_setflat",
    "pdf_set_font",
    "pdf_setfont",
    "pdf_setgray",
    "pdf_setgray_fill",
    "pdf_setgray_stroke",
    "pdf_set_horiz_scaling",
    "pdf_set_info",
    "pdf_set_info_author",
    "pdf_set_info_creator",
    "pdf_set_info_keywords",
    "pdf_set_info_subject",
    "pdf_set_info_title",
    "pdf_set_leading",
    "pdf_setlinecap",
    "pdf_setlinejoin",
    "pdf_setlinewidth",
    "pdf_setmatrix",
    "pdf_setmiterlimit",
    "pdf_set_parameter",
    "pdf_setpolydash",
    "pdf_setrgbcolor",
    "pdf_setrgbcolor_fill",
    "pdf_setrgbcolor_stroke",
    "pdf_set_text_matrix",
    "pdf_set_text_pos",
    "pdf_set_text_rendering",
    "pdf_set_text_rise",
    "pdf_set_value",
    "pdf_set_word_spacing",
    "pdf_show",
    "pdf_show_boxed",
    "pdf_show_xy",
    "pdf_skew",
    "pdf_stringwidth",
    "pdf_stroke",
    "pdf_translate",
    "PEAR_EXTENSION_DIR",
    "PEAR_INSTALL_DIR",
    "pfpro_cleanup",
    "pfpro_init",
    "pfpro_process",
    "pfpro_process_raw",
    "pfpro_version",
    "pfsockopen",
    "pg_affected_rows",
    "pg_cancel_query",
    "pg_client_encoding",
    "pg_close",
    "pg_connect",
    "pg_connection_busy",
    "pg_connection_reset",
    "pg_connection_status",
    "pg_convert",
    "pg_copy_from",
    "pg_copy_to",
    "pg_dbname",
    "pg_delete",
    "pg_end_copy",
    "pg_escape_bytea",
    "pg_escape_string",
    "pg_fetch_all",
    "pg_fetch_array",
    "pg_fetch_assoc",
    "pg_fetch_object",
    "pg_fetch_result",
    "pg_fetch_row",
    "pg_field_is_null",
    "pg_field_name",
    "pg_field_num",
    "pg_field_prtlen",
    "pg_field_size",
    "pg_field_type",
    "pg_free_result",
    "pg_get_notify",
    "pg_get_pid",
    "pg_get_result",
    "pg_host",
    "pg_insert",
    "pg_last_error",
    "pg_last_notice",
    "pg_last_oid",
    "pg_lo_close",
    "pg_lo_create",
    "pg_lo_export",
    "pg_lo_import",
    "pg_lo_open",
    "pg_lo_read",
    "pg_lo_read_all",
    "pg_lo_seek",
    "pg_lo_tell",
    "pg_lo_unlink",
    "pg_lo_write",
    "pg_meta_data",
    "pg_num_fields",
    "pg_num_rows",
    "pg_options",
    "pg_pconnect",
    "pg_ping",
    "pg_port",
    "pg_put_line",
    "pg_query",
    "pg_result_error",
    "pg_result_seek",
    "pg_result_status",
    "pg_select",
    "pg_send_query",
    "pg_set_client_encoding",
    "pg_trace",
    "pg_tty",
    "pg_unescape_bytea",
    "pg_untrace",
    "pg_update",
    "PHP_BINDIR",
    "PHP_CONFIG_FILE_PATH",
    "phpcredits",
    "PHP_DATADIR",
    "PHP_ERRMSG",
    "PHP_EXTENSION_DIR",
    "phpinfo",
    "php_ini_scanned_files",
    "PHP_LIBDIR",
    "PHP_LOCALSTATEDIR",
    "php_logo_guid",
    "PHP_OS",
    "PHP_OUTPUT_HANDLER_CONT",
    "PHP_OUTPUT_HANDLER_END",
    "PHP_OUTPUT_HANDLER_START",
    "php_sapi_name",
    "PHP_SELF",
    "PHP_SYSCONFDIR",
    "php_uname",
    "phpversion",
    "PHP_VERSION",
    "pi",
    "png2wbmp",
    "popen",
    "pos",
    "posix_ctermid",
    "posix_getcwd",
    "posix_getegid",
    "posix_geteuid",
    "posix_getgid",
    "posix_getgrgid",
    "posix_getgrnam",
    "posix_getgroups",
    "posix_getlogin",
    "posix_getpgid",
    "posix_getpgrp",
    "posix_getpid",
    "posix_getppid",
    "posix_getpwnam",
    "posix_getpwuid",
    "posix_getrlimit",
    "posix_getsid",
    "posix_getuid",
    "posix_isatty",
    "posix_kill",
    "posix_mkfifo",
    "posix_setegid",
    "posix_seteuid",
    "posix_setgid",
    "posix_setpgid",
    "posix_setsid",
    "posix_setuid",
    "posix_times",
    "posix_ttyname",
    "posix_uname",
    "_POST",
    "pow",
    "prefix",
    "preg_grep",
    "preg_match",
    "preg_match_all",
    "preg_quote",
    "preg_replace",
    "preg_replace_callback",
    "preg_split",
    "prev",
    "previous_sibling",
    "print",
    "printer_abort",
    "printer_close",
    "printer_create_brush",
    "printer_create_dc",
    "printer_create_font",
    "printer_create_pen",
    "printer_delete_brush",
    "printer_delete_dc",
    "printer_delete_font",
    "printer_delete_pen",
    "printer_draw_bmp",
    "printer_draw_chord",
    "printer_draw_elipse",
    "printer_draw_line",
    "printer_draw_pie",
    "printer_draw_rectangle",
    "printer_draw_roundrect",
    "printer_draw_text",
    "printer_end_doc",
    "printer_end_page",
    "printer_get_option",
    "printer_list",
    "printer_logical_fontheight",
    "printer_open",
    "printer_select_brush",
    "printer_select_font",
    "printer_select_pen",
    "printer_set_option",
    "printer_start_doc",
    "printer_start_page",
    "printer_write",
    "printf",
    "print_r",
    "private",
    "proc_close",
    "process",
    "proc_open",
    "protected",
    "pspell_add_to_personal",
    "pspell_add_to_session",
    "pspell_check",
    "pspell_clear_session",
    "pspell_config_create",
    "pspell_config_ignore",
    "pspell_config_mode",
    "pspell_config_personal",
    "pspell_config_repl",
    "pspell_config_runtogether",
    "pspell_config_save_repl",
    "pspell_new",
    "pspell_new_config",
    "pspell_new_personal",
    "pspell_save_wordlist",
    "pspell_store_replacement",
    "pspell_suggest",
    "public",
    "public_id",
    "putenv",
    "qdom_error",
    "qdom_tree",
    "QUERY_STRING",
    "quoted_printable_decode",
    "quotemeta",
    "rad2deg",
    "rand",
    "range",
    "rawurldecode",
    "rawurlencode",
    "read",
    "readdir",
    "read_exif_data",
    "readfile",
    "readgzfile",
    "readline",
    "readline_add_history",
    "readline_clear_history",
    "readline_completion_function",
    "readline_info",
    "readline_list_history",
    "readline_read_history",
    "readline_write_history",
    "readlink",
    "realpath",
    "reason",
    "recode",
    "recode_file",
    "recode_string",
    "register_shutdown_function",
    "register_tick_function",
    "REMOTE_ADDR",
    "REMOTE_PORT",
    "remove",
    "remove_attribute",
    "remove_child",
    "rename",
    "replace",
    "replace_child",
    "replace_node",
    "_REQUEST",
    "REQUEST_METHOD",
    "REQUEST_URI",
    "require",
    "require_once",
    "reset",
    "restore_error_handler",
    "restore_include_path",
    "result_dump_file",
    "result_dump_mem",
    "return",
    "rewind",
    "rewinddir",
    "rmdir",
    "Rotate",
    "rotateTo",
    "round",
    "rsort",
    "rtrim",
    "save",
    "scale",
    "scaleTo",
    "SCRIPT_FILENAME",
    "SCRIPT_NAME",
    "sem_acquire",
    "sem_get",
    "sem_release",
    "sem_remove",
    "serialize",
    "_SERVER",
    "SERVER_ADMIN",
    "SERVER_NAME",
    "SERVER_PORT",
    "SERVER_PROTOCOL",
    "SERVER_SIGNATURE",
    "SERVER_SOFTWARE",
    "sesam_affected_rows",
    "sesam_commit",
    "sesam_connect",
    "sesam_diagnostic",
    "sesam_disconnect",
    "sesam_errormsg",
    "sesam_execimm",
    "sesam_fetch_array",
    "sesam_fetch_result",
    "sesam_fetch_row",
    "sesam_field_array",
    "sesam_field_name",
    "sesam_free_result",
    "sesam_num_fields",
    "sesam_query",
    "sesam_rollback",
    "sesam_seek_row",
    "sesam_settransaction",
    "_SESSION",
    "session_cache_expire",
    "session_cache_limiter",
    "session_decode",
    "session_destroy",
    "session_encode",
    "session_get_cookie_params",
    "session_id",
    "session_is_registered",
    "session_module_name",
    "session_name",
    "session_readonly",
    "session_register",
    "session_save_path",
    "session_set_cookie_params",
    "session_set_save_handler",
    "session_start",
    "session_unregister",
    "session_unset",
    "session_write_close",
    "setAction",
    "set_attribute",
    "setbackground",
    "setbounds",
    "setcolor",
    "setColor",
    "setcommitedversion",
    "set_content",
    "setcookie",
    "setDepth",
    "setdimension",
    "setdown",
    "set_error_handler",
    "set_file_buffer",
    "setFont",
    "setframes",
    "setHeight",
    "setHit",
    "set_include_path",
    "setindentation",
    "setLeftFill",
    "setLeftMargin",
    "setLine",
    "setLineSpacing",
    "setlocale",
    "set_magic_quotes_runtime",
    "setMargins",
    "set_name",
    "setname",
    "setName",
    "set_namespace",
    "setOver",
    "setrate",
    "setRatio",
    "setRightFill",
    "setrightMargin",
    "setSpacing",
    "set_time_limit",
    "settype",
    "setUp",
    "sha1",
    "sha1_file",
    "shell_exec",
    "shm_attach",
    "shm_detach",
    "shm_get_var",
    "shmop_close",
    "shmop_delete",
    "shmop_open",
    "shmop_read",
    "shmop_size",
    "shmop_write",
    "shm_put_var",
    "shm_remove",
    "shm_remove_var",
    "show_source",
    "shuffle",
    "similar_text",
    "sin",
    "sinh",
    "sizeof",
    "skewX",
    "skewXTo",
    "skewY",
    "skewYTo",
    "sleep",
    "snmpget",
    "snmp_get_quick_print",
    "snmprealwalk",
    "snmpset",
    "snmp_set_quick_print",
    "snmpwalk",
    "snmpwalkoid",
    "socket_accept",
    "socket_bind",
    "socket_clear_error",
    "socket_close",
    "socket_connect",
    "socket_create",
    "socket_create_listen",
    "socket_create_pair",
    "socket_get_option",
    "socket_getpeername",
    "socket_getsockname",
    "socket_get_status",
    "socket_iovec_add",
    "socket_iovec_alloc",
    "socket_iovec_delete",
    "socket_iovec_fetch",
    "socket_iovec_free",
    "socket_iovec_set",
    "socket_last_error",
    "socket_listen",
    "socket_read",
    "socket_readv",
    "socket_recv",
    "socket_recvfrom",
    "socket_recvmsg",
    "socket_select",
    "socket_send",
    "socket_sendmsg",
    "socket_sendto",
    "socket_set_blocking",
    "socket_set_nonblock",
    "socket_set_option",
    "socket_set_timeout",
    "socket_shutdown",
    "socket_strerror",
    "socket_write",
    "socket_writev",
    "sort",
    "soundex",
    "specified",
    "split",
    "spliti",
    "sprintf",
    "sql_regcase",
    "sqrt",
    "srand",
    "srcanchors",
    "srcsofdst",
    "sscanf",
    "stat",
    "static",
    "stdClass",
    "strcasecmp",
    "strchr",
    "strcmp",
    "strcoll",
    "strcspn",
    "stream_context_create",
    "stream_context_get_options",
    "stream_context_set_option",
    "stream_context_set_params",
    "stream_filter_append",
    "stream_filter_prepend",
    "stream_get_filters",
    "stream_get_meta_data",
    "stream_get_wrappers",
    "streammp3",
    "stream_register_filter",
    "stream_register_wrapper",
    "stream_select",
    "stream_set_blocking",
    "stream_set_timeout",
    "stream_set_write_buffer",
    "strftime",
    "stripcslashes",
    "stripslashes",
    "strip_tags",
    "stristr",
    "strlen",
    "strnatcasecmp",
    "strnatcmp",
    "strncasecmp",
    "strncmp",
    "str_pad",
    "strpos",
    "strrchr",
    "str_repeat",
    "str_replace",
    "strrev",
    "str_rot13",
    "strrpos",
    "str_shuffle",
    "strspn",
    "strstr",
    "strtok",
    "strtolower",
    "strtotime",
    "strtoupper",
    "strtr",
    "strval",
    "str_word_count",
    "substr",
    "substr_count",
    "substr_replace",
    "SWFAction",
    "swf_actiongeturl",
    "swf_actiongotoframe",
    "swf_actiongotolabel",
    "swf_actionnextframe",
    "swf_actionplay",
    "swf_actionprevframe",
    "swf_actionsettarget",
    "swf_actionstop",
    "swf_actiontogglequality",
    "swf_actionwaitforframe",
    "swf_addbuttonrecord",
    "swf_addcolor",
    "SWFBitmap",
    "SWFbutton",
    "swfbutton_keypress",
    "swf_closefile",
    "swf_definebitmap",
    "swf_definefont",
    "swf_defineline",
    "swf_definepoly",
    "swf_definerect",
    "swf_definetext",
    "SWFDisplayItem",
    "swf_endbutton",
    "swf_enddoaction",
    "swf_endshape",
    "swf_endsymbol",
    "SWFFill",
    "SWFFont",
    "swf_fontsize",
    "swf_fontslant",
    "swf_fonttracking",
    "swf_getbitmapinfo",
    "swf_getfontinfo",
    "swf_getframe",
    "SWFGradient",
    "swf_labelframe",
    "swf_lookat",
    "swf_modifyobject",
    "SWFMorph",
    "SWFMovie",
    "swf_mulcolor",
    "swf_nextid",
    "swf_oncondition",
    "swf_openfile",
    "swf_ortho",
    "swf_ortho2",
    "swf_perspective",
    "swf_placeobject",
    "swf_polarview",
    "swf_popmatrix",
    "swf_posround",
    "swf_pushmatrix",
    "swf_removeobject",
    "swf_rotate",
    "swf_scale",
    "swf_setfont",
    "swf_setframe",
    "SWFShape",
    "swf_shapearc",
    "swf_shapecurveto",
    "swf_shapecurveto3",
    "swf_shapefillbitmapclip",
    "swf_shapefillbitmaptile",
    "swf_shapefilloff",
    "swf_shapefillsolid",
    "swf_shapelinesolid",
    "swf_shapelineto",
    "swf_shapemoveto",
    "swf_showframe",
    "SWFSprite",
    "swf_startbutton",
    "swf_startdoaction",
    "swf_startshape",
    "swf_startsymbol",
    "SWFText",
    "SWFTextField",
    "swf_textwidth",
    "swf_translate",
    "swf_viewport",
    "switch",
    "sybase_affected_rows",
    "sybase_close",
    "sybase_connect",
    "sybase_data_seek",
    "sybase_fetch_array",
    "sybase_fetch_field",
    "sybase_fetch_object",
    "sybase_fetch_row",
    "sybase_field_seek",
    "sybase_free_result",
    "sybase_get_last_message",
    "sybase_min_client_severity",
    "sybase_min_error_severity",
    "sybase_min_message_severity",
    "sybase_min_server_severity",
    "sybase_num_fields",
    "sybase_num_rows",
    "sybase_pconnect",
    "sybase_query",
    "sybase_result",
    "sybase_select_db",
    "symlink",
    "syslog",
    "system",
    "system_id",
    "tagname",
    "tan",
    "tanh",
    "target",
    "tempnam",
    "textdomain",
    "time",
    "title",
    "tmpfile",
    "token_get_all",
    "token_name",
    "touch",
    "trigger_error",
    "trim",
    "TRUE",
    "type",
    "uasort",
    "ucfirst",
    "ucwords",
    "udm_add_search_limit",
    "udm_alloc_agent",
    "udm_api_version",
    "udm_cat_list",
    "udm_cat_path",
    "udm_check_charset",
    "udm_check_stored",
    "udm_clear_search_limits",
    "udm_close_stored",
    "udm_crc32",
    "udm_errno",
    "udm_error",
    "udm_find",
    "udm_free_agent",
    "udm_free_ispell_data",
    "udm_free_res",
    "udm_get_doc_count",
    "udm_get_res_field",
    "udm_get_res_param",
    "udm_load_ispell_data",
    "udm_open_stored",
    "udm_set_agent_param",
    "uksort",
    "umask",
    "uniqid",
    "unixtojd",
    "unlink",
    "unlink_node",
    "unlock",
    "unpack",
    "unregister_tick_function",
    "unserialize",
    "unset",
    "urldecode",
    "urlencode",
    "user",
    "user_error",
    "userlist",
    "usleep",
    "usort",
    "utf8_decode",
    "utf8_encode",
    "value",
    "values",
    "var",
    "var_dump",
    "var_export",
    "version_compare",
    "virtual",
    "vpopmail_add_alias_domain",
    "vpopmail_add_alias_domain_ex",
    "vpopmail_add_domain",
    "vpopmail_add_domain_ex",
    "vpopmail_add_user",
    "vpopmail_alias_add",
    "vpopmail_alias_del",
    "vpopmail_alias_del_domain",
    "vpopmail_alias_get",
    "vpopmail_alias_get_all",
    "vpopmail_auth_user",
    "vpopmail_del_domain",
    "vpopmail_del_domain_ex",
    "vpopmail_del_user",
    "vpopmail_error",
    "vpopmail_passwd",
    "vpopmail_set_user_quota",
    "vprintf",
    "vsprintf",
    "w32api_deftype",
    "w32api_init_dtype",
    "w32api_invoke_function",
    "w32api_register_function",
    "w32api_set_call_method",
    "wddx_add_vars",
    "wddx_deserialize",
    "wddx_packet_end",
    "wddx_packet_start",
    "wddx_serialize_value",
    "wddx_serialize_vars",
    "while",
    "wordwrap",
    "xinclude",
    "xml_error_string",
    "xml_get_current_byte_index",
    "xml_get_current_column_number",
    "xml_get_current_line_number",
    "xml_get_error_code",
    "xml_parse",
    "xml_parse_into_struct",
    "xml_parser_create",
    "xml_parser_create_ns",
    "xml_parser_free",
    "xml_parser_get_option",
    "xml_parser_set_option",
    "xmlrpc_decode",
    "xmlrpc_decode_request",
    "xmlrpc_encode",
    "xmlrpc_encode_request",
    "xmlrpc_get_type",
    "xmlrpc_parse_method_descriptions",
    "xmlrpc_server_add_introspection_data",
    "xmlrpc_server_call_method",
    "xmlrpc_server_create",
    "xmlrpc_server_destroy",
    "xmlrpc_server_register_introspection_callback",
    "xmlrpc_server_register_method",
    "xmlrpc_set_type",
    "xml_set_character_data_handler",
    "xml_set_default_handler",
    "xml_set_element_handler",
    "xml_set_end_namespace_decl_handler",
    "xml_set_external_entity_ref_handler",
    "xml_set_notation_decl_handler",
    "xml_set_object",
    "xml_set_processing_instruction_handler",
    "xml_set_start_namespace_decl_handler",
    "xml_set_unparsed_entity_decl_handler",
    "xpath_eval",
    "xpath_eval_expression",
    "xpath_new_context",
    "xptr_eval",
    "xptr_new_context",
    "xslt_create",
    "xslt_errno",
    "xslt_error",
    "xslt_free",
    "xslt_output_process",
    "xslt_set_base",
    "xslt_set_encoding",
    "xslt_set_error_handler",
    "xslt_set_log",
    "xslt_set_sax_handler",
    "xslt_set_sax_handlers",
    "xslt_set_scheme_handler",
    "xslt_set_scheme_handlers",
    "yaz_addinfo",
    "yaz_ccl_conf",
    "yaz_ccl_parse",
    "yaz_close",
    "yaz_connect",
    "yaz_database",
    "yaz_element",
    "yaz_errno",
    "yaz_error",
    "yaz_get_option",
    "yaz_hits",
    "yaz_itemorder",
    "yaz_present",
    "yaz_range",
    "yaz_record",
    "yaz_scan",
    "yaz_scan_result",
    "yaz_schema",
    "yaz_search",
    "yaz_set_option",
    "yaz_sort",
    "yaz_syntax",
    "yaz_wait",
    "yp_all",
    "yp_cat",
    "yp_errno",
    "yp_err_string",
    "yp_first",
    "yp_get_default_domain",
    "yp_master",
    "yp_match",
    "yp_next",
    "yp_order",
    "zend_logo_guid",
    "zend_version",
    "zend_version",
    "zip_close",
    "zip_entry_close",
    "zip_entry_compressedsize",
    "zip_entry_compressionmethod",
    "zip_entry_filesize",
    "zip_entry_name",
    "zip_entry_open",
    "zip_entry_read",
    "zip_open",
    "zip_read",
    0
};

PhpWriter::PhpWriter()
{
}

PhpWriter::~PhpWriter()
{
}

/**
 * Call this method to generate Php code for a UMLClassifier.
 * @param c   the class you want to generate code for.
 */
void PhpWriter::writeClass(UMLClassifier *c)
{
    if (!c) {
        uDebug() << "Cannot write class of NULL concept!";
        return;
    }

    QString classname = cleanName(c->name());
    //find an appropriate name for our file
    QString fileName = findFileName(c, QLatin1String(".php"));
    if (fileName.isEmpty()) {
        emit codeGenerated(c, false);
        return;
    }

    QFile filephp;
    if (!openFile(filephp, fileName)) {
        emit codeGenerated(c, false);
        return;
    }
    QTextStream php(&filephp);

    //////////////////////////////
    //Start generating the code!!
    /////////////////////////////

    //try to find a heading file (license, coments, etc)
    QString str;
    str = getHeadingFile(QLatin1String(".php"));
    if (!str.isEmpty()) {
        str.replace(QRegExp(QLatin1String("%filename%")), fileName);
        str.replace(QRegExp(QLatin1String("%filepath%")), filephp.fileName());
        php << str << m_endl;
    }

    //write includes
    UMLPackageList includes;
    findObjectsRelated(c, includes);

    foreach(UMLPackage* conc, includes) {
        QString headerName = findFileName(conc, QLatin1String(".php"));
        if (headerName.isEmpty()) {
            php << "include '" << headerName << "';" << m_endl;
        }
    }
    php << m_endl;

    //Write class Documentation if there is somthing or if force option
    if (forceDoc() || !c->doc().isEmpty()) {
        php << m_endl << "/**" << m_endl;
        php << " * class " << classname << m_endl;
        php << formatDoc(c->doc(), QLatin1String(" * "));
        php << " */" << m_endl ;
    }

    UMLClassifierList superclasses = c->getSuperClasses();
    UMLAssociationList aggregations = c->getAggregations();
    UMLAssociationList compositions = c->getCompositions();

    //check if class is abstract and / or has abstract methods
    //FG        if(c->getAbstract() && !hasAbstractOps(c))
    if (c->isAbstract())
        php << "/******************************* Abstract Class ****************************" << m_endl << "  "
            << classname << " does not have any pure virtual methods, but its author" << m_endl
            << "  defined it as an abstract class, so you should not use it directly." << m_endl
            << "  Inherit from it instead and create only objects from the derived classes" << m_endl
            << "*****************************************************************************/" << m_endl << m_endl;

    php << "class " << classname << (superclasses.count() > 0 ? QLatin1String(" extends ") : QString());
    foreach (UMLClassifier *obj, superclasses) {
        php << cleanName(obj->name());
    }
    php << m_endl << "{" << m_endl;

    //associations
    if (forceSections() || !aggregations.isEmpty()) {
        php <<  m_endl << m_indentation << "/** Aggregations: */" << m_endl;
        foreach (UMLAssociation* a, aggregations) {
            php <<  m_endl;
            //maybe we should parse the string here and take multiplicity into account to decide
            //which container to use.
            //:UNUSED: UMLObject *o = a->getObject(Uml::RoleType::A);
            //:UNUSED: QString typeName = cleanName(o->name());
            if (a->getMultiplicity(Uml::RoleType::A).isEmpty())  {
                php << m_indentation << "var $m_" << ";" << m_endl;
            } else {
                php << m_indentation << "var $m_" << "Vector = array();" << m_endl;
            }
        }//end for
    }

    if (forceSections() || !compositions.isEmpty()) {
        php <<  m_endl << m_indentation << "/** Compositions: */" << m_endl;
        foreach (UMLAssociation* a, compositions) {
            // see comment on Aggregation about multiplicity...
            //:UNUSED: UMLObject *o = a->getObject(Uml::RoleType::A);
            //:UNUSED: QString typeName = cleanName(o->name());
            if (a->getMultiplicity(Uml::RoleType::A).isEmpty())  {
                php << m_indentation << "var $m_" << ";" << m_endl;
            } else {
                php << m_indentation << "var $m_" << "Vector = array();" << m_endl;
            }
        }
    }

    const bool isClass = !c->isInterface();

    //attributes
    if (isClass)
        writeAttributes(c, php);

    //operations
    writeOperations(c, php);

    if (isClass && hasDefaultValueAttr(c)) {
        UMLAttributeList atl = c->getAttributeList();
        php << m_endl;

        php << m_indentation << "/**" << m_endl;
        QString temp = QLatin1String("initAttributes sets all ") + classname + QLatin1String(" attributes to its default value.")
                     + QLatin1String(" Make sure to call this method within your class constructor");
        php << formatDoc(temp, m_indentation + QLatin1String(" * "));
        php << m_indentation << " */" << m_endl;
        php << m_indentation << "function " << "initAttributes()" << m_endl;
        php << m_indentation << "{" << m_endl;
        foreach (UMLAttribute* at, atl)  {
            if (!at->getInitialValue().isEmpty())  {
                php << m_indentation << m_indentation << "$this->" << cleanName(at->name()) << " = " <<
                at->getInitialValue() << ";" << m_endl;
            }
        }
        php << m_indentation << "}" << m_endl;
    }

    php << m_endl;

    //finish file
    php <<  m_endl << "} // end of " << classname << m_endl;
    php << "?>" << m_endl;

    //close files and notfiy we are done
    filephp.close();
    emit codeGenerated(c, true);
    emit showGeneratedFile(filephp.fileName());
}

////////////////////////////////////////////////////////////////////////////////////
//  Helper Methods

/**
 * Write all operations for a given class.
 * @param c     the concept we are generating code for
 * @param php   output stream for the PHP file
 */
void PhpWriter::writeOperations(UMLClassifier *c, QTextStream &php)
{
    //Lists to store operations  sorted by scope
    UMLOperationList oppub, opprot, oppriv;

    //sort operations by scope first and see if there are abstract methods
    UMLOperationList opl(c->getOpList());
    foreach (UMLOperation *op, opl) {
        switch(op->visibility()) {
          case Uml::Visibility::Public:
            oppub.append(op);
            break;
          case Uml::Visibility::Protected:
            opprot.append(op);
            break;
          case Uml::Visibility::Private:
            oppriv.append(op);
            break;
          default:
            break;
        }
    }

    QString classname(cleanName(c->name()));

    //write operations to file
    if (forceSections() || !oppub.isEmpty()) {
        php << m_endl;
        writeOperations(classname, oppub, php);
    }

    if (forceSections() || !opprot.isEmpty()) {
        php << m_endl;
        writeOperations(classname, opprot, php);
    }

    if (forceSections() || !oppriv.isEmpty()) {
        php << m_endl;
        writeOperations(classname, oppriv, php);
    }
}

/**
 * Write a list of class operations.
 * @param classname   the name of the class
 * @param opList      the list of operations
 * @param php         output stream for the PHP file
 */
void PhpWriter::writeOperations(const QString& classname,
                                UMLOperationList &opList,
                                QTextStream &php)
{
    Q_UNUSED(classname);
    foreach (UMLOperation* op, opList) {
        UMLAttributeList atl = op->getParmList();
        //write method doc if we have doc || if at least one of the params has doc
        bool writeDoc = forceDoc() || !op->doc().isEmpty();
        foreach (UMLAttribute* at, atl)
            writeDoc |= !at->doc().isEmpty();

        if (writeDoc)  //write method documentation
        {
            php <<m_indentation << "/**" << m_endl <<formatDoc(op->doc(), m_indentation + QLatin1String(" * "));
            php << m_indentation << " *" << m_endl;

            foreach (UMLAttribute* at, atl)  //write parameter documentation
            {
                if (forceDoc() || !at->doc().isEmpty()) {
                    php << m_indentation << " * @param " << at->getTypeName() << " " << cleanName(at->name());
                    php << " " << formatDoc(at->doc(), QString());
                }
            }//end for : write parameter documentation
            php << m_indentation << " * @return " << op->getTypeName() << m_endl;
            if (op->isAbstract()) php << m_indentation << " * @abstract" << m_endl;
            if (op->isStatic()) php << m_indentation << " * @static" << m_endl;
            switch(op->visibility()) {
              case Uml::Visibility::Public:
                php << m_indentation << " * @access public" << m_endl;
                break;
              case Uml::Visibility::Protected:
                php << m_indentation << " * @access protected" << m_endl;
                break;
              case Uml::Visibility::Private:
                php << m_indentation << " * @access private" << m_endl;
                break;
              default:
                break;
            }
            php << m_indentation << " */" << m_endl;
        }//end if : write method documentation

        php <<  m_indentation << "function " << cleanName(op->name()) << "(";

        int i= atl.count();
        int j=0;
        foreach (UMLAttribute* at, atl) {
            php << " $" << cleanName(at->name())
                << (!(at->getInitialValue().isEmpty()) ?
                    QLatin1String(" = ") + at->getInitialValue() : QString())
                << ((j < i-1) ? QLatin1String(", ") : QString());
            j++;
        }
        php <<")" << m_endl;
        php << m_indentation << "{" << m_endl;
        QString sourceCode = op->getSourceCode();
        if (sourceCode.isEmpty()) {
            php << m_indentation << m_indentation << m_endl;
        }
        else {
            php << formatSourceCode(sourceCode, m_indentation + m_indentation);
        }
        php << m_indentation << "} // end of member function " << cleanName(op->name()) << m_endl;
        php << m_endl;
    }//end for
}

/**
 * Write all the attributes of a class.
 * @param c     the class we are generating code for
 * @param php   output stream for the PHP file
 */
void PhpWriter::writeAttributes(UMLClassifier *c, QTextStream &php)
{
    UMLAttributeList  atpub, atprot, atpriv, atdefval;

    //sort attributes by scope and see if they have a default value
    UMLAttributeList atl = c->getAttributeList();

    foreach (UMLAttribute* at, atl) {
        if (!at->getInitialValue().isEmpty())
            atdefval.append(at);
        switch(at->visibility()) {
          case Uml::Visibility::Public:
            atpub.append(at);
            break;
          case Uml::Visibility::Protected:
            atprot.append(at);
            break;
          case Uml::Visibility::Private:
            atpriv.append(at);
            break;
          default:
            break;
        }
    }

    if (forceSections() || atl.count())
        php <<  m_endl << m_indentation << " /*** Attributes: ***/" << m_endl << m_endl;

    if (forceSections() || atpub.count()) {
        writeAttributes(atpub, php);
    }

    if (forceSections() || atprot.count()) {
        writeAttributes(atprot, php);
    }

    if (forceSections() || atpriv.count()) {
        writeAttributes(atpriv, php);
    }
}

/**
 * Write a list of class attributes.
 * @param atList   the list of attributes
 * @param php      output stream for the PHP file
 */
void PhpWriter::writeAttributes(UMLAttributeList &atList, QTextStream &php)
{
    foreach (UMLAttribute *at, atList) {
        if (forceDoc() || !at->doc().isEmpty()) {
            php << m_indentation << "/**" << m_endl << formatDoc(at->doc(), m_indentation + QLatin1String(" * "));
            switch(at->visibility()) {
              case Uml::Visibility::Public:
                php << m_indentation << " * @access public" << m_endl;
                break;
              case Uml::Visibility::Protected:
                php << m_indentation << " * @access protected" << m_endl;
                break;
              case Uml::Visibility::Private:
                php << m_indentation << " * @access private" << m_endl;
                break;
              default:
                break;
            }

            php << m_indentation << " */" << m_endl;
        }
        php << m_indentation << "var " << "$" << cleanName(at->name()) << ";" << m_endl;

    } // end for
    return;
}

/**
 * Returns "PHP".
 * @return   the programming language identifier
 */
Uml::ProgrammingLanguage::Enum PhpWriter::language() const
{
    return Uml::ProgrammingLanguage::PHP;
}

/**
 * Get list of reserved keywords.
 * @return   the list of reserved keywords
 */
QStringList PhpWriter::reservedKeywords() const
{
    static QStringList keywords;

    if (keywords.isEmpty()) {
        for (int i = 0; reserved_words[i]; ++i)
            keywords.append(QLatin1String(reserved_words[i]));
    }

    return keywords;
}


