/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003-2006 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmpluginsettings.h"

#include "pmpluginmanager.h"

#include <qlayout.h>
#include <q3groupbox.h>
#include <q3listview.h>
#include <qpushbutton.h>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QList>
#include <klocale.h>

class PMPluginListViewItem : public Q3ListViewItem
{
public:
   PMPluginListViewItem( Q3ListView* parent, PMPluginInfo* info )
         : Q3ListViewItem( parent, info->name( ), info->description( ) )
   {
      m_info = info;
      m_enabled = info->enabled( );
      setStatus( );
   }
   void toggleStatus( )
   {
      m_enabled = !m_enabled;
      setStatus( );
   }
   void setStatus( )
   {
      if( m_enabled )
         setText( 2, i18n( "loaded" ) );
      else
         setText( 2, i18n( "deactivated" ) );
   }
   PMPluginInfo* m_info;
   bool m_enabled;
};

PMPluginSettings::PMPluginSettings( QWidget* parent )
      : PMSettingsDialogPage( parent )
{
   QVBoxLayout* vlayout = new QVBoxLayout( this );
   vlayout->setSpacing( KDialog::spacingHint( ) );
   vlayout->setMargin( 0 );

   Q3GroupBox* gb = new Q3GroupBox( i18n( "Installed Plugins" ), this );
   vlayout->addWidget( gb );

   QVBoxLayout* gvl = new QVBoxLayout( gb );
   gvl->setSpacing( KDialog::spacingHint( ) );
   gvl->setMargin( KDialog::marginHint( ) );
   gvl->addSpacing( 10 );

   m_pPluginsList = new Q3ListView( gb );
   connect( m_pPluginsList, SIGNAL( selectionChanged( ) ),
            SLOT( slotSelectionChanged( ) ) );
   m_pPluginsList->addColumn( i18n( "Name" ) );
   m_pPluginsList->addColumn( i18n( "Description" ) );
   m_pPluginsList->addColumn( i18n( "Status" ) );
   gvl->addWidget( m_pPluginsList, 1 );

   QHBoxLayout* hl = new QHBoxLayout( );
   gvl->addLayout( hl );
   m_pToggle = new QPushButton( i18n( "Load" ), gb );
   m_pToggle->setEnabled( false );
   connect( m_pToggle, SIGNAL( clicked( ) ), SLOT( slotToggle( ) ) );
   hl->addWidget( m_pToggle );
   hl->addStretch( 1 );

   vlayout->addStretch( 1 );
}

void PMPluginSettings::displaySettings( )
{
   QList<PMPluginInfo*> plugins = PMPluginManager::theManager( )->plugins( );
   QList<PMPluginInfo*>::const_iterator it;

   m_pPluginsList->clear( );
   for(it = plugins.constBegin( ); it != plugins.constEnd( ); ++it )
      new PMPluginListViewItem( m_pPluginsList, *it );
}

void PMPluginSettings::applySettings( )
{
   bool changes = false;
   PMPluginListViewItem* item =
      ( PMPluginListViewItem* ) m_pPluginsList->firstChild( );
   for( ; item; item = ( PMPluginListViewItem* ) item->nextSibling( ) )
   {
      if( item->m_enabled != item->m_info->enabled( ) )
      {
         item->m_info->enable( item->m_enabled );
         changes = true;
      }
   }
   if( changes )
      PMPluginManager::theManager( )->updatePlugins( );
}

bool PMPluginSettings::validateData( )
{
   return true;
}

void PMPluginSettings::displayDefaults( )
{
}

void PMPluginSettings::slotToggle( )
{
   PMPluginListViewItem* item =
      ( PMPluginListViewItem* ) m_pPluginsList->currentItem( );
   if( item )
   {
      item->toggleStatus( );
   
      if( item->m_enabled )
         m_pToggle->setText( i18n( "Deactivate" ) );
      else
         m_pToggle->setText( i18n( "Load" ) );
   }
}

void PMPluginSettings::slotSelectionChanged( )
{
   PMPluginListViewItem* item =
      ( PMPluginListViewItem* ) m_pPluginsList->currentItem( );
   if( item )
   {
      m_pToggle->setEnabled( true );
      if( item->m_enabled )
         m_pToggle->setText( i18n( "Deactivate" ) );
      else
         m_pToggle->setText( i18n( "Load" ) );
   }
   else
      m_pToggle->setEnabled( false );
}

#include "pmpluginsettings.moc"
