//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  The base class for configuration modules.
    ///  Configuration modules are realized as plugins that are loaded only when
    ///  needed.
    ///  The module in principle is a simple widget displaying the
    ///  item to be changed. The module has a very small interface.
    ///  All the necessary glue logic and the GUI bells and whistles
    ///  are provided by the control center and must not concern
    ///  the module author.
    ///  To write a config module, you have to create a library
    ///  that contains at one factory function like this:
    ///  <pre>
    ///  #include <kgenericfactory.h>
    ///  typedef KGenericFactory<YourKCModule, QWidget> YourKCModuleFactory;
    ///  K_EXPORT_COMPONENT_FACTORY( yourLibName, YourKCModuleFactory("name_of_the_po_file") );
    ///  </pre>
    ///  The parameter "name_of_the_po_file" has to correspond with the messages target
    ///  that you created in your Makefile.am. Instead of using the library name for
    ///  <pre>yourLibName</pre> you can also use another name which you specify in the desktop
    ///  file with <pre>X</pre>-KDE-FactoryName. This is useful to have more than one factory
    ///  in one lib.
    ///  The constructor of the KCModule then looks like this:
    ///  <pre>
    ///  YourKCModule.YourKCModule( QWidget parent ), parent )
    ///  {
    ///    KAboutData about = new KAboutData(
    ///      <kcm name>, 0, ki18n( "..." ),
    ///      KDE_VERSION_STRING, KLocalizedString(), KAboutData.License_GPL,
    ///      ki18n( "Copyright 2006 ..." ) );
    ///    about.AddAuthor( ki18n(...) );
    ///    setAboutData( about );
    ///    .
    ///    .
    ///    .
    ///  }
    ///  </pre>
    ///  If you want to make the KCModule available only conditionally (i.e. show in
    ///  the list of available modules only if some test succeeds) then you can use
    ///  Hidden in the .desktop file. An example:
    ///  <pre>
    ///  Hidden[$e]=$(if test -e /dev/js; then echo "false"; else echo "true"; fi)
    ///  </pre>
    ///  The example executes the given code in a shell and uses the stdout output for
    ///  the Hidden value (so it's either Hidden=true or Hidden=false).
    ///  See http://developer.kde.org/documentation/other/kcm_howto.html
    ///  for more detailed documentation.
    ///  See <see cref="IKCModuleSignals"></see> for signals emitted by KCModule
    /// </remarks>        <author> Matthias Hoelzer-Kluepfel <hoelzer@kde.org>
    ///  </author>
    ///         <short>    The base class for configuration modules.</short>
    [SmokeClass("KCModule")]
    public class KCModule : QWidget, IDisposable {
        protected KCModule(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KCModule), this);
        }
        /// <remarks>
        ///  An enumeration type for the buttons used by this module.
        ///  You should only use Help, Default and Apply. The rest is obsolete.
        ///  NoAdditionalButton can be used when we do not want have other button that Ok Cancel
        /// </remarks>        <short>    An enumeration type for the buttons used by this module.</short>
        ///         <see> KCModule.Buttons</see>
        ///         <see> @see</see>
        ///         <see> KCModule.SetButtons</see>
        public enum Button {
            NoAdditionalButton = 0,
            Help = 1,
            Default = 2,
            Apply = 4,
        }
        /// <remarks>
        ///  Base class for all KControlModules.
        ///  @note do not emit changed signals here, since they are not yet connected
        ///        to any slot.
        ///    </remarks>        <short>    Base class for all KControlModules.</short>
        public KCModule(KComponentData componentData, QWidget parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModule##?", "KCModule(const KComponentData&, QWidget*, const QList<QVariant>&)", typeof(void), typeof(KComponentData), componentData, typeof(QWidget), parent, typeof(List<QVariant>), args);
        }
        public KCModule(KComponentData componentData, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModule##", "KCModule(const KComponentData&, QWidget*)", typeof(void), typeof(KComponentData), componentData, typeof(QWidget), parent);
        }
        public KCModule(KComponentData componentData) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModule#", "KCModule(const KComponentData&)", typeof(void), typeof(KComponentData), componentData);
        }
        /// <remarks>
        ///  Return a quick-help text.
        ///  This method is called when the module is docked.
        ///  The quick-help text should contain a short description of the module and
        ///  links to the module's help files. You can use QML formatting tags in the text.
        ///  @note make sure the quick help text gets translated (use i18n()).
        ///    </remarks>        <short>    Return a quick-help text.</short>
        [SmokeMethod("quickHelp() const")]
        public virtual string QuickHelp() {
            return (string) interceptor.Invoke("quickHelp", "quickHelp() const", typeof(string));
        }
        /// <remarks>
        ///  This is generally only called for the KBugReport.
        ///  If you override you should  have it return a pointer to a constant.
        /// </remarks>        <return> the KAboutData for this module
        ///    </return>
        ///         <short>    This is generally only called for the KBugReport.</short>
        [SmokeMethod("aboutData() const")]
        public virtual KAboutData AboutData() {
            return (KAboutData) interceptor.Invoke("aboutData", "aboutData() const", typeof(KAboutData));
        }
        /// <remarks>
        ///  This sets the KAboutData returned by aboutData()
        ///    </remarks>        <short>    This sets the KAboutData returned by aboutData()    </short>
        public void SetAboutData(KAboutData about) {
            interceptor.Invoke("setAboutData#", "setAboutData(const KAboutData*)", typeof(void), typeof(KAboutData), about);
        }
        /// <remarks>
        ///  Indicate which buttons will be used.
        ///  The return value is a value or'ed together from
        ///  the Button enumeration type.
        /// </remarks>        <short>    Indicate which buttons will be used.</short>
        ///         <see> KCModule.SetButtons</see>
        public uint Buttons() {
            return (uint) interceptor.Invoke("buttons", "buttons() const", typeof(uint));
        }
        /// <remarks>
        ///  Get the RootOnly message for this module.
        ///  When the module must be run as root, or acts differently
        ///  for root and a normal user, it is sometimes useful to
        ///  customize the message that appears at the top of the module
        ///  when used as a normal user. This function returns this
        ///  customized message. If none has been set, a default message
        ///  will be used.
        /// </remarks>        <short>    Get the RootOnly message for this module.</short>
        ///         <see> KCModule.SetRootOnlyMessage</see>
        public string RootOnlyMessage() {
            return (string) interceptor.Invoke("rootOnlyMessage", "rootOnlyMessage() const", typeof(string));
        }
        /// <remarks>
        ///  Tell if KControl should show a RootOnly message when run as
        ///  a normal user.
        ///  In some cases, the module don't want a RootOnly message to
        ///  appear (for example if it has already one). This function
        ///  tells KControl if a RootOnly message should be shown
        /// </remarks>        <short>    Tell if KControl should show a RootOnly message when run as  a normal user.</short>
        ///         <see> KCModule.SetUseRootOnlyMessage</see>
        public bool UseRootOnlyMessage() {
            return (bool) interceptor.Invoke("useRootOnlyMessage", "useRootOnlyMessage() const", typeof(bool));
        }
        public KComponentData ComponentData() {
            return (KComponentData) interceptor.Invoke("componentData", "componentData() const", typeof(KComponentData));
        }
        /// <remarks>
        /// </remarks>        <return> a list of @ref KConfigDialogManager's in use, if any.
        ///    </return>
        ///         <short>   </short>
        public List<KConfigDialogManager> Configs() {
            return (List<KConfigDialogManager>) interceptor.Invoke("configs", "configs() const", typeof(List<KConfigDialogManager>));
        }
        /// <remarks>
        ///  Load the configuration data into the module.
        ///  The load method sets the user interface elements of the
        ///  module to reflect the current settings stored in the
        ///  configuration files.
        ///  This method is invoked whenever the module should read its configuration
        ///  (most of the times from a config file) and update the user interface.
        ///  This happens when the user clicks the "Reset" button in the control
        ///  center, to undo all of his changes and restore the currently valid
        ///  settings. It is also called right after construction.
        ///    </remarks>        <short>    Load the configuration data into the module.</short>
        [Q_SLOT("void load()")]
        [SmokeMethod("load()")]
        public virtual void Load() {
            interceptor.Invoke("load", "load()", typeof(void));
        }
        /// <remarks>
        ///  Save the configuration data.
        ///  The save method stores the config information as shown
        ///  in the user interface in the config files.
        ///  If necessary, this method also updates the running system,
        ///  e.g. by restarting applications. This normally does not apply for
        ///  KSettings.Dialog modules where the updating is taken care of by
        ///  KSettings.Dispatcher.
        ///  save is called when the user clicks "Apply" or "Ok".
        ///  If you use KConfigXT, saving is taken care off automatically and
        ///  you do not need to load manually. However, if you for some reason reimplement it and
        ///  also are using KConfigXT, you must call this function, otherwise the saving of KConfigXT
        ///  options will not work. Call it at the very end of your reimplementation, to avoid
        ///  changed() signals getting emitted when you modify widgets.
        ///    </remarks>        <short>    Save the configuration data.</short>
        [Q_SLOT("void save()")]
        [SmokeMethod("save()")]
        public virtual void Save() {
            interceptor.Invoke("save", "save()", typeof(void));
        }
        /// <remarks>
        ///  Sets the configuration to sensible default values.
        ///  This method is called when the user clicks the "Default"
        ///  button. It should set the display to useful values.
        ///  If you use KConfigXT, you do not have to reimplement this function since
        ///  the fetching and settings of default values is done automatically. However, if you
        ///  reimplement and also are using KConfigXT, remember to call the base function at the
        ///  very end of your reimplementation.
        ///    </remarks>        <short>    Sets the configuration to sensible default values.</short>
        [Q_SLOT("void defaults()")]
        [SmokeMethod("defaults()")]
        public virtual void Defaults() {
            interceptor.Invoke("defaults", "defaults()", typeof(void));
        }
        /// <remarks>
        ///  Adds a KConfigskeleton <code>config</code> to watch the widget <code>widget</code>
        ///  This function is useful if you need to handle multiple configuration files.
        /// <param> name="config" the KConfigSkeleton to use
        /// </param><param> name="widget" the widget to watch
        ///    </param></remarks>        <return> a pointer to the KConfigDialogManager in use
        /// </return>
        ///         <short>    Adds a KConfigskeleton <code>config</code> to watch the widget <code>widget</code> </short>
        protected KConfigDialogManager AddConfig(KConfigSkeleton config, QWidget widget) {
            return (KConfigDialogManager) interceptor.Invoke("addConfig##", "addConfig(KConfigSkeleton*, QWidget*)", typeof(KConfigDialogManager), typeof(KConfigSkeleton), config, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Sets the quick help.
        ///    </remarks>        <short>    Sets the quick help.</short>
        protected void SetQuickHelp(string help) {
            interceptor.Invoke("setQuickHelp$", "setQuickHelp(const QString&)", typeof(void), typeof(string), help);
        }
        [SmokeMethod("showEvent(QShowEvent*)")]
        protected override void ShowEvent(QShowEvent ev) {
            interceptor.Invoke("showEvent#", "showEvent(QShowEvent*)", typeof(void), typeof(QShowEvent), ev);
        }
        /// <remarks>
        ///  Sets the buttons to display.
        ///  Help: shows a "Help" button.
        ///  Default: shows a "Use Defaults" button
        ///  Apply: in kcontrol this will show an "Apply" and "Reset" button
        ///         in kcmshell this will show an "Ok", "Apply" and "Cancel" button
        ///  If Apply is not specified, kcmshell will show a "Close" button.
        /// </remarks>        <short>    Sets the buttons to display.</short>
        ///         <see> KCModule.Buttons</see>
        protected void SetButtons(uint btn) {
            interceptor.Invoke("setButtons$", "setButtons(KCModule::Buttons)", typeof(void), typeof(uint), btn);
        }
        /// <remarks>
        ///  Sets the RootOnly message.
        ///  This message will be shown at the top of the module if useRootOnlyMessage is
        ///  set. If no message is set, a default one will be used.
        /// </remarks>        <short>    Sets the RootOnly message.</short>
        ///         <see> KCModule.RootOnlyMessage</see>
        protected void SetRootOnlyMessage(string message) {
            interceptor.Invoke("setRootOnlyMessage$", "setRootOnlyMessage(const QString&)", typeof(void), typeof(string), message);
        }
        /// <remarks>
        ///  Change whether or not the RootOnly message should be shown.
        ///  Following the value of <code>on</code>, the RootOnly message will be
        ///  shown or not.
        /// </remarks>        <short>    Change whether or not the RootOnly message should be shown.</short>
        ///         <see> KCModule.UseRootOnlyMessage</see>
        protected void SetUseRootOnlyMessage(bool on) {
            interceptor.Invoke("setUseRootOnlyMessage$", "setUseRootOnlyMessage(bool)", typeof(void), typeof(bool), on);
        }
        /// <remarks>
        ///  Returns the changed state of automatically managed widgets in this dialog
        ///    </remarks>        <short>    Returns the changed state of automatically managed widgets in this dialog    </short>
        protected bool ManagedWidgetChangeState() {
            return (bool) interceptor.Invoke("managedWidgetChangeState", "managedWidgetChangeState() const", typeof(bool));
        }
        /// <remarks>
        ///  Call this method when your manually managed widgets change state between
        ///  changed and not changed
        ///    </remarks>        <short>    Call this method when your manually managed widgets change state between  changed and not changed    </short>
        protected void UnmanagedWidgetChangeState(bool arg1) {
            interceptor.Invoke("unmanagedWidgetChangeState$", "unmanagedWidgetChangeState(bool)", typeof(void), typeof(bool), arg1);
        }
        /// <remarks>
        ///  Calling this slot is equivalent to emitting changed(true).
        ///    </remarks>        <short>    Calling this slot is equivalent to emitting changed(true).</short>
        [Q_SLOT("void changed()")]
        protected void Changed() {
            interceptor.Invoke("changed", "changed()", typeof(void));
        }
        /// <remarks>
        ///  A managed widget was changed, the widget settings and the current
        ///  settings are compared and a corresponding changed() signal is emitted
        ///    </remarks>        <short>    A managed widget was changed, the widget settings and the current  settings are compared and a corresponding changed() signal is emitted    </short>
        [Q_SLOT("void widgetChanged()")]
        protected void WidgetChanged() {
            interceptor.Invoke("widgetChanged", "widgetChanged()", typeof(void));
        }
        ~KCModule() {
            interceptor.Invoke("~KCModule", "~KCModule()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KCModule", "~KCModule()", typeof(void));
        }
        protected new IKCModuleSignals Emit {
            get { return (IKCModuleSignals) Q_EMIT; }
        }
    }

    public interface IKCModuleSignals : IQWidgetSignals {
        /// <remarks>
        ///  Indicate that the state of the modules contents has changed.
        ///  This signal is emitted whenever the state of the configuration
        ///  shown in the module changes. It allows the module container to
        ///  keep track of unsaved changes.
        ///    </remarks>        <short>    Indicate that the state of the modules contents has changed.</short>
        [Q_SIGNAL("void changed(bool)")]
        void Changed(bool state);
        /// <remarks>
        ///  Indicate that the module's quickhelp has changed.
        ///  Emit this signal whenever the module's quickhelp changes.
        ///  Modules implemented as tabbed dialogs might want to implement
        ///  per-tab quickhelp for example.
        ///    </remarks>        <short>    Indicate that the module's quickhelp has changed.</short>
        [Q_SIGNAL("void quickHelpChanged()")]
        void QuickHelpChanged();
    }
}
