/*  This file is part of the KDE project
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/
#ifndef ABSTRACTITEM_H
#define ABSTRACTITEM_H

#include <QVariant>

class AbstractItem
{
public:
    AbstractItem(AbstractItem *parent = 0);
    virtual ~AbstractItem();

    virtual QVariant data(int column, int datarole = Qt::DisplayRole) = 0;//Just for the model :P to not cast :P
    virtual bool isGroup() = 0;
    AbstractItem* parent() const;

private:
    class Private;
    Private *d;
};

#endif
