/*
    KMix -- KDE's full featured mini mixer
    Copyright (C) 2012  Christian Esken <esken@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


#ifndef GLOBALCONFIG_H
#define GLOBALCONFIG_H

#include <Qt>
#include <QSet>

class GlobalConfig
{
public:
   bool showTicks;
   bool showLabels;
   bool showOSD;
   Qt::Orientation toplevelOrientation;
   Qt::Orientation traypopupOrientation;
   void setMixersForSoundmenu(QSet<QString> mixersForSoundmenu) { this->mixersForSoundmenu = mixersForSoundmenu; };
   QSet<QString> getMixersForSoundmenu() { return mixersForSoundmenu; };

   static GlobalConfig& instance() { return instanceObj; };
   
   bool volumeOverdrive; // whether more than recommended volume (typically 0dB) is allowed

protected:
   QSet<QString> mixersForSoundmenu;

private:

  GlobalConfig()
  {
    showTicks = true;
    showLabels = true;
    showOSD = true;
    toplevelOrientation = Qt::Vertical;
    traypopupOrientation = Qt::Vertical;
    volumeOverdrive = false;
  };
  
  static GlobalConfig instanceObj;
};

#endif // GLOBALCONFIG_H
