//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import java.util.ArrayList;
import org.kde.qt.QVariant;

/**

 @brief Meta Information about a file
 This is the class for objects that hold meta information about a file.
 The information is kept in form of a system of key/value pairs. See also
 KFileMetaInfoItem.
 This information is retrieved from the file through a plugin system, and
 this class is the main interface to it.
 If you want to write your own plugin, have a look at KFilePlugin.
 There are basically two different kinds of meta information: Fixed ones
 that the plugin knows about (e.g. an mp3 id3v1 tag has a well defined
 fixed list of fields), and variable keys that exist in mimetypes that
 support their own key/value system (comments in png files are of this type).
 Almost every file has fixed keys, but some also have variable keys.
 The groups and the What enum are not yet supported, but already added to
 the interface so that adding support doesn't break compatibility.
 		@short    @brief Meta Information about a file

*/
public class KFileMetaInfo implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KFileMetaInfo(Class dummy){}

	/**	
		 This is used to specify what a KFileMetaInfo object should read, so
		 you can specify if you want to read "expensive" items or not.
		     		@short    This is used to specify what a KFileMetaInfo object should read, so  you can specify if you want to read "expensive" items or not.
	*/
	public static final int Fastest = 0x1;
	public static final int DontCare = 0x2;
	public static final int TechnicalInfo = 0x4;
	public static final int ContentInfo = 0x8;
	public static final int ExtenedAttr = 0x10;
	public static final int Thumbnail = 0x20;
	public static final int Preferred = 0x40;
	public static final int Everything = 0xffff;

	/**	
		 The constructor.
			 creating a KFileMetaInfo item through this will autoload the plugin
		 belonging to the mimetype and try to get meta information about
		 the specified file.
			 If no info is available, you'll get an empty (not invalid) object.
		 You can test for it with the isEmpty() method.
			@param path The file name. This must be the path to a local file.
			@param mimeType The name of the file's mimetype. If ommited, the
		         mimetype is autodetected
			@param what one or more of the What enum values. It gives some
		              hint to the plugin what information is desired. The plugin
		              may still return more items.
			 @note This version will <b></b>nly work for <b></b>ocal (file:/) files.
				@short    The constructor.
	*/
	public KFileMetaInfo(String path, String mimeType, int what) {
		newKFileMetaInfo(path,mimeType,what);
	}
	private native void newKFileMetaInfo(String path, String mimeType, int what);
	public KFileMetaInfo(String path, String mimeType) {
		newKFileMetaInfo(path,mimeType);
	}
	private native void newKFileMetaInfo(String path, String mimeType);
	public KFileMetaInfo(String path) {
		newKFileMetaInfo(path);
	}
	private native void newKFileMetaInfo(String path);
	/**	
		 Another constructor
			 Similar to the above, but takes a URL so that meta-data may be retrieved
		 over other protocols (ftp, etc.)
				@short    Another constructor
	*/
	public KFileMetaInfo(KURL url, String mimeType, int what) {
		newKFileMetaInfo(url,mimeType,what);
	}
	private native void newKFileMetaInfo(KURL url, String mimeType, int what);
	public KFileMetaInfo(KURL url, String mimeType) {
		newKFileMetaInfo(url,mimeType);
	}
	private native void newKFileMetaInfo(KURL url, String mimeType);
	public KFileMetaInfo(KURL url) {
		newKFileMetaInfo(url);
	}
	private native void newKFileMetaInfo(KURL url);
	/**	
		 Default constructor. This will create an invalid object (see
		 isValid().
				@short    Default constructor.
	*/
	public KFileMetaInfo() {
		newKFileMetaInfo();
	}
	private native void newKFileMetaInfo();
	/**	
		 Copy constructor. This creates a copy of the original object, but
		 that copy will point to the same data, so if you change the original,
		 the copy will be changed, too. After all, they are referring to the same
		 file.
				@short    Copy constructor.
	*/
	public KFileMetaInfo(KFileMetaInfo original) {
		newKFileMetaInfo(original);
	}
	private native void newKFileMetaInfo(KFileMetaInfo original);
	/**	
		 Returns a list of all groups.
				@return the keys of the groups that the file has.
     
		@short    Returns a list of all groups.
	*/
	public native ArrayList groups();
	/**	
		 Returns a list of all supported groups.
				@return the supported keys of the groups that the file has.
     
		@short    Returns a list of all supported groups.
	*/
	public native ArrayList supportedGroups();
	/**	
		 Returns a list of the preferred groups.
				@return the keys of the preferred groups that the file has.
     
		@short    Returns a list of the preferred groups.
	*/
	public native ArrayList preferredGroups();
	/**	
		 Returns a list of all preferred keys.
				@return a list of all preferred keys.
     
		@short    Returns a list of all preferred keys.
	*/
	public native ArrayList preferredKeys();
	/**	
		 Returns a list of supported keys.
				@return a list of supported keys
     
		@short    Returns a list of supported keys.
	*/
	public native ArrayList supportedKeys();
	/**	
		 Returns the list of groups that you can add or remove from the file.
				@return the groups can be added or removed
    
		@short    Returns the list of groups that you can add or remove from the file.
	*/
	public native ArrayList editableGroups();
	/**	
		 Returns the KFileMetaInfoItem with the given <code>key.</code>
			@param key the key of the item
				@return the item. Invalid if there is no item with the given <code>key.</code>
     
		@short    Returns the KFileMetaInfoItem with the given <code>key.</code>
	*/
	public native KFileMetaInfoItem item(String key);
	/**	
		 Returns the KFileMetaInfoItem with the given <code>hint.</code>
			@param hint the hint of the item
				@return the item. Invalid if there is no item with the given <code>hint.</code>
     
		@short    Returns the KFileMetaInfoItem with the given <code>hint.</code>
	*/
	// KFileMetaInfoItem item(const KFileMetaInfoItem::Hint arg1); >>>> NOT CONVERTED
	/**	
		 Saves the item with the given <code>key.</code>
			@param key the key of the item
			@param preferredGroup the preferred group, or null
			@param createGroup true to create the group if necessary
				@return the saved item
     
		@short    Saves the item with the given <code>key.</code>
	*/
	public native KFileMetaInfoItem saveItem(String key, String preferredGroup, boolean createGroup);
	public native KFileMetaInfoItem saveItem(String key, String preferredGroup);
	public native KFileMetaInfoItem saveItem(String key);
	/**	
		 Returns the KFileMetaInfoGroup with the given <code>key.</code>
			@param key the key of the item
				@return the group. Invalid if there is no group with the given <code>key.</code>
     
		@short    Returns the KFileMetaInfoGroup with the given <code>key.</code>
	*/
	public native KFileMetaInfoGroup group(String key);
	/**	
		 Returns the KFileMetaInfoGroup with the given <code>key.</code>
			@param key the key of the item
				@return the group. Invalid if there is no group with the given <code>key.</code>
     
		@short    Returns the KFileMetaInfoGroup with the given <code>key.</code>
	*/
	public native KFileMetaInfoGroup op_at(String key);
	/**	
		 Try to add the specified group. This will only succeed if it is
		 in the list of editableGroups().
			 @note that all non-variable items that belong to this group are
		  automatically added as empty item.
			@param name the name of the group to add
				@return true if successful, false if not
    
		@short    Try to add the specified group.
	*/
	public native boolean addGroup(String name);
	/**	
		 Remove the specified group. This will only succeed if it is
		 in the list of editableGroups(). Beware that this also
		 removes all the items in that group, so always ask the user
		 before removing it!
			@param name the name of the group to remove
				@return true if successful, false if not
    
		@short    Remove the specified group.
	*/
	public native boolean removeGroup(String name);
	/**	
		 Returns a list of removed groups.
				@return a list of removed groups.
     
		@short    Returns a list of removed groups.
	*/
	public native ArrayList removedGroups();
	/**	
		 This method writes all pending changes of the meta info back to the file.
		 If any items are marked as removed, they are really removed from the
		 list. The info object as well as all items are updated.
				@return true if successful, false if not
    
		@short    This method writes all pending changes of the meta info back to the file.
	*/
	public native boolean applyChanges();
	/**	
		 Checks whether an item with the given <code>key</code> exists.
			@param key the key to check
				@return whether an item for this <code>key</code> exists.
     
		@short    Checks whether an item with the given <code>key</code> exists.
	*/
	public native boolean contains(String key);
	/**	
		 Checks whether a group with the given <code>key</code> exists.
			@param key the key to check
				@return whether a group with this name exists.
     
		@short    Checks whether a group with the given <code>key</code> exists.
	*/
	public native boolean containsGroup(String key);
	/**	
		 Returns the value with the given <code>key.</code>
			@param key the key to retrieve
				@return the value. Invalid if it does not exist
     
		@short    Returns the value with the given <code>key.</code>
	*/
	public native QVariant value(String key);
	/**	
		 Returns true if the item is valid, i.e. if actually represents the info
		 about a file, false if the object is uninitialized.
				@return true if valid, false otherwise
     
		@short    Returns true if the item is valid, i.
	*/
	public native boolean isValid();
	/**	
		 Returns false if the object contains data, true if it's empty. You'll
		 get an empty object if no plugin for the file could be found.
				@return true if empty, false otherwise
     
		@short    Returns false if the object contains data, true if it's empty.
	*/
	public native boolean isEmpty();
	/**	
		 Returns the mime type of file.
				@return the file's mime type
     
		@short    Returns the mime type of file.
	*/
	public native String mimeType();
	/**	
		 Returns the path of file - or null if file is non-local
				@return the file's path - or null if file is non-local
     
		@short    Returns the path of file - or String.null if file is non-local
	*/
	public native String path();
	/**	
		 Returns the url of file
				@return the file's url
     
		@short    Returns the url of file
	*/
	public native KURL url();
	protected native KFileMetaInfoGroup appendGroup(String name);
	/**	
				@return a pointer to the plugin that belogs to this object's mimetype.
         It will be auto-loaded if it's currently not loaded

		@short
	*/
	// KFilePlugin * const plugin(); >>>> NOT CONVERTED
	protected native void ref();
	protected native void deref();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
