
#include <khtml_part.h> // this plugin applies to a khtml part
#include <kdebug.h>
#include "|NAMELITTLE|.h"
#include <kaction.h>
#include <kinstance.h>
#include <kiconloader.h>
#include <qmessagebox.h>
#include <klocale.h>
 
|NAME|::|NAME|( QObject* parent, const char* name )
    : Plugin( parent, name )
{
    (void) new KAction( "&|NAME| (plugin)",
                        "filter", 0,
                        this, SLOT(slotAction()),
                        actionCollection(), "|NAMELITTLE|" );
}
 
|NAME|::~|NAME|()
{
}
 
KURL |NAME|::|NAMELITTLE|URL( const KURL &url )
{
    // Check syntax
    if ( url.isMalformed() ) {
        QString title = i18n( "Malformed URL" );
        QString text = i18n( "<qt><p>The URL you entered is not valid, please "
                             "correct it and try again</p></qt>" );
        QMessageBox::warning( 0, title, text );
        return QString::null;
    }
 
    // Create the URL
    KURL hax0red( "http://www.psyclops.com/translator/translator.cgi" );
 
    // Set entered URL as a parameter
    QString p;
    QString q = url.url();
    q = KURL::encode_string( q );
    p = "url=" + q + "&mode=hacker";
 
    hax0red.setQuery( p );

    return hax0red;
}
 
void |NAME|::slotAction()
{
    // The parent is assumed to be a KHTMLPart
    if ( !parent()->inherits("KHTMLPart") ) {
        QString title = i18n( "Cannot hax0red source" );
        QString text = i18n( "You cannot hax0red anything except web pages with\n"
                             "this plugin, sorry." );
 
       QMessageBox::warning( 0, title, text );
    }
    else
    {
        KHTMLPart *part = (KHTMLPart *) parent();
 
        // Get URL
        KURL url = part->url();
        KURL |NAMELITTLE|url = |NAMELITTLE|URL( url );
 
        part->openURL( |NAMELITTLE|url );
    }
}
KPluginFactory::KPluginFactory( QObject* parent, const char* name )
  : KLibFactory( parent, name )
{
  s_instance = new KInstance("KPluginFactory");
}
 
QObject* KPluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
    QObject *obj = new |NAME|( parent, name );
    return obj;
}
KPluginFactory::~KPluginFactory()
{ delete s_instance; }

 
extern "C"
{
  void* init_lib|NAMELITTLE|()
  {
    return new KPluginFactory;
  }
 
}
 
KInstance* KPluginFactory::s_instance = 0L;
