/***************************************************************************
                          kscribbleview.cpp  -  description
                             -------------------
    begin                : Fri Jul 23 08:25:10 CEST 1999

    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>

#include <qevent.h>
#include <qrect.h>
#include <qpoint.h>
#include <qimage.h>
#include <qintdict.h>

// include files for KDE
#include <kcursor.h>

// application specific includes
#include <kscribbleview.h>
#include "kscribbledoc.h"
#include "kscribble.h"

KScribbleView::KScribbleView(QWidget *parent, const char* name) : QWidget(parent, name), pen( red, 3), polyline(3),
mousePressed( FALSE ), buffer( width(), height() )
{
  resize(300, 200);
  buffer.fill( white );
  setBackgroundMode( QWidget::NoBackground );
  setCursor(KCursor::crossCursor());

}

KScribbleView::~KScribbleView(){
}


KScribbleDoc* KScribbleView::getDocument() const
{
	KScribbleApp* theApp=(KScribbleApp*)parentWidget();
	return theApp->getDocument();
}

void KScribbleView::print(QPrinter* m_pPrinter)
{
	QPainter printpainter;
	printpainter.begin(m_pPrinter);
	
	// TODO: add your printing code here
	
	printpainter.end();

}



void KScribbleView::clearScreen()
{
  buffer.fill( white );
  repaint( FALSE );
}

void KScribbleView::mousePressEvent( QMouseEvent *e )
{
  mousePressed = TRUE;
  polyline.setPoint(0,e->pos());
  polyline.setPoint(1,e->pos());
  polyline.setPoint(2,e->pos());

}

void KScribbleView::mouseReleaseEvent( QMouseEvent * )
{
  mousePressed = FALSE;
}

void KScribbleView::mouseMoveEvent( QMouseEvent *e )
{
  if ( mousePressed ) {
    QPainter painter;
    painter.begin( &buffer );
    painter.setPen( pen );
    polyline.setPoint(2, polyline.point(1));
    polyline.setPoint(1, polyline.point(0));
    polyline.setPoint(0, e->pos());
    painter.drawPolyline( polyline );
    painter.end();

    QRect r = polyline.boundingRect();
    r = r.normalize();
    r.setLeft( r.left() - penWidth() );
    r.setTop( r.top() - penWidth() );
    r.setRight( r.right() + penWidth() );
    r.setBottom( r.bottom() + penWidth() );

    bitBlt( this, r.x(), r.y(), &buffer, r.x(), r.y(), r.width(), r.height() );
  }
}

void KScribbleView::resizeEvent( QResizeEvent *e )
{
  QWidget::resizeEvent( e );

  int w = width() > buffer.width() ?
  width() : buffer.width();
  int h = height() > buffer.height() ?
  height() : buffer.height();

  QPixmap tmp( buffer );
  buffer.resize( w, h );
  buffer.fill( white );
  bitBlt( &buffer, 0, 0, &tmp, 0, 0, tmp.width(), tmp.height() );
}

void KScribbleView::paintEvent( QPaintEvent *e )
{
  QWidget::paintEvent( e );

  QRect r = e->rect();

  bitBlt( this, r.x(), r.y(), &buffer, r.x(), r.y(), r.width(), r.height() );
}












