#include <qobjectlist.h>
#include "buttongroup.h"


//
// 1999-11-21-Espen Sand <espen@kde.org>:
// The purpose of this class is to display the title in bold. The former
// version set the font outside the class. This version will automatically 
// trigger on setFont() usage and during show() using showEvent().
//

ButtonGroup::ButtonGroup(const QString & title, QWidget *parent) 
  :QButtonGroup(title, parent), changingFont(false)
{
  setFontPropagation( NoChildren );
}

void ButtonGroup::fontChange( const QFont & oldFont ) 
{
  if( changingFont == true ) // setFont() will call fontChange()
  {
    return;
  }
  changingFont = true;

  QFont f = font();
  f.setBold(true);
  setFont(f);

  if( children() )
  {
    f.setBold(false);
    QObjectList *l = (QObjectList*)children(); // silence please
    for( uint i=0; i < l->count(); i++ )
    {
      QObject *o = l->at(i);
      if( o->isWidgetType() )
      {
	((QWidget*)o)->setFont(f);
      }
    }
  }
  changingFont = false;
}

void ButtonGroup::showEvent( QShowEvent * )  
{
  fontChange( font() );
}

