/***************************************************************************
                            KURLLabel.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A label class that supports displaying an active hyperlink.

 KURLLabel is a drop-in replacement for QLabel that handles text
 in a fashion similar to how an HTML widget handles hyperlinks.  The
 text can be underlined (or not) and set to different colors.  It
 can also "glow" (cycle colors) when the mouse passes over it.

 KURLLabel also provides signals for several events, including
 the mouse leaving and entering the text area and all forms of
 mouse clicking.

 A typical usage would be something like so:

 <PRE>
     KURLLabel address = new KURLLabel(this);
     address.setText("My homepage");
     address.setURL("http://www.home.com/~me");
     connect(address, SIGNAL("leftClickedURL(String)"),
                      SLOT("processMyURL(String)"));
 </PRE>

 In this example, the text "My homepage" would be displayed
 as blue, underlined text.  When the mouse passed over it, 
 it would "glow" red.  When the user clicks on the text, the
 signal {@link #leftClickedURL} would be emitted with "http://www.home.com/~me"
 as its argument.

 
 See {@link KURLLabelSignals} for signals emitted by KURLLabel.

 See {@link KURLLabelEventHandling} for event handlers to override in subclasses of KURLLabel.

 @author Peter Putzer <putzer@kde.org> (Rewrite)

 @version $Id: KURLLabel.java,v 1.2.2.1 2001/08/29 23:14:11 rdale Exp $

 @short A drop-in replacement for QLabel that displays hyperlinks.

*/
public class KURLLabel extends QLabel  {
	protected KURLLabel(Class dummy){super((Class) null);}


/** 
 Default constructor.

 Use {@link #setURL} and {@link #setText} or {@link QListView#setPixmap}
 to set the resp. properties.
   
*/
	private native void newKURLLabel( QWidget parent, String name);
	public KURLLabel( QWidget parent, String name) {
		super((Class) null);
		newKURLLabel( parent, name);
	}
	private native void newKURLLabel();
	public KURLLabel() {
		super((Class) null);
		newKURLLabel();
	}

/** 
 Convenience constructor.

 <code>parent</code> and <code>name</code> are passed to {@link QLabel}.
   
*/
	private native void newKURLLabel( String url, String text, QWidget parent, String name);
	public KURLLabel( String url, String text, QWidget parent, String name) {
		super((Class) null);
		newKURLLabel( url, text, parent, name);
	}
	private native void newKURLLabel( String url);
	public KURLLabel( String url) {
		super((Class) null);
		newKURLLabel( url);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Retreive the URL. 

*/
	public native String url();

/** 
 Retreive the tooltip text.

*/
	public native String tipText();

/** 

*/
	public native boolean useTips();

/** 

*/
	public native boolean useCursor();

/** 
 When this is on, the text will switch to the selected 
 color whenever the mouse passes over it.
   
*/
	public native boolean isGlowEnabled();

/** 
 This feature is very similar to the "glow" feature in that the color of the
 label switches to the selected color when the cursor passes
 over it. In addition, underlining is turned on for as
 long as the mouse is overhead. Note that if "glow" and
 underlining are both already turned on, this feature
 will have no visible effect.
   
*/
	public native boolean isFloatEnabled();

/** 

*/
	public native QPixmap altPixmap();

/** 
 Turn on or off the underlining.

  When this is on, the
 text will be underlined.  By default, it is <code>true.</code>
   
*/
	public native void setUnderline( boolean on);
	public native void setUnderline();

/** 
 Sets the URL for this label to <code>url.</code>

*/
	public native void setURL( String url);

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
	public native void setFont( QFont arg1);

/** 
 Turn on or off the tool tip feature.

 When this is on, the URL will be displayed as a
 tooltip whenever the mouse passes passes over it.
 By default, it is <code>false.</code>
   
*/
	public native void setUseTips( boolean on);
	public native void setUseTips();

/** 
 Specifies what text to display when tooltips are turned on.

 If this is not used, the tip will default to the URL.

*/
	public native void setTipText( String tip);

/** 
 Set the highlight color.

 This is the default foreground
 color (non-selected).  By default, it is <code>blue.</code>
   
*/
	public native void setHighlightedColor( QColor highcolor);

/** 
 This is an overloaded version for convenience.

*/
	public native void setHighlightedColor( String highcolor);

/** 
 Set the selected color.

 This is the color the text will change
 to when either a mouse passes over it and "glow" mode is on or
 when it is selected (clicked).  By default, it is <code>red.</code>
   
*/
	public native void setSelectedColor( QColor selcolor);

/** 
 This is an overloaded version for convenience.

*/
	public native void setSelectedColor( String selcolor);

/** 
 Turn the custom cursor feature on or off.

 When this is on, the cursor will change to a custom cursor
 (default is a "pointing hand") whenever the cursor passes
 over the label. By default, it is on.

*/
	public native void setUseCursor( boolean on, QCursor cursor);
	public native void setUseCursor( boolean on);

/** 
 Turn on or off the "glow" feature. 

 When this is on, the text will switch to the
 selected color whenever the mouse
 passes over it. By default, it is <code>true.</code>
   
*/
	public native void setGlow( boolean glow);
	public native void setGlow();

/** 
 Turn on or off the "float" feature.

 This feature is very similar to the "glow" feature in
 that the color of the label switches to the selected 
 color when the cursor passes over it. In addition,
 underlining is turned on for as long as the mouse is overhead.
 Note that if "glow" and underlining are both already turned
 on, this feature will have no visible effect.
 By default, it is <code>false.</code>
   
*/
	public native void setFloat( boolean do_float);
	public native void setFloat();

/** 
 Set the "alt" pixmap. 

 This pixmap will be displayed when the
 cursor passes over the label.  The effect is similar to the
 trick done with 'onMouseOver' in javascript.

*/
	public native void setAltPixmap( QPixmap altPix);
}
