/***************************************************************************
                            KStdAccel.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Convenient methods for access to the common accelerator keys in
 the key configuration. These are the standard keybindings that should
 be used in all KDE applications. They will be configurable,
 so do not hardcode the default behavior.

 If you want real configurable keybindings in your applications,
 please checkout the class {@link KAccel} in kaccel.h
 
 @short 
 Convenient methods for access to the common accelerator keys in
 the key configuration.
*/
public class  KStdAccel implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStdAccel(Class dummy){}

	private native void newKStdAccel();
	public KStdAccel() {
		newKStdAccel();
	}

/**  Open file. Default: Ctrl-o 
*/
	public static native int open();

/**  Create a new document (or whatever). Default: Ctrl-n 
*/
	public static native int openNew();

/**  Close current document. Default: Ctrl-w 
*/
	public static native int close();

/**  Save current document. Default: Ctrl-s 
*/
	public static native int save();

/**  Print current document. Default: Ctrl-p 
*/
	public static native int print();

/**  Quit the program. Default: Ctrl-q 
*/
	public static native int quit();

/**  Cut selected area and store it in the clipboard. Default: Ctrl-x 
*/
	public static native int cut();

/**  Copy selected area into the clipboard. Default: Ctrl-c 
*/
	public static native int copy();

/**  Paste contents of clipboard at mouse/cursor position. Default: Ctrl-v 
*/
	public static native int paste();

/**  Delete a word back from mouse/cursor position. Default: Ctrl-Backspace 
*/
	public static native int deleteWordBack();

/**  Delete a word forward from mouse/cursor position. Default: Ctrl-Delete 
*/
	public static native int deleteWordForward();

/**  Undo last operation. Default: Ctrl-z 
*/
	public static native int undo();

/**  Redo. Default: Shift-Ctrl-z 
*/
	public static native int redo();

/**  Find, search. Default: Ctrl-f 
*/
	public static native int find();

/**  Find/search next. Default: F3 
*/
	public static native int findNext();

/**  Find/search previous. Default: Shift-F3 
*/
	public static native int findPrev();

/**  Find and replace matches. Default: Ctrl-r 
*/
	public static native int replace();

/**  Zoom in. Default: Ctrl-Plus 
*/
	public static native int zoomIn();

/**  Zoom out. Default: Ctrl-Minus 
*/
	public static native int zoomOut();

/**  Toggle insert/overwrite (with visual feedback, e.g. in the statusbar). Default: Insert 
*/
	public static native int insert();

/**  Goto beginning of current line. Default: Home 
*/
	public static native int home();

/**  Goto end of current line. Default: End 
*/
	public static native int end();

/**  Scroll up one page. Default: Prior 
*/
	public static native int prior();

/**  Scroll down one page. Default: Next 
*/
	public static native int next();

/**  Go to line. Default: Ctrl+G 
*/
	public static native int gotoLine();

/**  Add current page to bookmarks. Default: Ctrl+B 
*/
	public static native int addBookmark();

/**  Help the user in the current situation. Default: F1 
*/
	public static native int help();

/**  Complete text in input widgets. Default Ctrl+E 
*/
	public static native int completion();

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Up 
*/
	public static native int prevCompletion();

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Down 
*/
	public static native int nextCompletion();

/**  Help users iterate through a list of enteries. Default: Up 
*/
	public static native int rotateUp();

/**  Help users iterate through a list of enteries. Default: Down 
*/
	public static native int rotateDown();

/**  popup a context menu. Default: Menu 
*/
	public static native int popupMenuContext();

/**  What's This button. Default: Shift+F1 
*/
	public static native int whatsThis();

/**  Reload. Default: F5 
*/
	public static native int reload();

/**  Reload. Default: Ctrl-A 
*/
	public static native int selectAll();

/**  Up. Default: Alt+Up 
*/
	public static native int up();

/**  Back. Default: Alt+Left 
*/
	public static native int back();

/**  Forward. Default: ALT+Right 
*/
	public static native int forward();

/**  Show Menu Bar.  Default: Ctrl-M 
*/
	public static native int showMenubar();

/** 
 Compare the keys generated by the key event with
 the value of the integer.

 If a modifier (Shift, Alt, Ctrl) key is present in
 {@link QKeyEvent}, its sum with the actual key value
 is used for comparing it with the integer parameter.

*/
	public static native boolean isEqual( QKeyEvent arg1, int arg2);

/** 
 Return the keybinding for <code>accel.</code>
   
*/
	public static native int key( int accel);
	public static native String action( int arg1);
	public static native String description( int arg1);

/** 

 Return the hardcoded default keybinding for <code>accel.</code>
 This does not take into account the user's configuration.
   
*/
	public static native int defaultKey( int accel);
	public static native int defaultKey3( int accel);
	public static native int defaultKey4( int accel);
	public static final int Open = 0;
	public static final int New = 0;
	public static final int Close = 1;
	public static final int Save = 2;
	public static final int Print = 3;
	public static final int Quit = 4;
	public static final int Cut = 5;
	public static final int Copy = 6;
	public static final int Paste = 7;
	public static final int Undo = 8;
	public static final int Redo = 9;
	public static final int Find = 10;
	public static final int Replace = 11;
	public static final int Insert = 12;
	public static final int Home = 13;
	public static final int End = 14;
	public static final int Prior = 15;
	public static final int Next = 16;
	public static final int Help = 17;
	public static final int FindNext = 18;
	public static final int FindPrev = 19;
	public static final int ZoomIn = 20;
	public static final int ZoomOut = 21;
	public static final int AddBookmark = 22;
	public static final int TextCompletion = 23;
	public static final int PrevCompletion = 24;
	public static final int NextCompletion = 25;
	public static final int RotateUp = 26;
	public static final int RotateDown = 27;
	public static final int PopupMenuContext = 28;
	public static final int WhatThis = 29;
	public static final int Reload = 30;
	public static final int SelectAll = 31;
	public static final int Up = 32;
	public static final int Back = 33;
	public static final int Forward = 34;
	public static final int ShowMenubar = 35;
	public static final int GotoLine = 36;
	public static final int DeleteWordBack = 37;
	public static final int DeleteWordForward = 38;
	public static final int NB_STD_ACCELS = 39;
}
