/***************************************************************************
                            KHTMLView.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Render and display HTML in a {@link QScrollView}.

 Suitable for use as an application's main view.

 See {@link KHTMLViewSignals} for signals emitted by KHTMLView.

 See {@link KHTMLViewEventHandling} for event handlers to override in subclasses of KHTMLView.

 @short 
 Render and display HTML in a @ref QScrollView.
*/
public class KHTMLView extends QScrollView  {
	protected KHTMLView(Class dummy){super((Class) null);}


/** 
 Construct a {@link KHTMLView}.
     
*/
	private native void newKHTMLView( KHTMLPart part, QWidget parent, String name);
	public KHTMLView( KHTMLPart part, QWidget parent, String name) {
		super((Class) null);
		newKHTMLView( part, parent, name);
	}
	private native void newKHTMLView( KHTMLPart part, QWidget parent);
	public KHTMLView( KHTMLPart part, QWidget parent) {
		super((Class) null);
		newKHTMLView( part, parent);
	}
	protected native void finalize() throws InternalError;

/** 
 Retrieve a pointer to the {@link KHTMLPart} that is
 rendering the page.

*/
	public native KHTMLPart part();
	public native int frameWidth();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0.
 use sendEvent(view, Key_Tab) instead.
 Move the view towards the next link and
 draw a cursor around it

*/
	public native boolean gotoNextLink();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0
 use sendEvent(view, Key_BackTab) instead.
 Move the view towards the next link and
 draw a cursor around it

*/
	public native boolean gotoPrevLink();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0
 use sendEvent(view, Key_Return) instead.
 visualize that the item under the cursor
 has been pressed (true) or released(false)
     
*/
//	public native void toggleActLink( boolean arg1);

/** 
 Set a margin in x direction.
     
*/
	public native void setMarginWidth( int x);

/** 
 Retrieve the margin width.

 A return value of -1 means the default value will be used.
     
*/
	public native int marginWidth();
	public native void setMarginHeight( int y);
	public native int marginHeight();
	public native void setVScrollBarMode( int mode);
	public native void setHScrollBarMode( int mode);

/** 
 Print the HTML document.

*/
	public native void print();

/** 
 Paint the HTML document to a QPainter.
 The document will be scaled to match the width of
 rc and clipped to fit in the height.
 yOff determines the vertical offset in the document to start with.
 more, if nonzero will be set to true if the documents extends
 beyond the rc or false if everything below yOff was painted.

*/
	public native void paint( QPainter p, QRect rc, int yOff, int[] more);
	public native void paint( QPainter p, QRect rc);
	public native QWidget layout( boolean force);
	public native QLayout layout();
	protected native void clear();
	protected native boolean focusNextPrevChild( boolean next);
	protected native void drawContents( QPainter p, int clipx, int clipy, int clipw, int cliph);

/** 
 Scroll the view
     
*/
	protected native void doAutoScroll();
	protected native void slotPaletteChanged();
}
