package org.kde.koala;
import org.kde.qt.*;
import java.util.ArrayList;


/** {@link KDirLister} emits these signals */
public interface KDirListerSignals {

/**  Send a list of items filtered-out by mime-type. 
*/
	void itemsFilteredByMime( ArrayList items );
	void destroyed();

/**  Signal new items, <code>complete</code> is true when the directory loading has
  finished 
*/
	void newItems( ArrayList items );

/** 
 Tell the view that the listing of the directory <code>_url</code> is finished.
 There might be other running jobs left.
 This signal is only emitted if KDirLister is watching more than one directory.

*/
	void completed( KURL _url );

/**  Signal to clear all items in case of _keep == false 
*/
	void clear();

/** 
 Instruct the view to close itself, since the dir was just deleted.
   
*/
	void closeView();

/** 
 Tell the view that the listing of the directory <code>_url</code> was canceled.
 There might be other running jobs left.
 This signal is only emitted if KDirLister is watching more than one directory.

*/
	void canceled( KURL _url );

/** 
 Signal a redirection.
 Only emitted if _keep == true, i.e. there are more than one dirs to list
   
*/
	void redirection( KURL oldUrl, KURL newUrl );

/** 
 Tell the view that we started to list _url.
 The view knows that openURL should start it, so it might seem useless,
 but the view also needs to know when an automatic update happens.

 ## KDE 3.0: change to const KURL&
   
*/
	void started( String _url );

/** 
 Signal an item to refresh (its mimetype/icon/name has changed)
 Note: KFileItem.refresh has already been called on those items.
   
*/
	void refreshItems( ArrayList items );

/** 
 Signal an item to remove.
 ## change to const KFileItem in 3.0
   
*/
	void deleteItem( KFileItem _fileItem );
}

