/***************************************************************************
                            KDesktopFile.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 KDE Desktop File Management.

 See {@link KDesktopFileSignals} for signals emitted by KDesktopFile.

 See {@link KDesktopFileEventHandling} for event handlers to override in subclasses of KDesktopFile.

 @author Pietro Iglio <iglio@kde.org>

 @version $Id: KDesktopFile.java,v 1.2.2.1 2001/08/29 23:14:09 rdale Exp $

 @short KDE Desktop File Management class.
*/
public class KDesktopFile extends KConfig  {
	protected KDesktopFile(Class dummy){super((Class) null);}


/**  
 Construct a KDesktopFile object and make it either read-write
 or read-only.  

*/
	private native void newKDesktopFile( String pFileName, boolean bReadOnly, String resType);
	public KDesktopFile( String pFileName, boolean bReadOnly, String resType) {
		super((Class) null);
		newKDesktopFile( pFileName, bReadOnly, resType);
	}
	private native void newKDesktopFile( String pFileName);
	public KDesktopFile( String pFileName) {
		super((Class) null);
		newKDesktopFile( pFileName);
	}

/**  
 Destructor. 

 Write back any dirty configuration entries.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Retrieve the value of the "Type=" entry.
   
*/
	public native String readType();

/** 
 Retrieve the value of the "Icon=" entry.
   
*/
	public native String readIcon();

/** 
 Retrieve the value of the "Name=" entry.
   
*/
	public native String readName();

/** 
 Retrieve the value of the "Comment=" entry.
   
*/
	public native String readComment();

/** 
 Retrieve the value of the "Path=" entry.

   
*/
	public native String readPath();

/** 
 Retrieve the value of the "Dev=" entry.
   
*/
	public native String readDevice();

/** 
 Retrieve the value of the "URL=" entry.
   
*/
	public native String readURL();

/** 
 Returns a list of the "Actions=" entries.
   
*/
	public native ArrayList readActions();

/** 
 Sets the desktop action group.
   
*/
	public native void setActionGroup( String group);

/** 
 Returns <code>if</code> the action group exists.
   
*/
	public native boolean hasActionGroup( String group);

/** 
 Check to see if there is a "Type=Link" entry.

 The link points to the "URL=" entry.
   
*/
	public native boolean hasLinkType();

/** 
 Check to see if there is an entry "Type=Application".
   
*/
	public native boolean hasApplicationType();

/** 
 Check to see if there is an entry "Type=MimeType".
   
*/
	public native boolean hasMimeTypeType();

/** 
 Check to see if there is an entry "Type=FSDev".
   
*/
	public native boolean hasDeviceType();

/** 
 Check to see if the TryExec field contains a binary
 which is found on the local system.
   
*/
	public native boolean tryExec();

/** 

*/
	public native String filename();

/** 

*/
	public native String resource();
	public native ArrayList sortOrder();

/** 
 Check to see whether this is a desktop file.

 The check is performed looking at the file extension (the file is not
 opened).
 Currently, valid extensions are ".kdelnk" and ".desktop".

*/
	public static native boolean isDesktopFile( String path);
}
