/***************************************************************************
                            HTMLInputElement.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Form control. Note. Depending upon the environment the page is
 being viewed, the value property may be read-only for the file
 upload input type. For the "password" input type, the actual value
 returned may be masked to prevent unauthorized use. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-INPUT">
 INPUT element definition </a> in HTML 4.0.

 
 @short 
 Form control.
*/
public class HTMLInputElement extends HTMLElement  {
	protected HTMLInputElement(Class dummy){super((Class) null);}

	private native void newHTMLInputElement();
	public HTMLInputElement() {
		super((Class) null);
		newHTMLInputElement();
	}
	private native void newHTMLInputElement( HTMLInputElement other);
	public HTMLInputElement( HTMLInputElement other) {
		super((Class) null);
		newHTMLInputElement( other);
	}
	private native void newHTMLInputElement( DOMNode other);
	public HTMLInputElement( DOMNode other) {
		super((Class) null);
		newHTMLInputElement( other);
	}
	protected native void finalize() throws InternalError;

/** 
 Stores the initial control value (i.e., the initial value of
 <code> value </code> ).

     
*/
	public native String defaultValue();

/** 
 see {@link defaultValue}
     
*/
	public native void setDefaultValue( String arg1);

/** 
 When <code> type </code> has the value "Radio" or "Checkbox",
 stores the initial value of the <code> checked </code>
 attribute.

     
*/
	public native boolean defaultChecked();

/** 
 see {@link defaultChecked}
     
*/
	public native void setDefaultChecked( boolean arg1);

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
	public native HTMLFormElement form();

/** 
 A comma-separated list of content types that a server
 processing this form will handle correctly. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept">
 accept attribute definition </a> in HTML 4.0.

     
*/
	public native String accept();

/** 
 see {@link accept}
     
*/
	public native void setAccept( String arg1);

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
	public native String accessKey();

/** 
 see {@link accessKey}
     
*/
	public native void setAccessKey( String arg1);

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String align();

/** 
 see {@link align}
     
*/
	public native void setAlign( String arg1);

/** 
 Alternate text for user agents not rendering the normal content
 of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-alt">
 alt attribute definition </a> in HTML 4.0.

     
*/
	public native String alt();

/** 
 see {@link alt}
     
*/
	public native void setAlt( String arg1);

/** 
 Describes whether a radio or check box is checked, when <code>
 type </code> has the value "Radio" or "Checkbox". The value is
 TRUE if explicitly set. Represents the current state of the
 checkbox or radio button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-checked">
 checked attribute definition </a> in HTML 4.0.

     
*/
	public native boolean checked();

/** 
 see {@link checked}
     
*/
	public native void setChecked( boolean arg1);

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
	public native boolean disabled();

/** 
 see {@link disabled}
     
*/
	public native void setDisabled( boolean arg1);

/** 
 Maximum number of characters for text fields, when <code> type
 </code> has the value "Text" or "Password". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-maxlength">
 maxlength attribute definition </a> in HTML 4.0.

     
*/
	public native long maxLength();

/** 
 see {@link maxLength}
     
*/
	public native void setMaxLength( long arg1);

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
	public native String name();

/** 
 see {@link name}
     
*/
	public native void setName( String arg1);

/** 
 This control is read-only. When <code> type </code> has the
 value "text" or "password" only. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-readonly">
 readonly attribute definition </a> in HTML 4.0.

     
*/
	public native boolean readOnly();

/** 
 see {@link readOnly}
     
*/
	public native void setReadOnly( boolean arg1);

/** 
 Size information. The precise meaning is specific to each type
 of field. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-INPUT">
 size attribute definition </a> in HTML 4.0.

     
*/
	public native String size();

/** 
 see {@link size}
     
*/
	public native void setSize( String arg1);

/** 
 When the <code> type </code> attribute has the value "Image",
 this attribute specifies the location of the image to be used
 to decorate the graphical submit button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-src">
 src attribute definition </a> in HTML 4.0.

     
*/
	public native String src();

/** 
 see {@link src}
     
*/
	public native void setSrc( String arg1);

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
	public native long tabIndex();

/** 
 see {@link tabIndex}
     
*/
	public native void setTabIndex( long arg1);

/** 
 The type of control created. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-type-INPUT">
 type attribute definition </a> in HTML 4.0.

     
*/
	public native String type();

/** 
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
	public native String useMap();

/** 
 see {@link useMap}
     
*/
	public native void setUseMap( String arg1);

/** 
 The current form control value. Used for radio buttons and
 check boxes. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-INPUT">
 value attribute definition </a> in HTML 4.0.

     
*/
	public native String value();

/** 
 see {@link value}
     
*/
	public native void setValue( String arg1);

/** 
 Removes keyboard focus from this element.

     
*/
	public native void blur();

/** 
 Gives keyboard focus to this element.

     
*/
	public native void focus();

/** 
 Select the contents of the text area. For <code> INPUT </code>
 elements whose <code> type </code> attribute has one of the
 following values: "Text", "File", or "Password".

     
*/
	public native void select();

/** 
 Simulate a mouse-click. For <code> INPUT </code> elements whose
 <code> type </code> attribute has one of the following values:
 "Button", "Checkbox", "Radio", "Reset", or "Submit".
     
*/
	public native void click();
//	private native void newHTMLInputElement( HTMLInputElementImpl impl);
//	public HTMLInputElement( HTMLInputElementImpl impl) {
//		super((Class) null);
//		newHTMLInputElement( impl);
//	}
}
