#include "ksvpathconfig.h"

#include <klineedit.h>
#include <kfiledialog.h>

/* 
 *  Constructs a KSVPathConfig which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KSVPathConfig::KSVPathConfig( QWidget* parent,  const char* name, WFlags fl )
    : PathConfiguration( parent, name, fl )
{
  mSpacer->setFixedHeight (KDialog::spacingHint());
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KSVPathConfig::~KSVPathConfig()
{
    // no need to delete child widgets, Qt does it all for us
}

void KSVPathConfig::browseServices()
{
  QString path = KFileDialog::getExistingDirectory(mServicesPath->text(), this);

  if (!path.isEmpty())
    mServicesPath->setText(path);
  
  mServicesPath->setFocus();
}

void KSVPathConfig::browseRunlevels()
{
  QString path = KFileDialog::getExistingDirectory(mRunlevelPath->text(), this);

  if (!path.isEmpty())
    mRunlevelPath->setText(path);

  mRunlevelPath->setFocus();
}

#include "pathconfig.moc"
#include "ksvpathconfig.moc"

